# Copyright 2020 OpenStack Foundation
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
#

"""Ocata rebase

Revision ID: 39cf2e645cba
Revises: None
Create Date: 2020-09-23 07:55:03.238363

"""

# revision identifiers, used by Alembic.
revision = '39cf2e645cba'
down_revision = None

from alembic import op
import sqlalchemy as sa

import barbican


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'projects',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('external_id', sa.String(length=255), nullable=True),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('external_id'),
        mysql_engine='InnoDB'
    )
    op.create_table(
        'secret_stores',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('store_plugin', sa.String(length=255), nullable=False),
        sa.Column('crypto_plugin', sa.String(length=255), nullable=True),
        sa.Column('global_default', sa.Boolean(), nullable=False),
        sa.Column('name', sa.String(length=255), nullable=False),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('name', name='_secret_stores_name_uc'),
        sa.UniqueConstraint('store_plugin', 'crypto_plugin',
                            name='_secret_stores_plugin_names_uc')
    )
    op.create_table(
        'transport_keys',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('plugin_name', sa.String(length=255), nullable=False),
        sa.Column('transport_key', sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_table(
        'certificate_authorities',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('plugin_name', sa.String(length=255), nullable=False),
        sa.Column('plugin_ca_id', sa.Text(), nullable=False),
        sa.Column('expiration', sa.DateTime(), nullable=True),
        sa.Column('creator_id', sa.String(length=255), nullable=True),
        sa.Column('project_id', sa.String(length=36), nullable=True),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'],
                                name='cas_project_fk'),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_table(
        'containers',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('name', sa.String(length=255), nullable=True),
        sa.Column('type', sa.Enum('generic', 'rsa', 'dsa', 'certificate',
                                  name='container_types'), nullable=True),
        sa.Column('project_id', sa.String(length=36), nullable=False),
        sa.Column('creator_id', sa.String(length=255), nullable=True),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'],
                                name='containers_project_fk'),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_index(op.f('ix_containers_project_id'),
                    'containers', ['project_id'], unique=False)
    op.create_table(
        'kek_data',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('plugin_name', sa.String(length=255), nullable=False),
        sa.Column('kek_label', sa.String(length=255), nullable=True),
        sa.Column('project_id', sa.String(length=36), nullable=False),
        sa.Column('active', sa.Boolean(), nullable=False),
        sa.Column('bind_completed', sa.Boolean(), nullable=False),
        sa.Column('algorithm', sa.String(length=255), nullable=True),
        sa.Column('bit_length', sa.Integer(), nullable=True),
        sa.Column('mode', sa.String(length=255), nullable=True),
        sa.Column('plugin_meta', sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'],
                                name='kek_data_project_fk'),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_index(op.f('ix_kek_data_project_id'),
                    'kek_data', ['project_id'], unique=False)
    op.create_table(
        'project_quotas',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('project_id', sa.String(length=36), nullable=False),
        sa.Column('secrets', sa.Integer(), nullable=True),
        sa.Column('orders', sa.Integer(), nullable=True),
        sa.Column('containers', sa.Integer(), nullable=True),
        sa.Column('consumers', sa.Integer(), nullable=True),
        sa.Column('cas', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'],
                                name='project_quotas_fk'),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_index(op.f('ix_project_quotas_project_id'), 'project_quotas',
                    ['project_id'], unique=False)
    op.create_table(
        'project_secret_store',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('secret_store_id', sa.String(length=36), nullable=False),
        sa.Column('project_id', sa.String(length=36), nullable=False),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'], ),
        sa.ForeignKeyConstraint(['secret_store_id'], ['secret_stores.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('project_id',
                            name='_project_secret_store_project_uc')
    )
    op.create_index(op.f('ix_project_secret_store_project_id'),
                    'project_secret_store', ['project_id'], unique=False)
    op.create_index(op.f('ix_project_secret_store_secret_store_id'),
                    'project_secret_store', ['secret_store_id'],
                    unique=False)
    op.create_table(
        'secrets',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('name', sa.String(length=255), nullable=True),
        sa.Column('secret_type', sa.String(length=255),
                  server_default='opaque', nullable=True),
        sa.Column('expiration', sa.DateTime(), nullable=True),
        sa.Column('algorithm', sa.String(length=255), nullable=True),
        sa.Column('bit_length', sa.Integer(), nullable=True),
        sa.Column('mode', sa.String(length=255), nullable=True),
        sa.Column('creator_id', sa.String(length=255), nullable=True),
        sa.Column('project_id', sa.String(length=36), nullable=False),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'],
                                name='secrets_project_fk'),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_index(op.f('ix_secrets_project_id'), 'secrets', ['project_id'],
                    unique=False)
    op.create_table(
        'certificate_authority_metadata',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('key', sa.String(length=255), nullable=False),
        sa.Column('value', sa.Text(), nullable=False),
        sa.Column('ca_id', sa.String(length=36), nullable=False),
        sa.ForeignKeyConstraint(['ca_id'], ['certificate_authorities.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('ca_id', 'key',
                            name='_certificate_authority_metadatum_uc')
    )
    op.create_index(op.f('ix_certificate_authority_metadata_ca_id'),
                    'certificate_authority_metadata', ['ca_id'],
                    unique=False)
    op.create_index(op.f('ix_certificate_authority_metadata_key'),
                    'certificate_authority_metadata', ['key'], unique=False)
    op.create_table(
        'container_acls',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('container_id', sa.String(length=36), nullable=False),
        sa.Column('operation', sa.String(length=255), nullable=False),
        sa.Column('project_access', sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(['container_id'], ['containers.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('container_id', 'operation',
                            name='_container_acl_operation_uc')
    )
    op.create_index(op.f('ix_container_acls_container_id'), 'container_acls',
                    ['container_id'], unique=False)
    op.create_table(
        'container_consumer_metadata',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('container_id', sa.String(length=36), nullable=False),
        sa.Column('project_id', sa.String(length=36), nullable=True),
        sa.Column('name', sa.String(length=36), nullable=True),
        sa.Column('URL', sa.String(length=255), nullable=True),
        sa.Column('data_hash', sa.CHAR(length=64), nullable=True),
        sa.ForeignKeyConstraint(['container_id'], ['containers.id'], ),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('data_hash',
                            name='_consumer_hashed_container_name_url_uc')
    )
    op.create_index(op.f('ix_container_consumer_metadata_container_id'),
                    'container_consumer_metadata', ['container_id'],
                    unique=False)
    op.create_index(op.f('ix_container_consumer_metadata_project_id'),
                    'container_consumer_metadata', ['project_id'],
                    unique=False)
    op.create_index('values_index', 'container_consumer_metadata',
                    ['container_id', 'name', 'URL'], unique=False)
    op.create_table(
        'container_secret',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('name', sa.String(length=255), nullable=True),
        sa.Column('container_id', sa.String(length=36), nullable=False),
        sa.Column('secret_id', sa.String(length=36), nullable=False),
        sa.ForeignKeyConstraint(['container_id'], ['containers.id'], ),
        sa.ForeignKeyConstraint(['secret_id'], ['secrets.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('container_id', 'secret_id', 'name',
                            name='_container_secret_name_uc')
    )
    op.create_index(op.f('ix_container_secret_container_id'),
                    'container_secret', ['container_id'], unique=False)
    op.create_index(op.f('ix_container_secret_secret_id'), 'container_secret',
                    ['secret_id'], unique=False)
    op.create_table(
        'encrypted_data',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('content_type', sa.String(length=255), nullable=True),
        sa.Column('secret_id', sa.String(length=36), nullable=False),
        sa.Column('kek_id', sa.String(length=36), nullable=False),
        sa.Column('cypher_text', sa.Text(), nullable=True),
        sa.Column('kek_meta_extended', sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(['kek_id'], ['kek_data.id'], ),
        sa.ForeignKeyConstraint(['secret_id'], ['secrets.id'], ),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_index(op.f('ix_encrypted_data_kek_id'), 'encrypted_data',
                    ['kek_id'], unique=False)
    op.create_index(op.f('ix_encrypted_data_secret_id'), 'encrypted_data',
                    ['secret_id'], unique=False)
    op.create_table(
        'orders',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('type', sa.String(length=255), nullable=False),
        sa.Column('project_id', sa.String(length=36), nullable=False),
        sa.Column('error_status_code', sa.String(length=16), nullable=True),
        sa.Column('error_reason', sa.String(length=255), nullable=True),
        sa.Column('meta', barbican.model.models.JsonBlob(), nullable=True),
        sa.Column('secret_id', sa.String(length=36), nullable=True),
        sa.Column('container_id', sa.String(length=36), nullable=True),
        sa.Column('sub_status', sa.String(length=36), nullable=True),
        sa.Column('sub_status_message', sa.String(length=255), nullable=True),
        sa.Column('creator_id', sa.String(length=255), nullable=True),
        sa.ForeignKeyConstraint(['container_id'], ['containers.id'], ),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'],
                                name='orders_project_fk'),
        sa.ForeignKeyConstraint(['secret_id'], ['secrets.id'], ),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_index(op.f('ix_orders_container_id'), 'orders', ['container_id'],
                    unique=False)
    op.create_index(op.f('ix_orders_project_id'), 'orders', ['project_id'],
                    unique=False)
    op.create_index(op.f('ix_orders_secret_id'), 'orders', ['secret_id'],
                    unique=False)
    op.create_table(
        'preferred_certificate_authorities',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('project_id', sa.String(length=36), nullable=False),
        sa.Column('ca_id', sa.String(length=36), nullable=False),
        sa.ForeignKeyConstraint(['ca_id'], ['certificate_authorities.id'],
                                name='preferred_certificate_authorities_fk'),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'], ),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_index(op.f('ix_preferred_certificate_authorities_ca_id'),
                    'preferred_certificate_authorities', ['ca_id'],
                    unique=False)
    op.create_index(op.f('ix_preferred_certificate_authorities_project_id'),
                    'preferred_certificate_authorities', ['project_id'],
                    unique=True)
    op.create_table(
        'project_certificate_authorities',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('project_id', sa.String(length=36), nullable=False),
        sa.Column('ca_id', sa.String(length=36), nullable=False),
        sa.ForeignKeyConstraint(['ca_id'], ['certificate_authorities.id'], ),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('project_id', 'ca_id',
                            name='_project_certificate_authority_uc'))
    op.create_index(op.f('ix_project_certificate_authorities_ca_id'),
                    'project_certificate_authorities', ['ca_id'],
                    unique=False)
    op.create_index(op.f('ix_project_certificate_authorities_project_id'),
                    'project_certificate_authorities', ['project_id'],
                    unique=False)
    op.create_table(
        'secret_acls',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('secret_id', sa.String(length=36), nullable=False),
        sa.Column('operation', sa.String(length=255), nullable=False),
        sa.Column('project_access', sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(['secret_id'], ['secrets.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('secret_id', 'operation',
                            name='_secret_acl_operation_uc')
    )
    op.create_index(op.f('ix_secret_acls_secret_id'), 'secret_acls',
                    ['secret_id'], unique=False)
    op.create_table(
        'secret_store_metadata',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('key', sa.String(length=255), nullable=False),
        sa.Column('value', sa.String(length=255), nullable=False),
        sa.Column('secret_id', sa.String(length=36), nullable=False),
        sa.ForeignKeyConstraint(['secret_id'], ['secrets.id'], ),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_index(op.f('ix_secret_store_metadata_secret_id'),
                    'secret_store_metadata', ['secret_id'], unique=False)
    op.create_table(
        'secret_user_metadata',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('key', sa.String(length=255), nullable=False),
        sa.Column('value', sa.String(length=255), nullable=False),
        sa.Column('secret_id', sa.String(length=36), nullable=False),
        sa.ForeignKeyConstraint(['secret_id'], ['secrets.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('secret_id', 'key', name='_secret_key_uc')
    )
    op.create_index(op.f('ix_secret_user_metadata_secret_id'),
                    'secret_user_metadata', ['secret_id'], unique=False)
    op.create_table(
        'container_acl_users',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('acl_id', sa.String(length=36), nullable=False),
        sa.Column('user_id', sa.String(length=255), nullable=False),
        sa.ForeignKeyConstraint(['acl_id'], ['container_acls.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('acl_id', 'user_id', name='_container_acl_user_uc')
    )
    op.create_index(op.f('ix_container_acl_users_acl_id'),
                    'container_acl_users', ['acl_id'], unique=False)
    op.create_table(
        'order_barbican_metadata',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('order_id', sa.String(length=36), nullable=False),
        sa.Column('key', sa.String(length=255), nullable=False),
        sa.Column('value', sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(['order_id'], ['orders.id'], ),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_index(op.f('ix_order_barbican_metadata_order_id'),
                    'order_barbican_metadata', ['order_id'], unique=False)
    op.create_table(
        'order_plugin_metadata',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('order_id', sa.String(length=36), nullable=False),
        sa.Column('key', sa.String(length=255), nullable=False),
        sa.Column('value', sa.String(length=255), nullable=False),
        sa.ForeignKeyConstraint(['order_id'], ['orders.id'], ),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_index(op.f('ix_order_plugin_metadata_order_id'),
                    'order_plugin_metadata', ['order_id'], unique=False)
    op.create_table(
        'order_retry_tasks',
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('order_id', sa.String(length=36), nullable=False),
        sa.Column('retry_task', sa.Text(), nullable=False),
        sa.Column('retry_at', sa.DateTime(), nullable=False),
        sa.Column('retry_args', barbican.model.models.JsonBlob(),
                  nullable=False),
        sa.Column('retry_kwargs', barbican.model.models.JsonBlob(),
                  nullable=False),
        sa.Column('retry_count', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(['order_id'], ['orders.id'], ),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    op.create_index(op.f('ix_order_retry_tasks_order_id'), 'order_retry_tasks',
                    ['order_id'], unique=False)
    op.create_table(
        'secret_acl_users',
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=False),
        sa.Column('status', sa.String(length=20), nullable=False),
        sa.Column('acl_id', sa.String(length=36), nullable=False),
        sa.Column('user_id', sa.String(length=255), nullable=False),
        sa.ForeignKeyConstraint(['acl_id'], ['secret_acls.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('acl_id', 'user_id', name='_secret_acl_user_uc')
    )
    op.create_index(op.f('ix_secret_acl_users_acl_id'), 'secret_acl_users',
                    ['acl_id'], unique=False)
    # ### end Alembic commands ###
