
vcpkg_from_github(OUT_SOURCE_PATH SOURCE_PATH
    REPO DragonJoker/ShaderWriter
    REF v1.1.0
    SHA512 7c2a311f332342a2fc7d37e646314fe79f28a00292ff082903b3fc30f3ff86f222936fd2bc9d85d79a66caf854b05bfa5546f9d299c0764d695c027c5101bc74
)

vcpkg_from_github(OUT_SOURCE_PATH CMAKE_SOURCE_PATH
    REPO DragonJoker/CMakeUtils
    REF 0d750fb17099157f0e15e09cdf834453f3e8557a
    HEAD_REF master
    SHA512 579ad01149180b2295a0441b3c4b575448d2f4335d013948b15c7b70c0232d3488ac296d4864a7808773fa3e3c1a8fc4de0c7b42a6595cc9b9d27f154321984a
)

get_filename_component(SRC_PATH ${CMAKE_SOURCE_PATH} DIRECTORY)
if (EXISTS ${SRC_PATH}/CMake)
    file(REMOVE_RECURSE ${SRC_PATH}/CMake)
endif()
file(RENAME ${CMAKE_SOURCE_PATH} ${SRC_PATH}/CMake)
set(CMAKE_SOURCE_PATH ${SRC_PATH}/CMake)
file(COPY ${CMAKE_SOURCE_PATH} DESTINATION ${SOURCE_PATH})

string(COMPARE EQUAL "${VCPKG_LIBRARY_LINKAGE}" "static" BUILD_STATIC)

vcpkg_configure_cmake(
    SOURCE_PATH ${SOURCE_PATH}
    PREFER_NINJA
    OPTIONS
        -DPROJECTS_USE_PRECOMPILED_HEADERS=OFF
        -DSDW_GENERATE_SOURCE=OFF
        -DSDW_BUILD_VULKAN_LAYER=OFF
        -DSDW_BUILD_TESTS=OFF
        -DSDW_BUILD_STATIC_SDW=${BUILD_STATIC}
        -DSDW_BUILD_STATIC_SDAST=${BUILD_STATIC}
        -DSDW_BUILD_EXPORTER_GLSL_STATIC=${BUILD_STATIC}
        -DSDW_BUILD_EXPORTER_HLSL_STATIC=${BUILD_STATIC}
        -DSDW_BUILD_EXPORTER_SPIRV_STATIC=${BUILD_STATIC}
)

vcpkg_install_cmake()
vcpkg_fixup_cmake_targets(CONFIG_PATH lib/cmake/shaderwriter)

file(INSTALL ${SOURCE_PATH}/LICENSE DESTINATION ${CURRENT_PACKAGES_DIR}/share/${PORT} RENAME copyright)