; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=rewrite-statepoints-for-gc -S | FileCheck %s

; This test is to verify gc.relocate can handle pointer to vector of
; pointers (ptr addrspace(1) in this case).
; The old scheme to create a gc.relocate of ptr addrspace(1)
; type will fail because llvm does not support mangling vector of pointers.
; The new scheme will create all gc.relocate to ptr addrspace(1) type and
; then bitcast to the correct type.

declare void @foo()

declare void @use(...) "gc-leaf-function"

define void @test1(ptr addrspace(1) %obj) gc "statepoint-example" {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[STATEPOINT_TOKEN:%.*]] = call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 2882400000, i32 0, ptr elementtype(void ()) @foo, i32 0, i32 0, i32 0, i32 0) [ "deopt"(), "gc-live"(ptr addrspace(1) [[OBJ:%.*]]) ]
; CHECK-NEXT:    [[OBJ_RELOCATED:%.*]] = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[STATEPOINT_TOKEN]], i32 0, i32 0)
; CHECK-NEXT:    call void (...) @use(ptr addrspace(1) [[OBJ_RELOCATED]])
; CHECK-NEXT:    ret void
;
entry:

  call void @foo() [ "deopt"() ]
  call void (...) @use(ptr addrspace(1) %obj)
  ret void
}
