/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef IMPHEADER_H_INCLUDED
#define IMPHEADER_H_INCLUDED

#include <boost/shared_ptr.hpp>

#include "IMPTypes.h"


namespace libebook
{

class IMPHeader
{
public:
  explicit IMPHeader(librevenge::RVNGInputStream *input);

  static boost::shared_ptr<IMPHeader> create(librevenge::RVNGInputStream *input);

  unsigned getVersion() const;
  IMPColorMode getColorMode() const;
  unsigned getFileCount() const;
  bool getCompressed() const;
  bool getEncrypted() const;
  const IMPMetadata &getMetadata() const;

  unsigned getTOCOffset() const;

private:
  void readHeader(librevenge::RVNGInputStream *input);
  void readBookProperties(librevenge::RVNGInputStream *input);

private:
  unsigned m_version;
  IMPColorMode m_colorMode;
  unsigned m_files;
  unsigned m_dirNameLength;
  unsigned m_remainingBytes;
  bool m_compressed;
  bool m_encrypted;
  IMPMetadata m_metadata;
};

}

#endif // IMPHEADER_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
