/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfvalidator.Logger;
import org.odftoolkit.odfvalidator.ODFPackageValidator;
import org.odftoolkit.odfvalidator.ODFValidatorException;
import org.odftoolkit.odfvalidator.ODFValidatorProvider;
import org.odftoolkit.odfvalidator.OdfValidatorMode;
import org.odftoolkit.odfvalidator.OdfVersion;
import org.odftoolkit.odfvalidator.SAXParseExceptionFilter;

class ODFSubPackageValidator
extends ODFPackageValidator {
    private OdfPackage m_aPkg = null;
    private String m_aBaseURI = null;
    private String m_aSubEntryName = null;

    ODFSubPackageValidator(OdfPackage aPkg, String aBaseURI, String aSubEntryName, String aMediaType, Logger.LogLevel nLogLevel, OdfValidatorMode eMode, OdfVersion aVersion, SAXParseExceptionFilter aFilter, String aParentGenerator, ODFValidatorProvider aValidatorProvider) throws ODFValidatorException {
        super(nLogLevel, eMode, aVersion, aFilter, aValidatorProvider);
        this.m_aPkg = aPkg;
        this.m_aBaseURI = aBaseURI;
        this.m_aSubEntryName = aSubEntryName;
        this.m_aResult.setMediaType(aMediaType);
        if (aFilter != null) {
            aFilter.startPackage(aParentGenerator);
        }
    }

    @Override
    protected String getLoggerName() {
        return this.m_aBaseURI;
    }

    @Override
    protected String getDocumentPath() {
        return this.m_aSubEntryName;
    }

    @Override
    protected OdfPackage getPackage(Logger aLogger) {
        return this.m_aPkg;
    }

    @Override
    protected String getStreamName(String aEntry) {
        return this.m_aSubEntryName + aEntry;
    }
}

