/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.util.UndoManager;
import org.jhotdraw.util.Undoable;

public class UndoCommand
extends AbstractCommand {
    public UndoCommand(String string, DrawingEditor drawingEditor) {
        super(string, drawingEditor);
    }

    public void execute() {
        super.execute();
        UndoManager undoManager = this.getDrawingEditor().getUndoManager();
        if (undoManager == null || !undoManager.isUndoable()) {
            return;
        }
        Undoable undoable = undoManager.popUndo();
        boolean bl = undoable.undo();
        if (bl && undoable.isRedoable()) {
            undoManager.pushRedo(undoable);
        }
        undoable.getDrawingView().checkDamage();
        this.getDrawingEditor().figureSelectionChanged(undoable.getDrawingView());
    }

    public boolean isExecutableWithView() {
        UndoManager undoManager = this.getDrawingEditor().getUndoManager();
        return undoManager != null && undoManager.getUndoSize() > 0;
    }
}

