RabbitMQ `3.9.6` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports the latest Erlang 24 version, 24.0.5 at the time of release. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.



## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes. This helps with release automation and a more consistent release schedule.


### Core Server

#### Bug Fixes

 * TLS information delivered in [Proxy protocol](https://www.rabbitmq.com/networking.html#proxy-protocol) header is now attached to connection metrics as if it was provided by a non-proxying client.

  GitHub issues: [#3175](https://github.com/rabbitmq/rabbitmq-server/pull/3175), [#3371](https://github.com/rabbitmq/rabbitmq-server/pull/3371) contributed by @prefiks, sponsored by CloudAMQP

 * `max_message_size` had a one-off error in the validator.

   GitHub issue: [#3398](https://github.com/rabbitmq/rabbitmq-server/pull/3398)

 * `mirroring_sync_batch_size` was incorrectly validated as if it represented batch size in bytes.
   It represents batch size in number of messages, so the new default hard cap is now 1M (a very high number that's impractical)

   GitHub issue: [#3398](https://github.com/rabbitmq/rabbitmq-server/pull/3398)

### Stream Plugin

#### Bug Fixes

 * Offset parameters were not stored correctly in some cases.

   GitHub issue: [#3360](https://github.com/rabbitmq/rabbitmq-server/pull/3360), contributed by @korsmakolnikov

 * Partitions list order is now stable.

   GitHub issue: [#3423](https://github.com/rabbitmq/rabbitmq-server/pull/3423)

 * When stream clients close connections abruptly, publisher and consumer metrics get cleaned up correctly.

   GitHub issue: [#3340](https://github.com/rabbitmq/rabbitmq-server/pull/3340)

### Management Plugin

#### Enhancements

  * Stream publishers are now listed on the individual stream page.

    GitHub issue: [#3389](https://github.com/rabbitmq/rabbitmq-server/issues/3389)

  * Counters have been added to the tiles of several sections on detail pages.

    GitHub issue: [#3422](https://github.com/rabbitmq/rabbitmq-server/pull/3422)


## Dependency Upgrades

 * Osiris was [upgraded to `1.2.0`](https://github.com/rabbitmq/osiris/compare/v1.1.0...v1.2.0)
 * Ranch was [upgraded to `2.1.0`](https://github.com/ninenines/ranch/compare/2.0.0...2.1.0)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.6.tar.xz` instead of the source tarball produced by GitHub.
