/* table-lookup-test.c generated by valac 0.20.1, the Vala compiler
 * generated from table-lookup-test.vala, do not modify */

/* where-clause-test.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-engine.h"
#include "zeitgeist-internal.h"
#include <sqlite3.h>


#define TYPE_PUBLIC_ENGINE (public_engine_get_type ())
#define PUBLIC_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUBLIC_ENGINE, PublicEngine))
#define PUBLIC_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUBLIC_ENGINE, PublicEngineClass))
#define IS_PUBLIC_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUBLIC_ENGINE))
#define IS_PUBLIC_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUBLIC_ENGINE))
#define PUBLIC_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUBLIC_ENGINE, PublicEngineClass))

typedef struct _PublicEngine PublicEngine;
typedef struct _PublicEngineClass PublicEngineClass;
typedef struct _PublicEnginePrivate PublicEnginePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PublicEngine {
	ZeitgeistEngine parent_instance;
	PublicEnginePrivate * priv;
};

struct _PublicEngineClass {
	ZeitgeistEngineClass parent_class;
};


static gpointer public_engine_parent_class = NULL;

gint _vala_main (gchar** args, int args_length1);
void basic_test (void);
static void _basic_test_gtest_func (void);
void engine_test (void);
static void _engine_test_gtest_func (void);
void get_value_with_query_test (void);
static void _get_value_with_query_test_gtest_func (void);
GType public_engine_get_type (void) G_GNUC_CONST;
enum  {
	PUBLIC_ENGINE_DUMMY_PROPERTY
};
ZeitgeistSQLiteTableLookup* public_engine_get_actors_table_lookup (PublicEngine* self);
PublicEngine* public_engine_new (void);
PublicEngine* public_engine_construct (GType object_type);


static void _basic_test_gtest_func (void) {
#line 39 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	basic_test ();
#line 79 "table-lookup-test.c"
}


static void _engine_test_gtest_func (void) {
#line 40 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	engine_test ();
#line 86 "table-lookup-test.c"
}


static void _get_value_with_query_test_gtest_func (void) {
#line 41 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	get_value_with_query_test ();
#line 93 "table-lookup-test.c"
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
#line 27 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	g_test_init (&args_length1, &args, NULL);
#line 30 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	g_log_set_always_fatal (G_LOG_LEVEL_CRITICAL);
#line 34 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp0_ = g_setenv ("ZEITGEIST_DATA_PATH", "/tmp/zeitgeist-tests", TRUE);
#line 34 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_vala_assert (_tmp0_, "Environment.set_variable(         \"ZEITGEIST_DATA_PATH\", \"/tmp/zeitgeist-tests\", true)");
#line 36 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp1_ = g_setenv ("ZEITGEIST_DATABASE_PATH", ":memory:", TRUE);
#line 36 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_vala_assert (_tmp1_, "Environment.set_variable(         \"ZEITGEIST_DATABASE_PATH\", \":memory:\", true)");
#line 39 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	g_test_add_func ("/WhereClause/basic", _basic_test_gtest_func);
#line 40 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	g_test_add_func ("/WhereClause/delete_hook", _engine_test_gtest_func);
#line 41 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	g_test_add_func ("/WhereClause/get_value_query", _get_value_with_query_test_gtest_func);
#line 43 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp2_ = g_test_run ();
#line 43 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	result = _tmp2_;
#line 43 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	return result;
#line 126 "table-lookup-test.c"
}


int main (int argc, char ** argv) {
#line 25 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	g_type_init ();
#line 25 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	return _vala_main (argv, argc);
#line 135 "table-lookup-test.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 50 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 142 "table-lookup-test.c"
}


ZeitgeistSQLiteTableLookup* public_engine_get_actors_table_lookup (PublicEngine* self) {
	ZeitgeistSQLiteTableLookup* result = NULL;
	ZeitgeistSQLiteTableLookup* _tmp0_;
	ZeitgeistSQLiteTableLookup* _tmp1_;
#line 48 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp0_ = ((ZeitgeistDbReader*) self)->actors_table;
#line 50 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 50 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	result = _tmp1_;
#line 50 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	return result;
#line 160 "table-lookup-test.c"
}


PublicEngine* public_engine_construct (GType object_type) {
	PublicEngine * self = NULL;
	GError * _inner_error_ = NULL;
#line 46 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	self = (PublicEngine*) zeitgeist_engine_construct (object_type, &_inner_error_);
#line 46 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	if (_inner_error_ != NULL) {
#line 46 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 46 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_clear_error (&_inner_error_);
#line 46 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		return NULL;
#line 177 "table-lookup-test.c"
	}
#line 46 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	return self;
#line 181 "table-lookup-test.c"
}


PublicEngine* public_engine_new (void) {
#line 46 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	return public_engine_construct (TYPE_PUBLIC_ENGINE);
#line 188 "table-lookup-test.c"
}


static void public_engine_class_init (PublicEngineClass * klass) {
#line 46 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	public_engine_parent_class = g_type_class_peek_parent (klass);
#line 195 "table-lookup-test.c"
}


static void public_engine_instance_init (PublicEngine * self) {
}


GType public_engine_get_type (void) {
	static volatile gsize public_engine_type_id__volatile = 0;
	if (g_once_init_enter (&public_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PublicEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) public_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublicEngine), 0, (GInstanceInitFunc) public_engine_instance_init, NULL };
		GType public_engine_type_id;
		public_engine_type_id = g_type_register_static (ZEITGEIST_TYPE_ENGINE, "PublicEngine", &g_define_type_info, 0);
		g_once_init_leave (&public_engine_type_id__volatile, public_engine_type_id);
	}
	return public_engine_type_id__volatile;
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	const gchar* _tmp0_;
	sqlite3_callback _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint ec;
	const gchar* _tmp6_;
#line 34 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 34 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	g_return_val_if_fail (sql != NULL, 0);
#line 36 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	_tmp0_ = sql;
#line 36 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	_tmp1_ = callback;
#line 36 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	_tmp1__target = callback_target;
#line 36 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
#line 36 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	sqlite_errmsg = _tmp2_;
#line 36 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	ec = _tmp3_;
#line 37 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	if ((&_vala_errmsg) != NULL) {
#line 244 "table-lookup-test.c"
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 38 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
		_tmp4_ = sqlite_errmsg;
#line 38 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
		_tmp5_ = g_strdup (_tmp4_);
#line 38 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 38 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
		_vala_errmsg = _tmp5_;
#line 255 "table-lookup-test.c"
	}
#line 40 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	_tmp6_ = sqlite_errmsg;
#line 40 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	sqlite3_free ((void*) _tmp6_);
#line 41 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	result = ec;
#line 41 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	if (errmsg) {
#line 41 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
		*errmsg = _vala_errmsg;
#line 267 "table-lookup-test.c"
	} else {
#line 41 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 271 "table-lookup-test.c"
	}
#line 41 "/usr/share/vala-0.20/vapi/sqlite3.vapi"
	return result;
#line 275 "table-lookup-test.c"
}


void basic_test (void) {
	ZeitgeistSQLiteDatabase* _tmp0_;
	ZeitgeistSQLiteDatabase* database;
	ZeitgeistSQLiteDatabase* _tmp1_;
	sqlite3* _tmp2_;
	sqlite3* db;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteTableLookup* _tmp4_;
	ZeitgeistSQLiteTableLookup* table_lookup;
	ZeitgeistSQLiteTableLookup* _tmp5_;
	gint _tmp6_ = 0;
	gint id;
	ZeitgeistSQLiteTableLookup* _tmp7_;
	gint _tmp8_ = 0;
	gint _tmp9_;
	gint _tmp10_;
	ZeitgeistSQLiteTableLookup* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_;
	gint _tmp14_;
	sqlite3* _tmp15_;
	gint _tmp16_ = 0;
	gint rc;
	gint _tmp17_;
	ZeitgeistSQLiteTableLookup* _tmp18_;
	ZeitgeistSQLiteTableLookup* _tmp19_;
	gint _tmp20_ = 0;
	gint _tmp21_;
	gint _tmp22_;
	ZeitgeistSQLiteTableLookup* _tmp23_;
	gint _tmp24_ = 0;
	gint _tmp25_;
	gint _tmp26_;
	GError * _inner_error_ = NULL;
#line 56 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp0_ = zeitgeist_sq_lite_database_new (&_inner_error_);
#line 56 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	database = _tmp0_;
#line 56 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	if (_inner_error_ != NULL) {
#line 56 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 56 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_clear_error (&_inner_error_);
#line 56 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		return;
#line 325 "table-lookup-test.c"
	}
#line 57 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp1_ = database;
#line 57 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp2_ = _tmp1_->database;
#line 57 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	db = _tmp2_;
#line 58 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp3_ = database;
#line 58 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp4_ = zeitgeist_sq_lite_table_lookup_new (_tmp3_, "actor", &_inner_error_);
#line 58 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	table_lookup = _tmp4_;
#line 58 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	if (_inner_error_ != NULL) {
#line 58 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (database);
#line 58 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 58 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_clear_error (&_inner_error_);
#line 58 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		return;
#line 349 "table-lookup-test.c"
	}
#line 60 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp5_ = table_lookup;
#line 60 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp6_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp5_, "1st-actor", &_inner_error_);
#line 60 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	id = _tmp6_;
#line 60 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	if (_inner_error_ != NULL) {
#line 60 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 60 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (database);
#line 60 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 60 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_clear_error (&_inner_error_);
#line 60 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		return;
#line 369 "table-lookup-test.c"
	}
#line 61 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp7_ = table_lookup;
#line 61 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp8_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp7_, "2nd-actor", &_inner_error_);
#line 61 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp9_ = _tmp8_;
#line 61 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	if (_inner_error_ != NULL) {
#line 61 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 61 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (database);
#line 61 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 61 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_clear_error (&_inner_error_);
#line 61 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		return;
#line 389 "table-lookup-test.c"
	}
#line 61 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp10_ = id;
#line 61 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	g_assert_cmpint (_tmp9_, ==, _tmp10_ + 1);
#line 62 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp11_ = table_lookup;
#line 62 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp12_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp11_, "1st-actor", &_inner_error_);
#line 62 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp13_ = _tmp12_;
#line 62 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	if (_inner_error_ != NULL) {
#line 62 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 62 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (database);
#line 62 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 62 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_clear_error (&_inner_error_);
#line 62 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		return;
#line 413 "table-lookup-test.c"
	}
#line 62 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp14_ = id;
#line 62 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	g_assert_cmpint (_tmp13_, ==, _tmp14_);
#line 64 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp15_ = db;
#line 64 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp16_ = _sqlite3_exec (_tmp15_, "DELETE FROM actor WHERE value='1st-actor'", NULL, NULL, NULL);
#line 64 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	rc = _tmp16_;
#line 65 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp17_ = rc;
#line 65 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_vala_assert (_tmp17_ == SQLITE_OK, "rc == Sqlite.OK");
#line 67 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp18_ = table_lookup;
#line 67 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	zeitgeist_sq_lite_table_lookup_remove (_tmp18_, 1);
#line 68 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp19_ = table_lookup;
#line 68 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp20_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp19_, "2nd-actor", &_inner_error_);
#line 68 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp21_ = _tmp20_;
#line 68 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	if (_inner_error_ != NULL) {
#line 68 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 68 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (database);
#line 68 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 68 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_clear_error (&_inner_error_);
#line 68 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		return;
#line 451 "table-lookup-test.c"
	}
#line 68 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp22_ = id;
#line 68 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	g_assert_cmpint (_tmp21_, ==, _tmp22_ + 1);
#line 69 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp23_ = table_lookup;
#line 69 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp24_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp23_, "1st-actor", &_inner_error_);
#line 69 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp25_ = _tmp24_;
#line 69 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	if (_inner_error_ != NULL) {
#line 69 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 69 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (database);
#line 69 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 69 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_clear_error (&_inner_error_);
#line 69 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		return;
#line 475 "table-lookup-test.c"
	}
#line 69 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp26_ = id;
#line 69 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	g_assert_cmpint (_tmp25_, ==, _tmp26_ + 2);
#line 54 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_g_object_unref0 (table_lookup);
#line 54 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_g_object_unref0 (database);
#line 485 "table-lookup-test.c"
}


void get_value_with_query_test (void) {
	ZeitgeistSQLiteDatabase* _tmp0_;
	ZeitgeistSQLiteDatabase* database;
	ZeitgeistSQLiteDatabase* _tmp1_;
	sqlite3* _tmp2_;
	sqlite3* db;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteTableLookup* _tmp4_;
	ZeitgeistSQLiteTableLookup* table_lookup;
	sqlite3* _tmp5_;
	gint _tmp6_ = 0;
	gint rc;
	gint _tmp7_;
	ZeitgeistSQLiteTableLookup* _tmp8_;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_;
	GError * _inner_error_ = NULL;
#line 74 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp0_ = zeitgeist_sq_lite_database_new (&_inner_error_);
#line 74 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	database = _tmp0_;
#line 74 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	if (_inner_error_ != NULL) {
#line 74 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 74 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_clear_error (&_inner_error_);
#line 74 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		return;
#line 518 "table-lookup-test.c"
	}
#line 75 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp1_ = database;
#line 75 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp2_ = _tmp1_->database;
#line 75 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	db = _tmp2_;
#line 76 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp3_ = database;
#line 76 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp4_ = zeitgeist_sq_lite_table_lookup_new (_tmp3_, "actor", &_inner_error_);
#line 76 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	table_lookup = _tmp4_;
#line 76 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	if (_inner_error_ != NULL) {
#line 76 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (database);
#line 76 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 76 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_clear_error (&_inner_error_);
#line 76 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		return;
#line 542 "table-lookup-test.c"
	}
#line 78 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp5_ = db;
#line 78 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp6_ = _sqlite3_exec (_tmp5_, "INSERT INTO actor (id, value) VALUES (100, 'new-actor')", NULL, NULL, NULL);
#line 78 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	rc = _tmp6_;
#line 79 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp7_ = rc;
#line 79 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "rc == Sqlite.OK");
#line 81 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp8_ = table_lookup;
#line 81 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp9_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp8_, 100, &_inner_error_);
#line 81 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp10_ = _tmp9_;
#line 81 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	if (_inner_error_ != NULL) {
#line 81 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 81 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (database);
#line 81 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 81 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_clear_error (&_inner_error_);
#line 81 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		return;
#line 572 "table-lookup-test.c"
	}
#line 81 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	g_assert_cmpstr (_tmp10_, ==, "new-actor");
#line 72 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_g_object_unref0 (table_lookup);
#line 72 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_g_object_unref0 (database);
#line 580 "table-lookup-test.c"
}


void engine_test (void) {
	PublicEngine* _tmp0_;
	PublicEngine* engine;
	PublicEngine* _tmp1_;
	ZeitgeistSQLiteDatabase* _tmp2_;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	ZeitgeistSQLiteDatabase* database;
	ZeitgeistSQLiteDatabase* _tmp5_;
	sqlite3* _tmp6_;
	sqlite3* db;
	PublicEngine* _tmp7_;
	ZeitgeistSQLiteTableLookup* _tmp8_ = NULL;
	ZeitgeistSQLiteTableLookup* table_lookup;
	ZeitgeistSQLiteTableLookup* _tmp9_;
	gint _tmp10_ = 0;
	gint _tmp11_;
	sqlite3* _tmp12_;
	gint _tmp13_ = 0;
	gint rc;
	gint _tmp14_;
	ZeitgeistSQLiteTableLookup* _tmp15_;
	gint _tmp16_ = 0;
	gint _tmp17_;
	GError * _inner_error_ = NULL;
#line 86 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp0_ = public_engine_new ();
#line 86 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	engine = _tmp0_;
#line 87 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp1_ = engine;
#line 87 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp2_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) _tmp1_);
#line 87 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp3_ = _tmp2_;
#line 87 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 87 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	database = _tmp4_;
#line 88 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp5_ = database;
#line 88 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp6_ = _tmp5_->database;
#line 88 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	db = _tmp6_;
#line 89 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp7_ = engine;
#line 89 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp8_ = public_engine_get_actors_table_lookup (_tmp7_);
#line 89 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	table_lookup = _tmp8_;
#line 91 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp9_ = table_lookup;
#line 91 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp10_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp9_, "something", &_inner_error_);
#line 91 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp11_ = _tmp10_;
#line 91 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	if (_inner_error_ != NULL) {
#line 91 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 91 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (database);
#line 91 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (engine);
#line 91 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 91 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_clear_error (&_inner_error_);
#line 91 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		return;
#line 655 "table-lookup-test.c"
	}
#line 91 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	g_assert_cmpint (_tmp11_, ==, 1);
#line 95 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp12_ = db;
#line 95 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp13_ = _sqlite3_exec (_tmp12_, "DELETE FROM actor WHERE value='something'", NULL, NULL, NULL);
#line 95 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	rc = _tmp13_;
#line 96 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp14_ = rc;
#line 96 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_vala_assert (_tmp14_ == SQLITE_OK, "rc == Sqlite.OK");
#line 98 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp15_ = table_lookup;
#line 98 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp16_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp15_, "something", &_inner_error_);
#line 98 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_tmp17_ = _tmp16_;
#line 98 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	if (_inner_error_ != NULL) {
#line 98 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 98 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (database);
#line 98 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		_g_object_unref0 (engine);
#line 98 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 98 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		g_clear_error (&_inner_error_);
#line 98 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
		return;
#line 689 "table-lookup-test.c"
	}
#line 98 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	g_assert_cmpint (_tmp17_, ==, 2);
#line 84 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_g_object_unref0 (table_lookup);
#line 84 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_g_object_unref0 (database);
#line 84 "/home/manish/code/zeitgeist/test/direct/table-lookup-test.vala"
	_g_object_unref0 (engine);
#line 699 "table-lookup-test.c"
}



