FIND_PATH(LIBZIP_INCLUDE_DIR NAMES zip.h)
MARK_AS_ADVANCED(LIBZIP_INCLUDE_DIR)

FIND_LIBRARY(LIBZIP_LIBRARY NAMES zip)
MARK_AS_ADVANCED(LIBZIP_LIBRARY)

IF(LIBZIP_INCLUDE_DIR AND LIBZIP_LIBRARY)
  SET(LIBZIP_FOUND 1)
  SET(LIBZIP_LIBRARIES ${LIBZIP_LIBRARY})
  SET(LIBZIP_INCLUDE_DIRS ${LIBZIP_INCLUDE_DIR})
ELSE(LIBZIP_INCLUDE_DIR AND LIBZIP_LIBRARY)
  SET(LIBZIP_FOUND 0)
  SET(LIBZIP_LIBRARIES)
  SET(LIBZIP_INCLUDE_DIRS)
ENDIF(LIBZIP_INCLUDE_DIR AND LIBZIP_LIBRARY)

# Report the results.
IF(NOT LIBZIP_FOUND)
  SET(LIBZIP_DIR_MESSAGE
      "LIBZIP was not found. Make sure LIBZIP_LIBRARY and LIBZIP_INCLUDE_DIR are set.")
  IF(NOT LIBZIP_FIND_QUIETLY)
    MESSAGE(STATUS "${LIBZIP_DIR_MESSAGE}")
  ELSE(NOT LIBZIP_FIND_QUIETLY)
    IF(LIBZIP_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "${LIBZIP_DIR_MESSAGE}")
    ENDIF(LIBZIP_FIND_REQUIRED)
  ENDIF(NOT LIBZIP_FIND_QUIETLY)
ENDIF(NOT LIBZIP_FOUND)


