/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.UserCreateRequest;
import com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyResult;
import com.amazonaws.services.identitymanagement.model.CreateUserRequest;
import com.amazonaws.services.identitymanagement.model.CreateUserResult;
import com.amazonaws.services.identitymanagement.model.GetGroupRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMUserCreateDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMUserCreateDriver.class);

    public void invokeRequestImpl(CLIRequest request) {
        if (request instanceof UserCreateRequest) {
            UserCreateRequest req = (UserCreateRequest)request;
            if (req.getGroupNames() != null && !req.getGroupNames().isEmpty()) {
                for (String groupName : req.getGroupNames()) {
                    GetGroupRequest getGroupRequest = new GetGroupRequest();
                    getGroupRequest.setGroupName(groupName);
                    getGroupRequest.setMaxItems(1);
                    this.getClient().getGroup(getGroupRequest);
                }
            }
            CreateUserRequest createUserRequest = new CreateUserRequest();
            createUserRequest.setPath(this.verifyPathAndAddSlashSuffix(req.getPath()));
            createUserRequest.setUserName(req.getUserName());
            LOG.debug((Object)("Creating user with request " + request));
            CreateUserResult createUserResult = this.getClient().createUser(createUserRequest);
            if (req.isCreateKey()) {
                LOG.debug((Object)("creating accesskey with request " + request));
                CreateAccessKeyRequest accessKeyRequest = new CreateAccessKeyRequest();
                accessKeyRequest.setUserName(req.getUserName());
                LOG.debug((Object)("Creating accesskey with request " + request));
                CreateAccessKeyResult accessKeyResult = this.getClient().createAccessKey(accessKeyRequest);
                LOG.info((Object)accessKeyResult.getAccessKey().getAccessKeyId());
                LOG.info((Object)accessKeyResult.getAccessKey().getSecretAccessKey());
            }
            if (req.getGroupNames() != null && !req.getGroupNames().isEmpty()) {
                for (String group : req.getGroupNames()) {
                    AddUserToGroupRequest groupRequest = new AddUserToGroupRequest();
                    groupRequest.setGroupName(group);
                    groupRequest.setUserName(req.getUserName());
                    LOG.debug((Object)("Adding user to group " + groupRequest));
                    this.getClient().addUserToGroup(groupRequest);
                }
            }
            if (req.isVerbose()) {
                LOG.info((Object)createUserResult.getUser().getArn());
                LOG.info((Object)createUserResult.getUser().getUserId());
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

