/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.FocusOwnerFinderStrategy;
import org.fest.swing.core.HierarchyBasedFocusOwnerFinder;
import org.fest.swing.core.ReflectionBasedFocusOwnerFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Collections;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FocusOwnerFinder {
    private static final List<FocusOwnerFinderStrategy> STRATEGIES = new ArrayList<FocusOwnerFinderStrategy>();

    @VisibleForTesting
    static void initializeStrategies() {
        FocusOwnerFinder.replaceStrategiesWith(new ReflectionBasedFocusOwnerFinder(), new HierarchyBasedFocusOwnerFinder());
    }

    @VisibleForTesting
    static void replaceStrategiesWith(FocusOwnerFinderStrategy ... strategies) {
        STRATEGIES.clear();
        STRATEGIES.addAll(Collections.list((Object[])strategies));
    }

    @VisibleForTesting
    static List<FocusOwnerFinderStrategy> strategies() {
        return new ArrayList<FocusOwnerFinderStrategy>(STRATEGIES);
    }

    @RunsInEDT
    public static Component inEdtFocusOwner() {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            protected Component executeInEDT() {
                return FocusOwnerFinder.focusOwner();
            }
        });
    }

    @RunsInCurrentThread
    public static Component focusOwner() {
        for (FocusOwnerFinderStrategy strategy : STRATEGIES) {
            try {
                return strategy.focusOwner();
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    private FocusOwnerFinder() {
    }

    static {
        FocusOwnerFinder.initializeStrategies();
    }
}

