/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JTreeFixture;
import org.fest.swing.fixture.JTreeNodeFixture;

public class JTreeRowFixture
implements JTreeNodeFixture {
    private final int index;
    private final JTreeFixture tree;

    protected JTreeRowFixture(JTreeFixture tree, int index) {
        this.tree = tree;
        this.index = index;
    }

    public JTreeRowFixture expand() {
        this.tree.expandRow(this.index);
        return this;
    }

    public JTreeRowFixture collapse() {
        this.tree.collapseRow(this.index);
        return this;
    }

    public JTreeRowFixture select() {
        this.tree.selectRow(this.index);
        return this;
    }

    public JTreeRowFixture click() {
        this.tree.clickRow(this.index);
        return this;
    }

    public JTreeRowFixture click(MouseButton button) {
        this.tree.clickRow(this.index, button);
        return this;
    }

    public JTreeRowFixture click(MouseClickInfo mouseClickInfo) {
        this.tree.clickRow(this.index, mouseClickInfo);
        return this;
    }

    public JTreeRowFixture doubleClick() {
        this.tree.doubleClickRow(this.index);
        return this;
    }

    public JTreeRowFixture rightClick() {
        this.tree.rightClickRow(this.index);
        return this;
    }

    public JTreeRowFixture drag() {
        this.tree.drag(this.index);
        return this;
    }

    public JTreeRowFixture drop() {
        this.tree.drop(this.index);
        return this;
    }

    public JPopupMenuFixture showPopupMenu() {
        return this.tree.showPopupMenuAt(this.index);
    }

    public String value() {
        return this.tree.valueAt(this.index);
    }

    public int index() {
        return this.index;
    }
}

