/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.Jpeg2000Module;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Marker;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Tile;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class ContCodestream {
    private Codestream _codestream;
    private long _length;
    private Jpeg2000Module _module;
    private DataInputStream _dstream;
    private List _tileParts;
    private List _tiles;
    private long _tileLeft;
    private Tile _curTile;
    private boolean ppmSeen;
    private static final int SOC = 79;
    private static final int COD = 82;
    private static final int COC = 83;
    private static final int TLM = 85;
    private static final int PLM = 87;
    private static final int PLT = 88;
    private static final int QCD = 92;
    private static final int QCC = 93;
    private static final int RGN = 94;
    private static final int POC = 95;
    private static final int PPM = 96;
    private static final int PPT = 97;
    private static final int CRG = 99;
    private static final int COM = 100;
    private static final int SOT = 144;
    private static final int SOP = 145;
    private static final int EPH = 146;
    private static final int SOD = 147;
    private static final int EOC = 217;
    private static final int SIZ = 81;

    public ContCodestream(Jpeg2000Module jpeg2000Module, DataInputStream dataInputStream, long l) {
        this._module = jpeg2000Module;
        this._dstream = dataInputStream;
        this._length = l;
        this._tiles = new LinkedList();
        this._tileParts = new LinkedList();
        this.ppmSeen = false;
    }

    public boolean readCodestream(Codestream codestream, RepInfo repInfo) throws IOException {
        this._codestream = codestream;
        long l = this._length;
        this._tileLeft = 0L;
        boolean bl = false;
        if (l == 0L) {
            l = Long.MAX_VALUE;
        }
        try {
            while (l > 0L) {
                int n = ModuleBase.readUnsignedByte(this._dstream, this._module);
                if (n != 255) {
                    repInfo.setMessage(new ErrorMessage("Ill-formed codestream"));
                    repInfo.setWellFormed(false);
                    return false;
                }
                int n2 = ModuleBase.readUnsignedByte(this._dstream, this._module);
                if (n2 == 79) {
                    bl = true;
                }
                MarkerSegment markerSegment = MarkerSegment.markerSegmentMaker(n2);
                markerSegment.setCodestream(codestream);
                markerSegment.setContCodestream(this);
                markerSegment.setDataInputStream(this._dstream);
                markerSegment.setRepInfo(repInfo);
                markerSegment.setModule(this._module);
                int n3 = markerSegment.readMarkLen();
                if (!markerSegment.process(n3 == 0 ? 0 : n3 - 2)) {
                    repInfo.setMessage(new ErrorMessage("Invalid marker segment"));
                    repInfo.setWellFormed(false);
                    return false;
                }
                if (!(markerSegment instanceof Marker)) {
                    l -= (long)(n3 + 2);
                    if (this._tileLeft <= 0L) continue;
                    this._tileLeft -= (long)(n3 + 2);
                    continue;
                }
                l -= 2L;
                if (this._tileLeft > 0L) {
                    this._tileLeft -= 2L;
                }
                if (n2 == 147) {
                    this._module.skipBytes(this._dstream, (int)this._tileLeft, this._module);
                    l -= this._tileLeft;
                    this._tileLeft = 0L;
                    continue;
                }
                if (n2 != 217) continue;
                break;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (!bl) {
            repInfo.setMessage(new ErrorMessage("Ill-formed codestream"));
            repInfo.setWellFormed(false);
            return false;
        }
        this._codestream.setTiles(this._tiles);
        return true;
    }

    public List getTiles() {
        return this._tiles;
    }

    protected void setTileLeft(long l) {
        this._tileLeft = l;
    }

    protected Tile getTile(int n) {
        while (this._tiles.size() <= n) {
            this._tiles.add(new Tile());
        }
        return (Tile)this._tiles.get(n);
    }

    protected void setCurTile(Tile tile) {
        this._curTile = tile;
    }

    protected void setPPMSeen(boolean bl) {
        this.ppmSeen = bl;
    }

    protected Tile getCurTile() {
        return this._curTile;
    }

    protected boolean isPPMSeen() {
        return this.ppmSeen;
    }

    private static boolean isSegment(int n) {
        return (n < 48 || n > 63) && n != 79 && n != 146 && n != 147 && n != 217;
    }
}

