#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 30 July 2009 16:01:18 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/cartoon/cartoon3_net.py,v 1.6 2009/07/31 00:54:52 vareille Exp $
#
# $Id: cartoon3_net.py,v 1.6 2009/07/31 00:54:52 vareille Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from Vision.PILNodes import imagelib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node iterate ##
    from Vision.StandardNodes import Iterate
    iterate_1 = Iterate(constrkw={}, name='iterate', library=stdlib)
    masterNet.addNode(iterate_1,9,188)
    apply(iterate_1.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Iterate named iterate in network masterNet"
    print_exc()
    iterate_1=None

try:
    ## saving node Read Image ##
    from Vision.PILNodes import ReadImage
    Read_Image_2 = ReadImage(constrkw={}, name='Read Image', library=imagelib)
    masterNet.addNode(Read_Image_2,9,241)
    apply(Read_Image_2.inputPortByName['filename'].configure, (), {'datatype': 'string', 'originalDatatype': 'str'})
    Read_Image_2.inputPortByName['filename'].rebindWidget()
    Read_Image_2.inputPortByName['filename'].widget.set(r"", run=False)
    Read_Image_2.inputPortByName['filename'].unbindWidget()
    apply(Read_Image_2.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ReadImage named Read Image in network masterNet"
    print_exc()
    Read_Image_2=None

try:
    ## saving node Scale ##
    from Vision.PILNodes import ResizeImage
    Scale_3 = ResizeImage(constrkw={}, name='Scale', library=imagelib)
    masterNet.addNode(Scale_3,111,244)
    Scale_3.inputPortByName['scale'].widget.set(1.0, run=False)
    Scale_3.inputPortByName['filter'].widget.set(r"NEAREST", run=False)
    apply(Scale_3.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ResizeImage named Scale in network masterNet"
    print_exc()
    Scale_3=None

try:
    ## saving node Show Image ##
    from Vision.PILNodes import ShowImage
    Show_Image_4 = ShowImage(constrkw={}, name='Show Image', library=imagelib)
    masterNet.addNode(Show_Image_4,16,352)
except:
    print "WARNING: failed to restore ShowImage named Show Image in network masterNet"
    print_exc()
    Show_Image_4=None

try:
    ## saving node call method ##
    from Vision.StandardNodes import CallMethod
    call_method_5 = CallMethod(constrkw={}, name='call method', library=stdlib)
    masterNet.addNode(call_method_5,8,107)
    call_method_5.inputPortByName['signature'].widget.set(r"sort", run=False)
    apply(call_method_5.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore CallMethod named call method in network masterNet"
    print_exc()
    call_method_5=None

try:
    ## saving node Entry ##
    from Vision.StandardNodes import Filelist
    Entry_6 = Filelist(constrkw={}, name='Entry', library=stdlib)
    masterNet.addNode(Entry_6,8,3)
    Entry_6.inputPortByName['directory'].widget.set(r".", run=False)
    Entry_6.inputPortByName['match_str'].widget.set(r"cartoonMovie/*.png", run=False)
    apply(Entry_6.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Filelist named Entry in network masterNet"
    print_exc()
    Entry_6=None

#masterNet.run()
masterNet.freeze()

## saving connections for network cartoon3 ##
if iterate_1 is not None and Read_Image_2 is not None:
    try:
        masterNet.connectNodes(
            iterate_1, Read_Image_2, "oneItem", "filename", blocking=True
            , splitratio=[0.31788170286986356, 0.44260090366721838])
    except:
        print "WARNING: failed to restore connection between iterate_1 and Read_Image_2 in network masterNet"
if Read_Image_2 is not None and Scale_3 is not None:
    try:
        masterNet.connectNodes(
            Read_Image_2, Scale_3, "image", "image", blocking=True
            , splitratio=[0.68702028015822869, 0.31682728633214896])
    except:
        print "WARNING: failed to restore connection between Read_Image_2 and Scale_3 in network masterNet"
if Scale_3 is not None and Show_Image_4 is not None:
    try:
        masterNet.connectNodes(
            Scale_3, Show_Image_4, "scaledImage", "image", blocking=True
            , splitratio=[0.59517673777211644, 0.62260864490666867])
    except:
        print "WARNING: failed to restore connection between Scale_3 and Show_Image_4 in network masterNet"
if call_method_5 is not None and iterate_1 is not None:
    try:
        masterNet.connectNodes(
            call_method_5, iterate_1, "objects", "listToLoopOver", blocking=True
            , splitratio=[0.22351729190876407, 0.60373121452041001])
    except:
        print "WARNING: failed to restore connection between call_method_5 and iterate_1 in network masterNet"
if Entry_6 is not None and call_method_5 is not None:
    try:
        masterNet.connectNodes(
            Entry_6, call_method_5, "filelist", "objects", blocking=True
            , splitratio=[0.34152769576085495, 0.48996380680354434])
    except:
        print "WARNING: failed to restore connection between Entry_6 and call_method_5 in network masterNet"
masterNet.runOnNewData.value = True

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 0) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        # create communication socket
        import socket
        HOST = ''                 # Symbolic name meaning the local host
        PORT = 50010              # Arbitrary non-privileged port
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.bind((HOST, PORT))
        s.listen(5)
        s.setblocking(0)
        masterNet.socket = s
        masterNet.socketConnections = []
        masterNet.HOST = HOST
        masterNet.PORT = PORT

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

