/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ptp.internal.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.internal.rdt.sync.core.SyncUtils;
import org.eclipse.ptp.internal.rdt.sync.core.messages.Messages;
import org.eclipse.ptp.internal.rdt.sync.core.services.SynchronizeServiceRegistry;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.PreferenceSyncFileFilterStorage;
import org.eclipse.ptp.rdt.sync.core.RecursiveSubMonitor;
import org.eclipse.ptp.rdt.sync.core.RemoteLocation;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.SyncEvent;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.handlers.IMissingConnectionHandler;
import org.eclipse.ptp.rdt.sync.core.handlers.ISyncExceptionHandler;
import org.eclipse.ptp.rdt.sync.core.listeners.ISyncListener;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;
import org.eclipse.ptp.rdt.sync.core.services.ISynchronizeService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteServices;
import org.osgi.service.prefs.Preferences;

public class SyncManager {
    private static final String SYNC_MODE_KEY = "sync-mode";
    private static final String SYNC_AUTO_KEY = "sync-auto";
    private static final String SHOW_ERROR_KEY = "show-error";
    public static final String SYNCHRONIZE_POLICY_EXTENSION = "synchronizePolicy";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_NATURE = "nature";
    private static ISyncExceptionHandler defaultSyncExceptionHandler = new ISyncExceptionHandler(){

        @Override
        public void handle(IProject project, CoreException e) {
            RDTSyncCorePlugin.log(String.valueOf(Messages.SyncManager_8) + project.getName(), e);
        }
    };
    private static IMissingConnectionHandler defaultMissingConnectionHandler = new IMissingConnectionHandler(){

        @Override
        public void handle(IRemoteServices remoteServices, String connectionName) {
            RDTSyncCorePlugin.log(String.valueOf(Messages.SyncManager_10) + connectionName);
        }
    };
    private static final Map<IProject, Set<ISyncListener>> fProjectToSyncListenersMap = Collections.synchronizedMap(new HashMap());
    private static final SyncMode DEFAULT_SYNC_MODE = SyncMode.UNAVAILABLE;
    private static final boolean DEFAULT_SYNC_AUTO_SETTING = true;
    private static final boolean DEFAULT_SHOW_ERROR_SETTING = true;

    public static void addPostSyncListener(IProject project, ISyncListener listener) {
        Set<ISyncListener> listenerSet = fProjectToSyncListenersMap.get(project);
        if (listenerSet == null) {
            listenerSet = new HashSet<ISyncListener>();
            fProjectToSyncListenersMap.put(project, listenerSet);
        }
        listenerSet.add(listener);
    }

    public static void makeSyncProject(IProject project, String remoteSyncConfigName, String syncServiceId, IRemoteConnection conn, String location, AbstractSyncFileFilter fileFilter) throws CoreException {
        RemoteSyncNature.addNature(project, (IProgressMonitor)new NullProgressMonitor());
        SyncConfig config = SyncConfigManager.newConfig(remoteSyncConfigName, syncServiceId, conn, location);
        SyncConfigManager.addConfig(project, config);
        SyncConfigManager.setActive(project, config);
        if (fileFilter == null) {
            fileFilter = SyncManager.getDefaultFileFilter();
        }
        ISynchronizeService syncService = SyncManager.getSyncService(syncServiceId);
        syncService.setSyncFileFilter(project, fileFilter);
        try {
            config = SyncConfigManager.getLocalConfig(syncServiceId);
            SyncConfigManager.addConfig(project, config);
        }
        catch (CoreException e) {
            RDTSyncCorePlugin.log(Messages.SyncManager_0, e);
        }
    }

    public static PreferenceSyncFileFilterStorage getDefaultFileFilter() {
        PreferenceSyncFileFilterStorage filter = new PreferenceSyncFileFilterStorage();
        if (!filter.loadFilter()) {
            filter.loadBuiltInDefaultFilter();
        }
        return filter;
    }

    public static IMissingConnectionHandler getDefaultMissingConnectionHandler() {
        return defaultMissingConnectionHandler;
    }

    public static ISyncExceptionHandler getDefaultSyncExceptionHandler() {
        return defaultSyncExceptionHandler;
    }

    public static AbstractSyncFileFilter getFileFilter(IProject project) {
        String currentSyncServiceId = SyncConfigManager.getActive(project).getSyncProviderId();
        AbstractSyncFileFilter filter = null;
        try {
            filter = SyncManager.getSyncService(currentSyncServiceId).getSyncFileFilter(project);
        }
        catch (CoreException e) {
            RDTSyncCorePlugin.log(e);
            return SyncManager.getDefaultFileFilter();
        }
        return filter;
    }

    public static boolean getShowErrors(IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_3);
            return true;
        }
        return node.getBoolean(SHOW_ERROR_KEY, true);
    }

    public static boolean getSyncAuto() {
        IScopeContext context = InstanceScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_6);
            return true;
        }
        return node.getBoolean(SYNC_AUTO_KEY, true);
    }

    public static SyncMode getSyncMode(IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_3);
            return DEFAULT_SYNC_MODE;
        }
        return SyncMode.valueOf(node.get(SYNC_MODE_KEY, DEFAULT_SYNC_MODE.name()));
    }

    public static ISynchronizeService getSyncService(String syncServiceId) {
        return SynchronizeServiceRegistry.getSynchronizeServiceDescriptor(syncServiceId).getService();
    }

    private static void notifySyncListeners(IProject project) {
        Set<ISyncListener> listenerSet = fProjectToSyncListenersMap.get(project);
        if (listenerSet == null) {
            return;
        }
        for (ISyncListener listener : listenerSet) {
            listener.handleSyncEvent(new SyncEvent());
        }
    }

    public static void removePostSyncListener(IProject project, ISyncListener listener) {
        Set<ISyncListener> listenerSet = fProjectToSyncListenersMap.get(project);
        if (listenerSet != null) {
            listenerSet.remove(listener);
        }
    }

    public static void saveFileFilter(IProject project, AbstractSyncFileFilter filter) throws CoreException {
        String currentSyncServiceId = SyncConfigManager.getActive(project).getSyncProviderId();
        SyncManager.getSyncService(currentSyncServiceId).setSyncFileFilter(project, filter);
    }

    private static Job[] scheduleSyncJobs(IResourceDelta delta, IProject project, Set<SyncFlag> syncFlags, boolean syncAll, boolean isBlocking, boolean useExceptionHandler, ISyncExceptionHandler seHandler, IProgressMonitor monitor) throws CoreException {
        int jobNum = 0;
        SyncConfig[] syncConfigs = !syncAll ? new SyncConfig[]{SyncConfigManager.getActive(project)} : SyncConfigManager.getConfigs(project);
        Job[] syncJobs = new Job[syncConfigs.length];
        SyncConfig[] syncConfigArray = syncConfigs;
        int n = syncConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            SyncConfig config = syncConfigArray[n2];
            if (!SyncConfigManager.isLocal(config)) {
                SynchronizeJob job;
                block13: {
                    job = null;
                    String currentSyncServiceId = config.getSyncProviderId();
                    ISynchronizeService syncService = SyncManager.getSyncService(currentSyncServiceId);
                    if (syncService != null) {
                        if (isBlocking) {
                            try {
                                try {
                                    RemoteLocation rl = new RemoteLocation(config.getRemoteLocation());
                                    syncService.synchronize(project, rl, delta, monitor, syncFlags);
                                }
                                catch (CoreException e) {
                                    if (!useExceptionHandler) {
                                        throw e;
                                    }
                                    if (seHandler == null) {
                                        defaultSyncExceptionHandler.handle(project, e);
                                    } else {
                                        seHandler.handle(project, e);
                                    }
                                    SyncManager.notifySyncListeners(project);
                                    break block13;
                                }
                            }
                            catch (Throwable throwable) {
                                SyncManager.notifySyncListeners(project);
                                throw throwable;
                            }
                            SyncManager.notifySyncListeners(project);
                        } else {
                            job = new SynchronizeJob(project, config, delta, syncService, syncFlags, seHandler);
                            job.schedule();
                        }
                    }
                }
                syncJobs[jobNum] = job;
                ++jobNum;
            }
            ++n2;
        }
        return syncJobs;
    }

    public static void setDefaultMissingConnectionHandler(IMissingConnectionHandler handler) {
        defaultMissingConnectionHandler = handler;
    }

    public static void setDefaultSyncExceptionHandler(ISyncExceptionHandler handler) {
        defaultSyncExceptionHandler = handler;
    }

    public static void setShowErrors(IProject project, boolean shouldBeDisplayed) {
        if (project == null) {
            throw new NullPointerException();
        }
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_3);
            return;
        }
        if (shouldBeDisplayed) {
            node.remove(SHOW_ERROR_KEY);
        } else {
            node.putBoolean(SHOW_ERROR_KEY, shouldBeDisplayed);
        }
        SyncUtils.flushNode((Preferences)node);
    }

    public static void setSyncAuto(boolean isSyncAutomatic) {
        IScopeContext context = InstanceScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_6);
            return;
        }
        if (isSyncAutomatic) {
            node.remove(SYNC_AUTO_KEY);
        } else {
            node.putBoolean(SYNC_AUTO_KEY, isSyncAutomatic);
        }
        SyncUtils.flushNode((Preferences)node);
    }

    public static void setSyncMode(IProject project, SyncMode mode) {
        if (project == null || mode == null) {
            throw new NullPointerException();
        }
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_3);
            return;
        }
        if (mode == DEFAULT_SYNC_MODE) {
            node.remove(SYNC_MODE_KEY);
        } else {
            node.put(SYNC_MODE_KEY, mode.name());
        }
        SyncUtils.flushNode((Preferences)node);
    }

    private static Job sync(IResourceDelta delta, IProject project, Set<SyncFlag> syncFlags, boolean isBlocking, boolean useExceptionHandler, ISyncExceptionHandler seHandler, IProgressMonitor monitor) throws CoreException {
        if (SyncManager.getSyncMode(project) == SyncMode.UNAVAILABLE) {
            return null;
        }
        Job[] syncJobs = SyncManager.scheduleSyncJobs(delta, project, syncFlags, false, isBlocking, useExceptionHandler, seHandler, monitor);
        return syncJobs[0];
    }

    public static Job sync(IResourceDelta delta, IProject project, Set<SyncFlag> syncFlags, ISyncExceptionHandler seHandler) throws CoreException {
        return SyncManager.sync(delta, project, syncFlags, false, true, seHandler, null);
    }

    public static Job[] syncAll(IResourceDelta delta, IProject project, Set<SyncFlag> syncFlags, ISyncExceptionHandler seHandler) throws CoreException {
        if (SyncManager.getSyncMode(project) == SyncMode.UNAVAILABLE) {
            return new Job[0];
        }
        return SyncManager.scheduleSyncJobs(delta, project, syncFlags, true, false, true, seHandler, null);
    }

    public static Job[] syncAllBlocking(IResourceDelta delta, IProject project, Set<SyncFlag> syncFlags, ISyncExceptionHandler seHandler) throws CoreException {
        if (SyncManager.getSyncMode(project) == SyncMode.UNAVAILABLE) {
            return new Job[0];
        }
        return SyncManager.scheduleSyncJobs(delta, project, syncFlags, true, true, true, seHandler, null);
    }

    public static Job syncBlocking(IResourceDelta delta, IProject project, Set<SyncFlag> syncFlags, IProgressMonitor monitor) throws CoreException {
        return SyncManager.sync(delta, project, syncFlags, true, false, null, monitor);
    }

    public static Job syncBlocking(IResourceDelta delta, IProject project, Set<SyncFlag> syncFlags, IProgressMonitor monitor, ISyncExceptionHandler seHandler) throws CoreException {
        return SyncManager.sync(delta, project, syncFlags, true, true, seHandler, monitor);
    }

    private SyncManager() {
    }

    public static enum SyncMode {
        ACTIVE,
        ALL,
        NONE,
        UNAVAILABLE;

    }

    private static class SynchronizeJob
    extends Job {
        private final IProject fProject;
        private final SyncConfig fSyncConfig;
        private final IResourceDelta fDelta;
        private final ISynchronizeService fSyncService;
        private final Set<SyncFlag> fSyncFlags;
        private final ISyncExceptionHandler fSyncExceptionHandler;

        public SynchronizeJob(IProject project, SyncConfig syncConfig, IResourceDelta delta, ISynchronizeService syncService, Set<SyncFlag> syncFlags, ISyncExceptionHandler seHandler) {
            super(Messages.SyncManager_4);
            this.fProject = project;
            this.fSyncConfig = syncConfig;
            this.fDelta = delta;
            this.fSyncService = syncService;
            this.fSyncFlags = syncFlags;
            this.fSyncExceptionHandler = seHandler;
        }

        protected IStatus run(IProgressMonitor monitor) {
            RecursiveSubMonitor subMonitor = RecursiveSubMonitor.convert(monitor);
            try {
                try {
                    RemoteLocation rl = new RemoteLocation(this.fSyncConfig.getRemoteLocation());
                    this.fSyncService.synchronize(this.fProject, rl, this.fDelta, (IProgressMonitor)subMonitor, this.fSyncFlags);
                }
                catch (CoreException e) {
                    if (this.fSyncExceptionHandler == null) {
                        defaultSyncExceptionHandler.handle(this.fProject, e);
                    } else {
                        this.fSyncExceptionHandler.handle(this.fProject, e);
                    }
                    monitor.done();
                    SyncManager.notifySyncListeners(this.fProject);
                }
            }
            finally {
                monitor.done();
                SyncManager.notifySyncListeners(this.fProject);
            }
            return Status.OK_STATUS;
        }
    }
}

