/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model;

import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaObjectsFactory;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.ICudaVisitor;
import com.nvidia.cuda.ide.debug.model.Kernel;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateInDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Block
extends AbstractDMContext
implements ICudaRuntimeObject {
    private final CudaCoord blockIdx;
    private final Kernel kernel;

    public Block(Kernel kernel, CudaCoord blockIdx) {
        super(kernel.getSessionId(), new IDMContext[]{kernel});
        this.kernel = kernel;
        this.blockIdx = blockIdx;
    }

    public CudaCoord getBlockIdx() {
        return this.blockIdx;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Block) {
            return ((Block)obj).getBlockIdx().equals(this.blockIdx) && ((Block)obj).getKernel().equals(this.kernel);
        }
        return false;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public int hashCode() {
        int baseHashCode;
        try {
            baseHashCode = this.baseHashCode();
        }
        catch (NullPointerException nullPointerException) {
            baseHashCode = 13;
        }
        return baseHashCode ^ this.blockIdx.hashCode();
    }

    public String toString() {
        return String.format("Block %s", this.blockIdx);
    }

    public boolean hasExpandedThreads() {
        return this.getApplication().hasExpandedThreads(this);
    }

    private ICudaApplication getApplication() {
        return (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)this, ICudaApplication.class);
    }

    @Override
    public void getState(DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.getApplication().getBlockState(this, rm);
    }

    public DeviceThread getThread(CudaCoord threadIdx) throws CudaException {
        return CudaObjectsFactory.getInstance().newThread(this, threadIdx);
    }

    public long getOrdinal() {
        return this.getKernel().getGridDim().getOrdinal(this.blockIdx);
    }

    @Override
    public void accept(ICudaVisitor visitor) {
        visitor.visitBlock(this);
    }

    @Override
    public ElementType getType() {
        return ElementType.block;
    }

    public void getActiveThreadCount(ViewerDataRequestMonitor<Integer> rm) {
        DsfSession session = this.getSession();
        if (session != null) {
            ImmediateInDsfExecutor executor = new ImmediateInDsfExecutor(session.getExecutor());
            executor.execute((Runnable)new DsfRunnable((Executor)executor, rm){
                private final /* synthetic */ Executor val$executor;
                private final /* synthetic */ ViewerDataRequestMonitor val$rm;
                {
                    this.val$executor = executor;
                    this.val$rm = viewerDataRequestMonitor;
                }

                public void run() {
                    ((ICudaApplication)DMContexts.getAncestorOfType((IDMContext)Block.this, ICudaApplication.class)).getActiveThreads(Block.this, false, ICoordSorter.HARDWARE, new DataRequestMonitor<IDMContext[]>(this.val$executor, (RequestMonitor)this.val$rm){

                        protected void handleSuccess() {
                            val$rm.setData((Object)((IDMContext[])this.getData()).length);
                            val$rm.done();
                        }
                    });
                }
            });
        } else {
            rm.setData((Object)0);
            rm.done();
        }
    }

    protected DsfSession getSession() {
        String sessionId = this.getSessionId();
        if (sessionId != null) {
            return DsfSession.getSession((String)sessionId);
        }
        return null;
    }

    @Override
    public void toHardwareElement(final DataRequestMonitor<ICudaRuntimeObject> drm) {
        this.getState(new DataRequestMonitor<CudaRuntimeInformation>(ImmediateExecutor.getInstance(), drm){

            protected void handleSuccess() {
                final CudaRuntimeInformation information = (CudaRuntimeInformation)this.getData();
                if (information.getState().isActive()) {
                    Block.this.getApplication().getDevices(new DataRequestMonitor<Device[]>(ImmediateExecutor.getInstance(), (RequestMonitor)drm){

                        protected void handleSuccess() {
                            try {
                                Device[] deviceArray = (Device[])this.getData();
                                int n = deviceArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Device device = deviceArray[n2];
                                    if (device.getId() == information.getDeviceId()) {
                                        drm.setData((Object)device.getSm(information.getSm()));
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            catch (CudaException e) {
                                drm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                            }
                            drm.done();
                        }
                    });
                }
            }
        });
    }

    @Override
    public void toLogicalElement(DataRequestMonitor<ICudaRuntimeObject> drm) {
        drm.setData((Object)this);
        drm.done();
    }
}

