/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel;

import com.nvidia.cuda.ide.debug.model.IFocusDMContext;
import com.nvidia.cuda.ide.debug.model.events.ElementPinnedStatusEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaThreadColumns;
import com.nvidia.cuda.ide.debug.ui.viewmodel.IDataContextProvider;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.CudaVariableVMNode;
import com.nvidia.cuda.ide.debug.util.ThreadColumnsManager;
import com.nvidia.cuda.ide.debug.util.ThreadsColumnPresentation;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.DsfCastToTypeSupport;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.GdbVariableVMProvider;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.RootDMVMNode;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public final class CudaVariableVMProvider
extends GdbVariableVMProvider
implements ICudaThreadColumns {
    public CudaVariableVMProvider(AbstractVMAdapter adapter, IPresentationContext context, DsfSession session) {
        super(adapter, context, session);
        context.setProperty("cuda_threads", (Object)this);
    }

    protected void configureLayout() {
        SyncVariableDataAccess varAccess = new SyncVariableDataAccess(this.getSession());
        RootDMVMNode rootNode = new RootDMVMNode((AbstractVMProvider)this);
        this.setRootNode((IRootVMNode)rootNode);
        CudaVariableVMNode subExpressioNode = new CudaVariableVMNode((AbstractDMVMProvider)this, this.getSession(), varAccess);
        this.addChildNodes((IVMNode)rootNode, new IVMNode[]{subExpressioNode});
        ((VariableVMNode)subExpressioNode).setCastToTypeSupport(new DsfCastToTypeSupport(this.getSession(), (AbstractDMVMProvider)this, varAccess));
        this.addChildNodes(subExpressioNode, new IVMNode[]{subExpressioNode});
    }

    public void refresh() {
        this.getColumnsManager().refresh();
        super.refresh();
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        return new ThreadsColumnPresentation(super.createColumnPresentation(context, element));
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public IFocusDMContext getColumnFocus(String columnId) {
        return this.getColumnsManager().getColumnFocus(columnId);
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        return ThreadsColumnPresentation.getId(super.getColumnPresentationId(context, element));
    }

    public void handleEvent(Object event, RequestMonitor rm) {
        if (event instanceof ElementPinnedStatusEvent || event instanceof IRunControl.IContainerSuspendedDMEvent) {
            this.getColumnsManager().refresh();
        }
        super.handleEvent(event, rm);
    }

    public void update(final IViewerInputUpdate update) {
        IDataContextProvider stackFrameProvider;
        Object element = update.getElement();
        if (element instanceof IAdaptable && (stackFrameProvider = (IDataContextProvider)((IAdaptable)element).getAdapter(IDataContextProvider.class)) != null) {
            stackFrameProvider.getDataContext(element, (DataRequestMonitor<IDMVMContext>)new ViewerDataRequestMonitor<IDMVMContext>(this.getExecutor(), (IViewerUpdate)update){

                protected void handleSuccess() {
                    CudaVariableVMProvider.this.getColumnsManager().showColumns(this.getData());
                    update.setInputElement(this.getData());
                    update.done();
                }
            });
            return;
        }
        this.getColumnsManager().showColumns(update.getElement());
        super.update(update);
    }

    private ThreadColumnsManager getColumnsManager() {
        return ThreadColumnsManager.getColumnsManager(this.getPresentationContext(), "org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME", "org.eclipse.cdt.dsf.ui.COLUMN_ID__TYPE", "org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE");
    }
}

