/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LayoutChangeEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LinkedSelectionChangedEvent;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public final class CudaAllThreadsVMNode
extends AbstractDMVMNode
implements IElementLabelProvider,
IElementPropertiesProvider {
    private static final String PROPERTY_BLOCKDIM = "blockdim";
    private static final String PROPERTY_GRIDDIM = "griddim";
    private PropertiesBasedLabelProvider labelProvider;

    private static Kernel getKernel(VMDelta parent) {
        Object element = parent.getElement();
        Object ctx = element instanceof IDMContext ? (IDMContext)element : (element instanceof IAdaptable ? (IDMContext)((IAdaptable)element).getAdapter(IDMContext.class) : null);
        if (ctx != null) {
            return (Kernel)DMContexts.getAncestorOfType((IDMContext)ctx, Kernel.class);
        }
        return null;
    }

    public CudaAllThreadsVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, AllThreadsDMContext.class);
    }

    public void buildDelta(Object event, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        Kernel kernel;
        if (this.isEnabled() && (event instanceof LinkedSelectionChangedEvent || event instanceof LayoutChangeEvent) && (kernel = CudaAllThreadsVMNode.getKernel(parent)) != null) {
            AllThreadsDMContext allThreads = new AllThreadsDMContext(DsfSession.getSession((String)kernel.getSessionId()), kernel);
            parent.addNode((Object)this.createVMContext((IDMContext)allThreads), nodeOffset, this.getAllThreadsNodeFlags(event, kernel));
        }
        requestMonitor.done();
    }

    private LabelColumnInfo createColumnInfo() {
        return new LabelColumnInfo(new LabelAttribute[]{new LabelText("All Kernel Threads ({0} {0,choice,1#Block|1<Blocks} of {1} {1,choice,1#Thread|1<Threads})", new String[]{PROPERTY_GRIDDIM, PROPERTY_BLOCKDIM}), new LabelImage(CudaDebugImages.ALL_THREADS.getDescriptor())});
    }

    private int getAllThreadsNodeFlags(Object event, Kernel kernel) {
        DeviceThread thread;
        IDMContext context = ((IDMEvent)event).getDMContext();
        if (context != null && DMContexts.isAncestorOf((IDMContext)context, (IDMContext)kernel) && ((thread = (DeviceThread)DMContexts.getAncestorOfType((IDMContext)context, DeviceThread.class)) == null || !DebugUtil.isPinnedOrRemembered(thread))) {
            return 0x100000;
        }
        return event instanceof LinkedSelectionChangedEvent ? 0 : 0x2000000;
    }

    public int getDeltaFlags(Object event) {
        if (this.isEnabled() && (event instanceof LinkedSelectionChangedEvent || event instanceof LayoutChangeEvent)) {
            return 0x2100000;
        }
        return 0;
    }

    private Kernel getKernelFromUpdate(IViewerUpdate update) {
        return (Kernel)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), Kernel.class);
    }

    private synchronized IElementLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new PropertiesBasedLabelProvider();
            this.labelProvider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME", this.createColumnInfo());
            this.labelProvider.setColumnInfo("ID_COLUMN_NO_COLUMNS", this.createColumnInfo());
        }
        return this.labelProvider;
    }

    private boolean isEnabled() {
        String mode = Activator.getDefault().getPreferenceStore().getString("debug.view.cuda.layout");
        return "debug_view_tree".equals(mode);
    }

    protected final void isKernelActive(IViewerUpdate update, DataRequestMonitor<Integer> drm) {
        Kernel kernel = this.getKernelFromUpdate(update);
        if (kernel == null) {
            drm.setData((Object)0);
            drm.done();
        } else {
            kernel.getActiveBlocksCount(drm);
        }
    }

    public void update(IChildrenCountUpdate[] updates) {
        IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
            if (this.isEnabled()) {
                ViewerDataRequestMonitor<Integer> drm = new ViewerDataRequestMonitor<Integer>(this.getExecutor(), (IViewerUpdate)update){

                    @ConfinedToDsfExecutor(value="fExecutor")
                    protected void handleCompleted() {
                        if (this.getData() == null || Integer.valueOf(0).equals(this.getData())) {
                            update.setChildCount(0);
                        } else {
                            update.setChildCount(1);
                        }
                        update.done();
                    }
                };
                this.isKernelActive((IViewerUpdate)update, (DataRequestMonitor<Integer>)drm);
            } else {
                update.setChildCount(0);
                update.done();
            }
            ++n2;
        }
    }

    public void update(IChildrenUpdate[] updates) {
        IChildrenUpdate[] iChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IChildrenUpdate update = iChildrenUpdateArray[n2];
            if (this.isEnabled()) {
                this.isKernelActive((IViewerUpdate)update, (DataRequestMonitor<Integer>)new ViewerDataRequestMonitor<Integer>(this.getExecutor(), (IViewerUpdate)update){

                    @ConfinedToDsfExecutor(value="fExecutor")
                    protected void handleCompleted() {
                        if (this.getData() != null && !Integer.valueOf(0).equals(this.getData())) {
                            CudaAllThreadsVMNode.this.fillUpdateWithVMCs(update, new IDMContext[]{new AllThreadsDMContext(CudaAllThreadsVMNode.this.getSession(), CudaAllThreadsVMNode.this.getKernelFromUpdate((IViewerUpdate)update))});
                        }
                        update.done();
                    }
                });
            } else {
                update.done();
            }
            ++n2;
        }
    }

    public void update(IHasChildrenUpdate[] updates) {
        IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
            if (this.isEnabled()) {
                this.isKernelActive((IViewerUpdate)update, (DataRequestMonitor<Integer>)new ViewerDataRequestMonitor<Integer>(this.getExecutor(), (IViewerUpdate)update){

                    @ConfinedToDsfExecutor(value="fExecutor")
                    protected void handleCompleted() {
                        update.setHasChilren(this.getData() != null && !Integer.valueOf(0).equals(this.getData()));
                        update.done();
                    }
                });
            } else {
                update.setHasChilren(false);
                update.done();
            }
            ++n2;
        }
    }

    public void update(ILabelUpdate[] updates) {
        IElementLabelProvider provider = this.getLabelProvider();
        provider.update(updates);
    }

    public void update(IPropertiesUpdate[] updates) {
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            Kernel kernel = this.getKernelFromUpdate((IViewerUpdate)update);
            if (kernel != null) {
                update.setProperty(PROPERTY_BLOCKDIM, (Object)kernel.getBlockDim().elementCount());
                update.setProperty(PROPERTY_GRIDDIM, (Object)kernel.getGridDim().elementCount());
            }
            update.done();
            ++n2;
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updateElementsInSessionThread(IChildrenUpdate update) {
    }

    private static class AllThreadsDMContext
    extends AbstractDMContext {
        public AllThreadsDMContext(DsfSession session, Kernel kernel) {
            super(session, new IDMContext[]{kernel});
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj);
        }

        public int hashCode() {
            return this.baseHashCode() * 31;
        }
    }
}

