/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.ui;

import com.nvidia.common.device.ICudaDevice;
import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.core.Messages;
import com.nvidia.cuda.ide.build.project.AbstractMultiModule;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.project.ICudaProjectConfiguration;
import com.nvidia.cuda.ide.build.project.MultiConfiguration;
import com.nvidia.cuda.ide.build.project.MultiCubin;
import com.nvidia.cuda.ide.build.project.MultiExecutable;
import com.nvidia.cuda.ide.build.ui.AddModuleToAllConfigs;
import com.nvidia.cuda.ide.build.ui.CudaCFileSelectionDialog;
import com.nvidia.cuda.ide.build.ui.FindKernelsVisitor;
import com.nvidia.cuda.ide.build.ui.ModuleEditorPane;
import com.nvidia.cuda.ide.build.ui.ProjectExecutableEditorPane;
import com.nvidia.cuda.ide.devices.CudaDevice;
import com.nvidia.cuda.ide.util.UiUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public final class MultiModuleView
extends Composite
implements ICudaProjectConfiguration.IModuleListener {
    private final MultiConfiguration configuration;
    private ToolItem deleteButton;
    private final StackLayout detailsLayout;
    private final IExecutableFileList executableFileList;
    private final ModuleEditorPane moduleDetails;
    private TableViewer modules;
    private final AddModuleToAllConfigs moduleInOneConfig;
    private final AtomicBoolean refreshing = new AtomicBoolean(false);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void findCompatibleDevices(CLabel clabel, AbstractMultiModule module, ICudaModule.Type type) {
        clabel.setImage(null);
        clabel.setText("");
        int phys = module.getPhysicalArchitecturesForAllConfigurations();
        int virt = module.getVirtualArchitecturesForAllConfigurations();
        if (phys == 0 && virt == 0) {
            if (module.getPhysicalArchitecturesForSomeConfigurations() != 0 || module.getVirtualArchitecturesForSomeConfigurations() != 0) return;
            String text = module.isDeviceLinking() != false ? "SASS 2.0 will be generated by default" : Messages.CudaProjectSetupWizardPage_info_default_versions;
            MultiModuleView.setWarningOrInfo(clabel, false, text);
            return;
        } else {
            IStatus result = UiUtil.validateCompatibility(type, phys, virt, Boolean.TRUE.equals(module.isDeviceLinking()));
            if (result.getSeverity() == 0) return;
            MultiModuleView.setWarningOrInfo(clabel, result.getSeverity() == 2, result.getMessage());
        }
    }

    private static void setWarningOrInfo(CLabel clabel, boolean warn, String label) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        Object image = warn ? sharedImages.getImage("IMG_OBJS_WARN_TSK") : (label.length() > 0 ? sharedImages.getImage("IMG_OBJS_INFO_TSK") : null);
        clabel.setText(label);
        clabel.setImage(image);
    }

    public static IFile getNewModuleSourceFile(MultiConfiguration configuration, IFile file) {
        CudaCFileSelectionDialog dialog = new CudaCFileSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), false, (IContainer)configuration.getProject(), 1);
        dialog.setInitialPattern("*.cu");
        dialog.setTitle("Select source file");
        if (file != null) {
            dialog.setInitialElementSelections(Collections.singletonList(file));
        }
        if (dialog.open() == 0) {
            return (IFile)dialog.getFirstResult();
        }
        return null;
    }

    public MultiModuleView(Composite parent, int style, MultiConfiguration projectConfiguration) {
        super(parent, style);
        this.configuration = projectConfiguration;
        this.configuration.addModuleListener(this);
        this.executableFileList = new ProjectExecutableEditorPane(projectConfiguration);
        SashForm sashForm = new SashForm((Composite)this, 0);
        StackLayout layout = new StackLayout();
        this.createModulesList(sashForm);
        Composite details = new Composite((Composite)sashForm, 0);
        this.detailsLayout = new StackLayout();
        details.setLayout((Layout)this.detailsLayout);
        this.moduleDetails = new ModuleEditorPane(details);
        this.moduleInOneConfig = new AddModuleToAllConfigs(details);
        this.executableFileList.createControl(details);
        layout.topControl = sashForm;
        this.setLayout((Layout)layout);
        this.modules.setContentProvider((IContentProvider)new ListProvider());
        this.modules.setLabelProvider((IBaseLabelProvider)new ModuleListLabelProvider());
        this.modules.setInput((Object)this.configuration);
        this.modules.setSelection((ISelection)new StructuredSelection((Object)this.configuration.getExecutable()));
        this.selectModule();
        sashForm.setWeights(new int[]{1, 2});
    }

    protected void addModule() {
        IFile file = MultiModuleView.getNewModuleSourceFile(this.configuration, null);
        if (file != null) {
            String potentialName = this.generateDefaultName(file.getFullPath().removeFileExtension().lastSegment());
            IPath moduleName = new Path(potentialName).addFileExtension("fatbin");
            Architecture arch = this.getDefaultArch();
            MultiCubin module = this.configuration.newModule(moduleName);
            module.setType(ICudaModule.Type.fatbin);
            module.enableArchitecture(arch, true);
            module.enableArchitecture(arch.getVirtual(), false);
            try {
                module.include(file);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "com.nvidia.cuda.ide.build", "Unable to add a module", (Throwable)e), 3);
            }
            this.modules.refresh();
            this.modules.setSelection((ISelection)new StructuredSelection((Object)module));
        }
    }

    protected void checkSubclass() {
    }

    @Override
    public void configurationReloaded() {
        ISelection selection = this.modules.getSelection();
        this.modules.refresh();
        this.modules.setSelection(selection);
        if (this.modules.getSelection().isEmpty()) {
            this.modules.setSelection((ISelection)new StructuredSelection((Object)this.configuration.getExecutable()));
        }
        this.selectModule();
    }

    private void createModulesList(SashForm sashForm) {
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginHeight = 0;
        gl_composite.verticalSpacing = 0;
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginWidth = 0;
        composite.setLayout((Layout)gl_composite);
        Composite composite_3 = new Composite(composite, 2048);
        composite_3.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_composite_3 = new GridLayout(2, false);
        gl_composite_3.verticalSpacing = 0;
        gl_composite_3.marginHeight = 0;
        composite_3.setLayout((Layout)gl_composite_3);
        Label lblNewLabel = new Label(composite_3, 0);
        lblNewLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblNewLabel.setText("Modules");
        ToolBar toolBar = new ToolBar(composite_3, 0x820000);
        toolBar.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ToolItem add = new ToolItem(toolBar, 0);
        add.setToolTipText("Add module");
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiModuleView.this.addModule();
            }
        });
        add.setImage(sharedImages.getImage("IMG_OBJ_ADD"));
        this.deleteButton = new ToolItem(toolBar, 0);
        this.deleteButton.setToolTipText("Delete module");
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MultiModuleView.this.removeModule();
                }
                catch (CoreException e1) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "com.nvidia.cuda.ide.build", "Cannot remove module", (Throwable)e1));
                }
            }
        });
        this.deleteButton.setImage(sharedImages.getImage("IMG_TOOL_DELETE"));
        this.modules = new TableViewer(composite, 67584);
        this.modules.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!MultiModuleView.this.refreshing.get()) {
                    MultiModuleView.this.selectModule();
                }
            }
        });
        Table modulesTable = this.modules.getTable();
        modulesTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    private String generateDefaultName(String baseName) {
        String potentialName = baseName;
        int n = 1;
        boolean unique = false;
        block0: while (!unique) {
            unique = true;
            MultiCubin[] multiCubinArray = this.configuration.getModules();
            int n2 = multiCubinArray.length;
            int n3 = 0;
            while (n3 < n2) {
                MultiCubin module = multiCubinArray[n3];
                if (module.getPath().removeFileExtension().toString().equals(potentialName)) {
                    unique = false;
                    potentialName = String.format("%s_%d", baseName, n++);
                    continue block0;
                }
                ++n3;
            }
        }
        return potentialName;
    }

    private Architecture getDefaultArch() {
        Architecture[] arch = Architecture.all();
        ICudaDevice[] devices = CudaDevice.getDevices((boolean)true, null);
        if (devices.length > 0) {
            ICudaDevice device = devices[0];
            int i = arch.length - 1;
            while (i >= 0) {
                Architecture architecture = arch[i];
                if (architecture.compatible(device.getVersionMajor(), device.getVersionMinor(), true)) {
                    return architecture;
                }
                --i;
            }
        }
        return arch[0];
    }

    private AbstractMultiModule getModule() {
        ISelection sel = this.modules.getSelection();
        if (!sel.isEmpty()) {
            return (AbstractMultiModule)((IStructuredSelection)sel).getFirstElement();
        }
        return null;
    }

    public boolean hasModules() {
        return this.configuration.getModules().length != 0;
    }

    private int indexOf(AbstractMultiModule module) {
        MultiCubin[] allModules = this.configuration.getModules();
        int i = 0;
        while (i < allModules.length) {
            MultiCubin m2 = allModules[i];
            if (m2.equals(module)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public void moduleAdded() {
    }

    @Override
    public void modulePropertyChanged() {
        if (this.refreshing.compareAndSet(false, true)) {
            try {
                if (!this.modules.getControl().isDisposed()) {
                    this.modules.refresh();
                    AbstractMultiModule module = this.getModule();
                    if (module instanceof MultiCubin) {
                        this.moduleDetails.setModule((MultiCubin)module);
                    }
                }
            }
            finally {
                this.refreshing.set(false);
            }
        }
    }

    @Override
    public void moduleRemoved() {
    }

    public void performDefaults() {
        try {
            this.configuration.resetToDefault();
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        this.executableFileList.performDefaults();
    }

    protected Architecture[] removeArch(Architecture[] archs, Architecture architecture) {
        LinkedList<Architecture> arch = new LinkedList<Architecture>(Arrays.asList(archs));
        if (arch.contains(architecture)) {
            arch.remove(architecture);
            return arch.toArray(new Architecture[arch.size()]);
        }
        return archs;
    }

    protected void removeModule() throws CoreException {
        AbstractMultiModule module;
        IStructuredSelection selection = (IStructuredSelection)this.modules.getSelection();
        if (!selection.isEmpty() && (module = (AbstractMultiModule)selection.getFirstElement()) instanceof MultiCubin) {
            int i = this.indexOf(module);
            ((MultiCubin)module).remove();
            MultiCubin[] allModules = this.configuration.getModules();
            StructuredSelection newSelection = allModules.length > i ? new StructuredSelection((Object)allModules[i]) : (allModules.length > 0 ? new StructuredSelection((Object)allModules[allModules.length - 1]) : new StructuredSelection((Object)this.configuration.getExecutable()));
            this.modules.setSelection((ISelection)newSelection);
            this.modules.refresh();
        }
    }

    protected void selectModule() {
        Object control;
        AbstractMultiModule selection = this.getModule();
        this.deleteButton.setEnabled(selection instanceof MultiCubin);
        if (selection instanceof MultiExecutable) {
            control = this.executableFileList.getControl();
        } else if (selection instanceof MultiCubin && !((MultiCubin)selection).isInAllConfigurations()) {
            control = this.moduleInOneConfig;
            this.moduleInOneConfig.setModule((MultiCubin)selection);
        } else {
            control = this.moduleDetails;
            this.moduleDetails.setModule((MultiCubin)selection);
        }
        this.detailsLayout.topControl = control;
        control.getParent().layout(true);
    }

    public static interface IExecutableFileList {
        public void createControl(Composite var1);

        public Control getControl();

        public void performDefaults();
    }

    public static final class KernelsListProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IFile) {
                ICElement element = CoreModel.getDefault().create((IFile)inputElement);
                try {
                    if (element != null) {
                        FindKernelsVisitor visitor = new FindKernelsVisitor();
                        element.accept((ICElementVisitor)visitor);
                        return visitor.getKernels().toArray();
                    }
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                }
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ListProvider
    implements IStructuredContentProvider {
        private ListProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            MultiCubin[] driverApi = ((MultiConfiguration)inputElement).getModules();
            Object[] modules = new AbstractMultiModule[driverApi.length + 1];
            modules[0] = ((MultiConfiguration)inputElement).getExecutable();
            System.arraycopy(driverApi, 0, modules, 1, driverApi.length);
            return modules;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ModuleListLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ModuleListLabelProvider() {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof MultiCubin && !((MultiCubin)element).isInAllConfigurations()) {
                return MultiModuleView.this.modules.getControl().getDisplay().getSystemColor(33);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof MultiCubin) {
                return ((MultiCubin)element).getPath().toString();
            }
            if (element instanceof MultiExecutable) {
                return "Application Executable";
            }
            return String.format("? %s ?", element.getClass());
        }
    }
}

