/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.util.AbstractEntryStorage;
import org.eclipse.cdt.core.settings.model.util.EntryStorageBasedLanguageData;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;
import org.eclipse.cdt.core.settings.model.util.UserAndDiscoveredEntryStorage;

public abstract class UserAndDiscoveredEntryLanguageData
extends EntryStorageBasedLanguageData {
    private KindBasedStore<Set<String>> fDisabledNameSetStore;

    public UserAndDiscoveredEntryLanguageData() {
    }

    public UserAndDiscoveredEntryLanguageData(String id, CLanguageData base) {
        super(id, base);
    }

    @Override
    protected void copySettingsFrom(CLanguageData data) {
        super.copySettingsFrom(data);
        if (data instanceof UserAndDiscoveredEntryLanguageData) {
            UserAndDiscoveredEntryLanguageData lData = (UserAndDiscoveredEntryLanguageData)data;
            if (lData.fDisabledNameSetStore != null) {
                KindBasedStore clone;
                this.fDisabledNameSetStore = clone = (KindBasedStore)lData.fDisabledNameSetStore.clone();
                int[] kinds = KindBasedStore.getLanguageEntryKinds();
                int i = 0;
                while (i < kinds.length) {
                    int kind = kinds[i];
                    Set<String> set = this.fDisabledNameSetStore.get(kind);
                    if (set != null) {
                        set = new HashSet<String>(set);
                        this.fDisabledNameSetStore.put(kind, set);
                    }
                    ++i;
                }
            }
        }
    }

    public UserAndDiscoveredEntryLanguageData(String id, String languageId, String[] ids, boolean isContentTypes) {
        super(id, languageId, ids, isContentTypes);
    }

    @Override
    protected AbstractEntryStorage getStorage(int kind) {
        return new UserAndDiscoveredEntryLanguageDataEntryStorage(kind, this);
    }

    protected ICLanguageSettingEntry[] getDiscoveredEntries(int kind, Set<String> disabledNameSet) {
        ICLanguageSettingEntry[] entries = this.getAllDiscoveredEntries(kind);
        Set<String> set = this.getDisabledSet(kind);
        if (set != null && set.size() != 0) {
            disabledNameSet.addAll(set);
        }
        return entries;
    }

    protected void removeInexistent(ICLanguageSettingEntry[] entries, Set<String> set) {
        HashSet<String> copy = new HashSet<String>(set);
        int i = 0;
        while (i < entries.length) {
            copy.remove(entries[i].getName());
            ++i;
        }
        if (copy.size() != 0) {
            set.removeAll(copy);
        }
    }

    protected ICLanguageSettingEntry[] getUserEntries(int kind) {
        return this.getEntriesFromStore(kind);
    }

    protected void setDisabledDiscoveredNames(int kind, Set<String> disabledNameSet) {
        this.setDisabledSet(kind, (Set<String>)(disabledNameSet != null ? new HashSet<String>(disabledNameSet) : null));
    }

    protected Set<String> getDisabledSet(int kind) {
        if (this.fDisabledNameSetStore != null) {
            return this.fDisabledNameSetStore.get(kind);
        }
        return null;
    }

    protected void setDisabledSet(int kind, Set<String> set) {
        if (set == null || set.size() == 0) {
            if (this.fDisabledNameSetStore != null) {
                this.fDisabledNameSetStore.put(kind, null);
            }
        } else {
            if (this.fDisabledNameSetStore == null) {
                this.fDisabledNameSetStore = new KindBasedStore();
            }
            this.fDisabledNameSetStore.put(kind, set);
        }
    }

    protected abstract ICLanguageSettingEntry[] getAllDiscoveredEntries(int var1);

    protected void setUserEntries(int kind, ICLanguageSettingEntry[] entries) {
        this.setEntriesToStore(kind, entries);
    }

    protected boolean canDisableDiscoveredEntries(int kind) {
        return true;
    }

    @Override
    protected ICLanguageSettingEntry[] getEntriesToCopy(int kind, CLanguageData data) {
        return ((UserAndDiscoveredEntryLanguageData)data).getEntriesFromStore(kind);
    }

    public static class UserAndDiscoveredEntryLanguageDataEntryStorage
    extends UserAndDiscoveredEntryStorage {
        private UserAndDiscoveredEntryLanguageData fLangData;

        public UserAndDiscoveredEntryLanguageDataEntryStorage(int kind, UserAndDiscoveredEntryLanguageData lData) {
            super(kind);
            this.fLangData = lData;
        }

        @Override
        protected ICLanguageSettingEntry[] getDiscoveredEntries(Set<String> disabledNameSet) {
            return this.fLangData.getDiscoveredEntries(this.getKind(), disabledNameSet);
        }

        @Override
        protected ICLanguageSettingEntry[] getUserEntries() {
            return this.fLangData.getUserEntries(this.getKind());
        }

        @Override
        protected void setDisabledDiscoveredNames(Set<String> disabledNameSet) {
            this.fLangData.setDisabledDiscoveredNames(this.getKind(), disabledNameSet);
        }

        @Override
        protected void setUserEntries(ICLanguageSettingEntry[] entries) {
            this.fLangData.setUserEntries(this.getKind(), entries);
        }

        @Override
        protected boolean canDisableDiscoveredEntries() {
            return this.fLangData.canDisableDiscoveredEntries(this.getKind());
        }
    }
}

