#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_AssociatedPowerManagementService.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_AssociatedPowerManagementService provider module";
Name = "PowerManagement_OpenDRIM_AssociatedPowerManagementServiceModule";
Location = "cmpiPowerManagement_OpenDRIM_AssociatedPowerManagementServiceProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_AssociatedPowerManagementService provider";
Name = "PowerManagement_OpenDRIM_AssociatedPowerManagementServiceProvider";
ProviderModuleName = "PowerManagement_OpenDRIM_AssociatedPowerManagementServiceModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_AssociatedPowerManagementService provider capabilities";
ProviderModuleName = "PowerManagement_OpenDRIM_AssociatedPowerManagementServiceModule";
ProviderName = "PowerManagement_OpenDRIM_AssociatedPowerManagementServiceProvider";
ClassName = "OpenDRIM_AssociatedPowerManagementService";
ProviderType = {2, 3};
Namespaces = {"$1"};
SupportedProperties = {"ServiceProvided", "UserOfService", "PowerState", "OtherPowerState", "RequestedPowerState", "OtherRequestedPowerState", "PowerOnTime"};
CapabilityID = "PowerManagement_OpenDRIM_AssociatedPowerManagementService";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_AssociatedPowerManagementService.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_AssociatedPowerManagementService]   
   provider: PowerManagement_OpenDRIM_AssociatedPowerManagementServiceProvider
   location: cmpiPowerManagement_OpenDRIM_AssociatedPowerManagementServiceProvider
   type: instance association
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_AssociatedPowerManagementService.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_AssociatedPowerManagementService-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_AssociatedPowerManagementService.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
