/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_ORDEREDSOFTWAREINVENTORYCOMPONENT_H_
#define OPENDRIM_ORDEREDSOFTWAREINVENTORYCOMPONENT_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
*/

const static char* OpenDRIM_OrderedSoftwareInventoryComponent_classnames[] = {"OpenDRIM_OrderedSoftwareInventoryComponent"};
static string OpenDRIM_OrderedSoftwareInventoryComponent_NAMESPACE = _NAMESPACE;
const static string PartComponent_role = "PartComponent";
const static char* PartComponent_classnames[] = {"OpenDRIM_SoftwareIdentity"};
const static string PartComponent_NAMESPACE = _NAMESPACE;

const static string GroupComponent_role = "GroupComponent";
const static char* GroupComponent_classnames[] = {"OpenDRIM_SoftwareIdentity"};
const static string GroupComponent_NAMESPACE = _NAMESPACE;

class OpenDRIM_OrderedSoftwareInventoryComponent {

public:
	
	Objectpath GroupComponent;
	bool GroupComponent_isNULL;
	
	Objectpath PartComponent;
	bool PartComponent_isNULL;
	
	unsigned long long AssignedSequence;
	bool AssignedSequence_isNULL;
	
	OpenDRIM_OrderedSoftwareInventoryComponent() {
		GroupComponent_isNULL = true;
		PartComponent_isNULL = true;
		AssignedSequence_isNULL = true;
	}
	
	~OpenDRIM_OrderedSoftwareInventoryComponent() {}
	
	string getKeys() const {
		return CF_toLowCase(".GroupComponent=\"" + CF_quoteString(GroupComponent.toString()) + "\""".PartComponent=\"" + CF_quoteString(PartComponent.toString()) + "\"");
	}

	int getGroupComponent(Objectpath& value) const {
		if (GroupComponent_isNULL==true)
			return NOT_FOUND;
		value = GroupComponent;
		return OK;
	}
	
	int setGroupComponent(const Objectpath& newValue) {
		GroupComponent = newValue;
		GroupComponent.setNamespace(GroupComponent_NAMESPACE);
		GroupComponent_isNULL = false;
		return OK;
	}

	int getPartComponent(Objectpath& value) const {
		if (PartComponent_isNULL==true)
			return NOT_FOUND;
		value = PartComponent;
		return OK;
	}
	
	int setPartComponent(const Objectpath& newValue) {
		PartComponent = newValue;
		PartComponent.setNamespace(PartComponent_NAMESPACE);
		PartComponent_isNULL = false;
		return OK;
	}

	int getAssignedSequence(unsigned long long& value) const {
		if (AssignedSequence_isNULL==true)
			return NOT_FOUND;
		value = AssignedSequence;
		return OK;
	}
	
	int setAssignedSequence(const unsigned long long& newValue) {
		AssignedSequence = newValue;
		AssignedSequence_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_ORDEREDSOFTWAREINVENTORYCOMPONENT_H_*/
