/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_SoftwareIdentity.h"

CMPIObjectPath* SoftwareInventory_OpenDRIM_SoftwareIdentity_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_SoftwareIdentity& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_SoftwareIdentity_classnames[0], OpenDRIM_SoftwareIdentity_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* SoftwareInventory_OpenDRIM_SoftwareIdentity_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_SoftwareIdentity& instance) {
	_E_;
	Objectpath op(broker, SoftwareInventory_OpenDRIM_SoftwareIdentity_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.InstallDate_isNULL)
		ci.setPropertyDatetime("InstallDate", instance.InstallDate);

	if (!instance.Name_isNULL)
		ci.setProperty("Name", instance.Name);

	if (!instance.OperationalStatus_isNULL)
		ci.setProperty("OperationalStatus", instance.OperationalStatus);

	if (!instance.StatusDescriptions_isNULL)
		ci.setProperty("StatusDescriptions", instance.StatusDescriptions);

	if (!instance.Status_isNULL)
		ci.setProperty("Status", instance.Status);

	if (!instance.HealthState_isNULL)
		ci.setProperty("HealthState", instance.HealthState);

	if (!instance.PrimaryStatus_isNULL)
		ci.setProperty("PrimaryStatus", instance.PrimaryStatus);

	if (!instance.DetailedStatus_isNULL)
		ci.setProperty("DetailedStatus", instance.DetailedStatus);

	if (!instance.OperatingStatus_isNULL)
		ci.setProperty("OperatingStatus", instance.OperatingStatus);

	if (!instance.CommunicationStatus_isNULL)
		ci.setProperty("CommunicationStatus", instance.CommunicationStatus);

	if (!instance.MajorVersion_isNULL)
		ci.setProperty("MajorVersion", instance.MajorVersion);

	if (!instance.MinorVersion_isNULL)
		ci.setProperty("MinorVersion", instance.MinorVersion);

	if (!instance.RevisionNumber_isNULL)
		ci.setProperty("RevisionNumber", instance.RevisionNumber);

	if (!instance.BuildNumber_isNULL)
		ci.setProperty("BuildNumber", instance.BuildNumber);

	if (!instance.VersionString_isNULL)
		ci.setProperty("VersionString", instance.VersionString);

	if (!instance.TargetOperatingSystems_isNULL)
		ci.setProperty("TargetOperatingSystems", instance.TargetOperatingSystems);

	if (!instance.Manufacturer_isNULL)
		ci.setProperty("Manufacturer", instance.Manufacturer);

	if (!instance.Languages_isNULL)
		ci.setProperty("Languages", instance.Languages);

	if (!instance.Classifications_isNULL)
		ci.setProperty("Classifications", instance.Classifications);

	if (!instance.ClassificationDescriptions_isNULL)
		ci.setProperty("ClassificationDescriptions", instance.ClassificationDescriptions);

	if (!instance.SerialNumber_isNULL)
		ci.setProperty("SerialNumber", instance.SerialNumber);

	if (!instance.TargetTypes_isNULL)
		ci.setProperty("TargetTypes", instance.TargetTypes);

	if (!instance.IdentityInfoValue_isNULL)
		ci.setProperty("IdentityInfoValue", instance.IdentityInfoValue);

	if (!instance.IdentityInfoType_isNULL)
		ci.setProperty("IdentityInfoType", instance.IdentityInfoType);

	if (!instance.ReleaseDate_isNULL)
		ci.setPropertyDatetime("ReleaseDate", instance.ReleaseDate);

	if (!instance.IsEntity_isNULL)
		ci.setProperty("IsEntity", instance.IsEntity);

	if (!instance.ExtendedResourceType_isNULL)
		ci.setProperty("ExtendedResourceType", instance.ExtendedResourceType);

	if (!instance.OtherExtendedResourceTypeDescription_isNULL)
		ci.setProperty("OtherExtendedResourceTypeDescription", instance.OtherExtendedResourceTypeDescription);

	if (!instance.MinExtendedResourceTypeMajorVersion_isNULL)
		ci.setProperty("MinExtendedResourceTypeMajorVersion", instance.MinExtendedResourceTypeMajorVersion);

	if (!instance.MinExtendedResourceTypeMinorVersion_isNULL)
		ci.setProperty("MinExtendedResourceTypeMinorVersion", instance.MinExtendedResourceTypeMinorVersion);

	if (!instance.MinExtendedResourceTypeRevisionNumber_isNULL)
		ci.setProperty("MinExtendedResourceTypeRevisionNumber", instance.MinExtendedResourceTypeRevisionNumber);

	if (!instance.MinExtendedResourceTypeBuildNumber_isNULL)
		ci.setProperty("MinExtendedResourceTypeBuildNumber", instance.MinExtendedResourceTypeBuildNumber);

	if (!instance.TargetOSTypes_isNULL)
		ci.setProperty("TargetOSTypes", instance.TargetOSTypes);

	_L_;
	return ci.getHdl();
}

void SoftwareInventory_OpenDRIM_SoftwareIdentity_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_SoftwareIdentity& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void SoftwareInventory_OpenDRIM_SoftwareIdentity_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_SoftwareIdentity& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getPropertyDatetime("InstallDate", instance.InstallDate) == OK)
		instance.InstallDate_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("OperationalStatus", instance.OperationalStatus) == OK)
		instance.OperationalStatus_isNULL = false;

	if (inst.getProperty("StatusDescriptions", instance.StatusDescriptions) == OK)
		instance.StatusDescriptions_isNULL = false;

	if (inst.getProperty("Status", instance.Status) == OK)
		instance.Status_isNULL = false;

	if (inst.getProperty("HealthState", instance.HealthState) == OK)
		instance.HealthState_isNULL = false;

	if (inst.getProperty("PrimaryStatus", instance.PrimaryStatus) == OK)
		instance.PrimaryStatus_isNULL = false;

	if (inst.getProperty("DetailedStatus", instance.DetailedStatus) == OK)
		instance.DetailedStatus_isNULL = false;

	if (inst.getProperty("OperatingStatus", instance.OperatingStatus) == OK)
		instance.OperatingStatus_isNULL = false;

	if (inst.getProperty("CommunicationStatus", instance.CommunicationStatus) == OK)
		instance.CommunicationStatus_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("MajorVersion", instance.MajorVersion) == OK)
		instance.MajorVersion_isNULL = false;

	if (inst.getProperty("MinorVersion", instance.MinorVersion) == OK)
		instance.MinorVersion_isNULL = false;

	if (inst.getProperty("RevisionNumber", instance.RevisionNumber) == OK)
		instance.RevisionNumber_isNULL = false;

	if (inst.getProperty("BuildNumber", instance.BuildNumber) == OK)
		instance.BuildNumber_isNULL = false;

	if (inst.getProperty("VersionString", instance.VersionString) == OK)
		instance.VersionString_isNULL = false;

	if (inst.getProperty("TargetOperatingSystems", instance.TargetOperatingSystems) == OK)
		instance.TargetOperatingSystems_isNULL = false;

	if (inst.getProperty("Manufacturer", instance.Manufacturer) == OK)
		instance.Manufacturer_isNULL = false;

	if (inst.getProperty("Languages", instance.Languages) == OK)
		instance.Languages_isNULL = false;

	if (inst.getProperty("Classifications", instance.Classifications) == OK)
		instance.Classifications_isNULL = false;

	if (inst.getProperty("ClassificationDescriptions", instance.ClassificationDescriptions) == OK)
		instance.ClassificationDescriptions_isNULL = false;

	if (inst.getProperty("SerialNumber", instance.SerialNumber) == OK)
		instance.SerialNumber_isNULL = false;

	if (inst.getProperty("TargetTypes", instance.TargetTypes) == OK)
		instance.TargetTypes_isNULL = false;

	if (inst.getProperty("IdentityInfoValue", instance.IdentityInfoValue) == OK)
		instance.IdentityInfoValue_isNULL = false;

	if (inst.getProperty("IdentityInfoType", instance.IdentityInfoType) == OK)
		instance.IdentityInfoType_isNULL = false;

	if (inst.getPropertyDatetime("ReleaseDate", instance.ReleaseDate) == OK)
		instance.ReleaseDate_isNULL = false;

	if (inst.getProperty("IsEntity", instance.IsEntity) == OK)
		instance.IsEntity_isNULL = false;

	if (inst.getProperty("ExtendedResourceType", instance.ExtendedResourceType) == OK)
		instance.ExtendedResourceType_isNULL = false;

	if (inst.getProperty("OtherExtendedResourceTypeDescription", instance.OtherExtendedResourceTypeDescription) == OK)
		instance.OtherExtendedResourceTypeDescription_isNULL = false;

	if (inst.getProperty("MinExtendedResourceTypeMajorVersion", instance.MinExtendedResourceTypeMajorVersion) == OK)
		instance.MinExtendedResourceTypeMajorVersion_isNULL = false;

	if (inst.getProperty("MinExtendedResourceTypeMinorVersion", instance.MinExtendedResourceTypeMinorVersion) == OK)
		instance.MinExtendedResourceTypeMinorVersion_isNULL = false;

	if (inst.getProperty("MinExtendedResourceTypeRevisionNumber", instance.MinExtendedResourceTypeRevisionNumber) == OK)
		instance.MinExtendedResourceTypeRevisionNumber_isNULL = false;

	if (inst.getProperty("MinExtendedResourceTypeBuildNumber", instance.MinExtendedResourceTypeBuildNumber) == OK)
		instance.MinExtendedResourceTypeBuildNumber_isNULL = false;

	if (inst.getProperty("TargetOSTypes", instance.TargetOSTypes) == OK)
		instance.TargetOSTypes_isNULL = false;

	_L_;
}

