#!/bin/bash

###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_InstalledSoftwareIdentity.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_InstalledSoftwareIdentity provider module";
Name = "SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityModule";
Location = "cmpiSoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_InstalledSoftwareIdentity provider";
Name = "SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProvider";
ProviderModuleName = "SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_InstalledSoftwareIdentity provider capabilities";
ProviderModuleName = "SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityModule";
ProviderName = "SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProvider";
ClassName = "OpenDRIM_InstalledSoftwareIdentity";
ProviderType = {2, 3};
Namespaces = {"$1"};
SupportedProperties = {"System", "InstalledSoftware"};
CapabilityID = "SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_InstalledSoftwareIdentity.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_InstalledSoftwareIdentity]   
   provider: SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProvider
   location: cmpiSoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProvider
   type: instance association
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_InstalledSoftwareIdentity.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_InstalledSoftwareIdentity-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_InstalledSoftwareIdentity.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
