#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Harry Potter and the Mysterious Thief Part 2
# send your bug reports to contact@dotslashplay.it
###

script_version=20230425.1

GAME_ID='harry-potter-and-the-mysterious-thief-part2'
GAME_NAME='Harry Potter and the Mysterious Thief Part 2'

ARCHIVE_BASE_0='HPatMTp2-linux.tar.bz2'
ARCHIVE_BASE_0_MD5='e3505e2a2ba06f645092c6e53c344ca2'
ARCHIVE_BASE_0_SIZE='120000'
ARCHIVE_BASE_0_VERSION='1.0-itch.2020.12.01'
ARCHIVE_BASE_0_URL='https://rivarsstudio.itch.io/harry-potter-and-the-mysterious-thief-part-ii'

RENPY_NAME='HarryPotterandTheMysteriousThiefpart2'

CONTENT_PATH_DEFAULT='HPatMTp2-linux'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT}/lib/linux-x86_64"
CONTENT_LIBS_BIN_FILES='
libGLEW.so.1.7
libavcodec.so.57
libavformat.so.57
libavresample.so.3
libavutil.so.55
libpng12.so.0
libpython2.7.so.1.0
libswresample.so.2
libswscale.so.4'
CONTENT_GAME_BIN_FILES="
lib/linux-x86_64/lib/python2.7
lib/linux-x86_64/python
lib/linux-x86_64/pythonw
lib/linux-x86_64/zsync
lib/linux-x86_64/zsyncmake
lib/linux-x86_64/${RENPY_NAME}"
CONTENT_GAME_DATA_FILES="
game
renpy
lib/pythonlib2.7
${RENPY_NAME}.py"

APP_MAIN_EXE="lib/linux-x86_64/${RENPY_NAME}"
APP_MAIN_OPTIONS="-EO ${RENPY_NAME}.py"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libfreetype.so.6
libGL.so.1
libGLU.so.1
libjpeg.so.62
libm.so.6
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0
libSDL2_ttf-2.0.so.0
libutil.so.1
libX11.so.6
libXext.so.6
libXi.so.6
libXmu.so.6
libz.so.1'

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Use default Ren'Py icon if it is available

launcher_desktop() {
	local application
	application="$1"

	local application_name application_icon application_category launcher_desktop_exec
	application_name=$(application_name "$application")
	application_category=$(application_category "$application")
	launcher_desktop_exec=$(launcher_desktop_exec "$application")

	cat <<- EOF
	[Desktop Entry]
	Version=1.0
	Type=Application
	Name=$application_name
	Icon=renpy
	$launcher_desktop_exec
	Categories=$application_category
	EOF
}

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
