#!/bin/sh
set -o errexit

###
# Copyright (c) 2015-2021, Antoine Le Gonidec <vv221@dotslashplay.it>
# Copyright (c) 2016-2021, Mopi
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Yono and the Celestial Elephants
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20211214.2

# Set game-specific variables

GAME_ID='yono-and-the-celestial-elephants'
GAME_NAME='Yono and the Celestial Elephants'

ARCHIVE_BASE_1='setup_yono_and_the_celestial_elephants_01.01_cn_update_(40286).exe'
ARCHIVE_BASE_1_MD5='1503a970416ab3cd2e68db7f577f9701'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='1200000'
ARCHIVE_BASE_1_VERSION='01.01-gog40286'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/yono_and_the_celestial_elephants'

ARCHIVE_BASE_0='setup_yono_and_the_celestial_elephants_01.01_(15299).exe'
ARCHIVE_BASE_0_MD5='c16fddaa24eded544fb9ee42d5b4e2a2'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1200000'
ARCHIVE_BASE_0_VERSION='01.01-gog15299'

CONTENT_PATH_DEFAULT='.'

ARCHIVE_GAME_BIN_PATH="$CONTENT_PATH_DEFAULT"
ARCHIVE_GAME_BIN_FILES='
yono?and?the?celestial?elephants.exe
yono?and?the?celestial?elephants_data/mono
yono?and?the?celestial?elephants_data/plugins'

ARCHIVE_GAME_DATA_PATH="$CONTENT_PATH_DEFAULT"
ARCHIVE_GAME_DATA_FILES='yono?and?the?celestial?elephants_data'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='yono and the celestial elephants.exe'
APP_MAIN_ICON='yono and the celestial elephants.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine alsa libGL.so.1"

# Use persistent storage for user data

APP_WINE_LINK_DIRS="$APP_WINE_LINK_DIRS"'
userdata:users/$(id -un)/AppData/LocalLow/Neckbolt/Yono and the Celestial Elephants/Resources/savefiles'
DATA_DIRS="$DATA_DIRS ./userdata"

# Use a dedicated log file for the current game session

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'

# Use a dedicated log file for the current game session
mkdir --parents logs
APP_OPTIONS="${APP_OPTIONS} -logFile ./logs/$(date +%F-%R).log"'

# Improve controller support
# Tested only with an XBox 360 controller

APP_WINETRICKS="$APP_WINETRICKS xinput"
PKG_BIN_DEPS="$PKG_BIN_DEPS winetricks"

# Keep compatibility with old archives

CONTENT_PATH_DEFAULT_0='app'
ARCHIVE_GAME_BIN_PATH_0="$CONTENT_PATH_DEFAULT_0"
ARCHIVE_GAME_DATA_PATH_0="$CONTENT_PATH_DEFAULT_0"

# Load common functions

target_version='2.14'

if [ -z "$PLAYIT_LIB2" ]; then
	for path in \
		"$PWD" \
		"${XDG_DATA_HOME:="$HOME/.local/share"}/play.it" \
		'/usr/local/share/games/play.it' \
		'/usr/local/share/play.it' \
		'/usr/share/games/play.it' \
		'/usr/share/play.it'
	do
		if [ -e "${path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "$PLAYIT_WORKDIR/gamedata"

# Extract icons

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
