;; sdic-compat.el ---- -*- Emacs-Lisp -*- Library to search COMPAT format dictionary.
;; $Id: sdic-compat.el,v 2.5 2002/07/02 11:17:46 tsuchiya Exp $

;; Copyright (C) 1998,99 TSUCHIYA Masatoshi <tsuchiya@namazu.org>

;; Author: TSUCHIYA Masatoshi <tsuchiya@namazu.org>
;; Keywords: dictionary

;; This file is part of SDIC.

;; SDIC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; SDIC is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SDIC; if not, write to the Free Software Foundation,
;; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


;;; Commentary:

;; COMPAT μץ( look / grep )ѤƸ
;; 饤֥ǤCOMPAT ξܺ٤ˤĤƤ sdic.texi 򻲾ȤƲ
;; 


;;; Install:

;; (1) look ʸ/ʸΰ㤤̵뤷 grep ( fgrep 
;;     ޤ GNU grep )ɬפǤޤɽѤ 
;;     egrep ɬפǤѥ̤äƤ뤫ǧƲ
;;
;; (2) ŬڤʷѴơŬʾ( : /usr/dict/ )¸
;;     ƲѴѥץȤȤưʲ Perl ץȤ
;;     ѤǤޤ
;;
;;         gene.perl    - GENE95 
;;         jgene.perl   - GENE95 񤫤±Ѽ
;;         eijirou.perl - ѼϺ
;;
;;     --compat ץꤹɬפޤ
;;
;; (3) Ȥ褦ˤ sdic-eiwa-dictionary-list ޤ
;;      sdic-waei-dictionary-list ɲäƲ
;;
;;         (setq sdic-eiwa-dictionary-list
;;               (cons '(sdic-compat "/usr/dict/gene.dic") sdic-eiwa-dictionary-list))
;;
;;     ϼΤ褦ʹˤʤäƤޤ
;;
;;         (sdic-compat ե̾ (ץA A) (ץB B) ...)
;;
;;     ̤ʻ꤬פʾˤϡץϾάǤޤ
;;
;;         (sdic-compat ե̾)


;;; Options:

;; sdic-compat.el ФƻǤ륪ץϼ̤Ǥ
;;
;; coding-system
;;     δɤꤷޤάϡ
;;     sdic-default-coding-system ͤȤޤ
;;
;; title
;;     Υȥꤷޤάϡե 
;;     basename 򥿥ȥȤޤ
;;
;; look
;;     ׸/׸λѤ볰ޥɤ̾
;;     ޤά sdic-compat-look-command ͤȤޤ
;;
;; look-case-option
;;     look ץˤäƻꤵ줿ޥɤФơʸ
;;     /ʸ̤ʤǸ褦˻ؼ뤿Υޥɥ饤
;;     ꤷޤά sdic-compat-look-case-option 
;;     ͤȤޤ
;;
;; grep
;;     ׸/ʸλѤ볰ޥɤ̾ꤷ
;;     ά sdic-compat-grep-command ͤȤޤ
;;
;; grep-case-option
;;     grep ץˤäƻꤵ줿ޥɤФơʸ
;;     /ʸ̤ʤǸ褦˻ؼ뤿Υޥɥ饤
;;     ꤷޤά sdic-compat-grep-case-option 
;;     ͤȤޤ
;;
;; egrep
;;     ɽλѤ볰ޥɤ̾ꤷޤά
;;      sdic-compat-egrep-command ͤȤޤ
;;
;; egrep-case-option
;;     egrep ץˤäƻꤵ줿ޥɤФơʸ
;;     /ʸ̤ʤǸ褦˻ؼ뤿Υޥɥ饤
;;     ꤷޤά 
;;     sdic-compat-egrep-case-option ͤȤޤ


;;; Note:

;; sdic-compat-look-command / sdic-compat-grep-command /
;; sdic-compat-egrep-command ͤϼưŪꤵޤ㤨С
;; sdic-compat-grep-command ξ硢fgrep / fgrep.exe / grep /
;; grep.exe 4Υޥɤ򸡺ơĤäޥɤȤޤ
;;
;; sdic-compat.el  sdic-gene.el Ʊǽ󶡤Ƥ饤֥
;; sdic-compat.el ϳޥɤƤӽФƤΤФơ
;; sdic-gene.el  Emacs εǽΤߤѤƤޤХ
;; եɤ߹Ǥ鸡ԤʤΤǡ̤Υ꤬ɬפˤʤޤ
;;
;; Default ǤϡɬפʳޥɤĤä 
;; sdic-compat.el 򡢸Ĥʤäˤ sdic-gene.el Ȥ褦
;; ˤʤäƤޤ


;;; 饤֥
(require 'sdic)
(require 'sdicf)
(provide 'sdic-compat)
(put 'sdic-compat 'version "2.0")
(put 'sdic-compat 'init-dictionary 'sdic-compat-init-dictionary)
(put 'sdic-compat 'open-dictionary 'sdic-compat-open-dictionary)
(put 'sdic-compat 'close-dictionary 'sdic-compat-close-dictionary)
(put 'sdic-compat 'search-entry 'sdic-compat-search-entry)
(put 'sdic-compat 'get-content 'sdic-compat-get-content)


;;;----------------------------------------------------------------------
;;;		/ѿ
;;;----------------------------------------------------------------------

(defvar sdic-compat-look-command (sdicf-find-program "look" "look.exe")
  "*Executable file name of look")

(defvar sdic-compat-look-case-option "-f" "*Command line option for look to ignore case")

(defvar sdic-compat-grep-command (sdicf-find-program "fgrep" "fgrep.exe" "grep" "grep.exe")
  "*Executable file name of grep")

(defvar sdic-compat-grep-case-option "-i" "*Command line option for grep to ignore case")

(defvar sdic-compat-egrep-command (sdicf-find-program "egrep" "egrep.exe" "grep" "grep.exe")
  "*Executable file name of egrep")

(defvar sdic-compat-egrep-case-option "-i" "*Command line option for egrep to ignore case")

(defconst sdic-compat-search-buffer-name " *sdic-compat*")



;;;----------------------------------------------------------------------
;;;		
;;;----------------------------------------------------------------------

(defun sdic-compat-available-p () "\
Function to check availability of library.
饤֥Ѳǽ򸡺ؿ"
  (and (file-executable-p sdic-compat-look-command)
       (file-executable-p sdic-compat-grep-command)))


(defun sdic-compat-init-dictionary (file-name &rest option-list)
  "Function to initialize dictionary"
  (let ((dic (sdic-make-dictionary-symbol)))
    (if (file-readable-p (setq file-name (expand-file-name file-name)))
	(progn
	  (mapcar '(lambda (c) (put dic (car c) (nth 1 c))) option-list)
	  (put dic 'file-name file-name)
	  (put dic 'identifier (concat "sdic-compat+" file-name))
	  (or (get dic 'title)
	      (put dic 'title (file-name-nondirectory file-name)))
	  (or (get dic 'look)
	      (put dic 'look sdic-compat-look-command))
	  (or (get dic 'look-case-option)
	      (put dic 'look-case-option sdic-compat-look-case-option))
	  (or (get dic 'grep)
	      (put dic 'grep sdic-compat-grep-command))
	  (or (get dic 'grep-case-option)
	      (put dic 'grep-case-option sdic-compat-grep-case-option))
	  (or (get dic 'egrep)
	      (put dic 'egrep sdic-compat-egrep-command))
	  (or (get dic 'egrep-case-option)
	      (put dic 'egrep-case-option sdic-compat-egrep-case-option))
	  (or (get dic 'coding-system)
	      (put dic 'coding-system sdic-default-coding-system))
	  (and (stringp (get dic 'look))
	       (stringp (get dic 'grep))
	       dic))
      (error "Can't read dictionary: %s" (prin1-to-string file-name)))))


(defun sdic-compat-open-dictionary (dic)
  "Function to open dictionary"
  (and (or (sdicf-buffer-live-p (get dic 'sdic-compat-search-buffer))
	   (put dic 'sdic-compat-search-buffer (generate-new-buffer sdic-compat-search-buffer-name)))
       dic))


(defun sdic-compat-close-dictionary (dic)
  "Function to close dictionary"
  (kill-buffer (get dic 'sdic-compat-search-buffer))
  (put dic 'sdic-compat-search-buffer nil))


(defun sdic-compat-search-entry (dic string &optional search-type) "\
Function to search word with look or grep, and write results to current buffer.
search-type ͤˤäƼΤ褦ưѹ롣
    nil    : ׸
    t      : ׸
    lambda : ׸
    0      : ʸ
    regexp : ɽ
̤ȤƸĤäФ򥭡ȤʸƬ point ͤȤ
Ϣ֤"
  (save-excursion
    (set-buffer (get dic 'sdic-compat-search-buffer))
    (save-restriction
      (if (get dic 'sdic-compat-erase-buffer)
	  (delete-region (point-min) (point-max))
	(goto-char (point-max))
	(narrow-to-region (point-max) (point-max)))
      (put dic 'sdic-compat-erase-buffer nil)
      (cond
       ;; ׸ξ -> look ȤäƸ
       ((eq search-type nil)
	(if (string-match "\\Ca" string)
	    (sdicf-call-process (get dic 'look) (get dic 'coding-system) nil t nil
				string (get dic 'file-name))
	  (sdicf-call-process (get dic 'look) (get dic 'coding-system) nil t nil
			      (get dic 'look-case-option) string (get dic 'file-name))))
       ;; ׸ξ -> grep ȤäƸ
       ((eq search-type t)
	(if (string-match "\\Ca" string)
	    (sdicf-call-process (get dic 'grep) (get dic 'coding-system) nil t nil
				(concat string "\t") (get dic 'file-name))
	  (sdicf-call-process (get dic 'grep) (get dic 'coding-system) nil t nil
			      (get dic 'grep-case-option)
			      (concat string "\t") (get dic 'file-name))))
       ;; ׸ξ -> look ȤäƸ / ;ʬʥǡõ
       ((eq search-type 'lambda)
	(if (string-match "\\Ca" string)
	    (sdicf-call-process (get dic 'look) (get dic 'coding-system) nil t nil
				string (get dic 'file-name))
	  (sdicf-call-process (get dic 'look) (get dic 'coding-system) nil t nil
			      (get dic 'look-case-option)
			      string (get dic 'file-name)))
	(goto-char (point-min))
	(while (if (looking-at (format "%s\t" (regexp-quote string)))
		   (= 0 (forward-line 1))
		 (delete-region (point) (point-max)))))
       ;; ʸξ -> grep ȤäƸ
       ((eq search-type 0)
	(if (string-match "\\Ca" string)
	    (sdicf-call-process (get dic 'grep) (get dic 'coding-system) nil t nil
				string (get dic 'file-name))
	  (sdicf-call-process (get dic 'grep) (get dic 'coding-system) nil t nil
			      (get dic 'grep-case-option)
			      string (get dic 'file-name))))
       ;; ɽξ -> egrep ȤäƸ
       ((eq search-type 'regexp)
	(or (stringp (get dic 'egrep))
	    (error "%s" "Command to search regular expression pattern is not specified"))
	(if (string-match "\\Ca" string)
	    (sdicf-call-process (get dic 'egrep) (get dic 'coding-system) nil t nil
				string (get dic 'file-name))
	  (sdicf-call-process (get dic 'egrep) (get dic 'coding-system) nil t nil
			      (get dic 'egrep-case-option)
			      string (get dic 'file-name))))
       ;; ʳθꤵ줿
       (t (error "Not supported search type is specified. \(%s\)"
		 (prin1-to-string search-type))))
      ;; Ƹ̤ ID Ϳ
      (goto-char (point-min))
      (let (ret)
	(while (if (looking-at "\\([^\t]+\\)\t")
		   (progn
		     (setq ret (cons (cons (sdic-match-string 1) (match-end 0)) ret))
		     (= 0 (forward-line 1)))))
	(nreverse ret)))))


(defun sdic-compat-get-content (dic point)
  (save-excursion
    (set-buffer (get dic 'sdic-compat-search-buffer))
    (put dic 'sdic-compat-erase-buffer t)
    (if (<= point (point-max))
	(buffer-substring (goto-char point) (progn (end-of-line) (point)))
      (error "Can't find content. (ID=%d)" point))))
