!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawpupot
!! NAME
!! pawpupot
!!
!! FUNCTION
!! Compute occupation matrix, LDA+U potential, and Contributions to energy
!! for PAW+U calculations
!!
!! A-Compute LDA+U Potential
!! B-Compute Contributions to energy
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (BA, FJ)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors.
!!
!! INPUTS
!!  ispden=current spin component
!!  nspden=number of spin components
!!  pawprtvol=control print volume and debugging output for PAW
!!  paw_ij(natom) <type(paw_ij_type)>=paw arrays given on (i,j) channels
!!  %noccmmp(2*pawtab(itypat)%lpawu+1,2*pawtab(itypat)%lpawu+1,nspden)
!!     density matrix in the sphere
!!  %nocctot(nspden) number of electrons in the correlated subspace
!!  pawtab(ntypat) <type(pawtab_type)>=paw tabulated starting data:
!!     %lpawu=l used for lda+u
!!     %vee(2*lpawu+1*4)=screened coulomb matrix
!!  VUKS= Kohn Sham potential for LDA+U (for test only)
!!
!! OUTPUT
!!  vpawu(pawtab%lpawu*2+1,pawtab%lpawu*2+1)=lda+u potential
!!       (see eg PRB 52m 5467 (1995))
!!
!! PARENTS
!!      pawdij
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 subroutine pawpupot(ispden,nspden,paw_ij,pawprtvol,pawtab,vpawu,VUKS)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ---------------------------------------------
!scalars
 integer,intent(in) :: ispden,nspden,pawprtvol
 type(paw_ij_type),intent(in) :: paw_ij
 type(pawtab_type),intent(in) :: pawtab
!arrays
 real(dp),intent(inout) :: vpawu(pawtab%lpawu*2+1,pawtab%lpawu*2+1)

!Local variables ---------------------------------------
!scalars
 integer :: lpawu,m1,m11,m2,m21,m3,m31,m4,m41
 real(dp) :: VUKS,VUKStemp
 character(len=500) :: message

! *****************************************************
 lpawu=pawtab%lpawu

!======================================================
! Compute LDA+U Potential on the basis of projectors.
! cf PRB 52 5467 (1995)
! -----------------------------------------------------

 vpawu=zero
 do m1=-lpawu,lpawu
  m11=m1+lpawu+1
  do m2=-lpawu,lpawu
   m21=m2+lpawu+1
   do m3=-lpawu,lpawu
    m31=m3+lpawu+1
    do m4=-lpawu,lpawu
     m41=m4+lpawu+1
     vpawu(m11,m21)=vpawu(m11,m21)+&
&    pawtab%vee(m11,m31,m21,m41)*paw_ij%noccmmp(m31,m41,nspden-ispden+1)+&
&    (pawtab%vee(m11,m31,m21,m41)-pawtab%vee(m11,m31,m41,m21))&
&    *paw_ij%noccmmp(m31,m41,ispden) 
    end do
   end do
   if(pawprtvol>=3) then
    if(m11/=m21) then
     write(message,'(a,i4,i4,e20.10)') "vu",m11,m21,vpawu(m11,m21)
     call wrtout(06,  message,'COLL')
     write(message,'(a,e20.10)') "vupred",-pawtab%upawu*paw_ij%noccmmp(m21,m11,ispden)
     call wrtout(06,  message,'COLL')
    end if
   end if
  end do ! m2
  if(pawtab%usepawu==1) then
   vpawu(m11,m11)=vpawu(m11,m11)-&
&  pawtab%upawu*(paw_ij%nocctot(ispden)+paw_ij%nocctot(nspden-ispden+1)-One/Two)+&
&  pawtab%jpawu*(paw_ij%nocctot(ispden)             -One/Two)
  elseif(pawtab%usepawu==2) then
   vpawu(m11,m11)=vpawu(m11,m11)-&
&  pawtab%upawu*(paw_ij%nocctot(nspden-ispden+1))-&
&  (pawtab%upawu-pawtab%jpawu)*(paw_ij%nocctot(ispden)*&
&  (Two*dfloat(lpawu))/(Two*dfloat(lpawu)+One))
  end if
  if (pawprtvol>=3) then
   write(message,'(a,i4,i4,2x,e20.10)') "vudiag",m11,m11,vpawu(m11,m11)
   call wrtout(06,  message,'COLL')
   write(message,'(a,e20.10)') "vudiagpred",pawtab%upawu*(half-paw_ij%noccmmp(m11,m11,ispden))
   call wrtout(06,  message,'COLL')
  end if
 end do ! m1

 if (pawprtvol>=3) then
  VUKStemp=zero
  do m1=-lpawu,lpawu
   m11=m1+lpawu+1
   do m2=-lpawu,lpawu
    m21=m2+lpawu+1
    VUKStemp=VUKStemp+vpawu(m11,m21)*paw_ij%noccmmp(m11,m21,ispden)
    write(message,'(a,e20.10,e20.10)') "vuks,m1,m2,vpawu,noccmmp",vpawu(m11,m21)&
&   ,paw_ij%noccmmp(m11,m21,ispden)
    call wrtout(06,  message,'COLL')
   end do
  end do
  VUKS=VUKS+VUKStemp
  write(message,*) "pawpupot: VUKStemp",ispden,VUKStemp
  call wrtout(06,  message,'COLL')
  write(message,*) "pawpupot: VUKS",ispden,VUKS
  call wrtout(06,  message,'COLL')
 end if
 
 end subroutine pawpupot
!!***
