!{\src2tex{textfont=tt}}
!!****f* ABINIT/findqg0
!! NAME
!! findqg0
!!
!! FUNCTION
!! Identify q + g0 = k - kp
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  kmkp(3)= k - kp input vector
!!  nqbz=number of q points
!!  qbz(3,nqbz)=coordinates of q points
!!
!! OUTPUT
!!  iq=index of q vector in BZ table
!!  g0(3)=reciprocal space vector, to be used in igfft
!!
!! PARENTS
!!      csigme
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine findqg0(iq,g0,kmkp,nqbz,qbz)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nqbz
 integer,intent(out) :: iq
!arrays
 integer,intent(out) :: g0(3)
 real(dp),intent(in) :: kmkp(3),qbz(3,nqbz)

!Local variables-------------------------------
!scalars
 integer :: iqbz,jg01,jg02,jg03
 real(dp),parameter :: biggest_q0=1.0d-3
!arrays
 real(dp) :: kp(3),qpg0(3)

! *************************************************************************
 iq=0
 if(all(abs(kmkp(:))<epsilon(one))) then
  ! find q close to 0
  do iqbz=1,nqbz
   if(all(abs(qbz(:,iqbz))<biggest_q0)) iq=iqbz
  end do
  if(iq==0) stop 'wrong em1 file: q=0 not existing'
  g0(:)=0
  return
 else
  do iqbz=1,nqbz
   do jg01=-2,2
    do jg02=-2,2
     do jg03=-2,2
!     form q-G0 and check if it is the one
      qpg0(1)=qbz(1,iqbz)+jg01
      qpg0(2)=qbz(2,iqbz)+jg02
      qpg0(3)=qbz(3,iqbz)+jg03
      if(all(abs(qpg0(:)-kmkp(:))<1.e-5)) then
       if(iq/=0) then
        write(6,*)'**error: duplicated q+g0.'
        write(6,*) iqbz,qbz(:,iqbz),jg01,jg02,jg03
        write(6,*)  iq,qbz(:,iq),g0
        stop 'duplicated q+g0'
       end if
       iq=iqbz
       g0(1)=jg01
       g0(2)=jg02
       g0(3)=jg03
      end if
     end do
    end do
   end do
  end do
  if(iq==0) then
   write(6,*) '**error: q = k - kp + g0 not found.'
   write(6,*) 'kmkp  = ',kmkp(:)
   stop 'q = k - kp + g0 not found'
  end if
 end if
 return
end subroutine findqg0
!!***
