(make-*/mail-returns-symbol-alistp-thm email-auto-outgoing)
(make-*/mail-returns-same-env-thm      email-auto-outgoing)
(make-*/mail-returns-message-p-thm     email-auto-outgoing)
(make-*/mail-returns-symbolp-thm       email-auto-outgoing)

(make-*/mail-returns-symbolp-thm       email-auto-incoming)
(make-*/mail-returns-symbol-alistp-thm email-auto-incoming)
(make-*/mail-returns-message-p-thm     email-auto-incoming)
(make-*/mail-returns-superset-of-user-thm email-auto-incoming)

(make-*/init-add-and-changes-only-x-variables-thm email-auto-init 
   '(already-answered user default-response))

;; (user-in-already-answered user env) -> boolean
;; checks whether user in in 'already-answered list
(defun user-in-already-answered (user env)
  (member-equal user (get-var 'already-answered env)))

; example usage of user-in-already-answered
(user-in-already-answered (email 'user 'host)
			  (set-var 'already-answered
				   (list (email 'u 'h)
				    (email 'user 'host))
				   '()))

;;;;;;;;email-auto-incoming/*;;;;;;;;;;;;;

;; email-auto-incoming/auto-response-if-not-already-answered
;;   if autoresponder enabled, then a message sent to user
;;   will result in one auto-response
(defthm email-auto-incoming/auto-response-if-not-already-answered
  (implies
   (and
    (lookup 'default-response)             ; autoresponder enabled
    (lookup 'user)                         
    (equal sender (message-sender msg))
    (not (member-equal sender (lookup 'already-answered)))
    )
   (mv-let (s new-msg new-env)
	   (email-auto-incoming msg env)
	   (and (equal s 'mail)
		(equal (recipient new-msg) sender)
		)
		))
  :hints (("Goal" :in-theory (enable email-auto-incoming)))) 

(defthm email-auto-incoming/auto-response-if-not-already-answered-mail-action
  (implies
   (and
    (lookup 'default-response)             ; autoresponder enabled
    (lookup 'user)                         
    (equal sender (message-sender msg))
    (not (member-equal sender (lookup 'already-answered)))
    )
   (mv-let (s new-msg new-env)
	   (email-auto-incoming msg env)
	   (equal s 'mail)
		))
  :hints (("Goal" :in-theory (enable email-auto-incoming)))) 


;; email-auto-incoming/no-auto-response-if-already-answered
;;   If enabled, subsequent messages from the same user result in
;;   no additional messages
(defthm email-auto-incoming/no-auto-response-if-already-answered
  (implies
   (and
    (equal (message-sender msg) sender)
    (user-in-already-answered sender env)
    )
   (not 
    (equal (mv-status (email-auto-incoming msg env))
	   'mail)))
  :hints (("Goal" :in-theory (enable email-auto-incoming))))

;; email-auto-incoming/auto-response-adds-sender-to-already-answered
;;   When sending an autoresponse, sender address is added to 
;;   'already-answered list and will thus not receive additional
;;   auto-responses
(defthm email-auto-incoming/auto-response-adds-sender-to-already-answered
  (implies
   (and
    (lookup 'default-response)
    (lookup 'user)
    (equal sender (message-sender msg))
    (not (member-equal sender (lookup 'already-answered)))
    )
   (user-in-already-answered sender (mv-env (email-auto-incoming msg env))))
  :hints (("Goal" :in-theory (enable email-auto-incoming))))

(defthm email-auto-incoming/something
  (implies
   (and
    (lookup 'default-response)             ; autoresponder enabled
    (lookup 'user)                         
    (equal sender (message-sender msg))
    (not (member-equal sender (lookup 'already-answered)))
    )
   (mv-let (s new-msg new-env)
	   (email-auto-incoming msg env)
	   (equal s 'mail)))
  :hints (("Goal" :in-theory (enable email-auto-incoming))))

(defthm email-auto-incoming/auto-response-recipient-becomes-message-sender
  (implies
   (and
    (lookup 'default-response)             ; autoresponder enabled
    (lookup 'user)                         
    (equal sender (message-sender msg))
    (not (member-equal sender (lookup 'already-answered)))
    )
    (equal 
     (message-sender (mv-msg (email-auto-incoming msg env)))
     (recipient msg)))
  :hints (("Goal" :in-theory (enable email-auto-incoming))))

(defthm email-auto-incoming/auto-response-message-sender-becomes-recipient
  (implies
   (and
;    (message-p msg)
    (get-var 'default-response env)   ; autoresponder enabled
    (get-var 'user             env)
    (equal (message-sender msg) sender)
    (not (member-equal sender (get-var 'already-answered env)))
    )
   (sender-becomes-recipient 
      msg
      (mv-msg (email-auto-incoming msg env))))
;    (equal 
;     (recipient (mv-msg (email-auto-incoming msg env)))
;     sender))
  :hints (("Goal" :in-theory (enable email-auto-incoming))))
(user-deliver
 (mk-message 
  (mk-email 'rjh 'host)
  (list (mk-email 'bob 'host))
  '()
  '(a body))
 (set-var 'default-response 'res
 (set-var 'user             'rjh
 (set-var 'already-answered '()
     '()))))

(defthm email-auto-incoming/auto-response-message-rewrite
  (implies
   (and
    (message-p msg)
    (get-var 'default-response env)   ; autoresponder enabled
    (get-var 'user             env)
    (equal (message-sender msg) sender)
    (equal (recipient msg) recip)
    (not (member-equal sender (get-var 'already-answered env)))
    )
    (equal 
     (mv-msg (email-auto-incoming msg env))
     (mk-message recip (list sender)
		 (set-var 'subject (list 're (subject msg)) '())
		 (cons (get-var 'default-response env) '()))))
  :hints (("Goal" :in-theory (enable email-auto-incoming)))
  :rule-classes (:rewrite :forward-chaining))

(defthm email-auto-incoming/already-answered-added
  (implies
   (and
    (lookup 'default-response)             ; autoresponder enabled
    (lookup 'user)                         
    (equal sender (message-sender msg))
    (not (member-equal sender (lookup 'already-answered)))
    )
   (equal 
    (mv-env (email-auto-incoming msg env))
    (set-var 'already-answered 
	     (cons sender (get-var 'already-answered env))
	     env)))
  :hints (("Goal" :in-theory (enable email-auto-incoming))))



;; email-auto-incoming/auto-response-adds-sender-to-already-answered
(fif comment 
    (defthm email-auto-incoming/xxxx
  (implies
   (and
    (lookup 'default-response)
    (lookup 'user)
    (equal sender (message-sender msg))
    (not (member-equal sender (lookup 'already-answered)))
    (not (lookup k))
    (symbolp k)
    )
   (mv-let (s new-msg new-env)
	   (email-auto-incoming msg env)
	   (equal (get-var k env)
		  (get-var k new-env))))
  :hints (("Goal" :in-theory (enable email-auto-incoming))))
)
