#include <stdio.h>
#include <time.h>
#include "ap.h"
// disable some irrelevant warnings
#if (AE_COMPILER==AE_MSVC) && !defined(AE_ALL_WARNINGS)
#pragma warning(disable:4100)
#pragma warning(disable:4127)
#pragma warning(disable:4611)
#pragma warning(disable:4702)
#pragma warning(disable:4996)
#endif
#include "alglibinternal.h"
#include "alglibmisc.h"
#include "linalg.h"
#include "solvers.h"
#include "optimization.h"
#include "diffequations.h"
#include "specialfunctions.h"
#include "integration.h"
#include "statistics.h"
#include "interpolation.h"
#include "fasttransforms.h"
#include "dataanalysis.h"

using namespace alglib_impl;



typedef struct
{
    double v0;
    ae_vector x0;
    ae_vector x1;
    ae_vector x2;
    ae_vector ix0;
    ae_vector ix1;
    ae_vector bx0;
    ae_vector bx1;
    ae_matrix a0;
    ae_matrix a1;
} ablasfplayground;





ae_bool testablasf(ae_bool silent, ae_state *_state);
ae_bool _pexec_testablasf(ae_bool silent, ae_state *_state);


double refrdotv(ae_int_t n,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_vector* y,
     ae_state *_state);


double refrdotvr(ae_int_t n,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_matrix* a,
     ae_int_t i,
     ae_state *_state);


double refrdotrr(ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     /* Real    */ ae_matrix* b,
     ae_int_t ib,
     ae_state *_state);


double refrdotv2(ae_int_t n, /* Real    */ ae_vector* x, ae_state *_state);


void refraddv(ae_int_t n,
     double alpha,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_vector* x,
     ae_state *_state);


void refraddvx(ae_int_t n,
     double alpha,
     /* Real    */ ae_vector* y,
     ae_int_t offsy,
     /* Real    */ ae_vector* x,
     ae_int_t offsx,
     ae_state *_state);


void refraddvc(ae_int_t n,
     double alpha,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_matrix* x,
     ae_int_t colidx,
     ae_state *_state);


void refraddvr(ae_int_t n,
     double alpha,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_matrix* x,
     ae_int_t rowidx,
     ae_state *_state);


void refraddrv(ae_int_t n,
     double alpha,
     /* Real    */ ae_matrix* y,
     ae_int_t ridx,
     /* Real    */ ae_vector* x,
     ae_state *_state);


void refraddrr(ae_int_t n,
     double alpha,
     /* Real    */ ae_matrix* y,
     ae_int_t ridxsrc,
     /* Real    */ ae_matrix* x,
     ae_int_t ridxdst,
     ae_state *_state);


void refrsetv(ae_int_t n,
     double v,
     /* Real    */ ae_vector* x,
     ae_state *_state);


void refrsetvx(ae_int_t n,
     double v,
     /* Real    */ ae_vector* x,
     ae_int_t offsx,
     ae_state *_state);


void refisetv(ae_int_t n,
     ae_int_t v,
     /* Integer */ ae_vector* x,
     ae_state *_state);


void refbsetv(ae_int_t n,
     ae_bool v,
     /* Boolean */ ae_vector* x,
     ae_state *_state);


void refrsetm(ae_int_t m,
     ae_int_t n,
     double v,
     /* Real    */ ae_matrix* a,
     ae_state *_state);


void refrsetr(ae_int_t n,
     double v,
     /* Real    */ ae_matrix* a,
     ae_int_t i,
     ae_state *_state);


void refrsetc(ae_int_t n,
     double v,
     /* Real    */ ae_matrix* a,
     ae_int_t j,
     ae_state *_state);


void refrcopyv(ae_int_t n,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_vector* y,
     ae_state *_state);


void refbcopyv(ae_int_t n,
     /* Boolean */ ae_vector* x,
     /* Boolean */ ae_vector* y,
     ae_state *_state);


void refrcopyvx(ae_int_t n,
     /* Real    */ ae_vector* x,
     ae_int_t offsx,
     /* Real    */ ae_vector* y,
     ae_int_t offsy,
     ae_state *_state);


void reficopyv(ae_int_t n,
     /* Integer */ ae_vector* x,
     /* Integer */ ae_vector* y,
     ae_state *_state);


void reficopyvx(ae_int_t n,
     /* Integer */ ae_vector* x,
     ae_int_t offsx,
     /* Integer */ ae_vector* y,
     ae_int_t offsy,
     ae_state *_state);


void refrcopyvr(ae_int_t n,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_matrix* a,
     ae_int_t i,
     ae_state *_state);


void refrcopyrv(ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i,
     /* Real    */ ae_vector* x,
     ae_state *_state);


void refrcopyrr(ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i,
     /* Real    */ ae_matrix* b,
     ae_int_t k,
     ae_state *_state);


void refrcopyvc(ae_int_t n,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_matrix* a,
     ae_int_t j,
     ae_state *_state);


void refrcopycv(ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t j,
     /* Real    */ ae_vector* x,
     ae_state *_state);


void refrcopymulv(ae_int_t n,
     double v,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_vector* y,
     ae_state *_state);


void refrcopymulvr(ae_int_t n,
     double v,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_matrix* y,
     ae_int_t ridx,
     ae_state *_state);


void refrcopymulvc(ae_int_t n,
     double v,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_matrix* y,
     ae_int_t cidx,
     ae_state *_state);


void refrmulv(ae_int_t n,
     double v,
     /* Real    */ ae_vector* x,
     ae_state *_state);


void refrmulr(ae_int_t n,
     double v,
     /* Real    */ ae_matrix* x,
     ae_int_t rowidx,
     ae_state *_state);


void refrmulvx(ae_int_t n,
     double v,
     /* Real    */ ae_vector* x,
     ae_int_t offsx,
     ae_state *_state);


void refrmergemulv(ae_int_t n,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_vector* x,
     ae_state *_state);


void refrmergemulvr(ae_int_t n,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_matrix* x,
     ae_int_t rowidx,
     ae_state *_state);


void refrmergemulrv(ae_int_t n,
     /* Real    */ ae_matrix* y,
     ae_int_t rowidx,
     /* Real    */ ae_vector* x,
     ae_state *_state);


void refrmergemaxv(ae_int_t n,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_vector* x,
     ae_state *_state);


void refrmergemaxvr(ae_int_t n,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_matrix* x,
     ae_int_t rowidx,
     ae_state *_state);


void refrmergemaxrv(ae_int_t n,
     /* Real    */ ae_matrix* y,
     ae_int_t rowidx,
     /* Real    */ ae_vector* x,
     ae_state *_state);


void refrmergeminv(ae_int_t n,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_vector* x,
     ae_state *_state);


void refrmergeminvr(ae_int_t n,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_matrix* x,
     ae_int_t rowidx,
     ae_state *_state);


void refrmergeminrv(ae_int_t n,
     /* Real    */ ae_matrix* y,
     ae_int_t rowidx,
     /* Real    */ ae_vector* x,
     ae_state *_state);


double refrmaxv(ae_int_t n, /* Real    */ ae_vector* x, ae_state *_state);


double refrmaxabsv(ae_int_t n,
     /* Real    */ ae_vector* x,
     ae_state *_state);


double refrmaxr(ae_int_t n,
     /* Real    */ ae_matrix* x,
     ae_int_t rowidx,
     ae_state *_state);


double refrmaxabsr(ae_int_t n,
     /* Real    */ ae_matrix* x,
     ae_int_t rowidx,
     ae_state *_state);


void refrgemvx(ae_int_t m,
     ae_int_t n,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t opa,
     /* Real    */ ae_vector* x,
     ae_int_t ix,
     double beta,
     /* Real    */ ae_vector* y,
     ae_int_t iy,
     ae_state *_state);


/*************************************************************************
Reference TRSV
*************************************************************************/
void reftrsvx(ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Real    */ ae_vector* x,
     ae_int_t ix,
     ae_state *_state);
void _ablasfplayground_init(void* _p, ae_state *_state, ae_bool make_automatic);
void _ablasfplayground_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic);
void _ablasfplayground_clear(void* _p);
void _ablasfplayground_destroy(void* _p);








ae_bool testhqrnd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testhqrnd(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for test HQRNDContinuous function
*************************************************************************/
ae_bool hqrndcontinuoustest(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for test HQRNDContinuous function
*************************************************************************/
ae_bool hqrnddiscretetest(ae_bool silent, ae_state *_state);








ae_bool testablas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testablas(ae_bool silent, ae_state *_state);








ae_bool testhblas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testhblas(ae_bool silent, ae_state *_state);








ae_bool testcreflections(ae_bool silent, ae_state *_state);
ae_bool _pexec_testcreflections(ae_bool silent, ae_state *_state);








ae_bool testsblas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsblas(ae_bool silent, ae_state *_state);








/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testortfac(ae_bool silent, ae_state *_state);
ae_bool _pexec_testortfac(ae_bool silent, ae_state *_state);








ae_bool testmatgen(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmatgen(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing tag sort
*************************************************************************/
ae_bool testtsort(ae_bool silent, ae_state *_state);
ae_bool _pexec_testtsort(ae_bool silent, ae_state *_state);





typedef struct
{
    ae_int_t n;
    ae_int_t m;
    ae_int_t matkind;
    ae_int_t triangle;
    ae_matrix bufa;
    hqrndstate rs;
    rcommstate rcs;
} sparsegenerator;





ae_bool testsparse(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsparse(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for testing basic SKS functional.
Returns True on errors, False on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
ae_bool skstest(ae_state *_state);


/*************************************************************************
Function for testing CRS-specific functionality.
On failure sets ErrorFlag, on success does not touch it.

  -- ALGLIB PROJECT --
     Copyright 30.01.2018 by Bochkanov Sergey
*************************************************************************/
void crstest(ae_bool* errorflag, ae_state *_state);


/*************************************************************************
Function for testing serialization.
On failure sets ErrorFlag, on success does not touch it.

  -- ALGLIB PROJECT --
     Copyright 30.01.2018 by Bochkanov Sergey
*************************************************************************/
void testserialize(ae_bool* errorflag, ae_state *_state);


/*************************************************************************
Function for testing basic functional

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basicfunctest(ae_state *_state);


/*************************************************************************
Function for testing Level 2 unsymmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2unsymmetric(ae_state *_state);


/*************************************************************************
Function for testing Level 3 unsymmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel3unsymmetric(ae_state *_state);


/*************************************************************************
Function for testing Level 2 symmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2symmetric(ae_state *_state);


/*************************************************************************
Function for testing Level 2 symmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel3symmetric(ae_state *_state);


/*************************************************************************
Function for testing sparse symmetric permutations

  -- ALGLIB PROJECT --
     Copyright 07.10.2020 by Bochkanov Sergey
*************************************************************************/
ae_bool testsymmetricperm(ae_state *_state);


/*************************************************************************
Function for testing Level 2 triangular linear algebra functions.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2triangular(ae_state *_state);


/*************************************************************************
Function for testing basic functional

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basicfuncrandomtest(ae_state *_state);


/*************************************************************************
Function for testing multyplication matrix with vector

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionstest(ae_state *_state);


/*************************************************************************
Function for testing multyplication for simmetric matrix with vector

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionsstest(ae_state *_state);


/*************************************************************************
Function for testing multyplication sparse matrix with nerrow dense matrix

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionsmmtest(ae_state *_state);


/*************************************************************************
Function for testing multyplication for simmetric sparse matrix with narrow
dense matrix

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionssmmtest(ae_state *_state);


/*************************************************************************
Function for basic test SparseCopy

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basiccopyfunctest(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for testing SparseCopy

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool copyfunctest(ae_bool silent, ae_state *_state);
void _sparsegenerator_init(void* _p, ae_state *_state, ae_bool make_automatic);
void _sparsegenerator_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic);
void _sparsegenerator_clear(void* _p);
void _sparsegenerator_destroy(void* _p);








ae_bool testblas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testblas(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing symmetric EVD subroutine
*************************************************************************/
ae_bool testevd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testevd(ae_bool silent, ae_state *_state);








ae_bool testtrfac(ae_bool silent, ae_state *_state);
ae_bool _pexec_testtrfac(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for testing sparse real Cholesky.
Returns True on errors, False on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
ae_bool sparserealcholeskytest(ae_state *_state);


/*************************************************************************
Function for testing sparse real LU decomposition.
Sets error flag on failure, leave is unchanged on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
void sparsereallutest(ae_bool* err, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testpolynomialsolver(ae_bool silent, ae_state *_state);
ae_bool _pexec_testpolynomialsolver(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing bidiagonal SVD decomposition subroutine
*************************************************************************/
ae_bool testbdsvd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testbdsvd(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing SVD decomposition subroutine
*************************************************************************/
ae_bool testsvd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsvd(ae_bool silent, ae_state *_state);








/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testtrlinsolve(ae_bool silent, ae_state *_state);
ae_bool _pexec_testtrlinsolve(ae_bool silent, ae_state *_state);








/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testsafesolve(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsafesolve(ae_bool silent, ae_state *_state);








ae_bool testrcond(ae_bool silent, ae_state *_state);
ae_bool _pexec_testrcond(ae_bool silent, ae_state *_state);








ae_bool testxblas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testxblas(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testdirectdensesolvers(ae_bool silent, ae_state *_state);
ae_bool _pexec_testdirectdensesolvers(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testdirectsparsesolvers(ae_bool silent, ae_state *_state);
ae_bool _pexec_testdirectsparsesolvers(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing
*************************************************************************/
ae_bool testfbls(ae_bool silent, ae_state *_state);
ae_bool _pexec_testfbls(ae_bool silent, ae_state *_state);








ae_bool testiterativesparse(ae_bool silent, ae_state *_state);
ae_bool _pexec_testiterativesparse(ae_bool silent, ae_state *_state);








ae_bool testlincg(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlincg(ae_bool silent, ae_state *_state);








ae_bool testnormestimator(ae_bool silent, ae_state *_state);
ae_bool _pexec_testnormestimator(ae_bool silent, ae_state *_state);








ae_bool testlinlsqr(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlinlsqr(ae_bool silent, ae_state *_state);








ae_bool testlinmin(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlinmin(ae_bool silent, ae_state *_state);








ae_bool testnleq(ae_bool silent, ae_state *_state);
ae_bool _pexec_testnleq(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testmatinv(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmatinv(ae_bool silent, ae_state *_state);








ae_bool testoptserv(ae_bool silent, ae_state *_state);
ae_bool _pexec_testoptserv(ae_bool silent, ae_state *_state);








ae_bool testminlbfgs(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminlbfgs(ae_bool silent, ae_state *_state);








ae_bool testcqmodels(ae_bool silent, ae_state *_state);
ae_bool _pexec_testcqmodels(ae_bool silent, ae_state *_state);








ae_bool testsnnls(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsnnls(ae_bool silent, ae_state *_state);








ae_bool testsactivesets(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsactivesets(ae_bool silent, ae_state *_state);








ae_bool testminbleic(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminbleic(ae_bool silent, ae_state *_state);








ae_bool testminqp(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminqp(ae_bool silent, ae_state *_state);


/*************************************************************************
Function to test: 'MinQPCreate', 'MinQPSetQuadraticTerm', 'MinQPSetBC', 
'MinQPSetOrigin', 'MinQPSetStartingPoint', 'MinQPOptimize', 'MinQPResults'.

Test problem:
    A = diag(aii), aii>0 (random)
    b = 0
    random bounds (either no bounds, one bound, two bounds a<b, two bounds a=b)
    random start point
    dimension - from 1 to 5.
    
Returns True on success, False on failure.
*************************************************************************/
ae_bool simpletest(ae_state *_state);


/*************************************************************************
Function to test: 'MinQPCreate', 'MinQPSetLinearTerm', 'MinQPSetQuadraticTerm',
'MinQPSetOrigin', 'MinQPSetStartingPoint', 'MinQPOptimize', 'MinQPResults'.

Test problem:
    A = positive-definite matrix, obtained by 'SPDMatrixRndCond' function
    b <> 0
    without bounds
    random start point
    dimension - from 1 to 5.
*************************************************************************/
ae_bool functest1(ae_state *_state);


/*************************************************************************
Function to test: 'MinQPCreate', 'MinQPSetLinearTerm', 'MinQPSetQuadraticTerm',
'MinQPSetBC', 'MinQPSetOrigin', 'MinQPSetStartingPoint', 'MinQPOptimize', 
'MinQPResults'.

Test problem:
    A = positive-definite matrix, obtained by 'SPDMatrixRndCond' function
    b <> 0
    boundary constraints
    random start point
    dimension - from 1 to 5.
*************************************************************************/
ae_bool functest2(ae_state *_state);


/*************************************************************************
ConsoleTest.
*************************************************************************/
ae_bool consoletest(ae_state *_state);


/*************************************************************************
This function performs tests specific for QuickQP solver
    
Returns True on failure.
*************************************************************************/
ae_bool quickqptests(ae_state *_state);


/*************************************************************************
This function performs tests specific for BLEIC solver
    
Returns True on error, False on success.
*************************************************************************/
ae_bool bleictests(ae_state *_state);








ae_bool testminlm(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminlm(ae_bool silent, ae_state *_state);








ae_bool testmincg(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmincg(ae_bool silent, ae_state *_state);


/*************************************************************************
Other properties
*************************************************************************/
void testother(ae_bool* err, ae_state *_state);








ae_bool testminlp(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminlp(ae_bool silent, ae_state *_state);








ae_bool testminnlc(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminnlc(ae_bool silent, ae_state *_state);








ae_bool testminns(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminns(ae_bool silent, ae_state *_state);








ae_bool testminbc(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminbc(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing Nearest Neighbor Search
*************************************************************************/
ae_bool testnearestneighbor(ae_bool silent, ae_state *_state);
ae_bool _pexec_testnearestneighbor(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testodesolver(ae_bool silent, ae_state *_state);
ae_bool _pexec_testodesolver(ae_bool silent, ae_state *_state);








ae_bool testinverseupdate(ae_bool silent, ae_state *_state);
ae_bool _pexec_testinverseupdate(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing Schur decomposition subroutine
*************************************************************************/
ae_bool testschur(ae_bool silent, ae_state *_state);
ae_bool _pexec_testschur(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing bidiagonal SVD decomposition subroutine
*************************************************************************/
ae_bool testspdgevd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testspdgevd(ae_bool silent, ae_state *_state);








ae_bool testgammafunc(ae_bool silent, ae_state *_state);
ae_bool _pexec_testgammafunc(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testgq(ae_bool silent, ae_state *_state);
ae_bool _pexec_testgq(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testgkq(ae_bool silent, ae_state *_state);
ae_bool _pexec_testgkq(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testautogk(ae_bool silent, ae_state *_state);
ae_bool _pexec_testautogk(ae_bool silent, ae_state *_state);








ae_bool testnormaldistr(ae_bool silent, ae_state *_state);
ae_bool _pexec_testnormaldistr(ae_bool silent, ae_state *_state);








ae_bool testbasestat(ae_bool silent, ae_state *_state);
ae_bool _pexec_testbasestat(ae_bool silent, ae_state *_state);








ae_bool testwsr(ae_bool silent, ae_state *_state);
ae_bool _pexec_testwsr(ae_bool silent, ae_state *_state);








ae_bool testmannwhitneyu(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmannwhitneyu(ae_bool silent, ae_state *_state);








ae_bool teststest(ae_bool silent, ae_state *_state);
ae_bool _pexec_teststest(ae_bool silent, ae_state *_state);








ae_bool teststudentttests(ae_bool silent, ae_state *_state);
ae_bool _pexec_teststudentttests(ae_bool silent, ae_state *_state);








ae_bool testratint(ae_bool silent, ae_state *_state);
ae_bool _pexec_testratint(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing IDW interpolation
*************************************************************************/
ae_bool testidw(ae_bool silent, ae_state *_state);
ae_bool _pexec_testidw(ae_bool silent, ae_state *_state);








/*************************************************************************
Unit test
*************************************************************************/
ae_bool testpolint(ae_bool silent, ae_state *_state);
ae_bool _pexec_testpolint(ae_bool silent, ae_state *_state);








ae_bool testspline1d(ae_bool silent, ae_state *_state);
ae_bool _pexec_testspline1d(ae_bool silent, ae_state *_state);








ae_bool testlsfit(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlsfit(ae_bool silent, ae_state *_state);








ae_bool testfitsphere(ae_bool silent, ae_state *_state);
ae_bool _pexec_testfitsphere(ae_bool silent, ae_state *_state);








ae_bool testparametric(ae_bool silent, ae_state *_state);
ae_bool _pexec_testparametric(ae_bool silent, ae_state *_state);








ae_bool testspline2d(ae_bool silent, ae_state *_state);
ae_bool _pexec_testspline2d(ae_bool silent, ae_state *_state);








ae_bool testspline3d(ae_bool silence, ae_state *_state);
ae_bool _pexec_testspline3d(ae_bool silence, ae_state *_state);








ae_bool testrbf(ae_bool silent, ae_state *_state);
ae_bool _pexec_testrbf(ae_bool silent, ae_state *_state);


/*************************************************************************
The test  has  to  check, that  algorithm can solve problems of matrix are
degenerate.
    * used model with linear term;
    * points locate in a subspace of dimension less than an original space.

  -- ALGLIB --
     Copyright 13.12.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool sqrdegmatrixrbftest(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for testing basic functionality of RBF module on regular grids with
multi-layer algorithm in 1D.

  -- ALGLIB --
     Copyright 2.03.2012 by Bochkanov Sergey
*************************************************************************/
ae_bool basicmultilayerrbf1dtest(ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testfft(ae_bool silent, ae_state *_state);
ae_bool _pexec_testfft(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testfht(ae_bool silent, ae_state *_state);
ae_bool _pexec_testfht(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testconv(ae_bool silent, ae_state *_state);
ae_bool _pexec_testconv(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testcorr(ae_bool silent, ae_state *_state);
ae_bool _pexec_testcorr(ae_bool silent, ae_state *_state);








ae_bool testchebyshev(ae_bool silent, ae_state *_state);
ae_bool _pexec_testchebyshev(ae_bool silent, ae_state *_state);








ae_bool testhermite(ae_bool silent, ae_state *_state);
ae_bool _pexec_testhermite(ae_bool silent, ae_state *_state);








ae_bool testlegendre(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlegendre(ae_bool silent, ae_state *_state);








ae_bool testlaguerre(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlaguerre(ae_bool silent, ae_state *_state);








ae_bool testpca(ae_bool silent, ae_state *_state);
ae_bool _pexec_testpca(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing BDSS operations
*************************************************************************/
ae_bool testbdss(ae_bool silent, ae_state *_state);
ae_bool _pexec_testbdss(ae_bool silent, ae_state *_state);








ae_bool testmlpbase(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmlpbase(ae_bool silent, ae_state *_state);








ae_bool testmlpe(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmlpe(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing clustering
*************************************************************************/
ae_bool testclustering(ae_bool silent, ae_state *_state);
ae_bool _pexec_testclustering(ae_bool silent, ae_state *_state);








ae_bool testdforest(ae_bool silent, ae_state *_state);
ae_bool _pexec_testdforest(ae_bool silent, ae_state *_state);








ae_bool testlinreg(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlinreg(ae_bool silent, ae_state *_state);








ae_bool testfilters(ae_bool silent, ae_state *_state);
ae_bool _pexec_testfilters(ae_bool silent, ae_state *_state);


/*************************************************************************
This function tests SMA(k) filter. It returns True on error.

Additional IsSilent parameter controls detailed error reporting.
*************************************************************************/
ae_bool testsma(ae_bool issilent, ae_state *_state);


/*************************************************************************
This function tests EMA(alpha) filter. It returns True on error.

Additional IsSilent parameter controls detailed error reporting.
*************************************************************************/
ae_bool testema(ae_bool issilent, ae_state *_state);


/*************************************************************************
This function tests LRMA(k) filter. It returns True on error.

Additional IsSilent parameter controls detailed error reporting.
*************************************************************************/
ae_bool testlrma(ae_bool issilent, ae_state *_state);








ae_bool testssa(ae_bool silent, ae_state *_state);
ae_bool _pexec_testssa(ae_bool silent, ae_state *_state);








ae_bool testlda(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlda(ae_bool silent, ae_state *_state);








ae_bool testmcpd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmcpd(ae_bool silent, ae_state *_state);








ae_bool testknn(ae_bool silent, ae_state *_state);
ae_bool _pexec_testknn(ae_bool silent, ae_state *_state);








ae_bool testmlptrain(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmlptrain(ae_bool silent, ae_state *_state);





typedef struct
{
    ae_bool bfield;
    double rfield;
    ae_int_t ifield;
    ae_complex cfield;
    ae_vector b1field;
    ae_vector r1field;
    ae_vector i1field;
    ae_vector c1field;
    ae_matrix b2field;
    ae_matrix r2field;
    ae_matrix i2field;
    ae_matrix c2field;
} rec1;


typedef struct
{
    ae_vector b;
    ae_vector i;
    ae_vector r;
} rec4serialization;


typedef struct
{
    ae_complex cval;
    double rval;
    ae_int_t ival;
    ae_bool bval;
    ae_vector i1val;
} poolrec1;


typedef struct
{
    ae_bool bval;
    poolrec1 recval;
    ae_shared_pool pool;
} poolrec2;


typedef struct
{
    ae_int_t val;
} poolsummand;





void rec4serializationalloc(ae_serializer* s,
     rec4serialization* v,
     ae_state *_state);


void rec4serializationserialize(ae_serializer* s,
     rec4serialization* v,
     ae_state *_state);


void rec4serializationunserialize(ae_serializer* s,
     rec4serialization* v,
     ae_state *_state);


ae_bool testalglibbasics(ae_bool silent, ae_state *_state);
ae_bool _pexec_testalglibbasics(ae_bool silent, ae_state *_state);
void _rec1_init(void* _p, ae_state *_state, ae_bool make_automatic);
void _rec1_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic);
void _rec1_clear(void* _p);
void _rec1_destroy(void* _p);
void _rec4serialization_init(void* _p, ae_state *_state, ae_bool make_automatic);
void _rec4serialization_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic);
void _rec4serialization_clear(void* _p);
void _rec4serialization_destroy(void* _p);
void _poolrec1_init(void* _p, ae_state *_state, ae_bool make_automatic);
void _poolrec1_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic);
void _poolrec1_clear(void* _p);
void _poolrec1_destroy(void* _p);
void _poolrec2_init(void* _p, ae_state *_state, ae_bool make_automatic);
void _poolrec2_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic);
void _poolrec2_clear(void* _p);
void _poolrec2_destroy(void* _p);
void _poolsummand_init(void* _p, ae_state *_state, ae_bool make_automatic);
void _poolsummand_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic);
void _poolsummand_clear(void* _p);
void _poolsummand_destroy(void* _p);




static ae_bool testablasfunit_testxdot(ae_int_t maxn,
     double tol,
     ae_state *_state);
static ae_bool testablasfunit_testxset(ae_int_t maxn,
     double tol,
     ae_state *_state);
static ae_bool testablasfunit_testxadd(ae_int_t maxn,
     double tol,
     ae_state *_state);
static ae_bool testablasfunit_testxmul(ae_int_t maxn,
     double tol,
     ae_state *_state);
static ae_bool testablasfunit_testxmax(ae_int_t maxn,
     double tol,
     ae_state *_state);
static ae_bool testablasfunit_testxmerge(ae_int_t maxn,
     double tol,
     ae_state *_state);
static ae_bool testablasfunit_testxcopy(ae_int_t maxn,
     double tol,
     ae_state *_state);
static ae_bool testablasfunit_testxgemv(ae_int_t maxn,
     double tol,
     ae_state *_state);
static ae_bool testablasfunit_testxger(ae_int_t maxn,
     double tol,
     ae_state *_state);
static ae_bool testablasfunit_testxtrsv(ae_int_t maxn,
     double tol,
     ae_state *_state);
static void testablasfunit_initplayground(ae_int_t minlen,
     ae_int_t iseed,
     ablasfplayground* s,
     ae_state *_state);
static double testablasfunit_compareplaygrounds(ablasfplayground* s0,
     ablasfplayground* s1,
     ae_state *_state);
static ae_int_t testablasfunit_pseudorandominit1(/* Real    */ ae_vector* x,
     ae_int_t iseed,
     ae_state *_state);
static ae_int_t testablasfunit_pseudorandominit1i(/* Integer */ ae_vector* x,
     ae_int_t iseed,
     ae_state *_state);
static ae_int_t testablasfunit_pseudorandominit1b(/* Boolean */ ae_vector* x,
     ae_int_t iseed,
     ae_state *_state);
static ae_int_t testablasfunit_pseudorandominit2(/* Real    */ ae_matrix* x,
     ae_int_t iseed,
     ae_state *_state);
static double testablasfunit_rmx3(double r0,
     double r1,
     double r2,
     ae_state *_state);
static double testablasfunit_rcmp1(/* Real    */ ae_vector* x,
     /* Real    */ ae_vector* y,
     ae_state *_state);
static double testablasfunit_icmp1(/* Integer */ ae_vector* x,
     /* Integer */ ae_vector* y,
     ae_state *_state);
static double testablasfunit_bcmp1(/* Boolean */ ae_vector* x,
     /* Boolean */ ae_vector* y,
     ae_state *_state);
static double testablasfunit_rcmp2(/* Real    */ ae_matrix* x,
     /* Real    */ ae_matrix* y,
     ae_state *_state);
static void testablasfunit_refgerx(ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     double alpha,
     /* Real    */ ae_vector* u,
     ae_int_t iu,
     /* Real    */ ae_vector* v,
     ae_int_t iv,
     ae_state *_state);





ae_bool testablasf(ae_bool silent, ae_state *_state)
{
    ae_int_t maxn;
    double tol;
    ae_bool wereerrors;
    ae_bool xdoterrors;
    ae_bool xseterrors;
    ae_bool xadderrors;
    ae_bool xmulerrors;
    ae_bool xmaxerrors;
    ae_bool xmergeerrors;
    ae_bool xcopyerrors;
    ae_bool xgemverrors;
    ae_bool xgererrors;
    ae_bool xtrsverrors;
    ae_bool result;


    maxn = 100;
    tol = 10000*ae_machineepsilon;
    xdoterrors = testablasfunit_testxdot(maxn, tol, _state);
    xseterrors = testablasfunit_testxset(maxn, tol, _state);
    xadderrors = testablasfunit_testxadd(maxn, tol, _state);
    xmulerrors = testablasfunit_testxmul(maxn, tol, _state);
    xmaxerrors = testablasfunit_testxmax(maxn, tol, _state);
    xmergeerrors = testablasfunit_testxmerge(maxn, tol, _state);
    xcopyerrors = testablasfunit_testxcopy(maxn, tol, _state);
    xgemverrors = testablasfunit_testxgemv(maxn, tol, _state);
    xgererrors = testablasfunit_testxger(maxn, tol, _state);
    xtrsverrors = testablasfunit_testxtrsv(maxn, tol, _state);
    wereerrors = ((((((((xdoterrors||xseterrors)||xadderrors)||xmulerrors)||xmaxerrors)||xmergeerrors)||xcopyerrors)||xgemverrors)||xgererrors)||xtrsverrors;
    
    /*
     * report
     */
    if( !silent )
    {
        printf("TESTING ABLASF\n");
        printf("xDotXX:                                  ");
        if( xdoterrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("xSetXX:                                  ");
        if( xseterrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("xAddXX:                                  ");
        if( xadderrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("xMulXX:                                  ");
        if( xmulerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("xMaxXX:                                  ");
        if( xmaxerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("xMergeXX:                                ");
        if( xmergeerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("xCopyXX:                                 ");
        if( xcopyerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("xGEMVx:                                  ");
        if( xgemverrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("xGERx:                                   ");
        if( xgererrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("xTRSVx:                                  ");
        if( xtrsverrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( wereerrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !wereerrors;
    return result;
}


double refrdotv(ae_int_t n,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_vector* y,
     ae_state *_state)
{
    ae_int_t i;
    double result;


    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        result = result+x->ptr.p_double[i]*y->ptr.p_double[i];
    }
    return result;
}


double refrdotvr(ae_int_t n,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_matrix* a,
     ae_int_t i,
     ae_state *_state)
{
    ae_int_t j;
    double result;


    result = (double)(0);
    for(j=0; j<=n-1; j++)
    {
        result = result+x->ptr.p_double[j]*a->ptr.pp_double[i][j];
    }
    return result;
}


double refrdotrr(ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     /* Real    */ ae_matrix* b,
     ae_int_t ib,
     ae_state *_state)
{
    ae_int_t j;
    double result;


    result = (double)(0);
    for(j=0; j<=n-1; j++)
    {
        result = result+a->ptr.pp_double[ia][j]*b->ptr.pp_double[ib][j];
    }
    return result;
}


double refrdotv2(ae_int_t n, /* Real    */ ae_vector* x, ae_state *_state)
{
    ae_int_t i;
    double v;
    double result;


    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        v = x->ptr.p_double[i];
        result = result+v*v;
    }
    return result;
}


void refraddv(ae_int_t n,
     double alpha,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.p_double[i] = x->ptr.p_double[i]+alpha*y->ptr.p_double[i];
    }
}


void refraddvx(ae_int_t n,
     double alpha,
     /* Real    */ ae_vector* y,
     ae_int_t offsy,
     /* Real    */ ae_vector* x,
     ae_int_t offsx,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.p_double[offsx+i] = x->ptr.p_double[offsx+i]+alpha*y->ptr.p_double[offsy+i];
    }
}


void refraddvc(ae_int_t n,
     double alpha,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_matrix* x,
     ae_int_t colidx,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.pp_double[i][colidx] = x->ptr.pp_double[i][colidx]+alpha*y->ptr.p_double[i];
    }
}


void refraddvr(ae_int_t n,
     double alpha,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_matrix* x,
     ae_int_t rowidx,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.pp_double[rowidx][i] = x->ptr.pp_double[rowidx][i]+alpha*y->ptr.p_double[i];
    }
}


void refraddrv(ae_int_t n,
     double alpha,
     /* Real    */ ae_matrix* y,
     ae_int_t ridx,
     /* Real    */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.p_double[i] = x->ptr.p_double[i]+alpha*y->ptr.pp_double[ridx][i];
    }
}


void refraddrr(ae_int_t n,
     double alpha,
     /* Real    */ ae_matrix* y,
     ae_int_t ridxsrc,
     /* Real    */ ae_matrix* x,
     ae_int_t ridxdst,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.pp_double[ridxdst][i] = x->ptr.pp_double[ridxdst][i]+alpha*y->ptr.pp_double[ridxsrc][i];
    }
}


void refrsetv(ae_int_t n,
     double v,
     /* Real    */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t j;


    for(j=0; j<=n-1; j++)
    {
        x->ptr.p_double[j] = v;
    }
}


void refrsetvx(ae_int_t n,
     double v,
     /* Real    */ ae_vector* x,
     ae_int_t offsx,
     ae_state *_state)
{
    ae_int_t j;


    for(j=0; j<=n-1; j++)
    {
        x->ptr.p_double[offsx+j] = v;
    }
}


void refisetv(ae_int_t n,
     ae_int_t v,
     /* Integer */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t j;


    for(j=0; j<=n-1; j++)
    {
        x->ptr.p_int[j] = v;
    }
}


void refbsetv(ae_int_t n,
     ae_bool v,
     /* Boolean */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t j;


    for(j=0; j<=n-1; j++)
    {
        x->ptr.p_bool[j] = v;
    }
}


void refrsetm(ae_int_t m,
     ae_int_t n,
     double v,
     /* Real    */ ae_matrix* a,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a->ptr.pp_double[i][j] = v;
        }
    }
}


void refrsetr(ae_int_t n,
     double v,
     /* Real    */ ae_matrix* a,
     ae_int_t i,
     ae_state *_state)
{
    ae_int_t j;


    for(j=0; j<=n-1; j++)
    {
        a->ptr.pp_double[i][j] = v;
    }
}


void refrsetc(ae_int_t n,
     double v,
     /* Real    */ ae_matrix* a,
     ae_int_t j,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        a->ptr.pp_double[i][j] = v;
    }
}


void refrcopyv(ae_int_t n,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_vector* y,
     ae_state *_state)
{
    ae_int_t j;


    for(j=0; j<=n-1; j++)
    {
        y->ptr.p_double[j] = x->ptr.p_double[j];
    }
}


void refbcopyv(ae_int_t n,
     /* Boolean */ ae_vector* x,
     /* Boolean */ ae_vector* y,
     ae_state *_state)
{
    ae_int_t j;


    for(j=0; j<=n-1; j++)
    {
        y->ptr.p_bool[j] = x->ptr.p_bool[j];
    }
}


void refrcopyvx(ae_int_t n,
     /* Real    */ ae_vector* x,
     ae_int_t offsx,
     /* Real    */ ae_vector* y,
     ae_int_t offsy,
     ae_state *_state)
{
    ae_int_t j;


    for(j=0; j<=n-1; j++)
    {
        y->ptr.p_double[offsy+j] = x->ptr.p_double[offsx+j];
    }
}


void reficopyv(ae_int_t n,
     /* Integer */ ae_vector* x,
     /* Integer */ ae_vector* y,
     ae_state *_state)
{
    ae_int_t j;


    for(j=0; j<=n-1; j++)
    {
        y->ptr.p_int[j] = x->ptr.p_int[j];
    }
}


void reficopyvx(ae_int_t n,
     /* Integer */ ae_vector* x,
     ae_int_t offsx,
     /* Integer */ ae_vector* y,
     ae_int_t offsy,
     ae_state *_state)
{
    ae_int_t j;


    for(j=0; j<=n-1; j++)
    {
        y->ptr.p_int[offsy+j] = x->ptr.p_int[offsx+j];
    }
}


void refrcopyvr(ae_int_t n,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_matrix* a,
     ae_int_t i,
     ae_state *_state)
{
    ae_int_t j;


    for(j=0; j<=n-1; j++)
    {
        a->ptr.pp_double[i][j] = x->ptr.p_double[j];
    }
}


void refrcopyrv(ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i,
     /* Real    */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t j;


    for(j=0; j<=n-1; j++)
    {
        x->ptr.p_double[j] = a->ptr.pp_double[i][j];
    }
}


void refrcopyrr(ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i,
     /* Real    */ ae_matrix* b,
     ae_int_t k,
     ae_state *_state)
{
    ae_int_t j;


    for(j=0; j<=n-1; j++)
    {
        b->ptr.pp_double[k][j] = a->ptr.pp_double[i][j];
    }
}


void refrcopyvc(ae_int_t n,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_matrix* a,
     ae_int_t j,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        a->ptr.pp_double[i][j] = x->ptr.p_double[i];
    }
}


void refrcopycv(ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t j,
     /* Real    */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.p_double[i] = a->ptr.pp_double[i][j];
    }
}


void refrcopymulv(ae_int_t n,
     double v,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_vector* y,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        y->ptr.p_double[i] = v*x->ptr.p_double[i];
    }
}


void refrcopymulvr(ae_int_t n,
     double v,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_matrix* y,
     ae_int_t ridx,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        y->ptr.pp_double[ridx][i] = v*x->ptr.p_double[i];
    }
}


void refrcopymulvc(ae_int_t n,
     double v,
     /* Real    */ ae_vector* x,
     /* Real    */ ae_matrix* y,
     ae_int_t cidx,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        y->ptr.pp_double[i][cidx] = v*x->ptr.p_double[i];
    }
}


void refrmulv(ae_int_t n,
     double v,
     /* Real    */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.p_double[i] = x->ptr.p_double[i]*v;
    }
}


void refrmulr(ae_int_t n,
     double v,
     /* Real    */ ae_matrix* x,
     ae_int_t rowidx,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.pp_double[rowidx][i] = x->ptr.pp_double[rowidx][i]*v;
    }
}


void refrmulvx(ae_int_t n,
     double v,
     /* Real    */ ae_vector* x,
     ae_int_t offsx,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.p_double[offsx+i] = x->ptr.p_double[offsx+i]*v;
    }
}


void refrmergemulv(ae_int_t n,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.p_double[i] = x->ptr.p_double[i]*y->ptr.p_double[i];
    }
}


void refrmergemulvr(ae_int_t n,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_matrix* x,
     ae_int_t rowidx,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.pp_double[rowidx][i] = x->ptr.pp_double[rowidx][i]*y->ptr.p_double[i];
    }
}


void refrmergemulrv(ae_int_t n,
     /* Real    */ ae_matrix* y,
     ae_int_t rowidx,
     /* Real    */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.p_double[i] = x->ptr.p_double[i]*y->ptr.pp_double[rowidx][i];
    }
}


void refrmergemaxv(ae_int_t n,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.p_double[i] = ae_maxreal(x->ptr.p_double[i], y->ptr.p_double[i], _state);
    }
}


void refrmergemaxvr(ae_int_t n,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_matrix* x,
     ae_int_t rowidx,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.pp_double[rowidx][i] = ae_maxreal(x->ptr.pp_double[rowidx][i], y->ptr.p_double[i], _state);
    }
}


void refrmergemaxrv(ae_int_t n,
     /* Real    */ ae_matrix* y,
     ae_int_t rowidx,
     /* Real    */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.p_double[i] = ae_maxreal(x->ptr.p_double[i], y->ptr.pp_double[rowidx][i], _state);
    }
}


void refrmergeminv(ae_int_t n,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.p_double[i] = ae_minreal(x->ptr.p_double[i], y->ptr.p_double[i], _state);
    }
}


void refrmergeminvr(ae_int_t n,
     /* Real    */ ae_vector* y,
     /* Real    */ ae_matrix* x,
     ae_int_t rowidx,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.pp_double[rowidx][i] = ae_minreal(x->ptr.pp_double[rowidx][i], y->ptr.p_double[i], _state);
    }
}


void refrmergeminrv(ae_int_t n,
     /* Real    */ ae_matrix* y,
     ae_int_t rowidx,
     /* Real    */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        x->ptr.p_double[i] = ae_minreal(x->ptr.p_double[i], y->ptr.pp_double[rowidx][i], _state);
    }
}


double refrmaxv(ae_int_t n, /* Real    */ ae_vector* x, ae_state *_state)
{
    ae_int_t i;
    double v;
    double result;


    if( n<=0 )
    {
        result = (double)(0);
        return result;
    }
    result = x->ptr.p_double[0];
    for(i=0; i<=n-1; i++)
    {
        v = x->ptr.p_double[i];
        if( v>result )
        {
            result = v;
        }
    }
    return result;
}


double refrmaxabsv(ae_int_t n,
     /* Real    */ ae_vector* x,
     ae_state *_state)
{
    ae_int_t i;
    double v;
    double result;


    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        v = ae_fabs(x->ptr.p_double[i], _state);
        if( v>result )
        {
            result = v;
        }
    }
    return result;
}


double refrmaxr(ae_int_t n,
     /* Real    */ ae_matrix* x,
     ae_int_t rowidx,
     ae_state *_state)
{
    ae_int_t i;
    double v;
    double result;


    if( n<=0 )
    {
        result = (double)(0);
        return result;
    }
    result = x->ptr.pp_double[rowidx][0];
    for(i=0; i<=n-1; i++)
    {
        v = x->ptr.pp_double[rowidx][i];
        if( v>result )
        {
            result = v;
        }
    }
    return result;
}


double refrmaxabsr(ae_int_t n,
     /* Real    */ ae_matrix* x,
     ae_int_t rowidx,
     ae_state *_state)
{
    ae_int_t i;
    double v;
    double result;


    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        v = ae_fabs(x->ptr.pp_double[rowidx][i], _state);
        if( v>result )
        {
            result = v;
        }
    }
    return result;
}


void refrgemvx(ae_int_t m,
     ae_int_t n,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t opa,
     /* Real    */ ae_vector* x,
     ae_int_t ix,
     double beta,
     /* Real    */ ae_vector* y,
     ae_int_t iy,
     ae_state *_state)
{
    ae_int_t i;
    double v;


    
    /*
     * Quick exit for M=0, N=0 or Alpha=0.
     *
     * After this block we have M>0, N>0, Alpha<>0.
     */
    if( m<=0 )
    {
        return;
    }
    if( n<=0||ae_fp_eq(alpha,0.0) )
    {
        if( ae_fp_neq(beta,(double)(0)) )
        {
            for(i=0; i<=m-1; i++)
            {
                y->ptr.p_double[iy+i] = beta*y->ptr.p_double[iy+i];
            }
        }
        else
        {
            for(i=0; i<=m-1; i++)
            {
                y->ptr.p_double[iy+i] = 0.0;
            }
        }
        return;
    }
    
    /*
     * Generic code
     */
    if( opa==0 )
    {
        
        /*
         * y = A*x
         */
        for(i=0; i<=m-1; i++)
        {
            v = ae_v_dotproduct(&a->ptr.pp_double[ia+i][ja], 1, &x->ptr.p_double[ix], 1, ae_v_len(ja,ja+n-1));
            if( ae_fp_eq(beta,0.0) )
            {
                y->ptr.p_double[iy+i] = alpha*v;
            }
            else
            {
                y->ptr.p_double[iy+i] = alpha*v+beta*y->ptr.p_double[iy+i];
            }
        }
        return;
    }
    if( opa==1 )
    {
        
        /*
         * Prepare output array
         */
        if( ae_fp_eq(beta,0.0) )
        {
            for(i=0; i<=m-1; i++)
            {
                y->ptr.p_double[iy+i] = (double)(0);
            }
        }
        else
        {
            for(i=0; i<=m-1; i++)
            {
                y->ptr.p_double[iy+i] = beta*y->ptr.p_double[iy+i];
            }
        }
        
        /*
         * y += A^T*x
         */
        for(i=0; i<=n-1; i++)
        {
            v = alpha*x->ptr.p_double[ix+i];
            ae_v_addd(&y->ptr.p_double[iy], 1, &a->ptr.pp_double[ia+i][ja], 1, ae_v_len(iy,iy+m-1), v);
        }
        return;
    }
}


/*************************************************************************
Reference TRSV
*************************************************************************/
void reftrsvx(ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Real    */ ae_vector* x,
     ae_int_t ix,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    double v;


    
    /*
     * Quick exit
     */
    if( n<=0 )
    {
        return;
    }
    
    /*
     * Generic code
     */
    if( optype==0&&isupper )
    {
        for(i=n-1; i>=0; i--)
        {
            v = x->ptr.p_double[ix+i];
            for(j=i+1; j<=n-1; j++)
            {
                v = v-a->ptr.pp_double[ia+i][ja+j]*x->ptr.p_double[ix+j];
            }
            if( !isunit )
            {
                v = v/a->ptr.pp_double[ia+i][ja+i];
            }
            x->ptr.p_double[ix+i] = v;
        }
        return;
    }
    if( optype==0&&!isupper )
    {
        for(i=0; i<=n-1; i++)
        {
            v = x->ptr.p_double[ix+i];
            for(j=0; j<=i-1; j++)
            {
                v = v-a->ptr.pp_double[ia+i][ja+j]*x->ptr.p_double[ix+j];
            }
            if( !isunit )
            {
                v = v/a->ptr.pp_double[ia+i][ja+i];
            }
            x->ptr.p_double[ix+i] = v;
        }
        return;
    }
    if( optype==1&&isupper )
    {
        for(i=0; i<=n-1; i++)
        {
            v = x->ptr.p_double[ix+i];
            if( !isunit )
            {
                v = v/a->ptr.pp_double[ia+i][ja+i];
            }
            x->ptr.p_double[ix+i] = v;
            if( v==0 )
            {
                continue;
            }
            for(j=i+1; j<=n-1; j++)
            {
                x->ptr.p_double[ix+j] = x->ptr.p_double[ix+j]-v*a->ptr.pp_double[ia+i][ja+j];
            }
        }
        return;
    }
    if( optype==1&&!isupper )
    {
        for(i=n-1; i>=0; i--)
        {
            v = x->ptr.p_double[ix+i];
            if( !isunit )
            {
                v = v/a->ptr.pp_double[ia+i][ja+i];
            }
            x->ptr.p_double[ix+i] = v;
            if( v==0 )
            {
                continue;
            }
            for(j=0; j<=i-1; j++)
            {
                x->ptr.p_double[ix+j] = x->ptr.p_double[ix+j]-v*a->ptr.pp_double[ia+i][ja+j];
            }
        }
        return;
    }
    ae_assert(ae_false, "RMatrixTRSV: unexpected operation type", _state);
}


static ae_bool testablasfunit_testxdot(ae_int_t maxn,
     double tol,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t iseed;
    ae_int_t ridx;
    ae_int_t ridx2;
    ablasfplayground s0;
    ablasfplayground s1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    _ablasfplayground_init(&s0, _state, ae_true);
    _ablasfplayground_init(&s1, _state, ae_true);

    iseed = ae_randominteger(10000, _state);
    result = ae_false;
    for(n=0; n<=maxn; n++)
    {
        
        /*
         * Prepare two identical playground structures
         */
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        iseed = iseed+1;
        
        /*
         * Compute each rDot version twice - reference vs library.
         * Compare playground snapshots - should be identical.
         */
        ridx = ae_randominteger(ae_maxint(n, 1, _state), _state);
        ridx2 = ae_randominteger(ae_maxint(n, 1, _state), _state);
        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(rdotv(n, &s0.x0, &s0.x1, _state)-refrdotv(n, &s1.x0, &s1.x1, _state), _state),tol), __FILE__, __LINE__, "testablasfunit.ap:142");
        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(rdotvr(n, &s0.x0, &s0.a0, ridx, _state)-refrdotvr(n, &s1.x0, &s1.a0, ridx, _state), _state),tol), __FILE__, __LINE__, "testablasfunit.ap:143");
        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(rdotrr(n, &s0.a0, ridx, &s0.a1, ridx2, _state)-refrdotrr(n, &s1.a0, ridx, &s1.a1, ridx2, _state), _state),tol), __FILE__, __LINE__, "testablasfunit.ap:144");
        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(rdotv2(n, &s0.x0, _state)-refrdotv2(n, &s1.x0, _state), _state),tol), __FILE__, __LINE__, "testablasfunit.ap:145");
    }
    ae_frame_leave(_state);
    return result;
}


static ae_bool testablasfunit_testxset(ae_int_t maxn,
     double tol,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t iseed;
    double alpha;
    ae_int_t ialpha;
    ae_bool balpha;
    ae_int_t ridx;
    ae_int_t cidx;
    ae_int_t m0;
    ae_int_t m1;
    ae_int_t offsx;
    ablasfplayground s0;
    ablasfplayground s1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    _ablasfplayground_init(&s0, _state, ae_true);
    _ablasfplayground_init(&s1, _state, ae_true);

    iseed = ae_randominteger(10000, _state);
    result = ae_false;
    for(n=0; n<=maxn; n++)
    {
        
        /*
         * Prepare two identical playground structures
         * Compute each xSetXX version twice - reference vs library.
         * Compare playground snapshots - should be identical.
         */
        m0 = ae_randominteger(ae_maxint(n, 1, _state), _state);
        m1 = ae_randominteger(ae_maxint(n, 1, _state), _state);
        ridx = ae_randominteger(ae_maxint(n, 1, _state), _state);
        cidx = ae_randominteger(ae_maxint(n, 1, _state), _state);
        offsx = ae_randominteger(n/2+1, _state);
        alpha = 2*ae_randomreal(_state)-1;
        ialpha = ae_randominteger(21, _state)-10;
        balpha = ae_fp_greater(ae_randomreal(_state),0.5);
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rsetv(n, alpha, &s0.x0, _state);
        refrsetv(n, alpha, &s1.x0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:183");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rsetr(n, alpha, &s0.a0, ridx, _state);
        refrsetr(n, alpha, &s1.a0, ridx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:189");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rsetc(n, alpha, &s0.a0, cidx, _state);
        refrsetc(n, alpha, &s1.a0, cidx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:195");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rsetm(m0, m1, alpha, &s0.a0, _state);
        refrsetm(m0, m1, alpha, &s1.a0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:201");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        isetv(n, ialpha, &s0.ix0, _state);
        refisetv(n, ialpha, &s1.ix0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:207");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        bsetv(n, balpha, &s0.bx0, _state);
        refbsetv(n, balpha, &s1.bx0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:213");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rsetvx(n/2, alpha, &s0.x0, offsx, _state);
        refrsetvx(n/2, alpha, &s1.x0, offsx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:219");
        
        /*
         * Increment seed
         */
        iseed = iseed+1;
    }
    ae_frame_leave(_state);
    return result;
}


static ae_bool testablasfunit_testxadd(ae_int_t maxn,
     double tol,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t iseed;
    double alpha;
    ae_int_t ridx;
    ae_int_t ridx2;
    ae_int_t cidx;
    ae_int_t offsx;
    ae_int_t offsy;
    ablasfplayground s0;
    ablasfplayground s1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    _ablasfplayground_init(&s0, _state, ae_true);
    _ablasfplayground_init(&s1, _state, ae_true);

    iseed = ae_randominteger(10000, _state);
    result = ae_false;
    for(n=0; n<=maxn; n++)
    {
        
        /*
         * Prepare two identical playground structures
         * Compute each xAddXX version twice - reference vs library.
         * Compare playground snapshots - should be identical.
         */
        ridx = ae_randominteger(ae_maxint(n, 1, _state), _state);
        ridx2 = ae_randominteger(ae_maxint(n, 1, _state), _state);
        cidx = ae_randominteger(ae_maxint(n, 1, _state), _state);
        offsx = ae_randominteger(n/2+1, _state);
        offsy = ae_randominteger(n/2+1, _state);
        alpha = 2*ae_randomreal(_state)-1;
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        raddv(n, alpha, &s0.x0, &s0.x1, _state);
        refraddv(n, alpha, &s1.x0, &s1.x1, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:257");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        raddvr(n, alpha, &s0.x0, &s0.a0, cidx, _state);
        refraddvr(n, alpha, &s1.x0, &s1.a0, cidx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:263");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        raddvc(n, alpha, &s0.x0, &s0.a0, cidx, _state);
        refraddvc(n, alpha, &s1.x0, &s1.a0, cidx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:269");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        raddrv(n, alpha, &s0.a0, ridx, &s0.x0, _state);
        refraddrv(n, alpha, &s1.a0, ridx, &s1.x0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:275");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        raddrr(n, alpha, &s0.a0, ridx, &s0.a1, ridx2, _state);
        refraddrr(n, alpha, &s1.a0, ridx, &s1.a1, ridx2, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:281");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        raddvx(n/2, alpha, &s0.x0, offsx, &s0.x1, offsy, _state);
        refraddvx(n/2, alpha, &s1.x0, offsx, &s1.x1, offsy, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:287");
        
        /*
         * Increment seed
         */
        iseed = iseed+1;
    }
    ae_frame_leave(_state);
    return result;
}


static ae_bool testablasfunit_testxmul(ae_int_t maxn,
     double tol,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t iseed;
    double alpha;
    ae_int_t ridx;
    ae_int_t offsx;
    ablasfplayground s0;
    ablasfplayground s1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    _ablasfplayground_init(&s0, _state, ae_true);
    _ablasfplayground_init(&s1, _state, ae_true);

    iseed = ae_randominteger(10000, _state);
    result = ae_false;
    for(n=0; n<=maxn; n++)
    {
        
        /*
         * Prepare two identical playground structures
         * Compute each xAddXX version twice - reference vs library.
         * Compare playground snapshots - should be identical.
         */
        ridx = ae_randominteger(ae_maxint(n, 1, _state), _state);
        offsx = ae_randominteger(n/2+1, _state);
        alpha = 2*ae_randomreal(_state)-1;
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rmulv(n, alpha, &s0.x0, _state);
        refrmulv(n, alpha, &s1.x0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:322");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rmulr(n, alpha, &s0.a0, ridx, _state);
        refrmulr(n, alpha, &s1.a0, ridx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:328");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rmulvx(n/2, alpha, &s0.x0, offsx, _state);
        refrmulvx(n/2, alpha, &s1.x0, offsx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:334");
        
        /*
         * Increment seed
         */
        iseed = iseed+1;
    }
    ae_frame_leave(_state);
    return result;
}


static ae_bool testablasfunit_testxmax(ae_int_t maxn,
     double tol,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t iseed;
    ae_int_t ridx;
    ablasfplayground s0;
    ablasfplayground s1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    _ablasfplayground_init(&s0, _state, ae_true);
    _ablasfplayground_init(&s1, _state, ae_true);

    iseed = ae_randominteger(10000, _state);
    result = ae_false;
    for(n=0; n<=maxn; n++)
    {
        
        /*
         * Prepare two identical playground structures
         * Compute each xAddXX version twice - reference vs library.
         * Compare playground snapshots - should be identical.
         */
        ridx = ae_randominteger(ae_maxint(n, 1, _state), _state);
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        s0.v0 = rmaxv(n, &s0.x0, _state);
        s1.v0 = refrmaxv(n, &s1.x0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:365");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        s0.v0 = rmaxabsv(n, &s0.x0, _state);
        s1.v0 = refrmaxabsv(n, &s1.x0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:371");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        s0.v0 = rmaxr(n, &s0.a0, ridx, _state);
        s1.v0 = refrmaxr(n, &s1.a0, ridx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:377");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        s0.v0 = rmaxabsr(n, &s0.a0, ridx, _state);
        s1.v0 = refrmaxabsr(n, &s1.a0, ridx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:383");
        
        /*
         * Increment seed
         */
        iseed = iseed+1;
    }
    ae_frame_leave(_state);
    return result;
}


static ae_bool testablasfunit_testxmerge(ae_int_t maxn,
     double tol,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t iseed;
    ae_int_t ridx;
    ablasfplayground s0;
    ablasfplayground s1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    _ablasfplayground_init(&s0, _state, ae_true);
    _ablasfplayground_init(&s1, _state, ae_true);

    iseed = ae_randominteger(10000, _state);
    result = ae_false;
    for(n=0; n<=maxn; n++)
    {
        
        /*
         * Prepare two identical playground structures
         * Compute each xAddXX version twice - reference vs library.
         * Compare playground snapshots - should be identical.
         */
        ridx = ae_randominteger(ae_maxint(n, 1, _state), _state);
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rmergemulv(n, &s0.x0, &s0.x1, _state);
        refrmergemulv(n, &s1.x0, &s1.x1, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:414");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rmergemulvr(n, &s0.x0, &s0.a0, ridx, _state);
        refrmergemulvr(n, &s1.x0, &s1.a0, ridx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:420");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rmergemulrv(n, &s0.a0, ridx, &s0.x0, _state);
        refrmergemulrv(n, &s1.a0, ridx, &s1.x0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:426");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rmergemaxv(n, &s0.x0, &s0.x1, _state);
        refrmergemaxv(n, &s1.x0, &s1.x1, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:432");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rmergemaxvr(n, &s0.x0, &s0.a0, ridx, _state);
        refrmergemaxvr(n, &s1.x0, &s1.a0, ridx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:438");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rmergemaxrv(n, &s0.a0, ridx, &s0.x0, _state);
        refrmergemaxrv(n, &s1.a0, ridx, &s1.x0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:444");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rmergeminv(n, &s0.x0, &s0.x1, _state);
        refrmergeminv(n, &s1.x0, &s1.x1, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:450");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rmergeminvr(n, &s0.x0, &s0.a0, ridx, _state);
        refrmergeminvr(n, &s1.x0, &s1.a0, ridx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:456");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rmergeminrv(n, &s0.a0, ridx, &s0.x0, _state);
        refrmergeminrv(n, &s1.a0, ridx, &s1.x0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:462");
        
        /*
         * Increment seed
         */
        iseed = iseed+1;
    }
    ae_frame_leave(_state);
    return result;
}


static ae_bool testablasfunit_testxcopy(ae_int_t maxn,
     double tol,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t iseed;
    double alpha;
    ae_int_t ridx;
    ae_int_t ridx2;
    ae_int_t cidx;
    ae_int_t offsx;
    ae_int_t offsy;
    ablasfplayground s0;
    ablasfplayground s1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    _ablasfplayground_init(&s0, _state, ae_true);
    _ablasfplayground_init(&s1, _state, ae_true);

    iseed = ae_randominteger(10000, _state);
    result = ae_false;
    for(n=0; n<=maxn; n++)
    {
        
        /*
         * Prepare two identical playground structures
         * Compute each xAddXX version twice - reference vs library.
         * Compare playground snapshots - should be identical.
         */
        ridx = ae_randominteger(ae_maxint(n, 1, _state), _state);
        ridx2 = ae_randominteger(ae_maxint(n, 1, _state), _state);
        cidx = ae_randominteger(ae_maxint(n, 1, _state), _state);
        offsx = ae_randominteger(n/2+1, _state);
        offsy = ae_randominteger(n/2+1, _state);
        alpha = 2*ae_randomreal(_state)-1;
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rcopyv(n, &s0.x0, &s0.x1, _state);
        refrcopyv(n, &s1.x0, &s1.x1, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:500");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        icopyv(n, &s0.ix0, &s0.ix1, _state);
        reficopyv(n, &s1.ix0, &s1.ix1, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:506");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        bcopyv(n, &s0.bx0, &s0.bx1, _state);
        refbcopyv(n, &s1.bx0, &s1.bx1, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:512");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rcopyvr(n, &s0.x0, &s0.a0, ridx, _state);
        refrcopyvr(n, &s1.x0, &s1.a0, ridx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:518");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rcopyrv(n, &s0.a0, ridx, &s0.x0, _state);
        refrcopyrv(n, &s1.a0, ridx, &s1.x0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:524");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rcopyrr(n, &s0.a0, ridx, &s0.a1, ridx2, _state);
        refrcopyrr(n, &s1.a0, ridx, &s1.a1, ridx2, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:530");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rcopyvc(n, &s0.x0, &s0.a0, cidx, _state);
        refrcopyvc(n, &s1.x0, &s1.a0, cidx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:536");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rcopycv(n, &s0.a0, cidx, &s0.x0, _state);
        refrcopycv(n, &s1.a0, cidx, &s1.x0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:542");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rcopyvx(n/2, &s0.x0, offsx, &s0.x1, offsy, _state);
        refrcopyvx(n/2, &s1.x0, offsx, &s1.x1, offsy, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:548");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        icopyvx(n/2, &s0.ix0, offsx, &s0.ix1, offsy, _state);
        reficopyvx(n/2, &s1.ix0, offsx, &s1.ix1, offsy, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:554");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rcopymulv(n, alpha, &s0.x0, &s0.x1, _state);
        refrcopymulv(n, alpha, &s1.x0, &s1.x1, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:560");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rcopymulvr(n, alpha, &s0.x0, &s0.a0, ridx, _state);
        refrcopymulvr(n, alpha, &s1.x0, &s1.a0, ridx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:566");
        testablasfunit_initplayground(n, iseed, &s0, _state);
        testablasfunit_initplayground(n, iseed, &s1, _state);
        rcopymulvc(n, alpha, &s0.x0, &s0.a0, cidx, _state);
        refrcopymulvc(n, alpha, &s1.x0, &s1.a0, cidx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:572");
        
        /*
         * Increment seed
         */
        iseed = iseed+1;
    }
    ae_frame_leave(_state);
    return result;
}


static ae_bool testablasfunit_testxgemv(ae_int_t maxn,
     double tol,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t m;
    ae_int_t iseed;
    double alpha;
    double beta;
    ae_int_t offs0;
    ae_int_t offs1;
    ae_int_t offsx;
    ae_int_t offsy;
    ae_int_t padding;
    ae_int_t opa;
    ablasfplayground s0;
    ablasfplayground s1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    _ablasfplayground_init(&s0, _state, ae_true);
    _ablasfplayground_init(&s1, _state, ae_true);

    iseed = ae_randominteger(10000, _state);
    result = ae_false;
    for(n=0; n<=maxn; n++)
    {
        
        /*
         * Prepare two identical playground structures
         * Compute each GEMV version twice - reference vs library.
         * Compare playground snapshots - should be identical.
         */
        padding = ae_randominteger(10, _state);
        m = ae_randominteger(n+1, _state);
        offs0 = ae_randominteger(ae_maxint(n, 1, _state), _state);
        offs1 = ae_randominteger(ae_maxint(n, 1, _state), _state);
        offsx = ae_randominteger(ae_maxint(n, 1, _state), _state);
        offsy = ae_randominteger(ae_maxint(n, 1, _state), _state);
        alpha = (2*ae_randomreal(_state)-1)*ae_randominteger(2, _state);
        beta = (2*ae_randomreal(_state)-1)*ae_randominteger(2, _state);
        opa = ae_randominteger(2, _state);
        testablasfunit_initplayground(2*n+padding, iseed, &s0, _state);
        testablasfunit_initplayground(2*n+padding, iseed, &s1, _state);
        rgemv(m, n, alpha, &s0.a0, opa, &s0.x0, beta, &s0.x1, _state);
        refrgemvx(m, n, alpha, &s1.a0, 0, 0, opa, &s1.x0, 0, beta, &s1.x1, 0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:615");
        testablasfunit_initplayground(2*n+padding, iseed, &s0, _state);
        testablasfunit_initplayground(2*n+padding, iseed, &s1, _state);
        rgemvx(m, n, alpha, &s0.a0, offs0, offs1, opa, &s0.x0, offsx, beta, &s0.x1, offsy, _state);
        refrgemvx(m, n, alpha, &s1.a0, offs0, offs1, opa, &s1.x0, offsx, beta, &s1.x1, offsy, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:621");
        
        /*
         * Increment seed
         */
        iseed = iseed+1;
    }
    ae_frame_leave(_state);
    return result;
}


static ae_bool testablasfunit_testxger(ae_int_t maxn,
     double tol,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t m;
    ae_int_t iseed;
    double alpha;
    ae_int_t padding;
    ablasfplayground s0;
    ablasfplayground s1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    _ablasfplayground_init(&s0, _state, ae_true);
    _ablasfplayground_init(&s1, _state, ae_true);

    iseed = ae_randominteger(10000, _state);
    result = ae_false;
    for(n=0; n<=maxn; n++)
    {
        
        /*
         * Prepare two identical playground structures
         * Compute each GER version twice - reference vs library.
         * Compare playground snapshots - should be identical.
         */
        padding = ae_randominteger(10, _state);
        m = ae_randominteger(n+1, _state);
        alpha = (2*ae_randomreal(_state)-1)*ae_randominteger(2, _state);
        testablasfunit_initplayground(2*n+padding, iseed, &s0, _state);
        testablasfunit_initplayground(2*n+padding, iseed, &s1, _state);
        rger(m, n, alpha, &s0.x0, &s0.x1, &s0.a0, _state);
        testablasfunit_refgerx(m, n, &s1.a0, 0, 0, alpha, &s1.x0, 0, &s1.x1, 0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:656");
        testablasfunit_initplayground(2*n+padding, iseed, &s0, _state);
        testablasfunit_initplayground(2*n+padding, iseed, &s1, _state);
        rger(n, m, alpha, &s0.x0, &s0.x1, &s0.a0, _state);
        testablasfunit_refgerx(n, m, &s1.a0, 0, 0, alpha, &s1.x0, 0, &s1.x1, 0, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:662");
        
        /*
         * Increment seed
         */
        iseed = iseed+1;
    }
    ae_frame_leave(_state);
    return result;
}


static ae_bool testablasfunit_testxtrsv(ae_int_t maxn,
     double tol,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t iseed;
    ae_int_t offs0;
    ae_int_t offs1;
    ae_int_t offsx;
    ae_int_t padding;
    ae_int_t opa;
    ae_bool isupper;
    ae_bool isunit;
    ablasfplayground s0;
    ablasfplayground s1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    _ablasfplayground_init(&s0, _state, ae_true);
    _ablasfplayground_init(&s1, _state, ae_true);

    iseed = ae_randominteger(10000, _state);
    result = ae_false;
    for(n=0; n<=maxn; n++)
    {
        
        /*
         * Prepare two identical playground structures
         * Compute each GEMV version twice - reference vs library.
         * Compare playground snapshots - should be identical.
         */
        padding = ae_randominteger(10, _state);
        offs0 = ae_randominteger(ae_maxint(n, 1, _state), _state);
        offs1 = ae_randominteger(ae_maxint(n, 1, _state), _state);
        offsx = ae_randominteger(ae_maxint(n, 1, _state), _state);
        opa = ae_randominteger(2, _state);
        isupper = ae_fp_greater(ae_randomreal(_state),0.5);
        isunit = ae_fp_greater(ae_randomreal(_state),0.5);
        testablasfunit_initplayground(2*n+padding, iseed, &s0, _state);
        testablasfunit_initplayground(2*n+padding, iseed, &s1, _state);
        rtrsvx(n, &s0.a0, offs0, offs1, isupper, isunit, opa, &s0.x0, offsx, _state);
        reftrsvx(n, &s1.a0, offs0, offs1, isupper, isunit, opa, &s1.x0, offsx, _state);
        ae_set_error_flag(&result, ae_fp_greater(testablasfunit_compareplaygrounds(&s0, &s1, _state),tol), __FILE__, __LINE__, "testablasfunit.ap:703");
        
        /*
         * Increment seed
         */
        iseed = iseed+1;
    }
    ae_frame_leave(_state);
    return result;
}


static void testablasfunit_initplayground(ae_int_t minlen,
     ae_int_t iseed,
     ablasfplayground* s,
     ae_state *_state)
{
    ae_int_t maxpad;
    ae_int_t k;

    _ablasfplayground_clear(s);

    maxpad = 10;
    k = iseed+iseed*iseed*iseed;
    ae_vector_set_length(&s->x0, minlen+ae_round(maxpad*ae_sqr(ae_sin((double)(k), _state), _state), _state), _state);
    k = k+1;
    ae_vector_set_length(&s->x1, minlen+ae_round(maxpad*ae_sqr(ae_sin((double)(k), _state), _state), _state), _state);
    k = k+1;
    ae_vector_set_length(&s->x2, minlen+ae_round(maxpad*ae_sqr(ae_sin((double)(k), _state), _state), _state), _state);
    k = k+1;
    ae_vector_set_length(&s->ix0, minlen+ae_round(maxpad*ae_sqr(ae_sin((double)(k), _state), _state), _state), _state);
    k = k+1;
    ae_vector_set_length(&s->ix1, minlen+ae_round(maxpad*ae_sqr(ae_sin((double)(k), _state), _state), _state), _state);
    k = k+1;
    ae_vector_set_length(&s->bx0, minlen+ae_round(maxpad*ae_sqr(ae_sin((double)(k), _state), _state), _state), _state);
    k = k+1;
    ae_vector_set_length(&s->bx1, minlen+ae_round(maxpad*ae_sqr(ae_sin((double)(k), _state), _state), _state), _state);
    k = k+1;
    ae_matrix_set_length(&s->a0, minlen+ae_round(maxpad*ae_sqr(ae_sin((double)(k), _state), _state), _state), minlen+ae_round(maxpad*ae_sqr(ae_sin((double)(k+1), _state), _state), _state), _state);
    k = k+2;
    ae_matrix_set_length(&s->a1, minlen+ae_round(maxpad*ae_sqr(ae_sin((double)(k), _state), _state), _state), minlen+ae_round(maxpad*ae_sqr(ae_sin((double)(k+1), _state), _state), _state), _state);
    k = k+2;
    s->v0 = (double)(0);
    k = testablasfunit_pseudorandominit1(&s->x0, k, _state);
    k = testablasfunit_pseudorandominit1(&s->x1, k, _state);
    k = testablasfunit_pseudorandominit1(&s->x2, k, _state);
    k = testablasfunit_pseudorandominit1i(&s->ix0, k, _state);
    k = testablasfunit_pseudorandominit1i(&s->ix1, k, _state);
    k = testablasfunit_pseudorandominit1b(&s->bx0, k, _state);
    k = testablasfunit_pseudorandominit1b(&s->bx1, k, _state);
    k = testablasfunit_pseudorandominit2(&s->a0, k, _state);
    k = testablasfunit_pseudorandominit2(&s->a1, k, _state);
}


static double testablasfunit_compareplaygrounds(ablasfplayground* s0,
     ablasfplayground* s1,
     ae_state *_state)
{
    double result;


    result = (double)(0);
    result = ae_maxreal(result, ae_fabs(s0->v0-s1->v0, _state)/testablasfunit_rmx3(ae_fabs(s0->v0, _state), ae_fabs(s1->v0, _state), (double)(1), _state), _state);
    result = ae_maxreal(result, testablasfunit_rcmp1(&s0->x0, &s1->x0, _state), _state);
    result = ae_maxreal(result, testablasfunit_rcmp1(&s0->x1, &s1->x1, _state), _state);
    result = ae_maxreal(result, testablasfunit_icmp1(&s0->ix0, &s1->ix0, _state), _state);
    result = ae_maxreal(result, testablasfunit_icmp1(&s0->ix1, &s1->ix1, _state), _state);
    result = ae_maxreal(result, testablasfunit_bcmp1(&s0->bx0, &s1->bx0, _state), _state);
    result = ae_maxreal(result, testablasfunit_bcmp1(&s0->bx1, &s1->bx1, _state), _state);
    result = ae_maxreal(result, testablasfunit_rcmp1(&s0->x2, &s1->x2, _state), _state);
    result = ae_maxreal(result, testablasfunit_rcmp2(&s0->a0, &s1->a0, _state), _state);
    result = ae_maxreal(result, testablasfunit_rcmp2(&s0->a1, &s1->a1, _state), _state);
    return result;
}


static ae_int_t testablasfunit_pseudorandominit1(/* Real    */ ae_vector* x,
     ae_int_t iseed,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t result;


    for(i=0; i<=x->cnt-1; i++)
    {
        x->ptr.p_double[i] = ae_sin(iseed+ae_sin((double)(i), _state), _state);
        iseed = iseed+1;
    }
    result = iseed;
    return result;
}


static ae_int_t testablasfunit_pseudorandominit1i(/* Integer */ ae_vector* x,
     ae_int_t iseed,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t result;


    for(i=0; i<=x->cnt-1; i++)
    {
        x->ptr.p_int[i] = ae_round(100*ae_sin(iseed+ae_sin((double)(i), _state), _state), _state);
        iseed = iseed+1;
    }
    result = iseed;
    return result;
}


static ae_int_t testablasfunit_pseudorandominit1b(/* Boolean */ ae_vector* x,
     ae_int_t iseed,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t result;


    for(i=0; i<=x->cnt-1; i++)
    {
        x->ptr.p_bool[i] = ae_fp_greater(ae_sin(iseed+ae_sin((double)(i), _state), _state),(double)(0));
        iseed = iseed+1;
    }
    result = iseed;
    return result;
}


static ae_int_t testablasfunit_pseudorandominit2(/* Real    */ ae_matrix* x,
     ae_int_t iseed,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_vector xr;
    ae_vector xc;
    ae_int_t result;

    ae_frame_make(_state, &_frame_block);
    memset(&xr, 0, sizeof(xr));
    memset(&xc, 0, sizeof(xc));
    ae_vector_init(&xr, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&xc, 0, DT_REAL, _state, ae_true);

    ae_vector_set_length(&xr, x->rows, _state);
    for(i=0; i<=x->rows-1; i++)
    {
        xr.ptr.p_double[i] = ae_sin((double)(13+2*i+iseed), _state);
    }
    iseed = iseed+1;
    ae_vector_set_length(&xc, x->cols, _state);
    for(j=0; j<=x->cols-1; j++)
    {
        xc.ptr.p_double[j] = ae_sin((double)(17+3*j+iseed), _state);
    }
    iseed = iseed+1;
    for(i=0; i<=x->rows-1; i++)
    {
        for(j=0; j<=x->cols-1; j++)
        {
            x->ptr.pp_double[i][j] = xr.ptr.p_double[i]+xc.ptr.p_double[j];
            while(ae_fp_greater(x->ptr.pp_double[i][j],(double)(1)))
            {
                x->ptr.pp_double[i][j] = x->ptr.pp_double[i][j]-1;
            }
            while(ae_fp_less(x->ptr.pp_double[i][j],(double)(-1)))
            {
                x->ptr.pp_double[i][j] = x->ptr.pp_double[i][j]+1;
            }
        }
    }
    result = iseed;
    ae_frame_leave(_state);
    return result;
}


static double testablasfunit_rmx3(double r0,
     double r1,
     double r2,
     ae_state *_state)
{
    double result;


    result = r0;
    if( ae_fp_greater(r1,result) )
    {
        result = r1;
    }
    if( ae_fp_greater(r2,result) )
    {
        result = r2;
    }
    return result;
}


static double testablasfunit_rcmp1(/* Real    */ ae_vector* x,
     /* Real    */ ae_vector* y,
     ae_state *_state)
{
    ae_int_t i;
    double mx;
    double result;


    ae_assert(x->cnt==y->cnt, "rcmp1: sizes do not match", _state);
    result = (double)(0);
    mx = (double)(1);
    for(i=0; i<=x->cnt-1; i++)
    {
        result = ae_maxreal(result, ae_fabs(x->ptr.p_double[i]-y->ptr.p_double[i], _state), _state);
        mx = ae_maxreal(mx, ae_fabs(x->ptr.p_double[i], _state), _state);
        mx = ae_maxreal(mx, ae_fabs(y->ptr.p_double[i], _state), _state);
    }
    result = result/mx;
    return result;
}


static double testablasfunit_icmp1(/* Integer */ ae_vector* x,
     /* Integer */ ae_vector* y,
     ae_state *_state)
{
    ae_int_t i;
    double result;


    ae_assert(x->cnt==y->cnt, "rcmp1: sizes do not match", _state);
    result = (double)(0);
    for(i=0; i<=x->cnt-1; i++)
    {
        result = ae_maxreal(result, ae_fabs((double)(x->ptr.p_int[i]-y->ptr.p_int[i]), _state), _state);
    }
    return result;
}


static double testablasfunit_bcmp1(/* Boolean */ ae_vector* x,
     /* Boolean */ ae_vector* y,
     ae_state *_state)
{
    ae_int_t i;
    double result;


    ae_assert(x->cnt==y->cnt, "rcmp1: sizes do not match", _state);
    result = (double)(0);
    for(i=0; i<=x->cnt-1; i++)
    {
        if( (x->ptr.p_bool[i]&&!y->ptr.p_bool[i])||(y->ptr.p_bool[i]&&!x->ptr.p_bool[i]) )
        {
            result = (double)(1);
        }
    }
    return result;
}


static double testablasfunit_rcmp2(/* Real    */ ae_matrix* x,
     /* Real    */ ae_matrix* y,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    double mx;
    double result;


    ae_assert(x->rows==y->rows, "rcmp2: rows do not match", _state);
    ae_assert(x->cols==y->cols, "rcmp2: cols do not match", _state);
    result = (double)(0);
    mx = (double)(1);
    for(i=0; i<=x->rows-1; i++)
    {
        for(j=0; j<=x->cols-1; j++)
        {
            result = ae_maxreal(result, ae_fabs(x->ptr.pp_double[i][j]-y->ptr.pp_double[i][j], _state), _state);
            mx = ae_maxreal(mx, ae_fabs(x->ptr.pp_double[i][j], _state), _state);
            mx = ae_maxreal(mx, ae_fabs(y->ptr.pp_double[i][j], _state), _state);
        }
    }
    result = result/mx;
    return result;
}


/*************************************************************************
Reference code

     16.10.2017
     Bochkanov Sergey
*************************************************************************/
static void testablasfunit_refgerx(ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     double alpha,
     /* Real    */ ae_vector* u,
     ae_int_t iu,
     /* Real    */ ae_vector* v,
     ae_int_t iv,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    double s;


    if( (m<=0||n<=0)||ae_fp_eq(alpha,(double)(0)) )
    {
        return;
    }
    for(i=0; i<=m-1; i++)
    {
        s = alpha*u->ptr.p_double[iu+i];
        for(j=0; j<=n-1; j++)
        {
            a->ptr.pp_double[ia+i][ja+j] = a->ptr.pp_double[ia+i][ja+j]+s*v->ptr.p_double[iv+j];
        }
    }
}


void _ablasfplayground_init(void* _p, ae_state *_state, ae_bool make_automatic)
{
    ablasfplayground *p = (ablasfplayground*)_p;
    ae_touch_ptr((void*)p);
    ae_vector_init(&p->x0, 0, DT_REAL, _state, make_automatic);
    ae_vector_init(&p->x1, 0, DT_REAL, _state, make_automatic);
    ae_vector_init(&p->x2, 0, DT_REAL, _state, make_automatic);
    ae_vector_init(&p->ix0, 0, DT_INT, _state, make_automatic);
    ae_vector_init(&p->ix1, 0, DT_INT, _state, make_automatic);
    ae_vector_init(&p->bx0, 0, DT_BOOL, _state, make_automatic);
    ae_vector_init(&p->bx1, 0, DT_BOOL, _state, make_automatic);
    ae_matrix_init(&p->a0, 0, 0, DT_REAL, _state, make_automatic);
    ae_matrix_init(&p->a1, 0, 0, DT_REAL, _state, make_automatic);
}


void _ablasfplayground_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic)
{
    ablasfplayground *dst = (ablasfplayground*)_dst;
    ablasfplayground *src = (ablasfplayground*)_src;
    dst->v0 = src->v0;
    ae_vector_init_copy(&dst->x0, &src->x0, _state, make_automatic);
    ae_vector_init_copy(&dst->x1, &src->x1, _state, make_automatic);
    ae_vector_init_copy(&dst->x2, &src->x2, _state, make_automatic);
    ae_vector_init_copy(&dst->ix0, &src->ix0, _state, make_automatic);
    ae_vector_init_copy(&dst->ix1, &src->ix1, _state, make_automatic);
    ae_vector_init_copy(&dst->bx0, &src->bx0, _state, make_automatic);
    ae_vector_init_copy(&dst->bx1, &src->bx1, _state, make_automatic);
    ae_matrix_init_copy(&dst->a0, &src->a0, _state, make_automatic);
    ae_matrix_init_copy(&dst->a1, &src->a1, _state, make_automatic);
}


void _ablasfplayground_clear(void* _p)
{
    ablasfplayground *p = (ablasfplayground*)_p;
    ae_touch_ptr((void*)p);
    ae_vector_clear(&p->x0);
    ae_vector_clear(&p->x1);
    ae_vector_clear(&p->x2);
    ae_vector_clear(&p->ix0);
    ae_vector_clear(&p->ix1);
    ae_vector_clear(&p->bx0);
    ae_vector_clear(&p->bx1);
    ae_matrix_clear(&p->a0);
    ae_matrix_clear(&p->a1);
}


void _ablasfplayground_destroy(void* _p)
{
    ablasfplayground *p = (ablasfplayground*)_p;
    ae_touch_ptr((void*)p);
    ae_vector_destroy(&p->x0);
    ae_vector_destroy(&p->x1);
    ae_vector_destroy(&p->x2);
    ae_vector_destroy(&p->ix0);
    ae_vector_destroy(&p->ix1);
    ae_vector_destroy(&p->bx0);
    ae_vector_destroy(&p->bx1);
    ae_matrix_destroy(&p->a0);
    ae_matrix_destroy(&p->a1);
}



static void testhqrndunit_calculatemv(/* Real    */ ae_vector* x,
     ae_int_t n,
     double* mean,
     double* means,
     double* stddev,
     double* stddevs,
     ae_state *_state);
static void testhqrndunit_unsetstate(hqrndstate* state, ae_state *_state);





ae_bool testhqrnd(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool waserrors;
    ae_int_t samplesize;
    double sigmathreshold;
    ae_int_t passcount;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t pass;
    ae_int_t s1;
    ae_int_t s2;
    ae_int_t i1;
    ae_int_t i2;
    double r1;
    double r2;
    ae_vector x;
    ae_vector dx;
    ae_matrix a;
    ae_int_t am;
    ae_int_t an;
    ae_vector bins;
    double mean;
    double means;
    double stddev;
    double stddevs;
    double lambdav;
    ae_bool seederrors;
    ae_bool urerrors;
    double ursigmaerr;
    ae_bool uierrors;
    double uisigmaerr;
    ae_bool normerrors;
    double normsigmaerr;
    ae_bool unit2errors;
    ae_bool experrors;
    double expsigmaerr;
    ae_bool discreteerr;
    ae_bool continuouserr;
    hqrndstate state;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x, 0, sizeof(x));
    memset(&dx, 0, sizeof(dx));
    memset(&a, 0, sizeof(a));
    memset(&bins, 0, sizeof(bins));
    memset(&state, 0, sizeof(state));
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&dx, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&bins, 0, DT_INT, _state, ae_true);
    _hqrndstate_init(&state, _state, ae_true);

    waserrors = ae_false;
    sigmathreshold = (double)(7);
    samplesize = 100000+ae_randominteger(100, _state);
    passcount = 50;
    seederrors = ae_false;
    urerrors = ae_false;
    uierrors = ae_false;
    normerrors = ae_false;
    experrors = ae_false;
    unit2errors = ae_false;
    ae_vector_set_length(&x, samplesize-1+1, _state);
    
    /*
     * Test seed errors
     */
    for(pass=1; pass<=passcount; pass++)
    {
        s1 = 1+ae_randominteger(32000, _state);
        s2 = 1+ae_randominteger(32000, _state);
        testhqrndunit_unsetstate(&state, _state);
        hqrndseed(s1, s2, &state, _state);
        i1 = hqrnduniformi(&state, 100, _state);
        testhqrndunit_unsetstate(&state, _state);
        hqrndseed(s1, s2, &state, _state);
        i2 = hqrnduniformi(&state, 100, _state);
        seederrors = seederrors||i1!=i2;
        testhqrndunit_unsetstate(&state, _state);
        hqrndseed(s1, s2, &state, _state);
        r1 = hqrnduniformr(&state, _state);
        testhqrndunit_unsetstate(&state, _state);
        hqrndseed(s1, s2, &state, _state);
        r2 = hqrnduniformr(&state, _state);
        seederrors = seederrors||ae_fp_neq(r1,r2);
    }
    
    /*
     * Test HQRNDRandomize() and real uniform generator
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    ursigmaerr = (double)(0);
    for(i=0; i<=samplesize-1; i++)
    {
        x.ptr.p_double[i] = hqrnduniformr(&state, _state);
    }
    for(i=0; i<=samplesize-1; i++)
    {
        urerrors = (urerrors||ae_fp_less_eq(x.ptr.p_double[i],(double)(0)))||ae_fp_greater_eq(x.ptr.p_double[i],(double)(1));
    }
    testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
    if( ae_fp_neq(means,(double)(0)) )
    {
        ursigmaerr = ae_maxreal(ursigmaerr, ae_fabs((mean-0.5)/means, _state), _state);
    }
    else
    {
        urerrors = ae_true;
    }
    if( ae_fp_neq(stddevs,(double)(0)) )
    {
        ursigmaerr = ae_maxreal(ursigmaerr, ae_fabs((stddev-ae_sqrt((double)1/(double)12, _state))/stddevs, _state), _state);
    }
    else
    {
        urerrors = ae_true;
    }
    urerrors = urerrors||ae_fp_greater(ursigmaerr,sigmathreshold);
    
    /*
     * Test HQRNDRandomize() and integer uniform
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    uisigmaerr = (double)(0);
    for(n=2; n<=10; n++)
    {
        for(i=0; i<=samplesize-1; i++)
        {
            x.ptr.p_double[i] = (double)(hqrnduniformi(&state, n, _state));
        }
        for(i=0; i<=samplesize-1; i++)
        {
            uierrors = (uierrors||ae_fp_less(x.ptr.p_double[i],(double)(0)))||ae_fp_greater_eq(x.ptr.p_double[i],(double)(n));
        }
        testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
        if( ae_fp_neq(means,(double)(0)) )
        {
            uisigmaerr = ae_maxreal(uisigmaerr, ae_fabs((mean-0.5*(n-1))/means, _state), _state);
        }
        else
        {
            uierrors = ae_true;
        }
        if( ae_fp_neq(stddevs,(double)(0)) )
        {
            uisigmaerr = ae_maxreal(uisigmaerr, ae_fabs((stddev-ae_sqrt((ae_sqr((double)(n), _state)-1)/12, _state))/stddevs, _state), _state);
        }
        else
        {
            uierrors = ae_true;
        }
    }
    uierrors = uierrors||ae_fp_greater(uisigmaerr,sigmathreshold);
    
    /*
     * Special 'close-to-limit' test on uniformity of integers
     * (straightforward implementation like 'RND mod N' will return
     *  non-uniform numbers for N=2/3*LIMIT)
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    uisigmaerr = (double)(0);
    n = 1431655708;
    for(i=0; i<=samplesize-1; i++)
    {
        x.ptr.p_double[i] = (double)(hqrnduniformi(&state, n, _state));
    }
    for(i=0; i<=samplesize-1; i++)
    {
        uierrors = (uierrors||ae_fp_less(x.ptr.p_double[i],(double)(0)))||ae_fp_greater_eq(x.ptr.p_double[i],(double)(n));
    }
    testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
    if( ae_fp_neq(means,(double)(0)) )
    {
        uisigmaerr = ae_maxreal(uisigmaerr, ae_fabs((mean-0.5*(n-1))/means, _state), _state);
    }
    else
    {
        uierrors = ae_true;
    }
    if( ae_fp_neq(stddevs,(double)(0)) )
    {
        uisigmaerr = ae_maxreal(uisigmaerr, ae_fabs((stddev-ae_sqrt((ae_sqr((double)(n), _state)-1)/12, _state))/stddevs, _state), _state);
    }
    else
    {
        uierrors = ae_true;
    }
    uierrors = uierrors||ae_fp_greater(uisigmaerr,sigmathreshold);
    
    /*
     * Test normal
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    i = 0;
    while(i<samplesize)
    {
        hqrndnormal2(&state, &r1, &r2, _state);
        x.ptr.p_double[i] = r1;
        if( i+1<samplesize )
        {
            x.ptr.p_double[i+1] = r2;
        }
        i = i+2;
    }
    normsigmaerr = (double)(0);
    testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
    if( ae_fp_neq(means,(double)(0)) )
    {
        normsigmaerr = ae_maxreal(normsigmaerr, ae_fabs((mean-0)/means, _state), _state);
    }
    else
    {
        normerrors = ae_true;
    }
    if( ae_fp_neq(stddevs,(double)(0)) )
    {
        normsigmaerr = ae_maxreal(normsigmaerr, ae_fabs((stddev-1)/stddevs, _state), _state);
    }
    else
    {
        normerrors = ae_true;
    }
    ae_set_error_flag(&normerrors, ae_fp_greater(normsigmaerr,sigmathreshold), __FILE__, __LINE__, "testhqrndunit.ap:230");
    ae_vector_set_length(&x, 0, _state);
    hqrndnormalv(&state, samplesize, &x, _state);
    ae_set_error_flag(&normerrors, x.cnt!=samplesize, __FILE__, __LINE__, "testhqrndunit.ap:233");
    ae_set_error_flag(&normerrors, !isfinitevector(&x, samplesize, _state), __FILE__, __LINE__, "testhqrndunit.ap:234");
    if( !normerrors )
    {
        
        /*
         * Check mean/sigma of the distribution
         */
        testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
        ae_set_error_flag(&normerrors, ae_fp_eq(means,(double)(0)), __FILE__, __LINE__, "testhqrndunit.ap:241");
        ae_set_error_flag(&normerrors, ae_fp_eq(stddevs,(double)(0)), __FILE__, __LINE__, "testhqrndunit.ap:242");
        normsigmaerr = (double)(0);
        normsigmaerr = ae_maxreal(normsigmaerr, ae_fabs((mean-0)/coalesce(means, (double)(1), _state), _state), _state);
        normsigmaerr = ae_maxreal(normsigmaerr, ae_fabs((stddev-1)/coalesce(stddevs, (double)(1), _state), _state), _state);
        ae_set_error_flag(&normerrors, ae_fp_greater(normsigmaerr,sigmathreshold), __FILE__, __LINE__, "testhqrndunit.ap:246");
        
        /*
         * Check that subsequent differences are normally distributed too
         */
        ae_vector_set_length(&dx, samplesize-1, _state);
        for(i=0; i<=samplesize-2; i++)
        {
            dx.ptr.p_double[i] = x.ptr.p_double[i+1]-x.ptr.p_double[i];
        }
        testhqrndunit_calculatemv(&dx, samplesize-1, &mean, &means, &stddev, &stddevs, _state);
        ae_set_error_flag(&normerrors, ae_fp_eq(means,(double)(0)), __FILE__, __LINE__, "testhqrndunit.ap:255");
        ae_set_error_flag(&normerrors, ae_fp_eq(stddevs,(double)(0)), __FILE__, __LINE__, "testhqrndunit.ap:256");
        normsigmaerr = (double)(0);
        normsigmaerr = ae_maxreal(normsigmaerr, ae_fabs((mean-0)/coalesce(means, (double)(1), _state), _state), _state);
        normsigmaerr = ae_maxreal(normsigmaerr, ae_fabs((stddev-ae_sqrt((double)(2), _state))/coalesce(stddevs, (double)(1), _state), _state), _state);
        ae_set_error_flag(&normerrors, ae_fp_greater(normsigmaerr,sigmathreshold), __FILE__, __LINE__, "testhqrndunit.ap:260");
    }
    am = 1+ae_randominteger(ae_round(ae_sqrt((double)(samplesize), _state), _state), _state);
    an = 1+samplesize/am;
    hqrndnormalm(&state, am, an, &a, _state);
    ae_set_error_flag(&normerrors, a.rows!=am, __FILE__, __LINE__, "testhqrndunit.ap:265");
    ae_set_error_flag(&normerrors, a.cols!=an, __FILE__, __LINE__, "testhqrndunit.ap:266");
    ae_set_error_flag(&normerrors, !apservisfinitematrix(&a, am, an, _state), __FILE__, __LINE__, "testhqrndunit.ap:267");
    ae_vector_set_length(&x, am*an, _state);
    for(i=0; i<=am-1; i++)
    {
        for(j=0; j<=an-1; j++)
        {
            x.ptr.p_double[i*an+j] = a.ptr.pp_double[i][j];
        }
    }
    testhqrndunit_calculatemv(&x, am*an, &mean, &means, &stddev, &stddevs, _state);
    ae_set_error_flag(&normerrors, ae_fp_eq(means,(double)(0)), __FILE__, __LINE__, "testhqrndunit.ap:273");
    ae_set_error_flag(&normerrors, ae_fp_eq(stddevs,(double)(0)), __FILE__, __LINE__, "testhqrndunit.ap:274");
    normsigmaerr = (double)(0);
    normsigmaerr = ae_maxreal(normsigmaerr, ae_fabs((mean-0)/coalesce(means, (double)(1), _state), _state), _state);
    normsigmaerr = ae_maxreal(normsigmaerr, ae_fabs((stddev-1)/coalesce(stddevs, (double)(1), _state), _state), _state);
    ae_set_error_flag(&normerrors, ae_fp_greater(normsigmaerr,sigmathreshold), __FILE__, __LINE__, "testhqrndunit.ap:278");
    
    /*
     * Test unit2
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    n = 1000000;
    ae_vector_set_length(&bins, 10, _state);
    for(i=0; i<=bins.cnt-1; i++)
    {
        bins.ptr.p_int[i] = 0;
    }
    for(pass=0; pass<=n-1; pass++)
    {
        hqrndunit2(&state, &r1, &r2, _state);
        ae_set_error_flag(&unit2errors, ae_fp_greater(ae_fabs(r1*r1+r2*r2-1, _state),100*ae_machineepsilon), __FILE__, __LINE__, "testhqrndunit.ap:292");
        k = ae_ifloor((ae_atan2(r1, r2, _state)+ae_pi)/(2*ae_pi)*bins.cnt, _state);
        if( k<0 )
        {
            k = 0;
        }
        if( k>=bins.cnt )
        {
            k = bins.cnt-1;
        }
        bins.ptr.p_int[k] = bins.ptr.p_int[k]+1;
    }
    for(i=0; i<=bins.cnt-1; i++)
    {
        ae_set_error_flag(&unit2errors, ae_fp_less((double)(bins.ptr.p_int[i]),0.9*n/bins.cnt)||ae_fp_greater((double)(bins.ptr.p_int[i]),1.1*n/bins.cnt), __FILE__, __LINE__, "testhqrndunit.ap:301");
    }
    
    /*
     * Test exponential
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    expsigmaerr = (double)(0);
    lambdav = 2+5*ae_randomreal(_state);
    for(i=0; i<=samplesize-1; i++)
    {
        x.ptr.p_double[i] = hqrndexponential(&state, lambdav, _state);
    }
    for(i=0; i<=samplesize-1; i++)
    {
        uierrors = uierrors||ae_fp_less(x.ptr.p_double[i],(double)(0));
    }
    testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
    if( ae_fp_neq(means,(double)(0)) )
    {
        expsigmaerr = ae_maxreal(expsigmaerr, ae_fabs((mean-1.0/lambdav)/means, _state), _state);
    }
    else
    {
        experrors = ae_true;
    }
    if( ae_fp_neq(stddevs,(double)(0)) )
    {
        expsigmaerr = ae_maxreal(expsigmaerr, ae_fabs((stddev-1.0/lambdav)/stddevs, _state), _state);
    }
    else
    {
        experrors = ae_true;
    }
    experrors = experrors||ae_fp_greater(expsigmaerr,sigmathreshold);
    
    /*
     *Discrete/Continuous tests
     */
    discreteerr = hqrnddiscretetest(ae_true, _state);
    continuouserr = hqrndcontinuoustest(ae_true, _state);
    
    /*
     * Final report
     */
    waserrors = ((((((seederrors||urerrors)||uierrors)||normerrors)||unit2errors)||experrors)||discreteerr)||continuouserr;
    if( !silent )
    {
        printf("RNG TEST\n");
        printf("SEED TEST:                               ");
        if( !seederrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("UNIFORM CONTINUOUS:                      ");
        if( !urerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("UNIFORM INTEGER:                         ");
        if( !uierrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("NORMAL:                                  ");
        if( !normerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("UNIT2:                                   ");
        if( !unit2errors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("EXPONENTIAL:                             ");
        if( !experrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("DISCRETE:                                ");
        if( !discreteerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("CONTINUOUS:                              ");
        if( !continuouserr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST SUMMARY: FAILED\n");
        }
        else
        {
            printf("TEST SUMMARY: PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for test HQRNDContinuous function
*************************************************************************/
ae_bool hqrndcontinuoustest(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector sample;
    ae_vector bins;
    ae_vector binbounds;
    ae_int_t nb;
    ae_int_t samplesize;
    hqrndstate state;
    ae_int_t xp;
    ae_int_t i;
    ae_int_t j;
    double v;
    double sigma;
    double sigmamax;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&sample, 0, sizeof(sample));
    memset(&bins, 0, sizeof(bins));
    memset(&binbounds, 0, sizeof(binbounds));
    memset(&state, 0, sizeof(state));
    ae_vector_init(&sample, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&bins, 0, DT_INT, _state, ae_true);
    ae_vector_init(&binbounds, 0, DT_REAL, _state, ae_true);
    _hqrndstate_init(&state, _state, ae_true);

    result = ae_false;
    
    /*
     * Test for sample size equal to 1
     */
    ae_vector_set_length(&sample, 1, _state);
    sample.ptr.p_double[0] = ae_randomreal(_state);
    hqrndrandomize(&state, _state);
    result = result||ae_fp_neq(hqrndcontinuous(&state, &sample, 1, _state),sample.ptr.p_double[0]);
    
    /*
     * Test for larger samples
     */
    xp = 100000;
    sigmamax = 10.0;
    for(samplesize=2; samplesize<=5; samplesize++)
    {
        
        /*
         * 1. Generate random sample with SampleSize points
         * 2. Generate NB=3*(SampleSize-1) bins, with bounds as prescribed by (BinBounds[I],BinBounds[I+1]).
         *    Bin bounds are generated in such a way that value can fall into any bin with same probability
         * 3. Generate many random values
         * 4. Calculate number of values which fall into each bin
         * 5. Bins[I] should have binomial distribution with mean XP/NB and 
         *    variance XP*(1/NB)*(1-1/NB)
         */
        nb = 3*(samplesize-1);
        sigma = ae_sqrt(xp*((double)1/(double)nb)*(1-(double)1/(double)nb), _state);
        ae_vector_set_length(&sample, samplesize, _state);
        sample.ptr.p_double[0] = 2*ae_randomreal(_state)-1;
        for(i=0; i<=samplesize-2; i++)
        {
            sample.ptr.p_double[i+1] = sample.ptr.p_double[i]+0.1+ae_randomreal(_state);
        }
        ae_vector_set_length(&bins, nb, _state);
        ae_vector_set_length(&binbounds, nb+1, _state);
        for(i=0; i<=samplesize-2; i++)
        {
            bins.ptr.p_int[3*i+0] = 0;
            bins.ptr.p_int[3*i+1] = 0;
            bins.ptr.p_int[3*i+2] = 0;
            binbounds.ptr.p_double[3*i+0] = sample.ptr.p_double[i];
            binbounds.ptr.p_double[3*i+1] = sample.ptr.p_double[i]+(sample.ptr.p_double[i+1]-sample.ptr.p_double[i])/3;
            binbounds.ptr.p_double[3*i+2] = sample.ptr.p_double[i]+(sample.ptr.p_double[i+1]-sample.ptr.p_double[i])*2/3;
        }
        binbounds.ptr.p_double[nb] = sample.ptr.p_double[samplesize-1];
        hqrndrandomize(&state, _state);
        for(i=0; i<=xp-1; i++)
        {
            v = hqrndcontinuous(&state, &sample, samplesize, _state);
            for(j=0; j<=nb-1; j++)
            {
                if( ae_fp_greater(v,binbounds.ptr.p_double[j])&&ae_fp_less(v,binbounds.ptr.p_double[j+1]) )
                {
                    bins.ptr.p_int[j] = bins.ptr.p_int[j]+1;
                    break;
                }
            }
        }
        for(i=0; i<=nb-1; i++)
        {
            result = result||ae_fp_greater(ae_fabs(bins.ptr.p_int[i]-(double)xp/(double)nb, _state),sigma*sigmamax);
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for test HQRNDContinuous function
*************************************************************************/
ae_bool hqrnddiscretetest(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector sample;
    double sigma;
    double sigmathreshold;
    double tsample;
    double max;
    double min;
    ae_int_t i;
    ae_int_t j;
    ae_int_t s1;
    ae_int_t s2;
    ae_int_t binscount;
    ae_int_t xp;
    ae_vector nn;
    hqrndstate state;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&sample, 0, sizeof(sample));
    memset(&nn, 0, sizeof(nn));
    memset(&state, 0, sizeof(state));
    ae_vector_init(&sample, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&nn, 0, DT_INT, _state, ae_true);
    _hqrndstate_init(&state, _state, ae_true);

    
    /*
     * We test that all values from discrete sample are generated with same probability.
     * To do this, we generate random values many times, then we calculate actual probabilities
     * and compare them with theoretical ones.
     */
    max = (double)(100);
    min = (double)(-100);
    xp = 100000;
    sigmathreshold = 10.0;
    for(binscount=1; binscount<=5; binscount++)
    {
        sigma = ae_sqrt(xp*((double)1/(double)binscount)*(1-(double)1/(double)binscount), _state);
        ae_vector_set_length(&nn, binscount, _state);
        for(i=0; i<=binscount-1; i++)
        {
            nn.ptr.p_int[i] = 0;
        }
        ae_vector_set_length(&sample, binscount, _state);
        sample.ptr.p_double[0] = (max-min)*ae_randomreal(_state)+min;
        for(i=1; i<=binscount-1; i++)
        {
            sample.ptr.p_double[i] = sample.ptr.p_double[i-1]+max*ae_randomreal(_state)+0.001;
        }
        s1 = 1+ae_randominteger(32000, _state);
        s2 = 1+ae_randominteger(32000, _state);
        hqrndseed(s1, s2, &state, _state);
        for(i=0; i<=xp-1; i++)
        {
            tsample = hqrnddiscrete(&state, &sample, binscount, _state);
            for(j=0; j<=binscount-1; j++)
            {
                if( ae_fp_eq(tsample,sample.ptr.p_double[j]) )
                {
                    nn.ptr.p_int[j] = nn.ptr.p_int[j]+1;
                    break;
                }
            }
        }
        for(i=0; i<=binscount-1; i++)
        {
            if( ae_fp_less((double)(nn.ptr.p_int[i]),(double)xp/(double)binscount-sigmathreshold*sigma)||ae_fp_greater((double)(nn.ptr.p_int[i]),(double)xp/(double)binscount+sigmathreshold*sigma) )
            {
                if( !silent )
                {
                    printf("HQRNDDiscreteTest::ErrorReport::\n");
                    printf("nn[%0d]=%0d;\n   xp/BinsCount=%0.5f;\n   C*sigma=%0.5f\n",
                        (int)(i),
                        (int)(nn.ptr.p_int[i]),
                        (double)((double)xp/(double)binscount),
                        (double)(sigmathreshold*sigma));
                    printf("HQRNDDiscreteTest: test is FAILED!\n");
                }
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
        }
        if( !silent )
        {
            printf("HQRNDDiscreteTest: test is OK.\n");
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


static void testhqrndunit_calculatemv(/* Real    */ ae_vector* x,
     ae_int_t n,
     double* mean,
     double* means,
     double* stddev,
     double* stddevs,
     ae_state *_state)
{
    ae_int_t i;
    double v1;
    double v2;
    double variance;

    *mean = 0;
    *means = 0;
    *stddev = 0;
    *stddevs = 0;

    *mean = (double)(0);
    *means = (double)(1);
    *stddev = (double)(0);
    *stddevs = (double)(1);
    variance = (double)(0);
    if( n<=1 )
    {
        return;
    }
    
    /*
     * Mean
     */
    for(i=0; i<=n-1; i++)
    {
        *mean = *mean+x->ptr.p_double[i];
    }
    *mean = *mean/n;
    
    /*
     * Variance (using corrected two-pass algorithm)
     */
    if( n!=1 )
    {
        v1 = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v1 = v1+ae_sqr(x->ptr.p_double[i]-(*mean), _state);
        }
        v2 = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v2 = v2+(x->ptr.p_double[i]-(*mean));
        }
        v2 = ae_sqr(v2, _state)/n;
        variance = (v1-v2)/(n-1);
        if( ae_fp_less(variance,(double)(0)) )
        {
            variance = (double)(0);
        }
        *stddev = ae_sqrt(variance, _state);
    }
    
    /*
     * Errors
     */
    *means = *stddev/ae_sqrt((double)(n), _state);
    *stddevs = *stddev*ae_sqrt((double)(2), _state)/ae_sqrt((double)(n-1), _state);
}


/*************************************************************************
Unsets HQRNDState structure
*************************************************************************/
static void testhqrndunit_unsetstate(hqrndstate* state, ae_state *_state)
{


    state->s1 = 0;
    state->s2 = 0;
    state->magicv = 0;
}



static ae_bool testablasunit_testtrsm(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testsyrk(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testgemm(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testtrans(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testrank1(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testgemv(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static void testablasunit_testsymv(ae_int_t minn,
     ae_int_t maxn,
     ae_bool* errorflag,
     ae_state *_state);
static void testablasunit_testtrsv(ae_int_t minn,
     ae_int_t maxn,
     ae_bool* errorflag,
     ae_state *_state);
static void testablasunit_spectest(ae_bool* errorflag, ae_state *_state);
static ae_bool testablasunit_testcopy(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static void testablasunit_testcopy1(ae_int_t minn,
     ae_int_t maxn,
     ae_bool* err,
     ae_state *_state);
static void testablasunit_testreflections(ae_bool* errorflag,
     ae_state *_state);
static void testablasunit_refcmatrixrighttrsm(ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Complex */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state);
static void testablasunit_refcmatrixlefttrsm(ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Complex */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state);
static void testablasunit_refrmatrixrighttrsm(ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Real    */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state);
static void testablasunit_refrmatrixlefttrsm(ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Real    */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state);
static ae_bool testablasunit_internalcmatrixtrinverse(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state);
static ae_bool testablasunit_internalrmatrixtrinverse(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state);
static void testablasunit_refcmatrixherk(ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Complex */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     double beta,
     /* Complex */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_bool isupper,
     ae_state *_state);
static void testablasunit_refrmatrixsyrk(ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     double beta,
     /* Real    */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_bool isupper,
     ae_state *_state);
static void testablasunit_refcmatrixgemm(ae_int_t m,
     ae_int_t n,
     ae_int_t k,
     ae_complex alpha,
     /* Complex */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     /* Complex */ ae_matrix* b,
     ae_int_t ib,
     ae_int_t jb,
     ae_int_t optypeb,
     ae_complex beta,
     /* Complex */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_state *_state);
static void testablasunit_refrmatrixgemm(ae_int_t m,
     ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     /* Real    */ ae_matrix* b,
     ae_int_t ib,
     ae_int_t jb,
     ae_int_t optypeb,
     double beta,
     /* Real    */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_state *_state);
static void testablasunit_refrmatrixsymv(ae_int_t n,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_bool isupper,
     /* Real    */ ae_vector* x,
     ae_int_t ix,
     double beta,
     /* Real    */ ae_vector* y,
     ae_int_t iy,
     ae_state *_state);
static double testablasunit_refrmatrixsyvmv(ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_bool isupper,
     /* Real    */ ae_vector* x,
     ae_int_t ix,
     ae_state *_state);





ae_bool testablas(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n0;
    ae_int_t n1;
    ae_bool trsmerrors;
    ae_bool syrkerrors;
    ae_bool gemmerrors;
    ae_bool transerrors;
    ae_bool rank1errors;
    ae_bool gemverrors;
    ae_bool symverrors;
    ae_bool trsverrors;
    ae_bool reflerrors;
    ae_bool copyerrors;
    ae_bool copy1errors;
    ae_bool specerrors;
    ae_bool waserrors;
    ae_matrix ra;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&ra, 0, sizeof(ra));
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);

    trsmerrors = ae_false;
    syrkerrors = ae_false;
    gemmerrors = ae_false;
    transerrors = ae_false;
    rank1errors = ae_false;
    gemverrors = ae_false;
    symverrors = ae_false;
    trsverrors = ae_false;
    reflerrors = ae_false;
    copyerrors = ae_false;
    copy1errors = ae_false;
    waserrors = ae_false;
    specerrors = ae_false;
    testablasunit_spectest(&specerrors, _state);
    trsmerrors = trsmerrors||testablasunit_testtrsm(1, 3*matrixtilesizea(_state)+1, _state);
    syrkerrors = syrkerrors||testablasunit_testsyrk(1, 3*matrixtilesizea(_state)+1, _state);
    gemmerrors = gemmerrors||testablasunit_testgemm(1, 3*matrixtilesizea(_state)+1, _state);
    transerrors = transerrors||testablasunit_testtrans(1, 3*matrixtilesizea(_state)+1, _state);
    rank1errors = rank1errors||testablasunit_testrank1(1, 3*matrixtilesizea(_state)+1, _state);
    gemverrors = gemverrors||testablasunit_testgemv(1, 3*matrixtilesizea(_state)+1, _state);
    copyerrors = copyerrors||testablasunit_testcopy(1, 3*matrixtilesizea(_state)+1, _state);
    testablasunit_testsymv(1, 3*matrixtilesizea(_state)+1, &symverrors, _state);
    testablasunit_testtrsv(1, 3*matrixtilesizea(_state)+1, &trsverrors, _state);
    testablasunit_testreflections(&reflerrors, _state);
    n0 = 6*matrixtilesizeb(_state);
    n1 = 6*matrixtilesizeb(_state);
    gemmerrors = gemmerrors||testablasunit_testgemm(n0, n1, _state);
    trsmerrors = trsmerrors||testablasunit_testtrsm(n0, n1, _state);
    syrkerrors = syrkerrors||testablasunit_testsyrk(n0, n1, _state);
    testablasunit_testcopy1(1, 3*matrixtilesizea(_state)+1, &copy1errors, _state);
    
    /*
     * report
     */
    waserrors = ((((((((((trsmerrors||syrkerrors)||gemmerrors)||transerrors)||rank1errors)||gemverrors)||symverrors)||trsverrors)||reflerrors)||copyerrors)||copy1errors)||specerrors;
    if( !silent )
    {
        printf("TESTING ABLAS\n");
        printf("LEVEL 3 FUNCTIONS:\n");
        printf("* TRSM                                   ");
        if( trsmerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SYRK                                   ");
        if( syrkerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* GEMM                                   ");
        if( gemmerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("LEVEL 2 FUNCTIONS:\n");
        printf("* TRANS                                  ");
        if( transerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* RANK1                                  ");
        if( rank1errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* GEMV                                   ");
        if( gemverrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SYMV/SYVMV                             ");
        if( symverrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* TRSV                                   ");
        if( trsverrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* REFL                                   ");
        if( reflerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* COPY                                   ");
        if( copyerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("LEVEL 1 FUNCTIONS:\n");
        printf("* COPY                                   ");
        if( copy1errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("SPECIAL TESTS                            ");
        if( specerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
?Matrix????TRSM tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testtrsm(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t m;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t optype;
    ae_int_t uppertype;
    ae_int_t unittype;
    ae_int_t xoffsi;
    ae_int_t xoffsj;
    ae_int_t aoffsitype;
    ae_int_t aoffsjtype;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_matrix refra;
    ae_matrix refrxl;
    ae_matrix refrxr;
    ae_matrix refca;
    ae_matrix refcxl;
    ae_matrix refcxr;
    ae_matrix ra;
    ae_matrix ca;
    ae_matrix rxr1;
    ae_matrix rxl1;
    ae_matrix cxr1;
    ae_matrix cxl1;
    ae_matrix rxr2;
    ae_matrix rxl2;
    ae_matrix cxr2;
    ae_matrix cxl2;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&refrxl, 0, sizeof(refrxl));
    memset(&refrxr, 0, sizeof(refrxr));
    memset(&refca, 0, sizeof(refca));
    memset(&refcxl, 0, sizeof(refcxl));
    memset(&refcxr, 0, sizeof(refcxr));
    memset(&ra, 0, sizeof(ra));
    memset(&ca, 0, sizeof(ca));
    memset(&rxr1, 0, sizeof(rxr1));
    memset(&rxl1, 0, sizeof(rxl1));
    memset(&cxr1, 0, sizeof(cxr1));
    memset(&cxl1, 0, sizeof(cxl1));
    memset(&rxr2, 0, sizeof(rxr2));
    memset(&rxl2, 0, sizeof(rxl2));
    memset(&cxr2, 0, sizeof(cxr2));
    memset(&cxl2, 0, sizeof(cxl2));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refrxl, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refrxr, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&refcxl, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&refcxr, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&rxr1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rxl1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cxr1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cxl1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&rxr2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rxl2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cxr2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cxl2, 0, 0, DT_COMPLEX, _state, ae_true);

    threshold = ae_sqr((double)(maxn), _state)*100*ae_machineepsilon;
    result = ae_false;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize RefRA/RefCA by random matrices whose upper
         * and lower triangle submatrices are non-degenerate
         * well-conditioned matrices.
         *
         * Matrix size is 2Mx2M (four copies of same MxM matrix
         * to test different offsets)
         */
        ae_matrix_set_length(&refra, 2*m, 2*m, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refra.ptr.pp_double[i][j] = 0.2*ae_randomreal(_state)-0.1;
            }
        }
        for(i=0; i<=m-1; i++)
        {
            refra.ptr.pp_double[i][i] = (2*ae_randominteger(1, _state)-1)*(2*m+ae_randomreal(_state));
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refra.ptr.pp_double[i+m][j] = refra.ptr.pp_double[i][j];
                refra.ptr.pp_double[i][j+m] = refra.ptr.pp_double[i][j];
                refra.ptr.pp_double[i+m][j+m] = refra.ptr.pp_double[i][j];
            }
        }
        ae_matrix_set_length(&refca, 2*m, 2*m, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refca.ptr.pp_complex[i][j].x = 0.2*ae_randomreal(_state)-0.1;
                refca.ptr.pp_complex[i][j].y = 0.2*ae_randomreal(_state)-0.1;
            }
        }
        for(i=0; i<=m-1; i++)
        {
            refca.ptr.pp_complex[i][i].x = (2*ae_randominteger(2, _state)-1)*(2*m+ae_randomreal(_state));
            refca.ptr.pp_complex[i][i].y = (2*ae_randominteger(2, _state)-1)*(2*m+ae_randomreal(_state));
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refca.ptr.pp_complex[i+m][j] = refca.ptr.pp_complex[i][j];
                refca.ptr.pp_complex[i][j+m] = refca.ptr.pp_complex[i][j];
                refca.ptr.pp_complex[i+m][j+m] = refca.ptr.pp_complex[i][j];
            }
        }
        
        /*
         * Generate random XL/XR.
         *
         * XR is NxM matrix (matrix for 'Right' subroutines)
         * XL is MxN matrix (matrix for 'Left' subroutines)
         */
        ae_matrix_set_length(&refrxr, n, m, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refrxr.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        ae_matrix_set_length(&refrxl, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                refrxl.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        ae_matrix_set_length(&refcxr, n, m, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refcxr.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcxr.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        ae_matrix_set_length(&refcxl, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                refcxl.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcxl.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * test different types of operations, offsets, and so on...
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        ae_matrix_set_length(&ra, 2*m, 2*m, _state);
        ae_matrix_set_length(&rxr1, n, m, _state);
        ae_matrix_set_length(&rxr2, n, m, _state);
        ae_matrix_set_length(&rxl1, m, n, _state);
        ae_matrix_set_length(&rxl2, m, n, _state);
        ae_matrix_set_length(&ca, 2*m, 2*m, _state);
        ae_matrix_set_length(&cxr1, n, m, _state);
        ae_matrix_set_length(&cxr2, n, m, _state);
        ae_matrix_set_length(&cxl1, m, n, _state);
        ae_matrix_set_length(&cxl2, m, n, _state);
        optype = ae_randominteger(3, _state);
        uppertype = ae_randominteger(2, _state);
        unittype = ae_randominteger(2, _state);
        xoffsi = ae_randominteger(2, _state);
        xoffsj = ae_randominteger(2, _state);
        aoffsitype = ae_randominteger(2, _state);
        aoffsjtype = ae_randominteger(2, _state);
        aoffsi = m*aoffsitype;
        aoffsj = m*aoffsjtype;
        
        /*
         * copy A, XR, XL (fill unused parts with random garbage)
         */
        for(i=0; i<=2*m-1; i++)
        {
            for(j=0; j<=2*m-1; j++)
            {
                if( ((i>=aoffsi&&i<aoffsi+m)&&j>=aoffsj)&&j<aoffsj+m )
                {
                    ca.ptr.pp_complex[i][j] = refca.ptr.pp_complex[i][j];
                    ra.ptr.pp_double[i][j] = refra.ptr.pp_double[i][j];
                }
                else
                {
                    ca.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    ra.ptr.pp_double[i][j] = ae_randomreal(_state);
                }
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                if( i>=xoffsi&&j>=xoffsj )
                {
                    cxr1.ptr.pp_complex[i][j] = refcxr.ptr.pp_complex[i][j];
                    cxr2.ptr.pp_complex[i][j] = refcxr.ptr.pp_complex[i][j];
                    rxr1.ptr.pp_double[i][j] = refrxr.ptr.pp_double[i][j];
                    rxr2.ptr.pp_double[i][j] = refrxr.ptr.pp_double[i][j];
                }
                else
                {
                    cxr1.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    cxr2.ptr.pp_complex[i][j] = cxr1.ptr.pp_complex[i][j];
                    rxr1.ptr.pp_double[i][j] = ae_randomreal(_state);
                    rxr2.ptr.pp_double[i][j] = rxr1.ptr.pp_double[i][j];
                }
            }
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( i>=xoffsi&&j>=xoffsj )
                {
                    cxl1.ptr.pp_complex[i][j] = refcxl.ptr.pp_complex[i][j];
                    cxl2.ptr.pp_complex[i][j] = refcxl.ptr.pp_complex[i][j];
                    rxl1.ptr.pp_double[i][j] = refrxl.ptr.pp_double[i][j];
                    rxl2.ptr.pp_double[i][j] = refrxl.ptr.pp_double[i][j];
                }
                else
                {
                    cxl1.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    cxl2.ptr.pp_complex[i][j] = cxl1.ptr.pp_complex[i][j];
                    rxl1.ptr.pp_double[i][j] = ae_randomreal(_state);
                    rxl2.ptr.pp_double[i][j] = rxl1.ptr.pp_double[i][j];
                }
            }
        }
        
        /*
         * Test CXR
         */
        cmatrixrighttrsm(n-xoffsi, m-xoffsj, &ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &cxr1, xoffsi, xoffsj, _state);
        testablasunit_refcmatrixrighttrsm(n-xoffsi, m-xoffsj, &ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &cxr2, xoffsi, xoffsj, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(cxr1.ptr.pp_complex[i][j],cxr2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        
        /*
         * Test CXL
         */
        cmatrixlefttrsm(m-xoffsi, n-xoffsj, &ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &cxl1, xoffsi, xoffsj, _state);
        testablasunit_refcmatrixlefttrsm(m-xoffsi, n-xoffsj, &ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &cxl2, xoffsi, xoffsj, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(cxl1.ptr.pp_complex[i][j],cxl2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        if( optype<2 )
        {
            
            /*
             * Test RXR
             */
            rmatrixrighttrsm(n-xoffsi, m-xoffsj, &ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &rxr1, xoffsi, xoffsj, _state);
            testablasunit_refrmatrixrighttrsm(n-xoffsi, m-xoffsj, &ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &rxr2, xoffsi, xoffsj, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=m-1; j++)
                {
                    result = result||ae_fp_greater(ae_fabs(rxr1.ptr.pp_double[i][j]-rxr2.ptr.pp_double[i][j], _state),threshold);
                }
            }
            
            /*
             * Test RXL
             */
            rmatrixlefttrsm(m-xoffsi, n-xoffsj, &ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &rxl1, xoffsi, xoffsj, _state);
            testablasunit_refrmatrixlefttrsm(m-xoffsi, n-xoffsj, &ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &rxl2, xoffsi, xoffsj, _state);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    result = result||ae_fp_greater(ae_fabs(rxl1.ptr.pp_double[i][j]-rxl2.ptr.pp_double[i][j], _state),threshold);
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
SYRK tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testsyrk(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t k;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t uppertype;
    ae_int_t xoffsi;
    ae_int_t xoffsj;
    ae_int_t aoffsitype;
    ae_int_t aoffsjtype;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t alphatype;
    ae_int_t betatype;
    ae_matrix refra;
    ae_matrix refrc;
    ae_matrix refca;
    ae_matrix refcc;
    double alpha;
    double beta;
    ae_matrix ra1;
    ae_matrix ra2;
    ae_matrix ca1;
    ae_matrix ca2;
    ae_matrix rc;
    ae_matrix rct;
    ae_matrix cc;
    ae_matrix cct;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&refrc, 0, sizeof(refrc));
    memset(&refca, 0, sizeof(refca));
    memset(&refcc, 0, sizeof(refcc));
    memset(&ra1, 0, sizeof(ra1));
    memset(&ra2, 0, sizeof(ra2));
    memset(&ca1, 0, sizeof(ca1));
    memset(&ca2, 0, sizeof(ca2));
    memset(&rc, 0, sizeof(rc));
    memset(&rct, 0, sizeof(rct));
    memset(&cc, 0, sizeof(cc));
    memset(&cct, 0, sizeof(cct));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refrc, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&refcc, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ra1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ra2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ca2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&rc, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rct, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cc, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cct, 0, 0, DT_COMPLEX, _state, ae_true);

    threshold = maxn*100*ae_machineepsilon;
    result = ae_false;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        k = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            k = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize RefRA/RefCA by random Hermitian matrices,
         * RefRC/RefCC by random matrices
         *
         * RA/CA size is 2Nx2N (four copies of same NxN matrix
         * to test different offsets)
         */
        ae_matrix_set_length(&refra, 2*n, 2*n, _state);
        ae_matrix_set_length(&refca, 2*n, 2*n, _state);
        for(i=0; i<=n-1; i++)
        {
            refra.ptr.pp_double[i][i] = 2*ae_randomreal(_state)-1;
            refca.ptr.pp_complex[i][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
            for(j=i+1; j<=n-1; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                refra.ptr.pp_double[j][i] = refra.ptr.pp_double[i][j];
                refca.ptr.pp_complex[j][i] = ae_c_conj(refca.ptr.pp_complex[i][j], _state);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                refra.ptr.pp_double[i+n][j] = refra.ptr.pp_double[i][j];
                refra.ptr.pp_double[i][j+n] = refra.ptr.pp_double[i][j];
                refra.ptr.pp_double[i+n][j+n] = refra.ptr.pp_double[i][j];
                refca.ptr.pp_complex[i+n][j] = refca.ptr.pp_complex[i][j];
                refca.ptr.pp_complex[i][j+n] = refca.ptr.pp_complex[i][j];
                refca.ptr.pp_complex[i+n][j+n] = refca.ptr.pp_complex[i][j];
            }
        }
        ae_matrix_set_length(&refrc, n, k, _state);
        ae_matrix_set_length(&refcc, n, k, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=k-1; j++)
            {
                refrc.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refcc.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcc.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * test different types of operations, offsets, and so on...
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        ae_matrix_set_length(&ra1, 2*n, 2*n, _state);
        ae_matrix_set_length(&ra2, 2*n, 2*n, _state);
        ae_matrix_set_length(&ca1, 2*n, 2*n, _state);
        ae_matrix_set_length(&ca2, 2*n, 2*n, _state);
        ae_matrix_set_length(&rc, n, k, _state);
        ae_matrix_set_length(&rct, k, n, _state);
        ae_matrix_set_length(&cc, n, k, _state);
        ae_matrix_set_length(&cct, k, n, _state);
        uppertype = ae_randominteger(2, _state);
        xoffsi = ae_randominteger(2, _state);
        xoffsj = ae_randominteger(2, _state);
        aoffsitype = ae_randominteger(2, _state);
        aoffsjtype = ae_randominteger(2, _state);
        alphatype = ae_randominteger(2, _state);
        betatype = ae_randominteger(2, _state);
        aoffsi = n*aoffsitype;
        aoffsj = n*aoffsjtype;
        alpha = alphatype*(2*ae_randomreal(_state)-1);
        beta = betatype*(2*ae_randomreal(_state)-1);
        
        /*
         * copy A, C (fill unused parts with random garbage)
         */
        for(i=0; i<=2*n-1; i++)
        {
            for(j=0; j<=2*n-1; j++)
            {
                if( ((i>=aoffsi&&i<aoffsi+n)&&j>=aoffsj)&&j<aoffsj+n )
                {
                    ca1.ptr.pp_complex[i][j] = refca.ptr.pp_complex[i][j];
                    ca2.ptr.pp_complex[i][j] = refca.ptr.pp_complex[i][j];
                    ra1.ptr.pp_double[i][j] = refra.ptr.pp_double[i][j];
                    ra2.ptr.pp_double[i][j] = refra.ptr.pp_double[i][j];
                }
                else
                {
                    ca1.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    ca2.ptr.pp_complex[i][j] = ca1.ptr.pp_complex[i][j];
                    ra1.ptr.pp_double[i][j] = ae_randomreal(_state);
                    ra2.ptr.pp_double[i][j] = ra1.ptr.pp_double[i][j];
                }
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=k-1; j++)
            {
                if( i>=xoffsi&&j>=xoffsj )
                {
                    rc.ptr.pp_double[i][j] = refrc.ptr.pp_double[i][j];
                    rct.ptr.pp_double[j][i] = refrc.ptr.pp_double[i][j];
                    cc.ptr.pp_complex[i][j] = refcc.ptr.pp_complex[i][j];
                    cct.ptr.pp_complex[j][i] = refcc.ptr.pp_complex[i][j];
                }
                else
                {
                    rc.ptr.pp_double[i][j] = ae_randomreal(_state);
                    rct.ptr.pp_double[j][i] = rc.ptr.pp_double[i][j];
                    cc.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    cct.ptr.pp_complex[j][i] = cct.ptr.pp_complex[j][i];
                }
            }
        }
        
        /*
         * Test complex
         * Only one of transform types is selected and tested
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            cmatrixherk(n-xoffsi, k-xoffsj, alpha, &cc, xoffsi, xoffsj, 0, beta, &ca1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refcmatrixherk(n-xoffsi, k-xoffsj, alpha, &cc, xoffsi, xoffsj, 0, beta, &ca2, aoffsi, aoffsj, uppertype==0, _state);
        }
        else
        {
            cmatrixherk(n-xoffsi, k-xoffsj, alpha, &cct, xoffsj, xoffsi, 2, beta, &ca1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refcmatrixherk(n-xoffsi, k-xoffsj, alpha, &cct, xoffsj, xoffsi, 2, beta, &ca2, aoffsi, aoffsj, uppertype==0, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(ca1.ptr.pp_complex[i][j],ca2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        
        /*
         * Test old version of HERK (named SYRK)
         * Only one of transform types is selected and tested
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            cmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &cc, xoffsi, xoffsj, 0, beta, &ca1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refcmatrixherk(n-xoffsi, k-xoffsj, alpha, &cc, xoffsi, xoffsj, 0, beta, &ca2, aoffsi, aoffsj, uppertype==0, _state);
        }
        else
        {
            cmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &cct, xoffsj, xoffsi, 2, beta, &ca1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refcmatrixherk(n-xoffsi, k-xoffsj, alpha, &cct, xoffsj, xoffsi, 2, beta, &ca2, aoffsi, aoffsj, uppertype==0, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(ca1.ptr.pp_complex[i][j],ca2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        
        /*
         * Test real
         * Only one of transform types is selected and tested
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            rmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &rc, xoffsi, xoffsj, 0, beta, &ra1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refrmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &rc, xoffsi, xoffsj, 0, beta, &ra2, aoffsi, aoffsj, uppertype==0, _state);
        }
        else
        {
            rmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &rct, xoffsj, xoffsi, 1, beta, &ra1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refrmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &rct, xoffsj, xoffsi, 1, beta, &ra2, aoffsi, aoffsj, uppertype==0, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                result = result||ae_fp_greater(ae_fabs(ra1.ptr.pp_double[i][j]-ra2.ptr.pp_double[i][j], _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
GEMM tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testgemm(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t k;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t aoptype;
    ae_int_t aoptyper;
    ae_int_t boffsi;
    ae_int_t boffsj;
    ae_int_t boptype;
    ae_int_t boptyper;
    ae_int_t coffsi;
    ae_int_t coffsj;
    ae_matrix refra;
    ae_matrix refrb;
    ae_matrix refrc;
    ae_matrix refca;
    ae_matrix refcb;
    ae_matrix refcc;
    double alphar;
    double betar;
    ae_complex alphac;
    ae_complex betac;
    ae_matrix rc1;
    ae_matrix rc2;
    ae_matrix cc1;
    ae_matrix cc2;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&refrb, 0, sizeof(refrb));
    memset(&refrc, 0, sizeof(refrc));
    memset(&refca, 0, sizeof(refca));
    memset(&refcb, 0, sizeof(refcb));
    memset(&refcc, 0, sizeof(refcc));
    memset(&rc1, 0, sizeof(rc1));
    memset(&rc2, 0, sizeof(rc2));
    memset(&cc1, 0, sizeof(cc1));
    memset(&cc2, 0, sizeof(cc2));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refrb, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refrc, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&refcb, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&refcc, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&rc1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rc2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cc1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cc2, 0, 0, DT_COMPLEX, _state, ae_true);

    threshold = maxn*100*ae_machineepsilon;
    result = ae_false;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N/K in [1,MX] such that max(M,N,K)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        k = 1+ae_randominteger(mx, _state);
        i = ae_randominteger(3, _state);
        if( i==0 )
        {
            m = mx;
        }
        if( i==1 )
        {
            n = mx;
        }
        if( i==2 )
        {
            k = mx;
        }
        
        /*
         * Initialize A/B/C by random matrices with size (MaxN+1)*(MaxN+1)
         */
        ae_matrix_set_length(&refra, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refrb, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refrc, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refca, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refcb, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refcc, maxn+1, maxn+1, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refrb.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refrc.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                refcb.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcb.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                refcc.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcc.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * test different types of operations, offsets, and so on...
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        ae_matrix_set_length(&rc1, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&rc2, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&cc1, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&cc2, maxn+1, maxn+1, _state);
        aoffsi = ae_randominteger(2, _state);
        aoffsj = ae_randominteger(2, _state);
        aoptype = ae_randominteger(3, _state);
        aoptyper = ae_randominteger(2, _state);
        boffsi = ae_randominteger(2, _state);
        boffsj = ae_randominteger(2, _state);
        boptype = ae_randominteger(3, _state);
        boptyper = ae_randominteger(2, _state);
        coffsi = ae_randominteger(2, _state);
        coffsj = ae_randominteger(2, _state);
        alphar = ae_randominteger(2, _state)*(2*ae_randomreal(_state)-1);
        betar = ae_randominteger(2, _state)*(2*ae_randomreal(_state)-1);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            alphac.x = 2*ae_randomreal(_state)-1;
            alphac.y = 2*ae_randomreal(_state)-1;
        }
        else
        {
            alphac = ae_complex_from_i(0);
        }
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            betac.x = 2*ae_randomreal(_state)-1;
            betac.y = 2*ae_randomreal(_state)-1;
        }
        else
        {
            betac = ae_complex_from_i(0);
        }
        
        /*
         * copy C
         */
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                rc1.ptr.pp_double[i][j] = refrc.ptr.pp_double[i][j];
                rc2.ptr.pp_double[i][j] = refrc.ptr.pp_double[i][j];
                cc1.ptr.pp_complex[i][j] = refcc.ptr.pp_complex[i][j];
                cc2.ptr.pp_complex[i][j] = refcc.ptr.pp_complex[i][j];
            }
        }
        
        /*
         * Test complex
         */
        cmatrixgemm(m, n, k, alphac, &refca, aoffsi, aoffsj, aoptype, &refcb, boffsi, boffsj, boptype, betac, &cc1, coffsi, coffsj, _state);
        testablasunit_refcmatrixgemm(m, n, k, alphac, &refca, aoffsi, aoffsj, aoptype, &refcb, boffsi, boffsj, boptype, betac, &cc2, coffsi, coffsj, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(cc1.ptr.pp_complex[i][j],cc2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        
        /*
         * Test real
         */
        rmatrixgemm(m, n, k, alphar, &refra, aoffsi, aoffsj, aoptyper, &refrb, boffsi, boffsj, boptyper, betar, &rc1, coffsi, coffsj, _state);
        testablasunit_refrmatrixgemm(m, n, k, alphar, &refra, aoffsi, aoffsj, aoptyper, &refrb, boffsi, boffsj, boptyper, betar, &rc2, coffsi, coffsj, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                result = result||ae_fp_greater(ae_fabs(rc1.ptr.pp_double[i][j]-rc2.ptr.pp_double[i][j], _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
transpose tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testtrans(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t boffsi;
    ae_int_t boffsj;
    double v1;
    double v2;
    double threshold;
    ae_matrix refra;
    ae_matrix refrb;
    ae_matrix refca;
    ae_matrix refcb;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&refrb, 0, sizeof(refrb));
    memset(&refca, 0, sizeof(refca));
    memset(&refcb, 0, sizeof(refcb));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refrb, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&refcb, 0, 0, DT_COMPLEX, _state, ae_true);

    result = ae_false;
    threshold = 1000*ae_machineepsilon;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         * Generate random V1 and V2 which are used to fill
         * RefRB/RefCB with control values.
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_randominteger(2, _state)==0 )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        v1 = ae_randomreal(_state);
        v2 = ae_randomreal(_state);
        
        /*
         * Initialize A by random matrix with size (MaxN+1)*(MaxN+1)
         * Fill B with control values
         */
        ae_matrix_set_length(&refra, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refrb, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refca, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refcb, maxn+1, maxn+1, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                refrb.ptr.pp_double[i][j] = i*v1+j*v2;
                refcb.ptr.pp_complex[i][j] = ae_complex_from_d(i*v1+j*v2);
            }
        }
        
        /*
         * test different offsets (zero or one)
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        aoffsi = ae_randominteger(2, _state);
        aoffsj = ae_randominteger(2, _state);
        boffsi = ae_randominteger(2, _state);
        boffsj = ae_randominteger(2, _state);
        rmatrixtranspose(m, n, &refra, aoffsi, aoffsj, &refrb, boffsi, boffsj, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                if( ((i<boffsi||i>=boffsi+n)||j<boffsj)||j>=boffsj+m )
                {
                    result = result||ae_fp_greater(ae_fabs(refrb.ptr.pp_double[i][j]-(v1*i+v2*j), _state),threshold);
                }
                else
                {
                    result = result||ae_fp_greater(ae_fabs(refrb.ptr.pp_double[i][j]-refra.ptr.pp_double[aoffsi+j-boffsj][aoffsj+i-boffsi], _state),threshold);
                }
            }
        }
        cmatrixtranspose(m, n, &refca, aoffsi, aoffsj, &refcb, boffsi, boffsj, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                if( ((i<boffsi||i>=boffsi+n)||j<boffsj)||j>=boffsj+m )
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub_d(refcb.ptr.pp_complex[i][j],v1*i+v2*j), _state),threshold);
                }
                else
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub(refcb.ptr.pp_complex[i][j],refca.ptr.pp_complex[aoffsi+j-boffsj][aoffsj+i-boffsi]), _state),threshold);
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
rank-1tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testrank1(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t uoffs;
    ae_int_t voffs;
    double threshold;
    double ralpha;
    ae_matrix refra;
    ae_matrix refrb;
    ae_matrix refca;
    ae_matrix refcb;
    ae_vector ru;
    ae_vector rv;
    ae_vector cu;
    ae_vector cv;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&refrb, 0, sizeof(refrb));
    memset(&refca, 0, sizeof(refca));
    memset(&refcb, 0, sizeof(refcb));
    memset(&ru, 0, sizeof(ru));
    memset(&rv, 0, sizeof(rv));
    memset(&cu, 0, sizeof(cu));
    memset(&cv, 0, sizeof(cv));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refrb, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&refcb, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&ru, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&rv, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&cu, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&cv, 0, DT_COMPLEX, _state, ae_true);

    result = ae_false;
    threshold = 1000*ae_machineepsilon;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_randominteger(2, _state)==0 )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize A by random matrix with size (MaxN+1)*(MaxN+1)
         * Fill B with control values
         */
        ae_matrix_set_length(&refra, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&refrb, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&refca, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&refcb, maxn+maxn, maxn+maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refrb.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refcb.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcb.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        ae_vector_set_length(&ru, 2*m, _state);
        ae_vector_set_length(&cu, 2*m, _state);
        for(i=0; i<=2*m-1; i++)
        {
            ru.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            cu.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            cu.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
        }
        ae_vector_set_length(&rv, 2*n, _state);
        ae_vector_set_length(&cv, 2*n, _state);
        for(i=0; i<=2*n-1; i++)
        {
            rv.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            cv.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            cv.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
        }
        
        /*
         * Generate random offsets of all operands and random coefficients.
         */
        aoffsi = ae_randominteger(maxn, _state);
        aoffsj = ae_randominteger(maxn, _state);
        uoffs = ae_randominteger(m, _state);
        voffs = ae_randominteger(n, _state);
        ralpha = ae_randomreal(_state)-0.5;
        
        /*
         * Test CMatrixRank1() and deprecated RMatrixRank1()
         */
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refca.ptr.pp_complex[i][j] = refcb.ptr.pp_complex[i][j];
            }
        }
        cmatrixrank1(m, n, &refca, aoffsi, aoffsj, &cu, uoffs, &cv, voffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                if( ((i<aoffsi||i>=aoffsi+m)||j<aoffsj)||j>=aoffsj+n )
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub(refca.ptr.pp_complex[i][j],refcb.ptr.pp_complex[i][j]), _state),threshold);
                }
                else
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub(refca.ptr.pp_complex[i][j],ae_c_add(refcb.ptr.pp_complex[i][j],ae_c_mul(cu.ptr.p_complex[i-aoffsi+uoffs],cv.ptr.p_complex[j-aoffsj+voffs]))), _state),threshold);
                }
            }
        }
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refra.ptr.pp_double[i][j] = refrb.ptr.pp_double[i][j];
            }
        }
        rmatrixrank1(m, n, &refra, aoffsi, aoffsj, &ru, uoffs, &rv, voffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                if( ((i<aoffsi||i>=aoffsi+m)||j<aoffsj)||j>=aoffsj+n )
                {
                    result = result||ae_fp_greater(ae_fabs(refra.ptr.pp_double[i][j]-refrb.ptr.pp_double[i][j], _state),threshold);
                }
                else
                {
                    result = result||ae_fp_greater(ae_fabs(refra.ptr.pp_double[i][j]-(refrb.ptr.pp_double[i][j]+ru.ptr.p_double[i-aoffsi+uoffs]*rv.ptr.p_double[j-aoffsj+voffs]), _state),threshold);
                }
            }
        }
        
        /*
         * Test modern RMatrixGER()
         */
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refra.ptr.pp_double[i][j] = refrb.ptr.pp_double[i][j];
            }
        }
        rmatrixger(m, n, &refra, aoffsi, aoffsj, ralpha, &ru, uoffs, &rv, voffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                if( ((i<aoffsi||i>=aoffsi+m)||j<aoffsj)||j>=aoffsj+n )
                {
                    ae_set_error_flag(&result, ae_fp_neq(ae_fabs(refra.ptr.pp_double[i][j]-refrb.ptr.pp_double[i][j], _state),0.0), __FILE__, __LINE__, "testablasunit.ap:1145");
                }
                else
                {
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(refra.ptr.pp_double[i][j]-(refrb.ptr.pp_double[i][j]+ralpha*ru.ptr.p_double[i-aoffsi+uoffs]*rv.ptr.p_double[j-aoffsj+voffs]), _state),threshold), __FILE__, __LINE__, "testablasunit.ap:1147");
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
MV tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testgemv(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t xoffs;
    ae_int_t yoffs;
    ae_int_t opca;
    ae_int_t opra;
    double threshold;
    double ralpha;
    double rbeta;
    double rv1;
    double rv2;
    ae_complex cv1;
    ae_complex cv2;
    ae_matrix refra;
    ae_matrix refca;
    ae_vector rx;
    ae_vector ry;
    ae_vector cx;
    ae_vector cy;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&refca, 0, sizeof(refca));
    memset(&rx, 0, sizeof(rx));
    memset(&ry, 0, sizeof(ry));
    memset(&cx, 0, sizeof(cx));
    memset(&cy, 0, sizeof(cy));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&rx, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ry, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&cx, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&cy, 0, DT_COMPLEX, _state, ae_true);

    result = ae_false;
    threshold = 1000*ae_machineepsilon;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_randominteger(2, _state)==0 )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize A by random matrix with size (MaxN+MaxN)*(MaxN+MaxN)
         * Initialize X by random vector with size (MaxN+MaxN)
         * Fill Y by control values
         */
        ae_matrix_set_length(&refra, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&refca, maxn+maxn, maxn+maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        ae_vector_set_length(&rx, 2*maxn, _state);
        ae_vector_set_length(&cx, 2*maxn, _state);
        ae_vector_set_length(&ry, 2*maxn, _state);
        ae_vector_set_length(&cy, 2*maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            rx.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            cx.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            cx.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
        }
        
        /*
         * Select random offsets and operations.
         *
         * To avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        aoffsi = ae_randominteger(maxn, _state);
        aoffsj = ae_randominteger(maxn, _state);
        xoffs = ae_randominteger(maxn, _state);
        yoffs = ae_randominteger(maxn, _state);
        opca = ae_randominteger(3, _state);
        opra = ae_randominteger(2, _state);
        ralpha = (ae_randomreal(_state)-0.5)*ae_randominteger(2, _state);
        rbeta = (ae_randomreal(_state)-0.5)*ae_randominteger(2, _state);
        
        /*
         * Test CMatrixMV and deprecated RMatrixMV
         */
        for(i=0; i<=2*maxn-1; i++)
        {
            cy.ptr.p_complex[i] = ae_complex_from_i(i);
        }
        cmatrixmv(m, n, &refca, aoffsi, aoffsj, opca, &cx, xoffs, &cy, yoffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            if( i<yoffs||i>=yoffs+m )
            {
                result = result||ae_c_neq_d(cy.ptr.p_complex[i],(double)(i));
            }
            else
            {
                cv1 = cy.ptr.p_complex[i];
                cv2 = ae_complex_from_d(0.0);
                if( opca==0 )
                {
                    cv2 = ae_v_cdotproduct(&refca.ptr.pp_complex[aoffsi+i-yoffs][aoffsj], 1, "N", &cx.ptr.p_complex[xoffs], 1, "N", ae_v_len(aoffsj,aoffsj+n-1));
                }
                if( opca==1 )
                {
                    cv2 = ae_v_cdotproduct(&refca.ptr.pp_complex[aoffsi][aoffsj+i-yoffs], refca.stride, "N", &cx.ptr.p_complex[xoffs], 1, "N", ae_v_len(aoffsi,aoffsi+n-1));
                }
                if( opca==2 )
                {
                    cv2 = ae_v_cdotproduct(&refca.ptr.pp_complex[aoffsi][aoffsj+i-yoffs], refca.stride, "Conj", &cx.ptr.p_complex[xoffs], 1, "N", ae_v_len(aoffsi,aoffsi+n-1));
                }
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(cv1,cv2), _state),threshold);
            }
        }
        for(i=0; i<=2*maxn-1; i++)
        {
            ry.ptr.p_double[i] = (double)(i);
        }
        rmatrixmv(m, n, &refra, aoffsi, aoffsj, opra, &rx, xoffs, &ry, yoffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            if( i<yoffs||i>=yoffs+m )
            {
                result = result||ae_fp_neq(ry.ptr.p_double[i],(double)(i));
            }
            else
            {
                rv1 = ry.ptr.p_double[i];
                rv2 = (double)(0);
                if( opra==0 )
                {
                    rv2 = ae_v_dotproduct(&refra.ptr.pp_double[aoffsi+i-yoffs][aoffsj], 1, &rx.ptr.p_double[xoffs], 1, ae_v_len(aoffsj,aoffsj+n-1));
                }
                if( opra==1 )
                {
                    rv2 = ae_v_dotproduct(&refra.ptr.pp_double[aoffsi][aoffsj+i-yoffs], refra.stride, &rx.ptr.p_double[xoffs], 1, ae_v_len(aoffsi,aoffsi+n-1));
                }
                result = result||ae_fp_greater(ae_fabs(rv1-rv2, _state),threshold);
            }
        }
        
        /*
         * Test modern RMatrixGEMV()
         */
        for(i=0; i<=2*maxn-1; i++)
        {
            ry.ptr.p_double[i] = (double)(i);
        }
        rmatrixgemv(m, n, ralpha, &refra, aoffsi, aoffsj, opra, &rx, xoffs, rbeta, &ry, yoffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            if( i<yoffs||i>=yoffs+m )
            {
                ae_set_error_flag(&result, ae_fp_neq(ry.ptr.p_double[i],(double)(i)), __FILE__, __LINE__, "testablasunit.ap:1295");
            }
            else
            {
                rv1 = ry.ptr.p_double[i];
                rv2 = (double)(0);
                if( opra==0 )
                {
                    rv2 = ae_v_dotproduct(&refra.ptr.pp_double[aoffsi+i-yoffs][aoffsj], 1, &rx.ptr.p_double[xoffs], 1, ae_v_len(aoffsj,aoffsj+n-1));
                }
                if( opra==1 )
                {
                    rv2 = ae_v_dotproduct(&refra.ptr.pp_double[aoffsi][aoffsj+i-yoffs], refra.stride, &rx.ptr.p_double[xoffs], 1, ae_v_len(aoffsi,aoffsi+n-1));
                }
                rv2 = rbeta*i+ralpha*rv2;
                ae_set_error_flag(&result, ae_fp_greater(ae_fabs(rv1-rv2, _state),threshold), __FILE__, __LINE__, "testablasunit.ap:1305");
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
SYMV/SYVMV tests

Sets error flag on failure, ignores on success.
*************************************************************************/
static void testablasunit_testsymv(ae_int_t minn,
     ae_int_t maxn,
     ae_bool* errorflag,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t xoffs;
    ae_int_t yoffs;
    ae_bool isuppera;
    double threshold;
    double ralpha;
    double rbeta;
    double rv1;
    double rv2;
    ae_matrix refra;
    ae_vector rx;
    ae_vector ry;
    ae_vector rz;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&rx, 0, sizeof(rx));
    memset(&ry, 0, sizeof(ry));
    memset(&rz, 0, sizeof(rz));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&rx, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ry, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&rz, 0, DT_REAL, _state, ae_true);

    threshold = 1000*ae_machineepsilon;
    for(n=minn; n<=maxn; n++)
    {
        
        /*
         * Initialize A by random matrix with size (MaxN+MaxN)*(MaxN+MaxN)
         * Initialize X by random vector with size (MaxN+MaxN)
         * Fill Y by control values
         */
        ae_matrix_set_length(&refra, maxn+maxn, maxn+maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        ae_vector_set_length(&rx, 2*maxn, _state);
        ae_vector_set_length(&ry, 2*maxn, _state);
        ae_vector_set_length(&rz, 2*maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            rx.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        
        /*
         * Select random offsets and operations.
         *
         * To avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        aoffsi = ae_randominteger(maxn, _state);
        aoffsj = ae_randominteger(maxn, _state);
        xoffs = ae_randominteger(maxn, _state);
        yoffs = ae_randominteger(maxn, _state);
        isuppera = ae_fp_greater(ae_randomreal(_state),0.5);
        ralpha = (ae_randomreal(_state)-0.5)*ae_randominteger(2, _state);
        rbeta = (ae_randomreal(_state)-0.5)*ae_randominteger(2, _state);
        
        /*
         * Test RMatrixSYMV()
         */
        for(i=0; i<=2*maxn-1; i++)
        {
            ry.ptr.p_double[i] = (double)(i);
            rz.ptr.p_double[i] = (double)(i);
        }
        rmatrixsymv(n, ralpha, &refra, aoffsi, aoffsj, isuppera, &rx, xoffs, rbeta, &ry, yoffs, _state);
        testablasunit_refrmatrixsymv(n, ralpha, &refra, aoffsi, aoffsj, isuppera, &rx, xoffs, rbeta, &rz, yoffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            if( i<yoffs||i>=yoffs+n )
            {
                ae_set_error_flag(errorflag, ae_fp_neq(ry.ptr.p_double[i],(double)(i)), __FILE__, __LINE__, "testablasunit.ap:1393");
            }
            else
            {
                ae_set_error_flag(errorflag, ae_fp_greater(ae_fabs(ry.ptr.p_double[i]-rz.ptr.p_double[i], _state),threshold*maxreal3(ae_fabs(ry.ptr.p_double[i], _state), ae_fabs(rz.ptr.p_double[i], _state), 1.0, _state)), __FILE__, __LINE__, "testablasunit.ap:1395");
            }
        }
        
        /*
         * Test RMatrixSYVMV()
         */
        rv1 = rmatrixsyvmv(n, &refra, aoffsi, aoffsj, isuppera, &rx, xoffs, &ry, _state);
        rv2 = testablasunit_refrmatrixsyvmv(n, &refra, aoffsi, aoffsj, isuppera, &rx, xoffs, _state);
        ae_set_error_flag(errorflag, ae_fp_greater(ae_fabs(rv1-rv2, _state),threshold*maxreal3(ae_fabs(rv1, _state), ae_fabs(rv2, _state), 1.0, _state)), __FILE__, __LINE__, "testablasunit.ap:1409");
    }
    ae_frame_leave(_state);
}


/*************************************************************************
TRSV tests

Sets error flag on failure, ignores on success.
*************************************************************************/
static void testablasunit_testtrsv(ae_int_t minn,
     ae_int_t maxn,
     ae_bool* errorflag,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t xoffs;
    ae_bool isuppera;
    ae_bool isunita;
    ae_int_t opa;
    double threshold;
    ae_matrix refra;
    ae_matrix ea;
    ae_vector rx;
    ae_vector ry;
    double v;

    ae_frame_make(_state, &_frame_block);
    memset(&refra, 0, sizeof(refra));
    memset(&ea, 0, sizeof(ea));
    memset(&rx, 0, sizeof(rx));
    memset(&ry, 0, sizeof(ry));
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ea, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&rx, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ry, 0, DT_REAL, _state, ae_true);

    for(n=minn; n<=maxn; n++)
    {
        
        /*
         * Decreased threshold because of ill-conditioning of randomly generated matrices
         */
        threshold = 1.0E-6*(1+n);
        
        /*
         * Initialize A by random matrix with size (MaxN+MaxN)*(MaxN+MaxN)
         * Initialize X by sparse random vector with size (MaxN+MaxN) (sparsity is important to test some branches of algorithm)
         * Fill Y by control values
         */
        ae_matrix_set_length(&refra, maxn+maxn, maxn+maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        ae_vector_set_length(&rx, 2*maxn, _state);
        ae_vector_set_length(&ry, 2*maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            rx.ptr.p_double[i] = (2*ae_randomreal(_state)-1)*ae_randominteger(3, _state);
        }
        
        /*
         * Select random offsets and operations.
         *
         * To avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         *
         * NOTE: in order to improve conditioning properties we add 10*Identity
         *       to purported diagonal of A
         */
        aoffsi = ae_randominteger(maxn, _state);
        aoffsj = ae_randominteger(maxn, _state);
        xoffs = ae_randominteger(maxn, _state);
        isuppera = ae_fp_greater(ae_randomreal(_state),0.5);
        isunita = ae_fp_greater(ae_randomreal(_state),0.5);
        opa = ae_randominteger(2, _state);
        for(i=0; i<=n-1; i++)
        {
            refra.ptr.pp_double[aoffsi+i][aoffsj+i] = refra.ptr.pp_double[aoffsi+i][aoffsj+i]+10;
        }
        
        /*
         * Test RMatrixTRSV():
         * * check that elements of RX beyond [XOffs,XOffs+N-1] are unchanged
         * * calculate RX:=TRSV(RX)
         * * extract effective A from RefRA to EA=array[N,N]
         * * compare product EA*RX, compare with copy of RX stored in RY
         */
        for(i=0; i<=2*maxn-1; i++)
        {
            ry.ptr.p_double[i] = rx.ptr.p_double[i];
        }
        rmatrixtrsv(n, &refra, aoffsi, aoffsj, isuppera, isunita, opa, &rx, xoffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            if( i<xoffs||i>xoffs+n-1 )
            {
                ae_set_error_flag(errorflag, ae_fp_neq(rx.ptr.p_double[i],ry.ptr.p_double[i]), __FILE__, __LINE__, "testablasunit.ap:1493");
            }
        }
        ae_matrix_set_length(&ea, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                v = refra.ptr.pp_double[aoffsi+i][aoffsj+j];
                if( (j<i&&isuppera)||(j>i&&!isuppera) )
                {
                    v = (double)(0);
                }
                if( isunita&&i==j )
                {
                    v = (double)(1);
                }
                if( opa==0 )
                {
                    ea.ptr.pp_double[i][j] = v;
                }
                else
                {
                    ea.ptr.pp_double[j][i] = v;
                }
            }
        }
        for(i=0; i<=n-1; i++)
        {
            v = ae_v_dotproduct(&ea.ptr.pp_double[i][0], 1, &rx.ptr.p_double[xoffs], 1, ae_v_len(0,n-1));
            ae_set_error_flag(errorflag, ae_fp_greater(ae_fabs(v-ry.ptr.p_double[xoffs+i], _state),threshold), __FILE__, __LINE__, "testablasunit.ap:1516");
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Special test.
On failure sets error flag, on success does not change it.
*************************************************************************/
static void testablasunit_spectest(ae_bool* errorflag, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix emptyr2;
    ae_matrix emptyc2;
    ae_matrix outputr2;
    ae_matrix outputc2;
    ae_int_t i;
    ae_int_t j;
    ae_int_t n;
    ae_int_t pass;

    ae_frame_make(_state, &_frame_block);
    memset(&emptyr2, 0, sizeof(emptyr2));
    memset(&emptyc2, 0, sizeof(emptyc2));
    memset(&outputr2, 0, sizeof(outputr2));
    memset(&outputc2, 0, sizeof(outputc2));
    ae_matrix_init(&emptyr2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&emptyc2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&outputr2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&outputc2, 0, 0, DT_COMPLEX, _state, ae_true);

    
    /*
     * Test that SYRK, GEMM and TRSM does not reference empty argument at all.
     *
     * In order to perform this test we pass empty (unallocated) matrix
     * with large offset; incorrect implementation will crash on such data.
     */
    n = 128+ae_randominteger(65, _state)-32;
    ae_matrix_set_length(&outputr2, n, n, _state);
    ae_matrix_set_length(&outputc2, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            outputr2.ptr.pp_double[i][j] = (double)(0);
            outputc2.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    for(pass=0; pass<=10; pass++)
    {
        rmatrixgemm(n, n, 0, 1.0, &emptyr2, 35345, 23453, ae_randominteger(2, _state), &emptyr2, 74764, 26845, ae_randominteger(2, _state), 1.0+ae_randominteger(2, _state), &outputr2, 0, 0, _state);
        rmatrixgemm(n, n, n, 0.0, &emptyr2, 35345, 23453, ae_randominteger(2, _state), &emptyr2, 74764, 26845, ae_randominteger(2, _state), 1.0+ae_randominteger(2, _state), &outputr2, 0, 0, _state);
        cmatrixgemm(n, n, 0, ae_complex_from_d(1.0), &emptyc2, 35345, 23453, ae_randominteger(3, _state), &emptyc2, 74764, 26845, ae_randominteger(3, _state), ae_complex_from_d(1.0+ae_randominteger(2, _state)), &outputc2, 0, 0, _state);
        cmatrixgemm(n, n, n, ae_complex_from_d(0.0), &emptyc2, 35345, 23453, ae_randominteger(3, _state), &emptyc2, 74764, 26845, ae_randominteger(3, _state), ae_complex_from_d(1.0+ae_randominteger(2, _state)), &outputc2, 0, 0, _state);
        rmatrixsyrk(n, 0, 1.0, &emptyr2, 54674, 34657, 2*ae_randominteger(2, _state), 1.0+ae_randominteger(2, _state), &outputr2, 0, 0, ae_fp_greater(ae_randomreal(_state),0.5), _state);
        rmatrixsyrk(n, n, 0.0, &emptyr2, 54674, 34657, 2*ae_randominteger(2, _state), 1.0+ae_randominteger(2, _state), &outputr2, 0, 0, ae_fp_greater(ae_randomreal(_state),0.5), _state);
        cmatrixherk(n, 0, 1.0, &emptyc2, 54674, 34657, 2*ae_randominteger(2, _state), 1.0+ae_randominteger(2, _state), &outputc2, 0, 0, ae_fp_greater(ae_randomreal(_state),0.5), _state);
        cmatrixherk(n, n, 0.0, &emptyc2, 54674, 34657, 2*ae_randominteger(2, _state), 1.0+ae_randominteger(2, _state), &outputc2, 0, 0, ae_fp_greater(ae_randomreal(_state),0.5), _state);
        rmatrixrighttrsm(0, 0, &emptyr2, 63463, 36345, ae_fp_greater(ae_randomreal(_state),0.5), ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(2, _state), &outputr2, 0, 0, _state);
        rmatrixlefttrsm(0, 0, &emptyr2, 63463, 36345, ae_fp_greater(ae_randomreal(_state),0.5), ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(2, _state), &outputr2, 0, 0, _state);
        cmatrixrighttrsm(0, 0, &emptyc2, 63463, 36345, ae_fp_greater(ae_randomreal(_state),0.5), ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(3, _state), &outputc2, 0, 0, _state);
        cmatrixlefttrsm(0, 0, &emptyc2, 63463, 36345, ae_fp_greater(ae_randomreal(_state),0.5), ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(3, _state), &outputc2, 0, 0, _state);
    }
    ae_frame_leave(_state);
}


/*************************************************************************
COPY (Level 2) tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testcopy(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t boffsi;
    ae_int_t boffsj;
    double threshold;
    ae_matrix ra;
    ae_matrix rb;
    ae_matrix ca;
    ae_matrix cb;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&ra, 0, sizeof(ra));
    memset(&rb, 0, sizeof(rb));
    memset(&ca, 0, sizeof(ca));
    memset(&cb, 0, sizeof(cb));
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rb, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cb, 0, 0, DT_COMPLEX, _state, ae_true);

    result = ae_false;
    threshold = 1000*ae_machineepsilon;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_randominteger(2, _state)==0 )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize A by random matrix with size (MaxN+MaxN)*(MaxN+MaxN)
         * Initialize X by random vector with size (MaxN+MaxN)
         * Fill Y by control values
         */
        ae_matrix_set_length(&ra, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&ca, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&rb, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&cb, maxn+maxn, maxn+maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                rb.ptr.pp_double[i][j] = (double)(1+2*i+3*j);
                cb.ptr.pp_complex[i][j] = ae_complex_from_i(1+2*i+3*j);
            }
        }
        
        /*
         * test different offsets (zero or one)
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        aoffsi = ae_randominteger(maxn, _state);
        aoffsj = ae_randominteger(maxn, _state);
        boffsi = ae_randominteger(maxn, _state);
        boffsj = ae_randominteger(maxn, _state);
        cmatrixcopy(m, n, &ca, aoffsi, aoffsj, &cb, boffsi, boffsj, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                if( ((i<boffsi||i>=boffsi+m)||j<boffsj)||j>=boffsj+n )
                {
                    result = result||ae_c_neq_d(cb.ptr.pp_complex[i][j],(double)(1+2*i+3*j));
                }
                else
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[aoffsi+i-boffsi][aoffsj+j-boffsj],cb.ptr.pp_complex[i][j]), _state),threshold);
                }
            }
        }
        rmatrixcopy(m, n, &ra, aoffsi, aoffsj, &rb, boffsi, boffsj, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                if( ((i<boffsi||i>=boffsi+m)||j<boffsj)||j>=boffsj+n )
                {
                    result = result||ae_fp_neq(rb.ptr.pp_double[i][j],(double)(1+2*i+3*j));
                }
                else
                {
                    result = result||ae_fp_greater(ae_fabs(ra.ptr.pp_double[aoffsi+i-boffsi][aoffsj+j-boffsj]-rb.ptr.pp_double[i][j], _state),threshold);
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
COPY (Level 1) tests

On failure sets error flag, on success does not touch it
*************************************************************************/
static void testablasunit_testcopy1(ae_int_t minn,
     ae_int_t maxn,
     ae_bool* err,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t ss;
    ae_int_t i;
    ae_int_t aoffs;
    ae_int_t boffs;
    double threshold;
    ae_vector ra;
    ae_vector rb;

    ae_frame_make(_state, &_frame_block);
    memset(&ra, 0, sizeof(ra));
    memset(&rb, 0, sizeof(rb));
    ae_vector_init(&ra, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&rb, 0, DT_REAL, _state, ae_true);

    threshold = 1000*ae_machineepsilon;
    for(ss=minn; ss<=maxn; ss++)
    {
        
        /*
         * Initialize A by random vector
         * Initialize X by random vector
         * Fill Y by control values
         */
        ae_vector_set_length(&ra, 2*maxn, _state);
        ae_vector_set_length(&rb, 2*maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            ra.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            rb.ptr.p_double[i] = (double)(1+2*i);
        }
        
        /*
         * test different offsets (zero or one)
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        aoffs = ae_randominteger(maxn, _state);
        boffs = ae_randominteger(maxn, _state);
        rvectorcopy(ss, &ra, aoffs, &rb, boffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            if( i<boffs||i>=boffs+ss )
            {
                ae_set_error_flag(err, ae_fp_neq(rb.ptr.p_double[i],(double)(1+2*i)), __FILE__, __LINE__, "testablasunit.ap:1762");
            }
            else
            {
                ae_set_error_flag(err, ae_fp_greater(ae_fabs(ra.ptr.p_double[aoffs+i-boffs]-rb.ptr.p_double[i], _state),threshold), __FILE__, __LINE__, "testablasunit.ap:1764");
            }
        }
    }
    ae_frame_leave(_state);
}


static void testablasunit_testreflections(ae_bool* errorflag,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t n;
    ae_int_t m;
    ae_int_t maxmn;
    ae_vector x;
    ae_vector v;
    ae_vector work;
    ae_matrix h;
    ae_matrix a;
    ae_matrix b;
    ae_matrix c;
    double tmp;
    double beta;
    double tau;
    double err;
    double mer;
    double mel;
    double meg;
    ae_int_t pass;
    ae_int_t passcount;
    double threshold;
    ae_int_t tasktype;
    double xscale;

    ae_frame_make(_state, &_frame_block);
    memset(&x, 0, sizeof(x));
    memset(&v, 0, sizeof(v));
    memset(&work, 0, sizeof(work));
    memset(&h, 0, sizeof(h));
    memset(&a, 0, sizeof(a));
    memset(&b, 0, sizeof(b));
    memset(&c, 0, sizeof(c));
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&v, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&work, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&h, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c, 0, 0, DT_REAL, _state, ae_true);

    passcount = 10;
    threshold = 100*ae_machineepsilon;
    mer = (double)(0);
    mel = (double)(0);
    meg = (double)(0);
    for(pass=1; pass<=passcount; pass++)
    {
        for(n=1; n<=10; n++)
        {
            for(m=1; m<=10; m++)
            {
                
                /*
                 * Task
                 */
                n = 1+ae_randominteger(10, _state);
                m = 1+ae_randominteger(10, _state);
                maxmn = ae_maxint(m, n, _state);
                
                /*
                 * Initialize
                 */
                ae_vector_set_length(&x, maxmn+1, _state);
                ae_vector_set_length(&v, maxmn+1, _state);
                ae_vector_set_length(&work, maxmn+1, _state);
                ae_matrix_set_length(&h, maxmn+1, maxmn+1, _state);
                ae_matrix_set_length(&a, maxmn+1, maxmn+1, _state);
                ae_matrix_set_length(&b, maxmn+1, maxmn+1, _state);
                ae_matrix_set_length(&c, maxmn+1, maxmn+1, _state);
                
                /*
                 * GenerateReflection, three tasks are possible:
                 * * random X
                 * * zero X
                 * * non-zero X[1], all other are zeros
                 * * random X, near underflow scale
                 * * random X, near overflow scale
                 */
                for(tasktype=0; tasktype<=4; tasktype++)
                {
                    xscale = (double)(1);
                    if( tasktype==0 )
                    {
                        for(i=1; i<=n; i++)
                        {
                            x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    if( tasktype==1 )
                    {
                        for(i=1; i<=n; i++)
                        {
                            x.ptr.p_double[i] = (double)(0);
                        }
                    }
                    if( tasktype==2 )
                    {
                        x.ptr.p_double[1] = 2*ae_randomreal(_state)-1;
                        for(i=2; i<=n; i++)
                        {
                            x.ptr.p_double[i] = (double)(0);
                        }
                    }
                    if( tasktype==3 )
                    {
                        for(i=1; i<=n; i++)
                        {
                            x.ptr.p_double[i] = (ae_randominteger(21, _state)-10)*ae_minrealnumber;
                        }
                        xscale = 10*ae_minrealnumber;
                    }
                    if( tasktype==4 )
                    {
                        for(i=1; i<=n; i++)
                        {
                            x.ptr.p_double[i] = (2*ae_randomreal(_state)-1)*ae_maxrealnumber;
                        }
                        xscale = ae_maxrealnumber;
                    }
                    ae_v_move(&v.ptr.p_double[1], 1, &x.ptr.p_double[1], 1, ae_v_len(1,n));
                    generatereflection(&v, n, &tau, _state);
                    beta = v.ptr.p_double[1];
                    v.ptr.p_double[1] = (double)(1);
                    for(i=1; i<=n; i++)
                    {
                        for(j=1; j<=n; j++)
                        {
                            if( i==j )
                            {
                                h.ptr.pp_double[i][j] = 1-tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                            }
                            else
                            {
                                h.ptr.pp_double[i][j] = -tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                            }
                        }
                    }
                    err = (double)(0);
                    for(i=1; i<=n; i++)
                    {
                        tmp = ae_v_dotproduct(&h.ptr.pp_double[i][1], 1, &x.ptr.p_double[1], 1, ae_v_len(1,n));
                        if( i==1 )
                        {
                            err = ae_maxreal(err, ae_fabs(tmp-beta, _state), _state);
                        }
                        else
                        {
                            err = ae_maxreal(err, ae_fabs(tmp, _state), _state);
                        }
                    }
                    meg = ae_maxreal(meg, err/xscale, _state);
                }
                
                /*
                 * ApplyReflectionFromTheLeft
                 */
                for(i=1; i<=m; i++)
                {
                    x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                    v.ptr.p_double[i] = x.ptr.p_double[i];
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        b.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
                    }
                }
                generatereflection(&v, m, &tau, _state);
                beta = v.ptr.p_double[1];
                v.ptr.p_double[1] = (double)(1);
                applyreflectionfromtheleft(&b, tau, &v, 1, m, 1, n, &work, _state);
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=m; j++)
                    {
                        if( i==j )
                        {
                            h.ptr.pp_double[i][j] = 1-tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                        }
                        else
                        {
                            h.ptr.pp_double[i][j] = -tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                        }
                    }
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        tmp = ae_v_dotproduct(&h.ptr.pp_double[i][1], 1, &a.ptr.pp_double[1][j], a.stride, ae_v_len(1,m));
                        c.ptr.pp_double[i][j] = tmp;
                    }
                }
                err = (double)(0);
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        err = ae_maxreal(err, ae_fabs(b.ptr.pp_double[i][j]-c.ptr.pp_double[i][j], _state), _state);
                    }
                }
                mel = ae_maxreal(mel, err, _state);
                
                /*
                 * ApplyReflectionFromTheRight
                 */
                for(i=1; i<=n; i++)
                {
                    x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                    v.ptr.p_double[i] = x.ptr.p_double[i];
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        b.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
                    }
                }
                generatereflection(&v, n, &tau, _state);
                beta = v.ptr.p_double[1];
                v.ptr.p_double[1] = (double)(1);
                applyreflectionfromtheright(&b, tau, &v, 1, m, 1, n, &work, _state);
                for(i=1; i<=n; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        if( i==j )
                        {
                            h.ptr.pp_double[i][j] = 1-tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                        }
                        else
                        {
                            h.ptr.pp_double[i][j] = -tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                        }
                    }
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        tmp = ae_v_dotproduct(&a.ptr.pp_double[i][1], 1, &h.ptr.pp_double[1][j], h.stride, ae_v_len(1,n));
                        c.ptr.pp_double[i][j] = tmp;
                    }
                }
                err = (double)(0);
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        err = ae_maxreal(err, ae_fabs(b.ptr.pp_double[i][j]-c.ptr.pp_double[i][j], _state), _state);
                    }
                }
                mer = ae_maxreal(mer, err, _state);
            }
        }
    }
    
    /*
     * Overflow crash test
     */
    ae_vector_set_length(&x, 10+1, _state);
    ae_vector_set_length(&v, 10+1, _state);
    for(i=1; i<=10; i++)
    {
        v.ptr.p_double[i] = ae_maxrealnumber*0.01*(2*ae_randomreal(_state)-1);
    }
    generatereflection(&v, 10, &tau, _state);
    
    /*
     * Result
     */
    ae_set_error_flag(errorflag, (ae_fp_greater(meg,threshold)||ae_fp_greater(mel,threshold))||ae_fp_greater(mer,threshold), __FILE__, __LINE__, "testablasunit.ap:1956");
    ae_frame_leave(_state);
}


/*************************************************************************
Reference implementation

  -- ALGLIB routine --
     15.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refcmatrixrighttrsm(ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Complex */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix a2;
    ae_vector tx;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;
    ae_bool rupper;

    ae_frame_make(_state, &_frame_block);
    memset(&a1, 0, sizeof(a1));
    memset(&a2, 0, sizeof(a2));
    memset(&tx, 0, sizeof(tx));
    ae_matrix_init(&a1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&a2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&tx, 0, DT_COMPLEX, _state, ae_true);

    if( n*m==0 )
    {
        ae_frame_leave(_state);
        return;
    }
    ae_matrix_set_length(&a1, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a1.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    if( isupper )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                a1.ptr.pp_complex[i][j] = a->ptr.pp_complex[i1+i][j1+j];
            }
        }
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                a1.ptr.pp_complex[i][j] = a->ptr.pp_complex[i1+i][j1+j];
            }
        }
    }
    rupper = isupper;
    if( isunit )
    {
        for(i=0; i<=n-1; i++)
        {
            a1.ptr.pp_complex[i][i] = ae_complex_from_i(1);
        }
    }
    ae_matrix_set_length(&a2, n, n, _state);
    if( optype==0 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_complex[i][j] = a1.ptr.pp_complex[i][j];
            }
        }
    }
    if( optype==1 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_complex[i][j] = a1.ptr.pp_complex[j][i];
            }
        }
        rupper = !rupper;
    }
    if( optype==2 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_complex[i][j] = ae_c_conj(a1.ptr.pp_complex[j][i], _state);
            }
        }
        rupper = !rupper;
    }
    testablasunit_internalcmatrixtrinverse(&a2, n, rupper, ae_false, _state);
    ae_vector_set_length(&tx, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_cmove(&tx.ptr.p_complex[0], 1, &x->ptr.pp_complex[i2+i][j2], 1, "N", ae_v_len(0,n-1));
        for(j=0; j<=n-1; j++)
        {
            vc = ae_v_cdotproduct(&tx.ptr.p_complex[0], 1, "N", &a2.ptr.pp_complex[0][j], a2.stride, "N", ae_v_len(0,n-1));
            x->ptr.pp_complex[i2+i][j2+j] = vc;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference implementation

  -- ALGLIB routine --
     15.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refcmatrixlefttrsm(ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Complex */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix a2;
    ae_vector tx;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;
    ae_bool rupper;

    ae_frame_make(_state, &_frame_block);
    memset(&a1, 0, sizeof(a1));
    memset(&a2, 0, sizeof(a2));
    memset(&tx, 0, sizeof(tx));
    ae_matrix_init(&a1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&a2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&tx, 0, DT_COMPLEX, _state, ae_true);

    if( n*m==0 )
    {
        ae_frame_leave(_state);
        return;
    }
    ae_matrix_set_length(&a1, m, m, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            a1.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    if( isupper )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=i; j<=m-1; j++)
            {
                a1.ptr.pp_complex[i][j] = a->ptr.pp_complex[i1+i][j1+j];
            }
        }
    }
    else
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                a1.ptr.pp_complex[i][j] = a->ptr.pp_complex[i1+i][j1+j];
            }
        }
    }
    rupper = isupper;
    if( isunit )
    {
        for(i=0; i<=m-1; i++)
        {
            a1.ptr.pp_complex[i][i] = ae_complex_from_i(1);
        }
    }
    ae_matrix_set_length(&a2, m, m, _state);
    if( optype==0 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_complex[i][j] = a1.ptr.pp_complex[i][j];
            }
        }
    }
    if( optype==1 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_complex[i][j] = a1.ptr.pp_complex[j][i];
            }
        }
        rupper = !rupper;
    }
    if( optype==2 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_complex[i][j] = ae_c_conj(a1.ptr.pp_complex[j][i], _state);
            }
        }
        rupper = !rupper;
    }
    testablasunit_internalcmatrixtrinverse(&a2, m, rupper, ae_false, _state);
    ae_vector_set_length(&tx, m, _state);
    for(j=0; j<=n-1; j++)
    {
        ae_v_cmove(&tx.ptr.p_complex[0], 1, &x->ptr.pp_complex[i2][j2+j], x->stride, "N", ae_v_len(0,m-1));
        for(i=0; i<=m-1; i++)
        {
            vc = ae_v_cdotproduct(&a2.ptr.pp_complex[i][0], 1, "N", &tx.ptr.p_complex[0], 1, "N", ae_v_len(0,m-1));
            x->ptr.pp_complex[i2+i][j2+j] = vc;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference implementation

  -- ALGLIB routine --
     15.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refrmatrixrighttrsm(ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Real    */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix a2;
    ae_vector tx;
    ae_int_t i;
    ae_int_t j;
    double vr;
    ae_bool rupper;

    ae_frame_make(_state, &_frame_block);
    memset(&a1, 0, sizeof(a1));
    memset(&a2, 0, sizeof(a2));
    memset(&tx, 0, sizeof(tx));
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a2, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tx, 0, DT_REAL, _state, ae_true);

    if( n*m==0 )
    {
        ae_frame_leave(_state);
        return;
    }
    ae_matrix_set_length(&a1, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a1.ptr.pp_double[i][j] = (double)(0);
        }
    }
    if( isupper )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                a1.ptr.pp_double[i][j] = a->ptr.pp_double[i1+i][j1+j];
            }
        }
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                a1.ptr.pp_double[i][j] = a->ptr.pp_double[i1+i][j1+j];
            }
        }
    }
    rupper = isupper;
    if( isunit )
    {
        for(i=0; i<=n-1; i++)
        {
            a1.ptr.pp_double[i][i] = (double)(1);
        }
    }
    ae_matrix_set_length(&a2, n, n, _state);
    if( optype==0 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j];
            }
        }
    }
    if( optype==1 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_double[i][j] = a1.ptr.pp_double[j][i];
            }
        }
        rupper = !rupper;
    }
    testablasunit_internalrmatrixtrinverse(&a2, n, rupper, ae_false, _state);
    ae_vector_set_length(&tx, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_move(&tx.ptr.p_double[0], 1, &x->ptr.pp_double[i2+i][j2], 1, ae_v_len(0,n-1));
        for(j=0; j<=n-1; j++)
        {
            vr = ae_v_dotproduct(&tx.ptr.p_double[0], 1, &a2.ptr.pp_double[0][j], a2.stride, ae_v_len(0,n-1));
            x->ptr.pp_double[i2+i][j2+j] = vr;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference implementation

  -- ALGLIB routine --
     15.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refrmatrixlefttrsm(ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Real    */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix a2;
    ae_vector tx;
    ae_int_t i;
    ae_int_t j;
    double vr;
    ae_bool rupper;

    ae_frame_make(_state, &_frame_block);
    memset(&a1, 0, sizeof(a1));
    memset(&a2, 0, sizeof(a2));
    memset(&tx, 0, sizeof(tx));
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a2, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tx, 0, DT_REAL, _state, ae_true);

    if( n*m==0 )
    {
        ae_frame_leave(_state);
        return;
    }
    ae_matrix_set_length(&a1, m, m, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            a1.ptr.pp_double[i][j] = (double)(0);
        }
    }
    if( isupper )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=i; j<=m-1; j++)
            {
                a1.ptr.pp_double[i][j] = a->ptr.pp_double[i1+i][j1+j];
            }
        }
    }
    else
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                a1.ptr.pp_double[i][j] = a->ptr.pp_double[i1+i][j1+j];
            }
        }
    }
    rupper = isupper;
    if( isunit )
    {
        for(i=0; i<=m-1; i++)
        {
            a1.ptr.pp_double[i][i] = (double)(1);
        }
    }
    ae_matrix_set_length(&a2, m, m, _state);
    if( optype==0 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j];
            }
        }
    }
    if( optype==1 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_double[i][j] = a1.ptr.pp_double[j][i];
            }
        }
        rupper = !rupper;
    }
    testablasunit_internalrmatrixtrinverse(&a2, m, rupper, ae_false, _state);
    ae_vector_set_length(&tx, m, _state);
    for(j=0; j<=n-1; j++)
    {
        ae_v_move(&tx.ptr.p_double[0], 1, &x->ptr.pp_double[i2][j2+j], x->stride, ae_v_len(0,m-1));
        for(i=0; i<=m-1; i++)
        {
            vr = ae_v_dotproduct(&a2.ptr.pp_double[i][0], 1, &tx.ptr.p_double[0], 1, ae_v_len(0,m-1));
            x->ptr.pp_double[i2+i][j2+j] = vr;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Internal subroutine.
Triangular matrix inversion

  -- LAPACK routine (version 3.0) --
     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
     Courant Institute, Argonne National Lab, and Rice University
     February 29, 1992
*************************************************************************/
static ae_bool testablasunit_internalcmatrixtrinverse(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool nounit;
    ae_int_t i;
    ae_int_t j;
    ae_complex v;
    ae_complex ajj;
    ae_vector t;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&t, 0, sizeof(t));
    ae_vector_init(&t, 0, DT_COMPLEX, _state, ae_true);

    result = ae_true;
    ae_vector_set_length(&t, n-1+1, _state);
    
    /*
     * Test the input parameters.
     */
    nounit = !isunittriangular;
    if( isupper )
    {
        
        /*
         * Compute inverse of upper triangular matrix.
         */
        for(j=0; j<=n-1; j++)
        {
            if( nounit )
            {
                if( ae_c_eq_d(a->ptr.pp_complex[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_complex[j][j] = ae_c_d_div(1,a->ptr.pp_complex[j][j]);
                ajj = ae_c_neg(a->ptr.pp_complex[j][j]);
            }
            else
            {
                ajj = ae_complex_from_i(-1);
            }
            
            /*
             * Compute elements 1:j-1 of j-th column.
             */
            if( j>0 )
            {
                ae_v_cmove(&t.ptr.p_complex[0], 1, &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,j-1));
                for(i=0; i<=j-1; i++)
                {
                    if( i+1<j )
                    {
                        v = ae_v_cdotproduct(&a->ptr.pp_complex[i][i+1], 1, "N", &t.ptr.p_complex[i+1], 1, "N", ae_v_len(i+1,j-1));
                    }
                    else
                    {
                        v = ae_complex_from_i(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,ae_c_mul(a->ptr.pp_complex[i][i],t.ptr.p_complex[i]));
                    }
                    else
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,t.ptr.p_complex[i]);
                    }
                }
                ae_v_cmulc(&a->ptr.pp_complex[0][j], a->stride, ae_v_len(0,j-1), ajj);
            }
        }
    }
    else
    {
        
        /*
         * Compute inverse of lower triangular matrix.
         */
        for(j=n-1; j>=0; j--)
        {
            if( nounit )
            {
                if( ae_c_eq_d(a->ptr.pp_complex[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_complex[j][j] = ae_c_d_div(1,a->ptr.pp_complex[j][j]);
                ajj = ae_c_neg(a->ptr.pp_complex[j][j]);
            }
            else
            {
                ajj = ae_complex_from_i(-1);
            }
            if( j+1<n )
            {
                
                /*
                 * Compute elements j+1:n of j-th column.
                 */
                ae_v_cmove(&t.ptr.p_complex[j+1], 1, &a->ptr.pp_complex[j+1][j], a->stride, "N", ae_v_len(j+1,n-1));
                for(i=j+1; i<=n-1; i++)
                {
                    if( i>j+1 )
                    {
                        v = ae_v_cdotproduct(&a->ptr.pp_complex[i][j+1], 1, "N", &t.ptr.p_complex[j+1], 1, "N", ae_v_len(j+1,i-1));
                    }
                    else
                    {
                        v = ae_complex_from_i(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,ae_c_mul(a->ptr.pp_complex[i][i],t.ptr.p_complex[i]));
                    }
                    else
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,t.ptr.p_complex[i]);
                    }
                }
                ae_v_cmulc(&a->ptr.pp_complex[j+1][j], a->stride, ae_v_len(j+1,n-1), ajj);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Internal subroutine.
Triangular matrix inversion

  -- LAPACK routine (version 3.0) --
     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
     Courant Institute, Argonne National Lab, and Rice University
     February 29, 1992
*************************************************************************/
static ae_bool testablasunit_internalrmatrixtrinverse(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool nounit;
    ae_int_t i;
    ae_int_t j;
    double v;
    double ajj;
    ae_vector t;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&t, 0, sizeof(t));
    ae_vector_init(&t, 0, DT_REAL, _state, ae_true);

    result = ae_true;
    ae_vector_set_length(&t, n-1+1, _state);
    
    /*
     * Test the input parameters.
     */
    nounit = !isunittriangular;
    if( isupper )
    {
        
        /*
         * Compute inverse of upper triangular matrix.
         */
        for(j=0; j<=n-1; j++)
        {
            if( nounit )
            {
                if( ae_fp_eq(a->ptr.pp_double[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_double[j][j] = 1/a->ptr.pp_double[j][j];
                ajj = -a->ptr.pp_double[j][j];
            }
            else
            {
                ajj = (double)(-1);
            }
            
            /*
             * Compute elements 1:j-1 of j-th column.
             */
            if( j>0 )
            {
                ae_v_move(&t.ptr.p_double[0], 1, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1));
                for(i=0; i<=j-1; i++)
                {
                    if( i<j-1 )
                    {
                        v = ae_v_dotproduct(&a->ptr.pp_double[i][i+1], 1, &t.ptr.p_double[i+1], 1, ae_v_len(i+1,j-1));
                    }
                    else
                    {
                        v = (double)(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_double[i][j] = v+a->ptr.pp_double[i][i]*t.ptr.p_double[i];
                    }
                    else
                    {
                        a->ptr.pp_double[i][j] = v+t.ptr.p_double[i];
                    }
                }
                ae_v_muld(&a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1), ajj);
            }
        }
    }
    else
    {
        
        /*
         * Compute inverse of lower triangular matrix.
         */
        for(j=n-1; j>=0; j--)
        {
            if( nounit )
            {
                if( ae_fp_eq(a->ptr.pp_double[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_double[j][j] = 1/a->ptr.pp_double[j][j];
                ajj = -a->ptr.pp_double[j][j];
            }
            else
            {
                ajj = (double)(-1);
            }
            if( j<n-1 )
            {
                
                /*
                 * Compute elements j+1:n of j-th column.
                 */
                ae_v_move(&t.ptr.p_double[j+1], 1, &a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1));
                for(i=j+1; i<=n-1; i++)
                {
                    if( i>j+1 )
                    {
                        v = ae_v_dotproduct(&a->ptr.pp_double[i][j+1], 1, &t.ptr.p_double[j+1], 1, ae_v_len(j+1,i-1));
                    }
                    else
                    {
                        v = (double)(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_double[i][j] = v+a->ptr.pp_double[i][i]*t.ptr.p_double[i];
                    }
                    else
                    {
                        a->ptr.pp_double[i][j] = v+t.ptr.p_double[i];
                    }
                }
                ae_v_muld(&a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1), ajj);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Reference SYRK subroutine.

  -- ALGLIB routine --
     16.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refcmatrixherk(ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Complex */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     double beta,
     /* Complex */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_bool isupper,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ae;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;

    ae_frame_make(_state, &_frame_block);
    memset(&ae, 0, sizeof(ae));
    ae_matrix_init(&ae, 0, 0, DT_COMPLEX, _state, ae_true);

    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (isupper&&j>=i)||(!isupper&&j<=i) )
            {
                if( ae_fp_eq(beta,(double)(0)) )
                {
                    c->ptr.pp_complex[i+ic][j+jc] = ae_complex_from_i(0);
                }
                else
                {
                    c->ptr.pp_complex[i+ic][j+jc] = ae_c_mul_d(c->ptr.pp_complex[i+ic][j+jc],beta);
                }
            }
        }
    }
    if( ae_fp_eq(alpha,(double)(0)) )
    {
        ae_frame_leave(_state);
        return;
    }
    if( n*k>0 )
    {
        ae_matrix_set_length(&ae, n, k, _state);
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            if( optypea==0 )
            {
                ae.ptr.pp_complex[i][j] = a->ptr.pp_complex[ia+i][ja+j];
            }
            if( optypea==2 )
            {
                ae.ptr.pp_complex[i][j] = ae_c_conj(a->ptr.pp_complex[ia+j][ja+i], _state);
            }
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            vc = ae_complex_from_i(0);
            if( k>0 )
            {
                vc = ae_v_cdotproduct(&ae.ptr.pp_complex[i][0], 1, "N", &ae.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,k-1));
            }
            vc = ae_c_mul_d(vc,alpha);
            if( isupper&&j>=i )
            {
                c->ptr.pp_complex[ic+i][jc+j] = ae_c_add(vc,c->ptr.pp_complex[ic+i][jc+j]);
            }
            if( !isupper&&j<=i )
            {
                c->ptr.pp_complex[ic+i][jc+j] = ae_c_add(vc,c->ptr.pp_complex[ic+i][jc+j]);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference SYRK subroutine.

  -- ALGLIB routine --
     16.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refrmatrixsyrk(ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     double beta,
     /* Real    */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_bool isupper,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ae;
    ae_int_t i;
    ae_int_t j;
    double vr;

    ae_frame_make(_state, &_frame_block);
    memset(&ae, 0, sizeof(ae));
    ae_matrix_init(&ae, 0, 0, DT_REAL, _state, ae_true);

    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (isupper&&j>=i)||(!isupper&&j<=i) )
            {
                if( ae_fp_eq(beta,(double)(0)) )
                {
                    c->ptr.pp_double[i+ic][j+jc] = (double)(0);
                }
                else
                {
                    c->ptr.pp_double[i+ic][j+jc] = c->ptr.pp_double[i+ic][j+jc]*beta;
                }
            }
        }
    }
    if( ae_fp_eq(alpha,(double)(0)) )
    {
        ae_frame_leave(_state);
        return;
    }
    if( n*k>0 )
    {
        ae_matrix_set_length(&ae, n, k, _state);
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            if( optypea==0 )
            {
                ae.ptr.pp_double[i][j] = a->ptr.pp_double[ia+i][ja+j];
            }
            if( optypea==1 )
            {
                ae.ptr.pp_double[i][j] = a->ptr.pp_double[ia+j][ja+i];
            }
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            vr = (double)(0);
            if( k>0 )
            {
                vr = ae_v_dotproduct(&ae.ptr.pp_double[i][0], 1, &ae.ptr.pp_double[j][0], 1, ae_v_len(0,k-1));
            }
            vr = alpha*vr;
            if( isupper&&j>=i )
            {
                c->ptr.pp_double[ic+i][jc+j] = vr+c->ptr.pp_double[ic+i][jc+j];
            }
            if( !isupper&&j<=i )
            {
                c->ptr.pp_double[ic+i][jc+j] = vr+c->ptr.pp_double[ic+i][jc+j];
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference GEMM,
ALGLIB subroutine
*************************************************************************/
static void testablasunit_refcmatrixgemm(ae_int_t m,
     ae_int_t n,
     ae_int_t k,
     ae_complex alpha,
     /* Complex */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     /* Complex */ ae_matrix* b,
     ae_int_t ib,
     ae_int_t jb,
     ae_int_t optypeb,
     ae_complex beta,
     /* Complex */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ae;
    ae_matrix be;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;

    ae_frame_make(_state, &_frame_block);
    memset(&ae, 0, sizeof(ae));
    memset(&be, 0, sizeof(be));
    ae_matrix_init(&ae, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&be, 0, 0, DT_COMPLEX, _state, ae_true);

    ae_matrix_set_length(&ae, m, k, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            if( optypea==0 )
            {
                ae.ptr.pp_complex[i][j] = a->ptr.pp_complex[ia+i][ja+j];
            }
            if( optypea==1 )
            {
                ae.ptr.pp_complex[i][j] = a->ptr.pp_complex[ia+j][ja+i];
            }
            if( optypea==2 )
            {
                ae.ptr.pp_complex[i][j] = ae_c_conj(a->ptr.pp_complex[ia+j][ja+i], _state);
            }
        }
    }
    ae_matrix_set_length(&be, k, n, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( optypeb==0 )
            {
                be.ptr.pp_complex[i][j] = b->ptr.pp_complex[ib+i][jb+j];
            }
            if( optypeb==1 )
            {
                be.ptr.pp_complex[i][j] = b->ptr.pp_complex[ib+j][jb+i];
            }
            if( optypeb==2 )
            {
                be.ptr.pp_complex[i][j] = ae_c_conj(b->ptr.pp_complex[ib+j][jb+i], _state);
            }
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            vc = ae_v_cdotproduct(&ae.ptr.pp_complex[i][0], 1, "N", &be.ptr.pp_complex[0][j], be.stride, "N", ae_v_len(0,k-1));
            vc = ae_c_mul(alpha,vc);
            if( ae_c_neq_d(beta,(double)(0)) )
            {
                vc = ae_c_add(vc,ae_c_mul(beta,c->ptr.pp_complex[ic+i][jc+j]));
            }
            c->ptr.pp_complex[ic+i][jc+j] = vc;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference GEMM,
ALGLIB subroutine
*************************************************************************/
static void testablasunit_refrmatrixgemm(ae_int_t m,
     ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     /* Real    */ ae_matrix* b,
     ae_int_t ib,
     ae_int_t jb,
     ae_int_t optypeb,
     double beta,
     /* Real    */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ae;
    ae_matrix be;
    ae_int_t i;
    ae_int_t j;
    double vc;

    ae_frame_make(_state, &_frame_block);
    memset(&ae, 0, sizeof(ae));
    memset(&be, 0, sizeof(be));
    ae_matrix_init(&ae, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&be, 0, 0, DT_REAL, _state, ae_true);

    ae_matrix_set_length(&ae, m, k, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            if( optypea==0 )
            {
                ae.ptr.pp_double[i][j] = a->ptr.pp_double[ia+i][ja+j];
            }
            if( optypea==1 )
            {
                ae.ptr.pp_double[i][j] = a->ptr.pp_double[ia+j][ja+i];
            }
        }
    }
    ae_matrix_set_length(&be, k, n, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( optypeb==0 )
            {
                be.ptr.pp_double[i][j] = b->ptr.pp_double[ib+i][jb+j];
            }
            if( optypeb==1 )
            {
                be.ptr.pp_double[i][j] = b->ptr.pp_double[ib+j][jb+i];
            }
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            vc = ae_v_dotproduct(&ae.ptr.pp_double[i][0], 1, &be.ptr.pp_double[0][j], be.stride, ae_v_len(0,k-1));
            vc = alpha*vc;
            if( ae_fp_neq(beta,(double)(0)) )
            {
                vc = vc+beta*c->ptr.pp_double[ic+i][jc+j];
            }
            c->ptr.pp_double[ic+i][jc+j] = vc;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference SYMV,
ALGLIB subroutine
*************************************************************************/
static void testablasunit_refrmatrixsymv(ae_int_t n,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_bool isupper,
     /* Real    */ ae_vector* x,
     ae_int_t ix,
     double beta,
     /* Real    */ ae_vector* y,
     ae_int_t iy,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    double v;
    ae_matrix b;

    ae_frame_make(_state, &_frame_block);
    memset(&b, 0, sizeof(b));
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Convert problem to traditional dense GEMV
     */
    ae_matrix_set_length(&b, n, n, _state);
    if( isupper )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                b.ptr.pp_double[i][j] = a->ptr.pp_double[ia+i][ja+j];
                b.ptr.pp_double[j][i] = a->ptr.pp_double[ia+i][ja+j];
            }
        }
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                b.ptr.pp_double[i][j] = a->ptr.pp_double[ia+i][ja+j];
                b.ptr.pp_double[j][i] = a->ptr.pp_double[ia+i][ja+j];
            }
        }
    }
    
    /*
     * Calculate result
     */
    for(i=0; i<=n-1; i++)
    {
        v = beta*y->ptr.p_double[iy+i];
        for(j=0; j<=n-1; j++)
        {
            v = v+alpha*b.ptr.pp_double[i][j]*x->ptr.p_double[ix+j];
        }
        y->ptr.p_double[iy+i] = v;
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference SYVMV,
ALGLIB subroutine
*************************************************************************/
static double testablasunit_refrmatrixsyvmv(ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_bool isupper,
     /* Real    */ ae_vector* x,
     ae_int_t ix,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_matrix b;
    double result;

    ae_frame_make(_state, &_frame_block);
    memset(&b, 0, sizeof(b));
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Convert problem to traditional dense GEMV
     */
    ae_matrix_set_length(&b, n, n, _state);
    if( isupper )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                b.ptr.pp_double[i][j] = a->ptr.pp_double[ia+i][ja+j];
                b.ptr.pp_double[j][i] = a->ptr.pp_double[ia+i][ja+j];
            }
        }
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                b.ptr.pp_double[i][j] = a->ptr.pp_double[ia+i][ja+j];
                b.ptr.pp_double[j][i] = a->ptr.pp_double[ia+i][ja+j];
            }
        }
    }
    
    /*
     * Calculate result
     */
    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            result = result+x->ptr.p_double[ix+i]*b.ptr.pp_double[i][j]*x->ptr.p_double[ix+j];
        }
    }
    ae_frame_leave(_state);
    return result;
}








ae_bool testhblas(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix ua;
    ae_matrix la;
    ae_vector x;
    ae_vector y1;
    ae_vector y2;
    ae_vector y3;
    ae_int_t n;
    ae_int_t maxn;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t i2;
    ae_bool waserrors;
    double mverr;
    double threshold;
    ae_complex alpha;
    ae_complex v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&ua, 0, sizeof(ua));
    memset(&la, 0, sizeof(la));
    memset(&x, 0, sizeof(x));
    memset(&y1, 0, sizeof(y1));
    memset(&y2, 0, sizeof(y2));
    memset(&y3, 0, sizeof(y3));
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ua, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&la, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&x, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&y1, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&y2, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&y3, 0, DT_COMPLEX, _state, ae_true);

    mverr = (double)(0);
    waserrors = ae_false;
    maxn = 10;
    threshold = 1000*ae_machineepsilon;
    
    /*
     * Test MV
     */
    for(n=2; n<=maxn; n++)
    {
        ae_matrix_set_length(&a, n+1, n+1, _state);
        ae_matrix_set_length(&ua, n+1, n+1, _state);
        ae_matrix_set_length(&la, n+1, n+1, _state);
        ae_vector_set_length(&x, n+1, _state);
        ae_vector_set_length(&y1, n+1, _state);
        ae_vector_set_length(&y2, n+1, _state);
        ae_vector_set_length(&y3, n+1, _state);
        
        /*
         * fill A, UA, LA
         */
        for(i=1; i<=n; i++)
        {
            a.ptr.pp_complex[i][i].x = 2*ae_randomreal(_state)-1;
            a.ptr.pp_complex[i][i].y = (double)(0);
            for(j=i+1; j<=n; j++)
            {
                a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                a.ptr.pp_complex[j][i] = ae_c_conj(a.ptr.pp_complex[i][j], _state);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                ua.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=i; j<=n; j++)
            {
                ua.ptr.pp_complex[i][j] = a.ptr.pp_complex[i][j];
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                la.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=i; j++)
            {
                la.ptr.pp_complex[i][j] = a.ptr.pp_complex[i][j];
            }
        }
        
        /*
         * test on different I1, I2
         */
        for(i1=1; i1<=n; i1++)
        {
            for(i2=i1; i2<=n; i2++)
            {
                
                /*
                 * Fill X, choose Alpha
                 */
                for(i=1; i<=i2-i1+1; i++)
                {
                    x.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
                    x.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
                }
                alpha.x = 2*ae_randomreal(_state)-1;
                alpha.y = 2*ae_randomreal(_state)-1;
                
                /*
                 * calculate A*x, UA*x, LA*x
                 */
                for(i=i1; i<=i2; i++)
                {
                    v = ae_v_cdotproduct(&a.ptr.pp_complex[i][i1], 1, "N", &x.ptr.p_complex[1], 1, "N", ae_v_len(i1,i2));
                    y1.ptr.p_complex[i-i1+1] = ae_c_mul(alpha,v);
                }
                hermitianmatrixvectormultiply(&ua, ae_true, i1, i2, &x, alpha, &y2, _state);
                hermitianmatrixvectormultiply(&la, ae_false, i1, i2, &x, alpha, &y3, _state);
                
                /*
                 * Calculate error
                 */
                ae_v_csub(&y2.ptr.p_complex[1], 1, &y1.ptr.p_complex[1], 1, "N", ae_v_len(1,i2-i1+1));
                v = ae_v_cdotproduct(&y2.ptr.p_complex[1], 1, "N", &y2.ptr.p_complex[1], 1, "Conj", ae_v_len(1,i2-i1+1));
                mverr = ae_maxreal(mverr, ae_sqrt(ae_c_abs(v, _state), _state), _state);
                ae_v_csub(&y3.ptr.p_complex[1], 1, &y1.ptr.p_complex[1], 1, "N", ae_v_len(1,i2-i1+1));
                v = ae_v_cdotproduct(&y3.ptr.p_complex[1], 1, "N", &y3.ptr.p_complex[1], 1, "Conj", ae_v_len(1,i2-i1+1));
                mverr = ae_maxreal(mverr, ae_sqrt(ae_c_abs(v, _state), _state), _state);
            }
        }
    }
    
    /*
     * report
     */
    waserrors = ae_fp_greater(mverr,threshold);
    if( !silent )
    {
        printf("TESTING HERMITIAN BLAS\n");
        printf("MV error:                                %5.3e\n",
            (double)(mverr));
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}








ae_bool testcreflections(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t n;
    ae_int_t m;
    ae_int_t maxmn;
    ae_vector x;
    ae_vector v;
    ae_vector work;
    ae_matrix h;
    ae_matrix a;
    ae_matrix b;
    ae_matrix c;
    ae_complex tmp;
    ae_complex beta;
    ae_complex tau;
    double err;
    double mer;
    double mel;
    double meg;
    ae_int_t pass;
    ae_int_t passcount;
    ae_bool waserrors;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x, 0, sizeof(x));
    memset(&v, 0, sizeof(v));
    memset(&work, 0, sizeof(work));
    memset(&h, 0, sizeof(h));
    memset(&a, 0, sizeof(a));
    memset(&b, 0, sizeof(b));
    memset(&c, 0, sizeof(c));
    ae_vector_init(&x, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&v, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&work, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&h, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&c, 0, 0, DT_COMPLEX, _state, ae_true);

    threshold = 1000*ae_machineepsilon;
    passcount = 1000;
    mer = (double)(0);
    mel = (double)(0);
    meg = (double)(0);
    for(pass=1; pass<=passcount; pass++)
    {
        
        /*
         * Task
         */
        n = 1+ae_randominteger(10, _state);
        m = 1+ae_randominteger(10, _state);
        maxmn = ae_maxint(m, n, _state);
        
        /*
         * Initialize
         */
        ae_vector_set_length(&x, maxmn+1, _state);
        ae_vector_set_length(&v, maxmn+1, _state);
        ae_vector_set_length(&work, maxmn+1, _state);
        ae_matrix_set_length(&h, maxmn+1, maxmn+1, _state);
        ae_matrix_set_length(&a, maxmn+1, maxmn+1, _state);
        ae_matrix_set_length(&b, maxmn+1, maxmn+1, _state);
        ae_matrix_set_length(&c, maxmn+1, maxmn+1, _state);
        
        /*
         * GenerateReflection
         */
        for(i=1; i<=n; i++)
        {
            x.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            x.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
            v.ptr.p_complex[i] = x.ptr.p_complex[i];
        }
        complexgeneratereflection(&v, n, &tau, _state);
        beta = v.ptr.p_complex[1];
        v.ptr.p_complex[1] = ae_complex_from_i(1);
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                if( i==j )
                {
                    h.ptr.pp_complex[i][j] = ae_c_d_sub(1,ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
                else
                {
                    h.ptr.pp_complex[i][j] = ae_c_neg(ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
            }
        }
        err = (double)(0);
        for(i=1; i<=n; i++)
        {
            tmp = ae_v_cdotproduct(&h.ptr.pp_complex[1][i], h.stride, "Conj", &x.ptr.p_complex[1], 1, "N", ae_v_len(1,n));
            if( i==1 )
            {
                err = ae_maxreal(err, ae_c_abs(ae_c_sub(tmp,beta), _state), _state);
            }
            else
            {
                err = ae_maxreal(err, ae_c_abs(tmp, _state), _state);
            }
        }
        err = ae_maxreal(err, ae_fabs(beta.y, _state), _state);
        meg = ae_maxreal(meg, err, _state);
        
        /*
         * ApplyReflectionFromTheLeft
         */
        for(i=1; i<=m; i++)
        {
            x.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            x.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
            v.ptr.p_complex[i] = x.ptr.p_complex[i];
        }
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                b.ptr.pp_complex[i][j] = a.ptr.pp_complex[i][j];
            }
        }
        complexgeneratereflection(&v, m, &tau, _state);
        beta = v.ptr.p_complex[1];
        v.ptr.p_complex[1] = ae_complex_from_i(1);
        complexapplyreflectionfromtheleft(&b, tau, &v, 1, m, 1, n, &work, _state);
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=m; j++)
            {
                if( i==j )
                {
                    h.ptr.pp_complex[i][j] = ae_c_d_sub(1,ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
                else
                {
                    h.ptr.pp_complex[i][j] = ae_c_neg(ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
            }
        }
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                tmp = ae_v_cdotproduct(&h.ptr.pp_complex[i][1], 1, "N", &a.ptr.pp_complex[1][j], a.stride, "N", ae_v_len(1,m));
                c.ptr.pp_complex[i][j] = tmp;
            }
        }
        err = (double)(0);
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                err = ae_maxreal(err, ae_c_abs(ae_c_sub(b.ptr.pp_complex[i][j],c.ptr.pp_complex[i][j]), _state), _state);
            }
        }
        mel = ae_maxreal(mel, err, _state);
        
        /*
         * ApplyReflectionFromTheRight
         */
        for(i=1; i<=n; i++)
        {
            x.ptr.p_complex[i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
            v.ptr.p_complex[i] = x.ptr.p_complex[i];
        }
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                a.ptr.pp_complex[i][j] = ae_complex_from_d(2*ae_randomreal(_state)-1);
                b.ptr.pp_complex[i][j] = a.ptr.pp_complex[i][j];
            }
        }
        complexgeneratereflection(&v, n, &tau, _state);
        beta = v.ptr.p_complex[1];
        v.ptr.p_complex[1] = ae_complex_from_i(1);
        complexapplyreflectionfromtheright(&b, tau, &v, 1, m, 1, n, &work, _state);
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                if( i==j )
                {
                    h.ptr.pp_complex[i][j] = ae_c_d_sub(1,ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
                else
                {
                    h.ptr.pp_complex[i][j] = ae_c_neg(ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
            }
        }
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                tmp = ae_v_cdotproduct(&a.ptr.pp_complex[i][1], 1, "N", &h.ptr.pp_complex[1][j], h.stride, "N", ae_v_len(1,n));
                c.ptr.pp_complex[i][j] = tmp;
            }
        }
        err = (double)(0);
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                err = ae_maxreal(err, ae_c_abs(ae_c_sub(b.ptr.pp_complex[i][j],c.ptr.pp_complex[i][j]), _state), _state);
            }
        }
        mer = ae_maxreal(mer, err, _state);
    }
    
    /*
     * Overflow crash test
     */
    ae_vector_set_length(&x, 10+1, _state);
    ae_vector_set_length(&v, 10+1, _state);
    for(i=1; i<=10; i++)
    {
        v.ptr.p_complex[i] = ae_complex_from_d(ae_maxrealnumber*0.01*(2*ae_randomreal(_state)-1));
    }
    complexgeneratereflection(&v, 10, &tau, _state);
    
    /*
     * report
     */
    waserrors = (ae_fp_greater(meg,threshold)||ae_fp_greater(mel,threshold))||ae_fp_greater(mer,threshold);
    if( !silent )
    {
        printf("TESTING COMPLEX REFLECTIONS\n");
        printf("Generate error:                          %5.3e\n",
            (double)(meg));
        printf("Apply(L) error:                          %5.3e\n",
            (double)(mel));
        printf("Apply(R) error:                          %5.3e\n",
            (double)(mer));
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        printf("Overflow crash test:                     PASSED\n");
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}








ae_bool testsblas(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix ua;
    ae_matrix la;
    ae_vector x;
    ae_vector y1;
    ae_vector y2;
    ae_vector y3;
    ae_int_t n;
    ae_int_t maxn;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t i2;
    ae_bool waserrors;
    double mverr;
    double threshold;
    double alpha;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&ua, 0, sizeof(ua));
    memset(&la, 0, sizeof(la));
    memset(&x, 0, sizeof(x));
    memset(&y1, 0, sizeof(y1));
    memset(&y2, 0, sizeof(y2));
    memset(&y3, 0, sizeof(y3));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ua, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&la, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y2, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y3, 0, DT_REAL, _state, ae_true);

    mverr = (double)(0);
    waserrors = ae_false;
    maxn = 10;
    threshold = 1000*ae_machineepsilon;
    
    /*
     * Test MV
     */
    for(n=2; n<=maxn; n++)
    {
        ae_matrix_set_length(&a, n+1, n+1, _state);
        ae_matrix_set_length(&ua, n+1, n+1, _state);
        ae_matrix_set_length(&la, n+1, n+1, _state);
        ae_vector_set_length(&x, n+1, _state);
        ae_vector_set_length(&y1, n+1, _state);
        ae_vector_set_length(&y2, n+1, _state);
        ae_vector_set_length(&y3, n+1, _state);
        
        /*
         * fill A, UA, LA
         */
        for(i=1; i<=n; i++)
        {
            a.ptr.pp_double[i][i] = 2*ae_randomreal(_state)-1;
            for(j=i+1; j<=n; j++)
            {
                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                ua.ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=i; j<=n; j++)
            {
                ua.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                la.ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=i; j++)
            {
                la.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
            }
        }
        
        /*
         * test on different I1, I2
         */
        for(i1=1; i1<=n; i1++)
        {
            for(i2=i1; i2<=n; i2++)
            {
                
                /*
                 * Fill X, choose Alpha
                 */
                for(i=1; i<=i2-i1+1; i++)
                {
                    x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                }
                alpha = 2*ae_randomreal(_state)-1;
                
                /*
                 * calculate A*x, UA*x, LA*x
                 */
                for(i=i1; i<=i2; i++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[i][i1], 1, &x.ptr.p_double[1], 1, ae_v_len(i1,i2));
                    y1.ptr.p_double[i-i1+1] = alpha*v;
                }
                symmetricmatrixvectormultiply(&ua, ae_true, i1, i2, &x, alpha, &y2, _state);
                symmetricmatrixvectormultiply(&la, ae_false, i1, i2, &x, alpha, &y3, _state);
                
                /*
                 * Calculate error
                 */
                ae_v_sub(&y2.ptr.p_double[1], 1, &y1.ptr.p_double[1], 1, ae_v_len(1,i2-i1+1));
                v = ae_v_dotproduct(&y2.ptr.p_double[1], 1, &y2.ptr.p_double[1], 1, ae_v_len(1,i2-i1+1));
                mverr = ae_maxreal(mverr, ae_sqrt(v, _state), _state);
                ae_v_sub(&y3.ptr.p_double[1], 1, &y1.ptr.p_double[1], 1, ae_v_len(1,i2-i1+1));
                v = ae_v_dotproduct(&y3.ptr.p_double[1], 1, &y3.ptr.p_double[1], 1, ae_v_len(1,i2-i1+1));
                mverr = ae_maxreal(mverr, ae_sqrt(v, _state), _state);
            }
        }
    }
    
    /*
     * report
     */
    waserrors = ae_fp_greater(mverr,threshold);
    if( !silent )
    {
        printf("TESTING SYMMETRIC BLAS\n");
        printf("MV error:                                %5.3e\n",
            (double)(mverr));
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}



static double testortfacunit_rmatrixdiff(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* b,
     ae_int_t m,
     ae_int_t n,
     ae_state *_state);
static void testortfacunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state);
static void testortfacunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state);
static void testortfacunit_rmatrixfillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state);
static void testortfacunit_cmatrixfillsparsea(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state);
static void testortfacunit_internalmatrixmatrixmultiply(/* Real    */ ae_matrix* a,
     ae_int_t ai1,
     ae_int_t ai2,
     ae_int_t aj1,
     ae_int_t aj2,
     ae_bool transa,
     /* Real    */ ae_matrix* b,
     ae_int_t bi1,
     ae_int_t bi2,
     ae_int_t bj1,
     ae_int_t bj2,
     ae_bool transb,
     /* Real    */ ae_matrix* c,
     ae_int_t ci1,
     ae_int_t ci2,
     ae_int_t cj1,
     ae_int_t cj2,
     ae_state *_state);
static void testortfacunit_testrqrproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* qrerrors,
     ae_state *_state);
static void testortfacunit_testcqrproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* qrerrors,
     ae_state *_state);
static void testortfacunit_testrlqproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* lqerrors,
     ae_state *_state);
static void testortfacunit_testclqproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* lqerrors,
     ae_state *_state);
static void testortfacunit_testrbdproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* bderrors,
     ae_state *_state);
static void testortfacunit_testrhessproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* hesserrors,
     ae_state *_state);
static void testortfacunit_testrtdproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state);
static void testortfacunit_testctdproblem(/* Complex */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state);





/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testortfac(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    double threshold;
    ae_int_t mx;
    ae_matrix ra;
    ae_matrix ca;
    ae_int_t m;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_bool rqrerrors;
    ae_bool rlqerrors;
    ae_bool cqrerrors;
    ae_bool clqerrors;
    ae_bool rbderrors;
    ae_bool rhesserrors;
    ae_bool rtderrors;
    ae_bool ctderrors;
    ae_bool waserrors;
    hqrndstate rs;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&ra, 0, sizeof(ra));
    memset(&ca, 0, sizeof(ca));
    memset(&rs, 0, sizeof(rs));
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    hqrndrandomize(&rs, _state);
    waserrors = ae_false;
    rqrerrors = ae_false;
    rlqerrors = ae_false;
    cqrerrors = ae_false;
    clqerrors = ae_false;
    rbderrors = ae_false;
    rhesserrors = ae_false;
    rtderrors = ae_false;
    ctderrors = ae_false;
    threshold = 5*1000*ae_machineepsilon;
    
    /*
     * Medium-scale problems with various sparseness profiles
     */
    for(mx=1; mx<=3*matrixtilesizea(_state)+1; mx++)
    {
        
        /*
         * Rectangular factorizations: QR, LQ, bidiagonal
         * Matrix types: zero, dense, sparse
         */
        n = 1+ae_randominteger(mx, _state);
        m = 1+ae_randominteger(mx, _state);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            n = mx;
        }
        else
        {
            m = mx;
        }
        ae_matrix_set_length(&ra, m, n, _state);
        ae_matrix_set_length(&ca, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = (double)(0);
                ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        testortfacunit_testrqrproblem(&ra, m, n, threshold, &rqrerrors, _state);
        testortfacunit_testrlqproblem(&ra, m, n, threshold, &rlqerrors, _state);
        testortfacunit_testcqrproblem(&ca, m, n, threshold, &cqrerrors, _state);
        testortfacunit_testclqproblem(&ca, m, n, threshold, &clqerrors, _state);
        testortfacunit_testrbdproblem(&ra, m, n, threshold, &rbderrors, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        testortfacunit_testrqrproblem(&ra, m, n, threshold, &rqrerrors, _state);
        testortfacunit_testrlqproblem(&ra, m, n, threshold, &rlqerrors, _state);
        testortfacunit_testcqrproblem(&ca, m, n, threshold, &cqrerrors, _state);
        testortfacunit_testclqproblem(&ca, m, n, threshold, &clqerrors, _state);
        testortfacunit_testrbdproblem(&ra, m, n, threshold, &rbderrors, _state);
        testortfacunit_rmatrixfillsparsea(&ra, m, n, 0.95, _state);
        testortfacunit_cmatrixfillsparsea(&ca, m, n, 0.95, _state);
        testortfacunit_testrqrproblem(&ra, m, n, threshold, &rqrerrors, _state);
        testortfacunit_testrlqproblem(&ra, m, n, threshold, &rlqerrors, _state);
        testortfacunit_testcqrproblem(&ca, m, n, threshold, &cqrerrors, _state);
        testortfacunit_testclqproblem(&ca, m, n, threshold, &clqerrors, _state);
        testortfacunit_testrbdproblem(&ra, m, n, threshold, &rbderrors, _state);
        
        /*
         * Square factorizations: Hessenberg, tridiagonal
         * Matrix types: zero, dense, sparse
         */
        ae_matrix_set_length(&ra, mx, mx, _state);
        ae_matrix_set_length(&ca, mx, mx, _state);
        for(i=0; i<=mx-1; i++)
        {
            for(j=0; j<=mx-1; j++)
            {
                ra.ptr.pp_double[i][j] = (double)(0);
                ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        testortfacunit_testrhessproblem(&ra, mx, threshold, &rhesserrors, _state);
        for(i=0; i<=mx-1; i++)
        {
            for(j=0; j<=mx-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        testortfacunit_testrhessproblem(&ra, mx, threshold, &rhesserrors, _state);
        testortfacunit_rmatrixfillsparsea(&ra, mx, mx, 0.95, _state);
        testortfacunit_cmatrixfillsparsea(&ca, mx, mx, 0.95, _state);
        testortfacunit_testrhessproblem(&ra, mx, threshold, &rhesserrors, _state);
        
        /*
         * Symetric factorizations: tridiagonal
         * Matrix types: zero, dense, sparse
         */
        ae_matrix_set_length(&ra, mx, mx, _state);
        ae_matrix_set_length(&ca, mx, mx, _state);
        for(i=0; i<=mx-1; i++)
        {
            for(j=0; j<=mx-1; j++)
            {
                ra.ptr.pp_double[i][j] = (double)(0);
                ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        testortfacunit_testrtdproblem(&ra, mx, threshold, &rtderrors, _state);
        testortfacunit_testctdproblem(&ca, mx, threshold, &ctderrors, _state);
        for(i=0; i<=mx-1; i++)
        {
            for(j=i; j<=mx-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                ra.ptr.pp_double[j][i] = ra.ptr.pp_double[i][j];
                ca.ptr.pp_complex[j][i] = ae_c_conj(ca.ptr.pp_complex[i][j], _state);
            }
        }
        for(i=0; i<=mx-1; i++)
        {
            ca.ptr.pp_complex[i][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
        }
        testortfacunit_testrtdproblem(&ra, mx, threshold, &rtderrors, _state);
        testortfacunit_testctdproblem(&ca, mx, threshold, &ctderrors, _state);
        testortfacunit_rmatrixfillsparsea(&ra, mx, mx, 0.95, _state);
        testortfacunit_cmatrixfillsparsea(&ca, mx, mx, 0.95, _state);
        for(i=0; i<=mx-1; i++)
        {
            for(j=i; j<=mx-1; j++)
            {
                ra.ptr.pp_double[j][i] = ra.ptr.pp_double[i][j];
                ca.ptr.pp_complex[j][i] = ae_c_conj(ca.ptr.pp_complex[i][j], _state);
            }
        }
        for(i=0; i<=mx-1; i++)
        {
            ca.ptr.pp_complex[i][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
        }
        testortfacunit_testrtdproblem(&ra, mx, threshold, &rtderrors, _state);
        testortfacunit_testctdproblem(&ca, mx, threshold, &ctderrors, _state);
    }
    
    /*
     * Large-scale tests
     */
    for(mx=4*matrixtilesizeb(_state); mx<=4*matrixtilesizeb(_state); mx++)
    {
        
        /*
         * Rectangular factorizations: QR, LQ, bidiagonal
         * Matrix types: dense
         */
        n = 1+ae_randominteger(mx, _state);
        m = 1+ae_randominteger(mx, _state);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            n = mx;
        }
        else
        {
            m = mx;
        }
        ae_matrix_set_length(&ra, m, n, _state);
        ae_matrix_set_length(&ca, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        testortfacunit_testrqrproblem(&ra, m, n, threshold, &rqrerrors, _state);
        testortfacunit_testrlqproblem(&ra, m, n, threshold, &rlqerrors, _state);
        testortfacunit_testcqrproblem(&ca, m, n, threshold, &cqrerrors, _state);
        testortfacunit_testclqproblem(&ca, m, n, threshold, &clqerrors, _state);
        testortfacunit_testrbdproblem(&ra, m, n, threshold, &rbderrors, _state);
        
        /*
         * Square factorizations: Hessenberg, tridiagonal
         * Matrix types: dense
         */
        ae_matrix_set_length(&ra, mx, mx, _state);
        ae_matrix_set_length(&ca, mx, mx, _state);
        for(i=0; i<=mx-1; i++)
        {
            for(j=0; j<=mx-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        testortfacunit_testrhessproblem(&ra, mx, threshold, &rhesserrors, _state);
        
        /*
         * Symetric factorizations: tridiagonal
         * Matrix types: dense
         */
        ae_matrix_set_length(&ra, mx, mx, _state);
        ae_matrix_set_length(&ca, mx, mx, _state);
        for(i=0; i<=mx-1; i++)
        {
            for(j=i; j<=mx-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                ra.ptr.pp_double[j][i] = ra.ptr.pp_double[i][j];
                ca.ptr.pp_complex[j][i] = ae_c_conj(ca.ptr.pp_complex[i][j], _state);
            }
        }
        for(i=0; i<=mx-1; i++)
        {
            ca.ptr.pp_complex[i][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
        }
        testortfacunit_testrtdproblem(&ra, mx, threshold, &rtderrors, _state);
        testortfacunit_testctdproblem(&ca, mx, threshold, &ctderrors, _state);
    }
    
    /*
     * report
     */
    waserrors = ((((((rqrerrors||rlqerrors)||cqrerrors)||clqerrors)||rbderrors)||rhesserrors)||rtderrors)||ctderrors;
    if( !silent )
    {
        printf("TESTING ORTFAC UNIT\n");
        printf("RQR ERRORS:                              ");
        if( !rqrerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("RLQ ERRORS:                              ");
        if( !rlqerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("CQR ERRORS:                              ");
        if( !cqrerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("CLQ ERRORS:                              ");
        if( !clqerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("RBD ERRORS:                              ");
        if( !rbderrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("RHESS ERRORS:                            ");
        if( !rhesserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("RTD ERRORS:                              ");
        if( !rtderrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("CTD ERRORS:                              ");
        if( !ctderrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Diff
*************************************************************************/
static double testortfacunit_rmatrixdiff(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* b,
     ae_int_t m,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    double result;


    result = (double)(0);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            result = ae_maxreal(result, ae_fabs(b->ptr.pp_double[i][j]-a->ptr.pp_double[i][j], _state), _state);
        }
    }
    return result;
}


/*************************************************************************
Copy
*************************************************************************/
static void testortfacunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
}


/*************************************************************************
Copy
*************************************************************************/
static void testortfacunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
}


/*************************************************************************
Sparse fill
*************************************************************************/
static void testortfacunit_rmatrixfillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
            {
                a->ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
            else
            {
                a->ptr.pp_double[i][j] = (double)(0);
            }
        }
    }
}


/*************************************************************************
Sparse fill
*************************************************************************/
static void testortfacunit_cmatrixfillsparsea(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
            {
                a->ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                a->ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
            else
            {
                a->ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
    }
}


/*************************************************************************
Matrix multiplication
*************************************************************************/
static void testortfacunit_internalmatrixmatrixmultiply(/* Real    */ ae_matrix* a,
     ae_int_t ai1,
     ae_int_t ai2,
     ae_int_t aj1,
     ae_int_t aj2,
     ae_bool transa,
     /* Real    */ ae_matrix* b,
     ae_int_t bi1,
     ae_int_t bi2,
     ae_int_t bj1,
     ae_int_t bj2,
     ae_bool transb,
     /* Real    */ ae_matrix* c,
     ae_int_t ci1,
     ae_int_t ci2,
     ae_int_t cj1,
     ae_int_t cj2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t arows;
    ae_int_t acols;
    ae_int_t brows;
    ae_int_t bcols;
    ae_int_t crows;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t l;
    ae_int_t r;
    double v;
    ae_vector work;
    double beta;
    double alpha;

    ae_frame_make(_state, &_frame_block);
    memset(&work, 0, sizeof(work));
    ae_vector_init(&work, 0, DT_REAL, _state, ae_true);

    
    /*
     * Pre-setup
     */
    k = ae_maxint(ai2-ai1+1, aj2-aj1+1, _state);
    k = ae_maxint(k, bi2-bi1+1, _state);
    k = ae_maxint(k, bj2-bj1+1, _state);
    ae_vector_set_length(&work, k+1, _state);
    beta = (double)(0);
    alpha = (double)(1);
    
    /*
     * Setup
     */
    if( !transa )
    {
        arows = ai2-ai1+1;
        acols = aj2-aj1+1;
    }
    else
    {
        arows = aj2-aj1+1;
        acols = ai2-ai1+1;
    }
    if( !transb )
    {
        brows = bi2-bi1+1;
        bcols = bj2-bj1+1;
    }
    else
    {
        brows = bj2-bj1+1;
        bcols = bi2-bi1+1;
    }
    ae_assert(acols==brows, "MatrixMatrixMultiply: incorrect matrix sizes!", _state);
    if( ((arows<=0||acols<=0)||brows<=0)||bcols<=0 )
    {
        ae_frame_leave(_state);
        return;
    }
    crows = arows;
    
    /*
     * Test WORK
     */
    i = ae_maxint(arows, acols, _state);
    i = ae_maxint(brows, i, _state);
    i = ae_maxint(i, bcols, _state);
    work.ptr.p_double[1] = (double)(0);
    work.ptr.p_double[i] = (double)(0);
    
    /*
     * Prepare C
     */
    if( ae_fp_eq(beta,(double)(0)) )
    {
        for(i=ci1; i<=ci2; i++)
        {
            for(j=cj1; j<=cj2; j++)
            {
                c->ptr.pp_double[i][j] = (double)(0);
            }
        }
    }
    else
    {
        for(i=ci1; i<=ci2; i++)
        {
            ae_v_muld(&c->ptr.pp_double[i][cj1], 1, ae_v_len(cj1,cj2), beta);
        }
    }
    
    /*
     * A*B
     */
    if( !transa&&!transb )
    {
        for(l=ai1; l<=ai2; l++)
        {
            for(r=bi1; r<=bi2; r++)
            {
                v = alpha*a->ptr.pp_double[l][aj1+r-bi1];
                k = ci1+l-ai1;
                ae_v_addd(&c->ptr.pp_double[k][cj1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(cj1,cj2), v);
            }
        }
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * A*B'
     */
    if( !transa&&transb )
    {
        if( arows*acols<brows*bcols )
        {
            for(r=bi1; r<=bi2; r++)
            {
                for(l=ai1; l<=ai2; l++)
                {
                    v = ae_v_dotproduct(&a->ptr.pp_double[l][aj1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(aj1,aj2));
                    c->ptr.pp_double[ci1+l-ai1][cj1+r-bi1] = c->ptr.pp_double[ci1+l-ai1][cj1+r-bi1]+alpha*v;
                }
            }
            ae_frame_leave(_state);
            return;
        }
        else
        {
            for(l=ai1; l<=ai2; l++)
            {
                for(r=bi1; r<=bi2; r++)
                {
                    v = ae_v_dotproduct(&a->ptr.pp_double[l][aj1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(aj1,aj2));
                    c->ptr.pp_double[ci1+l-ai1][cj1+r-bi1] = c->ptr.pp_double[ci1+l-ai1][cj1+r-bi1]+alpha*v;
                }
            }
            ae_frame_leave(_state);
            return;
        }
    }
    
    /*
     * A'*B
     */
    if( transa&&!transb )
    {
        for(l=aj1; l<=aj2; l++)
        {
            for(r=bi1; r<=bi2; r++)
            {
                v = alpha*a->ptr.pp_double[ai1+r-bi1][l];
                k = ci1+l-aj1;
                ae_v_addd(&c->ptr.pp_double[k][cj1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(cj1,cj2), v);
            }
        }
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * A'*B'
     */
    if( transa&&transb )
    {
        if( arows*acols<brows*bcols )
        {
            for(r=bi1; r<=bi2; r++)
            {
                for(i=1; i<=crows; i++)
                {
                    work.ptr.p_double[i] = 0.0;
                }
                for(l=ai1; l<=ai2; l++)
                {
                    v = alpha*b->ptr.pp_double[r][bj1+l-ai1];
                    k = cj1+r-bi1;
                    ae_v_addd(&work.ptr.p_double[1], 1, &a->ptr.pp_double[l][aj1], 1, ae_v_len(1,crows), v);
                }
                ae_v_add(&c->ptr.pp_double[ci1][k], c->stride, &work.ptr.p_double[1], 1, ae_v_len(ci1,ci2));
            }
            ae_frame_leave(_state);
            return;
        }
        else
        {
            for(l=aj1; l<=aj2; l++)
            {
                k = ai2-ai1+1;
                ae_v_move(&work.ptr.p_double[1], 1, &a->ptr.pp_double[ai1][l], a->stride, ae_v_len(1,k));
                for(r=bi1; r<=bi2; r++)
                {
                    v = ae_v_dotproduct(&work.ptr.p_double[1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(1,k));
                    c->ptr.pp_double[ci1+l-aj1][cj1+r-bi1] = c->ptr.pp_double[ci1+l-aj1][cj1+r-bi1]+alpha*v;
                }
            }
            ae_frame_leave(_state);
            return;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testrqrproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* qrerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix b;
    ae_vector taub;
    ae_matrix q;
    ae_matrix r;
    ae_matrix q2;
    double v;

    ae_frame_make(_state, &_frame_block);
    memset(&b, 0, sizeof(b));
    memset(&taub, 0, sizeof(taub));
    memset(&q, 0, sizeof(q));
    memset(&r, 0, sizeof(r));
    memset(&q2, 0, sizeof(q2));
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&taub, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&r, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q2, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Test decompose-and-unpack error
     */
    testortfacunit_rmatrixmakeacopy(a, m, n, &b, _state);
    rmatrixqr(&b, m, n, &taub, _state);
    rmatrixqrunpackq(&b, m, n, &taub, m, &q, _state);
    rmatrixqrunpackr(&b, m, n, &r, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &r.ptr.pp_double[0][j], r.stride, ae_v_len(0,m-1));
            *qrerrors = *qrerrors||ae_fp_greater(ae_fabs(v-a->ptr.pp_double[i][j], _state),threshold);
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=ae_minint(i, n-1, _state)-1; j++)
        {
            *qrerrors = *qrerrors||ae_fp_neq(r.ptr.pp_double[i][j],(double)(0));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &q.ptr.pp_double[j][0], 1, ae_v_len(0,m-1));
            if( i==j )
            {
                v = v-1;
            }
            *qrerrors = *qrerrors||ae_fp_greater_eq(ae_fabs(v, _state),threshold);
        }
    }
    
    /*
     * Test for other errors
     */
    k = 1+ae_randominteger(m, _state);
    rmatrixqrunpackq(&b, m, n, &taub, k, &q2, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            *qrerrors = *qrerrors||ae_fp_greater(ae_fabs(q2.ptr.pp_double[i][j]-q.ptr.pp_double[i][j], _state),10*ae_machineepsilon);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testcqrproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* qrerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix b;
    ae_vector taub;
    ae_matrix q;
    ae_matrix r;
    ae_matrix q2;
    ae_complex v;

    ae_frame_make(_state, &_frame_block);
    memset(&b, 0, sizeof(b));
    memset(&taub, 0, sizeof(taub));
    memset(&q, 0, sizeof(q));
    memset(&r, 0, sizeof(r));
    memset(&q2, 0, sizeof(q2));
    ae_matrix_init(&b, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&taub, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&r, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&q2, 0, 0, DT_COMPLEX, _state, ae_true);

    
    /*
     * Test decompose-and-unpack error
     */
    testortfacunit_cmatrixmakeacopy(a, m, n, &b, _state);
    cmatrixqr(&b, m, n, &taub, _state);
    cmatrixqrunpackq(&b, m, n, &taub, m, &q, _state);
    cmatrixqrunpackr(&b, m, n, &r, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &r.ptr.pp_complex[0][j], r.stride, "N", ae_v_len(0,m-1));
            *qrerrors = *qrerrors||ae_fp_greater(ae_c_abs(ae_c_sub(v,a->ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=ae_minint(i, n-1, _state)-1; j++)
        {
            *qrerrors = *qrerrors||ae_c_neq_d(r.ptr.pp_complex[i][j],(double)(0));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,m-1));
            if( i==j )
            {
                v = ae_c_sub_d(v,1);
            }
            *qrerrors = *qrerrors||ae_fp_greater_eq(ae_c_abs(v, _state),threshold);
        }
    }
    
    /*
     * Test for other errors
     */
    k = 1+ae_randominteger(m, _state);
    cmatrixqrunpackq(&b, m, n, &taub, k, &q2, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            *qrerrors = *qrerrors||ae_fp_greater(ae_c_abs(ae_c_sub(q2.ptr.pp_complex[i][j],q.ptr.pp_complex[i][j]), _state),10*ae_machineepsilon);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testrlqproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* lqerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix b;
    ae_vector taub;
    ae_matrix q;
    ae_matrix l;
    ae_matrix q2;
    double v;

    ae_frame_make(_state, &_frame_block);
    memset(&b, 0, sizeof(b));
    memset(&taub, 0, sizeof(taub));
    memset(&q, 0, sizeof(q));
    memset(&l, 0, sizeof(l));
    memset(&q2, 0, sizeof(q2));
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&taub, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&l, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q2, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Test decompose-and-unpack error
     */
    testortfacunit_rmatrixmakeacopy(a, m, n, &b, _state);
    rmatrixlq(&b, m, n, &taub, _state);
    rmatrixlqunpackq(&b, m, n, &taub, n, &q, _state);
    rmatrixlqunpackl(&b, m, n, &l, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&l.ptr.pp_double[i][0], 1, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,n-1));
            *lqerrors = *lqerrors||ae_fp_greater_eq(ae_fabs(v-a->ptr.pp_double[i][j], _state),threshold);
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=ae_minint(i, n-1, _state)+1; j<=n-1; j++)
        {
            *lqerrors = *lqerrors||ae_fp_neq(l.ptr.pp_double[i][j],(double)(0));
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &q.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i==j )
            {
                v = v-1;
            }
            *lqerrors = *lqerrors||ae_fp_greater_eq(ae_fabs(v, _state),threshold);
        }
    }
    
    /*
     * Test for other errors
     */
    k = 1+ae_randominteger(n, _state);
    rmatrixlqunpackq(&b, m, n, &taub, k, &q2, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *lqerrors = *lqerrors||ae_fp_greater(ae_fabs(q2.ptr.pp_double[i][j]-q.ptr.pp_double[i][j], _state),10*ae_machineepsilon);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testclqproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* lqerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix b;
    ae_vector taub;
    ae_matrix q;
    ae_matrix l;
    ae_matrix q2;
    ae_complex v;

    ae_frame_make(_state, &_frame_block);
    memset(&b, 0, sizeof(b));
    memset(&taub, 0, sizeof(taub));
    memset(&q, 0, sizeof(q));
    memset(&l, 0, sizeof(l));
    memset(&q2, 0, sizeof(q2));
    ae_matrix_init(&b, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&taub, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&l, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&q2, 0, 0, DT_COMPLEX, _state, ae_true);

    
    /*
     * Test decompose-and-unpack error
     */
    testortfacunit_cmatrixmakeacopy(a, m, n, &b, _state);
    cmatrixlq(&b, m, n, &taub, _state);
    cmatrixlqunpackq(&b, m, n, &taub, n, &q, _state);
    cmatrixlqunpackl(&b, m, n, &l, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&l.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[0][j], q.stride, "N", ae_v_len(0,n-1));
            *lqerrors = *lqerrors||ae_fp_greater_eq(ae_c_abs(ae_c_sub(v,a->ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=ae_minint(i, n-1, _state)+1; j<=n-1; j++)
        {
            *lqerrors = *lqerrors||ae_c_neq_d(l.ptr.pp_complex[i][j],(double)(0));
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
            if( i==j )
            {
                v = ae_c_sub_d(v,1);
            }
            *lqerrors = *lqerrors||ae_fp_greater_eq(ae_c_abs(v, _state),threshold);
        }
    }
    
    /*
     * Test for other errors
     */
    k = 1+ae_randominteger(n, _state);
    cmatrixlqunpackq(&b, m, n, &taub, k, &q2, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *lqerrors = *lqerrors||ae_fp_greater(ae_c_abs(ae_c_sub(q2.ptr.pp_complex[i][j],q.ptr.pp_complex[i][j]), _state),10*ae_machineepsilon);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testrbdproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* bderrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix t;
    ae_matrix pt;
    ae_matrix q;
    ae_matrix r;
    ae_matrix bd;
    ae_matrix x;
    ae_matrix r1;
    ae_matrix r2;
    ae_vector taup;
    ae_vector tauq;
    ae_vector d;
    ae_vector e;
    ae_bool up;
    double v;
    ae_int_t mtsize;

    ae_frame_make(_state, &_frame_block);
    memset(&t, 0, sizeof(t));
    memset(&pt, 0, sizeof(pt));
    memset(&q, 0, sizeof(q));
    memset(&r, 0, sizeof(r));
    memset(&bd, 0, sizeof(bd));
    memset(&x, 0, sizeof(x));
    memset(&r1, 0, sizeof(r1));
    memset(&r2, 0, sizeof(r2));
    memset(&taup, 0, sizeof(taup));
    memset(&tauq, 0, sizeof(tauq));
    memset(&d, 0, sizeof(d));
    memset(&e, 0, sizeof(e));
    ae_matrix_init(&t, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&pt, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&r, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&bd, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&x, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&r1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&r2, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&taup, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tauq, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&d, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&e, 0, DT_REAL, _state, ae_true);

    
    /*
     * Bidiagonal decomposition error
     */
    testortfacunit_rmatrixmakeacopy(a, m, n, &t, _state);
    rmatrixbd(&t, m, n, &tauq, &taup, _state);
    rmatrixbdunpackq(&t, m, n, &tauq, m, &q, _state);
    rmatrixbdunpackpt(&t, m, n, &taup, n, &pt, _state);
    rmatrixbdunpackdiagonals(&t, m, n, &up, &d, &e, _state);
    ae_matrix_set_length(&bd, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            bd.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=ae_minint(m, n, _state)-1; i++)
    {
        bd.ptr.pp_double[i][i] = d.ptr.p_double[i];
    }
    if( up )
    {
        for(i=0; i<=ae_minint(m, n, _state)-2; i++)
        {
            bd.ptr.pp_double[i][i+1] = e.ptr.p_double[i];
        }
    }
    else
    {
        for(i=0; i<=ae_minint(m, n, _state)-2; i++)
        {
            bd.ptr.pp_double[i+1][i] = e.ptr.p_double[i];
        }
    }
    ae_matrix_set_length(&r, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &bd.ptr.pp_double[0][j], bd.stride, ae_v_len(0,m-1));
            r.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&r.ptr.pp_double[i][0], 1, &pt.ptr.pp_double[0][j], pt.stride, ae_v_len(0,n-1));
            *bderrors = *bderrors||ae_fp_greater(ae_fabs(v-a->ptr.pp_double[i][j], _state),threshold);
        }
    }
    
    /*
     * Orthogonality test for Q/PT
     */
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[0][i], q.stride, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,m-1));
            if( i==j )
            {
                *bderrors = *bderrors||ae_fp_greater(ae_fabs(v-1, _state),threshold);
            }
            else
            {
                *bderrors = *bderrors||ae_fp_greater(ae_fabs(v, _state),threshold);
            }
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&pt.ptr.pp_double[i][0], 1, &pt.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i==j )
            {
                *bderrors = *bderrors||ae_fp_greater(ae_fabs(v-1, _state),threshold);
            }
            else
            {
                *bderrors = *bderrors||ae_fp_greater(ae_fabs(v, _state),threshold);
            }
        }
    }
    
    /*
     * Partial unpacking test
     */
    k = 1+ae_randominteger(m, _state);
    rmatrixbdunpackq(&t, m, n, &tauq, k, &r, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            *bderrors = *bderrors||ae_fp_greater(ae_fabs(r.ptr.pp_double[i][j]-q.ptr.pp_double[i][j], _state),10*ae_machineepsilon);
        }
    }
    k = 1+ae_randominteger(n, _state);
    rmatrixbdunpackpt(&t, m, n, &taup, k, &r, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *bderrors = *bderrors||ae_fp_greater(ae_fabs(r.ptr.pp_double[i][j]-pt.ptr.pp_double[i][j], _state),10*ae_machineepsilon);
        }
    }
    
    /*
     * Multiplication test
     */
    ae_matrix_set_length(&x, ae_maxint(m, n, _state)-1+1, ae_maxint(m, n, _state)-1+1, _state);
    ae_matrix_set_length(&r, ae_maxint(m, n, _state)-1+1, ae_maxint(m, n, _state)-1+1, _state);
    ae_matrix_set_length(&r1, ae_maxint(m, n, _state)-1+1, ae_maxint(m, n, _state)-1+1, _state);
    ae_matrix_set_length(&r2, ae_maxint(m, n, _state)-1+1, ae_maxint(m, n, _state)-1+1, _state);
    for(i=0; i<=ae_maxint(m, n, _state)-1; i++)
    {
        for(j=0; j<=ae_maxint(m, n, _state)-1; j++)
        {
            x.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
        }
    }
    mtsize = 1+ae_randominteger(ae_maxint(m, n, _state), _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, m, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&r, 0, mtsize-1, 0, m-1, ae_false, &q, 0, m-1, 0, m-1, ae_false, &r1, 0, mtsize-1, 0, m-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, m, &r2, _state);
    rmatrixbdmultiplybyq(&t, m, n, &tauq, &r2, mtsize, m, ae_true, ae_false, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, mtsize, m, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, m, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&r, 0, mtsize-1, 0, m-1, ae_false, &q, 0, m-1, 0, m-1, ae_true, &r1, 0, mtsize-1, 0, m-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, m, &r2, _state);
    rmatrixbdmultiplybyq(&t, m, n, &tauq, &r2, mtsize, m, ae_true, ae_true, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, mtsize, m, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, m, mtsize, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&q, 0, m-1, 0, m-1, ae_false, &r, 0, m-1, 0, mtsize-1, ae_false, &r1, 0, m-1, 0, mtsize-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, m, mtsize, &r2, _state);
    rmatrixbdmultiplybyq(&t, m, n, &tauq, &r2, m, mtsize, ae_false, ae_false, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, m, mtsize, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, m, mtsize, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&q, 0, m-1, 0, m-1, ae_true, &r, 0, m-1, 0, mtsize-1, ae_false, &r1, 0, m-1, 0, mtsize-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, m, mtsize, &r2, _state);
    rmatrixbdmultiplybyq(&t, m, n, &tauq, &r2, m, mtsize, ae_false, ae_true, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, m, mtsize, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, n, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&r, 0, mtsize-1, 0, n-1, ae_false, &pt, 0, n-1, 0, n-1, ae_true, &r1, 0, mtsize-1, 0, n-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, n, &r2, _state);
    rmatrixbdmultiplybyp(&t, m, n, &taup, &r2, mtsize, n, ae_true, ae_false, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, mtsize, n, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, n, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&r, 0, mtsize-1, 0, n-1, ae_false, &pt, 0, n-1, 0, n-1, ae_false, &r1, 0, mtsize-1, 0, n-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, n, &r2, _state);
    rmatrixbdmultiplybyp(&t, m, n, &taup, &r2, mtsize, n, ae_true, ae_true, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, mtsize, n, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, n, mtsize, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&pt, 0, n-1, 0, n-1, ae_true, &r, 0, n-1, 0, mtsize-1, ae_false, &r1, 0, n-1, 0, mtsize-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, n, mtsize, &r2, _state);
    rmatrixbdmultiplybyp(&t, m, n, &taup, &r2, n, mtsize, ae_false, ae_false, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, n, mtsize, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, n, mtsize, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&pt, 0, n-1, 0, n-1, ae_false, &r, 0, n-1, 0, mtsize-1, ae_false, &r1, 0, n-1, 0, mtsize-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, n, mtsize, &r2, _state);
    rmatrixbdmultiplybyp(&t, m, n, &taup, &r2, n, mtsize, ae_false, ae_true, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, n, mtsize, _state),threshold);
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testrhessproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* hesserrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix b;
    ae_matrix h;
    ae_matrix q;
    ae_matrix t1;
    ae_matrix t2;
    ae_vector tau;
    ae_int_t i;
    ae_int_t j;
    double v;

    ae_frame_make(_state, &_frame_block);
    memset(&b, 0, sizeof(b));
    memset(&h, 0, sizeof(h));
    memset(&q, 0, sizeof(q));
    memset(&t1, 0, sizeof(t1));
    memset(&t2, 0, sizeof(t2));
    memset(&tau, 0, sizeof(tau));
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&h, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&t1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&t2, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tau, 0, DT_REAL, _state, ae_true);

    testortfacunit_rmatrixmakeacopy(a, n, n, &b, _state);
    
    /*
     * Decomposition
     */
    rmatrixhessenberg(&b, n, &tau, _state);
    rmatrixhessenbergunpackq(&b, n, &tau, &q, _state);
    rmatrixhessenbergunpackh(&b, n, &h, _state);
    
    /*
     * Matrix properties
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[0][i], q.stride, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,n-1));
            if( i==j )
            {
                v = v-1;
            }
            *hesserrors = *hesserrors||ae_fp_greater(ae_fabs(v, _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=i-2; j++)
        {
            *hesserrors = *hesserrors||ae_fp_neq(h.ptr.pp_double[i][j],(double)(0));
        }
    }
    
    /*
     * Decomposition error
     */
    ae_matrix_set_length(&t1, n, n, _state);
    ae_matrix_set_length(&t2, n, n, _state);
    testortfacunit_internalmatrixmatrixmultiply(&q, 0, n-1, 0, n-1, ae_false, &h, 0, n-1, 0, n-1, ae_false, &t1, 0, n-1, 0, n-1, _state);
    testortfacunit_internalmatrixmatrixmultiply(&t1, 0, n-1, 0, n-1, ae_false, &q, 0, n-1, 0, n-1, ae_true, &t2, 0, n-1, 0, n-1, _state);
    *hesserrors = *hesserrors||ae_fp_greater(testortfacunit_rmatrixdiff(&t2, a, n, n, _state),threshold);
    ae_frame_leave(_state);
}


/*************************************************************************
Tridiagonal tester
*************************************************************************/
static void testortfacunit_testrtdproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_matrix ua;
    ae_matrix la;
    ae_matrix t;
    ae_matrix q;
    ae_matrix t2;
    ae_matrix t3;
    ae_vector tau;
    ae_vector d;
    ae_vector e;
    double v;

    ae_frame_make(_state, &_frame_block);
    memset(&ua, 0, sizeof(ua));
    memset(&la, 0, sizeof(la));
    memset(&t, 0, sizeof(t));
    memset(&q, 0, sizeof(q));
    memset(&t2, 0, sizeof(t2));
    memset(&t3, 0, sizeof(t3));
    memset(&tau, 0, sizeof(tau));
    memset(&d, 0, sizeof(d));
    memset(&e, 0, sizeof(e));
    ae_matrix_init(&ua, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&la, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&t, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&t2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&t3, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tau, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&d, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&e, 0, DT_REAL, _state, ae_true);

    ae_matrix_set_length(&ua, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&la, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&q, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t2, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t3, n-1+1, n-1+1, _state);
    
    /*
     * fill
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            ua.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=i; j<=n-1; j++)
        {
            ua.ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            la.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=i; j++)
        {
            la.ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
    
    /*
     * Test 2tridiagonal: upper
     */
    smatrixtd(&ua, n, ae_true, &tau, &d, &e, _state);
    smatrixtdunpackq(&ua, n, ae_true, &tau, &q, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            t.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        t.ptr.pp_double[i][i] = d.ptr.p_double[i];
    }
    for(i=0; i<=n-2; i++)
    {
        t.ptr.pp_double[i][i+1] = e.ptr.p_double[i];
        t.ptr.pp_double[i+1][i] = e.ptr.p_double[i];
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[0][i], q.stride, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,n-1));
            t2.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&t2.ptr.pp_double[i][0], 1, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,n-1));
            t3.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *tderrors = *tderrors||ae_fp_greater(ae_fabs(t3.ptr.pp_double[i][j]-t.ptr.pp_double[i][j], _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &q.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i==j )
            {
                v = v-1;
            }
            *tderrors = *tderrors||ae_fp_greater(ae_fabs(v, _state),threshold);
        }
    }
    
    /*
     * Test 2tridiagonal: lower
     */
    smatrixtd(&la, n, ae_false, &tau, &d, &e, _state);
    smatrixtdunpackq(&la, n, ae_false, &tau, &q, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            t.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        t.ptr.pp_double[i][i] = d.ptr.p_double[i];
    }
    for(i=0; i<=n-2; i++)
    {
        t.ptr.pp_double[i][i+1] = e.ptr.p_double[i];
        t.ptr.pp_double[i+1][i] = e.ptr.p_double[i];
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[0][i], q.stride, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,n-1));
            t2.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&t2.ptr.pp_double[i][0], 1, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,n-1));
            t3.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *tderrors = *tderrors||ae_fp_greater(ae_fabs(t3.ptr.pp_double[i][j]-t.ptr.pp_double[i][j], _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &q.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i==j )
            {
                v = v-1;
            }
            *tderrors = *tderrors||ae_fp_greater(ae_fabs(v, _state),threshold);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Hermitian problem tester
*************************************************************************/
static void testortfacunit_testctdproblem(/* Complex */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_matrix ua;
    ae_matrix la;
    ae_matrix t;
    ae_matrix q;
    ae_matrix t2;
    ae_matrix t3;
    ae_vector tau;
    ae_vector d;
    ae_vector e;
    ae_complex v;

    ae_frame_make(_state, &_frame_block);
    memset(&ua, 0, sizeof(ua));
    memset(&la, 0, sizeof(la));
    memset(&t, 0, sizeof(t));
    memset(&q, 0, sizeof(q));
    memset(&t2, 0, sizeof(t2));
    memset(&t3, 0, sizeof(t3));
    memset(&tau, 0, sizeof(tau));
    memset(&d, 0, sizeof(d));
    memset(&e, 0, sizeof(e));
    ae_matrix_init(&ua, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&la, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&t, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&q, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&t2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&t3, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&tau, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&d, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&e, 0, DT_REAL, _state, ae_true);

    ae_matrix_set_length(&ua, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&la, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&q, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t2, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t3, n-1+1, n-1+1, _state);
    
    /*
     * fill
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            ua.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=i; j<=n-1; j++)
        {
            ua.ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            la.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=i; j++)
        {
            la.ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
    
    /*
     * Test 2tridiagonal: upper
     */
    hmatrixtd(&ua, n, ae_true, &tau, &d, &e, _state);
    hmatrixtdunpackq(&ua, n, ae_true, &tau, &q, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            t.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        t.ptr.pp_complex[i][i] = ae_complex_from_d(d.ptr.p_double[i]);
    }
    for(i=0; i<=n-2; i++)
    {
        t.ptr.pp_complex[i][i+1] = ae_complex_from_d(e.ptr.p_double[i]);
        t.ptr.pp_complex[i+1][i] = ae_complex_from_d(e.ptr.p_double[i]);
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[0][i], q.stride, "Conj", &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,n-1));
            t2.ptr.pp_complex[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&t2.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[0][j], q.stride, "N", ae_v_len(0,n-1));
            t3.ptr.pp_complex[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *tderrors = *tderrors||ae_fp_greater(ae_c_abs(ae_c_sub(t3.ptr.pp_complex[i][j],t.ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
            if( i==j )
            {
                v = ae_c_sub_d(v,1);
            }
            *tderrors = *tderrors||ae_fp_greater(ae_c_abs(v, _state),threshold);
        }
    }
    
    /*
     * Test 2tridiagonal: lower
     */
    hmatrixtd(&la, n, ae_false, &tau, &d, &e, _state);
    hmatrixtdunpackq(&la, n, ae_false, &tau, &q, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            t.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        t.ptr.pp_complex[i][i] = ae_complex_from_d(d.ptr.p_double[i]);
    }
    for(i=0; i<=n-2; i++)
    {
        t.ptr.pp_complex[i][i+1] = ae_complex_from_d(e.ptr.p_double[i]);
        t.ptr.pp_complex[i+1][i] = ae_complex_from_d(e.ptr.p_double[i]);
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[0][i], q.stride, "Conj", &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,n-1));
            t2.ptr.pp_complex[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&t2.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[0][j], q.stride, "N", ae_v_len(0,n-1));
            t3.ptr.pp_complex[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *tderrors = *tderrors||ae_fp_greater(ae_c_abs(ae_c_sub(t3.ptr.pp_complex[i][j],t.ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
            if( i==j )
            {
                v = ae_c_sub_d(v,1);
            }
            *tderrors = *tderrors||ae_fp_greater(ae_c_abs(v, _state),threshold);
        }
    }
    ae_frame_leave(_state);
}



static ae_int_t testmatgenunit_maxsvditerations = 60;
static void testmatgenunit_unset2d(/* Real    */ ae_matrix* a,
     ae_state *_state);
static void testmatgenunit_unset2dc(/* Complex */ ae_matrix* a,
     ae_state *_state);
static ae_bool testmatgenunit_isspd(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_state *_state);
static ae_bool testmatgenunit_ishpd(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static ae_bool testmatgenunit_testeult(ae_state *_state);
static double testmatgenunit_svdcond(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static ae_bool testmatgenunit_obsoletesvddecomposition(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* v,
     ae_state *_state);
static double testmatgenunit_extsign(double a, double b, ae_state *_state);
static double testmatgenunit_mymax(double a, double b, ae_state *_state);
static double testmatgenunit_pythag(double a, double b, ae_state *_state);





ae_bool testmatgen(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix b;
    ae_matrix u;
    ae_matrix v;
    ae_matrix ca;
    ae_matrix cb;
    ae_matrix r1;
    ae_matrix r2;
    ae_matrix c1;
    ae_matrix c2;
    ae_vector w;
    ae_int_t n;
    ae_int_t maxn;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_int_t passcount;
    ae_bool waserrors;
    double cond;
    double threshold;
    double vt;
    ae_complex ct;
    double minw;
    double maxw;
    ae_bool serr;
    ae_bool herr;
    ae_bool spderr;
    ae_bool hpderr;
    ae_bool rerr;
    ae_bool cerr;
    ae_bool eulerr;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&b, 0, sizeof(b));
    memset(&u, 0, sizeof(u));
    memset(&v, 0, sizeof(v));
    memset(&ca, 0, sizeof(ca));
    memset(&cb, 0, sizeof(cb));
    memset(&r1, 0, sizeof(r1));
    memset(&r2, 0, sizeof(r2));
    memset(&c1, 0, sizeof(c1));
    memset(&c2, 0, sizeof(c2));
    memset(&w, 0, sizeof(w));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&u, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&v, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cb, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&r1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&r2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&c2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&w, 0, DT_REAL, _state, ae_true);

    rerr = ae_false;
    cerr = ae_false;
    serr = ae_false;
    herr = ae_false;
    spderr = ae_false;
    hpderr = ae_false;
    eulerr = ae_false;
    waserrors = ae_false;
    maxn = 20;
    passcount = 15;
    threshold = 1000*ae_machineepsilon;
    
    /*
     * Testing orthogonal
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=passcount; pass++)
        {
            ae_matrix_set_length(&r1, n-1+1, 2*n-1+1, _state);
            ae_matrix_set_length(&r2, 2*n-1+1, n-1+1, _state);
            ae_matrix_set_length(&c1, n-1+1, 2*n-1+1, _state);
            ae_matrix_set_length(&c2, 2*n-1+1, n-1+1, _state);
            
            /*
             * Random orthogonal, real
             */
            testmatgenunit_unset2d(&a, _state);
            testmatgenunit_unset2d(&b, _state);
            rmatrixrndorthogonal(n, &a, _state);
            rmatrixrndorthogonal(n, &b, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    vt = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &a.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    vt = ae_v_dotproduct(&b.ptr.pp_double[i][0], 1, &b.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    if( n>=2 )
                    {
                        rerr = rerr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
            
            /*
             * Random orthogonal, complex
             */
            testmatgenunit_unset2dc(&ca, _state);
            testmatgenunit_unset2dc(&cb, _state);
            cmatrixrndorthogonal(n, &ca, _state);
            cmatrixrndorthogonal(n, &cb, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    ct = ae_v_cdotproduct(&ca.ptr.pp_complex[i][0], 1, "N", &ca.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    ct = ae_v_cdotproduct(&cb.ptr.pp_complex[i][0], 1, "N", &cb.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    if( n>=2 )
                    {
                        cerr = cerr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                    }
                }
            }
            
            /*
             * From the right real tests:
             * 1. E*Q is orthogonal
             * 2. Q1<>Q2 (routine result is changing)
             * 3. (E E)'*Q = (Q' Q')' (correct handling of non-square matrices)
             */
            testmatgenunit_unset2d(&a, _state);
            testmatgenunit_unset2d(&b, _state);
            ae_matrix_set_length(&a, n-1+1, n-1+1, _state);
            ae_matrix_set_length(&b, n-1+1, n-1+1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = (double)(0);
                    b.ptr.pp_double[i][j] = (double)(0);
                }
                a.ptr.pp_double[i][i] = (double)(1);
                b.ptr.pp_double[i][i] = (double)(1);
            }
            rmatrixrndorthogonalfromtheright(&a, n, n, _state);
            rmatrixrndorthogonalfromtheright(&b, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    vt = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &a.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    vt = ae_v_dotproduct(&b.ptr.pp_double[i][0], 1, &b.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    if( n>=2 )
                    {
                        rerr = rerr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    r2.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    r2.ptr.pp_double[i+n][j] = r2.ptr.pp_double[i][j];
                }
            }
            rmatrixrndorthogonalfromtheright(&r2, 2*n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    rerr = rerr||ae_fp_greater(ae_fabs(r2.ptr.pp_double[i+n][j]-r2.ptr.pp_double[i][j], _state),threshold);
                }
            }
            
            /*
             * From the left real tests:
             * 1. Q*E is orthogonal
             * 2. Q1<>Q2 (routine result is changing)
             * 3. Q*(E E) = (Q Q) (correct handling of non-square matrices)
             */
            testmatgenunit_unset2d(&a, _state);
            testmatgenunit_unset2d(&b, _state);
            ae_matrix_set_length(&a, n-1+1, n-1+1, _state);
            ae_matrix_set_length(&b, n-1+1, n-1+1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = (double)(0);
                    b.ptr.pp_double[i][j] = (double)(0);
                }
                a.ptr.pp_double[i][i] = (double)(1);
                b.ptr.pp_double[i][i] = (double)(1);
            }
            rmatrixrndorthogonalfromtheleft(&a, n, n, _state);
            rmatrixrndorthogonalfromtheleft(&b, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    vt = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &a.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    vt = ae_v_dotproduct(&b.ptr.pp_double[i][0], 1, &b.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    if( n>=2 )
                    {
                        rerr = rerr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    r1.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    r1.ptr.pp_double[i][j+n] = r1.ptr.pp_double[i][j];
                }
            }
            rmatrixrndorthogonalfromtheleft(&r1, n, 2*n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    rerr = rerr||ae_fp_greater(ae_fabs(r1.ptr.pp_double[i][j]-r1.ptr.pp_double[i][j+n], _state),threshold);
                }
            }
            
            /*
             * From the right complex tests:
             * 1. E*Q is orthogonal
             * 2. Q1<>Q2 (routine result is changing)
             * 3. (E E)'*Q = (Q' Q')' (correct handling of non-square matrices)
             */
            testmatgenunit_unset2dc(&ca, _state);
            testmatgenunit_unset2dc(&cb, _state);
            ae_matrix_set_length(&ca, n-1+1, n-1+1, _state);
            ae_matrix_set_length(&cb, n-1+1, n-1+1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                    cb.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                }
                ca.ptr.pp_complex[i][i] = ae_complex_from_i(1);
                cb.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            cmatrixrndorthogonalfromtheright(&ca, n, n, _state);
            cmatrixrndorthogonalfromtheright(&cb, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    ct = ae_v_cdotproduct(&ca.ptr.pp_complex[i][0], 1, "N", &ca.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    ct = ae_v_cdotproduct(&cb.ptr.pp_complex[i][0], 1, "N", &cb.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    cerr = cerr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    c2.ptr.pp_complex[i][j] = ae_complex_from_d(2*ae_randomreal(_state)-1);
                    c2.ptr.pp_complex[i+n][j] = c2.ptr.pp_complex[i][j];
                }
            }
            cmatrixrndorthogonalfromtheright(&c2, 2*n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub(c2.ptr.pp_complex[i+n][j],c2.ptr.pp_complex[i][j]), _state),threshold);
                }
            }
            
            /*
             * From the left complex tests:
             * 1. Q*E is orthogonal
             * 2. Q1<>Q2 (routine result is changing)
             * 3. Q*(E E) = (Q Q) (correct handling of non-square matrices)
             */
            testmatgenunit_unset2dc(&ca, _state);
            testmatgenunit_unset2dc(&cb, _state);
            ae_matrix_set_length(&ca, n-1+1, n-1+1, _state);
            ae_matrix_set_length(&cb, n-1+1, n-1+1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                    cb.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                }
                ca.ptr.pp_complex[i][i] = ae_complex_from_i(1);
                cb.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            cmatrixrndorthogonalfromtheleft(&ca, n, n, _state);
            cmatrixrndorthogonalfromtheleft(&cb, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    ct = ae_v_cdotproduct(&ca.ptr.pp_complex[i][0], 1, "N", &ca.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    ct = ae_v_cdotproduct(&cb.ptr.pp_complex[i][0], 1, "N", &cb.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    cerr = cerr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    c1.ptr.pp_complex[i][j] = ae_complex_from_d(2*ae_randomreal(_state)-1);
                    c1.ptr.pp_complex[i][j+n] = c1.ptr.pp_complex[i][j];
                }
            }
            cmatrixrndorthogonalfromtheleft(&c1, n, 2*n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub(c1.ptr.pp_complex[i][j],c1.ptr.pp_complex[i][j+n]), _state),threshold);
                }
            }
        }
    }
    
    /*
     * Testing GCond
     */
    for(n=2; n<=maxn; n++)
    {
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * real test
             */
            testmatgenunit_unset2d(&a, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            rmatrixrndcond(n, cond, &a, _state);
            ae_matrix_set_length(&b, n+1, n+1, _state);
            for(i=1; i<=n; i++)
            {
                for(j=1; j<=n; j++)
                {
                    b.ptr.pp_double[i][j] = a.ptr.pp_double[i-1][j-1];
                }
            }
            if( testmatgenunit_obsoletesvddecomposition(&b, n, n, &w, &v, _state) )
            {
                maxw = w.ptr.p_double[1];
                minw = w.ptr.p_double[1];
                for(i=2; i<=n; i++)
                {
                    if( ae_fp_greater(w.ptr.p_double[i],maxw) )
                    {
                        maxw = w.ptr.p_double[i];
                    }
                    if( ae_fp_less(w.ptr.p_double[i],minw) )
                    {
                        minw = w.ptr.p_double[i];
                    }
                }
                vt = maxw/minw/cond;
                if( ae_fp_greater(ae_fabs(ae_log(vt, _state), _state),ae_log(1+threshold, _state)) )
                {
                    rerr = ae_true;
                }
            }
        }
    }
    
    /*
     * Symmetric/SPD
     * N = 2 .. 30
     */
    for(n=2; n<=maxn; n++)
    {
        
        /*
         * SPD matrices
         */
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * Generate A
             */
            testmatgenunit_unset2d(&a, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            spdmatrixrndcond(n, cond, &a, _state);
            
            /*
             * test condition number
             */
            spderr = spderr||ae_fp_greater(testmatgenunit_svdcond(&a, n, _state)/cond-1,threshold);
            
            /*
             * test SPD
             */
            spderr = spderr||!testmatgenunit_isspd(&a, n, ae_true, _state);
            
            /*
             * test that A is symmetic
             */
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    spderr = spderr||ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a.ptr.pp_double[j][i], _state),threshold);
                }
            }
            
            /*
             * test for difference between A and B (subsequent matrix)
             */
            testmatgenunit_unset2d(&b, _state);
            spdmatrixrndcond(n, cond, &b, _state);
            if( n>=2 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        spderr = spderr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
        }
        
        /*
         * HPD matrices
         */
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * Generate A
             */
            testmatgenunit_unset2dc(&ca, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            hpdmatrixrndcond(n, cond, &ca, _state);
            
            /*
             * test HPD
             */
            hpderr = hpderr||!testmatgenunit_ishpd(&ca, n, _state);
            
            /*
             * test that A is Hermitian
             */
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    hpderr = hpderr||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[i][j],ae_c_conj(ca.ptr.pp_complex[j][i], _state)), _state),threshold);
                }
            }
            
            /*
             * test for difference between A and B (subsequent matrix)
             */
            testmatgenunit_unset2dc(&cb, _state);
            hpdmatrixrndcond(n, cond, &cb, _state);
            if( n>=2 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        hpderr = hpderr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                    }
                }
            }
        }
        
        /*
         * Symmetric matrices
         */
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * test condition number
             */
            testmatgenunit_unset2d(&a, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            smatrixrndcond(n, cond, &a, _state);
            serr = serr||ae_fp_greater(testmatgenunit_svdcond(&a, n, _state)/cond-1,threshold);
            
            /*
             * test for difference between A and B
             */
            testmatgenunit_unset2d(&b, _state);
            smatrixrndcond(n, cond, &b, _state);
            if( n>=2 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        serr = serr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
        }
        
        /*
         * Hermitian matrices
         */
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * Generate A
             */
            testmatgenunit_unset2dc(&ca, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            hmatrixrndcond(n, cond, &ca, _state);
            
            /*
             * test that A is Hermitian
             */
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    herr = herr||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[i][j],ae_c_conj(ca.ptr.pp_complex[j][i], _state)), _state),threshold);
                }
            }
            
            /*
             * test for difference between A and B (subsequent matrix)
             */
            testmatgenunit_unset2dc(&cb, _state);
            hmatrixrndcond(n, cond, &cb, _state);
            if( n>=2 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        herr = herr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                    }
                }
            }
        }
    }
    
    /*
     * Test for symmetric matrices
     */
    eulerr = testmatgenunit_testeult(_state);
    
    /*
     * report
     */
    waserrors = (((((rerr||cerr)||serr)||spderr)||herr)||hpderr)||eulerr;
    if( !silent )
    {
        printf("TESTING MATRIX GENERATOR\n");
        printf("REAL TEST:                               ");
        if( !rerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COMPLEX TEST:                            ");
        if( !cerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("SYMMETRIC TEST:                          ");
        if( !serr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("HERMITIAN TEST:                          ");
        if( !herr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("SPD TEST:                                ");
        if( !spderr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("HPD TEST:                                ");
        if( !hpderr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("TEST FOR SYMMETRIC MATRICES:             ");
        if( !eulerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Unsets 2D array.
*************************************************************************/
static void testmatgenunit_unset2d(/* Real    */ ae_matrix* a,
     ae_state *_state)
{


    ae_matrix_set_length(a, 0+1, 0+1, _state);
    a->ptr.pp_double[0][0] = 2*ae_randomreal(_state)-1;
}


/*************************************************************************
Unsets 2D array.
*************************************************************************/
static void testmatgenunit_unset2dc(/* Complex */ ae_matrix* a,
     ae_state *_state)
{


    ae_matrix_set_length(a, 0+1, 0+1, _state);
    a->ptr.pp_complex[0][0] = ae_complex_from_d(2*ae_randomreal(_state)-1);
}


/*************************************************************************
Test whether matrix is SPD
*************************************************************************/
static ae_bool testmatgenunit_isspd(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix _a;
    ae_int_t i;
    ae_int_t j;
    double ajj;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&_a, 0, sizeof(_a));
    ae_matrix_init_copy(&_a, a, _state, ae_true);
    a = &_a;

    
    /*
     *     Test the input parameters.
     */
    ae_assert(n>=0, "Error in SMatrixCholesky: incorrect function arguments", _state);
    
    /*
     *     Quick return if possible
     */
    result = ae_true;
    if( n<=0 )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( isupper )
    {
        
        /*
         * Compute the Cholesky factorization A = U'*U.
         */
        for(j=0; j<=n-1; j++)
        {
            
            /*
             * Compute U(J,J) and test for non-positive-definiteness.
             */
            v = ae_v_dotproduct(&a->ptr.pp_double[0][j], a->stride, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1));
            ajj = a->ptr.pp_double[j][j]-v;
            if( ae_fp_less_eq(ajj,(double)(0)) )
            {
                result = ae_false;
                ae_frame_leave(_state);
                return result;
            }
            ajj = ae_sqrt(ajj, _state);
            a->ptr.pp_double[j][j] = ajj;
            
            /*
             * Compute elements J+1:N of row J.
             */
            if( j<n-1 )
            {
                for(i=j+1; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&a->ptr.pp_double[0][i], a->stride, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1));
                    a->ptr.pp_double[j][i] = a->ptr.pp_double[j][i]-v;
                }
                v = 1/ajj;
                ae_v_muld(&a->ptr.pp_double[j][j+1], 1, ae_v_len(j+1,n-1), v);
            }
        }
    }
    else
    {
        
        /*
         * Compute the Cholesky factorization A = L*L'.
         */
        for(j=0; j<=n-1; j++)
        {
            
            /*
             * Compute L(J,J) and test for non-positive-definiteness.
             */
            v = ae_v_dotproduct(&a->ptr.pp_double[j][0], 1, &a->ptr.pp_double[j][0], 1, ae_v_len(0,j-1));
            ajj = a->ptr.pp_double[j][j]-v;
            if( ae_fp_less_eq(ajj,(double)(0)) )
            {
                result = ae_false;
                ae_frame_leave(_state);
                return result;
            }
            ajj = ae_sqrt(ajj, _state);
            a->ptr.pp_double[j][j] = ajj;
            
            /*
             * Compute elements J+1:N of column J.
             */
            if( j<n-1 )
            {
                for(i=j+1; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&a->ptr.pp_double[i][0], 1, &a->ptr.pp_double[j][0], 1, ae_v_len(0,j-1));
                    a->ptr.pp_double[i][j] = a->ptr.pp_double[i][j]-v;
                }
                v = 1/ajj;
                ae_v_muld(&a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1), v);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Tests whether A is HPD
*************************************************************************/
static ae_bool testmatgenunit_ishpd(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix _a;
    ae_int_t j;
    double ajj;
    ae_complex v;
    double r;
    ae_vector t;
    ae_vector t2;
    ae_vector t3;
    ae_int_t i;
    ae_matrix a1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&_a, 0, sizeof(_a));
    memset(&t, 0, sizeof(t));
    memset(&t2, 0, sizeof(t2));
    memset(&t3, 0, sizeof(t3));
    memset(&a1, 0, sizeof(a1));
    ae_matrix_init_copy(&_a, a, _state, ae_true);
    a = &_a;
    ae_vector_init(&t, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&t2, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&t3, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&a1, 0, 0, DT_COMPLEX, _state, ae_true);

    ae_vector_set_length(&t, n-1+1, _state);
    ae_vector_set_length(&t2, n-1+1, _state);
    ae_vector_set_length(&t3, n-1+1, _state);
    result = ae_true;
    
    /*
     * Compute the Cholesky factorization A = U'*U.
     */
    for(j=0; j<=n-1; j++)
    {
        
        /*
         * Compute U(J,J) and test for non-positive-definiteness.
         */
        v = ae_v_cdotproduct(&a->ptr.pp_complex[0][j], a->stride, "Conj", &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,j-1));
        ajj = ae_c_sub(a->ptr.pp_complex[j][j],v).x;
        if( ae_fp_less_eq(ajj,(double)(0)) )
        {
            a->ptr.pp_complex[j][j] = ae_complex_from_d(ajj);
            result = ae_false;
            ae_frame_leave(_state);
            return result;
        }
        ajj = ae_sqrt(ajj, _state);
        a->ptr.pp_complex[j][j] = ae_complex_from_d(ajj);
        
        /*
         * Compute elements J+1:N-1 of row J.
         */
        if( j<n-1 )
        {
            ae_v_cmove(&t2.ptr.p_complex[0], 1, &a->ptr.pp_complex[0][j], a->stride, "Conj", ae_v_len(0,j-1));
            ae_v_cmove(&t3.ptr.p_complex[j+1], 1, &a->ptr.pp_complex[j][j+1], 1, "N", ae_v_len(j+1,n-1));
            for(i=j+1; i<=n-1; i++)
            {
                v = ae_v_cdotproduct(&a->ptr.pp_complex[0][i], a->stride, "N", &t2.ptr.p_complex[0], 1, "N", ae_v_len(0,j-1));
                t3.ptr.p_complex[i] = ae_c_sub(t3.ptr.p_complex[i],v);
            }
            ae_v_cmove(&a->ptr.pp_complex[j][j+1], 1, &t3.ptr.p_complex[j+1], 1, "N", ae_v_len(j+1,n-1));
            r = 1/ajj;
            ae_v_cmuld(&a->ptr.pp_complex[j][j+1], 1, ae_v_len(j+1,n-1), r);
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
The function check, that upper triangle from symmetric matrix is equal to
lower triangle.
*************************************************************************/
static ae_bool testmatgenunit_testeult(ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix b;
    double c;
    double range;
    double eps;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&b, 0, sizeof(b));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_COMPLEX, _state, ae_true);

    eps = 2*ae_machineepsilon;
    range = 100*(2*ae_randomreal(_state)-1);
    for(n=1; n<=15; n++)
    {
        c = 900*ae_randomreal(_state)+100;
        
        /*
         * Generate symmetric matrix and check it
         */
        smatrixrndcond(n, c, &a, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a.ptr.pp_double[j][i], _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        spdmatrixrndcond(n, c, &a, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a.ptr.pp_double[j][i], _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        hmatrixrndcond(n, c, &b, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].x-b.ptr.pp_complex[j][i].x, _state),eps)||ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].y+b.ptr.pp_complex[j][i].y, _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        hpdmatrixrndcond(n, c, &b, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].x-b.ptr.pp_complex[j][i].x, _state),eps)||ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].y+b.ptr.pp_complex[j][i].y, _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        
        /*
         * Prepare symmetric matrix with real values
         */
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                a.ptr.pp_double[i][j] = range*(2*ae_randomreal(_state)-1);
            }
        }
        for(i=0; i<=n-2; i++)
        {
            for(j=i+1; j<=n-1; j++)
            {
                a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
            }
        }
        smatrixrndmultiply(&a, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a.ptr.pp_double[j][i], _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        
        /*
         * Prepare symmetric matrix with complex values
         */
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                b.ptr.pp_complex[i][j].x = range*(2*ae_randomreal(_state)-1);
                if( i!=j )
                {
                    b.ptr.pp_complex[i][j].y = range*(2*ae_randomreal(_state)-1);
                }
                else
                {
                    b.ptr.pp_complex[i][j].y = (double)(0);
                }
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=i+1; j<=n-1; j++)
            {
                b.ptr.pp_complex[i][j].x = b.ptr.pp_complex[j][i].x;
                b.ptr.pp_complex[i][j].y = -b.ptr.pp_complex[j][i].y;
            }
        }
        hmatrixrndmultiply(&b, n, _state);
        for(i=0; i<=n-1; i++)
        {
            b.ptr.pp_complex[i][i].y = (double)(0);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].x-b.ptr.pp_complex[j][i].x, _state),eps)||ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].y+b.ptr.pp_complex[j][i].y, _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
SVD condition number
*************************************************************************/
static double testmatgenunit_svdcond(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix v;
    ae_vector w;
    ae_int_t i;
    ae_int_t j;
    double minw;
    double maxw;
    double result;

    ae_frame_make(_state, &_frame_block);
    memset(&a1, 0, sizeof(a1));
    memset(&v, 0, sizeof(v));
    memset(&w, 0, sizeof(w));
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&v, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&w, 0, DT_REAL, _state, ae_true);

    ae_matrix_set_length(&a1, n+1, n+1, _state);
    for(i=1; i<=n; i++)
    {
        for(j=1; j<=n; j++)
        {
            a1.ptr.pp_double[i][j] = a->ptr.pp_double[i-1][j-1];
        }
    }
    if( !testmatgenunit_obsoletesvddecomposition(&a1, n, n, &w, &v, _state) )
    {
        result = (double)(0);
        ae_frame_leave(_state);
        return result;
    }
    minw = w.ptr.p_double[1];
    maxw = w.ptr.p_double[1];
    for(i=2; i<=n; i++)
    {
        if( ae_fp_less(w.ptr.p_double[i],minw) )
        {
            minw = w.ptr.p_double[i];
        }
        if( ae_fp_greater(w.ptr.p_double[i],maxw) )
        {
            maxw = w.ptr.p_double[i];
        }
    }
    result = maxw/minw;
    ae_frame_leave(_state);
    return result;
}


static ae_bool testmatgenunit_obsoletesvddecomposition(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* v,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t nm;
    ae_int_t minmn;
    ae_int_t l;
    ae_int_t k;
    ae_int_t j;
    ae_int_t jj;
    ae_int_t its;
    ae_int_t i;
    double z;
    double y;
    double x;
    double vscale;
    double s;
    double h;
    double g;
    double f;
    double c;
    double anorm;
    ae_vector rv1;
    ae_bool flag;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&rv1, 0, sizeof(rv1));
    ae_vector_clear(w);
    ae_matrix_clear(v);
    ae_vector_init(&rv1, 0, DT_REAL, _state, ae_true);

    ae_vector_set_length(&rv1, n+1, _state);
    ae_vector_set_length(w, n+1, _state);
    ae_matrix_set_length(v, n+1, n+1, _state);
    result = ae_true;
    if( m<n )
    {
        minmn = m;
    }
    else
    {
        minmn = n;
    }
    g = 0.0;
    vscale = 0.0;
    anorm = 0.0;
    l = n;
    for(i=1; i<=n; i++)
    {
        l = i+1;
        rv1.ptr.p_double[i] = vscale*g;
        g = (double)(0);
        s = (double)(0);
        vscale = (double)(0);
        if( i<=m )
        {
            for(k=i; k<=m; k++)
            {
                vscale = vscale+ae_fabs(a->ptr.pp_double[k][i], _state);
            }
            if( ae_fp_neq(vscale,0.0) )
            {
                for(k=i; k<=m; k++)
                {
                    a->ptr.pp_double[k][i] = a->ptr.pp_double[k][i]/vscale;
                    s = s+a->ptr.pp_double[k][i]*a->ptr.pp_double[k][i];
                }
                f = a->ptr.pp_double[i][i];
                g = -testmatgenunit_extsign(ae_sqrt(s, _state), f, _state);
                h = f*g-s;
                a->ptr.pp_double[i][i] = f-g;
                if( i!=n )
                {
                    for(j=l; j<=n; j++)
                    {
                        s = 0.0;
                        for(k=i; k<=m; k++)
                        {
                            s = s+a->ptr.pp_double[k][i]*a->ptr.pp_double[k][j];
                        }
                        f = s/h;
                        for(k=i; k<=m; k++)
                        {
                            a->ptr.pp_double[k][j] = a->ptr.pp_double[k][j]+f*a->ptr.pp_double[k][i];
                        }
                    }
                }
                for(k=i; k<=m; k++)
                {
                    a->ptr.pp_double[k][i] = vscale*a->ptr.pp_double[k][i];
                }
            }
        }
        w->ptr.p_double[i] = vscale*g;
        g = 0.0;
        s = 0.0;
        vscale = 0.0;
        if( i<=m&&i!=n )
        {
            for(k=l; k<=n; k++)
            {
                vscale = vscale+ae_fabs(a->ptr.pp_double[i][k], _state);
            }
            if( ae_fp_neq(vscale,0.0) )
            {
                for(k=l; k<=n; k++)
                {
                    a->ptr.pp_double[i][k] = a->ptr.pp_double[i][k]/vscale;
                    s = s+a->ptr.pp_double[i][k]*a->ptr.pp_double[i][k];
                }
                f = a->ptr.pp_double[i][l];
                g = -testmatgenunit_extsign(ae_sqrt(s, _state), f, _state);
                h = f*g-s;
                a->ptr.pp_double[i][l] = f-g;
                for(k=l; k<=n; k++)
                {
                    rv1.ptr.p_double[k] = a->ptr.pp_double[i][k]/h;
                }
                if( i!=m )
                {
                    for(j=l; j<=m; j++)
                    {
                        s = 0.0;
                        for(k=l; k<=n; k++)
                        {
                            s = s+a->ptr.pp_double[j][k]*a->ptr.pp_double[i][k];
                        }
                        for(k=l; k<=n; k++)
                        {
                            a->ptr.pp_double[j][k] = a->ptr.pp_double[j][k]+s*rv1.ptr.p_double[k];
                        }
                    }
                }
                for(k=l; k<=n; k++)
                {
                    a->ptr.pp_double[i][k] = vscale*a->ptr.pp_double[i][k];
                }
            }
        }
        anorm = testmatgenunit_mymax(anorm, ae_fabs(w->ptr.p_double[i], _state)+ae_fabs(rv1.ptr.p_double[i], _state), _state);
    }
    for(i=n; i>=1; i--)
    {
        if( i<n )
        {
            if( ae_fp_neq(g,0.0) )
            {
                for(j=l; j<=n; j++)
                {
                    v->ptr.pp_double[j][i] = a->ptr.pp_double[i][j]/a->ptr.pp_double[i][l]/g;
                }
                for(j=l; j<=n; j++)
                {
                    s = 0.0;
                    for(k=l; k<=n; k++)
                    {
                        s = s+a->ptr.pp_double[i][k]*v->ptr.pp_double[k][j];
                    }
                    for(k=l; k<=n; k++)
                    {
                        v->ptr.pp_double[k][j] = v->ptr.pp_double[k][j]+s*v->ptr.pp_double[k][i];
                    }
                }
            }
            for(j=l; j<=n; j++)
            {
                v->ptr.pp_double[i][j] = 0.0;
                v->ptr.pp_double[j][i] = 0.0;
            }
        }
        v->ptr.pp_double[i][i] = 1.0;
        g = rv1.ptr.p_double[i];
        l = i;
    }
    for(i=minmn; i>=1; i--)
    {
        l = i+1;
        g = w->ptr.p_double[i];
        if( i<n )
        {
            for(j=l; j<=n; j++)
            {
                a->ptr.pp_double[i][j] = 0.0;
            }
        }
        if( ae_fp_neq(g,0.0) )
        {
            g = 1.0/g;
            if( i!=n )
            {
                for(j=l; j<=n; j++)
                {
                    s = 0.0;
                    for(k=l; k<=m; k++)
                    {
                        s = s+a->ptr.pp_double[k][i]*a->ptr.pp_double[k][j];
                    }
                    f = s/a->ptr.pp_double[i][i]*g;
                    for(k=i; k<=m; k++)
                    {
                        a->ptr.pp_double[k][j] = a->ptr.pp_double[k][j]+f*a->ptr.pp_double[k][i];
                    }
                }
            }
            for(j=i; j<=m; j++)
            {
                a->ptr.pp_double[j][i] = a->ptr.pp_double[j][i]*g;
            }
        }
        else
        {
            for(j=i; j<=m; j++)
            {
                a->ptr.pp_double[j][i] = 0.0;
            }
        }
        a->ptr.pp_double[i][i] = a->ptr.pp_double[i][i]+1.0;
    }
    nm = 0;
    for(k=n; k>=1; k--)
    {
        for(its=1; its<=testmatgenunit_maxsvditerations; its++)
        {
            flag = ae_true;
            for(l=k; l>=1; l--)
            {
                nm = l-1;
                if( ae_fp_eq(ae_fabs(rv1.ptr.p_double[l], _state)+anorm,anorm) )
                {
                    flag = ae_false;
                    break;
                }
                if( ae_fp_eq(ae_fabs(w->ptr.p_double[nm], _state)+anorm,anorm) )
                {
                    break;
                }
            }
            if( flag )
            {
                c = 0.0;
                s = 1.0;
                for(i=l; i<=k; i++)
                {
                    f = s*rv1.ptr.p_double[i];
                    if( ae_fp_neq(ae_fabs(f, _state)+anorm,anorm) )
                    {
                        g = w->ptr.p_double[i];
                        h = testmatgenunit_pythag(f, g, _state);
                        w->ptr.p_double[i] = h;
                        h = 1.0/h;
                        c = g*h;
                        s = -f*h;
                        for(j=1; j<=m; j++)
                        {
                            y = a->ptr.pp_double[j][nm];
                            z = a->ptr.pp_double[j][i];
                            a->ptr.pp_double[j][nm] = y*c+z*s;
                            a->ptr.pp_double[j][i] = -y*s+z*c;
                        }
                    }
                }
            }
            z = w->ptr.p_double[k];
            if( l==k )
            {
                if( ae_fp_less(z,0.0) )
                {
                    w->ptr.p_double[k] = -z;
                    for(j=1; j<=n; j++)
                    {
                        v->ptr.pp_double[j][k] = -v->ptr.pp_double[j][k];
                    }
                }
                break;
            }
            if( its==testmatgenunit_maxsvditerations )
            {
                result = ae_false;
                ae_frame_leave(_state);
                return result;
            }
            x = w->ptr.p_double[l];
            nm = k-1;
            y = w->ptr.p_double[nm];
            g = rv1.ptr.p_double[nm];
            h = rv1.ptr.p_double[k];
            f = ((y-z)*(y+z)+(g-h)*(g+h))/(2.0*h*y);
            g = testmatgenunit_pythag(f, (double)(1), _state);
            f = ((x-z)*(x+z)+h*(y/(f+testmatgenunit_extsign(g, f, _state))-h))/x;
            c = 1.0;
            s = 1.0;
            for(j=l; j<=nm; j++)
            {
                i = j+1;
                g = rv1.ptr.p_double[i];
                y = w->ptr.p_double[i];
                h = s*g;
                g = c*g;
                z = testmatgenunit_pythag(f, h, _state);
                rv1.ptr.p_double[j] = z;
                c = f/z;
                s = h/z;
                f = x*c+g*s;
                g = -x*s+g*c;
                h = y*s;
                y = y*c;
                for(jj=1; jj<=n; jj++)
                {
                    x = v->ptr.pp_double[jj][j];
                    z = v->ptr.pp_double[jj][i];
                    v->ptr.pp_double[jj][j] = x*c+z*s;
                    v->ptr.pp_double[jj][i] = -x*s+z*c;
                }
                z = testmatgenunit_pythag(f, h, _state);
                w->ptr.p_double[j] = z;
                if( ae_fp_neq(z,0.0) )
                {
                    z = 1.0/z;
                    c = f*z;
                    s = h*z;
                }
                f = c*g+s*y;
                x = -s*g+c*y;
                for(jj=1; jj<=m; jj++)
                {
                    y = a->ptr.pp_double[jj][j];
                    z = a->ptr.pp_double[jj][i];
                    a->ptr.pp_double[jj][j] = y*c+z*s;
                    a->ptr.pp_double[jj][i] = -y*s+z*c;
                }
            }
            rv1.ptr.p_double[l] = 0.0;
            rv1.ptr.p_double[k] = f;
            w->ptr.p_double[k] = x;
        }
    }
    ae_frame_leave(_state);
    return result;
}


static double testmatgenunit_extsign(double a, double b, ae_state *_state)
{
    double result;


    if( ae_fp_greater_eq(b,(double)(0)) )
    {
        result = ae_fabs(a, _state);
    }
    else
    {
        result = -ae_fabs(a, _state);
    }
    return result;
}


static double testmatgenunit_mymax(double a, double b, ae_state *_state)
{
    double result;


    if( ae_fp_greater(a,b) )
    {
        result = a;
    }
    else
    {
        result = b;
    }
    return result;
}


static double testmatgenunit_pythag(double a, double b, ae_state *_state)
{
    double result;


    if( ae_fp_less(ae_fabs(a, _state),ae_fabs(b, _state)) )
    {
        result = ae_fabs(b, _state)*ae_sqrt(1+ae_sqr(a/b, _state), _state);
    }
    else
    {
        result = ae_fabs(a, _state)*ae_sqrt(1+ae_sqr(b/a, _state), _state);
    }
    return result;
}



static void testtsortunit_unset1di(/* Integer */ ae_vector* a,
     ae_state *_state);
static void testtsortunit_testsortresults(/* Real    */ ae_vector* asorted,
     /* Integer */ ae_vector* p1,
     /* Integer */ ae_vector* p2,
     /* Real    */ ae_vector* aoriginal,
     ae_int_t n,
     ae_bool* waserrors,
     ae_state *_state);





/*************************************************************************
Testing tag sort
*************************************************************************/
ae_bool testtsort(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool waserrors;
    ae_int_t n;
    ae_int_t i;
    ae_int_t m;
    ae_int_t offs;
    ae_int_t pass;
    ae_int_t passcount;
    ae_int_t maxn;
    ae_vector a;
    ae_vector a0;
    ae_vector a1;
    ae_vector a2;
    ae_vector a3;
    ae_vector i1;
    ae_vector i2;
    ae_vector i3;
    ae_vector a4;
    ae_vector a5;
    ae_vector pa4;
    ae_vector ar;
    ae_vector ar2;
    ae_vector ai;
    ae_vector p1;
    ae_vector p2;
    ae_vector bufr1;
    ae_vector bufr2;
    ae_vector bufi1;
    ae_bool distinctvals;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&a0, 0, sizeof(a0));
    memset(&a1, 0, sizeof(a1));
    memset(&a2, 0, sizeof(a2));
    memset(&a3, 0, sizeof(a3));
    memset(&i1, 0, sizeof(i1));
    memset(&i2, 0, sizeof(i2));
    memset(&i3, 0, sizeof(i3));
    memset(&a4, 0, sizeof(a4));
    memset(&a5, 0, sizeof(a5));
    memset(&pa4, 0, sizeof(pa4));
    memset(&ar, 0, sizeof(ar));
    memset(&ar2, 0, sizeof(ar2));
    memset(&ai, 0, sizeof(ai));
    memset(&p1, 0, sizeof(p1));
    memset(&p2, 0, sizeof(p2));
    memset(&bufr1, 0, sizeof(bufr1));
    memset(&bufr2, 0, sizeof(bufr2));
    memset(&bufi1, 0, sizeof(bufi1));
    ae_vector_init(&a, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&a0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&a1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&a2, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&a3, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&i1, 0, DT_INT, _state, ae_true);
    ae_vector_init(&i2, 0, DT_INT, _state, ae_true);
    ae_vector_init(&i3, 0, DT_INT, _state, ae_true);
    ae_vector_init(&a4, 0, DT_INT, _state, ae_true);
    ae_vector_init(&a5, 0, DT_INT, _state, ae_true);
    ae_vector_init(&pa4, 0, DT_INT, _state, ae_true);
    ae_vector_init(&ar, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ar2, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ai, 0, DT_INT, _state, ae_true);
    ae_vector_init(&p1, 0, DT_INT, _state, ae_true);
    ae_vector_init(&p2, 0, DT_INT, _state, ae_true);
    ae_vector_init(&bufr1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&bufr2, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&bufi1, 0, DT_INT, _state, ae_true);

    waserrors = ae_false;
    maxn = 100;
    passcount = 10;
    
    /*
     * Test tagsort
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * Pprobably distinct sort:
             * * generate array of integer random numbers.
             *   Because of birthday paradox, random numbers have to be VERY large
             *   in order to avoid situation when we have distinct values.
             * * sort A0 using TagSort and test sort results
             * * now we can use A0 as reference point and test other functions
             */
            testtsortunit_unset1di(&p1, _state);
            testtsortunit_unset1di(&p2, _state);
            ae_vector_set_length(&a, n, _state);
            ae_vector_set_length(&a0, n, _state);
            ae_vector_set_length(&a1, n, _state);
            ae_vector_set_length(&a2, n, _state);
            ae_vector_set_length(&a3, n, _state);
            ae_vector_set_length(&a4, n, _state);
            ae_vector_set_length(&a5, n, _state);
            ae_vector_set_length(&ar, n, _state);
            ae_vector_set_length(&ar2, n, _state);
            ae_vector_set_length(&ai, n, _state);
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(ae_randominteger(100000000, _state));
                a0.ptr.p_double[i] = a.ptr.p_double[i];
                a1.ptr.p_double[i] = a.ptr.p_double[i];
                a2.ptr.p_double[i] = a.ptr.p_double[i];
                a3.ptr.p_double[i] = a.ptr.p_double[i];
                a4.ptr.p_int[i] = ae_round(a.ptr.p_double[i], _state);
                a5.ptr.p_int[i] = ae_round(a.ptr.p_double[i], _state);
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
                ai.ptr.p_int[i] = i;
            }
            tagsort(&a0, n, &p1, &p2, _state);
            testtsortunit_testsortresults(&a0, &p1, &p2, &a, n, &waserrors, _state);
            distinctvals = ae_true;
            for(i=1; i<=n-1; i++)
            {
                distinctvals = distinctvals&&ae_fp_neq(a0.ptr.p_double[i],a0.ptr.p_double[i-1]);
            }
            if( distinctvals )
            {
                tagsortfasti(&a1, &ai, &bufr1, &bufi1, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = (waserrors||ae_fp_neq(a1.ptr.p_double[i],a0.ptr.p_double[i]))||ai.ptr.p_int[i]!=p1.ptr.p_int[i];
                }
                tagsortfastr(&a2, &ar, &bufr1, &bufr2, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = (waserrors||ae_fp_neq(a2.ptr.p_double[i],a0.ptr.p_double[i]))||ae_fp_neq(ar.ptr.p_double[i],(double)(p1.ptr.p_int[i]));
                }
                tagsortfast(&a3, &bufr1, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = waserrors||ae_fp_neq(a3.ptr.p_double[i],a0.ptr.p_double[i]);
                }
                tagsortmiddleir(&a4, &ar2, 0, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = (waserrors||ae_fp_neq((double)(a4.ptr.p_int[i]),a0.ptr.p_double[i]))||ae_fp_neq(ar2.ptr.p_double[i],(double)(p1.ptr.p_int[i]));
                }
                sortmiddlei(&a5, 0, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = waserrors||ae_fp_neq((double)(a5.ptr.p_int[i]),a0.ptr.p_double[i]);
                }
            }
            
            /*
             * Non-distinct sort.
             * We test that keys are correctly reordered, but do NOT test order of values.
             */
            testtsortunit_unset1di(&p1, _state);
            testtsortunit_unset1di(&p2, _state);
            ae_vector_set_length(&a, n, _state);
            ae_vector_set_length(&a0, n, _state);
            ae_vector_set_length(&a1, n, _state);
            ae_vector_set_length(&a2, n, _state);
            ae_vector_set_length(&a3, n, _state);
            ae_vector_set_length(&a4, n, _state);
            ae_vector_set_length(&a5, n, _state);
            ae_vector_set_length(&ar, n, _state);
            ae_vector_set_length(&ar2, n, _state);
            ae_vector_set_length(&ai, n, _state);
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)((n-i)/2);
                a0.ptr.p_double[i] = a.ptr.p_double[i];
                a1.ptr.p_double[i] = a.ptr.p_double[i];
                a2.ptr.p_double[i] = a.ptr.p_double[i];
                a3.ptr.p_double[i] = a.ptr.p_double[i];
                a4.ptr.p_int[i] = ae_round(a.ptr.p_double[i], _state);
                a5.ptr.p_int[i] = ae_round(a.ptr.p_double[i], _state);
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
                ai.ptr.p_int[i] = i;
            }
            tagsort(&a0, n, &p1, &p2, _state);
            testtsortunit_testsortresults(&a0, &p1, &p2, &a, n, &waserrors, _state);
            tagsortfasti(&a1, &ai, &bufr1, &bufi1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a1.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfastr(&a2, &ar, &bufr1, &bufr2, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a2.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfast(&a3, &bufr1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a3.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortmiddleir(&a4, &ar2, 0, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq((double)(a4.ptr.p_int[i]),a0.ptr.p_double[i]);
            }
            sortmiddlei(&a5, 0, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq((double)(a5.ptr.p_int[i]),a0.ptr.p_double[i]);
            }
            
            /*
             * 'All same' sort
             * We test that keys are correctly reordered, but do NOT test order of values.
             */
            testtsortunit_unset1di(&p1, _state);
            testtsortunit_unset1di(&p2, _state);
            ae_vector_set_length(&a, n, _state);
            ae_vector_set_length(&a0, n, _state);
            ae_vector_set_length(&a1, n, _state);
            ae_vector_set_length(&a2, n, _state);
            ae_vector_set_length(&a3, n, _state);
            ae_vector_set_length(&a4, n, _state);
            ae_vector_set_length(&ar, n, _state);
            ae_vector_set_length(&ar2, n, _state);
            ae_vector_set_length(&ai, n, _state);
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(0);
                a0.ptr.p_double[i] = a.ptr.p_double[i];
                a1.ptr.p_double[i] = a.ptr.p_double[i];
                a2.ptr.p_double[i] = a.ptr.p_double[i];
                a3.ptr.p_double[i] = a.ptr.p_double[i];
                a4.ptr.p_int[i] = ae_round(a.ptr.p_double[i], _state);
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
                ai.ptr.p_int[i] = i;
            }
            tagsort(&a0, n, &p1, &p2, _state);
            testtsortunit_testsortresults(&a0, &p1, &p2, &a, n, &waserrors, _state);
            tagsortfasti(&a1, &ai, &bufr1, &bufi1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a1.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfastr(&a2, &ar, &bufr1, &bufr2, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a2.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfast(&a3, &bufr1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a3.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortmiddleir(&a4, &ar2, 0, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq((double)(a4.ptr.p_int[i]),a0.ptr.p_double[i]);
            }
            
            /*
             * 0-1 sort
             * We test that keys are correctly reordered, but do NOT test order of values.
             */
            testtsortunit_unset1di(&p1, _state);
            testtsortunit_unset1di(&p2, _state);
            ae_vector_set_length(&a, n, _state);
            ae_vector_set_length(&a0, n, _state);
            ae_vector_set_length(&a1, n, _state);
            ae_vector_set_length(&a2, n, _state);
            ae_vector_set_length(&a3, n, _state);
            ae_vector_set_length(&a4, n, _state);
            ae_vector_set_length(&ar, n, _state);
            ae_vector_set_length(&ar2, n, _state);
            ae_vector_set_length(&ai, n, _state);
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(ae_randominteger(2, _state));
                a0.ptr.p_double[i] = a.ptr.p_double[i];
                a1.ptr.p_double[i] = a.ptr.p_double[i];
                a2.ptr.p_double[i] = a.ptr.p_double[i];
                a3.ptr.p_double[i] = a.ptr.p_double[i];
                a4.ptr.p_int[i] = ae_round(a.ptr.p_double[i], _state);
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
                ai.ptr.p_int[i] = i;
            }
            tagsort(&a0, n, &p1, &p2, _state);
            testtsortunit_testsortresults(&a0, &p1, &p2, &a, n, &waserrors, _state);
            tagsortfasti(&a1, &ai, &bufr1, &bufi1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a1.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfastr(&a2, &ar, &bufr1, &bufr2, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a2.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfast(&a3, &bufr1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a3.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortmiddleir(&a4, &ar2, 0, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq((double)(a4.ptr.p_int[i]),a0.ptr.p_double[i]);
            }
            
            /*
             * Special test for TagSortMiddleIR: sorting in the middle gives same results
             * as sorting in the beginning of the array
             */
            m = 3*n;
            offs = ae_randominteger(n, _state);
            ae_vector_set_length(&i1, m, _state);
            ae_vector_set_length(&i2, m, _state);
            ae_vector_set_length(&i3, m, _state);
            ae_vector_set_length(&ar, m, _state);
            ae_vector_set_length(&ar2, m, _state);
            for(i=0; i<=m-1; i++)
            {
                i1.ptr.p_int[i] = ae_randominteger(100000000, _state);
                i2.ptr.p_int[i] = i1.ptr.p_int[i];
                i3.ptr.p_int[i] = i1.ptr.p_int[i];
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
            }
            for(i=0; i<=n-1; i++)
            {
                i1.ptr.p_int[i] = i1.ptr.p_int[offs+i];
                ar.ptr.p_double[i] = ar.ptr.p_double[offs+i];
            }
            tagsortmiddleir(&i1, &ar, 0, n, _state);
            for(i=1; i<=n-1; i++)
            {
                distinctvals = distinctvals&&i1.ptr.p_int[i]!=i1.ptr.p_int[i-1];
            }
            if( distinctvals )
            {
                tagsortmiddleir(&i2, &ar2, offs, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = (waserrors||i2.ptr.p_int[offs+i]!=i1.ptr.p_int[i])||ae_fp_neq(ar2.ptr.p_double[offs+i],ar.ptr.p_double[i]);
                }
            }
        }
    }
    
    /*
     * report
     */
    if( !silent )
    {
        printf("TESTING TAGSORT\n");
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Unsets 1D array.
*************************************************************************/
static void testtsortunit_unset1di(/* Integer */ ae_vector* a,
     ae_state *_state)
{


    ae_vector_set_length(a, 0+1, _state);
    a->ptr.p_int[0] = ae_randominteger(3, _state)-1;
}


static void testtsortunit_testsortresults(/* Real    */ ae_vector* asorted,
     /* Integer */ ae_vector* p1,
     /* Integer */ ae_vector* p2,
     /* Real    */ ae_vector* aoriginal,
     ae_int_t n,
     ae_bool* waserrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_vector a2;
    double t;
    ae_vector f;

    ae_frame_make(_state, &_frame_block);
    memset(&a2, 0, sizeof(a2));
    memset(&f, 0, sizeof(f));
    ae_vector_init(&a2, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&f, 0, DT_INT, _state, ae_true);

    ae_vector_set_length(&a2, n-1+1, _state);
    ae_vector_set_length(&f, n-1+1, _state);
    
    /*
     * is set ordered?
     */
    for(i=0; i<=n-2; i++)
    {
        *waserrors = *waserrors||ae_fp_greater(asorted->ptr.p_double[i],asorted->ptr.p_double[i+1]);
    }
    
    /*
     * P1 correctness
     */
    for(i=0; i<=n-1; i++)
    {
        *waserrors = *waserrors||ae_fp_neq(asorted->ptr.p_double[i],aoriginal->ptr.p_double[p1->ptr.p_int[i]]);
    }
    for(i=0; i<=n-1; i++)
    {
        f.ptr.p_int[i] = 0;
    }
    for(i=0; i<=n-1; i++)
    {
        f.ptr.p_int[p1->ptr.p_int[i]] = f.ptr.p_int[p1->ptr.p_int[i]]+1;
    }
    for(i=0; i<=n-1; i++)
    {
        *waserrors = *waserrors||f.ptr.p_int[i]!=1;
    }
    
    /*
     * P2 correctness
     */
    for(i=0; i<=n-1; i++)
    {
        a2.ptr.p_double[i] = aoriginal->ptr.p_double[i];
    }
    for(i=0; i<=n-1; i++)
    {
        if( p2->ptr.p_int[i]!=i )
        {
            t = a2.ptr.p_double[i];
            a2.ptr.p_double[i] = a2.ptr.p_double[p2->ptr.p_int[i]];
            a2.ptr.p_double[p2->ptr.p_int[i]] = t;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        *waserrors = *waserrors||ae_fp_neq(asorted->ptr.p_double[i],a2.ptr.p_double[i]);
    }
    ae_frame_leave(_state);
}



static ae_int_t testsparseunit_maxtype = 2;
static void testsparseunit_initgenerator(ae_int_t m,
     ae_int_t n,
     ae_int_t matkind,
     ae_int_t triangle,
     sparsegenerator* g,
     ae_state *_state);
static ae_bool testsparseunit_generatenext(sparsegenerator* g,
     /* Real    */ ae_matrix* da,
     sparsematrix* sa,
     ae_state *_state);
static void testsparseunit_createrandom(ae_int_t m,
     ae_int_t n,
     ae_int_t pkind,
     ae_int_t ckind,
     ae_int_t p0,
     ae_int_t p1,
     /* Real    */ ae_matrix* da,
     sparsematrix* sa,
     ae_state *_state);
static ae_bool testsparseunit_enumeratetest(ae_state *_state);
static ae_bool testsparseunit_rewriteexistingtest(ae_state *_state);
static void testsparseunit_testgetrow(ae_bool* err, ae_state *_state);
static ae_bool testsparseunit_testconvertsm(ae_state *_state);
static ae_bool testsparseunit_testgcmatrixtype(ae_state *_state);





ae_bool testsparse(ae_bool silent, ae_state *_state)
{
    ae_bool waserrors;
    ae_bool basicerrors;
    ae_bool linearerrors;
    ae_bool basicrnderrors;
    ae_bool level2unsymmetricerrors;
    ae_bool level2symmetricerrors;
    ae_bool level2triangularerrors;
    ae_bool level3unsymmetricerrors;
    ae_bool level3symmetricerrors;
    ae_bool symmetricpermerrors;
    ae_bool linearserrors;
    ae_bool linearmmerrors;
    ae_bool linearsmmerrors;
    ae_bool getrowerrors;
    ae_bool serializeerrors;
    ae_bool copyerrors;
    ae_bool basiccopyerrors;
    ae_bool enumerateerrors;
    ae_bool rewriteexistingerr;
    ae_bool skserrors;
    ae_bool crserrors;
    ae_bool result;


    getrowerrors = ae_false;
    crserrors = ae_false;
    serializeerrors = ae_false;
    skserrors = skstest(_state);
    crstest(&crserrors, _state);
    basicerrors = basicfunctest(_state)||testsparseunit_testgcmatrixtype(_state);
    basicrnderrors = basicfuncrandomtest(_state);
    linearerrors = linearfunctionstest(_state);
    level2unsymmetricerrors = testlevel2unsymmetric(_state);
    level2symmetricerrors = testlevel2symmetric(_state);
    level2triangularerrors = testlevel2triangular(_state);
    level3unsymmetricerrors = testlevel3unsymmetric(_state);
    level3symmetricerrors = testlevel3symmetric(_state);
    symmetricpermerrors = testsymmetricperm(_state);
    linearserrors = linearfunctionsstest(_state);
    linearmmerrors = linearfunctionsmmtest(_state);
    linearsmmerrors = linearfunctionssmmtest(_state);
    copyerrors = copyfunctest(ae_true, _state)||testsparseunit_testconvertsm(_state);
    basiccopyerrors = basiccopyfunctest(ae_true, _state);
    enumerateerrors = testsparseunit_enumeratetest(_state);
    rewriteexistingerr = testsparseunit_rewriteexistingtest(_state);
    testsparseunit_testgetrow(&getrowerrors, _state);
    testserialize(&serializeerrors, _state);
    
    /*
     * report
     */
    waserrors = ((((((((((((((((((skserrors||crserrors)||getrowerrors)||serializeerrors)||basicerrors)||linearerrors)||basicrnderrors)||level2unsymmetricerrors)||level2symmetricerrors)||level2triangularerrors)||level3unsymmetricerrors)||level3symmetricerrors)||symmetricpermerrors)||linearserrors)||linearmmerrors)||linearsmmerrors)||copyerrors)||basiccopyerrors)||enumerateerrors)||rewriteexistingerr;
    if( !silent )
    {
        printf("TESTING SPARSE\n");
        printf("STORAGE FORMAT SPECIFICS:\n");
        printf("* SKS:                                   ");
        if( !skserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* CRS:                                   ");
        if( !crserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("OPERATIONS:\n");
        printf("* GETROW:                                ");
        if( !getrowerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* SERIALIZE:                             ");
        if( !serializeerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("BLAS:\n");
        printf("* LEVEL 2 GENERAL:                       ");
        if( !level2unsymmetricerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* LEVEL 2 SYMMETRIC:                     ");
        if( !level2symmetricerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* LEVEL 2 TRIANGULAR:                    ");
        if( !level2triangularerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* LEVEL 3 GENERAL:                       ");
        if( !level3unsymmetricerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* LEVEL 3 SYMMETRIC:                     ");
        if( !level3symmetricerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* PERMUTATIONS (SYMMETRIC):              ");
        if( !symmetricpermerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("BASIC TEST:                              ");
        if( !basicerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COPY TEST:                               ");
        if( !copyerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("BASIC_COPY TEST:                         ");
        if( !basiccopyerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("BASIC_RND TEST:                          ");
        if( !basicrnderrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("LINEAR TEST:                             ");
        if( !linearerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("LINEAR TEST FOR SYMMETRIC MATRICES:      ");
        if( !linearserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("LINEAR MxM TEST:                         ");
        if( !linearmmerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("LINEAR MxM TEST FOR SYMMETRIC MATRICES:  ");
        if( !linearsmmerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("ENUMERATE TEST:                          ");
        if( !enumerateerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("REWRITE EXISTING TEST:                   ");
        if( !rewriteexistingerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    return result;
}


/*************************************************************************
Function for testing basic SKS functional.
Returns True on errors, False on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
ae_bool skstest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix s2;
    sparsematrix s3;
    sparsematrix s4;
    sparsematrix s5;
    sparsematrix s6;
    ae_int_t n;
    ae_int_t nz;
    double pnz;
    ae_int_t i;
    ae_int_t j;
    ae_int_t t0;
    ae_int_t t1;
    ae_matrix a;
    ae_matrix wasenumerated;
    ae_vector d;
    ae_vector u;
    hqrndstate rs;
    double v0;
    double v1;
    ae_int_t uppercnt;
    ae_int_t lowercnt;
    ae_int_t bw;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    memset(&s2, 0, sizeof(s2));
    memset(&s3, 0, sizeof(s3));
    memset(&s4, 0, sizeof(s4));
    memset(&s5, 0, sizeof(s5));
    memset(&s6, 0, sizeof(s6));
    memset(&a, 0, sizeof(a));
    memset(&wasenumerated, 0, sizeof(wasenumerated));
    memset(&d, 0, sizeof(d));
    memset(&u, 0, sizeof(u));
    memset(&rs, 0, sizeof(rs));
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&s1, _state, ae_true);
    _sparsematrix_init(&s2, _state, ae_true);
    _sparsematrix_init(&s3, _state, ae_true);
    _sparsematrix_init(&s4, _state, ae_true);
    _sparsematrix_init(&s5, _state, ae_true);
    _sparsematrix_init(&s6, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&wasenumerated, 0, 0, DT_BOOL, _state, ae_true);
    ae_vector_init(&d, 0, DT_INT, _state, ae_true);
    ae_vector_init(&u, 0, DT_INT, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    result = ae_false;
    hqrndrandomize(&rs, _state);
    for(n=1; n<=20; n++)
    {
        nz = n*n-n;
        for(;;)
        {
            
            /*
             * Generate N*N matrix where probability of non-diagonal element
             * being non-zero is PNZ. We also generate D and U - subdiagonal
             * and superdiagonal profile sizes.
             *
             * Create matrix with either general SKS or banded SKS constructor function
             */
            if( n>1 )
            {
                pnz = (double)nz/(double)(n*n-n);
            }
            else
            {
                pnz = 1.0;
            }
            ae_vector_set_length(&d, n, _state);
            ae_vector_set_length(&u, n, _state);
            ae_matrix_set_length(&a, n, n, _state);
            if( ae_fp_greater(hqrndnormal(&rs, _state),(double)(0)) )
            {
                
                /*
                 * Test SparseCreateSKS() functionality
                 */
                for(i=0; i<=n-1; i++)
                {
                    d.ptr.p_int[i] = 0;
                    u.ptr.p_int[i] = 0;
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( i==j||ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                        {
                            a.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                            if( j<i )
                            {
                                d.ptr.p_int[i] = ae_maxint(d.ptr.p_int[i], i-j, _state);
                            }
                            else
                            {
                                u.ptr.p_int[j] = ae_maxint(u.ptr.p_int[j], j-i, _state);
                            }
                        }
                        else
                        {
                            a.ptr.pp_double[i][j] = 0.0;
                        }
                    }
                }
                sparsecreatesks(n, n, &d, &u, &s0, _state);
            }
            else
            {
                
                /*
                 * Test SparseCreateSKSBand() functionality
                 */
                bw = hqrnduniformi(&rs, n+1, _state);
                for(i=0; i<=n-1; i++)
                {
                    d.ptr.p_int[i] = ae_minint(bw, i, _state);
                    u.ptr.p_int[i] = ae_minint(bw, i, _state);
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_iabs(i-j, _state)<=bw&&ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                        {
                            a.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                        }
                        else
                        {
                            a.ptr.pp_double[i][j] = 0.0;
                        }
                    }
                }
                sparsecreatesksband(n, n, bw, &s0, _state);
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i][j],(double)(0)) )
                    {
                        if( ae_fp_greater(hqrndnormal(&rs, _state),(double)(0)) )
                        {
                            ae_set_error_flag(&result, !sparserewriteexisting(&s0, i, j, a.ptr.pp_double[i][j], _state), __FILE__, __LINE__, "testsparseunit.ap:456");
                        }
                        else
                        {
                            sparseset(&s0, i, j, a.ptr.pp_double[i][j], _state);
                        }
                    }
                }
            }
            uppercnt = 0;
            lowercnt = 0;
            for(i=0; i<=n-1; i++)
            {
                uppercnt = uppercnt+u.ptr.p_int[i];
                lowercnt = lowercnt+d.ptr.p_int[i];
            }
            
            /*
             * Check correctness of SparseExists()
             */
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( i>=j&&i-j>d.ptr.p_int[i] )
                    {
                        ae_set_error_flag(&result, sparseexists(&s0, i, j, _state), __FILE__, __LINE__, "testsparseunit.ap:475");
                    }
                    if( i>=j&&i-j<=d.ptr.p_int[i] )
                    {
                        ae_set_error_flag(&result, !sparseexists(&s0, i, j, _state), __FILE__, __LINE__, "testsparseunit.ap:477");
                    }
                    if( i<=j&&j-i>u.ptr.p_int[j] )
                    {
                        ae_set_error_flag(&result, sparseexists(&s0, i, j, _state), __FILE__, __LINE__, "testsparseunit.ap:479");
                    }
                    if( i<=j&&j-i<=u.ptr.p_int[j] )
                    {
                        ae_set_error_flag(&result, !sparseexists(&s0, i, j, _state), __FILE__, __LINE__, "testsparseunit.ap:481");
                    }
                }
            }
            
            /*
             * Try to call SparseRewriteExisting() for out-of-band elements, make sure that it returns False.
             */
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (i>=j&&i-j>d.ptr.p_int[i])||(i<=j&&j-i>u.ptr.p_int[j]) )
                    {
                        ae_set_error_flag(&result, sparserewriteexisting(&s0, i, j, 1.0, _state), __FILE__, __LINE__, "testsparseunit.ap:490");
                    }
                }
            }
            
            /*
             * Convert to several different formats, check their contents with SparseGet().
             */
            sparsecopy(&s0, &s1, _state);
            sparseconverttocrs(&s1, _state);
            sparsecopytocrs(&s0, &s2, _state);
            sparsecopytocrsbuf(&s0, &s3, _state);
            sparsecopytohash(&s0, &s4, _state);
            sparsecopytohashbuf(&s0, &s5, _state);
            sparsecopy(&s0, &s6, _state);
            sparseconverttohash(&s6, _state);
            ae_set_error_flag(&result, sparsegetnrows(&s0, _state)!=n, __FILE__, __LINE__, "testsparseunit.ap:503");
            ae_set_error_flag(&result, sparsegetncols(&s0, _state)!=n, __FILE__, __LINE__, "testsparseunit.ap:504");
            ae_set_error_flag(&result, sparsegetmatrixtype(&s0, _state)!=2, __FILE__, __LINE__, "testsparseunit.ap:505");
            ae_set_error_flag(&result, !sparseissks(&s0, _state), __FILE__, __LINE__, "testsparseunit.ap:506");
            ae_set_error_flag(&result, sparseiscrs(&s0, _state), __FILE__, __LINE__, "testsparseunit.ap:507");
            ae_set_error_flag(&result, sparseishash(&s0, _state), __FILE__, __LINE__, "testsparseunit.ap:508");
            ae_set_error_flag(&result, sparseissks(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:509");
            ae_set_error_flag(&result, !sparseiscrs(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:510");
            ae_set_error_flag(&result, sparseishash(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:511");
            for(i=0; i<=n-1; i++)
            {
                v1 = a.ptr.pp_double[i][i];
                v0 = sparsegetdiagonal(&s0, i, _state);
                ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:516");
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v1 = a.ptr.pp_double[i][j];
                    v0 = sparseget(&s0, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:523");
                    v0 = sparseget(&s1, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:525");
                    v0 = sparseget(&s2, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:527");
                    v0 = sparseget(&s3, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:529");
                    v0 = sparseget(&s4, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:531");
                    v0 = sparseget(&s5, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:533");
                    v0 = sparseget(&s6, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:535");
                }
            }
            
            /*
             * Check enumeration capabilities:
             * * each element returned by SparseEnumerate() is returned only once
             * * each non-zero element of A was enumerated
             */
            ae_matrix_set_length(&wasenumerated, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    wasenumerated.ptr.pp_bool[i][j] = ae_false;
                }
            }
            t0 = 0;
            t1 = 0;
            while(sparseenumerate(&s0, &t0, &t1, &i, &j, &v0, _state))
            {
                ae_set_error_flag(&result, wasenumerated.ptr.pp_bool[i][j], __FILE__, __LINE__, "testsparseunit.ap:551");
                wasenumerated.ptr.pp_bool[i][j] = ae_true;
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i][j],(double)(0)) )
                    {
                        ae_set_error_flag(&result, !wasenumerated.ptr.pp_bool[i][j], __FILE__, __LINE__, "testsparseunit.ap:557");
                    }
                }
            }
            
            /*
             * Check UpperCnt()/LowerCnt()
             */
            ae_set_error_flag(&result, sparsegetuppercount(&s0, _state)!=uppercnt, __FILE__, __LINE__, "testsparseunit.ap:562");
            ae_set_error_flag(&result, sparsegetlowercount(&s0, _state)!=lowercnt, __FILE__, __LINE__, "testsparseunit.ap:563");
            
            /*
             * Check in-place transposition
             */
            sparsecopy(&s0, &s1, _state);
            sparsetransposesks(&s1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v0 = sparseget(&s0, i, j, _state);
                    v1 = sparseget(&s1, j, i, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:575");
                }
            }
            
            /*
             * One more check - matrix is initially created in some other format
             * (CRS or Hash) and converted to SKS later.
             */
            sparsecreate(n, n, 0, &s0, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i][j],(double)(0)) )
                    {
                        sparseset(&s0, i, j, a.ptr.pp_double[i][j], _state);
                    }
                }
            }
            sparsecopy(&s0, &s1, _state);
            sparseconverttosks(&s1, _state);
            sparsecopytosks(&s0, &s2, _state);
            sparsecopytosksbuf(&s0, &s3, _state);
            ae_set_error_flag(&result, !sparseissks(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:591");
            ae_set_error_flag(&result, sparseiscrs(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:592");
            ae_set_error_flag(&result, sparseishash(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:593");
            ae_set_error_flag(&result, !sparseissks(&s2, _state), __FILE__, __LINE__, "testsparseunit.ap:594");
            ae_set_error_flag(&result, sparseiscrs(&s2, _state), __FILE__, __LINE__, "testsparseunit.ap:595");
            ae_set_error_flag(&result, sparseishash(&s2, _state), __FILE__, __LINE__, "testsparseunit.ap:596");
            ae_set_error_flag(&result, !sparseissks(&s3, _state), __FILE__, __LINE__, "testsparseunit.ap:597");
            ae_set_error_flag(&result, sparseiscrs(&s3, _state), __FILE__, __LINE__, "testsparseunit.ap:598");
            ae_set_error_flag(&result, sparseishash(&s3, _state), __FILE__, __LINE__, "testsparseunit.ap:599");
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v1 = a.ptr.pp_double[i][j];
                    v0 = sparseget(&s1, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:605");
                    v0 = sparseget(&s2, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:607");
                    v0 = sparseget(&s3, i, j, _state);
                    ae_set_error_flag(&result, ae_fp_neq(v0,v1), __FILE__, __LINE__, "testsparseunit.ap:609");
                }
            }
            
            /*
             * Increase problem sparcity and try one more time. 
             * Stop after testing NZ=0.
             */
            if( nz==0 )
            {
                break;
            }
            nz = ae_minint(ae_round(nz*0.95, _state), nz-1, _state);
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing CRS-specific functionality.
On failure sets ErrorFlag, on success does not touch it.

  -- ALGLIB PROJECT --
     Copyright 30.01.2018 by Bochkanov Sergey
*************************************************************************/
void crstest(ae_bool* errorflag, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t m;
    ae_int_t nz;
    double pnz;
    hqrndstate rs;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix s2;
    sparsematrix s3;
    sparsematrix s4;
    ae_int_t i;
    ae_int_t j;

    ae_frame_make(_state, &_frame_block);
    memset(&rs, 0, sizeof(rs));
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    memset(&s2, 0, sizeof(s2));
    memset(&s3, 0, sizeof(s3));
    memset(&s4, 0, sizeof(s4));
    _hqrndstate_init(&rs, _state, ae_true);
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&s1, _state, ae_true);
    _sparsematrix_init(&s2, _state, ae_true);
    _sparsematrix_init(&s3, _state, ae_true);
    _sparsematrix_init(&s4, _state, ae_true);

    hqrndrandomize(&rs, _state);
    for(n=1; n<=10; n++)
    {
        for(m=1; m<=10; m++)
        {
            nz = n*m;
            for(;;)
            {
                
                /*
                 * Generate N*N matrix where probability of non-diagonal element
                 * being non-zero is PNZ. We also generate D and U - subdiagonal
                 * and superdiagonal profile sizes.
                 *
                 * Create matrix with either general SKS or banded SKS constructor function
                 */
                if( n>1 )
                {
                    pnz = (double)nz/(double)(m*n);
                }
                else
                {
                    pnz = 1.0;
                }
                
                /*
                 * Generate random matrix in HASH format (testing SparseExists()
                 * during process), copy it to CRS format, compare with original
                 */
                sparsecreate(m, n, ae_round(nz*hqrnduniformr(&rs, _state), _state), &s0, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(errorflag, sparseexists(&s0, i, j, _state), __FILE__, __LINE__, "testsparseunit.ap:676");
                        if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                        {
                            sparseset(&s0, i, j, hqrndnormal(&rs, _state), _state);
                            ae_set_error_flag(errorflag, !sparseexists(&s0, i, j, _state), __FILE__, __LINE__, "testsparseunit.ap:680");
                        }
                    }
                }
                sparsecopytocrs(&s0, &s1, _state);
                ae_set_error_flag(errorflag, !sparseiscrs(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:684");
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(errorflag, ae_fp_neq(sparseget(&s0, i, j, _state),sparseget(&s1, i, j, _state)), __FILE__, __LINE__, "testsparseunit.ap:688");
                        ae_set_error_flag(errorflag, sparseexists(&s0, i, j, _state)&&!sparseexists(&s1, i, j, _state), __FILE__, __LINE__, "testsparseunit.ap:689");
                        ae_set_error_flag(errorflag, sparseexists(&s1, i, j, _state)&&!sparseexists(&s0, i, j, _state), __FILE__, __LINE__, "testsparseunit.ap:690");
                    }
                }
                if( *errorflag )
                {
                    ae_frame_leave(_state);
                    return;
                }
                
                /*
                 * Check transposition
                 */
                sparsecopytocrs(&s1, &s2, _state);
                sparsetransposecrs(&s2, _state);
                ae_set_error_flag(errorflag, !sparseiscrs(&s2, _state), __FILE__, __LINE__, "testsparseunit.ap:700");
                ae_set_error_flag(errorflag, sparsegetnrows(&s1, _state)!=sparsegetncols(&s2, _state), __FILE__, __LINE__, "testsparseunit.ap:701");
                ae_set_error_flag(errorflag, sparsegetncols(&s1, _state)!=sparsegetnrows(&s2, _state), __FILE__, __LINE__, "testsparseunit.ap:702");
                if( *errorflag )
                {
                    ae_frame_leave(_state);
                    return;
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(errorflag, ae_fp_neq(sparseget(&s1, i, j, _state),sparseget(&s2, j, i, _state)), __FILE__, __LINE__, "testsparseunit.ap:707");
                    }
                }
                if( *errorflag )
                {
                    ae_frame_leave(_state);
                    return;
                }
                
                /*
                 * Check transposition
                 */
                sparsecopytransposecrs(&s1, &s3, _state);
                ae_set_error_flag(errorflag, !sparseiscrs(&s3, _state), __FILE__, __LINE__, "testsparseunit.ap:715");
                ae_set_error_flag(errorflag, sparsegetnrows(&s1, _state)!=sparsegetncols(&s3, _state), __FILE__, __LINE__, "testsparseunit.ap:716");
                ae_set_error_flag(errorflag, sparsegetncols(&s1, _state)!=sparsegetnrows(&s3, _state), __FILE__, __LINE__, "testsparseunit.ap:717");
                if( *errorflag )
                {
                    ae_frame_leave(_state);
                    return;
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(errorflag, ae_fp_neq(sparseget(&s1, i, j, _state),sparseget(&s3, j, i, _state)), __FILE__, __LINE__, "testsparseunit.ap:722");
                    }
                }
                if( *errorflag )
                {
                    ae_frame_leave(_state);
                    return;
                }
                
                /*
                 * Check transposition
                 */
                sparsecopytransposecrs(&s1, &s4, _state);
                ae_set_error_flag(errorflag, !sparseiscrs(&s4, _state), __FILE__, __LINE__, "testsparseunit.ap:730");
                ae_set_error_flag(errorflag, sparsegetnrows(&s1, _state)!=sparsegetncols(&s4, _state), __FILE__, __LINE__, "testsparseunit.ap:731");
                ae_set_error_flag(errorflag, sparsegetncols(&s1, _state)!=sparsegetnrows(&s4, _state), __FILE__, __LINE__, "testsparseunit.ap:732");
                if( *errorflag )
                {
                    ae_frame_leave(_state);
                    return;
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(errorflag, ae_fp_neq(sparseget(&s1, i, j, _state),sparseget(&s4, j, i, _state)), __FILE__, __LINE__, "testsparseunit.ap:737");
                    }
                }
                if( *errorflag )
                {
                    ae_frame_leave(_state);
                    return;
                }
                
                /*
                 * Increase problem sparcity and try one more time. 
                 * Stop after testing NZ=0.
                 */
                if( nz==0 )
                {
                    break;
                }
                nz = ae_minint(ae_round(nz*0.95, _state), nz-1, _state);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Function for testing serialization.
On failure sets ErrorFlag, on success does not touch it.

  -- ALGLIB PROJECT --
     Copyright 30.01.2018 by Bochkanov Sergey
*************************************************************************/
void testserialize(ae_bool* errorflag, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t m;
    ae_int_t mtype;
    ae_int_t nz;
    double pnz;
    hqrndstate rs;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix s2;
    sparsematrix s3;
    sparsematrix s4;
    ae_int_t i;
    ae_int_t j;

    ae_frame_make(_state, &_frame_block);
    memset(&rs, 0, sizeof(rs));
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    memset(&s2, 0, sizeof(s2));
    memset(&s3, 0, sizeof(s3));
    memset(&s4, 0, sizeof(s4));
    _hqrndstate_init(&rs, _state, ae_true);
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&s1, _state, ae_true);
    _sparsematrix_init(&s2, _state, ae_true);
    _sparsematrix_init(&s3, _state, ae_true);
    _sparsematrix_init(&s4, _state, ae_true);

    hqrndrandomize(&rs, _state);
    for(n=1; n<=10; n++)
    {
        for(m=1; m<=10; m++)
        {
            for(mtype=0; mtype<=testsparseunit_maxtype; mtype++)
            {
                if( mtype==2&&m!=n )
                {
                    continue;
                }
                nz = n*m;
                for(;;)
                {
                    
                    /*
                     * Generate N*N matrix where probability of non-diagonal element
                     * being non-zero is PNZ.
                     */
                    if( n>1 )
                    {
                        pnz = (double)nz/(double)(m*n);
                    }
                    else
                    {
                        pnz = 0.5;
                    }
                    
                    /*
                     * Generate random matrix in HASH format (testing SparseExists()
                     * during process), convert it to HASH/CRS/SKS format
                     */
                    sparsecreate(m, n, ae_round(nz*hqrnduniformr(&rs, _state), _state), &s0, _state);
                    for(i=0; i<=m-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            ae_set_error_flag(errorflag, sparseexists(&s0, i, j, _state), __FILE__, __LINE__, "testsparseunit.ap:797");
                            if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                            {
                                sparseset(&s0, i, j, hqrndnormal(&rs, _state), _state);
                                ae_set_error_flag(errorflag, !sparseexists(&s0, i, j, _state), __FILE__, __LINE__, "testsparseunit.ap:801");
                            }
                        }
                    }
                    sparseconvertto(&s0, mtype, _state);
                    ae_set_error_flag(errorflag, sparsegetmatrixtype(&s0, _state)!=mtype, __FILE__, __LINE__, "testsparseunit.ap:805");
                    
                    /*
                     * Check copy-through-serialization
                     */
                    {
                        /*
                         * This code passes data structure through serializers
                         * (serializes it to string and loads back)
                         */
                        ae_serializer _local_serializer;
                        ae_int_t _local_ssize;
                        ae_frame _local_frame_block;
                        ae_dyn_block _local_dynamic_block;
                        
                        ae_frame_make(_state, &_local_frame_block);
                        
                        ae_serializer_init(&_local_serializer);
                        ae_serializer_alloc_start(&_local_serializer);
                        sparsealloc(&_local_serializer, &s0, _state);
                        _local_ssize = ae_serializer_get_alloc_size(&_local_serializer);
                        memset(&_local_dynamic_block, 0, sizeof(_local_dynamic_block));
                        ae_db_init(&_local_dynamic_block, _local_ssize+1, _state, ae_true);
                        ae_serializer_sstart_str(&_local_serializer, (char*)_local_dynamic_block.ptr);
                        sparseserialize(&_local_serializer, &s0, _state);
                        ae_serializer_stop(&_local_serializer, _state);
                        ae_serializer_clear(&_local_serializer);
                        
                        ae_serializer_init(&_local_serializer);
                        ae_serializer_ustart_str(&_local_serializer, (char*)_local_dynamic_block.ptr);
                        sparseunserialize(&_local_serializer, &s1, _state);
                        ae_serializer_stop(&_local_serializer, _state);
                        ae_serializer_clear(&_local_serializer);
                        
                        ae_frame_leave(_state);
                    }
                    ae_set_error_flag(errorflag, sparsegetmatrixtype(&s1, _state)!=mtype, __FILE__, __LINE__, "testsparseunit.ap:811");
                    ae_set_error_flag(errorflag, sparsegetnrows(&s0, _state)!=sparsegetnrows(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:812");
                    ae_set_error_flag(errorflag, sparsegetncols(&s0, _state)!=sparsegetncols(&s1, _state), __FILE__, __LINE__, "testsparseunit.ap:813");
                    if( *errorflag )
                    {
                        ae_frame_leave(_state);
                        return;
                    }
                    for(i=0; i<=m-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            ae_set_error_flag(errorflag, ae_fp_neq(sparseget(&s0, i, j, _state),sparseget(&s1, i, j, _state)), __FILE__, __LINE__, "testsparseunit.ap:818");
                        }
                    }
                    if( *errorflag )
                    {
                        ae_frame_leave(_state);
                        return;
                    }
                    
                    /*
                     * Increase problem sparcity and try one more time. 
                     * Stop after testing NZ=0.
                     */
                    if( nz==0 )
                    {
                        break;
                    }
                    nz = ae_minint(ae_round(nz*0.95, _state), nz-1, _state);
                }
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Function for testing basic functional

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basicfunctest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t n;
    ae_int_t m;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_int_t uppercnt;
    ae_int_t lowercnt;
    ae_matrix a;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    _sparsematrix_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);

    n = 10;
    m = 10;
    result = ae_false;
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            sparsecreate(i, j, 1, &s, _state);
            ae_matrix_set_length(&a, i, j, _state);
            
            /*
             * Checking for Matrix with hash table type
             */
            uppercnt = 0;
            lowercnt = 0;
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( j1>i1 )
                    {
                        inc(&uppercnt, _state);
                    }
                    if( j1<i1 )
                    {
                        inc(&lowercnt, _state);
                    }
                    a.ptr.pp_double[i1][j1] = i1+j1+(double)((i+j)*(m+n))/(double)2;
                    a.ptr.pp_double[i1][j1] = a.ptr.pp_double[i1][j1]+1;
                    sparseset(&s, i1, j1, i1+j1+(double)((i+j)*(m+n))/(double)2, _state);
                    sparseadd(&s, i1, j1, (double)(1), _state);
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            for(i1=0; i1<=ae_minint(i, j, _state)-1; i1++)
            {
                if( ae_fp_neq(a.ptr.pp_double[i1][i1],sparsegetdiagonal(&s, i1, _state)) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
            ae_set_error_flag(&result, sparsegetuppercount(&s, _state)!=uppercnt, __FILE__, __LINE__, "testsparseunit.ap:887");
            ae_set_error_flag(&result, sparsegetlowercount(&s, _state)!=lowercnt, __FILE__, __LINE__, "testsparseunit.ap:888");
            
            /*
             * Checking for Matrix with CRS type
             */
            sparseconverttocrs(&s, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            for(i1=0; i1<=ae_minint(i, j, _state)-1; i1++)
            {
                if( ae_fp_neq(a.ptr.pp_double[i1][i1],sparsegetdiagonal(&s, i1, _state)) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
            ae_set_error_flag(&result, sparsegetuppercount(&s, _state)!=uppercnt, __FILE__, __LINE__, "testsparseunit.ap:907");
            ae_set_error_flag(&result, sparsegetlowercount(&s, _state)!=lowercnt, __FILE__, __LINE__, "testsparseunit.ap:908");
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 2 unsymmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2unsymmetric(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_vector x0;
    ae_vector x1;
    ae_vector y0;
    ae_vector y1;
    ae_int_t i;
    ae_int_t j;
    ae_matrix a;
    sparsematrix s0;
    sparsematrix sa;
    double eps;
    double v;
    ae_int_t ix;
    ae_int_t iy;
    double alpha;
    double beta;
    ae_int_t ops;
    ae_int_t opm;
    ae_int_t opn;
    ae_int_t alphakind;
    ae_int_t betakind;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&y0, 0, sizeof(y0));
    memset(&y1, 0, sizeof(y1));
    memset(&a, 0, sizeof(a));
    memset(&s0, 0, sizeof(s0));
    memset(&sa, 0, sizeof(sa));
    memset(&g, 0, sizeof(g));
    memset(&rs, 0, sizeof(rs));
    ae_vector_init(&x0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y1, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&sa, _state, ae_true);
    _sparsegenerator_init(&g, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test linear algebra functions
     */
    for(m=1; m<=20; m++)
    {
        for(n=1; n<=20; n++)
        {
            testsparseunit_initgenerator(m, n, 0, 0, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Convert SA to desired storage format:
                 * * to CRS if M<>N
                 * * with 50% probability to CRS or SKS, if M=N
                 */
                if( m!=n||ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                }
                
                /*
                 * Test SparseGet() for SA and S0 against matrix returned in A
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&sa, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:966");
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&s0, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:967");
                    }
                }
                
                /*
                 * Test SparseMV
                 */
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(j=0; j<=n-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                sparsemv(&s0, &x0, &y0, _state);
                ae_set_error_flag(&result, y0.cnt<m, __FILE__, __LINE__, "testsparseunit.ap:981");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=m-1; i++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:987");
                }
                
                /*
                 * Test SparseMTV
                 */
                ae_vector_set_length(&x0, m, _state);
                ae_vector_set_length(&x1, m, _state);
                for(j=0; j<=m-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                sparsemtv(&s0, &x0, &y0, _state);
                ae_set_error_flag(&result, y0.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1001");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(j=0; j<=n-1; j++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[0][j], a.stride, &x1.ptr.p_double[0], 1, ae_v_len(0,m-1));
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1007");
                }
                
                /*
                 * Sparse GEMV
                 */
                for(ops=0; ops<=1; ops++)
                {
                    for(alphakind=0; alphakind<=1; alphakind++)
                    {
                        for(betakind=0; betakind<=1; betakind++)
                        {
                            
                            /*
                             * Prepare inputs for testing
                             */
                            ix = hqrnduniformi(&rs, 50, _state);
                            iy = hqrnduniformi(&rs, 50, _state);
                            alpha = alphakind*hqrndnormal(&rs, _state);
                            beta = betakind*hqrndnormal(&rs, _state);
                            if( ops==0 )
                            {
                                opm = m;
                                opn = n;
                            }
                            else
                            {
                                opm = n;
                                opn = m;
                            }
                            ae_vector_set_length(&x0, ix+opn, _state);
                            ae_vector_set_length(&x1, ix+opn, _state);
                            for(j=0; j<=ix+opn-1; j++)
                            {
                                x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                                x1.ptr.p_double[j] = x0.ptr.p_double[j];
                            }
                            ae_vector_set_length(&y0, iy+opm, _state);
                            ae_vector_set_length(&y1, iy+opm, _state);
                            for(j=0; j<=iy+opm-1; j++)
                            {
                                y0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                                y1.ptr.p_double[j] = y0.ptr.p_double[j];
                            }
                            
                            /*
                             * Prepare reference result in Y1
                             */
                            for(i=0; i<=opm-1; i++)
                            {
                                v = (double)(0);
                                for(j=0; j<=opn-1; j++)
                                {
                                    if( ops==0 )
                                    {
                                        v = v+a.ptr.pp_double[i][j]*x1.ptr.p_double[ix+j];
                                    }
                                    else
                                    {
                                        v = v+a.ptr.pp_double[j][i]*x1.ptr.p_double[ix+j];
                                    }
                                }
                                y1.ptr.p_double[iy+i] = alpha*v+beta*y1.ptr.p_double[iy+i];
                            }
                            
                            /*
                             * Test
                             */
                            sparsegemv(&s0, alpha, ops, &x0, ix, beta, &y0, iy, _state);
                            for(j=0; j<=iy+opm-1; j++)
                            {
                                ae_set_error_flag(&result, ae_fp_greater(ae_fabs(y0.ptr.p_double[j]-y1.ptr.p_double[j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1068");
                            }
                        }
                    }
                }
                
                /*
                 * Test SparseMV2
                 */
                if( m==n )
                {
                    ae_vector_set_length(&x0, n, _state);
                    ae_vector_set_length(&x1, n, _state);
                    for(j=0; j<=n-1; j++)
                    {
                        x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                        x1.ptr.p_double[j] = x0.ptr.p_double[j];
                    }
                    sparsemv2(&s0, &x0, &y0, &y1, _state);
                    ae_set_error_flag(&result, y0.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1084");
                    ae_set_error_flag(&result, y1.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1085");
                    if( result )
                    {
                        ae_frame_leave(_state);
                        return result;
                    }
                    for(j=0; j<=n-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[j][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1091");
                        v = ae_v_dotproduct(&a.ptr.pp_double[0][j], a.stride, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y1.ptr.p_double[j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1093");
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 3 unsymmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel3unsymmetric(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t k;
    ae_matrix x0;
    ae_matrix x1;
    ae_matrix y0;
    ae_matrix y1;
    ae_int_t i;
    ae_int_t j;
    ae_matrix a;
    sparsematrix s0;
    sparsematrix sa;
    double eps;
    double v;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&y0, 0, sizeof(y0));
    memset(&y1, 0, sizeof(y1));
    memset(&a, 0, sizeof(a));
    memset(&s0, 0, sizeof(s0));
    memset(&sa, 0, sizeof(sa));
    memset(&g, 0, sizeof(g));
    memset(&rs, 0, sizeof(rs));
    ae_matrix_init(&x0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&x1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&y0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&y1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&sa, _state, ae_true);
    _sparsegenerator_init(&g, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test linear algebra functions
     */
    for(m=1; m<=20; m++)
    {
        for(n=1; n<=20; n++)
        {
            testsparseunit_initgenerator(m, n, 0, 0, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Choose matrix width K
                 */
                k = 1+hqrnduniformi(&rs, 20, _state);
                
                /*
                 * Convert SA to desired storage format:
                 * * to CRS if M<>N
                 * * with 50% probability to CRS or SKS, if M=N
                 */
                if( m!=n||ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                }
                
                /*
                 * Test SparseGet() for SA and S0 against matrix returned in A
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(&result, ae_fp_neq(sparseget(&sa, i, j, _state),a.ptr.pp_double[i][j]), __FILE__, __LINE__, "testsparseunit.ap:1156");
                        ae_set_error_flag(&result, ae_fp_neq(sparseget(&s0, i, j, _state),a.ptr.pp_double[i][j]), __FILE__, __LINE__, "testsparseunit.ap:1157");
                    }
                }
                
                /*
                 * Test SparseMV
                 */
                ae_matrix_set_length(&x0, n, k, _state);
                ae_matrix_set_length(&x1, n, k, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        x0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                        x1.ptr.pp_double[i][j] = x0.ptr.pp_double[i][j];
                    }
                }
                sparsemm(&s0, &x0, k, &y0, _state);
                ae_set_error_flag(&result, y0.rows<m, __FILE__, __LINE__, "testsparseunit.ap:1172");
                ae_set_error_flag(&result, y0.cols<k, __FILE__, __LINE__, "testsparseunit.ap:1173");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,n-1));
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1180");
                    }
                }
                
                /*
                 * Test SparseMTM
                 */
                ae_matrix_set_length(&x0, m, k, _state);
                ae_matrix_set_length(&x1, m, k, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        x0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                        x1.ptr.pp_double[i][j] = x0.ptr.pp_double[i][j];
                    }
                }
                sparsemtm(&s0, &x0, k, &y0, _state);
                ae_set_error_flag(&result, y0.rows<n, __FILE__, __LINE__, "testsparseunit.ap:1195");
                ae_set_error_flag(&result, y0.cols<k, __FILE__, __LINE__, "testsparseunit.ap:1196");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[0][i], a.stride, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,m-1));
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1203");
                    }
                }
                
                /*
                 * Test SparseMM2
                 */
                if( m==n )
                {
                    ae_matrix_set_length(&x0, n, k, _state);
                    ae_matrix_set_length(&x1, n, k, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=k-1; j++)
                        {
                            x0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                            x1.ptr.pp_double[i][j] = x0.ptr.pp_double[i][j];
                        }
                    }
                    sparsemm2(&s0, &x0, k, &y0, &y1, _state);
                    ae_set_error_flag(&result, y0.rows<n, __FILE__, __LINE__, "testsparseunit.ap:1220");
                    ae_set_error_flag(&result, y0.cols<k, __FILE__, __LINE__, "testsparseunit.ap:1221");
                    ae_set_error_flag(&result, y1.rows<n, __FILE__, __LINE__, "testsparseunit.ap:1222");
                    ae_set_error_flag(&result, y1.cols<k, __FILE__, __LINE__, "testsparseunit.ap:1223");
                    if( result )
                    {
                        ae_frame_leave(_state);
                        return result;
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=k-1; j++)
                        {
                            v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,n-1));
                            ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1230");
                            v = ae_v_dotproduct(&a.ptr.pp_double[0][i], a.stride, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,n-1));
                            ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y1.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1232");
                        }
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 2 symmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2symmetric(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_vector x0;
    ae_vector x1;
    ae_vector y0;
    ae_vector y1;
    ae_int_t i;
    ae_int_t j;
    ae_matrix a;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix sa;
    double eps;
    double v;
    double va;
    double vb;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool isupper;
    ae_int_t triangletype;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&y0, 0, sizeof(y0));
    memset(&y1, 0, sizeof(y1));
    memset(&a, 0, sizeof(a));
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    memset(&sa, 0, sizeof(sa));
    memset(&g, 0, sizeof(g));
    memset(&rs, 0, sizeof(rs));
    ae_vector_init(&x0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y1, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&s1, _state, ae_true);
    _sparsematrix_init(&sa, _state, ae_true);
    _sparsegenerator_init(&g, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test linear algebra functions
     */
    for(n=1; n<=20; n++)
    {
        for(triangletype=-1; triangletype<=1; triangletype++)
        {
            isupper = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
            if( triangletype<0 )
            {
                isupper = ae_false;
            }
            if( triangletype>0 )
            {
                isupper = ae_true;
            }
            testsparseunit_initgenerator(n, n, 0, triangletype, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Convert SA to desired storage format:
                 * * S0 stores unmodified copy
                 * * S1 stores copy with unmodified triangle corresponding
                 *   to IsUpper and another triangle being spoiled by random
                 *   trash
                 */
                sparsecopytohash(&sa, &s1, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            sparseset(&s1, i, j, hqrnduniformr(&rs, _state), _state);
                        }
                    }
                }
                if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                    sparseconverttocrs(&s1, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                    sparseconverttosks(&s1, _state);
                }
                
                /*
                 * Test SparseGet() for SA and S0 against matrix returned in A
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&sa, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1311");
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&s0, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1312");
                        ae_set_error_flag(&result, (j<i&&triangletype==1)&&ae_fp_neq(sparseget(&s0, i, j, _state),(double)(0)), __FILE__, __LINE__, "testsparseunit.ap:1313");
                        ae_set_error_flag(&result, (j>i&&triangletype==-1)&&ae_fp_neq(sparseget(&s0, i, j, _state),(double)(0)), __FILE__, __LINE__, "testsparseunit.ap:1314");
                    }
                }
                
                /*
                 * Before we proceed with testing, update empty triangle of A
                 * with its copy from another part of the matrix.
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            a.ptr.pp_double[i][j] = a.ptr.pp_double[j][i];
                        }
                    }
                }
                
                /*
                 * Test SparseSMV
                 */
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(j=0; j<=n-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                sparsesmv(&s0, isupper, &x0, &y0, _state);
                ae_set_error_flag(&result, y0.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1337");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1343");
                }
                sparsesmv(&s1, isupper, &x0, &y1, _state);
                ae_set_error_flag(&result, y1.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1346");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y1.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1352");
                }
                
                /*
                 * Test SparseVSMV
                 */
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(j=0; j<=n-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                vb = 0.0;
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        vb = vb+x1.ptr.p_double[i]*a.ptr.pp_double[i][j]*x1.ptr.p_double[j];
                    }
                }
                va = sparsevsmv(&s0, isupper, &x0, _state);
                ae_set_error_flag(&result, ae_fp_greater(ae_fabs(va-vb, _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1370");
                va = sparsevsmv(&s1, isupper, &x0, _state);
                ae_set_error_flag(&result, ae_fp_greater(ae_fabs(va-vb, _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1372");
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 2 symmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel3symmetric(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t k;
    ae_matrix x0;
    ae_matrix x1;
    ae_matrix y0;
    ae_matrix y1;
    ae_int_t i;
    ae_int_t j;
    ae_matrix a;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix sa;
    double eps;
    double v;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool isupper;
    ae_int_t triangletype;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&y0, 0, sizeof(y0));
    memset(&y1, 0, sizeof(y1));
    memset(&a, 0, sizeof(a));
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    memset(&sa, 0, sizeof(sa));
    memset(&g, 0, sizeof(g));
    memset(&rs, 0, sizeof(rs));
    ae_matrix_init(&x0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&x1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&y0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&y1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&s1, _state, ae_true);
    _sparsematrix_init(&sa, _state, ae_true);
    _sparsegenerator_init(&g, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test linear algebra functions
     */
    for(n=1; n<=20; n++)
    {
        for(triangletype=-1; triangletype<=1; triangletype++)
        {
            isupper = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
            if( triangletype<0 )
            {
                isupper = ae_false;
            }
            if( triangletype>0 )
            {
                isupper = ae_true;
            }
            testsparseunit_initgenerator(n, n, 0, triangletype, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Choose matrix width K
                 */
                k = 1+hqrnduniformi(&rs, 20, _state);
                
                /*
                 * Convert SA to desired storage format:
                 * * S0 stores unmodified copy
                 * * S1 stores copy with unmodified triangle corresponding
                 *   to IsUpper and another triangle being spoiled by random
                 *   trash
                 */
                sparsecopytohash(&sa, &s1, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            sparseset(&s1, i, j, hqrnduniformr(&rs, _state), _state);
                        }
                    }
                }
                if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                    sparseconverttocrs(&s1, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                    sparseconverttosks(&s1, _state);
                }
                
                /*
                 * Test SparseGet() for SA and S0 against matrix returned in A
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&sa, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1453");
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&s0, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1454");
                        ae_set_error_flag(&result, (j<i&&triangletype==1)&&ae_fp_neq(sparseget(&s0, i, j, _state),(double)(0)), __FILE__, __LINE__, "testsparseunit.ap:1455");
                        ae_set_error_flag(&result, (j>i&&triangletype==-1)&&ae_fp_neq(sparseget(&s0, i, j, _state),(double)(0)), __FILE__, __LINE__, "testsparseunit.ap:1456");
                    }
                }
                
                /*
                 * Before we proceed with testing, update empty triangle of A
                 * with its copy from another part of the matrix.
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            a.ptr.pp_double[i][j] = a.ptr.pp_double[j][i];
                        }
                    }
                }
                
                /*
                 * Test SparseSMM
                 */
                ae_matrix_set_length(&x0, n, k, _state);
                ae_matrix_set_length(&x1, n, k, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        x0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                        x1.ptr.pp_double[i][j] = x0.ptr.pp_double[i][j];
                    }
                }
                sparsesmm(&s0, isupper, &x0, k, &y0, _state);
                ae_set_error_flag(&result, y0.rows<n, __FILE__, __LINE__, "testsparseunit.ap:1480");
                ae_set_error_flag(&result, y0.cols<k, __FILE__, __LINE__, "testsparseunit.ap:1481");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,n-1));
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.pp_double[i][j], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1488");
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing sparse symmetric permutations

  -- ALGLIB PROJECT --
     Copyright 07.10.2020 by Bochkanov Sergey
*************************************************************************/
ae_bool testsymmetricperm(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t functype;
    ae_int_t i;
    ae_int_t j;
    hqrndstate rs;
    ae_bool isupper;
    double eps;
    double nzprob;
    ae_matrix da;
    ae_matrix db;
    sparsematrix sa;
    sparsematrix sb;
    ae_vector ptbl;
    ae_vector pprod;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&rs, 0, sizeof(rs));
    memset(&da, 0, sizeof(da));
    memset(&db, 0, sizeof(db));
    memset(&sa, 0, sizeof(sa));
    memset(&sb, 0, sizeof(sb));
    memset(&ptbl, 0, sizeof(ptbl));
    memset(&pprod, 0, sizeof(pprod));
    _hqrndstate_init(&rs, _state, ae_true);
    ae_matrix_init(&da, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&db, 0, 0, DT_REAL, _state, ae_true);
    _sparsematrix_init(&sa, _state, ae_true);
    _sparsematrix_init(&sb, _state, ae_true);
    ae_vector_init(&ptbl, 0, DT_INT, _state, ae_true);
    ae_vector_init(&pprod, 0, DT_INT, _state, ae_true);

    eps = 10*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Try various N and fill factors
     */
    for(n=1; n<=20; n++)
    {
        nzprob = 1.0;
        while(ae_fp_greater_eq(nzprob,0.1/(n*n)))
        {
            
            /*
             * Generate matrix with desired fill factor, randomly select one triangle,
             * generate random permutation (in table and product form)
             */
            sparsecreate(n, n, 0, &sa, _state);
            ae_matrix_set_length(&da, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_less(hqrnduniformr(&rs, _state),nzprob) )
                    {
                        da.ptr.pp_double[i][j] = hqrndnormal(&rs, _state);
                        sparseset(&sa, i, j, da.ptr.pp_double[i][j], _state);
                    }
                    else
                    {
                        da.ptr.pp_double[i][j] = (double)(0);
                    }
                }
            }
            sparseconverttocrs(&sa, _state);
            isupper = ae_fp_greater(hqrndnormal(&rs, _state),(double)(0));
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=i; j++)
                {
                    if( isupper )
                    {
                        da.ptr.pp_double[i][j] = da.ptr.pp_double[j][i];
                    }
                    else
                    {
                        da.ptr.pp_double[j][i] = da.ptr.pp_double[i][j];
                    }
                }
            }
            ae_vector_set_length(&ptbl, n, _state);
            ae_vector_set_length(&pprod, n, _state);
            for(i=0; i<=n-1; i++)
            {
                ptbl.ptr.p_int[i] = i;
            }
            for(i=0; i<=n-1; i++)
            {
                pprod.ptr.p_int[i] = i+hqrnduniformi(&rs, n-i, _state);
                j = ptbl.ptr.p_int[i];
                ptbl.ptr.p_int[i] = ptbl.ptr.p_int[pprod.ptr.p_int[i]];
                ptbl.ptr.p_int[pprod.ptr.p_int[i]] = j;
            }
            ae_matrix_set_length(&db, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    db.ptr.pp_double[ptbl.ptr.p_int[i]][ptbl.ptr.p_int[j]] = da.ptr.pp_double[i][j];
                }
            }
            
            /*
             * Select function to test, run and test
             */
            functype = hqrnduniformi(&rs, 2, _state);
            if( functype==0 )
            {
                sparsesymmpermtblbuf(&sa, isupper, &ptbl, &sb, _state);
            }
            if( functype==1 )
            {
                sparsesymmpermtbl(&sa, isupper, &ptbl, &sb, _state);
            }
            ae_set_error_flag(&result, !sparseiscrs(&sb, _state), __FILE__, __LINE__, "testsparseunit.ap:1582");
            ae_set_error_flag(&result, sparsegetnrows(&sb, _state)!=n, __FILE__, __LINE__, "testsparseunit.ap:1583");
            ae_set_error_flag(&result, sparsegetncols(&sb, _state)!=n, __FILE__, __LINE__, "testsparseunit.ap:1584");
            if( result )
            {
                ae_frame_leave(_state);
                return result;
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ae_set_error_flag(&result, (isupper&&j>=i)&&ae_fp_greater(ae_fabs(db.ptr.pp_double[i][j]-sparseget(&sb, i, j, _state), _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1590");
                    ae_set_error_flag(&result, (isupper&&j<i)&&ae_fp_neq(sparseget(&sb, i, j, _state),(double)(0)), __FILE__, __LINE__, "testsparseunit.ap:1591");
                }
            }
            
            /*
             * Increase sparsity
             */
            nzprob = 0.75*nzprob;
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 2 triangular linear algebra functions.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2triangular(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_vector x0;
    ae_vector x1;
    ae_vector y0;
    ae_vector y1;
    ae_vector ey;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_matrix a;
    ae_matrix ea;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix sa;
    double eps;
    double v;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool isupper;
    ae_bool isunit;
    ae_int_t optype;
    ae_int_t triangletype;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&y0, 0, sizeof(y0));
    memset(&y1, 0, sizeof(y1));
    memset(&ey, 0, sizeof(ey));
    memset(&a, 0, sizeof(a));
    memset(&ea, 0, sizeof(ea));
    memset(&s0, 0, sizeof(s0));
    memset(&s1, 0, sizeof(s1));
    memset(&sa, 0, sizeof(sa));
    memset(&g, 0, sizeof(g));
    memset(&rs, 0, sizeof(rs));
    ae_vector_init(&x0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ey, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ea, 0, 0, DT_REAL, _state, ae_true);
    _sparsematrix_init(&s0, _state, ae_true);
    _sparsematrix_init(&s1, _state, ae_true);
    _sparsematrix_init(&sa, _state, ae_true);
    _sparsegenerator_init(&g, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test sparseTRMV
     */
    for(n=1; n<=20; n++)
    {
        for(triangletype=-1; triangletype<=1; triangletype++)
        {
            isupper = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
            if( triangletype<0 )
            {
                isupper = ae_false;
            }
            if( triangletype>0 )
            {
                isupper = ae_true;
            }
            testsparseunit_initgenerator(n, n, 0, triangletype, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Settings (IsUpper was already set, handle the rest)
                 */
                isunit = ae_fp_less(hqrnduniformr(&rs, _state),0.5);
                optype = hqrnduniformi(&rs, 2, _state);
                
                /*
                 * Convert SA to desired storage format:
                 * * S0 stores unmodified copy
                 * * S1 stores copy with unmodified triangle corresponding
                 *   to IsUpper and another triangle being spoiled by random
                 *   trash
                 */
                sparsecopytohash(&sa, &s1, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            sparseset(&s1, i, j, hqrnduniformr(&rs, _state), _state);
                        }
                    }
                }
                if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                    sparseconverttocrs(&s1, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                    sparseconverttosks(&s1, _state);
                }
                
                /*
                 * Generate "effective A"
                 */
                ae_matrix_set_length(&ea, n, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ea.ptr.pp_double[i][j] = (double)(0);
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j>=i&&isupper)||(j<=i&&!isupper) )
                        {
                            i1 = i;
                            j1 = j;
                            if( optype==1 )
                            {
                                swapi(&i1, &j1, _state);
                            }
                            ea.ptr.pp_double[i1][j1] = a.ptr.pp_double[i][j];
                            if( isunit&&i1==j1 )
                            {
                                ea.ptr.pp_double[i1][j1] = 1.0;
                            }
                        }
                    }
                }
                
                /*
                 * Test SparseTRMV
                 */
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(j=0; j<=n-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                sparsetrmv(&s0, isupper, isunit, optype, &x0, &y0, _state);
                ae_set_error_flag(&result, y0.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1706");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&ea.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1712");
                }
                sparsetrmv(&s0, isupper, isunit, optype, &x0, &y1, _state);
                ae_set_error_flag(&result, y1.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1715");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&ea.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(v-y1.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1721");
                }
            }
        }
    }
    
    /*
     * Test sparseTRSV
     */
    for(n=1; n<=20; n++)
    {
        for(triangletype=-1; triangletype<=1; triangletype++)
        {
            isupper = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
            if( triangletype==-1 )
            {
                isupper = ae_false;
            }
            if( triangletype==1 )
            {
                isupper = ae_true;
            }
            testsparseunit_initgenerator(n, n, 1, triangletype, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Settings (IsUpper was already set, handle the rest)
                 */
                isunit = ae_fp_less(hqrnduniformr(&rs, _state),0.5);
                optype = hqrnduniformi(&rs, 2, _state);
                
                /*
                 * Convert SA to desired storage format:
                 * * S0 stores unmodified copy
                 * * S1 stores copy with unmodified triangle corresponding
                 *   to IsUpper and another triangle being spoiled by random
                 *   trash
                 */
                sparsecopytohash(&sa, &s1, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            sparseset(&s1, i, j, hqrnduniformr(&rs, _state), _state);
                        }
                    }
                }
                if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                    sparseconverttocrs(&s1, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                    sparseconverttosks(&s1, _state);
                }
                
                /*
                 * Generate "effective A" and EY = inv(EA)*x0
                 */
                ae_matrix_set_length(&ea, n, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ea.ptr.pp_double[i][j] = (double)(0);
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j>=i&&isupper)||(j<=i&&!isupper) )
                        {
                            i1 = i;
                            j1 = j;
                            if( optype==1 )
                            {
                                swapi(&i1, &j1, _state);
                            }
                            ea.ptr.pp_double[i1][j1] = a.ptr.pp_double[i][j];
                            if( isunit&&i1==j1 )
                            {
                                ea.ptr.pp_double[i1][j1] = 1.0;
                            }
                        }
                    }
                }
                ae_vector_set_length(&ey, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    ey.ptr.p_double[i] = hqrnduniformr(&rs, _state)-0.5;
                }
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&ea.ptr.pp_double[i][0], 1, &ey.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    x0.ptr.p_double[i] = v;
                    x1.ptr.p_double[i] = v;
                }
                
                /*
                 * Test SparseTRSV
                 */
                sparsetrsv(&s0, isupper, isunit, optype, &x0, _state);
                ae_set_error_flag(&result, x0.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1805");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(ey.ptr.p_double[i]-x0.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1809");
                }
                sparsetrsv(&s1, isupper, isunit, optype, &x1, _state);
                ae_set_error_flag(&result, x1.cnt<n, __FILE__, __LINE__, "testsparseunit.ap:1811");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(ey.ptr.p_double[i]-x1.ptr.p_double[i], _state),eps), __FILE__, __LINE__, "testsparseunit.ap:1815");
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing basic functional

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basicfuncrandomtest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t n;
    ae_int_t m;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_matrix a;
    ae_int_t mfigure;
    ae_int_t temp;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    _sparsematrix_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);

    n = 20;
    m = 20;
    mfigure = 10;
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            sparsecreate(i, j, 0, &s, _state);
            ae_matrix_set_length(&a, i, j, _state);
            
            /*
             * Checking for Matrix with hash table type
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    temp = 2*ae_randominteger(mfigure, _state)-mfigure;
                    a.ptr.pp_double[i1][j1] = (double)(temp);
                    if( ae_randominteger(2, _state)==0 )
                    {
                        sparseset(&s, i1, j1, (double)(temp), _state);
                        sparseset(&s, i1, j1, (double)(temp), _state);
                    }
                    else
                    {
                        sparseadd(&s, i1, j1, (double)(temp), _state);
                        sparseadd(&s, i1, j1, (double)(0), _state);
                    }
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            
            /*
             * Nulling all elements
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( ae_randominteger(2, _state)==0 )
                    {
                        sparseset(&s, i1, j1, (double)(0), _state);
                    }
                    else
                    {
                        sparseadd(&s, i1, j1, -1*sparseget(&s, i1, j1, _state), _state);
                    }
                }
            }
            
            /*
             * Again initialization of the matrix and check new values
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    temp = 2*ae_randominteger(mfigure, _state)-mfigure;
                    a.ptr.pp_double[i1][j1] = (double)(temp);
                    if( ae_randominteger(2, _state)==0 )
                    {
                        sparseset(&s, i1, j1, (double)(temp), _state);
                    }
                    else
                    {
                        sparseadd(&s, i1, j1, (double)(temp), _state);
                    }
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            
            /*
             * Checking for Matrix with CRS type
             */
            sparseconverttocrs(&s, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing multyplication matrix with vector

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionstest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t n;
    ae_int_t m;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    double lb;
    double rb;
    ae_matrix a;
    ae_vector x0;
    ae_vector x1;
    ae_vector ty;
    ae_vector tyt;
    ae_vector y;
    ae_vector yt;
    ae_vector y0;
    ae_vector yt0;
    double eps;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&ty, 0, sizeof(ty));
    memset(&tyt, 0, sizeof(tyt));
    memset(&y, 0, sizeof(y));
    memset(&yt, 0, sizeof(yt));
    memset(&y0, 0, sizeof(y0));
    memset(&yt0, 0, sizeof(yt0));
    _sparsematrix_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ty, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tyt, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&yt, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&yt0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*n)
     */
    n = 10;
    m = 10;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            
            /*
             * Prepare test problem
             */
            testsparseunit_createrandom(i, j, -1, -1, -1, -1, &a, &s, _state);
            
            /*
             * Initialize temporaries
             */
            ae_vector_set_length(&ty, i, _state);
            ae_vector_set_length(&tyt, j, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                ty.ptr.p_double[i1] = (double)(0);
            }
            for(i1=0; i1<=j-1; i1++)
            {
                tyt.ptr.p_double[i1] = (double)(0);
            }
            ae_vector_set_length(&x0, j, _state);
            ae_vector_set_length(&x1, i, _state);
            for(i1=0; i1<=j-1; i1++)
            {
                x0.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
            }
            for(i1=0; i1<=i-1; i1++)
            {
                x1.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
            }
            
            /*
             * Consider two cases: square matrix, and non-square matrix
             */
            if( i!=j )
            {
                
                /*
                 * Searching true result
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    for(j1=0; j1<=j-1; j1++)
                    {
                        ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                        tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x1.ptr.p_double[i1];
                    }
                }
                
                /*
                 * Multiplication
                 */
                sparsemv(&s, &x0, &y, _state);
                sparsemtv(&s, &x1, &yt, _state);
                
                /*
                 * Check for MV-result
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    if( ae_fp_greater_eq(ae_fabs(y.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
                
                /*
                 * Check for MTV-result
                 */
                for(i1=0; i1<=j-1; i1++)
                {
                    if( ae_fp_greater_eq(ae_fabs(yt.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            else
            {
                
                /*
                 * Searching true result
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    for(j1=0; j1<=j-1; j1++)
                    {
                        ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                        tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[i1];
                    }
                }
                sparsemv(&s, &x0, &y, _state);
                sparsemtv(&s, &x0, &yt, _state);
                sparsemv2(&s, &x0, &y0, &yt0, _state);
                
                /*
                 * Check for MV2-result
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    if( ae_fp_greater_eq(ae_fabs(y0.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt0.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
                
                /*
                 * Check for MV- and MTV-result by help MV2
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    if( ae_fp_greater(ae_fabs(y0.ptr.p_double[i1]-y.ptr.p_double[i1], _state),eps)||ae_fp_greater(ae_fabs(yt0.ptr.p_double[i1]-yt.ptr.p_double[i1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing multyplication for simmetric matrix with vector

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionsstest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t m;
    ae_int_t i;
    ae_int_t i1;
    ae_int_t j1;
    double lb;
    double rb;
    ae_matrix a;
    ae_vector x0;
    ae_vector x1;
    ae_vector ty;
    ae_vector tyt;
    ae_vector y;
    ae_vector yt;
    double eps;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&ty, 0, sizeof(ty));
    memset(&tyt, 0, sizeof(tyt));
    memset(&y, 0, sizeof(y));
    memset(&yt, 0, sizeof(yt));
    _sparsematrix_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ty, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tyt, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&yt, 0, DT_REAL, _state, ae_true);

    
    /*
     *Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*m)
     */
    m = 10;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        
        /*
         * Prepare test problem
         */
        testsparseunit_createrandom(i, i, -1, -1, -1, -1, &a, &s, _state);
        
        /*
         * Initialize temporaries
         */
        ae_vector_set_length(&ty, i, _state);
        ae_vector_set_length(&tyt, i, _state);
        ae_vector_set_length(&x0, i, _state);
        ae_vector_set_length(&x1, i, _state);
        for(i1=0; i1<=i-1; i1++)
        {
            ty.ptr.p_double[i1] = (double)(0);
            tyt.ptr.p_double[i1] = (double)(0);
            x0.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
            x1.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
        }
        
        /*
         * Searching true result for upper and lower triangles
         * of the matrix
         */
        for(i1=0; i1<=i-1; i1++)
        {
            for(j1=i1; j1<=i-1; j1++)
            {
                ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                if( i1!=j1 )
                {
                    ty.ptr.p_double[j1] = ty.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[i1];
                }
            }
        }
        for(i1=0; i1<=i-1; i1++)
        {
            for(j1=0; j1<=i1; j1++)
            {
                tyt.ptr.p_double[i1] = tyt.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x1.ptr.p_double[j1];
                if( i1!=j1 )
                {
                    tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x1.ptr.p_double[i1];
                }
            }
        }
        
        /*
         * Multiplication
         */
        sparsesmv(&s, ae_true, &x0, &y, _state);
        sparsesmv(&s, ae_false, &x1, &yt, _state);
        
        /*
         * Check for SMV-result
         */
        for(i1=0; i1<=i-1; i1++)
        {
            if( ae_fp_greater_eq(ae_fabs(y.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps) )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing multyplication sparse matrix with nerrow dense matrix

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionsmmtest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t n;
    ae_int_t m;
    ae_int_t kmax;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t i1;
    ae_int_t j1;
    ae_int_t k1;
    double lb;
    double rb;
    ae_matrix a;
    ae_matrix x0;
    ae_matrix x1;
    ae_matrix ty;
    ae_matrix tyt;
    ae_matrix y;
    ae_matrix yt;
    ae_matrix y0;
    ae_matrix yt0;
    double eps;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&ty, 0, sizeof(ty));
    memset(&tyt, 0, sizeof(tyt));
    memset(&y, 0, sizeof(y));
    memset(&yt, 0, sizeof(yt));
    memset(&y0, 0, sizeof(y0));
    memset(&yt0, 0, sizeof(yt0));
    _sparsematrix_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&x0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&x1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ty, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&tyt, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&y, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&yt, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&y0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&yt0, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*n)
     */
    n = 32;
    m = 32;
    kmax = 32;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            
            /*
             * Prepare test problem
             */
            testsparseunit_createrandom(i, j, -1, -1, -1, -1, &a, &s, _state);
            ae_matrix_set_length(&x0, j, kmax, _state);
            ae_matrix_set_length(&x1, i, kmax, _state);
            for(i1=0; i1<=j-1; i1++)
            {
                for(j1=0; j1<=kmax-1; j1++)
                {
                    x0.ptr.pp_double[i1][j1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
            }
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=kmax-1; j1++)
                {
                    x1.ptr.pp_double[i1][j1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
            }
            ae_matrix_set_length(&ty, i, kmax, _state);
            ae_matrix_set_length(&tyt, j, kmax, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=kmax-1; j1++)
                {
                    ty.ptr.pp_double[i1][j1] = (double)(0);
                }
            }
            for(i1=0; i1<=j-1; i1++)
            {
                for(j1=0; j1<=kmax-1; j1++)
                {
                    tyt.ptr.pp_double[i1][j1] = (double)(0);
                }
            }
            if( i!=j )
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    for(k1=0; k1<=kmax-1; k1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            ty.ptr.pp_double[i1][k1] = ty.ptr.pp_double[i1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[j1][k1];
                            tyt.ptr.pp_double[j1][k1] = tyt.ptr.pp_double[j1][k1]+a.ptr.pp_double[i1][j1]*x1.ptr.pp_double[i1][k1];
                        }
                    }
                }
            }
            else
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    for(k1=0; k1<=kmax-1; k1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            ty.ptr.pp_double[i1][k1] = ty.ptr.pp_double[i1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[j1][k1];
                            tyt.ptr.pp_double[j1][k1] = tyt.ptr.pp_double[j1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[i1][k1];
                        }
                    }
                }
            }
            for(k=1; k<=kmax; k++)
            {
                
                /*
                 * Consider two cases: square matrix, and non-square matrix
                 */
                if( i!=j )
                {
                    
                    /*
                     * Multiplication
                     */
                    sparsemm(&s, &x0, k, &y, _state);
                    sparsemtm(&s, &x1, k, &yt, _state);
                    
                    /*
                     * Check for MM-result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=k-1; j1++)
                        {
                            if( ae_fp_greater_eq(ae_fabs(y.ptr.pp_double[i1][j1]-ty.ptr.pp_double[i1][j1], _state),eps) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                    
                    /*
                     * Check for MTM-result
                     */
                    for(i1=0; i1<=j-1; i1++)
                    {
                        for(j1=0; j1<=k-1; j1++)
                        {
                            if( ae_fp_greater_eq(ae_fabs(yt.ptr.pp_double[i1][j1]-tyt.ptr.pp_double[i1][j1], _state),eps) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
                else
                {
                    sparsemm(&s, &x0, k, &y, _state);
                    sparsemtm(&s, &x0, k, &yt, _state);
                    sparsemm2(&s, &x0, k, &y0, &yt0, _state);
                    
                    /*
                     * Check for MM2-result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=k-1; j1++)
                        {
                            if( ae_fp_greater_eq(ae_fabs(y0.ptr.pp_double[i1][j1]-ty.ptr.pp_double[i1][j1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt0.ptr.pp_double[i1][j1]-tyt.ptr.pp_double[i1][j1], _state),eps) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                    
                    /*
                     * Check for MV- and MTM-result by help MV2
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=k-1; j1++)
                        {
                            if( ae_fp_greater(ae_fabs(y0.ptr.pp_double[i1][j1]-y.ptr.pp_double[i1][j1], _state),eps)||ae_fp_greater(ae_fabs(yt0.ptr.pp_double[i1][j1]-yt.ptr.pp_double[i1][j1], _state),eps) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing multyplication for simmetric sparse matrix with narrow
dense matrix

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionssmmtest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t m;
    ae_int_t k;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_int_t k1;
    double lb;
    double rb;
    ae_matrix a;
    ae_matrix x0;
    ae_matrix x1;
    ae_matrix ty;
    ae_matrix tyt;
    ae_matrix y;
    ae_matrix yt;
    double eps;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&ty, 0, sizeof(ty));
    memset(&tyt, 0, sizeof(tyt));
    memset(&y, 0, sizeof(y));
    memset(&yt, 0, sizeof(yt));
    _sparsematrix_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&x0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&x1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ty, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&tyt, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&y, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&yt, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*m)
     */
    m = 32;
    k = 32;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=k-1; j++)
        {
            
            /*
             * Prepare test problem
             */
            testsparseunit_createrandom(i, i, -1, -1, -1, -1, &a, &s, _state);
            
            /*
             * Initialize temporaries
             */
            ae_matrix_set_length(&ty, i, j, _state);
            ae_matrix_set_length(&tyt, i, j, _state);
            ae_matrix_set_length(&x0, i, j, _state);
            ae_matrix_set_length(&x1, i, j, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    ty.ptr.pp_double[i1][j1] = (double)(0);
                    tyt.ptr.pp_double[i1][j1] = (double)(0);
                    x0.ptr.pp_double[i1][j1] = (rb-lb)*ae_randomreal(_state)+lb;
                    x1.ptr.pp_double[i1][j1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
            }
            
            /*
             * Searching true result for upper and lower triangles
             * of the matrix
             */
            for(k1=0; k1<=j-1; k1++)
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    for(j1=i1; j1<=i-1; j1++)
                    {
                        ty.ptr.pp_double[i1][k1] = ty.ptr.pp_double[i1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[j1][k1];
                        if( i1!=j1 )
                        {
                            ty.ptr.pp_double[j1][k1] = ty.ptr.pp_double[j1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[i1][k1];
                        }
                    }
                }
            }
            for(k1=0; k1<=j-1; k1++)
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    for(j1=0; j1<=i1; j1++)
                    {
                        tyt.ptr.pp_double[i1][k1] = tyt.ptr.pp_double[i1][k1]+a.ptr.pp_double[i1][j1]*x1.ptr.pp_double[j1][k1];
                        if( i1!=j1 )
                        {
                            tyt.ptr.pp_double[j1][k1] = tyt.ptr.pp_double[j1][k1]+a.ptr.pp_double[i1][j1]*x1.ptr.pp_double[i1][k1];
                        }
                    }
                }
            }
            
            /*
             * Multiplication
             */
            sparsesmm(&s, ae_true, &x0, j, &y, _state);
            sparsesmm(&s, ae_false, &x1, j, &yt, _state);
            
            /*
             * Check for SMM-result
             */
            for(k1=0; k1<=j-1; k1++)
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    if( ae_fp_greater_eq(ae_fabs(y.ptr.pp_double[i1][k1]-ty.ptr.pp_double[i1][k1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt.ptr.pp_double[i1][k1]-tyt.ptr.pp_double[i1][k1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for basic test SparseCopy

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basiccopyfunctest(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    sparsematrix ss;
    sparsematrix sss;
    ae_int_t n;
    ae_int_t m;
    ae_vector ner;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_matrix a;
    double a0;
    double a1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&ss, 0, sizeof(ss));
    memset(&sss, 0, sizeof(sss));
    memset(&ner, 0, sizeof(ner));
    memset(&a, 0, sizeof(a));
    _sparsematrix_init(&s, _state, ae_true);
    _sparsematrix_init(&ss, _state, ae_true);
    _sparsematrix_init(&sss, _state, ae_true);
    ae_vector_init(&ner, 0, DT_INT, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);

    n = 30;
    m = 30;
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            sparsecreate(i, j, 1, &s, _state);
            ae_matrix_set_length(&a, i, j, _state);
            ae_vector_set_length(&ner, i, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                if( i1<=j-3 )
                {
                    ner.ptr.p_int[i1] = 2;
                }
                else
                {
                    if( j-3<i1&&i1<=j-2 )
                    {
                        ner.ptr.p_int[i1] = 1;
                    }
                    else
                    {
                        ner.ptr.p_int[i1] = 0;
                    }
                }
            }
            sparsecreatecrs(i, j, &ner, &sss, _state);
            
            /*
             * Checking for Matrix with hash table type
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( j1>i1&&j1<=i1+2 )
                    {
                        a.ptr.pp_double[i1][j1] = (double)(i1+j1+1);
                        sparseset(&s, i1, j1, a.ptr.pp_double[i1][j1], _state);
                        sparseadd(&s, i1, j1, (double)(0), _state);
                        sparseset(&sss, i1, j1, a.ptr.pp_double[i1][j1], _state);
                    }
                    else
                    {
                        a.ptr.pp_double[i1][j1] = (double)(0);
                        sparseset(&s, i1, j1, a.ptr.pp_double[i1][j1], _state);
                        sparseadd(&s, i1, j1, (double)(0), _state);
                    }
                    
                    /*
                     * Check for SparseCreate
                     */
                    sparsecopy(&s, &ss, _state);
                    a0 = sparseget(&s, i1, j1, _state);
                    a1 = sparseget(&ss, i1, j1, _state);
                    if( ae_fp_neq(a0,a1) )
                    {
                        if( !silent )
                        {
                            printf("BasicCopyFuncTest::Report::SparseGet\n");
                            printf("S::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a0));
                            printf("SS::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a1));
                            printf("          TEST FAILED.\n");
                        }
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            
            /*
             * Check for SparseCreateCRS
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    sparsecopy(&sss, &ss, _state);
                    a0 = sparseget(&sss, i1, j1, _state);
                    a1 = sparseget(&ss, i1, j1, _state);
                    if( ae_fp_neq(a0,a1) )
                    {
                        if( !silent )
                        {
                            printf("BasicCopyFuncTest::Report::SparseGet\n");
                            printf("S::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a0));
                            printf("SS::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a1));
                            printf("          TEST FAILED.\n");
                        }
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            
            /*
             * Check for Matrix with CRS type
             */
            sparseconverttocrs(&s, _state);
            sparsecopy(&s, &ss, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    a0 = sparseget(&s, i1, j1, _state);
                    a1 = sparseget(&ss, i1, j1, _state);
                    if( ae_fp_neq(a0,a1) )
                    {
                        if( !silent )
                        {
                            printf("BasicCopyFuncTest::Report::SparseGet\n");
                            printf("S::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a0));
                            printf("SS::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a1));
                            printf("          TEST FAILED.\n");
                        }
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
        }
    }
    if( !silent )
    {
        printf("          TEST IS PASSED.\n");
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing SparseCopy

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool copyfunctest(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    sparsematrix ss;
    ae_int_t n;
    ae_int_t m;
    ae_int_t mtype;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    double lb;
    double rb;
    ae_matrix a;
    ae_vector x0;
    ae_vector x1;
    ae_vector ty;
    ae_vector tyt;
    ae_vector y;
    ae_vector yt;
    ae_vector y0;
    ae_vector yt0;
    ae_vector cpy;
    ae_vector cpyt;
    ae_vector cpy0;
    ae_vector cpyt0;
    double eps;
    double a0;
    double a1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&ss, 0, sizeof(ss));
    memset(&a, 0, sizeof(a));
    memset(&x0, 0, sizeof(x0));
    memset(&x1, 0, sizeof(x1));
    memset(&ty, 0, sizeof(ty));
    memset(&tyt, 0, sizeof(tyt));
    memset(&y, 0, sizeof(y));
    memset(&yt, 0, sizeof(yt));
    memset(&y0, 0, sizeof(y0));
    memset(&yt0, 0, sizeof(yt0));
    memset(&cpy, 0, sizeof(cpy));
    memset(&cpyt, 0, sizeof(cpyt));
    memset(&cpy0, 0, sizeof(cpy0));
    memset(&cpyt0, 0, sizeof(cpyt0));
    _sparsematrix_init(&s, _state, ae_true);
    _sparsematrix_init(&ss, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ty, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tyt, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&yt, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&yt0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&cpy, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&cpyt, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&cpy0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&cpyt0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*n)
     */
    n = 30;
    m = 30;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            for(mtype=0; mtype<=1; mtype++)
            {
                
                /*
                 * Prepare test problem
                 */
                testsparseunit_createrandom(i, j, -1, mtype, -1, -1, &a, &s, _state);
                sparsecopy(&s, &ss, _state);
                
                /*
                 * Initialize temporaries
                 */
                ae_vector_set_length(&ty, i, _state);
                ae_vector_set_length(&tyt, j, _state);
                for(i1=0; i1<=i-1; i1++)
                {
                    ty.ptr.p_double[i1] = (double)(0);
                }
                for(i1=0; i1<=j-1; i1++)
                {
                    tyt.ptr.p_double[i1] = (double)(0);
                }
                ae_vector_set_length(&x0, j, _state);
                ae_vector_set_length(&x1, i, _state);
                for(i1=0; i1<=j-1; i1++)
                {
                    x0.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
                for(i1=0; i1<=i-1; i1++)
                {
                    x1.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
                
                /*
                 * Consider two cases: square matrix, and non-square matrix
                 */
                if( i!=j )
                {
                    
                    /*
                     * Searching true result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                            tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x1.ptr.p_double[i1];
                        }
                    }
                    
                    /*
                     * Multiplication
                     */
                    sparsemv(&s, &x0, &y, _state);
                    sparsemtv(&s, &x1, &yt, _state);
                    sparsemv(&ss, &x0, &cpy, _state);
                    sparsemtv(&ss, &x1, &cpyt, _state);
                    
                    /*
                     * Check for MV-result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        if( (ae_fp_greater_eq(ae_fabs(y.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(cpy.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps))||ae_fp_neq(cpy.ptr.p_double[i1]-y.ptr.p_double[i1],(double)(0)) )
                        {
                            if( !silent )
                            {
                                printf("CopyFuncTest::Report::RES_MV\n");
                                printf("Y[%0d]=%0.5f; tY[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(y.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(ty.ptr.p_double[i1]));
                                printf("cpY[%0d]=%0.5f;\n",
                                    (int)(i1),
                                    (double)(cpy.ptr.p_double[i1]));
                                printf("          TEST FAILED.\n");
                            }
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                    
                    /*
                     * Check for MTV-result
                     */
                    for(i1=0; i1<=j-1; i1++)
                    {
                        if( (ae_fp_greater_eq(ae_fabs(yt.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(cpyt.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps))||ae_fp_neq(cpyt.ptr.p_double[i1]-yt.ptr.p_double[i1],(double)(0)) )
                        {
                            if( !silent )
                            {
                                printf("CopyFuncTest::Report::RES_MTV\n");
                                printf("Yt[%0d]=%0.5f; tYt[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(yt.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(tyt.ptr.p_double[i1]));
                                printf("cpYt[%0d]=%0.5f;\n",
                                    (int)(i1),
                                    (double)(cpyt.ptr.p_double[i1]));
                                printf("          TEST FAILED.\n");
                            }
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                    sparsecopy(&s, &ss, _state);
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            a0 = sparseget(&s, i1, j1, _state);
                            a1 = sparseget(&ss, i1, j1, _state);
                            if( ae_fp_neq(a0,a1) )
                            {
                                if( !silent )
                                {
                                    printf("CopyFuncTest::Report::SparseGet\n");
                                    printf("S::[%0d,%0d]=%0.5f\n",
                                        (int)(i1),
                                        (int)(j1),
                                        (double)(a0));
                                    printf("SS::[%0d,%0d]=%0.5f\n",
                                        (int)(i1),
                                        (int)(j1),
                                        (double)(a1));
                                    printf("          TEST FAILED.\n");
                                }
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
                else
                {
                    
                    /*
                     * Searching true result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                            tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[i1];
                        }
                    }
                    
                    /*
                     * Multiplication
                     */
                    sparsemv(&s, &x0, &y, _state);
                    sparsemtv(&s, &x0, &yt, _state);
                    sparsemv2(&s, &x0, &y0, &yt0, _state);
                    sparsemv(&ss, &x0, &cpy, _state);
                    sparsemtv(&ss, &x0, &cpyt, _state);
                    sparsemv2(&ss, &x0, &cpy0, &cpyt0, _state);
                    
                    /*
                     * Check for MV2-result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        if( ((((ae_fp_greater_eq(ae_fabs(y0.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt0.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps))||ae_fp_greater_eq(ae_fabs(cpy0.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps))||ae_fp_greater_eq(ae_fabs(cpyt0.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps))||ae_fp_neq(cpy0.ptr.p_double[i1]-y0.ptr.p_double[i1],(double)(0)))||ae_fp_neq(cpyt0.ptr.p_double[i1]-yt0.ptr.p_double[i1],(double)(0)) )
                        {
                            if( !silent )
                            {
                                printf("CopyFuncTest::Report::RES_MV2\n");
                                printf("Y0[%0d]=%0.5f; tY[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(y0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(ty.ptr.p_double[i1]));
                                printf("Yt0[%0d]=%0.5f; tYt[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(yt0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(tyt.ptr.p_double[i1]));
                                printf("cpY0[%0d]=%0.5f;\n",
                                    (int)(i1),
                                    (double)(cpy0.ptr.p_double[i1]));
                                printf("cpYt0[%0d]=%0.5f;\n",
                                    (int)(i1),
                                    (double)(cpyt0.ptr.p_double[i1]));
                                printf("          TEST FAILED.\n");
                            }
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                    
                    /*
                     * Check for MV- and MTV-result by help MV2
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        if( ((ae_fp_greater(ae_fabs(y0.ptr.p_double[i1]-y.ptr.p_double[i1], _state),eps)||ae_fp_greater(ae_fabs(yt0.ptr.p_double[i1]-yt.ptr.p_double[i1], _state),eps))||ae_fp_greater(ae_fabs(cpy0.ptr.p_double[i1]-cpy.ptr.p_double[i1], _state),eps))||ae_fp_greater(ae_fabs(cpyt0.ptr.p_double[i1]-cpyt.ptr.p_double[i1], _state),eps) )
                        {
                            if( !silent )
                            {
                                printf("CopyFuncTest::Report::RES_MV_MVT\n");
                                printf("Y0[%0d]=%0.5f; Y[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(y0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(y.ptr.p_double[i1]));
                                printf("Yt0[%0d]=%0.5f; Yt[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(yt0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(yt.ptr.p_double[i1]));
                                printf("cpY0[%0d]=%0.5f; cpY[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(cpy0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(cpy.ptr.p_double[i1]));
                                printf("cpYt0[%0d]=%0.5f; cpYt[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(cpyt0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(cpyt.ptr.p_double[i1]));
                                printf("          TEST FAILED.\n");
                            }
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                    sparsecopy(&s, &ss, _state);
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            a0 = sparseget(&s, i1, j1, _state);
                            a1 = sparseget(&ss, i1, j1, _state);
                            if( ae_fp_neq(a0,a1) )
                            {
                                if( !silent )
                                {
                                    printf("CopyFuncTest::Report::SparseGet\n");
                                    printf("S::[%0d,%0d]=%0.5f\n",
                                        (int)(i1),
                                        (int)(j1),
                                        (double)(a0));
                                    printf("SS::[%0d,%0d]=%0.5f\n",
                                        (int)(i1),
                                        (int)(j1),
                                        (double)(a1));
                                    printf("          TEST FAILED.\n");
                                }
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
            }
        }
    }
    if( !silent )
    {
        printf("          TEST IS PASSED.\n");
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
This function initializes sparse matrix generator, which is used to generate
a set of matrices with sequentially increasing sparsity.

PARAMETERS:
    M, N        -   matrix size. If M=0, then matrix is square N*N.
                    N and M must be small enough to store N*M dense matrix.
    MatKind     -   matrix properties:
                    * 0     -   general sparse (no structure)
                    * 1     -   general sparse, but diagonal is always present and non-zero
                    * 2     -   diagonally dominant, SPD
    Triangle    -   triangle being returned:
                    * +1    -   upper triangle
                    * -1    -   lower triangle
                    *  0    -   full matrix is returned
                    
OUTPUT PARAMETERS:
    G           -   generator
    A           -   matrix A in dense format
    SA          -   matrix A in sparse format (hash-table storage)
*************************************************************************/
static void testsparseunit_initgenerator(ae_int_t m,
     ae_int_t n,
     ae_int_t matkind,
     ae_int_t triangle,
     sparsegenerator* g,
     ae_state *_state)
{

    _sparsegenerator_clear(g);

    g->n = n;
    g->m = m;
    g->matkind = matkind;
    g->triangle = triangle;
    hqrndrandomize(&g->rs, _state);
    ae_vector_set_length(&g->rcs.ia, 5+1, _state);
    ae_vector_set_length(&g->rcs.ra, 1+1, _state);
    g->rcs.stage = -1;
}


static ae_bool testsparseunit_generatenext(sparsegenerator* g,
     /* Real    */ ae_matrix* da,
     sparsematrix* sa,
     ae_state *_state)
{
    ae_int_t n;
    ae_int_t m;
    ae_int_t nz;
    ae_int_t nzd;
    double pnz;
    ae_int_t i;
    ae_int_t j;
    double v;
    ae_bool result;

    ae_matrix_clear(da);
    _sparsematrix_clear(sa);

    
    /*
     * Reverse communication preparations
     * I know it looks ugly, but it works the same way
     * anywhere from C++ to Python.
     *
     * This code initializes locals by:
     * * random values determined during code
     *   generation - on first subroutine call
     * * values from previous call - on subsequent calls
     */
    if( g->rcs.stage>=0 )
    {
        n = g->rcs.ia.ptr.p_int[0];
        m = g->rcs.ia.ptr.p_int[1];
        nz = g->rcs.ia.ptr.p_int[2];
        nzd = g->rcs.ia.ptr.p_int[3];
        i = g->rcs.ia.ptr.p_int[4];
        j = g->rcs.ia.ptr.p_int[5];
        pnz = g->rcs.ra.ptr.p_double[0];
        v = g->rcs.ra.ptr.p_double[1];
    }
    else
    {
        n = 359;
        m = -58;
        nz = -919;
        nzd = -909;
        i = 81;
        j = 255;
        pnz = 74;
        v = -788;
    }
    if( g->rcs.stage==0 )
    {
        goto lbl_0;
    }
    if( g->rcs.stage==1 )
    {
        goto lbl_1;
    }
    
    /*
     * Routine body
     */
    n = g->n;
    if( g->m==0 )
    {
        m = n;
    }
    else
    {
        m = g->m;
    }
    ae_assert(m>0&&n>0, "GenerateNext: incorrect N/M", _state);
    
    /*
     * Generate general sparse matrix
     */
    if( g->matkind!=0 )
    {
        goto lbl_2;
    }
    nz = n*m;
lbl_4:
    if( ae_false )
    {
        goto lbl_5;
    }
    
    /*
     * Generate dense N*N matrix where probability of element
     * being non-zero is PNZ.
     */
    pnz = (double)nz/(double)(n*m);
    ae_matrix_set_length(&g->bufa, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_less_eq(hqrnduniformr(&g->rs, _state),pnz) )
            {
                g->bufa.ptr.pp_double[i][j] = hqrnduniformr(&g->rs, _state)-0.5;
            }
            else
            {
                g->bufa.ptr.pp_double[i][j] = 0.0;
            }
        }
    }
    
    /*
     * Output matrix and RComm
     */
    ae_matrix_set_length(da, m, n, _state);
    sparsecreate(m, n, ae_round(pnz*m*n, _state), sa, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (j<=i&&g->triangle<=0)||(j>=i&&g->triangle>=0) )
            {
                da->ptr.pp_double[i][j] = g->bufa.ptr.pp_double[i][j];
                sparseset(sa, i, j, g->bufa.ptr.pp_double[i][j], _state);
            }
            else
            {
                da->ptr.pp_double[i][j] = 0.0;
            }
        }
    }
    g->rcs.stage = 0;
    goto lbl_rcomm;
lbl_0:
    
    /*
     * Increase problem sparcity and try one more time. 
     * Stop after testing NZ=0.
     */
    if( nz==0 )
    {
        goto lbl_5;
    }
    nz = nz/2;
    goto lbl_4;
lbl_5:
    result = ae_false;
    return result;
lbl_2:
    
    /*
     * Generate general sparse matrix with non-zero diagonal
     */
    if( g->matkind!=1 )
    {
        goto lbl_6;
    }
    ae_assert(n==m, "GenerateNext: non-square matrix for MatKind=1", _state);
    nz = n*n-n;
lbl_8:
    if( ae_false )
    {
        goto lbl_9;
    }
    
    /*
     * Generate dense N*N matrix where probability of non-diagonal element
     * being non-zero is PNZ.
     */
    if( n>1 )
    {
        pnz = (double)nz/(double)(n*n-n);
    }
    else
    {
        pnz = (double)(1);
    }
    ae_matrix_set_length(&g->bufa, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( i==j )
            {
                do
                {
                    g->bufa.ptr.pp_double[i][i] = hqrnduniformr(&g->rs, _state)-0.5;
                }
                while(ae_fp_eq(g->bufa.ptr.pp_double[i][i],(double)(0)));
                g->bufa.ptr.pp_double[i][i] = g->bufa.ptr.pp_double[i][i]+1.5*ae_sign(g->bufa.ptr.pp_double[i][i], _state);
                continue;
            }
            if( ae_fp_less_eq(hqrnduniformr(&g->rs, _state),pnz) )
            {
                g->bufa.ptr.pp_double[i][j] = hqrnduniformr(&g->rs, _state)-0.5;
            }
            else
            {
                g->bufa.ptr.pp_double[i][j] = 0.0;
            }
        }
    }
    
    /*
     * Output matrix and RComm
     */
    ae_matrix_set_length(da, n, n, _state);
    sparsecreate(n, n, ae_round(pnz*(n*n-n)+n, _state), sa, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (j<=i&&g->triangle<=0)||(j>=i&&g->triangle>=0) )
            {
                da->ptr.pp_double[i][j] = g->bufa.ptr.pp_double[i][j];
                sparseset(sa, i, j, g->bufa.ptr.pp_double[i][j], _state);
            }
            else
            {
                da->ptr.pp_double[i][j] = 0.0;
            }
        }
    }
    g->rcs.stage = 1;
    goto lbl_rcomm;
lbl_1:
    
    /*
     * Increase problem sparcity and try one more time. 
     * Stop after testing NZ=0.
     */
    if( nz==0 )
    {
        goto lbl_9;
    }
    nz = nz/2;
    goto lbl_8;
lbl_9:
    result = ae_false;
    return result;
lbl_6:
    ae_assert(ae_false, "Assertion failed", _state);
    result = ae_false;
    return result;
    
    /*
     * Saving state
     */
lbl_rcomm:
    result = ae_true;
    g->rcs.ia.ptr.p_int[0] = n;
    g->rcs.ia.ptr.p_int[1] = m;
    g->rcs.ia.ptr.p_int[2] = nz;
    g->rcs.ia.ptr.p_int[3] = nzd;
    g->rcs.ia.ptr.p_int[4] = i;
    g->rcs.ia.ptr.p_int[5] = j;
    g->rcs.ra.ptr.p_double[0] = pnz;
    g->rcs.ra.ptr.p_double[1] = v;
    return result;
}


/*************************************************************************
This function creates random sparse matrix with some prescribed pattern.

INPUT PARAMETERS:
    M       -   number of rows
    N       -   number of columns
    PKind   -   sparsity pattern:
                *-1 = pattern is chosen at random as well as P0/P1
                * 0 = matrix with up to P0 non-zero elements at random locations
                      (however, actual number of non-zero elements can be
                      less than P0, and in fact can be zero)
                * 1 = band matrix with P0 non-zero elements below diagonal
                      and P1 non-zero element above diagonal
                * 2 = matrix with random number of contiguous non-zero 
                      elements in the each row
    CKind   -   creation type:
                *-1 = CKind is chosen at random
                * 0 = matrix is created in Hash-Table format and converted
                      to CRS representation
                * 1 = matrix is created in CRS format
                * 2 = matrix is created in Hash-Table format and converted
                      to SKS representation

OUTPUT PARAMETERS:
    DA      -   dense representation of A, array[M,N]
    SA      -   sparse representation of A, in CRS format

  -- ALGLIB PROJECT --
     Copyright 31.10.2011 by Bochkanov Sergey
*************************************************************************/
static void testsparseunit_createrandom(ae_int_t m,
     ae_int_t n,
     ae_int_t pkind,
     ae_int_t ckind,
     ae_int_t p0,
     ae_int_t p1,
     /* Real    */ ae_matrix* da,
     sparsematrix* sa,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t maxpkind;
    ae_int_t maxckind;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double v;
    ae_vector c0;
    ae_vector c1;
    ae_vector rowsizes;

    ae_frame_make(_state, &_frame_block);
    memset(&c0, 0, sizeof(c0));
    memset(&c1, 0, sizeof(c1));
    memset(&rowsizes, 0, sizeof(rowsizes));
    ae_matrix_clear(da);
    _sparsematrix_clear(sa);
    ae_vector_init(&c0, 0, DT_INT, _state, ae_true);
    ae_vector_init(&c1, 0, DT_INT, _state, ae_true);
    ae_vector_init(&rowsizes, 0, DT_INT, _state, ae_true);

    maxpkind = 2;
    maxckind = 2;
    ae_assert(m>=1, "CreateRandom: incorrect parameters", _state);
    ae_assert(n>=1, "CreateRandom: incorrect parameters", _state);
    ae_assert(pkind>=-1&&pkind<=maxpkind, "CreateRandom: incorrect parameters", _state);
    ae_assert(ckind>=-1&&ckind<=maxckind, "CreateRandom: incorrect parameters", _state);
    ae_assert(!(ckind==2&&m!=n), "CreateRandom: incorrect parameters", _state);
    if( pkind==-1 )
    {
        pkind = ae_randominteger(maxpkind+1, _state);
        if( pkind==0 )
        {
            p0 = ae_randominteger(m*n, _state);
        }
        if( pkind==1 )
        {
            p0 = ae_randominteger(ae_minint(m, n, _state), _state);
            p1 = ae_randominteger(ae_minint(m, n, _state), _state);
        }
    }
    if( ckind==-1 )
    {
        do
        {
            ckind = ae_randominteger(maxckind+1, _state);
        }
        while(ckind==2&&m!=n);
    }
    if( pkind==0 )
    {
        
        /*
         * Matrix with elements at random locations
         */
        ae_matrix_set_length(da, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                da->ptr.pp_double[i][j] = (double)(0);
            }
        }
        if( ckind==0||ckind==2 )
        {
            
            /*
             * Create matrix in Hash format, convert to CRS or SKS
             */
            sparsecreate(m, n, 1, sa, _state);
            for(k=0; k<=p0-1; k++)
            {
                i = ae_randominteger(m, _state);
                j = ae_randominteger(n, _state);
                v = (double)(ae_randominteger(17, _state)-8)/(double)8;
                if( ae_fp_greater(ae_randomreal(_state),0.5) )
                {
                    da->ptr.pp_double[i][j] = v;
                    sparseset(sa, i, j, v, _state);
                }
                else
                {
                    da->ptr.pp_double[i][j] = da->ptr.pp_double[i][j]+v;
                    sparseadd(sa, i, j, v, _state);
                }
            }
            if( ckind!=2 )
            {
                sparseconverttocrs(sa, _state);
            }
            else
            {
                sparseconverttosks(sa, _state);
            }
            ae_frame_leave(_state);
            return;
        }
        if( ckind==1 )
        {
            
            /*
             * Create matrix in CRS format
             */
            for(k=0; k<=p0-1; k++)
            {
                i = ae_randominteger(m, _state);
                j = ae_randominteger(n, _state);
                v = (double)(ae_randominteger(17, _state)-8)/(double)8;
                da->ptr.pp_double[i][j] = v;
            }
            ae_vector_set_length(&rowsizes, m, _state);
            for(i=0; i<=m-1; i++)
            {
                rowsizes.ptr.p_int[i] = 0;
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(da->ptr.pp_double[i][j],(double)(0)) )
                    {
                        rowsizes.ptr.p_int[i] = rowsizes.ptr.p_int[i]+1;
                    }
                }
            }
            sparsecreatecrs(m, n, &rowsizes, sa, _state);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(da->ptr.pp_double[i][j],(double)(0)) )
                    {
                        sparseset(sa, i, j, da->ptr.pp_double[i][j], _state);
                    }
                }
            }
            ae_frame_leave(_state);
            return;
        }
        ae_assert(ae_false, "CreateRandom: internal error", _state);
    }
    if( pkind==1 )
    {
        
        /*
         * Band matrix
         */
        ae_matrix_set_length(da, m, n, _state);
        ae_vector_set_length(&rowsizes, m, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                da->ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=ae_maxint(i-p0, 0, _state); j<=ae_minint(i+p1, n-1, _state); j++)
            {
                do
                {
                    da->ptr.pp_double[i][j] = (double)(ae_randominteger(17, _state)-8)/(double)8;
                }
                while(ae_fp_eq(da->ptr.pp_double[i][j],(double)(0)));
            }
            rowsizes.ptr.p_int[i] = ae_maxint(ae_minint(i+p1, n-1, _state)-ae_maxint(i-p0, 0, _state)+1, 0, _state);
        }
        if( ckind==0 )
        {
            sparsecreate(m, n, 1, sa, _state);
        }
        if( ckind==1 )
        {
            sparsecreatecrs(m, n, &rowsizes, sa, _state);
        }
        if( ckind==2 )
        {
            sparsecreate(m, n, 1, sa, _state);
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_neq(da->ptr.pp_double[i][j],(double)(0)) )
                {
                    sparseset(sa, i, j, da->ptr.pp_double[i][j], _state);
                }
            }
        }
        if( ckind!=2 )
        {
            sparseconverttocrs(sa, _state);
        }
        else
        {
            sparseconverttosks(sa, _state);
        }
        ae_frame_leave(_state);
        return;
    }
    if( pkind==2 )
    {
        
        /*
         * Matrix with one contiguous sequence of non-zero elements per row
         */
        ae_matrix_set_length(da, m, n, _state);
        ae_vector_set_length(&rowsizes, m, _state);
        ae_vector_set_length(&c0, m, _state);
        ae_vector_set_length(&c1, m, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                da->ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=0; i<=m-1; i++)
        {
            c0.ptr.p_int[i] = ae_randominteger(n, _state);
            c1.ptr.p_int[i] = c0.ptr.p_int[i]+ae_randominteger(n-c0.ptr.p_int[i]+1, _state);
            rowsizes.ptr.p_int[i] = c1.ptr.p_int[i]-c0.ptr.p_int[i];
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=c0.ptr.p_int[i]; j<=c1.ptr.p_int[i]-1; j++)
            {
                do
                {
                    da->ptr.pp_double[i][j] = (double)(ae_randominteger(17, _state)-8)/(double)8;
                }
                while(ae_fp_eq(da->ptr.pp_double[i][j],(double)(0)));
            }
        }
        if( ckind==0 )
        {
            sparsecreate(m, n, 1, sa, _state);
        }
        if( ckind==1 )
        {
            sparsecreatecrs(m, n, &rowsizes, sa, _state);
        }
        if( ckind==2 )
        {
            sparsecreate(m, n, 1, sa, _state);
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_neq(da->ptr.pp_double[i][j],(double)(0)) )
                {
                    sparseset(sa, i, j, da->ptr.pp_double[i][j], _state);
                }
            }
        }
        if( ckind!=2 )
        {
            sparseconverttocrs(sa, _state);
        }
        else
        {
            sparseconverttosks(sa, _state);
        }
        ae_frame_leave(_state);
        return;
    }
    ae_frame_leave(_state);
}


/*************************************************************************
This function does test for SparseEnumerate function.

  -- ALGLIB PROJECT --
     Copyright 14.03.2012 by Bochkanov Sergey
*************************************************************************/
static ae_bool testsparseunit_enumeratetest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix spa;
    ae_matrix a;
    ae_matrix ta;
    ae_int_t m;
    ae_int_t n;
    double r;
    double v;
    ae_int_t ne;
    ae_int_t t0;
    ae_int_t t1;
    ae_int_t counter;
    ae_int_t c;
    ae_int_t hashcrs;
    ae_int_t i;
    ae_int_t j;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&spa, 0, sizeof(spa));
    memset(&a, 0, sizeof(a));
    memset(&ta, 0, sizeof(ta));
    _sparsematrix_init(&spa, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ta, 0, 0, DT_BOOL, _state, ae_true);

    r = 10.5;
    for(m=1; m<=30; m++)
    {
        for(n=1; n<=30; n++)
        {
            ne = 0;
            
            /*
             * Create matrix with non-zero elements inside the region:
             * 0<=I<S.M and 0<=J<S.N
             */
            ae_matrix_set_length(&a, m, n, _state);
            ae_matrix_set_length(&ta, m, n, _state);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = (double)(0);
                    ta.ptr.pp_bool[i][j] = ae_false;
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    c = ae_randominteger(2, _state);
                    if( c==0 )
                    {
                        a.ptr.pp_double[i][j] = (double)(0);
                    }
                    else
                    {
                        do
                        {
                            a.ptr.pp_double[i][j] = r*(2*ae_randomreal(_state)-1);
                        }
                        while(ae_fp_eq(a.ptr.pp_double[i][j],(double)(0)));
                        
                        /*
                         * Number of non-zero elements
                         */
                        ne = ne+1;
                    }
                }
            }
            for(hashcrs=0; hashcrs<=1; hashcrs++)
            {
                sparsecreate(m, n, m*n, &spa, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        sparseset(&spa, i, j, a.ptr.pp_double[i][j], _state);
                    }
                }
                if( hashcrs==1 )
                {
                    sparseconverttocrs(&spa, _state);
                }
                t0 = 0;
                t1 = 0;
                counter = 0;
                while(sparseenumerate(&spa, &t0, &t1, &i, &j, &v, _state))
                {
                    ta.ptr.pp_bool[i][j] = ae_true;
                    counter = counter+1;
                    if( ae_fp_neq(v,a.ptr.pp_double[i][j]) )
                    {
                        ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testsparseunit.ap:3112");
                        ae_frame_leave(_state);
                        return result;
                    }
                }
                
                /*
                 * Check that all non-zero elements was enumerated
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ta.ptr.pp_bool[i][j]&&ae_fp_eq(a.ptr.pp_double[i][j],(double)(0)) )
                        {
                            ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testsparseunit.ap:3124");
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                }
                if( ne!=counter )
                {
                    ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testsparseunit.ap:3130");
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
This function does test for SparseRewriteExisting function.

  -- ALGLIB PROJECT --
     Copyright 14.03.2012 by Bochkanov Sergey
*************************************************************************/
static ae_bool testsparseunit_rewriteexistingtest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix spa;
    double spaval;
    ae_matrix a;
    ae_matrix ta;
    ae_int_t m;
    ae_int_t n;
    ae_int_t c;
    ae_int_t ne;
    ae_int_t nr;
    double r;
    double v;
    ae_int_t hashcrs;
    ae_int_t i;
    ae_int_t j;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&spa, 0, sizeof(spa));
    memset(&a, 0, sizeof(a));
    memset(&ta, 0, sizeof(ta));
    _sparsematrix_init(&spa, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ta, 0, 0, DT_BOOL, _state, ae_true);

    r = 20.0;
    for(m=1; m<=30; m++)
    {
        for(n=1; n<=30; n++)
        {
            ae_matrix_set_length(&a, m, n, _state);
            ae_matrix_set_length(&ta, m, n, _state);
            for(hashcrs=0; hashcrs<=1; hashcrs++)
            {
                v = r*(2*ae_randomreal(_state)-1);
                
                /*
                 * Creating and filling of the matrix
                 */
                ne = 0;
                sparsecreate(m, n, m*n, &spa, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        c = ae_randominteger(2, _state);
                        if( c==0 )
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                        }
                        if( c==1 )
                        {
                            do
                            {
                                a.ptr.pp_double[i][j] = r*(2*ae_randomreal(_state)-1);
                            }
                            while(ae_fp_eq(a.ptr.pp_double[i][j],(double)(0)));
                            sparseset(&spa, i, j, a.ptr.pp_double[i][j], _state);
                            ne = ne+1;
                        }
                        ta.ptr.pp_bool[i][j] = ae_false;
                    }
                }
                if( hashcrs==1 )
                {
                    sparseconverttocrs(&spa, _state);
                }
                
                /*
                 * Rewrite some elements
                 */
                nr = 0;
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        c = ae_randominteger(2, _state);
                        if( c==1 )
                        {
                            ta.ptr.pp_bool[i][j] = sparserewriteexisting(&spa, i, j, v, _state);
                            if( ta.ptr.pp_bool[i][j] )
                            {
                                a.ptr.pp_double[i][j] = v;
                                nr = nr+1;
                            }
                        }
                    }
                }
                
                /*
                 * Now we have to be sure, that all changes had made correctly
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ta.ptr.pp_bool[i][j] )
                        {
                            spaval = sparseget(&spa, i, j, _state);
                            nr = nr-1;
                            if( ae_fp_neq(spaval,v)||ae_fp_neq(spaval,a.ptr.pp_double[i][j]) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
                if( nr!=0 )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
                
                /*
                 * Rewrite all elements
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ta.ptr.pp_bool[i][j] = sparserewriteexisting(&spa, i, j, v, _state);
                        if( ta.ptr.pp_bool[i][j] )
                        {
                            a.ptr.pp_double[i][j] = v;
                        }
                    }
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ta.ptr.pp_bool[i][j] )
                        {
                            ne = ne-1;
                        }
                    }
                }
                if( ne!=0 )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        spaval = sparseget(&spa, i, j, _state);
                        if( ta.ptr.pp_bool[i][j] )
                        {
                            if( ae_fp_neq(spaval,v)||ae_fp_neq(spaval,a.ptr.pp_double[i][j]) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                        else
                        {
                            if( ae_fp_neq(spaval,(double)(0))||ae_fp_neq(spaval,a.ptr.pp_double[i][j]) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Test  for  SparseGetRow/GetCompressedRow  function.   It  creates  random
dense and sparse matrices;  then  get every  row from  sparse matrix  and
compares it with every row in dense matrix.

On failure sets error flag, on success leaves it unchanged.

  -- ALGLIB PROJECT --
     Copyright 23.07.2012 by Bochkanov Sergey
*************************************************************************/
static void testsparseunit_testgetrow(ae_bool* err, ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_matrix a;
    ae_int_t m;
    ae_int_t n;
    ae_int_t msize;
    ae_int_t nsize;
    ae_int_t nz;
    ae_vector vals;
    ae_vector mrow;
    ae_vector colidx;
    ae_vector wasreturned;
    ae_int_t mtype;
    ae_int_t i;
    ae_int_t j;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&a, 0, sizeof(a));
    memset(&vals, 0, sizeof(vals));
    memset(&mrow, 0, sizeof(mrow));
    memset(&colidx, 0, sizeof(colidx));
    memset(&wasreturned, 0, sizeof(wasreturned));
    _sparsematrix_init(&s, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&vals, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&mrow, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&colidx, 0, DT_INT, _state, ae_true);
    ae_vector_init(&wasreturned, 0, DT_BOOL, _state, ae_true);

    msize = 15;
    nsize = 15;
    for(mtype=1; mtype<=2; mtype++)
    {
        for(m=1; m<=msize; m++)
        {
            for(n=1; n<=nsize; n++)
            {
                
                /*
                 * Skip nonrectangular SKS matrices - not supported
                 */
                if( mtype==2&&m!=n )
                {
                    continue;
                }
                
                /*
                 * Create "reference" and sparse matrices
                 */
                ae_matrix_set_length(&a, m, n, _state);
                sparsecreate(m, n, 1, &s, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_randominteger(5, _state)==3 )
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            sparseset(&s, i, j, a.ptr.pp_double[i][j], _state);
                        }
                        else
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
                
                /*
                 * Choose matrix type to test
                 */
                if( mtype==1 )
                {
                    sparseconverttocrs(&s, _state);
                }
                else
                {
                    sparseconverttosks(&s, _state);
                }
                
                /*
                 * Test SparseGetRow()
                 */
                for(i=0; i<=m-1; i++)
                {
                    sparsegetrow(&s, i, &mrow, _state);
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_fp_neq(mrow.ptr.p_double[j],a.ptr.pp_double[i][j])||ae_fp_neq(mrow.ptr.p_double[j],sparseget(&s, i, j, _state)) )
                        {
                            ae_set_error_flag(err, ae_true, __FILE__, __LINE__, "testsparseunit.ap:3355");
                            ae_frame_leave(_state);
                            return;
                        }
                    }
                }
                
                /*
                 * Test SparseGetCompressedRow()
                 */
                ae_vector_set_length(&wasreturned, n, _state);
                for(i=0; i<=m-1; i++)
                {
                    sparsegetcompressedrow(&s, i, &colidx, &vals, &nz, _state);
                    if( nz<0||nz>n )
                    {
                        ae_set_error_flag(err, ae_true, __FILE__, __LINE__, "testsparseunit.ap:3369");
                        ae_frame_leave(_state);
                        return;
                    }
                    for(j=0; j<=n-1; j++)
                    {
                        wasreturned.ptr.p_bool[j] = ae_false;
                    }
                    for(j=0; j<=nz-1; j++)
                    {
                        if( colidx.ptr.p_int[j]<0||colidx.ptr.p_int[j]>n )
                        {
                            ae_set_error_flag(err, ae_true, __FILE__, __LINE__, "testsparseunit.ap:3378");
                            ae_frame_leave(_state);
                            return;
                        }
                        ae_set_error_flag(err, j>0&&colidx.ptr.p_int[j]<=colidx.ptr.p_int[j-1], __FILE__, __LINE__, "testsparseunit.ap:3381");
                        ae_set_error_flag(err, ae_fp_neq(vals.ptr.p_double[j],a.ptr.pp_double[i][colidx.ptr.p_int[j]])||ae_fp_neq(vals.ptr.p_double[j],sparseget(&s, i, colidx.ptr.p_int[j], _state)), __FILE__, __LINE__, "testsparseunit.ap:3382");
                        wasreturned.ptr.p_bool[colidx.ptr.p_int[j]] = ae_true;
                    }
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(err, ae_fp_neq(a.ptr.pp_double[i][j],(double)(0))&&!wasreturned.ptr.p_bool[j], __FILE__, __LINE__, "testsparseunit.ap:3386");
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Test for SparseConvert functions(isn't tested ConvertToCRS function). The
function  create random  dense and sparse  matrices  in CRS  format. Then
convert  sparse matrix  to some  format  by CONVERT_TO/COPY_TO  functions,
then it does  some modification in matrices and compares that marices are
identical.

NOTE:
    Result of the function assigned to variable CopyErrors in unit test.

  -- ALGLIB PROJECT --
     Copyright 23.07.2012 by Bochkanov Sergey
*************************************************************************/
static ae_bool testsparseunit_testconvertsm(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    sparsematrix cs;
    ae_matrix a;
    ae_int_t m;
    ae_int_t n;
    ae_int_t msize;
    ae_int_t nsize;
    ae_vector ner;
    double tmp;
    ae_int_t i;
    ae_int_t j;
    ae_int_t vartf;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&cs, 0, sizeof(cs));
    memset(&a, 0, sizeof(a));
    memset(&ner, 0, sizeof(ner));
    _sparsematrix_init(&s, _state, ae_true);
    _sparsematrix_init(&cs, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ner, 0, DT_INT, _state, ae_true);

    msize = 15;
    nsize = 15;
    for(m=1; m<=msize; m++)
    {
        for(n=1; n<=nsize; n++)
        {
            for(vartf=0; vartf<=2; vartf++)
            {
                ae_matrix_set_length(&a, m, n, _state);
                ae_vector_set_length(&ner, m, _state);
                for(i=0; i<=m-1; i++)
                {
                    ner.ptr.p_int[i] = 0;
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_randominteger(5, _state)==3 )
                        {
                            ner.ptr.p_int[i] = ner.ptr.p_int[i]+1;
                            do
                            {
                                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            }
                            while(ae_fp_eq(a.ptr.pp_double[i][j],(double)(0)));
                        }
                        else
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
                
                /*
                 * Create sparse matrix
                 */
                sparsecreatecrs(m, n, &ner, &s, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_fp_neq(a.ptr.pp_double[i][j],(double)(0)) )
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            sparseset(&s, i, j, a.ptr.pp_double[i][j], _state);
                        }
                    }
                }
                
                /*
                 * Set matrix type(we have to be sure that all formats
                 * converted correctly)
                 */
                i = ae_randominteger(2, _state);
                if( i==0 )
                {
                    sparseconverttohash(&s, _state);
                }
                if( i==1 )
                {
                    sparseconverttocrs(&s, _state);
                }
                
                /*
                 * Start test
                 */
                if( vartf==0 )
                {
                    sparseconverttohash(&s, _state);
                    sparsecopy(&s, &cs, _state);
                }
                if( vartf==1 )
                {
                    sparsecopytohash(&s, &cs, _state);
                }
                if( vartf==2 )
                {
                    sparsecopytocrs(&s, &cs, _state);
                }
                
                /*
                 * Change some elements in row
                 */
                if( vartf!=2 )
                {
                    for(i=0; i<=m-1; i++)
                    {
                        tmp = 2*ae_randomreal(_state)-1;
                        j = ae_randominteger(n, _state);
                        a.ptr.pp_double[i][j] = tmp;
                        sparseset(&cs, i, j, tmp, _state);
                        tmp = 2*ae_randomreal(_state)-1;
                        j = ae_randominteger(n, _state);
                        a.ptr.pp_double[i][j] = a.ptr.pp_double[i][j]+tmp;
                        sparseadd(&cs, i, j, tmp, _state);
                    }
                }
                
                /*
                 * Check that A is identical to S
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_fp_neq(a.ptr.pp_double[i][j],sparseget(&cs, i, j, _state)) )
                        {
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Test for  check/get  type functions.  The function  create sparse matrix,
converts it to desired type then check this type.

NOTE:
    Result of the function assigned to variable BasicErrors in unit test.

  -- ALGLIB PROJECT --
     Copyright 23.07.2012 by Bochkanov Sergey
*************************************************************************/
static ae_bool testsparseunit_testgcmatrixtype(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    sparsematrix cs;
    ae_int_t m;
    ae_int_t n;
    ae_int_t msize;
    ae_int_t nsize;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&s, 0, sizeof(s));
    memset(&cs, 0, sizeof(cs));
    _sparsematrix_init(&s, _state, ae_true);
    _sparsematrix_init(&cs, _state, ae_true);

    msize = 5;
    nsize = 5;
    for(m=1; m<=msize; m++)
    {
        for(n=1; n<=nsize; n++)
        {
            sparsecreate(m, n, 1, &s, _state);
            sparseconverttocrs(&s, _state);
            if( (sparseishash(&s, _state)||!sparseiscrs(&s, _state))||sparsegetmatrixtype(&s, _state)!=1 )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
            sparseconverttohash(&s, _state);
            if( (!sparseishash(&s, _state)||sparseiscrs(&s, _state))||sparsegetmatrixtype(&s, _state)!=0 )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
            sparsecopytocrs(&s, &cs, _state);
            if( (sparseishash(&cs, _state)||!sparseiscrs(&cs, _state))||sparsegetmatrixtype(&cs, _state)!=1 )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
            sparsecopytohash(&cs, &s, _state);
            if( (!sparseishash(&s, _state)||sparseiscrs(&s, _state))||sparsegetmatrixtype(&s, _state)!=0 )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


void _sparsegenerator_init(void* _p, ae_state *_state, ae_bool make_automatic)
{
    sparsegenerator *p = (sparsegenerator*)_p;
    ae_touch_ptr((void*)p);
    ae_matrix_init(&p->bufa, 0, 0, DT_REAL, _state, make_automatic);
    _hqrndstate_init(&p->rs, _state, make_automatic);
    _rcommstate_init(&p->rcs, _state, make_automatic);
}


void _sparsegenerator_init_copy(void* _dst, void* _src, ae_state *_state, ae_bool make_automatic)
{
    sparsegenerator *dst = (sparsegenerator*)_dst;
    sparsegenerator *src = (sparsegenerator*)_src;
    dst->n = src->n;
    dst->m = src->m;
    dst->matkind = src->matkind;
    dst->triangle = src->triangle;
    ae_matrix_init_copy(&dst->bufa, &src->bufa, _state, make_automatic);
    _hqrndstate_init_copy(&dst->rs, &src->rs, _state, make_automatic);
    _rcommstate_init_copy(&dst->rcs, &src->rcs, _state, make_automatic);
}


void _sparsegenerator_clear(void* _p)
{
    sparsegenerator *p = (sparsegenerator*)_p;
    ae_touch_ptr((void*)p);
    ae_matrix_clear(&p->bufa);
    _hqrndstate_clear(&p->rs);
    _rcommstate_clear(&p->rcs);
}


void _sparsegenerator_destroy(void* _p)
{
    sparsegenerator *p = (sparsegenerator*)_p;
    ae_touch_ptr((void*)p);
    ae_matrix_destroy(&p->bufa);
    _hqrndstate_destroy(&p->rs);
    _rcommstate_destroy(&p->rcs);
}



static void testblasunit_naivematrixmatrixmultiply(/* Real    */ ae_matrix* a,
     ae_int_t ai1,
     ae_int_t ai2,
     ae_int_t aj1,
     ae_int_t aj2,
     ae_bool transa,
     /* Real    */ ae_matrix* b,
     ae_int_t bi1,
     ae_int_t bi2,
     ae_int_t bj1,
     ae_int_t bj2,
     ae_bool transb,
     double alpha,
     /* Real    */ ae_matrix* c,
     ae_int_t ci1,
     ae_int_t ci2,
     ae_int_t cj1,
     ae_int_t cj2,
     double beta,
     ae_state *_state);





ae_bool testblas(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t pass;
    ae_int_t passcount;
    ae_int_t n;
    ae_int_t i;
    ae_int_t i1;
    ae_int_t i2;
    ae_int_t j;
    ae_int_t j1;
    ae_int_t j2;
    ae_int_t l;
    ae_int_t k;
    ae_int_t r;
    ae_int_t i3;
    ae_int_t j3;
    ae_int_t col1;
    ae_int_t col2;
    ae_int_t row1;
    ae_int_t row2;
    ae_vector x1;
    ae_vector x2;
    ae_matrix a;
    ae_matrix b;
    ae_matrix c1;
    ae_matrix c2;
    double err;
    double e1;
    double e2;
    double e3;
    double v;
    double scl1;
    double scl2;
    double scl3;
    ae_bool was1;
    ae_bool was2;
    ae_bool trans1;
    ae_bool trans2;
    double threshold;
    ae_bool n2errors;
    ae_bool hsnerrors;
    ae_bool amaxerrors;
    ae_bool mverrors;
    ae_bool iterrors;
    ae_bool cterrors;
    ae_bool mmerrors;
    ae_bool waserrors;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&x1, 0, sizeof(x1));
    memset(&x2, 0, sizeof(x2));
    memset(&a, 0, sizeof(a));
    memset(&b, 0, sizeof(b));
    memset(&c1, 0, sizeof(c1));
    memset(&c2, 0, sizeof(c2));
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x2, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c2, 0, 0, DT_REAL, _state, ae_true);

    n2errors = ae_false;
    amaxerrors = ae_false;
    hsnerrors = ae_false;
    mverrors = ae_false;
    iterrors = ae_false;
    cterrors = ae_false;
    mmerrors = ae_false;
    waserrors = ae_false;
    threshold = 10000*ae_machineepsilon;
    
    /*
     * Test Norm2
     */
    passcount = 1000;
    e1 = (double)(0);
    e2 = (double)(0);
    e3 = (double)(0);
    scl2 = 0.5*ae_maxrealnumber;
    scl3 = 2*ae_minrealnumber;
    for(pass=1; pass<=passcount; pass++)
    {
        n = 1+ae_randominteger(1000, _state);
        i1 = ae_randominteger(10, _state);
        i2 = n+i1-1;
        ae_vector_set_length(&x1, i2+1, _state);
        ae_vector_set_length(&x2, i2+1, _state);
        for(i=i1; i<=i2; i++)
        {
            x1.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        v = (double)(0);
        for(i=i1; i<=i2; i++)
        {
            v = v+ae_sqr(x1.ptr.p_double[i], _state);
        }
        v = ae_sqrt(v, _state);
        e1 = ae_maxreal(e1, ae_fabs(v-vectornorm2(&x1, i1, i2, _state), _state), _state);
        for(i=i1; i<=i2; i++)
        {
            x2.ptr.p_double[i] = scl2*x1.ptr.p_double[i];
        }
        e2 = ae_maxreal(e2, ae_fabs(v*scl2-vectornorm2(&x2, i1, i2, _state), _state), _state);
        for(i=i1; i<=i2; i++)
        {
            x2.ptr.p_double[i] = scl3*x1.ptr.p_double[i];
        }
        e3 = ae_maxreal(e3, ae_fabs(v*scl3-vectornorm2(&x2, i1, i2, _state), _state), _state);
    }
    e2 = e2/scl2;
    e3 = e3/scl3;
    n2errors = (ae_fp_greater_eq(e1,threshold)||ae_fp_greater_eq(e2,threshold))||ae_fp_greater_eq(e3,threshold);
    
    /*
     * Testing VectorAbsMax, Column/Row AbsMax
     */
    ae_vector_set_length(&x1, 5+1, _state);
    x1.ptr.p_double[1] = 2.0;
    x1.ptr.p_double[2] = 0.2;
    x1.ptr.p_double[3] = -1.3;
    x1.ptr.p_double[4] = 0.7;
    x1.ptr.p_double[5] = -3.0;
    amaxerrors = (vectoridxabsmax(&x1, 1, 5, _state)!=5||vectoridxabsmax(&x1, 1, 4, _state)!=1)||vectoridxabsmax(&x1, 2, 4, _state)!=3;
    n = 30;
    ae_vector_set_length(&x1, n+1, _state);
    ae_matrix_set_length(&a, n+1, n+1, _state);
    for(i=1; i<=n; i++)
    {
        for(j=1; j<=n; j++)
        {
            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
        }
    }
    was1 = ae_false;
    was2 = ae_false;
    for(pass=1; pass<=1000; pass++)
    {
        j = 1+ae_randominteger(n, _state);
        i1 = 1+ae_randominteger(n, _state);
        i2 = i1+ae_randominteger(n+1-i1, _state);
        ae_v_move(&x1.ptr.p_double[i1], 1, &a.ptr.pp_double[i1][j], a.stride, ae_v_len(i1,i2));
        if( vectoridxabsmax(&x1, i1, i2, _state)!=columnidxabsmax(&a, i1, i2, j, _state) )
        {
            was1 = ae_true;
        }
        i = 1+ae_randominteger(n, _state);
        j1 = 1+ae_randominteger(n, _state);
        j2 = j1+ae_randominteger(n+1-j1, _state);
        ae_v_move(&x1.ptr.p_double[j1], 1, &a.ptr.pp_double[i][j1], 1, ae_v_len(j1,j2));
        if( vectoridxabsmax(&x1, j1, j2, _state)!=rowidxabsmax(&a, j1, j2, i, _state) )
        {
            was2 = ae_true;
        }
    }
    amaxerrors = (amaxerrors||was1)||was2;
    
    /*
     * Testing upper Hessenberg 1-norm
     */
    ae_matrix_set_length(&a, 3+1, 3+1, _state);
    ae_vector_set_length(&x1, 3+1, _state);
    a.ptr.pp_double[1][1] = (double)(2);
    a.ptr.pp_double[1][2] = (double)(3);
    a.ptr.pp_double[1][3] = (double)(1);
    a.ptr.pp_double[2][1] = (double)(4);
    a.ptr.pp_double[2][2] = (double)(-5);
    a.ptr.pp_double[2][3] = (double)(8);
    a.ptr.pp_double[3][1] = (double)(99);
    a.ptr.pp_double[3][2] = (double)(3);
    a.ptr.pp_double[3][3] = (double)(1);
    hsnerrors = ae_fp_greater(ae_fabs(upperhessenberg1norm(&a, 1, 3, 1, 3, &x1, _state)-11, _state),threshold);
    
    /*
     * Testing MatrixVectorMultiply
     */
    ae_matrix_set_length(&a, 3+1, 5+1, _state);
    ae_vector_set_length(&x1, 3+1, _state);
    ae_vector_set_length(&x2, 2+1, _state);
    a.ptr.pp_double[2][3] = (double)(2);
    a.ptr.pp_double[2][4] = (double)(-1);
    a.ptr.pp_double[2][5] = (double)(-1);
    a.ptr.pp_double[3][3] = (double)(1);
    a.ptr.pp_double[3][4] = (double)(-2);
    a.ptr.pp_double[3][5] = (double)(2);
    x1.ptr.p_double[1] = (double)(1);
    x1.ptr.p_double[2] = (double)(2);
    x1.ptr.p_double[3] = (double)(1);
    x2.ptr.p_double[1] = (double)(-1);
    x2.ptr.p_double[2] = (double)(-1);
    matrixvectormultiply(&a, 2, 3, 3, 5, ae_false, &x1, 1, 3, 1.0, &x2, 1, 2, 1.0, _state);
    matrixvectormultiply(&a, 2, 3, 3, 5, ae_true, &x2, 1, 2, 1.0, &x1, 1, 3, 1.0, _state);
    e1 = ae_fabs(x1.ptr.p_double[1]+5, _state)+ae_fabs(x1.ptr.p_double[2]-8, _state)+ae_fabs(x1.ptr.p_double[3]+1, _state)+ae_fabs(x2.ptr.p_double[1]+2, _state)+ae_fabs(x2.ptr.p_double[2]+2, _state);
    x1.ptr.p_double[1] = (double)(1);
    x1.ptr.p_double[2] = (double)(2);
    x1.ptr.p_double[3] = (double)(1);
    x2.ptr.p_double[1] = (double)(-1);
    x2.ptr.p_double[2] = (double)(-1);
    matrixvectormultiply(&a, 2, 3, 3, 5, ae_false, &x1, 1, 3, 1.0, &x2, 1, 2, 0.0, _state);
    matrixvectormultiply(&a, 2, 3, 3, 5, ae_true, &x2, 1, 2, 1.0, &x1, 1, 3, 0.0, _state);
    e2 = ae_fabs(x1.ptr.p_double[1]+3, _state)+ae_fabs(x1.ptr.p_double[2]-3, _state)+ae_fabs(x1.ptr.p_double[3]+1, _state)+ae_fabs(x2.ptr.p_double[1]+1, _state)+ae_fabs(x2.ptr.p_double[2]+1, _state);
    mverrors = ae_fp_greater_eq(e1+e2,threshold);
    
    /*
     * testing inplace transpose
     */
    n = 10;
    ae_matrix_set_length(&a, n+1, n+1, _state);
    ae_matrix_set_length(&b, n+1, n+1, _state);
    ae_vector_set_length(&x1, n-1+1, _state);
    for(i=1; i<=n; i++)
    {
        for(j=1; j<=n; j++)
        {
            a.ptr.pp_double[i][j] = ae_randomreal(_state);
        }
    }
    passcount = 10000;
    was1 = ae_false;
    for(pass=1; pass<=passcount; pass++)
    {
        i1 = 1+ae_randominteger(n, _state);
        i2 = i1+ae_randominteger(n-i1+1, _state);
        j1 = 1+ae_randominteger(n-(i2-i1), _state);
        j2 = j1+(i2-i1);
        copymatrix(&a, i1, i2, j1, j2, &b, i1, i2, j1, j2, _state);
        inplacetranspose(&b, i1, i2, j1, j2, &x1, _state);
        for(i=i1; i<=i2; i++)
        {
            for(j=j1; j<=j2; j++)
            {
                if( ae_fp_neq(a.ptr.pp_double[i][j],b.ptr.pp_double[i1+(j-j1)][j1+(i-i1)]) )
                {
                    was1 = ae_true;
                }
            }
        }
    }
    iterrors = was1;
    
    /*
     * testing copy and transpose
     */
    n = 10;
    ae_matrix_set_length(&a, n+1, n+1, _state);
    ae_matrix_set_length(&b, n+1, n+1, _state);
    for(i=1; i<=n; i++)
    {
        for(j=1; j<=n; j++)
        {
            a.ptr.pp_double[i][j] = ae_randomreal(_state);
        }
    }
    passcount = 10000;
    was1 = ae_false;
    for(pass=1; pass<=passcount; pass++)
    {
        i1 = 1+ae_randominteger(n, _state);
        i2 = i1+ae_randominteger(n-i1+1, _state);
        j1 = 1+ae_randominteger(n, _state);
        j2 = j1+ae_randominteger(n-j1+1, _state);
        copyandtranspose(&a, i1, i2, j1, j2, &b, j1, j2, i1, i2, _state);
        for(i=i1; i<=i2; i++)
        {
            for(j=j1; j<=j2; j++)
            {
                if( ae_fp_neq(a.ptr.pp_double[i][j],b.ptr.pp_double[j][i]) )
                {
                    was1 = ae_true;
                }
            }
        }
    }
    cterrors = was1;
    
    /*
     * Testing MatrixMatrixMultiply
     */
    n = 10;
    ae_matrix_set_length(&a, 2*n+1, 2*n+1, _state);
    ae_matrix_set_length(&b, 2*n+1, 2*n+1, _state);
    ae_matrix_set_length(&c1, 2*n+1, 2*n+1, _state);
    ae_matrix_set_length(&c2, 2*n+1, 2*n+1, _state);
    ae_vector_set_length(&x1, n+1, _state);
    ae_vector_set_length(&x2, n+1, _state);
    for(i=1; i<=2*n; i++)
    {
        for(j=1; j<=2*n; j++)
        {
            a.ptr.pp_double[i][j] = ae_randomreal(_state);
            b.ptr.pp_double[i][j] = ae_randomreal(_state);
        }
    }
    passcount = 1000;
    was1 = ae_false;
    for(pass=1; pass<=passcount; pass++)
    {
        for(i=1; i<=2*n; i++)
        {
            for(j=1; j<=2*n; j++)
            {
                c1.ptr.pp_double[i][j] = 2.1*i+3.1*j;
                c2.ptr.pp_double[i][j] = c1.ptr.pp_double[i][j];
            }
        }
        l = 1+ae_randominteger(n, _state);
        k = 1+ae_randominteger(n, _state);
        r = 1+ae_randominteger(n, _state);
        i1 = 1+ae_randominteger(n, _state);
        j1 = 1+ae_randominteger(n, _state);
        i2 = 1+ae_randominteger(n, _state);
        j2 = 1+ae_randominteger(n, _state);
        i3 = 1+ae_randominteger(n, _state);
        j3 = 1+ae_randominteger(n, _state);
        trans1 = ae_fp_greater(ae_randomreal(_state),0.5);
        trans2 = ae_fp_greater(ae_randomreal(_state),0.5);
        if( trans1 )
        {
            col1 = l;
            row1 = k;
        }
        else
        {
            col1 = k;
            row1 = l;
        }
        if( trans2 )
        {
            col2 = k;
            row2 = r;
        }
        else
        {
            col2 = r;
            row2 = k;
        }
        scl1 = ae_randomreal(_state);
        scl2 = ae_randomreal(_state);
        matrixmatrixmultiply(&a, i1, i1+row1-1, j1, j1+col1-1, trans1, &b, i2, i2+row2-1, j2, j2+col2-1, trans2, scl1, &c1, i3, i3+l-1, j3, j3+r-1, scl2, &x1, _state);
        testblasunit_naivematrixmatrixmultiply(&a, i1, i1+row1-1, j1, j1+col1-1, trans1, &b, i2, i2+row2-1, j2, j2+col2-1, trans2, scl1, &c2, i3, i3+l-1, j3, j3+r-1, scl2, _state);
        err = (double)(0);
        for(i=1; i<=l; i++)
        {
            for(j=1; j<=r; j++)
            {
                err = ae_maxreal(err, ae_fabs(c1.ptr.pp_double[i3+i-1][j3+j-1]-c2.ptr.pp_double[i3+i-1][j3+j-1], _state), _state);
            }
        }
        if( ae_fp_greater(err,threshold) )
        {
            was1 = ae_true;
            break;
        }
    }
    mmerrors = was1;
    
    /*
     * report
     */
    waserrors = (((((n2errors||amaxerrors)||hsnerrors)||mverrors)||iterrors)||cterrors)||mmerrors;
    if( !silent )
    {
        printf("TESTING BLAS\n");
        printf("VectorNorm2:                             ");
        if( n2errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("AbsMax (vector/row/column):              ");
        if( amaxerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("UpperHessenberg1Norm:                    ");
        if( hsnerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("MatrixVectorMultiply:                    ");
        if( mverrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("InplaceTranspose:                        ");
        if( iterrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("CopyAndTranspose:                        ");
        if( cterrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("MatrixMatrixMultiply:                    ");
        if( mmerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


static void testblasunit_naivematrixmatrixmultiply(/* Real    */ ae_matrix* a,
     ae_int_t ai1,
     ae_int_t ai2,
     ae_int_t aj1,
     ae_int_t aj2,
     ae_bool transa,
     /* Real    */ ae_matrix* b,
     ae_int_t bi1,
     ae_int_t bi2,
     ae_int_t bj1,
     ae_int_t bj2,
     ae_bool transb,
     double alpha,
     /* Real    */ ae_matrix* c,
     ae_int_t ci1,
     ae_int_t ci2,
     ae_int_t cj1,
     ae_int_t cj2,
     double beta,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t arows;
    ae_int_t acols;
    ae_int_t brows;
    ae_int_t bcols;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t l;
    ae_int_t r;
    double v;
    ae_vector x1;
    ae_vector x2;

    ae_frame_make(_state, &_frame_block);
    memset(&x1, 0, sizeof(x1));
    memset(&x2, 0, sizeof(x2));
    ae_vector_init(&x1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x2, 0, DT_REAL, _state, ae_true);

    
    /*
     * Setup
     */
    if( !transa )
    {
        arows = ai2-ai1+1;
        acols = aj2-aj1+1;
    }
    else
    {
        arows = aj2-aj1+1;
        acols = ai2-ai1+1;
    }
    if( !transb )
    {
        brows = bi2-bi1+1;
        bcols = bj2-bj1+1;
    }
    else
    {
        brows = bj2-bj1+1;
        bcols = bi2-bi1+1;
    }
    ae_assert(acols==brows, "NaiveMatrixMatrixMultiply: incorrect matrix sizes!", _state);
    if( ((arows<=0||acols<=0)||brows<=0)||bcols<=0 )
    {
        ae_frame_leave(_state);
        return;
    }
    l = arows;
    r = bcols;
    k = acols;
    ae_vector_set_length(&x1, k+1, _state);
    ae_vector_set_length(&x2, k+1, _state);
    for(i=1; i<=l; i++)
    {
        for(j=1; j<=r; j++)
        {
            if( !transa )
            {
                if( !transb )
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1][bj1+j-1], b->stride, &a->ptr.pp_double[ai1+i-1][aj1], 1, ae_v_len(bi1,bi2));
                }
                else
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1+j-1][bj1], 1, &a->ptr.pp_double[ai1+i-1][aj1], 1, ae_v_len(bj1,bj2));
                }
            }
            else
            {
                if( !transb )
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1][bj1+j-1], b->stride, &a->ptr.pp_double[ai1][aj1+i-1], a->stride, ae_v_len(bi1,bi2));
                }
                else
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1+j-1][bj1], 1, &a->ptr.pp_double[ai1][aj1+i-1], a->stride, ae_v_len(bj1,bj2));
                }
            }
            if( ae_fp_eq(beta,(double)(0)) )
            {
                c->ptr.pp_double[ci1+i-1][cj1+j-1] = alpha*v;
            }
            else
            {
                c->ptr.pp_double[ci1+i-1][cj1+j-1] = beta*c->ptr.pp_double[ci1+i-1][cj1+j-1]+alpha*v;
            }
        }
    }
    ae_frame_leave(_state);
}



static void testevdunit_rmatrixfillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     double diagmag,
     ae_state *_state);
static void testevdunit_cmatrixfillsparsea(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     double diagmag,
     ae_state *_state);
static void testevdunit_rmatrixsymmetricsplit(/* Real    */ ae_matrix* a,
     ae_int_t n,
     /* Real    */ ae_matrix* al,
     /* Real    */ ae_matrix* au,
     ae_state *_state);
static void testevdunit_cmatrixhermitiansplit(/* Complex */ ae_matrix* a,
     ae_int_t n,
     /* Complex */ ae_matrix* al,
     /* Complex */ ae_matrix* au,
     ae_state *_state);
static void testevdunit_unset2d(/* Real    */ ae_matrix* a,
     ae_state *_state);
static void testevdunit_cunset2d(/* Complex */ ae_matrix* a,
     ae_state *_state);
static void testevdunit_unset1d(/* Real    */ ae_vector* a,
     ae_state *_state);
static double testevdunit_tdtestproduct(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     /* Real    */ ae_matrix* z,
     /* Real    */ ae_vector* lambdav,
     ae_state *_state);
static double testevdunit_testproduct(/* Real    */ ae_matrix* a,
     ae_int_t n,
     /* Real    */ ae_matrix* z,
     /* Real    */ ae_vector* lambdav,
     ae_state *_state);
static double testevdunit_testort(/* Real    */ ae_matrix* z,
     ae_int_t n,
     ae_state *_state);
static double testevdunit_testcproduct(/* Complex */ ae_matrix* a,
     ae_int_t n,
     /* Complex */ ae_matrix* z,
     /* Real    */ ae_vector* lambdav,
     ae_state *_state);
static double testevdunit_testcort(/* Complex */ ae_matrix* z,
     ae_int_t n,
     ae_state *_state);
static void testevdunit_testsevdproblem(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* al,
     /* Real    */ ae_matrix* au,
     ae_int_t n,
     double threshold,
     ae_bool* serrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state);
static void testevdunit_testhevdproblem(/* Complex */ ae_matrix* a,
     /* Complex */ ae_matrix* al,
     /* Complex */ ae_matrix* au,
     ae_int_t n,
     double threshold,
     ae_bool* herrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state);
static void testevdunit_testsevdbiproblem(/* Real    */ ae_matrix* afull,
     /* Real    */ ae_matrix* al,
     /* Real    */ ae_matrix* au,
     ae_int_t n,
     ae_bool distvals,
     double threshold,
     ae_bool* serrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state);
static void testevdunit_testhevdbiproblem(/* Complex */ ae_matrix* afull,
     /* Complex */ ae_matrix* al,
     /* Complex */ ae_matrix* au,
     ae_int_t n,
     ae_bool distvals,
     double threshold,
     ae_bool* herrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state);
static void testevdunit_testtdevdproblem(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state);
static void testevdunit_testtdevdbiproblem(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool distvals,
     double threshold,
     ae_bool* serrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state);
static void testevdunit_testnsevdproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* nserrors,
     ae_state *_state);
static void testevdunit_testevdset(ae_int_t n,
     double threshold,
     double bithreshold,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_bool* nserrors,
     ae_bool* serrors,
     ae_bool* herrors,
     ae_bool* tderrors,
     ae_bool* sbierrors,
     ae_bool* hbierrors,
     ae_bool* tdbierrors,
     ae_state *_state);
static void testevdunit_testsisymm(ae_bool* errorflag, ae_state *_state);





/*************************************************************************
Testing symmetric EVD subroutine
*************************************************************************/
ae_bool testevd(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ra;
    ae_int_t n;
    ae_int_t j;
    ae_int_t failc;
    ae_int_t runs;
    double failthreshold;
    double threshold;
    double bithreshold;
    ae_bool waserrors;
    ae_bool nserrors;
    ae_bool serrors;
    ae_bool herrors;
    ae_bool tderrors;
    ae_bool sbierrors;
    ae_bool hbierrors;
    ae_bool tdbierrors;
    ae_bool sisymmerrors;
    ae_bool wfailed;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&ra, 0, sizeof(ra));
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);

    failthreshold = 0.005;
    threshold = 1.0E-8;
    bithreshold = 1.0E-6;
    nserrors = ae_false;
    serrors = ae_false;
    herrors = ae_false;
    tderrors = ae_false;
    sbierrors = ae_false;
    hbierrors = ae_false;
    tdbierrors = ae_false;
    sisymmerrors = ae_false;
    failc = 0;
    runs = 0;
    
    /*
     * Test subspace iteration solver
     */
    testevdunit_testsisymm(&sisymmerrors, _state);
    
    /*
     * Test dense solvers
     */
    for(n=1; n<=ablasblocksize(&ra, _state); n++)
    {
        testevdunit_testevdset(n, threshold, bithreshold, &failc, &runs, &nserrors, &serrors, &herrors, &tderrors, &sbierrors, &hbierrors, &tdbierrors, _state);
    }
    for(j=2; j<=3; j++)
    {
        for(n=j*ablasblocksize(&ra, _state)-1; n<=j*ablasblocksize(&ra, _state)+1; n++)
        {
            testevdunit_testevdset(n, threshold, bithreshold, &failc, &runs, &nserrors, &serrors, &herrors, &tderrors, &sbierrors, &hbierrors, &tdbierrors, _state);
        }
    }
    
    /*
     * report
     */
    wfailed = ae_fp_greater((double)failc/(double)runs,failthreshold);
    waserrors = (((((((nserrors||serrors)||herrors)||tderrors)||sbierrors)||hbierrors)||tdbierrors)||wfailed)||sisymmerrors;
    if( !silent )
    {
        printf("TESTING EVD UNIT\n");
        printf("DENSE DIRECT SOLVERS:\n");
        printf("* NS                                     ");
        if( !nserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* S                                      ");
        if( !serrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* H                                      ");
        if( !herrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* TD                                     ");
        if( !tderrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* SBI                                    ");
        if( !sbierrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* HBI                                    ");
        if( !hbierrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* TDBI                                   ");
        if( !tdbierrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* FAILURE THRESHOLD                      ");
        if( !wfailed )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("ITERATIVE SOLVERS:\n");
        printf("* SUBSPACE ITERATION (S)                 ");
        if( !sisymmerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Sparse fill

Sparcity - sparcity level, in [0,1] (0=dense matrix).
DiagMAg - magnitude of dense diagonal entries; zero value means that diagonal
is sparse too, non-zero value means that diagonal is dense
*************************************************************************/
static void testevdunit_rmatrixfillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     double diagmag,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
            {
                a->ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
            else
            {
                a->ptr.pp_double[i][j] = (double)(0);
            }
        }
    }
    if( ae_fp_greater(diagmag,(double)(0)) )
    {
        for(i=0; i<=ae_minint(m, n, _state)-1; i++)
        {
            a->ptr.pp_double[i][i] = diagmag*(2*ae_randomreal(_state)-1);
        }
    }
}


/*************************************************************************
Sparse fill

Sparcity - sparcity level, in [0,1] (0=dense matrix).
DiagMAg - magnitude of dense diagonal entries; zero value means that diagonal
is sparse too, non-zero value means that diagonal is dense
*************************************************************************/
static void testevdunit_cmatrixfillsparsea(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     double diagmag,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
            {
                a->ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                a->ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
            else
            {
                a->ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
    }
    if( ae_fp_greater(diagmag,(double)(0)) )
    {
        for(i=0; i<=ae_minint(m, n, _state)-1; i++)
        {
            a->ptr.pp_complex[i][i].x = diagmag*(2*ae_randomreal(_state)-1);
            a->ptr.pp_complex[i][i].y = diagmag*(2*ae_randomreal(_state)-1);
        }
    }
}


/*************************************************************************
Copies A to AL (lower half) and AU (upper half), filling unused parts by
random garbage.
*************************************************************************/
static void testevdunit_rmatrixsymmetricsplit(/* Real    */ ae_matrix* a,
     ae_int_t n,
     /* Real    */ ae_matrix* al,
     /* Real    */ ae_matrix* au,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=i+1; j<=n-1; j++)
        {
            al->ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            al->ptr.pp_double[j][i] = a->ptr.pp_double[i][j];
            au->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
            au->ptr.pp_double[j][i] = 2*ae_randomreal(_state)-1;
        }
        al->ptr.pp_double[i][i] = a->ptr.pp_double[i][i];
        au->ptr.pp_double[i][i] = a->ptr.pp_double[i][i];
    }
}


/*************************************************************************
Copies A to AL (lower half) and AU (upper half), filling unused parts by
random garbage.
*************************************************************************/
static void testevdunit_cmatrixhermitiansplit(/* Complex */ ae_matrix* a,
     ae_int_t n,
     /* Complex */ ae_matrix* al,
     /* Complex */ ae_matrix* au,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=i+1; j<=n-1; j++)
        {
            al->ptr.pp_complex[i][j] = ae_complex_from_d(2*ae_randomreal(_state)-1);
            al->ptr.pp_complex[j][i] = ae_c_conj(a->ptr.pp_complex[i][j], _state);
            au->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
            au->ptr.pp_complex[j][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
        }
        al->ptr.pp_complex[i][i] = a->ptr.pp_complex[i][i];
        au->ptr.pp_complex[i][i] = a->ptr.pp_complex[i][i];
    }
}


/*************************************************************************
Unsets 2D array.
*************************************************************************/
static void testevdunit_unset2d(/* Real    */ ae_matrix* a,
     ae_state *_state)
{

    ae_matrix_clear(a);

    if( a->rows*a->cols>0 )
    {
        ae_matrix_set_length(a, 1, 1, _state);
    }
}


/*************************************************************************
Unsets 2D array.
*************************************************************************/
static void testevdunit_cunset2d(/* Complex */ ae_matrix* a,
     ae_state *_state)
{


    ae_matrix_set_length(a, 0+1, 0+1, _state);
    a->ptr.pp_complex[0][0] = ae_complex_from_d(2*ae_randomreal(_state)-1);
}


/*************************************************************************
Unsets 1D array.
*************************************************************************/
static void testevdunit_unset1d(/* Real    */ ae_vector* a,
     ae_state *_state)
{

    ae_vector_clear(a);

    if( a->cnt>0 )
    {
        ae_vector_set_length(a, 1, _state);
    }
}


/*************************************************************************
Tests Z*Lambda*Z' against tridiag(D,E).
Returns relative error.
*************************************************************************/
static double testevdunit_tdtestproduct(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     /* Real    */ ae_matrix* z,
     /* Real    */ ae_vector* lambdav,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double v;
    double mx;
    double result;


    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            
            /*
             * Calculate V = A[i,j], A = Z*Lambda*Z'
             */
            v = (double)(0);
            for(k=0; k<=n-1; k++)
            {
                v = v+z->ptr.pp_double[i][k]*lambdav->ptr.p_double[k]*z->ptr.pp_double[j][k];
            }
            
            /*
             * Compare
             */
            if( ae_iabs(i-j, _state)==0 )
            {
                result = ae_maxreal(result, ae_fabs(v-d->ptr.p_double[i], _state), _state);
            }
            if( ae_iabs(i-j, _state)==1 )
            {
                result = ae_maxreal(result, ae_fabs(v-e->ptr.p_double[ae_minint(i, j, _state)], _state), _state);
            }
            if( ae_iabs(i-j, _state)>1 )
            {
                result = ae_maxreal(result, ae_fabs(v, _state), _state);
            }
        }
    }
    mx = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        mx = ae_maxreal(mx, ae_fabs(d->ptr.p_double[i], _state), _state);
    }
    for(i=0; i<=n-2; i++)
    {
        mx = ae_maxreal(mx, ae_fabs(e->ptr.p_double[i], _state), _state);
    }
    if( ae_fp_eq(mx,(double)(0)) )
    {
        mx = (double)(1);
    }
    result = result/mx;
    return result;
}


/*************************************************************************
Tests Z*Lambda*Z' against A
Returns relative error.
*************************************************************************/
static double testevdunit_testproduct(/* Real    */ ae_matrix* a,
     ae_int_t n,
     /* Real    */ ae_matrix* z,
     /* Real    */ ae_vector* lambdav,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double v;
    double mx;
    double result;


    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            
            /*
             * Calculate V = A[i,j], A = Z*Lambda*Z'
             */
            v = (double)(0);
            for(k=0; k<=n-1; k++)
            {
                v = v+z->ptr.pp_double[i][k]*lambdav->ptr.p_double[k]*z->ptr.pp_double[j][k];
            }
            
            /*
             * Compare
             */
            result = ae_maxreal(result, ae_fabs(v-a->ptr.pp_double[i][j], _state), _state);
        }
    }
    mx = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            mx = ae_maxreal(mx, ae_fabs(a->ptr.pp_double[i][j], _state), _state);
        }
    }
    if( ae_fp_eq(mx,(double)(0)) )
    {
        mx = (double)(1);
    }
    result = result/mx;
    return result;
}


/*************************************************************************
Tests Z*Z' against diag(1...1)
Returns absolute error.
*************************************************************************/
static double testevdunit_testort(/* Real    */ ae_matrix* z,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    double v;
    double result;


    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&z->ptr.pp_double[0][i], z->stride, &z->ptr.pp_double[0][j], z->stride, ae_v_len(0,n-1));
            if( i==j )
            {
                v = v-1;
            }
            result = ae_maxreal(result, ae_fabs(v, _state), _state);
        }
    }
    return result;
}


/*************************************************************************
Tests Z*Lambda*Z' against A
Returns relative error.
*************************************************************************/
static double testevdunit_testcproduct(/* Complex */ ae_matrix* a,
     ae_int_t n,
     /* Complex */ ae_matrix* z,
     /* Real    */ ae_vector* lambdav,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_complex v;
    double mx;
    double result;


    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            
            /*
             * Calculate V = A[i,j], A = Z*Lambda*Z'
             */
            v = ae_complex_from_i(0);
            for(k=0; k<=n-1; k++)
            {
                v = ae_c_add(v,ae_c_mul(ae_c_mul_d(z->ptr.pp_complex[i][k],lambdav->ptr.p_double[k]),ae_c_conj(z->ptr.pp_complex[j][k], _state)));
            }
            
            /*
             * Compare
             */
            result = ae_maxreal(result, ae_c_abs(ae_c_sub(v,a->ptr.pp_complex[i][j]), _state), _state);
        }
    }
    mx = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            mx = ae_maxreal(mx, ae_c_abs(a->ptr.pp_complex[i][j], _state), _state);
        }
    }
    if( ae_fp_eq(mx,(double)(0)) )
    {
        mx = (double)(1);
    }
    result = result/mx;
    return result;
}


/*************************************************************************
Tests Z*Z' against diag(1...1)
Returns absolute error.
*************************************************************************/
static double testevdunit_testcort(/* Complex */ ae_matrix* z,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_complex v;
    double result;


    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&z->ptr.pp_complex[0][i], z->stride, "N", &z->ptr.pp_complex[0][j], z->stride, "Conj", ae_v_len(0,n-1));
            if( i==j )
            {
                v = ae_c_sub_d(v,1);
            }
            result = ae_maxreal(result, ae_c_abs(v, _state), _state);
        }
    }
    return result;
}


/*************************************************************************
Tests SEVD problem
*************************************************************************/
static void testevdunit_testsevdproblem(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* al,
     /* Real    */ ae_matrix* au,
     ae_int_t n,
     double threshold,
     ae_bool* serrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector lambdav;
    ae_vector lambdaref;
    ae_matrix z;
    ae_int_t i;

    ae_frame_make(_state, &_frame_block);
    memset(&lambdav, 0, sizeof(lambdav));
    memset(&lambdaref, 0, sizeof(lambdaref));
    memset(&z, 0, sizeof(z));
    ae_vector_init(&lambdav, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&lambdaref, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&z, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * Test simple EVD: values and full vectors, lower A
     */
    testevdunit_unset1d(&lambdaref, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevd(al, n, 1, ae_false, &lambdaref, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    *serrors = *serrors||ae_fp_greater(testevdunit_testproduct(a, n, &z, &lambdaref, _state),threshold);
    *serrors = *serrors||ae_fp_greater(testevdunit_testort(&z, n, _state),threshold);
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_less(lambdaref.ptr.p_double[i+1],lambdaref.ptr.p_double[i]) )
        {
            *serrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    
    /*
     * Test simple EVD: values and full vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevd(au, n, 1, ae_true, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    *serrors = *serrors||ae_fp_greater(testevdunit_testproduct(a, n, &z, &lambdav, _state),threshold);
    *serrors = *serrors||ae_fp_greater(testevdunit_testort(&z, n, _state),threshold);
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_less(lambdav.ptr.p_double[i+1],lambdav.ptr.p_double[i]) )
        {
            *serrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    
    /*
     * Test simple EVD: values only, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevd(al, n, 0, ae_false, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(i=0; i<=n-1; i++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[i]-lambdaref.ptr.p_double[i], _state),threshold);
    }
    
    /*
     * Test simple EVD: values only, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevd(au, n, 0, ae_true, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(i=0; i<=n-1; i++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[i]-lambdaref.ptr.p_double[i], _state),threshold);
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Tests SEVD problem
*************************************************************************/
static void testevdunit_testhevdproblem(/* Complex */ ae_matrix* a,
     /* Complex */ ae_matrix* al,
     /* Complex */ ae_matrix* au,
     ae_int_t n,
     double threshold,
     ae_bool* herrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector lambdav;
    ae_vector lambdaref;
    ae_matrix z;
    ae_int_t i;

    ae_frame_make(_state, &_frame_block);
    memset(&lambdav, 0, sizeof(lambdav));
    memset(&lambdaref, 0, sizeof(lambdaref));
    memset(&z, 0, sizeof(z));
    ae_vector_init(&lambdav, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&lambdaref, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&z, 0, 0, DT_COMPLEX, _state, ae_true);

    
    /*
     * Test simple EVD: values and full vectors, lower A
     */
    testevdunit_unset1d(&lambdaref, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevd(al, n, 1, ae_false, &lambdaref, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    *herrors = *herrors||ae_fp_greater(testevdunit_testcproduct(a, n, &z, &lambdaref, _state),threshold);
    *herrors = *herrors||ae_fp_greater(testevdunit_testcort(&z, n, _state),threshold);
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_less(lambdaref.ptr.p_double[i+1],lambdaref.ptr.p_double[i]) )
        {
            *herrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    
    /*
     * Test simple EVD: values and full vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevd(au, n, 1, ae_true, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    *herrors = *herrors||ae_fp_greater(testevdunit_testcproduct(a, n, &z, &lambdav, _state),threshold);
    *herrors = *herrors||ae_fp_greater(testevdunit_testcort(&z, n, _state),threshold);
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_less(lambdav.ptr.p_double[i+1],lambdav.ptr.p_double[i]) )
        {
            *herrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    
    /*
     * Test simple EVD: values only, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevd(al, n, 0, ae_false, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(i=0; i<=n-1; i++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[i]-lambdaref.ptr.p_double[i], _state),threshold);
    }
    
    /*
     * Test simple EVD: values only, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevd(au, n, 0, ae_true, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(i=0; i<=n-1; i++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[i]-lambdaref.ptr.p_double[i], _state),threshold);
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Tests EVD problem

DistVals    -   is True, when eigenvalues are distinct. Is False, when we
                are solving sparse task with  lots  of  zero  eigenvalues.
                In such cases some tests related to the  eigenvectors  are
                not performed.
*************************************************************************/
static void testevdunit_testsevdbiproblem(/* Real    */ ae_matrix* afull,
     /* Real    */ ae_matrix* al,
     /* Real    */ ae_matrix* au,
     ae_int_t n,
     ae_bool distvals,
     double threshold,
     ae_bool* serrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector lambdav;
    ae_vector lambdaref;
    ae_matrix z;
    ae_matrix zref;
    ae_matrix a1;
    ae_matrix a2;
    ae_matrix ar;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t m;
    ae_int_t i1;
    ae_int_t i2;
    double v;
    double a;
    double b;

    ae_frame_make(_state, &_frame_block);
    memset(&lambdav, 0, sizeof(lambdav));
    memset(&lambdaref, 0, sizeof(lambdaref));
    memset(&z, 0, sizeof(z));
    memset(&zref, 0, sizeof(zref));
    memset(&a1, 0, sizeof(a1));
    memset(&a2, 0, sizeof(a2));
    memset(&ar, 0, sizeof(ar));
    ae_vector_init(&lambdav, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&lambdaref, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&z, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&zref, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ar, 0, 0, DT_REAL, _state, ae_true);

    ae_vector_set_length(&lambdaref, n-1+1, _state);
    ae_matrix_set_length(&zref, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a1, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a2, n-1+1, n-1+1, _state);
    
    /*
     * Reference EVD
     */
    *runs = *runs+1;
    if( !smatrixevd(afull, n, 1, ae_true, &lambdaref, &zref, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * Select random interval boundaries.
     * If there are non-distinct eigenvalues at the boundaries,
     * we move indexes further until values splits. It is done to
     * avoid situations where we can't get definite answer.
     */
    i1 = ae_randominteger(n, _state);
    i2 = i1+ae_randominteger(n-i1, _state);
    while(i1>0)
    {
        if( ae_fp_greater(ae_fabs(lambdaref.ptr.p_double[i1-1]-lambdaref.ptr.p_double[i1], _state),10*threshold) )
        {
            break;
        }
        i1 = i1-1;
    }
    while(i2<n-1)
    {
        if( ae_fp_greater(ae_fabs(lambdaref.ptr.p_double[i2+1]-lambdaref.ptr.p_double[i2], _state),10*threshold) )
        {
            break;
        }
        i2 = i2+1;
    }
    
    /*
     * Select A, B
     */
    if( i1>0 )
    {
        a = 0.5*(lambdaref.ptr.p_double[i1]+lambdaref.ptr.p_double[i1-1]);
    }
    else
    {
        a = lambdaref.ptr.p_double[0]-1;
    }
    if( i2<n-1 )
    {
        b = 0.5*(lambdaref.ptr.p_double[i2]+lambdaref.ptr.p_double[i2+1]);
    }
    else
    {
        b = lambdaref.ptr.p_double[n-1]+1;
    }
    
    /*
     * Test interval, no vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdr(al, n, 0, ae_false, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test interval, no vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdr(au, n, 0, ae_true, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test indexes, no vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdi(al, n, 0, ae_false, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test indexes, no vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdi(au, n, 0, ae_true, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test interval, vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdr(al, n, 1, ae_false, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&z.ptr.pp_double[0][j], z.stride, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&z.ptr.pp_double[0][j], z.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(z.ptr.pp_double[i][j]-zref.ptr.pp_double[i][i1+j], _state),threshold);
            }
        }
    }
    
    /*
     * Test interval, vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdr(au, n, 1, ae_true, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&z.ptr.pp_double[0][j], z.stride, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&z.ptr.pp_double[0][j], z.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(z.ptr.pp_double[i][j]-zref.ptr.pp_double[i][i1+j], _state),threshold);
            }
        }
    }
    
    /*
     * Test indexes, vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdi(al, n, 1, ae_false, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&z.ptr.pp_double[0][j], z.stride, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&z.ptr.pp_double[0][j], z.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(z.ptr.pp_double[i][j]-zref.ptr.pp_double[i][i1+j], _state),threshold);
            }
        }
    }
    
    /*
     * Test indexes, vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdi(au, n, 1, ae_true, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&z.ptr.pp_double[0][j], z.stride, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&z.ptr.pp_double[0][j], z.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(z.ptr.pp_double[i][j]-zref.ptr.pp_double[i][i1+j], _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Tests EVD problem

DistVals    -   is True, when eigenvalues are distinct. Is False, when we
                are solving sparse task with  lots  of  zero  eigenvalues.
                In such cases some tests related to the  eigenvectors  are
                not performed.
*************************************************************************/
static void testevdunit_testhevdbiproblem(/* Complex */ ae_matrix* afull,
     /* Complex */ ae_matrix* al,
     /* Complex */ ae_matrix* au,
     ae_int_t n,
     ae_bool distvals,
     double threshold,
     ae_bool* herrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector lambdav;
    ae_vector lambdaref;
    ae_matrix z;
    ae_matrix zref;
    ae_matrix a1;
    ae_matrix a2;
    ae_matrix ar;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t m;
    ae_int_t i1;
    ae_int_t i2;
    ae_complex v;
    double a;
    double b;

    ae_frame_make(_state, &_frame_block);
    memset(&lambdav, 0, sizeof(lambdav));
    memset(&lambdaref, 0, sizeof(lambdaref));
    memset(&z, 0, sizeof(z));
    memset(&zref, 0, sizeof(zref));
    memset(&a1, 0, sizeof(a1));
    memset(&a2, 0, sizeof(a2));
    memset(&ar, 0, sizeof(ar));
    ae_vector_init(&lambdav, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&lambdaref, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&z, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&zref, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&a1, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&a2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ar, 0, 0, DT_COMPLEX, _state, ae_true);

    ae_vector_set_length(&lambdaref, n-1+1, _state);
    ae_matrix_set_length(&zref, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a1, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a2, n-1+1, n-1+1, _state);
    
    /*
     * Reference EVD
     */
    *runs = *runs+1;
    if( !hmatrixevd(afull, n, 1, ae_true, &lambdaref, &zref, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * Select random interval boundaries.
     * If there are non-distinct eigenvalues at the boundaries,
     * we move indexes further until values splits. It is done to
     * avoid situations where we can't get definite answer.
     */
    i1 = ae_randominteger(n, _state);
    i2 = i1+ae_randominteger(n-i1, _state);
    while(i1>0)
    {
        if( ae_fp_greater(ae_fabs(lambdaref.ptr.p_double[i1-1]-lambdaref.ptr.p_double[i1], _state),10*threshold) )
        {
            break;
        }
        i1 = i1-1;
    }
    while(i2<n-1)
    {
        if( ae_fp_greater(ae_fabs(lambdaref.ptr.p_double[i2+1]-lambdaref.ptr.p_double[i2], _state),10*threshold) )
        {
            break;
        }
        i2 = i2+1;
    }
    
    /*
     * Select A, B
     */
    if( i1>0 )
    {
        a = 0.5*(lambdaref.ptr.p_double[i1]+lambdaref.ptr.p_double[i1-1]);
    }
    else
    {
        a = lambdaref.ptr.p_double[0]-1;
    }
    if( i2<n-1 )
    {
        b = 0.5*(lambdaref.ptr.p_double[i2]+lambdaref.ptr.p_double[i2+1]);
    }
    else
    {
        b = lambdaref.ptr.p_double[n-1]+1;
    }
    
    /*
     * Test interval, no vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdr(al, n, 0, ae_false, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test interval, no vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdr(au, n, 0, ae_true, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test indexes, no vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdi(al, n, 0, ae_false, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test indexes, no vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdi(au, n, 0, ae_true, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test interval, vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdr(al, n, 1, ae_false, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_cdotproduct(&z.ptr.pp_complex[0][j], z.stride, "N", &zref.ptr.pp_complex[0][i1+j], zref.stride, "Conj", ae_v_len(0,n-1));
            v = ae_c_conj(ae_c_div_d(v,ae_c_abs(v, _state)), _state);
            ae_v_cmulc(&z.ptr.pp_complex[0][j], z.stride, ae_v_len(0,n-1), v);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *herrors = *herrors||ae_fp_greater(ae_c_abs(ae_c_sub(z.ptr.pp_complex[i][j],zref.ptr.pp_complex[i][i1+j]), _state),threshold);
            }
        }
    }
    
    /*
     * Test interval, vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdr(au, n, 1, ae_true, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_cdotproduct(&z.ptr.pp_complex[0][j], z.stride, "N", &zref.ptr.pp_complex[0][i1+j], zref.stride, "Conj", ae_v_len(0,n-1));
            v = ae_c_conj(ae_c_div_d(v,ae_c_abs(v, _state)), _state);
            ae_v_cmulc(&z.ptr.pp_complex[0][j], z.stride, ae_v_len(0,n-1), v);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *herrors = *herrors||ae_fp_greater(ae_c_abs(ae_c_sub(z.ptr.pp_complex[i][j],zref.ptr.pp_complex[i][i1+j]), _state),threshold);
            }
        }
    }
    
    /*
     * Test indexes, vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdi(al, n, 1, ae_false, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_cdotproduct(&z.ptr.pp_complex[0][j], z.stride, "N", &zref.ptr.pp_complex[0][i1+j], zref.stride, "Conj", ae_v_len(0,n-1));
            v = ae_c_conj(ae_c_div_d(v,ae_c_abs(v, _state)), _state);
            ae_v_cmulc(&z.ptr.pp_complex[0][j], z.stride, ae_v_len(0,n-1), v);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *herrors = *herrors||ae_fp_greater(ae_c_abs(ae_c_sub(z.ptr.pp_complex[i][j],zref.ptr.pp_complex[i][i1+j]), _state),threshold);
            }
        }
    }
    
    /*
     * Test indexes, vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdi(au, n, 1, ae_true, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_cdotproduct(&z.ptr.pp_complex[0][j], z.stride, "N", &zref.ptr.pp_complex[0][i1+j], zref.stride, "Conj", ae_v_len(0,n-1));
            v = ae_c_conj(ae_c_div_d(v,ae_c_abs(v, _state)), _state);
            ae_v_cmulc(&z.ptr.pp_complex[0][j], z.stride, ae_v_len(0,n-1), v);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *herrors = *herrors||ae_fp_greater(ae_c_abs(ae_c_sub(z.ptr.pp_complex[i][j],zref.ptr.pp_complex[i][i1+j]), _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Tests EVD problem
*************************************************************************/
static void testevdunit_testtdevdproblem(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector lambdav;
    ae_vector ee;
    ae_vector lambda2;
    ae_matrix z;
    ae_matrix zref;
    ae_matrix a1;
    ae_matrix a2;
    ae_bool wsucc;
    ae_int_t i;
    ae_int_t j;
    double v;
    double worstseparation;
    double requiredseparation;
    double specialthreshold;

    ae_frame_make(_state, &_frame_block);
    memset(&lambdav, 0, sizeof(lambdav));
    memset(&ee, 0, sizeof(ee));
    memset(&lambda2, 0, sizeof(lambda2));
    memset(&z, 0, sizeof(z));
    memset(&zref, 0, sizeof(zref));
    memset(&a1, 0, sizeof(a1));
    memset(&a2, 0, sizeof(a2));
    ae_vector_init(&lambdav, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ee, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&lambda2, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&z, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&zref, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a2, 0, 0, DT_REAL, _state, ae_true);

    ae_vector_set_length(&lambdav, n-1+1, _state);
    ae_vector_set_length(&lambda2, n-1+1, _state);
    ae_matrix_set_length(&zref, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a1, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a2, n-1+1, n-1+1, _state);
    if( n>1 )
    {
        ae_vector_set_length(&ee, n-2+1, _state);
    }
    
    /*
     * Test simple EVD: values and full vectors
     */
    for(i=0; i<=n-1; i++)
    {
        lambdav.ptr.p_double[i] = d->ptr.p_double[i];
    }
    for(i=0; i<=n-2; i++)
    {
        ee.ptr.p_double[i] = e->ptr.p_double[i];
    }
    testevdunit_unset2d(&z, _state);
    wsucc = smatrixtdevd(&lambdav, &ee, n, 2, &z, _state);
    if( !wsucc )
    {
        ae_set_error_flag(tderrors, ae_true, __FILE__, __LINE__, "testevdunit.ap:1113");
        ae_frame_leave(_state);
        return;
    }
    ae_set_error_flag(tderrors, ae_fp_greater(testevdunit_tdtestproduct(d, e, n, &z, &lambdav, _state),threshold), __FILE__, __LINE__, "testevdunit.ap:1116");
    ae_set_error_flag(tderrors, ae_fp_greater(testevdunit_testort(&z, n, _state),threshold), __FILE__, __LINE__, "testevdunit.ap:1117");
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_less(lambdav.ptr.p_double[i+1],lambdav.ptr.p_double[i]) )
        {
            ae_set_error_flag(tderrors, ae_true, __FILE__, __LINE__, "testevdunit.ap:1121");
            ae_frame_leave(_state);
            return;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            zref.ptr.pp_double[i][j] = z.ptr.pp_double[i][j];
        }
    }
    
    /*
     * Test values only variant
     */
    for(i=0; i<=n-1; i++)
    {
        lambda2.ptr.p_double[i] = d->ptr.p_double[i];
    }
    for(i=0; i<=n-2; i++)
    {
        ee.ptr.p_double[i] = e->ptr.p_double[i];
    }
    testevdunit_unset2d(&z, _state);
    wsucc = smatrixtdevd(&lambda2, &ee, n, 0, &z, _state);
    if( !wsucc )
    {
        ae_set_error_flag(tderrors, ae_true, __FILE__, __LINE__, "testevdunit.ap:1139");
        ae_frame_leave(_state);
        return;
    }
    for(i=0; i<=n-1; i++)
    {
        ae_set_error_flag(tderrors, ae_fp_greater(ae_fabs(lambda2.ptr.p_double[i]-lambdav.ptr.p_double[i], _state),threshold), __FILE__, __LINE__, "testevdunit.ap:1143");
    }
    
    /*
     * Test multiplication variant
     */
    for(i=0; i<=n-1; i++)
    {
        lambda2.ptr.p_double[i] = d->ptr.p_double[i];
    }
    for(i=0; i<=n-2; i++)
    {
        ee.ptr.p_double[i] = e->ptr.p_double[i];
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a1.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            a2.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j];
        }
    }
    wsucc = smatrixtdevd(&lambda2, &ee, n, 1, &a1, _state);
    if( !wsucc )
    {
        ae_set_error_flag(tderrors, ae_true, __FILE__, __LINE__, "testevdunit.ap:1161");
        ae_frame_leave(_state);
        return;
    }
    for(i=0; i<=n-1; i++)
    {
        ae_set_error_flag(tderrors, ae_fp_greater(ae_fabs(lambda2.ptr.p_double[i]-lambdav.ptr.p_double[i], _state),threshold), __FILE__, __LINE__, "testevdunit.ap:1165");
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&a2.ptr.pp_double[i][0], 1, &zref.ptr.pp_double[0][j], zref.stride, ae_v_len(0,n-1));
            
            /*
             * next line is a bit complicated because
             * depending on algorithm used we can get either
             * z or -z as eigenvector. so we compare result
             * with both A*ZRef and -A*ZRef
             */
            ae_set_error_flag(tderrors, ae_fp_greater(ae_fabs(v-a1.ptr.pp_double[i][j], _state),threshold)&&ae_fp_greater(ae_fabs(v+a1.ptr.pp_double[i][j], _state),threshold), __FILE__, __LINE__, "testevdunit.ap:1177");
        }
    }
    
    /*
     * Test first row variant.
     *
     * NOTE: this test is special because ZNeeded=3 is ALGLIB-specific feature
     *       which is NOT supported by Intel MKL. Thus, MKL-capable version of
     *       ALGLIB will use different algorithms for ZNeeded=3 and for ZNeeded<3.
     *
     *       In most cases it is OK, but when problem happened to be degenerate
     *       (two close eigenvalues), Z computed by ALGLIB may be different from
     *       Z computed by MKL (up to arbitrary rotation), which will lead to
     *       failure of the test, because ZNeeded=2 is used as reference value
     *       for ZNeeded=3.
     *
     *       That's why this test is performed only for well-separated matrices,
     *       and with custom threshold.
     */
    requiredseparation = 1.0E-6;
    specialthreshold = 1.0E-6;
    worstseparation = ae_maxrealnumber;
    for(i=0; i<=n-2; i++)
    {
        worstseparation = ae_minreal(worstseparation, ae_fabs(lambdav.ptr.p_double[i+1]-lambdav.ptr.p_double[i], _state), _state);
    }
    if( ae_fp_greater(worstseparation,requiredseparation) )
    {
        for(i=0; i<=n-1; i++)
        {
            lambda2.ptr.p_double[i] = d->ptr.p_double[i];
        }
        for(i=0; i<=n-2; i++)
        {
            ee.ptr.p_double[i] = e->ptr.p_double[i];
        }
        testevdunit_unset2d(&z, _state);
        wsucc = smatrixtdevd(&lambda2, &ee, n, 3, &z, _state);
        if( !wsucc )
        {
            ae_set_error_flag(tderrors, ae_true, __FILE__, __LINE__, "testevdunit.ap:1211");
            ae_frame_leave(_state);
            return;
        }
        for(i=0; i<=n-1; i++)
        {
            ae_set_error_flag(tderrors, ae_fp_greater(ae_fabs(lambda2.ptr.p_double[i]-lambdav.ptr.p_double[i], _state),threshold), __FILE__, __LINE__, "testevdunit.ap:1216");
            
            /*
             * next line is a bit complicated because
             * depending on algorithm used we can get either
             * z or -z as eigenvector. so we compare result
             * with both z and -z
             */
            ae_set_error_flag(tderrors, ae_fp_greater(ae_fabs(z.ptr.pp_double[0][i]-zref.ptr.pp_double[0][i], _state),specialthreshold)&&ae_fp_greater(ae_fabs(z.ptr.pp_double[0][i]+zref.ptr.pp_double[0][i], _state),specialthreshold), __FILE__, __LINE__, "testevdunit.ap:1224");
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Tests EVD problem

DistVals    -   is True, when eigenvalues are distinct. Is False, when we
                are solving sparse task with  lots  of  zero  eigenvalues.
                In such cases some tests related to the  eigenvectors  are
                not performed.
*************************************************************************/
static void testevdunit_testtdevdbiproblem(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool distvals,
     double threshold,
     ae_bool* serrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector lambdav;
    ae_vector lambdaref;
    ae_matrix z;
    ae_matrix zref;
    ae_matrix a1;
    ae_matrix a2;
    ae_matrix ar;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t m;
    ae_int_t i1;
    ae_int_t i2;
    double v;
    double a;
    double b;

    ae_frame_make(_state, &_frame_block);
    memset(&lambdav, 0, sizeof(lambdav));
    memset(&lambdaref, 0, sizeof(lambdaref));
    memset(&z, 0, sizeof(z));
    memset(&zref, 0, sizeof(zref));
    memset(&a1, 0, sizeof(a1));
    memset(&a2, 0, sizeof(a2));
    memset(&ar, 0, sizeof(ar));
    ae_vector_init(&lambdav, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&lambdaref, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&z, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&zref, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ar, 0, 0, DT_REAL, _state, ae_true);

    ae_vector_set_length(&lambdaref, n-1+1, _state);
    ae_matrix_set_length(&zref, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a1, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a2, n-1+1, n-1+1, _state);
    
    /*
     * Reference EVD
     */
    ae_vector_set_length(&lambdaref, n, _state);
    ae_v_move(&lambdaref.ptr.p_double[0], 1, &d->ptr.p_double[0], 1, ae_v_len(0,n-1));
    *runs = *runs+1;
    if( !smatrixtdevd(&lambdaref, e, n, 2, &zref, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * Select random interval boundaries.
     * If there are non-distinct eigenvalues at the boundaries,
     * we move indexes further until values splits. It is done to
     * avoid situations where we can't get definite answer.
     */
    i1 = ae_randominteger(n, _state);
    i2 = i1+ae_randominteger(n-i1, _state);
    while(i1>0)
    {
        if( ae_fp_greater(ae_fabs(lambdaref.ptr.p_double[i1-1]-lambdaref.ptr.p_double[i1], _state),10*threshold) )
        {
            break;
        }
        i1 = i1-1;
    }
    while(i2<n-1)
    {
        if( ae_fp_greater(ae_fabs(lambdaref.ptr.p_double[i2+1]-lambdaref.ptr.p_double[i2], _state),10*threshold) )
        {
            break;
        }
        i2 = i2+1;
    }
    
    /*
     * Test different combinations
     */
    
    /*
     * Select A, B
     */
    if( i1>0 )
    {
        a = 0.5*(lambdaref.ptr.p_double[i1]+lambdaref.ptr.p_double[i1-1]);
    }
    else
    {
        a = lambdaref.ptr.p_double[0]-1;
    }
    if( i2<n-1 )
    {
        b = 0.5*(lambdaref.ptr.p_double[i2]+lambdaref.ptr.p_double[i2+1]);
    }
    else
    {
        b = lambdaref.ptr.p_double[n-1]+1;
    }
    
    /*
     * Test interval, no vectors
     */
    ae_vector_set_length(&lambdav, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        lambdav.ptr.p_double[i] = d->ptr.p_double[i];
    }
    *runs = *runs+1;
    if( !smatrixtdevdr(&lambdav, e, n, 0, a, b, &m, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test indexes, no vectors
     */
    ae_vector_set_length(&lambdav, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        lambdav.ptr.p_double[i] = d->ptr.p_double[i];
    }
    *runs = *runs+1;
    if( !smatrixtdevdi(&lambdav, e, n, 0, i1, i2, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test interval, transform vectors
     */
    ae_vector_set_length(&lambdav, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        lambdav.ptr.p_double[i] = d->ptr.p_double[i];
    }
    ae_matrix_set_length(&a1, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a2, n-1+1, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a1.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            a2.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j];
        }
    }
    *runs = *runs+1;
    if( !smatrixtdevdr(&lambdav, e, n, 1, a, b, &m, &a1, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        ae_matrix_set_length(&ar, n-1+1, m-1+1, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                v = ae_v_dotproduct(&a2.ptr.pp_double[i][0], 1, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
                ar.ptr.pp_double[i][j] = v;
            }
        }
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&a1.ptr.pp_double[0][j], a1.stride, &ar.ptr.pp_double[0][j], ar.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&ar.ptr.pp_double[0][j], ar.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(a1.ptr.pp_double[i][j]-ar.ptr.pp_double[i][j], _state),threshold);
            }
        }
    }
    
    /*
     * Test indexes, transform vectors
     */
    ae_vector_set_length(&lambdav, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        lambdav.ptr.p_double[i] = d->ptr.p_double[i];
    }
    ae_matrix_set_length(&a1, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a2, n-1+1, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a1.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            a2.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j];
        }
    }
    *runs = *runs+1;
    if( !smatrixtdevdi(&lambdav, e, n, 1, i1, i2, &a1, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        ae_matrix_set_length(&ar, n-1+1, m-1+1, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                v = ae_v_dotproduct(&a2.ptr.pp_double[i][0], 1, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
                ar.ptr.pp_double[i][j] = v;
            }
        }
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&a1.ptr.pp_double[0][j], a1.stride, &ar.ptr.pp_double[0][j], ar.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&ar.ptr.pp_double[0][j], ar.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(a1.ptr.pp_double[i][j]-ar.ptr.pp_double[i][j], _state),threshold);
            }
        }
    }
    
    /*
     * Test interval, do not transform vectors
     */
    ae_vector_set_length(&lambdav, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        lambdav.ptr.p_double[i] = d->ptr.p_double[i];
    }
    ae_matrix_set_length(&z, 0+1, 0+1, _state);
    *runs = *runs+1;
    if( !smatrixtdevdr(&lambdav, e, n, 2, a, b, &m, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&z.ptr.pp_double[0][j], z.stride, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&z.ptr.pp_double[0][j], z.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(z.ptr.pp_double[i][j]-zref.ptr.pp_double[i][i1+j], _state),threshold);
            }
        }
    }
    
    /*
     * Test indexes, do not transform vectors
     */
    ae_vector_set_length(&lambdav, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        lambdav.ptr.p_double[i] = d->ptr.p_double[i];
    }
    ae_matrix_set_length(&z, 0+1, 0+1, _state);
    *runs = *runs+1;
    if( !smatrixtdevdi(&lambdav, e, n, 2, i1, i2, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&z.ptr.pp_double[0][j], z.stride, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&z.ptr.pp_double[0][j], z.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(z.ptr.pp_double[i][j]-zref.ptr.pp_double[i][i1+j], _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Non-symmetric problem
*************************************************************************/
static void testevdunit_testnsevdproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* nserrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    double mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t vjob;
    ae_bool needl;
    ae_bool needr;
    ae_vector wr0;
    ae_vector wi0;
    ae_vector wr1;
    ae_vector wi1;
    ae_vector wr0s;
    ae_vector wi0s;
    ae_vector wr1s;
    ae_vector wi1s;
    ae_matrix vl;
    ae_matrix vr;
    ae_vector vec1r;
    ae_vector vec1i;
    ae_vector vec2r;
    ae_vector vec2i;
    ae_vector vec3r;
    ae_vector vec3i;
    double curwr;
    double curwi;
    double vt;
    double tmp;
    double vnorm;

    ae_frame_make(_state, &_frame_block);
    memset(&wr0, 0, sizeof(wr0));
    memset(&wi0, 0, sizeof(wi0));
    memset(&wr1, 0, sizeof(wr1));
    memset(&wi1, 0, sizeof(wi1));
    memset(&wr0s, 0, sizeof(wr0s));
    memset(&wi0s, 0, sizeof(wi0s));
    memset(&wr1s, 0, sizeof(wr1s));
    memset(&wi1s, 0, sizeof(wi1s));
    memset(&vl, 0, sizeof(vl));
    memset(&vr, 0, sizeof(vr));
    memset(&vec1r, 0, sizeof(vec1r));
    memset(&vec1i, 0, sizeof(vec1i));
    memset(&vec2r, 0, sizeof(vec2r));
    memset(&vec2i, 0, sizeof(vec2i));
    memset(&vec3r, 0, sizeof(vec3r));
    memset(&vec3i, 0, sizeof(vec3i));
    ae_vector_init(&wr0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&wi0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&wr1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&wi1, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&wr0s, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&wi0s, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&wr1s, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&wi1s, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&vl, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&vr, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&vec1r, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&vec1i, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&vec2r, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&vec2i, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&vec3r, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&vec3i, 0, DT_REAL, _state, ae_true);

    ae_vector_set_length(&vec1r, n-1+1, _state);
    ae_vector_set_length(&vec2r, n-1+1, _state);
    ae_vector_set_length(&vec3r, n-1+1, _state);
    ae_vector_set_length(&vec1i, n-1+1, _state);
    ae_vector_set_length(&vec2i, n-1+1, _state);
    ae_vector_set_length(&vec3i, n-1+1, _state);
    ae_vector_set_length(&wr0s, n-1+1, _state);
    ae_vector_set_length(&wr1s, n-1+1, _state);
    ae_vector_set_length(&wi0s, n-1+1, _state);
    ae_vector_set_length(&wi1s, n-1+1, _state);
    mx = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater(ae_fabs(a->ptr.pp_double[i][j], _state),mx) )
            {
                mx = ae_fabs(a->ptr.pp_double[i][j], _state);
            }
        }
    }
    if( ae_fp_eq(mx,(double)(0)) )
    {
        mx = (double)(1);
    }
    
    /*
     * Load values-only
     */
    if( !rmatrixevd(a, n, 0, &wr0, &wi0, &vl, &vr, _state) )
    {
        ae_set_error_flag(nserrors, ae_true, __FILE__, __LINE__, "testevdunit.ap:1554");
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * Test different jobs
     */
    for(vjob=1; vjob<=3; vjob++)
    {
        needr = vjob==1||vjob==3;
        needl = vjob==2||vjob==3;
        if( !rmatrixevd(a, n, vjob, &wr1, &wi1, &vl, &vr, _state) )
        {
            ae_set_error_flag(nserrors, ae_true, __FILE__, __LINE__, "testevdunit.ap:1567");
            ae_frame_leave(_state);
            return;
        }
        
        /*
         * Test values:
         * 1. sort by real part
         * 2. test
         */
        ae_v_move(&wr0s.ptr.p_double[0], 1, &wr0.ptr.p_double[0], 1, ae_v_len(0,n-1));
        ae_v_move(&wi0s.ptr.p_double[0], 1, &wi0.ptr.p_double[0], 1, ae_v_len(0,n-1));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-2-i; j++)
            {
                if( ae_fp_greater(wr0s.ptr.p_double[j],wr0s.ptr.p_double[j+1]) )
                {
                    tmp = wr0s.ptr.p_double[j];
                    wr0s.ptr.p_double[j] = wr0s.ptr.p_double[j+1];
                    wr0s.ptr.p_double[j+1] = tmp;
                    tmp = wi0s.ptr.p_double[j];
                    wi0s.ptr.p_double[j] = wi0s.ptr.p_double[j+1];
                    wi0s.ptr.p_double[j+1] = tmp;
                }
            }
        }
        ae_v_move(&wr1s.ptr.p_double[0], 1, &wr1.ptr.p_double[0], 1, ae_v_len(0,n-1));
        ae_v_move(&wi1s.ptr.p_double[0], 1, &wi1.ptr.p_double[0], 1, ae_v_len(0,n-1));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-2-i; j++)
            {
                if( ae_fp_greater(wr1s.ptr.p_double[j],wr1s.ptr.p_double[j+1]) )
                {
                    tmp = wr1s.ptr.p_double[j];
                    wr1s.ptr.p_double[j] = wr1s.ptr.p_double[j+1];
                    wr1s.ptr.p_double[j+1] = tmp;
                    tmp = wi1s.ptr.p_double[j];
                    wi1s.ptr.p_double[j] = wi1s.ptr.p_double[j+1];
                    wi1s.ptr.p_double[j+1] = tmp;
                }
            }
        }
        for(i=0; i<=n-1; i++)
        {
            ae_set_error_flag(nserrors, ae_fp_greater(ae_fabs(wr0s.ptr.p_double[i]-wr1s.ptr.p_double[i], _state),threshold), __FILE__, __LINE__, "testevdunit.ap:1604");
            ae_set_error_flag(nserrors, ae_fp_greater(ae_fabs(wi0s.ptr.p_double[i]-wi1s.ptr.p_double[i], _state),threshold), __FILE__, __LINE__, "testevdunit.ap:1605");
        }
        
        /*
         * Test right vectors
         */
        if( needr )
        {
            k = 0;
            while(k<=n-1)
            {
                curwr = (double)(0);
                curwi = (double)(0);
                if( ae_fp_eq(wi1.ptr.p_double[k],(double)(0)) )
                {
                    ae_v_move(&vec1r.ptr.p_double[0], 1, &vr.ptr.pp_double[0][k], vr.stride, ae_v_len(0,n-1));
                    for(i=0; i<=n-1; i++)
                    {
                        vec1i.ptr.p_double[i] = (double)(0);
                    }
                    curwr = wr1.ptr.p_double[k];
                    curwi = (double)(0);
                }
                if( ae_fp_greater(wi1.ptr.p_double[k],(double)(0)) )
                {
                    ae_v_move(&vec1r.ptr.p_double[0], 1, &vr.ptr.pp_double[0][k], vr.stride, ae_v_len(0,n-1));
                    ae_v_move(&vec1i.ptr.p_double[0], 1, &vr.ptr.pp_double[0][k+1], vr.stride, ae_v_len(0,n-1));
                    curwr = wr1.ptr.p_double[k];
                    curwi = wi1.ptr.p_double[k];
                }
                if( ae_fp_less(wi1.ptr.p_double[k],(double)(0)) )
                {
                    ae_v_move(&vec1r.ptr.p_double[0], 1, &vr.ptr.pp_double[0][k-1], vr.stride, ae_v_len(0,n-1));
                    ae_v_moveneg(&vec1i.ptr.p_double[0], 1, &vr.ptr.pp_double[0][k], vr.stride, ae_v_len(0,n-1));
                    curwr = wr1.ptr.p_double[k];
                    curwi = wi1.ptr.p_double[k];
                }
                vnorm = 0.0;
                for(i=0; i<=n-1; i++)
                {
                    vt = ae_v_dotproduct(&a->ptr.pp_double[i][0], 1, &vec1r.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    vec2r.ptr.p_double[i] = vt;
                    vt = ae_v_dotproduct(&a->ptr.pp_double[i][0], 1, &vec1i.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    vec2i.ptr.p_double[i] = vt;
                    vnorm = vnorm+ae_sqr(vec1r.ptr.p_double[i], _state)+ae_sqr(vec1i.ptr.p_double[i], _state);
                }
                vnorm = ae_sqrt(vnorm, _state);
                ae_v_moved(&vec3r.ptr.p_double[0], 1, &vec1r.ptr.p_double[0], 1, ae_v_len(0,n-1), curwr);
                ae_v_subd(&vec3r.ptr.p_double[0], 1, &vec1i.ptr.p_double[0], 1, ae_v_len(0,n-1), curwi);
                ae_v_moved(&vec3i.ptr.p_double[0], 1, &vec1r.ptr.p_double[0], 1, ae_v_len(0,n-1), curwi);
                ae_v_addd(&vec3i.ptr.p_double[0], 1, &vec1i.ptr.p_double[0], 1, ae_v_len(0,n-1), curwr);
                ae_set_error_flag(nserrors, ae_fp_less(vnorm,1.0E-3)||!ae_isfinite(vnorm, _state), __FILE__, __LINE__, "testevdunit.ap:1654");
                for(i=0; i<=n-1; i++)
                {
                    ae_set_error_flag(nserrors, ae_fp_greater(ae_fabs(vec2r.ptr.p_double[i]-vec3r.ptr.p_double[i], _state),threshold), __FILE__, __LINE__, "testevdunit.ap:1657");
                    ae_set_error_flag(nserrors, ae_fp_greater(ae_fabs(vec2i.ptr.p_double[i]-vec3i.ptr.p_double[i], _state),threshold), __FILE__, __LINE__, "testevdunit.ap:1658");
                }
                k = k+1;
            }
        }
        
        /*
         * Test left vectors
         */
        curwr = (double)(0);
        curwi = (double)(0);
        if( needl )
        {
            k = 0;
            while(k<=n-1)
            {
                if( ae_fp_eq(wi1.ptr.p_double[k],(double)(0)) )
                {
                    ae_v_move(&vec1r.ptr.p_double[0], 1, &vl.ptr.pp_double[0][k], vl.stride, ae_v_len(0,n-1));
                    for(i=0; i<=n-1; i++)
                    {
                        vec1i.ptr.p_double[i] = (double)(0);
                    }
                    curwr = wr1.ptr.p_double[k];
                    curwi = (double)(0);
                }
                if( ae_fp_greater(wi1.ptr.p_double[k],(double)(0)) )
                {
                    ae_v_move(&vec1r.ptr.p_double[0], 1, &vl.ptr.pp_double[0][k], vl.stride, ae_v_len(0,n-1));
                    ae_v_move(&vec1i.ptr.p_double[0], 1, &vl.ptr.pp_double[0][k+1], vl.stride, ae_v_len(0,n-1));
                    curwr = wr1.ptr.p_double[k];
                    curwi = wi1.ptr.p_double[k];
                }
                if( ae_fp_less(wi1.ptr.p_double[k],(double)(0)) )
                {
                    ae_v_move(&vec1r.ptr.p_double[0], 1, &vl.ptr.pp_double[0][k-1], vl.stride, ae_v_len(0,n-1));
                    ae_v_moveneg(&vec1i.ptr.p_double[0], 1, &vl.ptr.pp_double[0][k], vl.stride, ae_v_len(0,n-1));
                    curwr = wr1.ptr.p_double[k];
                    curwi = wi1.ptr.p_double[k];
                }
                vnorm = 0.0;
                for(j=0; j<=n-1; j++)
                {
                    vt = ae_v_dotproduct(&vec1r.ptr.p_double[0], 1, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,n-1));
                    vec2r.ptr.p_double[j] = vt;
                    vt = ae_v_dotproduct(&vec1i.ptr.p_double[0], 1, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,n-1));
                    vec2i.ptr.p_double[j] = -vt;
                    vnorm = vnorm+ae_sqr(vec1r.ptr.p_double[j], _state)+ae_sqr(vec1i.ptr.p_double[j], _state);
                }
                vnorm = ae_sqrt(vnorm, _state);
                ae_v_moved(&vec3r.ptr.p_double[0], 1, &vec1r.ptr.p_double[0], 1, ae_v_len(0,n-1), curwr);
                ae_v_addd(&vec3r.ptr.p_double[0], 1, &vec1i.ptr.p_double[0], 1, ae_v_len(0,n-1), curwi);
                ae_v_moved(&vec3i.ptr.p_double[0], 1, &vec1r.ptr.p_double[0], 1, ae_v_len(0,n-1), curwi);
                ae_v_addd(&vec3i.ptr.p_double[0], 1, &vec1i.ptr.p_double[0], 1, ae_v_len(0,n-1), -curwr);
                ae_set_error_flag(nserrors, ae_fp_less(vnorm,1.0E-3)||!ae_isfinite(vnorm, _state), __FILE__, __LINE__, "testevdunit.ap:1710");
                for(i=0; i<=n-1; i++)
                {
                    ae_set_error_flag(nserrors, ae_fp_greater(ae_fabs(vec2r.ptr.p_double[i]-vec3r.ptr.p_double[i], _state),threshold), __FILE__, __LINE__, "testevdunit.ap:1713");
                    ae_set_error_flag(nserrors, ae_fp_greater(ae_fabs(vec2i.ptr.p_double[i]-vec3i.ptr.p_double[i], _state),threshold), __FILE__, __LINE__, "testevdunit.ap:1714");
                }
                k = k+1;
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Testing EVD subroutines for one N

NOTES:
* BIThreshold is a threshold for bisection-and-inverse-iteration subroutines.
  special threshold is needed because these subroutines may have much more
  larger error than QR-based algorithms.
*************************************************************************/
static void testevdunit_testevdset(ae_int_t n,
     double threshold,
     double bithreshold,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_bool* nserrors,
     ae_bool* serrors,
     ae_bool* herrors,
     ae_bool* tderrors,
     ae_bool* sbierrors,
     ae_bool* hbierrors,
     ae_bool* tdbierrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ra;
    ae_matrix ral;
    ae_matrix rau;
    ae_matrix ca;
    ae_matrix cal;
    ae_matrix cau;
    ae_vector d;
    ae_vector e;
    ae_int_t i;
    ae_int_t j;
    ae_int_t mkind;

    ae_frame_make(_state, &_frame_block);
    memset(&ra, 0, sizeof(ra));
    memset(&ral, 0, sizeof(ral));
    memset(&rau, 0, sizeof(rau));
    memset(&ca, 0, sizeof(ca));
    memset(&cal, 0, sizeof(cal));
    memset(&cau, 0, sizeof(cau));
    memset(&d, 0, sizeof(d));
    memset(&e, 0, sizeof(e));
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ral, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rau, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cal, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cau, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&d, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&e, 0, DT_REAL, _state, ae_true);

    
    /*
     * Test symmetric problems
     */
    ae_matrix_set_length(&ra, n, n, _state);
    ae_matrix_set_length(&ral, n, n, _state);
    ae_matrix_set_length(&rau, n, n, _state);
    ae_matrix_set_length(&ca, n, n, _state);
    ae_matrix_set_length(&cal, n, n, _state);
    ae_matrix_set_length(&cau, n, n, _state);
    
    /*
     * Zero matrices
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            ra.ptr.pp_double[i][j] = (double)(0);
            ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    testevdunit_rmatrixsymmetricsplit(&ra, n, &ral, &rau, _state);
    testevdunit_cmatrixhermitiansplit(&ca, n, &cal, &cau, _state);
    testevdunit_testsevdproblem(&ra, &ral, &rau, n, threshold, serrors, failc, runs, _state);
    testevdunit_testhevdproblem(&ca, &cal, &cau, n, threshold, herrors, failc, runs, _state);
    testevdunit_testsevdbiproblem(&ra, &ral, &rau, n, ae_false, bithreshold, sbierrors, failc, runs, _state);
    testevdunit_testhevdbiproblem(&ca, &cal, &cau, n, ae_false, bithreshold, hbierrors, failc, runs, _state);
    
    /*
     * Random matrix
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=i+1; j<=n-1; j++)
        {
            ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
            ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            ra.ptr.pp_double[j][i] = ra.ptr.pp_double[i][j];
            ca.ptr.pp_complex[j][i] = ae_c_conj(ca.ptr.pp_complex[i][j], _state);
        }
        ra.ptr.pp_double[i][i] = 2*ae_randomreal(_state)-1;
        ca.ptr.pp_complex[i][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
    }
    testevdunit_rmatrixsymmetricsplit(&ra, n, &ral, &rau, _state);
    testevdunit_cmatrixhermitiansplit(&ca, n, &cal, &cau, _state);
    testevdunit_testsevdproblem(&ra, &ral, &rau, n, threshold, serrors, failc, runs, _state);
    testevdunit_testhevdproblem(&ca, &cal, &cau, n, threshold, herrors, failc, runs, _state);
    
    /*
     * Random diagonally dominant matrix with distinct eigenvalues
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=i+1; j<=n-1; j++)
        {
            ra.ptr.pp_double[i][j] = 0.1*(2*ae_randomreal(_state)-1)/n;
            ca.ptr.pp_complex[i][j].x = 0.1*(2*ae_randomreal(_state)-1)/n;
            ca.ptr.pp_complex[i][j].y = 0.1*(2*ae_randomreal(_state)-1)/n;
            ra.ptr.pp_double[j][i] = ra.ptr.pp_double[i][j];
            ca.ptr.pp_complex[j][i] = ae_c_conj(ca.ptr.pp_complex[i][j], _state);
        }
        ra.ptr.pp_double[i][i] = 0.1*(2*ae_randomreal(_state)-1)+i;
        ca.ptr.pp_complex[i][i] = ae_complex_from_d(0.1*(2*ae_randomreal(_state)-1)+i);
    }
    testevdunit_rmatrixsymmetricsplit(&ra, n, &ral, &rau, _state);
    testevdunit_cmatrixhermitiansplit(&ca, n, &cal, &cau, _state);
    testevdunit_testsevdproblem(&ra, &ral, &rau, n, threshold, serrors, failc, runs, _state);
    testevdunit_testhevdproblem(&ca, &cal, &cau, n, threshold, herrors, failc, runs, _state);
    testevdunit_testsevdbiproblem(&ra, &ral, &rau, n, ae_true, bithreshold, sbierrors, failc, runs, _state);
    testevdunit_testhevdbiproblem(&ca, &cal, &cau, n, ae_true, bithreshold, hbierrors, failc, runs, _state);
    
    /*
     * Sparse matrices
     */
    testevdunit_rmatrixfillsparsea(&ra, n, n, 0.995, (double)(0), _state);
    testevdunit_cmatrixfillsparsea(&ca, n, n, 0.995, (double)(0), _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=i+1; j<=n-1; j++)
        {
            ra.ptr.pp_double[j][i] = ra.ptr.pp_double[i][j];
            ca.ptr.pp_complex[j][i] = ae_c_conj(ca.ptr.pp_complex[i][j], _state);
        }
        ca.ptr.pp_complex[i][i].y = (double)(0);
    }
    testevdunit_rmatrixsymmetricsplit(&ra, n, &ral, &rau, _state);
    testevdunit_cmatrixhermitiansplit(&ca, n, &cal, &cau, _state);
    testevdunit_testsevdproblem(&ra, &ral, &rau, n, threshold, serrors, failc, runs, _state);
    testevdunit_testhevdproblem(&ca, &cal, &cau, n, threshold, herrors, failc, runs, _state);
    testevdunit_testsevdbiproblem(&ra, &ral, &rau, n, ae_false, bithreshold, sbierrors, failc, runs, _state);
    testevdunit_testhevdbiproblem(&ca, &cal, &cau, n, ae_false, bithreshold, hbierrors, failc, runs, _state);
    
    /*
     * testing tridiagonal problems
     */
    for(mkind=0; mkind<=7; mkind++)
    {
        ae_vector_set_length(&d, n, _state);
        if( n>1 )
        {
            ae_vector_set_length(&e, n-1, _state);
        }
        if( mkind==0 )
        {
            
            /*
             * Zero matrix
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = (double)(0);
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = (double)(0);
            }
        }
        if( mkind==1 )
        {
            
            /*
             * Diagonal matrix
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = (double)(0);
            }
        }
        if( mkind==2 )
        {
            
            /*
             * Off-diagonal matrix
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = (double)(0);
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
        }
        if( mkind==3 )
        {
            
            /*
             * Dense matrix with blocks
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            j = 1;
            i = 2;
            while(j<=n-2)
            {
                e.ptr.p_double[j] = (double)(0);
                j = j+i;
                i = i+1;
            }
        }
        if( mkind==4 )
        {
            
            /*
             * dense matrix
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
        }
        if( mkind==5 )
        {
            
            /*
             * Diagonal matrix with distinct eigenvalues
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = 0.1*(2*ae_randomreal(_state)-1)+i;
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = (double)(0);
            }
        }
        if( mkind==6 )
        {
            
            /*
             * Off-diagonal matrix with distinct eigenvalues
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = (double)(0);
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = 0.1*(2*ae_randomreal(_state)-1)+i+1;
            }
        }
        if( mkind==7 )
        {
            
            /*
             * dense matrix with distinct eigenvalues
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = 0.1*(2*ae_randomreal(_state)-1)+i+1;
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = 0.1*(2*ae_randomreal(_state)-1);
            }
        }
        testevdunit_testtdevdproblem(&d, &e, n, threshold, tderrors, _state);
        testevdunit_testtdevdbiproblem(&d, &e, n, (mkind==5||mkind==6)||mkind==7, bithreshold, tdbierrors, failc, runs, _state);
    }
    
    /*
     * Test non-symmetric problems
     */
    
    /*
     * Test non-symmetric problems: zero, random, sparse matrices.
     */
    ae_matrix_set_length(&ra, n, n, _state);
    ae_matrix_set_length(&ca, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            ra.ptr.pp_double[i][j] = (double)(0);
            ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    testevdunit_testnsevdproblem(&ra, n, threshold, nserrors, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
            ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
        }
    }
    testevdunit_testnsevdproblem(&ra, n, threshold, nserrors, _state);
    ae_frame_leave(_state);
}


/*************************************************************************
Testing symmetric mode of subspace iteration solver.

On failure sets error flag, on success flag is not changed.
*************************************************************************/
static void testevdunit_testsisymm(ae_bool* errorflag, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t m;
    ae_int_t smode;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    hqrndstate rs;
    double sgn;
    ae_vector diaga;
    double decaya;
    ae_bool isupper;
    ae_matrix qa;
    ae_matrix densea;
    ae_matrix halfa;
    ae_matrix ra;
    ae_matrix rb;
    ae_matrix tmp2;
    sparsematrix halfsa;
    ae_int_t sformat;
    double v;
    double mx;
    eigsubspacestate s;
    eigsubspacereport rep;
    ae_vector sw;
    ae_matrix sz;
    ae_vector u;
    double tollambda;
    double tolvector;
    ae_int_t itscount;
    ae_int_t callcount;
    ae_int_t requestsize;
    ae_int_t requesttype;
    ae_int_t pass;
    ae_int_t cnta;
    ae_int_t cntb;
    ae_int_t cntc;
    double nu;
    double eps;

    ae_frame_make(_state, &_frame_block);
    memset(&rs, 0, sizeof(rs));
    memset(&diaga, 0, sizeof(diaga));
    memset(&qa, 0, sizeof(qa));
    memset(&densea, 0, sizeof(densea));
    memset(&halfa, 0, sizeof(halfa));
    memset(&ra, 0, sizeof(ra));
    memset(&rb, 0, sizeof(rb));
    memset(&tmp2, 0, sizeof(tmp2));
    memset(&halfsa, 0, sizeof(halfsa));
    memset(&s, 0, sizeof(s));
    memset(&rep, 0, sizeof(rep));
    memset(&sw, 0, sizeof(sw));
    memset(&sz, 0, sizeof(sz));
    memset(&u, 0, sizeof(u));
    _hqrndstate_init(&rs, _state, ae_true);
    ae_vector_init(&diaga, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&qa, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&densea, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&halfa, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rb, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&tmp2, 0, 0, DT_REAL, _state, ae_true);
    _sparsematrix_init(&halfsa, _state, ae_true);
    _eigsubspacestate_init(&s, _state, ae_true);
    _eigsubspacereport_init(&rep, _state, ae_true);
    ae_vector_init(&sw, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&sz, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&u, 0, DT_REAL, _state, ae_true);

    hqrndrandomize(&rs, _state);
    
    /*
     * Problem with weakly separated eigenvalues (but not too weak),
     * either with alternating sign - or all positive. EPS-based
     * stopping condition is used because we can not tell how many
     * iterations is required to solve it.
     */
    tollambda = 1.0E-9;
    tolvector = 1.0E-4;
    for(n=1; n<=25; n++)
    {
        for(m=1; m<=n; m++)
        {
            for(smode=0; smode<=2; smode++)
            {
                
                /*
                 * Generate eigenproblem
                 */
                sgn = (double)(2*hqrnduniformi(&rs, 2, _state)-1);
                decaya = 1.05;
                ae_vector_set_length(&diaga, n, _state);
                diaga.ptr.p_double[0] = ae_pow((double)(10), 2*hqrnduniformr(&rs, _state)-1, _state);
                for(i=1; i<=n-1; i++)
                {
                    diaga.ptr.p_double[i] = diaga.ptr.p_double[i-1]*sgn/(decaya*(1+0.01*hqrnduniformr(&rs, _state)));
                }
                rmatrixrndorthogonal(n, &qa, _state);
                ae_matrix_set_length(&densea, n, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = (double)(0);
                        for(k=0; k<=n-1; k++)
                        {
                            v = v+qa.ptr.pp_double[k][i]*diaga.ptr.p_double[k]*qa.ptr.pp_double[k][j];
                        }
                        densea.ptr.pp_double[i][j] = v;
                    }
                }
                isupper = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
                ae_matrix_set_length(&halfa, n, n, _state);
                sparsecreate(n, n, 0, &halfsa, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        halfa.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state);
                        if( j>=i&&isupper )
                        {
                            halfa.ptr.pp_double[i][j] = densea.ptr.pp_double[i][j];
                            sparseset(&halfsa, i, j, densea.ptr.pp_double[i][j], _state);
                        }
                        if( j<=i&&!isupper )
                        {
                            halfa.ptr.pp_double[i][j] = densea.ptr.pp_double[i][j];
                            sparseset(&halfsa, i, j, densea.ptr.pp_double[i][j], _state);
                        }
                    }
                }
                sformat = hqrnduniformi(&rs, 2, _state);
                if( sformat==0 )
                {
                    sparseconverttocrs(&halfsa, _state);
                }
                if( sformat==1 )
                {
                    sparseconverttosks(&halfsa, _state);
                }
                
                /*
                 * Solve with eigensolver operating in dense mode
                 */
                eigsubspacecreate(n, m, &s, _state);
                eigsubspacesetcond(&s, tollambda/100, 0, _state);
                if( smode==0 )
                {
                    
                    /*
                     * Dense mode
                     */
                    eigsubspacesolvedenses(&s, &halfa, isupper, &sw, &sz, &rep, _state);
                }
                else
                {
                    if( smode==1 )
                    {
                        
                        /*
                         * Sparse mode
                         */
                        eigsubspacesolvesparses(&s, &halfsa, isupper, &sw, &sz, &rep, _state);
                    }
                    else
                    {
                        if( smode==2 )
                        {
                            
                            /*
                             * Out-of-core mode, symmetric version
                             */
                            eigsubspaceoocstart(&s, 0, _state);
                            while(eigsubspaceooccontinue(&s, _state))
                            {
                                eigsubspaceoocgetrequestinfo(&s, &requesttype, &requestsize, _state);
                                ae_assert(requesttype==0, "EVDI: integrity check failed in unit test", _state);
                                ae_assert(requestsize>0, "EVDI: integrity check failed in unit test", _state);
                                eigsubspaceoocgetrequestdata(&s, &ra, _state);
                                rmatrixsetlengthatleast(&rb, n, requestsize, _state);
                                rmatrixgemm(n, requestsize, n, 1.0, &densea, 0, 0, 0, &ra, 0, 0, 0, 0.0, &rb, 0, 0, _state);
                                eigsubspaceoocsendresult(&s, &rb, _state);
                            }
                            eigsubspaceoocstop(&s, &sw, &sz, &rep, _state);
                        }
                        else
                        {
                            ae_assert(ae_false, "unittest: integrity check failed", _state);
                        }
                    }
                }
                
                /*
                 * Compare against reference values
                 */
                for(i=0; i<=m-1; i++)
                {
                    ae_set_error_flag(errorflag, ae_fp_greater(ae_fabs(sw.ptr.p_double[i]-diaga.ptr.p_double[i], _state),tollambda), __FILE__, __LINE__, "testevdunit.ap:2126");
                    v = ae_v_dotproduct(&qa.ptr.pp_double[i][0], 1, &sz.ptr.pp_double[0][i], sz.stride, ae_v_len(0,n-1));
                    mx = (double)(0);
                    for(j=0; j<=n-1; j++)
                    {
                        mx = ae_maxreal(mx, ae_fabs(sz.ptr.pp_double[j][i]*ae_sign(v, _state)-qa.ptr.pp_double[i][j], _state), _state);
                    }
                    ae_set_error_flag(errorflag, ae_fp_greater(mx,tolvector), __FILE__, __LINE__, "testevdunit.ap:2131");
                }
            }
        }
    }
    
    /*
     * Problem with highly separated eigenvalues (either with alternating
     * sign - or all positive). Only a few iterations is performed, we
     * want to check convergence properties on such problems.
     */
    tollambda = 1.0E-9;
    tolvector = 1.0E-4;
    itscount = 5;
    for(n=1; n<=25; n++)
    {
        for(m=1; m<=n; m++)
        {
            for(smode=0; smode<=2; smode++)
            {
                
                /*
                 * Generate eigenproblem
                 */
                sgn = (double)(2*hqrnduniformi(&rs, 2, _state)-1);
                decaya = 1.05;
                ae_vector_set_length(&diaga, n, _state);
                diaga.ptr.p_double[0] = ae_pow((double)(10), 2*hqrnduniformr(&rs, _state)-1, _state);
                for(i=1; i<=n-1; i++)
                {
                    diaga.ptr.p_double[i] = diaga.ptr.p_double[i-1]*sgn/(decaya*(1+0.01*hqrnduniformr(&rs, _state)));
                }
                for(i=m; i<=n-1; i++)
                {
                    diaga.ptr.p_double[i] = diaga.ptr.p_double[i]/(100+10*hqrnduniformr(&rs, _state));
                }
                rmatrixrndorthogonal(n, &qa, _state);
                ae_matrix_set_length(&densea, n, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = (double)(0);
                        for(k=0; k<=n-1; k++)
                        {
                            v = v+qa.ptr.pp_double[k][i]*diaga.ptr.p_double[k]*qa.ptr.pp_double[k][j];
                        }
                        densea.ptr.pp_double[i][j] = v;
                    }
                }
                isupper = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
                ae_matrix_set_length(&halfa, n, n, _state);
                sparsecreate(n, n, 0, &halfsa, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        halfa.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state);
                        if( j>=i&&isupper )
                        {
                            halfa.ptr.pp_double[i][j] = densea.ptr.pp_double[i][j];
                            sparseset(&halfsa, i, j, densea.ptr.pp_double[i][j], _state);
                        }
                        if( j<=i&&!isupper )
                        {
                            halfa.ptr.pp_double[i][j] = densea.ptr.pp_double[i][j];
                            sparseset(&halfsa, i, j, densea.ptr.pp_double[i][j], _state);
                        }
                    }
                }
                sformat = hqrnduniformi(&rs, 2, _state);
                if( sformat==0 )
                {
                    sparseconverttocrs(&halfsa, _state);
                }
                if( sformat==1 )
                {
                    sparseconverttosks(&halfsa, _state);
                }
                
                /*
                 * Solve with eigensolver operating in dense mode
                 */
                eigsubspacecreate(n, m, &s, _state);
                eigsubspacesetcond(&s, (double)(0), itscount, _state);
                if( smode==0 )
                {
                    
                    /*
                     * Dense mode
                     */
                    eigsubspacesolvedenses(&s, &halfa, isupper, &sw, &sz, &rep, _state);
                }
                else
                {
                    if( smode==1 )
                    {
                        
                        /*
                         * Sparse mode
                         */
                        eigsubspacesolvesparses(&s, &halfsa, isupper, &sw, &sz, &rep, _state);
                    }
                    else
                    {
                        if( smode==2 )
                        {
                            
                            /*
                             * Out-of-core mode, symmetric version
                             *
                             * NOTE: we check that solver performs no more than ItsCount+2 calls
                             */
                            callcount = 0;
                            eigsubspaceoocstart(&s, 0, _state);
                            while(eigsubspaceooccontinue(&s, _state))
                            {
                                eigsubspaceoocgetrequestinfo(&s, &requesttype, &requestsize, _state);
                                ae_assert(requesttype==0, "EVDI: integrity check failed in unit test", _state);
                                ae_assert(requestsize>0, "EVDI: integrity check failed in unit test", _state);
                                eigsubspaceoocgetrequestdata(&s, &ra, _state);
                                rmatrixsetlengthatleast(&rb, n, requestsize, _state);
                                rmatrixgemm(n, requestsize, n, 1.0, &densea, 0, 0, 0, &ra, 0, 0, 0, 0.0, &rb, 0, 0, _state);
                                eigsubspaceoocsendresult(&s, &rb, _state);
                                callcount = callcount+1;
                            }
                            eigsubspaceoocstop(&s, &sw, &sz, &rep, _state);
                            ae_set_error_flag(errorflag, callcount>itscount+2, __FILE__, __LINE__, "testevdunit.ap:2238");
                        }
                        else
                        {
                            ae_assert(ae_false, "unittest: integrity check failed", _state);
                        }
                    }
                }
                
                /*
                 * Compare against reference values
                 */
                ae_set_error_flag(errorflag, rep.iterationscount>itscount, __FILE__, __LINE__, "testevdunit.ap:2246");
                for(i=0; i<=m-1; i++)
                {
                    ae_set_error_flag(errorflag, ae_fp_greater(ae_fabs(sw.ptr.p_double[i]-diaga.ptr.p_double[i], _state),tollambda), __FILE__, __LINE__, "testevdunit.ap:2249");
                    v = ae_v_dotproduct(&qa.ptr.pp_double[i][0], 1, &sz.ptr.pp_double[0][i], sz.stride, ae_v_len(0,n-1));
                    mx = (double)(0);
                    for(j=0; j<=n-1; j++)
                    {
                        mx = ae_maxreal(mx, ae_fabs(sz.ptr.pp_double[j][i]*ae_sign(v, _state)-qa.ptr.pp_double[i][j], _state), _state);
                    }
                    ae_set_error_flag(errorflag, ae_fp_greater(mx,tolvector), __FILE__, __LINE__, "testevdunit.ap:2254");
                }
            }
        }
    }
    
    /*
     * Problem with numerically zero matrix. We check ability to stop
     * and to return orthogonal vectors.
     */
    tollambda = 1.0E-9;
    itscount = 5;
    for(n=1; n<=25; n++)
    {
        for(m=1; m<=n; m++)
        {
            
            /*
             * Generate eigenproblem
             */
            ae_matrix_set_length(&densea, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    densea.ptr.pp_double[i][j] = (double)(0);
                }
            }
            
            /*
             * Solve with eigensolver operating in dense mode,
             * iteration count based stopping condition.
             */
            eigsubspacecreate(n, m, &s, _state);
            eigsubspacesetcond(&s, (double)(0), itscount, _state);
            eigsubspacesolvedenses(&s, &densea, ae_true, &sw, &sz, &rep, _state);
            ae_set_error_flag(errorflag, rep.iterationscount>itscount, __FILE__, __LINE__, "testevdunit.ap:2283");
            for(i=0; i<=m-1; i++)
            {
                for(j=i; j<=m-1; j++)
                {
                    v = ae_v_dotproduct(&sz.ptr.pp_double[0][i], sz.stride, &sz.ptr.pp_double[0][j], sz.stride, ae_v_len(0,n-1));
                    if( j==i )
                    {
                        v = v-1;
                    }
                    ae_set_error_flag(errorflag, ae_fp_greater(ae_fabs(v, _state),1.0E3*ae_machineepsilon), __FILE__, __LINE__, "testevdunit.ap:2291");
                }
                ae_set_error_flag(errorflag, ae_fp_neq(sw.ptr.p_double[i],(double)(0)), __FILE__, __LINE__, "testevdunit.ap:2293");
            }
            
            /*
             * Solve with eigensolver operating in dense mode,
             * eps-based stopping condition.
             */
            eigsubspacecreate(n, m, &s, _state);
            eigsubspacesetcond(&s, tollambda, 0, _state);
            eigsubspacesolvedenses(&s, &densea, ae_true, &sw, &sz, &rep, _state);
            for(i=0; i<=m-1; i++)
            {
                for(j=i; j<=m-1; j++)
                {
                    v = ae_v_dotproduct(&sz.ptr.pp_double[0][i], sz.stride, &sz.ptr.pp_double[0][j], sz.stride, ae_v_len(0,n-1));
                    if( j==i )
                    {
                        v = v-1;
                    }
                    ae_set_error_flag(errorflag, ae_fp_greater(ae_fabs(v, _state),1.0E3*ae_machineepsilon), __FILE__, __LINE__, "testevdunit.ap:2310");
                }
                ae_set_error_flag(errorflag, ae_fp_neq(sw.ptr.p_double[i],(double)(0)), __FILE__, __LINE__, "testevdunit.ap:2312");
            }
        }
    }
    
    /*
     * Test warm start functionality:
     * * for many randomly generated problems...
     * * ...solve original problem with EPS-based criterion
     * * ...then apply small rank-1 correction to the matrix
     * * ...and solve again, with warm start
     * * ...and solve again, with explicit cold start
     * * do so many times and calculate total iteration counts
     *
     * Iteration counts for warm starts should be significantly lower,
     * whilst solution found should be within tolerances.
     */
    cnta = 0;
    cntb = 0;
    cntc = 0;
    eps = 1.0E-3;
    nu = 0.001;
    for(pass=1; pass<=50; pass++)
    {
        
        /*
         * Generate eigenproblem and rank-1 update
         */
        n = 50+hqrnduniformi(&rs, 20, _state);
        m = 1+hqrnduniformi(&rs, 5, _state);
        ae_matrix_set_length(&ra, n, n, _state);
        ae_matrix_set_length(&tmp2, n, n, _state);
        ae_vector_set_length(&u, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                tmp2.ptr.pp_double[i][j] = hqrndnormal(&rs, _state);
            }
        }
        rmatrixgemm(n, n, n, 1.0, &tmp2, 0, 0, 0, &tmp2, 0, 0, 1, 0.0, &ra, 0, 0, _state);
        
        /*
         * Solve with eigensolver operating in cold-start mode,
         * iteration count based stopping condition.
         */
        eigsubspacecreate(n, m, &s, _state);
        eigsubspacesetcond(&s, eps, 0, _state);
        eigsubspacesolvedenses(&s, &ra, ae_true, &sw, &sz, &rep, _state);
        cnta = cnta+rep.iterationscount;
        
        /*
         * Solve with eigensolver operating in warm-start mode,
         * iteration count based stopping condition.
         */
        for(i=0; i<=n-1; i++)
        {
            u.ptr.p_double[i] = hqrndnormal(&rs, _state);
        }
        rmatrixger(n, n, &ra, 0, 0, nu, &u, 0, &u, 0, _state);
        eigsubspacesetwarmstart(&s, ae_true, _state);
        eigsubspacesolvedenses(&s, &ra, ae_true, &sw, &sz, &rep, _state);
        cntb = cntb+rep.iterationscount;
        
        /*
         * Solve with eigensolver operating in explicit cold-start mode,
         * iteration count based stopping condition.
         */
        for(i=0; i<=n-1; i++)
        {
            u.ptr.p_double[i] = hqrndnormal(&rs, _state);
        }
        rmatrixger(n, n, &ra, 0, 0, nu, &u, 0, &u, 0, _state);
        eigsubspacesetwarmstart(&s, ae_false, _state);
        eigsubspacesolvedenses(&s, &ra, ae_true, &sw, &sz, &rep, _state);
        cntc = cntc+rep.iterationscount;
    }
    ae_set_error_flag(errorflag, ae_fp_greater((double)(cntb),0.66*cnta), __FILE__, __LINE__, "testevdunit.ap:2387");
    ae_set_error_flag(errorflag, ae_fp_less((double)(cntc),0.66*cnta), __FILE__, __LINE__, "testevdunit.ap:2388");
    ae_frame_leave(_state);
}



static void testtrfacunit_testcluproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* err,
     ae_bool* properr,
     ae_state *_state);
static void testtrfacunit_testrluproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* err,
     ae_bool* properr,
     ae_state *_state);
static void testtrfacunit_testdensecholeskyupdates(ae_bool* spdupderrorflag,
     ae_state *_state);





ae_bool testtrfac(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ra;
    ae_matrix ral;
    ae_matrix rau;
    ae_matrix ca;
    ae_matrix cal;
    ae_matrix cau;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t maxmn;
    ae_int_t largemn;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;
    double vr;
    ae_bool waserrors;
    ae_bool dspderr;
    ae_bool sspderr;
    ae_bool srerr;
    ae_bool hpderr;
    ae_bool rerr;
    ae_bool cerr;
    ae_bool properr;
    ae_bool dspdupderr;
    double threshold;
    ae_int_t pass;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&ra, 0, sizeof(ra));
    memset(&ral, 0, sizeof(ral));
    memset(&rau, 0, sizeof(rau));
    memset(&ca, 0, sizeof(ca));
    memset(&cal, 0, sizeof(cal));
    memset(&cau, 0, sizeof(cau));
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ral, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rau, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cal, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cau, 0, 0, DT_COMPLEX, _state, ae_true);

    rerr = ae_false;
    dspderr = ae_false;
    sspderr = ae_false;
    cerr = ae_false;
    hpderr = ae_false;
    properr = ae_false;
    dspdupderr = ae_false;
    srerr = ae_false;
    waserrors = ae_false;
    maxmn = 4*matrixtilesizea(_state)+1;
    largemn = 256;
    threshold = 1000*ae_machineepsilon*maxmn;
    
    /*
     * Sparse Cholesky
     */
    sspderr = sparserealcholeskytest(_state);
    
    /*
     * Sparse LU
     */
    sparsereallutest(&srerr, _state);
    
    /*
     * Cholesky updates
     */
    testtrfacunit_testdensecholeskyupdates(&dspdupderr, _state);
    
    /*
     * test LU:
     * * first, test on small-scale matrices
     * * then, perform several large-scale tests
     */
    for(mx=1; mx<=maxmn; mx++)
    {
        
        /*
         * Initialize N/M, both are <=MX,
         * at least one of them is exactly equal to MX
         */
        n = 1+ae_randominteger(mx, _state);
        m = 1+ae_randominteger(mx, _state);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            n = mx;
        }
        else
        {
            m = mx;
        }
        
        /*
         * First, test on zero matrix
         */
        ae_matrix_set_length(&ra, m, n, _state);
        ae_matrix_set_length(&ca, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = (double)(0);
                ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        testtrfacunit_testcluproblem(&ca, m, n, threshold, &cerr, &properr, _state);
        testtrfacunit_testrluproblem(&ra, m, n, threshold, &rerr, &properr, _state);
        
        /*
         * Second, random matrix with moderate condition number
         */
        ae_matrix_set_length(&ra, m, n, _state);
        ae_matrix_set_length(&ca, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = (double)(0);
                ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        for(i=0; i<=ae_minint(m, n, _state)-1; i++)
        {
            ra.ptr.pp_double[i][i] = 1+10*ae_randomreal(_state);
            ca.ptr.pp_complex[i][i] = ae_complex_from_d(1+10*ae_randomreal(_state));
        }
        cmatrixrndorthogonalfromtheleft(&ca, m, n, _state);
        cmatrixrndorthogonalfromtheright(&ca, m, n, _state);
        rmatrixrndorthogonalfromtheleft(&ra, m, n, _state);
        rmatrixrndorthogonalfromtheright(&ra, m, n, _state);
        testtrfacunit_testcluproblem(&ca, m, n, threshold, &cerr, &properr, _state);
        testtrfacunit_testrluproblem(&ra, m, n, threshold, &rerr, &properr, _state);
    }
    for(pass=1; pass<=2; pass++)
    {
        m = largemn+(ae_randominteger(3, _state)-1);
        n = largemn+(ae_randominteger(3, _state)-1);
        
        /*
         * Random matrix with moderate condition number
         */
        ae_matrix_set_length(&ra, m, n, _state);
        ae_matrix_set_length(&ca, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = (double)(0);
                ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        for(i=0; i<=ae_minint(m, n, _state)-1; i++)
        {
            ra.ptr.pp_double[i][i] = 1+10*ae_randomreal(_state);
            ca.ptr.pp_complex[i][i] = ae_complex_from_d(1+10*ae_randomreal(_state));
        }
        cmatrixrndorthogonalfromtheleft(&ca, m, n, _state);
        cmatrixrndorthogonalfromtheright(&ca, m, n, _state);
        rmatrixrndorthogonalfromtheleft(&ra, m, n, _state);
        rmatrixrndorthogonalfromtheright(&ra, m, n, _state);
        testtrfacunit_testcluproblem(&ca, m, n, threshold, &cerr, &properr, _state);
        testtrfacunit_testrluproblem(&ra, m, n, threshold, &rerr, &properr, _state);
    }
    
    /*
     * Test Cholesky
     */
    for(n=1; n<=maxmn; n++)
    {
        
        /*
         * Load CA (HPD matrix with low condition number),
         *      CAL and CAU - its lower and upper triangles
         */
        hpdmatrixrndcond(n, 1+50*ae_randomreal(_state), &ca, _state);
        ae_matrix_set_length(&cal, n, n, _state);
        ae_matrix_set_length(&cau, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                cal.ptr.pp_complex[i][j] = ae_complex_from_i(i);
                cau.ptr.pp_complex[i][j] = ae_complex_from_i(j);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            ae_v_cmove(&cal.ptr.pp_complex[i][0], 1, &ca.ptr.pp_complex[i][0], 1, "N", ae_v_len(0,i));
            ae_v_cmove(&cau.ptr.pp_complex[i][i], 1, &ca.ptr.pp_complex[i][i], 1, "N", ae_v_len(i,n-1));
        }
        
        /*
         * Test HPDMatrixCholesky:
         * 1. it must leave upper (lower) part unchanged
         * 2. max(A-L*L^H) must be small
         */
        if( hpdmatrixcholesky(&cal, n, ae_false, _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( j>i )
                    {
                        hpderr = hpderr||ae_c_neq_d(cal.ptr.pp_complex[i][j],(double)(i));
                    }
                    else
                    {
                        vc = ae_v_cdotproduct(&cal.ptr.pp_complex[i][0], 1, "N", &cal.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,j));
                        hpderr = hpderr||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[i][j],vc), _state),threshold);
                    }
                }
            }
        }
        else
        {
            hpderr = ae_true;
        }
        if( hpdmatrixcholesky(&cau, n, ae_true, _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( j<i )
                    {
                        hpderr = hpderr||ae_c_neq_d(cau.ptr.pp_complex[i][j],(double)(j));
                    }
                    else
                    {
                        vc = ae_v_cdotproduct(&cau.ptr.pp_complex[0][i], cau.stride, "Conj", &cau.ptr.pp_complex[0][j], cau.stride, "N", ae_v_len(0,i));
                        hpderr = hpderr||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[i][j],vc), _state),threshold);
                    }
                }
            }
        }
        else
        {
            hpderr = ae_true;
        }
        
        /*
         * Load RA (SPD matrix with low condition number),
         *      RAL and RAU - its lower and upper triangles
         *
         * Test SPDMatrixCholesky:
         * 1. it must leave upper (lower) part unchanged
         * 2. max(A-L*L^H) must be small
         *
         * After testing SPDMatrixCholesky() we compare results
         * returned by SparseCholeskyX() against ones returned
         * by SPDMatrixCholesky().
         */
        spdmatrixrndcond(n, 1+50*ae_randomreal(_state), &ra, _state);
        ae_matrix_set_length(&ral, n, n, _state);
        ae_matrix_set_length(&rau, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ral.ptr.pp_double[i][j] = (double)(i);
                rau.ptr.pp_double[i][j] = (double)(j);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            ae_v_move(&ral.ptr.pp_double[i][0], 1, &ra.ptr.pp_double[i][0], 1, ae_v_len(0,i));
            ae_v_move(&rau.ptr.pp_double[i][i], 1, &ra.ptr.pp_double[i][i], 1, ae_v_len(i,n-1));
        }
        if( spdmatrixcholesky(&ral, n, ae_false, _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( j>i )
                    {
                        dspderr = dspderr||ae_fp_neq(ral.ptr.pp_double[i][j],(double)(i));
                    }
                    else
                    {
                        vr = ae_v_dotproduct(&ral.ptr.pp_double[i][0], 1, &ral.ptr.pp_double[j][0], 1, ae_v_len(0,j));
                        dspderr = dspderr||ae_fp_greater(ae_fabs(ra.ptr.pp_double[i][j]-vr, _state),threshold);
                    }
                }
            }
        }
        else
        {
            dspderr = ae_true;
        }
        if( spdmatrixcholesky(&rau, n, ae_true, _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( j<i )
                    {
                        dspderr = dspderr||ae_fp_neq(rau.ptr.pp_double[i][j],(double)(j));
                    }
                    else
                    {
                        vr = ae_v_dotproduct(&rau.ptr.pp_double[0][i], rau.stride, &rau.ptr.pp_double[0][j], rau.stride, ae_v_len(0,i));
                        dspderr = dspderr||ae_fp_greater(ae_fabs(ra.ptr.pp_double[i][j]-vr, _state),threshold);
                    }
                }
            }
        }
        else
        {
            dspderr = ae_true;
        }
        
        /*
         * Check algorithms on negative definite matrices -
         * correct error code must be returned.
         */
        ae_matrix_set_length(&ra, n, n, _state);
        ae_matrix_set_length(&ca, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = 0.0;
                ca.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
            }
            ra.ptr.pp_double[i][i] = 1.0;
            ca.ptr.pp_complex[i][i] = ae_complex_from_d(1.0);
        }
        ra.ptr.pp_double[n/2][n/2] = -1.0;
        ca.ptr.pp_complex[n/2][n/2] = ae_complex_from_d(-1.0);
        ae_set_error_flag(&dspderr, spdmatrixcholesky(&ra, n, ae_fp_greater(ae_randomreal(_state),0.5), _state), __FILE__, __LINE__, "testtrfacunit.ap:509");
        ae_set_error_flag(&hpderr, hpdmatrixcholesky(&ca, n, ae_fp_greater(ae_randomreal(_state),0.5), _state), __FILE__, __LINE__, "testtrfacunit.ap:510");
    }
    
    /*
     * report
     */
    waserrors = ((((((rerr||srerr)||dspderr)||sspderr)||cerr)||hpderr)||properr)||dspdupderr;
    if( !silent )
    {
        printf("TESTING TRIANGULAR FACTORIZATIONS\n");
        printf("* REAL (dense):                          ");
        if( rerr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* REAL (sparse):                         ");
        if( srerr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SPD (dense)                            ");
        if( dspderr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SPD (sparse)                           ");
        if( sspderr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* COMPLEX:                               ");
        if( cerr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* HPD:                                   ");
        if( hpderr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* OTHER PROPERTIES:                      ");
        if( properr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("TESTING UPDATED FACTORIZATIONS\n");
        printf("* SPD (dense)                            ");
        if( dspdupderr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing sparse real Cholesky.
Returns True on errors, False on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
ae_bool sparserealcholeskytest(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t nz;
    double pnz;
    ae_matrix a;
    ae_matrix a1;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double v;
    ae_int_t t0;
    ae_int_t t1;
    ae_bool isupper;
    double offscale;
    double tol;
    sparsematrix sa;
    sparsematrix sa1;
    sparsematrix sc;
    sparsematrix sp;
    sparsebuffers sbuf;
    ae_vector p0;
    ae_vector p1;
    ae_vector d;
    ae_vector b1;
    hqrndstate rs;
    ae_int_t maxfmt;
    ae_int_t minperm;
    ae_int_t maxperm;
    ae_int_t routinetype;
    sparsedecompositionanalysis analysis;
    ae_int_t permtype;
    ae_int_t facttype;
    ae_int_t updatewidth;
    ae_int_t updaterank;
    ae_int_t targetwidth;
    ae_int_t bigsize;
    ae_int_t bottomsize;
    ae_int_t nbetter;
    ae_int_t nworse;
    ae_int_t pass;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&a1, 0, sizeof(a1));
    memset(&sa, 0, sizeof(sa));
    memset(&sa1, 0, sizeof(sa1));
    memset(&sc, 0, sizeof(sc));
    memset(&sp, 0, sizeof(sp));
    memset(&sbuf, 0, sizeof(sbuf));
    memset(&p0, 0, sizeof(p0));
    memset(&p1, 0, sizeof(p1));
    memset(&d, 0, sizeof(d));
    memset(&b1, 0, sizeof(b1));
    memset(&rs, 0, sizeof(rs));
    memset(&analysis, 0, sizeof(analysis));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state, ae_true);
    _sparsematrix_init(&sa, _state, ae_true);
    _sparsematrix_init(&sa1, _state, ae_true);
    _sparsematrix_init(&sc, _state, ae_true);
    _sparsematrix_init(&sp, _state, ae_true);
    _sparsebuffers_init(&sbuf, _state, ae_true);
    ae_vector_init(&p0, 0, DT_INT, _state, ae_true);
    ae_vector_init(&p1, 0, DT_INT, _state, ae_true);
    ae_vector_init(&d, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&b1, 0, DT_BOOL, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);
    _sparsedecompositionanalysis_init(&analysis, _state, ae_true);

    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Settings
     */
    maxfmt = 2;
    minperm = -3;
    maxperm = 3;
    offscale = 1.0E-3;
    tol = 1.0E-8;
    
    /*
     * Modern Cholesky (SparseCholesky, SparseCholeskyP, Analyze/Factorize) tests:
     * performed for positive definite matrices of all sizes in 1..20 and all sparcity percentages.
     */
    for(n=1; n<=30; n++)
    {
        nz = n*n-n;
        for(;;)
        {
            
            /*
             * Generate symmetric N*N matrix where probability of non-diagonal element
             * being non-zero is PNZ. Off-diagonal elements are set to very
             * small values, so positive definiteness is guaranteed.
             */
            if( n>1 )
            {
                pnz = (double)nz/(double)(n*n-n);
            }
            else
            {
                pnz = 1.0;
            }
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=i; j++)
                {
                    if( i==j )
                    {
                        a.ptr.pp_double[i][i] = 1+hqrnduniformr(&rs, _state);
                        continue;
                    }
                    if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                    {
                        a.ptr.pp_double[i][j] = 0.5/n*(hqrnduniformr(&rs, _state)-0.5);
                        a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
                    }
                    else
                    {
                        a.ptr.pp_double[i][j] = 0.0;
                        a.ptr.pp_double[j][i] = 0.0;
                    }
                }
            }
            
            /*
             * Create matrix in hash-based storage format, convert it to random storage format.
             */
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            sparsecreate(n, n, 0, &sa, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i&&!isupper)||(j>=i&&isupper) )
                    {
                        sparseset(&sa, i, j, a.ptr.pp_double[i][j], _state);
                    }
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<i&&isupper)||(j>i&&!isupper) )
                    {
                        if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                        {
                            sparseset(&sa, i, j, hqrndnormal(&rs, _state), _state);
                        }
                    }
                }
            }
            sparseconvertto(&sa, hqrnduniformi(&rs, maxfmt+1, _state), _state);
            
            /*
             * Try various factorization routines:
             * * SparseCholesky() without permutation
             * * SparseCholeskyP()
             * * Analyze/Factorize family of functions
             */
            for(routinetype=0; routinetype<=2; routinetype++)
            {
                
                /*
                 * The factorization
                 */
                sparsecopy(&sa, &sc, _state);
                if( routinetype==0 )
                {
                    
                    /*
                     * Positive-definite Cholesky without permutation
                     */
                    if( !sparsecholesky(&sc, isupper, _state) )
                    {
                        ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:697");
                        ae_frame_leave(_state);
                        return result;
                    }
                    ae_vector_set_length(&p0, n, _state);
                    ae_vector_set_length(&d, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        p0.ptr.p_int[i] = i;
                        d.ptr.p_double[i] = 1.0;
                    }
                }
                if( routinetype==1 )
                {
                    
                    /*
                     * Positive-definite Cholesky with permutation
                     */
                    if( !sparsecholeskyp(&sc, isupper, &p0, _state) )
                    {
                        ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:715");
                        ae_frame_leave(_state);
                        return result;
                    }
                    ae_vector_set_length(&d, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        d.ptr.p_double[i] = 1.0;
                    }
                }
                if( routinetype==2 )
                {
                    
                    /*
                     * Positive-definite analyze/factorize with randomly chosen permutation.
                     * We also check that we may analyze one matrix and factorize another one
                     * with same sparsity pattern.
                     */
                    sparsecopybuf(&sc, &sp, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            if( sparseexists(&sp, i, j, _state) )
                            {
                                sparserewriteexisting(&sp, i, j, 1.0, _state);
                            }
                        }
                    }
                    permtype = minperm+hqrnduniformi(&rs, maxperm-minperm+1, _state);
                    if( ae_fp_greater(hqrndnormal(&rs, _state),(double)(0)) )
                    {
                        
                        /*
                         * Test analyze/factorize sequence
                         */
                        if( !sparsecholeskyanalyze(&sc, isupper, 0, permtype, &analysis, _state) )
                        {
                            ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:742");
                            ae_frame_leave(_state);
                            return result;
                        }
                        sparsecreate(1, 1, 0, &sc, _state);
                        if( !sparsecholeskyfactorize(&analysis, isupper, &sc, &d, &p0, _state) )
                        {
                            ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:748");
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                    else
                    {
                        
                        /*
                         * Test analyze/reload/factorize sequence
                         */
                        if( !sparsecholeskyanalyze(&sp, isupper, 0, permtype, &analysis, _state) )
                        {
                            ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:759");
                            ae_frame_leave(_state);
                            return result;
                        }
                        sparsecholeskyreload(&analysis, &sc, isupper, _state);
                        sparsecreate(1, 1, 0, &sc, _state);
                        if( !sparsecholeskyfactorize(&analysis, isupper, &sc, &d, &p0, _state) )
                        {
                            ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:766");
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                    if( d.cnt!=n )
                    {
                        ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:772");
                        ae_frame_leave(_state);
                        return result;
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        ae_set_error_flag(&result, ae_fp_neq(d.ptr.p_double[i],1.0), __FILE__, __LINE__, "testtrfacunit.ap:776");
                    }
                }
                
                /*
                 * Check output sizes and formats
                 */
                ae_set_error_flag(&result, (!sparseiscrs(&sc, _state)||sparsegetnrows(&sc, _state)!=n)||sparsegetncols(&sc, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:784");
                ae_set_error_flag(&result, p0.cnt!=n, __FILE__, __LINE__, "testtrfacunit.ap:785");
                ae_set_error_flag(&result, d.cnt!=n, __FILE__, __LINE__, "testtrfacunit.ap:786");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    ae_set_error_flag(&result, p0.ptr.p_int[i]<i||p0.ptr.p_int[i]>=n, __FILE__, __LINE__, "testtrfacunit.ap:791");
                    ae_set_error_flag(&result, !ae_isfinite(d.ptr.p_double[i], _state), __FILE__, __LINE__, "testtrfacunit.ap:792");
                }
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                t0 = 0;
                t1 = 0;
                while(sparseenumerate(&sc, &t0, &t1, &i, &j, &v, _state))
                {
                    ae_set_error_flag(&result, j<i&&isupper, __FILE__, __LINE__, "testtrfacunit.ap:800");
                    ae_set_error_flag(&result, j>i&&!isupper, __FILE__, __LINE__, "testtrfacunit.ap:801");
                }
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                
                /*
                 * Now, test correctness of Cholesky decomposition itself.
                 * We calculate U'*U (or L*L') and check it against permutation
                 * of A given by P0.
                 *
                 * NOTE: we expect that only one triangle of SC is filled,
                 *       and another one is exactly zero.
                 */
                ae_matrix_set_length(&a1, n, n, _state);
                if( isupper )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            v = 0.0;
                            for(k=0; k<=n-1; k++)
                            {
                                v = v+sparseget(&sc, k, j, _state)*d.ptr.p_double[k]*sparseget(&sc, k, i, _state);
                            }
                            a1.ptr.pp_double[i][j] = v;
                        }
                    }
                }
                else
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            v = 0.0;
                            for(k=0; k<=n-1; k++)
                            {
                                v = v+sparseget(&sc, j, k, _state)*d.ptr.p_double[k]*sparseget(&sc, i, k, _state);
                            }
                            a1.ptr.pp_double[i][j] = v;
                        }
                    }
                }
                for(i=n-1; i>=0; i--)
                {
                    swaprows(&a1, i, p0.ptr.p_int[i], n, _state);
                    swapcols(&a1, i, p0.ptr.p_int[i], n, _state);
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a1.ptr.pp_double[i][j], _state),tol), __FILE__, __LINE__, "testtrfacunit.ap:844");
                    }
                }
            }
            
            /*
             * Check handling of degenerate problems: zeros at main diagonal, negative definite matrices
             */
            for(routinetype=0; routinetype<=1; routinetype++)
            {
                
                /*
                 * Exact zero at diagonal
                 */
                sparsecopy(&sa, &sc, _state);
                sparseconverttohash(&sc, _state);
                k = hqrnduniformi(&rs, n, _state);
                sparseset(&sc, k, k, (double)(0), _state);
                sparseconvertto(&sc, hqrnduniformi(&rs, maxfmt+1, _state), _state);
                if( routinetype==0 )
                {
                    ae_set_error_flag(&result, sparsecholesky(&sc, isupper, _state), __FILE__, __LINE__, "testtrfacunit.ap:861");
                }
                if( routinetype==1 )
                {
                    ae_set_error_flag(&result, sparsecholeskyp(&sc, isupper, &p0, _state), __FILE__, __LINE__, "testtrfacunit.ap:863");
                }
                
                /*
                 * Negative definite matrix
                 */
                sparsecopy(&sa, &sc, _state);
                sparseconverttohash(&sc, _state);
                k = hqrnduniformi(&rs, n, _state);
                sparseset(&sc, k, k, -1.0E10, _state);
                sparseconvertto(&sc, hqrnduniformi(&rs, maxfmt+1, _state), _state);
                if( routinetype==0 )
                {
                    ae_set_error_flag(&result, sparsecholesky(&sc, isupper, _state), __FILE__, __LINE__, "testtrfacunit.ap:874");
                }
                if( routinetype==1 )
                {
                    ae_set_error_flag(&result, sparsecholeskyp(&sc, isupper, &p0, _state), __FILE__, __LINE__, "testtrfacunit.ap:876");
                }
            }
            
            /*
             * Increase problem sparcity and try one more time. 
             * Stop after testing NZ=0.
             */
            if( nz==0 )
            {
                break;
            }
            nz = nz/2;
        }
    }
    
    /*
     * Negative definite LDLT factorization: performed for matrices with various sparsity factors
     */
    for(n=1; n<=30; n++)
    {
        nz = n*n-n;
        for(;;)
        {
            
            /*
             * Generate symmetric N*N matrix where probability of non-diagonal element
             * being non-zero is PNZ. Off-diagonal elements are set to very
             * small values, so positive definiteness is guaranteed.
             */
            if( n>1 )
            {
                pnz = (double)nz/(double)(n*n-n);
            }
            else
            {
                pnz = 1.0;
            }
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=i; j++)
                {
                    if( i==j )
                    {
                        a.ptr.pp_double[i][i] = possign(hqrndnormal(&rs, _state), _state)*(1+hqrnduniformr(&rs, _state));
                        continue;
                    }
                    if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                    {
                        a.ptr.pp_double[i][j] = 0.5/n*(hqrnduniformr(&rs, _state)-0.5);
                        a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
                    }
                    else
                    {
                        a.ptr.pp_double[i][j] = 0.0;
                        a.ptr.pp_double[j][i] = 0.0;
                    }
                }
            }
            
            /*
             * Create matrix in hash-based storage format, convert it to random storage format.
             */
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            sparsecreate(n, n, 0, &sa, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i&&!isupper)||(j>=i&&isupper) )
                    {
                        sparseset(&sa, i, j, a.ptr.pp_double[i][j], _state);
                    }
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<i&&isupper)||(j>i&&!isupper) )
                    {
                        if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                        {
                            sparseset(&sa, i, j, hqrndnormal(&rs, _state), _state);
                        }
                    }
                }
            }
            sparseconvertto(&sa, hqrnduniformi(&rs, maxfmt+1, _state), _state);
            
            /*
             * Try Analyze/Factorize family of functions
             */
            sparsecopy(&sa, &sc, _state);
            sparsecopybuf(&sc, &sp, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( sparseexists(&sp, i, j, _state) )
                    {
                        sparserewriteexisting(&sp, i, j, 1.0, _state);
                    }
                }
            }
            facttype = 1;
            permtype = minperm+hqrnduniformi(&rs, maxperm-minperm+1, _state);
            if( ae_fp_greater(hqrndnormal(&rs, _state),(double)(0)) )
            {
                
                /*
                 * Test analyze/factorize sequence
                 */
                if( !sparsecholeskyanalyze(&sc, isupper, facttype, permtype, &analysis, _state) )
                {
                    ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:961");
                    ae_frame_leave(_state);
                    return result;
                }
                sparsecreate(1, 1, 0, &sc, _state);
                if( !sparsecholeskyfactorize(&analysis, isupper, &sc, &d, &p0, _state) )
                {
                    ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:967");
                    ae_frame_leave(_state);
                    return result;
                }
            }
            else
            {
                
                /*
                 * Test analyze/reload/factorize sequence
                 */
                if( !sparsecholeskyanalyze(&sp, isupper, facttype, permtype, &analysis, _state) )
                {
                    ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:978");
                    ae_frame_leave(_state);
                    return result;
                }
                sparsecholeskyreload(&analysis, &sc, isupper, _state);
                sparsecreate(1, 1, 0, &sc, _state);
                if( !sparsecholeskyfactorize(&analysis, isupper, &sc, &d, &p0, _state) )
                {
                    ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:985");
                    ae_frame_leave(_state);
                    return result;
                }
            }
            
            /*
             * Check output sizes and formats
             */
            ae_set_error_flag(&result, (!sparseiscrs(&sc, _state)||sparsegetnrows(&sc, _state)!=n)||sparsegetncols(&sc, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:993");
            ae_set_error_flag(&result, p0.cnt!=n, __FILE__, __LINE__, "testtrfacunit.ap:994");
            ae_set_error_flag(&result, d.cnt!=n, __FILE__, __LINE__, "testtrfacunit.ap:995");
            if( result )
            {
                ae_frame_leave(_state);
                return result;
            }
            for(i=0; i<=n-1; i++)
            {
                ae_set_error_flag(&result, p0.ptr.p_int[i]<i||p0.ptr.p_int[i]>=n, __FILE__, __LINE__, "testtrfacunit.ap:1000");
                ae_set_error_flag(&result, !ae_isfinite(d.ptr.p_double[i], _state), __FILE__, __LINE__, "testtrfacunit.ap:1001");
            }
            if( result )
            {
                ae_frame_leave(_state);
                return result;
            }
            t0 = 0;
            t1 = 0;
            while(sparseenumerate(&sc, &t0, &t1, &i, &j, &v, _state))
            {
                ae_set_error_flag(&result, j<i&&isupper, __FILE__, __LINE__, "testtrfacunit.ap:1009");
                ae_set_error_flag(&result, j>i&&!isupper, __FILE__, __LINE__, "testtrfacunit.ap:1010");
            }
            if( result )
            {
                ae_frame_leave(_state);
                return result;
            }
            
            /*
             * Now, test correctness of Cholesky decomposition itself.
             * We calculate U'*U (or L*L') and check it against permutation
             * of A given by P0.
             *
             * NOTE: we expect that only one triangle of SC is filled,
             *       and another one is exactly zero.
             */
            ae_matrix_set_length(&a1, n, n, _state);
            if( isupper )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = 0.0;
                        for(k=0; k<=n-1; k++)
                        {
                            v = v+sparseget(&sc, k, j, _state)*d.ptr.p_double[k]*sparseget(&sc, k, i, _state);
                        }
                        a1.ptr.pp_double[i][j] = v;
                    }
                }
            }
            else
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = 0.0;
                        for(k=0; k<=n-1; k++)
                        {
                            v = v+sparseget(&sc, j, k, _state)*d.ptr.p_double[k]*sparseget(&sc, i, k, _state);
                        }
                        a1.ptr.pp_double[i][j] = v;
                    }
                }
            }
            for(i=n-1; i>=0; i--)
            {
                swaprows(&a1, i, p0.ptr.p_int[i], n, _state);
                swapcols(&a1, i, p0.ptr.p_int[i], n, _state);
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ae_set_error_flag(&result, ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a1.ptr.pp_double[i][j], _state),tol), __FILE__, __LINE__, "testtrfacunit.ap:1053");
                }
            }
            
            /*
             * Increase problem sparcity and try one more time. 
             * Stop after testing NZ=0.
             */
            if( nz==0 )
            {
                break;
            }
            nz = nz/2;
        }
    }
    
    /*
     * Basis test of modified Cholesky.
     *
     * We do not perform deep tests here, basically the fact that with diagonal modification
     * we can complete factorization that can't be completed without modification.
     */
    for(n=1; n<=30; n++)
    {
        nz = n*n-n;
        for(;;)
        {
            
            /*
             * Generate symmetric N*N matrix where probability of non-diagonal element
             * being non-zero is PNZ. One of diagonal elements is guaranteed to be
             * negative in order to test modification strategy.
             */
            if( n>1 )
            {
                pnz = (double)nz/(double)(n*n-n);
            }
            else
            {
                pnz = 1.0;
            }
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=i; j++)
                {
                    if( i==j )
                    {
                        a.ptr.pp_double[i][i] = hqrndnormal(&rs, _state);
                        continue;
                    }
                    if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                    {
                        a.ptr.pp_double[i][j] = 0.5/n*(hqrnduniformr(&rs, _state)-0.5);
                        a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
                    }
                    else
                    {
                        a.ptr.pp_double[i][j] = 0.0;
                        a.ptr.pp_double[j][i] = 0.0;
                    }
                }
            }
            i = hqrnduniformi(&rs, n, _state);
            a.ptr.pp_double[i][i] = (double)(-1);
            sparsecreate(n, n, 0, &sa, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i&&!isupper)||(j>=i&&isupper) )
                    {
                        sparseset(&sa, i, j, a.ptr.pp_double[i][j], _state);
                    }
                }
            }
            
            /*
             * Try Analyze/Factorize family of functions
             */
            facttype = 0;
            permtype = minperm+hqrnduniformi(&rs, maxperm-minperm+1, _state);
            sparsecopy(&sa, &sc, _state);
            if( !sparsecholeskyanalyze(&sc, isupper, facttype, permtype, &analysis, _state) )
            {
                ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:1121");
                ae_frame_leave(_state);
                return result;
            }
            if( sparsecholeskyfactorize(&analysis, isupper, &sc, &d, &p0, _state) )
            {
                ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:1126");
                ae_frame_leave(_state);
                return result;
            }
            sparsecopy(&sa, &sc, _state);
            sparsecholeskysetmodtype(&analysis, 1, 1.0, (double)(0), (double)(0), (double)(0), _state);
            sparsecholeskyreload(&analysis, &sc, isupper, _state);
            if( !sparsecholeskyfactorize(&analysis, isupper, &sc, &d, &p0, _state) )
            {
                ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:1134");
                ae_frame_leave(_state);
                return result;
            }
            
            /*
             * Increase problem sparcity and try one more time. 
             * Stop after testing NZ=0.
             */
            if( nz==0 )
            {
                break;
            }
            nz = nz/2;
        }
    }
    
    /*
     * Specially designed matrix that allows us to test all internal supernodal update kernels,
     * with all update ranks, update widths, target widths
     */
    updaterank = 1;
    updatewidth = 3;
    targetwidth = updatewidth;
    for(updaterank=1; updaterank<=spsymmgetmaxfastkernel(_state); updaterank++)
    {
        for(updatewidth=1; updatewidth<=spsymmgetmaxfastkernel(_state); updatewidth++)
        {
            for(targetwidth=updatewidth; targetwidth<=spsymmgetmaxfastkernel(_state); targetwidth++)
            {
                
                /*
                 * Generate test matrix A:
                 *
                 * [ U                  ]
                 * [ UU                 ]
                 * [ UUU                ]
                 * [ UUUT               ]
                 * [ UUUTT              ]
                 * [ UUUTTT             ]
                 * [    TTTT            ]
                 * [    TTTTR           ]
                 * [    TTTTRR          ]
                 * [    TTTTRRR         ]
                 * [    TTTTRRRR        ]
                 * [    TTTTRRRRR       ]
                 * [        RRRRRR      ]
                 * [        RRRRRRR     ]
                 * [        RRRRRRRR    ]
                 * [        RRRRRRRRR   ]
                 * [ UUUTTTTRRRRRRRRRR  ]
                 * [ UUUTTTTRRRRRRRRRRR ]
                 *
                 * where U is update matrix, T is target matrix, heights of U and T are chosen in
                 * such a way that supernode T will NOT be merged with supernode U, their sizes
                 * are chosen to investigate all possible kinds of update kernels. The residual
                 * R is also chosen in such a way that it is NOT merged with T.
                 */
                bigsize = 10;
                bottomsize = 2+hqrnduniformi(&rs, 10, _state);
                n = updaterank+targetwidth+2*bigsize+bottomsize;
                ae_matrix_set_length(&a, n, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( i==j )
                        {
                            a.ptr.pp_double[i][j] = 1+hqrnduniformr(&rs, _state);
                        }
                        else
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
                for(j=0; j<=updaterank-1; j++)
                {
                    for(i=j+1; i<=updaterank+updatewidth-1; i++)
                    {
                        a.ptr.pp_double[i][j] = 0.5/n*(hqrnduniformr(&rs, _state)-0.5);
                    }
                    for(i=n-bottomsize; i<=n-1; i++)
                    {
                        a.ptr.pp_double[i][j] = 0.5/n*(hqrnduniformr(&rs, _state)-0.5);
                    }
                }
                for(j=updaterank; j<=updaterank+targetwidth-1; j++)
                {
                    for(i=j+1; i<=updaterank+targetwidth+bigsize-1; i++)
                    {
                        a.ptr.pp_double[i][j] = 0.5/n*(hqrnduniformr(&rs, _state)-0.5);
                    }
                    for(i=n-bottomsize; i<=n-1; i++)
                    {
                        a.ptr.pp_double[i][j] = 0.5/n*(hqrnduniformr(&rs, _state)-0.5);
                    }
                }
                for(j=updaterank+targetwidth; j<=n-1; j++)
                {
                    for(i=j+1; i<=n-1; i++)
                    {
                        a.ptr.pp_double[i][j] = 0.5/n*(hqrnduniformr(&rs, _state)-0.5);
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=i-1; j++)
                    {
                        a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
                    }
                }
                
                /*
                 * Create matrix in hash-based storage format
                 */
                isupper = ae_false;
                sparsecreate(n, n, 0, &sa, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        sparseset(&sa, i, j, a.ptr.pp_double[i][j], _state);
                    }
                }
                
                /*
                 * Try analysis with random permutation and factorization
                 */
                facttype = hqrnduniformi(&rs, 2, _state);
                permtype = minperm+hqrnduniformi(&rs, maxperm-minperm+1, _state);
                if( !sparsecholeskyanalyze(&sa, isupper, facttype, permtype, &analysis, _state) )
                {
                    ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:1234");
                    ae_frame_leave(_state);
                    return result;
                }
                if( !sparsecholeskyfactorize(&analysis, isupper, &sc, &d, &p0, _state) )
                {
                    ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:1239");
                    ae_frame_leave(_state);
                    return result;
                }
                
                /*
                 * Check output sizes and formats
                 */
                ae_set_error_flag(&result, (!sparseiscrs(&sc, _state)||sparsegetnrows(&sc, _state)!=n)||sparsegetncols(&sc, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:1247");
                ae_set_error_flag(&result, p0.cnt!=n, __FILE__, __LINE__, "testtrfacunit.ap:1248");
                ae_set_error_flag(&result, d.cnt!=n, __FILE__, __LINE__, "testtrfacunit.ap:1249");
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    ae_set_error_flag(&result, p0.ptr.p_int[i]<i||p0.ptr.p_int[i]>=n, __FILE__, __LINE__, "testtrfacunit.ap:1254");
                    ae_set_error_flag(&result, !ae_isfinite(d.ptr.p_double[i], _state), __FILE__, __LINE__, "testtrfacunit.ap:1255");
                }
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                t0 = 0;
                t1 = 0;
                while(sparseenumerate(&sc, &t0, &t1, &i, &j, &v, _state))
                {
                    ae_set_error_flag(&result, j<i&&isupper, __FILE__, __LINE__, "testtrfacunit.ap:1263");
                    ae_set_error_flag(&result, j>i&&!isupper, __FILE__, __LINE__, "testtrfacunit.ap:1264");
                }
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                
                /*
                 * Now, test correctness of Cholesky decomposition itself.
                 * We calculate U'*U (or L*L') and check it against permutation
                 * of A given by P0.
                 *
                 * NOTE: we expect that only one triangle of SC is filled,
                 *       and another one is exactly zero.
                 */
                ae_matrix_set_length(&a1, n, n, _state);
                if( isupper )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            v = 0.0;
                            for(k=0; k<=n-1; k++)
                            {
                                v = v+sparseget(&sc, k, j, _state)*d.ptr.p_double[k]*sparseget(&sc, k, i, _state);
                            }
                            a1.ptr.pp_double[i][j] = v;
                        }
                    }
                }
                else
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            v = 0.0;
                            for(k=0; k<=n-1; k++)
                            {
                                v = v+sparseget(&sc, j, k, _state)*d.ptr.p_double[k]*sparseget(&sc, i, k, _state);
                            }
                            a1.ptr.pp_double[i][j] = v;
                        }
                    }
                }
                for(i=n-1; i>=0; i--)
                {
                    swaprows(&a1, i, p0.ptr.p_int[i], n, _state);
                    swapcols(&a1, i, p0.ptr.p_int[i], n, _state);
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a1.ptr.pp_double[i][j], _state),tol), __FILE__, __LINE__, "testtrfacunit.ap:1307");
                    }
                }
            }
        }
    }
    
    /*
     * SparseCholeskySkyline test: performed for matrices
     * of all sizes in 1..20 and all sparcity percentages.
     */
    for(n=1; n<=20; n++)
    {
        nz = n*n-n;
        for(;;)
        {
            
            /*
             * Choose IsUpper - main triangle to work with.
             *
             * Generate A - symmetric N*N matrix where probability of non-diagonal
             * element being non-zero is PNZ. Off-diagonal elements are set to
             * very small values, so positive definiteness is guaranteed. Full matrix
             * is generated.
             *
             * Additionally, we create A1 - same as A, but one of the triangles is
             * asymmetrically spoiled. If IsUpper is True, we spoil lower one, or vice versa.
             */
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            if( n>1 )
            {
                pnz = (double)nz/(double)(n*n-n);
            }
            else
            {
                pnz = 1.0;
            }
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=i; j++)
                {
                    if( i==j )
                    {
                        a.ptr.pp_double[i][i] = 1+hqrnduniformr(&rs, _state);
                        continue;
                    }
                    if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                    {
                        a.ptr.pp_double[i][j] = offscale*(hqrnduniformr(&rs, _state)-0.5);
                        a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
                    }
                    else
                    {
                        a.ptr.pp_double[i][j] = 0.0;
                        a.ptr.pp_double[j][i] = 0.0;
                    }
                }
            }
            ae_matrix_set_length(&a1, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i&&!isupper)||(j>=i&&isupper) )
                    {
                        
                        /*
                         * Copy one triangle
                         */
                        a1.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
                    }
                    else
                    {
                        
                        /*
                         * Form another sparse pattern in different triangle.
                         */
                        if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                        {
                            a1.ptr.pp_double[i][j] = offscale*(hqrnduniformr(&rs, _state)-0.5);
                        }
                        else
                        {
                            a1.ptr.pp_double[i][j] = 0.0;
                        }
                    }
                }
            }
            
            /*
             * Create copies of A and A1 in hash-based storage format.
             * Only one triangle of A is copied, but A1 is copied fully.
             * Convert them to SKS
             */
            sparsecreate(n, n, 0, &sa, _state);
            sparsecreate(n, n, 0, &sa1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i&&!isupper)||(j>=i&&isupper) )
                    {
                        sparseset(&sa, i, j, a.ptr.pp_double[i][j], _state);
                    }
                    sparseset(&sa1, i, j, a1.ptr.pp_double[i][j], _state);
                }
            }
            sparseconverttosks(&sa, _state);
            sparseconverttosks(&sa1, _state);
            
            /*
             * Call SparseCholeskySkyline() for SA and make several tests:
             * * check that it is still SKS
             * * check that it has correct size (exactly N*N)
             * * check that correct triangle is returned (and another one is unchanged - zero)
             * * check that it is correct Cholesky decomposition.
             *   We calculate U'*U (or L*L') and check at against A. We expect
             *   that only one triangle of SA is filled, and another one is
             *   exactly zero.
             */
            if( !sparsecholeskyskyline(&sa, n, isupper, _state) )
            {
                ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:1409");
                ae_frame_leave(_state);
                return result;
            }
            ae_set_error_flag(&result, !sparseissks(&sa, _state), __FILE__, __LINE__, "testtrfacunit.ap:1412");
            ae_set_error_flag(&result, sparsegetncols(&sa, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:1413");
            ae_set_error_flag(&result, sparsegetnrows(&sa, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:1414");
            t0 = 0;
            t1 = 0;
            while(sparseenumerate(&sa, &t0, &t1, &i, &j, &v, _state))
            {
                ae_set_error_flag(&result, j<i&&isupper, __FILE__, __LINE__, "testtrfacunit.ap:1419");
                ae_set_error_flag(&result, j>i&&!isupper, __FILE__, __LINE__, "testtrfacunit.ap:1420");
            }
            if( isupper )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = 0.0;
                        for(k=0; k<=n-1; k++)
                        {
                            v = v+sparseget(&sa, k, j, _state)*sparseget(&sa, k, i, _state);
                        }
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-v, _state),tol), __FILE__, __LINE__, "testtrfacunit.ap:1430");
                    }
                }
            }
            else
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = 0.0;
                        for(k=0; k<=n-1; k++)
                        {
                            v = v+sparseget(&sa, j, k, _state)*sparseget(&sa, i, k, _state);
                        }
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-v, _state),tol), __FILE__, __LINE__, "testtrfacunit.ap:1441");
                    }
                }
            }
            
            /*
             * Call SparseCholeskySkyline() for SA1 and make several tests:
             * * check that it is still SKS
             * * check that it has correct size (exactly N*N)
             * * check that factorized triangle matches contents of SA,
             *   and another triangle was unchanged (matches contents of A1).
             */
            if( !sparsecholeskyskyline(&sa1, n, isupper, _state) )
            {
                ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:1454");
                ae_frame_leave(_state);
                return result;
            }
            ae_set_error_flag(&result, !sparseissks(&sa1, _state), __FILE__, __LINE__, "testtrfacunit.ap:1457");
            ae_set_error_flag(&result, sparsegetncols(&sa1, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:1458");
            ae_set_error_flag(&result, sparsegetnrows(&sa1, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:1459");
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i&&!isupper)||(j>=i&&isupper) )
                    {
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&sa1, i, j, _state)-sparseget(&sa, i, j, _state), _state),10*ae_machineepsilon), __FILE__, __LINE__, "testtrfacunit.ap:1463");
                    }
                    else
                    {
                        ae_set_error_flag(&result, ae_fp_greater(ae_fabs(sparseget(&sa1, i, j, _state)-a1.ptr.pp_double[i][j], _state),10*ae_machineepsilon), __FILE__, __LINE__, "testtrfacunit.ap:1465");
                    }
                }
            }
            
            /*
             * Increase problem sparcity and try one more time. 
             * Stop after testing NZ=0.
             */
            if( nz==0 )
            {
                break;
            }
            nz = nz/2;
        }
    }
    
    /*
     * Test fill-in reducing permutation - on average, AMD and its variants must reduce fill-in.
     * We check it by factorizing many matrices with AMD and without it, and by comparing average
     * fill-in produced during the factorization.
     *
     * Test matrices being factorized are ones with mostly low-degree rows/cols, but (sometimes)
     * a few nearly dense rows/cols.
     */
    for(permtype=0; permtype<=maxperm; permtype++)
    {
        
        /*
         * Evaluate all orderings except for supernodal one (does not reduce fill-in)
         */
        if( permtype==1 )
        {
            continue;
        }
        
        /*
         * Compare fill-in with ordering and without it
         */
        nbetter = 0;
        nworse = 0;
        for(pass=0; pass<=99; pass++)
        {
            
            /*
             * Generate test matrix:
             * * first, fill it with unit diagonal and typically 2 off-diagonal elements per row/col
             * * then, make some small number of rows/cols dense
             */
            n = 30+hqrnduniformi(&rs, 20, _state);
            sparsecreate(n, n, 0, &sa, _state);
            for(i=0; i<=n-1; i++)
            {
                sparseset(&sa, i, i, 1.0, _state);
                for(k=1; k<=2; k++)
                {
                    j = hqrnduniformi(&rs, n, _state);
                    if( j!=i )
                    {
                        sparseset(&sa, i, j, 0.01/n, _state);
                        sparseset(&sa, j, i, 0.01/n, _state);
                    }
                }
            }
            while(ae_fp_greater(hqrndnormal(&rs, _state),(double)(0)))
            {
                i = hqrnduniformi(&rs, n, _state);
                for(j=0; j<=n-1; j++)
                {
                    if( j!=i )
                    {
                        sparseset(&sa, i, j, 0.01/n, _state);
                        sparseset(&sa, j, i, 0.01/n, _state);
                    }
                }
            }
            sparsecopy(&sa, &sa1, _state);
            
            /*
             * Factorize with AMD and without it
             */
            if( !sparsecholeskyanalyze(&sa, ae_false, 0, permtype, &analysis, _state) )
            {
                ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:1537");
                ae_frame_leave(_state);
                return result;
            }
            if( !sparsecholeskyfactorize(&analysis, ae_false, &sa, &d, &p0, _state) )
            {
                ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:1542");
                ae_frame_leave(_state);
                return result;
            }
            if( !sparsecholeskyanalyze(&sa1, ae_false, 0, -2, &analysis, _state) )
            {
                ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:1547");
                ae_frame_leave(_state);
                return result;
            }
            if( !sparsecholeskyfactorize(&analysis, ae_false, &sa1, &d, &p0, _state) )
            {
                ae_set_error_flag(&result, ae_true, __FILE__, __LINE__, "testtrfacunit.ap:1552");
                ae_frame_leave(_state);
                return result;
            }
            if( sa.ridx.ptr.p_int[n]<sa1.ridx.ptr.p_int[n] )
            {
                inc(&nbetter, _state);
            }
            else
            {
                inc(&nworse, _state);
            }
        }
        ae_set_error_flag(&result, ae_fp_less((double)(nbetter),0.75*(nbetter+nworse)), __FILE__, __LINE__, "testtrfacunit.ap:1560");
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing sparse real LU decomposition.
Sets error flag on failure, leave is unchanged on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
void sparsereallutest(ae_bool* err, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t nz;
    double pnz;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double v;
    ae_matrix a;
    ae_matrix b1;
    ae_matrix b2;
    ae_matrix c;
    ae_vector pivr;
    ae_vector pivc;
    sparsematrix sa;
    sparsematrix crsa;
    ae_bool success;
    double tol;
    ae_bool haszero;
    ae_int_t pivottype;
    hqrndstate rs;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&b1, 0, sizeof(b1));
    memset(&b2, 0, sizeof(b2));
    memset(&c, 0, sizeof(c));
    memset(&pivr, 0, sizeof(pivr));
    memset(&pivc, 0, sizeof(pivc));
    memset(&sa, 0, sizeof(sa));
    memset(&crsa, 0, sizeof(crsa));
    memset(&rs, 0, sizeof(rs));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&pivr, 0, DT_INT, _state, ae_true);
    ae_vector_init(&pivc, 0, DT_INT, _state, ae_true);
    _sparsematrix_init(&sa, _state, ae_true);
    _sparsematrix_init(&crsa, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    hqrndrandomize(&rs, _state);
    tol = 1.0E4*ae_machineepsilon;
    
    /*
     * Test matrix sizes in 1...20 and with all sparsity percentages
     */
    for(n=1; n<=20; n++)
    {
        nz = n*n;
        for(;;)
        {
            
            /*
             * Generate N*N matrix where probability of element being
             * non-zero is PNZ. Create sparse matrix in hash-based storage format.
             */
            pnz = (double)nz/(double)(n*n);
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                    {
                        a.ptr.pp_double[i][j] = hqrndnormal(&rs, _state);
                    }
                    else
                    {
                        a.ptr.pp_double[i][j] = 0.0;
                    }
                }
            }
            sparsecreate(n, n, 0, &sa, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    sparseset(&sa, i, j, a.ptr.pp_double[i][j], _state);
                }
            }
            
            /*
             * Test SparseLU()
             */
            for(pivottype=0; pivottype<=2; pivottype++)
            {
                sparsecopytocrs(&sa, &crsa, _state);
                ae_vector_set_length(&pivr, 0, _state);
                ae_vector_set_length(&pivc, 0, _state);
                success = sparselu(&crsa, pivottype, &pivr, &pivc, _state);
                ae_set_error_flag(err, !sparseiscrs(&crsa, _state), __FILE__, __LINE__, "testtrfacunit.ap:1630");
                ae_set_error_flag(err, sparsegetncols(&crsa, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:1631");
                ae_set_error_flag(err, sparsegetnrows(&crsa, _state)!=n, __FILE__, __LINE__, "testtrfacunit.ap:1632");
                ae_set_error_flag(err, pivr.cnt!=n, __FILE__, __LINE__, "testtrfacunit.ap:1633");
                ae_set_error_flag(err, pivc.cnt!=n, __FILE__, __LINE__, "testtrfacunit.ap:1634");
                if( *err )
                {
                    ae_frame_leave(_state);
                    return;
                }
                for(i=0; i<=n-1; i++)
                {
                    ae_set_error_flag(err, ((pivr.ptr.p_int[i]<0||pivr.ptr.p_int[i]>=n)||pivc.ptr.p_int[i]<0)||pivc.ptr.p_int[i]>=n, __FILE__, __LINE__, "testtrfacunit.ap:1638");
                }
                for(i=0; i<=n-1; i++)
                {
                    ae_set_error_flag(err, pivottype==1&&pivc.ptr.p_int[i]!=i, __FILE__, __LINE__, "testtrfacunit.ap:1640");
                }
                ae_matrix_set_length(&b1, n, n, _state);
                ae_matrix_set_length(&b2, n, n, _state);
                haszero = ae_false;
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=i-1; j++)
                    {
                        b1.ptr.pp_double[i][j] = sparseget(&crsa, i, j, _state);
                    }
                    b1.ptr.pp_double[i][i] = (double)(1);
                    for(j=i+1; j<=n-1; j++)
                    {
                        b1.ptr.pp_double[i][j] = (double)(0);
                    }
                    for(j=0; j<=i-1; j++)
                    {
                        b2.ptr.pp_double[i][j] = (double)(0);
                    }
                    for(j=i; j<=n-1; j++)
                    {
                        b2.ptr.pp_double[i][j] = sparseget(&crsa, i, j, _state);
                    }
                    haszero = haszero||ae_fp_eq(b2.ptr.pp_double[i][i],(double)(0));
                }
                ae_matrix_set_length(&c, n, n, _state);
                rmatrixgemm(n, n, n, 1.0, &b1, 0, 0, 0, &b2, 0, 0, 0, 0.0, &c, 0, 0, _state);
                for(i=n-1; i>=0; i--)
                {
                    j = pivr.ptr.p_int[i];
                    for(k=0; k<=n-1; k++)
                    {
                        v = c.ptr.pp_double[i][k];
                        c.ptr.pp_double[i][k] = c.ptr.pp_double[j][k];
                        c.ptr.pp_double[j][k] = v;
                    }
                }
                for(i=n-1; i>=0; i--)
                {
                    j = pivc.ptr.p_int[i];
                    for(k=0; k<=n-1; k++)
                    {
                        v = c.ptr.pp_double[k][i];
                        c.ptr.pp_double[k][i] = c.ptr.pp_double[k][j];
                        c.ptr.pp_double[k][j] = v;
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ae_set_error_flag(err, ae_fp_greater(ae_fabs(c.ptr.pp_double[i][j]-a.ptr.pp_double[i][j], _state),tol), __FILE__, __LINE__, "testtrfacunit.ap:1689");
                    }
                }
                ae_set_error_flag(err, (success&&haszero)||(!haszero&&!success), __FILE__, __LINE__, "testtrfacunit.ap:1690");
            }
            
            /*
             * Increase problem sparcity and try one more time. 
             * Stop after testing NZ=0.
             */
            if( nz==0 )
            {
                break;
            }
            nz = nz/2;
        }
    }
    ae_frame_leave(_state);
}


static void testtrfacunit_testcluproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* err,
     ae_bool* properr,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ca;
    ae_matrix cl;
    ae_matrix cu;
    ae_matrix ca2;
    ae_vector ct;
    ae_int_t i;
    ae_int_t j;
    ae_int_t minmn;
    ae_complex v;
    ae_vector p;

    ae_frame_make(_state, &_frame_block);
    memset(&ca, 0, sizeof(ca));
    memset(&cl, 0, sizeof(cl));
    memset(&cu, 0, sizeof(cu));
    memset(&ca2, 0, sizeof(ca2));
    memset(&ct, 0, sizeof(ct));
    memset(&p, 0, sizeof(p));
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cl, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cu, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ca2, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&ct, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);

    minmn = ae_minint(m, n, _state);
    
    /*
     * PLU test
     */
    ae_matrix_set_length(&ca, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_cmove(&ca.ptr.pp_complex[i][0], 1, &a->ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1));
    }
    cmatrixplu(&ca, m, n, &p, _state);
    for(i=0; i<=minmn-1; i++)
    {
        if( p.ptr.p_int[i]<i||p.ptr.p_int[i]>=m )
        {
            *properr = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    ae_matrix_set_length(&cl, m, minmn, _state);
    for(j=0; j<=minmn-1; j++)
    {
        for(i=0; i<=j-1; i++)
        {
            cl.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
        }
        cl.ptr.pp_complex[j][j] = ae_complex_from_d(1.0);
        for(i=j+1; i<=m-1; i++)
        {
            cl.ptr.pp_complex[i][j] = ca.ptr.pp_complex[i][j];
        }
    }
    ae_matrix_set_length(&cu, minmn, n, _state);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=0; j<=i-1; j++)
        {
            cu.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
        }
        for(j=i; j<=n-1; j++)
        {
            cu.ptr.pp_complex[i][j] = ca.ptr.pp_complex[i][j];
        }
    }
    ae_matrix_set_length(&ca2, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&cl.ptr.pp_complex[i][0], 1, "N", &cu.ptr.pp_complex[0][j], cu.stride, "N", ae_v_len(0,minmn-1));
            ca2.ptr.pp_complex[i][j] = v;
        }
    }
    ae_vector_set_length(&ct, n, _state);
    for(i=minmn-1; i>=0; i--)
    {
        if( i!=p.ptr.p_int[i] )
        {
            ae_v_cmove(&ct.ptr.p_complex[0], 1, &ca2.ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1));
            ae_v_cmove(&ca2.ptr.pp_complex[i][0], 1, &ca2.ptr.pp_complex[p.ptr.p_int[i]][0], 1, "N", ae_v_len(0,n-1));
            ae_v_cmove(&ca2.ptr.pp_complex[p.ptr.p_int[i]][0], 1, &ct.ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *err = *err||ae_fp_greater(ae_c_abs(ae_c_sub(a->ptr.pp_complex[i][j],ca2.ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    
    /*
     * LUP test
     */
    ae_matrix_set_length(&ca, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_cmove(&ca.ptr.pp_complex[i][0], 1, &a->ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1));
    }
    cmatrixlup(&ca, m, n, &p, _state);
    for(i=0; i<=minmn-1; i++)
    {
        if( p.ptr.p_int[i]<i||p.ptr.p_int[i]>=n )
        {
            *properr = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    ae_matrix_set_length(&cl, m, minmn, _state);
    for(j=0; j<=minmn-1; j++)
    {
        for(i=0; i<=j-1; i++)
        {
            cl.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
        }
        for(i=j; i<=m-1; i++)
        {
            cl.ptr.pp_complex[i][j] = ca.ptr.pp_complex[i][j];
        }
    }
    ae_matrix_set_length(&cu, minmn, n, _state);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=0; j<=i-1; j++)
        {
            cu.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
        }
        cu.ptr.pp_complex[i][i] = ae_complex_from_d(1.0);
        for(j=i+1; j<=n-1; j++)
        {
            cu.ptr.pp_complex[i][j] = ca.ptr.pp_complex[i][j];
        }
    }
    ae_matrix_set_length(&ca2, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&cl.ptr.pp_complex[i][0], 1, "N", &cu.ptr.pp_complex[0][j], cu.stride, "N", ae_v_len(0,minmn-1));
            ca2.ptr.pp_complex[i][j] = v;
        }
    }
    ae_vector_set_length(&ct, m, _state);
    for(i=minmn-1; i>=0; i--)
    {
        if( i!=p.ptr.p_int[i] )
        {
            ae_v_cmove(&ct.ptr.p_complex[0], 1, &ca2.ptr.pp_complex[0][i], ca2.stride, "N", ae_v_len(0,m-1));
            ae_v_cmove(&ca2.ptr.pp_complex[0][i], ca2.stride, &ca2.ptr.pp_complex[0][p.ptr.p_int[i]], ca2.stride, "N", ae_v_len(0,m-1));
            ae_v_cmove(&ca2.ptr.pp_complex[0][p.ptr.p_int[i]], ca2.stride, &ct.ptr.p_complex[0], 1, "N", ae_v_len(0,m-1));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *err = *err||ae_fp_greater(ae_c_abs(ae_c_sub(a->ptr.pp_complex[i][j],ca2.ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    ae_frame_leave(_state);
}


static void testtrfacunit_testrluproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* err,
     ae_bool* properr,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ca;
    ae_matrix cl;
    ae_matrix cu;
    ae_matrix ca2;
    ae_vector ct;
    ae_int_t i;
    ae_int_t j;
    ae_int_t minmn;
    double v;
    ae_vector p;

    ae_frame_make(_state, &_frame_block);
    memset(&ca, 0, sizeof(ca));
    memset(&cl, 0, sizeof(cl));
    memset(&cu, 0, sizeof(cu));
    memset(&ca2, 0, sizeof(ca2));
    memset(&ct, 0, sizeof(ct));
    memset(&p, 0, sizeof(p));
    ae_matrix_init(&ca, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cl, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cu, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ca2, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ct, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);

    minmn = ae_minint(m, n, _state);
    
    /*
     * PLU test
     */
    ae_matrix_set_length(&ca, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_move(&ca.ptr.pp_double[i][0], 1, &a->ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
    }
    rmatrixplu(&ca, m, n, &p, _state);
    for(i=0; i<=minmn-1; i++)
    {
        if( p.ptr.p_int[i]<i||p.ptr.p_int[i]>=m )
        {
            *properr = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    ae_matrix_set_length(&cl, m, minmn, _state);
    for(j=0; j<=minmn-1; j++)
    {
        for(i=0; i<=j-1; i++)
        {
            cl.ptr.pp_double[i][j] = 0.0;
        }
        cl.ptr.pp_double[j][j] = 1.0;
        for(i=j+1; i<=m-1; i++)
        {
            cl.ptr.pp_double[i][j] = ca.ptr.pp_double[i][j];
        }
    }
    ae_matrix_set_length(&cu, minmn, n, _state);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=0; j<=i-1; j++)
        {
            cu.ptr.pp_double[i][j] = 0.0;
        }
        for(j=i; j<=n-1; j++)
        {
            cu.ptr.pp_double[i][j] = ca.ptr.pp_double[i][j];
        }
    }
    ae_matrix_set_length(&ca2, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&cl.ptr.pp_double[i][0], 1, &cu.ptr.pp_double[0][j], cu.stride, ae_v_len(0,minmn-1));
            ca2.ptr.pp_double[i][j] = v;
        }
    }
    ae_vector_set_length(&ct, n, _state);
    for(i=minmn-1; i>=0; i--)
    {
        if( i!=p.ptr.p_int[i] )
        {
            ae_v_move(&ct.ptr.p_double[0], 1, &ca2.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
            ae_v_move(&ca2.ptr.pp_double[i][0], 1, &ca2.ptr.pp_double[p.ptr.p_int[i]][0], 1, ae_v_len(0,n-1));
            ae_v_move(&ca2.ptr.pp_double[p.ptr.p_int[i]][0], 1, &ct.ptr.p_double[0], 1, ae_v_len(0,n-1));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *err = *err||ae_fp_greater(ae_fabs(a->ptr.pp_double[i][j]-ca2.ptr.pp_double[i][j], _state),threshold);
        }
    }
    
    /*
     * LUP test
     */
    ae_matrix_set_length(&ca, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_move(&ca.ptr.pp_double[i][0], 1, &a->ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
    }
    rmatrixlup(&ca, m, n, &p, _state);
    for(i=0; i<=minmn-1; i++)
    {
        if( p.ptr.p_int[i]<i||p.ptr.p_int[i]>=n )
        {
            *properr = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    ae_matrix_set_length(&cl, m, minmn, _state);
    for(j=0; j<=minmn-1; j++)
    {
        for(i=0; i<=j-1; i++)
        {
            cl.ptr.pp_double[i][j] = 0.0;
        }
        for(i=j; i<=m-1; i++)
        {
            cl.ptr.pp_double[i][j] = ca.ptr.pp_double[i][j];
        }
    }
    ae_matrix_set_length(&cu, minmn, n, _state);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=0; j<=i-1; j++)
        {
            cu.ptr.pp_double[i][j] = 0.0;
        }
        cu.ptr.pp_double[i][i] = 1.0;
        for(j=i+1; j<=n-1; j++)
        {
            cu.ptr.pp_double[i][j] = ca.ptr.pp_double[i][j];
        }
    }
    ae_matrix_set_length(&ca2, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&cl.ptr.pp_double[i][0], 1, &cu.ptr.pp_double[0][j], cu.stride, ae_v_len(0,minmn-1));
            ca2.ptr.pp_double[i][j] = v;
        }
    }
    ae_vector_set_length(&ct, m, _state);
    for(i=minmn-1; i>=0; i--)
    {
        if( i!=p.ptr.p_int[i] )
        {
            ae_v_move(&ct.ptr.p_double[0], 1, &ca2.ptr.pp_double[0][i], ca2.stride, ae_v_len(0,m-1));
            ae_v_move(&ca2.ptr.pp_double[0][i], ca2.stride, &ca2.ptr.pp_double[0][p.ptr.p_int[i]], ca2.stride, ae_v_len(0,m-1));
            ae_v_move(&ca2.ptr.pp_double[0][p.ptr.p_int[i]], ca2.stride, &ct.ptr.p_double[0], 1, ae_v_len(0,m-1));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *err = *err||ae_fp_greater(ae_fabs(a->ptr.pp_double[i][j]-ca2.ptr.pp_double[i][j], _state),threshold);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Function for testing dense Cholesky updates
Sets error flag to True on errors, does not change it on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
static void testtrfacunit_testdensecholeskyupdates(ae_bool* spdupderrorflag,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    double pfix;
    ae_matrix a0;
    ae_matrix a1;
    ae_vector u;
    ae_vector fix;
    ae_int_t i;
    ae_int_t j;
    ae_bool isupper;
    double tol;
    ae_vector bufr;
    hqrndstate rs;

    ae_frame_make(_state, &_frame_block);
    memset(&a0, 0, sizeof(a0));
    memset(&a1, 0, sizeof(a1));
    memset(&u, 0, sizeof(u));
    memset(&fix, 0, sizeof(fix));
    memset(&bufr, 0, sizeof(bufr));
    memset(&rs, 0, sizeof(rs));
    ae_matrix_init(&a0, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&u, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&fix, 0, DT_BOOL, _state, ae_true);
    ae_vector_init(&bufr, 0, DT_REAL, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    hqrndrandomize(&rs, _state);
    
    /*
     * Settings
     */
    tol = 1.0E-8;
    
    /*
     * Test rank-1 updates
     *
     * For each matrix size in 1..30 select sparse update vector with probability of element
     * being non-zero equal to 1/2.
     */
    for(n=1; n<=30; n++)
    {
        
        /*
         * Generate two matrices A0=A1, fill one triangle with SPD matrix,
         * another one with trash. Prepare vector U.
         */
        isupper = ae_fp_less(hqrnduniformr(&rs, _state),0.5);
        spdmatrixrndcond(n, 1.0E4, &a0, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( (j<i&&isupper)||(j>i&&!isupper) )
                {
                    a0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                }
            }
        }
        ae_matrix_set_length(&a1, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a1.ptr.pp_double[i][j] = a0.ptr.pp_double[i][j];
            }
        }
        ae_vector_set_length(&u, n, _state);
        for(i=0; i<=n-1; i++)
        {
            if( ae_fp_less_eq(hqrnduniformr(&rs, _state),0.5) )
            {
                u.ptr.p_double[i] = hqrnduniformr(&rs, _state)-0.5;
            }
            else
            {
                u.ptr.p_double[i] = (double)(0);
            }
        }
        
        /*
         * Factorize and compare:
         * * A0 is factorized as follows: first with full Cholesky, then
         *   we call SPDMatrixCholeskyUpdateAdd1
         * * A1 is transformed explicitly before factorization with full Cholesky
         *
         * We randomly test either SPDMatrixCholeskyUpdateFix() or its
         * buffered version, SPDMatrixCholeskyUpdateFixBuf()
         */
        ae_set_error_flag(spdupderrorflag, !spdmatrixcholesky(&a0, n, isupper, _state), __FILE__, __LINE__, "testtrfacunit.ap:1772");
        if( *spdupderrorflag )
        {
            ae_frame_leave(_state);
            return;
        }
        if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
        {
            spdmatrixcholeskyupdateadd1(&a0, n, isupper, &u, _state);
        }
        else
        {
            spdmatrixcholeskyupdateadd1buf(&a0, n, isupper, &u, &bufr, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( (j>=i&&isupper)||(j<=i&&!isupper) )
                {
                    a1.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j]+u.ptr.p_double[i]*u.ptr.p_double[j];
                }
            }
        }
        ae_set_error_flag(spdupderrorflag, !spdmatrixcholesky(&a1, n, isupper, _state), __FILE__, __LINE__, "testtrfacunit.ap:1783");
        if( *spdupderrorflag )
        {
            ae_frame_leave(_state);
            return;
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ae_set_error_flag(spdupderrorflag, ae_fp_greater(ae_fabs(a0.ptr.pp_double[i][j]-a1.ptr.pp_double[i][j], _state),tol), __FILE__, __LINE__, "testtrfacunit.ap:1788");
            }
        }
    }
    
    /*
     * Test variable fixing functions.
     *
     * For each matrix size in 1..30 select PFix - probability of each variable being fixed,
     * and perform test.
     */
    for(n=1; n<=30; n++)
    {
        
        /*
         * Generate two matrices A0=A1, fill one triangle with SPD matrix,
         * another one with trash. Prepare vector Fix.
         */
        pfix = (double)hqrnduniformi(&rs, n+1, _state)/(double)n;
        isupper = ae_fp_less(hqrnduniformr(&rs, _state),0.5);
        spdmatrixrndcond(n, 1.0E4, &a0, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( (j<i&&isupper)||(j>i&&!isupper) )
                {
                    a0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                }
            }
        }
        ae_matrix_set_length(&a1, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a1.ptr.pp_double[i][j] = a0.ptr.pp_double[i][j];
            }
        }
        ae_vector_set_length(&fix, n, _state);
        for(i=0; i<=n-1; i++)
        {
            fix.ptr.p_bool[i] = ae_fp_less_eq(hqrnduniformr(&rs, _state),pfix);
        }
        
        /*
         * Factorize and compare:
         * * A0 is factorized as follows: first with full Cholesky, then
         *   variables are fixed with SPDMatrixCholeskyUpdateFix
         * * A1 is fixed explicitly before factorization with full Cholesky
         *
         * We randomly test either SPDMatrixCholeskyUpdateFix() or its
         * buffered version, SPDMatrixCholeskyUpdateFixBuf()
         */
        ae_set_error_flag(spdupderrorflag, !spdmatrixcholesky(&a0, n, isupper, _state), __FILE__, __LINE__, "testtrfacunit.ap:1827");
        if( *spdupderrorflag )
        {
            ae_frame_leave(_state);
            return;
        }
        if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
        {
            spdmatrixcholeskyupdatefixbuf(&a0, n, isupper, &fix, &bufr, _state);
        }
        else
        {
            spdmatrixcholeskyupdatefix(&a0, n, isupper, &fix, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( (j>=i&&isupper)||(j<=i&&!isupper) )
                {
                    if( fix.ptr.p_bool[i]||fix.ptr.p_bool[j] )
                    {
                        if( i==j )
                        {
                            a1.ptr.pp_double[i][j] = (double)(1);
                        }
                        else
                        {
                            a1.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
            }
        }
        ae_set_error_flag(spdupderrorflag, !spdmatrixcholesky(&a1, n, isupper, _state), __FILE__, __LINE__, "testtrfacunit.ap:1844");
        if( *spdupderrorflag )
        {
            ae_frame_leave(_state);
            return;
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ae_set_error_flag(spdupderrorflag, ae_fp_greater(ae_fabs(a0.ptr.pp_double[i][j]-a1.ptr.pp_double[i][j], _state),tol), __FILE__, __LINE__, "testtrfacunit.ap:1849");
            }
        }
    }
    ae_frame_leave(_state);
}








/*************************************************************************
Test
*************************************************************************/
ae_bool testpolynomialsolver(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool wereerrors;
    ae_vector a;
    ae_vector x;
    double eps;
    ae_int_t n;
    polynomialsolverreport rep;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&x, 0, sizeof(x));
    memset(&rep, 0, sizeof(rep));
    ae_vector_init(&a, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&x, 0, DT_COMPLEX, _state, ae_true);
    _polynomialsolverreport_init(&rep, _state, ae_true);

    wereerrors = ae_false;
    
    /*
     * Basic tests
     */
    eps = 1.0E-6;
    n = 1;
    ae_vector_set_length(&a, n+1, _state);
    a.ptr.p_double[0] = (double)(2);
    a.ptr.p_double[1] = (double)(3);
    polynomialsolve(&a, n, &x, &rep, _state);
    ae_set_error_flag(&wereerrors, ae_fp_greater(ae_fabs(x.ptr.p_complex[0].x+(double)2/(double)3, _state),eps), __FILE__, __LINE__, "testpolynomialsolverunit.ap:33");
    ae_set_error_flag(&wereerrors, ae_fp_neq(x.ptr.p_complex[0].y,(double)(0)), __FILE__, __LINE__, "testpolynomialsolverunit.ap:34");
    ae_set_error_flag(&wereerrors, ae_fp_greater(rep.maxerr,100*ae_machineepsilon), __FILE__, __LINE__, "testpolynomialsolverunit.ap:35");
    n = 2;
    ae_vector_set_length(&a, n+1, _state);
    a.ptr.p_double[0] = (double)(1);
    a.ptr.p_double[1] = (double)(-2);
    a.ptr.p_double[2] = (double)(1);
    polynomialsolve(&a, n, &x, &rep, _state);
    ae_set_error_flag(&wereerrors, ae_fp_greater(ae_c_abs(ae_c_sub_d(x.ptr.p_complex[0],1), _state),eps), __FILE__, __LINE__, "testpolynomialsolverunit.ap:43");
    ae_set_error_flag(&wereerrors, ae_fp_greater(ae_c_abs(ae_c_sub_d(x.ptr.p_complex[1],1), _state),eps), __FILE__, __LINE__, "testpolynomialsolverunit.ap:44");
    ae_set_error_flag(&wereerrors, ae_fp_greater(rep.maxerr,100*ae_machineepsilon), __FILE__, __LINE__, "testpolynomialsolverunit.ap:45");
    n = 2;
    ae_vector_set_length(&a, n+1, _state);
    a.ptr.p_double[0] = (double)(2);
    a.ptr.p_double[1] = (double)(-3);
    a.ptr.p_double[2] = (double)(1);
    polynomialsolve(&a, n, &x, &rep, _state);
    if( ae_fp_less(x.ptr.p_complex[0].x,x.ptr.p_complex[1].x) )
    {
        ae_set_error_flag(&wereerrors, ae_fp_greater(ae_fabs(x.ptr.p_complex[0].x-1, _state),eps), __FILE__, __LINE__, "testpolynomialsolverunit.ap:55");
        ae_set_error_flag(&wereerrors, ae_fp_greater(ae_fabs(x.ptr.p_complex[1].x-2, _state),eps), __FILE__, __LINE__, "testpolynomialsolverunit.ap:56");
    }
    else
    {
        ae_set_error_flag(&wereerrors, ae_fp_greater(ae_fabs(x.ptr.p_complex[0].x-2, _state),eps), __FILE__, __LINE__, "testpolynomialsolverunit.ap:60");
        ae_set_error_flag(&wereerrors, ae_fp_greater(ae_fabs(x.ptr.p_complex[1].x-1, _state),eps), __FILE__, __LINE__, "testpolynomialsolverunit.ap:61");
    }
    ae_set_error_flag(&wereerrors, ae_fp_neq(x.ptr.p_complex[0].y,(double)(0)), __FILE__, __LINE__, "testpolynomialsolverunit.ap:63");
    ae_set_error_flag(&wereerrors, ae_fp_neq(x.ptr.p_complex[1].y,(double)(0)), __FILE__, __LINE__, "testpolynomialsolverunit.ap:64");
    ae_set_error_flag(&wereerrors, ae_fp_greater(rep.maxerr,100*ae_machineepsilon), __FILE__, __LINE__, "testpolynomialsolverunit.ap:65");
    n = 2;
    ae_vector_set_length(&a, n+1, _state);
    a.ptr.p_double[0] = (double)(1);
    a.ptr.p_double[1] = (double)(0);
    a.ptr.p_double[2] = (double)(1);
    polynomialsolve(&a, n, &x, &rep, _state);
    ae_set_error_flag(&wereerrors, ae_fp_greater(ae_c_abs(ae_c_add_d(ae_c_mul(x.ptr.p_complex[0],x.ptr.p_complex[0]),(double)(1)), _state),eps), __FILE__, __LINE__, "testpolynomialsolverunit.ap:73");
    ae_set_error_flag(&wereerrors, ae_fp_greater(rep.maxerr,100*ae_machineepsilon), __FILE__, __LINE__, "testpolynomialsolverunit.ap:74");
    n = 4;
    ae_vector_set_length(&a, n+1, _state);
    a.ptr.p_double[0] = (double)(0);
    a.ptr.p_double[1] = (double)(0);
    a.ptr.p_double[2] = (double)(0);
    a.ptr.p_double[3] = (double)(0);
    a.ptr.p_double[4] = (double)(1);
    polynomialsolve(&a, n, &x, &rep, _state);
    ae_set_error_flag(&wereerrors, ae_c_neq_d(x.ptr.p_complex[0],(double)(0)), __FILE__, __LINE__, "testpolynomialsolverunit.ap:84");
    ae_set_error_flag(&wereerrors, ae_c_neq_d(x.ptr.p_complex[1],(double)(0)), __FILE__, __LINE__, "testpolynomialsolverunit.ap:85");
    ae_set_error_flag(&wereerrors, ae_c_neq_d(x.ptr.p_complex[2],(double)(0)), __FILE__, __LINE__, "testpolynomialsolverunit.ap:86");
    ae_set_error_flag(&wereerrors, ae_c_neq_d(x.ptr.p_complex[3],(double)(0)), __FILE__, __LINE__, "testpolynomialsolverunit.ap:87");
    ae_set_error_flag(&wereerrors, ae_fp_greater(rep.maxerr,100*ae_machineepsilon), __FILE__, __LINE__, "testpolynomialsolverunit.ap:88");
    n = 2;
    ae_vector_set_length(&a, n+1, _state);
    a.ptr.p_double[0] = (double)(0);
    a.ptr.p_double[1] = (double)(3);
    a.ptr.p_double[2] = (double)(2);
    polynomialsolve(&a, n, &x, &rep, _state);
    if( ae_fp_greater(x.ptr.p_complex[0].x,x.ptr.p_complex[1].x) )
    {
        ae_set_error_flag(&wereerrors, ae_c_neq_d(x.ptr.p_complex[0],(double)(0)), __FILE__, __LINE__, "testpolynomialsolverunit.ap:98");
        ae_set_error_flag(&wereerrors, ae_fp_greater(ae_fabs(x.ptr.p_complex[1].x+(double)3/(double)2, _state),eps), __FILE__, __LINE__, "testpolynomialsolverunit.ap:99");
        ae_set_error_flag(&wereerrors, ae_fp_neq(x.ptr.p_complex[1].y,(double)(0)), __FILE__, __LINE__, "testpolynomialsolverunit.ap:100");
    }
    else
    {
        ae_set_error_flag(&wereerrors, ae_c_neq_d(x.ptr.p_complex[1],(double)(0)), __FILE__, __LINE__, "testpolynomialsolverunit.ap:104");
        ae_set_error_flag(&wereerrors, ae_fp_greater(ae_fabs(x.ptr.p_complex[0].x+(double)3/(double)2, _state),eps), __FILE__, __LINE__, "testpolynomialsolverunit.ap:105");
        ae_set_error_flag(&wereerrors, ae_fp_neq(x.ptr.p_complex[0].y,(double)(0)), __FILE__, __LINE__, "testpolynomialsolverunit.ap:106");
    }
    ae_set_error_flag(&wereerrors, ae_fp_greater(rep.maxerr,100*ae_machineepsilon), __FILE__, __LINE__, "testpolynomialsolverunit.ap:108");
    if( !silent )
    {
        printf("TESTING POLYNOMIAL SOLVER\n");
        if( wereerrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
    }
    result = !wereerrors;
    ae_frame_leave(_state);
    return result;
}



static void testbdsvdunit_fillidentity(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static void testbdsvdunit_fillsparsede(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double sparcity,
     ae_state *_state);
static void testbdsvdunit_getbdsvderror(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool isupper,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_matrix* c,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_state *_state);
static void testbdsvdunit_checksvdmultiplication(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool isupper,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_matrix* c,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* err,
     ae_state *_state);
static void testbdsvdunit_testbdsvdproblem(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_bool* wfailed,
     ae_int_t* failcount,
     ae_int_t* succcount,
     ae_state *_state);





/*************************************************************************
Testing bidiagonal SVD decomposition subroutine
*************************************************************************/
ae_bool testbdsvd(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector d;
    ae_vector e;
    ae_matrix mempty;
    ae_int_t n;
    ae_int_t maxn;
    ae_int_t i;
    ae_int_t pass;
    ae_bool waserrors;
    ae_bool wsorted;
    ae_bool wfailed;
    double materr;
    double orterr;
    double threshold;
    double failr;
    ae_int_t failcount;
    ae_int_t succcount;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&d, 0, sizeof(d));
    memset(&e, 0, sizeof(e));
    memset(&mempty, 0, sizeof(mempty));
    ae_vector_init(&d, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&e, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&mempty, 0, 0, DT_REAL, _state, ae_true);

    failcount = 0;
    succcount = 0;
    materr = (double)(0);
    orterr = (double)(0);
    wsorted = ae_true;
    wfailed = ae_false;
    waserrors = ae_false;
    maxn = 15;
    threshold = 5*100*ae_machineepsilon;
    ae_vector_set_length(&d, maxn-1+1, _state);
    ae_vector_set_length(&e, maxn-2+1, _state);
    
    /*
     * special case: zero divide matrix
     * unfixed LAPACK routine should fail on this problem
     */
    n = 7;
    d.ptr.p_double[0] = -6.96462904751731892700e-01;
    d.ptr.p_double[1] = 0.00000000000000000000e+00;
    d.ptr.p_double[2] = -5.73827770385971991400e-01;
    d.ptr.p_double[3] = -6.62562624399371191700e-01;
    d.ptr.p_double[4] = 5.82737148001782223600e-01;
    d.ptr.p_double[5] = 3.84825263580925003300e-01;
    d.ptr.p_double[6] = 9.84087420830525472200e-01;
    e.ptr.p_double[0] = -7.30307931760612871800e-02;
    e.ptr.p_double[1] = -2.30079042939542843800e-01;
    e.ptr.p_double[2] = -6.87824621739351216300e-01;
    e.ptr.p_double[3] = -1.77306437707837570600e-02;
    e.ptr.p_double[4] = 1.78285126526551632000e-15;
    e.ptr.p_double[5] = -4.89434737751289969400e-02;
    rmatrixbdsvd(&d, &e, n, ae_true, ae_false, &mempty, 0, &mempty, 0, &mempty, 0, _state);
    
    /*
     * zero matrix, several cases
     */
    for(i=0; i<=maxn-1; i++)
    {
        d.ptr.p_double[i] = (double)(0);
    }
    for(i=0; i<=maxn-2; i++)
    {
        e.ptr.p_double[i] = (double)(0);
    }
    for(n=1; n<=maxn; n++)
    {
        testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
    }
    
    /*
     * Dense matrix
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=10; pass++)
        {
            for(i=0; i<=maxn-1; i++)
            {
                d.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            for(i=0; i<=maxn-2; i++)
            {
                e.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
        }
    }
    
    /*
     * Sparse matrices, very sparse matrices, incredible sparse matrices
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=10; pass++)
        {
            testbdsvdunit_fillsparsede(&d, &e, n, 0.5, _state);
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
            testbdsvdunit_fillsparsede(&d, &e, n, 0.8, _state);
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
            testbdsvdunit_fillsparsede(&d, &e, n, 0.9, _state);
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
            testbdsvdunit_fillsparsede(&d, &e, n, 0.95, _state);
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
        }
    }
    
    /*
     * report
     */
    failr = (double)failcount/(double)(succcount+failcount);
    waserrors = ((wfailed||ae_fp_greater(materr,threshold))||ae_fp_greater(orterr,threshold))||!wsorted;
    if( !silent )
    {
        printf("TESTING BIDIAGONAL SVD DECOMPOSITION\n");
        printf("SVD decomposition error:                 %5.3e\n",
            (double)(materr));
        printf("SVD orthogonality error:                 %5.3e\n",
            (double)(orterr));
        printf("Singular values order:                   ");
        if( wsorted )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("Always converged:                        ");
        if( !wfailed )
        {
            printf("YES\n");
        }
        else
        {
            printf("NO\n");
            printf("Fail ratio:                              %5.3f\n",
                (double)(failr));
        }
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


static void testbdsvdunit_fillidentity(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    ae_matrix_set_length(a, n-1+1, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( i==j )
            {
                a->ptr.pp_double[i][j] = (double)(1);
            }
            else
            {
                a->ptr.pp_double[i][j] = (double)(0);
            }
        }
    }
}


static void testbdsvdunit_fillsparsede(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double sparcity,
     ae_state *_state)
{
    ae_int_t i;


    ae_vector_set_length(d, n-1+1, _state);
    ae_vector_set_length(e, ae_maxint(0, n-2, _state)+1, _state);
    for(i=0; i<=n-1; i++)
    {
        if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
        {
            d->ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        else
        {
            d->ptr.p_double[i] = (double)(0);
        }
    }
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
        {
            e->ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        else
        {
            e->ptr.p_double[i] = (double)(0);
        }
    }
}


static void testbdsvdunit_getbdsvderror(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool isupper,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_matrix* c,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double locerr;
    double sm;


    
    /*
     * decomposition error
     */
    locerr = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            sm = (double)(0);
            for(k=0; k<=n-1; k++)
            {
                sm = sm+w->ptr.p_double[k]*u->ptr.pp_double[i][k]*vt->ptr.pp_double[k][j];
            }
            if( isupper )
            {
                if( i==j )
                {
                    locerr = ae_maxreal(locerr, ae_fabs(d->ptr.p_double[i]-sm, _state), _state);
                }
                else
                {
                    if( i==j-1 )
                    {
                        locerr = ae_maxreal(locerr, ae_fabs(e->ptr.p_double[i]-sm, _state), _state);
                    }
                    else
                    {
                        locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
                    }
                }
            }
            else
            {
                if( i==j )
                {
                    locerr = ae_maxreal(locerr, ae_fabs(d->ptr.p_double[i]-sm, _state), _state);
                }
                else
                {
                    if( i-1==j )
                    {
                        locerr = ae_maxreal(locerr, ae_fabs(e->ptr.p_double[j]-sm, _state), _state);
                    }
                    else
                    {
                        locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
                    }
                }
            }
        }
    }
    *materr = ae_maxreal(*materr, locerr, _state);
    
    /*
     * check for C = U'
     * we consider it as decomposition error
     */
    locerr = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            locerr = ae_maxreal(locerr, ae_fabs(u->ptr.pp_double[i][j]-c->ptr.pp_double[j][i], _state), _state);
        }
    }
    *materr = ae_maxreal(*materr, locerr, _state);
    
    /*
     * orthogonality error
     */
    locerr = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=i; j<=n-1; j++)
        {
            sm = ae_v_dotproduct(&u->ptr.pp_double[0][i], u->stride, &u->ptr.pp_double[0][j], u->stride, ae_v_len(0,n-1));
            if( i!=j )
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
            }
            else
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm-1, _state), _state);
            }
            sm = ae_v_dotproduct(&vt->ptr.pp_double[i][0], 1, &vt->ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i!=j )
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
            }
            else
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm-1, _state), _state);
            }
        }
    }
    *orterr = ae_maxreal(*orterr, locerr, _state);
    
    /*
     * values order error
     */
    for(i=1; i<=n-1; i++)
    {
        if( ae_fp_greater(w->ptr.p_double[i],w->ptr.p_double[i-1]) )
        {
            *wsorted = ae_false;
        }
    }
}


static void testbdsvdunit_checksvdmultiplication(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool isupper,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_matrix* c,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* err,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_vector wt;
    ae_matrix u2;
    ae_matrix c2;
    ae_matrix vt2;
    ae_matrix u1;
    ae_matrix c1;
    ae_matrix vt1;
    ae_int_t nru;
    ae_int_t ncc;
    ae_int_t ncvt;
    ae_int_t pass;
    hqrndstate rs;
    double v;

    ae_frame_make(_state, &_frame_block);
    memset(&wt, 0, sizeof(wt));
    memset(&u2, 0, sizeof(u2));
    memset(&c2, 0, sizeof(c2));
    memset(&vt2, 0, sizeof(vt2));
    memset(&u1, 0, sizeof(u1));
    memset(&c1, 0, sizeof(c1));
    memset(&vt1, 0, sizeof(vt1));
    memset(&rs, 0, sizeof(rs));
    ae_vector_init(&wt, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&u2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&vt2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&u1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c1, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&vt1, 0, 0, DT_REAL, _state, ae_true);
    _hqrndstate_init(&rs, _state, ae_true);

    hqrndrandomize(&rs, _state);
    ae_vector_set_length(&wt, n, _state);
    
    /*
     * Perform nonsquare SVD
     */
    for(pass=1; pass<=20; pass++)
    {
        
        /*
         * Problem size
         */
        nru = hqrnduniformi(&rs, 2*n, _state);
        ncc = hqrnduniformi(&rs, 2*n, _state);
        ncvt = hqrnduniformi(&rs, 2*n, _state);
        
        /*
         * Reference matrices (copy 1) and working matrices (copy 2)
         */
        for(i=0; i<=n-1; i++)
        {
            wt.ptr.p_double[i] = d->ptr.p_double[i];
        }
        if( nru>0 )
        {
            
            /*
             * init U1/U2
             */
            ae_matrix_set_length(&u1, nru, n, _state);
            ae_matrix_set_length(&u2, nru, n, _state);
            for(i=0; i<=u1.rows-1; i++)
            {
                for(j=0; j<=u1.cols-1; j++)
                {
                    u1.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                    u2.ptr.pp_double[i][j] = u1.ptr.pp_double[i][j];
                }
            }
        }
        else
        {
            
            /*
             * Set U1/U2 to 1x1 matrices; working with 1x1 matrices allows
             * to test correctness of code which passes them to MKL.
             */
            ae_matrix_set_length(&u1, 1, 1, _state);
            ae_matrix_set_length(&u2, 1, 1, _state);
        }
        if( ncc>0 )
        {
            ae_matrix_set_length(&c1, n, ncc, _state);
            ae_matrix_set_length(&c2, n, ncc, _state);
            for(i=0; i<=c1.rows-1; i++)
            {
                for(j=0; j<=c1.cols-1; j++)
                {
                    c1.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                    c2.ptr.pp_double[i][j] = c1.ptr.pp_double[i][j];
                }
            }
        }
        else
        {
            
            /*
             * Set C1/C1 to 1x1 matrices; working with 1x1 matrices allows
             * to test correctness of code which passes them to MKL.
             */
            ae_matrix_set_length(&c1, 1, 1, _state);
            ae_matrix_set_length(&c2, 1, 1, _state);
        }
        if( ncvt>0 )
        {
            ae_matrix_set_length(&vt1, n, ncvt, _state);
            ae_matrix_set_length(&vt2, n, ncvt, _state);
            for(i=0; i<=vt1.rows-1; i++)
            {
                for(j=0; j<=vt1.cols-1; j++)
                {
                    vt1.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                    vt2.ptr.pp_double[i][j] = vt1.ptr.pp_double[i][j];
                }
            }
        }
        else
        {
            
            /*
             * Set VT1/VT1 to 1x1 matrices; working with 1x1 matrices allows
             * to test correctness of code which passes them to MKL.
             */
            ae_matrix_set_length(&vt1, 1, 1, _state);
            ae_matrix_set_length(&vt2, 1, 1, _state);
        }
        
        /*
         * SVD with non-square U/C/VT
         */
        if( !rmatrixbdsvd(&wt, e, n, isupper, ae_fp_greater(hqrnduniformr(&rs, _state),(double)(0)), &u2, nru, &c2, ncc, &vt2, ncvt, _state) )
        {
            *err = 1.0;
            ae_frame_leave(_state);
            return;
        }
        for(i=0; i<=nru-1; i++)
        {
            for(j=0; j<=u2.cols-1; j++)
            {
                v = ae_v_dotproduct(&u1.ptr.pp_double[i][0], 1, &u->ptr.pp_double[0][j], u->stride, ae_v_len(0,n-1));
                *err = ae_maxreal(*err, ae_fabs(v-u2.ptr.pp_double[i][j], _state), _state);
            }
        }
        for(i=0; i<=c2.rows-1; i++)
        {
            for(j=0; j<=ncc-1; j++)
            {
                v = ae_v_dotproduct(&c->ptr.pp_double[i][0], 1, &c1.ptr.pp_double[0][j], c1.stride, ae_v_len(0,n-1));
                *err = ae_maxreal(*err, ae_fabs(v-c2.ptr.pp_double[i][j], _state), _state);
            }
        }
        for(i=0; i<=vt2.rows-1; i++)
        {
            for(j=0; j<=ncvt-1; j++)
            {
                v = ae_v_dotproduct(&vt->ptr.pp_double[i][0], 1, &vt1.ptr.pp_double[0][j], vt1.stride, ae_v_len(0,n-1));
                *err = ae_maxreal(*err, ae_fabs(v-vt2.ptr.pp_double[i][j], _state), _state);
            }
        }
    }
    ae_frame_leave(_state);
}


static void testbdsvdunit_testbdsvdproblem(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_bool* wfailed,
     ae_int_t* failcount,
     ae_int_t* succcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix u;
    ae_matrix vt;
    ae_matrix c;
    ae_vector w;
    ae_int_t i;
    double mx;

    ae_frame_make(_state, &_frame_block);
    memset(&u, 0, sizeof(u));
    memset(&vt, 0, sizeof(vt));
    memset(&c, 0, sizeof(c));
    memset(&w, 0, sizeof(w));
    ae_matrix_init(&u, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&vt, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&c, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&w, 0, DT_REAL, _state, ae_true);

    mx = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        if( ae_fp_greater(ae_fabs(d->ptr.p_double[i], _state),mx) )
        {
            mx = ae_fabs(d->ptr.p_double[i], _state);
        }
    }
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_greater(ae_fabs(e->ptr.p_double[i], _state),mx) )
        {
            mx = ae_fabs(e->ptr.p_double[i], _state);
        }
    }
    if( ae_fp_eq(mx,(double)(0)) )
    {
        mx = (double)(1);
    }
    
    /*
     * Upper BDSVD tests
     */
    ae_vector_set_length(&w, n-1+1, _state);
    testbdsvdunit_fillidentity(&u, n, _state);
    testbdsvdunit_fillidentity(&vt, n, _state);
    testbdsvdunit_fillidentity(&c, n, _state);
    for(i=0; i<=n-1; i++)
    {
        w.ptr.p_double[i] = d->ptr.p_double[i];
    }
    if( !rmatrixbdsvd(&w, e, n, ae_true, ae_false, &u, n, &c, n, &vt, n, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testbdsvdunit_getbdsvderror(d, e, n, ae_true, &u, &c, &w, &vt, materr, orterr, wsorted, _state);
    testbdsvdunit_checksvdmultiplication(d, e, n, ae_true, &u, &c, &w, &vt, materr, _state);
    testbdsvdunit_fillidentity(&u, n, _state);
    testbdsvdunit_fillidentity(&vt, n, _state);
    testbdsvdunit_fillidentity(&c, n, _state);
    for(i=0; i<=n-1; i++)
    {
        w.ptr.p_double[i] = d->ptr.p_double[i];
    }
    if( !rmatrixbdsvd(&w, e, n, ae_true, ae_true, &u, n, &c, n, &vt, n, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testbdsvdunit_getbdsvderror(d, e, n, ae_true, &u, &c, &w, &vt, materr, orterr, wsorted, _state);
    testbdsvdunit_checksvdmultiplication(d, e, n, ae_true, &u, &c, &w, &vt, materr, _state);
    
    /*
     * Lower BDSVD tests
     */
    ae_vector_set_length(&w, n-1+1, _state);
    testbdsvdunit_fillidentity(&u, n, _state);
    testbdsvdunit_fillidentity(&vt, n, _state);
    testbdsvdunit_fillidentity(&c, n, _state);
    for(i=0; i<=n-1; i++)
    {
        w.ptr.p_double[i] = d->ptr.p_double[i];
    }
    if( !rmatrixbdsvd(&w, e, n, ae_false, ae_false, &u, n, &c, n, &vt, n, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testbdsvdunit_getbdsvderror(d, e, n, ae_false, &u, &c, &w, &vt, materr, orterr, wsorted, _state);
    testbdsvdunit_checksvdmultiplication(d, e, n, ae_false, &u, &c, &w, &vt, materr, _state);
    testbdsvdunit_fillidentity(&u, n, _state);
    testbdsvdunit_fillidentity(&vt, n, _state);
    testbdsvdunit_fillidentity(&c, n, _state);
    for(i=0; i<=n-1; i++)
    {
        w.ptr.p_double[i] = d->ptr.p_double[i];
    }
    if( !rmatrixbdsvd(&w, e, n, ae_false, ae_true, &u, n, &c, n, &vt, n, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testbdsvdunit_getbdsvderror(d, e, n, ae_false, &u, &c, &w, &vt, materr, orterr, wsorted, _state);
    testbdsvdunit_checksvdmultiplication(d, e, n, ae_false, &u, &c, &w, &vt, materr, _state);
    
    /*
     * update counter
     */
    *succcount = *succcount+1;
    ae_frame_leave(_state);
}



static void testsvdunit_fillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state);
static void testsvdunit_getsvderror(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_state *_state);
static void testsvdunit_testsvdproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double* materr,
     double* orterr,
     double* othererr,
     ae_bool* wsorted,
     ae_bool* wfailed,
     ae_int_t* failcount,
     ae_int_t* succcount,
     ae_state *_state);





/*************************************************************************
Testing SVD decomposition subroutine
*************************************************************************/
ae_bool testsvd(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_int_t m;
    ae_int_t n;
    ae_int_t maxmn;
    ae_int_t i;
    ae_int_t j;
    ae_int_t gpass;
    ae_int_t pass;
    ae_bool waserrors;
    ae_bool wsorted;
    ae_bool wfailed;
    double materr;
    double orterr;
    double othererr;
    double threshold;
    double failr;
    ae_int_t failcount;
    ae_int_t succcount;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);

    failcount = 0;
    succcount = 0;
    materr = (double)(0);
    orterr = (double)(0);
    othererr = (double)(0);
    wsorted = ae_true;
    wfailed = ae_false;
    waserrors = ae_false;
    maxmn = 30;
    threshold = 5*100*ae_machineepsilon;
    ae_matrix_set_length(&a, maxmn-1+1, maxmn-1+1, _state);
    
    /*
     * TODO: div by zero fail, convergence fail
     */
    for(gpass=1; gpass<=1; gpass++)
    {
        
        /*
         * zero matrix, several cases
         */
        for(i=0; i<=maxmn-1; i++)
        {
            for(j=0; j<=maxmn-1; j++)
            {
                a.ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=1; i<=ae_minint(5, maxmn, _state); i++)
        {
            for(j=1; j<=ae_minint(5, maxmn, _state); j++)
            {
                testsvdunit_testsvdproblem(&a, i, j, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
            }
        }
        
        /*
         * Long dense matrix
         */
        for(i=0; i<=maxmn-1; i++)
        {
            for(j=0; j<=ae_minint(5, maxmn, _state)-1; j++)
            {
                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        for(i=1; i<=maxmn; i++)
        {
            for(j=1; j<=ae_minint(5, maxmn, _state); j++)
            {
                testsvdunit_testsvdproblem(&a, i, j, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
            }
        }
        for(i=0; i<=ae_minint(5, maxmn, _state)-1; i++)
        {
            for(j=0; j<=maxmn-1; j++)
            {
                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        for(i=1; i<=ae_minint(5, maxmn, _state); i++)
        {
            for(j=1; j<=maxmn; j++)
            {
                testsvdunit_testsvdproblem(&a, i, j, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
            }
        }
        
        /*
         * Dense matrices
         */
        for(m=1; m<=ae_minint(10, maxmn, _state); m++)
        {
            for(n=1; n<=ae_minint(10, maxmn, _state); n++)
            {
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    }
                }
                testsvdunit_testsvdproblem(&a, m, n, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
            }
        }
        
        /*
         * Sparse matrices, very sparse matrices, incredible sparse matrices
         */
        for(m=1; m<=10; m++)
        {
            for(n=1; n<=10; n++)
            {
                for(pass=1; pass<=2; pass++)
                {
                    testsvdunit_fillsparsea(&a, m, n, 0.8, _state);
                    testsvdunit_testsvdproblem(&a, m, n, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
                    testsvdunit_fillsparsea(&a, m, n, 0.9, _state);
                    testsvdunit_testsvdproblem(&a, m, n, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
                    testsvdunit_fillsparsea(&a, m, n, 0.95, _state);
                    testsvdunit_testsvdproblem(&a, m, n, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
                }
            }
        }
    }
    
    /*
     * report
     */
    failr = (double)failcount/(double)(succcount+failcount);
    waserrors = (((wfailed||ae_fp_greater(materr,threshold))||ae_fp_greater(orterr,threshold))||ae_fp_greater(othererr,threshold))||!wsorted;
    if( !silent )
    {
        printf("TESTING SVD DECOMPOSITION\n");
        printf("SVD decomposition error:                 %5.3e\n",
            (double)(materr));
        printf("SVD orthogonality error:                 %5.3e\n",
            (double)(orterr));
        printf("SVD with different parameters error:     %5.3e\n",
            (double)(othererr));
        printf("Singular values order:                   ");
        if( wsorted )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("Always converged:                        ");
        if( !wfailed )
        {
            printf("YES\n");
        }
        else
        {
            printf("NO\n");
            printf("Fail ratio:                              %5.3f\n",
                (double)(failr));
        }
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


static void testsvdunit_fillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
            {
                a->ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
            else
            {
                a->ptr.pp_double[i][j] = (double)(0);
            }
        }
    }
}


static void testsvdunit_getsvderror(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t minmn;
    double locerr;
    double sm;


    minmn = ae_minint(m, n, _state);
    
    /*
     * decomposition error
     */
    locerr = (double)(0);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            sm = (double)(0);
            for(k=0; k<=minmn-1; k++)
            {
                sm = sm+w->ptr.p_double[k]*u->ptr.pp_double[i][k]*vt->ptr.pp_double[k][j];
            }
            locerr = ae_maxreal(locerr, ae_fabs(a->ptr.pp_double[i][j]-sm, _state), _state);
        }
    }
    *materr = ae_maxreal(*materr, locerr, _state);
    
    /*
     * orthogonality error
     */
    locerr = (double)(0);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=i; j<=minmn-1; j++)
        {
            sm = ae_v_dotproduct(&u->ptr.pp_double[0][i], u->stride, &u->ptr.pp_double[0][j], u->stride, ae_v_len(0,m-1));
            if( i!=j )
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
            }
            else
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm-1, _state), _state);
            }
            sm = ae_v_dotproduct(&vt->ptr.pp_double[i][0], 1, &vt->ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i!=j )
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
            }
            else
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm-1, _state), _state);
            }
        }
    }
    *orterr = ae_maxreal(*orterr, locerr, _state);
    
    /*
     * values order error
     */
    for(i=1; i<=minmn-1; i++)
    {
        if( ae_fp_greater(w->ptr.p_double[i],w->ptr.p_double[i-1]) )
        {
            *wsorted = ae_false;
        }
    }
}


static void testsvdunit_testsvdproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double* materr,
     double* orterr,
     double* othererr,
     ae_bool* wsorted,
     ae_bool* wfailed,
     ae_int_t* failcount,
     ae_int_t* succcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix u;
    ae_matrix vt;
    ae_matrix u2;
    ae_matrix vt2;
    ae_vector w;
    ae_vector w2;
    ae_int_t i;
    ae_int_t j;
    ae_int_t ujob;
    ae_int_t vtjob;
    ae_int_t memjob;
    ae_int_t ucheck;
    ae_int_t vtcheck;

    ae_frame_make(_state, &_frame_block);
    memset(&u, 0, sizeof(u));
    memset(&vt, 0, sizeof(vt));
    memset(&u2, 0, sizeof(u2));
    memset(&vt2, 0, sizeof(vt2));
    memset(&w, 0, sizeof(w));
    memset(&w2, 0, sizeof(w2));
    ae_matrix_init(&u, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&vt, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&u2, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&vt2, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&w, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&w2, 0, DT_REAL, _state, ae_true);

    
    /*
     * Main SVD test
     */
    if( !rmatrixsvd(a, m, n, 2, 2, 2, &w, &u, &vt, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testsvdunit_getsvderror(a, m, n, &u, &w, &vt, materr, orterr, wsorted, _state);
    
    /*
     * Additional SVD tests
     */
    for(ujob=0; ujob<=2; ujob++)
    {
        for(vtjob=0; vtjob<=2; vtjob++)
        {
            for(memjob=0; memjob<=2; memjob++)
            {
                if( !rmatrixsvd(a, m, n, ujob, vtjob, memjob, &w2, &u2, &vt2, _state) )
                {
                    *failcount = *failcount+1;
                    *wfailed = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                ucheck = 0;
                if( ujob==1 )
                {
                    ucheck = ae_minint(m, n, _state);
                }
                if( ujob==2 )
                {
                    ucheck = m;
                }
                vtcheck = 0;
                if( vtjob==1 )
                {
                    vtcheck = ae_minint(m, n, _state);
                }
                if( vtjob==2 )
                {
                    vtcheck = n;
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=ucheck-1; j++)
                    {
                        *othererr = ae_maxreal(*othererr, ae_fabs(u.ptr.pp_double[i][j]-u2.ptr.pp_double[i][j], _state), _state);
                    }
                }
                for(i=0; i<=vtcheck-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        *othererr = ae_maxreal(*othererr, ae_fabs(vt.ptr.pp_double[i][j]-vt2.ptr.pp_double[i][j], _state), _state);
                    }
                }
                for(i=0; i<=ae_minint(m, n, _state)-1; i++)
                {
                    *othererr = ae_maxreal(*othererr, ae_fabs(w.ptr.p_double[i]-w2.ptr.p_double[i], _state), _state);
                }
            }
        }
    }
    
    /*
     * update counter
     */
    *succcount = *succcount+1;
    ae_frame_leave(_state);
}








/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testtrlinsolve(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t maxmn;
    ae_int_t passcount;
    double threshold;
    ae_matrix aeffective;
    ae_matrix aparam;
    ae_vector xe;
    ae_vector b;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t i;
    ae_int_t j;
    ae_int_t cnts;
    ae_int_t cntu;
    ae_int_t cntt;
    ae_int_t cntm;
    ae_bool waserrors;
    ae_bool isupper;
    ae_bool istrans;
    ae_bool isunit;
    double v;
    double s;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&aeffective, 0, sizeof(aeffective));
    memset(&aparam, 0, sizeof(aparam));
    memset(&xe, 0, sizeof(xe));
    memset(&b, 0, sizeof(b));
    ae_matrix_init(&aeffective, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&aparam, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&xe, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&b, 0, DT_REAL, _state, ae_true);

    waserrors = ae_false;
    maxmn = 15;
    passcount = 15;
    threshold = 1000*ae_machineepsilon;
    
    /*
     * Different problems
     */
    for(n=1; n<=maxmn; n++)
    {
        ae_matrix_set_length(&aeffective, n-1+1, n-1+1, _state);
        ae_matrix_set_length(&aparam, n-1+1, n-1+1, _state);
        ae_vector_set_length(&xe, n-1+1, _state);
        ae_vector_set_length(&b, n-1+1, _state);
        for(pass=1; pass<=passcount; pass++)
        {
            for(cnts=0; cnts<=1; cnts++)
            {
                for(cntu=0; cntu<=1; cntu++)
                {
                    for(cntt=0; cntt<=1; cntt++)
                    {
                        for(cntm=0; cntm<=2; cntm++)
                        {
                            isupper = cnts==0;
                            isunit = cntu==0;
                            istrans = cntt==0;
                            
                            /*
                             * Skip meaningless combinations of parameters:
                             * (matrix is singular) AND (matrix is unit diagonal)
                             */
                            if( cntm==2&&isunit )
                            {
                                continue;
                            }
                            
                            /*
                             * Clear matrices
                             */
                            for(i=0; i<=n-1; i++)
                            {
                                for(j=0; j<=n-1; j++)
                                {
                                    aeffective.ptr.pp_double[i][j] = (double)(0);
                                    aparam.ptr.pp_double[i][j] = (double)(0);
                                }
                            }
                            
                            /*
                             * Prepare matrices
                             */
                            if( isupper )
                            {
                                for(i=0; i<=n-1; i++)
                                {
                                    for(j=i; j<=n-1; j++)
                                    {
                                        aeffective.ptr.pp_double[i][j] = 0.9*(2*ae_randomreal(_state)-1);
                                        aparam.ptr.pp_double[i][j] = aeffective.ptr.pp_double[i][j];
                                    }
                                    aeffective.ptr.pp_double[i][i] = (2*ae_randominteger(2, _state)-1)*(0.8+ae_randomreal(_state));
                                    aparam.ptr.pp_double[i][i] = aeffective.ptr.pp_double[i][i];
                                }
                            }
                            else
                            {
                                for(i=0; i<=n-1; i++)
                                {
                                    for(j=0; j<=i; j++)
                                    {
                                        aeffective.ptr.pp_double[i][j] = 0.9*(2*ae_randomreal(_state)-1);
                                        aparam.ptr.pp_double[i][j] = aeffective.ptr.pp_double[i][j];
                                    }
                                    aeffective.ptr.pp_double[i][i] = (2*ae_randominteger(2, _state)-1)*(0.8+ae_randomreal(_state));
                                    aparam.ptr.pp_double[i][i] = aeffective.ptr.pp_double[i][i];
                                }
                            }
                            if( isunit )
                            {
                                for(i=0; i<=n-1; i++)
                                {
                                    aeffective.ptr.pp_double[i][i] = (double)(1);
                                    aparam.ptr.pp_double[i][i] = (double)(0);
                                }
                            }
                            if( istrans )
                            {
                                if( isupper )
                                {
                                    for(i=0; i<=n-1; i++)
                                    {
                                        for(j=i+1; j<=n-1; j++)
                                        {
                                            aeffective.ptr.pp_double[j][i] = aeffective.ptr.pp_double[i][j];
                                            aeffective.ptr.pp_double[i][j] = (double)(0);
                                        }
                                    }
                                }
                                else
                                {
                                    for(i=0; i<=n-1; i++)
                                    {
                                        for(j=i+1; j<=n-1; j++)
                                        {
                                            aeffective.ptr.pp_double[i][j] = aeffective.ptr.pp_double[j][i];
                                            aeffective.ptr.pp_double[j][i] = (double)(0);
                                        }
                                    }
                                }
                            }
                            
                            /*
                             * Prepare task, solve, compare
                             */
                            for(i=0; i<=n-1; i++)
                            {
                                xe.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                            }
                            for(i=0; i<=n-1; i++)
                            {
                                v = ae_v_dotproduct(&aeffective.ptr.pp_double[i][0], 1, &xe.ptr.p_double[0], 1, ae_v_len(0,n-1));
                                b.ptr.p_double[i] = v;
                            }
                            rmatrixtrsafesolve(&aparam, n, &b, &s, isupper, istrans, isunit, _state);
                            ae_v_muld(&xe.ptr.p_double[0], 1, ae_v_len(0,n-1), s);
                            ae_v_sub(&xe.ptr.p_double[0], 1, &b.ptr.p_double[0], 1, ae_v_len(0,n-1));
                            v = ae_v_dotproduct(&xe.ptr.p_double[0], 1, &xe.ptr.p_double[0], 1, ae_v_len(0,n-1));
                            v = ae_sqrt(v, _state);
                            waserrors = waserrors||ae_fp_greater(v,threshold);
                        }
                    }
                }
            }
        }
    }
    
    /*
     * report
     */
    if( !silent )
    {
        printf("TESTING RMatrixTRSafeSolve\n");
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}



static void testsafesolveunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state);
static void testsafesolveunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state);





/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testsafesolve(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t maxmn;
    double threshold;
    ae_bool rerrors;
    ae_bool cerrors;
    ae_bool waserrors;
    ae_bool isupper;
    ae_int_t trans;
    ae_bool isunit;
    double scalea;
    double growth;
    ae_int_t i;
    ae_int_t j;
    ae_int_t n;
    ae_int_t j1;
    ae_int_t j2;
    ae_complex cv;
    ae_matrix ca;
    ae_matrix cea;
    ae_matrix ctmpa;
    ae_vector cxs;
    ae_vector cxe;
    double rv;
    ae_matrix ra;
    ae_matrix rea;
    ae_matrix rtmpa;
    ae_vector rxs;
    ae_vector rxe;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&ca, 0, sizeof(ca));
    memset(&cea, 0, sizeof(cea));
    memset(&ctmpa, 0, sizeof(ctmpa));
    memset(&cxs, 0, sizeof(cxs));
    memset(&cxe, 0, sizeof(cxe));
    memset(&ra, 0, sizeof(ra));
    memset(&rea, 0, sizeof(rea));
    memset(&rtmpa, 0, sizeof(rtmpa));
    memset(&rxs, 0, sizeof(rxs));
    memset(&rxe, 0, sizeof(rxe));
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cea, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ctmpa, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&cxs, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&cxe, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rea, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&rtmpa, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&rxs, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&rxe, 0, DT_REAL, _state, ae_true);

    maxmn = 30;
    threshold = 100000*ae_machineepsilon;
    rerrors = ae_false;
    cerrors = ae_false;
    waserrors = ae_false;
    
    /*
     * Different problems: general tests
     */
    for(n=1; n<=maxmn; n++)
    {
        
        /*
         * test complex solver with well-conditioned matrix:
         * 1. generate A: fill off-diagonal elements with small values,
         *    diagonal elements are filled with larger values
         * 2. generate 'effective' A
         * 3. prepare task (exact X is stored in CXE, right part - in CXS),
         *    solve and compare CXS and CXE
         */
        isupper = ae_fp_greater(ae_randomreal(_state),0.5);
        trans = ae_randominteger(3, _state);
        isunit = ae_fp_greater(ae_randomreal(_state),0.5);
        scalea = ae_randomreal(_state)+0.5;
        ae_matrix_set_length(&ca, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( i==j )
                {
                    ca.ptr.pp_complex[i][j].x = (2*ae_randominteger(2, _state)-1)*(5+ae_randomreal(_state));
                    ca.ptr.pp_complex[i][j].y = (2*ae_randominteger(2, _state)-1)*(5+ae_randomreal(_state));
                }
                else
                {
                    ca.ptr.pp_complex[i][j].x = 0.2*ae_randomreal(_state)-0.1;
                    ca.ptr.pp_complex[i][j].y = 0.2*ae_randomreal(_state)-0.1;
                }
            }
        }
        testsafesolveunit_cmatrixmakeacopy(&ca, n, n, &ctmpa, _state);
        for(i=0; i<=n-1; i++)
        {
            if( isupper )
            {
                j1 = 0;
                j2 = i-1;
            }
            else
            {
                j1 = i+1;
                j2 = n-1;
            }
            for(j=j1; j<=j2; j++)
            {
                ctmpa.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
            if( isunit )
            {
                ctmpa.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
        }
        ae_matrix_set_length(&cea, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            if( trans==0 )
            {
                ae_v_cmoved(&cea.ptr.pp_complex[i][0], 1, &ctmpa.ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1), scalea);
            }
            if( trans==1 )
            {
                ae_v_cmoved(&cea.ptr.pp_complex[0][i], cea.stride, &ctmpa.ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1), scalea);
            }
            if( trans==2 )
            {
                ae_v_cmoved(&cea.ptr.pp_complex[0][i], cea.stride, &ctmpa.ptr.pp_complex[i][0], 1, "Conj", ae_v_len(0,n-1), scalea);
            }
        }
        ae_vector_set_length(&cxe, n, _state);
        for(i=0; i<=n-1; i++)
        {
            cxe.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            cxe.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
        }
        ae_vector_set_length(&cxs, n, _state);
        for(i=0; i<=n-1; i++)
        {
            cv = ae_v_cdotproduct(&cea.ptr.pp_complex[i][0], 1, "N", &cxe.ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
            cxs.ptr.p_complex[i] = cv;
        }
        if( cmatrixscaledtrsafesolve(&ca, scalea, n, &cxs, isupper, trans, isunit, ae_sqrt(ae_maxrealnumber, _state), _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                cerrors = cerrors||ae_fp_greater(ae_c_abs(ae_c_sub(cxs.ptr.p_complex[i],cxe.ptr.p_complex[i]), _state),threshold);
            }
        }
        else
        {
            cerrors = ae_true;
        }
        
        /*
         * same with real
         */
        isupper = ae_fp_greater(ae_randomreal(_state),0.5);
        trans = ae_randominteger(2, _state);
        isunit = ae_fp_greater(ae_randomreal(_state),0.5);
        scalea = ae_randomreal(_state)+0.5;
        ae_matrix_set_length(&ra, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( i==j )
                {
                    ra.ptr.pp_double[i][j] = (2*ae_randominteger(2, _state)-1)*(5+ae_randomreal(_state));
                }
                else
                {
                    ra.ptr.pp_double[i][j] = 0.2*ae_randomreal(_state)-0.1;
                }
            }
        }
        testsafesolveunit_rmatrixmakeacopy(&ra, n, n, &rtmpa, _state);
        for(i=0; i<=n-1; i++)
        {
            if( isupper )
            {
                j1 = 0;
                j2 = i-1;
            }
            else
            {
                j1 = i+1;
                j2 = n-1;
            }
            for(j=j1; j<=j2; j++)
            {
                rtmpa.ptr.pp_double[i][j] = (double)(0);
            }
            if( isunit )
            {
                rtmpa.ptr.pp_double[i][i] = (double)(1);
            }
        }
        ae_matrix_set_length(&rea, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            if( trans==0 )
            {
                ae_v_moved(&rea.ptr.pp_double[i][0], 1, &rtmpa.ptr.pp_double[i][0], 1, ae_v_len(0,n-1), scalea);
            }
            if( trans==1 )
            {
                ae_v_moved(&rea.ptr.pp_double[0][i], rea.stride, &rtmpa.ptr.pp_double[i][0], 1, ae_v_len(0,n-1), scalea);
            }
        }
        ae_vector_set_length(&rxe, n, _state);
        for(i=0; i<=n-1; i++)
        {
            rxe.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        ae_vector_set_length(&rxs, n, _state);
        for(i=0; i<=n-1; i++)
        {
            rv = ae_v_dotproduct(&rea.ptr.pp_double[i][0], 1, &rxe.ptr.p_double[0], 1, ae_v_len(0,n-1));
            rxs.ptr.p_double[i] = rv;
        }
        if( rmatrixscaledtrsafesolve(&ra, scalea, n, &rxs, isupper, trans, isunit, ae_sqrt(ae_maxrealnumber, _state), _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                rerrors = rerrors||ae_fp_greater(ae_fabs(rxs.ptr.p_double[i]-rxe.ptr.p_double[i], _state),threshold);
            }
        }
        else
        {
            rerrors = ae_true;
        }
    }
    
    /*
     * Special test with diagonal ill-conditioned matrix:
     * * ability to solve it when resulting growth is less than threshold
     * * ability to stop solve when resulting growth is greater than threshold
     *
     * A = diag(1, 1/growth)
     * b = (1, 0.5)
     */
    n = 2;
    growth = (double)(10);
    ae_matrix_set_length(&ca, n, n, _state);
    ca.ptr.pp_complex[0][0] = ae_complex_from_i(1);
    ca.ptr.pp_complex[0][1] = ae_complex_from_i(0);
    ca.ptr.pp_complex[1][0] = ae_complex_from_i(0);
    ca.ptr.pp_complex[1][1] = ae_complex_from_d(1/growth);
    ae_vector_set_length(&cxs, n, _state);
    cxs.ptr.p_complex[0] = ae_complex_from_d(1.0);
    cxs.ptr.p_complex[1] = ae_complex_from_d(0.5);
    cerrors = cerrors||!cmatrixscaledtrsafesolve(&ca, 1.0, n, &cxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(3, _state), ae_false, 1.05*ae_maxreal(ae_c_abs(cxs.ptr.p_complex[1], _state)*growth, 1.0, _state), _state);
    cerrors = cerrors||!cmatrixscaledtrsafesolve(&ca, 1.0, n, &cxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(3, _state), ae_false, 0.95*ae_maxreal(ae_c_abs(cxs.ptr.p_complex[1], _state)*growth, 1.0, _state), _state);
    ae_matrix_set_length(&ra, n, n, _state);
    ra.ptr.pp_double[0][0] = (double)(1);
    ra.ptr.pp_double[0][1] = (double)(0);
    ra.ptr.pp_double[1][0] = (double)(0);
    ra.ptr.pp_double[1][1] = 1/growth;
    ae_vector_set_length(&rxs, n, _state);
    rxs.ptr.p_double[0] = 1.0;
    rxs.ptr.p_double[1] = 0.5;
    rerrors = rerrors||!rmatrixscaledtrsafesolve(&ra, 1.0, n, &rxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(2, _state), ae_false, 1.05*ae_maxreal(ae_fabs(rxs.ptr.p_double[1], _state)*growth, 1.0, _state), _state);
    rerrors = rerrors||!rmatrixscaledtrsafesolve(&ra, 1.0, n, &rxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(2, _state), ae_false, 0.95*ae_maxreal(ae_fabs(rxs.ptr.p_double[1], _state)*growth, 1.0, _state), _state);
    
    /*
     * Special test with diagonal degenerate matrix:
     * * ability to solve it when resulting growth is less than threshold
     * * ability to stop solve when resulting growth is greater than threshold
     *
     * A = diag(1, 0)
     * b = (1, 0.5)
     */
    n = 2;
    ae_matrix_set_length(&ca, n, n, _state);
    ca.ptr.pp_complex[0][0] = ae_complex_from_i(1);
    ca.ptr.pp_complex[0][1] = ae_complex_from_i(0);
    ca.ptr.pp_complex[1][0] = ae_complex_from_i(0);
    ca.ptr.pp_complex[1][1] = ae_complex_from_i(0);
    ae_vector_set_length(&cxs, n, _state);
    cxs.ptr.p_complex[0] = ae_complex_from_d(1.0);
    cxs.ptr.p_complex[1] = ae_complex_from_d(0.5);
    cerrors = cerrors||cmatrixscaledtrsafesolve(&ca, 1.0, n, &cxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(3, _state), ae_false, ae_sqrt(ae_maxrealnumber, _state), _state);
    ae_matrix_set_length(&ra, n, n, _state);
    ra.ptr.pp_double[0][0] = (double)(1);
    ra.ptr.pp_double[0][1] = (double)(0);
    ra.ptr.pp_double[1][0] = (double)(0);
    ra.ptr.pp_double[1][1] = (double)(0);
    ae_vector_set_length(&rxs, n, _state);
    rxs.ptr.p_double[0] = 1.0;
    rxs.ptr.p_double[1] = 0.5;
    rerrors = rerrors||rmatrixscaledtrsafesolve(&ra, 1.0, n, &rxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(2, _state), ae_false, ae_sqrt(ae_maxrealnumber, _state), _state);
    
    /*
     * report
     */
    waserrors = rerrors||cerrors;
    if( !silent )
    {
        printf("TESTING SAFE TR SOLVER\n");
        printf("REAL:                                    ");
        if( !rerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COMPLEX:                                 ");
        if( !cerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Copy
*************************************************************************/
static void testsafesolveunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
}


/*************************************************************************
Copy
*************************************************************************/
static void testsafesolveunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
}



static double testrcondunit_threshold50 = 0.25;
static double testrcondunit_threshold90 = 0.10;
static void testrcondunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state);
static void testrcondunit_rmatrixdrophalf(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state);
static void testrcondunit_cmatrixdrophalf(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state);
static void testrcondunit_rmatrixgenzero(/* Real    */ ae_matrix* a0,
     ae_int_t n,
     ae_state *_state);
static ae_bool testrcondunit_rmatrixinvmattr(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state);
static ae_bool testrcondunit_rmatrixinvmatlu(/* Real    */ ae_matrix* a,
     /* Integer */ ae_vector* pivots,
     ae_int_t n,
     ae_state *_state);
static ae_bool testrcondunit_rmatrixinvmat(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static void testrcondunit_rmatrixrefrcond(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double* rc1,
     double* rcinf,
     ae_state *_state);
static void testrcondunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state);
static void testrcondunit_cmatrixgenzero(/* Complex */ ae_matrix* a0,
     ae_int_t n,
     ae_state *_state);
static ae_bool testrcondunit_cmatrixinvmattr(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state);
static ae_bool testrcondunit_cmatrixinvmatlu(/* Complex */ ae_matrix* a,
     /* Integer */ ae_vector* pivots,
     ae_int_t n,
     ae_state *_state);
static ae_bool testrcondunit_cmatrixinvmat(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static void testrcondunit_cmatrixrefrcond(/* Complex */ ae_matrix* a,
     ae_int_t n,
     double* rc1,
     double* rcinf,
     ae_state *_state);
static ae_bool testrcondunit_testrmatrixtrrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testcmatrixtrrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testrmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testspdmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testcmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testhpdmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);





ae_bool testrcond(ae_bool silent, ae_state *_state)
{
    ae_int_t maxn;
    ae_int_t passcount;
    ae_bool waserrors;
    ae_bool rtrerr;
    ae_bool ctrerr;
    ae_bool rerr;
    ae_bool cerr;
    ae_bool spderr;
    ae_bool hpderr;
    ae_bool result;


    maxn = 10;
    passcount = 100;
    
    /*
     * report
     */
    rtrerr = !testrcondunit_testrmatrixtrrcond(maxn, passcount, _state);
    ctrerr = !testrcondunit_testcmatrixtrrcond(maxn, passcount, _state);
    rerr = !testrcondunit_testrmatrixrcond(maxn, passcount, _state);
    cerr = !testrcondunit_testcmatrixrcond(maxn, passcount, _state);
    spderr = !testrcondunit_testspdmatrixrcond(maxn, passcount, _state);
    hpderr = !testrcondunit_testhpdmatrixrcond(maxn, passcount, _state);
    waserrors = ((((rtrerr||ctrerr)||rerr)||cerr)||spderr)||hpderr;
    if( !silent )
    {
        printf("TESTING RCOND\n");
        printf("REAL TRIANGULAR:                         ");
        if( !rtrerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COMPLEX TRIANGULAR:                      ");
        if( !ctrerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("REAL:                                    ");
        if( !rerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("SPD:                                     ");
        if( !spderr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("HPD:                                     ");
        if( !hpderr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COMPLEX:                                 ");
        if( !cerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    return result;
}


/*************************************************************************
Copy
*************************************************************************/
static void testrcondunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
}


/*************************************************************************
Drops upper or lower half of the matrix - fills it by special pattern
which may be used later to ensure that this part wasn't changed
*************************************************************************/
static void testrcondunit_rmatrixdrophalf(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (droplower&&i>j)||(!droplower&&i<j) )
            {
                a->ptr.pp_double[i][j] = (double)(1+2*i+3*j);
            }
        }
    }
}


/*************************************************************************
Drops upper or lower half of the matrix - fills it by special pattern
which may be used later to ensure that this part wasn't changed
*************************************************************************/
static void testrcondunit_cmatrixdrophalf(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (droplower&&i>j)||(!droplower&&i<j) )
            {
                a->ptr.pp_complex[i][j] = ae_complex_from_i(1+2*i+3*j);
            }
        }
    }
}


/*************************************************************************
Generate matrix with given condition number C (2-norm)
*************************************************************************/
static void testrcondunit_rmatrixgenzero(/* Real    */ ae_matrix* a0,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    ae_matrix_set_length(a0, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a0->ptr.pp_double[i][j] = (double)(0);
        }
    }
}


/*************************************************************************
triangular inverse
*************************************************************************/
static ae_bool testrcondunit_rmatrixinvmattr(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool nounit;
    ae_int_t i;
    ae_int_t j;
    double v;
    double ajj;
    ae_vector t;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&t, 0, sizeof(t));
    ae_vector_init(&t, 0, DT_REAL, _state, ae_true);

    result = ae_true;
    ae_vector_set_length(&t, n-1+1, _state);
    
    /*
     * Test the input parameters.
     */
    nounit = !isunittriangular;
    if( isupper )
    {
        
        /*
         * Compute inverse of upper triangular matrix.
         */
        for(j=0; j<=n-1; j++)
        {
            if( nounit )
            {
                if( ae_fp_eq(a->ptr.pp_double[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_double[j][j] = 1/a->ptr.pp_double[j][j];
                ajj = -a->ptr.pp_double[j][j];
            }
            else
            {
                ajj = (double)(-1);
            }
            
            /*
             * Compute elements 1:j-1 of j-th column.
             */
            if( j>0 )
            {
                ae_v_move(&t.ptr.p_double[0], 1, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1));
                for(i=0; i<=j-1; i++)
                {
                    if( i<j-1 )
                    {
                        v = ae_v_dotproduct(&a->ptr.pp_double[i][i+1], 1, &t.ptr.p_double[i+1], 1, ae_v_len(i+1,j-1));
                    }
                    else
                    {
                        v = (double)(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_double[i][j] = v+a->ptr.pp_double[i][i]*t.ptr.p_double[i];
                    }
                    else
                    {
                        a->ptr.pp_double[i][j] = v+t.ptr.p_double[i];
                    }
                }
                ae_v_muld(&a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1), ajj);
            }
        }
    }
    else
    {
        
        /*
         * Compute inverse of lower triangular matrix.
         */
        for(j=n-1; j>=0; j--)
        {
            if( nounit )
            {
                if( ae_fp_eq(a->ptr.pp_double[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_double[j][j] = 1/a->ptr.pp_double[j][j];
                ajj = -a->ptr.pp_double[j][j];
            }
            else
            {
                ajj = (double)(-1);
            }
            if( j<n-1 )
            {
                
                /*
                 * Compute elements j+1:n of j-th column.
                 */
                ae_v_move(&t.ptr.p_double[j+1], 1, &a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1));
                for(i=j+1; i<=n-1; i++)
                {
                    if( i>j+1 )
                    {
                        v = ae_v_dotproduct(&a->ptr.pp_double[i][j+1], 1, &t.ptr.p_double[j+1], 1, ae_v_len(j+1,i-1));
                    }
                    else
                    {
                        v = (double)(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_double[i][j] = v+a->ptr.pp_double[i][i]*t.ptr.p_double[i];
                    }
                    else
                    {
                        a->ptr.pp_double[i][j] = v+t.ptr.p_double[i];
                    }
                }
                ae_v_muld(&a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1), ajj);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
LU inverse
*************************************************************************/
static ae_bool testrcondunit_rmatrixinvmatlu(/* Real    */ ae_matrix* a,
     /* Integer */ ae_vector* pivots,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector work;
    ae_int_t i;
    ae_int_t j;
    ae_int_t jp;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&work, 0, sizeof(work));
    ae_vector_init(&work, 0, DT_REAL, _state, ae_true);

    result = ae_true;
    
    /*
     * Quick return if possible
     */
    if( n==0 )
    {
        ae_frame_leave(_state);
        return result;
    }
    ae_vector_set_length(&work, n-1+1, _state);
    
    /*
     * Form inv(U)
     */
    if( !testrcondunit_rmatrixinvmattr(a, n, ae_true, ae_false, _state) )
    {
        result = ae_false;
        ae_frame_leave(_state);
        return result;
    }
    
    /*
     * Solve the equation inv(A)*L = inv(U) for inv(A).
     */
    for(j=n-1; j>=0; j--)
    {
        
        /*
         * Copy current column of L to WORK and replace with zeros.
         */
        for(i=j+1; i<=n-1; i++)
        {
            work.ptr.p_double[i] = a->ptr.pp_double[i][j];
            a->ptr.pp_double[i][j] = (double)(0);
        }
        
        /*
         * Compute current column of inv(A).
         */
        if( j<n-1 )
        {
            for(i=0; i<=n-1; i++)
            {
                v = ae_v_dotproduct(&a->ptr.pp_double[i][j+1], 1, &work.ptr.p_double[j+1], 1, ae_v_len(j+1,n-1));
                a->ptr.pp_double[i][j] = a->ptr.pp_double[i][j]-v;
            }
        }
    }
    
    /*
     * Apply column interchanges.
     */
    for(j=n-2; j>=0; j--)
    {
        jp = pivots->ptr.p_int[j];
        if( jp!=j )
        {
            ae_v_move(&work.ptr.p_double[0], 1, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,n-1));
            ae_v_move(&a->ptr.pp_double[0][j], a->stride, &a->ptr.pp_double[0][jp], a->stride, ae_v_len(0,n-1));
            ae_v_move(&a->ptr.pp_double[0][jp], a->stride, &work.ptr.p_double[0], 1, ae_v_len(0,n-1));
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Matrix inverse
*************************************************************************/
static ae_bool testrcondunit_rmatrixinvmat(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector pivots;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&pivots, 0, sizeof(pivots));
    ae_vector_init(&pivots, 0, DT_INT, _state, ae_true);

    rmatrixlu(a, n, n, &pivots, _state);
    result = testrcondunit_rmatrixinvmatlu(a, &pivots, n, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
reference RCond
*************************************************************************/
static void testrcondunit_rmatrixrefrcond(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double* rc1,
     double* rcinf,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix inva;
    double nrm1a;
    double nrminfa;
    double nrm1inva;
    double nrminfinva;
    double v;
    ae_int_t k;
    ae_int_t i;

    ae_frame_make(_state, &_frame_block);
    memset(&inva, 0, sizeof(inva));
    *rc1 = 0;
    *rcinf = 0;
    ae_matrix_init(&inva, 0, 0, DT_REAL, _state, ae_true);

    
    /*
     * inv A
     */
    testrcondunit_rmatrixmakeacopy(a, n, n, &inva, _state);
    if( !testrcondunit_rmatrixinvmat(&inva, n, _state) )
    {
        *rc1 = (double)(0);
        *rcinf = (double)(0);
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * norm A
     */
    nrm1a = (double)(0);
    nrminfa = (double)(0);
    for(k=0; k<=n-1; k++)
    {
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_fabs(a->ptr.pp_double[i][k], _state);
        }
        nrm1a = ae_maxreal(nrm1a, v, _state);
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_fabs(a->ptr.pp_double[k][i], _state);
        }
        nrminfa = ae_maxreal(nrminfa, v, _state);
    }
    
    /*
     * norm inv A
     */
    nrm1inva = (double)(0);
    nrminfinva = (double)(0);
    for(k=0; k<=n-1; k++)
    {
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_fabs(inva.ptr.pp_double[i][k], _state);
        }
        nrm1inva = ae_maxreal(nrm1inva, v, _state);
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_fabs(inva.ptr.pp_double[k][i], _state);
        }
        nrminfinva = ae_maxreal(nrminfinva, v, _state);
    }
    
    /*
     * result
     */
    *rc1 = nrm1inva*nrm1a;
    *rcinf = nrminfinva*nrminfa;
    ae_frame_leave(_state);
}


/*************************************************************************
Copy
*************************************************************************/
static void testrcondunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
}


/*************************************************************************
Generate matrix with given condition number C (2-norm)
*************************************************************************/
static void testrcondunit_cmatrixgenzero(/* Complex */ ae_matrix* a0,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    ae_matrix_set_length(a0, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a0->ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
}


/*************************************************************************
triangular inverse
*************************************************************************/
static ae_bool testrcondunit_cmatrixinvmattr(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool nounit;
    ae_int_t i;
    ae_int_t j;
    ae_complex v;
    ae_complex ajj;
    ae_vector t;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&t, 0, sizeof(t));
    ae_vector_init(&t, 0, DT_COMPLEX, _state, ae_true);

    result = ae_true;
    ae_vector_set_length(&t, n-1+1, _state);
    
    /*
     * Test the input parameters.
     */
    nounit = !isunittriangular;
    if( isupper )
    {
        
        /*
         * Compute inverse of upper triangular matrix.
         */
        for(j=0; j<=n-1; j++)
        {
            if( nounit )
            {
                if( ae_c_eq_d(a->ptr.pp_complex[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_complex[j][j] = ae_c_d_div(1,a->ptr.pp_complex[j][j]);
                ajj = ae_c_neg(a->ptr.pp_complex[j][j]);
            }
            else
            {
                ajj = ae_complex_from_i(-1);
            }
            
            /*
             * Compute elements 1:j-1 of j-th column.
             */
            if( j>0 )
            {
                ae_v_cmove(&t.ptr.p_complex[0], 1, &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,j-1));
                for(i=0; i<=j-1; i++)
                {
                    if( i<j-1 )
                    {
                        v = ae_v_cdotproduct(&a->ptr.pp_complex[i][i+1], 1, "N", &t.ptr.p_complex[i+1], 1, "N", ae_v_len(i+1,j-1));
                    }
                    else
                    {
                        v = ae_complex_from_i(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,ae_c_mul(a->ptr.pp_complex[i][i],t.ptr.p_complex[i]));
                    }
                    else
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,t.ptr.p_complex[i]);
                    }
                }
                ae_v_cmulc(&a->ptr.pp_complex[0][j], a->stride, ae_v_len(0,j-1), ajj);
            }
        }
    }
    else
    {
        
        /*
         * Compute inverse of lower triangular matrix.
         */
        for(j=n-1; j>=0; j--)
        {
            if( nounit )
            {
                if( ae_c_eq_d(a->ptr.pp_complex[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_complex[j][j] = ae_c_d_div(1,a->ptr.pp_complex[j][j]);
                ajj = ae_c_neg(a->ptr.pp_complex[j][j]);
            }
            else
            {
                ajj = ae_complex_from_i(-1);
            }
            if( j<n-1 )
            {
                
                /*
                 * Compute elements j+1:n of j-th column.
                 */
                ae_v_cmove(&t.ptr.p_complex[j+1], 1, &a->ptr.pp_complex[j+1][j], a->stride, "N", ae_v_len(j+1,n-1));
                for(i=j+1; i<=n-1; i++)
                {
                    if( i>j+1 )
                    {
                        v = ae_v_cdotproduct(&a->ptr.pp_complex[i][j+1], 1, "N", &t.ptr.p_complex[j+1], 1, "N", ae_v_len(j+1,i-1));
                    }
                    else
                    {
                        v = ae_complex_from_i(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,ae_c_mul(a->ptr.pp_complex[i][i],t.ptr.p_complex[i]));
                    }
                    else
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,t.ptr.p_complex[i]);
                    }
                }
                ae_v_cmulc(&a->ptr.pp_complex[j+1][j], a->stride, ae_v_len(j+1,n-1), ajj);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
LU inverse
*************************************************************************/
static ae_bool testrcondunit_cmatrixinvmatlu(/* Complex */ ae_matrix* a,
     /* Integer */ ae_vector* pivots,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector work;
    ae_int_t i;
    ae_int_t j;
    ae_int_t jp;
    ae_complex v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&work, 0, sizeof(work));
    ae_vector_init(&work, 0, DT_COMPLEX, _state, ae_true);

    result = ae_true;
    
    /*
     * Quick return if possible
     */
    if( n==0 )
    {
        ae_frame_leave(_state);
        return result;
    }
    ae_vector_set_length(&work, n-1+1, _state);
    
    /*
     * Form inv(U)
     */
    if( !testrcondunit_cmatrixinvmattr(a, n, ae_true, ae_false, _state) )
    {
        result = ae_false;
        ae_frame_leave(_state);
        return result;
    }
    
    /*
     * Solve the equation inv(A)*L = inv(U) for inv(A).
     */
    for(j=n-1; j>=0; j--)
    {
        
        /*
         * Copy current column of L to WORK and replace with zeros.
         */
        for(i=j+1; i<=n-1; i++)
        {
            work.ptr.p_complex[i] = a->ptr.pp_complex[i][j];
            a->ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
        
        /*
         * Compute current column of inv(A).
         */
        if( j<n-1 )
        {
            for(i=0; i<=n-1; i++)
            {
                v = ae_v_cdotproduct(&a->ptr.pp_complex[i][j+1], 1, "N", &work.ptr.p_complex[j+1], 1, "N", ae_v_len(j+1,n-1));
                a->ptr.pp_complex[i][j] = ae_c_sub(a->ptr.pp_complex[i][j],v);
            }
        }
    }
    
    /*
     * Apply column interchanges.
     */
    for(j=n-2; j>=0; j--)
    {
        jp = pivots->ptr.p_int[j];
        if( jp!=j )
        {
            ae_v_cmove(&work.ptr.p_complex[0], 1, &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,n-1));
            ae_v_cmove(&a->ptr.pp_complex[0][j], a->stride, &a->ptr.pp_complex[0][jp], a->stride, "N", ae_v_len(0,n-1));
            ae_v_cmove(&a->ptr.pp_complex[0][jp], a->stride, &work.ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Matrix inverse
*************************************************************************/
static ae_bool testrcondunit_cmatrixinvmat(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector pivots;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&pivots, 0, sizeof(pivots));
    ae_vector_init(&pivots, 0, DT_INT, _state, ae_true);

    cmatrixlu(a, n, n, &pivots, _state);
    result = testrcondunit_cmatrixinvmatlu(a, &pivots, n, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
reference RCond
*************************************************************************/
static void testrcondunit_cmatrixrefrcond(/* Complex */ ae_matrix* a,
     ae_int_t n,
     double* rc1,
     double* rcinf,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix inva;
    double nrm1a;
    double nrminfa;
    double nrm1inva;
    double nrminfinva;
    double v;
    ae_int_t k;
    ae_int_t i;

    ae_frame_make(_state, &_frame_block);
    memset(&inva, 0, sizeof(inva));
    *rc1 = 0;
    *rcinf = 0;
    ae_matrix_init(&inva, 0, 0, DT_COMPLEX, _state, ae_true);

    
    /*
     * inv A
     */
    testrcondunit_cmatrixmakeacopy(a, n, n, &inva, _state);
    if( !testrcondunit_cmatrixinvmat(&inva, n, _state) )
    {
        *rc1 = (double)(0);
        *rcinf = (double)(0);
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * norm A
     */
    nrm1a = (double)(0);
    nrminfa = (double)(0);
    for(k=0; k<=n-1; k++)
    {
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_c_abs(a->ptr.pp_complex[i][k], _state);
        }
        nrm1a = ae_maxreal(nrm1a, v, _state);
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_c_abs(a->ptr.pp_complex[k][i], _state);
        }
        nrminfa = ae_maxreal(nrminfa, v, _state);
    }
    
    /*
     * norm inv A
     */
    nrm1inva = (double)(0);
    nrminfinva = (double)(0);
    for(k=0; k<=n-1; k++)
    {
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_c_abs(inva.ptr.pp_complex[i][k], _state);
        }
        nrm1inva = ae_maxreal(nrm1inva, v, _state);
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_c_abs(inva.ptr.pp_complex[k][i], _state);
        }
        nrminfinva = ae_maxreal(nrminfinva, v, _state);
    }
    
    /*
     * result
     */
    *rc1 = nrm1inva*nrm1a;
    *rcinf = nrminfinva*nrminfa;
    ae_frame_leave(_state);
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testrmatrixtrrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix ea;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t j1;
    ae_int_t j2;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool isupper;
    ae_bool isunit;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&ea, 0, sizeof(ea));
    memset(&p, 0, sizeof(p));
    memset(&q50, 0, sizeof(q50));
    memset(&q90, 0, sizeof(q90));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&ea, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_vector_init(&q50, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&q90, 0, DT_REAL, _state, ae_true);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 2, _state);
    ae_vector_set_length(&q90, 2, _state);
    for(n=1; n<=maxn; n++)
    {
        
        /*
         * special test for zero matrix
         */
        testrcondunit_rmatrixgenzero(&a, n, _state);
        errspec = errspec||ae_fp_neq(rmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        errspec = errspec||ae_fp_neq(rmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n, n, _state);
        for(i=0; i<=1; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            isunit = ae_fp_greater(ae_randomreal(_state),0.5);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = ae_randomreal(_state)-0.5;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = 1+ae_randomreal(_state);
            }
            testrcondunit_rmatrixmakeacopy(&a, n, n, &ea, _state);
            for(i=0; i<=n-1; i++)
            {
                if( isupper )
                {
                    j1 = 0;
                    j2 = i-1;
                }
                else
                {
                    j1 = i+1;
                    j2 = n-1;
                }
                for(j=j1; j<=j2; j++)
                {
                    ea.ptr.pp_double[i][j] = (double)(0);
                }
                if( isunit )
                {
                    ea.ptr.pp_double[i][i] = (double)(1);
                }
            }
            testrcondunit_rmatrixrefrcond(&ea, n, &erc1, &ercinf, _state);
            
            /*
             * 1-norm
             */
            v = 1/rmatrixtrrcond1(&a, n, isupper, isunit, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Inf-norm
             */
            v = 1/rmatrixtrrcondinf(&a, n, isupper, isunit, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
        }
        for(i=0; i<=1; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            a.ptr.pp_double[0][0] = (double)(1);
            a.ptr.pp_double[n-1][n-1] = (double)(1);
            errspec = errspec||ae_fp_neq(rmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = (double)(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_double[i][i] = 0.1*ae_maxrealnumber;
            errspec = errspec||ae_fp_neq(rmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testcmatrixtrrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix ea;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t j1;
    ae_int_t j2;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool isupper;
    ae_bool isunit;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&ea, 0, sizeof(ea));
    memset(&p, 0, sizeof(p));
    memset(&q50, 0, sizeof(q50));
    memset(&q90, 0, sizeof(q90));
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&ea, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_vector_init(&q50, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&q90, 0, DT_REAL, _state, ae_true);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 2, _state);
    ae_vector_set_length(&q90, 2, _state);
    for(n=1; n<=maxn; n++)
    {
        
        /*
         * special test for zero matrix
         */
        testrcondunit_cmatrixgenzero(&a, n, _state);
        errspec = errspec||ae_fp_neq(cmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        errspec = errspec||ae_fp_neq(cmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n, n, _state);
        for(i=0; i<=1; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            isunit = ae_fp_greater(ae_randomreal(_state),0.5);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j].x = ae_randomreal(_state)-0.5;
                    a.ptr.pp_complex[i][j].y = ae_randomreal(_state)-0.5;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_complex[i][i].x = 1+ae_randomreal(_state);
                a.ptr.pp_complex[i][i].y = 1+ae_randomreal(_state);
            }
            testrcondunit_cmatrixmakeacopy(&a, n, n, &ea, _state);
            for(i=0; i<=n-1; i++)
            {
                if( isupper )
                {
                    j1 = 0;
                    j2 = i-1;
                }
                else
                {
                    j1 = i+1;
                    j2 = n-1;
                }
                for(j=j1; j<=j2; j++)
                {
                    ea.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                }
                if( isunit )
                {
                    ea.ptr.pp_complex[i][i] = ae_complex_from_i(1);
                }
            }
            testrcondunit_cmatrixrefrcond(&ea, n, &erc1, &ercinf, _state);
            
            /*
             * 1-norm
             */
            v = 1/cmatrixtrrcond1(&a, n, isupper, isunit, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Inf-norm
             */
            v = 1/cmatrixtrrcondinf(&a, n, isupper, isunit, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
        }
        for(i=0; i<=1; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            a.ptr.pp_complex[0][0] = ae_complex_from_i(1);
            a.ptr.pp_complex[n-1][n-1] = ae_complex_from_i(1);
            errspec = errspec||ae_fp_neq(cmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_complex[i][i] = ae_complex_from_d(0.1*ae_maxrealnumber);
            errspec = errspec||ae_fp_neq(cmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testrmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix lua;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&lua, 0, sizeof(lua));
    memset(&p, 0, sizeof(p));
    memset(&q50, 0, sizeof(q50));
    memset(&q90, 0, sizeof(q90));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&lua, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_vector_init(&q50, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&q90, 0, DT_REAL, _state, ae_true);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 3+1, _state);
    ae_vector_set_length(&q90, 3+1, _state);
    for(n=1; n<=maxn; n++)
    {
        
        /*
         * special test for zero matrix
         */
        testrcondunit_rmatrixgenzero(&a, n, _state);
        testrcondunit_rmatrixmakeacopy(&a, n, n, &lua, _state);
        rmatrixlu(&lua, n, n, &p, _state);
        errspec = errspec||ae_fp_neq(rmatrixrcond1(&a, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(rmatrixrcondinf(&a, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(rmatrixlurcond1(&lua, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(rmatrixlurcondinf(&lua, n, _state),(double)(0));
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n-1+1, n-1+1, _state);
        for(i=0; i<=3; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            rmatrixrndcond(n, ae_exp(ae_randomreal(_state)*ae_log((double)(1000), _state), _state), &a, _state);
            testrcondunit_rmatrixmakeacopy(&a, n, n, &lua, _state);
            rmatrixlu(&lua, n, n, &p, _state);
            testrcondunit_rmatrixrefrcond(&a, n, &erc1, &ercinf, _state);
            
            /*
             * 1-norm, normal
             */
            v = 1/rmatrixrcond1(&a, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * 1-norm, LU
             */
            v = 1/rmatrixlurcond1(&lua, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Inf-norm, normal
             */
            v = 1/rmatrixrcondinf(&a, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[2] = q50.ptr.p_double[2]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[2] = q90.ptr.p_double[2]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
            
            /*
             * Inf-norm, LU
             */
            v = 1/rmatrixlurcondinf(&lua, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[3] = q50.ptr.p_double[3]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[3] = q90.ptr.p_double[3]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
        }
        for(i=0; i<=3; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            a.ptr.pp_double[0][0] = (double)(1);
            a.ptr.pp_double[n-1][n-1] = (double)(1);
            errspec = errspec||ae_fp_neq(rmatrixrcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixrcondinf(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixlurcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixlurcondinf(&a, n, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = (double)(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_double[i][i] = 0.1*ae_maxrealnumber;
            errspec = errspec||ae_fp_neq(rmatrixrcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixrcondinf(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixlurcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixlurcondinf(&a, n, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testspdmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix cha;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    ae_bool isupper;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&cha, 0, sizeof(cha));
    memset(&p, 0, sizeof(p));
    memset(&q50, 0, sizeof(q50));
    memset(&q90, 0, sizeof(q90));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cha, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_vector_init(&q50, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&q90, 0, DT_REAL, _state, ae_true);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 2, _state);
    ae_vector_set_length(&q90, 2, _state);
    for(n=1; n<=maxn; n++)
    {
        isupper = ae_fp_greater(ae_randomreal(_state),0.5);
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n, n, _state);
        for(i=0; i<=1; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            spdmatrixrndcond(n, ae_exp(ae_randomreal(_state)*ae_log((double)(1000), _state), _state), &a, _state);
            testrcondunit_rmatrixrefrcond(&a, n, &erc1, &ercinf, _state);
            testrcondunit_rmatrixdrophalf(&a, n, isupper, _state);
            testrcondunit_rmatrixmakeacopy(&a, n, n, &cha, _state);
            spdmatrixcholesky(&cha, n, isupper, _state);
            
            /*
             * normal
             */
            v = 1/spdmatrixrcond(&a, n, isupper, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Cholesky
             */
            v = 1/spdmatrixcholeskyrcond(&cha, n, isupper, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
        }
        for(i=0; i<=1; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            a.ptr.pp_double[0][0] = (double)(1);
            a.ptr.pp_double[n-1][n-1] = (double)(1);
            errspec = errspec||ae_fp_neq(spdmatrixrcond(&a, n, isupper, _state),(double)(-1));
            errspec = errspec||ae_fp_neq(spdmatrixcholeskyrcond(&a, n, isupper, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = (double)(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_double[i][i] = 0.1*ae_maxrealnumber;
            errspec = errspec||ae_fp_neq(spdmatrixrcond(&a, n, isupper, _state),(double)(0));
            errspec = errspec||ae_fp_neq(spdmatrixcholeskyrcond(&a, n, isupper, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testcmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix lua;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errless;
    ae_bool errspec;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&lua, 0, sizeof(lua));
    memset(&p, 0, sizeof(p));
    memset(&q50, 0, sizeof(q50));
    memset(&q90, 0, sizeof(q90));
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&lua, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_vector_init(&q50, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&q90, 0, DT_REAL, _state, ae_true);

    ae_vector_set_length(&q50, 3+1, _state);
    ae_vector_set_length(&q90, 3+1, _state);
    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    
    /*
     * process
     */
    for(n=1; n<=maxn; n++)
    {
        
        /*
         * special test for zero matrix
         */
        testrcondunit_cmatrixgenzero(&a, n, _state);
        testrcondunit_cmatrixmakeacopy(&a, n, n, &lua, _state);
        cmatrixlu(&lua, n, n, &p, _state);
        errspec = errspec||ae_fp_neq(cmatrixrcond1(&a, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(cmatrixrcondinf(&a, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(cmatrixlurcond1(&lua, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(cmatrixlurcondinf(&lua, n, _state),(double)(0));
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n-1+1, n-1+1, _state);
        for(i=0; i<=3; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            cmatrixrndcond(n, ae_exp(ae_randomreal(_state)*ae_log((double)(1000), _state), _state), &a, _state);
            testrcondunit_cmatrixmakeacopy(&a, n, n, &lua, _state);
            cmatrixlu(&lua, n, n, &p, _state);
            testrcondunit_cmatrixrefrcond(&a, n, &erc1, &ercinf, _state);
            
            /*
             * 1-norm, normal
             */
            v = 1/cmatrixrcond1(&a, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * 1-norm, LU
             */
            v = 1/cmatrixlurcond1(&lua, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Inf-norm, normal
             */
            v = 1/cmatrixrcondinf(&a, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[2] = q50.ptr.p_double[2]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[2] = q90.ptr.p_double[2]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
            
            /*
             * Inf-norm, LU
             */
            v = 1/cmatrixlurcondinf(&lua, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[3] = q50.ptr.p_double[3]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[3] = q90.ptr.p_double[3]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
        }
        for(i=0; i<=3; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            a.ptr.pp_complex[0][0] = ae_complex_from_i(1);
            a.ptr.pp_complex[n-1][n-1] = ae_complex_from_i(1);
            errspec = errspec||ae_fp_neq(cmatrixrcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixrcondinf(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixlurcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixlurcondinf(&a, n, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_complex[i][i] = ae_complex_from_d(0.1*ae_maxrealnumber);
            errspec = errspec||ae_fp_neq(cmatrixrcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixrcondinf(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixlurcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixlurcondinf(&a, n, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testhpdmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix cha;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    ae_bool isupper;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&cha, 0, sizeof(cha));
    memset(&p, 0, sizeof(p));
    memset(&q50, 0, sizeof(q50));
    memset(&q90, 0, sizeof(q90));
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_matrix_init(&cha, 0, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_vector_init(&q50, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&q90, 0, DT_REAL, _state, ae_true);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 2, _state);
    ae_vector_set_length(&q90, 2, _state);
    for(n=1; n<=maxn; n++)
    {
        isupper = ae_fp_greater(ae_randomreal(_state),0.5);
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n, n, _state);
        for(i=0; i<=1; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            hpdmatrixrndcond(n, ae_exp(ae_randomreal(_state)*ae_log((double)(1000), _state), _state), &a, _state);
            testrcondunit_cmatrixrefrcond(&a, n, &erc1, &ercinf, _state);
            testrcondunit_cmatrixdrophalf(&a, n, isupper, _state);
            testrcondunit_cmatrixmakeacopy(&a, n, n, &cha, _state);
            hpdmatrixcholesky(&cha, n, isupper, _state);
            
            /*
             * normal
             */
            v = 1/hpdmatrixrcond(&a, n, isupper, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Cholesky
             */
            v = 1/hpdmatrixcholeskyrcond(&cha, n, isupper, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
        }
        for(i=0; i<=1; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            a.ptr.pp_complex[0][0] = ae_complex_from_i(1);
            a.ptr.pp_complex[n-1][n-1] = ae_complex_from_i(1);
            errspec = errspec||ae_fp_neq(hpdmatrixrcond(&a, n, isupper, _state),(double)(-1));
            errspec = errspec||ae_fp_neq(hpdmatrixcholeskyrcond(&a, n, isupper, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_complex[i][i] = ae_complex_from_d(0.1*ae_maxrealnumber);
            errspec = errspec||ae_fp_neq(hpdmatrixrcond(&a, n, isupper, _state),(double)(0));
            errspec = errspec||ae_fp_neq(hpdmatrixcholeskyrcond(&a, n, isupper, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}








ae_bool testxblas(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool approxerrors;
    ae_bool exactnesserrors;
    ae_bool waserrors;
    double approxthreshold;
    ae_int_t maxn;
    ae_int_t passcount;
    ae_int_t n;
    ae_int_t i;
    ae_int_t pass;
    double rv1;
    double rv2;
    double rv2err;
    ae_complex cv1;
    ae_complex cv2;
    double cv2err;
    ae_vector rx;
    ae_vector ry;
    ae_vector cx;
    ae_vector cy;
    ae_vector temp;
    double s;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&rx, 0, sizeof(rx));
    memset(&ry, 0, sizeof(ry));
    memset(&cx, 0, sizeof(cx));
    memset(&cy, 0, sizeof(cy));
    memset(&temp, 0, sizeof(temp));
    ae_vector_init(&rx, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&ry, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&cx, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&cy, 0, DT_COMPLEX, _state, ae_true);
    ae_vector_init(&temp, 0, DT_REAL, _state, ae_true);

    approxerrors = ae_false;
    exactnesserrors = ae_false;
    waserrors = ae_false;
    approxthreshold = 1000*ae_machineepsilon;
    maxn = 1000;
    passcount = 10;
    
    /*
     * tests:
     * 1. ability to calculate dot product
     * 2. higher precision
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             *  ability to approximately calculate real dot product
             */
            ae_vector_set_length(&rx, n, _state);
            ae_vector_set_length(&ry, n, _state);
            ae_vector_set_length(&temp, n, _state);
            for(i=0; i<=n-1; i++)
            {
                if( ae_fp_greater(ae_randomreal(_state),0.2) )
                {
                    rx.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                }
                else
                {
                    rx.ptr.p_double[i] = (double)(0);
                }
                if( ae_fp_greater(ae_randomreal(_state),0.2) )
                {
                    ry.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                }
                else
                {
                    ry.ptr.p_double[i] = (double)(0);
                }
            }
            rv1 = ae_v_dotproduct(&rx.ptr.p_double[0], 1, &ry.ptr.p_double[0], 1, ae_v_len(0,n-1));
            xdot(&rx, &ry, n, &temp, &rv2, &rv2err, _state);
            approxerrors = approxerrors||ae_fp_greater(ae_fabs(rv1-rv2, _state),approxthreshold);
            
            /*
             *  ability to approximately calculate complex dot product
             */
            ae_vector_set_length(&cx, n, _state);
            ae_vector_set_length(&cy, n, _state);
            ae_vector_set_length(&temp, 2*n, _state);
            for(i=0; i<=n-1; i++)
            {
                if( ae_fp_greater(ae_randomreal(_state),0.2) )
                {
                    cx.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
                    cx.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
                }
                else
                {
                    cx.ptr.p_complex[i] = ae_complex_from_i(0);
                }
                if( ae_fp_greater(ae_randomreal(_state),0.2) )
                {
                    cy.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
                    cy.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
                }
                else
                {
                    cy.ptr.p_complex[i] = ae_complex_from_i(0);
                }
            }
            cv1 = ae_v_cdotproduct(&cx.ptr.p_complex[0], 1, "N", &cy.ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
            xcdot(&cx, &cy, n, &temp, &cv2, &cv2err, _state);
            approxerrors = approxerrors||ae_fp_greater(ae_c_abs(ae_c_sub(cv1,cv2), _state),approxthreshold);
        }
    }
    
    /*
     * test of precision: real
     */
    n = 50000;
    ae_vector_set_length(&rx, n, _state);
    ae_vector_set_length(&ry, n, _state);
    ae_vector_set_length(&temp, n, _state);
    for(pass=0; pass<=passcount-1; pass++)
    {
        ae_assert(n%2==0, "Assertion failed", _state);
        
        /*
         * First test: X + X + ... + X - X - X - ... - X = 1*X
         */
        s = ae_exp((double)(ae_maxint(pass, 50, _state)), _state);
        if( pass==passcount-1&&pass>1 )
        {
            s = ae_maxrealnumber;
        }
        ry.ptr.p_double[0] = (2*ae_randomreal(_state)-1)*s*ae_sqrt(2*ae_randomreal(_state), _state);
        for(i=1; i<=n-1; i++)
        {
            ry.ptr.p_double[i] = ry.ptr.p_double[0];
        }
        for(i=0; i<=n/2-1; i++)
        {
            rx.ptr.p_double[i] = (double)(1);
        }
        for(i=n/2; i<=n-2; i++)
        {
            rx.ptr.p_double[i] = (double)(-1);
        }
        rx.ptr.p_double[n-1] = (double)(0);
        xdot(&rx, &ry, n, &temp, &rv2, &rv2err, _state);
        exactnesserrors = exactnesserrors||ae_fp_less(rv2err,(double)(0));
        exactnesserrors = exactnesserrors||ae_fp_greater(rv2err,4*ae_machineepsilon*ae_fabs(ry.ptr.p_double[0], _state));
        exactnesserrors = exactnesserrors||ae_fp_greater(ae_fabs(rv2-ry.ptr.p_double[0], _state),rv2err);
        
        /*
         * First test: X + X + ... + X = N*X
         */
        s = ae_exp((double)(ae_maxint(pass, 50, _state)), _state);
        if( pass==passcount-1&&pass>1 )
        {
            s = ae_maxrealnumber;
        }
        ry.ptr.p_double[0] = (2*ae_randomreal(_state)-1)*s*ae_sqrt(2*ae_randomreal(_state), _state);
        for(i=1; i<=n-1; i++)
        {
            ry.ptr.p_double[i] = ry.ptr.p_double[0];
        }
        for(i=0; i<=n-1; i++)
        {
            rx.ptr.p_double[i] = (double)(1);
        }
        xdot(&rx, &ry, n, &temp, &rv2, &rv2err, _state);
        exactnesserrors = exactnesserrors||ae_fp_less(rv2err,(double)(0));
        exactnesserrors = exactnesserrors||ae_fp_greater(rv2err,4*ae_machineepsilon*ae_fabs(ry.ptr.p_double[0], _state)*n);
        exactnesserrors = exactnesserrors||ae_fp_greater(ae_fabs(rv2-n*ry.ptr.p_double[0], _state),rv2err);
    }
    
    /*
     * test of precision: complex
     */
    n = 50000;
    ae_vector_set_length(&cx, n, _state);
    ae_vector_set_length(&cy, n, _state);
    ae_vector_set_length(&temp, 2*n, _state);
    for(pass=0; pass<=passcount-1; pass++)
    {
        ae_assert(n%2==0, "Assertion failed", _state);
        
        /*
         * First test: X + X + ... + X - X - X - ... - X = 1*X
         */
        s = ae_exp((double)(ae_maxint(pass, 50, _state)), _state);
        if( pass==passcount-1&&pass>1 )
        {
            s = ae_maxrealnumber;
        }
        cy.ptr.p_complex[0].x = (2*ae_randomreal(_state)-1)*s*ae_sqrt(2*ae_randomreal(_state), _state);
        cy.ptr.p_complex[0].y = (2*ae_randomreal(_state)-1)*s*ae_sqrt(2*ae_randomreal(_state), _state);
        for(i=1; i<=n-1; i++)
        {
            cy.ptr.p_complex[i] = cy.ptr.p_complex[0];
        }
        for(i=0; i<=n/2-1; i++)
        {
            cx.ptr.p_complex[i] = ae_complex_from_i(1);
        }
        for(i=n/2; i<=n-2; i++)
        {
            cx.ptr.p_complex[i] = ae_complex_from_i(-1);
        }
        cx.ptr.p_complex[n-1] = ae_complex_from_i(0);
        xcdot(&cx, &cy, n, &temp, &cv2, &cv2err, _state);
        exactnesserrors = exactnesserrors||ae_fp_less(cv2err,(double)(0));
        exactnesserrors = exactnesserrors||ae_fp_greater(cv2err,4*ae_machineepsilon*ae_c_abs(cy.ptr.p_complex[0], _state));
        exactnesserrors = exactnesserrors||ae_fp_greater(ae_c_abs(ae_c_sub(cv2,cy.ptr.p_complex[0]), _state),cv2err);
        
        /*
         * First test: X + X + ... + X = N*X
         */
        s = ae_exp((double)(ae_maxint(pass, 50, _state)), _state);
        if( pass==passcount-1&&pass>1 )
        {
            s = ae_maxrealnumber;
        }
        cy.ptr.p_complex[0] = ae_complex_from_d((2*ae_randomreal(_state)-1)*s*ae_sqrt(2*ae_randomreal(_state), _state));
        for(i=1; i<=n-1; i++)
        {
            cy.ptr.p_complex[i] = cy.ptr.p_complex[0];
        }
        for(i=0; i<=n-1; i++)
        {
            cx.ptr.p_complex[i] = ae_complex_from_i(1);
        }
        xcdot(&cx, &cy, n, &temp, &cv2, &cv2err, _state);
        exactnesserrors = exactnesserrors||ae_fp_less(cv2err,(double)(0));
        exactnesserrors = exactnesserrors||ae_fp_greater(cv2err,4*ae_machineepsilon*ae_c_abs(cy.ptr.p_complex[0], _state)*n);
        exactnesserrors = exactnesserrors||ae_fp_greater(ae_c_abs(ae_c_sub(cv2,ae_c_mul_d(cy.ptr.p_complex[0],1.0*n)), _state),cv2err);
    }
    
    /*
     * report
     */
    waserrors = approxerrors||exactnesserrors;
    if( !silent )
    {
        printf("TESTING XBLAS\n");
        printf("APPROX.TESTS:                            ");
        if( approxerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("EXACT TESTS:                             ");
        if( exactnesserrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    
    /*
     * end
     */
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}



static ae_bool testdirectdensesolversunit_rmatrixchecksolutionm(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_rmatrixchecksolutionmfast(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     /* Real    */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_rmatrixchecksolution(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_vector* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_rmatrixchecksolutionfast(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     /* Real    */ ae_vector* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_rmatrixchecksingularm(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_rmatrixchecksingularmfast(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     /* Real    */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_rmatrixchecksingular(ae_int_t n,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_vector* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_rmatrixchecksingularfast(ae_int_t n,
     ae_int_t info,
     /* Real    */ ae_vector* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksolutionm(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksolutionmfast(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     /* Complex */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksolution(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_vector* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksolutionfast(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     /* Complex */ ae_vector* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksingularm(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksingularmfast(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     /* Complex */ ae_matrix* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksingular(ae_int_t n,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_vector* xs,
     ae_state *_state);
static ae_bool testdirectdensesolversunit_cmatrixchecksingularfast(ae_int_t n,
     ae_int_t info,
     /* Complex */ ae_vector* xs,
     ae_state *_state);
static void testdirectdensesolversunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state);
static void testdirectdensesolversunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state);
static void testdirectdensesolversunit_rmatrixdrophalf(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state);
static void testdirectdensesolversunit_cmatrixdrophalf(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state);
static void testdirectdensesolversunit_testrsolver(ae_int_t maxn,
     ae_int_t maxm,
     ae_int_t passcount,
     double threshold,
     ae_bool* rerrors,
     ae_bool* rfserrors,
     ae_state *_state);
static void testdirectdensesolversunit_testspdsolver(ae_int_t maxn,
     ae_int_t maxm,
     ae_int_t passcount,
     double threshold,
     ae_bool* spderrors,
     ae_bool* rfserrors,
     ae_state *_state);
static void testdirectdensesolversunit_testcsolver(ae_int_t maxn,
     ae_int_t maxm,
     ae_int_t passcount,
     double threshold,
     ae_bool* cerrors,
     ae_bool* rfserrors,
     ae_state *_state);
static void testdirectdensesolversunit_testhpdsolver(ae_int_t maxn,
     ae_int_t maxm,
     ae_int_t passcount,
     double threshold,
     ae_bool* hpderrors,
     ae_bool* rfserrors,
     ae_state *_state);
static void testdirectdensesolversunit_unset2d(/* Real    */ ae_matrix* x,
     ae_state *_state);
static void testdirectdensesolversunit_unset1d(/* Real    */ ae_vector* x,
     ae_state *_state);
static void testdirectdensesolversunit_cunset2d(/* Complex */ ae_matrix* x,
     ae_state *_state);
static void testdirectdensesolversunit_cunset1d(/* Complex */ ae_vector* x,
     ae_state *_state);
static void testdirectdensesolversunit_unsetrep(densesolverreport* r,
     ae_state *_state);
static void testdirectdensesolversunit_unsetlsrep(densesolverlsreport* r,
     ae_state *_state);





/*************************************************************************
Test
*************************************************************************/
ae_bool testdirectdensesolvers(ae_bool silent, ae_state *_state)
{
    ae_int_t maxn;
    ae_int_t maxm;
    ae_int_t passcount;
    double threshold;
    ae_bool rerrors;
    ae_bool cerrors;
    ae_bool spderrors;
    ae_bool hpderrors;
    ae_bool rfserrors;
    ae_bool waserrors;
    ae_bool result;


    maxn = 10;
    maxm = 5;
    passcount = 5;
    threshold = 10000*ae_machineepsilon;
    rfserrors = ae_false;
    rerrors = ae_false;
    cerrors = ae_false;
    spderrors = ae_false;
    hpderrors = ae_false;
    testdirectdensesolversunit_testrsolver(maxn, maxm, passcount, threshold, &rerrors, &rfserrors, _state);
    testdirectdensesolversunit_testspdsolver(maxn, maxm, passcount, threshold, &spderrors, &rfserrors, _state);
    testdirectdensesolversunit_testcsolver(maxn, maxm, passcount, threshold, &cerrors, &rfserrors, _state);
    testdirectdensesolversunit_testhpdsolver(maxn, maxm, passcount, threshold, &hpderrors, &rfserrors, _state);
    waserrors = (((rerrors||cerrors)||spderrors)||hpderrors)||rfserrors;
    if( !silent )
    {
        printf("TESTING DENSE SOLVER\n");
        printf("* REAL:                                   ");
        if( rerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* COMPLEX:                                ");
        if( cerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SPD:                                    ");
        if( spderrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* HPD:                                    ");
        if( hpderrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* ITERATIVE IMPROVEMENT:                  ");
        if( rfserrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
    }
    result = !waserrors;
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksolutionm(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,100*ae_machineepsilon)||ae_fp_greater(rep->r1,1+1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,100*ae_machineepsilon)||ae_fp_greater(rep->rinf,1+1000*ae_machineepsilon));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result&&ae_fp_less_eq(ae_fabs(xe->ptr.pp_double[i][j]-xs->ptr.pp_double[i][j], _state),threshold);
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksolutionmfast(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     /* Real    */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result&&ae_fp_less_eq(ae_fabs(xe->ptr.pp_double[i][j]-xs->ptr.pp_double[i][j], _state),threshold);
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksolution(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_vector* xs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xsm;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&xsm, 0, sizeof(xsm));
    ae_matrix_init(&xsm, 0, 0, DT_REAL, _state, ae_true);

    ae_matrix_set_length(&xsm, n, 1, _state);
    ae_v_move(&xsm.ptr.pp_double[0][0], xsm.stride, &xs->ptr.p_double[0], 1, ae_v_len(0,n-1));
    result = testdirectdensesolversunit_rmatrixchecksolutionm(xe, n, 1, threshold, info, rep, &xsm, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksolutionfast(/* Real    */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     /* Real    */ ae_vector* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_bool result;


    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            result = result&&ae_fp_less_eq(ae_fabs(xe->ptr.pp_double[i][0]-xs->ptr.p_double[i], _state),threshold);
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksingularm(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info!=-3&&info!=1 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,(double)(0))||ae_fp_greater(rep->r1,1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,(double)(0))||ae_fp_greater(rep->rinf,1000*ae_machineepsilon));
        if( info==-3 )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=m-1; j++)
                {
                    result = result&&ae_fp_eq(xs->ptr.pp_double[i][j],(double)(0));
                }
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksingularmfast(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     /* Real    */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info!=-3 )
    {
        result = ae_false;
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result&&ae_fp_eq(xs->ptr.pp_double[i][j],(double)(0));
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksingular(ae_int_t n,
     ae_int_t info,
     densesolverreport* rep,
     /* Real    */ ae_vector* xs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xsm;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&xsm, 0, sizeof(xsm));
    ae_matrix_init(&xsm, 0, 0, DT_REAL, _state, ae_true);

    ae_matrix_set_length(&xsm, n, 1, _state);
    ae_v_move(&xsm.ptr.pp_double[0][0], xsm.stride, &xs->ptr.p_double[0], 1, ae_v_len(0,n-1));
    result = testdirectdensesolversunit_rmatrixchecksingularm(n, 1, info, rep, &xsm, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_rmatrixchecksingularfast(ae_int_t n,
     ae_int_t info,
     /* Real    */ ae_vector* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_bool result;


    result = ae_true;
    if( info!=-3 )
    {
        result = ae_false;
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            result = result&&ae_fp_eq(xs->ptr.p_double[i],(double)(0));
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksolutionm(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,100*ae_machineepsilon)||ae_fp_greater(rep->r1,1+1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,100*ae_machineepsilon)||ae_fp_greater(rep->rinf,1+1000*ae_machineepsilon));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result&&ae_fp_less_eq(ae_c_abs(ae_c_sub(xe->ptr.pp_complex[i][j],xs->ptr.pp_complex[i][j]), _state),threshold);
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksolutionmfast(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     ae_int_t m,
     double threshold,
     ae_int_t info,
     /* Complex */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
        return result;
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            result = result&&ae_fp_less_eq(ae_c_abs(ae_c_sub(xe->ptr.pp_complex[i][j],xs->ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksolution(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_vector* xs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xsm;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&xsm, 0, sizeof(xsm));
    ae_matrix_init(&xsm, 0, 0, DT_COMPLEX, _state, ae_true);

    ae_matrix_set_length(&xsm, n, 1, _state);
    ae_v_cmove(&xsm.ptr.pp_complex[0][0], xsm.stride, &xs->ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
    result = testdirectdensesolversunit_cmatrixchecksolutionm(xe, n, 1, threshold, info, rep, &xsm, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Checks whether solver results are correct solution.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksolutionfast(/* Complex */ ae_matrix* xe,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     /* Complex */ ae_vector* xs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xsm;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&xsm, 0, sizeof(xsm));
    ae_matrix_init(&xsm, 0, 0, DT_COMPLEX, _state, ae_true);

    ae_matrix_set_length(&xsm, n, 1, _state);
    ae_v_cmove(&xsm.ptr.pp_complex[0][0], xsm.stride, &xs->ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
    result = testdirectdensesolversunit_cmatrixchecksolutionmfast(xe, n, 1, threshold, info, &xsm, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksingularm(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info!=-3&&info!=1 )
    {
        result = ae_false;
        return result;
    }
    result = result&&!(ae_fp_less(rep->r1,(double)(0))||ae_fp_greater(rep->r1,1000*ae_machineepsilon));
    result = result&&!(ae_fp_less(rep->rinf,(double)(0))||ae_fp_greater(rep->rinf,1000*ae_machineepsilon));
    if( info==-3 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result&&ae_c_eq_d(xs->ptr.pp_complex[i][j],(double)(0));
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksingularmfast(ae_int_t n,
     ae_int_t m,
     ae_int_t info,
     /* Complex */ ae_matrix* xs,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info!=-3 )
    {
        result = ae_false;
        return result;
    }
    if( info==-3 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result&&ae_c_eq_d(xs->ptr.pp_complex[i][j],(double)(0));
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksingular(ae_int_t n,
     ae_int_t info,
     densesolverreport* rep,
     /* Complex */ ae_vector* xs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xsm;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&xsm, 0, sizeof(xsm));
    ae_matrix_init(&xsm, 0, 0, DT_COMPLEX, _state, ae_true);

    ae_matrix_set_length(&xsm, n, 1, _state);
    ae_v_cmove(&xsm.ptr.pp_complex[0][0], xsm.stride, &xs->ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
    result = testdirectdensesolversunit_cmatrixchecksingularm(n, 1, info, rep, &xsm, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Checks whether solver results indicate singular matrix.
Returns True on success.
*************************************************************************/
static ae_bool testdirectdensesolversunit_cmatrixchecksingularfast(ae_int_t n,
     ae_int_t info,
     /* Complex */ ae_vector* xs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xsm;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    memset(&xsm, 0, sizeof(xsm));
    ae_matrix_init(&xsm, 0, 0, DT_COMPLEX, _state, ae_true);

    ae_matrix_set_length(&xsm, n, 1, _state);
    ae_v_cmove(&xsm.ptr.pp_complex[0][0], xsm.stride, &xs->ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
    result = testdirectdensesolversunit_cmatrixchecksingularmfast(n, 1, info, &xsm, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Copy
*************************************************************************/
static void testdirectdensesolversunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
}


/*************************************************************************
Copy
*************************************************************************/
static void testdirectdensesolversunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
}


/*************************************************************************
Drops upper or lower half of the matrix - fills it by special pattern
which may be used later to ensure that this part wasn't changed
*************************************************************************/
static void testdirectdensesolversunit_rmatrixdrophalf(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (droplower&&i>j)||(!droplower&&i<j) )
            {
                a->ptr.pp_double[i][j] = (double)(1+2*i+3*j);
            }
        }
    }
}


/*************************************************************************
Drops upper or lower half of the matrix - fills it by special pattern
which may be used later to ensure that this part wasn't changed
*************************************************************************/
static void testdirectdensesolversunit_cmatrixdrophalf(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (droplower&&i>j)||(!droplower&&i<j) )
            {
                a->ptr.pp_complex[i][j] = ae_complex_from_i(1+2*i+3*j);
            }
        }
    }
}


/*************************************************************************
Real test
*************************************************************************/
static void testdirectdensesolversunit_testrsolver(ae_int_t maxn,
     ae_int_t maxm,
     ae_int_t passcount,
     double threshold,
     ae_bool* rerrors,
     ae_bool* rfserrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix lua;
    ae_matrix atmp;
    ae_vector p;
    ae_matrix xe;
    ae_matrix b;
    ae_vector bv;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t n;
    ae_int_t m;
    ae_int_t pass;
    ae_int_t taskkind;
    double v;
    double verr;
    ae_int_t info;
    densesolverreport rep;
    densesolverlsreport repls;
    ae_matrix x;
    ae_vector xv;
    ae_vector y;
    ae_vector tx;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&lua, 0, sizeof(lua));
    memset(&atmp, 0, sizeof(atmp));
    memset(&p, 0, sizeof(p));
    memset(&xe, 0, sizeof(xe));
    memset(&b, 0, sizeof(b));
    memset(&bv, 0, sizeof(bv));
    memset(&rep, 0, sizeof(rep));
    memset(&repls, 0, sizeof(repls));
    memset(&x, 0, sizeof(x));
    memset(&xv, 0, sizeof(xv));
    memset(&y, 0, sizeof(y));
    memset(&tx, 0, sizeof(tx));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&lua, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&atmp, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_matrix_init(&xe, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&bv, 0, DT_REAL, _state, ae_true);
    _densesolverreport_init(&rep, _state, ae_true);
    _densesolverlsreport_init(&repls, _state, ae_true);
    ae_matrix_init(&x, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&xv, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tx, 0, DT_REAL, _state, ae_true);

    
    /*
     * General square matrices:
     * * test general solvers
     * * test least squares solver
     */
    for(pass=1; pass<=passcount; pass++)
    {
        for(n=1; n<=maxn; n++)
        {
            for(m=1; m<=maxm; m++)
            {
                
                /*
                 * ********************************************************
                 * WELL CONDITIONED TASKS
                 * ability to find correct solution is tested
                 * ********************************************************
                 *
                 * 1. generate random well conditioned matrix A.
                 * 2. generate random solution vector xe
                 * 3. generate right part b=A*xe
                 * 4. test different methods on original A
                 */
                rmatrixrndcond(n, (double)(1000), &a, _state);
                testdirectdensesolversunit_rmatrixmakeacopy(&a, n, n, &lua, _state);
                rmatrixlu(&lua, n, n, &p, _state);
                ae_matrix_set_length(&xe, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        xe.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    }
                }
                ae_matrix_set_length(&b, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &xe.ptr.pp_double[0][j], xe.stride, ae_v_len(0,n-1));
                        b.ptr.pp_double[i][j] = v;
                    }
                }
                
                /*
                 * Test solvers
                 */
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset2d(&x, _state);
                rmatrixsolvem(&a, n, &b, m, ae_fp_greater(ae_randomreal(_state),0.5), &info, &rep, &x, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolutionm(&xe, n, m, threshold, info, &rep, &x, _state);
                info = 0;
                ae_matrix_set_length(&x, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        x.ptr.pp_double[i][j] = b.ptr.pp_double[i][j];
                    }
                }
                rmatrixsolvemfast(&a, n, &x, m, &info, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolutionmfast(&xe, n, m, threshold, info, &x, _state);
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                rmatrixsolve(&a, n, &bv, &info, &rep, &xv, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolution(&xe, n, threshold, info, &rep, &xv, _state);
                info = 0;
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                rmatrixsolvefast(&a, n, &bv, &info, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolutionfast(&xe, n, threshold, info, &bv, _state);
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset2d(&x, _state);
                rmatrixlusolvem(&lua, &p, n, &b, m, &info, &rep, &x, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolutionm(&xe, n, m, threshold, info, &rep, &x, _state);
                info = 0;
                ae_matrix_set_length(&x, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        x.ptr.pp_double[i][j] = b.ptr.pp_double[i][j];
                    }
                }
                rmatrixlusolvemfast(&lua, &p, n, &x, m, &info, _state);
                ae_set_error_flag(rerrors, !testdirectdensesolversunit_rmatrixchecksolutionmfast(&xe, n, m, threshold, info, &x, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:552");
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                rmatrixlusolve(&lua, &p, n, &bv, &info, &rep, &xv, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolution(&xe, n, threshold, info, &rep, &xv, _state);
                info = 0;
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&xv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                rmatrixlusolvefast(&lua, &p, n, &xv, &info, _state);
                ae_set_error_flag(rerrors, !testdirectdensesolversunit_rmatrixchecksolutionfast(&xe, n, threshold, info, &xv, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:566");
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset2d(&x, _state);
                rmatrixmixedsolvem(&a, &lua, &p, n, &b, m, &info, &rep, &x, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolutionm(&xe, n, m, threshold, info, &rep, &x, _state);
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                rmatrixmixedsolve(&a, &lua, &p, n, &bv, &info, &rep, &xv, _state);
                *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksolution(&xe, n, threshold, info, &rep, &xv, _state);
                
                /*
                 * Test DenseSolverRLS():
                 * * test on original system A*x = b
                 * * test on overdetermined system with the same solution: (A' A')'*x = (b' b')'
                 * * test on underdetermined system with the same solution: (A 0 0 0 ) * z = b
                 */
                info = 0;
                testdirectdensesolversunit_unsetlsrep(&repls, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                rmatrixsolvels(&a, n, n, &bv, 0.0, &info, &repls, &xv, _state);
                if( info<=0 )
                {
                    *rerrors = ae_true;
                }
                else
                {
                    *rerrors = (*rerrors||ae_fp_less(repls.r2,100*ae_machineepsilon))||ae_fp_greater(repls.r2,1+1000*ae_machineepsilon);
                    *rerrors = (*rerrors||repls.n!=n)||repls.k!=0;
                    for(i=0; i<=n-1; i++)
                    {
                        *rerrors = *rerrors||ae_fp_greater(ae_fabs(xe.ptr.pp_double[i][0]-xv.ptr.p_double[i], _state),threshold);
                    }
                }
                info = 0;
                testdirectdensesolversunit_unsetlsrep(&repls, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, 2*n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                ae_v_move(&bv.ptr.p_double[n], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(n,2*n-1));
                ae_matrix_set_length(&atmp, 2*n, n, _state);
                copymatrix(&a, 0, n-1, 0, n-1, &atmp, 0, n-1, 0, n-1, _state);
                copymatrix(&a, 0, n-1, 0, n-1, &atmp, n, 2*n-1, 0, n-1, _state);
                rmatrixsolvels(&atmp, 2*n, n, &bv, 0.0, &info, &repls, &xv, _state);
                if( info<=0 )
                {
                    *rerrors = ae_true;
                }
                else
                {
                    *rerrors = (*rerrors||ae_fp_less(repls.r2,100*ae_machineepsilon))||ae_fp_greater(repls.r2,1+1000*ae_machineepsilon);
                    *rerrors = (*rerrors||repls.n!=n)||repls.k!=0;
                    for(i=0; i<=n-1; i++)
                    {
                        *rerrors = *rerrors||ae_fp_greater(ae_fabs(xe.ptr.pp_double[i][0]-xv.ptr.p_double[i], _state),threshold);
                    }
                }
                info = 0;
                testdirectdensesolversunit_unsetlsrep(&repls, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                ae_matrix_set_length(&atmp, n, 2*n, _state);
                copymatrix(&a, 0, n-1, 0, n-1, &atmp, 0, n-1, 0, n-1, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=n; j<=2*n-1; j++)
                    {
                        atmp.ptr.pp_double[i][j] = (double)(0);
                    }
                }
                rmatrixsolvels(&atmp, n, 2*n, &bv, 0.0, &info, &repls, &xv, _state);
                if( info<=0 )
                {
                    *rerrors = ae_true;
                }
                else
                {
                    *rerrors = *rerrors||ae_fp_neq(repls.r2,(double)(0));
                    *rerrors = (*rerrors||repls.n!=2*n)||repls.k!=n;
                    for(i=0; i<=n-1; i++)
                    {
                        *rerrors = *rerrors||ae_fp_greater(ae_fabs(xe.ptr.pp_double[i][0]-xv.ptr.p_double[i], _state),threshold);
                    }
                    for(i=n; i<=2*n-1; i++)
                    {
                        *rerrors = *rerrors||ae_fp_greater(ae_fabs(xv.ptr.p_double[i], _state),threshold);
                    }
                }
                
                /*
                 * ********************************************************
                 * EXACTLY SINGULAR MATRICES
                 * ability to detect singularity is tested
                 * ********************************************************
                 *
                 * 1. generate different types of singular matrices:
                 *    * zero (TaskKind=0)
                 *    * with zero columns (TaskKind=1)
                 *    * with zero rows (TaskKind=2)
                 *    * with equal rows/columns (TaskKind=2 or 3)
                 * 2. generate random solution vector xe
                 * 3. generate right part b=A*xe
                 * 4. test different methods
                 */
                for(taskkind=0; taskkind<=4; taskkind++)
                {
                    testdirectdensesolversunit_unset2d(&a, _state);
                    if( taskkind==0 )
                    {
                        
                        /*
                         * all zeros
                         */
                        ae_matrix_set_length(&a, n, n, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = (double)(0);
                            }
                        }
                    }
                    if( taskkind==1 )
                    {
                        
                        /*
                         * there is zero column
                         */
                        ae_matrix_set_length(&a, n, n, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            }
                        }
                        k = ae_randominteger(n, _state);
                        ae_v_muld(&a.ptr.pp_double[0][k], a.stride, ae_v_len(0,n-1), 0);
                    }
                    if( taskkind==2 )
                    {
                        
                        /*
                         * there is zero row
                         */
                        ae_matrix_set_length(&a, n, n, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            }
                        }
                        k = ae_randominteger(n, _state);
                        ae_v_muld(&a.ptr.pp_double[k][0], 1, ae_v_len(0,n-1), 0);
                    }
                    if( taskkind==3 )
                    {
                        
                        /*
                         * equal columns
                         */
                        if( n<2 )
                        {
                            continue;
                        }
                        ae_matrix_set_length(&a, n, n, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            }
                        }
                        k = 1+ae_randominteger(n-1, _state);
                        ae_v_move(&a.ptr.pp_double[0][0], a.stride, &a.ptr.pp_double[0][k], a.stride, ae_v_len(0,n-1));
                    }
                    if( taskkind==4 )
                    {
                        
                        /*
                         * equal rows
                         */
                        if( n<2 )
                        {
                            continue;
                        }
                        ae_matrix_set_length(&a, n, n, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            }
                        }
                        k = 1+ae_randominteger(n-1, _state);
                        ae_v_move(&a.ptr.pp_double[0][0], 1, &a.ptr.pp_double[k][0], 1, ae_v_len(0,n-1));
                    }
                    ae_matrix_set_length(&xe, n, m, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=m-1; j++)
                        {
                            xe.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    ae_matrix_set_length(&b, n, m, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=m-1; j++)
                        {
                            v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &xe.ptr.pp_double[0][j], xe.stride, ae_v_len(0,n-1));
                            b.ptr.pp_double[i][j] = v;
                        }
                    }
                    testdirectdensesolversunit_rmatrixmakeacopy(&a, n, n, &lua, _state);
                    rmatrixlu(&lua, n, n, &p, _state);
                    
                    /*
                     * Test RMatrixSolveM()
                     */
                    info = 0;
                    testdirectdensesolversunit_unsetrep(&rep, _state);
                    testdirectdensesolversunit_unset2d(&x, _state);
                    rmatrixsolvem(&a, n, &b, m, ae_fp_greater(ae_randomreal(_state),0.5), &info, &rep, &x, _state);
                    *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksingularm(n, m, info, &rep, &x, _state);
                    
                    /*
                     * Test RMatrixSolveMFast(); performed only for matrices
                     * with zero rows or columns
                     */
                    if( (taskkind==0||taskkind==1)||taskkind==2 )
                    {
                        info = 0;
                        ae_matrix_set_length(&x, n, m, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=m-1; j++)
                            {
                                x.ptr.pp_double[i][j] = b.ptr.pp_double[i][j];
                            }
                        }
                        rmatrixsolvemfast(&a, n, &x, m, &info, _state);
                        *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksingularmfast(n, m, info, &x, _state);
                    }
                    
                    /*
                     * Test RMatrixSolve()
                     */
                    info = 0;
                    testdirectdensesolversunit_unsetrep(&rep, _state);
                    testdirectdensesolversunit_unset2d(&x, _state);
                    ae_vector_set_length(&bv, n, _state);
                    ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                    rmatrixsolve(&a, n, &bv, &info, &rep, &xv, _state);
                    *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksingular(n, info, &rep, &xv, _state);
                    
                    /*
                     * Test RMatrixSolveFast(); performed only for matrices
                     * with zero rows or columns
                     */
                    if( (taskkind==0||taskkind==1)||taskkind==2 )
                    {
                        info = 0;
                        ae_vector_set_length(&bv, n, _state);
                        ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                        rmatrixsolvefast(&a, n, &bv, &info, _state);
                        ae_set_error_flag(rerrors, !testdirectdensesolversunit_rmatrixchecksingularfast(n, info, &bv, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:784");
                    }
                    
                    /*
                     * Test RMatrixLUSolveM()
                     */
                    info = 0;
                    testdirectdensesolversunit_unsetrep(&rep, _state);
                    testdirectdensesolversunit_unset2d(&x, _state);
                    rmatrixlusolvem(&lua, &p, n, &b, m, &info, &rep, &x, _state);
                    *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksingularm(n, m, info, &rep, &x, _state);
                    
                    /*
                     * Test RMatrixLUSolveMFast(); performed only for matrices
                     * with zero rows or columns
                     */
                    if( (taskkind==0||taskkind==1)||taskkind==2 )
                    {
                        info = 0;
                        ae_matrix_set_length(&x, n, m, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=m-1; j++)
                            {
                                x.ptr.pp_double[i][j] = b.ptr.pp_double[i][j];
                            }
                        }
                        rmatrixlusolvemfast(&lua, &p, n, &x, m, &info, _state);
                        ae_set_error_flag(rerrors, !testdirectdensesolversunit_rmatrixchecksingularmfast(n, m, info, &x, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:808");
                    }
                    
                    /*
                     * Test RMatrixLUSolve()
                     */
                    info = 0;
                    testdirectdensesolversunit_unsetrep(&rep, _state);
                    testdirectdensesolversunit_unset2d(&x, _state);
                    ae_vector_set_length(&bv, n, _state);
                    ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                    rmatrixlusolve(&lua, &p, n, &bv, &info, &rep, &xv, _state);
                    *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksingular(n, info, &rep, &xv, _state);
                    
                    /*
                     * Test RMatrixLUSolveFast(); performed only for matrices
                     * with zero rows or columns
                     */
                    if( (taskkind==0||taskkind==1)||taskkind==2 )
                    {
                        info = 0;
                        ae_vector_set_length(&bv, n, _state);
                        ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                        rmatrixlusolvefast(&lua, &p, n, &bv, &info, _state);
                        ae_set_error_flag(rerrors, !testdirectdensesolversunit_rmatrixchecksingularfast(n, info, &bv, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:832");
                    }
                    
                    /*
                     * Test RMatrixMixedSolveM()
                     */
                    info = 0;
                    testdirectdensesolversunit_unsetrep(&rep, _state);
                    testdirectdensesolversunit_unset2d(&x, _state);
                    rmatrixmixedsolvem(&a, &lua, &p, n, &b, m, &info, &rep, &x, _state);
                    *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksingularm(n, m, info, &rep, &x, _state);
                    
                    /*
                     * Test RMatrixMixedSolve()
                     */
                    info = 0;
                    testdirectdensesolversunit_unsetrep(&rep, _state);
                    testdirectdensesolversunit_unset2d(&x, _state);
                    ae_vector_set_length(&bv, n, _state);
                    ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                    rmatrixmixedsolve(&a, &lua, &p, n, &bv, &info, &rep, &xv, _state);
                    *rerrors = *rerrors||!testdirectdensesolversunit_rmatrixchecksingular(n, info, &rep, &xv, _state);
                }
            }
        }
    }
    
    /*
     * test iterative improvement
     */
    for(pass=1; pass<=passcount; pass++)
    {
        
        /*
         * Test iterative improvement matrices
         *
         * A matrix/right part are constructed such that both matrix
         * and solution components are within (-1,+1). Such matrix/right part
         * have nice properties - system can be solved using iterative
         * improvement with |A*x-b| about several ulps of max(1,|b|).
         */
        n = 100;
        ae_matrix_set_length(&a, n, n, _state);
        ae_matrix_set_length(&b, n, 1, _state);
        ae_vector_set_length(&bv, n, _state);
        ae_vector_set_length(&tx, n, _state);
        ae_vector_set_length(&xv, n, _state);
        ae_vector_set_length(&y, n, _state);
        for(i=0; i<=n-1; i++)
        {
            xv.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
            ae_v_move(&y.ptr.p_double[0], 1, &a.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
            xdot(&y, &xv, n, &tx, &v, &verr, _state);
            bv.ptr.p_double[i] = v;
        }
        ae_v_move(&b.ptr.pp_double[0][0], b.stride, &bv.ptr.p_double[0], 1, ae_v_len(0,n-1));
        
        /*
         * Test RMatrixSolveM()
         */
        testdirectdensesolversunit_unset2d(&x, _state);
        rmatrixsolvem(&a, n, &b, 1, ae_true, &info, &rep, &x, _state);
        if( info<=0 )
        {
            *rfserrors = ae_true;
        }
        else
        {
            ae_vector_set_length(&xv, n, _state);
            ae_v_move(&xv.ptr.p_double[0], 1, &x.ptr.pp_double[0][0], x.stride, ae_v_len(0,n-1));
            for(i=0; i<=n-1; i++)
            {
                ae_v_move(&y.ptr.p_double[0], 1, &a.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
                xdot(&y, &xv, n, &tx, &v, &verr, _state);
                *rfserrors = *rfserrors||ae_fp_greater(ae_fabs(v-b.ptr.pp_double[i][0], _state),8*ae_machineepsilon*ae_maxreal((double)(1), ae_fabs(b.ptr.pp_double[i][0], _state), _state));
            }
        }
        
        /*
         * Test RMatrixSolve()
         */
        testdirectdensesolversunit_unset1d(&xv, _state);
        rmatrixsolve(&a, n, &bv, &info, &rep, &xv, _state);
        if( info<=0 )
        {
            *rfserrors = ae_true;
        }
        else
        {
            for(i=0; i<=n-1; i++)
            {
                ae_v_move(&y.ptr.p_double[0], 1, &a.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
                xdot(&y, &xv, n, &tx, &v, &verr, _state);
                *rfserrors = *rfserrors||ae_fp_greater(ae_fabs(v-bv.ptr.p_double[i], _state),8*ae_machineepsilon*ae_maxreal((double)(1), ae_fabs(bv.ptr.p_double[i], _state), _state));
            }
        }
        
        /*
         * Test LS-solver on the same matrix
         */
        rmatrixsolvels(&a, n, n, &bv, 0.0, &info, &repls, &xv, _state);
        if( info<=0 )
        {
            *rfserrors = ae_true;
        }
        else
        {
            for(i=0; i<=n-1; i++)
            {
                ae_v_move(&y.ptr.p_double[0], 1, &a.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
                xdot(&y, &xv, n, &tx, &v, &verr, _state);
                *rfserrors = *rfserrors||ae_fp_greater(ae_fabs(v-bv.ptr.p_double[i], _state),8*ae_machineepsilon*ae_maxreal((double)(1), ae_fabs(bv.ptr.p_double[i], _state), _state));
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
SPD test
*************************************************************************/
static void testdirectdensesolversunit_testspdsolver(ae_int_t maxn,
     ae_int_t maxm,
     ae_int_t passcount,
     double threshold,
     ae_bool* spderrors,
     ae_bool* rfserrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix cha;
    ae_matrix atmp;
    ae_vector p;
    ae_matrix xe;
    ae_matrix b;
    ae_vector bv;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t n;
    ae_int_t m;
    ae_int_t pass;
    ae_int_t taskkind;
    double v;
    ae_bool isupper;
    ae_int_t info;
    densesolverreport rep;
    densesolverlsreport repls;
    ae_matrix x;
    ae_vector xv;
    ae_vector y;
    ae_vector tx;

    ae_frame_make(_state, &_frame_block);
    memset(&a, 0, sizeof(a));
    memset(&cha, 0, sizeof(cha));
    memset(&atmp, 0, sizeof(atmp));
    memset(&p, 0, sizeof(p));
    memset(&xe, 0, sizeof(xe));
    memset(&b, 0, sizeof(b));
    memset(&bv, 0, sizeof(bv));
    memset(&rep, 0, sizeof(rep));
    memset(&repls, 0, sizeof(repls));
    memset(&x, 0, sizeof(x));
    memset(&xv, 0, sizeof(xv));
    memset(&y, 0, sizeof(y));
    memset(&tx, 0, sizeof(tx));
    ae_matrix_init(&a, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&cha, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&atmp, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&p, 0, DT_INT, _state, ae_true);
    ae_matrix_init(&xe, 0, 0, DT_REAL, _state, ae_true);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&bv, 0, DT_REAL, _state, ae_true);
    _densesolverreport_init(&rep, _state, ae_true);
    _densesolverlsreport_init(&repls, _state, ae_true);
    ae_matrix_init(&x, 0, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&xv, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&y, 0, DT_REAL, _state, ae_true);
    ae_vector_init(&tx, 0, DT_REAL, _state, ae_true);

    
    /*
     * General square matrices:
     * * test general solvers
     * * test least squares solver
     */
    for(pass=1; pass<=passcount; pass++)
    {
        for(n=1; n<=maxn; n++)
        {
            for(m=1; m<=maxm; m++)
            {
                
                /*
                 * ********************************************************
                 * WELL CONDITIONED TASKS
                 * ability to find correct solution is tested
                 * ********************************************************
                 *
                 * 1. generate random well conditioned matrix A.
                 * 2. generate random solution vector xe
                 * 3. generate right part b=A*xe
                 * 4. test different methods on original A
                 */
                isupper = ae_fp_greater(ae_randomreal(_state),0.5);
                spdmatrixrndcond(n, (double)(1000), &a, _state);
                testdirectdensesolversunit_rmatrixmakeacopy(&a, n, n, &cha, _state);
                if( !spdmatrixcholesky(&cha, n, isupper, _state) )
                {
                    *spderrors = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                ae_matrix_set_length(&xe, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        xe.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    }
                }
                ae_matrix_set_length(&b, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &xe.ptr.pp_double[0][j], xe.stride, ae_v_len(0,n-1));
                        b.ptr.pp_double[i][j] = v;
                    }
                }
                testdirectdensesolversunit_rmatrixdrophalf(&a, n, isupper, _state);
                testdirectdensesolversunit_rmatrixdrophalf(&cha, n, isupper, _state);
                
                /*
                 * Test solvers
                 */
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset2d(&x, _state);
                spdmatrixsolvem(&a, n, isupper, &b, m, &info, &rep, &x, _state);
                *spderrors = *spderrors||!testdirectdensesolversunit_rmatrixchecksolutionm(&xe, n, m, threshold, info, &rep, &x, _state);
                info = 0;
                ae_matrix_set_length(&x, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        x.ptr.pp_double[i][j] = b.ptr.pp_double[i][j];
                    }
                }
                spdmatrixsolvemfast(&a, n, isupper, &x, m, &info, _state);
                ae_set_error_flag(spderrors, !testdirectdensesolversunit_rmatrixchecksolutionmfast(&xe, n, m, threshold, info, &x, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:1023");
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                spdmatrixsolve(&a, n, isupper, &bv, &info, &rep, &xv, _state);
                *spderrors = *spderrors||!testdirectdensesolversunit_rmatrixchecksolution(&xe, n, threshold, info, &rep, &xv, _state);
                info = 0;
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                spdmatrixsolvefast(&a, n, isupper, &bv, &info, _state);
                ae_set_error_flag(spderrors, !testdirectdensesolversunit_rmatrixchecksolutionfast(&xe, n, threshold, info, &bv, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:1037");
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset2d(&x, _state);
                spdmatrixcholeskysolvem(&cha, n, isupper, &b, m, &info, &rep, &x, _state);
                *spderrors = *spderrors||!testdirectdensesolversunit_rmatrixchecksolutionm(&xe, n, m, threshold, info, &rep, &x, _state);
                info = 0;
                ae_matrix_set_length(&x, n, m, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        x.ptr.pp_double[i][j] = b.ptr.pp_double[i][j];
                    }
                }
                spdmatrixcholeskysolvemfast(&cha, n, isupper, &x, m, &info, _state);
                ae_set_error_flag(spderrors, !testdirectdensesolversunit_rmatrixchecksolutionmfast(&xe, n, m, threshold, info, &x, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:1051");
                info = 0;
                testdirectdensesolversunit_unsetrep(&rep, _state);
                testdirectdensesolversunit_unset1d(&xv, _state);
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                spdmatrixcholeskysolve(&cha, n, isupper, &bv, &info, &rep, &xv, _state);
                *spderrors = *spderrors||!testdirectdensesolversunit_rmatrixchecksolution(&xe, n, threshold, info, &rep, &xv, _state);
                info = 0;
                ae_vector_set_length(&bv, n, _state);
                ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                spdmatrixcholeskysolvefast(&cha, n, isupper, &bv, &info, _state);
                ae_set_error_flag(spderrors, !testdirectdensesolversunit_rmatrixchecksolutionfast(&xe, n, threshold, info, &bv, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:1065");
                
                /*
                 * ********************************************************
                 * EXACTLY SINGULAR MATRICES
                 * ability to detect singularity is tested
                 * ********************************************************
                 *
                 * 1. generate different types of singular matrices:
                 *    * zero
                 *    * with zero columns
                 *    * with zero rows
                 *    * with equal rows/columns
                 * 2. generate random solution vector xe
                 * 3. generate right part b=A*xe
                 * 4. test different methods
                 */
                for(taskkind=0; taskkind<=3; taskkind++)
                {
                    testdirectdensesolversunit_unset2d(&a, _state);
                    if( taskkind==0 )
                    {
                        
                        /*
                         * all zeros
                         */
                        ae_matrix_set_length(&a, n, n, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = (double)(0);
                            }
                        }
                    }
                    if( taskkind==1 )
                    {
                        
                        /*
                         * there is zero column
                         */
                        ae_matrix_set_length(&a, n, n, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=i; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                                a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
                            }
                        }
                        k = ae_randominteger(n, _state);
                        ae_v_muld(&a.ptr.pp_double[0][k], a.stride, ae_v_len(0,n-1), 0);
                        ae_v_muld(&a.ptr.pp_double[k][0], 1, ae_v_len(0,n-1), 0);
                    }
                    if( taskkind==2 )
                    {
                        
                        /*
                         * there is zero row
                         */
                        ae_matrix_set_length(&a, n, n, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=i; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                                a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
                            }
                        }
                        k = ae_randominteger(n, _state);
                        ae_v_muld(&a.ptr.pp_double[k][0], 1, ae_v_len(0,n-1), 0);
                        ae_v_muld(&a.ptr.pp_double[0][k], a.stride, ae_v_len(0,n-1), 0);
                    }
                    if( taskkind==3 )
                    {
                        
                        /*
                         * equal columns/rows
                         */
                        if( n<2 )
                        {
                            continue;
                        }
                        ae_matrix_set_length(&a, n, n, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=i; j<=n-1; j++)
                            {
                                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                                a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
                            }
                        }
                        k = 1+ae_randominteger(n-1, _state);
                        ae_v_move(&a.ptr.pp_double[0][0], a.stride, &a.ptr.pp_double[0][k], a.stride, ae_v_len(0,n-1));
                        ae_v_move(&a.ptr.pp_double[0][0], 1, &a.ptr.pp_double[k][0], 1, ae_v_len(0,n-1));
                    }
                    ae_matrix_set_length(&xe, n, m, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=m-1; j++)
                        {
                            xe.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    ae_matrix_set_length(&b, n, m, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=m-1; j++)
                        {
                            v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &xe.ptr.pp_double[0][j], xe.stride, ae_v_len(0,n-1));
                            b.ptr.pp_double[i][j] = v;
                        }
                    }
                    testdirectdensesolversunit_rmatrixmakeacopy(&a, n, n, &cha, _state);
                    testdirectdensesolversunit_rmatrixdrophalf(&a, n, isupper, _state);
                    testdirectdensesolversunit_rmatrixdrophalf(&cha, n, isupper, _state);
                    
                    /*
                     * Test SPDMatrixSolveM()
                     */
                    info = 0;
                    testdirectdensesolversunit_unsetrep(&rep, _state);
                    testdirectdensesolversunit_unset2d(&x, _state);
                    spdmatrixsolvem(&a, n, isupper, &b, m, &info, &rep, &x, _state);
                    *spderrors = *spderrors||!testdirectdensesolversunit_rmatrixchecksingularm(n, m, info, &rep, &x, _state);
                    
                    /*
                     * Test SPDMatrixSolveMFast()
                     */
                    if( (taskkind==0||taskkind==1)||taskkind==2 )
                    {
                        info = 0;
                        ae_matrix_set_length(&x, n, m, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=m-1; j++)
                            {
                                x.ptr.pp_double[i][j] = b.ptr.pp_double[i][j];
                            }
                        }
                        spdmatrixsolvemfast(&a, n, isupper, &x, m, &info, _state);
                        ae_set_error_flag(spderrors, !testdirectdensesolversunit_rmatrixchecksingularmfast(n, m, info, &x, _state), __FILE__, __LINE__, "testdirectdensesolversunit.ap:1181");
                    }
                    
                    /*
                     * Test SPDMatrixSolve()
                     */
                    info = 0;
                    testdirectdensesolversunit_unsetrep(&rep, _state);
                    testdirectdensesolversunit_unset2d(&x, _state);
                    ae_vector_set_length(&bv, n, _state);
                    ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                    spdmatrixsolve(&a, n, isupper, &bv, &info, &rep, &xv, _state);
                    *spderrors = *spderrors||!testdirectdensesolversunit_rmatrixchecksingular(n, info, &rep, &xv, _state);
                    
                    /*
                     * Test SPDMatrixSolveFast()
                     */
                    info = 0;
                    ae_vector_set_length(&bv, n, _state);
                    ae_v_move(&bv.ptr.p_double[0], 1, &b.ptr.pp_double[0][0], b.stride, ae_v_len(0,n-1));
                    spdmatrixsolvefast(&a, n, isupp