/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:27:15 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.PipedReader;
import java.io.StringReader;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockPrintWriter;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class RawStreamSequence_ESTest extends RawStreamSequence_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      rawStreamSequence0.getFastaHeaderStrings();
      assertEquals(0, rawStreamSequence0.length());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = null;
      try {
        rawStreamSequence0 = new RawStreamSequence((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = null;
      try {
        rawStreamSequence0 = new RawStreamSequence((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("Can't remove transition as its weight is not zero or NaN: ");
      PipedOutputStream pipedOutputStream0 = new PipedOutputStream();
      MockPrintWriter mockPrintWriter0 = new MockPrintWriter(pipedOutputStream0);
      rawStreamSequence0.writeToStream(mockPrintWriter0);
      assertEquals(6, rawStreamSequence0.getTCount());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("org.apache.log4j.RollingCalendar", "org.apache.log4j.RollingCalendar");
      RawStreamSequence rawStreamSequence0 = null;
      try {
        rawStreamSequence0 = new RawStreamSequence(fastaStreamSequence0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      rawStreamSequence0.setFastaHeaderPositionsOnReverseComplement((RangeVector) null);
      assertEquals(0, rawStreamSequence0.length());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("_");
      int[] intArray0 = rawStreamSequence0.getFastaHeaderPositions();
      rawStreamSequence0.setFastaHeaderPosition(intArray0, intArray0);
      assertArrayEquals(new int[] {}, intArray0);
      assertEquals(1, rawStreamSequence0.length());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("G*}Zh5Kg:^&ac#S{G");
      int[] intArray0 = new int[5];
      int[] intArray1 = new int[3];
      rawStreamSequence0.setFastaHeaderPosition(intArray0, intArray1);
      assertEquals(17, rawStreamSequence0.length());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      ByteArrayOutputStream byteArrayOutputStream0 = new ByteArrayOutputStream();
      MockPrintWriter mockPrintWriter0 = new MockPrintWriter(byteArrayOutputStream0, true);
      rawStreamSequence0.writeToStream(mockPrintWriter0);
      assertEquals(0, rawStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      StringReader stringReader0 = new StringReader(" as it is not an instance of CrossProductSymbol or ");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(linePushBackReader0);
      assertEquals(0, rawStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      // Undeclared exception!
      try { 
        rawStreamSequence0.copy();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("Can't remove transition as its weight is not zero or NaN: ");
      char[] charArray0 = new char[4];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(charArrayReader0);
      rawStreamSequence0.readHeader(linePushBackReader0);
      assertEquals(47, rawStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader(2960);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pipedReader0);
      RawStreamSequence rawStreamSequence0 = null;
      try {
        rawStreamSequence0 = new RawStreamSequence(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      int int0 = rawStreamSequence0.getFormatType();
      assertEquals(3, int0);
      assertEquals(0, rawStreamSequence0.length());
  }
}
