;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.

;; Check that heap types are emitted properly in the binary format. This file
;; contains small modules that each use a single instruction with a heap type.
;; If we forgot to update collectHeapTypes then we would not write out their
;; type, and hit an error during --roundtrip.

;; RUN: foreach %s %t wasm-opt -all --roundtrip -S -o - | filecheck %s
;; RUN: foreach %s %t wasm-opt -all --roundtrip -S --nominal -o - | filecheck %s --check-prefix NOMNL

(module
  ;; CHECK:      (type $struct.A (struct (field i32)))
  ;; NOMNL:      (type $struct.A (struct_subtype (field i32) data))
  (type $struct.A (struct i32))
  ;; NOMNL:      (type $struct.B (struct_subtype (field i32) data))
  (type $struct.B (struct i32))
  ;; CHECK:      (func $test
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.test_static $struct.A
  ;; CHECK-NEXT:    (ref.null $struct.A)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $test (type $none_=>_none)
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (ref.test_static $struct.B
  ;; NOMNL-NEXT:    (ref.null $struct.A)
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT: )
  (func $test
    (drop
      (ref.test_static $struct.B (ref.null $struct.A))
    )
  )
)

(module
  ;; CHECK:      (type $struct.A (struct (field i32)))
  ;; NOMNL:      (type $struct.A (struct_subtype (field i32) data))
  (type $struct.A (struct i32))
  ;; NOMNL:      (type $struct.B (struct_subtype (field i32) data))
  (type $struct.B (struct i32))
  ;; CHECK:      (func $test
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast_static $struct.A
  ;; CHECK-NEXT:    (ref.null $struct.A)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $test (type $none_=>_none)
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (ref.cast_static $struct.B
  ;; NOMNL-NEXT:    (ref.null $struct.A)
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT: )
  (func $test
    (drop
      (ref.cast_static $struct.B (ref.null $struct.A))
    )
  )
)

(module
  ;; CHECK:      (type $struct.A (struct (field i32)))
  ;; NOMNL:      (type $struct.A (struct_subtype (field i32) data))
  (type $struct.A (struct i32))
  ;; CHECK:      (func $test
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_default $struct.A)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $test (type $none_=>_none)
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (struct.new_default $struct.A)
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT: )
  (func $test
    (drop
      (struct.new_default $struct.A)
    )
  )
)

(module
  ;; CHECK:      (type $vector (array (mut f64)))
  ;; NOMNL:      (type $vector (array_subtype (mut f64) data))
  (type $vector (array (mut f64)))
  ;; CHECK:      (func $test
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (array.new $vector
  ;; CHECK-NEXT:    (f64.const 3.14159)
  ;; CHECK-NEXT:    (i32.const 3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $test (type $none_=>_none)
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (array.new $vector
  ;; NOMNL-NEXT:    (f64.const 3.14159)
  ;; NOMNL-NEXT:    (i32.const 3)
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT: )
  (func $test
    (drop
      (array.new $vector
        (f64.const 3.14159)
        (i32.const 3)
      )
    )
  )
)

(module
  ;; CHECK:      (type $vector (array (mut f64)))
  ;; NOMNL:      (type $vector (array_subtype (mut f64) data))
  (type $vector (array (mut f64)))
  ;; CHECK:      (func $test
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (array.init_static $vector
  ;; CHECK-NEXT:    (f64.const 1)
  ;; CHECK-NEXT:    (f64.const 2)
  ;; CHECK-NEXT:    (f64.const 4)
  ;; CHECK-NEXT:    (f64.const 8)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $test (type $none_=>_none)
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (array.init_static $vector
  ;; NOMNL-NEXT:    (f64.const 1)
  ;; NOMNL-NEXT:    (f64.const 2)
  ;; NOMNL-NEXT:    (f64.const 4)
  ;; NOMNL-NEXT:    (f64.const 8)
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT: )
  (func $test
    (drop
      (array.init_static $vector
        (f64.const 1)
        (f64.const 2)
        (f64.const 4)
        (f64.const 8)
      )
    )
  )
)
