/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <utility>
#include <cassert>
#include <ctime>
#include <map>
#include <set>
#include <vector>
#include <iostream>
#include <fstream>
#include <string>
#include <cstring>
#include <exception>
#include <stdexcept>
#include <cmath>
#include <algorithm>
#include <numeric>
#include <sstream>
#include <cstdlib>
#include <stack>
#include <queue>
#include <typeinfo>
#include <sys/stat.h>
#include <cerrno>
#include <libintl.h>
#include <getopt.h>


#define _(String) gettext (String)


//useful macro

#define DEBUG_TO_CERR(x) std::cerr << __FUNCTION__ << " line: "\
  << __LINE__ << " check: " << #x << " = " << x << std::endl;

//#include <mcheck.h>

using namespace std;


/**
 *larghezza della pagina in pixel
 */

#define PAPER_W_STD 800


/**
 *altezza della pagina in pixel
 */

#define PAPER_H_STD 600

/**numero di dimensioni possibili per i font*/

#define NUM_FONT_DIM 50


/**
 *Tipo di atomo di default per un nuovo legame
 */

#define DEFAULT_TYPE_ATOMO 12

/**
 *Tipo di gruppo di default per un nuovo gruppo
 */

#define DEFAULT_TYPE_GROUP 0

#define ATOMO 10
#define ETICHETTA 11

/***************tipi procedure***********/

#define PROC_ARC      1
#define PROC_ARROW    2
#define PROC_BEZIER   3
#define PROC_BOX      4

/***************************************/


#define ARR_NO_PUNT      1
#define ARR_OMOL_PUNT    2
#define ARR_ETEROL_PUNT  3
#define ARR_DOUBLE       4
#define ARR_BLOC         5
#define ARR_EQ           6

#define EQU_SPACING      6.0f

#define TYPE_OF_ARROW_NUMBER 6


/**
 *Larghezza finestra
 */

#define FIN_W 800

/**
 *Altezza finestra
 */

#define FIN_H 624



/**
 *Il valore per gruppo non valido
 */

#define NO_VALID_GROUP -1

/*
 *Valori di default per l'interfaccia
 */



// units
#define PIXELS 0
#define ENGLISH 1
#define METRIC 2


// page setup
#define PAGE_LETTER 1
#define PAGE_LEGAL  2
#define PAGE_A4     3
#define PAGE_640    4
#define PAGE_800    5
#define PAGE_1024   6
#define PAGE_CUSTOM 7
#define PAGE_PORTRAIT  100
#define PAGE_LANDSCAPE 200


/**
 *Grid settings
 */

#define GRID_NONE 0
#define GRID_SQUARE 1
#define GRID_HEX 2



/**
 *Errore ammesso nella selezione del legame
 */

#define SENSIB_LEG 5


/**
 *Larghezza freccia in px
 */
#define ARR_W 12.0f

/**
 *Altezza freccia in px
 */

#define ARR_H 4.0f


/**
 *Arrow gap
 */

#define ARR_GAP .25

/**
 *Lunghezza legame in px 
 */

#define LENGHT_BOND 25.0f

/**
 *Angolo legame in radianti
 */

#define ANGL_BOND .52359877559829887307

/**
 *Spazio tra i legami in un legame multiplo in px
 */

#define SPACE_BOND 3.0f


/**
 * specifica quanto,in  un legame  multiplo, i legami  sopra e  sotto il
 * principale sono piu' corti del principale.
 */

#define MULTIPLE_BOND_GAP 1.0f/8.0f



/**
 *Width default of  single bond
 */

#define LARG_SINGLE_BOND   1.0f

/**
 *Larghezza massima del cuneo di un legame sereospecifico
 */

#define LARG_MAX_CUNEO   4.0f

/**
 *Larghezza minima del cuneo di un legame sereospecifico
 */

#define LARG_MIN_CUNEO   2.0f

/**
 *Tratteggio di un legame tratteggiato
 */

#define TRATTEGGIO_LEGAME 5


/**
 *Ampiezza dell'ansa del legame a streochimica sconosciuta
 *
 */

#define AMPIEZZA_STEREO_SCON  2.0f

/**
 *frequenza dell'ansa del legame a streochimica sconosciuta
 *
 */

#define FREQUENZA_STEREO_SCON 1.0f


/**
 *Numero di tick per il legame che si allontana da noi
 */

#define NUM_BARRETTE_STEREO_DOWN 8

/**
 *Di quanto deve essere piu' piccolo l'apice e il pedice?
 */

#define SCALE_APICI 2.0f



#define SCALE_SUP_MINUS .72f


#define MINUS "-"
#define PLUS  "+"


/**
 *Tipo di font per le cariche
 */

#define FONT_STD_CARICHE 0

/**
 *Font standard per le etichette
 */
#define FONT_STD  0

/**
 *Dimensione font standard per le etichette
 */

#define FONT_STD_DIM  13


/**
 *Raggio degli elettroni
 * <b>this is the value of border in png bounding box</b>
 */

#define RAGGIO_EL 3


/**
 *Raggio dell'idrogeno verso di noi.
 */

#define RAGGIO_IDR_UP 6


#define DEFAULT_SIMILAR_THRESHOLD 0.1f

/**
 *Symbol table
 */

#define ETIC_ALLINEA_DX 2
#define ETIC_ALLINEA_SX 0
#define ETIC_ALLINEA_CT 1

#define NO_ETIC         "#"
#define ETIC_IDR_UP     "."
#define NULL_CHAR       "\t\n "

#define APRI             "{"
#define CHIUDI           "}"
#define DP               ":"
#define SEP              ","

#define ETIC_ELEMENTO               "elemento"
#define ETIC_LISTA                  "lista"
#define ETIC_LEGAME                 "legame"
#define ETIC_ATOMO                  "atomo"
#define ETIC_TIPO_ATOMO             "tipo_atomo"
#define ETIC_ETIC                   "etichetta"
#define ETIC_MULTILINE_LABEL        "multiline_label"
#define ETIC_MULTIFONT_LABEL        "multifont_label"
#define ETIC_PARAGRAPH              "paragraph"
#define ETIC_GRUPPO                 "gruppo"
#define ETIC_TIPO_GRUPPO            "tipo_gruppo"
#define ETIC_ROT                    "ROT"
#define ETIC_ARC                    "ARC"
#define ETIC_ARROW                  "ARROW"
#define ETIC_BEZIER                 "BEZIER"
#define ETIC_BOX                    "BOX"

#define APICE            "^"
#define PEDICE           "_"

#define ESCAPE_CHAR      "\\"

#define NUM_CAMPI_ELEM  6
#define NUM_CAMPI_ETIC  5

#define CITE_ERROR_RG   10

#define COMP_R_EV       0xff
#define COMP_G_EV       0x00
#define COMP_B_EV       0x00


//extern Fl_Double_Window* la_finestra;



#define EXPORT_FORMAT_PS  "ps"
#define EXPORT_FORMAT_SVG "svg"
#define EXPORT_FORMAT_PNG "png"



/**
 *Default button width
 *
 */
#define LARG_BUTTON_DEFAULT 28


#define ALT_MENU 30

#define ALT_TOOLBAR 32

#define LARGH_BUTTON_BAR 62
#define ALT_FIN 200
#define LARGH_FIN 800

#define ALT_BUTT_LEFT 28
#define LARG_BUTTON_LEFT 28

#define LARG_BUTTON_LEFT_L (LARGH_BUTTON_BAR/2 - 2)
#define LARG_BUTTON_TOP 28
#define ALT_BUTT_TOP    28

#define HEIGHT_INF_BAR  ALT_BUTT_TOP


#define PADD_BUTT 2

#define SPACER ALT_BUTT_LEFT



/**
 *Contiene i simboli degli elementi ordinati per numero atomico.
 */


const string symbol_el[104]={
  "" ,"H", "He", 
      "Li", "Be", "B", "C", "N", "O", "F", "Ne",
      "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", 
      "K",  "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", 
      "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe",
      "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", 
      "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr"};



