//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Device/DetectorAlignmentForm.h
//! @brief     A widget for editing the alignment of a detector
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_DEVICE_DETECTORALIGNMENTFORM_H
#define BORNAGAIN_GUI_VIEW_DEVICE_DETECTORALIGNMENTFORM_H

#include <QWidget>

class DetectorAlignmentForm;
class DoubleProperty;
class DoubleSpinBox;
class QFormLayout;
class RectangularDetectorItem;
class VectorProperty;

/// Widget for selecting the alignment of a detector (combo box) and input of the corresponding
/// values

class DetectorAlignmentForm : public QWidget {
    Q_OBJECT
public:
    DetectorAlignmentForm(QWidget* parent, RectangularDetectorItem* item);

signals:
    void dataChanged();

private:
    void createAligmentWidgets();
    DoubleSpinBox* createSpinBox(QFormLayout* parentFormLayout, DoubleProperty& d);
    DoubleSpinBox* createSpinBox(DoubleProperty& d);
    void addVector(QFormLayout* parentLayout, VectorProperty& d);

private:
    RectangularDetectorItem* m_item;
    QFormLayout* m_formLayout;
};

#endif // BORNAGAIN_GUI_VIEW_DEVICE_DETECTORALIGNMENTFORM_H
