//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/ScanEditor.h
//! @brief     Defines class ScanEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INSTRUMENT_SCANEDITOR_H
#define BORNAGAIN_GUI_VIEW_INSTRUMENT_SCANEDITOR_H

#include <QGroupBox>

class ScanItem;
class InstrumentNotifier;

//! Specular beam editor. Operates on ScanItem.

class ScanEditor : public QGroupBox {
    Q_OBJECT

public:
    ScanEditor(QWidget* parent, ScanItem* item, InstrumentNotifier* ec, bool allow_distr = true);

signals:
    void dataChanged();
};

#endif // BORNAGAIN_GUI_VIEW_INSTRUMENT_SCANEDITOR_H
