# -*- coding: utf-8; indent-tabs-mode: t; tab-width: 4 -*-

#  Copyright (C) 2008-2010 by Canonical Ltd
#  Copyright (C) 2012 Koichi Akabe <vbkaisetsu@gmail.com>
# 
#  gLogic is free software: you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the
#  Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
# 
#  gLogic is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#  See the GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License along
#  with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from bzrlib.commands import Command
from bzrlib import config as globalconfig
from bzrlib import branch
from i18n import gettext as _
import requests
from requests_oauthlib import OAuth1
from urlparse import parse_qs
import twitter

from keys import *


class cmd_tweet_auth(Command):

	"""Authenticate to tweet messages on services

	This command gets an access token from services. 

	You can choose "twitter" or "identica" as a service. If you authenticated
	with both services, this plugin will tweet to each services.
	"""

	aliases = ["twitter-auth"]
	takes_args = ["service?"]


	def auth(self, service_name, request_token_url, access_token_url, authorize_url, consumer_key, consumer_sec):

		oauth_consumer = OAuth1(consumer_key, client_secret=consumer_sec)

		try:
			r = requests.post(url=request_token_url, auth=oauth_consumer)
		except Exception:
			print(_("Unable to connect to the server. Please check the internet connection."))
			return

		credentials = parse_qs(r.content)
		owner_key = credentials.get("oauth_token")[0]
		owner_sec = credentials.get("oauth_token_secret")[0]

		print(_("Please access to the following address and get pin:"))
		print("%s?oauth_token=%s" % (authorize_url, credentials.get("oauth_token")[0]))

		pin = raw_input(_("PIN code: ").encode("utf-8"))

		if pin == "":
			print(_("Authorization failed!"))
			return

		oauth_verify = OAuth1(consumer_key, client_secret=consumer_sec, 
		                      resource_owner_key=owner_key, resource_owner_secret=owner_sec,
		                      verifier=pin)

		try:
			r = requests.post(url=access_token_url, auth=oauth_verify)
		except Exception:
			print(_("Unable to connect to the server. Please check the internet connection."))
			return

		credentials = parse_qs(r.content)

		try:
			owner_key = credentials.get("oauth_token")[0]
			owner_sec = credentials.get("oauth_token_secret")[0]
			gs = globalconfig.GlobalStack()
			print(_("Authorization success!"))

		except Exception:
			print(_("Authorization failed!"))
			return

		gs.set("%s_token_key" % service_name, owner_key)
		gs.set("%s_token_secret" % service_name, owner_sec)


	def run(self, service="twitter"):

		if service == "twitter":

			self.auth("twitter",
			          "https://api.twitter.com/oauth/request_token",
			          "https://api.twitter.com/oauth/access_token",
			          "https://api.twitter.com/oauth/authorize",
			          twitter_consumer_key,
			          twitter_consumer_sec)


			"""
		elif service == "identica":
			self.auth("identica",
			          "https://identi.ca/api/oauth/request_token?oauth_callback=oob",
			          "https://identi.ca/api/oauth/access_token",
			          "https://identi.ca/api/oauth/authorize",
			          identica_consumer_key,
			          identica_consumer_sec)
		"""

		else:
			print(_("Unknown service!"))


class cmd_tweet_branchid(Command):

	"""Set a branch id for commit messages

	This plugin tweets the following formatted message:
	  bzr commit: BRANCHID has the new revid: 10: example commit [bzr-tweet]
	
	You can set BRANCHID using this command.
	"""

	aliases = ["twitter-branchid"]
	takes_args = ["branchid?"]


	def run(self, branchid=None):

		if branchid is None:
			branchid = raw_input(_("ID: ").encode("utf-8"))

		if branchid == "":
			return

		cs = branch.Branch.open_containing(u'.')[0].get_config_stack()
		cs.set("twitter_branch_id", branchid)
