/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.tools.findbugs.plugin;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;

public class SynchronizedThisDetector
extends OpcodeStackDetector {
    private static final int[] PATTERN = new int[]{42, 89, 255, 255, 194};
    private int mStep = 0;
    private BugReporter mBugReporter;

    public SynchronizedThisDetector(BugReporter bugReporter) {
        this.mBugReporter = bugReporter;
    }

    public void visit(Code code) {
        this.mStep = 0;
        super.visit(code);
    }

    public void sawOpcode(int n) {
        if (PATTERN[this.mStep] == n) {
            ++this.mStep;
            if (this.mStep == PATTERN.length) {
                this.mBugReporter.reportBug(new BugInstance((Detector)this, "CHROMIUM_SYNCHRONIZED_THIS", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                this.mStep = 0;
                return;
            }
        } else if (this.mStep == 2) {
            switch (n) {
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    this.mStep += 2;
                    break;
                }
                case 58: {
                    ++this.mStep;
                    break;
                }
                default: {
                    this.mStep = 0;
                    break;
                }
            }
        } else {
            this.mStep = this.mStep == 3 ? ++this.mStep : 0;
        }
    }
}

