/****************************************************************************
 *    app/options.h - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009-2010  Torsten Grote								*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#ifndef COALA_OPTIONS_H_INCLUDED
#define COALA_OPTIONS_H_INCLUDED

#include <string>
#include "program_opts/program_options.h"

const char* const VERSION = "1.0.1";

namespace Coala {

class Options {
public:
	Options();
	virtual ~Options();
	void setDefaults();
	bool parse(int argc, char** argv, std::ostream& os);
	const std::string& getError() const {
		return error_;
	}
	const std::string getWarning() const {
		return warning_;
	}
	
	std::string language;
	bool fake_class_neg;
	int debug;
	bool no_direct_enc;
	bool incremental;
	bool reverse;
	bool no_where_check;
	bool version;
	bool help;
	std::vector<std::string> input;	// list of files
private:
	void initOptions(ProgramOptions::OptionGroup& allOpts, ProgramOptions::OptionGroup& hidden);
	void checkCommonOptions(const ProgramOptions::OptionValues&);
	void printHelp(const ProgramOptions::OptionGroup& opts, std::ostream& os) const;
	void printVersion(const ProgramOptions::OptionGroup& opts, std::ostream& os) const;
	std::string error_;
	std::string warning_;
};
}
#endif
