/** \file
 *  This C source file was generated by $ANTLR version 3.4
 *
 *     -  From the grammar source file : ../../../../src/parser/cvc/Cvc.g
 *     -                            On : 2017-07-10 10:01:30
 *     -                for the parser : CvcParserParser
 *
 * Editing it, at least manually, is not wise.
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD license"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


/* =============================================================================
 * This is what the grammar programmer asked us to put at the top of every file.
 */

/**
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2016 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.
 **/

/* End of Header action.
 * =============================================================================
 */

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "CvcParser.h"


#include <sstream>
#include <string>
#include <vector>

#include "base/output.h"
#include "base/ptr_closer.h"
#include "expr/expr.h"
#include "expr/kind.h"
#include "expr/type.h"
#include "parser/antlr_input.h"
#include "parser/parser.h"


#define REPEAT_COMMAND(k, CommandCtor)                      \
  ({                                                        \
    unsigned __k = (k);                                     \
    (__k <= 1)                                              \
      ? (Command*) new CommandCtor                          \
      : ({                                                  \
          CommandSequence* __seq = new CommandSequence();   \
          while(__k-- > 0) {                                \
            __seq->addCommand(new CommandCtor);             \
          }                                                 \
          (Command*) __seq;                                 \
        });                                                 \
  })

using namespace CVC4;
using namespace CVC4::parser;

/* These need to be macros so they can refer to the PARSER macro, which will be defined
 * by ANTLR *after* this section. (If they were functions, PARSER would be undefined.) */
#undef PARSER_STATE
#define PARSER_STATE ((Parser*)PARSER->super)
#undef EXPR_MANAGER
#define EXPR_MANAGER PARSER_STATE->getExprManager()
#undef MK_EXPR
#define MK_EXPR EXPR_MANAGER->mkExpr
#undef MK_CONST
#define MK_CONST EXPR_MANAGER->mkConst
#define UNSUPPORTED PARSER_STATE->unimplementedFeature

#define ENSURE_BV_SIZE(k, f)                                   \
{                                                              \
  unsigned size = BitVectorType(f.getType()).getSize();        \
  if(k > size) {                                               \
    f = MK_EXPR(MK_CONST(BitVectorZeroExtend(k - size)), f);   \
  } else if (k < size) {                                       \
    f = MK_EXPR(MK_CONST(BitVectorExtract(k - 1, 0)), f);      \
  }                                                            \
}


/* ----------------------------------------- */





/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */

#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pCvcParser_##scope##_SCOPE
#define SCOPE_STACK(scope)  pCvcParser_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pCvcParser_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pCvcParser_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */

#undef	    PARSER
#undef	    RECOGNIZER
#undef	    HAVEPARSEDRULE
#undef		MEMOIZE
#undef	    INPUT
#undef	    STRSTREAM
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    MATCHT
#undef	    MATCHANYT
#undef	    FOLLOWSTACK
#undef	    FOLLOWPUSH
#undef	    FOLLOWPOP
#undef	    PRECOVER
#undef	    PREPORTERROR
#undef	    LA
#undef	    LT
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    PERRORRECOVERY
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    RECOVERFROMMISMATCHEDSET
#undef	    RECOVERFROMMISMATCHEDELEMENT
#undef		INDEX
#undef      ADAPTOR
#undef		SEEK
#undef	    RULEMEMO
#undef		DBG

#define	    PARSER				ctx->pParser
#define	    RECOGNIZER				PARSER->rec
#define	    PSRSTATE				RECOGNIZER->state
#define	    HAVEPARSEDRULE(r)			RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define	    MEMOIZE(ri,si)			RECOGNIZER->memoize(RECOGNIZER, ri, si)
#define	    INPUT				PARSER->tstream
#define	    STRSTREAM				INPUT
#define	    ISTREAM				INPUT->istream
#define	    INDEX()				ISTREAM->index(INPUT->istream)
#define	    HASEXCEPTION()			(PSRSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION				PSRSTATE->exception
#define	    MATCHT(t, fs)			RECOGNIZER->match(RECOGNIZER, t, fs)
#define	    MATCHANYT()				RECOGNIZER->matchAny(RECOGNIZER)
#define	    FOLLOWSTACK				PSRSTATE->following
#ifdef  SKIP_FOLLOW_SETS
#define	    FOLLOWPUSH(x)
#define	    FOLLOWPOP()
#else
#define	    FOLLOWPUSH(x)			FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define	    FOLLOWPOP()				FOLLOWSTACK->pop(FOLLOWSTACK)
#endif
#define	    PRECOVER()				RECOGNIZER->recover(RECOGNIZER)
#define	    PREPORTERROR()			RECOGNIZER->reportError(RECOGNIZER)
#define	    LA(n)				INPUT->istream->_LA(ISTREAM, n)
#define	    LT(n)				INPUT->_LT(INPUT, n)
#define	    CONSTRUCTEX()			RECOGNIZER->exConstruct(RECOGNIZER)
#define	    CONSUME()				ISTREAM->consume(ISTREAM)
#define	    MARK()				ISTREAM->mark(ISTREAM)
#define	    REWIND(m)				ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()			ISTREAM->rewindLast(ISTREAM)
#define	    SEEK(n)				ISTREAM->seek(ISTREAM, n)
#define	    PERRORRECOVERY			PSRSTATE->errorRecovery
#define	    FAILEDFLAG				PSRSTATE->failed
#define	    HASFAILED()				(FAILEDFLAG == ANTLR3_TRUE)
#define	    BACKTRACKING			PSRSTATE->backtracking
#define	    RECOVERFROMMISMATCHEDSET(s)		RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define	    RECOVERFROMMISMATCHEDELEMENT(e)	RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         ctx->adaptor
#define		RULEMEMO						PSRSTATE->ruleMemo
#define		DBG								RECOGNIZER->debugger


#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */


/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   CvcParserTokenNames[190+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>",
        (pANTLR3_UINT8) "<UP>",
        (pANTLR3_UINT8) "ABS_TOK",
        (pANTLR3_UINT8) "ALPHA",
        (pANTLR3_UINT8) "AND_TOK",
        (pANTLR3_UINT8) "ARITH_VAR_ORDER_TOK",
        (pANTLR3_UINT8) "ARRAY_TOK",
        (pANTLR3_UINT8) "ARROW_TOK",
        (pANTLR3_UINT8) "ASSERTIONS_TOK",
        (pANTLR3_UINT8) "ASSERT_TOK",
        (pANTLR3_UINT8) "ASSIGN_TOK",
        (pANTLR3_UINT8) "ASSUMPTIONS_TOK",
        (pANTLR3_UINT8) "BAR",
        (pANTLR3_UINT8) "BINARY_LITERAL",
        (pANTLR3_UINT8) "BITVECTOR_TOK",
        (pANTLR3_UINT8) "BOOLEAN_TOK",
        (pANTLR3_UINT8) "BVAND_TOK",
        (pANTLR3_UINT8) "BVASHR_TOK",
        (pANTLR3_UINT8) "BVCOMP_TOK",
        (pANTLR3_UINT8) "BVGE_TOK",
        (pANTLR3_UINT8) "BVGT_TOK",
        (pANTLR3_UINT8) "BVLE_TOK",
        (pANTLR3_UINT8) "BVLSHR_TOK",
        (pANTLR3_UINT8) "BVLT_TOK",
        (pANTLR3_UINT8) "BVMULT_TOK",
        (pANTLR3_UINT8) "BVNAND_TOK",
        (pANTLR3_UINT8) "BVNEG_TOK",
        (pANTLR3_UINT8) "BVNOR_TOK",
        (pANTLR3_UINT8) "BVPLUS_TOK",
        (pANTLR3_UINT8) "BVREPEAT_TOK",
        (pANTLR3_UINT8) "BVROTL_TOK",
        (pANTLR3_UINT8) "BVROTR_TOK",
        (pANTLR3_UINT8) "BVSDIV_TOK",
        (pANTLR3_UINT8) "BVSGE_TOK",
        (pANTLR3_UINT8) "BVSGT_TOK",
        (pANTLR3_UINT8) "BVSHL_TOK",
        (pANTLR3_UINT8) "BVSLE_TOK",
        (pANTLR3_UINT8) "BVSLT_TOK",
        (pANTLR3_UINT8) "BVSMOD_TOK",
        (pANTLR3_UINT8) "BVSREM_TOK",
        (pANTLR3_UINT8) "BVSUB_TOK",
        (pANTLR3_UINT8) "BVUDIV_TOK",
        (pANTLR3_UINT8) "BVUMINUS_TOK",
        (pANTLR3_UINT8) "BVUREM_TOK",
        (pANTLR3_UINT8) "BVXNOR_TOK",
        (pANTLR3_UINT8) "BVXOR_TOK",
        (pANTLR3_UINT8) "BVZEROEXTEND_TOK",
        (pANTLR3_UINT8) "CALL_TOK",
        (pANTLR3_UINT8) "CHECKSAT_TOK",
        (pANTLR3_UINT8) "CHECK_TYPE_TOK",
        (pANTLR3_UINT8) "COLON",
        (pANTLR3_UINT8) "COMMA",
        (pANTLR3_UINT8) "COMMENT",
        (pANTLR3_UINT8) "CONCAT_TOK",
        (pANTLR3_UINT8) "CONTEXT_TOK",
        (pANTLR3_UINT8) "CONTINUE_TOK",
        (pANTLR3_UINT8) "COUNTEREXAMPLE_TOK",
        (pANTLR3_UINT8) "COUNTERMODEL_TOK",
        (pANTLR3_UINT8) "DATATYPE_TOK",
        (pANTLR3_UINT8) "DBG_TOK",
        (pANTLR3_UINT8) "DECIMAL_LITERAL",
        (pANTLR3_UINT8) "DIGIT",
        (pANTLR3_UINT8) "DISEQUAL_TOK",
        (pANTLR3_UINT8) "DISTINCT_TOK",
        (pANTLR3_UINT8) "DIVISIBLE_TOK",
        (pANTLR3_UINT8) "DIV_TOK",
        (pANTLR3_UINT8) "DOT",
        (pANTLR3_UINT8) "DOTDOT",
        (pANTLR3_UINT8) "DUMP_ASSUMPTIONS_TOK",
        (pANTLR3_UINT8) "DUMP_CLOSURE_PROOF_TOK",
        (pANTLR3_UINT8) "DUMP_CLOSURE_TOK",
        (pANTLR3_UINT8) "DUMP_PROOF_TOK",
        (pANTLR3_UINT8) "DUMP_SIG_TOK",
        (pANTLR3_UINT8) "DUMP_TCC_ASSUMPTIONS_TOK",
        (pANTLR3_UINT8) "DUMP_TCC_PROOF_TOK",
        (pANTLR3_UINT8) "DUMP_TCC_TOK",
        (pANTLR3_UINT8) "DUMP_UNSAT_CORE_TOK",
        (pANTLR3_UINT8) "ECHO_TOK",
        (pANTLR3_UINT8) "ELSEIF_TOK",
        (pANTLR3_UINT8) "ELSE_TOK",
        (pANTLR3_UINT8) "ENDIF_TOK",
        (pANTLR3_UINT8) "END_TOK",
        (pANTLR3_UINT8) "EQUAL_TOK",
        (pANTLR3_UINT8) "ESCAPE",
        (pANTLR3_UINT8) "EXISTS_TOK",
        (pANTLR3_UINT8) "EXIT_TOK",
        (pANTLR3_UINT8) "EXP_TOK",
        (pANTLR3_UINT8) "FALSE_TOK",
        (pANTLR3_UINT8) "FLOOR_TOK",
        (pANTLR3_UINT8) "FMF_CARD_TOK",
        (pANTLR3_UINT8) "FORALL_TOK",
        (pANTLR3_UINT8) "FORGET_TOK",
        (pANTLR3_UINT8) "GEQ_TOK",
        (pANTLR3_UINT8) "GET_CHILD_TOK",
        (pANTLR3_UINT8) "GET_OP_TOK",
        (pANTLR3_UINT8) "GET_TYPE_TOK",
        (pANTLR3_UINT8) "GET_VALUE_TOK",
        (pANTLR3_UINT8) "GT_TOK",
        (pANTLR3_UINT8) "HASHPAREN",
        (pANTLR3_UINT8) "HASHSQ",
        (pANTLR3_UINT8) "HELP_TOK",
        (pANTLR3_UINT8) "HEX_DIGIT",
        (pANTLR3_UINT8) "HEX_LITERAL",
        (pANTLR3_UINT8) "IDENTIFIER",
        (pANTLR3_UINT8) "IDEN_TOK",
        (pANTLR3_UINT8) "IFF_TOK",
        (pANTLR3_UINT8) "IF_TOK",
        (pANTLR3_UINT8) "IMPLIES_TOK",
        (pANTLR3_UINT8) "INCLUDE_TOK",
        (pANTLR3_UINT8) "INTDIV_TOK",
        (pANTLR3_UINT8) "INTEGER_LITERAL",
        (pANTLR3_UINT8) "INT_TOK",
        (pANTLR3_UINT8) "IN_TOK",
        (pANTLR3_UINT8) "IS_INTEGER_TOK",
        (pANTLR3_UINT8) "JOIN_IMAGE_TOK",
        (pANTLR3_UINT8) "JOIN_TOK",
        (pANTLR3_UINT8) "LAMBDA",
        (pANTLR3_UINT8) "LBRACE",
        (pANTLR3_UINT8) "LBRACKET",
        (pANTLR3_UINT8) "LEFTSHIFT_TOK",
        (pANTLR3_UINT8) "LEQ_TOK",
        (pANTLR3_UINT8) "LET_TOK",
        (pANTLR3_UINT8) "LPAREN",
        (pANTLR3_UINT8) "LT_TOK",
        (pANTLR3_UINT8) "MEMBER_TOK",
        (pANTLR3_UINT8) "MINUS_TOK",
        (pANTLR3_UINT8) "MOD_TOK",
        (pANTLR3_UINT8) "NOT_TOK",
        (pANTLR3_UINT8) "NUMBER_OR_RANGEOP",
        (pANTLR3_UINT8) "OF_TOK",
        (pANTLR3_UINT8) "OPTION_TOK",
        (pANTLR3_UINT8) "OR_TOK",
        (pANTLR3_UINT8) "PARENHASH",
        (pANTLR3_UINT8) "PATTERN_TOK",
        (pANTLR3_UINT8) "PLUS_TOK",
        (pANTLR3_UINT8) "POPTO_SCOPE_TOK",
        (pANTLR3_UINT8) "POPTO_TOK",
        (pANTLR3_UINT8) "POP_SCOPE_TOK",
        (pANTLR3_UINT8) "POP_TOK",
        (pANTLR3_UINT8) "PRINT_TOK",
        (pANTLR3_UINT8) "PRINT_TYPE_TOK",
        (pANTLR3_UINT8) "PRODUCT_TOK",
        (pANTLR3_UINT8) "PUSH_SCOPE_TOK",
        (pANTLR3_UINT8) "PUSH_TOK",
        (pANTLR3_UINT8) "QUERY_TOK",
        (pANTLR3_UINT8) "RBRACE",
        (pANTLR3_UINT8) "RBRACKET",
        (pANTLR3_UINT8) "REAL_TOK",
        (pANTLR3_UINT8) "RESET_TOK",
        (pANTLR3_UINT8) "RESTART_TOK",
        (pANTLR3_UINT8) "RIGHTSHIFT_TOK",
        (pANTLR3_UINT8) "RPAREN",
        (pANTLR3_UINT8) "SEMICOLON",
        (pANTLR3_UINT8) "SETS_CARD_TOK",
        (pANTLR3_UINT8) "SET_TOK",
        (pANTLR3_UINT8) "SQHASH",
        (pANTLR3_UINT8) "STAR_TOK",
        (pANTLR3_UINT8) "STRING_CHARAT_TOK",
        (pANTLR3_UINT8) "STRING_CONCAT_TOK",
        (pANTLR3_UINT8) "STRING_CONTAINS_TOK",
        (pANTLR3_UINT8) "STRING_INDEXOF_TOK",
        (pANTLR3_UINT8) "STRING_ITOS_TOK",
        (pANTLR3_UINT8) "STRING_LENGTH_TOK",
        (pANTLR3_UINT8) "STRING_LITERAL",
        (pANTLR3_UINT8) "STRING_PREFIXOF_TOK",
        (pANTLR3_UINT8) "STRING_REPLACE_TOK",
        (pANTLR3_UINT8) "STRING_STOI_TOK",
        (pANTLR3_UINT8) "STRING_STOU16_TOK",
        (pANTLR3_UINT8) "STRING_STOU32_TOK",
        (pANTLR3_UINT8) "STRING_SUBSTR_TOK",
        (pANTLR3_UINT8) "STRING_SUFFIXOF_TOK",
        (pANTLR3_UINT8) "STRING_TOK",
        (pANTLR3_UINT8) "STRING_U16TOS_TOK",
        (pANTLR3_UINT8) "STRING_U32TOS_TOK",
        (pANTLR3_UINT8) "SUBSTITUTE_TOK",
        (pANTLR3_UINT8) "SUBTYPE_TOK",
        (pANTLR3_UINT8) "SX_TOK",
        (pANTLR3_UINT8) "THEN_TOK",
        (pANTLR3_UINT8) "TRACE_TOK",
        (pANTLR3_UINT8) "TRANSCLOSURE_TOK",
        (pANTLR3_UINT8) "TRANSFORM_TOK",
        (pANTLR3_UINT8) "TRANSPOSE_TOK",
        (pANTLR3_UINT8) "TRUE_TOK",
        (pANTLR3_UINT8) "TUPLE_TOK",
        (pANTLR3_UINT8) "TYPE_TOK",
        (pANTLR3_UINT8) "UNDERSCORE",
        (pANTLR3_UINT8) "UNIVSET_TOK",
        (pANTLR3_UINT8) "UNTRACE_TOK",
        (pANTLR3_UINT8) "WHERE_TOK",
        (pANTLR3_UINT8) "WHITESPACE",
        (pANTLR3_UINT8) "WITH_TOK",
        (pANTLR3_UINT8) "XOR_TOK"
       };



// Forward declare the locally static matching functions we have generated.
//
static 
 CVC4::Expr
	parseExpr    (pCvcParser ctx);
static 
 CVC4::Command*
	parseCommand    (pCvcParser ctx);
static 
 void
	command    (pCvcParser ctx, CVC4::PtrCloser<CVC4::Command>* cmd);
static 
 void
	typeOrVarLetDecl    (pCvcParser ctx, CVC4::parser::DeclarationCheck check);
static 
 void
	mainCommand    (pCvcParser ctx, CVC4::PtrCloser<CVC4::Command>* cmd);
static 
 void
	simpleSymbolicExpr    (pCvcParser ctx, CVC4::SExpr& sexpr);
static 
 void
	symbolicExpr    (pCvcParser ctx, CVC4::SExpr& sexpr);
static 
 void
	toplevelDeclaration    (pCvcParser ctx, CVC4::PtrCloser<CVC4::Command>* cmd);
static 
 void
	boundVarDecl    (pCvcParser ctx, std::vector<std::string>& ids, CVC4::Type& t);
static 
 void
	boundVarDecls    (pCvcParser ctx);
static 
 void
	boundVarDeclsReturn    (pCvcParser ctx, std::vector<CVC4::Expr>& terms, std::vector<CVC4::Type>& types);
static 
 void
	boundVarDeclReturn    (pCvcParser ctx, std::vector<CVC4::Expr>& terms, std::vector<CVC4::Type>& types);
static 
 void
	declareTypes    (pCvcParser ctx, CVC4::PtrCloser<CVC4::Command>* cmd, const std::vector<std::string>& idList);
static 
 void
	declareVariables    (pCvcParser ctx, CVC4::PtrCloser<CVC4::Command>* cmd, CVC4::Type& t, const std::vector<std::string>& idList, bool topLevel);
static 
 void
	identifierList    (pCvcParser ctx, std::vector<std::string>& idList, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	identifier    (pCvcParser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	type    (pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check);
static 
 void
	restrictedType    (pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check);
static 
 void
	restrictedTypePossiblyFunctionLHS    (pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check, bool& lhs);
static 
 void
	parameterization    (pCvcParser ctx, CVC4::parser::DeclarationCheck check, std::vector<CVC4::Type>& params);
static 
 CVC4::parser::cvc::mySubrangeBound
	bound    (pCvcParser ctx);
static 
 void
	typeLetDecl    (pCvcParser ctx, CVC4::parser::DeclarationCheck check);
static 
 void
	formula    (pCvcParser ctx, CVC4::Expr& f);
static 
 size_t
	morecomparisons    (pCvcParser ctx, std::vector<CVC4::Expr>& expressions, std::vector<unsigned>& operators);
static 
 size_t
	nots    (pCvcParser ctx);
static 
 void
	prefixFormula    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	instantiationPatterns    (pCvcParser ctx, CVC4::Expr& expr);
static 
 void
	letDecl    (pCvcParser ctx);
static 
 void
	booleanBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	comparison    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	comparisonBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	arithmeticBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	term    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	arrayStore    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	tupleStore    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	recordStore    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	uminusTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	bvBinaryOpTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	bvBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	bvNegTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	relationTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	postfixTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	bvTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	stringTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	setsTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	simpleTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	typeAscription    (pCvcParser ctx, const CVC4::Expr& f, CVC4::Type& t);
static 
 void
	recordEntry    (pCvcParser ctx, std::string& name, CVC4::Expr& ex);
static 
 void
	iteTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	iteElseTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	datatypeDef    (pCvcParser ctx, std::vector<CVC4::Datatype>& datatypes);
static 
 void
	constructorDef    (pCvcParser ctx, CVC4::Datatype& type);
static 
 void
	selector    (pCvcParser ctx, CVC4::PtrCloser<CVC4::DatatypeConstructor>* ctor);
static 
 unsigned
	numeral    (pCvcParser ctx);
static 
 CVC4::Rational
	integer    (pCvcParser ctx);
static 
 void
	str    (pCvcParser ctx, std::string& s);
static 
 ANTLR3_BOOLEAN
	synpred1_Cvc    (pCvcParser ctx);
static void	CvcParserFree(pCvcParser ctx);
static void     CvcParserReset (pCvcParser ctx);

/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed.
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static	void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "../../../../src/parser/cvc/Cvc.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}
/** \brief Create a new CvcParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pCvcParser
CvcParserNew   (pANTLR3_COMMON_TOKEN_STREAM instream)
{
	// See if we can create a new parser with the standard constructor
	//
	return CvcParserNewSSD(instream, NULL);
}

/** \brief Create a new CvcParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pCvcParser
CvcParserNewSSD   (pANTLR3_COMMON_TOKEN_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pCvcParser ctx;	    /* Context structure we will build and return   */

    ctx	= (pCvcParser) ANTLR3_CALLOC(1, sizeof(CvcParser));

    if	(ctx == NULL)
    {
		// Failed to allocate memory for parser context
		//
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function.
     *
     * We don't use the macros defined in CvcParser.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base parser/recognizer, using the supplied token stream
     */
    ctx->pParser	    = antlr3ParserNewStream(ANTLR3_SIZE_HINT, instream->tstream, state);
    /* Install the implementation of our CvcParser interface
     */
    ctx->parseExpr	= parseExpr;
    ctx->parseCommand	= parseCommand;
    ctx->command	= command;
    ctx->typeOrVarLetDecl	= typeOrVarLetDecl;
    ctx->mainCommand	= mainCommand;
    ctx->simpleSymbolicExpr	= simpleSymbolicExpr;
    ctx->symbolicExpr	= symbolicExpr;
    ctx->toplevelDeclaration	= toplevelDeclaration;
    ctx->boundVarDecl	= boundVarDecl;
    ctx->boundVarDecls	= boundVarDecls;
    ctx->boundVarDeclsReturn	= boundVarDeclsReturn;
    ctx->boundVarDeclReturn	= boundVarDeclReturn;
    ctx->declareTypes	= declareTypes;
    ctx->declareVariables	= declareVariables;
    ctx->identifierList	= identifierList;
    ctx->identifier	= identifier;
    ctx->type	= type;
    ctx->restrictedType	= restrictedType;
    ctx->restrictedTypePossiblyFunctionLHS	= restrictedTypePossiblyFunctionLHS;
    ctx->parameterization	= parameterization;
    ctx->bound	= bound;
    ctx->typeLetDecl	= typeLetDecl;
    ctx->formula	= formula;
    ctx->morecomparisons	= morecomparisons;
    ctx->nots	= nots;
    ctx->prefixFormula	= prefixFormula;
    ctx->instantiationPatterns	= instantiationPatterns;
    ctx->letDecl	= letDecl;
    ctx->booleanBinop	= booleanBinop;
    ctx->comparison	= comparison;
    ctx->comparisonBinop	= comparisonBinop;
    ctx->arithmeticBinop	= arithmeticBinop;
    ctx->term	= term;
    ctx->arrayStore	= arrayStore;
    ctx->tupleStore	= tupleStore;
    ctx->recordStore	= recordStore;
    ctx->uminusTerm	= uminusTerm;
    ctx->bvBinaryOpTerm	= bvBinaryOpTerm;
    ctx->bvBinop	= bvBinop;
    ctx->bvNegTerm	= bvNegTerm;
    ctx->relationTerm	= relationTerm;
    ctx->postfixTerm	= postfixTerm;
    ctx->bvTerm	= bvTerm;
    ctx->stringTerm	= stringTerm;
    ctx->setsTerm	= setsTerm;
    ctx->simpleTerm	= simpleTerm;
    ctx->typeAscription	= typeAscription;
    ctx->recordEntry	= recordEntry;
    ctx->iteTerm	= iteTerm;
    ctx->iteElseTerm	= iteElseTerm;
    ctx->datatypeDef	= datatypeDef;
    ctx->constructorDef	= constructorDef;
    ctx->selector	= selector;
    ctx->numeral	= numeral;
    ctx->integer	= integer;
    ctx->str	= str;
    ctx->synpred1_Cvc	= synpred1_Cvc;
    ctx->free			= CvcParserFree;
    ctx->reset			= CvcParserReset;
    ctx->getGrammarFileName	= getGrammarFileName;

    /* Install the scope pushing methods.
     */

    /* Install the token table
     */
    PSRSTATE->tokenNames   = CvcParserTokenNames;


    /* Return the newly built parser to the caller
     */
    return  ctx;
}

static void
CvcParserReset (pCvcParser ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** Free the parser resources
 */
 static void
 CvcParserFree(pCvcParser ctx)
 {
    /* Free any scope memory
     */

	// Free this parser
	//
    ctx->pParser->free(ctx->pParser);


    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }

/** Return token names used by this 
parser

 *
 * The returned pointer is used as an index into the token names table (using the token
 * number as the index).
 *
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames()
{
        return CvcParserTokenNames;
}



    // Idea and code guidance from Sam Harwell,
    // http://www.antlr.org/wiki/display/ANTLR3/Operator+precedence+parser

    bool isRightToLeft(int type) {
      // return true here for any operators that are right-to-left associative
      switch(type) {
      case IMPLIES_TOK: return true;
      default: return false;
      }
    }/* isRightToLeft() */

    int getOperatorPrecedence(int type) {
      switch(type) {
      case BITVECTOR_TOK: return 1;
      //case DOT:
      case LPAREN:
      case LBRACE: return 2;
      case LBRACKET: return 3;
      case ARROW_TOK: return 4;
      case IS_INTEGER_TOK: return 5;
      case BVSLT_TOK:
      case BVSLE_TOK:
      case BVSGT_TOK:
      case BVSGE_TOK: return 6;
      case BVLT_TOK:
      case BVLE_TOK:
      case BVGT_TOK:
      case BVGE_TOK: return 7;
      case LEFTSHIFT_TOK:
      case RIGHTSHIFT_TOK: return 8;
      case SX_TOK:
      case BVZEROEXTEND_TOK:
      case BVREPEAT_TOK:
      case BVROTL_TOK:
      case BVROTR_TOK: return 9;
      case BVUDIV_TOK:
      case BVSDIV_TOK:
      case BVUREM_TOK:
      case BVSREM_TOK:
      case BVSMOD_TOK:
      case BVSHL_TOK:
      case BVASHR_TOK:
      case BVLSHR_TOK: return 10;
      case BVUMINUS_TOK:
      case BVPLUS_TOK:
      case BVSUB_TOK: return 11;
      case BVNEG_TOK: return 12;
      case BVXNOR_TOK: return 13;
      case BVNOR_TOK:
      case BVCOMP_TOK: return 14;
      case BVNAND_TOK: return 15;
      case BVXOR_TOK: return 16;
      case BVAND_TOK: return 17;
      case BAR: return 18;
      case CONCAT_TOK: return 19;
    //case UMINUS_TOK: return 20;
      case WITH_TOK: return 21;
      case EXP_TOK: return 22;
      case STAR_TOK:
      case INTDIV_TOK:
      case DIV_TOK:
      case TUPLE_TOK:
      case MOD_TOK: return 23;
      case PLUS_TOK:
      case MINUS_TOK:
      case JOIN_TOK:
      case TRANSPOSE_TOK:
      case PRODUCT_TOK:
      case IDEN_TOK:
      case JOIN_IMAGE_TOK:  
      case TRANSCLOSURE_TOK: return 24;
      case LEQ_TOK:
      case LT_TOK:
      case GEQ_TOK:
      case GT_TOK:
      case MEMBER_TOK: 
      case SETS_CARD_TOK:
      case FMF_CARD_TOK: return 25;
      case EQUAL_TOK:
      case DISEQUAL_TOK: return 26;
      case NOT_TOK: return 27;
      case AND_TOK: return 28;
      case OR_TOK:
      case XOR_TOK: return 29;
      case IMPLIES_TOK: return 30;// right-to-left
      case IFF_TOK: return 31;
      case FORALL_TOK:
      case EXISTS_TOK: return 32;
      case ASSIGN_TOK:
      case IN_TOK: return 33;

      default:
        std::stringstream ss;
        ss << "internal error: no entry in precedence table for operator " << CvcParserTokenNames[type];
        throw ParserException(ss.str());
      }
    }/* getOperatorPrecedence() */

    Kind getOperatorKind(int type, bool& negate) {
      negate = false;

      switch(type) {
        // booleanBinop
      case IFF_TOK: return kind::EQUAL;
      case IMPLIES_TOK: return kind::IMPLIES;
      case OR_TOK: return kind::OR;
      case XOR_TOK: return kind::XOR;
      case AND_TOK: return kind::AND;
      
      case PRODUCT_TOK: return kind::PRODUCT;
      case JOIN_TOK: return kind::JOIN;
      case JOIN_IMAGE_TOK: return kind::JOIN_IMAGE;  

        // comparisonBinop
      case EQUAL_TOK: return kind::EQUAL;
      case DISEQUAL_TOK: negate = true; return kind::EQUAL;
      case GT_TOK: return kind::GT;
      case GEQ_TOK: return kind::GEQ;
      case LT_TOK: return kind::LT;
      case LEQ_TOK: return kind::LEQ;
      case MEMBER_TOK: return kind::MEMBER;
      case SETS_CARD_TOK: return kind::CARD;
      case FMF_CARD_TOK: return kind::CARDINALITY_CONSTRAINT;

        // arithmeticBinop
      case PLUS_TOK: return kind::PLUS;
      case MINUS_TOK: return kind::MINUS;
      case STAR_TOK: return kind::MULT;
      case INTDIV_TOK: return kind::INTS_DIVISION;
      case MOD_TOK: return kind::INTS_MODULUS;
      case DIV_TOK: return kind::DIVISION;
      case EXP_TOK: return kind::POW;

        // bvBinop
      case CONCAT_TOK: return kind::BITVECTOR_CONCAT;
      case BAR: return kind::BITVECTOR_OR;
      case BVAND_TOK: return kind::BITVECTOR_AND;
      
      }

      std::stringstream ss;
      ss << "internal error: no entry in operator-kind table for operator " << CvcParserTokenNames[type];
      throw ParserException(ss.str());

    }/* getOperatorKind() */

    unsigned findPivot(const std::vector<unsigned>& operators,
                       unsigned startIndex, unsigned stopIndex) {
      unsigned pivot = startIndex;
      unsigned pivotRank = getOperatorPrecedence(operators[pivot]);
      /*Debug("prec") << "initial pivot at " << pivot
                    << "(" << CvcParserTokenNames[operators[pivot]] << ") "
                    << "level " << pivotRank << std::endl;*/
      for(unsigned i = startIndex + 1; i <= stopIndex; ++i) {
        unsigned current = getOperatorPrecedence(operators[i]);
        bool rtl = isRightToLeft(operators[i]);
        if(current > pivotRank || (current == pivotRank && !rtl)) {
          /*Debug("prec") << "new pivot at " << i
                        << "(" << CvcParserTokenNames[operators[i]] << ") "
                        << "level " << current << " rtl == " << rtl << std::endl;*/
          pivot = i;
          pivotRank = current;
        }
      }
      return pivot;
    }/* findPivot() */

    Expr createPrecedenceTree(Parser* parser, ExprManager* em,
                              const std::vector<CVC4::Expr>& expressions,
                              const std::vector<unsigned>& operators,
                              unsigned startIndex, unsigned stopIndex) {
      assert(expressions.size() == operators.size() + 1);
      assert(startIndex < expressions.size());
      assert(stopIndex < expressions.size());
      assert(startIndex <= stopIndex);

      if(stopIndex == startIndex) {
        return expressions[startIndex];
      }

      unsigned pivot = findPivot(operators, startIndex, stopIndex - 1);
      //Debug("prec") << "pivot[" << startIndex << "," << stopIndex - 1 << "] at " << pivot << std::endl;
      bool negate;
      Kind k = getOperatorKind(operators[pivot], negate);
      Expr lhs = createPrecedenceTree(parser, em, expressions, operators, startIndex, pivot);
      Expr rhs = createPrecedenceTree(parser, em, expressions, operators, pivot + 1, stopIndex);

      switch(k) {
      case kind::LEQ          : if(lhs.getType().isSet()) { k = kind::SUBSET; } break;
      case kind::MINUS        : if(lhs.getType().isSet()) { k = kind::SETMINUS; } break;
      case kind::BITVECTOR_AND: if(lhs.getType().isSet()) { k = kind::INTERSECTION; } break;
      case kind::BITVECTOR_OR : if(lhs.getType().isSet()) { k = kind::UNION; } break;
      default: break;
      }
      Expr e = em->mkExpr(k, lhs, rhs);
      return negate ? em->mkExpr(kind::NOT, e) : e;
    }/* createPrecedenceTree() recursive variant */

    Expr createPrecedenceTree(Parser* parser, ExprManager* em,
                              const std::vector<CVC4::Expr>& expressions,
                              const std::vector<unsigned>& operators) {
      if(Debug.isOn("prec") && operators.size() > 1) {
        for(unsigned i = 0; i < expressions.size(); ++i) {
          Debug("prec") << expressions[i];
          if(operators.size() > i) {
            Debug("prec") << ' ' << CvcParserTokenNames[operators[i]] << ' ';
          }
        }
        Debug("prec") << std::endl;
      }

      Expr e = createPrecedenceTree(parser, em, expressions, operators, 0, expressions.size() - 1);
      if(Debug.isOn("prec") && operators.size() > 1) {
        language::SetLanguage::Scope ls(Debug("prec"), language::output::LANG_AST);
        Debug("prec") << "=> " << e << std::endl;
      }
      return e;
    }/* createPrecedenceTree() base variant */

    /** Add n NOTs to the front of e and return the result. */
    Expr addNots(ExprManager* em, size_t n, Expr e) {
      while(n-- > 0) {
        e = em->mkExpr(kind::NOT, e);
      }
      return e;
    }/* addNots() */



/* Declare the bitsets
 */
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_parseExpr1820  */
static	ANTLR3_BITWORD FOLLOW_formula_in_parseExpr1820_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_parseExpr1820	= { FOLLOW_formula_in_parseExpr1820_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseExpr1827  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseExpr1827_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseExpr1827	= { FOLLOW_EOF_in_parseExpr1827_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_parseCommand1858  */
static	ANTLR3_BITWORD FOLLOW_command_in_parseCommand1858_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_parseCommand1858	= { FOLLOW_command_in_parseCommand1858_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_parseCommand1865  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_parseCommand1865_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_parseCommand1865	= { FOLLOW_LPAREN_in_parseCommand1865_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_parseCommand1867  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_parseCommand1867_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_parseCommand1867	= { FOLLOW_IDENTIFIER_in_parseCommand1867_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseCommand1879  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseCommand1879_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseCommand1879	= { FOLLOW_EOF_in_parseCommand1879_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_mainCommand_in_command1898  */
static	ANTLR3_BITWORD FOLLOW_mainCommand_in_command1898_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_mainCommand_in_command1898	= { FOLLOW_mainCommand_in_command1898_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SEMICOLON_in_command1901  */
static	ANTLR3_BITWORD FOLLOW_SEMICOLON_in_command1901_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SEMICOLON_in_command1901	= { FOLLOW_SEMICOLON_in_command1901_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SEMICOLON_in_command1909  */
static	ANTLR3_BITWORD FOLLOW_SEMICOLON_in_command1909_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SEMICOLON_in_command1909	= { FOLLOW_SEMICOLON_in_command1909_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_command1917  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_command1917_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_command1917	= { FOLLOW_LET_TOK_in_command1917_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeOrVarLetDecl_in_command1927  */
static	ANTLR3_BITWORD FOLLOW_typeOrVarLetDecl_in_command1927_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeOrVarLetDecl_in_command1927	= { FOLLOW_typeOrVarLetDecl_in_command1927_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_command1942  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_command1942_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_command1942	= { FOLLOW_COMMA_in_command1942_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeOrVarLetDecl_in_command1944  */
static	ANTLR3_BITWORD FOLLOW_typeOrVarLetDecl_in_command1944_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeOrVarLetDecl_in_command1944	= { FOLLOW_typeOrVarLetDecl_in_command1944_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IN_TOK_in_command1956  */
static	ANTLR3_BITWORD FOLLOW_IN_TOK_in_command1956_bits[]	= { ANTLR3_UINT64_LIT(0x3F0E000000002C80), ANTLR3_UINT64_LIT(0x08004247A080FFC0), ANTLR3_UINT64_LIT(0x6051000004C77E10) };
static  ANTLR3_BITSET_LIST FOLLOW_IN_TOK_in_command1956	= { FOLLOW_IN_TOK_in_command1956_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_command1958  */
static	ANTLR3_BITWORD FOLLOW_command_in_command1958_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_command1958	= { FOLLOW_command_in_command1958_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_command1985  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_command1985_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_command1985	= { FOLLOW_IDENTIFIER_in_command1985_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SEMICOLON_in_command1987  */
static	ANTLR3_BITWORD FOLLOW_SEMICOLON_in_command1987_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SEMICOLON_in_command1987	= { FOLLOW_SEMICOLON_in_command1987_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_typeOrVarLetDecl2018  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_typeOrVarLetDecl2018_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_typeOrVarLetDecl2018	= { FOLLOW_letDecl_in_typeOrVarLetDecl2018_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeLetDecl_in_typeOrVarLetDecl2022  */
static	ANTLR3_BITWORD FOLLOW_typeLetDecl_in_typeOrVarLetDecl2022_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_typeLetDecl_in_typeOrVarLetDecl2022	= { FOLLOW_typeLetDecl_in_typeOrVarLetDecl2022_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSERT_TOK_in_mainCommand2048  */
static	ANTLR3_BITWORD FOLLOW_ASSERT_TOK_in_mainCommand2048_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSERT_TOK_in_mainCommand2048	= { FOLLOW_ASSERT_TOK_in_mainCommand2048_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2050  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2050_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2050	= { FOLLOW_formula_in_mainCommand2050_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_QUERY_TOK_in_mainCommand2060  */
static	ANTLR3_BITWORD FOLLOW_QUERY_TOK_in_mainCommand2060_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_QUERY_TOK_in_mainCommand2060	= { FOLLOW_QUERY_TOK_in_mainCommand2060_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2062  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2062_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2062	= { FOLLOW_formula_in_mainCommand2062_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECKSAT_TOK_in_mainCommand2071  */
static	ANTLR3_BITWORD FOLLOW_CHECKSAT_TOK_in_mainCommand2071_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C112), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECKSAT_TOK_in_mainCommand2071	= { FOLLOW_CHECKSAT_TOK_in_mainCommand2071_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2073  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2073_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2073	= { FOLLOW_formula_in_mainCommand2073_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OPTION_TOK_in_mainCommand2093  */
static	ANTLR3_BITWORD FOLLOW_OPTION_TOK_in_mainCommand2093_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_OPTION_TOK_in_mainCommand2093	= { FOLLOW_OPTION_TOK_in_mainCommand2093_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2101  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2101_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008002), ANTLR3_UINT64_LIT(0x9001030002000000), ANTLR3_UINT64_LIT(0x0100002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2101	= { FOLLOW_str_in_mainCommand2101_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2106  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2106_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008002), ANTLR3_UINT64_LIT(0x9001030002000000), ANTLR3_UINT64_LIT(0x0100002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2106	= { FOLLOW_IDENTIFIER_in_mainCommand2106_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_mainCommand2118  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_mainCommand2118_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_mainCommand2118	= { FOLLOW_symbolicExpr_in_mainCommand2118_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRUE_TOK_in_mainCommand2135  */
static	ANTLR3_BITWORD FOLLOW_TRUE_TOK_in_mainCommand2135_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TRUE_TOK_in_mainCommand2135	= { FOLLOW_TRUE_TOK_in_mainCommand2135_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FALSE_TOK_in_mainCommand2145  */
static	ANTLR3_BITWORD FOLLOW_FALSE_TOK_in_mainCommand2145_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FALSE_TOK_in_mainCommand2145	= { FOLLOW_FALSE_TOK_in_mainCommand2145_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PUSH_TOK_in_mainCommand2174  */
static	ANTLR3_BITWORD FOLLOW_PUSH_TOK_in_mainCommand2174_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PUSH_TOK_in_mainCommand2174	= { FOLLOW_PUSH_TOK_in_mainCommand2174_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2180  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2180_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2180	= { FOLLOW_numeral_in_mainCommand2180_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POP_TOK_in_mainCommand2209  */
static	ANTLR3_BITWORD FOLLOW_POP_TOK_in_mainCommand2209_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POP_TOK_in_mainCommand2209	= { FOLLOW_POP_TOK_in_mainCommand2209_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2215  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2215_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2215	= { FOLLOW_numeral_in_mainCommand2215_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POPTO_TOK_in_mainCommand2243  */
static	ANTLR3_BITWORD FOLLOW_POPTO_TOK_in_mainCommand2243_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POPTO_TOK_in_mainCommand2243	= { FOLLOW_POPTO_TOK_in_mainCommand2243_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2247  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2247_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2247	= { FOLLOW_numeral_in_mainCommand2247_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2267  */
static	ANTLR3_BITWORD FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2267_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2267	= { FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2267_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2271  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2271_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2271	= { FOLLOW_numeral_in_mainCommand2271_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POP_SCOPE_TOK_in_mainCommand2284  */
static	ANTLR3_BITWORD FOLLOW_POP_SCOPE_TOK_in_mainCommand2284_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POP_SCOPE_TOK_in_mainCommand2284	= { FOLLOW_POP_SCOPE_TOK_in_mainCommand2284_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2288  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2288_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2288	= { FOLLOW_numeral_in_mainCommand2288_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2301  */
static	ANTLR3_BITWORD FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2301_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2301	= { FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2301_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2305  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2305_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2305	= { FOLLOW_numeral_in_mainCommand2305_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESET_TOK_in_mainCommand2319  */
static	ANTLR3_BITWORD FOLLOW_RESET_TOK_in_mainCommand2319_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RESET_TOK_in_mainCommand2319	= { FOLLOW_RESET_TOK_in_mainCommand2319_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESET_TOK_in_mainCommand2332  */
static	ANTLR3_BITWORD FOLLOW_RESET_TOK_in_mainCommand2332_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_RESET_TOK_in_mainCommand2332	= { FOLLOW_RESET_TOK_in_mainCommand2332_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSERTIONS_TOK_in_mainCommand2334  */
static	ANTLR3_BITWORD FOLLOW_ASSERTIONS_TOK_in_mainCommand2334_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSERTIONS_TOK_in_mainCommand2334	= { FOLLOW_ASSERTIONS_TOK_in_mainCommand2334_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATATYPE_TOK_in_mainCommand2362  */
static	ANTLR3_BITWORD FOLLOW_DATATYPE_TOK_in_mainCommand2362_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DATATYPE_TOK_in_mainCommand2362	= { FOLLOW_DATATYPE_TOK_in_mainCommand2362_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDef_in_mainCommand2374  */
static	ANTLR3_BITWORD FOLLOW_datatypeDef_in_mainCommand2374_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDef_in_mainCommand2374	= { FOLLOW_datatypeDef_in_mainCommand2374_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_mainCommand2383  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_mainCommand2383_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_mainCommand2383	= { FOLLOW_COMMA_in_mainCommand2383_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDef_in_mainCommand2385  */
static	ANTLR3_BITWORD FOLLOW_datatypeDef_in_mainCommand2385_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDef_in_mainCommand2385	= { FOLLOW_datatypeDef_in_mainCommand2385_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_END_TOK_in_mainCommand2395  */
static	ANTLR3_BITWORD FOLLOW_END_TOK_in_mainCommand2395_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_END_TOK_in_mainCommand2395	= { FOLLOW_END_TOK_in_mainCommand2395_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONTEXT_TOK_in_mainCommand2408  */
static	ANTLR3_BITWORD FOLLOW_CONTEXT_TOK_in_mainCommand2408_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_CONTEXT_TOK_in_mainCommand2408	= { FOLLOW_CONTEXT_TOK_in_mainCommand2408_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2418  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2418_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2418	= { FOLLOW_str_in_mainCommand2418_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2423  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2423_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2423	= { FOLLOW_IDENTIFIER_in_mainCommand2423_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORGET_TOK_in_mainCommand2456  */
static	ANTLR3_BITWORD FOLLOW_FORGET_TOK_in_mainCommand2456_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FORGET_TOK_in_mainCommand2456	= { FOLLOW_FORGET_TOK_in_mainCommand2456_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2458  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2458_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2458	= { FOLLOW_identifier_in_mainCommand2458_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_TYPE_TOK_in_mainCommand2472  */
static	ANTLR3_BITWORD FOLLOW_GET_TYPE_TOK_in_mainCommand2472_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_TYPE_TOK_in_mainCommand2472	= { FOLLOW_GET_TYPE_TOK_in_mainCommand2472_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2474  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2474_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2474	= { FOLLOW_formula_in_mainCommand2474_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECK_TYPE_TOK_in_mainCommand2488  */
static	ANTLR3_BITWORD FOLLOW_CHECK_TYPE_TOK_in_mainCommand2488_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECK_TYPE_TOK_in_mainCommand2488	= { FOLLOW_CHECK_TYPE_TOK_in_mainCommand2488_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2490  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2490_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2490	= { FOLLOW_formula_in_mainCommand2490_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_mainCommand2493  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_mainCommand2493_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_mainCommand2493	= { FOLLOW_COLON_in_mainCommand2493_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_mainCommand2495  */
static	ANTLR3_BITWORD FOLLOW_type_in_mainCommand2495_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_mainCommand2495	= { FOLLOW_type_in_mainCommand2495_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_CHILD_TOK_in_mainCommand2509  */
static	ANTLR3_BITWORD FOLLOW_GET_CHILD_TOK_in_mainCommand2509_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_CHILD_TOK_in_mainCommand2509	= { FOLLOW_GET_CHILD_TOK_in_mainCommand2509_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2511  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2511_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2511	= { FOLLOW_formula_in_mainCommand2511_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2516  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2516_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2516	= { FOLLOW_numeral_in_mainCommand2516_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_OP_TOK_in_mainCommand2529  */
static	ANTLR3_BITWORD FOLLOW_GET_OP_TOK_in_mainCommand2529_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_OP_TOK_in_mainCommand2529	= { FOLLOW_GET_OP_TOK_in_mainCommand2529_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2531  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2531_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2531	= { FOLLOW_formula_in_mainCommand2531_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_VALUE_TOK_in_mainCommand2545  */
static	ANTLR3_BITWORD FOLLOW_GET_VALUE_TOK_in_mainCommand2545_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_VALUE_TOK_in_mainCommand2545	= { FOLLOW_GET_VALUE_TOK_in_mainCommand2545_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2547  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2547_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2547	= { FOLLOW_formula_in_mainCommand2547_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SUBSTITUTE_TOK_in_mainCommand2561  */
static	ANTLR3_BITWORD FOLLOW_SUBSTITUTE_TOK_in_mainCommand2561_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SUBSTITUTE_TOK_in_mainCommand2561	= { FOLLOW_SUBSTITUTE_TOK_in_mainCommand2561_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2563  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2563_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2563	= { FOLLOW_identifier_in_mainCommand2563_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_mainCommand2566  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_mainCommand2566_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_mainCommand2566	= { FOLLOW_COLON_in_mainCommand2566_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_mainCommand2572  */
static	ANTLR3_BITWORD FOLLOW_type_in_mainCommand2572_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_mainCommand2572	= { FOLLOW_type_in_mainCommand2572_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_mainCommand2575  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_mainCommand2575_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_mainCommand2575	= { FOLLOW_EQUAL_TOK_in_mainCommand2575_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2577  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2577_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2577	= { FOLLOW_formula_in_mainCommand2577_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_mainCommand2580  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_mainCommand2580_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_mainCommand2580	= { FOLLOW_LBRACKET_in_mainCommand2580_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2586  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2586_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2586	= { FOLLOW_identifier_in_mainCommand2586_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_mainCommand2589  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_mainCommand2589_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_mainCommand2589	= { FOLLOW_ASSIGN_TOK_in_mainCommand2589_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2591  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2591_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2591	= { FOLLOW_formula_in_mainCommand2591_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_mainCommand2594  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_mainCommand2594_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_mainCommand2594	= { FOLLOW_RBRACKET_in_mainCommand2594_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DBG_TOK_in_mainCommand2613  */
static	ANTLR3_BITWORD FOLLOW_DBG_TOK_in_mainCommand2613_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DBG_TOK_in_mainCommand2613	= { FOLLOW_DBG_TOK_in_mainCommand2613_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2623  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2623_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2623	= { FOLLOW_str_in_mainCommand2623_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2628  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2628_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2628	= { FOLLOW_IDENTIFIER_in_mainCommand2628_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRACE_TOK_in_mainCommand2661  */
static	ANTLR3_BITWORD FOLLOW_TRACE_TOK_in_mainCommand2661_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_TRACE_TOK_in_mainCommand2661	= { FOLLOW_TRACE_TOK_in_mainCommand2661_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2671  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2671_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2671	= { FOLLOW_str_in_mainCommand2671_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2676  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2676_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2676	= { FOLLOW_IDENTIFIER_in_mainCommand2676_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNTRACE_TOK_in_mainCommand2708  */
static	ANTLR3_BITWORD FOLLOW_UNTRACE_TOK_in_mainCommand2708_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_UNTRACE_TOK_in_mainCommand2708	= { FOLLOW_UNTRACE_TOK_in_mainCommand2708_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2718  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2718_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2718	= { FOLLOW_str_in_mainCommand2718_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2723  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2723_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2723	= { FOLLOW_IDENTIFIER_in_mainCommand2723_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HELP_TOK_in_mainCommand2756  */
static	ANTLR3_BITWORD FOLLOW_HELP_TOK_in_mainCommand2756_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_HELP_TOK_in_mainCommand2756	= { FOLLOW_HELP_TOK_in_mainCommand2756_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2766  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2766_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2766	= { FOLLOW_str_in_mainCommand2766_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2771  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2771_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2771	= { FOLLOW_IDENTIFIER_in_mainCommand2771_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRANSFORM_TOK_in_mainCommand2812  */
static	ANTLR3_BITWORD FOLLOW_TRANSFORM_TOK_in_mainCommand2812_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_TRANSFORM_TOK_in_mainCommand2812	= { FOLLOW_TRANSFORM_TOK_in_mainCommand2812_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2814  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2814_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2814	= { FOLLOW_formula_in_mainCommand2814_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PRINT_TOK_in_mainCommand2828  */
static	ANTLR3_BITWORD FOLLOW_PRINT_TOK_in_mainCommand2828_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_PRINT_TOK_in_mainCommand2828	= { FOLLOW_PRINT_TOK_in_mainCommand2828_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2830  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2830_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2830	= { FOLLOW_formula_in_mainCommand2830_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PRINT_TYPE_TOK_in_mainCommand2843  */
static	ANTLR3_BITWORD FOLLOW_PRINT_TYPE_TOK_in_mainCommand2843_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_PRINT_TYPE_TOK_in_mainCommand2843	= { FOLLOW_PRINT_TYPE_TOK_in_mainCommand2843_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_mainCommand2845  */
static	ANTLR3_BITWORD FOLLOW_type_in_mainCommand2845_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_mainCommand2845	= { FOLLOW_type_in_mainCommand2845_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CALL_TOK_in_mainCommand2859  */
static	ANTLR3_BITWORD FOLLOW_CALL_TOK_in_mainCommand2859_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_CALL_TOK_in_mainCommand2859	= { FOLLOW_CALL_TOK_in_mainCommand2859_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2861  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2861_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2861	= { FOLLOW_identifier_in_mainCommand2861_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2864  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2864_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2864	= { FOLLOW_formula_in_mainCommand2864_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ECHO_TOK_in_mainCommand2878  */
static	ANTLR3_BITWORD FOLLOW_ECHO_TOK_in_mainCommand2878_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008002), ANTLR3_UINT64_LIT(0x8001030000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ECHO_TOK_in_mainCommand2878	= { FOLLOW_ECHO_TOK_in_mainCommand2878_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_mainCommand2886  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_mainCommand2886_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_mainCommand2886	= { FOLLOW_simpleSymbolicExpr_in_mainCommand2886_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXIT_TOK_in_mainCommand2916  */
static	ANTLR3_BITWORD FOLLOW_EXIT_TOK_in_mainCommand2916_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXIT_TOK_in_mainCommand2916	= { FOLLOW_EXIT_TOK_in_mainCommand2916_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INCLUDE_TOK_in_mainCommand2929  */
static	ANTLR3_BITWORD FOLLOW_INCLUDE_TOK_in_mainCommand2929_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INCLUDE_TOK_in_mainCommand2929	= { FOLLOW_INCLUDE_TOK_in_mainCommand2929_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2939  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2939_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2939	= { FOLLOW_str_in_mainCommand2939_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2944  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2944_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2944	= { FOLLOW_IDENTIFIER_in_mainCommand2944_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DUMP_PROOF_TOK_in_mainCommand2977  */
static	ANTLR3_BITWORD FOLLOW_DUMP_PROOF_TOK_in_mainCommand2977_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DUMP_PROOF_TOK_in_mainCommand2977	= { FOLLOW_DUMP_PROOF_TOK_in_mainCommand2977_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand2990  */
static	ANTLR3_BITWORD FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand2990_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand2990	= { FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand2990_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_mainCommand3003  */
static	ANTLR3_BITWORD FOLLOW_set_in_mainCommand3003_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_mainCommand3003	= { FOLLOW_set_in_mainCommand3003_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_mainCommand3074  */
static	ANTLR3_BITWORD FOLLOW_set_in_mainCommand3074_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_mainCommand3074	= { FOLLOW_set_in_mainCommand3074_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3099  */
static	ANTLR3_BITWORD FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3099_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3099	= { FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3099_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COUNTERMODEL_TOK_in_mainCommand3111  */
static	ANTLR3_BITWORD FOLLOW_COUNTERMODEL_TOK_in_mainCommand3111_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_COUNTERMODEL_TOK_in_mainCommand3111	= { FOLLOW_COUNTERMODEL_TOK_in_mainCommand3111_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3124  */
static	ANTLR3_BITWORD FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3124_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3124	= { FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3124_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_mainCommand3126  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_mainCommand3126_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_mainCommand3126	= { FOLLOW_LPAREN_in_mainCommand3126_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand3128  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand3128_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand3128	= { FOLLOW_formula_in_mainCommand3128_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_mainCommand3133  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_mainCommand3133_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_mainCommand3133	= { FOLLOW_COMMA_in_mainCommand3133_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand3135  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand3135_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand3135	= { FOLLOW_formula_in_mainCommand3135_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_mainCommand3141  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_mainCommand3141_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_mainCommand3141	= { FOLLOW_RPAREN_in_mainCommand3141_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONTINUE_TOK_in_mainCommand3154  */
static	ANTLR3_BITWORD FOLLOW_CONTINUE_TOK_in_mainCommand3154_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CONTINUE_TOK_in_mainCommand3154	= { FOLLOW_CONTINUE_TOK_in_mainCommand3154_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESTART_TOK_in_mainCommand3166  */
static	ANTLR3_BITWORD FOLLOW_RESTART_TOK_in_mainCommand3166_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_RESTART_TOK_in_mainCommand3166	= { FOLLOW_RESTART_TOK_in_mainCommand3166_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand3168  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand3168_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand3168	= { FOLLOW_formula_in_mainCommand3168_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_toplevelDeclaration_in_mainCommand3177  */
static	ANTLR3_BITWORD FOLLOW_toplevelDeclaration_in_mainCommand3177_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_toplevelDeclaration_in_mainCommand3177	= { FOLLOW_toplevelDeclaration_in_mainCommand3177_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3197  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3197_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3197	= { FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3197_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3209  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3209_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3209	= { FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3209_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3211  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3211_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3211	= { FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3211_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3223  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3223_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3223	= { FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3223_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3235  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3235_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3235	= { FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3235_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3247  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3247_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3247	= { FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3247_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_simpleSymbolicExpr3259  */
static	ANTLR3_BITWORD FOLLOW_str_in_simpleSymbolicExpr3259_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_simpleSymbolicExpr3259	= { FOLLOW_str_in_simpleSymbolicExpr3259_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3272  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3272_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3272	= { FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3272_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_symbolicExpr3297  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_symbolicExpr3297_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_symbolicExpr3297	= { FOLLOW_simpleSymbolicExpr_in_symbolicExpr3297_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_symbolicExpr3304  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_symbolicExpr3304_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008000), ANTLR3_UINT64_LIT(0x9001030000000000), ANTLR3_UINT64_LIT(0x0000002002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_symbolicExpr3304	= { FOLLOW_LPAREN_in_symbolicExpr3304_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_symbolicExpr3307  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_symbolicExpr3307_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008000), ANTLR3_UINT64_LIT(0x9001030000000000), ANTLR3_UINT64_LIT(0x0000002002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_symbolicExpr3307	= { FOLLOW_symbolicExpr_in_symbolicExpr3307_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_symbolicExpr3315  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_symbolicExpr3315_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_symbolicExpr3315	= { FOLLOW_RPAREN_in_symbolicExpr3315_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifierList_in_toplevelDeclaration3342  */
static	ANTLR3_BITWORD FOLLOW_identifierList_in_toplevelDeclaration3342_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifierList_in_toplevelDeclaration3342	= { FOLLOW_identifierList_in_toplevelDeclaration3342_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_toplevelDeclaration3345  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_toplevelDeclaration3345_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0402200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_toplevelDeclaration3345	= { FOLLOW_COLON_in_toplevelDeclaration3345_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_declareVariables_in_toplevelDeclaration3353  */
static	ANTLR3_BITWORD FOLLOW_declareVariables_in_toplevelDeclaration3353_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_declareVariables_in_toplevelDeclaration3353	= { FOLLOW_declareVariables_in_toplevelDeclaration3353_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_declareTypes_in_toplevelDeclaration3362  */
static	ANTLR3_BITWORD FOLLOW_declareTypes_in_toplevelDeclaration3362_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_declareTypes_in_toplevelDeclaration3362	= { FOLLOW_declareTypes_in_toplevelDeclaration3362_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifierList_in_boundVarDecl3386  */
static	ANTLR3_BITWORD FOLLOW_identifierList_in_boundVarDecl3386_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifierList_in_boundVarDecl3386	= { FOLLOW_identifierList_in_boundVarDecl3386_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_boundVarDecl3389  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_boundVarDecl3389_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_boundVarDecl3389	= { FOLLOW_COLON_in_boundVarDecl3389_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_declareVariables_in_boundVarDecl3395  */
static	ANTLR3_BITWORD FOLLOW_declareVariables_in_boundVarDecl3395_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_declareVariables_in_boundVarDecl3395	= { FOLLOW_declareVariables_in_boundVarDecl3395_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_boundVarDecls3416  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_boundVarDecls3416_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_boundVarDecls3416	= { FOLLOW_boundVarDecl_in_boundVarDecls3416_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_boundVarDecls3421  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_boundVarDecls3421_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_boundVarDecls3421	= { FOLLOW_COMMA_in_boundVarDecls3421_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_boundVarDecls3423  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_boundVarDecls3423_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_boundVarDecls3423	= { FOLLOW_boundVarDecl_in_boundVarDecls3423_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3446  */
static	ANTLR3_BITWORD FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3446_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3446	= { FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3446_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_boundVarDeclsReturn3451  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_boundVarDeclsReturn3451_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_boundVarDeclsReturn3451	= { FOLLOW_COMMA_in_boundVarDeclsReturn3451_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3453  */
static	ANTLR3_BITWORD FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3453_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3453	= { FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3453_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifierList_in_boundVarDeclReturn3476  */
static	ANTLR3_BITWORD FOLLOW_identifierList_in_boundVarDeclReturn3476_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifierList_in_boundVarDeclReturn3476	= { FOLLOW_identifierList_in_boundVarDeclReturn3476_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_boundVarDeclReturn3479  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_boundVarDeclReturn3479_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_boundVarDeclReturn3479	= { FOLLOW_COLON_in_boundVarDeclReturn3479_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_boundVarDeclReturn3481  */
static	ANTLR3_BITWORD FOLLOW_type_in_boundVarDeclReturn3481_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_boundVarDeclReturn3481	= { FOLLOW_type_in_boundVarDeclReturn3481_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_declareTypes3515  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_declareTypes3515_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_declareTypes3515	= { FOLLOW_TYPE_TOK_in_declareTypes3515_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_declareTypes3534  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_declareTypes3534_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_declareTypes3534	= { FOLLOW_TYPE_TOK_in_declareTypes3534_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_declareTypes3536  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_declareTypes3536_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_declareTypes3536	= { FOLLOW_EQUAL_TOK_in_declareTypes3536_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_declareTypes3538  */
static	ANTLR3_BITWORD FOLLOW_type_in_declareTypes3538_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_declareTypes3538	= { FOLLOW_type_in_declareTypes3538_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_declareVariables3572  */
static	ANTLR3_BITWORD FOLLOW_type_in_declareVariables3572_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_declareVariables3572	= { FOLLOW_type_in_declareVariables3572_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_declareVariables3577  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_declareVariables3577_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_declareVariables3577	= { FOLLOW_EQUAL_TOK_in_declareVariables3577_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_declareVariables3579  */
static	ANTLR3_BITWORD FOLLOW_formula_in_declareVariables3579_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_declareVariables3579	= { FOLLOW_formula_in_declareVariables3579_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_identifierList3610  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_identifierList3610_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_identifierList3610	= { FOLLOW_identifier_in_identifierList3610_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_identifierList3621  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_identifierList3621_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_identifierList3621	= { FOLLOW_COMMA_in_identifierList3621_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_identifierList3623  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_identifierList3623_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_identifierList3623	= { FOLLOW_identifier_in_identifierList3623_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_identifier3645  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_identifier3645_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_identifier3645	= { FOLLOW_IDENTIFIER_in_identifier3645_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3678  */
static	ANTLR3_BITWORD FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3678_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000202) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3678	= { FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3678_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARROW_TOK_in_type3693  */
static	ANTLR3_BITWORD FOLLOW_ARROW_TOK_in_type3693_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARROW_TOK_in_type3693	= { FOLLOW_ARROW_TOK_in_type3693_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_type3695  */
static	ANTLR3_BITWORD FOLLOW_type_in_type3695_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_type3695	= { FOLLOW_type_in_type3695_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_type3720  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_type3720_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_type3720	= { FOLLOW_LET_TOK_in_type3720_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeLetDecl_in_type3728  */
static	ANTLR3_BITWORD FOLLOW_typeLetDecl_in_type3728_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeLetDecl_in_type3728	= { FOLLOW_typeLetDecl_in_type3728_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_type3733  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_type3733_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_type3733	= { FOLLOW_COMMA_in_type3733_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeLetDecl_in_type3735  */
static	ANTLR3_BITWORD FOLLOW_typeLetDecl_in_type3735_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeLetDecl_in_type3735	= { FOLLOW_typeLetDecl_in_type3735_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IN_TOK_in_type3741  */
static	ANTLR3_BITWORD FOLLOW_IN_TOK_in_type3741_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_IN_TOK_in_type3741	= { FOLLOW_IN_TOK_in_type3741_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_type3743  */
static	ANTLR3_BITWORD FOLLOW_type_in_type3743_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_type3743	= { FOLLOW_type_in_type3743_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3779  */
static	ANTLR3_BITWORD FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3779_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3779	= { FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3779_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3813  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3813_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3813	= { FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3813_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3820  */
static	ANTLR3_BITWORD FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3820_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3820	= { FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3820_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3841  */
static	ANTLR3_BITWORD FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3841_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3841	= { FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3841_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3843  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3843_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3843	= { FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3843_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3846  */
static	ANTLR3_BITWORD FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3846_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3846	= { FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3846_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3848  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3848_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3848	= { FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3848_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3861  */
static	ANTLR3_BITWORD FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3861_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3861	= { FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3861_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3863  */
static	ANTLR3_BITWORD FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3863_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3863	= { FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3863_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3865  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3865_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3865	= { FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3865_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3888  */
static	ANTLR3_BITWORD FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3888_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3888	= { FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3888_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3890  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3890_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3890	= { FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3890_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3908  */
static	ANTLR3_BITWORD FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3908_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3908	= { FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3908_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3913  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3913_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3913	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3913_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3915  */
static	ANTLR3_BITWORD FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3915_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3915	= { FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3915_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3921  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3921_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3921	= { FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3921_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3940  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3940_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x8001000000000000), ANTLR3_UINT64_LIT(0x0800000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3940	= { FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3940_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3944  */
static	ANTLR3_BITWORD FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3944_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3944	= { FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3944_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3946  */
static	ANTLR3_BITWORD FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3946_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x8001000000000000), ANTLR3_UINT64_LIT(0x0800000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3946	= { FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3946_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3950  */
static	ANTLR3_BITWORD FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3950_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3950	= { FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3950_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3952  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3952_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3952	= { FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3952_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3971  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3971_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030300000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3971	= { FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3971_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3975  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3975_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3975	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3975_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3986  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3986_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3986	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3986_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3988  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3988_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3988	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3988_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3999  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3999_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3999	= { FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3999_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4018  */
static	ANTLR3_BITWORD FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4018_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000022000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4018	= { FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4018_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4022  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4022_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4022	= { FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4022_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4025  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4025_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4025	= { FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4025_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4027  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4027_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4027	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4027_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4038  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4038_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4038	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4038_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4040  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4040_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4040	= { FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4040_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4043  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4043_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4043	= { FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4043_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4045  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4045_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4045	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4045_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4056  */
static	ANTLR3_BITWORD FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4056_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4056	= { FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4056_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4075  */
static	ANTLR3_BITWORD FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4075_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4075	= { FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4075_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4077  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4077_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4077	= { FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4077_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4081  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4081_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4081	= { FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4081_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4083  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4083_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4083	= { FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4083_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4102  */
static	ANTLR3_BITWORD FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4102_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4102	= { FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4102_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4117  */
static	ANTLR3_BITWORD FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4117_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4117	= { FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4117_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4125  */
static	ANTLR3_BITWORD FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4125_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4125	= { FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4125_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4133  */
static	ANTLR3_BITWORD FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4133_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4133	= { FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4133_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4148  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4148_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4148	= { FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4148_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4150  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4150_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4150	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4150_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4161  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4161_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4161	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4161_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4163  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4163_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4163	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4163_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4171  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4171_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4171	= { FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4171_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_parameterization4196  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_parameterization4196_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_parameterization4196	= { FOLLOW_LBRACKET_in_parameterization4196_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_parameterization4198  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_parameterization4198_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_parameterization4198	= { FOLLOW_restrictedType_in_parameterization4198_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_parameterization4209  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_parameterization4209_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_parameterization4209	= { FOLLOW_COMMA_in_parameterization4209_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_parameterization4211  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_parameterization4211_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_parameterization4211	= { FOLLOW_restrictedType_in_parameterization4211_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_parameterization4219  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_parameterization4219_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_parameterization4219	= { FOLLOW_RBRACKET_in_parameterization4219_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNDERSCORE_in_bound4236  */
static	ANTLR3_BITWORD FOLLOW_UNDERSCORE_in_bound4236_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_UNDERSCORE_in_bound4236	= { FOLLOW_UNDERSCORE_in_bound4236_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_integer_in_bound4246  */
static	ANTLR3_BITWORD FOLLOW_integer_in_bound4246_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_integer_in_bound4246	= { FOLLOW_integer_in_bound4246_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_typeLetDecl4265  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_typeLetDecl4265_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_typeLetDecl4265	= { FOLLOW_identifier_in_typeLetDecl4265_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_typeLetDecl4269  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_typeLetDecl4269_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_typeLetDecl4269	= { FOLLOW_COLON_in_typeLetDecl4269_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_typeLetDecl4271  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_typeLetDecl4271_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_typeLetDecl4271	= { FOLLOW_TYPE_TOK_in_typeLetDecl4271_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_typeLetDecl4275  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_typeLetDecl4275_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_typeLetDecl4275	= { FOLLOW_EQUAL_TOK_in_typeLetDecl4275_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_typeLetDecl4277  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_typeLetDecl4277_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_typeLetDecl4277	= { FOLLOW_restrictedType_in_typeLetDecl4277_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nots_in_formula4307  */
static	ANTLR3_BITWORD FOLLOW_nots_in_formula4307_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000040) };
static  ANTLR3_BITSET_LIST FOLLOW_nots_in_formula4307	= { FOLLOW_nots_in_formula4307_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_prefixFormula_in_formula4315  */
static	ANTLR3_BITWORD FOLLOW_prefixFormula_in_formula4315_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_prefixFormula_in_formula4315	= { FOLLOW_prefixFormula_in_formula4315_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_comparison_in_formula4332  */
static	ANTLR3_BITWORD FOLLOW_comparison_in_formula4332_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000042), ANTLR3_UINT64_LIT(0x0030280000000000), ANTLR3_UINT64_LIT(0x0000000000008020), ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_comparison_in_formula4332	= { FOLLOW_comparison_in_formula4332_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_morecomparisons_in_formula4349  */
static	ANTLR3_BITWORD FOLLOW_morecomparisons_in_formula4349_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_morecomparisons_in_formula4349	= { FOLLOW_morecomparisons_in_formula4349_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_booleanBinop_in_morecomparisons4388  */
static	ANTLR3_BITWORD FOLLOW_booleanBinop_in_morecomparisons4388_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_booleanBinop_in_morecomparisons4388	= { FOLLOW_booleanBinop_in_morecomparisons4388_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nots_in_morecomparisons4399  */
static	ANTLR3_BITWORD FOLLOW_nots_in_morecomparisons4399_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000040) };
static  ANTLR3_BITSET_LIST FOLLOW_nots_in_morecomparisons4399	= { FOLLOW_nots_in_morecomparisons4399_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_prefixFormula_in_morecomparisons4407  */
static	ANTLR3_BITWORD FOLLOW_prefixFormula_in_morecomparisons4407_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_prefixFormula_in_morecomparisons4407	= { FOLLOW_prefixFormula_in_morecomparisons4407_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_comparison_in_morecomparisons4424  */
static	ANTLR3_BITWORD FOLLOW_comparison_in_morecomparisons4424_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000042), ANTLR3_UINT64_LIT(0x0030280000000000), ANTLR3_UINT64_LIT(0x0000000000008020), ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_comparison_in_morecomparisons4424	= { FOLLOW_comparison_in_morecomparisons4424_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_morecomparisons_in_morecomparisons4441  */
static	ANTLR3_BITWORD FOLLOW_morecomparisons_in_morecomparisons4441_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_morecomparisons_in_morecomparisons4441	= { FOLLOW_morecomparisons_in_morecomparisons4441_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_TOK_in_nots4470  */
static	ANTLR3_BITWORD FOLLOW_NOT_TOK_in_nots4470_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_TOK_in_nots4470	= { FOLLOW_NOT_TOK_in_nots4470_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORALL_TOK_in_prefixFormula4502  */
static	ANTLR3_BITWORD FOLLOW_FORALL_TOK_in_prefixFormula4502_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FORALL_TOK_in_prefixFormula4502	= { FOLLOW_FORALL_TOK_in_prefixFormula4502_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXISTS_TOK_in_prefixFormula4508  */
static	ANTLR3_BITWORD FOLLOW_EXISTS_TOK_in_prefixFormula4508_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_EXISTS_TOK_in_prefixFormula4508	= { FOLLOW_EXISTS_TOK_in_prefixFormula4508_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_prefixFormula4520  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_prefixFormula4520_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_prefixFormula4520	= { FOLLOW_LPAREN_in_prefixFormula4520_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_prefixFormula4526  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_prefixFormula4526_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_prefixFormula4526	= { FOLLOW_boundVarDecl_in_prefixFormula4526_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_prefixFormula4541  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_prefixFormula4541_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_prefixFormula4541	= { FOLLOW_COMMA_in_prefixFormula4541_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_prefixFormula4543  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_prefixFormula4543_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_prefixFormula4543	= { FOLLOW_boundVarDecl_in_prefixFormula4543_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_prefixFormula4561  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_prefixFormula4561_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_prefixFormula4561	= { FOLLOW_RPAREN_in_prefixFormula4561_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_prefixFormula4569  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_prefixFormula4569_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF080000C2) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_prefixFormula4569	= { FOLLOW_COLON_in_prefixFormula4569_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_instantiationPatterns_in_prefixFormula4571  */
static	ANTLR3_BITWORD FOLLOW_instantiationPatterns_in_prefixFormula4571_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_instantiationPatterns_in_prefixFormula4571	= { FOLLOW_instantiationPatterns_in_prefixFormula4571_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_prefixFormula4575  */
static	ANTLR3_BITWORD FOLLOW_formula_in_prefixFormula4575_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_prefixFormula4575	= { FOLLOW_formula_in_prefixFormula4575_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_prefixFormula4594  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_prefixFormula4594_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_prefixFormula4594	= { FOLLOW_LET_TOK_in_prefixFormula4594_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_prefixFormula4602  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_prefixFormula4602_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_prefixFormula4602	= { FOLLOW_letDecl_in_prefixFormula4602_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_prefixFormula4606  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_prefixFormula4606_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_prefixFormula4606	= { FOLLOW_COMMA_in_prefixFormula4606_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_prefixFormula4608  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_prefixFormula4608_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_prefixFormula4608	= { FOLLOW_letDecl_in_prefixFormula4608_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IN_TOK_in_prefixFormula4617  */
static	ANTLR3_BITWORD FOLLOW_IN_TOK_in_prefixFormula4617_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_IN_TOK_in_prefixFormula4617	= { FOLLOW_IN_TOK_in_prefixFormula4617_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_prefixFormula4619  */
static	ANTLR3_BITWORD FOLLOW_formula_in_prefixFormula4619_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_prefixFormula4619	= { FOLLOW_formula_in_prefixFormula4619_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LAMBDA_in_prefixFormula4634  */
static	ANTLR3_BITWORD FOLLOW_LAMBDA_in_prefixFormula4634_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LAMBDA_in_prefixFormula4634	= { FOLLOW_LAMBDA_in_prefixFormula4634_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_prefixFormula4638  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_prefixFormula4638_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_prefixFormula4638	= { FOLLOW_LPAREN_in_prefixFormula4638_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDeclsReturn_in_prefixFormula4644  */
static	ANTLR3_BITWORD FOLLOW_boundVarDeclsReturn_in_prefixFormula4644_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDeclsReturn_in_prefixFormula4644	= { FOLLOW_boundVarDeclsReturn_in_prefixFormula4644_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_prefixFormula4651  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_prefixFormula4651_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_prefixFormula4651	= { FOLLOW_RPAREN_in_prefixFormula4651_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_prefixFormula4653  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_prefixFormula4653_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_prefixFormula4653	= { FOLLOW_COLON_in_prefixFormula4653_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_prefixFormula4655  */
static	ANTLR3_BITWORD FOLLOW_formula_in_prefixFormula4655_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_prefixFormula4655	= { FOLLOW_formula_in_prefixFormula4655_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PATTERN_TOK_in_instantiationPatterns4683  */
static	ANTLR3_BITWORD FOLLOW_PATTERN_TOK_in_instantiationPatterns4683_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PATTERN_TOK_in_instantiationPatterns4683	= { FOLLOW_PATTERN_TOK_in_instantiationPatterns4683_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_instantiationPatterns4685  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_instantiationPatterns4685_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_instantiationPatterns4685	= { FOLLOW_LPAREN_in_instantiationPatterns4685_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_instantiationPatterns4687  */
static	ANTLR3_BITWORD FOLLOW_formula_in_instantiationPatterns4687_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_instantiationPatterns4687	= { FOLLOW_formula_in_instantiationPatterns4687_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_instantiationPatterns4693  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_instantiationPatterns4693_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_instantiationPatterns4693	= { FOLLOW_COMMA_in_instantiationPatterns4693_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_instantiationPatterns4695  */
static	ANTLR3_BITWORD FOLLOW_formula_in_instantiationPatterns4695_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_instantiationPatterns4695	= { FOLLOW_formula_in_instantiationPatterns4695_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_instantiationPatterns4703  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_instantiationPatterns4703_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_instantiationPatterns4703	= { FOLLOW_RPAREN_in_instantiationPatterns4703_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_instantiationPatterns4705  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_instantiationPatterns4705_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_instantiationPatterns4705	= { FOLLOW_COLON_in_instantiationPatterns4705_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_letDecl4742  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_letDecl4742_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_letDecl4742	= { FOLLOW_identifier_in_letDecl4742_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_letDecl4745  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_letDecl4745_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_letDecl4745	= { FOLLOW_EQUAL_TOK_in_letDecl4745_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_letDecl4747  */
static	ANTLR3_BITWORD FOLLOW_formula_in_letDecl4747_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_letDecl4747	= { FOLLOW_formula_in_letDecl4747_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_comparison4836  */
static	ANTLR3_BITWORD FOLLOW_term_in_comparison4836_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x6400000848100001) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_comparison4836	= { FOLLOW_term_in_comparison4836_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_comparisonBinop_in_comparison4847  */
static	ANTLR3_BITWORD FOLLOW_comparisonBinop_in_comparison4847_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x13A4DFFF08000040) };
static  ANTLR3_BITSET_LIST FOLLOW_comparisonBinop_in_comparison4847	= { FOLLOW_comparisonBinop_in_comparison4847_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_comparison4850  */
static	ANTLR3_BITWORD FOLLOW_term_in_comparison4850_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x6400000848100001) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_comparison4850	= { FOLLOW_term_in_comparison4850_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_uminusTerm_in_term5005  */
static	ANTLR3_BITWORD FOLLOW_uminusTerm_in_term5005_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x8000800001000008), ANTLR3_UINT64_LIT(0x0000000040000101), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_uminusTerm_in_term5005	= { FOLLOW_uminusTerm_in_term5005_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_WITH_TOK_in_term5014  */
static	ANTLR3_BITWORD FOLLOW_WITH_TOK_in_term5014_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_WITH_TOK_in_term5014	= { FOLLOW_WITH_TOK_in_term5014_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_term5024  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_term5024_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_term5024	= { FOLLOW_arrayStore_in_term5024_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_term5029  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_term5029_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_term5029	= { FOLLOW_COMMA_in_term5029_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_term5031  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_term5031_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_term5031	= { FOLLOW_arrayStore_in_term5031_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_term5045  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_term5045_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_term5045	= { FOLLOW_DOT_in_term5045_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_term5049  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_term5049_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_term5049	= { FOLLOW_tupleStore_in_term5049_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_term5054  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_term5054_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_term5054	= { FOLLOW_COMMA_in_term5054_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_term5056  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_term5056_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_term5056	= { FOLLOW_DOT_in_term5056_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_term5058  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_term5058_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_term5058	= { FOLLOW_tupleStore_in_term5058_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_term5078  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_term5078_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_term5078	= { FOLLOW_recordStore_in_term5078_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_term5083  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_term5083_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_term5083	= { FOLLOW_COMMA_in_term5083_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_term5085  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_term5085_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_term5085	= { FOLLOW_DOT_in_term5085_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_term5087  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_term5087_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_term5087	= { FOLLOW_recordStore_in_term5087_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arithmeticBinop_in_term5113  */
static	ANTLR3_BITWORD FOLLOW_arithmeticBinop_in_term5113_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x13A4DFFF08000040) };
static  ANTLR3_BITSET_LIST FOLLOW_arithmeticBinop_in_term5113	= { FOLLOW_arithmeticBinop_in_term5113_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_uminusTerm_in_term5116  */
static	ANTLR3_BITWORD FOLLOW_uminusTerm_in_term5116_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x8000800001000008), ANTLR3_UINT64_LIT(0x0000000040000101) };
static  ANTLR3_BITSET_LIST FOLLOW_uminusTerm_in_term5116	= { FOLLOW_uminusTerm_in_term5116_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_arrayStore5157  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_arrayStore5157_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_arrayStore5157	= { FOLLOW_LBRACKET_in_arrayStore5157_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_arrayStore5159  */
static	ANTLR3_BITWORD FOLLOW_formula_in_arrayStore5159_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_arrayStore5159	= { FOLLOW_formula_in_arrayStore5159_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_arrayStore5162  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_arrayStore5162_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0100000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_arrayStore5162	= { FOLLOW_RBRACKET_in_arrayStore5162_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_arrayStore5178  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_arrayStore5178_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_arrayStore5178	= { FOLLOW_arrayStore_in_arrayStore5178_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_arrayStore5189  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_arrayStore5189_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_arrayStore5189	= { FOLLOW_DOT_in_arrayStore5189_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_arrayStore5193  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_arrayStore5193_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_arrayStore5193	= { FOLLOW_tupleStore_in_arrayStore5193_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_arrayStore5210  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_arrayStore5210_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_arrayStore5210	= { FOLLOW_recordStore_in_arrayStore5210_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_arrayStore5223  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_arrayStore5223_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x13A4DFFF08000040) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_arrayStore5223	= { FOLLOW_ASSIGN_TOK_in_arrayStore5223_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_arrayStore5225  */
static	ANTLR3_BITWORD FOLLOW_term_in_arrayStore5225_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_arrayStore5225	= { FOLLOW_term_in_arrayStore5225_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_tupleStore5257  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_tupleStore5257_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0100000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_tupleStore5257	= { FOLLOW_numeral_in_tupleStore5257_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_tupleStore5273  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_tupleStore5273_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_tupleStore5273	= { FOLLOW_arrayStore_in_tupleStore5273_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_tupleStore5284  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_tupleStore5284_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_tupleStore5284	= { FOLLOW_DOT_in_tupleStore5284_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_tupleStore5288  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_tupleStore5288_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_tupleStore5288	= { FOLLOW_tupleStore_in_tupleStore5288_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_tupleStore5305  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_tupleStore5305_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_tupleStore5305	= { FOLLOW_recordStore_in_tupleStore5305_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_tupleStore5318  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_tupleStore5318_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x13A4DFFF08000040) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_tupleStore5318	= { FOLLOW_ASSIGN_TOK_in_tupleStore5318_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_tupleStore5320  */
static	ANTLR3_BITWORD FOLLOW_term_in_tupleStore5320_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_tupleStore5320	= { FOLLOW_term_in_tupleStore5320_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_recordStore5350  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_recordStore5350_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0100000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_recordStore5350	= { FOLLOW_identifier_in_recordStore5350_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_recordStore5367  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_recordStore5367_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_recordStore5367	= { FOLLOW_arrayStore_in_recordStore5367_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_recordStore5378  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_recordStore5378_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_recordStore5378	= { FOLLOW_DOT_in_recordStore5378_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_recordStore5382  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_recordStore5382_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_recordStore5382	= { FOLLOW_tupleStore_in_recordStore5382_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_recordStore5399  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_recordStore5399_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_recordStore5399	= { FOLLOW_recordStore_in_recordStore5399_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_recordStore5412  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_recordStore5412_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x13A4DFFF08000040) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_recordStore5412	= { FOLLOW_ASSIGN_TOK_in_recordStore5412_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_recordStore5414  */
static	ANTLR3_BITWORD FOLLOW_term_in_recordStore5414_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_recordStore5414	= { FOLLOW_term_in_recordStore5414_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_uminusTerm5451  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_uminusTerm5451_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x13A4DFFF08000040) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_uminusTerm5451	= { FOLLOW_MINUS_TOK_in_uminusTerm5451_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvBinaryOpTerm_in_uminusTerm5457  */
static	ANTLR3_BITWORD FOLLOW_bvBinaryOpTerm_in_uminusTerm5457_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvBinaryOpTerm_in_uminusTerm5457	= { FOLLOW_bvBinaryOpTerm_in_uminusTerm5457_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvBinaryOpTerm_in_uminusTerm5470  */
static	ANTLR3_BITWORD FOLLOW_bvBinaryOpTerm_in_uminusTerm5470_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvBinaryOpTerm_in_uminusTerm5470	= { FOLLOW_bvBinaryOpTerm_in_uminusTerm5470_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvNegTerm_in_bvBinaryOpTerm5492  */
static	ANTLR3_BITWORD FOLLOW_bvNegTerm_in_bvBinaryOpTerm5492_bits[]	= { ANTLR3_UINT64_LIT(0x0080000000044002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvNegTerm_in_bvBinaryOpTerm5492	= { FOLLOW_bvNegTerm_in_bvBinaryOpTerm5492_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvBinop_in_bvBinaryOpTerm5503  */
static	ANTLR3_BITWORD FOLLOW_bvBinop_in_bvBinaryOpTerm5503_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x13A4DFFF08000040) };
static  ANTLR3_BITSET_LIST FOLLOW_bvBinop_in_bvBinaryOpTerm5503	= { FOLLOW_bvBinop_in_bvBinaryOpTerm5503_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvNegTerm_in_bvBinaryOpTerm5506  */
static	ANTLR3_BITWORD FOLLOW_bvNegTerm_in_bvBinaryOpTerm5506_bits[]	= { ANTLR3_UINT64_LIT(0x0080000000044002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvNegTerm_in_bvBinaryOpTerm5506	= { FOLLOW_bvNegTerm_in_bvBinaryOpTerm5506_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNEG_TOK_in_bvNegTerm5569  */
static	ANTLR3_BITWORD FOLLOW_BVNEG_TOK_in_bvNegTerm5569_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x13A4DFFF08000040) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNEG_TOK_in_bvNegTerm5569	= { FOLLOW_BVNEG_TOK_in_bvNegTerm5569_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvNegTerm_in_bvNegTerm5571  */
static	ANTLR3_BITWORD FOLLOW_bvNegTerm_in_bvNegTerm5571_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvNegTerm_in_bvNegTerm5571	= { FOLLOW_bvNegTerm_in_bvNegTerm5571_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_relationTerm_in_bvNegTerm5584  */
static	ANTLR3_BITWORD FOLLOW_relationTerm_in_bvNegTerm5584_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_relationTerm_in_bvNegTerm5584	= { FOLLOW_relationTerm_in_bvNegTerm5584_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRANSPOSE_TOK_in_relationTerm5605  */
static	ANTLR3_BITWORD FOLLOW_TRANSPOSE_TOK_in_relationTerm5605_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFEFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x13A4DFFF08000040) };
static  ANTLR3_BITSET_LIST FOLLOW_TRANSPOSE_TOK_in_relationTerm5605	= { FOLLOW_TRANSPOSE_TOK_in_relationTerm5605_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_relationTerm_in_relationTerm5607  */
static	ANTLR3_BITWORD FOLLOW_relationTerm_in_relationTerm5607_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_relationTerm_in_relationTerm5607	= { FOLLOW_relationTerm_in_relationTerm5607_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRANSCLOSURE_TOK_in_relationTerm5621  */
static	ANTLR3_BITWORD FOLLOW_TRANSCLOSURE_TOK_in_relationTerm5621_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFEFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x13A4DFFF08000040) };
static  ANTLR3_BITSET_LIST FOLLOW_TRANSCLOSURE_TOK_in_relationTerm5621	= { FOLLOW_TRANSCLOSURE_TOK_in_relationTerm5621_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_relationTerm_in_relationTerm5623  */
static	ANTLR3_BITWORD FOLLOW_relationTerm_in_relationTerm5623_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_relationTerm_in_relationTerm5623	= { FOLLOW_relationTerm_in_relationTerm5623_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TUPLE_TOK_in_relationTerm5636  */
static	ANTLR3_BITWORD FOLLOW_TUPLE_TOK_in_relationTerm5636_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_TUPLE_TOK_in_relationTerm5636	= { FOLLOW_TUPLE_TOK_in_relationTerm5636_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_relationTerm5638  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_relationTerm5638_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFEFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x13A4DFFF08000040) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_relationTerm5638	= { FOLLOW_LPAREN_in_relationTerm5638_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_relationTerm_in_relationTerm5640  */
static	ANTLR3_BITWORD FOLLOW_relationTerm_in_relationTerm5640_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_relationTerm_in_relationTerm5640	= { FOLLOW_relationTerm_in_relationTerm5640_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_relationTerm5643  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_relationTerm5643_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_relationTerm5643	= { FOLLOW_RPAREN_in_relationTerm5643_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDEN_TOK_in_relationTerm5655  */
static	ANTLR3_BITWORD FOLLOW_IDEN_TOK_in_relationTerm5655_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFEFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x13A4DFFF08000040) };
static  ANTLR3_BITSET_LIST FOLLOW_IDEN_TOK_in_relationTerm5655	= { FOLLOW_IDEN_TOK_in_relationTerm5655_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_relationTerm_in_relationTerm5657  */
static	ANTLR3_BITWORD FOLLOW_relationTerm_in_relationTerm5657_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_relationTerm_in_relationTerm5657	= { FOLLOW_relationTerm_in_relationTerm5657_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_postfixTerm_in_relationTerm5687  */
static	ANTLR3_BITWORD FOLLOW_postfixTerm_in_relationTerm5687_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_postfixTerm_in_relationTerm5687	= { FOLLOW_postfixTerm_in_relationTerm5687_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvTerm_in_postfixTerm5711  */
static	ANTLR3_BITWORD FOLLOW_bvTerm_in_postfixTerm5711_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_bvTerm_in_postfixTerm5711	= { FOLLOW_bvTerm_in_postfixTerm5711_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_postfixTerm5728  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_postfixTerm5728_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_postfixTerm5728	= { FOLLOW_LBRACKET_in_postfixTerm5728_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5740  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5740_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5740	= { FOLLOW_formula_in_postfixTerm5740_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5757  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5757_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5757	= { FOLLOW_numeral_in_postfixTerm5757_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_postfixTerm5759  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_postfixTerm5759_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_postfixTerm5759	= { FOLLOW_COLON_in_postfixTerm5759_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5763  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5763_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5763	= { FOLLOW_numeral_in_postfixTerm5763_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_postfixTerm5775  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_postfixTerm5775_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_postfixTerm5775	= { FOLLOW_RBRACKET_in_postfixTerm5775_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5801  */
static	ANTLR3_BITWORD FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5801_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5801	= { FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5801_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5813  */
static	ANTLR3_BITWORD FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5813_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5813	= { FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5813_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5821  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5821_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5821	= { FOLLOW_numeral_in_postfixTerm5821_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm5846  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm5846_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm5846	= { FOLLOW_LPAREN_in_postfixTerm5846_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5856  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5856_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5856	= { FOLLOW_formula_in_postfixTerm5856_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_postfixTerm5869  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_postfixTerm5869_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_postfixTerm5869	= { FOLLOW_COMMA_in_postfixTerm5869_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5871  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5871_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5871	= { FOLLOW_formula_in_postfixTerm5871_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm5879  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm5879_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm5879	= { FOLLOW_RPAREN_in_postfixTerm5879_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_postfixTerm5911  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_postfixTerm5911_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_postfixTerm5911	= { FOLLOW_DOT_in_postfixTerm5911_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_postfixTerm5921  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_postfixTerm5921_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_postfixTerm5921	= { FOLLOW_identifier_in_postfixTerm5921_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5944  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5944_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5944	= { FOLLOW_numeral_in_postfixTerm5944_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FLOOR_TOK_in_postfixTerm5977  */
static	ANTLR3_BITWORD FOLLOW_FLOOR_TOK_in_postfixTerm5977_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FLOOR_TOK_in_postfixTerm5977	= { FOLLOW_FLOOR_TOK_in_postfixTerm5977_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm5979  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm5979_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm5979	= { FOLLOW_LPAREN_in_postfixTerm5979_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5981  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5981_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5981	= { FOLLOW_formula_in_postfixTerm5981_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm5984  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm5984_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm5984	= { FOLLOW_RPAREN_in_postfixTerm5984_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IS_INTEGER_TOK_in_postfixTerm6000  */
static	ANTLR3_BITWORD FOLLOW_IS_INTEGER_TOK_in_postfixTerm6000_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IS_INTEGER_TOK_in_postfixTerm6000	= { FOLLOW_IS_INTEGER_TOK_in_postfixTerm6000_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm6002  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm6002_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm6002	= { FOLLOW_LPAREN_in_postfixTerm6002_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6004  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6004_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6004	= { FOLLOW_formula_in_postfixTerm6004_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm6007  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm6007_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm6007	= { FOLLOW_RPAREN_in_postfixTerm6007_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ABS_TOK_in_postfixTerm6023  */
static	ANTLR3_BITWORD FOLLOW_ABS_TOK_in_postfixTerm6023_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ABS_TOK_in_postfixTerm6023	= { FOLLOW_ABS_TOK_in_postfixTerm6023_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm6025  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm6025_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm6025	= { FOLLOW_LPAREN_in_postfixTerm6025_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6027  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6027_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6027	= { FOLLOW_formula_in_postfixTerm6027_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm6030  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm6030_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm6030	= { FOLLOW_RPAREN_in_postfixTerm6030_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DIVISIBLE_TOK_in_postfixTerm6046  */
static	ANTLR3_BITWORD FOLLOW_DIVISIBLE_TOK_in_postfixTerm6046_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DIVISIBLE_TOK_in_postfixTerm6046	= { FOLLOW_DIVISIBLE_TOK_in_postfixTerm6046_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm6048  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm6048_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm6048	= { FOLLOW_LPAREN_in_postfixTerm6048_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6050  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6050_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6050	= { FOLLOW_formula_in_postfixTerm6050_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_postfixTerm6053  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_postfixTerm6053_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_postfixTerm6053	= { FOLLOW_COMMA_in_postfixTerm6053_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm6057  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm6057_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm6057	= { FOLLOW_numeral_in_postfixTerm6057_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm6059  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm6059_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm6059	= { FOLLOW_RPAREN_in_postfixTerm6059_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DISTINCT_TOK_in_postfixTerm6075  */
static	ANTLR3_BITWORD FOLLOW_DISTINCT_TOK_in_postfixTerm6075_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DISTINCT_TOK_in_postfixTerm6075	= { FOLLOW_DISTINCT_TOK_in_postfixTerm6075_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm6077  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm6077_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm6077	= { FOLLOW_LPAREN_in_postfixTerm6077_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6085  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6085_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6085	= { FOLLOW_formula_in_postfixTerm6085_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_postfixTerm6098  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_postfixTerm6098_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_postfixTerm6098	= { FOLLOW_COMMA_in_postfixTerm6098_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6100  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6100_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6100	= { FOLLOW_formula_in_postfixTerm6100_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm6108  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm6108_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm6108	= { FOLLOW_RPAREN_in_postfixTerm6108_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeAscription_in_postfixTerm6130  */
static	ANTLR3_BITWORD FOLLOW_typeAscription_in_postfixTerm6130_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_typeAscription_in_postfixTerm6130	= { FOLLOW_typeAscription_in_postfixTerm6130_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVXOR_TOK_in_bvTerm6171  */
static	ANTLR3_BITWORD FOLLOW_BVXOR_TOK_in_bvTerm6171_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVXOR_TOK_in_bvTerm6171	= { FOLLOW_BVXOR_TOK_in_bvTerm6171_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6173  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6173_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6173	= { FOLLOW_LPAREN_in_bvTerm6173_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6175  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6175_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6175	= { FOLLOW_formula_in_bvTerm6175_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6178  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6178_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6178	= { FOLLOW_COMMA_in_bvTerm6178_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6180  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6180_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6180	= { FOLLOW_formula_in_bvTerm6180_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6183  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6183_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6183	= { FOLLOW_RPAREN_in_bvTerm6183_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNAND_TOK_in_bvTerm6195  */
static	ANTLR3_BITWORD FOLLOW_BVNAND_TOK_in_bvTerm6195_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNAND_TOK_in_bvTerm6195	= { FOLLOW_BVNAND_TOK_in_bvTerm6195_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6197  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6197_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6197	= { FOLLOW_LPAREN_in_bvTerm6197_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6199  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6199_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6199	= { FOLLOW_formula_in_bvTerm6199_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6202  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6202_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6202	= { FOLLOW_COMMA_in_bvTerm6202_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6204  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6204_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6204	= { FOLLOW_formula_in_bvTerm6204_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6207  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6207_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6207	= { FOLLOW_RPAREN_in_bvTerm6207_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNOR_TOK_in_bvTerm6219  */
static	ANTLR3_BITWORD FOLLOW_BVNOR_TOK_in_bvTerm6219_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNOR_TOK_in_bvTerm6219	= { FOLLOW_BVNOR_TOK_in_bvTerm6219_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6221  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6221_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6221	= { FOLLOW_LPAREN_in_bvTerm6221_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6223  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6223_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6223	= { FOLLOW_formula_in_bvTerm6223_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6226  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6226_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6226	= { FOLLOW_COMMA_in_bvTerm6226_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6228  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6228_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6228	= { FOLLOW_formula_in_bvTerm6228_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6231  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6231_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6231	= { FOLLOW_RPAREN_in_bvTerm6231_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVCOMP_TOK_in_bvTerm6243  */
static	ANTLR3_BITWORD FOLLOW_BVCOMP_TOK_in_bvTerm6243_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVCOMP_TOK_in_bvTerm6243	= { FOLLOW_BVCOMP_TOK_in_bvTerm6243_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6245  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6245_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6245	= { FOLLOW_LPAREN_in_bvTerm6245_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6247  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6247_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6247	= { FOLLOW_formula_in_bvTerm6247_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6250  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6250_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6250	= { FOLLOW_COMMA_in_bvTerm6250_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6252  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6252_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6252	= { FOLLOW_formula_in_bvTerm6252_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6255  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6255_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6255	= { FOLLOW_RPAREN_in_bvTerm6255_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVXNOR_TOK_in_bvTerm6267  */
static	ANTLR3_BITWORD FOLLOW_BVXNOR_TOK_in_bvTerm6267_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVXNOR_TOK_in_bvTerm6267	= { FOLLOW_BVXNOR_TOK_in_bvTerm6267_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6269  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6269_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6269	= { FOLLOW_LPAREN_in_bvTerm6269_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6271  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6271_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6271	= { FOLLOW_formula_in_bvTerm6271_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6274  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6274_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6274	= { FOLLOW_COMMA_in_bvTerm6274_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6276  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6276_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6276	= { FOLLOW_formula_in_bvTerm6276_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6279  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6279_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6279	= { FOLLOW_RPAREN_in_bvTerm6279_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUMINUS_TOK_in_bvTerm6298  */
static	ANTLR3_BITWORD FOLLOW_BVUMINUS_TOK_in_bvTerm6298_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUMINUS_TOK_in_bvTerm6298	= { FOLLOW_BVUMINUS_TOK_in_bvTerm6298_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6300  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6300_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6300	= { FOLLOW_LPAREN_in_bvTerm6300_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6302  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6302_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6302	= { FOLLOW_formula_in_bvTerm6302_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6305  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6305_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6305	= { FOLLOW_RPAREN_in_bvTerm6305_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVPLUS_TOK_in_bvTerm6323  */
static	ANTLR3_BITWORD FOLLOW_BVPLUS_TOK_in_bvTerm6323_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVPLUS_TOK_in_bvTerm6323	= { FOLLOW_BVPLUS_TOK_in_bvTerm6323_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6325  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6325_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6325	= { FOLLOW_LPAREN_in_bvTerm6325_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6329  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6329_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6329	= { FOLLOW_numeral_in_bvTerm6329_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6331  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6331_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6331	= { FOLLOW_COMMA_in_bvTerm6331_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6333  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6333_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6333	= { FOLLOW_formula_in_bvTerm6333_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6344  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6344_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6344	= { FOLLOW_COMMA_in_bvTerm6344_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6346  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6346_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6346	= { FOLLOW_formula_in_bvTerm6346_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6354  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6354_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6354	= { FOLLOW_RPAREN_in_bvTerm6354_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSUB_TOK_in_bvTerm6372  */
static	ANTLR3_BITWORD FOLLOW_BVSUB_TOK_in_bvTerm6372_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSUB_TOK_in_bvTerm6372	= { FOLLOW_BVSUB_TOK_in_bvTerm6372_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6374  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6374_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6374	= { FOLLOW_LPAREN_in_bvTerm6374_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6378  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6378_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6378	= { FOLLOW_numeral_in_bvTerm6378_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6380  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6380_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6380	= { FOLLOW_COMMA_in_bvTerm6380_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6382  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6382_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6382	= { FOLLOW_formula_in_bvTerm6382_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6385  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6385_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6385	= { FOLLOW_COMMA_in_bvTerm6385_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6387  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6387_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6387	= { FOLLOW_formula_in_bvTerm6387_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6390  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6390_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6390	= { FOLLOW_RPAREN_in_bvTerm6390_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVMULT_TOK_in_bvTerm6408  */
static	ANTLR3_BITWORD FOLLOW_BVMULT_TOK_in_bvTerm6408_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVMULT_TOK_in_bvTerm6408	= { FOLLOW_BVMULT_TOK_in_bvTerm6408_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6410  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6410_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6410	= { FOLLOW_LPAREN_in_bvTerm6410_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6414  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6414_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6414	= { FOLLOW_numeral_in_bvTerm6414_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6416  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6416_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6416	= { FOLLOW_COMMA_in_bvTerm6416_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6418  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6418_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6418	= { FOLLOW_formula_in_bvTerm6418_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6421  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6421_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6421	= { FOLLOW_COMMA_in_bvTerm6421_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6423  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6423_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6423	= { FOLLOW_formula_in_bvTerm6423_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6426  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6426_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6426	= { FOLLOW_RPAREN_in_bvTerm6426_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUDIV_TOK_in_bvTerm6444  */
static	ANTLR3_BITWORD FOLLOW_BVUDIV_TOK_in_bvTerm6444_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUDIV_TOK_in_bvTerm6444	= { FOLLOW_BVUDIV_TOK_in_bvTerm6444_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6446  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6446_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6446	= { FOLLOW_LPAREN_in_bvTerm6446_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6448  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6448_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6448	= { FOLLOW_formula_in_bvTerm6448_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6451  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6451_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6451	= { FOLLOW_COMMA_in_bvTerm6451_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6453  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6453_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6453	= { FOLLOW_formula_in_bvTerm6453_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6456  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6456_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6456	= { FOLLOW_RPAREN_in_bvTerm6456_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSDIV_TOK_in_bvTerm6474  */
static	ANTLR3_BITWORD FOLLOW_BVSDIV_TOK_in_bvTerm6474_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSDIV_TOK_in_bvTerm6474	= { FOLLOW_BVSDIV_TOK_in_bvTerm6474_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6476  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6476_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6476	= { FOLLOW_LPAREN_in_bvTerm6476_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6478  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6478_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6478	= { FOLLOW_formula_in_bvTerm6478_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6481  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6481_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6481	= { FOLLOW_COMMA_in_bvTerm6481_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6483  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6483_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6483	= { FOLLOW_formula_in_bvTerm6483_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6486  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6486_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6486	= { FOLLOW_RPAREN_in_bvTerm6486_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUREM_TOK_in_bvTerm6504  */
static	ANTLR3_BITWORD FOLLOW_BVUREM_TOK_in_bvTerm6504_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUREM_TOK_in_bvTerm6504	= { FOLLOW_BVUREM_TOK_in_bvTerm6504_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6506  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6506_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6506	= { FOLLOW_LPAREN_in_bvTerm6506_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6508  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6508_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6508	= { FOLLOW_formula_in_bvTerm6508_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6511  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6511_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6511	= { FOLLOW_COMMA_in_bvTerm6511_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6513  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6513_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6513	= { FOLLOW_formula_in_bvTerm6513_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6516  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6516_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6516	= { FOLLOW_RPAREN_in_bvTerm6516_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSREM_TOK_in_bvTerm6534  */
static	ANTLR3_BITWORD FOLLOW_BVSREM_TOK_in_bvTerm6534_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSREM_TOK_in_bvTerm6534	= { FOLLOW_BVSREM_TOK_in_bvTerm6534_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6536  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6536_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6536	= { FOLLOW_LPAREN_in_bvTerm6536_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6538  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6538_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6538	= { FOLLOW_formula_in_bvTerm6538_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6541  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6541_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6541	= { FOLLOW_COMMA_in_bvTerm6541_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6543  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6543_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6543	= { FOLLOW_formula_in_bvTerm6543_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6546  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6546_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6546	= { FOLLOW_RPAREN_in_bvTerm6546_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSMOD_TOK_in_bvTerm6564  */
static	ANTLR3_BITWORD FOLLOW_BVSMOD_TOK_in_bvTerm6564_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSMOD_TOK_in_bvTerm6564	= { FOLLOW_BVSMOD_TOK_in_bvTerm6564_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6566  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6566_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6566	= { FOLLOW_LPAREN_in_bvTerm6566_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6568  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6568_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6568	= { FOLLOW_formula_in_bvTerm6568_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6571  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6571_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6571	= { FOLLOW_COMMA_in_bvTerm6571_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6573  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6573_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6573	= { FOLLOW_formula_in_bvTerm6573_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6576  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6576_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6576	= { FOLLOW_RPAREN_in_bvTerm6576_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSHL_TOK_in_bvTerm6594  */
static	ANTLR3_BITWORD FOLLOW_BVSHL_TOK_in_bvTerm6594_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSHL_TOK_in_bvTerm6594	= { FOLLOW_BVSHL_TOK_in_bvTerm6594_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6596  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6596_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6596	= { FOLLOW_LPAREN_in_bvTerm6596_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6598  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6598_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6598	= { FOLLOW_formula_in_bvTerm6598_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6601  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6601_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6601	= { FOLLOW_COMMA_in_bvTerm6601_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6603  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6603_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6603	= { FOLLOW_formula_in_bvTerm6603_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6606  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6606_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6606	= { FOLLOW_RPAREN_in_bvTerm6606_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVASHR_TOK_in_bvTerm6624  */
static	ANTLR3_BITWORD FOLLOW_BVASHR_TOK_in_bvTerm6624_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVASHR_TOK_in_bvTerm6624	= { FOLLOW_BVASHR_TOK_in_bvTerm6624_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6626  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6626_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6626	= { FOLLOW_LPAREN_in_bvTerm6626_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6628  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6628_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6628	= { FOLLOW_formula_in_bvTerm6628_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6631  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6631_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6631	= { FOLLOW_COMMA_in_bvTerm6631_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6633  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6633_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6633	= { FOLLOW_formula_in_bvTerm6633_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6636  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6636_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6636	= { FOLLOW_RPAREN_in_bvTerm6636_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVLSHR_TOK_in_bvTerm6654  */
static	ANTLR3_BITWORD FOLLOW_BVLSHR_TOK_in_bvTerm6654_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVLSHR_TOK_in_bvTerm6654	= { FOLLOW_BVLSHR_TOK_in_bvTerm6654_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6656  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6656_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6656	= { FOLLOW_LPAREN_in_bvTerm6656_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6658  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6658_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6658	= { FOLLOW_formula_in_bvTerm6658_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6661  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6661_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6661	= { FOLLOW_COMMA_in_bvTerm6661_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6663  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6663_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6663	= { FOLLOW_formula_in_bvTerm6663_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6666  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6666_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6666	= { FOLLOW_RPAREN_in_bvTerm6666_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SX_TOK_in_bvTerm6684  */
static	ANTLR3_BITWORD FOLLOW_SX_TOK_in_bvTerm6684_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SX_TOK_in_bvTerm6684	= { FOLLOW_SX_TOK_in_bvTerm6684_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6686  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6686_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6686	= { FOLLOW_LPAREN_in_bvTerm6686_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6688  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6688_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6688	= { FOLLOW_formula_in_bvTerm6688_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6691  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6691_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6691	= { FOLLOW_COMMA_in_bvTerm6691_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6695  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6695_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6695	= { FOLLOW_numeral_in_bvTerm6695_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6697  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6697_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6697	= { FOLLOW_RPAREN_in_bvTerm6697_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6715  */
static	ANTLR3_BITWORD FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6715_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6715	= { FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6715_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6717  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6717_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6717	= { FOLLOW_LPAREN_in_bvTerm6717_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6719  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6719_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6719	= { FOLLOW_formula_in_bvTerm6719_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6722  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6722_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6722	= { FOLLOW_COMMA_in_bvTerm6722_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6726  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6726_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6726	= { FOLLOW_numeral_in_bvTerm6726_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6728  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6728_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6728	= { FOLLOW_RPAREN_in_bvTerm6728_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVREPEAT_TOK_in_bvTerm6746  */
static	ANTLR3_BITWORD FOLLOW_BVREPEAT_TOK_in_bvTerm6746_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVREPEAT_TOK_in_bvTerm6746	= { FOLLOW_BVREPEAT_TOK_in_bvTerm6746_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6748  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6748_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6748	= { FOLLOW_LPAREN_in_bvTerm6748_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6750  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6750_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6750	= { FOLLOW_formula_in_bvTerm6750_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6753  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6753_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6753	= { FOLLOW_COMMA_in_bvTerm6753_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6757  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6757_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6757	= { FOLLOW_numeral_in_bvTerm6757_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6759  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6759_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6759	= { FOLLOW_RPAREN_in_bvTerm6759_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVROTR_TOK_in_bvTerm6777  */
static	ANTLR3_BITWORD FOLLOW_BVROTR_TOK_in_bvTerm6777_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVROTR_TOK_in_bvTerm6777	= { FOLLOW_BVROTR_TOK_in_bvTerm6777_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6779  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6779_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6779	= { FOLLOW_LPAREN_in_bvTerm6779_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6781  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6781_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6781	= { FOLLOW_formula_in_bvTerm6781_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6784  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6784_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6784	= { FOLLOW_COMMA_in_bvTerm6784_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6788  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6788_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6788	= { FOLLOW_numeral_in_bvTerm6788_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6790  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6790_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6790	= { FOLLOW_RPAREN_in_bvTerm6790_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVROTL_TOK_in_bvTerm6808  */
static	ANTLR3_BITWORD FOLLOW_BVROTL_TOK_in_bvTerm6808_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVROTL_TOK_in_bvTerm6808	= { FOLLOW_BVROTL_TOK_in_bvTerm6808_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6810  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6810_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6810	= { FOLLOW_LPAREN_in_bvTerm6810_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6812  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6812_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6812	= { FOLLOW_formula_in_bvTerm6812_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6815  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6815_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6815	= { FOLLOW_COMMA_in_bvTerm6815_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6819  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6819_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6819	= { FOLLOW_numeral_in_bvTerm6819_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6821  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6821_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6821	= { FOLLOW_RPAREN_in_bvTerm6821_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVLT_TOK_in_bvTerm6840  */
static	ANTLR3_BITWORD FOLLOW_BVLT_TOK_in_bvTerm6840_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVLT_TOK_in_bvTerm6840	= { FOLLOW_BVLT_TOK_in_bvTerm6840_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6842  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6842_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6842	= { FOLLOW_LPAREN_in_bvTerm6842_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6844  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6844_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6844	= { FOLLOW_formula_in_bvTerm6844_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6847  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6847_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6847	= { FOLLOW_COMMA_in_bvTerm6847_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6849  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6849_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6849	= { FOLLOW_formula_in_bvTerm6849_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6852  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6852_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6852	= { FOLLOW_RPAREN_in_bvTerm6852_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVLE_TOK_in_bvTerm6864  */
static	ANTLR3_BITWORD FOLLOW_BVLE_TOK_in_bvTerm6864_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVLE_TOK_in_bvTerm6864	= { FOLLOW_BVLE_TOK_in_bvTerm6864_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6866  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6866_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6866	= { FOLLOW_LPAREN_in_bvTerm6866_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6868  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6868_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6868	= { FOLLOW_formula_in_bvTerm6868_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6871  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6871_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6871	= { FOLLOW_COMMA_in_bvTerm6871_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6873  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6873_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6873	= { FOLLOW_formula_in_bvTerm6873_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6876  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6876_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6876	= { FOLLOW_RPAREN_in_bvTerm6876_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVGT_TOK_in_bvTerm6888  */
static	ANTLR3_BITWORD FOLLOW_BVGT_TOK_in_bvTerm6888_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVGT_TOK_in_bvTerm6888	= { FOLLOW_BVGT_TOK_in_bvTerm6888_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6890  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6890_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6890	= { FOLLOW_LPAREN_in_bvTerm6890_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6892  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6892_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6892	= { FOLLOW_formula_in_bvTerm6892_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6895  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6895_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6895	= { FOLLOW_COMMA_in_bvTerm6895_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6897  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6897_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6897	= { FOLLOW_formula_in_bvTerm6897_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6900  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6900_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6900	= { FOLLOW_RPAREN_in_bvTerm6900_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVGE_TOK_in_bvTerm6912  */
static	ANTLR3_BITWORD FOLLOW_BVGE_TOK_in_bvTerm6912_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVGE_TOK_in_bvTerm6912	= { FOLLOW_BVGE_TOK_in_bvTerm6912_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6914  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6914_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6914	= { FOLLOW_LPAREN_in_bvTerm6914_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6916  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6916_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6916	= { FOLLOW_formula_in_bvTerm6916_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6919  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6919_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6919	= { FOLLOW_COMMA_in_bvTerm6919_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6921  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6921_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6921	= { FOLLOW_formula_in_bvTerm6921_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6924  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6924_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6924	= { FOLLOW_RPAREN_in_bvTerm6924_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSLT_TOK_in_bvTerm6936  */
static	ANTLR3_BITWORD FOLLOW_BVSLT_TOK_in_bvTerm6936_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSLT_TOK_in_bvTerm6936	= { FOLLOW_BVSLT_TOK_in_bvTerm6936_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6938  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6938_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6938	= { FOLLOW_LPAREN_in_bvTerm6938_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6940  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6940_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6940	= { FOLLOW_formula_in_bvTerm6940_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6943  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6943_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6943	= { FOLLOW_COMMA_in_bvTerm6943_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6945  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6945_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6945	= { FOLLOW_formula_in_bvTerm6945_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6948  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6948_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6948	= { FOLLOW_RPAREN_in_bvTerm6948_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSLE_TOK_in_bvTerm6960  */
static	ANTLR3_BITWORD FOLLOW_BVSLE_TOK_in_bvTerm6960_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSLE_TOK_in_bvTerm6960	= { FOLLOW_BVSLE_TOK_in_bvTerm6960_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6962  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6962_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6962	= { FOLLOW_LPAREN_in_bvTerm6962_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6964  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6964_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6964	= { FOLLOW_formula_in_bvTerm6964_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6967  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6967_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6967	= { FOLLOW_COMMA_in_bvTerm6967_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6969  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6969_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6969	= { FOLLOW_formula_in_bvTerm6969_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6972  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6972_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6972	= { FOLLOW_RPAREN_in_bvTerm6972_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSGT_TOK_in_bvTerm6984  */
static	ANTLR3_BITWORD FOLLOW_BVSGT_TOK_in_bvTerm6984_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSGT_TOK_in_bvTerm6984	= { FOLLOW_BVSGT_TOK_in_bvTerm6984_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6986  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6986_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6986	= { FOLLOW_LPAREN_in_bvTerm6986_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6988  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6988_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6988	= { FOLLOW_formula_in_bvTerm6988_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6991  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6991_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6991	= { FOLLOW_COMMA_in_bvTerm6991_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6993  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6993_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6993	= { FOLLOW_formula_in_bvTerm6993_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6996  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6996_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6996	= { FOLLOW_RPAREN_in_bvTerm6996_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSGE_TOK_in_bvTerm7008  */
static	ANTLR3_BITWORD FOLLOW_BVSGE_TOK_in_bvTerm7008_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSGE_TOK_in_bvTerm7008	= { FOLLOW_BVSGE_TOK_in_bvTerm7008_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm7010  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm7010_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm7010	= { FOLLOW_LPAREN_in_bvTerm7010_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7012  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7012_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7012	= { FOLLOW_formula_in_bvTerm7012_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm7015  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm7015_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm7015	= { FOLLOW_COMMA_in_bvTerm7015_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7017  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7017_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7017	= { FOLLOW_formula_in_bvTerm7017_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm7020  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm7020_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm7020	= { FOLLOW_RPAREN_in_bvTerm7020_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_stringTerm_in_bvTerm7032  */
static	ANTLR3_BITWORD FOLLOW_stringTerm_in_bvTerm7032_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_stringTerm_in_bvTerm7032	= { FOLLOW_stringTerm_in_bvTerm7032_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_CONCAT_TOK_in_stringTerm7058  */
static	ANTLR3_BITWORD FOLLOW_STRING_CONCAT_TOK_in_stringTerm7058_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_CONCAT_TOK_in_stringTerm7058	= { FOLLOW_STRING_CONCAT_TOK_in_stringTerm7058_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7060  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7060_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7060	= { FOLLOW_LPAREN_in_stringTerm7060_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7062  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7062_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7062	= { FOLLOW_formula_in_stringTerm7062_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7073  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7073_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7073	= { FOLLOW_COMMA_in_stringTerm7073_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7075  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7075_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7075	= { FOLLOW_formula_in_stringTerm7075_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7083  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7083_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7083	= { FOLLOW_RPAREN_in_stringTerm7083_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_LENGTH_TOK_in_stringTerm7095  */
static	ANTLR3_BITWORD FOLLOW_STRING_LENGTH_TOK_in_stringTerm7095_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_LENGTH_TOK_in_stringTerm7095	= { FOLLOW_STRING_LENGTH_TOK_in_stringTerm7095_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7097  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7097_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7097	= { FOLLOW_LPAREN_in_stringTerm7097_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7099  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7099_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7099	= { FOLLOW_formula_in_stringTerm7099_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7102  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7102_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7102	= { FOLLOW_RPAREN_in_stringTerm7102_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_CONTAINS_TOK_in_stringTerm7114  */
static	ANTLR3_BITWORD FOLLOW_STRING_CONTAINS_TOK_in_stringTerm7114_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_CONTAINS_TOK_in_stringTerm7114	= { FOLLOW_STRING_CONTAINS_TOK_in_stringTerm7114_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7116  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7116_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7116	= { FOLLOW_LPAREN_in_stringTerm7116_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7118  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7118_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7118	= { FOLLOW_formula_in_stringTerm7118_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7121  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7121_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7121	= { FOLLOW_COMMA_in_stringTerm7121_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7123  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7123_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7123	= { FOLLOW_formula_in_stringTerm7123_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7126  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7126_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7126	= { FOLLOW_RPAREN_in_stringTerm7126_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_SUBSTR_TOK_in_stringTerm7138  */
static	ANTLR3_BITWORD FOLLOW_STRING_SUBSTR_TOK_in_stringTerm7138_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_SUBSTR_TOK_in_stringTerm7138	= { FOLLOW_STRING_SUBSTR_TOK_in_stringTerm7138_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7140  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7140_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7140	= { FOLLOW_LPAREN_in_stringTerm7140_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7142  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7142_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7142	= { FOLLOW_formula_in_stringTerm7142_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7145  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7145_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7145	= { FOLLOW_COMMA_in_stringTerm7145_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7147  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7147_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7147	= { FOLLOW_formula_in_stringTerm7147_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7150  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7150_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7150	= { FOLLOW_COMMA_in_stringTerm7150_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7152  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7152_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7152	= { FOLLOW_formula_in_stringTerm7152_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7155  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7155_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7155	= { FOLLOW_RPAREN_in_stringTerm7155_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_INDEXOF_TOK_in_stringTerm7167  */
static	ANTLR3_BITWORD FOLLOW_STRING_INDEXOF_TOK_in_stringTerm7167_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_INDEXOF_TOK_in_stringTerm7167	= { FOLLOW_STRING_INDEXOF_TOK_in_stringTerm7167_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7169  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7169_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7169	= { FOLLOW_LPAREN_in_stringTerm7169_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7171  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7171_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7171	= { FOLLOW_formula_in_stringTerm7171_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7174  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7174_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7174	= { FOLLOW_COMMA_in_stringTerm7174_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7176  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7176_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7176	= { FOLLOW_formula_in_stringTerm7176_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7179  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7179_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7179	= { FOLLOW_COMMA_in_stringTerm7179_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7181  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7181_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7181	= { FOLLOW_formula_in_stringTerm7181_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7184  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7184_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7184	= { FOLLOW_RPAREN_in_stringTerm7184_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_REPLACE_TOK_in_stringTerm7196  */
static	ANTLR3_BITWORD FOLLOW_STRING_REPLACE_TOK_in_stringTerm7196_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_REPLACE_TOK_in_stringTerm7196	= { FOLLOW_STRING_REPLACE_TOK_in_stringTerm7196_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7198  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7198_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7198	= { FOLLOW_LPAREN_in_stringTerm7198_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7200  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7200_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7200	= { FOLLOW_formula_in_stringTerm7200_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7203  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7203_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7203	= { FOLLOW_COMMA_in_stringTerm7203_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7205  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7205_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7205	= { FOLLOW_formula_in_stringTerm7205_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7208  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7208_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7208	= { FOLLOW_COMMA_in_stringTerm7208_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7210  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7210_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7210	= { FOLLOW_formula_in_stringTerm7210_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7213  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7213_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7213	= { FOLLOW_RPAREN_in_stringTerm7213_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_PREFIXOF_TOK_in_stringTerm7225  */
static	ANTLR3_BITWORD FOLLOW_STRING_PREFIXOF_TOK_in_stringTerm7225_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_PREFIXOF_TOK_in_stringTerm7225	= { FOLLOW_STRING_PREFIXOF_TOK_in_stringTerm7225_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7227  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7227_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7227	= { FOLLOW_LPAREN_in_stringTerm7227_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7229  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7229_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7229	= { FOLLOW_formula_in_stringTerm7229_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7232  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7232_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7232	= { FOLLOW_COMMA_in_stringTerm7232_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7234  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7234_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7234	= { FOLLOW_formula_in_stringTerm7234_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7237  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7237_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7237	= { FOLLOW_RPAREN_in_stringTerm7237_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_SUFFIXOF_TOK_in_stringTerm7249  */
static	ANTLR3_BITWORD FOLLOW_STRING_SUFFIXOF_TOK_in_stringTerm7249_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_SUFFIXOF_TOK_in_stringTerm7249	= { FOLLOW_STRING_SUFFIXOF_TOK_in_stringTerm7249_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7251  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7251_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7251	= { FOLLOW_LPAREN_in_stringTerm7251_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7253  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7253_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7253	= { FOLLOW_formula_in_stringTerm7253_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7256  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7256_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7256	= { FOLLOW_COMMA_in_stringTerm7256_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7258  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7258_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7258	= { FOLLOW_formula_in_stringTerm7258_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7261  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7261_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7261	= { FOLLOW_RPAREN_in_stringTerm7261_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_STOI_TOK_in_stringTerm7273  */
static	ANTLR3_BITWORD FOLLOW_STRING_STOI_TOK_in_stringTerm7273_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_STOI_TOK_in_stringTerm7273	= { FOLLOW_STRING_STOI_TOK_in_stringTerm7273_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7275  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7275_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7275	= { FOLLOW_LPAREN_in_stringTerm7275_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7277  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7277_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7277	= { FOLLOW_formula_in_stringTerm7277_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7280  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7280_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7280	= { FOLLOW_RPAREN_in_stringTerm7280_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_ITOS_TOK_in_stringTerm7292  */
static	ANTLR3_BITWORD FOLLOW_STRING_ITOS_TOK_in_stringTerm7292_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_ITOS_TOK_in_stringTerm7292	= { FOLLOW_STRING_ITOS_TOK_in_stringTerm7292_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7294  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7294_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7294	= { FOLLOW_LPAREN_in_stringTerm7294_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7296  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7296_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7296	= { FOLLOW_formula_in_stringTerm7296_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7299  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7299_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7299	= { FOLLOW_RPAREN_in_stringTerm7299_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_U16TOS_TOK_in_stringTerm7311  */
static	ANTLR3_BITWORD FOLLOW_STRING_U16TOS_TOK_in_stringTerm7311_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_U16TOS_TOK_in_stringTerm7311	= { FOLLOW_STRING_U16TOS_TOK_in_stringTerm7311_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7313  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7313_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7313	= { FOLLOW_LPAREN_in_stringTerm7313_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7315  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7315_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7315	= { FOLLOW_formula_in_stringTerm7315_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7318  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7318_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7318	= { FOLLOW_RPAREN_in_stringTerm7318_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_STOU16_TOK_in_stringTerm7330  */
static	ANTLR3_BITWORD FOLLOW_STRING_STOU16_TOK_in_stringTerm7330_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_STOU16_TOK_in_stringTerm7330	= { FOLLOW_STRING_STOU16_TOK_in_stringTerm7330_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7332  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7332_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7332	= { FOLLOW_LPAREN_in_stringTerm7332_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7334  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7334_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7334	= { FOLLOW_formula_in_stringTerm7334_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7337  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7337_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7337	= { FOLLOW_RPAREN_in_stringTerm7337_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_U32TOS_TOK_in_stringTerm7349  */
static	ANTLR3_BITWORD FOLLOW_STRING_U32TOS_TOK_in_stringTerm7349_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_U32TOS_TOK_in_stringTerm7349	= { FOLLOW_STRING_U32TOS_TOK_in_stringTerm7349_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7351  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7351_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7351	= { FOLLOW_LPAREN_in_stringTerm7351_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7353  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7353_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7353	= { FOLLOW_formula_in_stringTerm7353_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7356  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7356_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7356	= { FOLLOW_RPAREN_in_stringTerm7356_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_STOU32_TOK_in_stringTerm7368  */
static	ANTLR3_BITWORD FOLLOW_STRING_STOU32_TOK_in_stringTerm7368_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_STOU32_TOK_in_stringTerm7368	= { FOLLOW_STRING_STOU32_TOK_in_stringTerm7368_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7370  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7370_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7370	= { FOLLOW_LPAREN_in_stringTerm7370_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7372  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7372_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7372	= { FOLLOW_formula_in_stringTerm7372_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7375  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7375_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7375	= { FOLLOW_RPAREN_in_stringTerm7375_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_stringTerm7398  */
static	ANTLR3_BITWORD FOLLOW_str_in_stringTerm7398_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_stringTerm7398	= { FOLLOW_str_in_stringTerm7398_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_setsTerm_in_stringTerm7412  */
static	ANTLR3_BITWORD FOLLOW_setsTerm_in_stringTerm7412_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_setsTerm_in_stringTerm7412	= { FOLLOW_setsTerm_in_stringTerm7412_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SETS_CARD_TOK_in_setsTerm7440  */
static	ANTLR3_BITWORD FOLLOW_SETS_CARD_TOK_in_setsTerm7440_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SETS_CARD_TOK_in_setsTerm7440	= { FOLLOW_SETS_CARD_TOK_in_setsTerm7440_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_setsTerm7442  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_setsTerm7442_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_setsTerm7442	= { FOLLOW_LPAREN_in_setsTerm7442_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_setsTerm7444  */
static	ANTLR3_BITWORD FOLLOW_formula_in_setsTerm7444_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_setsTerm7444	= { FOLLOW_formula_in_setsTerm7444_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_setsTerm7447  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_setsTerm7447_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_setsTerm7447	= { FOLLOW_RPAREN_in_setsTerm7447_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleTerm_in_setsTerm7459  */
static	ANTLR3_BITWORD FOLLOW_simpleTerm_in_setsTerm7459_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleTerm_in_setsTerm7459	= { FOLLOW_simpleTerm_in_setsTerm7459_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_iteTerm_in_simpleTerm7490  */
static	ANTLR3_BITWORD FOLLOW_iteTerm_in_simpleTerm7490_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_iteTerm_in_simpleTerm7490	= { FOLLOW_iteTerm_in_simpleTerm7490_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_simpleTerm7513  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_simpleTerm7513_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_simpleTerm7513	= { FOLLOW_LPAREN_in_simpleTerm7513_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm7515  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm7515_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm7515	= { FOLLOW_formula_in_simpleTerm7515_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_simpleTerm7526  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_simpleTerm7526_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_simpleTerm7526	= { FOLLOW_COMMA_in_simpleTerm7526_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm7528  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm7528_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm7528	= { FOLLOW_formula_in_simpleTerm7528_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_simpleTerm7536  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_simpleTerm7536_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_simpleTerm7536	= { FOLLOW_RPAREN_in_simpleTerm7536_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_simpleTerm7559  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_simpleTerm7559_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_simpleTerm7559	= { FOLLOW_LPAREN_in_simpleTerm7559_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_simpleTerm7561  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_simpleTerm7561_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_simpleTerm7561	= { FOLLOW_RPAREN_in_simpleTerm7561_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PARENHASH_in_simpleTerm7605  */
static	ANTLR3_BITWORD FOLLOW_PARENHASH_in_simpleTerm7605_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PARENHASH_in_simpleTerm7605	= { FOLLOW_PARENHASH_in_simpleTerm7605_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HASHPAREN_in_simpleTerm7607  */
static	ANTLR3_BITWORD FOLLOW_HASHPAREN_in_simpleTerm7607_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HASHPAREN_in_simpleTerm7607	= { FOLLOW_HASHPAREN_in_simpleTerm7607_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACE_in_simpleTerm7625  */
static	ANTLR3_BITWORD FOLLOW_LBRACE_in_simpleTerm7625_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACE_in_simpleTerm7625	= { FOLLOW_LBRACE_in_simpleTerm7625_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACE_in_simpleTerm7627  */
static	ANTLR3_BITWORD FOLLOW_RBRACE_in_simpleTerm7627_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACE_in_simpleTerm7627	= { FOLLOW_RBRACE_in_simpleTerm7627_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNIVSET_TOK_in_simpleTerm7639  */
static	ANTLR3_BITWORD FOLLOW_UNIVSET_TOK_in_simpleTerm7639_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_UNIVSET_TOK_in_simpleTerm7639	= { FOLLOW_UNIVSET_TOK_in_simpleTerm7639_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACE_in_simpleTerm7658  */
static	ANTLR3_BITWORD FOLLOW_LBRACE_in_simpleTerm7658_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACE_in_simpleTerm7658	= { FOLLOW_LBRACE_in_simpleTerm7658_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm7660  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm7660_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm7660	= { FOLLOW_formula_in_simpleTerm7660_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_simpleTerm7671  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_simpleTerm7671_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_simpleTerm7671	= { FOLLOW_COMMA_in_simpleTerm7671_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm7673  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm7673_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm7673	= { FOLLOW_formula_in_simpleTerm7673_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACE_in_simpleTerm7681  */
static	ANTLR3_BITWORD FOLLOW_RBRACE_in_simpleTerm7681_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACE_in_simpleTerm7681	= { FOLLOW_RBRACE_in_simpleTerm7681_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_simpleTerm7700  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_simpleTerm7700_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_simpleTerm7700	= { FOLLOW_BAR_in_simpleTerm7700_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_simpleTerm7702  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_simpleTerm7702_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_simpleTerm7702	= { FOLLOW_BAR_in_simpleTerm7702_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm7704  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm7704_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm7704	= { FOLLOW_formula_in_simpleTerm7704_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_simpleTerm7709  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_simpleTerm7709_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_simpleTerm7709	= { FOLLOW_BAR_in_simpleTerm7709_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_simpleTerm7711  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_simpleTerm7711_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_simpleTerm7711	= { FOLLOW_BAR_in_simpleTerm7711_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARRAY_TOK_in_simpleTerm7730  */
static	ANTLR3_BITWORD FOLLOW_ARRAY_TOK_in_simpleTerm7730_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARRAY_TOK_in_simpleTerm7730	= { FOLLOW_ARRAY_TOK_in_simpleTerm7730_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_simpleTerm7734  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_simpleTerm7734_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_simpleTerm7734	= { FOLLOW_LPAREN_in_simpleTerm7734_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_simpleTerm7740  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_simpleTerm7740_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_simpleTerm7740	= { FOLLOW_restrictedType_in_simpleTerm7740_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OF_TOK_in_simpleTerm7743  */
static	ANTLR3_BITWORD FOLLOW_OF_TOK_in_simpleTerm7743_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_OF_TOK_in_simpleTerm7743	= { FOLLOW_OF_TOK_in_simpleTerm7743_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_simpleTerm7745  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_simpleTerm7745_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_simpleTerm7745	= { FOLLOW_restrictedType_in_simpleTerm7745_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_simpleTerm7752  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_simpleTerm7752_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_simpleTerm7752	= { FOLLOW_RPAREN_in_simpleTerm7752_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_simpleTerm7754  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_simpleTerm7754_bits[]	= { ANTLR3_UINT64_LIT(0x400000000000C100), ANTLR3_UINT64_LIT(0x1081130002000000), ANTLR3_UINT64_LIT(0x1100000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_simpleTerm7754	= { FOLLOW_COLON_in_simpleTerm7754_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleTerm_in_simpleTerm7756  */
static	ANTLR3_BITWORD FOLLOW_simpleTerm_in_simpleTerm7756_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleTerm_in_simpleTerm7756	= { FOLLOW_simpleTerm_in_simpleTerm7756_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRUE_TOK_in_simpleTerm7776  */
static	ANTLR3_BITWORD FOLLOW_TRUE_TOK_in_simpleTerm7776_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TRUE_TOK_in_simpleTerm7776	= { FOLLOW_TRUE_TOK_in_simpleTerm7776_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FALSE_TOK_in_simpleTerm7785  */
static	ANTLR3_BITWORD FOLLOW_FALSE_TOK_in_simpleTerm7785_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FALSE_TOK_in_simpleTerm7785	= { FOLLOW_FALSE_TOK_in_simpleTerm7785_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_simpleTerm7805  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_simpleTerm7805_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_simpleTerm7805	= { FOLLOW_DECIMAL_LITERAL_in_simpleTerm7805_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleTerm7813  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleTerm7813_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleTerm7813	= { FOLLOW_INTEGER_LITERAL_in_simpleTerm7813_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_simpleTerm7827  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_simpleTerm7827_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_simpleTerm7827	= { FOLLOW_HEX_LITERAL_in_simpleTerm7827_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_simpleTerm7839  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_simpleTerm7839_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_simpleTerm7839	= { FOLLOW_BINARY_LITERAL_in_simpleTerm7839_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PARENHASH_in_simpleTerm7857  */
static	ANTLR3_BITWORD FOLLOW_PARENHASH_in_simpleTerm7857_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PARENHASH_in_simpleTerm7857	= { FOLLOW_PARENHASH_in_simpleTerm7857_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordEntry_in_simpleTerm7859  */
static	ANTLR3_BITWORD FOLLOW_recordEntry_in_simpleTerm7859_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_recordEntry_in_simpleTerm7859	= { FOLLOW_recordEntry_in_simpleTerm7859_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_simpleTerm7870  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_simpleTerm7870_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_simpleTerm7870	= { FOLLOW_COMMA_in_simpleTerm7870_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordEntry_in_simpleTerm7872  */
static	ANTLR3_BITWORD FOLLOW_recordEntry_in_simpleTerm7872_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_recordEntry_in_simpleTerm7872	= { FOLLOW_recordEntry_in_simpleTerm7872_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HASHPAREN_in_simpleTerm7880  */
static	ANTLR3_BITWORD FOLLOW_HASHPAREN_in_simpleTerm7880_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HASHPAREN_in_simpleTerm7880	= { FOLLOW_HASHPAREN_in_simpleTerm7880_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_simpleTerm7899  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_simpleTerm7899_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_simpleTerm7899	= { FOLLOW_identifier_in_simpleTerm7899_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_typeAscription7939  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_typeAscription7939_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_typeAscription7939	= { FOLLOW_COLON_in_typeAscription7939_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_typeAscription7941  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_typeAscription7941_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_typeAscription7941	= { FOLLOW_COLON_in_typeAscription7941_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_typeAscription7943  */
static	ANTLR3_BITWORD FOLLOW_type_in_typeAscription7943_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_typeAscription7943	= { FOLLOW_type_in_typeAscription7943_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_recordEntry7960  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_recordEntry7960_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_recordEntry7960	= { FOLLOW_identifier_in_recordEntry7960_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_recordEntry7963  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_recordEntry7963_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_recordEntry7963	= { FOLLOW_ASSIGN_TOK_in_recordEntry7963_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_recordEntry7965  */
static	ANTLR3_BITWORD FOLLOW_formula_in_recordEntry7965_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_recordEntry7965	= { FOLLOW_formula_in_recordEntry7965_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IF_TOK_in_iteTerm7987  */
static	ANTLR3_BITWORD FOLLOW_IF_TOK_in_iteTerm7987_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_IF_TOK_in_iteTerm7987	= { FOLLOW_IF_TOK_in_iteTerm7987_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteTerm7989  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteTerm7989_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0008000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteTerm7989	= { FOLLOW_formula_in_iteTerm7989_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_THEN_TOK_in_iteTerm7998  */
static	ANTLR3_BITWORD FOLLOW_THEN_TOK_in_iteTerm7998_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_THEN_TOK_in_iteTerm7998	= { FOLLOW_THEN_TOK_in_iteTerm7998_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteTerm8000  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteTerm8000_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000030000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteTerm8000	= { FOLLOW_formula_in_iteTerm8000_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_iteElseTerm_in_iteTerm8009  */
static	ANTLR3_BITWORD FOLLOW_iteElseTerm_in_iteTerm8009_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_iteElseTerm_in_iteTerm8009	= { FOLLOW_iteElseTerm_in_iteTerm8009_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ENDIF_TOK_in_iteTerm8018  */
static	ANTLR3_BITWORD FOLLOW_ENDIF_TOK_in_iteTerm8018_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ENDIF_TOK_in_iteTerm8018	= { FOLLOW_ENDIF_TOK_in_iteTerm8018_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ELSE_TOK_in_iteElseTerm8045  */
static	ANTLR3_BITWORD FOLLOW_ELSE_TOK_in_iteElseTerm8045_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_ELSE_TOK_in_iteElseTerm8045	= { FOLLOW_ELSE_TOK_in_iteElseTerm8045_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteElseTerm8047  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteElseTerm8047_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteElseTerm8047	= { FOLLOW_formula_in_iteElseTerm8047_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ELSEIF_TOK_in_iteElseTerm8054  */
static	ANTLR3_BITWORD FOLLOW_ELSEIF_TOK_in_iteElseTerm8054_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_ELSEIF_TOK_in_iteElseTerm8054	= { FOLLOW_ELSEIF_TOK_in_iteElseTerm8054_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteElseTerm8060  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteElseTerm8060_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0008000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteElseTerm8060	= { FOLLOW_formula_in_iteElseTerm8060_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_THEN_TOK_in_iteElseTerm8069  */
static	ANTLR3_BITWORD FOLLOW_THEN_TOK_in_iteElseTerm8069_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x13A4DFFF08000042) };
static  ANTLR3_BITSET_LIST FOLLOW_THEN_TOK_in_iteElseTerm8069	= { FOLLOW_THEN_TOK_in_iteElseTerm8069_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteElseTerm8075  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteElseTerm8075_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000030000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteElseTerm8075	= { FOLLOW_formula_in_iteElseTerm8075_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_iteElseTerm_in_iteElseTerm8088  */
static	ANTLR3_BITWORD FOLLOW_iteElseTerm_in_iteElseTerm8088_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_iteElseTerm_in_iteElseTerm8088	= { FOLLOW_iteElseTerm_in_iteElseTerm8088_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatypeDef8124  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatypeDef8124_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatypeDef8124	= { FOLLOW_identifier_in_datatypeDef8124_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_datatypeDef8135  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_datatypeDef8135_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_datatypeDef8135	= { FOLLOW_LBRACKET_in_datatypeDef8135_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatypeDef8137  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatypeDef8137_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatypeDef8137	= { FOLLOW_identifier_in_datatypeDef8137_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_datatypeDef8150  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_datatypeDef8150_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_datatypeDef8150	= { FOLLOW_COMMA_in_datatypeDef8150_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatypeDef8152  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatypeDef8152_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatypeDef8152	= { FOLLOW_identifier_in_datatypeDef8152_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_datatypeDef8166  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_datatypeDef8166_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_datatypeDef8166	= { FOLLOW_RBRACKET_in_datatypeDef8166_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_datatypeDef8185  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_datatypeDef8185_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_datatypeDef8185	= { FOLLOW_EQUAL_TOK_in_datatypeDef8185_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypeDef8187  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypeDef8187_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004002) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypeDef8187	= { FOLLOW_constructorDef_in_datatypeDef8187_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_datatypeDef8196  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_datatypeDef8196_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_datatypeDef8196	= { FOLLOW_BAR_in_datatypeDef8196_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypeDef8198  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypeDef8198_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004002) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypeDef8198	= { FOLLOW_constructorDef_in_datatypeDef8198_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_constructorDef8229  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_constructorDef8229_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_constructorDef8229	= { FOLLOW_identifier_in_constructorDef8229_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_constructorDef8244  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_constructorDef8244_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_constructorDef8244	= { FOLLOW_LPAREN_in_constructorDef8244_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_selector_in_constructorDef8252  */
static	ANTLR3_BITWORD FOLLOW_selector_in_constructorDef8252_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_selector_in_constructorDef8252	= { FOLLOW_selector_in_constructorDef8252_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_constructorDef8263  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_constructorDef8263_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_constructorDef8263	= { FOLLOW_COMMA_in_constructorDef8263_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_selector_in_constructorDef8265  */
static	ANTLR3_BITWORD FOLLOW_selector_in_constructorDef8265_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_selector_in_constructorDef8265	= { FOLLOW_selector_in_constructorDef8265_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_constructorDef8277  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_constructorDef8277_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_constructorDef8277	= { FOLLOW_RPAREN_in_constructorDef8277_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_selector8309  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_selector8309_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_selector8309	= { FOLLOW_identifier_in_selector8309_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_selector8312  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_selector8312_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0002200030200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_selector8312	= { FOLLOW_COLON_in_selector8312_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_selector8314  */
static	ANTLR3_BITWORD FOLLOW_type_in_selector8314_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_selector8314	= { FOLLOW_type_in_selector8314_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_numeral8389  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_numeral8389_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_numeral8389	= { FOLLOW_INTEGER_LITERAL_in_numeral8389_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_integer8414  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_integer8414_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_integer8414	= { FOLLOW_INTEGER_LITERAL_in_integer8414_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_integer8426  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_integer8426_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_integer8426	= { FOLLOW_MINUS_TOK_in_integer8426_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_integer8428  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_integer8428_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_integer8428	= { FOLLOW_INTEGER_LITERAL_in_integer8428_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_LITERAL_in_str8450  */
static	ANTLR3_BITWORD FOLLOW_STRING_LITERAL_in_str8450_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_LITERAL_in_str8450	= { FOLLOW_STRING_LITERAL_in_str8450_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_synpred1_Cvc2018  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_synpred1_Cvc2018_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_synpred1_Cvc2018	= { FOLLOW_letDecl_in_synpred1_Cvc2018_bits, 1	};


/* ==============================================
 * Parsing rules
 */
/**
 * $ANTLR start parseExpr
 * ../../../../src/parser/cvc/Cvc.g:651:1: parseExpr returns [CVC4::Expr expr = CVC4::Expr()] : ( formula[expr] | EOF );
 */
static CVC4::Expr
parseExpr(pCvcParser ctx)
{
    CVC4::Expr expr;


    /* Initialize rule variables
     */
    expr =  CVC4::Expr();


    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:652:3: ( formula[expr] | EOF )

            ANTLR3_UINT32 alt1;

            alt1=2;

            switch ( LA(1) )
            {
            case ABS_TOK:
            case ARRAY_TOK:
            case BAR:
            case BINARY_LITERAL:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVGE_TOK:
            case BVGT_TOK:
            case BVLE_TOK:
            case BVLSHR_TOK:
            case BVLT_TOK:
            case BVMULT_TOK:
            case BVNAND_TOK:
            case BVNEG_TOK:
            case BVNOR_TOK:
            case BVPLUS_TOK:
            case BVREPEAT_TOK:
            case BVROTL_TOK:
            case BVROTR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUMINUS_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case BVZEROEXTEND_TOK:
            case DECIMAL_LITERAL:
            case DISTINCT_TOK:
            case DIVISIBLE_TOK:
            case EXISTS_TOK:
            case FALSE_TOK:
            case FLOOR_TOK:
            case FORALL_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IDEN_TOK:
            case IF_TOK:
            case INTEGER_LITERAL:
            case IS_INTEGER_TOK:
            case LAMBDA:
            case LBRACE:
            case LET_TOK:
            case LPAREN:
            case MINUS_TOK:
            case NOT_TOK:
            case PARENHASH:
            case SETS_CARD_TOK:
            case STRING_CONCAT_TOK:
            case STRING_CONTAINS_TOK:
            case STRING_INDEXOF_TOK:
            case STRING_ITOS_TOK:
            case STRING_LENGTH_TOK:
            case STRING_LITERAL:
            case STRING_PREFIXOF_TOK:
            case STRING_REPLACE_TOK:
            case STRING_STOI_TOK:
            case STRING_STOU16_TOK:
            case STRING_STOU32_TOK:
            case STRING_SUBSTR_TOK:
            case STRING_SUFFIXOF_TOK:
            case STRING_U16TOS_TOK:
            case STRING_U32TOS_TOK:
            case SX_TOK:
            case TRANSCLOSURE_TOK:
            case TRANSPOSE_TOK:
            case TRUE_TOK:
            case TUPLE_TOK:
            case UNIVSET_TOK:
            	{
            		alt1=1;
            	}
                break;
            case EOF:
            	{
            		alt1=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return expr;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 1;
                EXCEPTION->state        = 0;


                goto ruleparseExprEx;

            }

            switch (alt1)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:652:5: formula[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_formula_in_parseExpr1820);
        	        formula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return expr;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:653:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseExpr1827);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return expr;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseExprEx; /* Prevent compiler warnings */
    ruleparseExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return expr;
}
/* $ANTLR end parseExpr */

/**
 * $ANTLR start parseCommand
 * ../../../../src/parser/cvc/Cvc.g:660:1: parseCommand returns [CVC4::Command* cmd_return = NULL] : (c= command[&cmd] | LPAREN IDENTIFIER | EOF );
 */
static CVC4::Command*
parseCommand(pCvcParser ctx)
{
    CVC4::Command* cmd_return;



        CVC4::PtrCloser<CVC4::Command> cmd;

    pANTLR3_COMMON_TOKEN    IDENTIFIER1;

    /* Initialize rule variables
     */
    cmd_return =  NULL;


    IDENTIFIER1       = NULL;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:667:3: (c= command[&cmd] | LPAREN IDENTIFIER | EOF )

            ANTLR3_UINT32 alt2;

            alt2=3;

            switch ( LA(1) )
            {
            case ARITH_VAR_ORDER_TOK:
            case ASSERTIONS_TOK:
            case ASSERT_TOK:
            case ASSUMPTIONS_TOK:
            case CALL_TOK:
            case CHECKSAT_TOK:
            case CHECK_TYPE_TOK:
            case CONTEXT_TOK:
            case CONTINUE_TOK:
            case COUNTEREXAMPLE_TOK:
            case COUNTERMODEL_TOK:
            case DATATYPE_TOK:
            case DBG_TOK:
            case DUMP_ASSUMPTIONS_TOK:
            case DUMP_CLOSURE_PROOF_TOK:
            case DUMP_CLOSURE_TOK:
            case DUMP_PROOF_TOK:
            case DUMP_SIG_TOK:
            case DUMP_TCC_ASSUMPTIONS_TOK:
            case DUMP_TCC_PROOF_TOK:
            case DUMP_TCC_TOK:
            case DUMP_UNSAT_CORE_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case FORGET_TOK:
            case GET_CHILD_TOK:
            case GET_OP_TOK:
            case GET_TYPE_TOK:
            case GET_VALUE_TOK:
            case HELP_TOK:
            case IDENTIFIER:
            case INCLUDE_TOK:
            case LET_TOK:
            case OPTION_TOK:
            case POPTO_SCOPE_TOK:
            case POPTO_TOK:
            case POP_SCOPE_TOK:
            case POP_TOK:
            case PRINT_TOK:
            case PRINT_TYPE_TOK:
            case PUSH_SCOPE_TOK:
            case PUSH_TOK:
            case QUERY_TOK:
            case RESET_TOK:
            case RESTART_TOK:
            case SEMICOLON:
            case SUBSTITUTE_TOK:
            case TRACE_TOK:
            case TRANSFORM_TOK:
            case UNTRACE_TOK:
            case WHERE_TOK:
            	{
            		alt2=1;
            	}
                break;
            case LPAREN:
            	{
            		alt2=2;
            	}
                break;
            case EOF:
            	{
            		alt2=3;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return cmd_return;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 2;
                EXCEPTION->state        = 0;


                goto ruleparseCommandEx;

            }

            switch (alt2)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:667:5: c= command[&cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_command_in_parseCommand1858);
        	        command(ctx, &cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd_return;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:668:5: LPAREN IDENTIFIER
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_parseCommand1865);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd_return;
        	        }


        	        IDENTIFIER1 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_parseCommand1867);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd_return;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::string s = AntlrInput::tokenText(IDENTIFIER1);
        	                if(s == "benchmark") {
        	                    PARSER_STATE->parseError(
        	                        "In CVC4 presentation language mode, but SMT-LIBv1 format "
        	                        "detected.  Use --lang smt1 for SMT-LIBv1 support.");
        	                  } else if(s == "set" || s == "get" || s == "declare" ||
        	                            s == "define" || s == "assert") {
        	                    PARSER_STATE->parseError(
        	                        "In CVC4 presentation language mode, but SMT-LIB format detected. "
        	                        "Use --lang smt for SMT-LIB support.");
        	                  } else {
        	                    PARSER_STATE->parseError(
        	                        "A CVC4 presentation language command cannot begin with a "
        	                        "parenthesis; expected command name.");
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:685:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseCommand1879);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd_return;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseCommandEx; /* Prevent compiler warnings */
    ruleparseCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
            else
            {
                {

                        cmd_return = cmd.release();

                }
            }


    return cmd_return;
}
/* $ANTLR end parseCommand */

/**
 * $ANTLR start command
 * ../../../../src/parser/cvc/Cvc.g:692:1: command[CVC4::PtrCloser<CVC4::Command>* cmd] : ( ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd] ) | IDENTIFIER SEMICOLON );
 */
static void
command(pCvcParser ctx, CVC4::PtrCloser<CVC4::Command>* cmd)
{
    pANTLR3_COMMON_TOKEN    IDENTIFIER2;

    /* Initialize rule variables
     */

    IDENTIFIER2       = NULL;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:693:3: ( ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd] ) | IDENTIFIER SEMICOLON )

            ANTLR3_UINT32 alt5;

            alt5=2;

            switch ( LA(1) )
            {
            case ARITH_VAR_ORDER_TOK:
            case ASSERTIONS_TOK:
            case ASSERT_TOK:
            case ASSUMPTIONS_TOK:
            case CALL_TOK:
            case CHECKSAT_TOK:
            case CHECK_TYPE_TOK:
            case CONTEXT_TOK:
            case CONTINUE_TOK:
            case COUNTEREXAMPLE_TOK:
            case COUNTERMODEL_TOK:
            case DATATYPE_TOK:
            case DBG_TOK:
            case DUMP_ASSUMPTIONS_TOK:
            case DUMP_CLOSURE_PROOF_TOK:
            case DUMP_CLOSURE_TOK:
            case DUMP_PROOF_TOK:
            case DUMP_SIG_TOK:
            case DUMP_TCC_ASSUMPTIONS_TOK:
            case DUMP_TCC_PROOF_TOK:
            case DUMP_TCC_TOK:
            case DUMP_UNSAT_CORE_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case FORGET_TOK:
            case GET_CHILD_TOK:
            case GET_OP_TOK:
            case GET_TYPE_TOK:
            case GET_VALUE_TOK:
            case HELP_TOK:
            case INCLUDE_TOK:
            case LET_TOK:
            case OPTION_TOK:
            case POPTO_SCOPE_TOK:
            case POPTO_TOK:
            case POP_SCOPE_TOK:
            case POP_TOK:
            case PRINT_TOK:
            case PRINT_TYPE_TOK:
            case PUSH_SCOPE_TOK:
            case PUSH_TOK:
            case QUERY_TOK:
            case RESET_TOK:
            case RESTART_TOK:
            case SEMICOLON:
            case SUBSTITUTE_TOK:
            case TRACE_TOK:
            case TRANSFORM_TOK:
            case UNTRACE_TOK:
            case WHERE_TOK:
            	{
            		alt5=1;
            	}
                break;
            case IDENTIFIER:
            	{
            		switch ( LA(2) )
            		{
            		case SEMICOLON:
            			{
            				alt5=2;
            			}
            		    break;
            		case COLON:
            		case COMMA:
            			{
            				alt5=1;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 5;
            		    EXCEPTION->state        = 41;


            		    goto rulecommandEx;

            		}

            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 5;
                EXCEPTION->state        = 0;


                goto rulecommandEx;

            }

            switch (alt5)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:693:5: ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd] )
        	    {
        	        // ../../../../src/parser/cvc/Cvc.g:693:5: ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd] )
        	        {
        	            int alt4=3;
        	            switch ( LA(1) )
        	            {
        	            case ARITH_VAR_ORDER_TOK:
        	            case ASSERTIONS_TOK:
        	            case ASSERT_TOK:
        	            case ASSUMPTIONS_TOK:
        	            case CALL_TOK:
        	            case CHECKSAT_TOK:
        	            case CHECK_TYPE_TOK:
        	            case CONTEXT_TOK:
        	            case CONTINUE_TOK:
        	            case COUNTEREXAMPLE_TOK:
        	            case COUNTERMODEL_TOK:
        	            case DATATYPE_TOK:
        	            case DBG_TOK:
        	            case DUMP_ASSUMPTIONS_TOK:
        	            case DUMP_CLOSURE_PROOF_TOK:
        	            case DUMP_CLOSURE_TOK:
        	            case DUMP_PROOF_TOK:
        	            case DUMP_SIG_TOK:
        	            case DUMP_TCC_ASSUMPTIONS_TOK:
        	            case DUMP_TCC_PROOF_TOK:
        	            case DUMP_TCC_TOK:
        	            case DUMP_UNSAT_CORE_TOK:
        	            case ECHO_TOK:
        	            case EXIT_TOK:
        	            case FORGET_TOK:
        	            case GET_CHILD_TOK:
        	            case GET_OP_TOK:
        	            case GET_TYPE_TOK:
        	            case GET_VALUE_TOK:
        	            case HELP_TOK:
        	            case IDENTIFIER:
        	            case INCLUDE_TOK:
        	            case OPTION_TOK:
        	            case POPTO_SCOPE_TOK:
        	            case POPTO_TOK:
        	            case POP_SCOPE_TOK:
        	            case POP_TOK:
        	            case PRINT_TOK:
        	            case PRINT_TYPE_TOK:
        	            case PUSH_SCOPE_TOK:
        	            case PUSH_TOK:
        	            case QUERY_TOK:
        	            case RESET_TOK:
        	            case RESTART_TOK:
        	            case SUBSTITUTE_TOK:
        	            case TRACE_TOK:
        	            case TRANSFORM_TOK:
        	            case UNTRACE_TOK:
        	            case WHERE_TOK:
        	            	{
        	            		alt4=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt4=2;
        	            	}
        	                break;
        	            case LET_TOK:
        	            	{
        	            		alt4=3;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 4;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt4)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:693:7: mainCommand[cmd] SEMICOLON
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_mainCommand_in_command1898);
        	        	        mainCommand(ctx, cmd);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	         MATCHT(SEMICOLON, &FOLLOW_SEMICOLON_in_command1901);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:694:7: SEMICOLON
        	        	    {
        	        	         MATCHT(SEMICOLON, &FOLLOW_SEMICOLON_in_command1909);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // ../../../../src/parser/cvc/Cvc.g:695:7: LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd]
        	        	    {
        	        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_command1917);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->pushScope(); 
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_typeOrVarLetDecl_in_command1927);
        	        	        typeOrVarLetDecl(ctx, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        // ../../../../src/parser/cvc/Cvc.g:696:40: ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )*

        	        	        for (;;)
        	        	        {
        	        	            int alt3=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case COMMA:
        	        	            	{
        	        	            		alt3=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt3)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:697:11: COMMA typeOrVarLetDecl[CHECK_DECLARED]
        	        	        	    {
        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_command1942);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulecommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_typeOrVarLetDecl_in_command1944);
        	        	        	        typeOrVarLetDecl(ctx, CHECK_DECLARED);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulecommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop3;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop3: ; /* Jump out to here if this rule does not match */


        	        	         MATCHT(IN_TOK, &FOLLOW_IN_TOK_in_command1956);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_command_in_command1958);
        	        	        command(ctx, cmd);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->popScope(); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             if(!(*cmd)) {
        	                    cmd->reset(new EmptyCommand());
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:705:5: IDENTIFIER SEMICOLON
        	    {
        	        IDENTIFIER2 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_command1985);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(SEMICOLON, &FOLLOW_SEMICOLON_in_command1987);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::stringstream ss;
        	                  ss << "Unrecognized command `"
        	                     << AntlrInput::tokenText(IDENTIFIER2)
        	                     << "'";
        	                  PARSER_STATE->parseError(ss.str());
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulecommandEx; /* Prevent compiler warnings */
    rulecommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end command */

/**
 * $ANTLR start typeOrVarLetDecl
 * ../../../../src/parser/cvc/Cvc.g:714:1: typeOrVarLetDecl[CVC4::parser::DeclarationCheck check] options {backtrack=true; } : ( letDecl | typeLetDecl[check] );
 */
static void
typeOrVarLetDecl(pCvcParser ctx, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:716:3: ( letDecl | typeLetDecl[check] )

            ANTLR3_UINT32 alt6;

            alt6=2;

            switch ( LA(1) )
            {
            case IDENTIFIER:
            	{
            		switch ( LA(2) )
            		{
            		case EQUAL_TOK:
            			{
            				switch ( LA(3) )
            				{
            				case ABS_TOK:
            				case BAR:
            				case BINARY_LITERAL:
            				case BVASHR_TOK:
            				case BVCOMP_TOK:
            				case BVGE_TOK:
            				case BVGT_TOK:
            				case BVLE_TOK:
            				case BVLSHR_TOK:
            				case BVLT_TOK:
            				case BVMULT_TOK:
            				case BVNAND_TOK:
            				case BVNEG_TOK:
            				case BVNOR_TOK:
            				case BVPLUS_TOK:
            				case BVREPEAT_TOK:
            				case BVROTL_TOK:
            				case BVROTR_TOK:
            				case BVSDIV_TOK:
            				case BVSGE_TOK:
            				case BVSGT_TOK:
            				case BVSHL_TOK:
            				case BVSLE_TOK:
            				case BVSLT_TOK:
            				case BVSMOD_TOK:
            				case BVSREM_TOK:
            				case BVSUB_TOK:
            				case BVUDIV_TOK:
            				case BVUMINUS_TOK:
            				case BVUREM_TOK:
            				case BVXNOR_TOK:
            				case BVXOR_TOK:
            				case BVZEROEXTEND_TOK:
            				case DECIMAL_LITERAL:
            				case DISTINCT_TOK:
            				case DIVISIBLE_TOK:
            				case EXISTS_TOK:
            				case FALSE_TOK:
            				case FLOOR_TOK:
            				case FORALL_TOK:
            				case HEX_LITERAL:
            				case IDEN_TOK:
            				case IF_TOK:
            				case INTEGER_LITERAL:
            				case IS_INTEGER_TOK:
            				case LAMBDA:
            				case LBRACE:
            				case LET_TOK:
            				case MINUS_TOK:
            				case NOT_TOK:
            				case PARENHASH:
            				case SETS_CARD_TOK:
            				case STRING_CONCAT_TOK:
            				case STRING_CONTAINS_TOK:
            				case STRING_INDEXOF_TOK:
            				case STRING_ITOS_TOK:
            				case STRING_LENGTH_TOK:
            				case STRING_LITERAL:
            				case STRING_PREFIXOF_TOK:
            				case STRING_REPLACE_TOK:
            				case STRING_STOI_TOK:
            				case STRING_STOU16_TOK:
            				case STRING_STOU32_TOK:
            				case STRING_SUBSTR_TOK:
            				case STRING_SUFFIXOF_TOK:
            				case STRING_U16TOS_TOK:
            				case STRING_U32TOS_TOK:
            				case SX_TOK:
            				case TRANSCLOSURE_TOK:
            				case TRANSPOSE_TOK:
            				case TRUE_TOK:
            				case TUPLE_TOK:
            				case UNIVSET_TOK:
            					{
            						alt6=1;
            					}
            				    break;
            				case LPAREN:
            					{
            						{
            						    int LA6_62 = LA(4);
            						    if ( (synpred1_Cvc(ctx)))
            						    {
            						        alt6=1;
            						    }
            						    else if ( (ANTLR3_TRUE))
            						    {
            						        alt6=2;
            						    }
            						    else
            						    {
            						        if (BACKTRACKING>0)
            						        {
            						            FAILEDFLAG = ANTLR3_TRUE;
            						            return ;
            						        }


            						        CONSTRUCTEX();
            						        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            						        EXCEPTION->message      = (void *)"";
            						        EXCEPTION->decisionNum  = 6;
            						        EXCEPTION->state        = 62;


            						        goto ruletypeOrVarLetDeclEx;

            						    }
            						}
            					}
            				    break;
            				case ARRAY_TOK:
            					{
            						{
            						    int LA6_67 = LA(4);
            						    if ( (synpred1_Cvc(ctx)))
            						    {
            						        alt6=1;
            						    }
            						    else if ( (ANTLR3_TRUE))
            						    {
            						        alt6=2;
            						    }
            						    else
            						    {
            						        if (BACKTRACKING>0)
            						        {
            						            FAILEDFLAG = ANTLR3_TRUE;
            						            return ;
            						        }


            						        CONSTRUCTEX();
            						        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            						        EXCEPTION->message      = (void *)"";
            						        EXCEPTION->decisionNum  = 6;
            						        EXCEPTION->state        = 67;


            						        goto ruletypeOrVarLetDeclEx;

            						    }
            						}
            					}
            				    break;
            				case IDENTIFIER:
            					{
            						{
            						    int LA6_74 = LA(4);
            						    if ( (synpred1_Cvc(ctx)))
            						    {
            						        alt6=1;
            						    }
            						    else if ( (ANTLR3_TRUE))
            						    {
            						        alt6=2;
            						    }
            						    else
            						    {
            						        if (BACKTRACKING>0)
            						        {
            						            FAILEDFLAG = ANTLR3_TRUE;
            						            return ;
            						        }


            						        CONSTRUCTEX();
            						        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            						        EXCEPTION->message      = (void *)"";
            						        EXCEPTION->decisionNum  = 6;
            						        EXCEPTION->state        = 74;


            						        goto ruletypeOrVarLetDeclEx;

            						    }
            						}
            					}
            				    break;
            				case BITVECTOR_TOK:
            				case BOOLEAN_TOK:
            				case INT_TOK:
            				case LBRACKET:
            				case REAL_TOK:
            				case SET_TOK:
            				case SQHASH:
            				case STRING_TOK:
            				case SUBTYPE_TOK:
            					{
            						alt6=2;
            					}
            				    break;

            				default:
            				    if (BACKTRACKING>0)
            				    {
            				        FAILEDFLAG = ANTLR3_TRUE;
            				        return ;
            				    }

            				    CONSTRUCTEX();
            				    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            				    EXCEPTION->message      = (void *)"";
            				    EXCEPTION->decisionNum  = 6;
            				    EXCEPTION->state        = 2;


            				    goto ruletypeOrVarLetDeclEx;

            				}

            			}
            		    break;
            		case COLON:
            			{
            				alt6=2;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 6;
            		    EXCEPTION->state        = 1;


            		    goto ruletypeOrVarLetDeclEx;

            		}

            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 6;
                EXCEPTION->state        = 0;


                goto ruletypeOrVarLetDeclEx;

            }

            switch (alt6)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:716:5: letDecl
        	    {
        	        FOLLOWPUSH(FOLLOW_letDecl_in_typeOrVarLetDecl2018);
        	        letDecl(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeOrVarLetDeclEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:716:15: typeLetDecl[check]
        	    {
        	        FOLLOWPUSH(FOLLOW_typeLetDecl_in_typeOrVarLetDecl2022);
        	        typeLetDecl(ctx, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeOrVarLetDeclEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletypeOrVarLetDeclEx; /* Prevent compiler warnings */
    ruletypeOrVarLetDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end typeOrVarLetDecl */

/**
 * $ANTLR start mainCommand
 * ../../../../src/parser/cvc/Cvc.g:719:1: mainCommand[CVC4::PtrCloser<CVC4::Command>* cmd] : ( ASSERT_TOK formula[f] | QUERY_TOK formula[f] | CHECKSAT_TOK ( formula[f] )? | OPTION_TOK ( str[s] | IDENTIFIER ) ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |) | PUSH_TOK (k= numeral |) | POP_TOK (k= numeral |) | POPTO_TOK (k= numeral )? | PUSH_SCOPE_TOK (k= numeral )? | POP_SCOPE_TOK (k= numeral )? | POPTO_SCOPE_TOK (k= numeral )? | RESET_TOK | RESET_TOK ASSERTIONS_TOK | DATATYPE_TOK datatypeDef[dts] ( COMMA datatypeDef[dts] )* END_TOK | CONTEXT_TOK ( ( str[s] | IDENTIFIER ) |) | FORGET_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] | GET_TYPE_TOK formula[f] | CHECK_TYPE_TOK formula[f] COLON type[t,CHECK_DECLARED] | GET_CHILD_TOK formula[f] k= numeral | GET_OP_TOK formula[f] | GET_VALUE_TOK formula[f] | SUBSTITUTE_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] EQUAL_TOK formula[f] LBRACKET identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[f] RBRACKET | DBG_TOK ( ( str[s] | IDENTIFIER ) |) | TRACE_TOK ( ( str[s] | IDENTIFIER ) |) | UNTRACE_TOK ( ( str[s] | IDENTIFIER ) |) | HELP_TOK ( ( str[s] | IDENTIFIER ) |) | TRANSFORM_TOK formula[f] | PRINT_TOK formula[f] | PRINT_TYPE_TOK type[t,CHECK_DECLARED] | CALL_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] formula[f] | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | EXIT_TOK | INCLUDE_TOK ( ( str[s] | IDENTIFIER ) |) | DUMP_PROOF_TOK | DUMP_UNSAT_CORE_TOK | ( DUMP_ASSUMPTIONS_TOK | DUMP_SIG_TOK | DUMP_TCC_TOK | DUMP_TCC_ASSUMPTIONS_TOK | DUMP_TCC_PROOF_TOK | DUMP_CLOSURE_TOK | DUMP_CLOSURE_PROOF_TOK ) | ( WHERE_TOK | ASSERTIONS_TOK | ASSUMPTIONS_TOK ) | COUNTEREXAMPLE_TOK | COUNTERMODEL_TOK | ARITH_VAR_ORDER_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN | CONTINUE_TOK | RESTART_TOK formula[f] | toplevelDeclaration[cmd] );
 */
static void
mainCommand(pCvcParser ctx, CVC4::PtrCloser<CVC4::Command>* cmd)
{
    pANTLR3_COMMON_TOKEN    IDENTIFIER3;
    pANTLR3_COMMON_TOKEN    IDENTIFIER4;
    pANTLR3_COMMON_TOKEN    IDENTIFIER5;
    pANTLR3_COMMON_TOKEN    IDENTIFIER6;
    pANTLR3_COMMON_TOKEN    IDENTIFIER7;
    pANTLR3_COMMON_TOKEN    IDENTIFIER8;
    pANTLR3_COMMON_TOKEN    IDENTIFIER9;
    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    /* Initialize rule variables
     */


      Expr f;
      SExpr sexpr;
      std::string id;
      Type t;
      std::vector<CVC4::Datatype> dts;
      Debug("parser-extra") << "command: " << AntlrInput::tokenText(LT(1)) << std::endl;
      std::string s;

    IDENTIFIER3       = NULL;
    IDENTIFIER4       = NULL;
    IDENTIFIER5       = NULL;
    IDENTIFIER6       = NULL;
    IDENTIFIER7       = NULL;
    IDENTIFIER8       = NULL;
    IDENTIFIER9       = NULL;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:730:3: ( ASSERT_TOK formula[f] | QUERY_TOK formula[f] | CHECKSAT_TOK ( formula[f] )? | OPTION_TOK ( str[s] | IDENTIFIER ) ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |) | PUSH_TOK (k= numeral |) | POP_TOK (k= numeral |) | POPTO_TOK (k= numeral )? | PUSH_SCOPE_TOK (k= numeral )? | POP_SCOPE_TOK (k= numeral )? | POPTO_SCOPE_TOK (k= numeral )? | RESET_TOK | RESET_TOK ASSERTIONS_TOK | DATATYPE_TOK datatypeDef[dts] ( COMMA datatypeDef[dts] )* END_TOK | CONTEXT_TOK ( ( str[s] | IDENTIFIER ) |) | FORGET_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] | GET_TYPE_TOK formula[f] | CHECK_TYPE_TOK formula[f] COLON type[t,CHECK_DECLARED] | GET_CHILD_TOK formula[f] k= numeral | GET_OP_TOK formula[f] | GET_VALUE_TOK formula[f] | SUBSTITUTE_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] EQUAL_TOK formula[f] LBRACKET identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[f] RBRACKET | DBG_TOK ( ( str[s] | IDENTIFIER ) |) | TRACE_TOK ( ( str[s] | IDENTIFIER ) |) | UNTRACE_TOK ( ( str[s] | IDENTIFIER ) |) | HELP_TOK ( ( str[s] | IDENTIFIER ) |) | TRANSFORM_TOK formula[f] | PRINT_TOK formula[f] | PRINT_TYPE_TOK type[t,CHECK_DECLARED] | CALL_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] formula[f] | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | EXIT_TOK | INCLUDE_TOK ( ( str[s] | IDENTIFIER ) |) | DUMP_PROOF_TOK | DUMP_UNSAT_CORE_TOK | ( DUMP_ASSUMPTIONS_TOK | DUMP_SIG_TOK | DUMP_TCC_TOK | DUMP_TCC_ASSUMPTIONS_TOK | DUMP_TCC_PROOF_TOK | DUMP_CLOSURE_TOK | DUMP_CLOSURE_PROOF_TOK ) | ( WHERE_TOK | ASSERTIONS_TOK | ASSUMPTIONS_TOK ) | COUNTEREXAMPLE_TOK | COUNTERMODEL_TOK | ARITH_VAR_ORDER_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN | CONTINUE_TOK | RESTART_TOK formula[f] | toplevelDeclaration[cmd] )

            ANTLR3_UINT32 alt31;

            alt31=42;

            switch ( LA(1) )
            {
            case ASSERT_TOK:
            	{
            		alt31=1;
            	}
                break;
            case QUERY_TOK:
            	{
            		alt31=2;
            	}
                break;
            case CHECKSAT_TOK:
            	{
            		alt31=3;
            	}
                break;
            case OPTION_TOK:
            	{
            		alt31=4;
            	}
                break;
            case PUSH_TOK:
            	{
            		alt31=5;
            	}
                break;
            case POP_TOK:
            	{
            		alt31=6;
            	}
                break;
            case POPTO_TOK:
            	{
            		alt31=7;
            	}
                break;
            case PUSH_SCOPE_TOK:
            	{
            		alt31=8;
            	}
                break;
            case POP_SCOPE_TOK:
            	{
            		alt31=9;
            	}
                break;
            case POPTO_SCOPE_TOK:
            	{
            		alt31=10;
            	}
                break;
            case RESET_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case ASSERTIONS_TOK:
            			{
            				alt31=12;
            			}
            		    break;
            		case SEMICOLON:
            			{
            				alt31=11;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 31;
            		    EXCEPTION->state        = 11;


            		    goto rulemainCommandEx;

            		}

            	}
                break;
            case DATATYPE_TOK:
            	{
            		alt31=13;
            	}
                break;
            case CONTEXT_TOK:
            	{
            		alt31=14;
            	}
                break;
            case FORGET_TOK:
            	{
            		alt31=15;
            	}
                break;
            case GET_TYPE_TOK:
            	{
            		alt31=16;
            	}
                break;
            case CHECK_TYPE_TOK:
            	{
            		alt31=17;
            	}
                break;
            case GET_CHILD_TOK:
            	{
            		alt31=18;
            	}
                break;
            case GET_OP_TOK:
            	{
            		alt31=19;
            	}
                break;
            case GET_VALUE_TOK:
            	{
            		alt31=20;
            	}
                break;
            case SUBSTITUTE_TOK:
            	{
            		alt31=21;
            	}
                break;
            case DBG_TOK:
            	{
            		alt31=22;
            	}
                break;
            case TRACE_TOK:
            	{
            		alt31=23;
            	}
                break;
            case UNTRACE_TOK:
            	{
            		alt31=24;
            	}
                break;
            case HELP_TOK:
            	{
            		alt31=25;
            	}
                break;
            case TRANSFORM_TOK:
            	{
            		alt31=26;
            	}
                break;
            case PRINT_TOK:
            	{
            		alt31=27;
            	}
                break;
            case PRINT_TYPE_TOK:
            	{
            		alt31=28;
            	}
                break;
            case CALL_TOK:
            	{
            		alt31=29;
            	}
                break;
            case ECHO_TOK:
            	{
            		alt31=30;
            	}
                break;
            case EXIT_TOK:
            	{
            		alt31=31;
            	}
                break;
            case INCLUDE_TOK:
            	{
            		alt31=32;
            	}
                break;
            case DUMP_PROOF_TOK:
            	{
            		alt31=33;
            	}
                break;
            case DUMP_UNSAT_CORE_TOK:
            	{
            		alt31=34;
            	}
                break;
            case DUMP_ASSUMPTIONS_TOK:
            case DUMP_CLOSURE_PROOF_TOK:
            case DUMP_CLOSURE_TOK:
            case DUMP_SIG_TOK:
            case DUMP_TCC_ASSUMPTIONS_TOK:
            case DUMP_TCC_PROOF_TOK:
            case DUMP_TCC_TOK:
            	{
            		alt31=35;
            	}
                break;
            case ASSERTIONS_TOK:
            case ASSUMPTIONS_TOK:
            case WHERE_TOK:
            	{
            		alt31=36;
            	}
                break;
            case COUNTEREXAMPLE_TOK:
            	{
            		alt31=37;
            	}
                break;
            case COUNTERMODEL_TOK:
            	{
            		alt31=38;
            	}
                break;
            case ARITH_VAR_ORDER_TOK:
            	{
            		alt31=39;
            	}
                break;
            case CONTINUE_TOK:
            	{
            		alt31=40;
            	}
                break;
            case RESTART_TOK:
            	{
            		alt31=41;
            	}
                break;
            case IDENTIFIER:
            	{
            		alt31=42;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 31;
                EXCEPTION->state        = 0;


                goto rulemainCommandEx;

            }

            switch (alt31)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:730:5: ASSERT_TOK formula[f]
        	    {
        	         MATCHT(ASSERT_TOK, &FOLLOW_ASSERT_TOK_in_mainCommand2048);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2050);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new AssertCommand(f)); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:732:5: QUERY_TOK formula[f]
        	    {
        	         MATCHT(QUERY_TOK, &FOLLOW_QUERY_TOK_in_mainCommand2060);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2062);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new QueryCommand(f)); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:733:5: CHECKSAT_TOK ( formula[f] )?
        	    {
        	         MATCHT(CHECKSAT_TOK, &FOLLOW_CHECKSAT_TOK_in_mainCommand2071);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:733:18: ( formula[f] )?
        	        {
        	            int alt7=2;
        	            switch ( LA(1) )
        	            {
        	                case ABS_TOK:
        	                case ARRAY_TOK:
        	                case BAR:
        	                case BINARY_LITERAL:
        	                case BVASHR_TOK:
        	                case BVCOMP_TOK:
        	                case BVGE_TOK:
        	                case BVGT_TOK:
        	                case BVLE_TOK:
        	                case BVLSHR_TOK:
        	                case BVLT_TOK:
        	                case BVMULT_TOK:
        	                case BVNAND_TOK:
        	                case BVNEG_TOK:
        	                case BVNOR_TOK:
        	                case BVPLUS_TOK:
        	                case BVREPEAT_TOK:
        	                case BVROTL_TOK:
        	                case BVROTR_TOK:
        	                case BVSDIV_TOK:
        	                case BVSGE_TOK:
        	                case BVSGT_TOK:
        	                case BVSHL_TOK:
        	                case BVSLE_TOK:
        	                case BVSLT_TOK:
        	                case BVSMOD_TOK:
        	                case BVSREM_TOK:
        	                case BVSUB_TOK:
        	                case BVUDIV_TOK:
        	                case BVUMINUS_TOK:
        	                case BVUREM_TOK:
        	                case BVXNOR_TOK:
        	                case BVXOR_TOK:
        	                case BVZEROEXTEND_TOK:
        	                case DECIMAL_LITERAL:
        	                case DISTINCT_TOK:
        	                case DIVISIBLE_TOK:
        	                case EXISTS_TOK:
        	                case FALSE_TOK:
        	                case FLOOR_TOK:
        	                case FORALL_TOK:
        	                case HEX_LITERAL:
        	                case IDENTIFIER:
        	                case IDEN_TOK:
        	                case IF_TOK:
        	                case INTEGER_LITERAL:
        	                case IS_INTEGER_TOK:
        	                case LAMBDA:
        	                case LBRACE:
        	                case LET_TOK:
        	                case LPAREN:
        	                case MINUS_TOK:
        	                case NOT_TOK:
        	                case PARENHASH:
        	                case SETS_CARD_TOK:
        	                case STRING_CONCAT_TOK:
        	                case STRING_CONTAINS_TOK:
        	                case STRING_INDEXOF_TOK:
        	                case STRING_ITOS_TOK:
        	                case STRING_LENGTH_TOK:
        	                case STRING_LITERAL:
        	                case STRING_PREFIXOF_TOK:
        	                case STRING_REPLACE_TOK:
        	                case STRING_STOI_TOK:
        	                case STRING_STOU16_TOK:
        	                case STRING_STOU32_TOK:
        	                case STRING_SUBSTR_TOK:
        	                case STRING_SUFFIXOF_TOK:
        	                case STRING_U16TOS_TOK:
        	                case STRING_U32TOS_TOK:
        	                case SX_TOK:
        	                case TRANSCLOSURE_TOK:
        	                case TRANSPOSE_TOK:
        	                case TRUE_TOK:
        	                case TUPLE_TOK:
        	                case UNIVSET_TOK:
        	                	{
        	                		alt7=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt7)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:733:18: formula[f]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2073);
        	        	        formula(ctx, f);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(f.isNull() ? new CheckSatCommand() : new CheckSatCommand(f)); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/cvc/Cvc.g:736:5: OPTION_TOK ( str[s] | IDENTIFIER ) ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |)
        	    {
        	         MATCHT(OPTION_TOK, &FOLLOW_OPTION_TOK_in_mainCommand2093);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:737:5: ( str[s] | IDENTIFIER )
        	        {
        	            int alt8=2;
        	            switch ( LA(1) )
        	            {
        	            case STRING_LITERAL:
        	            	{
        	            		alt8=1;
        	            	}
        	                break;
        	            case IDENTIFIER:
        	            	{
        	            		alt8=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 8;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt8)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:737:7: str[s]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2101);
        	        	        str(ctx, s);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:737:16: IDENTIFIER
        	        	    {
        	        	        IDENTIFIER3 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2106);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             s = AntlrInput::tokenText(IDENTIFIER3); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        // ../../../../src/parser/cvc/Cvc.g:738:5: ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |)
        	        {
        	            int alt9=4;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case HEX_LITERAL:
        	            case IDENTIFIER:
        	            case INTEGER_LITERAL:
        	            case LPAREN:
        	            case MINUS_TOK:
        	            case STRING_LITERAL:
        	            	{
        	            		alt9=1;
        	            	}
        	                break;
        	            case TRUE_TOK:
        	            	{
        	            		alt9=2;
        	            	}
        	                break;
        	            case FALSE_TOK:
        	            	{
        	            		alt9=3;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt9=4;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 9;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt9)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:738:7: symbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_mainCommand2118);
        	        	        symbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             if(s == "logic") {
        	        	                      cmd->reset(new SetBenchmarkLogicCommand(sexpr.getValue()));
        	        	                    } else {
        	        	                      cmd->reset(new SetOptionCommand(s, sexpr));
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:745:7: TRUE_TOK
        	        	    {
        	        	         MATCHT(TRUE_TOK, &FOLLOW_TRUE_TOK_in_mainCommand2135);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new SetOptionCommand(s, SExpr("true"))); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // ../../../../src/parser/cvc/Cvc.g:746:7: FALSE_TOK
        	        	    {
        	        	         MATCHT(FALSE_TOK, &FOLLOW_FALSE_TOK_in_mainCommand2145);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new SetOptionCommand(s, SExpr("false"))); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 4:
        	        	    // ../../../../src/parser/cvc/Cvc.g:747:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new SetOptionCommand(s, SExpr("true"))); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/cvc/Cvc.g:751:5: PUSH_TOK (k= numeral |)
        	    {
        	         MATCHT(PUSH_TOK, &FOLLOW_PUSH_TOK_in_mainCommand2174);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:751:14: (k= numeral |)
        	        {
        	            int alt10=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt10=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt10=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 10;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt10)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:751:16: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2180);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(REPEAT_COMMAND(k, PushCommand())); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:752:18: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new PushCommand()); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/cvc/Cvc.g:753:5: POP_TOK (k= numeral |)
        	    {
        	         MATCHT(POP_TOK, &FOLLOW_POP_TOK_in_mainCommand2209);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:753:13: (k= numeral |)
        	        {
        	            int alt11=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt11=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt11=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 11;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt11)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:753:15: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2215);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(REPEAT_COMMAND(k, PopCommand())); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:754:17: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new PopCommand()); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/cvc/Cvc.g:755:5: POPTO_TOK (k= numeral )?
        	    {
        	         MATCHT(POPTO_TOK, &FOLLOW_POPTO_TOK_in_mainCommand2243);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:755:16: (k= numeral )?
        	        {
        	            int alt12=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt12=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt12)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:755:16: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2247);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("POPTO command"); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/cvc/Cvc.g:759:5: PUSH_SCOPE_TOK (k= numeral )?
        	    {
        	         MATCHT(PUSH_SCOPE_TOK, &FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2267);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:759:21: (k= numeral )?
        	        {
        	            int alt13=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt13=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt13)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:759:21: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2271);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("PUSH_SCOPE command"); 
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/cvc/Cvc.g:761:5: POP_SCOPE_TOK (k= numeral )?
        	    {
        	         MATCHT(POP_SCOPE_TOK, &FOLLOW_POP_SCOPE_TOK_in_mainCommand2284);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:761:20: (k= numeral )?
        	        {
        	            int alt14=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt14=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt14)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:761:20: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2288);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("POP_SCOPE command"); 
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/cvc/Cvc.g:763:5: POPTO_SCOPE_TOK (k= numeral )?
        	    {
        	         MATCHT(POPTO_SCOPE_TOK, &FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2301);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:763:22: (k= numeral )?
        	        {
        	            int alt15=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt15=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt15)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:763:22: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2305);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("POPTO_SCOPE command"); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/cvc/Cvc.g:766:5: RESET_TOK
        	    {
        	         MATCHT(RESET_TOK, &FOLLOW_RESET_TOK_in_mainCommand2319);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new ResetCommand());
        	                  PARSER_STATE->reset();
        	                
        	        }


        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/cvc/Cvc.g:771:5: RESET_TOK ASSERTIONS_TOK
        	    {
        	         MATCHT(RESET_TOK, &FOLLOW_RESET_TOK_in_mainCommand2332);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(ASSERTIONS_TOK, &FOLLOW_ASSERTIONS_TOK_in_mainCommand2334);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new ResetAssertionsCommand());
        	                  PARSER_STATE->reset();
        	                
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/cvc/Cvc.g:779:5: DATATYPE_TOK datatypeDef[dts] ( COMMA datatypeDef[dts] )* END_TOK
        	    {
        	         MATCHT(DATATYPE_TOK, &FOLLOW_DATATYPE_TOK_in_mainCommand2362);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             /* open a scope to keep the UnresolvedTypes contained */
        	                  PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypeDef_in_mainCommand2374);
        	        datatypeDef(ctx, dts);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:783:5: ( COMMA datatypeDef[dts] )*

        	        for (;;)
        	        {
        	            int alt16=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt16=1;
        	            	}
        	                break;

        	            }

        	            switch (alt16)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:783:7: COMMA datatypeDef[dts]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_mainCommand2383);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_datatypeDef_in_mainCommand2385);
        	        	        datatypeDef(ctx, dts);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop16;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop16: ; /* Jump out to here if this rule does not match */


        	         MATCHT(END_TOK, &FOLLOW_END_TOK_in_mainCommand2395);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  cmd->reset(new DatatypeDeclarationCommand(
        	                      PARSER_STATE->mkMutualDatatypeTypes(dts)));
        	                
        	        }


        	    }
        	    break;
        	case 14:
        	    // ../../../../src/parser/cvc/Cvc.g:790:5: CONTEXT_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(CONTEXT_TOK, &FOLLOW_CONTEXT_TOK_in_mainCommand2408);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:791:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt18=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt18=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt18=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 18;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt18)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:791:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // ../../../../src/parser/cvc/Cvc.g:791:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt17=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt17=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt17=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 17;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt17)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:791:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2418);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:791:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER4 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2423);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER4); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             UNSUPPORTED("CONTEXT command"); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:793:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             UNSUPPORTED("CONTEXT command"); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 15:
        	    // ../../../../src/parser/cvc/Cvc.g:796:5: FORGET_TOK identifier[id,CHECK_NONE,SYM_VARIABLE]
        	    {
        	         MATCHT(FORGET_TOK, &FOLLOW_FORGET_TOK_in_mainCommand2456);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2458);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("FORGET command"); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // ../../../../src/parser/cvc/Cvc.g:799:5: GET_TYPE_TOK formula[f]
        	    {
        	         MATCHT(GET_TYPE_TOK, &FOLLOW_GET_TYPE_TOK_in_mainCommand2472);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2474);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("GET_TYPE command"); 
        	        }


        	    }
        	    break;
        	case 17:
        	    // ../../../../src/parser/cvc/Cvc.g:802:5: CHECK_TYPE_TOK formula[f] COLON type[t,CHECK_DECLARED]
        	    {
        	         MATCHT(CHECK_TYPE_TOK, &FOLLOW_CHECK_TYPE_TOK_in_mainCommand2488);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2490);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_mainCommand2493);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_mainCommand2495);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("CHECK_TYPE command"); 
        	        }


        	    }
        	    break;
        	case 18:
        	    // ../../../../src/parser/cvc/Cvc.g:805:5: GET_CHILD_TOK formula[f] k= numeral
        	    {
        	         MATCHT(GET_CHILD_TOK, &FOLLOW_GET_CHILD_TOK_in_mainCommand2509);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2511);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2516);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("GET_CHILD command"); 
        	        }


        	    }
        	    break;
        	case 19:
        	    // ../../../../src/parser/cvc/Cvc.g:808:5: GET_OP_TOK formula[f]
        	    {
        	         MATCHT(GET_OP_TOK, &FOLLOW_GET_OP_TOK_in_mainCommand2529);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2531);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("GET_OP command"); 
        	        }


        	    }
        	    break;
        	case 20:
        	    // ../../../../src/parser/cvc/Cvc.g:811:5: GET_VALUE_TOK formula[f]
        	    {
        	         MATCHT(GET_VALUE_TOK, &FOLLOW_GET_VALUE_TOK_in_mainCommand2545);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2547);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetValueCommand(f)); 
        	        }


        	    }
        	    break;
        	case 21:
        	    // ../../../../src/parser/cvc/Cvc.g:814:5: SUBSTITUTE_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] EQUAL_TOK formula[f] LBRACKET identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[f] RBRACKET
        	    {
        	         MATCHT(SUBSTITUTE_TOK, &FOLLOW_SUBSTITUTE_TOK_in_mainCommand2561);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2563);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_mainCommand2566);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_mainCommand2572);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_mainCommand2575);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2577);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_mainCommand2580);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2586);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_mainCommand2589);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2591);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_mainCommand2594);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("SUBSTITUTE command"); 
        	        }


        	    }
        	    break;
        	case 22:
        	    // ../../../../src/parser/cvc/Cvc.g:821:5: DBG_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(DBG_TOK, &FOLLOW_DBG_TOK_in_mainCommand2613);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:822:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt20=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt20=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt20=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 20;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt20)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:822:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // ../../../../src/parser/cvc/Cvc.g:822:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt19=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt19=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt19=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 19;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt19)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:822:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2623);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:822:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER5 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2628);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER5); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Debug.on(s); Trace.on(s); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:824:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please specify what to debug." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 23:
        	    // ../../../../src/parser/cvc/Cvc.g:827:5: TRACE_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(TRACE_TOK, &FOLLOW_TRACE_TOK_in_mainCommand2661);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:828:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt22=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt22=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt22=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 22;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt22)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:828:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // ../../../../src/parser/cvc/Cvc.g:828:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt21=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt21=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt21=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 21;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt21)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:828:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2671);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:828:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER6 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2676);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER6); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Trace.on(s); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:830:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please specify something to trace." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 24:
        	    // ../../../../src/parser/cvc/Cvc.g:832:5: UNTRACE_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(UNTRACE_TOK, &FOLLOW_UNTRACE_TOK_in_mainCommand2708);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:833:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt24=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt24=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt24=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 24;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt24)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:833:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // ../../../../src/parser/cvc/Cvc.g:833:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt23=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt23=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt23=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 23;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt23)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:833:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2718);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:833:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER7 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2723);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER7); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Trace.off(s); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:835:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please specify something to untrace." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 25:
        	    // ../../../../src/parser/cvc/Cvc.g:838:5: HELP_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(HELP_TOK, &FOLLOW_HELP_TOK_in_mainCommand2756);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:839:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt26=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt26=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt26=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 26;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt26)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:839:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // ../../../../src/parser/cvc/Cvc.g:839:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt25=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt25=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt25=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 25;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt25)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:839:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2766);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:839:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER8 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2771);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER8); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "No help available for `" << s << "'." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:841:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please use --help at the command line for help."
        	        	                            << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 26:
        	    // ../../../../src/parser/cvc/Cvc.g:845:5: TRANSFORM_TOK formula[f]
        	    {
        	         MATCHT(TRANSFORM_TOK, &FOLLOW_TRANSFORM_TOK_in_mainCommand2812);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2814);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new SimplifyCommand(f)); 
        	        }


        	    }
        	    break;
        	case 27:
        	    // ../../../../src/parser/cvc/Cvc.g:848:5: PRINT_TOK formula[f]
        	    {
        	         MATCHT(PRINT_TOK, &FOLLOW_PRINT_TOK_in_mainCommand2828);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2830);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("PRINT command"); 
        	        }


        	    }
        	    break;
        	case 28:
        	    // ../../../../src/parser/cvc/Cvc.g:850:5: PRINT_TYPE_TOK type[t,CHECK_DECLARED]
        	    {
        	         MATCHT(PRINT_TYPE_TOK, &FOLLOW_PRINT_TYPE_TOK_in_mainCommand2843);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_mainCommand2845);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("PRINT_TYPE command"); 
        	        }


        	    }
        	    break;
        	case 29:
        	    // ../../../../src/parser/cvc/Cvc.g:853:5: CALL_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] formula[f]
        	    {
        	         MATCHT(CALL_TOK, &FOLLOW_CALL_TOK_in_mainCommand2859);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2861);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2864);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("CALL command"); 
        	        }


        	    }
        	    break;
        	case 30:
        	    // ../../../../src/parser/cvc/Cvc.g:856:5: ECHO_TOK ( simpleSymbolicExpr[sexpr] |)
        	    {
        	         MATCHT(ECHO_TOK, &FOLLOW_ECHO_TOK_in_mainCommand2878);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:857:5: ( simpleSymbolicExpr[sexpr] |)
        	        {
        	            int alt27=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case HEX_LITERAL:
        	            case IDENTIFIER:
        	            case INTEGER_LITERAL:
        	            case MINUS_TOK:
        	            case STRING_LITERAL:
        	            	{
        	            		alt27=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt27=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 27;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt27)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:857:7: simpleSymbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_mainCommand2886);
        	        	        simpleSymbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new EchoCommand(sexpr.getValue())); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:859:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new EchoCommand()); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 31:
        	    // ../../../../src/parser/cvc/Cvc.g:862:5: EXIT_TOK
        	    {
        	         MATCHT(EXIT_TOK, &FOLLOW_EXIT_TOK_in_mainCommand2916);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new QuitCommand()); 
        	        }


        	    }
        	    break;
        	case 32:
        	    // ../../../../src/parser/cvc/Cvc.g:865:5: INCLUDE_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(INCLUDE_TOK, &FOLLOW_INCLUDE_TOK_in_mainCommand2929);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:866:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt29=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt29=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt29=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 29;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt29)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:866:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // ../../../../src/parser/cvc/Cvc.g:866:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt28=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt28=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt28=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 28;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt28)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:866:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2939);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:866:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER9 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2944);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER9); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             UNSUPPORTED("INCLUDE command"); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:868:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->parseError("No filename given to INCLUDE command"); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 33:
        	    // ../../../../src/parser/cvc/Cvc.g:871:5: DUMP_PROOF_TOK
        	    {
        	         MATCHT(DUMP_PROOF_TOK, &FOLLOW_DUMP_PROOF_TOK_in_mainCommand2977);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetProofCommand()); 
        	        }


        	    }
        	    break;
        	case 34:
        	    // ../../../../src/parser/cvc/Cvc.g:874:5: DUMP_UNSAT_CORE_TOK
        	    {
        	         MATCHT(DUMP_UNSAT_CORE_TOK, &FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand2990);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetUnsatCoreCommand()); 
        	        }


        	    }
        	    break;
        	case 35:
        	    // ../../../../src/parser/cvc/Cvc.g:877:5: ( DUMP_ASSUMPTIONS_TOK | DUMP_SIG_TOK | DUMP_TCC_TOK | DUMP_TCC_ASSUMPTIONS_TOK | DUMP_TCC_PROOF_TOK | DUMP_CLOSURE_TOK | DUMP_CLOSURE_PROOF_TOK )
        	    {
        	        if ( ((LA(1) >= DUMP_ASSUMPTIONS_TOK) && (LA(1) <= DUMP_CLOSURE_TOK)) || ((LA(1) >= DUMP_SIG_TOK) && (LA(1) <= DUMP_TCC_TOK)) )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	            FAILEDFLAG=ANTLR3_FALSE;

        	        }
        	        else
        	        {
        	            if (BACKTRACKING>0)
        	            {
        	                FAILEDFLAG = ANTLR3_TRUE;
        	                return ;
        	            }

        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto rulemainCommandEx;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("DUMP* command"); 
        	        }


        	    }
        	    break;
        	case 36:
        	    // ../../../../src/parser/cvc/Cvc.g:887:5: ( WHERE_TOK | ASSERTIONS_TOK | ASSUMPTIONS_TOK )
        	    {
        	        if ( LA(1) == ASSERTIONS_TOK || LA(1) == ASSUMPTIONS_TOK || LA(1) == WHERE_TOK )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	            FAILEDFLAG=ANTLR3_FALSE;

        	        }
        	        else
        	        {
        	            if (BACKTRACKING>0)
        	            {
        	                FAILEDFLAG = ANTLR3_TRUE;
        	                return ;
        	            }

        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto rulemainCommandEx;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetAssertionsCommand()); 
        	        }


        	    }
        	    break;
        	case 37:
        	    // ../../../../src/parser/cvc/Cvc.g:890:5: COUNTEREXAMPLE_TOK
        	    {
        	         MATCHT(COUNTEREXAMPLE_TOK, &FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3099);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetModelCommand); 
        	        }


        	    }
        	    break;
        	case 38:
        	    // ../../../../src/parser/cvc/Cvc.g:892:5: COUNTERMODEL_TOK
        	    {
        	         MATCHT(COUNTERMODEL_TOK, &FOLLOW_COUNTERMODEL_TOK_in_mainCommand3111);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetModelCommand); 
        	        }


        	    }
        	    break;
        	case 39:
        	    // ../../../../src/parser/cvc/Cvc.g:895:5: ARITH_VAR_ORDER_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN
        	    {
        	         MATCHT(ARITH_VAR_ORDER_TOK, &FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3124);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_mainCommand3126);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand3128);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:895:43: ( COMMA formula[f] )*

        	        for (;;)
        	        {
        	            int alt30=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt30=1;
        	            	}
        	                break;

        	            }

        	            switch (alt30)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:895:45: COMMA formula[f]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_mainCommand3133);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand3135);
        	        	        formula(ctx, f);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop30;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop30: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_mainCommand3141);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("ARITH_VAR_ORDER command"); 
        	        }


        	    }
        	    break;
        	case 40:
        	    // ../../../../src/parser/cvc/Cvc.g:898:5: CONTINUE_TOK
        	    {
        	         MATCHT(CONTINUE_TOK, &FOLLOW_CONTINUE_TOK_in_mainCommand3154);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("CONTINUE command"); 
        	        }


        	    }
        	    break;
        	case 41:
        	    // ../../../../src/parser/cvc/Cvc.g:900:5: RESTART_TOK formula[f]
        	    {
        	         MATCHT(RESTART_TOK, &FOLLOW_RESTART_TOK_in_mainCommand3166);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand3168);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("RESTART command"); 
        	        }


        	    }
        	    break;
        	case 42:
        	    // ../../../../src/parser/cvc/Cvc.g:901:5: toplevelDeclaration[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_toplevelDeclaration_in_mainCommand3177);
        	        toplevelDeclaration(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulemainCommandEx; /* Prevent compiler warnings */
    rulemainCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end mainCommand */

/**
 * $ANTLR start simpleSymbolicExpr
 * ../../../../src/parser/cvc/Cvc.g:904:1: simpleSymbolicExpr[CVC4::SExpr& sexpr] : ( INTEGER_LITERAL | MINUS_TOK INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s] | IDENTIFIER );
 */
static void
simpleSymbolicExpr(pCvcParser ctx, CVC4::SExpr& sexpr)
{

      std::string s;
      CVC4::Rational r;

    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL10;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL11;
    pANTLR3_COMMON_TOKEN    DECIMAL_LITERAL12;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL13;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL14;
    pANTLR3_COMMON_TOKEN    IDENTIFIER15;

    /* Initialize rule variables
     */

    INTEGER_LITERAL10       = NULL;
    INTEGER_LITERAL11       = NULL;
    DECIMAL_LITERAL12       = NULL;
    HEX_LITERAL13       = NULL;
    BINARY_LITERAL14       = NULL;
    IDENTIFIER15       = NULL;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:909:3: ( INTEGER_LITERAL | MINUS_TOK INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s] | IDENTIFIER )

            ANTLR3_UINT32 alt32;

            alt32=7;

            switch ( LA(1) )
            {
            case INTEGER_LITERAL:
            	{
            		alt32=1;
            	}
                break;
            case MINUS_TOK:
            	{
            		alt32=2;
            	}
                break;
            case DECIMAL_LITERAL:
            	{
            		alt32=3;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt32=4;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt32=5;
            	}
                break;
            case STRING_LITERAL:
            	{
            		alt32=6;
            	}
                break;
            case IDENTIFIER:
            	{
            		alt32=7;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 32;
                EXCEPTION->state        = 0;


                goto rulesimpleSymbolicExprEx;

            }

            switch (alt32)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:909:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL10 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3197);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(Integer(AntlrInput::tokenText(INTEGER_LITERAL10))); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:911:5: MINUS_TOK INTEGER_LITERAL
        	    {
        	         MATCHT(MINUS_TOK, &FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3209);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        INTEGER_LITERAL11 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3211);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(-Integer(AntlrInput::tokenText(INTEGER_LITERAL11))); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:913:5: DECIMAL_LITERAL
        	    {
        	        DECIMAL_LITERAL12 = (pANTLR3_COMMON_TOKEN) MATCHT(DECIMAL_LITERAL, &FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3223);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenToRational(DECIMAL_LITERAL12)); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/cvc/Cvc.g:915:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL13 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3235);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(HEX_LITERAL13)); 
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/cvc/Cvc.g:917:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL14 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3247);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(BINARY_LITERAL14)); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/cvc/Cvc.g:919:5: str[s]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_simpleSymbolicExpr3259);
        	        str(ctx, s);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(s); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/cvc/Cvc.g:921:5: IDENTIFIER
        	    {
        	        IDENTIFIER15 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3272);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(IDENTIFIER15)); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleSymbolicExprEx; /* Prevent compiler warnings */
    rulesimpleSymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleSymbolicExpr */

/**
 * $ANTLR start symbolicExpr
 * ../../../../src/parser/cvc/Cvc.g:925:1: symbolicExpr[CVC4::SExpr& sexpr] : ( simpleSymbolicExpr[sexpr] | LPAREN ( symbolicExpr[sexpr] )* RPAREN );
 */
static void
symbolicExpr(pCvcParser ctx, CVC4::SExpr& sexpr)
{

      std::vector<SExpr> children;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:929:3: ( simpleSymbolicExpr[sexpr] | LPAREN ( symbolicExpr[sexpr] )* RPAREN )

            ANTLR3_UINT32 alt34;

            alt34=2;

            switch ( LA(1) )
            {
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case HEX_LITERAL:
            case IDENTIFIER:
            case INTEGER_LITERAL:
            case MINUS_TOK:
            case STRING_LITERAL:
            	{
            		alt34=1;
            	}
                break;
            case LPAREN:
            	{
            		alt34=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 34;
                EXCEPTION->state        = 0;


                goto rulesymbolicExprEx;

            }

            switch (alt34)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:929:5: simpleSymbolicExpr[sexpr]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_symbolicExpr3297);
        	        simpleSymbolicExpr(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:930:5: LPAREN ( symbolicExpr[sexpr] )* RPAREN
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_symbolicExpr3304);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:930:12: ( symbolicExpr[sexpr] )*

        	        for (;;)
        	        {
        	            int alt33=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case HEX_LITERAL:
        	            case IDENTIFIER:
        	            case INTEGER_LITERAL:
        	            case LPAREN:
        	            case MINUS_TOK:
        	            case STRING_LITERAL:
        	            	{
        	            		alt33=1;
        	            	}
        	                break;

        	            }

        	            switch (alt33)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:930:13: symbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_symbolicExpr3307);
        	        	        symbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolicExprEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             children.push_back(sexpr); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop33;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop33: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_symbolicExpr3315);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(children); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesymbolicExprEx; /* Prevent compiler warnings */
    rulesymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbolicExpr */

/**
 * $ANTLR start toplevelDeclaration
 * ../../../../src/parser/cvc/Cvc.g:937:1: toplevelDeclaration[CVC4::PtrCloser<CVC4::Command>* cmd] : identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] ) ;
 */
static void
toplevelDeclaration(pCvcParser ctx, CVC4::PtrCloser<CVC4::Command>* cmd)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      Type t;
      Debug("parser-extra") << "declaration: " << AntlrInput::tokenText(LT(1))
                            << std::endl;

    {
        // ../../../../src/parser/cvc/Cvc.g:944:3: ( identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] ) )
        // ../../../../src/parser/cvc/Cvc.g:944:5: identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] )
        {
            FOLLOWPUSH(FOLLOW_identifierList_in_toplevelDeclaration3342);
            identifierList(ctx, ids, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletoplevelDeclarationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_toplevelDeclaration3345);
            if  (HASEXCEPTION())
            {
                goto ruletoplevelDeclarationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:945:5: ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] )
            {
                int alt35=2;
                switch ( LA(1) )
                {
                case ARRAY_TOK:
                case BITVECTOR_TOK:
                case BOOLEAN_TOK:
                case IDENTIFIER:
                case INT_TOK:
                case LBRACKET:
                case LET_TOK:
                case LPAREN:
                case REAL_TOK:
                case SET_TOK:
                case SQHASH:
                case STRING_TOK:
                case SUBTYPE_TOK:
                	{
                		alt35=1;
                	}
                    break;
                case TYPE_TOK:
                	{
                		alt35=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 35;
                    EXCEPTION->state        = 0;


                    goto ruletoplevelDeclarationEx;

                }

                switch (alt35)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:945:7: declareVariables[cmd,t,ids,true]
            	    {
            	        FOLLOWPUSH(FOLLOW_declareVariables_in_toplevelDeclaration3353);
            	        declareVariables(ctx, cmd, t, ids, true);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletoplevelDeclarationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:946:7: declareTypes[cmd,ids]
            	    {
            	        FOLLOWPUSH(FOLLOW_declareTypes_in_toplevelDeclaration3362);
            	        declareTypes(ctx, cmd, ids);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletoplevelDeclarationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruletoplevelDeclarationEx; /* Prevent compiler warnings */
    ruletoplevelDeclarationEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end toplevelDeclaration */

/**
 * $ANTLR start boundVarDecl
 * ../../../../src/parser/cvc/Cvc.g:952:1: boundVarDecl[std::vector<std::string>& ids, CVC4::Type& t] : identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON declareVariables[&local_cmd,t,ids,false] ;
 */
static void
boundVarDecl(pCvcParser ctx, std::vector<std::string>& ids, CVC4::Type& t)
{
    /* Initialize rule variables
     */


      CVC4::PtrCloser<Command> local_cmd;

    {
        // ../../../../src/parser/cvc/Cvc.g:956:3: ( identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON declareVariables[&local_cmd,t,ids,false] )
        // ../../../../src/parser/cvc/Cvc.g:956:5: identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON declareVariables[&local_cmd,t,ids,false]
        {
            FOLLOWPUSH(FOLLOW_identifierList_in_boundVarDecl3386);
            identifierList(ctx, ids, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_boundVarDecl3389);
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_declareVariables_in_boundVarDecl3395);
            declareVariables(ctx, &local_cmd, t, ids, false);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclEx; /* Prevent compiler warnings */
    ruleboundVarDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDecl */

/**
 * $ANTLR start boundVarDecls
 * ../../../../src/parser/cvc/Cvc.g:963:1: boundVarDecls : boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* ;
 */
static void
boundVarDecls(pCvcParser ctx)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      Type t;

    {
        // ../../../../src/parser/cvc/Cvc.g:968:3: ( boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* )
        // ../../../../src/parser/cvc/Cvc.g:968:5: boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )*
        {
            FOLLOWPUSH(FOLLOW_boundVarDecl_in_boundVarDecls3416);
            boundVarDecl(ctx, ids, t);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclsEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:968:25: ( COMMA boundVarDecl[ids,t] )*

            for (;;)
            {
                int alt36=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt36=1;
                	}
                    break;

                }

                switch (alt36)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:968:27: COMMA boundVarDecl[ids,t]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_boundVarDecls3421);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_boundVarDecl_in_boundVarDecls3423);
            	        boundVarDecl(ctx, ids, t);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop36;	/* break out of the loop */
            	    break;
                }
            }
            loop36: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclsEx; /* Prevent compiler warnings */
    ruleboundVarDeclsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDecls */

/**
 * $ANTLR start boundVarDeclsReturn
 * ../../../../src/parser/cvc/Cvc.g:971:1: boundVarDeclsReturn[std::vector<CVC4::Expr>& terms,\n std::vector<CVC4::Type>& types] : boundVarDeclReturn[terms,types] ( COMMA boundVarDeclReturn[terms,types] )* ;
 */
static void
boundVarDeclsReturn(pCvcParser ctx, std::vector<CVC4::Expr>& terms, std::vector<CVC4::Type>& types)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      Type t;
      terms.clear();
      types.clear();

    {
        // ../../../../src/parser/cvc/Cvc.g:979:3: ( boundVarDeclReturn[terms,types] ( COMMA boundVarDeclReturn[terms,types] )* )
        // ../../../../src/parser/cvc/Cvc.g:979:5: boundVarDeclReturn[terms,types] ( COMMA boundVarDeclReturn[terms,types] )*
        {
            FOLLOWPUSH(FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3446);
            boundVarDeclReturn(ctx, terms, types);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclsReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:979:37: ( COMMA boundVarDeclReturn[terms,types] )*

            for (;;)
            {
                int alt37=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt37=1;
                	}
                    break;

                }

                switch (alt37)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:979:39: COMMA boundVarDeclReturn[terms,types]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_boundVarDeclsReturn3451);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsReturnEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3453);
            	        boundVarDeclReturn(ctx, terms, types);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsReturnEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop37;	/* break out of the loop */
            	    break;
                }
            }
            loop37: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclsReturnEx; /* Prevent compiler warnings */
    ruleboundVarDeclsReturnEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDeclsReturn */

/**
 * $ANTLR start boundVarDeclReturn
 * ../../../../src/parser/cvc/Cvc.g:982:1: boundVarDeclReturn[std::vector<CVC4::Expr>& terms,\n std::vector<CVC4::Type>& types] : identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] ;
 */
static void
boundVarDeclReturn(pCvcParser ctx, std::vector<CVC4::Expr>& terms, std::vector<CVC4::Type>& types)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      Type t;
      // NOTE: do not clear the vectors here!

    {
        // ../../../../src/parser/cvc/Cvc.g:989:3: ( identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] )
        // ../../../../src/parser/cvc/Cvc.g:989:5: identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED]
        {
            FOLLOWPUSH(FOLLOW_identifierList_in_boundVarDeclReturn3476);
            identifierList(ctx, ids, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_boundVarDeclReturn3479);
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_type_in_boundVarDeclReturn3481);
            type(ctx, t, CHECK_DECLARED);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 const std::vector<Expr>& vars = PARSER_STATE->mkBoundVars(ids, t);
                      terms.insert(terms.end(), vars.begin(), vars.end());
                      for(unsigned i = 0; i < vars.size(); ++i) {
                        types.push_back(t);
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclReturnEx; /* Prevent compiler warnings */
    ruleboundVarDeclReturnEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDeclReturn */

/**
 * $ANTLR start declareTypes
 * ../../../../src/parser/cvc/Cvc.g:1005:1: declareTypes[CVC4::PtrCloser<CVC4::Command>* cmd,\n const std::vector<std::string>& idList] : ( TYPE_TOK | TYPE_TOK EQUAL_TOK type[t,CHECK_DECLARED] );
 */
static void
declareTypes(pCvcParser ctx, CVC4::PtrCloser<CVC4::Command>* cmd, const std::vector<std::string>& idList)
{
    /* Initialize rule variables
     */


      Type t;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1011:3: ( TYPE_TOK | TYPE_TOK EQUAL_TOK type[t,CHECK_DECLARED] )

            ANTLR3_UINT32 alt38;

            alt38=2;

            switch ( LA(1) )
            {
            case TYPE_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case EQUAL_TOK:
            			{
            				alt38=2;
            			}
            		    break;
            		case SEMICOLON:
            			{
            				alt38=1;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 38;
            		    EXCEPTION->state        = 1;


            		    goto ruledeclareTypesEx;

            		}

            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 38;
                EXCEPTION->state        = 0;


                goto ruledeclareTypesEx;

            }

            switch (alt38)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1011:5: TYPE_TOK
        	    {
        	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_declareTypes3515);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             CVC4::PtrCloser<DeclarationSequence> seq(new DeclarationSequence());
        	                  for(std::vector<std::string>::const_iterator i = idList.begin();
        	                      i != idList.end(); ++i) {
        	                    // Don't allow a type variable to clash with a previously
        	                    // declared type variable, however a type variable and a
        	                    // non-type variable can clash unambiguously.  Break from CVC3
        	                    // behavior here.
        	                    PARSER_STATE->checkDeclaration(*i, CHECK_UNDECLARED, SYM_SORT);
        	                    Type sort = PARSER_STATE->mkSort(*i);
        	                    Command* decl = new DeclareTypeCommand(*i, 0, sort);
        	                    seq->addCommand(decl);
        	                  }
        	                  cmd->reset(seq.release());
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1028:5: TYPE_TOK EQUAL_TOK type[t,CHECK_DECLARED]
        	    {
        	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_declareTypes3534);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_declareTypes3536);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_declareTypes3538);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             for(std::vector<std::string>::const_iterator i = idList.begin();
        	                      i != idList.end();
        	                      ++i) {
        	                    PARSER_STATE->checkDeclaration(*i, CHECK_UNDECLARED, SYM_SORT);
        	                    PARSER_STATE->defineType(*i, t);
        	                  }
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledeclareTypesEx; /* Prevent compiler warnings */
    ruledeclareTypesEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end declareTypes */

/**
 * $ANTLR start declareVariables
 * ../../../../src/parser/cvc/Cvc.g:1047:1: declareVariables[CVC4::PtrCloser<CVC4::Command>* cmd, CVC4::Type& t,\n const std::vector<std::string>& idList, bool topLevel] : type[t,CHECK_DECLARED] ( EQUAL_TOK formula[f] )? ;
 */
static void
declareVariables(pCvcParser ctx, CVC4::PtrCloser<CVC4::Command>* cmd, CVC4::Type& t, const std::vector<std::string>& idList, bool topLevel)
{
    /* Initialize rule variables
     */


      Expr f;
      Debug("parser-extra") << "declType: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        // ../../../../src/parser/cvc/Cvc.g:1054:3: ( type[t,CHECK_DECLARED] ( EQUAL_TOK formula[f] )? )
        // ../../../../src/parser/cvc/Cvc.g:1054:5: type[t,CHECK_DECLARED] ( EQUAL_TOK formula[f] )?
        {
            FOLLOWPUSH(FOLLOW_type_in_declareVariables3572);
            type(ctx, t, CHECK_DECLARED);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledeclareVariablesEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:1054:28: ( EQUAL_TOK formula[f] )?
            {
                int alt39=2;
                switch ( LA(1) )
                {
                    case EQUAL_TOK:
                    	{
                    		alt39=1;
                    	}
                        break;
                }

                switch (alt39)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1054:30: EQUAL_TOK formula[f]
            	    {
            	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_declareVariables3577);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledeclareVariablesEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_formula_in_declareVariables3579);
            	        formula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledeclareVariablesEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 CVC4::PtrCloser<DeclarationSequence> seq;
                      if(topLevel) {
                        seq.reset(new DeclarationSequence());
                      }
                      if(f.isNull()) {
                        Debug("parser") << "working on " << idList.front() << " : " << t
                                        << std::endl;
                        // CVC language allows redeclaration of variables if types are the same
                        for(std::vector<std::string>::const_iterator i = idList.begin(),
                              i_end = idList.end();
                            i != i_end;
                            ++i) {
                          if(PARSER_STATE->isDeclared(*i, SYM_VARIABLE)) {
                            Type oldType = PARSER_STATE->getType(*i);
                            Debug("parser") << "  " << *i << " was declared previously "
                                            << "with type " << oldType << std::endl;
                            if(oldType != t) {
                              std::stringstream ss;
                              ss << language::SetLanguage(language::output::LANG_CVC4)
                                 << "incompatible type for `" << *i << "':" << std::endl
                                 << "  old type: " << oldType << std::endl
                                 << "  new type: " << t << std::endl;
                              PARSER_STATE->parseError(ss.str());
                            } else {
                              Debug("parser") << "  types " << t << " and " << oldType
                                              << " are compatible" << std::endl;
                            }
                          } else {
                            Debug("parser") << "  " << *i << " not declared" << std::endl;
                            if(topLevel) {
                              Expr func = PARSER_STATE->mkVar(*i, t, ExprManager::VAR_FLAG_GLOBAL);
                              Command* decl = new DeclareFunctionCommand(*i, func, t);
                              seq->addCommand(decl);
                            } else {
                              PARSER_STATE->mkBoundVar(*i, t);
                            }
                          }
                        }
                      } else {
                        // f is not null-- meaning this is a definition not a declaration
                        if(!topLevel) {
                          // must be top-level; doesn't make sense to write something
                          // like e.g. FORALL(x:INT = 4): [...]
                          PARSER_STATE->parseError("cannot construct a definition here; maybe you want a LET");
                        }
                        assert(!idList.empty());
                        for(std::vector<std::string>::const_iterator i = idList.begin(),
                              i_end = idList.end();
                            i != i_end;
                            ++i) {
                          Debug("parser") << "making " << *i << " : " << t << " = " << f << std::endl;
                          PARSER_STATE->checkDeclaration(*i, CHECK_UNDECLARED, SYM_VARIABLE);
                          Expr func = EXPR_MANAGER->mkVar(*i, t, ExprManager::VAR_FLAG_GLOBAL | ExprManager::VAR_FLAG_DEFINED);
                          PARSER_STATE->defineFunction(*i, f);
                          Command* decl = new DefineFunctionCommand(*i, func, f);
                          seq->addCommand(decl);
                        }
                      }
                      if(topLevel) {
                        cmd->reset(new DeclarationSequence());
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledeclareVariablesEx; /* Prevent compiler warnings */
    ruledeclareVariablesEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end declareVariables */

/**
 * $ANTLR start identifierList
 * ../../../../src/parser/cvc/Cvc.g:1125:1: identifierList[std::vector<std::string>& idList,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : identifier[id,check,type] ( COMMA identifier[id,check,type] )* ;
 */
static void
identifierList(pCvcParser ctx, std::vector<std::string>& idList, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{
    /* Initialize rule variables
     */


      std::string id;
      idList.clear();

    {
        // ../../../../src/parser/cvc/Cvc.g:1132:3: ( identifier[id,check,type] ( COMMA identifier[id,check,type] )* )
        // ../../../../src/parser/cvc/Cvc.g:1132:5: identifier[id,check,type] ( COMMA identifier[id,check,type] )*
        {
            FOLLOWPUSH(FOLLOW_identifier_in_identifierList3610);
            identifier(ctx, id, check, type);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleidentifierListEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 idList.push_back(id); 
            }


            // ../../../../src/parser/cvc/Cvc.g:1133:5: ( COMMA identifier[id,check,type] )*

            for (;;)
            {
                int alt40=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt40=1;
                	}
                    break;

                }

                switch (alt40)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1133:7: COMMA identifier[id,check,type]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_identifierList3621);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleidentifierListEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_identifier_in_identifierList3623);
            	        identifier(ctx, id, check, type);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleidentifierListEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             idList.push_back(id); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop40;	/* break out of the loop */
            	    break;
                }
            }
            loop40: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleidentifierListEx; /* Prevent compiler warnings */
    ruleidentifierListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end identifierList */

/**
 * $ANTLR start identifier
 * ../../../../src/parser/cvc/Cvc.g:1139:1: identifier[std::string& id,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : IDENTIFIER ;
 */
static void
identifier(pCvcParser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{
    pANTLR3_COMMON_TOKEN    IDENTIFIER16;

    /* Initialize rule variables
     */

    IDENTIFIER16       = NULL;

    {
        // ../../../../src/parser/cvc/Cvc.g:1142:3: ( IDENTIFIER )
        // ../../../../src/parser/cvc/Cvc.g:1142:5: IDENTIFIER
        {
            IDENTIFIER16 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_identifier3645);
            if  (HASEXCEPTION())
            {
                goto ruleidentifierEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 id = AntlrInput::tokenText(IDENTIFIER16);
                      PARSER_STATE->checkDeclaration(id, check, type); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleidentifierEx; /* Prevent compiler warnings */
    ruleidentifierEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end identifier */

/**
 * $ANTLR start type
 * ../../../../src/parser/cvc/Cvc.g:1159:1: type[CVC4::Type& t,\n CVC4::parser::DeclarationCheck check] : ( restrictedTypePossiblyFunctionLHS[t,check,lhs] ( ARROW_TOK type[t2,check] )? | LET_TOK typeLetDecl[check] ( COMMA typeLetDecl[check] )* IN_TOK type[t,check] );
 */
static void
type(pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */


      Type t2;
      bool lhs;
      std::vector<Type> args;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1167:3: ( restrictedTypePossiblyFunctionLHS[t,check,lhs] ( ARROW_TOK type[t2,check] )? | LET_TOK typeLetDecl[check] ( COMMA typeLetDecl[check] )* IN_TOK type[t,check] )

            ANTLR3_UINT32 alt43;

            alt43=2;

            switch ( LA(1) )
            {
            case ARRAY_TOK:
            case BITVECTOR_TOK:
            case BOOLEAN_TOK:
            case IDENTIFIER:
            case INT_TOK:
            case LBRACKET:
            case LPAREN:
            case REAL_TOK:
            case SET_TOK:
            case SQHASH:
            case STRING_TOK:
            case SUBTYPE_TOK:
            	{
            		alt43=1;
            	}
                break;
            case LET_TOK:
            	{
            		alt43=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 43;
                EXCEPTION->state        = 0;


                goto ruletypeEx;

            }

            switch (alt43)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1167:5: restrictedTypePossiblyFunctionLHS[t,check,lhs] ( ARROW_TOK type[t2,check] )?
        	    {
        	        FOLLOWPUSH(FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3678);
        	        restrictedTypePossiblyFunctionLHS(ctx, t, check, lhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(lhs) {
        	                    assert(t.isTuple());
        	                    args = ((DatatypeType)t).getTupleTypes();
        	                  } else {
        	                    args.push_back(t);
        	                  }
        	                
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1175:5: ( ARROW_TOK type[t2,check] )?
        	        {
        	            int alt41=2;
        	            switch ( LA(1) )
        	            {
        	                case ARROW_TOK:
        	                	{
        	                		alt41=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt41)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1175:7: ARROW_TOK type[t2,check]
        	        	    {
        	        	         MATCHT(ARROW_TOK, &FOLLOW_ARROW_TOK_in_type3693);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_type_in_type3695);
        	        	        type(ctx, t2, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             args.push_back(t2); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             if(t2.isNull()) {
        	                    if(lhs) {
        	                      PARSER_STATE->parseError("improperly-placed type list; expected `->' after to define a function; or else maybe these parentheses were meant to be square brackets, to define a tuple type?");
        	                    }
        	                  } else {
        	                    t = EXPR_MANAGER->mkFunctionType(args);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1188:5: LET_TOK typeLetDecl[check] ( COMMA typeLetDecl[check] )* IN_TOK type[t,check]
        	    {
        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_type3720);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_typeLetDecl_in_type3728);
        	        typeLetDecl(ctx, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1189:24: ( COMMA typeLetDecl[check] )*

        	        for (;;)
        	        {
        	            int alt42=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt42=1;
        	            	}
        	                break;

        	            }

        	            switch (alt42)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1189:26: COMMA typeLetDecl[check]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_type3733);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_typeLetDecl_in_type3735);
        	        	        typeLetDecl(ctx, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop42;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop42: ; /* Jump out to here if this rule does not match */


        	         MATCHT(IN_TOK, &FOLLOW_IN_TOK_in_type3741);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_type3743);
        	        type(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope(); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletypeEx; /* Prevent compiler warnings */
    ruletypeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end type */

/**
 * $ANTLR start restrictedType
 * ../../../../src/parser/cvc/Cvc.g:1203:1: restrictedType[CVC4::Type& t,\n CVC4::parser::DeclarationCheck check] : restrictedTypePossiblyFunctionLHS[t,check,lhs] ;
 */
static void
restrictedType(pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */


      bool lhs;

    {
        // ../../../../src/parser/cvc/Cvc.g:1208:3: ( restrictedTypePossiblyFunctionLHS[t,check,lhs] )
        // ../../../../src/parser/cvc/Cvc.g:1208:5: restrictedTypePossiblyFunctionLHS[t,check,lhs]
        {
            FOLLOWPUSH(FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3779);
            restrictedTypePossiblyFunctionLHS(ctx, t, check, lhs);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerestrictedTypeEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 if(lhs) { PARSER_STATE->parseError("improperly-placed type list; maybe these parentheses were meant to be square brackets, to define a tuple type?"); } 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulerestrictedTypeEx; /* Prevent compiler warnings */
    rulerestrictedTypeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end restrictedType */

/**
 * $ANTLR start restrictedTypePossiblyFunctionLHS
 * ../../../../src/parser/cvc/Cvc.g:1216:1: restrictedTypePossiblyFunctionLHS[CVC4::Type& t,\n CVC4::parser::DeclarationCheck check,\n bool& lhs] : ( identifier[id,check,SYM_SORT] ( parameterization[check,types] )? | ARRAY_TOK restrictedType[t,check] OF_TOK restrictedType[t2,check] | SET_TOK OF_TOK restrictedType[t,check] | SUBTYPE_TOK LPAREN formula[f] ( COMMA formula[f2] )? RPAREN | LBRACKET k1= bound DOTDOT k2= bound RBRACKET | LBRACKET ( type[t,check] ( COMMA type[t,check] )* )? RBRACKET | SQHASH ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )? HASHSQ | BITVECTOR_TOK LPAREN k= numeral RPAREN | STRING_TOK | BOOLEAN_TOK | REAL_TOK | INT_TOK | LPAREN type[t,check] ( COMMA type[t,check] )* RPAREN );
 */
static void
restrictedTypePossiblyFunctionLHS(pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check, bool& lhs)
{
    CVC4::parser::cvc::mySubrangeBound k1;
    #undef	RETURN_TYPE_k1
    #define	RETURN_TYPE_k1 CVC4::parser::cvc::mySubrangeBound

    CVC4::parser::cvc::mySubrangeBound k2;
    #undef	RETURN_TYPE_k2
    #define	RETURN_TYPE_k2 CVC4::parser::cvc::mySubrangeBound

    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    /* Initialize rule variables
     */


      Type t2;
      Expr f, f2;
      std::string id;
      std::vector<Type> types;
      std::vector< std::pair<std::string, Type> > typeIds;
      //SymbolTable* symtab;
      Parser* parser;
      lhs = false;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1230:3: ( identifier[id,check,SYM_SORT] ( parameterization[check,types] )? | ARRAY_TOK restrictedType[t,check] OF_TOK restrictedType[t2,check] | SET_TOK OF_TOK restrictedType[t,check] | SUBTYPE_TOK LPAREN formula[f] ( COMMA formula[f2] )? RPAREN | LBRACKET k1= bound DOTDOT k2= bound RBRACKET | LBRACKET ( type[t,check] ( COMMA type[t,check] )* )? RBRACKET | SQHASH ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )? HASHSQ | BITVECTOR_TOK LPAREN k= numeral RPAREN | STRING_TOK | BOOLEAN_TOK | REAL_TOK | INT_TOK | LPAREN type[t,check] ( COMMA type[t,check] )* RPAREN )

            ANTLR3_UINT32 alt51;

            alt51=13;

            switch ( LA(1) )
            {
            case IDENTIFIER:
            	{
            		alt51=1;
            	}
                break;
            case ARRAY_TOK:
            	{
            		alt51=2;
            	}
                break;
            case SET_TOK:
            	{
            		alt51=3;
            	}
                break;
            case SUBTYPE_TOK:
            	{
            		alt51=4;
            	}
                break;
            case LBRACKET:
            	{
            		switch ( LA(2) )
            		{
            		case INTEGER_LITERAL:
            		case MINUS_TOK:
            		case UNDERSCORE:
            			{
            				alt51=5;
            			}
            		    break;
            		case ARRAY_TOK:
            		case BITVECTOR_TOK:
            		case BOOLEAN_TOK:
            		case IDENTIFIER:
            		case INT_TOK:
            		case LBRACKET:
            		case LET_TOK:
            		case LPAREN:
            		case RBRACKET:
            		case REAL_TOK:
            		case SET_TOK:
            		case SQHASH:
            		case STRING_TOK:
            		case SUBTYPE_TOK:
            			{
            				alt51=6;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 51;
            		    EXCEPTION->state        = 5;


            		    goto rulerestrictedTypePossiblyFunctionLHSEx;

            		}

            	}
                break;
            case SQHASH:
            	{
            		alt51=7;
            	}
                break;
            case BITVECTOR_TOK:
            	{
            		alt51=8;
            	}
                break;
            case STRING_TOK:
            	{
            		alt51=9;
            	}
                break;
            case BOOLEAN_TOK:
            	{
            		alt51=10;
            	}
                break;
            case REAL_TOK:
            	{
            		alt51=11;
            	}
                break;
            case INT_TOK:
            	{
            		alt51=12;
            	}
                break;
            case LPAREN:
            	{
            		alt51=13;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 51;
                EXCEPTION->state        = 0;


                goto rulerestrictedTypePossiblyFunctionLHSEx;

            }

            switch (alt51)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1230:5: identifier[id,check,SYM_SORT] ( parameterization[check,types] )?
        	    {
        	        FOLLOWPUSH(FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3813);
        	        identifier(ctx, id, check, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1231:5: ( parameterization[check,types] )?
        	        {
        	            int alt44=2;
        	            switch ( LA(1) )
        	            {
        	                case LBRACKET:
        	                	{
        	                		switch ( LA(2) )
        	                		{
        	                		    case IDENTIFIER:
        	                		    	{
        	                		    		switch ( LA(3) )
        	                		    		{
        	                		    		    case COMMA:
        	                		    		    case LBRACKET:
        	                		    		    case RBRACKET:
        	                		    		    	{
        	                		    		    		alt44=1;
        	                		    		    	}
        	                		    		        break;
        	                		    		}

        	                		    	}
        	                		        break;
        	                		    case ARRAY_TOK:
        	                		    case BITVECTOR_TOK:
        	                		    case BOOLEAN_TOK:
        	                		    case INT_TOK:
        	                		    case LBRACKET:
        	                		    case LPAREN:
        	                		    case REAL_TOK:
        	                		    case SET_TOK:
        	                		    case SQHASH:
        	                		    case STRING_TOK:
        	                		    case SUBTYPE_TOK:
        	                		    	{
        	                		    		alt44=1;
        	                		    	}
        	                		        break;
        	                		}

        	                	}
        	                    break;
        	            }

        	            switch (alt44)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1231:5: parameterization[check,types]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3820);
        	        	        parameterization(ctx, check, types);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {

        	                  if(check == CHECK_DECLARED ||
        	                     PARSER_STATE->isDeclared(id, SYM_SORT)) {
        	                    Debug("parser-param") << "param: getSort " << id << " " << types.size() << " " << PARSER_STATE->getArity( id )
        	                                          << " " << PARSER_STATE->isDeclared(id, SYM_SORT) << std::endl;
        	                    if(types.size() != PARSER_STATE->getArity(id)) {
        	                      std::stringstream ss;
        	                      ss << "incorrect arity for symbol `" << id << "': expected "
        	                         << PARSER_STATE->getArity( id ) << " type arguments, got "
        	                         << types.size();
        	                      PARSER_STATE->parseError(ss.str());
        	                    }
        	                    if(types.size() > 0) {
        	                      t = PARSER_STATE->getSort(id, types);
        	                    }else{
        	                      t = PARSER_STATE->getSort(id);
        	                    }
        	                  } else {
        	                    if(types.empty()) {
        	                      t = PARSER_STATE->mkUnresolvedType(id);
        	                      Debug("parser-param") << "param: make unres type " << id << std::endl;
        	                    }else{
        	                      t = PARSER_STATE->mkUnresolvedTypeConstructor(id,types);
        	                      t = SortConstructorType(t).instantiate( types );
        	                      Debug("parser-param") << "param: make unres param type " << id << " " << types.size() << " "
        	                                            << PARSER_STATE->getArity( id ) << std::endl;
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1263:5: ARRAY_TOK restrictedType[t,check] OF_TOK restrictedType[t2,check]
        	    {
        	         MATCHT(ARRAY_TOK, &FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3841);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3843);
        	        restrictedType(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(OF_TOK, &FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3846);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3848);
        	        restrictedType(ctx, t2, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->mkArrayType(t, t2); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:1265:5: SET_TOK OF_TOK restrictedType[t,check]
        	    {
        	         MATCHT(SET_TOK, &FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3861);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(OF_TOK, &FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3863);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3865);
        	        restrictedType(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->mkSetType(t); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/cvc/Cvc.g:1269:5: SUBTYPE_TOK LPAREN formula[f] ( COMMA formula[f2] )? RPAREN
        	    {
        	         MATCHT(SUBTYPE_TOK, &FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3888);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3890);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             /*symtab = PARSER_STATE->getSymbolTable();
        	                  PARSER_STATE->useDeclarationsFrom(new SymbolTable());*/ 
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3908);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1276:16: ( COMMA formula[f2] )?
        	        {
        	            int alt45=2;
        	            switch ( LA(1) )
        	            {
        	                case COMMA:
        	                	{
        	                		alt45=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt45)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1276:18: COMMA formula[f2]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3913);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3915);
        	        	        formula(ctx, f2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3921);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             /*SymbolTable* old = PARSER_STATE->getSymbolTable();
        	                  PARSER_STATE->useDeclarationsFrom(symtab);
        	                  delete old;*/
        	                  PARSER_STATE->unimplementedFeature("predicate subtyping not supported in this release");
        	                  /*t = f2.isNull() ?
        	                    EXPR_MANAGER->mkPredicateSubtype(f) :
        	                    EXPR_MANAGER->mkPredicateSubtype(f, f2);
        	                  */
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/cvc/Cvc.g:1288:5: LBRACKET k1= bound DOTDOT k2= bound RBRACKET
        	    {
        	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3940);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3944);
        	        k1=bound(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(DOTDOT, &FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3946);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3950);
        	        k2=bound(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3952);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(k1.hasBound() && k2.hasBound() &&
        	                     k1.getBound() > k2.getBound()) {
        	                    std::stringstream ss;
        	                    ss << "Subrange [" << k1.getBound() << ".." << k2.getBound()
        	                       << "] inappropriate: range must be nonempty!";
        	                    PARSER_STATE->parseError(ss.str());
        	                  }
        	                  t = EXPR_MANAGER->mkSubrangeType(SubrangeBounds(k1, k2));
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/cvc/Cvc.g:1300:5: LBRACKET ( type[t,check] ( COMMA type[t,check] )* )? RBRACKET
        	    {
        	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3971);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1300:14: ( type[t,check] ( COMMA type[t,check] )* )?
        	        {
        	            int alt47=2;
        	            switch ( LA(1) )
        	            {
        	                case ARRAY_TOK:
        	                case BITVECTOR_TOK:
        	                case BOOLEAN_TOK:
        	                case IDENTIFIER:
        	                case INT_TOK:
        	                case LBRACKET:
        	                case LET_TOK:
        	                case LPAREN:
        	                case REAL_TOK:
        	                case SET_TOK:
        	                case SQHASH:
        	                case STRING_TOK:
        	                case SUBTYPE_TOK:
        	                	{
        	                		alt47=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt47)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1300:16: type[t,check] ( COMMA type[t,check] )*
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3975);
        	        	        type(ctx, t, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             types.push_back(t); 
        	        	        }


        	        	        // ../../../../src/parser/cvc/Cvc.g:1301:5: ( COMMA type[t,check] )*

        	        	        for (;;)
        	        	        {
        	        	            int alt46=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case COMMA:
        	        	            	{
        	        	            		alt46=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt46)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:1301:7: COMMA type[t,check]
        	        	        	    {
        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3986);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3988);
        	        	        	        type(ctx, t, check);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             types.push_back(t); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop46;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop46: ; /* Jump out to here if this rule does not match */


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3999);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(types.size() == 1 && types.front().isFunction()) {
        	                    // old style function syntax [ T -> U ]
        	                    PARSER_STATE->parseError("old-style function type syntax not supported anymore; please use the new syntax");
        	                  } else {
        	                    // tuple type [ T, U, V... ]
        	                    t = EXPR_MANAGER->mkTupleType(types);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/cvc/Cvc.g:1312:5: SQHASH ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )? HASHSQ
        	    {
        	         MATCHT(SQHASH, &FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4018);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1312:12: ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )?
        	        {
        	            int alt49=2;
        	            switch ( LA(1) )
        	            {
        	                case IDENTIFIER:
        	                	{
        	                		alt49=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt49)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1312:14: identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )*
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4022);
        	        	        identifier(ctx, id, CHECK_NONE, SYM_SORT);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	         MATCHT(COLON, &FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4025);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4027);
        	        	        type(ctx, t, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             typeIds.push_back(std::make_pair(id, t)); 
        	        	        }


        	        	        // ../../../../src/parser/cvc/Cvc.g:1313:5: ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )*

        	        	        for (;;)
        	        	        {
        	        	            int alt48=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case COMMA:
        	        	            	{
        	        	            		alt48=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt48)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:1313:7: COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check]
        	        	        	    {
        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4038);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4040);
        	        	        	        identifier(ctx, id, CHECK_NONE, SYM_SORT);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	         MATCHT(COLON, &FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4043);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4045);
        	        	        	        type(ctx, t, check);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             typeIds.push_back(std::make_pair(id, t)); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop48;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop48: ; /* Jump out to here if this rule does not match */


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(HASHSQ, &FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4056);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->mkRecordType(typeIds); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/cvc/Cvc.g:1317:5: BITVECTOR_TOK LPAREN k= numeral RPAREN
        	    {
        	         MATCHT(BITVECTOR_TOK, &FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4075);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4077);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4081);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4083);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(k == 0) {
        	                    PARSER_STATE->parseError("Illegal bitvector size: 0");
        	                  }
        	                  t = EXPR_MANAGER->mkBitVectorType(k);
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/cvc/Cvc.g:1325:5: STRING_TOK
        	    {
        	         MATCHT(STRING_TOK, &FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4102);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->stringType(); 
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/cvc/Cvc.g:1328:5: BOOLEAN_TOK
        	    {
        	         MATCHT(BOOLEAN_TOK, &FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4117);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->booleanType(); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/cvc/Cvc.g:1329:5: REAL_TOK
        	    {
        	         MATCHT(REAL_TOK, &FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4125);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->realType(); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/cvc/Cvc.g:1330:5: INT_TOK
        	    {
        	         MATCHT(INT_TOK, &FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4133);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->integerType(); 
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/cvc/Cvc.g:1335:5: LPAREN type[t,check] ( COMMA type[t,check] )* RPAREN
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4148);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4150);
        	        type(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             types.push_back(t); 
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1336:5: ( COMMA type[t,check] )*

        	        for (;;)
        	        {
        	            int alt50=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt50=1;
        	            	}
        	                break;

        	            }

        	            switch (alt50)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1336:7: COMMA type[t,check]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4161);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4163);
        	        	        type(ctx, t, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             lhs = true; types.push_back(t); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop50;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop50: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4171);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(lhs) { t = EXPR_MANAGER->mkTupleType(types); }
        	                  // if !lhs, t is already set up correctly, nothing to do..
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulerestrictedTypePossiblyFunctionLHSEx; /* Prevent compiler warnings */
    rulerestrictedTypePossiblyFunctionLHSEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end restrictedTypePossiblyFunctionLHS */

/**
 * $ANTLR start parameterization
 * ../../../../src/parser/cvc/Cvc.g:1342:1: parameterization[CVC4::parser::DeclarationCheck check,\n std::vector<CVC4::Type>& params] : LBRACKET restrictedType[t,check] ( COMMA restrictedType[t,check] )* RBRACKET ;
 */
static void
parameterization(pCvcParser ctx, CVC4::parser::DeclarationCheck check, std::vector<CVC4::Type>& params)
{
    /* Initialize rule variables
     */


      Type t;

    {
        // ../../../../src/parser/cvc/Cvc.g:1347:3: ( LBRACKET restrictedType[t,check] ( COMMA restrictedType[t,check] )* RBRACKET )
        // ../../../../src/parser/cvc/Cvc.g:1347:5: LBRACKET restrictedType[t,check] ( COMMA restrictedType[t,check] )* RBRACKET
        {
             MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_parameterization4196);
            if  (HASEXCEPTION())
            {
                goto ruleparameterizationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_restrictedType_in_parameterization4198);
            restrictedType(ctx, t, check);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleparameterizationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 Debug("parser-param") << "t = " << t << std::endl; params.push_back( t ); 
            }


            // ../../../../src/parser/cvc/Cvc.g:1348:5: ( COMMA restrictedType[t,check] )*

            for (;;)
            {
                int alt52=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt52=1;
                	}
                    break;

                }

                switch (alt52)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1348:7: COMMA restrictedType[t,check]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_parameterization4209);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleparameterizationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_restrictedType_in_parameterization4211);
            	        restrictedType(ctx, t, check);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleparameterizationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             Debug("parser-param") << "t = " << t << std::endl; params.push_back( t ); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop52;	/* break out of the loop */
            	    break;
                }
            }
            loop52: ; /* Jump out to here if this rule does not match */


             MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_parameterization4219);
            if  (HASEXCEPTION())
            {
                goto ruleparameterizationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleparameterizationEx; /* Prevent compiler warnings */
    ruleparameterizationEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end parameterization */

/**
 * $ANTLR start bound
 * ../../../../src/parser/cvc/Cvc.g:1351:1: bound returns [CVC4::parser::cvc::mySubrangeBound bound] : ( UNDERSCORE |k= integer );
 */
static CVC4::parser::cvc::mySubrangeBound
bound(pCvcParser ctx)
{
    CVC4::parser::cvc::mySubrangeBound bound;


    CVC4::Rational k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k CVC4::Rational

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1352:3: ( UNDERSCORE |k= integer )

            ANTLR3_UINT32 alt53;

            alt53=2;

            switch ( LA(1) )
            {
            case UNDERSCORE:
            	{
            		alt53=1;
            	}
                break;
            case INTEGER_LITERAL:
            case MINUS_TOK:
            	{
            		alt53=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return bound;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 53;
                EXCEPTION->state        = 0;


                goto ruleboundEx;

            }

            switch (alt53)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1352:5: UNDERSCORE
        	    {
        	         MATCHT(UNDERSCORE, &FOLLOW_UNDERSCORE_in_bound4236);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleboundEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return bound;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             bound= SubrangeBound();
        	             
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1353:5: k= integer
        	    {
        	        FOLLOWPUSH(FOLLOW_integer_in_bound4246);
        	        k=integer(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleboundEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return bound;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             bound= SubrangeBound(k.getNumerator());
        	             
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleboundEx; /* Prevent compiler warnings */
    ruleboundEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return bound;
}
/* $ANTLR end bound */

/**
 * $ANTLR start typeLetDecl
 * ../../../../src/parser/cvc/Cvc.g:1356:1: typeLetDecl[CVC4::parser::DeclarationCheck check] : identifier[id,CHECK_NONE,SYM_SORT] ( COLON TYPE_TOK )? EQUAL_TOK restrictedType[t,check] ;
 */
static void
typeLetDecl(pCvcParser ctx, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */


      Type t;
      std::string id;

    {
        // ../../../../src/parser/cvc/Cvc.g:1361:3: ( identifier[id,CHECK_NONE,SYM_SORT] ( COLON TYPE_TOK )? EQUAL_TOK restrictedType[t,check] )
        // ../../../../src/parser/cvc/Cvc.g:1361:5: identifier[id,CHECK_NONE,SYM_SORT] ( COLON TYPE_TOK )? EQUAL_TOK restrictedType[t,check]
        {
            FOLLOWPUSH(FOLLOW_identifier_in_typeLetDecl4265);
            identifier(ctx, id, CHECK_NONE, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletypeLetDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:1361:40: ( COLON TYPE_TOK )?
            {
                int alt54=2;
                switch ( LA(1) )
                {
                    case COLON:
                    	{
                    		alt54=1;
                    	}
                        break;
                }

                switch (alt54)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1361:41: COLON TYPE_TOK
            	    {
            	         MATCHT(COLON, &FOLLOW_COLON_in_typeLetDecl4269);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletypeLetDeclEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_typeLetDecl4271);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletypeLetDeclEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

             MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_typeLetDecl4275);
            if  (HASEXCEPTION())
            {
                goto ruletypeLetDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_restrictedType_in_typeLetDecl4277);
            restrictedType(ctx, t, check);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletypeLetDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 PARSER_STATE->defineType(id, t); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletypeLetDeclEx; /* Prevent compiler warnings */
    ruletypeLetDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end typeLetDecl */

/**
 * $ANTLR start formula
 * ../../../../src/parser/cvc/Cvc.g:1372:1: formula[CVC4::Expr& f] : n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) ;
 */
static void
formula(pCvcParser ctx, CVC4::Expr& f)
{
    size_t n;
    #undef	RETURN_TYPE_n
    #define	RETURN_TYPE_n size_t

    /* Initialize rule variables
     */


      Debug("parser-extra") << "formula: " << AntlrInput::tokenText(LT(1)) << std::endl;
      Expr f2;
      std::vector<CVC4::Expr> expressions;
      std::vector<unsigned> operators;
      unsigned op;

    {
        // ../../../../src/parser/cvc/Cvc.g:1380:3: (n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) )
        // ../../../../src/parser/cvc/Cvc.g:1380:5: n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
        {
            FOLLOWPUSH(FOLLOW_nots_in_formula4307);
            n=nots(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleformulaEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:1381:5: ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
            {
                int alt56=2;
                switch ( LA(1) )
                {
                case EXISTS_TOK:
                case FORALL_TOK:
                case LAMBDA:
                case LET_TOK:
                	{
                		alt56=1;
                	}
                    break;
                case ABS_TOK:
                case ARRAY_TOK:
                case BAR:
                case BINARY_LITERAL:
                case BVASHR_TOK:
                case BVCOMP_TOK:
                case BVGE_TOK:
                case BVGT_TOK:
                case BVLE_TOK:
                case BVLSHR_TOK:
                case BVLT_TOK:
                case BVMULT_TOK:
                case BVNAND_TOK:
                case BVNEG_TOK:
                case BVNOR_TOK:
                case BVPLUS_TOK:
                case BVREPEAT_TOK:
                case BVROTL_TOK:
                case BVROTR_TOK:
                case BVSDIV_TOK:
                case BVSGE_TOK:
                case BVSGT_TOK:
                case BVSHL_TOK:
                case BVSLE_TOK:
                case BVSLT_TOK:
                case BVSMOD_TOK:
                case BVSREM_TOK:
                case BVSUB_TOK:
                case BVUDIV_TOK:
                case BVUMINUS_TOK:
                case BVUREM_TOK:
                case BVXNOR_TOK:
                case BVXOR_TOK:
                case BVZEROEXTEND_TOK:
                case DECIMAL_LITERAL:
                case DISTINCT_TOK:
                case DIVISIBLE_TOK:
                case FALSE_TOK:
                case FLOOR_TOK:
                case HEX_LITERAL:
                case IDENTIFIER:
                case IDEN_TOK:
                case IF_TOK:
                case INTEGER_LITERAL:
                case IS_INTEGER_TOK:
                case LBRACE:
                case LPAREN:
                case MINUS_TOK:
                case PARENHASH:
                case SETS_CARD_TOK:
                case STRING_CONCAT_TOK:
                case STRING_CONTAINS_TOK:
                case STRING_INDEXOF_TOK:
                case STRING_ITOS_TOK:
                case STRING_LENGTH_TOK:
                case STRING_LITERAL:
                case STRING_PREFIXOF_TOK:
                case STRING_REPLACE_TOK:
                case STRING_STOI_TOK:
                case STRING_STOU16_TOK:
                case STRING_STOU32_TOK:
                case STRING_SUBSTR_TOK:
                case STRING_SUFFIXOF_TOK:
                case STRING_U16TOS_TOK:
                case STRING_U32TOS_TOK:
                case SX_TOK:
                case TRANSCLOSURE_TOK:
                case TRANSPOSE_TOK:
                case TRUE_TOK:
                case TUPLE_TOK:
                case UNIVSET_TOK:
                	{
                		alt56=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 56;
                    EXCEPTION->state        = 0;


                    goto ruleformulaEx;

                }

                switch (alt56)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1381:7: prefixFormula[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_prefixFormula_in_formula4315);
            	        prefixFormula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleformulaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = addNots(EXPR_MANAGER, n, f); 
            	        }


            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:1383:7: comparison[f] ( morecomparisons[expressions,operators] )?
            	    {
            	        FOLLOWPUSH(FOLLOW_comparison_in_formula4332);
            	        comparison(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleformulaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = addNots(EXPR_MANAGER, n, f);
            	                    expressions.push_back(f);
            	                  
            	        }


            	        // ../../../../src/parser/cvc/Cvc.g:1387:7: ( morecomparisons[expressions,operators] )?
            	        {
            	            int alt55=2;
            	            switch ( LA(1) )
            	            {
            	                case AND_TOK:
            	                case IFF_TOK:
            	                case IMPLIES_TOK:
            	                case JOIN_IMAGE_TOK:
            	                case JOIN_TOK:
            	                case OR_TOK:
            	                case PRODUCT_TOK:
            	                case XOR_TOK:
            	                	{
            	                		alt55=1;
            	                	}
            	                    break;
            	            }

            	            switch (alt55)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1387:7: morecomparisons[expressions,operators]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_morecomparisons_in_formula4349);
            	        	        morecomparisons(ctx, expressions, operators);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleformulaEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;

            	            }
            	        }

            	        if ( BACKTRACKING==0 )
            	        {
            	             f = createPrecedenceTree(PARSER_STATE, EXPR_MANAGER, expressions, operators); 
            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruleformulaEx; /* Prevent compiler warnings */
    ruleformulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end formula */

/**
 * $ANTLR start morecomparisons
 * ../../../../src/parser/cvc/Cvc.g:1392:1: morecomparisons[std::vector<CVC4::Expr>& expressions,\n std::vector<unsigned>& operators] returns [size_t i = 0] : booleanBinop[op] n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) ;
 */
static size_t
morecomparisons(pCvcParser ctx, std::vector<CVC4::Expr>& expressions, std::vector<unsigned>& operators)
{
    size_t i;


    size_t n;
    #undef	RETURN_TYPE_n
    #define	RETURN_TYPE_n size_t

    /* Initialize rule variables
     */
    i =  0;



      unsigned op;
      Expr f;
      i= expressions.size();


    {
        // ../../../../src/parser/cvc/Cvc.g:1399:3: ( booleanBinop[op] n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) )
        // ../../../../src/parser/cvc/Cvc.g:1399:5: booleanBinop[op] n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
        {
            FOLLOWPUSH(FOLLOW_booleanBinop_in_morecomparisons4388);
            booleanBinop(ctx, op);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulemorecomparisonsEx;
            }
            if (HASFAILED())
            {
                return i;
            }


            if ( BACKTRACKING==0 )
            {
                 operators.push_back(op); 
            }


            FOLLOWPUSH(FOLLOW_nots_in_morecomparisons4399);
            n=nots(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulemorecomparisonsEx;
            }
            if (HASFAILED())
            {
                return i;
            }


            // ../../../../src/parser/cvc/Cvc.g:1401:5: ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
            {
                int alt58=2;
                switch ( LA(1) )
                {
                case EXISTS_TOK:
                case FORALL_TOK:
                case LAMBDA:
                case LET_TOK:
                	{
                		alt58=1;
                	}
                    break;
                case ABS_TOK:
                case ARRAY_TOK:
                case BAR:
                case BINARY_LITERAL:
                case BVASHR_TOK:
                case BVCOMP_TOK:
                case BVGE_TOK:
                case BVGT_TOK:
                case BVLE_TOK:
                case BVLSHR_TOK:
                case BVLT_TOK:
                case BVMULT_TOK:
                case BVNAND_TOK:
                case BVNEG_TOK:
                case BVNOR_TOK:
                case BVPLUS_TOK:
                case BVREPEAT_TOK:
                case BVROTL_TOK:
                case BVROTR_TOK:
                case BVSDIV_TOK:
                case BVSGE_TOK:
                case BVSGT_TOK:
                case BVSHL_TOK:
                case BVSLE_TOK:
                case BVSLT_TOK:
                case BVSMOD_TOK:
                case BVSREM_TOK:
                case BVSUB_TOK:
                case BVUDIV_TOK:
                case BVUMINUS_TOK:
                case BVUREM_TOK:
                case BVXNOR_TOK:
                case BVXOR_TOK:
                case BVZEROEXTEND_TOK:
                case DECIMAL_LITERAL:
                case DISTINCT_TOK:
                case DIVISIBLE_TOK:
                case FALSE_TOK:
                case FLOOR_TOK:
                case HEX_LITERAL:
                case IDENTIFIER:
                case IDEN_TOK:
                case IF_TOK:
                case INTEGER_LITERAL:
                case IS_INTEGER_TOK:
                case LBRACE:
                case LPAREN:
                case MINUS_TOK:
                case PARENHASH:
                case SETS_CARD_TOK:
                case STRING_CONCAT_TOK:
                case STRING_CONTAINS_TOK:
                case STRING_INDEXOF_TOK:
                case STRING_ITOS_TOK:
                case STRING_LENGTH_TOK:
                case STRING_LITERAL:
                case STRING_PREFIXOF_TOK:
                case STRING_REPLACE_TOK:
                case STRING_STOI_TOK:
                case STRING_STOU16_TOK:
                case STRING_STOU32_TOK:
                case STRING_SUBSTR_TOK:
                case STRING_SUFFIXOF_TOK:
                case STRING_U16TOS_TOK:
                case STRING_U32TOS_TOK:
                case SX_TOK:
                case TRANSCLOSURE_TOK:
                case TRANSPOSE_TOK:
                case TRUE_TOK:
                case TUPLE_TOK:
                case UNIVSET_TOK:
                	{
                		alt58=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return i;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 58;
                    EXCEPTION->state        = 0;


                    goto rulemorecomparisonsEx;

                }

                switch (alt58)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1401:7: prefixFormula[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_prefixFormula_in_morecomparisons4407);
            	        prefixFormula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulemorecomparisonsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return i;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             expressions.push_back(addNots(EXPR_MANAGER, n, f)); 
            	        }


            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:1403:7: comparison[f] ( morecomparisons[expressions,operators] )?
            	    {
            	        FOLLOWPUSH(FOLLOW_comparison_in_morecomparisons4424);
            	        comparison(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulemorecomparisonsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return i;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = addNots(EXPR_MANAGER, n, f);
            	                    expressions.push_back(f);
            	                  
            	        }


            	        // ../../../../src/parser/cvc/Cvc.g:1407:7: ( morecomparisons[expressions,operators] )?
            	        {
            	            int alt57=2;
            	            switch ( LA(1) )
            	            {
            	                case AND_TOK:
            	                case IFF_TOK:
            	                case IMPLIES_TOK:
            	                case JOIN_IMAGE_TOK:
            	                case JOIN_TOK:
            	                case OR_TOK:
            	                case PRODUCT_TOK:
            	                case XOR_TOK:
            	                	{
            	                		alt57=1;
            	                	}
            	                    break;
            	            }

            	            switch (alt57)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1407:7: morecomparisons[expressions,operators]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_morecomparisons_in_morecomparisons4441);
            	        	        morecomparisons(ctx, expressions, operators);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulemorecomparisonsEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return i;
            	        	        }


            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulemorecomparisonsEx; /* Prevent compiler warnings */
    rulemorecomparisonsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return i;
}
/* $ANTLR end morecomparisons */

/**
 * $ANTLR start nots
 * ../../../../src/parser/cvc/Cvc.g:1412:1: nots returns [size_t n = 0] : ( NOT_TOK )* ;
 */
static size_t
nots(pCvcParser ctx)
{
    size_t n;


    /* Initialize rule variables
     */
    n =  0;


    {
        // ../../../../src/parser/cvc/Cvc.g:1413:3: ( ( NOT_TOK )* )
        // ../../../../src/parser/cvc/Cvc.g:1413:5: ( NOT_TOK )*
        {
            // ../../../../src/parser/cvc/Cvc.g:1413:5: ( NOT_TOK )*

            for (;;)
            {
                int alt59=2;
                switch ( LA(1) )
                {
                case NOT_TOK:
                	{
                		alt59=1;
                	}
                    break;

                }

                switch (alt59)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1413:7: NOT_TOK
            	    {
            	         MATCHT(NOT_TOK, &FOLLOW_NOT_TOK_in_nots4470);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulenotsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return n;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             ++n
            	            ; 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop59;	/* break out of the loop */
            	    break;
                }
            }
            loop59: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulenotsEx; /* Prevent compiler warnings */
    rulenotsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return n;
}
/* $ANTLR end nots */

/**
 * $ANTLR start prefixFormula
 * ../../../../src/parser/cvc/Cvc.g:1416:1: prefixFormula[CVC4::Expr& f] : ( ( FORALL_TOK | EXISTS_TOK ) LPAREN boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* RPAREN COLON ( instantiationPatterns[ipl] )? formula[f] | LET_TOK letDecl ( COMMA letDecl )* IN_TOK formula[f] | LAMBDA LPAREN boundVarDeclsReturn[terms,types] RPAREN COLON formula[f] );
 */
static void
prefixFormula(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      std::vector<Expr> terms;
      std::vector<Type> types;
      std::vector<Expr> bvs;
      Type t;
      Kind k;
      Expr ipl;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1427:3: ( ( FORALL_TOK | EXISTS_TOK ) LPAREN boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* RPAREN COLON ( instantiationPatterns[ipl] )? formula[f] | LET_TOK letDecl ( COMMA letDecl )* IN_TOK formula[f] | LAMBDA LPAREN boundVarDeclsReturn[terms,types] RPAREN COLON formula[f] )

            ANTLR3_UINT32 alt64;

            alt64=3;

            switch ( LA(1) )
            {
            case EXISTS_TOK:
            case FORALL_TOK:
            	{
            		alt64=1;
            	}
                break;
            case LET_TOK:
            	{
            		alt64=2;
            	}
                break;
            case LAMBDA:
            	{
            		alt64=3;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 64;
                EXCEPTION->state        = 0;


                goto ruleprefixFormulaEx;

            }

            switch (alt64)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1427:5: ( FORALL_TOK | EXISTS_TOK ) LPAREN boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* RPAREN COLON ( instantiationPatterns[ipl] )? formula[f]
        	    {
        	        // ../../../../src/parser/cvc/Cvc.g:1427:5: ( FORALL_TOK | EXISTS_TOK )
        	        {
        	            int alt60=2;
        	            switch ( LA(1) )
        	            {
        	            case FORALL_TOK:
        	            	{
        	            		alt60=1;
        	            	}
        	                break;
        	            case EXISTS_TOK:
        	            	{
        	            		alt60=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 60;
        	                EXCEPTION->state        = 0;


        	                goto ruleprefixFormulaEx;

        	            }

        	            switch (alt60)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1427:7: FORALL_TOK
        	        	    {
        	        	         MATCHT(FORALL_TOK, &FOLLOW_FORALL_TOK_in_prefixFormula4502);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             k = kind::FORALL; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1427:42: EXISTS_TOK
        	        	    {
        	        	         MATCHT(EXISTS_TOK, &FOLLOW_EXISTS_TOK_in_prefixFormula4508);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             k = kind::EXISTS; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_prefixFormula4520);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_boundVarDecl_in_prefixFormula4526);
        	        boundVarDecl(ctx, ids, t);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             for(std::vector<std::string>::const_iterator i = ids.begin(); i != ids.end(); ++i) {
        	                    bvs.push_back(PARSER_STATE->mkBoundVar(*i, t));
        	                  }
        	                  ids.clear();
        	                
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1435:5: ( COMMA boundVarDecl[ids,t] )*

        	        for (;;)
        	        {
        	            int alt61=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt61=1;
        	            	}
        	                break;

        	            }

        	            switch (alt61)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1435:7: COMMA boundVarDecl[ids,t]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_prefixFormula4541);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_boundVarDecl_in_prefixFormula4543);
        	        	        boundVarDecl(ctx, ids, t);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {

        	        	                    for(std::vector<std::string>::const_iterator i = ids.begin(); i != ids.end(); ++i) {
        	        	                      bvs.push_back(PARSER_STATE->mkBoundVar(*i, t));
        	        	                    }
        	        	                    ids.clear();
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop61;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop61: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_prefixFormula4561);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  terms.push_back( EXPR_MANAGER->mkExpr( kind::BOUND_VAR_LIST, bvs ) ); 
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_prefixFormula4569);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1444:11: ( instantiationPatterns[ipl] )?
        	        {
        	            int alt62=2;
        	            switch ( LA(1) )
        	            {
        	                case PATTERN_TOK:
        	                	{
        	                		alt62=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt62)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1444:11: instantiationPatterns[ipl]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_instantiationPatterns_in_prefixFormula4571);
        	        	        instantiationPatterns(ctx, ipl);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        FOLLOWPUSH(FOLLOW_formula_in_prefixFormula4575);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  terms.push_back(f);
        	                  if(! ipl.isNull()) {
        	                    terms.push_back(ipl);
        	                  }
        	                  f = MK_EXPR(k, terms);
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1456:5: LET_TOK letDecl ( COMMA letDecl )* IN_TOK formula[f]
        	    {
        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_prefixFormula4594);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_letDecl_in_prefixFormula4602);
        	        letDecl(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1457:13: ( COMMA letDecl )*

        	        for (;;)
        	        {
        	            int alt63=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt63=1;
        	            	}
        	                break;

        	            }

        	            switch (alt63)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1457:15: COMMA letDecl
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_prefixFormula4606);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_letDecl_in_prefixFormula4608);
        	        	        letDecl(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop63;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop63: ; /* Jump out to here if this rule does not match */


        	         MATCHT(IN_TOK, &FOLLOW_IN_TOK_in_prefixFormula4617);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_prefixFormula4619);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope(); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:1461:5: LAMBDA LPAREN boundVarDeclsReturn[terms,types] RPAREN COLON formula[f]
        	    {
        	         MATCHT(LAMBDA, &FOLLOW_LAMBDA_in_prefixFormula4634);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_prefixFormula4638);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_boundVarDeclsReturn_in_prefixFormula4644);
        	        boundVarDeclsReturn(ctx, terms, types);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_prefixFormula4651);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_prefixFormula4653);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_prefixFormula4655);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  Type t = EXPR_MANAGER->mkFunctionType(types, f.getType());
        	                  std::string name = "lambda";
        	                  Expr func = PARSER_STATE->mkAnonymousFunction(name, t, ExprManager::VAR_FLAG_DEFINED);
        	                  Command* cmd = new DefineFunctionCommand(name, func, terms, f);
        	                  PARSER_STATE->preemptCommand(cmd);
        	                  f = func;
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleprefixFormulaEx; /* Prevent compiler warnings */
    ruleprefixFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end prefixFormula */

/**
 * $ANTLR start instantiationPatterns
 * ../../../../src/parser/cvc/Cvc.g:1474:1: instantiationPatterns[ CVC4::Expr& expr ] : ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+ ;
 */
static void
instantiationPatterns(pCvcParser ctx, CVC4::Expr& expr)
{
    /* Initialize rule variables
     */


      std::vector<Expr> args;
      Expr f;
      std::vector<Expr> patterns;

    {
        // ../../../../src/parser/cvc/Cvc.g:1480:3: ( ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+ )
        // ../../../../src/parser/cvc/Cvc.g:1480:5: ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+
        {
            // ../../../../src/parser/cvc/Cvc.g:1480:5: ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+
            {
                int cnt66=0;

                for (;;)
                {
                    int alt66=2;
            	switch ( LA(1) )
            	{
            	case PATTERN_TOK:
            		{
            			alt66=1;
            		}
            	    break;

            	}

            	switch (alt66)
            	{
            	    case 1:
            	        // ../../../../src/parser/cvc/Cvc.g:1480:7: PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON
            	        {
            	             MATCHT(PATTERN_TOK, &FOLLOW_PATTERN_TOK_in_instantiationPatterns4683);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	             MATCHT(LPAREN, &FOLLOW_LPAREN_in_instantiationPatterns4685);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            FOLLOWPUSH(FOLLOW_formula_in_instantiationPatterns4687);
            	            formula(ctx, f);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            if ( BACKTRACKING==0 )
            	            {
            	                 args.push_back( f ); 
            	            }


            	            // ../../../../src/parser/cvc/Cvc.g:1480:62: ( COMMA formula[f] )*

            	            for (;;)
            	            {
            	                int alt65=2;
            	                switch ( LA(1) )
            	                {
            	                case COMMA:
            	                	{
            	                		alt65=1;
            	                	}
            	                    break;

            	                }

            	                switch (alt65)
            	                {
            	            	case 1:
            	            	    // ../../../../src/parser/cvc/Cvc.g:1480:63: COMMA formula[f]
            	            	    {
            	            	         MATCHT(COMMA, &FOLLOW_COMMA_in_instantiationPatterns4693);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruleinstantiationPatternsEx;
            	            	        }
            	            	        if (HASFAILED())
            	            	        {
            	            	            return ;
            	            	        }


            	            	        FOLLOWPUSH(FOLLOW_formula_in_instantiationPatterns4695);
            	            	        formula(ctx, f);

            	            	        FOLLOWPOP();
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruleinstantiationPatternsEx;
            	            	        }
            	            	        if (HASFAILED())
            	            	        {
            	            	            return ;
            	            	        }


            	            	        if ( BACKTRACKING==0 )
            	            	        {
            	            	             args.push_back( f ); 
            	            	        }


            	            	    }
            	            	    break;

            	            	default:
            	            	    goto loop65;	/* break out of the loop */
            	            	    break;
            	                }
            	            }
            	            loop65: ; /* Jump out to here if this rule does not match */


            	             MATCHT(RPAREN, &FOLLOW_RPAREN_in_instantiationPatterns4703);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	             MATCHT(COLON, &FOLLOW_COLON_in_instantiationPatterns4705);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            if ( BACKTRACKING==0 )
            	            {
            	                 patterns.push_back( EXPR_MANAGER->mkExpr( kind::INST_PATTERN, args ) );
            	                        args.clear();
            	                      
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt66 >= 1 )
            		{
            		    goto loop66;
            		}
            		if (BACKTRACKING>0)
            		{
            		    FAILEDFLAG = ANTLR3_TRUE;
            		    return ;
            		}

            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruleinstantiationPatternsEx;
            	}
            	cnt66++;
                }
                loop66: ;	/* Jump to here if this rule does not match */
            }

            if ( BACKTRACKING==0 )
            {
                 if(! patterns.empty()) {
                       expr = EXPR_MANAGER->mkExpr( kind::INST_PATTERN_LIST, patterns );
                       }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleinstantiationPatternsEx; /* Prevent compiler warnings */
    ruleinstantiationPatternsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end instantiationPatterns */

/**
 * $ANTLR start letDecl
 * ../../../../src/parser/cvc/Cvc.g:1493:1: letDecl : identifier[name,CHECK_NONE,SYM_VARIABLE] EQUAL_TOK formula[e] ;
 */
static void
letDecl(pCvcParser ctx)
{
    /* Initialize rule variables
     */


      Expr e;
      std::string name;

    {
        // ../../../../src/parser/cvc/Cvc.g:1498:3: ( identifier[name,CHECK_NONE,SYM_VARIABLE] EQUAL_TOK formula[e] )
        // ../../../../src/parser/cvc/Cvc.g:1498:5: identifier[name,CHECK_NONE,SYM_VARIABLE] EQUAL_TOK formula[e]
        {
            FOLLOWPUSH(FOLLOW_identifier_in_letDecl4742);
            identifier(ctx, name, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleletDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_letDecl4745);
            if  (HASEXCEPTION())
            {
                goto ruleletDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_formula_in_letDecl4747);
            formula(ctx, e);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleletDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 Debug("parser") << language::SetLanguage(language::output::LANG_CVC4) << e.getType() << std::endl;
                      PARSER_STATE->defineVar(name, e);
                      Debug("parser") << "LET[" << PARSER_STATE->scopeLevel() << "]: "
                                      << name << std::endl
                                      << " ==>" << " " << e << std::endl;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleletDeclEx; /* Prevent compiler warnings */
    ruleletDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end letDecl */

/**
 * $ANTLR start booleanBinop
 * ../../../../src/parser/cvc/Cvc.g:1507:1: booleanBinop[unsigned& op] : ( IFF_TOK | IMPLIES_TOK | OR_TOK | XOR_TOK | AND_TOK | JOIN_TOK | PRODUCT_TOK | JOIN_IMAGE_TOK );
 */
static void
booleanBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // ../../../../src/parser/cvc/Cvc.g:1511:3: ( IFF_TOK | IMPLIES_TOK | OR_TOK | XOR_TOK | AND_TOK | JOIN_TOK | PRODUCT_TOK | JOIN_IMAGE_TOK )
        // ../../../../src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == AND_TOK || LA(1) == IFF_TOK || LA(1) == IMPLIES_TOK || ((LA(1) >= JOIN_IMAGE_TOK) && (LA(1) <= JOIN_TOK)) || LA(1) == OR_TOK || LA(1) == PRODUCT_TOK || LA(1) == XOR_TOK )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulebooleanBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebooleanBinopEx; /* Prevent compiler warnings */
    rulebooleanBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end booleanBinop */

/**
 * $ANTLR start comparison
 * ../../../../src/parser/cvc/Cvc.g:1521:1: comparison[CVC4::Expr& f] : term[f] ( comparisonBinop[op] term[f] )* ;
 */
static void
comparison(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<CVC4::Expr> expressions;
      std::vector<unsigned> operators;
      unsigned op;

    {
        // ../../../../src/parser/cvc/Cvc.g:1527:3: ( term[f] ( comparisonBinop[op] term[f] )* )
        // ../../../../src/parser/cvc/Cvc.g:1527:5: term[f] ( comparisonBinop[op] term[f] )*
        {
            FOLLOWPUSH(FOLLOW_term_in_comparison4836);
            term(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulecomparisonEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 expressions.push_back(f); 
            }


            // ../../../../src/parser/cvc/Cvc.g:1528:5: ( comparisonBinop[op] term[f] )*

            for (;;)
            {
                int alt67=2;
                switch ( LA(1) )
                {
                case DISEQUAL_TOK:
                case EQUAL_TOK:
                case FMF_CARD_TOK:
                case GEQ_TOK:
                case GT_TOK:
                case LEQ_TOK:
                case LT_TOK:
                case MEMBER_TOK:
                	{
                		alt67=1;
                	}
                    break;

                }

                switch (alt67)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1528:7: comparisonBinop[op] term[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_comparisonBinop_in_comparison4847);
            	        comparisonBinop(ctx, op);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecomparisonEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_comparison4850);
            	        term(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecomparisonEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             operators.push_back(op); expressions.push_back(f); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop67;	/* break out of the loop */
            	    break;
                }
            }
            loop67: ; /* Jump out to here if this rule does not match */


            if ( BACKTRACKING==0 )
            {
                 f = createPrecedenceTree(PARSER_STATE, EXPR_MANAGER, expressions, operators); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulecomparisonEx; /* Prevent compiler warnings */
    rulecomparisonEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end comparison */

/**
 * $ANTLR start comparisonBinop
 * ../../../../src/parser/cvc/Cvc.g:1533:1: comparisonBinop[unsigned& op] : ( EQUAL_TOK | DISEQUAL_TOK | GT_TOK | GEQ_TOK | LT_TOK | LEQ_TOK | MEMBER_TOK | FMF_CARD_TOK );
 */
static void
comparisonBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // ../../../../src/parser/cvc/Cvc.g:1537:3: ( EQUAL_TOK | DISEQUAL_TOK | GT_TOK | GEQ_TOK | LT_TOK | LEQ_TOK | MEMBER_TOK | FMF_CARD_TOK )
        // ../../../../src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == DISEQUAL_TOK || LA(1) == EQUAL_TOK || LA(1) == FMF_CARD_TOK || LA(1) == GEQ_TOK || LA(1) == GT_TOK || LA(1) == LEQ_TOK || ((LA(1) >= LT_TOK) && (LA(1) <= MEMBER_TOK)) )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulecomparisonBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulecomparisonBinopEx; /* Prevent compiler warnings */
    rulecomparisonBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end comparisonBinop */

/**
 * $ANTLR start arithmeticBinop
 * ../../../../src/parser/cvc/Cvc.g:1547:1: arithmeticBinop[unsigned& op] : ( PLUS_TOK | MINUS_TOK | STAR_TOK | INTDIV_TOK | MOD_TOK | DIV_TOK | EXP_TOK );
 */
static void
arithmeticBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // ../../../../src/parser/cvc/Cvc.g:1551:3: ( PLUS_TOK | MINUS_TOK | STAR_TOK | INTDIV_TOK | MOD_TOK | DIV_TOK | EXP_TOK )
        // ../../../../src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == DIV_TOK || LA(1) == EXP_TOK || LA(1) == INTDIV_TOK || ((LA(1) >= MINUS_TOK) && (LA(1) <= MOD_TOK)) || LA(1) == PLUS_TOK || LA(1) == STAR_TOK )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulearithmeticBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulearithmeticBinopEx; /* Prevent compiler warnings */
    rulearithmeticBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end arithmeticBinop */

/**
 * $ANTLR start term
 * ../../../../src/parser/cvc/Cvc.g:1561:1: term[CVC4::Expr& f] : uminusTerm[f] ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) | ( arithmeticBinop[op] uminusTerm[f] )* ) ;
 */
static void
term(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<CVC4::Expr> expressions;
      std::vector<unsigned> operators;
      unsigned op;
      Type t;

    {
        // ../../../../src/parser/cvc/Cvc.g:1568:3: ( uminusTerm[f] ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) | ( arithmeticBinop[op] uminusTerm[f] )* ) )
        // ../../../../src/parser/cvc/Cvc.g:1568:5: uminusTerm[f] ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) | ( arithmeticBinop[op] uminusTerm[f] )* )
        {
            FOLLOWPUSH(FOLLOW_uminusTerm_in_term5005);
            uminusTerm(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:1569:5: ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) | ( arithmeticBinop[op] uminusTerm[f] )* )
            {
                int alt74=2;
                switch ( LA(1) )
                {
                case WITH_TOK:
                	{
                		alt74=1;
                	}
                    break;
                case EOF:
                case AND_TOK:
                case BAR:
                case COLON:
                case COMMA:
                case DISEQUAL_TOK:
                case DIV_TOK:
                case ELSEIF_TOK:
                case ELSE_TOK:
                case ENDIF_TOK:
                case EQUAL_TOK:
                case EXP_TOK:
                case FMF_CARD_TOK:
                case GEQ_TOK:
                case GT_TOK:
                case HASHPAREN:
                case IFF_TOK:
                case IMPLIES_TOK:
                case INTDIV_TOK:
                case INTEGER_LITERAL:
                case IN_TOK:
                case JOIN_IMAGE_TOK:
                case JOIN_TOK:
                case LBRACKET:
                case LEQ_TOK:
                case LT_TOK:
                case MEMBER_TOK:
                case MINUS_TOK:
                case MOD_TOK:
                case OR_TOK:
                case PLUS_TOK:
                case PRODUCT_TOK:
                case RBRACE:
                case RBRACKET:
                case RPAREN:
                case SEMICOLON:
                case STAR_TOK:
                case THEN_TOK:
                case XOR_TOK:
                	{
                		alt74=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 74;
                    EXCEPTION->state        = 0;


                    goto ruletermEx;

                }

                switch (alt74)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1569:7: WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) )
            	    {
            	         MATCHT(WITH_TOK, &FOLLOW_WITH_TOK_in_term5014);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        // ../../../../src/parser/cvc/Cvc.g:1570:7: ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) )
            	        {
            	            int alt72=2;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		alt72=1;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt72=2;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return ;
            	                }

            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 72;
            	                EXCEPTION->state        = 0;


            	                goto ruletermEx;

            	            }

            	            switch (alt72)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1570:9: arrayStore[f] ( COMMA arrayStore[f] )*
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_term5024);
            	        	        arrayStore(ctx, f);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // ../../../../src/parser/cvc/Cvc.g:1570:23: ( COMMA arrayStore[f] )*

            	        	        for (;;)
            	        	        {
            	        	            int alt68=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case COMMA:
            	        	            	{
            	        	            		alt68=1;
            	        	            	}
            	        	                break;

            	        	            }

            	        	            switch (alt68)
            	        	            {
            	        	        	case 1:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1570:25: COMMA arrayStore[f]
            	        	        	    {
            	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_term5029);
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_term5031);
            	        	        	        arrayStore(ctx, f);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	        	default:
            	        	        	    goto loop68;	/* break out of the loop */
            	        	        	    break;
            	        	            }
            	        	        }
            	        	        loop68: ; /* Jump out to here if this rule does not match */


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1571:9: DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_term5045);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // ../../../../src/parser/cvc/Cvc.g:1571:13: ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* )
            	        	        {
            	        	            int alt71=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt71=1;
            	        	            	}
            	        	                break;
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt71=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 71;
            	        	                EXCEPTION->state        = 0;


            	        	                goto ruletermEx;

            	        	            }

            	        	            switch (alt71)
            	        	            {
            	        	        	case 1:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1571:15: tupleStore[f] ( COMMA DOT tupleStore[f] )*
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_term5049);
            	        	        	        tupleStore(ctx, f);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        // ../../../../src/parser/cvc/Cvc.g:1571:29: ( COMMA DOT tupleStore[f] )*

            	        	        	        for (;;)
            	        	        	        {
            	        	        	            int alt69=2;
            	        	        	            switch ( LA(1) )
            	        	        	            {
            	        	        	            case COMMA:
            	        	        	            	{
            	        	        	            		alt69=1;
            	        	        	            	}
            	        	        	                break;

            	        	        	            }

            	        	        	            switch (alt69)
            	        	        	            {
            	        	        	        	case 1:
            	        	        	        	    // ../../../../src/parser/cvc/Cvc.g:1571:31: COMMA DOT tupleStore[f]
            	        	        	        	    {
            	        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_term5054);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	         MATCHT(DOT, &FOLLOW_DOT_in_term5056);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_term5058);
            	        	        	        	        tupleStore(ctx, f);

            	        	        	        	        FOLLOWPOP();
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	    }
            	        	        	        	    break;

            	        	        	        	default:
            	        	        	        	    goto loop69;	/* break out of the loop */
            	        	        	        	    break;
            	        	        	            }
            	        	        	        }
            	        	        	        loop69: ; /* Jump out to here if this rule does not match */


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1572:15: recordStore[f] ( COMMA DOT recordStore[f] )*
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_term5078);
            	        	        	        recordStore(ctx, f);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        // ../../../../src/parser/cvc/Cvc.g:1572:30: ( COMMA DOT recordStore[f] )*

            	        	        	        for (;;)
            	        	        	        {
            	        	        	            int alt70=2;
            	        	        	            switch ( LA(1) )
            	        	        	            {
            	        	        	            case COMMA:
            	        	        	            	{
            	        	        	            		alt70=1;
            	        	        	            	}
            	        	        	                break;

            	        	        	            }

            	        	        	            switch (alt70)
            	        	        	            {
            	        	        	        	case 1:
            	        	        	        	    // ../../../../src/parser/cvc/Cvc.g:1572:32: COMMA DOT recordStore[f]
            	        	        	        	    {
            	        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_term5083);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	         MATCHT(DOT, &FOLLOW_DOT_in_term5085);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_term5087);
            	        	        	        	        recordStore(ctx, f);

            	        	        	        	        FOLLOWPOP();
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	    }
            	        	        	        	    break;

            	        	        	        	default:
            	        	        	        	    goto loop70;	/* break out of the loop */
            	        	        	        	    break;
            	        	        	            }
            	        	        	        }
            	        	        	        loop70: ; /* Jump out to here if this rule does not match */


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:1573:7: ( arithmeticBinop[op] uminusTerm[f] )*
            	    {
            	        if ( BACKTRACKING==0 )
            	        {
            	             expressions.push_back(f); 
            	        }


            	        // ../../../../src/parser/cvc/Cvc.g:1574:7: ( arithmeticBinop[op] uminusTerm[f] )*

            	        for (;;)
            	        {
            	            int alt73=2;
            	            switch ( LA(1) )
            	            {
            	            case DIV_TOK:
            	            case EXP_TOK:
            	            case INTDIV_TOK:
            	            case MINUS_TOK:
            	            case MOD_TOK:
            	            case PLUS_TOK:
            	            case STAR_TOK:
            	            	{
            	            		alt73=1;
            	            	}
            	                break;

            	            }

            	            switch (alt73)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1574:9: arithmeticBinop[op] uminusTerm[f]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arithmeticBinop_in_term5113);
            	        	        arithmeticBinop(ctx, op);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        FOLLOWPUSH(FOLLOW_uminusTerm_in_term5116);
            	        	        uminusTerm(ctx, f);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             operators.push_back(op); expressions.push_back(f); 
            	        	        }


            	        	    }
            	        	    break;

            	        	default:
            	        	    goto loop73;	/* break out of the loop */
            	        	    break;
            	            }
            	        }
            	        loop73: ; /* Jump out to here if this rule does not match */


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = createPrecedenceTree(PARSER_STATE, EXPR_MANAGER, expressions, operators); 
            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruletermEx; /* Prevent compiler warnings */
    ruletermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end term */

/**
 * $ANTLR start arrayStore
 * ../../../../src/parser/cvc/Cvc.g:1583:1: arrayStore[CVC4::Expr& f] : LBRACKET formula[k] RBRACKET ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) ;
 */
static void
arrayStore(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      Expr f2, k;

    {
        // ../../../../src/parser/cvc/Cvc.g:1587:3: ( LBRACKET formula[k] RBRACKET ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) )
        // ../../../../src/parser/cvc/Cvc.g:1587:5: LBRACKET formula[k] RBRACKET ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
        {
             MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_arrayStore5157);
            if  (HASEXCEPTION())
            {
                goto rulearrayStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_formula_in_arrayStore5159);
            formula(ctx, k);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulearrayStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_arrayStore5162);
            if  (HASEXCEPTION())
            {
                goto rulearrayStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 f2 = MK_EXPR(CVC4::kind::SELECT, f, k); 
            }


            // ../../../../src/parser/cvc/Cvc.g:1589:5: ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
            {
                int alt77=2;
                switch ( LA(1) )
                {
                case DOT:
                case LBRACKET:
                	{
                		alt77=1;
                	}
                    break;
                case ASSIGN_TOK:
                	{
                		alt77=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 77;
                    EXCEPTION->state        = 0;


                    goto rulearrayStoreEx;

                }

                switch (alt77)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1589:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	    {
            	        // ../../../../src/parser/cvc/Cvc.g:1589:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	        {
            	            int alt76=2;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		alt76=1;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt76=2;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return ;
            	                }

            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 76;
            	                EXCEPTION->state        = 0;


            	                goto rulearrayStoreEx;

            	            }

            	            switch (alt76)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1589:9: arrayStore[f2]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_arrayStore5178);
            	        	        arrayStore(ctx, f2);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulearrayStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1590:9: DOT ( tupleStore[f2] | recordStore[f2] )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_arrayStore5189);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulearrayStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // ../../../../src/parser/cvc/Cvc.g:1590:13: ( tupleStore[f2] | recordStore[f2] )
            	        	        {
            	        	            int alt75=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt75=1;
            	        	            	}
            	        	                break;
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt75=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 75;
            	        	                EXCEPTION->state        = 0;


            	        	                goto rulearrayStoreEx;

            	        	            }

            	        	            switch (alt75)
            	        	            {
            	        	        	case 1:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1590:15: tupleStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_arrayStore5193);
            	        	        	        tupleStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulearrayStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1591:15: recordStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_arrayStore5210);
            	        	        	        recordStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulearrayStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:1592:7: ASSIGN_TOK term[f2]
            	    {
            	         MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_arrayStore5223);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulearrayStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_arrayStore5225);
            	        term(ctx, f2);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulearrayStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 f = MK_EXPR(CVC4::kind::STORE, f, k, f2); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulearrayStoreEx; /* Prevent compiler warnings */
    rulearrayStoreEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end arrayStore */

/**
 * $ANTLR start tupleStore
 * ../../../../src/parser/cvc/Cvc.g:1600:1: tupleStore[CVC4::Expr& f] : k= numeral ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) ;
 */
static void
tupleStore(pCvcParser ctx, CVC4::Expr& f)
{
    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    /* Initialize rule variables
     */


      Expr f2;

    {
        // ../../../../src/parser/cvc/Cvc.g:1604:3: (k= numeral ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) )
        // ../../../../src/parser/cvc/Cvc.g:1604:5: k= numeral ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
        {
            FOLLOWPUSH(FOLLOW_numeral_in_tupleStore5257);
            k=numeral(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletupleStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 Type t = f.getType();
                      if(! t.isTuple()) {
                        PARSER_STATE->parseError("tuple-update applied to non-tuple");
                      }
                      size_t length = ((DatatypeType)t).getTupleLength();
                      if(k >= length) {
                        std::stringstream ss;
                        ss << "tuple is of length " << length << "; cannot update index " << k;
                        PARSER_STATE->parseError(ss.str());
                      }
                      std::vector<Expr> args;
                      const Datatype & dt = ((DatatypeType)t).getDatatype();
                      args.push_back( dt[0][k].getSelector() );
                      args.push_back( f );
                      f2 = MK_EXPR(CVC4::kind::APPLY_SELECTOR_TOTAL,args);
                    
            }


            // ../../../../src/parser/cvc/Cvc.g:1621:5: ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
            {
                int alt80=2;
                switch ( LA(1) )
                {
                case DOT:
                case LBRACKET:
                	{
                		alt80=1;
                	}
                    break;
                case ASSIGN_TOK:
                	{
                		alt80=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 80;
                    EXCEPTION->state        = 0;


                    goto ruletupleStoreEx;

                }

                switch (alt80)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1621:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	    {
            	        // ../../../../src/parser/cvc/Cvc.g:1621:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	        {
            	            int alt79=2;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		alt79=1;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt79=2;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return ;
            	                }

            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 79;
            	                EXCEPTION->state        = 0;


            	                goto ruletupleStoreEx;

            	            }

            	            switch (alt79)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1621:9: arrayStore[f2]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_tupleStore5273);
            	        	        arrayStore(ctx, f2);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletupleStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1622:9: DOT ( tupleStore[f2] | recordStore[f2] )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_tupleStore5284);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletupleStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // ../../../../src/parser/cvc/Cvc.g:1622:13: ( tupleStore[f2] | recordStore[f2] )
            	        	        {
            	        	            int alt78=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt78=1;
            	        	            	}
            	        	                break;
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt78=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 78;
            	        	                EXCEPTION->state        = 0;


            	        	                goto ruletupleStoreEx;

            	        	            }

            	        	            switch (alt78)
            	        	            {
            	        	        	case 1:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1622:15: tupleStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_tupleStore5288);
            	        	        	        tupleStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletupleStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1623:15: recordStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_tupleStore5305);
            	        	        	        recordStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletupleStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:1624:7: ASSIGN_TOK term[f2]
            	    {
            	         MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_tupleStore5318);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletupleStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_tupleStore5320);
            	        term(ctx, f2);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletupleStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 f = MK_EXPR(MK_CONST(TupleUpdate(k)), f, f2); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletupleStoreEx; /* Prevent compiler warnings */
    ruletupleStoreEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end tupleStore */

/**
 * $ANTLR start recordStore
 * ../../../../src/parser/cvc/Cvc.g:1632:1: recordStore[CVC4::Expr& f] : identifier[id,CHECK_NONE,SYM_VARIABLE] ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) ;
 */
static void
recordStore(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::string id;
      Expr f2;

    {
        // ../../../../src/parser/cvc/Cvc.g:1637:3: ( identifier[id,CHECK_NONE,SYM_VARIABLE] ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) )
        // ../../../../src/parser/cvc/Cvc.g:1637:5: identifier[id,CHECK_NONE,SYM_VARIABLE] ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
        {
            FOLLOWPUSH(FOLLOW_identifier_in_recordStore5350);
            identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerecordStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 Type t = f.getType();
                      if(! t.isRecord()) {
                        std::stringstream ss;
                        ss << "record-update applied to non-record term" << std::endl
                           << "the term: " << f << std::endl
                           << "its type: " << t;
                        PARSER_STATE->parseError(ss.str());
                      }
                      const Record& rec = ((DatatypeType)t).getRecord();
                      if(! rec.contains(id)) {
                        PARSER_STATE->parseError(std::string("no such field `") + id + "' in record");
                      }
                      std::vector<Expr> args;
                      const Datatype & dt = ((DatatypeType)t).getDatatype();
                      args.push_back( dt[0][id].getSelector() );
                      args.push_back( f );
                      f2 = MK_EXPR(CVC4::kind::APPLY_SELECTOR_TOTAL,args);
                    
            }


            // ../../../../src/parser/cvc/Cvc.g:1656:5: ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
            {
                int alt83=2;
                switch ( LA(1) )
                {
                case DOT:
                case LBRACKET:
                	{
                		alt83=1;
                	}
                    break;
                case ASSIGN_TOK:
                	{
                		alt83=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 83;
                    EXCEPTION->state        = 0;


                    goto rulerecordStoreEx;

                }

                switch (alt83)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1656:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	    {
            	        // ../../../../src/parser/cvc/Cvc.g:1656:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	        {
            	            int alt82=2;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		alt82=1;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt82=2;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return ;
            	                }

            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 82;
            	                EXCEPTION->state        = 0;


            	                goto rulerecordStoreEx;

            	            }

            	            switch (alt82)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1656:9: arrayStore[f2]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_recordStore5367);
            	        	        arrayStore(ctx, f2);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulerecordStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1657:9: DOT ( tupleStore[f2] | recordStore[f2] )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_recordStore5378);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulerecordStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // ../../../../src/parser/cvc/Cvc.g:1657:13: ( tupleStore[f2] | recordStore[f2] )
            	        	        {
            	        	            int alt81=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt81=1;
            	        	            	}
            	        	                break;
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt81=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 81;
            	        	                EXCEPTION->state        = 0;


            	        	                goto rulerecordStoreEx;

            	        	            }

            	        	            switch (alt81)
            	        	            {
            	        	        	case 1:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1657:15: tupleStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_recordStore5382);
            	        	        	        tupleStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulerecordStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1658:15: recordStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_recordStore5399);
            	        	        	        recordStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulerecordStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:1659:7: ASSIGN_TOK term[f2]
            	    {
            	         MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_recordStore5412);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulerecordStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_recordStore5414);
            	        term(ctx, f2);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulerecordStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 f = MK_EXPR(MK_CONST(RecordUpdate(id)), f, f2); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulerecordStoreEx; /* Prevent compiler warnings */
    rulerecordStoreEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end recordStore */

/**
 * $ANTLR start uminusTerm
 * ../../../../src/parser/cvc/Cvc.g:1664:1: uminusTerm[CVC4::Expr& f] : ( ( MINUS_TOK )+ bvBinaryOpTerm[f] | bvBinaryOpTerm[f] );
 */
static void
uminusTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      unsigned minusCount = 0;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1669:3: ( ( MINUS_TOK )+ bvBinaryOpTerm[f] | bvBinaryOpTerm[f] )

            ANTLR3_UINT32 alt85;

            alt85=2;

            switch ( LA(1) )
            {
            case MINUS_TOK:
            	{
            		alt85=1;
            	}
                break;
            case ABS_TOK:
            case ARRAY_TOK:
            case BAR:
            case BINARY_LITERAL:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVGE_TOK:
            case BVGT_TOK:
            case BVLE_TOK:
            case BVLSHR_TOK:
            case BVLT_TOK:
            case BVMULT_TOK:
            case BVNAND_TOK:
            case BVNEG_TOK:
            case BVNOR_TOK:
            case BVPLUS_TOK:
            case BVREPEAT_TOK:
            case BVROTL_TOK:
            case BVROTR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUMINUS_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case BVZEROEXTEND_TOK:
            case DECIMAL_LITERAL:
            case DISTINCT_TOK:
            case DIVISIBLE_TOK:
            case FALSE_TOK:
            case FLOOR_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IDEN_TOK:
            case IF_TOK:
            case INTEGER_LITERAL:
            case IS_INTEGER_TOK:
            case LBRACE:
            case LPAREN:
            case PARENHASH:
            case SETS_CARD_TOK:
            case STRING_CONCAT_TOK:
            case STRING_CONTAINS_TOK:
            case STRING_INDEXOF_TOK:
            case STRING_ITOS_TOK:
            case STRING_LENGTH_TOK:
            case STRING_LITERAL:
            case STRING_PREFIXOF_TOK:
            case STRING_REPLACE_TOK:
            case STRING_STOI_TOK:
            case STRING_STOU16_TOK:
            case STRING_STOU32_TOK:
            case STRING_SUBSTR_TOK:
            case STRING_SUFFIXOF_TOK:
            case STRING_U16TOS_TOK:
            case STRING_U32TOS_TOK:
            case SX_TOK:
            case TRANSCLOSURE_TOK:
            case TRANSPOSE_TOK:
            case TRUE_TOK:
            case TUPLE_TOK:
            case UNIVSET_TOK:
            	{
            		alt85=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 85;
                EXCEPTION->state        = 0;


                goto ruleuminusTermEx;

            }

            switch (alt85)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1669:5: ( MINUS_TOK )+ bvBinaryOpTerm[f]
        	    {
        	        // ../../../../src/parser/cvc/Cvc.g:1669:5: ( MINUS_TOK )+
        	        {
        	            int cnt84=0;

        	            for (;;)
        	            {
        	                int alt84=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case MINUS_TOK:
        	        		{
        	        			alt84=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt84)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/cvc/Cvc.g:1669:6: MINUS_TOK
        	        	        {
        	        	             MATCHT(MINUS_TOK, &FOLLOW_MINUS_TOK_in_uminusTerm5451);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleuminusTermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 ++minusCount; 
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt84 >= 1 )
        	        		{
        	        		    goto loop84;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleuminusTermEx;
        	        	}
        	        	cnt84++;
        	            }
        	            loop84: ;	/* Jump to here if this rule does not match */
        	        }

        	        FOLLOWPUSH(FOLLOW_bvBinaryOpTerm_in_uminusTerm5457);
        	        bvBinaryOpTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleuminusTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             while(minusCount > 0) { --minusCount; f = MK_EXPR(CVC4::kind::UMINUS, f); } 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1671:5: bvBinaryOpTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_bvBinaryOpTerm_in_uminusTerm5470);
        	        bvBinaryOpTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleuminusTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleuminusTermEx; /* Prevent compiler warnings */
    ruleuminusTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end uminusTerm */

/**
 * $ANTLR start bvBinaryOpTerm
 * ../../../../src/parser/cvc/Cvc.g:1675:1: bvBinaryOpTerm[CVC4::Expr& f] : bvNegTerm[f] ( bvBinop[op] bvNegTerm[f] )* ;
 */
static void
bvBinaryOpTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<CVC4::Expr> expressions;
      std::vector<unsigned> operators;
      unsigned op;

    {
        // ../../../../src/parser/cvc/Cvc.g:1681:3: ( bvNegTerm[f] ( bvBinop[op] bvNegTerm[f] )* )
        // ../../../../src/parser/cvc/Cvc.g:1681:5: bvNegTerm[f] ( bvBinop[op] bvNegTerm[f] )*
        {
            FOLLOWPUSH(FOLLOW_bvNegTerm_in_bvBinaryOpTerm5492);
            bvNegTerm(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulebvBinaryOpTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 expressions.push_back(f); 
            }


            // ../../../../src/parser/cvc/Cvc.g:1682:5: ( bvBinop[op] bvNegTerm[f] )*

            for (;;)
            {
                int alt86=2;
                switch ( LA(1) )
                {
                case BAR:
                	{
                		switch ( LA(2) )
                		{
                		case BAR:
                			{
                				switch ( LA(3) )
                				{
                				case BAR:
                					{
                						alt86=1;
                					}
                				    break;

                				}

                			}
                		    break;
                		case ABS_TOK:
                		case ARRAY_TOK:
                		case BINARY_LITERAL:
                		case BVASHR_TOK:
                		case BVCOMP_TOK:
                		case BVGE_TOK:
                		case BVGT_TOK:
                		case BVLE_TOK:
                		case BVLSHR_TOK:
                		case BVLT_TOK:
                		case BVMULT_TOK:
                		case BVNAND_TOK:
                		case BVNEG_TOK:
                		case BVNOR_TOK:
                		case BVPLUS_TOK:
                		case BVREPEAT_TOK:
                		case BVROTL_TOK:
                		case BVROTR_TOK:
                		case BVSDIV_TOK:
                		case BVSGE_TOK:
                		case BVSGT_TOK:
                		case BVSHL_TOK:
                		case BVSLE_TOK:
                		case BVSLT_TOK:
                		case BVSMOD_TOK:
                		case BVSREM_TOK:
                		case BVSUB_TOK:
                		case BVUDIV_TOK:
                		case BVUMINUS_TOK:
                		case BVUREM_TOK:
                		case BVXNOR_TOK:
                		case BVXOR_TOK:
                		case BVZEROEXTEND_TOK:
                		case DECIMAL_LITERAL:
                		case DISTINCT_TOK:
                		case DIVISIBLE_TOK:
                		case FALSE_TOK:
                		case FLOOR_TOK:
                		case HEX_LITERAL:
                		case IDENTIFIER:
                		case IDEN_TOK:
                		case IF_TOK:
                		case INTEGER_LITERAL:
                		case IS_INTEGER_TOK:
                		case LBRACE:
                		case LPAREN:
                		case PARENHASH:
                		case SETS_CARD_TOK:
                		case STRING_CONCAT_TOK:
                		case STRING_CONTAINS_TOK:
                		case STRING_INDEXOF_TOK:
                		case STRING_ITOS_TOK:
                		case STRING_LENGTH_TOK:
                		case STRING_LITERAL:
                		case STRING_PREFIXOF_TOK:
                		case STRING_REPLACE_TOK:
                		case STRING_STOI_TOK:
                		case STRING_STOU16_TOK:
                		case STRING_STOU32_TOK:
                		case STRING_SUBSTR_TOK:
                		case STRING_SUFFIXOF_TOK:
                		case STRING_U16TOS_TOK:
                		case STRING_U32TOS_TOK:
                		case SX_TOK:
                		case TRANSCLOSURE_TOK:
                		case TRANSPOSE_TOK:
                		case TRUE_TOK:
                		case TUPLE_TOK:
                		case UNIVSET_TOK:
                			{
                				alt86=1;
                			}
                		    break;

                		}

                	}
                    break;
                case BVAND_TOK:
                case CONCAT_TOK:
                	{
                		alt86=1;
                	}
                    break;

                }

                switch (alt86)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1682:7: bvBinop[op] bvNegTerm[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_bvBinop_in_bvBinaryOpTerm5503);
            	        bvBinop(ctx, op);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulebvBinaryOpTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_bvNegTerm_in_bvBinaryOpTerm5506);
            	        bvNegTerm(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulebvBinaryOpTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             operators.push_back(op); expressions.push_back(f); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop86;	/* break out of the loop */
            	    break;
                }
            }
            loop86: ; /* Jump out to here if this rule does not match */


            if ( BACKTRACKING==0 )
            {
                 f = createPrecedenceTree(PARSER_STATE, EXPR_MANAGER, expressions, operators); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebvBinaryOpTermEx; /* Prevent compiler warnings */
    rulebvBinaryOpTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bvBinaryOpTerm */

/**
 * $ANTLR start bvBinop
 * ../../../../src/parser/cvc/Cvc.g:1685:1: bvBinop[unsigned& op] : ( CONCAT_TOK | BAR | BVAND_TOK );
 */
static void
bvBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // ../../../../src/parser/cvc/Cvc.g:1689:3: ( CONCAT_TOK | BAR | BVAND_TOK )
        // ../../../../src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == BAR || LA(1) == BVAND_TOK || LA(1) == CONCAT_TOK )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulebvBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebvBinopEx; /* Prevent compiler warnings */
    rulebvBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bvBinop */

/**
 * $ANTLR start bvNegTerm
 * ../../../../src/parser/cvc/Cvc.g:1694:1: bvNegTerm[CVC4::Expr& f] : ( BVNEG_TOK bvNegTerm[f] | relationTerm[f] );
 */
static void
bvNegTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1696:3: ( BVNEG_TOK bvNegTerm[f] | relationTerm[f] )

            ANTLR3_UINT32 alt87;

            alt87=2;

            switch ( LA(1) )
            {
            case BVNEG_TOK:
            	{
            		alt87=1;
            	}
                break;
            case ABS_TOK:
            case ARRAY_TOK:
            case BAR:
            case BINARY_LITERAL:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVGE_TOK:
            case BVGT_TOK:
            case BVLE_TOK:
            case BVLSHR_TOK:
            case BVLT_TOK:
            case BVMULT_TOK:
            case BVNAND_TOK:
            case BVNOR_TOK:
            case BVPLUS_TOK:
            case BVREPEAT_TOK:
            case BVROTL_TOK:
            case BVROTR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUMINUS_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case BVZEROEXTEND_TOK:
            case DECIMAL_LITERAL:
            case DISTINCT_TOK:
            case DIVISIBLE_TOK:
            case FALSE_TOK:
            case FLOOR_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IDEN_TOK:
            case IF_TOK:
            case INTEGER_LITERAL:
            case IS_INTEGER_TOK:
            case LBRACE:
            case LPAREN:
            case PARENHASH:
            case SETS_CARD_TOK:
            case STRING_CONCAT_TOK:
            case STRING_CONTAINS_TOK:
            case STRING_INDEXOF_TOK:
            case STRING_ITOS_TOK:
            case STRING_LENGTH_TOK:
            case STRING_LITERAL:
            case STRING_PREFIXOF_TOK:
            case STRING_REPLACE_TOK:
            case STRING_STOI_TOK:
            case STRING_STOU16_TOK:
            case STRING_STOU32_TOK:
            case STRING_SUBSTR_TOK:
            case STRING_SUFFIXOF_TOK:
            case STRING_U16TOS_TOK:
            case STRING_U32TOS_TOK:
            case SX_TOK:
            case TRANSCLOSURE_TOK:
            case TRANSPOSE_TOK:
            case TRUE_TOK:
            case TUPLE_TOK:
            case UNIVSET_TOK:
            	{
            		alt87=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 87;
                EXCEPTION->state        = 0;


                goto rulebvNegTermEx;

            }

            switch (alt87)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1696:5: BVNEG_TOK bvNegTerm[f]
        	    {
        	         MATCHT(BVNEG_TOK, &FOLLOW_BVNEG_TOK_in_bvNegTerm5569);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvNegTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_bvNegTerm_in_bvNegTerm5571);
        	        bvNegTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvNegTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = f.getType().isSet() ? MK_EXPR(CVC4::kind::COMPLEMENT, f) : MK_EXPR(CVC4::kind::BITVECTOR_NOT, f); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1698:5: relationTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_relationTerm_in_bvNegTerm5584);
        	        relationTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvNegTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulebvNegTermEx; /* Prevent compiler warnings */
    rulebvNegTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bvNegTerm */

/**
 * $ANTLR start relationTerm
 * ../../../../src/parser/cvc/Cvc.g:1701:1: relationTerm[CVC4::Expr& f] : ( TRANSPOSE_TOK relationTerm[f] | TRANSCLOSURE_TOK relationTerm[f] | TUPLE_TOK LPAREN relationTerm[f] RPAREN | IDEN_TOK relationTerm[f] | postfixTerm[f] );
 */
static void
relationTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1703:3: ( TRANSPOSE_TOK relationTerm[f] | TRANSCLOSURE_TOK relationTerm[f] | TUPLE_TOK LPAREN relationTerm[f] RPAREN | IDEN_TOK relationTerm[f] | postfixTerm[f] )

            ANTLR3_UINT32 alt88;

            alt88=5;

            switch ( LA(1) )
            {
            case TRANSPOSE_TOK:
            	{
            		alt88=1;
            	}
                break;
            case TRANSCLOSURE_TOK:
            	{
            		alt88=2;
            	}
                break;
            case TUPLE_TOK:
            	{
            		alt88=3;
            	}
                break;
            case IDEN_TOK:
            	{
            		alt88=4;
            	}
                break;
            case ABS_TOK:
            case ARRAY_TOK:
            case BAR:
            case BINARY_LITERAL:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVGE_TOK:
            case BVGT_TOK:
            case BVLE_TOK:
            case BVLSHR_TOK:
            case BVLT_TOK:
            case BVMULT_TOK:
            case BVNAND_TOK:
            case BVNOR_TOK:
            case BVPLUS_TOK:
            case BVREPEAT_TOK:
            case BVROTL_TOK:
            case BVROTR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUMINUS_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case BVZEROEXTEND_TOK:
            case DECIMAL_LITERAL:
            case DISTINCT_TOK:
            case DIVISIBLE_TOK:
            case FALSE_TOK:
            case FLOOR_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IF_TOK:
            case INTEGER_LITERAL:
            case IS_INTEGER_TOK:
            case LBRACE:
            case LPAREN:
            case PARENHASH:
            case SETS_CARD_TOK:
            case STRING_CONCAT_TOK:
            case STRING_CONTAINS_TOK:
            case STRING_INDEXOF_TOK:
            case STRING_ITOS_TOK:
            case STRING_LENGTH_TOK:
            case STRING_LITERAL:
            case STRING_PREFIXOF_TOK:
            case STRING_REPLACE_TOK:
            case STRING_STOI_TOK:
            case STRING_STOU16_TOK:
            case STRING_STOU32_TOK:
            case STRING_SUBSTR_TOK:
            case STRING_SUFFIXOF_TOK:
            case STRING_U16TOS_TOK:
            case STRING_U32TOS_TOK:
            case SX_TOK:
            case TRUE_TOK:
            case UNIVSET_TOK:
            	{
            		alt88=5;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 88;
                EXCEPTION->state        = 0;


                goto rulerelationTermEx;

            }

            switch (alt88)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1703:5: TRANSPOSE_TOK relationTerm[f]
        	    {
        	         MATCHT(TRANSPOSE_TOK, &FOLLOW_TRANSPOSE_TOK_in_relationTerm5605);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_relationTerm_in_relationTerm5607);
        	        relationTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::TRANSPOSE, f); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1705:5: TRANSCLOSURE_TOK relationTerm[f]
        	    {
        	         MATCHT(TRANSCLOSURE_TOK, &FOLLOW_TRANSCLOSURE_TOK_in_relationTerm5621);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_relationTerm_in_relationTerm5623);
        	        relationTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::TCLOSURE, f); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:1707:5: TUPLE_TOK LPAREN relationTerm[f] RPAREN
        	    {
        	         MATCHT(TUPLE_TOK, &FOLLOW_TUPLE_TOK_in_relationTerm5636);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_relationTerm5638);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_relationTerm_in_relationTerm5640);
        	        relationTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_relationTerm5643);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::vector<Type> types;
        	                  std::vector<Expr> args;
        	                  args.push_back(f);
        	            	    types.push_back(f.getType());
        	                  DatatypeType t = EXPR_MANAGER->mkTupleType(types);
        	                  const Datatype& dt = t.getDatatype();
        	                  args.insert( args.begin(), dt[0].getConstructor() );
        	                  f = MK_EXPR(kind::APPLY_CONSTRUCTOR, args);
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/cvc/Cvc.g:1717:5: IDEN_TOK relationTerm[f]
        	    {
        	         MATCHT(IDEN_TOK, &FOLLOW_IDEN_TOK_in_relationTerm5655);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_relationTerm_in_relationTerm5657);
        	        relationTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::IDEN, f); 
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/cvc/Cvc.g:1719:5: postfixTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_postfixTerm_in_relationTerm5687);
        	        postfixTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulerelationTermEx; /* Prevent compiler warnings */
    rulerelationTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end relationTerm */

/**
 * $ANTLR start postfixTerm
 * ../../../../src/parser/cvc/Cvc.g:1731:1: postfixTerm[CVC4::Expr& f] : ( bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN ) ( typeAscription[f, t] )? ;
 */
static void
postfixTerm(pCvcParser ctx, CVC4::Expr& f)
{
    unsigned k1;
    #undef	RETURN_TYPE_k1
    #define	RETURN_TYPE_k1 unsigned

    unsigned k2;
    #undef	RETURN_TYPE_k2
    #define	RETURN_TYPE_k2 unsigned

    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    unsigned n;
    #undef	RETURN_TYPE_n
    #define	RETURN_TYPE_n unsigned

    /* Initialize rule variables
     */


      Expr f2;
      bool extract = false, left = false;
      std::vector<Expr> args;
      std::string id;
      Type t;

    {
        // ../../../../src/parser/cvc/Cvc.g:1739:3: ( ( bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN ) ( typeAscription[f, t] )? )
        // ../../../../src/parser/cvc/Cvc.g:1739:5: ( bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN ) ( typeAscription[f, t] )?
        {
            // ../../../../src/parser/cvc/Cvc.g:1739:5: ( bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN )
            {
                int alt95=6;
                switch ( LA(1) )
                {
                case ARRAY_TOK:
                case BAR:
                case BINARY_LITERAL:
                case BVASHR_TOK:
                case BVCOMP_TOK:
                case BVGE_TOK:
                case BVGT_TOK:
                case BVLE_TOK:
                case BVLSHR_TOK:
                case BVLT_TOK:
                case BVMULT_TOK:
                case BVNAND_TOK:
                case BVNOR_TOK:
                case BVPLUS_TOK:
                case BVREPEAT_TOK:
                case BVROTL_TOK:
                case BVROTR_TOK:
                case BVSDIV_TOK:
                case BVSGE_TOK:
                case BVSGT_TOK:
                case BVSHL_TOK:
                case BVSLE_TOK:
                case BVSLT_TOK:
                case BVSMOD_TOK:
                case BVSREM_TOK:
                case BVSUB_TOK:
                case BVUDIV_TOK:
                case BVUMINUS_TOK:
                case BVUREM_TOK:
                case BVXNOR_TOK:
                case BVXOR_TOK:
                case BVZEROEXTEND_TOK:
                case DECIMAL_LITERAL:
                case FALSE_TOK:
                case HEX_LITERAL:
                case IDENTIFIER:
                case IF_TOK:
                case INTEGER_LITERAL:
                case LBRACE:
                case LPAREN:
                case PARENHASH:
                case SETS_CARD_TOK:
                case STRING_CONCAT_TOK:
                case STRING_CONTAINS_TOK:
                case STRING_INDEXOF_TOK:
                case STRING_ITOS_TOK:
                case STRING_LENGTH_TOK:
                case STRING_LITERAL:
                case STRING_PREFIXOF_TOK:
                case STRING_REPLACE_TOK:
                case STRING_STOI_TOK:
                case STRING_STOU16_TOK:
                case STRING_STOU32_TOK:
                case STRING_SUBSTR_TOK:
                case STRING_SUFFIXOF_TOK:
                case STRING_U16TOS_TOK:
                case STRING_U32TOS_TOK:
                case SX_TOK:
                case TRUE_TOK:
                case UNIVSET_TOK:
                	{
                		alt95=1;
                	}
                    break;
                case FLOOR_TOK:
                	{
                		alt95=2;
                	}
                    break;
                case IS_INTEGER_TOK:
                	{
                		alt95=3;
                	}
                    break;
                case ABS_TOK:
                	{
                		alt95=4;
                	}
                    break;
                case DIVISIBLE_TOK:
                	{
                		alt95=5;
                	}
                    break;
                case DISTINCT_TOK:
                	{
                		alt95=6;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 95;
                    EXCEPTION->state        = 0;


                    goto rulepostfixTermEx;

                }

                switch (alt95)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1739:7: bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )*
            	    {
            	        FOLLOWPUSH(FOLLOW_bvTerm_in_postfixTerm5711);
            	        bvTerm(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        // ../../../../src/parser/cvc/Cvc.g:1740:5: ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )*

            	        for (;;)
            	        {
            	            int alt93=5;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		switch ( LA(2) )
            	            		{
            	            		case IDENTIFIER:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case AND_TOK:
            	            				case BAR:
            	            				case BVAND_TOK:
            	            				case COLON:
            	            				case CONCAT_TOK:
            	            				case DISEQUAL_TOK:
            	            				case DIV_TOK:
            	            				case DOT:
            	            				case EQUAL_TOK:
            	            				case EXP_TOK:
            	            				case FMF_CARD_TOK:
            	            				case GEQ_TOK:
            	            				case GT_TOK:
            	            				case IFF_TOK:
            	            				case IMPLIES_TOK:
            	            				case INTDIV_TOK:
            	            				case JOIN_IMAGE_TOK:
            	            				case JOIN_TOK:
            	            				case LBRACKET:
            	            				case LEFTSHIFT_TOK:
            	            				case LEQ_TOK:
            	            				case LPAREN:
            	            				case LT_TOK:
            	            				case MEMBER_TOK:
            	            				case MINUS_TOK:
            	            				case MOD_TOK:
            	            				case OR_TOK:
            	            				case PLUS_TOK:
            	            				case PRODUCT_TOK:
            	            				case RBRACKET:
            	            				case RIGHTSHIFT_TOK:
            	            				case STAR_TOK:
            	            				case WITH_TOK:
            	            				case XOR_TOK:
            	            					{
            	            						alt93=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case ABS_TOK:
            	            		case ARRAY_TOK:
            	            		case BAR:
            	            		case BINARY_LITERAL:
            	            		case BVASHR_TOK:
            	            		case BVCOMP_TOK:
            	            		case BVGE_TOK:
            	            		case BVGT_TOK:
            	            		case BVLE_TOK:
            	            		case BVLSHR_TOK:
            	            		case BVLT_TOK:
            	            		case BVMULT_TOK:
            	            		case BVNAND_TOK:
            	            		case BVNEG_TOK:
            	            		case BVNOR_TOK:
            	            		case BVPLUS_TOK:
            	            		case BVREPEAT_TOK:
            	            		case BVROTL_TOK:
            	            		case BVROTR_TOK:
            	            		case BVSDIV_TOK:
            	            		case BVSGE_TOK:
            	            		case BVSGT_TOK:
            	            		case BVSHL_TOK:
            	            		case BVSLE_TOK:
            	            		case BVSLT_TOK:
            	            		case BVSMOD_TOK:
            	            		case BVSREM_TOK:
            	            		case BVSUB_TOK:
            	            		case BVUDIV_TOK:
            	            		case BVUMINUS_TOK:
            	            		case BVUREM_TOK:
            	            		case BVXNOR_TOK:
            	            		case BVXOR_TOK:
            	            		case BVZEROEXTEND_TOK:
            	            		case DECIMAL_LITERAL:
            	            		case DISTINCT_TOK:
            	            		case DIVISIBLE_TOK:
            	            		case EXISTS_TOK:
            	            		case FALSE_TOK:
            	            		case FLOOR_TOK:
            	            		case FORALL_TOK:
            	            		case HEX_LITERAL:
            	            		case IDEN_TOK:
            	            		case IF_TOK:
            	            		case INTEGER_LITERAL:
            	            		case IS_INTEGER_TOK:
            	            		case LAMBDA:
            	            		case LBRACE:
            	            		case LET_TOK:
            	            		case LPAREN:
            	            		case MINUS_TOK:
            	            		case NOT_TOK:
            	            		case PARENHASH:
            	            		case SETS_CARD_TOK:
            	            		case STRING_CONCAT_TOK:
            	            		case STRING_CONTAINS_TOK:
            	            		case STRING_INDEXOF_TOK:
            	            		case STRING_ITOS_TOK:
            	            		case STRING_LENGTH_TOK:
            	            		case STRING_LITERAL:
            	            		case STRING_PREFIXOF_TOK:
            	            		case STRING_REPLACE_TOK:
            	            		case STRING_STOI_TOK:
            	            		case STRING_STOU16_TOK:
            	            		case STRING_STOU32_TOK:
            	            		case STRING_SUBSTR_TOK:
            	            		case STRING_SUFFIXOF_TOK:
            	            		case STRING_U16TOS_TOK:
            	            		case STRING_U32TOS_TOK:
            	            		case SX_TOK:
            	            		case TRANSCLOSURE_TOK:
            	            		case TRANSPOSE_TOK:
            	            		case TRUE_TOK:
            	            		case TUPLE_TOK:
            	            		case UNIVSET_TOK:
            	            			{
            	            				alt93=1;
            	            			}
            	            		    break;

            	            		}

            	            	}
            	                break;
            	            case LEFTSHIFT_TOK:
            	            case RIGHTSHIFT_TOK:
            	            	{
            	            		alt93=2;
            	            	}
            	                break;
            	            case LPAREN:
            	            	{
            	            		alt93=3;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt93=4;
            	            	}
            	                break;

            	            }

            	            switch (alt93)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1741:7: LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET
            	        	    {
            	        	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_postfixTerm5728);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // ../../../../src/parser/cvc/Cvc.g:1742:9: ( formula[f2] |k1= numeral COLON k2= numeral )
            	        	        {
            	        	            int alt89=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case ABS_TOK:
            	        	            case ARRAY_TOK:
            	        	            case BAR:
            	        	            case BINARY_LITERAL:
            	        	            case BVASHR_TOK:
            	        	            case BVCOMP_TOK:
            	        	            case BVGE_TOK:
            	        	            case BVGT_TOK:
            	        	            case BVLE_TOK:
            	        	            case BVLSHR_TOK:
            	        	            case BVLT_TOK:
            	        	            case BVMULT_TOK:
            	        	            case BVNAND_TOK:
            	        	            case BVNEG_TOK:
            	        	            case BVNOR_TOK:
            	        	            case BVPLUS_TOK:
            	        	            case BVREPEAT_TOK:
            	        	            case BVROTL_TOK:
            	        	            case BVROTR_TOK:
            	        	            case BVSDIV_TOK:
            	        	            case BVSGE_TOK:
            	        	            case BVSGT_TOK:
            	        	            case BVSHL_TOK:
            	        	            case BVSLE_TOK:
            	        	            case BVSLT_TOK:
            	        	            case BVSMOD_TOK:
            	        	            case BVSREM_TOK:
            	        	            case BVSUB_TOK:
            	        	            case BVUDIV_TOK:
            	        	            case BVUMINUS_TOK:
            	        	            case BVUREM_TOK:
            	        	            case BVXNOR_TOK:
            	        	            case BVXOR_TOK:
            	        	            case BVZEROEXTEND_TOK:
            	        	            case DECIMAL_LITERAL:
            	        	            case DISTINCT_TOK:
            	        	            case DIVISIBLE_TOK:
            	        	            case EXISTS_TOK:
            	        	            case FALSE_TOK:
            	        	            case FLOOR_TOK:
            	        	            case FORALL_TOK:
            	        	            case HEX_LITERAL:
            	        	            case IDENTIFIER:
            	        	            case IDEN_TOK:
            	        	            case IF_TOK:
            	        	            case IS_INTEGER_TOK:
            	        	            case LAMBDA:
            	        	            case LBRACE:
            	        	            case LET_TOK:
            	        	            case LPAREN:
            	        	            case MINUS_TOK:
            	        	            case NOT_TOK:
            	        	            case PARENHASH:
            	        	            case SETS_CARD_TOK:
            	        	            case STRING_CONCAT_TOK:
            	        	            case STRING_CONTAINS_TOK:
            	        	            case STRING_INDEXOF_TOK:
            	        	            case STRING_ITOS_TOK:
            	        	            case STRING_LENGTH_TOK:
            	        	            case STRING_LITERAL:
            	        	            case STRING_PREFIXOF_TOK:
            	        	            case STRING_REPLACE_TOK:
            	        	            case STRING_STOI_TOK:
            	        	            case STRING_STOU16_TOK:
            	        	            case STRING_STOU32_TOK:
            	        	            case STRING_SUBSTR_TOK:
            	        	            case STRING_SUFFIXOF_TOK:
            	        	            case STRING_U16TOS_TOK:
            	        	            case STRING_U32TOS_TOK:
            	        	            case SX_TOK:
            	        	            case TRANSCLOSURE_TOK:
            	        	            case TRANSPOSE_TOK:
            	        	            case TRUE_TOK:
            	        	            case TUPLE_TOK:
            	        	            case UNIVSET_TOK:
            	        	            	{
            	        	            		alt89=1;
            	        	            	}
            	        	                break;
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		switch ( LA(2) )
            	        	            		{
            	        	            		case AND_TOK:
            	        	            		case BAR:
            	        	            		case BVAND_TOK:
            	        	            		case CONCAT_TOK:
            	        	            		case DISEQUAL_TOK:
            	        	            		case DIV_TOK:
            	        	            		case DOT:
            	        	            		case EQUAL_TOK:
            	        	            		case EXP_TOK:
            	        	            		case FMF_CARD_TOK:
            	        	            		case GEQ_TOK:
            	        	            		case GT_TOK:
            	        	            		case IFF_TOK:
            	        	            		case IMPLIES_TOK:
            	        	            		case INTDIV_TOK:
            	        	            		case JOIN_IMAGE_TOK:
            	        	            		case JOIN_TOK:
            	        	            		case LBRACKET:
            	        	            		case LEFTSHIFT_TOK:
            	        	            		case LEQ_TOK:
            	        	            		case LPAREN:
            	        	            		case LT_TOK:
            	        	            		case MEMBER_TOK:
            	        	            		case MINUS_TOK:
            	        	            		case MOD_TOK:
            	        	            		case OR_TOK:
            	        	            		case PLUS_TOK:
            	        	            		case PRODUCT_TOK:
            	        	            		case RBRACKET:
            	        	            		case RIGHTSHIFT_TOK:
            	        	            		case STAR_TOK:
            	        	            		case WITH_TOK:
            	        	            		case XOR_TOK:
            	        	            			{
            	        	            				alt89=1;
            	        	            			}
            	        	            		    break;
            	        	            		case COLON:
            	        	            			{
            	        	            				switch ( LA(3) )
            	        	            				{
            	        	            				case COLON:
            	        	            					{
            	        	            						alt89=1;
            	        	            					}
            	        	            				    break;
            	        	            				case INTEGER_LITERAL:
            	        	            					{
            	        	            						alt89=2;
            	        	            					}
            	        	            				    break;

            	        	            				default:
            	        	            				    if (BACKTRACKING>0)
            	        	            				    {
            	        	            				        FAILEDFLAG = ANTLR3_TRUE;
            	        	            				        return ;
            	        	            				    }

            	        	            				    CONSTRUCTEX();
            	        	            				    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	            				    EXCEPTION->message      = (void *)"";
            	        	            				    EXCEPTION->decisionNum  = 89;
            	        	            				    EXCEPTION->state        = 82;


            	        	            				    goto rulepostfixTermEx;

            	        	            				}

            	        	            			}
            	        	            		    break;

            	        	            		default:
            	        	            		    if (BACKTRACKING>0)
            	        	            		    {
            	        	            		        FAILEDFLAG = ANTLR3_TRUE;
            	        	            		        return ;
            	        	            		    }

            	        	            		    CONSTRUCTEX();
            	        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	            		    EXCEPTION->message      = (void *)"";
            	        	            		    EXCEPTION->decisionNum  = 89;
            	        	            		    EXCEPTION->state        = 68;


            	        	            		    goto rulepostfixTermEx;

            	        	            		}

            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 89;
            	        	                EXCEPTION->state        = 0;


            	        	                goto rulepostfixTermEx;

            	        	            }

            	        	            switch (alt89)
            	        	            {
            	        	        	case 1:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1742:11: formula[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm5740);
            	        	        	        formula(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        if ( BACKTRACKING==0 )
            	        	        	        {
            	        	        	             extract = false; 
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1743:11: k1= numeral COLON k2= numeral
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_numeral_in_postfixTerm5757);
            	        	        	        k1=numeral(ctx);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	         MATCHT(COLON, &FOLLOW_COLON_in_postfixTerm5759);
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        FOLLOWPUSH(FOLLOW_numeral_in_postfixTerm5763);
            	        	        	        k2=numeral(ctx);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        if ( BACKTRACKING==0 )
            	        	        	        {
            	        	        	             extract = true; 
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_postfixTerm5775);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             if(extract) {
            	        	                      /* bitvector extract */
            	        	                      f = MK_EXPR(MK_CONST(BitVectorExtract(k1, k2)), f);
            	        	                    } else {
            	        	                      /* array select */
            	        	                      f = MK_EXPR(CVC4::kind::SELECT, f, f2);
            	        	                    }
            	        	                  
            	        	        }


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1754:7: ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral
            	        	    {
            	        	        // ../../../../src/parser/cvc/Cvc.g:1754:7: ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK )
            	        	        {
            	        	            int alt90=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case LEFTSHIFT_TOK:
            	        	            	{
            	        	            		alt90=1;
            	        	            	}
            	        	                break;
            	        	            case RIGHTSHIFT_TOK:
            	        	            	{
            	        	            		alt90=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 90;
            	        	                EXCEPTION->state        = 0;


            	        	                goto rulepostfixTermEx;

            	        	            }

            	        	            switch (alt90)
            	        	            {
            	        	        	case 1:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1754:9: LEFTSHIFT_TOK
            	        	        	    {
            	        	        	         MATCHT(LEFTSHIFT_TOK, &FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5801);
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        if ( BACKTRACKING==0 )
            	        	        	        {
            	        	        	             left = true; 
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1755:9: RIGHTSHIFT_TOK
            	        	        	    {
            	        	        	         MATCHT(RIGHTSHIFT_TOK, &FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5813);
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        if ( BACKTRACKING==0 )
            	        	        	        {
            	        	        	             left = false; 
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	        FOLLOWPUSH(FOLLOW_numeral_in_postfixTerm5821);
            	        	        k=numeral(ctx);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             // Defined in:
            	        	                    // http://www.cs.nyu.edu/acsys/cvc3/doc/user_doc.html#user_doc_pres_lang_expr_bit
            	        	                    if(left) {
            	        	                      f = MK_EXPR(kind::BITVECTOR_CONCAT, f, MK_CONST(BitVector(k)));
            	        	                    } else {
            	        	                      unsigned n = BitVectorType(f.getType()).getSize();
            	        	                      f = MK_EXPR(kind::BITVECTOR_CONCAT, MK_CONST(BitVector(k)),
            	        	                                  MK_EXPR(MK_CONST(BitVectorExtract(n - 1, k)), f));
            	        	                    }
            	        	                  
            	        	        }


            	        	    }
            	        	    break;
            	        	case 3:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1768:7: LPAREN formula[f] ( COMMA formula[f] )* RPAREN
            	        	    {
            	        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_postfixTerm5846);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             args.push_back(f); 
            	        	        }


            	        	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm5856);
            	        	        formula(ctx, f);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             args.push_back(f); 
            	        	        }


            	        	        // ../../../../src/parser/cvc/Cvc.g:1770:7: ( COMMA formula[f] )*

            	        	        for (;;)
            	        	        {
            	        	            int alt91=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case COMMA:
            	        	            	{
            	        	            		alt91=1;
            	        	            	}
            	        	                break;

            	        	            }

            	        	            switch (alt91)
            	        	            {
            	        	        	case 1:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1770:9: COMMA formula[f]
            	        	        	    {
            	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_postfixTerm5869);
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm5871);
            	        	        	        formula(ctx, f);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        if ( BACKTRACKING==0 )
            	        	        	        {
            	        	        	             args.push_back(f); 
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	        	default:
            	        	        	    goto loop91;	/* break out of the loop */
            	        	        	    break;
            	        	            }
            	        	        }
            	        	        loop91: ; /* Jump out to here if this rule does not match */


            	        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_postfixTerm5879);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             Type t = args.front().getType();
            	        	                    Debug("parser") << "type is " << t << std::endl;
            	        	                    Debug("parser") << "expr is " << args.front() << std::endl;
            	        	                    if(PARSER_STATE->isDefinedFunction(args.front())) {
            	        	                      f = MK_EXPR(CVC4::kind::APPLY, args);
            	        	                    } else if(t.isFunction()) {
            	        	                      f = MK_EXPR(CVC4::kind::APPLY_UF, args);
            	        	                    } else if(t.isConstructor()) {
            	        	                      f = MK_EXPR(CVC4::kind::APPLY_CONSTRUCTOR, args);
            	        	                    } else if(t.isSelector()) {
            	        	                      f = MK_EXPR(CVC4::kind::APPLY_SELECTOR, args);
            	        	                    } else if(t.isTester()) {
            	        	                      f = MK_EXPR(CVC4::kind::APPLY_TESTER, args);
            	        	                    } else {
            	        	                      PARSER_STATE->parseError("internal error: unhandled function application kind");
            	        	                    }
            	        	                  
            	        	        }


            	        	    }
            	        	    break;
            	        	case 4:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1791:7: DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_postfixTerm5911);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // ../../../../src/parser/cvc/Cvc.g:1792:7: ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral )
            	        	        {
            	        	            int alt92=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt92=1;
            	        	            	}
            	        	                break;
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt92=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 92;
            	        	                EXCEPTION->state        = 0;


            	        	                goto rulepostfixTermEx;

            	        	            }

            	        	            switch (alt92)
            	        	            {
            	        	        	case 1:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1792:9: identifier[id,CHECK_NONE,SYM_VARIABLE]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_identifier_in_postfixTerm5921);
            	        	        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        if ( BACKTRACKING==0 )
            	        	        	        {
            	        	        	             Type t = f.getType();
            	        	        	                      if(! t.isRecord()) {
            	        	        	                        PARSER_STATE->parseError("record-select applied to non-record");
            	        	        	                      }
            	        	        	                      const Record& rec = ((DatatypeType)t).getRecord();
            	        	        	                      if(!rec.contains(id)){
            	        	        	                        PARSER_STATE->parseError(std::string("no such field `") + id + "' in record");
            	        	        	                      }
            	        	        	                      const Datatype & dt = ((DatatypeType)t).getDatatype();
            	        	        	                      std::vector<Expr> sargs;
            	        	        	                      sargs.push_back( dt[0][id].getSelector() );
            	        	        	                      sargs.push_back( f );
            	        	        	                      f = MK_EXPR(CVC4::kind::APPLY_SELECTOR_TOTAL,sargs);
            	        	        	                    
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1807:9: k= numeral
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_numeral_in_postfixTerm5944);
            	        	        	        k=numeral(ctx);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        if ( BACKTRACKING==0 )
            	        	        	        {
            	        	        	             Type t = f.getType();
            	        	        	                      if(! t.isTuple()) {
            	        	        	                        PARSER_STATE->parseError("tuple-select applied to non-tuple");
            	        	        	                      }
            	        	        	                      size_t length = ((DatatypeType)t).getTupleLength();
            	        	        	                      if(k >= length) {
            	        	        	                        std::stringstream ss;
            	        	        	                        ss << "tuple is of length " << length << "; cannot access index " << k;
            	        	        	                        PARSER_STATE->parseError(ss.str());
            	        	        	                      }
            	        	        	                      const Datatype & dt = ((DatatypeType)t).getDatatype();
            	        	        	                      std::vector<Expr> sargs;
            	        	        	                      sargs.push_back( dt[0][k].getSelector() );
            	        	        	                      sargs.push_back( f );
            	        	        	                      f = MK_EXPR(CVC4::kind::APPLY_SELECTOR_TOTAL,sargs);
            	        	        	                    
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	        	default:
            	        	    goto loop93;	/* break out of the loop */
            	        	    break;
            	            }
            	        }
            	        loop93: ; /* Jump out to here if this rule does not match */


            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:1826:7: FLOOR_TOK LPAREN formula[f] RPAREN
            	    {
            	         MATCHT(FLOOR_TOK, &FOLLOW_FLOOR_TOK_in_postfixTerm5977);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_postfixTerm5979);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm5981);
            	        formula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_postfixTerm5984);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = MK_EXPR(CVC4::kind::TO_INTEGER, f); 
            	        }


            	    }
            	    break;
            	case 3:
            	    // ../../../../src/parser/cvc/Cvc.g:1828:7: IS_INTEGER_TOK LPAREN formula[f] RPAREN
            	    {
            	         MATCHT(IS_INTEGER_TOK, &FOLLOW_IS_INTEGER_TOK_in_postfixTerm6000);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_postfixTerm6002);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm6004);
            	        formula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_postfixTerm6007);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = MK_EXPR(CVC4::kind::IS_INTEGER, f); 
            	        }


            	    }
            	    break;
            	case 4:
            	    // ../../../../src/parser/cvc/Cvc.g:1830:7: ABS_TOK LPAREN formula[f] RPAREN
            	    {
            	         MATCHT(ABS_TOK, &FOLLOW_ABS_TOK_in_postfixTerm6023);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_postfixTerm6025);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm6027);
            	        formula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_postfixTerm6030);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = MK_EXPR(CVC4::kind::ABS, f); 
            	        }


            	    }
            	    break;
            	case 5:
            	    // ../../../../src/parser/cvc/Cvc.g:1832:7: DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN
            	    {
            	         MATCHT(DIVISIBLE_TOK, &FOLLOW_DIVISIBLE_TOK_in_postfixTerm6046);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_postfixTerm6048);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm6050);
            	        formula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(COMMA, &FOLLOW_COMMA_in_postfixTerm6053);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_numeral_in_postfixTerm6057);
            	        n=numeral(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_postfixTerm6059);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = MK_EXPR(CVC4::kind::DIVISIBLE, MK_CONST(CVC4::Divisible(n)), f); 
            	        }


            	    }
            	    break;
            	case 6:
            	    // ../../../../src/parser/cvc/Cvc.g:1834:7: DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN
            	    {
            	         MATCHT(DISTINCT_TOK, &FOLLOW_DISTINCT_TOK_in_postfixTerm6075);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_postfixTerm6077);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm6085);
            	        formula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             args.push_back(f); 
            	        }


            	        // ../../../../src/parser/cvc/Cvc.g:1836:7: ( COMMA formula[f] )*

            	        for (;;)
            	        {
            	            int alt94=2;
            	            switch ( LA(1) )
            	            {
            	            case COMMA:
            	            	{
            	            		alt94=1;
            	            	}
            	                break;

            	            }

            	            switch (alt94)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1836:9: COMMA formula[f]
            	        	    {
            	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_postfixTerm6098);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm6100);
            	        	        formula(ctx, f);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             args.push_back(f); 
            	        	        }


            	        	    }
            	        	    break;

            	        	default:
            	        	    goto loop94;	/* break out of the loop */
            	        	    break;
            	            }
            	        }
            	        loop94: ; /* Jump out to here if this rule does not match */


            	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_postfixTerm6108);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = (args.size() == 1) ? MK_CONST(bool(true)) : MK_EXPR(CVC4::kind::DISTINCT, args); 
            	        }


            	    }
            	    break;

                }
            }

            // ../../../../src/parser/cvc/Cvc.g:1839:5: ( typeAscription[f, t] )?
            {
                int alt96=2;
                switch ( LA(1) )
                {
                    case COLON:
                    	{
                    		switch ( LA(2) )
                    		{
                    		    case COLON:
                    		    	{
                    		    		alt96=1;
                    		    	}
                    		        break;
                    		}

                    	}
                        break;
                }

                switch (alt96)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1839:7: typeAscription[f, t]
            	    {
            	        FOLLOWPUSH(FOLLOW_typeAscription_in_postfixTerm6130);
            	        typeAscription(ctx, f, t);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             if(f.getKind() == CVC4::kind::APPLY_CONSTRUCTOR && t.isDatatype()) {
            	                      std::vector<CVC4::Expr> v;
            	                      Expr e = f.getOperator();
            	                      const DatatypeConstructor& dtc = Datatype::datatypeOf(e)[Datatype::indexOf(e)];
            	                      v.push_back(MK_EXPR( CVC4::kind::APPLY_TYPE_ASCRIPTION,
            	                                           MK_CONST(AscriptionType(dtc.getSpecializedConstructorType(t))), f.getOperator() ));
            	                      v.insert(v.end(), f.begin(), f.end());
            	                      f = MK_EXPR(CVC4::kind::APPLY_CONSTRUCTOR, v);
            	                    } else if(f.getKind() == CVC4::kind::EMPTYSET && t.isSet()) {
            	                      f = MK_CONST(CVC4::EmptySet(t));
            	                    } else if(f.getKind() == CVC4::kind::UNIVERSE_SET && t.isSet()) {
            	                      f = EXPR_MANAGER->mkNullaryOperator(t, kind::UNIVERSE_SET);
            	                    } else {
            	                      if(f.getType() != t) {
            	                        PARSER_STATE->parseError("Type ascription not satisfied.");
            	                      }
            	                    }
            	                  
            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulepostfixTermEx; /* Prevent compiler warnings */
    rulepostfixTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end postfixTerm */

/**
 * $ANTLR start bvTerm
 * ../../../../src/parser/cvc/Cvc.g:1861:1: bvTerm[CVC4::Expr& f] : ( BVXOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVNAND_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVNOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVCOMP_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVXNOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVUMINUS_TOK LPAREN formula[f] RPAREN | BVPLUS_TOK LPAREN k= numeral COMMA formula[f] ( COMMA formula[f2] )+ RPAREN | BVSUB_TOK LPAREN k= numeral COMMA formula[f] COMMA formula[f2] RPAREN | BVMULT_TOK LPAREN k= numeral COMMA formula[f] COMMA formula[f2] RPAREN | BVUDIV_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSDIV_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVUREM_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSREM_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSMOD_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSHL_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVASHR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVLSHR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | SX_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVZEROEXTEND_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVREPEAT_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVROTR_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVROTL_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVLT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVLE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVGT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVGE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSLT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSLE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSGT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSGE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | stringTerm[f] );
 */
static void
bvTerm(pCvcParser ctx, CVC4::Expr& f)
{
    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    /* Initialize rule variables
     */


      Expr f2;
      std::vector<Expr> args;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1867:3: ( BVXOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVNAND_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVNOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVCOMP_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVXNOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVUMINUS_TOK LPAREN formula[f] RPAREN | BVPLUS_TOK LPAREN k= numeral COMMA formula[f] ( COMMA formula[f2] )+ RPAREN | BVSUB_TOK LPAREN k= numeral COMMA formula[f] COMMA formula[f2] RPAREN | BVMULT_TOK LPAREN k= numeral COMMA formula[f] COMMA formula[f2] RPAREN | BVUDIV_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSDIV_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVUREM_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSREM_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSMOD_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSHL_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVASHR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVLSHR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | SX_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVZEROEXTEND_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVREPEAT_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVROTR_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVROTL_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVLT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVLE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVGT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVGE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSLT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSLE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSGT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSGE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | stringTerm[f] )

            ANTLR3_UINT32 alt98;

            alt98=31;

            switch ( LA(1) )
            {
            case BVXOR_TOK:
            	{
            		alt98=1;
            	}
                break;
            case BVNAND_TOK:
            	{
            		alt98=2;
            	}
                break;
            case BVNOR_TOK:
            	{
            		alt98=3;
            	}
                break;
            case BVCOMP_TOK:
            	{
            		alt98=4;
            	}
                break;
            case BVXNOR_TOK:
            	{
            		alt98=5;
            	}
                break;
            case BVUMINUS_TOK:
            	{
            		alt98=6;
            	}
                break;
            case BVPLUS_TOK:
            	{
            		alt98=7;
            	}
                break;
            case BVSUB_TOK:
            	{
            		alt98=8;
            	}
                break;
            case BVMULT_TOK:
            	{
            		alt98=9;
            	}
                break;
            case BVUDIV_TOK:
            	{
            		alt98=10;
            	}
                break;
            case BVSDIV_TOK:
            	{
            		alt98=11;
            	}
                break;
            case BVUREM_TOK:
            	{
            		alt98=12;
            	}
                break;
            case BVSREM_TOK:
            	{
            		alt98=13;
            	}
                break;
            case BVSMOD_TOK:
            	{
            		alt98=14;
            	}
                break;
            case BVSHL_TOK:
            	{
            		alt98=15;
            	}
                break;
            case BVASHR_TOK:
            	{
            		alt98=16;
            	}
                break;
            case BVLSHR_TOK:
            	{
            		alt98=17;
            	}
                break;
            case SX_TOK:
            	{
            		alt98=18;
            	}
                break;
            case BVZEROEXTEND_TOK:
            	{
            		alt98=19;
            	}
                break;
            case BVREPEAT_TOK:
            	{
            		alt98=20;
            	}
                break;
            case BVROTR_TOK:
            	{
            		alt98=21;
            	}
                break;
            case BVROTL_TOK:
            	{
            		alt98=22;
            	}
                break;
            case BVLT_TOK:
            	{
            		alt98=23;
            	}
                break;
            case BVLE_TOK:
            	{
            		alt98=24;
            	}
                break;
            case BVGT_TOK:
            	{
            		alt98=25;
            	}
                break;
            case BVGE_TOK:
            	{
            		alt98=26;
            	}
                break;
            case BVSLT_TOK:
            	{
            		alt98=27;
            	}
                break;
            case BVSLE_TOK:
            	{
            		alt98=28;
            	}
                break;
            case BVSGT_TOK:
            	{
            		alt98=29;
            	}
                break;
            case BVSGE_TOK:
            	{
            		alt98=30;
            	}
                break;
            case ARRAY_TOK:
            case BAR:
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case FALSE_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IF_TOK:
            case INTEGER_LITERAL:
            case LBRACE:
            case LPAREN:
            case PARENHASH:
            case SETS_CARD_TOK:
            case STRING_CONCAT_TOK:
            case STRING_CONTAINS_TOK:
            case STRING_INDEXOF_TOK:
            case STRING_ITOS_TOK:
            case STRING_LENGTH_TOK:
            case STRING_LITERAL:
            case STRING_PREFIXOF_TOK:
            case STRING_REPLACE_TOK:
            case STRING_STOI_TOK:
            case STRING_STOU16_TOK:
            case STRING_STOU32_TOK:
            case STRING_SUBSTR_TOK:
            case STRING_SUFFIXOF_TOK:
            case STRING_U16TOS_TOK:
            case STRING_U32TOS_TOK:
            case TRUE_TOK:
            case UNIVSET_TOK:
            	{
            		alt98=31;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 98;
                EXCEPTION->state        = 0;


                goto rulebvTermEx;

            }

            switch (alt98)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1867:5: BVXOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVXOR_TOK, &FOLLOW_BVXOR_TOK_in_bvTerm6171);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6173);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6175);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6178);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6180);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6183);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_XOR, f, f2); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1869:5: BVNAND_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVNAND_TOK, &FOLLOW_BVNAND_TOK_in_bvTerm6195);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6197);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6199);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6202);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6204);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6207);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_NAND, f, f2); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:1871:5: BVNOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVNOR_TOK, &FOLLOW_BVNOR_TOK_in_bvTerm6219);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6221);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6223);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6226);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6228);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6231);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_NOR, f, f2); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/cvc/Cvc.g:1873:5: BVCOMP_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVCOMP_TOK, &FOLLOW_BVCOMP_TOK_in_bvTerm6243);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6245);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6247);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6250);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6252);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6255);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_COMP, f, f2); 
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/cvc/Cvc.g:1875:5: BVXNOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVXNOR_TOK, &FOLLOW_BVXNOR_TOK_in_bvTerm6267);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6269);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6271);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6274);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6276);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6279);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_XNOR, f, f2); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/cvc/Cvc.g:1879:5: BVUMINUS_TOK LPAREN formula[f] RPAREN
        	    {
        	         MATCHT(BVUMINUS_TOK, &FOLLOW_BVUMINUS_TOK_in_bvTerm6298);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6300);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6302);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6305);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_NEG, f); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/cvc/Cvc.g:1882:5: BVPLUS_TOK LPAREN k= numeral COMMA formula[f] ( COMMA formula[f2] )+ RPAREN
        	    {
        	         MATCHT(BVPLUS_TOK, &FOLLOW_BVPLUS_TOK_in_bvTerm6323);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6325);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm6329);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6331);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6333);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1883:5: ( COMMA formula[f2] )+
        	        {
        	            int cnt97=0;

        	            for (;;)
        	            {
        	                int alt97=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case COMMA:
        	        		{
        	        			alt97=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt97)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/cvc/Cvc.g:1883:7: COMMA formula[f2]
        	        	        {
        	        	             MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6344);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulebvTermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_formula_in_bvTerm6346);
        	        	            formula(ctx, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulebvTermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 args.push_back(f2); 
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt97 >= 1 )
        	        		{
        	        		    goto loop97;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulebvTermEx;
        	        	}
        	        	cnt97++;
        	            }
        	            loop97: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6354);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  if (k <= 0) {
        	                    PARSER_STATE->parseError("BVPLUS(k,_,_) must have k > 0");
        	                  }
        	                  for (unsigned i = 0; i < args.size(); ++ i) {
        	                    ENSURE_BV_SIZE(k, args[i]);
        	                  }
        	                  f = MK_EXPR(CVC4::kind::BITVECTOR_PLUS, args);
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/cvc/Cvc.g:1894:5: BVSUB_TOK LPAREN k= numeral COMMA formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSUB_TOK, &FOLLOW_BVSUB_TOK_in_bvTerm6372);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6374);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm6378);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6380);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6382);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6385);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6387);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6390);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  if (k <= 0) {
        	                    PARSER_STATE->parseError("BVSUB(k,_,_) must have k > 0");
        	                  }
        	                  ENSURE_BV_SIZE(k, f);
        	                  ENSURE_BV_SIZE(k, f2);
        	                  f = MK_EXPR(CVC4::kind::BITVECTOR_SUB, f, f2);
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/cvc/Cvc.g:1904:5: BVMULT_TOK LPAREN k= numeral COMMA formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVMULT_TOK, &FOLLOW_BVMULT_TOK_in_bvTerm6408);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6410);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm6414);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6416);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6418);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6421);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6423);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6426);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  if (k <= 0) {
        	                    PARSER_STATE->parseError("BVMULT(k,_,_) must have k > 0");
        	                  }
        	                  ENSURE_BV_SIZE(k, f);
        	                  ENSURE_BV_SIZE(k, f2);
        	                  f = MK_EXPR(CVC4::kind::BITVECTOR_MULT, f, f2);
        	                
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/cvc/Cvc.g:1914:5: BVUDIV_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVUDIV_TOK, &FOLLOW_BVUDIV_TOK_in_bvTerm6444);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6446);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6448);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6451);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6453);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6456);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_UDIV, f, f2); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/cvc/Cvc.g:1917:5: BVSDIV_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSDIV_TOK, &FOLLOW_BVSDIV_TOK_in_bvTerm6474);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6476);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6478);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6481);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6483);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6486);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SDIV, f, f2); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/cvc/Cvc.g:1920:5: BVUREM_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVUREM_TOK, &FOLLOW_BVUREM_TOK_in_bvTerm6504);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6506);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6508);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6511);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6513);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6516);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_UREM, f, f2); 
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/cvc/Cvc.g:1923:5: BVSREM_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSREM_TOK, &FOLLOW_BVSREM_TOK_in_bvTerm6534);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6536);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6538);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6541);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6543);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6546);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SREM, f, f2); 
        	        }


        	    }
        	    break;
        	case 14:
        	    // ../../../../src/parser/cvc/Cvc.g:1926:5: BVSMOD_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSMOD_TOK, &FOLLOW_BVSMOD_TOK_in_bvTerm6564);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6566);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6568);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6571);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6573);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6576);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SMOD, f, f2); 
        	        }


        	    }
        	    break;
        	case 15:
        	    // ../../../../src/parser/cvc/Cvc.g:1929:5: BVSHL_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSHL_TOK, &FOLLOW_BVSHL_TOK_in_bvTerm6594);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6596);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6598);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6601);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6603);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6606);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SHL, f, f2); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // ../../../../src/parser/cvc/Cvc.g:1932:5: BVASHR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVASHR_TOK, &FOLLOW_BVASHR_TOK_in_bvTerm6624);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6626);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6628);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6631);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6633);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6636);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_ASHR, f, f2); 
        	        }


        	    }
        	    break;
        	case 17:
        	    // ../../../../src/parser/cvc/Cvc.g:1935:5: BVLSHR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVLSHR_TOK, &FOLLOW_BVLSHR_TOK_in_bvTerm6654);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6656);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6658);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6661);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6663);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6666);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_LSHR, f, f2); 
        	        }


        	    }
        	    break;
        	case 18:
        	    // ../../../../src/parser/cvc/Cvc.g:1938:5: SX_TOK LPAREN formula[f] COMMA k= numeral RPAREN
        	    {
        	         MATCHT(SX_TOK, &FOLLOW_SX_TOK_in_bvTerm6684);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6686);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6688);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6691);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm6695);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6697);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             unsigned n = BitVectorType(f.getType()).getSize();
        	                  // Sign extension in TheoryBitVector is defined as in SMT-LIB
        	                  // which is different than in the CVC language
        	                  // SX(BITVECTOR(k), n) in CVC language extends to n bits
        	                  // In SMT-LIB, such a thing expands to k + n bits
        	                  f = MK_EXPR(MK_CONST(BitVectorSignExtend(k - n)), f); 
        	        }


        	    }
        	    break;
        	case 19:
        	    // ../../../../src/parser/cvc/Cvc.g:1946:5: BVZEROEXTEND_TOK LPAREN formula[f] COMMA k= numeral RPAREN
        	    {
        	         MATCHT(BVZEROEXTEND_TOK, &FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6715);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6717);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6719);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6722);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm6726);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6728);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             unsigned n = BitVectorType(f.getType()).getSize();
        	                  // Zero extension in TheoryBitVector is defined as in SMT-LIB
        	                  // which is the same as in CVC3, but different than SX!
        	                  // SX(BITVECTOR(k), n) in CVC language extends to n bits
        	                  // BVZEROEXTEND(BITVECTOR(k), n) in CVC language extends to k + n bits
        	                  f = MK_EXPR(MK_CONST(BitVectorZeroExtend(k)), f); 
        	        }


        	    }
        	    break;
        	case 20:
        	    // ../../../../src/parser/cvc/Cvc.g:1954:5: BVREPEAT_TOK LPAREN formula[f] COMMA k= numeral RPAREN
        	    {
        	         MATCHT(BVREPEAT_TOK, &FOLLOW_BVREPEAT_TOK_in_bvTerm6746);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6748);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6750);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6753);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm6757);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6759);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(MK_CONST(BitVectorRepeat(k)), f); 
        	        }


        	    }
        	    break;
        	case 21:
        	    // ../../../../src/parser/cvc/Cvc.g:1957:5: BVROTR_TOK LPAREN formula[f] COMMA k= numeral RPAREN
        	    {
        	         MATCHT(BVROTR_TOK, &FOLLOW_BVROTR_TOK_in_bvTerm6777);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6779);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6781);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6784);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm6788);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6790);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(MK_CONST(BitVectorRotateRight(k)), f); 
        	        }


        	    }
        	    break;
        	case 22:
        	    // ../../../../src/parser/cvc/Cvc.g:1960:5: BVROTL_TOK LPAREN formula[f] COMMA k= numeral RPAREN
        	    {
        	         MATCHT(BVROTL_TOK, &FOLLOW_BVROTL_TOK_in_bvTerm6808);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6810);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6812);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6815);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm6819);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6821);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(MK_CONST(BitVectorRotateLeft(k)), f); 
        	        }


        	    }
        	    break;
        	case 23:
        	    // ../../../../src/parser/cvc/Cvc.g:1964:5: BVLT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVLT_TOK, &FOLLOW_BVLT_TOK_in_bvTerm6840);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6842);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6844);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6847);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6849);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6852);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_ULT, f, f2); 
        	        }


        	    }
        	    break;
        	case 24:
        	    // ../../../../src/parser/cvc/Cvc.g:1966:5: BVLE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVLE_TOK, &FOLLOW_BVLE_TOK_in_bvTerm6864);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6866);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6868);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6871);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6873);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6876);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_ULE, f, f2); 
        	        }


        	    }
        	    break;
        	case 25:
        	    // ../../../../src/parser/cvc/Cvc.g:1968:5: BVGT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVGT_TOK, &FOLLOW_BVGT_TOK_in_bvTerm6888);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6890);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6892);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6895);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6897);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6900);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_UGT, f, f2); 
        	        }


        	    }
        	    break;
        	case 26:
        	    // ../../../../src/parser/cvc/Cvc.g:1970:5: BVGE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVGE_TOK, &FOLLOW_BVGE_TOK_in_bvTerm6912);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6914);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6916);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6919);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6921);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6924);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_UGE, f, f2); 
        	        }


        	    }
        	    break;
        	case 27:
        	    // ../../../../src/parser/cvc/Cvc.g:1972:5: BVSLT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSLT_TOK, &FOLLOW_BVSLT_TOK_in_bvTerm6936);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6938);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6940);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6943);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6945);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6948);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SLT, f, f2); 
        	        }


        	    }
        	    break;
        	case 28:
        	    // ../../../../src/parser/cvc/Cvc.g:1974:5: BVSLE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSLE_TOK, &FOLLOW_BVSLE_TOK_in_bvTerm6960);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6962);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6964);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6967);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6969);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6972);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SLE, f, f2); 
        	        }


        	    }
        	    break;
        	case 29:
        	    // ../../../../src/parser/cvc/Cvc.g:1976:5: BVSGT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSGT_TOK, &FOLLOW_BVSGT_TOK_in_bvTerm6984);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6986);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6988);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6991);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6993);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6996);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SGT, f, f2); 
        	        }


        	    }
        	    break;
        	case 30:
        	    // ../../../../src/parser/cvc/Cvc.g:1978:5: BVSGE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSGE_TOK, &FOLLOW_BVSGE_TOK_in_bvTerm7008);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm7010);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm7012);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm7015);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm7017);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm7020);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SGE, f, f2); 
        	        }


        	    }
        	    break;
        	case 31:
        	    // ../../../../src/parser/cvc/Cvc.g:1980:5: stringTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_stringTerm_in_bvTerm7032);
        	        stringTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulebvTermEx; /* Prevent compiler warnings */
    rulebvTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bvTerm */

/**
 * $ANTLR start stringTerm
 * ../../../../src/parser/cvc/Cvc.g:1983:1: stringTerm[CVC4::Expr& f] : ( STRING_CONCAT_TOK LPAREN formula[f] ( COMMA formula[f2] )+ RPAREN | STRING_LENGTH_TOK LPAREN formula[f] RPAREN | STRING_CONTAINS_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | STRING_SUBSTR_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN | STRING_INDEXOF_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN | STRING_REPLACE_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN | STRING_PREFIXOF_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | STRING_SUFFIXOF_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | STRING_STOI_TOK LPAREN formula[f] RPAREN | STRING_ITOS_TOK LPAREN formula[f] RPAREN | STRING_U16TOS_TOK LPAREN formula[f] RPAREN | STRING_STOU16_TOK LPAREN formula[f] RPAREN | STRING_U32TOS_TOK LPAREN formula[f] RPAREN | STRING_STOU32_TOK LPAREN formula[f] RPAREN | str[s] | setsTerm[f] );
 */
static void
stringTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      Expr f2;
      Expr f3;
      std::string s;
      std::vector<Expr> args;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1991:3: ( STRING_CONCAT_TOK LPAREN formula[f] ( COMMA formula[f2] )+ RPAREN | STRING_LENGTH_TOK LPAREN formula[f] RPAREN | STRING_CONTAINS_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | STRING_SUBSTR_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN | STRING_INDEXOF_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN | STRING_REPLACE_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN | STRING_PREFIXOF_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | STRING_SUFFIXOF_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | STRING_STOI_TOK LPAREN formula[f] RPAREN | STRING_ITOS_TOK LPAREN formula[f] RPAREN | STRING_U16TOS_TOK LPAREN formula[f] RPAREN | STRING_STOU16_TOK LPAREN formula[f] RPAREN | STRING_U32TOS_TOK LPAREN formula[f] RPAREN | STRING_STOU32_TOK LPAREN formula[f] RPAREN | str[s] | setsTerm[f] )

            ANTLR3_UINT32 alt100;

            alt100=16;

            switch ( LA(1) )
            {
            case STRING_CONCAT_TOK:
            	{
            		alt100=1;
            	}
                break;
            case STRING_LENGTH_TOK:
            	{
            		alt100=2;
            	}
                break;
            case STRING_CONTAINS_TOK:
            	{
            		alt100=3;
            	}
                break;
            case STRING_SUBSTR_TOK:
            	{
            		alt100=4;
            	}
                break;
            case STRING_INDEXOF_TOK:
            	{
            		alt100=5;
            	}
                break;
            case STRING_REPLACE_TOK:
            	{
            		alt100=6;
            	}
                break;
            case STRING_PREFIXOF_TOK:
            	{
            		alt100=7;
            	}
                break;
            case STRING_SUFFIXOF_TOK:
            	{
            		alt100=8;
            	}
                break;
            case STRING_STOI_TOK:
            	{
            		alt100=9;
            	}
                break;
            case STRING_ITOS_TOK:
            	{
            		alt100=10;
            	}
                break;
            case STRING_U16TOS_TOK:
            	{
            		alt100=11;
            	}
                break;
            case STRING_STOU16_TOK:
            	{
            		alt100=12;
            	}
                break;
            case STRING_U32TOS_TOK:
            	{
            		alt100=13;
            	}
                break;
            case STRING_STOU32_TOK:
            	{
            		alt100=14;
            	}
                break;
            case STRING_LITERAL:
            	{
            		alt100=15;
            	}
                break;
            case ARRAY_TOK:
            case BAR:
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case FALSE_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IF_TOK:
            case INTEGER_LITERAL:
            case LBRACE:
            case LPAREN:
            case PARENHASH:
            case SETS_CARD_TOK:
            case TRUE_TOK:
            case UNIVSET_TOK:
            	{
            		alt100=16;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 100;
                EXCEPTION->state        = 0;


                goto rulestringTermEx;

            }

            switch (alt100)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1991:5: STRING_CONCAT_TOK LPAREN formula[f] ( COMMA formula[f2] )+ RPAREN
        	    {
        	         MATCHT(STRING_CONCAT_TOK, &FOLLOW_STRING_CONCAT_TOK_in_stringTerm7058);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm7060);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7062);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1992:5: ( COMMA formula[f2] )+
        	        {
        	            int cnt99=0;

        	            for (;;)
        	            {
        	                int alt99=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case COMMA:
        	        		{
        	        			alt99=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt99)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/cvc/Cvc.g:1992:7: COMMA formula[f2]
        	        	        {
        	        	             MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm7073);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulestringTermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_formula_in_stringTerm7075);
        	        	            formula(ctx, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulestringTermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 args.push_back(f2); 
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt99 >= 1 )
        	        		{
        	        		    goto loop99;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulestringTermEx;
        	        	}
        	        	cnt99++;
        	            }
        	            loop99: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm7083);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_CONCAT, args); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1994:5: STRING_LENGTH_TOK LPAREN formula[f] RPAREN
        	    {
        	         MATCHT(STRING_LENGTH_TOK, &FOLLOW_STRING_LENGTH_TOK_in_stringTerm7095);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm7097);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7099);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm7102);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_LENGTH, f); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:1996:5: STRING_CONTAINS_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(STRING_CONTAINS_TOK, &FOLLOW_STRING_CONTAINS_TOK_in_stringTerm7114);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm7116);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7118);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm7121);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7123);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm7126);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_STRCTN, f, f2); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/cvc/Cvc.g:1998:5: STRING_SUBSTR_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN
        	    {
        	         MATCHT(STRING_SUBSTR_TOK, &FOLLOW_STRING_SUBSTR_TOK_in_stringTerm7138);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm7140);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7142);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm7145);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7147);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm7150);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7152);
        	        formula(ctx, f3);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm7155);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_SUBSTR, f, f2, f3); 
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/cvc/Cvc.g:2000:5: STRING_INDEXOF_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN
        	    {
        	         MATCHT(STRING_INDEXOF_TOK, &FOLLOW_STRING_INDEXOF_TOK_in_stringTerm7167);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm7169);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7171);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm7174);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7176);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm7179);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7181);
        	        formula(ctx, f3);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm7184);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_STRIDOF, f, f2, f3); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/cvc/Cvc.g:2002:5: STRING_REPLACE_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN
        	    {
        	         MATCHT(STRING_REPLACE_TOK, &FOLLOW_STRING_REPLACE_TOK_in_stringTerm7196);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm7198);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7200);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm7203);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7205);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm7208);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7210);
        	        formula(ctx, f3);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm7213);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_STRREPL, f, f2, f3); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/cvc/Cvc.g:2004:5: STRING_PREFIXOF_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(STRING_PREFIXOF_TOK, &FOLLOW_STRING_PREFIXOF_TOK_in_stringTerm7225);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm7227);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7229);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm7232);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7234);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm7237);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_PREFIX, f, f2); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/cvc/Cvc.g:2006:5: STRING_SUFFIXOF_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(STRING_SUFFIXOF_TOK, &FOLLOW_STRING_SUFFIXOF_TOK_in_stringTerm7249);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm7251);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7253);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm7256);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7258);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm7261);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_SUFFIX, f, f2); 
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/cvc/Cvc.g:2008:5: STRING_STOI_TOK LPAREN formula[f] RPAREN
        	    {
        	         MATCHT(STRING_STOI_TOK, &FOLLOW_STRING_STOI_TOK_in_stringTerm7273);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm7275);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7277);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm7280);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_STOI, f); 
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/cvc/Cvc.g:2010:5: STRING_ITOS_TOK LPAREN formula[f] RPAREN
        	    {
        	         MATCHT(STRING_ITOS_TOK, &FOLLOW_STRING_ITOS_TOK_in_stringTerm7292);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm7294);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7296);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm7299);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_ITOS, f); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/cvc/Cvc.g:2012:5: STRING_U16TOS_TOK LPAREN formula[f] RPAREN
        	    {
        	         MATCHT(STRING_U16TOS_TOK, &FOLLOW_STRING_U16TOS_TOK_in_stringTerm7311);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm7313);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7315);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm7318);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_U16TOS, f); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/cvc/Cvc.g:2014:5: STRING_STOU16_TOK LPAREN formula[f] RPAREN
        	    {
        	         MATCHT(STRING_STOU16_TOK, &FOLLOW_STRING_STOU16_TOK_in_stringTerm7330);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm7332);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7334);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm7337);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_STOU16, f); 
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/cvc/Cvc.g:2016:5: STRING_U32TOS_TOK LPAREN formula[f] RPAREN
        	    {
        	         MATCHT(STRING_U32TOS_TOK, &FOLLOW_STRING_U32TOS_TOK_in_stringTerm7349);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm7351);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7353);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm7356);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_U32TOS, f); 
        	        }


        	    }
        	    break;
        	case 14:
        	    // ../../../../src/parser/cvc/Cvc.g:2018:5: STRING_STOU32_TOK LPAREN formula[f] RPAREN
        	    {
        	         MATCHT(STRING_STOU32_TOK, &FOLLOW_STRING_STOU32_TOK_in_stringTerm7368);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm7370);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm7372);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm7375);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_STOU32, f); 
        	        }


        	    }
        	    break;
        	case 15:
        	    // ../../../../src/parser/cvc/Cvc.g:2022:5: str[s]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_stringTerm7398);
        	        str(ctx, s);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_CONST(CVC4::String(s)); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // ../../../../src/parser/cvc/Cvc.g:2025:5: setsTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_setsTerm_in_stringTerm7412);
        	        setsTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulestringTermEx; /* Prevent compiler warnings */
    rulestringTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end stringTerm */

/**
 * $ANTLR start setsTerm
 * ../../../../src/parser/cvc/Cvc.g:2028:1: setsTerm[CVC4::Expr& f] : ( SETS_CARD_TOK LPAREN formula[f] RPAREN | simpleTerm[f] );
 */
static void
setsTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */



    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:2032:3: ( SETS_CARD_TOK LPAREN formula[f] RPAREN | simpleTerm[f] )

            ANTLR3_UINT32 alt101;

            alt101=2;

            switch ( LA(1) )
            {
            case SETS_CARD_TOK:
            	{
            		alt101=1;
            	}
                break;
            case ARRAY_TOK:
            case BAR:
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case FALSE_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IF_TOK:
            case INTEGER_LITERAL:
            case LBRACE:
            case LPAREN:
            case PARENHASH:
            case TRUE_TOK:
            case UNIVSET_TOK:
            	{
            		alt101=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 101;
                EXCEPTION->state        = 0;


                goto rulesetsTermEx;

            }

            switch (alt101)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:2032:5: SETS_CARD_TOK LPAREN formula[f] RPAREN
        	    {
        	         MATCHT(SETS_CARD_TOK, &FOLLOW_SETS_CARD_TOK_in_setsTerm7440);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesetsTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_setsTerm7442);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesetsTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_setsTerm7444);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesetsTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_setsTerm7447);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesetsTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::CARD, f); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:2034:5: simpleTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleTerm_in_setsTerm7459);
        	        simpleTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesetsTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesetsTermEx; /* Prevent compiler warnings */
    rulesetsTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end setsTerm */

/**
 * $ANTLR start simpleTerm
 * ../../../../src/parser/cvc/Cvc.g:2039:1: simpleTerm[CVC4::Expr& f] : ( iteTerm[f] | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | LPAREN RPAREN | PARENHASH HASHPAREN | LBRACE RBRACE | UNIVSET_TOK | LBRACE formula[f] ( COMMA formula[f] )* RBRACE | BAR BAR formula[f] BAR BAR | ARRAY_TOK LPAREN restrictedType[t, CHECK_DECLARED] OF_TOK restrictedType[t2, CHECK_DECLARED] RPAREN COLON simpleTerm[f] | TRUE_TOK | FALSE_TOK | DECIMAL_LITERAL | INTEGER_LITERAL | HEX_LITERAL | BINARY_LITERAL | PARENHASH recordEntry[name,e] ( COMMA recordEntry[name,e] )* HASHPAREN | identifier[name,CHECK_DECLARED,SYM_VARIABLE] );
 */
static void
simpleTerm(pCvcParser ctx, CVC4::Expr& f)
{
    pANTLR3_COMMON_TOKEN    DECIMAL_LITERAL17;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL18;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL19;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL20;

    /* Initialize rule variables
     */


      std::string name;
      std::vector<Expr> args;
      std::vector<std::string> names;
      Expr e;
      Debug("parser-extra") << "term: " << AntlrInput::tokenText(LT(1)) << std::endl;
      Type t, t2;

    DECIMAL_LITERAL17       = NULL;
    INTEGER_LITERAL18       = NULL;
    HEX_LITERAL19       = NULL;
    BINARY_LITERAL20       = NULL;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:2049:3: ( iteTerm[f] | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | LPAREN RPAREN | PARENHASH HASHPAREN | LBRACE RBRACE | UNIVSET_TOK | LBRACE formula[f] ( COMMA formula[f] )* RBRACE | BAR BAR formula[f] BAR BAR | ARRAY_TOK LPAREN restrictedType[t, CHECK_DECLARED] OF_TOK restrictedType[t2, CHECK_DECLARED] RPAREN COLON simpleTerm[f] | TRUE_TOK | FALSE_TOK | DECIMAL_LITERAL | INTEGER_LITERAL | HEX_LITERAL | BINARY_LITERAL | PARENHASH recordEntry[name,e] ( COMMA recordEntry[name,e] )* HASHPAREN | identifier[name,CHECK_DECLARED,SYM_VARIABLE] )

            ANTLR3_UINT32 alt105;

            alt105=17;

            switch ( LA(1) )
            {
            case IF_TOK:
            	{
            		alt105=1;
            	}
                break;
            case LPAREN:
            	{
            		switch ( LA(2) )
            		{
            		case RPAREN:
            			{
            				alt105=3;
            			}
            		    break;
            		case ABS_TOK:
            		case ARRAY_TOK:
            		case BAR:
            		case BINARY_LITERAL:
            		case BVASHR_TOK:
            		case BVCOMP_TOK:
            		case BVGE_TOK:
            		case BVGT_TOK:
            		case BVLE_TOK:
            		case BVLSHR_TOK:
            		case BVLT_TOK:
            		case BVMULT_TOK:
            		case BVNAND_TOK:
            		case BVNEG_TOK:
            		case BVNOR_TOK:
            		case BVPLUS_TOK:
            		case BVREPEAT_TOK:
            		case BVROTL_TOK:
            		case BVROTR_TOK:
            		case BVSDIV_TOK:
            		case BVSGE_TOK:
            		case BVSGT_TOK:
            		case BVSHL_TOK:
            		case BVSLE_TOK:
            		case BVSLT_TOK:
            		case BVSMOD_TOK:
            		case BVSREM_TOK:
            		case BVSUB_TOK:
            		case BVUDIV_TOK:
            		case BVUMINUS_TOK:
            		case BVUREM_TOK:
            		case BVXNOR_TOK:
            		case BVXOR_TOK:
            		case BVZEROEXTEND_TOK:
            		case DECIMAL_LITERAL:
            		case DISTINCT_TOK:
            		case DIVISIBLE_TOK:
            		case EXISTS_TOK:
            		case FALSE_TOK:
            		case FLOOR_TOK:
            		case FORALL_TOK:
            		case HEX_LITERAL:
            		case IDENTIFIER:
            		case IDEN_TOK:
            		case IF_TOK:
            		case INTEGER_LITERAL:
            		case IS_INTEGER_TOK:
            		case LAMBDA:
            		case LBRACE:
            		case LET_TOK:
            		case LPAREN:
            		case MINUS_TOK:
            		case NOT_TOK:
            		case PARENHASH:
            		case SETS_CARD_TOK:
            		case STRING_CONCAT_TOK:
            		case STRING_CONTAINS_TOK:
            		case STRING_INDEXOF_TOK:
            		case STRING_ITOS_TOK:
            		case STRING_LENGTH_TOK:
            		case STRING_LITERAL:
            		case STRING_PREFIXOF_TOK:
            		case STRING_REPLACE_TOK:
            		case STRING_STOI_TOK:
            		case STRING_STOU16_TOK:
            		case STRING_STOU32_TOK:
            		case STRING_SUBSTR_TOK:
            		case STRING_SUFFIXOF_TOK:
            		case STRING_U16TOS_TOK:
            		case STRING_U32TOS_TOK:
            		case SX_TOK:
            		case TRANSCLOSURE_TOK:
            		case TRANSPOSE_TOK:
            		case TRUE_TOK:
            		case TUPLE_TOK:
            		case UNIVSET_TOK:
            			{
            				alt105=2;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 105;
            		    EXCEPTION->state        = 2;


            		    goto rulesimpleTermEx;

            		}

            	}
                break;
            case PARENHASH:
            	{
            		switch ( LA(2) )
            		{
            		case HASHPAREN:
            			{
            				alt105=4;
            			}
            		    break;
            		case IDENTIFIER:
            			{
            				alt105=16;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 105;
            		    EXCEPTION->state        = 3;


            		    goto rulesimpleTermEx;

            		}

            	}
                break;
            case LBRACE:
            	{
            		switch ( LA(2) )
            		{
            		case RBRACE:
            			{
            				alt105=5;
            			}
            		    break;
            		case ABS_TOK:
            		case ARRAY_TOK:
            		case BAR:
            		case BINARY_LITERAL:
            		case BVASHR_TOK:
            		case BVCOMP_TOK:
            		case BVGE_TOK:
            		case BVGT_TOK:
            		case BVLE_TOK:
            		case BVLSHR_TOK:
            		case BVLT_TOK:
            		case BVMULT_TOK:
            		case BVNAND_TOK:
            		case BVNEG_TOK:
            		case BVNOR_TOK:
            		case BVPLUS_TOK:
            		case BVREPEAT_TOK:
            		case BVROTL_TOK:
            		case BVROTR_TOK:
            		case BVSDIV_TOK:
            		case BVSGE_TOK:
            		case BVSGT_TOK:
            		case BVSHL_TOK:
            		case BVSLE_TOK:
            		case BVSLT_TOK:
            		case BVSMOD_TOK:
            		case BVSREM_TOK:
            		case BVSUB_TOK:
            		case BVUDIV_TOK:
            		case BVUMINUS_TOK:
            		case BVUREM_TOK:
            		case BVXNOR_TOK:
            		case BVXOR_TOK:
            		case BVZEROEXTEND_TOK:
            		case DECIMAL_LITERAL:
            		case DISTINCT_TOK:
            		case DIVISIBLE_TOK:
            		case EXISTS_TOK:
            		case FALSE_TOK:
            		case FLOOR_TOK:
            		case FORALL_TOK:
            		case HEX_LITERAL:
            		case IDENTIFIER:
            		case IDEN_TOK:
            		case IF_TOK:
            		case INTEGER_LITERAL:
            		case IS_INTEGER_TOK:
            		case LAMBDA:
            		case LBRACE:
            		case LET_TOK:
            		case LPAREN:
            		case MINUS_TOK:
            		case NOT_TOK:
            		case PARENHASH:
            		case SETS_CARD_TOK:
            		case STRING_CONCAT_TOK:
            		case STRING_CONTAINS_TOK:
            		case STRING_INDEXOF_TOK:
            		case STRING_ITOS_TOK:
            		case STRING_LENGTH_TOK:
            		case STRING_LITERAL:
            		case STRING_PREFIXOF_TOK:
            		case STRING_REPLACE_TOK:
            		case STRING_STOI_TOK:
            		case STRING_STOU16_TOK:
            		case STRING_STOU32_TOK:
            		case STRING_SUBSTR_TOK:
            		case STRING_SUFFIXOF_TOK:
            		case STRING_U16TOS_TOK:
            		case STRING_U32TOS_TOK:
            		case SX_TOK:
            		case TRANSCLOSURE_TOK:
            		case TRANSPOSE_TOK:
            		case TRUE_TOK:
            		case TUPLE_TOK:
            		case UNIVSET_TOK:
            			{
            				alt105=7;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 105;
            		    EXCEPTION->state        = 4;


            		    goto rulesimpleTermEx;

            		}

            	}
                break;
            case UNIVSET_TOK:
            	{
            		alt105=6;
            	}
                break;
            case BAR:
            	{
            		alt105=8;
            	}
                break;
            case ARRAY_TOK:
            	{
            		alt105=9;
            	}
                break;
            case TRUE_TOK:
            	{
            		alt105=10;
            	}
                break;
            case FALSE_TOK:
            	{
            		alt105=11;
            	}
                break;
            case DECIMAL_LITERAL:
            	{
            		alt105=12;
            	}
                break;
            case INTEGER_LITERAL:
            	{
            		alt105=13;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt105=14;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt105=15;
            	}
                break;
            case IDENTIFIER:
            	{
            		alt105=17;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 105;
                EXCEPTION->state        = 0;


                goto rulesimpleTermEx;

            }

            switch (alt105)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:2049:5: iteTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_iteTerm_in_simpleTerm7490);
        	        iteTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:2052:5: LPAREN formula[f] ( COMMA formula[f] )* RPAREN
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_simpleTerm7513);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_simpleTerm7515);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:2053:5: ( COMMA formula[f] )*

        	        for (;;)
        	        {
        	            int alt102=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt102=1;
        	            	}
        	                break;

        	            }

        	            switch (alt102)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:2053:7: COMMA formula[f]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_simpleTerm7526);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesimpleTermEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_formula_in_simpleTerm7528);
        	        	        formula(ctx, f);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesimpleTermEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             args.push_back(f); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop102;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop102: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_simpleTerm7536);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(args.size() > 1) {
        	                    /* If args has elements, we must be a tuple literal.
        	                     * Otherwise, f is already the sub-formula, and
        	                     * there's nothing to do */
        	                    std::vector<Type> types;
        	                    for(std::vector<Expr>::const_iterator i = args.begin(); i != args.end(); ++i) {
        	                      types.push_back((*i).getType());
        	                    }
        	                    DatatypeType t = EXPR_MANAGER->mkTupleType(types);
        	                    const Datatype& dt = t.getDatatype();
        	                    args.insert( args.begin(), dt[0].getConstructor() );
        	                    f = MK_EXPR(kind::APPLY_CONSTRUCTOR, args);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:2070:5: LPAREN RPAREN
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_simpleTerm7559);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_simpleTerm7561);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::vector<Type> types;
        	                  DatatypeType t = EXPR_MANAGER->mkTupleType(types);
        	                  const Datatype& dt = t.getDatatype();
        	                  f = MK_EXPR(kind::APPLY_CONSTRUCTOR, dt[0].getConstructor()); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/cvc/Cvc.g:2077:5: PARENHASH HASHPAREN
        	    {
        	         MATCHT(PARENHASH, &FOLLOW_PARENHASH_in_simpleTerm7605);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(HASHPAREN, &FOLLOW_HASHPAREN_in_simpleTerm7607);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             DatatypeType t = EXPR_MANAGER->mkRecordType(std::vector< std::pair<std::string, Type> >());
        	                  const Datatype& dt = t.getDatatype();
        	                  f = MK_EXPR(kind::APPLY_CONSTRUCTOR, dt[0].getConstructor());
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/cvc/Cvc.g:2083:5: LBRACE RBRACE
        	    {
        	         MATCHT(LBRACE, &FOLLOW_LBRACE_in_simpleTerm7625);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RBRACE, &FOLLOW_RBRACE_in_simpleTerm7627);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_CONST(EmptySet(Type())); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/cvc/Cvc.g:2085:5: UNIVSET_TOK
        	    {
        	         MATCHT(UNIVSET_TOK, &FOLLOW_UNIVSET_TOK_in_simpleTerm7639);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             //booleanType is placeholder
        	                  f = EXPR_MANAGER->mkNullaryOperator(EXPR_MANAGER->booleanType(), kind::UNIVERSE_SET);
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/cvc/Cvc.g:2091:5: LBRACE formula[f] ( COMMA formula[f] )* RBRACE
        	    {
        	         MATCHT(LBRACE, &FOLLOW_LBRACE_in_simpleTerm7658);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_simpleTerm7660);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:2092:5: ( COMMA formula[f] )*

        	        for (;;)
        	        {
        	            int alt103=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt103=1;
        	            	}
        	                break;

        	            }

        	            switch (alt103)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:2092:7: COMMA formula[f]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_simpleTerm7671);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesimpleTermEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_formula_in_simpleTerm7673);
        	        	        formula(ctx, f);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesimpleTermEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             args.push_back(f); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop103;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop103: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RBRACE, &FOLLOW_RBRACE_in_simpleTerm7681);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(kind::SINGLETON, args[0]);
        	                  for(size_t i = 1; i < args.size(); ++i) {
        	                    f = MK_EXPR(kind::UNION, f, MK_EXPR(kind::SINGLETON, args[i]));
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/cvc/Cvc.g:2100:5: BAR BAR formula[f] BAR BAR
        	    {
        	         MATCHT(BAR, &FOLLOW_BAR_in_simpleTerm7700);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(BAR, &FOLLOW_BAR_in_simpleTerm7702);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_simpleTerm7704);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	         MATCHT(BAR, &FOLLOW_BAR_in_simpleTerm7709);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(BAR, &FOLLOW_BAR_in_simpleTerm7711);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(kind::CARD, args[0]);
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/cvc/Cvc.g:2105:5: ARRAY_TOK LPAREN restrictedType[t, CHECK_DECLARED] OF_TOK restrictedType[t2, CHECK_DECLARED] RPAREN COLON simpleTerm[f]
        	    {
        	         MATCHT(ARRAY_TOK, &FOLLOW_ARRAY_TOK_in_simpleTerm7730);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_simpleTerm7734);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_restrictedType_in_simpleTerm7740);
        	        restrictedType(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(OF_TOK, &FOLLOW_OF_TOK_in_simpleTerm7743);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_restrictedType_in_simpleTerm7745);
        	        restrictedType(ctx, t2, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_simpleTerm7752);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_simpleTerm7754);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_simpleTerm_in_simpleTerm7756);
        	        simpleTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             /* Eventually if we support a bound var (like a lambda) for array
        	                   * literals, we can use the push/pop scope. */
        	                  /* PARSER_STATE->popScope(); */
        	                  t = EXPR_MANAGER->mkArrayType(t, t2);
        	                  if(!f.isConst()) {
        	                    std::stringstream ss;
        	                    ss << "expected constant term inside array constant, but found "
        	                       << "nonconstant term" << std::endl
        	                       << "the term: " << f;
        	                    PARSER_STATE->parseError(ss.str());
        	                  }
        	                  if(!t2.isComparableTo(f.getType())) {
        	                    std::stringstream ss;
        	                    ss << "type mismatch inside array constant term:" << std::endl
        	                       << "array type:          " << t << std::endl
        	                       << "expected const type: " << t2 << std::endl
        	                       << "computed const type: " << f.getType();
        	                    PARSER_STATE->parseError(ss.str());
        	                  }
        	                  f = MK_CONST( ArrayStoreAll(t, f) );
        	                
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/cvc/Cvc.g:2131:5: TRUE_TOK
        	    {
        	         MATCHT(TRUE_TOK, &FOLLOW_TRUE_TOK_in_simpleTerm7776);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_CONST(bool(true)); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/cvc/Cvc.g:2132:5: FALSE_TOK
        	    {
        	         MATCHT(FALSE_TOK, &FOLLOW_FALSE_TOK_in_simpleTerm7785);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_CONST(bool(false)); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/cvc/Cvc.g:2137:5: DECIMAL_LITERAL
        	    {
        	        DECIMAL_LITERAL17 = (pANTLR3_COMMON_TOKEN) MATCHT(DECIMAL_LITERAL, &FOLLOW_DECIMAL_LITERAL_in_simpleTerm7805);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_CONST(AntlrInput::tokenToRational(DECIMAL_LITERAL17)); 
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/cvc/Cvc.g:2138:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL18 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_simpleTerm7813);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_CONST(AntlrInput::tokenToInteger(INTEGER_LITERAL18)); 
        	        }


        	    }
        	    break;
        	case 14:
        	    // ../../../../src/parser/cvc/Cvc.g:2140:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL19 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_simpleTerm7827);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             assert( AntlrInput::tokenText(HEX_LITERAL19).find("0hex") == 0 );
        	                  std::string hexString = AntlrInput::tokenTextSubstr(HEX_LITERAL19, 4);
        	                  f = MK_CONST( BitVector(hexString, 16) ); 
        	        }


        	    }
        	    break;
        	case 15:
        	    // ../../../../src/parser/cvc/Cvc.g:2144:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL20 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_simpleTerm7839);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             assert( AntlrInput::tokenText(BINARY_LITERAL20).find("0bin") == 0 );
        	                  std::string binString = AntlrInput::tokenTextSubstr(BINARY_LITERAL20, 4);
        	                  f = MK_CONST( BitVector(binString, 2) ); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // ../../../../src/parser/cvc/Cvc.g:2149:5: PARENHASH recordEntry[name,e] ( COMMA recordEntry[name,e] )* HASHPAREN
        	    {
        	         MATCHT(PARENHASH, &FOLLOW_PARENHASH_in_simpleTerm7857);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_recordEntry_in_simpleTerm7859);
        	        recordEntry(ctx, name, e);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             names.push_back(name); args.push_back(e); 
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:2150:5: ( COMMA recordEntry[name,e] )*

        	        for (;;)
        	        {
        	            int alt104=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt104=1;
        	            	}
        	                break;

        	            }

        	            switch (alt104)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:2150:7: COMMA recordEntry[name,e]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_simpleTerm7870);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesimpleTermEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_recordEntry_in_simpleTerm7872);
        	        	        recordEntry(ctx, name, e);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesimpleTermEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             names.push_back(name); args.push_back(e); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop104;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop104: ; /* Jump out to here if this rule does not match */


        	         MATCHT(HASHPAREN, &FOLLOW_HASHPAREN_in_simpleTerm7880);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::vector< std::pair<std::string, Type> > typeIds;
        	                  assert(names.size() == args.size());
        	                  for(unsigned i = 0; i < names.size(); ++i) {
        	                    typeIds.push_back(std::make_pair(names[i], args[i].getType()));
        	                  }
        	                  DatatypeType t = EXPR_MANAGER->mkRecordType(typeIds);
        	                  const Datatype& dt = t.getDatatype();
        	                  args.insert( args.begin(), dt[0].getConstructor() );
        	                  f = MK_EXPR(kind::APPLY_CONSTRUCTOR, args);
        	                
        	        }


        	    }
        	    break;
        	case 17:
        	    // ../../../../src/parser/cvc/Cvc.g:2163:5: identifier[name,CHECK_DECLARED,SYM_VARIABLE]
        	    {
        	        FOLLOWPUSH(FOLLOW_identifier_in_simpleTerm7899);
        	        identifier(ctx, name, CHECK_DECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = PARSER_STATE->getVariable(name); 
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             // datatypes: zero-ary constructors
        	                  Type t2 = PARSER_STATE->getType(name);
        	                  if(t2.isConstructor() && ConstructorType(t2).getArity() == 0) {
        	                    // don't require parentheses, immediately turn it into an apply
        	                    f = MK_EXPR(CVC4::kind::APPLY_CONSTRUCTOR, f);
        	                  }
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleTermEx; /* Prevent compiler warnings */
    rulesimpleTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleTerm */

/**
 * $ANTLR start typeAscription
 * ../../../../src/parser/cvc/Cvc.g:2179:1: typeAscription[const CVC4::Expr& f, CVC4::Type& t] : COLON COLON type[t,CHECK_DECLARED] ;
 */
static void
typeAscription(pCvcParser ctx, const CVC4::Expr& f, CVC4::Type& t)
{
    /* Initialize rule variables
     */



    {
        // ../../../../src/parser/cvc/Cvc.g:2182:3: ( COLON COLON type[t,CHECK_DECLARED] )
        // ../../../../src/parser/cvc/Cvc.g:2182:5: COLON COLON type[t,CHECK_DECLARED]
        {
             MATCHT(COLON, &FOLLOW_COLON_in_typeAscription7939);
            if  (HASEXCEPTION())
            {
                goto ruletypeAscriptionEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_typeAscription7941);
            if  (HASEXCEPTION())
            {
                goto ruletypeAscriptionEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_type_in_typeAscription7943);
            type(ctx, t, CHECK_DECLARED);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletypeAscriptionEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletypeAscriptionEx; /* Prevent compiler warnings */
    ruletypeAscriptionEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end typeAscription */

/**
 * $ANTLR start recordEntry
 * ../../../../src/parser/cvc/Cvc.g:2188:1: recordEntry[std::string& name, CVC4::Expr& ex] : identifier[name,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[ex] ;
 */
static void
recordEntry(pCvcParser ctx, std::string& name, CVC4::Expr& ex)
{
    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/cvc/Cvc.g:2189:3: ( identifier[name,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[ex] )
        // ../../../../src/parser/cvc/Cvc.g:2189:5: identifier[name,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[ex]
        {
            FOLLOWPUSH(FOLLOW_identifier_in_recordEntry7960);
            identifier(ctx, name, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerecordEntryEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_recordEntry7963);
            if  (HASEXCEPTION())
            {
                goto rulerecordEntryEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_formula_in_recordEntry7965);
            formula(ctx, ex);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerecordEntryEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulerecordEntryEx; /* Prevent compiler warnings */
    rulerecordEntryEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end recordEntry */

/**
 * $ANTLR start iteTerm
 * ../../../../src/parser/cvc/Cvc.g:2195:1: iteTerm[CVC4::Expr& f] : IF_TOK formula[f] THEN_TOK formula[f] iteElseTerm[f] ENDIF_TOK ;
 */
static void
iteTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<Expr> args;
      Debug("parser-extra") << "ite: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        // ../../../../src/parser/cvc/Cvc.g:2200:3: ( IF_TOK formula[f] THEN_TOK formula[f] iteElseTerm[f] ENDIF_TOK )
        // ../../../../src/parser/cvc/Cvc.g:2200:5: IF_TOK formula[f] THEN_TOK formula[f] iteElseTerm[f] ENDIF_TOK
        {
             MATCHT(IF_TOK, &FOLLOW_IF_TOK_in_iteTerm7987);
            if  (HASEXCEPTION())
            {
                goto ruleiteTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_formula_in_iteTerm7989);
            formula(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleiteTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 args.push_back(f); 
            }


             MATCHT(THEN_TOK, &FOLLOW_THEN_TOK_in_iteTerm7998);
            if  (HASEXCEPTION())
            {
                goto ruleiteTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_formula_in_iteTerm8000);
            formula(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleiteTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 args.push_back(f); 
            }


            FOLLOWPUSH(FOLLOW_iteElseTerm_in_iteTerm8009);
            iteElseTerm(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleiteTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 args.push_back(f); 
            }


             MATCHT(ENDIF_TOK, &FOLLOW_ENDIF_TOK_in_iteTerm8018);
            if  (HASEXCEPTION())
            {
                goto ruleiteTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 f = MK_EXPR(CVC4::kind::ITE, args); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleiteTermEx; /* Prevent compiler warnings */
    ruleiteTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end iteTerm */

/**
 * $ANTLR start iteElseTerm
 * ../../../../src/parser/cvc/Cvc.g:2210:1: iteElseTerm[CVC4::Expr& f] : ( ELSE_TOK formula[f] | ELSEIF_TOK iteCondition= formula[f] THEN_TOK iteThen= formula[f] iteElse= iteElseTerm[f] );
 */
static void
iteElseTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<Expr> args;
      Debug("parser-extra") << "else: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:2215:3: ( ELSE_TOK formula[f] | ELSEIF_TOK iteCondition= formula[f] THEN_TOK iteThen= formula[f] iteElse= iteElseTerm[f] )

            ANTLR3_UINT32 alt106;

            alt106=2;

            switch ( LA(1) )
            {
            case ELSE_TOK:
            	{
            		alt106=1;
            	}
                break;
            case ELSEIF_TOK:
            	{
            		alt106=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 106;
                EXCEPTION->state        = 0;


                goto ruleiteElseTermEx;

            }

            switch (alt106)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:2215:5: ELSE_TOK formula[f]
        	    {
        	         MATCHT(ELSE_TOK, &FOLLOW_ELSE_TOK_in_iteElseTerm8045);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleiteElseTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_iteElseTerm8047);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleiteElseTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:2216:5: ELSEIF_TOK iteCondition= formula[f] THEN_TOK iteThen= formula[f] iteElse= iteElseTerm[f]
        	    {
        	         MATCHT(ELSEIF_TOK, &FOLLOW_ELSEIF_TOK_in_iteElseTerm8054);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleiteElseTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_iteElseTerm8060);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleiteElseTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	         MATCHT(THEN_TOK, &FOLLOW_THEN_TOK_in_iteElseTerm8069);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleiteElseTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_iteElseTerm8075);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleiteElseTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	        FOLLOWPUSH(FOLLOW_iteElseTerm_in_iteElseTerm8088);
        	        iteElseTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleiteElseTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::ITE, args); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleiteElseTermEx; /* Prevent compiler warnings */
    ruleiteElseTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end iteElseTerm */

/**
 * $ANTLR start datatypeDef
 * ../../../../src/parser/cvc/Cvc.g:2225:1: datatypeDef[std::vector<CVC4::Datatype>& datatypes] : identifier[id,CHECK_NONE,SYM_SORT] ( LBRACKET identifier[id2,CHECK_UNDECLARED,SYM_SORT] ( COMMA identifier[id2,CHECK_UNDECLARED,SYM_SORT] )* RBRACKET )? EQUAL_TOK constructorDef[datatypes.back()] ( BAR constructorDef[datatypes.back()] )* ;
 */
static void
datatypeDef(pCvcParser ctx, std::vector<CVC4::Datatype>& datatypes)
{
    /* Initialize rule variables
     */


      std::string id, id2;
      Type t;
      std::vector< Type > params;

    {
        // ../../../../src/parser/cvc/Cvc.g:2235:3: ( identifier[id,CHECK_NONE,SYM_SORT] ( LBRACKET identifier[id2,CHECK_UNDECLARED,SYM_SORT] ( COMMA identifier[id2,CHECK_UNDECLARED,SYM_SORT] )* RBRACKET )? EQUAL_TOK constructorDef[datatypes.back()] ( BAR constructorDef[datatypes.back()] )* )
        // ../../../../src/parser/cvc/Cvc.g:2235:5: identifier[id,CHECK_NONE,SYM_SORT] ( LBRACKET identifier[id2,CHECK_UNDECLARED,SYM_SORT] ( COMMA identifier[id2,CHECK_UNDECLARED,SYM_SORT] )* RBRACKET )? EQUAL_TOK constructorDef[datatypes.back()] ( BAR constructorDef[datatypes.back()] )*
        {
            FOLLOWPUSH(FOLLOW_identifier_in_datatypeDef8124);
            identifier(ctx, id, CHECK_NONE, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 PARSER_STATE->pushScope(); 
            }


            // ../../../../src/parser/cvc/Cvc.g:2236:5: ( LBRACKET identifier[id2,CHECK_UNDECLARED,SYM_SORT] ( COMMA identifier[id2,CHECK_UNDECLARED,SYM_SORT] )* RBRACKET )?
            {
                int alt108=2;
                switch ( LA(1) )
                {
                    case LBRACKET:
                    	{
                    		alt108=1;
                    	}
                        break;
                }

                switch (alt108)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:2236:7: LBRACKET identifier[id2,CHECK_UNDECLARED,SYM_SORT] ( COMMA identifier[id2,CHECK_UNDECLARED,SYM_SORT] )* RBRACKET
            	    {
            	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_datatypeDef8135);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypeDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_identifier_in_datatypeDef8137);
            	        identifier(ctx, id2, CHECK_UNDECLARED, SYM_SORT);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypeDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {

            	                    t = PARSER_STATE->mkSort(id2, ExprManager::SORT_FLAG_PLACEHOLDER);
            	                    params.push_back( t );
            	                  
            	        }


            	        // ../../../../src/parser/cvc/Cvc.g:2240:7: ( COMMA identifier[id2,CHECK_UNDECLARED,SYM_SORT] )*

            	        for (;;)
            	        {
            	            int alt107=2;
            	            switch ( LA(1) )
            	            {
            	            case COMMA:
            	            	{
            	            		alt107=1;
            	            	}
            	                break;

            	            }

            	            switch (alt107)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:2240:9: COMMA identifier[id2,CHECK_UNDECLARED,SYM_SORT]
            	        	    {
            	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_datatypeDef8150);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruledatatypeDefEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        FOLLOWPUSH(FOLLOW_identifier_in_datatypeDef8152);
            	        	        identifier(ctx, id2, CHECK_UNDECLARED, SYM_SORT);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruledatatypeDefEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {

            	        	                    t = PARSER_STATE->mkSort(id2, ExprManager::SORT_FLAG_PLACEHOLDER);
            	        	                    params.push_back( t ); 
            	        	        }


            	        	    }
            	        	    break;

            	        	default:
            	        	    goto loop107;	/* break out of the loop */
            	        	    break;
            	            }
            	        }
            	        loop107: ; /* Jump out to here if this rule does not match */


            	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_datatypeDef8166);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypeDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 datatypes.push_back(Datatype(id, params, false));
                      if(!PARSER_STATE->isUnresolvedType(id)) {
                        // if not unresolved, must be undeclared
                        PARSER_STATE->checkDeclaration(id, CHECK_UNDECLARED, SYM_SORT);
                      }
                    
            }


             MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_datatypeDef8185);
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_constructorDef_in_datatypeDef8187);
            constructorDef(ctx, datatypes.back());

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:2252:5: ( BAR constructorDef[datatypes.back()] )*

            for (;;)
            {
                int alt109=2;
                switch ( LA(1) )
                {
                case BAR:
                	{
                		alt109=1;
                	}
                    break;

                }

                switch (alt109)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:2252:7: BAR constructorDef[datatypes.back()]
            	    {
            	         MATCHT(BAR, &FOLLOW_BAR_in_datatypeDef8196);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypeDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_constructorDef_in_datatypeDef8198);
            	        constructorDef(ctx, datatypes.back());

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypeDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop109;	/* break out of the loop */
            	    break;
                }
            }
            loop109: ; /* Jump out to here if this rule does not match */


            if ( BACKTRACKING==0 )
            {
                 PARSER_STATE->popScope(); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypeDefEx; /* Prevent compiler warnings */
    ruledatatypeDefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypeDef */

/**
 * $ANTLR start constructorDef
 * ../../../../src/parser/cvc/Cvc.g:2259:1: constructorDef[CVC4::Datatype& type] : identifier[id,CHECK_UNDECLARED,SYM_SORT] ( LPAREN selector[&ctor] ( COMMA selector[&ctor] )* RPAREN )? ;
 */
static void
constructorDef(pCvcParser ctx, CVC4::Datatype& type)
{
    /* Initialize rule variables
     */


      std::string id;
      CVC4::PtrCloser<CVC4::DatatypeConstructor> ctor;

    {
        // ../../../../src/parser/cvc/Cvc.g:2264:3: ( identifier[id,CHECK_UNDECLARED,SYM_SORT] ( LPAREN selector[&ctor] ( COMMA selector[&ctor] )* RPAREN )? )
        // ../../../../src/parser/cvc/Cvc.g:2264:5: identifier[id,CHECK_UNDECLARED,SYM_SORT] ( LPAREN selector[&ctor] ( COMMA selector[&ctor] )* RPAREN )?
        {
            FOLLOWPUSH(FOLLOW_identifier_in_constructorDef8229);
            identifier(ctx, id, CHECK_UNDECLARED, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleconstructorDefEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 // make the tester
                      std::string testerId("is_");
                      testerId.append(id);
                      PARSER_STATE->checkDeclaration(testerId, CHECK_UNDECLARED, SYM_SORT);
                      ctor.reset(new CVC4::DatatypeConstructor(id, testerId));
                    
            }


            // ../../../../src/parser/cvc/Cvc.g:2271:5: ( LPAREN selector[&ctor] ( COMMA selector[&ctor] )* RPAREN )?
            {
                int alt111=2;
                switch ( LA(1) )
                {
                    case LPAREN:
                    	{
                    		alt111=1;
                    	}
                        break;
                }

                switch (alt111)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:2271:7: LPAREN selector[&ctor] ( COMMA selector[&ctor] )* RPAREN
            	    {
            	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_constructorDef8244);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_selector_in_constructorDef8252);
            	        selector(ctx, &ctor);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        // ../../../../src/parser/cvc/Cvc.g:2273:7: ( COMMA selector[&ctor] )*

            	        for (;;)
            	        {
            	            int alt110=2;
            	            switch ( LA(1) )
            	            {
            	            case COMMA:
            	            	{
            	            		alt110=1;
            	            	}
            	                break;

            	            }

            	            switch (alt110)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:2273:9: COMMA selector[&ctor]
            	        	    {
            	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_constructorDef8263);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleconstructorDefEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        FOLLOWPUSH(FOLLOW_selector_in_constructorDef8265);
            	        	        selector(ctx, &ctor);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleconstructorDefEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;

            	        	default:
            	        	    goto loop110;	/* break out of the loop */
            	        	    break;
            	            }
            	        }
            	        loop110: ; /* Jump out to here if this rule does not match */


            	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_constructorDef8277);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 // make the constructor
                      type.addConstructor(*ctor.get());
                      Debug("parser-idt") << "constructor: " << id.c_str() << std::endl;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleconstructorDefEx; /* Prevent compiler warnings */
    ruleconstructorDefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end constructorDef */

/**
 * $ANTLR start selector
 * ../../../../src/parser/cvc/Cvc.g:2282:1: selector[CVC4::PtrCloser<CVC4::DatatypeConstructor>* ctor] : identifier[id,CHECK_UNDECLARED,SYM_SORT] COLON type[t,CHECK_NONE] ;
 */
static void
selector(pCvcParser ctx, CVC4::PtrCloser<CVC4::DatatypeConstructor>* ctor)
{
    /* Initialize rule variables
     */


      std::string id;
      Type t, t2;

    {
        // ../../../../src/parser/cvc/Cvc.g:2287:3: ( identifier[id,CHECK_UNDECLARED,SYM_SORT] COLON type[t,CHECK_NONE] )
        // ../../../../src/parser/cvc/Cvc.g:2287:5: identifier[id,CHECK_UNDECLARED,SYM_SORT] COLON type[t,CHECK_NONE]
        {
            FOLLOWPUSH(FOLLOW_identifier_in_selector8309);
            identifier(ctx, id, CHECK_UNDECLARED, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleselectorEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_selector8312);
            if  (HASEXCEPTION())
            {
                goto ruleselectorEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_type_in_selector8314);
            type(ctx, t, CHECK_NONE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleselectorEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 (*ctor)->addArg(id, t);
                      Debug("parser-idt") << "selector: " << id.c_str() << std::endl;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleselectorEx; /* Prevent compiler warnings */
    ruleselectorEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end selector */

/**
 * $ANTLR start numeral
 * ../../../../src/parser/cvc/Cvc.g:2305:1: numeral returns [unsigned k = 0] : INTEGER_LITERAL ;
 */
static unsigned
numeral(pCvcParser ctx)
{
    unsigned k;


    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL21;

    /* Initialize rule variables
     */
    k =  0;


    INTEGER_LITERAL21       = NULL;

    {
        // ../../../../src/parser/cvc/Cvc.g:2306:3: ( INTEGER_LITERAL )
        // ../../../../src/parser/cvc/Cvc.g:2306:5: INTEGER_LITERAL
        {
            INTEGER_LITERAL21 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_numeral8389);
            if  (HASEXCEPTION())
            {
                goto rulenumeralEx;
            }
            if (HASFAILED())
            {
                return k;
            }


            if ( BACKTRACKING==0 )
            {
                 k= AntlrInput::tokenToUnsigned(INTEGER_LITERAL21);
                 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulenumeralEx; /* Prevent compiler warnings */
    rulenumeralEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return k;
}
/* $ANTLR end numeral */

/**
 * $ANTLR start integer
 * ../../../../src/parser/cvc/Cvc.g:2313:1: integer returns [CVC4::Rational k = 0] : ( INTEGER_LITERAL | MINUS_TOK INTEGER_LITERAL );
 */
static CVC4::Rational
integer(pCvcParser ctx)
{
    CVC4::Rational k;


    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL22;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL23;

    /* Initialize rule variables
     */
    k =  0;


    INTEGER_LITERAL22       = NULL;
    INTEGER_LITERAL23       = NULL;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:2314:3: ( INTEGER_LITERAL | MINUS_TOK INTEGER_LITERAL )

            ANTLR3_UINT32 alt112;

            alt112=2;

            switch ( LA(1) )
            {
            case INTEGER_LITERAL:
            	{
            		alt112=1;
            	}
                break;
            case MINUS_TOK:
            	{
            		alt112=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return k;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 112;
                EXCEPTION->state        = 0;


                goto ruleintegerEx;

            }

            switch (alt112)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:2314:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL22 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_integer8414);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleintegerEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return k;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             k= AntlrInput::tokenToInteger(INTEGER_LITERAL22);
        	             
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:2316:5: MINUS_TOK INTEGER_LITERAL
        	    {
        	         MATCHT(MINUS_TOK, &FOLLOW_MINUS_TOK_in_integer8426);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleintegerEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return k;
        	        }


        	        INTEGER_LITERAL23 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_integer8428);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleintegerEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return k;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             k= -AntlrInput::tokenToInteger(INTEGER_LITERAL23);
        	             
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleintegerEx; /* Prevent compiler warnings */
    ruleintegerEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return k;
}
/* $ANTLR end integer */

/**
 * $ANTLR start str
 * ../../../../src/parser/cvc/Cvc.g:2323:1: str[std::string& s] : STRING_LITERAL ;
 */
static void
str(pCvcParser ctx, std::string& s)
{
    pANTLR3_COMMON_TOKEN    STRING_LITERAL24;

    /* Initialize rule variables
     */

    STRING_LITERAL24       = NULL;

    {
        // ../../../../src/parser/cvc/Cvc.g:2324:3: ( STRING_LITERAL )
        // ../../../../src/parser/cvc/Cvc.g:2324:5: STRING_LITERAL
        {
            STRING_LITERAL24 = (pANTLR3_COMMON_TOKEN) MATCHT(STRING_LITERAL, &FOLLOW_STRING_LITERAL_in_str8450);
            if  (HASEXCEPTION())
            {
                goto rulestrEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 s = AntlrInput::tokenText(STRING_LITERAL24);
                      /* strip off the quotes */
                      s = s.substr(1, s.size() - 2);
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulestrEx; /* Prevent compiler warnings */
    rulestrEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end str */

// $ANTLR start synpred1_Cvc
static void synpred1_Cvc_fragment(pCvcParser ctx )
{
    // ../../../../src/parser/cvc/Cvc.g:716:5: ( letDecl )
    // ../../../../src/parser/cvc/Cvc.g:716:5: letDecl
    {
        FOLLOWPUSH(FOLLOW_letDecl_in_synpred1_Cvc2018);
        letDecl(ctx);

        FOLLOWPOP();
        if  (HASEXCEPTION())
        {
            goto rulesynpred1_CvcEx;
        }
        if (HASFAILED())
        {
            return ;
        }


    }

// This is where rules clean up and exit
//
goto rulesynpred1_CvcEx; /* Prevent compiler warnings */
rulesynpred1_CvcEx: ;

}
// $ANTLR end synpred1_Cvc
/* End of parsing rules
 * ==============================================
 */

/* ==============================================
 * Syntactic predicates
 */
static ANTLR3_BOOLEAN synpred1_Cvc(pCvcParser ctx)
{
    ANTLR3_MARKER   start;
    ANTLR3_BOOLEAN  success;

    BACKTRACKING++;
    start	= MARK();
    synpred1_Cvc_fragment(ctx);	    // can never throw exception
    success	= !(FAILEDFLAG);
    REWIND(start);
    BACKTRACKING--;
    FAILEDFLAG	= ANTLR3_FALSE;
    return success;
}

/* End of syntactic predicates
 * ==============================================
 */






/* End of code
 * =============================================================================
 */
