/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"

namespace CVC4 {

template <> void Options::set(
    options::idlRewriteEq__option_t,
    const options::idlRewriteEq__option_t::type& x)
{
  d_holder->idlRewriteEq = x;
}
template <> const options::idlRewriteEq__option_t::type& Options::operator[](
    options::idlRewriteEq__option_t) const
{
  return d_holder->idlRewriteEq;
}
template <> bool Options::wasSetByUser(options::idlRewriteEq__option_t) const
{
  return d_holder->idlRewriteEq__setByUser__;
}


namespace options {

struct idlRewriteEq__option_t idlRewriteEq;


}  // namespace options
}  // namespace CVC4
