# - Try to find DIRECTX_DIRECTINPUT
# Once done this will define
#
#  DIRECTX_DIRECTINPUT_FOUND - system has DIRECTX_DIRECTINPUT
#  DIRECTX_DIRECTINPUT_INCLUDE_DIRS - the DIRECTX_DIRECTINPUT include directory
#  DIRECTX_DIRECTINPUT_LIBRARIES - Link these to use DIRECTX_DIRECTINPUT
#  DIRECTX_DIRECTINPUT_DEFINITIONS - Compiler switches required for using DIRECTX_DIRECTINPUT
#
#  Copyright (c) 2007 Jamie Jones <jamie_jones_au@yahoo.com.au>
#
#  Redistribution and use is allowed according to the terms of the
#  GNU GPLv3 license.
#


if (DIRECTX_DIRECTINPUT_LIBRARIES AND DIRECTX_DIRECTINPUT_INCLUDE_DIRS)
  # in cache already
  set(DIRECTX_DIRECTINPUT_FOUND TRUE)
else (DIRECTX_DIRECTINPUT_LIBRARIES AND DIRECTX_DIRECTINPUT_INCLUDE_DIRS)
  find_path(DIRECTX_DIRECTINPUT_INCLUDE_DIR
    NAMES
      dinput.h
    PATHS
      $ENV{DIRECTXDIR}/include
      /usr/include
      /usr/local/include
      /opt/local/include
      /sw/include
  )

  find_library(LIBDINPUT_LIBRARY
    NAMES
      libdinput
    PATHS
      $ENV{DIRECTXDIR}/lib
      /usr/lib
      /usr/local/lib
      /opt/local/lib
      /sw/lib
  )

  set(DIRECTX_DIRECTINPUT_INCLUDE_DIRS
    ${DIRECTX_DIRECTINPUT_INCLUDE_DIR}
  )
  set(DIRECTX_DIRECTINPUT_LIBRARIES
    ${LIBDINPUT_LIBRARY}
)

  if (DIRECTX_DIRECTINPUT_INCLUDE_DIRS AND DIRECTX_DIRECTINPUT_LIBRARIES)
     set(DIRECTX_DIRECTINPUT_FOUND TRUE)
  endif (DIRECTX_DIRECTINPUT_INCLUDE_DIRS AND DIRECTX_DIRECTINPUT_LIBRARIES)

  if (DIRECTX_DIRECTINPUT_FOUND)
    if (NOT DIRECTX_DIRECTINPUT_FIND_QUIETLY)
      message(STATUS "Found DIRECTX_DIRECTINPUT: ${DIRECTX_DIRECTINPUT_LIBRARIES}")
    endif (NOT DIRECTX_DIRECTINPUT_FIND_QUIETLY)
  else (DIRECTX_DIRECTINPUT_FOUND)
    if (DIRECTX_DIRECTINPUT_FIND_REQUIRED)
      message(FATAL_ERROR "Could not find DIRECTX_DIRECTINPUT")
    endif (DIRECTX_DIRECTINPUT_FIND_REQUIRED)
  endif (DIRECTX_DIRECTINPUT_FOUND)

  # show the DIRECTX_DIRECTINPUT_INCLUDE_DIRS and DIRECTX_DIRECTINPUT_LIBRARIES variables only in the advanced view
  mark_as_advanced(DIRECTX_DIRECTINPUT_INCLUDE_DIRS DIRECTX_DIRECTINPUT_LIBRARIES)

endif (DIRECTX_DIRECTINPUT_LIBRARIES AND DIRECTX_DIRECTINPUT_INCLUDE_DIRS)

