/*
 * Decompiled with CFR 0.152.
 */
import com.netscape.cmsutil.ocsp.BasicOCSPResponse;
import com.netscape.cmsutil.ocsp.CertID;
import com.netscape.cmsutil.ocsp.CertStatus;
import com.netscape.cmsutil.ocsp.GoodInfo;
import com.netscape.cmsutil.ocsp.OCSPRequest;
import com.netscape.cmsutil.ocsp.OCSPResponse;
import com.netscape.cmsutil.ocsp.OCSPResponseStatus;
import com.netscape.cmsutil.ocsp.Request;
import com.netscape.cmsutil.ocsp.ResponseBytes;
import com.netscape.cmsutil.ocsp.ResponseData;
import com.netscape.cmsutil.ocsp.RevokedInfo;
import com.netscape.cmsutil.ocsp.SingleResponse;
import com.netscape.cmsutil.ocsp.TBSRequest;
import com.netscape.cmsutil.ocsp.UnknownInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import netscape.security.x509.X500Name;
import netscape.security.x509.X509CertImpl;
import netscape.security.x509.X509Key;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.NULL;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import sun.misc.BASE64Encoder;

public class ca_ee_ocspRequest {
    private static String url = "/ca/ocsp";
    private static String client_certdb_dir = null;
    private static String client_certdb_pwd = null;
    private static String ca_cert_nickname = null;
    private static String serial_number = null;
    private static String ca_hostname = null;
    private static String ca_ee_port = null;
    private static String debug = null;
    private String query = null;
    private byte[] responseData;
    private byte[] request_data;
    private static HTTPResponse hr = null;

    public boolean buildquery() {
        boolean bl = true;
        OCSPRequest oCSPRequest = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        X509Certificate x509Certificate = null;
        try {
            CryptoManager cryptoManager = CryptoManager.getInstance();
            x509Certificate = cryptoManager.findCertByNickname(ca_cert_nickname);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            X509CertImpl x509CertImpl = new X509CertImpl(x509Certificate.getEncoded());
            X509Key x509Key = (X509Key)x509CertImpl.getPublicKey();
            byte[] byArray = messageDigest.digest(x509Key.getKey());
            X500Name x500Name = (X500Name)x509CertImpl.getSubjectDN();
            byte[] byArray2 = messageDigest.digest(x500Name.getEncoded());
            CertID certID = new CertID(new AlgorithmIdentifier(new OBJECT_IDENTIFIER("1.3.14.3.2.26"), (ASN1Value)new NULL()), new OCTET_STRING(byArray2), new OCTET_STRING(byArray), new INTEGER(serial_number));
            Request request = new Request(certID, null);
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addElement((ASN1Value)request);
            TBSRequest tBSRequest = new TBSRequest(null, null, sEQUENCE, null);
            oCSPRequest = new OCSPRequest(tBSRequest, null);
        }
        catch (Exception exception) {
            System.out.println("ERROR: unable to generate ocsp request");
            exception.printStackTrace();
            bl = false;
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            oCSPRequest.encode((OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            System.out.println("ERROR: unable to generate ocsp request");
            exception.printStackTrace();
            bl = false;
        }
        this.request_data = byteArrayOutputStream.toByteArray();
        System.out.println("OCSP_REQUEST= \n" + new BASE64Encoder().encode(this.request_data));
        return bl;
    }

    public boolean Send() {
        HTTPClient hTTPClient = new HTTPClient();
        hr = hTTPClient.nonsslConnect(ca_hostname, ca_ee_port, url, this.request_data);
        System.out.println("RETURN_CODE=" + hr.getStatusCode());
        this.responseData = hr.getResponseData();
        return hr.getStatusCode() == 200;
    }

    public boolean checkcertstatus() {
        ComCrypto comCrypto = new ComCrypto(client_certdb_dir, client_certdb_pwd, null, null, null);
        comCrypto.setDebug(true);
        comCrypto.setGenerateRequest(true);
        comCrypto.loginDB();
        if (!this.buildquery()) {
            System.out.println("ERROR: unable to build query string");
            return false;
        }
        if (!this.Send()) {
            System.out.println("ERROR: failed to send request");
            return false;
        }
        if (!this.Verify()) {
            System.out.println("ERROR");
            return false;
        }
        System.out.println("SUCCESS");
        return true;
    }

    public boolean Verify() {
        boolean bl = false;
        if (debug.equals("true")) {
            System.out.println("OCSP_RESPONSE= \n" + this.responseData);
        }
        try {
            OCSPResponse.Template template = new OCSPResponse.Template();
            OCSPResponse oCSPResponse = (OCSPResponse)template.decode((InputStream)new ByteArrayInputStream(this.responseData));
            OCSPResponseStatus oCSPResponseStatus = oCSPResponse.getResponseStatus();
            ResponseBytes responseBytes = oCSPResponse.getResponseBytes();
            BasicOCSPResponse basicOCSPResponse = (BasicOCSPResponse)BasicOCSPResponse.getTemplate().decode((InputStream)new ByteArrayInputStream(responseBytes.getResponse().toByteArray()));
            ResponseData responseData = basicOCSPResponse.getResponseData();
            System.out.println("response count = " + responseData.getResponseCount());
            for (int i = 0; i < responseData.getResponseCount(); ++i) {
                SingleResponse singleResponse = responseData.getResponseAt(i);
                CertStatus certStatus = singleResponse.getCertStatus();
                if (certStatus instanceof GoodInfo) {
                    System.out.println("CertStatus=Good \nSerialNumber=" + singleResponse.getCertID().getSerialNumber());
                }
                if (certStatus instanceof UnknownInfo) {
                    System.out.println("CertStatus=Unknown \nSerialNumber=" + singleResponse.getCertID().getSerialNumber());
                }
                if (!(certStatus instanceof RevokedInfo)) continue;
                System.out.println("CertStatus=Revoked \nSerialNumber=" + singleResponse.getCertID().getSerialNumber());
            }
            bl = true;
        }
        catch (Exception exception) {
            System.out.println("ERROR: unable to verify OCSP response");
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        ca_ee_ocspRequest ca_ee_ocspRequest2 = new ca_ee_ocspRequest();
        StringHolder stringHolder = new StringHolder();
        StringHolder stringHolder2 = new StringHolder();
        StringHolder stringHolder3 = new StringHolder();
        StringHolder stringHolder4 = new StringHolder();
        StringHolder stringHolder5 = new StringHolder();
        StringHolder stringHolder6 = new StringHolder();
        StringHolder stringHolder7 = new StringHolder();
        ArgParser argParser = new ArgParser("ca_ee_ocspRequest");
        argParser.addOption("-ca_hostname %s #CA Hostname", stringHolder5);
        argParser.addOption("-ca_ee_port %s #CA EE Port", stringHolder6);
        argParser.addOption("-client_certdb_dir %s #CertDB dir", stringHolder);
        argParser.addOption("-client_certdb_pwd %s #CertDB password", stringHolder2);
        argParser.addOption("-ca_cert_nickname %s #CA Cert Nickname", stringHolder3);
        argParser.addOption("-serial_number %s #Cert Serial Number in decimal", stringHolder4);
        argParser.addOption("-debug %s #enables display of debugging info", stringHolder7);
        String[] stringArray2 = null;
        stringArray2 = argParser.matchAllArgs(stringArray, 0, ArgParser.EXIT_ON_UNMATCHED);
        if (stringArray2 != null) {
            System.out.println("ERROR: Argument Mismatch");
            System.exit(-1);
        }
        ca_hostname = stringHolder5.value;
        ca_ee_port = stringHolder6.value;
        client_certdb_dir = stringHolder.value;
        client_certdb_pwd = stringHolder2.value;
        ca_cert_nickname = stringHolder3.value;
        serial_number = stringHolder4.value;
        debug = stringHolder7.value;
        boolean bl = ca_ee_ocspRequest2.checkcertstatus();
        if (bl) {
            System.exit(0);
        } else {
            System.exit(-1);
        }
    }
}

