# Codeflow PRs

Codeflow PRs are automated pull requests created by [Maestro](https://maestro.dot.net), and are generated by source-enabled subscriptions.  
These subscriptions can only be created between the [VMR (Virtual Monolithic Repository)](https://github.com/dotnet/dotnet/) and product repositories that have their [sources in the VMR](https://github.com/dotnet/dotnet/tree/main/src).  

As the name suggests, source-enabled subscriptions not only update dependencies but also synchronize source code changes **to and from** the VMR.
They ensure that repository sources remain in sync with the corresponding `src/` directory in the VMR.
Source code changes can originate in either the repository or the VMR and are synchronized to the other side via source-enabled subscriptions.

> [!IMPORTANT]
> Opening PRs against the VMR is **not yet permitted** and will be allowed in the near future. For now, source code changes should only be made in the repositories, barring exceptional cases.

For more details on code flow and the VMR, see [VMR Code and Build Workflow](https://github.com/dotnet/arcade/blob/main/Documentation/UnifiedBuild/VMR-Code-And-Build-Workflow.md).  

## Terminology

- **Product repository** / **VMR repository** - A repository that is required to build the .NET SDK, and which is synchronized [into the VMR](https://github.com/dotnet/dotnet/tree/main/src).
- **Dependency flow** / **Binary flow** - The old type of Maestro subscriptions that only update dependencies, e.g. [this one](https://github.com/dotnet/sdk/pull/47085).
- **Code flow** / **Source-enabled dependency flow** - New type of Maestro subscriptions that are, together with dependency updates, also flowing sources to/from the VMR.
- **Backflow** - A PR that flows changes from the VMR back to the product repository, carrying source updates as well as dependency updates (packages built in the VMR).
- **Forward flow** - A PR that flows changes from the product repository to the VMR, carrying repository source updates.
- **Flat flow** - A new structure of subscriptions between product repositories and the VMR.


## General Information

This is part of the [Unified Build](https://github.com/dotnet/arcade/tree/main/Documentation/UnifiedBuild) - an effort that changes how .NET is built and shipped.
If you're looking for an intro, a good source of information (though not public) are the .NET Platform Talks about [🎬 UB in general](https://microsoft-my.sharepoint.com/personal/tarekms_ntdev_microsoft_com/_layouts/15/stream.aspx?id=%2Fpersonal%2Ftarekms%5Fntdev%5Fmicrosoft%5Fcom%2FDocuments%2FRecordings%2F%2ENET%20platform%20talks%2D20250226%5F200258%2DMeeting%20Recording%2Emp4&referrer=StreamWebApp%2EWeb&referrerScenario=AddressBarCopied%2Eview%2E0f6357b7%2Db525%2D4eb3%2D9cb7%2D67297d6eaa23&mode=Edit) or a [🎬 more codeflow specific one](https://microsofteur-my.sharepoint.com/:v:/g/personal/prvysoky_microsoft_com/EdlGj6nIOWFFvMyF6izBAR8BkJI0ua_4rqgxQbcRrv2zRg?e=YXedHu).

## Codeflow PR Metadata

The code flow mechanism relies on metadata files similarly to the existing Maestro dependency flow.
- **`eng/Version.Details.xml`**
  - A file that was already used in the old dependency flow. It contains version information for dependencies between repositories. A new addition is the `<Source>` tag, used for tracking the latest codeflow from the VMR.
- **`src/source-manifest.json`**
  - A file [contained in the VMR](https://github.com/dotnet/dotnet/blob/main/src/source-manifest.json) that contains the last version of every repository synchronized into the VMR.

## FAQ

- **How can I see dependency subscriptions for my repository**?
  - Either use the [Maestro website](https://maestro.dot.net/subscriptions) or use the [`darc get-subscriptions`](../Darc.md) command.

- **Where can I find the new dependency PRs?**
  - The dependency PRs look almost the same as the old ones and are still [authored by the `dotnet-maestro` bot](https://github.com/pulls?q=sort%3Aupdated-desc+is%3Apr+author%3Aapp%2Fdotnet-maestro+archived%3Afalse+).  
The forward flow PRs will be opened [against the VMR](https://github.com/dotnet/dotnet/pulls/app%2Fdotnet-maestro) while the backflow PRs will be opened in your repository and named something like `[branch] Source code changes from dotnet/dotnet`.

- **Where can I find the official build of the VMR?**
  - The official build of the VMR is [dotnet-unified-build](https://dev.azure.com/dnceng/internal/_build?definitionId=1330).

- **What should I do in case of conflicts?**
  - Whenever there will be a conflict in a codeflow PR, Maestro bot will drop a comment in the PR guiding you through the process. If you're still unsure, you can always tag **@dotnet/product-construction** and we will help you resolve those.

- **My repo X depends on repo Y's packages. How will I get the new packages**?
  - If repo Y is part of the VMR, you will depend on the VMR instead of repo Y.
    The packages will be produced by the official VMR build and published to the `.NET 10 UB` channel.  
    The target feed for some packages might change from `dotnet-eng` to [`dotnet10-transport`](https://pkgs.dev.azure.com/dnceng/internal/_packaging/dotnet10-transport/nuget/v3/index.json).

    Furthermore, if you depend on multiple VMR repositories, you will get all the packages in a single backflow subscription (PR).

- **What if I cannot accept a specific package update?**
  - If your product repo is in the VMR but needs to stay on an older version of a certain package built in the VMR, the backflow PRs will keep updating it. You can specify this package in `Excluded assets` on the subscription settings (use `darc update-subscription`) for it to be ignored during backflow PRs.  
    
    *Note: Excluding `Microsoft.DotNet.Arcade.Sdk` will also turn off udpates of the SDK, `eng/common` and other related toolset files.*

## Contacts & Support

If you need help or have questions around the new flow, please either:
- tag the **@dotnet/product-construction** team on your PR/issue,
- use the [First Responder channel](https://teams.microsoft.com/l/channel/19%3Aafba3d1545dd45d7b79f34c1821f6055%40thread.skype/First%20Responders?groupId=4d73664c-9f2f-450d-82a5-c2f02756606d),
- open an issue in [dotnet/arcade-services](https://github.com/dotnet/arcade-services/issues/new?template=BLANK_ISSUE),
- or contact the [.NET Product Construction Services team](mailto:dotnetprodconsvcs@microsoft.com) via e-mail.


## Additional Resources

- [VMR Code and Build Workflow](https://github.com/dotnet/arcade/blob/main/Documentation/UnifiedBuild/VMR-Code-And-Build-Workflow.md)
- [VMR Full Code Flow](https://github.com/dotnet/arcade/blob/main/Documentation/UnifiedBuild/VMR-Full-Code-Flow.md)
- [Flat Flow Migration Guide](./Flat-Flow-Migration-Guide.md)
- [Darc Documentation](https://github.com/dotnet/arcade/tree/main/Documentation/Darc)
- [Branches, channels, and subscriptions](https://github.com/dotnet/arcade/blob/main/Documentation/BranchesChannelsAndSubscriptions.md)
