/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/***************************************************************************
 *            rcgen.cc
 *
 *  Sun Mar 17 20:27:17 CET 2013
 *  Copyright 2013 Bent Bisballe Nyeng
 *  deva@aasimon.org
 ****************************************************************************/

/*
 *  This file is part of DrumGizmo.
 *
 *  DrumGizmo is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  DrumGizmo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with DrumGizmo; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 */
#include <stdio.h>
#include <string>

int main(int argc, char *argv[])
{
	printf("/* This file is autogenerated by rcgen. Do not modify! */\n");
	printf("#include \"resource_data.h\"\n");
	printf("\n");
	printf("const rc_data_t rc_data[] =\n");
	printf("{\n");

	int i = 1;
	while(i < argc)
	{
		printf("	{\n		\":%s\", ", argv[i]);

		std::string data;
		FILE *fp = fopen(argv[i], "rb");
		if(!fp)
		{
			fprintf(stderr, "Could not read file '%s' - quitting\n", argv[i]);
			return 1;
		}

		char buf[32];
		while(!feof(fp))
		{
			std::size_t sz = fread(buf, 1, sizeof(buf), fp);
			data.append(buf, sz);
		}
		fclose(fp);

		printf("%d,\n		\"", (int)data.length());
		for(std::size_t j = 0; j < data.length(); ++j)
		{
			if((j != 0) && (j % 16) == 0)
			{
				printf("\"\n		\"");
			}
			printf("\\%o", (unsigned char)data[j]);
		}

		printf("\"\n	},\n");

		++i;
	}

	printf("	{ \"\", 0, 0 }\n");
	printf("};\n");

	return 0;
}
