/*
 * Decompiled with CFR 0.152.
 */
package dumphd.core;

import dumphd.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class KeyData {
    public static final int DATA_TITLE = 2;
    public static final int DATA_DATE = 4;
    public static final int DATA_MEK = 8;
    public static final int DATA_VIDBN = 16;
    public static final int DATA_VUKPAK = 32;
    public static final int DATA_TUK = 64;
    public static final int DATA_UM = 128;
    public static final int DATA_COMMENT = 256;
    public static final int DATA_ALL = -1;
    private byte[] discId = null;
    private String title = null;
    private Date date = null;
    private String comment = null;
    private byte[] mek = null;
    private TreeMap<Integer, byte[]> vids = new TreeMap();
    private TreeMap<Integer, byte[]> vuks = new TreeMap();
    private TreeMap<Integer, byte[]> tuks = new TreeMap();
    private ArrayList<UnitMappingSet> umss = new ArrayList(5);

    public KeyData(byte[] discId, int offset) {
        this.discId = new byte[20];
        System.arraycopy(discId, offset, this.discId, 0, this.discId.length);
    }

    public byte[] getDiscId() {
        return this.discId;
    }

    public String getTitle() {
        return this.title;
    }

    public Date getDate() {
        return this.date;
    }

    public String getComment() {
        return this.comment;
    }

    public byte[] getMek() {
        return this.mek;
    }

    public byte[] getVid() {
        return this.vids.get(0);
    }

    public byte[] getBn(int index) {
        return this.vids.get(index);
    }

    public byte[] getVuk() {
        return this.vuks.get(0);
    }

    public byte[] getPak(int index) {
        return this.vuks.get(index);
    }

    public byte[] getTuk(int index) {
        return this.tuks.get(index);
    }

    public int getHeadUnit(int unitMappingSet, int henr) {
        if (unitMappingSet < this.umss.size()) {
            UnitMappingSet ums = this.umss.get(unitMappingSet);
            if (henr < ums.hm.size()) {
                return ums.hm.get(henr);
            }
        }
        return 0;
    }

    public int getTcUnit(int unitMappingSet, int tcnr) {
        --tcnr;
        if (unitMappingSet < this.umss.size()) {
            UnitMappingSet kis = this.umss.get(unitMappingSet);
            if (tcnr < kis.tcm.size()) {
                return kis.tcm.get(tcnr);
            }
        }
        return 0;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDate(Date date) {
        this.date = date != null ? (Date)date.clone() : null;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setMek(byte[] mek, int offset) {
        if (mek != null) {
            this.mek = new byte[16];
            System.arraycopy(mek, offset, this.mek, 0, this.mek.length);
        } else {
            this.mek = null;
        }
    }

    public void setVid(byte[] vid, int offset) {
        this.setKey(this.vids, 0, vid, offset);
    }

    public void setBn(int index, byte[] bn, int offset) {
        this.setKey(this.vids, index, bn, offset);
    }

    public void setVuk(byte[] vuk, int offset) {
        this.setKey(this.vuks, 0, vuk, offset);
    }

    public void setPak(int index, byte[] pak, int offset) {
        this.setKey(this.vuks, index, pak, offset);
    }

    public void setTuk(int index, byte[] tuk, int offset) {
        this.setKey(this.tuks, index, tuk, offset);
    }

    public void setHeadUnit(int unitMappingSet, int henr, int unit) {
        while (this.umss.size() <= unitMappingSet) {
            this.umss.add(new UnitMappingSet());
        }
        UnitMappingSet ums = this.umss.get(unitMappingSet);
        while (ums.hm.size() < henr) {
            ums.hm.add(0);
        }
        if (ums.hm.size() == henr) {
            ums.hm.add(unit);
        } else {
            ums.hm.set(henr, unit);
        }
    }

    public void setTcUnit(int unitMappingSet, int tcnr, int unit) {
        --tcnr;
        while (this.umss.size() <= unitMappingSet) {
            this.umss.add(new UnitMappingSet());
        }
        UnitMappingSet ums = this.umss.get(unitMappingSet);
        while (ums.tcm.size() < tcnr) {
            ums.tcm.add(0);
        }
        if (ums.tcm.size() == tcnr) {
            ums.tcm.add(unit);
        } else {
            ums.tcm.set(tcnr, unit);
        }
    }

    public int dataMask() {
        int mask = 0;
        if (this.title != null) {
            mask |= 2;
        }
        if (this.date != null) {
            mask |= 4;
        }
        if (this.comment != null) {
            mask |= 0x100;
        }
        if (this.mek != null) {
            mask |= 8;
        }
        if (this.vids.size() > 0) {
            mask |= 0x10;
        }
        if (this.vuks.size() > 0) {
            mask |= 0x20;
        }
        if (this.tuks.size() > 0) {
            mask |= 0x40;
        }
        if (this.umss.size() > 0) {
            mask |= 0x80;
        }
        return mask;
    }

    public int bnCount() {
        return this.vids.size();
    }

    public int pakCount() {
        return this.vuks.size();
    }

    public int tukCount() {
        return this.tuks.size();
    }

    public Set<Integer> bnIdx() {
        return Collections.unmodifiableSet(this.vids.keySet());
    }

    public Set<Integer> pakIdx() {
        return Collections.unmodifiableSet(this.vuks.keySet());
    }

    public Set<Integer> tukIdx() {
        return Collections.unmodifiableSet(this.tuks.keySet());
    }

    public String toString() {
        StringBuffer out = new StringBuffer(8192);
        out.append("DiscID      : ");
        out.append(Utils.toHexString(this.discId, 0, this.discId.length));
        out.append("\nTitle       : ");
        if (this.title != null) {
            out.append(this.title);
        } else {
            out.append("N/A");
        }
        out.append("\nDate        : ");
        if (this.date != null) {
            out.append(String.format("%1$tY-%1$tm-%1$td", this.date));
        } else {
            out.append("N/A");
        }
        out.append("\nComment     : ");
        if (this.comment != null) {
            out.append(this.comment);
        } else {
            out.append("N/A");
        }
        out.append("\nMEK         : ");
        if (this.mek != null) {
            out.append(Utils.toHexString(this.mek, 0, this.mek.length));
        } else {
            out.append("N/A");
        }
        out.append("\nVID / BN's  : ");
        this.printKeys(out, this.vids);
        out.append("\nVUK / PAK's : ");
        this.printKeys(out, this.vuks);
        out.append("\nTUK's       : ");
        this.printKeys(out, this.tuks);
        if (this.umss.size() > 0) {
            out.append("\nUM's        : ");
            out.append(this.umss.size());
            int set = 0;
            while (set < this.umss.size()) {
                out.append(String.format("\n              Set %1$d", set));
                UnitMappingSet ums = this.umss.get(set);
                int i = 0;
                while (i < ums.hm.size()) {
                    out.append(String.format("\n%1$12dH-%2$d", i, ums.hm.get(i)));
                    ++i;
                }
                i = 0;
                while (i < ums.tcm.size()) {
                    out.append(String.format("\n%1$13d-%2$d", i + 1, ums.tcm.get(i)));
                    ++i;
                }
                ++set;
            }
        }
        return out.toString();
    }

    private void setKey(TreeMap<Integer, byte[]> tm, int index, byte[] key, int offset) {
        if (key != null) {
            byte[] tmp = new byte[16];
            System.arraycopy(key, offset, tmp, 0, tmp.length);
            tm.put(index, tmp);
        } else {
            tm.remove(index);
        }
    }

    private void printKeys(StringBuffer out, TreeMap<Integer, byte[]> keyMap) {
        int keyCount = keyMap.size();
        if (keyCount > 0) {
            out.append(keyCount);
            for (Map.Entry<Integer, byte[]> keyEntry : keyMap.entrySet()) {
                out.append(String.format("\n%1$13d-%2$s", keyEntry.getKey(), Utils.toHexString(keyEntry.getValue(), 0, keyEntry.getValue().length)));
            }
        } else {
            out.append("N/A");
        }
    }

    private class UnitMappingSet {
        public ArrayList<Integer> hm = new ArrayList(2);
        public ArrayList<Integer> tcm = new ArrayList(200);

        private UnitMappingSet() {
        }
    }
}

