function packageDynare(zipfile, version, version_sanitized, logo)

tfolder = tempname;
mkdir(tfolder)
dynarefld = fullfile(tfolder, "Dynare");

% unzip
unzip(zipfile,dynarefld)

% create tbx options
opts = matlab.addons.toolbox.ToolboxOptions(dynarefld, "dynare", ...
    ToolboxName = "Dynare", ...
    ToolboxVersion = version_sanitized, ...
    Summary = "Solves, simulates and estimates a wide class of economic models", ...
    AuthorName = "Dynare Team", ...
    ToolboxImageFile = logo, ...
    ToolboxMatlabPath = fullfile(dynarefld, "matlab"), ...
    OutputFile = fullfile(pwd, ['dynare-' version '.mltbx']), ...
    SupportedPlatforms = struct(Glnxa64 = false, Maci64 = false, MatlabOnline = true, Win64 = false));

% package toolbox
matlab.addons.toolbox.packageToolbox(opts)
