/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import org.emboss.jemboss.Jemboss;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.Browser;
import org.emboss.jemboss.gui.SetUpMenuBar;
import org.emboss.jemboss.gui.filetree.LocalAndRemoteFileTreeFrame;

public class LocalTreeToolBar
extends JToolBar {
    public LocalTreeToolBar(final JembossParams mysettings) {
        Dimension buttonSize = new Dimension(22, 24);
        JButton upBt = new JButton(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(new Color(0, 128, 0));
                float[][] loc1 = new float[][]{{11.0f, 18.0f}, {7.0f, 18.0f}, {7.0f, 14.0f}, {3.0f, 14.0f}, {11.0f, 4.0f}};
                g2.fill(Browser.makeShape(loc1));
                g2.setColor(Color.green);
                float[][] loc2 = new float[][]{{11.0f, 18.0f}, {15.0f, 18.0f}, {15.0f, 14.0f}, {19.0f, 14.0f}, {11.0f, 4.0f}};
                g2.fill(Browser.makeShape(loc2));
                this.setSize(22, 24);
            }
        };
        upBt.setPreferredSize(buttonSize);
        upBt.setMaximumSize(buttonSize);
        upBt.setToolTipText("Move Up a Directory");
        upBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File child = new File(mysettings.getUserHome());
                LocalTreeToolBar.this.setDirectory(child.getParentFile(), mysettings);
            }
        });
        this.add(upBt);
        JButton shortCut2 = new JButton(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                Font font = new Font("Monospaced", 1, 14);
                g2.setFont(font);
                g2.setColor(Color.black);
                g2.drawString("W", 4, 18);
                g2.setColor(Color.red);
                g2.drawString("D", 10, 15);
                this.setSize(22, 24);
            }
        };
        shortCut2.setPreferredSize(buttonSize);
        shortCut2.setMaximumSize(buttonSize);
        shortCut2.setToolTipText("Move To Working Directory");
        shortCut2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File cwd = new File(mysettings.getResultsHome());
                LocalTreeToolBar.this.setDirectory(cwd, mysettings);
            }
        });
        this.add(shortCut2);
        JButton homeBt = new JButton(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(Color.blue);
                float[][] loc1 = new float[][]{{3.0f, 14.0f}, {11.0f, 3.0f}, {19.0f, 14.0f}, {17.0f, 14.0f}, {17.0f, 18.0f}, {5.0f, 18.0f}, {5.0f, 14.0f}};
                g2.fill(Browser.makeShape(loc1));
                this.setSize(22, 24);
            }
        };
        homeBt.setPreferredSize(buttonSize);
        homeBt.setMaximumSize(buttonSize);
        homeBt.setToolTipText("Move To Home Directory");
        homeBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File cwd = new File(mysettings.getUserHome());
                LocalTreeToolBar.this.setDirectory(cwd, mysettings);
            }
        });
        this.add(homeBt);
        this.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 34));
    }

    private void setDirectory(File f, JembossParams mysettings) {
        if (f.exists() && f.canRead()) {
            String cwd = f.getAbsolutePath();
            Jemboss.tree.newRoot(cwd);
            if (SetUpMenuBar.localAndRemoteTree != null) {
                LocalAndRemoteFileTreeFrame.getLocalDragTree().newRoot(cwd);
            }
            if (!f.canWrite()) {
                JOptionPane.showMessageDialog(null, "You cannot write to this directory.", "Warning: Write", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "No access to this directory.", "Error: Access", 0);
        }
    }
}

