/*
 * squeeze - Żҥ֥å/EPWING ҷ̲
 *
 *	Written by Junn Ohta (ohta@src.ricoh.co.jp). Public Domain.
 *      Modified by yamagata@nwgpc.kek.jp on 2000/04/13
 */

char	*progname = "squeeze";
char	*version = "1.1";
char	*date = "2000/04/13";
char	*author = "Junn Ohta (ohta@src.ricoh.co.jp)";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "epw.h"

/*
 * ҹǼ
 */
#define	T_UNKNOWN	0	/* 				*/
#define	T_TEXT		1	/* ʸ˥塼Ф	*/
#define	T_INDEX		2	/* ǥå			*/
#define	T_DATA		3	/* ǡ		*/
#define	T_CINFO		4	/* ʣ縡		*/

/*
 * ǥå
 */
#define	IT_UNKNOWN	0	/* 				*/
#define	IT_DIRECT	1	/* Фͳľʸ	*/
#define	IT_NORMAL	2	/* Фͳʸ		*/
#define	IT_COND		3	/* ︡			*/
#define	IT_ITEM		4	/* ̾︡		*/

/*
 * ҹ°ɽ
 */
typedef struct itype_t {
    byte	idmin;
    byte	idmax;
    int		must;	 /* Ҥ˥ԡ뤫? */
    int		type;
    int		idxtype;
} ITYPE_T;

ITYPE_T	itypetbl[] = {
    { 0x00, 0x00, TRUE,  T_TEXT,  0	     }, /* ʸ */
    { 0x01, 0x01, TRUE,  T_TEXT,  0	     }, /* ˥塼 */
    { 0x02, 0x02, TRUE,  T_TEXT,  0	     }, /* ɽ */
    { 0x03, 0x03, FALSE, T_TEXT,  0	     }, /* ︡Ф */
    { 0x04, 0x04, TRUE,  T_TEXT,  0	     }, /* פʸФ */
    { 0x05, 0x05, TRUE,  T_TEXT,  0	     }, /* ɽФ */
    { 0x06, 0x06, TRUE,  T_TEXT,  0	     }, /* פʸФ */
    { 0x07, 0x07, TRUE,  T_TEXT,  0	     }, /* ɽФ */
    { 0x08, 0x08, TRUE,  T_TEXT,  0	     }, /* ױѻФ */
    { 0x09, 0x09, TRUE,  T_TEXT,  0	     }, /* ױѻФ */
    { 0x0a, 0x0a, FALSE, T_TEXT,  0	     }, /* Ф */
    { 0x0b, 0x0b, FALSE, T_TEXT,  0	     }, /* ֹ渫Ф */
    { 0x0d, 0x0d, FALSE, T_TEXT,  0	     }, /* ̾︡Ф */
    { 0x0f, 0x0f, FALSE, T_TEXT,  0	     }, /* ǸФ */
    { 0x20, 0x20, FALSE, T_TEXT,  0	     }, /* ˥塼 */
    { 0x21, 0x21, FALSE, T_TEXT,  0	     }, /* ɽ */
    { 0x23, 0x23, FALSE, T_TEXT,  0	     }, /* ɽ(1ɽ) */
    { 0x24, 0x24, FALSE, T_TEXT,  0	     }, /* Ф */
    { 0x30, 0x30, FALSE, T_INDEX, IT_DIRECT  }, /* INDEX */
    { 0x40, 0x40, FALSE, T_INDEX, IT_DIRECT  }, /* ѻINDEX */
    { 0x50, 0x50, FALSE, T_INDEX, IT_DIRECT  }, /* INDEX */
    { 0x60, 0x60, FALSE, T_INDEX, IT_DIRECT  }, /* ɽINDEX */
    { 0x70, 0x70, TRUE,  T_INDEX, IT_NORMAL  }, /* פINDEX */
    { 0x71, 0x71, TRUE,  T_INDEX, IT_NORMAL  }, /* ɽINDEX */
    { 0x72, 0x72, TRUE,  T_INDEX, IT_NORMAL  }, /* ױѻINDEX */
    { 0x80, 0x80, FALSE, T_INDEX, IT_COND    }, /* ︡INDEX */
    { 0x81, 0x81, FALSE, T_INDEX, IT_COND    }, /* INDEX */
    { 0x90, 0x90, TRUE,  T_INDEX, IT_NORMAL  }, /* פINDEX */
    { 0x91, 0x91, TRUE,  T_INDEX, IT_NORMAL  }, /* ɽINDEX */
    { 0x92, 0x92, TRUE,  T_INDEX, IT_NORMAL  }, /* ױѻINDEX */
    { 0xa0, 0xa0, FALSE, T_INDEX, IT_ITEM    }, /* ֹINDEX */
    { 0xa1, 0xa1, FALSE, T_INDEX, IT_ITEM    }, /* ̾︡INDEX */
    { 0xb0, 0xb0, FALSE, T_INDEX, IT_UNKNOWN }, /* ڡINDEX */
    { 0xb1, 0xb1, FALSE, T_INDEX, IT_UNKNOWN }, /* INDEX */
    { 0xd0, 0xd0, FALSE, T_DATA,  0	     }, /* Υ */
    { 0xd1, 0xd1, FALSE, T_DATA,  0	     }, /* ĥΥ */
    { 0xd2, 0xd2, FALSE, T_DATA,  0	     }, /* 顼 */
    { 0xd8, 0xd8, FALSE, T_DATA,  0	     }, /* PCM */
    { 0xe0, 0xe0, FALSE, T_DATA,  0	     }, /*  */
    { 0xf0, 0xf0, FALSE, T_DATA,  0	     }, /* ž */
    { 0xf1, 0xf1, TRUE,  T_DATA,  0	     }, /* (1616ɥå) */
    { 0xf2, 0xf2, TRUE,  T_DATA,  0	     }, /* (816ɥå) */
    { 0xf3, 0xf3, TRUE,  T_DATA,  0	     }, /* (2424ɥå) */
    { 0xf4, 0xf4, TRUE,  T_DATA,  0	     }, /* (1224ɥå) */
    { 0xf5, 0xf5, TRUE,  T_DATA,  0	     }, /* (3030ɥå) */
    { 0xf6, 0xf6, TRUE,  T_DATA,  0	     }, /* (1530ɥå) */
    { 0xf7, 0xf7, TRUE,  T_DATA,  0	     }, /* (4848ɥå) */
    { 0xf8, 0xf8, TRUE,  T_DATA,  0	     }, /* (2448ɥå) */
    { 0xff, 0xff, FALSE, T_CINFO, 0	     }, /* ʣ縡 */
    { 0x00, 0x2f, FALSE, T_TEXT,  0	     }, /* ¾Υƥȥǡ */
    { 0x70, 0x7f, FALSE, T_INDEX, IT_NORMAL  }, /* ¾θINDEX */
    { 0x80, 0x8f, FALSE, T_INDEX, IT_COND    }, /* ¾ξ︡INDEX */
    { 0x90, 0x9f, FALSE, T_INDEX, IT_NORMAL  }, /* ¾INDEX */
    { 0xa0, 0xbf, FALSE, T_INDEX, IT_UNKNOWN }, /* ¾INDEX */
    { 0xd0, 0xdf, FALSE, T_DATA,  0	     }  /* ޥǥǡ */
};

/*
 * ҹǺѤΥơ֥
 */
typedef	struct slot_t {
    byte	id;		/* Ǽ̻		*/
    dword	topblk;		/* ǤƬ֥å	*/
    dword	endblk;		/* Ǥκǽ֥å	*/
    dword	blks;		/* ǤΥ֥å		*/
    dword	ntopblk;	/* ԡƬ֥å	*/
} SLOT_T;

long	blkno;
uchr	*bookfile;
uchr	*nbookfile;
uchr	*logfile;
SLOT_T	*slot;			/* ַ׻ѥơ֥		*/
int	slots;			/* ַ׻ѥơ֥ǿ	*/
long	totalblks;
byte	buf[BLKSIZ];
byte	tmpbuf[BLKSIZ];
int	tty;

int	EBGmode = 0;

int	main();
void	usage();
void	init();
void	term();
int	squeeze();
int	nonzero();
ulng	val();
INFO_T	*mknewinfo();
int	checkslot();
long	reloc();
int	idmust();
int	idtype();
int	ididxtype();
int	markdel();
int	hex();
int	copybook();
void	putvoid();
int	copytext();
int	copyindex();
int	copydata();

int
main(ac, av)
int	ac;
char	**av;
{
    int		ret;

    ac--, av++;
    while (ac > 0 && **av == '-') {
	switch (av[0][1]) {
	case 'g':
	case 'G':
	    EBGmode = 1;
	    break;
	case 'd':
	case 'D':
	    if (markdel(&av[0][2]) == ERR)
		usage();
	    break;
	default:
	    usage();
	}
	ac--, av++;
    }
    if (ac != 2)
	usage();
    bookfile = av[0];
    nbookfile = av[1];
    init();
    blkno = 1L;
    ret = squeeze(bookfile, blkno, nbookfile);
    term();
    if (ret == ERR)
	exit(1);
    exit(0);
}

void
usage()
{
    fprintf(stderr, "Żҥ֥å/EPWING ҷ̲");
    fprintf(stderr, " Ver.%s (%s)\n    Written by %s, Public Domain.\n\n",
	version, date, author);
    fprintf(stderr, "ˡ: %s [-g] [-d<IDꥹ>]", progname);
    fprintf(stderr, " <Ͻҥե> <Ͻҥե>\n\n");
    fprintf(stderr, "ץ:\n");
    fprintf(stderr, "    -g: EBG ѥ⡼ɤˤ\n");
    fprintf(stderr, "    -d: IDιǤ\n");
    exit(1);
}

void
init()
{
    time_t	t;
    FILE	*fp;

    tty = isatty(fileno(stderr));
    logfile = (uchr *)malloc(strlen(progname) + strlen(".log") + 1);
    sprintf(logfile, "%s.log", progname);
    if ((fp = fopen(logfile, "a")) == NULL)
	return;
    time(&t);
    fprintf(fp, ": %s\n", ctime(&t));
    fclose(fp);
}

void
term()
{
    time_t	t;
    FILE	*fp;

    if ((fp = fopen(logfile, "a")) == NULL)
	return;
    time(&t);
    fprintf(fp, "\nλ: %s\n", ctime(&t));
    fclose(fp);
}

#ifdef VARARGS
#include <varargs.h>
void
log(va_alist)
va_dcl
#else
#include <stdarg.h>
void
log(uchr *fmt, ...)
#endif
{
    FILE	*fp;
#ifdef VARARGS
    va_list va;
    uchr *fmt;
    va_start(va);
    fmt = va_arg(va, uchr *);
#else
    va_list va;
    va_start(va, fmt);
#endif
    vfprintf(stderr, fmt, va);
    if ((fp = fopen(logfile, "a")) != NULL) {
	vfprintf(fp, fmt, va);
	fclose(fp);
    }
    va_end(va);
}

int
squeeze(bookfile, blkno, nbookfile)
char	*bookfile, *nbookfile;
long	blkno;
{
    int		i;
    INFO_T	*infop, *ninfop;
    SLOT_T	*slotp;

    if (open_book(bookfile) == ERR) {
	log("%s ץǤޤ\n", bookfile);
	return ERR;
    }
    if ((infop = getinfo(blkno)) == NULL) {
	log("Ҵ󤬼Ǥޤ\n");
	return ERR;
    }
    ninfop = mknewinfo(infop);
    if (ninfop == NULL) {
	log("꡼­ޤ\n");
	return ERR;
    }
    log("ϥե = %s\n", bookfile);
    log("ϥե = %s\n\n", nbookfile);
    log("Ժ֥ץ\n\n");
    log("ID ϥ֥å λ֥å      \n");
    slotp = slot;
    for (i = 0; i < slots; i++) {
	log("%02X     %8lu     %8lu  %8lu  %8lu\n",
	    slotp->id, slotp->topblk, slotp->endblk,
	    slotp->blks, slotp->ntopblk);
	slotp++;
    }
    log("\n");
    if (checkslot() == ERR) {
	log("ҥեκƹߤޤ\n");
	return ERR;
    }
    if (open_newbook(nbookfile) == ERR) {
	log("%s ץǤޤ\n", nbookfile);
	return ERR;
    }
    if (putinfo(ninfop, 1L) == ERR) {
	log("Ҵ󤬽񤭹ޤ\n");
	return ERR;
    }
    if (copybook() == ERR) {
	log("ҥեκƹߤޤ\n");
	return ERR;
    }
    close_book();
    if (close_newbook() == ERR) {
	log("ҥե뤬Ǥޤ\n");
	return ERR;
    }
    return OK;
}

int
nonzero(p, len)
uchr	*p;
int	len;
{
    while (len--)
	if (*p++)
	    return TRUE;
    return FALSE;
}

ulng
val(str, len)
uchr	*str;
int	len;
{
    ulng	l;

    l = 0L;
    while (len--)
	l = (l << 8) + *str++;
    return l;
}

INFO_T *
mknewinfo(infop)
INFO_T	*infop;
{
    int		i, j, k, m, n;
    int		items, cents, citems, cinfos;
    long	topblk;
    INFO_T	*ninfop;
    ITEM_T	*itemp, *nitemp;
    CINFO_T	*cinfop, *ncinfop;
    CENT_T	*centp, *ncentp;
    CITEM_T	*citemp, *ncitemp;

    /*
     * ԡ빽Ǥο(items)
     * ʣ縡ο(cinfos)
     * ַ׻ѥơ֥ǿ(slots)롣
     * Ǥʣ縡(ID_CINFO)ξ硢
     * itemsˤ1slotsˤϲ̹Ǥû롣
     * ʣ縡β̹ǤϽʣ뤳Ȥ뤬
     * ǤϽʣƤ⤫ޤ鷺Ȥ롣
     */
    items = 0;
    cinfos = 0;
    slots = 0;
    itemp = infop->item;
    for (i = 0; i < infop->items; i++) {
	if (!idmust(itemp->itemid)) {
	    itemp++;
	    continue;
	}
	if (itemp->itemid != ID_CINFO) {
	    items++;
	    slots++;
	    itemp++;
	    continue;
	}
	items++;
	cinfos++;
	cinfop = itemp->cinfo;
	centp = cinfop->cent;
	for (j = 0; j < cinfop->cents; j++) {
	    citemp = centp->citem;
	    for (k = 0; k < centp->citems; k++) {
		slots++;
		citemp++;
	    }
	    centp++;
	}
	itemp++;
    }
    /*
     * Ǿ򥳥ԡʣ縡֤롣
     * ҴϺǽΥ֥å˽񤭹ޤΤǡ
     * ʣ縡2֥åʹߤ˺֤롣
     */
    ninfop = (INFO_T *)malloc(sizeof(INFO_T));
    if (ninfop == NULL)
	return NULL;
    *ninfop = *infop;
    ninfop->items = items;
    nitemp = (ITEM_T *)malloc(sizeof(ITEM_T) * items);
    if (nitemp == NULL)
	return NULL;
    ninfop->item = nitemp;
    topblk = 2L;	/* ʣ縡γϥ֥å */
    itemp = infop->item;
    nitemp = ninfop->item;
    for (i = 0; i < infop->items; i++) {
	if (!idmust(itemp->itemid)) {
	    itemp++;
	    continue;
	}
	*nitemp = *itemp;
	if (itemp->itemid != ID_CINFO) {
	    /*
	     * ʣ縡ʳι
	     */
	    itemp++;
	    nitemp++;
	    continue;
	}
	/*
	 * ʣ縡
	 */
	nitemp->topblk = topblk++;
	cinfop = itemp->cinfo;
	ncinfop = (CINFO_T *)malloc(sizeof(CINFO_T));
	if (ncinfop == NULL)
	    return NULL;
	nitemp->cinfo = ncinfop;
	*ncinfop = *cinfop;
	centp = cinfop->cent;
	ncentp = (CENT_T *)malloc(sizeof(CENT_T) * ncinfop->cents);
	if (ncentp == NULL)
	    return NULL;
	ncinfop->cent = ncentp;
	for (j = 0; j < cinfop->cents; j++) {
	    *ncentp = *centp;
	    citemp = centp->citem;
	    ncitemp = (CITEM_T *)malloc(sizeof(CITEM_T) * ncentp->citems);
	    if (ncitemp == NULL)
		return NULL;
	    ncentp->citem = ncitemp;
	    for (k = 0; k < centp->citems; k++) {
		*ncitemp = *citemp;
		citemp++;
		ncitemp++;
	    }
	    centp++;
	    ncentp++;
	}
	itemp++;
	nitemp++;
    }
    /*
     * ַ׻ѥơ֥Ʊˡ
     * ʣ縡ʳιǤ֤롣
     */
    slot = (SLOT_T *)malloc(sizeof(SLOT_T) * slots);
    if (slot == NULL)
	return NULL;
    slots = 0;	/* ʣslotsθĿƷ׻ */
    nitemp = ninfop->item;
    for (i = 0; i < ninfop->items; i++) {
	if (nitemp->itemid != ID_CINFO) {
	    /*
	     * ʣ縡ʳι
	     */
	    for (m = 0; m < slots; m++) {
		if (slot[m].topblk == nitemp->topblk) {
		    nitemp->topblk = slot[m].ntopblk;
		    break;
		}
	    }
	    if (m == slots) {
		slot[slots].id = nitemp->itemid;
		slot[slots].topblk = nitemp->topblk;
		slot[slots].endblk = nitemp->topblk + nitemp->blks - 1;
		slot[slots].blks = nitemp->blks;
		slot[slots].ntopblk = topblk;
		nitemp->topblk = topblk;
		topblk += nitemp->blks;
		slots++;
	    }
	    nitemp++;
	    continue;
	}
	/*
	 * ʣ縡
	 */
	ncinfop = nitemp->cinfo;
	ncentp = ncinfop->cent;
	for (j = 0; j < ncinfop->cents; j++) {
	    ncitemp = ncentp->citem;
	    for (k = 0; k < ncentp->citems; k++) {
		for (m = 0; m < slots; m++) {
		    if (slot[m].topblk == ncitemp->ctopblk) {
			ncitemp->ctopblk = slot[m].ntopblk;
			break;
		    }
		}
		if (m == slots) {
		    slot[slots].id = ncitemp->citemid;
		    slot[slots].topblk = ncitemp->ctopblk;
		    slot[slots].endblk = ncitemp->ctopblk + ncitemp->cblks - 1;
		    slot[slots].blks = ncitemp->cblks;
		    slot[slots].ntopblk = topblk;
		    ncitemp->ctopblk = topblk;
		    topblk += ncitemp->cblks;
		    slots++;
		}
		ncitemp++;
	    }
	    ncentp++;
	}
	nitemp++;
    }
    return ninfop;
}

int
checkslot()
{
    int		i, err;

    err = 0;
    for (i = 0; i < slots; i++) {
	if (idtype(slot[i].id) == T_UNKNOWN) {
	    log("¤νҹǤޤ(ID=%02X)\n", slot[i].id);
	    err++;
	}
	if (idtype(slot[i].id) == T_INDEX &&
	    ididxtype(slot[i].id) == IT_UNKNOWN) {
	    log("¤Υǥåޤ(ID=%02X)\n", slot[i].id);
	    err++;
	}
    }
    if (err)
	return ERR;
    return OK;
}

long
reloc(blk)
long	blk;
{
    int		i;
    SLOT_T	*slotp;

    slotp = slot;
    for (i = 0; i < slots; i++) {
	if (blk >= slotp->topblk && blk <= slotp->endblk)
	    return blk - slotp->topblk + slotp->ntopblk;
	slotp++;
    }
    return 0L;
}

int
idmust(id)
int	id;
{
    int		i, n;

    n = sizeof(itypetbl) / sizeof(itypetbl[0]);
    for (i = 0; i < n; i++) {
	if (id >= itypetbl[i].idmin && id <= itypetbl[i].idmax)
	    return itypetbl[i].must;
    }
    return FALSE;
}

int
idtype(id)
int	id;
{
    int		i, n;

    n = sizeof(itypetbl) / sizeof(itypetbl[0]);
    for (i = 0; i < n; i++) {
	if (id >= itypetbl[i].idmin && id <= itypetbl[i].idmax)
	    return itypetbl[i].type;
    }
    return T_UNKNOWN;
}

int
ididxtype(id)
int	id;
{
    int		i, n;

    n = sizeof(itypetbl) / sizeof(itypetbl[0]);
    for (i = 0; i < n; i++) {
	if (id >= itypetbl[i].idmin && id <= itypetbl[i].idmax)
	    return itypetbl[i].idxtype;
    }
    return IT_UNKNOWN;
}

int
markdel(str)
uchr	*str;
{
    int		i, n;
    int		dmin, dmax;

    n = sizeof(itypetbl) / sizeof(itypetbl[0]);
    for (i = 0; i < n; i++)
	itypetbl[i].must = TRUE;
    while (*str) {
	dmin = dmax = hex(str);
	if (dmin < 0)
	    return ERR;
	str += 2;
	if (*str == '-') {
	    str++;
	    dmax = hex(str);
	    if (dmax < 0)
		return ERR;
	    str += 2;
	}
	for (i = 0; i < n; i++) {
	    if (dmax >= itypetbl[i].idmin && dmin <= itypetbl[i].idmax)
		itypetbl[i].must = FALSE;
	}
	if (*str == ',')
	    str++;
    }
    return OK;
}

int
hex(s)
uchr	*s;
{
    int		n;

    if (!isxdigit(s[0]) || !isxdigit(s[1]))
	return -1;
    if (s[0] >= '0' && s[0] <= '9')
	n = s[0] - '0';
    else if (s[0] >= 'A' && s[0] <= 'F')
	n = s[0] - 'A' + 10;
    else if (s[0] >= 'a' && s[0] <= 'f')
	n = s[0] - 'a' + 10;
    n <<= 4;
    if (s[1] >= '0' && s[1] <= '9')
	n += s[1] - '0';
    else if (s[1] >= 'A' && s[1] <= 'F')
	n += s[1] - 'A' + 10;
    else if (s[1] >= 'a' && s[1] <= 'f')
	n += s[1] - 'a' + 10;
    return n;
}

int
copybook()
{
    int		i, ret;
    SLOT_T	*p;

    if (tty) {
	fprintf(stderr, "Ǥ(0%%)");
	fflush(stderr);
    }
    totalblks = slot[slots-1].ntopblk + slot[slots-1].blks - 1;
    p = slot;
    for (i = 0; i < slots; i++) {
	if (locate_block(p->topblk) == ERR) {
	    if (tty)
		putc('\n', stderr);
	    log("եɤ߹ߤ˼Ԥޤ\n");
	    return ERR;
	}
	if (locate_newblock(p->ntopblk) == ERR) {
	    if (tty)
		putc('\n', stderr);
	    log("եν񤭹ߤ˼Ԥޤ\n");
	    return ERR;
	}
	switch (idtype(p->id)) {
	case T_TEXT:
	    ret = copytext(p->id, p->topblk, p->blks);
	    break;
	case T_INDEX:
	    ret = copyindex(p->id, p->topblk, p->blks, ididxtype(p->id));
	    break;
	case T_DATA:
	    ret = copydata(p->id, p->topblk, p->blks);
	    break;
	}
	if (ret == ERR)
	    return ERR;
	p++;
    }
    if (tty)
	fprintf(stderr, "\rλޤ    \n");
    else
	log("λޤ\n");
    return OK;
}

void
putvoid(n)
int	n;
{
    if (n >= 2) {
	/*
	 * ""񤭹
	 */
	if (!EBGmode) {
	    putword(0x222a);
	    putword(0x2222);
	} else {
	    putbyte('-');
	    putbyte('>');
	    putbyte('[');
	    putbyte(']');
	}
	n -= 2;
    }
    if (n >= 3 && n & 1) {
	putword(0x1fe0);	/* ĥĴɽ */
	putword(0x0001);
	putword(0x1fe1);	/* ĥĴɽλ */
	n -= 3;
    }
    while (n >= 2) {
	putword(0x1f04);	/* Ⱦѳ */
	putword(0x1f05);	/* Ⱦѽλ */
	n -= 2;
    }
    while (n--)
	if (!EBGmode) {
	    putword(0x2121);	/*  */
	} else {
	    putbyte(' ');	/*  */
	    putbyte(' ');	/*  */
	}
}

int
copytext(itemid, topblk, blks)
int	itemid;
long	topblk, blks;
{
    int		i, pc, npc, curoff, erroff;
    long	err, rel, curblk, endblk, errblk;
    long	blk1, blk2, off1, off2, bcd1, bcd2;
    word	w, w1, w2;
    byte	*p;
#ifdef TEST
    long	nerr = 0L;
#endif

    if (tty) {
	pc = -1;
	putc('\r', stderr);
    }
    log("ID=%02X, =ƥ, ϥ֥å=%ld, ֥å=%ld\n",
	itemid, topblk, blks);
    err = 0L;
    rel = 0L;
    reset_error();
    endblk = topblk + blks - 1;
    for (;;) {
	if (get_error() > 0) {
	    if (tty)
		putc('\n', stderr);
	    log("եν񤭹˥顼ȯޤ\n");
	    return ERR;
	}
	curblk = cur_block();
	curoff = cur_off();
	if (curblk > endblk || curblk == endblk && curoff == BLKSIZ)
	    break;
	if (tty) {
	    npc = (int)(cur_newblock() * 100 / totalblks);
	    if (npc > pc) {
		fprintf(stderr, "\rǤ(%d%%)", npc);
		fflush(stderr);
		pc = npc;
	    }
	}
	if (!EBGmode) {
	    w = getword();
	} else {
	    w = getbyte();
	}
    again:
	if (!EBGmode) {
	    if (w >= 0x2121 && w <= 0x7e7e || w >= 0xa121 && w <= 0xfe7e) {
		/*
		 * JISʸ;ʸϰϤϰʲ̤ΤϤ
		 *   ̾ʸ: 21217426
		 *   : a121fe7e
		 * Ʋɥϥ󥿡θ켭ŵ7671
		 * Żҥ֥åǸҿ¡±漭ŵ7440롣
		 */
		putword(w);
		w = getword();
		goto again;
	    }
	} else {
	    if (w == 0) {
	    } else if (w == 0x1f) {
		w = w << 8 | getbyte();
	    } else {
		putbyte(w & 0xff);
		if (0 < w && w < 0x1f) { /* EBG gaiji */
		    w = getbyte();
		    putbyte(w & 0xff);
		}
		w = getbyte();
		goto again;
	    }
	}

	if (w == 0x0000) {
	    /*
	     * ѥǥ
	     */
	    if (!EBGmode) {
		putword(w);
	    } else {
		putbyte(w);
	    }
	    continue;
	}
	/*
	 * ɽ浭һ
	 */
	if ((w & 0xff00) == 0x1f00) {
	    switch (w & 0x00ff) {
	    case 0x09:	/*  */
	    case 0x1a:	/* JIS X4081°λؼˤ */
	    case 0x1b:	/* JIS X4081°λؼˤ */
	    case 0x1c:	/* JIS X4081°λؼˤ */
	    case 0x1d:	/* JIS X4081°λؼˤ */
	    case 0x1e:	/* JIS X4081°λؼˤ */
	    case 0x1f:	/* JIS X4081°λؼˤ */
	    case 0x41:	/* һ */
	    case 0x45:	/* ǥǡ̻ (DIC 0.23ˤ) */
	    case 0xe0:	/* ĥĴɽϻ */
	    case 0xe2:	/* ݸϻ (DIC 0.23ˤ) */
		/*
		 * ľ1WORD򤽤Τޤޥԡ롣
		 * 1f45Żҥ֥åǹǤ˽ФƤ롣
		 */
		putword(w);
		w1 = getword();
		putword(w1);
		break;
	    case 0x31:	/* ǸФλؼ? */
	    case 0x32:	/* Żҥ֥åĥΥ */
	    case 0x42:	/* ̹ܻȵһ */
	    case 0x44:	/* ǥǡ̻ (DIC 0.23ˤ) */
	    case 0x46:	/* ǥ˥塼̻ (DIC 0.23ˤ) */
	    case 0x49:	/* ̤ǧ: ɽ? (cdrom2ˤ) */
	    case 0x4b:	/* ̤ǧ: ޷? (cdrom2ˤ) */
	    case 0x4c:	/* ̤ǧ: ޷? (cdrom2ˤ) */
	    case 0x4e:	/* ̤ǧ: ݥ? (cdrom2ˤ) */
	    case 0x4f:	/* ̤ǧ: ݥ? (cdrom2ˤ) */
		/*
		 * λ̻ҤޤǤŪ¸Ƥ
		 * λ̻ҤľˤBCD4+BCD2򸫤ơ
		 * 褬ʤΤ֢פ֤롣
		 *
		 * Żҥ֥åǸҿ¡±漭ŵǤ
		 * 1f42νλ̻1f62ǥեåȤ
		 * 2048ʾˤʤäƤս꤬롣
		 * ǡ򸫤ȥեåȤ2048
		 * Υ֥å򻲾ȤȤˡ
		 * ĤĤޤäƤ褦
		 */
		p = tmpbuf;
		*p++ = w >> 8;
		*p++ = w & 0xff;
		w1 = w + 0x0020;

		if (!EBGmode) {
		    while ((w = getword()) != w1) {
			*p++ = w >> 8;
			*p++ = w & 0xff;
		    }
		} else {
		    int ww;

		    while (1) {
			w = getbyte();
			if (w == 0x1f) {
			    ww = getbyte();
			    if (w << 8 | ww == w1) {
				w = w1;
				break;
			    } else {
				*p++ = w;
				*p++ = ww;
			    }
			} else {
			    *p++ = w;
			}
		    }
		}

		blk1 = getbcd(4);
		off1 = getbcd(2);
		if (blk1 < 0 || off1 < 0 || off1 >= BLKSIZ) {
		    err++;
		    errblk = cur_block();
		    erroff = cur_off();
#ifdef TEST
		    if (tty)
			putc('\r', stderr);
		    log("err: pos=%lu:%d\n", cur_block(), cur_off());
#endif
		}
		blk1 = reloc(blk1);
		if (blk1 == 0L) {
		    putvoid((p - tmpbuf) / 2 + 4);
		} else {
		    putbytes(tmpbuf, p - tmpbuf);
		    putword(w);
		    putbcd(blk1, 4);
		    putbcd(off1, 2);
		    rel++;
		}
		break;
	    case 0x33:	/* Żҥ֥å (ndtpdˤ) */
		/*
		 * ϡɥǥǤϺǽʤΤ
		 * Τ֢פ֤롣
		 */
		i = 1;
		while ((w = getword()) != 0x1f53)
		    i++;
		i++;
		w = getword();
		/*
		 * Żҥ֥åǹǤοǸФ򸫤¤ꡢ
		 * ΤBCD4+BCD2ǤϤʤ褦
		 */
		bcd1 = getbcd(3);
		bcd2 = getbcd(3);
		if (bcd1 < 0 || bcd2 < 0) {
		    err++;
		    errblk = cur_block();
		    erroff = cur_off();
#ifdef TEST
		    if (tty)
			putc('\r', stderr);
		    log("err: pos=%lu:%d\n", cur_block(), cur_off());
#endif
		}
		i += 4;
		putvoid(i);
		break;
	    case 0x48:	/* ǡ̻ (DIC 0.23ˤ) */
		/*
		 * 1f48ľ5WORDCDȥå򻲾ȤƤ롣
		 * ϡɥǥǤϺǽʤΤ
		 * 1f68ޤǤΤ֢פ֤롣
		 * 1f68θˤϥݥ󥿡ʤ
		 * 1f48ȤäƤEPWING缭Ӥˤ롣
		 */
		i = 1;
		while ((w = getword()) != 0x1f68)
		    i++;
		i++;
		putvoid(i);
		break;
	    case 0x4a:	/* EPWING PCM */
		/*
		 * 1f4a+WORD+WORD+BCD4+BCD2+BCD4+BCD2++1f6a
		 * Ȥ¤򤷤Ƥ롣
		 */
		w1 = getword();
		w2 = getword();
		blk1 = getbcd(4);
		off1 = getbcd(2);
		blk2 = getbcd(4);
		off2 = getbcd(2);
		if (blk1 < 0 || off1 < 0 || off1 >= BLKSIZ ||
		    blk2 < 0 || off2 < 0 || off2 >= BLKSIZ) {
		    err++;
		    errblk = cur_block();
		    erroff = cur_off();
#ifdef TEST
		    if (tty)
			putc('\r', stderr);
		    log("err: pos=%lu:%d\n", cur_block(), cur_off());
#endif
		}
		blk1 = reloc(blk1);
		blk2 = reloc(blk2);
		if (blk1 == 0L || blk2 == 0L) {
		    i = 9;
		    while (getword() != 0x1f6a)
			i++;
		    i++;
		    putvoid(i);
		} else {
		    putword(w);
		    putword(w1);
		    putword(w2);
		    putbcd(blk1, 4);
		    putbcd(off1, 2);
		    putbcd(blk2, 4);
		    putbcd(off2, 2);
		    rel++;
		    rel++;
		    while ((w = getword()) != 0x1f6a)
			putword(w);
		    putword(0x1f6a);
		}
		break;
	    case 0x4d:	/* 顼 */
		/*
		 * ˤ䤷ϤޤΤȤ
		 * EPWINGǹǤʸˤʤ
		 * ȤƤϡ֥פ2Υ顼Ǥ
		 * ȤƤȤ롣٤Ƥβս꤬
		 *   1f4d+0009+0000*5+BCD4+BCD2+٥+1f6d
		 * ȤǤꡢʳȤ߹碌Ϥʤ
		 * Ȥꤢ
		 *   1f4d+WORD*6+BCD4+BCD2+٥+1f6d
		 * ȤǤȲᤷƤ
		 */
		p = tmpbuf;
		*p++ = w >> 8;
		*p++ = w & 0xff;
		for (i = 0; i < 6; i++) {
		    w = getword();
		    *p++ = w >> 8;
		    *p++ = w & 0xff;
		}
		blk1 = getbcd(4);
		off1 = getbcd(2);
		if (blk1 < 0 || off1 < 0 || off1 >= BLKSIZ) {
		    err++;
		    errblk = cur_block();
		    erroff = cur_off();
#ifdef TEST
		    if (tty)
			putc('\r', stderr);
		    log("err: pos=%lu:%d\n", cur_block(), cur_off());
#endif
		}
		blk1 = reloc(blk1);
		if (blk1 == 0L) {
		    i = 1 + 6 + 3;
		    while (getword() != 0x1f6d)
			i++;
		    i++;
		    putvoid(i);
		} else {
		    putbytes(tmpbuf, p - tmpbuf);
		    putbcd(blk1, 4);
		    putbcd(off1, 2);
		    rel++;
		    while ((w = getword()) != 0x1f6d)
			putword(w);
		    putword(0x1f6d);
		}
		break;
	    case 0x62:	/* ̹ܻȽλһ */
	    case 0x63:	/* ˥塼λһ */
		/*
		 * ŵ97Υޥڥǥ97ǡ
		 * ܡפ̹ܻ桢֢ݥĥ
		 * ľˡ̢֥󡦰쥹ȡפȤܤ롣
		 * ɤ1f42254c˲Ƥ褦
		 * case 0x421f62ޤɤǽƤΤ
		 * case 0x62Τϡб뤿ᡣ
		 * (ǡ櫓ǤϤʤ)
		 */
		putword(w);
		blk1 = getbcd(4);
		off1 = getbcd(2);
		if (blk1 < 0 || off1 < 0 || off1 >= BLKSIZ) {
		    err++;
		    errblk = cur_block();
		    erroff = cur_off();
#ifdef TEST
		    if (tty)
			putc('\r', stderr);
		    log("err: pos=%lu:%d\n", cur_block(), cur_off());
#endif
		}
		blk1 = reloc(blk1);
		putbcd(blk1, 4);
		putbcd(off1, 2);
		rel++;
		break;
	    case 0x14:	/* 곫ϻ (DIC 0.23ˤ) */
	    case 0x67:	/* ܥ˥塼λ̻ (DIC 0.23ˤ) */
		do {
		    putword(w);
		    w = getword();
		} while ((w & 0xff00) == 0x1e00);
		goto again;
	    case 0x15:	/* 꽪λ (DIC 0.23ˤ) */
		/*
		 * EPWNIGǹCD-ROM(顼)Ǥ
		 * ︡ǡ֤礯礯פ򸡺
		 * ֥꡼ֿפθФΡ֡ۡפθǡ
		 * 1f15ľˤɤ櫓0260ФƤ롣
		 * ȤȤVer.2ٻCD񸡺V1.3L12
		 * OASYS-CDView/Win V3.0L10Ǥɽʤ
		 * DDwinViewIng95WordEngine2Ǥϲ롣
		 * ΥХ?
		 */
		putword(w);
		w = getword();
		if ((w & 0xff00) == 0x1f00)
		    goto again;
		putword(w);
		break;
	    default:
		putword(w);
		break;
	    }
	    continue;
	}
	/*
	 * Żҥ֥åǻƲޥåŵα¡±Ѽŵ
	 * ֥+ӥͥ+饦פǤϽҹ
	 * 0F(ǰ)D1(ĥΥ)Υǡ
	 * ޤäƤ褦ƤΥǡ
	 * 顼ȤƤƤ뤬ǡΰ
	 * ɽ浭һҤȤޤްפƤޤȡϡ
	 * λһҤбȤ줺˥ץब۾ｪλ
	 * Ƥޤǽ롣ޤкʤΤǡ
	 * Ǥ֤Ƥ
	 */
	putword(w);
#ifdef TEST
	if (nerr++ < 20L) {
	    if (tty)
		putc('\r', stderr);
	    log("ERR: word=%04X, pos=%lu:%d(%04x)\n",
		w, curblk, curoff, curoff);
	}
#endif
	err++;
	errblk = cur_block();
	erroff = cur_off();
    }
    if (err) {
	if (tty)
	    putc('\n', stderr);
	log("̤Τɽ湽¤ޤ(Ŀ=%ld, ǽ=%lu:%d)\n",
	    err, errblk, erroff);
    }
    return OK;
}

int
copyindex(itemid, topblk, blks, idxtype)
int	itemid;
long	topblk, blks;
int	idxtype;
{
    int		i, pc, npc, id, eid;
    int		off1, off2, erroff;
    long	n, err, ref, rel, errblk;
    long	blk1, blk2;
    word	len, cnt, num, dum;

    if (tty) {
	pc = -1;
	putc('\r', stderr);
    }
    log("ID=%02X, =ǥå, ϥ֥å=%ld, ֥å=%ld\n",
	itemid, topblk, blks);
    err = 0L;
    ref = 0L;
    rel = 0L;
    reset_error();
    n = cur_newblock();
    while (blks--) {
	if (tty) {
	    npc = (int)(n++ * 100 / totalblks);
	    if (npc > pc) {
		fprintf(stderr, "\rǤ(%d%%)", npc);
		fflush(stderr);
		pc = npc;
	    }
	}
	id = getbyte();
	len = getbyte();
	cnt = getword();
	putbyte(id);
	putbyte(len);
	putword(cnt);

	if ((id & 0x80) == 0x00) {
	    /*
	     * ̥ǥå֥å
	     */
	    for (i = 0; i < cnt; i++) {
		getbytes(buf, len);
		blk1 = getdword();
		blk1 = reloc(blk1);
		if (blk1 == 0L) {
		    errblk = cur_block();
		    erroff = cur_off();
		    ref++;
		}
		putbytes(buf, len);
		putdword(blk1);
		rel++;
	    }
	    goto nextblock;
	}

	/*
	 * ǲ̥ǥå֥å
	 */
	if ((id & 0x10) == 0x00) {
	    /*
	     * ̷ȥ
	     */
	    switch (idxtype) {
	    case IT_DIRECT:
		for (i = 0; i < cnt; i++) {
		    len = getbyte();
		    getbytes(buf, len);
		    blk1 = getdword();
		    off1 = getword();
		    if (off1 >= BLKSIZ)
			err++;
		    blk1 = reloc(blk1);
		    if (blk1 == 0L) {
			errblk = cur_block();
			erroff = cur_off();
			ref++;
		    }
		    putbyte(len);
		    putbytes(buf, len);
		    putdword(blk1);
		    putword(off1);
		    rel++;
		}
		break;

	    default:
		for (i = 0; i < cnt; i++) {
		    len = getbyte();
		    getbytes(buf, len);
		    blk1 = getdword();
		    off1 = getword();
		    blk2 = getdword();
		    off2 = getword();
		    if (off1 > BLKSIZ || off2 >= BLKSIZ) {
			/*
			 * Żҥ֥åǸҿ¡±漭ŵǤ
			 * եåoff12048ˤʤäƤս꤬롣
			 * Υ֥åƬ򻲾ȤȲ᤹
			 * ĤĤޤäƤΤǡ顼ˤϤʤ
			 * б뤿ᡢ顼ϰϤ
			 * >= BLKSIZפǤϤʤ> BLKSIZפȤ롣
			 */
			err++;
		    }
		    blk1 = reloc(blk1);
		    blk2 = reloc(blk2);
		    if (blk1 == 0L || blk2 == 0L) {
			errblk = cur_block();
			erroff = cur_off();
			ref++;
		    }
		    putbyte(len);
		    putbytes(buf, len);
		    putdword(blk1);
		    putword(off1);
		    putdword(blk2);
		    putword(off2);
		    rel++;
		    rel++;
		}
		break;
	    }
	    goto nextblock;
	}

	/*
	 * ĳǰդȥ
	 */
	switch (idxtype) {
	case IT_DIRECT:
	    for (i = 0; i < cnt; i++) {
		eid = getbyte();
		putbyte(eid);
		if (eid == 0x00) {
		    /*
		     * ܥȥ
		     */
		    len = getbyte();
		    getbytes(buf, len);
		    blk1 = getdword();
		    off1 = getword();
		    if (off1 >= BLKSIZ)
			err++;
		    blk1 = reloc(blk1);
		    if (blk1 == 0L) {
			errblk = cur_block();
			erroff = cur_off();
			ref++;
		    }
		    putbyte(len);
		    putbytes(buf, len);
		    putdword(blk1);
		    putword(off1);
		    rel++;
		} else if (eid == 0x80) {
		    /*
		     * ĥȥ
		     */
		    len = getbyte();
		    num = getword();
		    getbytes(buf, len);
		    putbyte(len);
		    putword(num);
		    putbytes(buf, len);
		} else if (eid == 0xc0) {
		    /*
		     * о
		     */
		    len = getbyte();
		    getbytes(buf, len);
		    blk1 = getdword();
		    off1 = getword();
		    if (off1 >= BLKSIZ)
			err++;
		    blk1 = reloc(blk1);
		    if (blk1 == 0L) {
			errblk = cur_block();
			erroff = cur_off();
			ref++;
		    }
		    putbyte(len);
		    putbytes(buf, len);
		    putdword(blk1);
		    putword(off1);
		    rel++;
		} else {
		    err++;
		    break;
		}
	    }
	    break;

	case IT_NORMAL:
	    for (i = 0; i < cnt; i++) {
		eid = getbyte();
		putbyte(eid);
		if (eid == 0x00) {
		    /*
		     * ܥȥ
		     */
		    len = getbyte();
		    getbytes(buf, len);
		    blk1 = getdword();
		    off1 = getword();
		    blk2 = getdword();
		    off2 = getword();
		    if (off1 >= BLKSIZ || off2 >= BLKSIZ)
			err++;
		    blk1 = reloc(blk1);
		    blk2 = reloc(blk2);
		    if (blk1 == 0L || blk2 == 0L) {
			errblk = cur_block();
			erroff = cur_off();
			ref++;
		    }
		    putbyte(len);
		    putbytes(buf, len);
		    putdword(blk1);
		    putword(off1);
		    putdword(blk2);
		    putword(off2);
		    rel++;
		} else if (eid == 0x80) {
		    /*
		     * ĥȥ
		     */
		    len = getbyte();
		    num = getword();
		    getbytes(buf, len);
		    putbyte(len);
		    putword(num);
		    putbytes(buf, len);
		} else if (eid == 0xc0) {
		    /*
		     * о
		     */
		    len = getbyte();
		    getbytes(buf, len);
		    blk1 = getdword();
		    off1 = getword();
		    blk2 = getdword();
		    off2 = getword();
		    if (off1 >= BLKSIZ || off2 >= BLKSIZ)
			err++;
		    blk1 = reloc(blk1);
		    blk2 = reloc(blk2);
		    if (blk1 == 0L || blk2 == 0L) {
			errblk = cur_block();
			erroff = cur_off();
			ref++;
		    }
		    putbyte(len);
		    putbytes(buf, len);
		    putdword(blk1);
		    putword(off1);
		    putdword(blk2);
		    putword(off2);
		    rel++;
		} else {
		    err++;
		    break;
		}
	    }
	    break;

	case IT_COND:
	    for (i = 0; i < cnt; i++) {
		eid = getbyte();
		putbyte(eid);
		if (eid == 0x00) {
		    /*
		     * ܥȥ
		     */
		    len = getbyte();
		    getbytes(buf, len);
		    blk1 = getdword();
		    off1 = getword();
		    blk2 = getdword();
		    off2 = getword();
		    if (off1 >= BLKSIZ || off2 >= BLKSIZ)
			err++;
		    blk1 = reloc(blk1);
		    blk2 = reloc(blk2);
		    if (blk1 == 0L || blk2 == 0L) {
			errblk = cur_block();
			erroff = cur_off();
			ref++;
		    }
		    putbyte(len);
		    putbytes(buf, len);
		    putdword(blk1);
		    putword(off1);
		    putdword(blk2);
		    putword(off2);
		    rel++;
		} else if (eid == 0x80) {
		    /*
		     * ĥȥ
		     */
		    len = getbyte();
		    dum = getword();
		    num = getword();
		    getbytes(buf, len);
		    blk1 = getdword();
		    off1 = getword();
		    if (off1 >= BLKSIZ)
			err++;
		    blk1 = reloc(blk1);
		    if (blk1 == 0L) {
			errblk = cur_block();
			erroff = cur_off();
			ref++;
		    }
		    putbyte(len);
		    putword(dum);
		    putword(num);
		    putbytes(buf, len);
		    putdword(blk1);
		    putword(off1);
		    rel++;
		} else if (eid == 0xc0) {
		    /*
		     * о
		     */
		    blk1 = getdword();
		    off1 = getword();
		    if (off1 >= BLKSIZ)
			err++;
		    blk1 = reloc(blk1);
		    if (blk1 == 0L) {
			errblk = cur_block();
			erroff = cur_off();
			ref++;
		    }
		    putdword(blk1);
		    putword(off1);
		    rel++;
		} else {
		    err++;
		    break;
		}
	    }
	    break;

	case IT_ITEM:
	    for (i = 0; i < cnt; i++) {
		eid = getbyte();
		putbyte(eid);
		if (eid == 0x00) {
		    /*
		     * ܥȥ
		     */
		    len = getbyte();
		    getbytes(buf, len);
		    blk1 = getdword();
		    off1 = getword();
		    blk2 = getdword();
		    off2 = getword();
		    if (off1 >= BLKSIZ || off2 >= BLKSIZ)
			err++;
		    blk1 = reloc(blk1);
		    blk2 = reloc(blk2);
		    if (blk1 == 0L || blk2 == 0L) {
			errblk = cur_block();
			erroff = cur_off();
			ref++;
		    }
		    putbyte(len);
		    putbytes(buf, len);
		    putdword(blk1);
		    putword(off1);
		    putdword(blk2);
		    putword(off2);
		    rel++;
		} else if (eid == 0x80) {
		    /*
		     * ĥȥ
		     */
		    len = getbyte();
		    dum = getword();
		    num = getword();
		    getbytes(buf, len);
		    putbyte(len);
		    putword(dum);
		    putword(num);
		    putbytes(buf, len);
		} else if (eid == 0xc0) {
		    /*
		     * о
		     */
		    blk1 = getdword();
		    off1 = getword();
		    blk2 = getdword();
		    off2 = getword();
		    if (off1 >= BLKSIZ || off2 >= BLKSIZ)
			err++;
		    blk1 = reloc(blk1);
		    blk2 = reloc(blk2);
		    if (blk1 == 0L || blk2 == 0L) {
			errblk = cur_block();
			erroff = cur_off();
			ref++;
		    }
		    putdword(blk1);
		    putword(off1);
		    putdword(blk2);
		    putword(off2);
		    rel++;
		} else {
		    err++;
		    break;
		}
	    }
	    break;
	}

    nextblock:
	if (err) {
	    if (tty)
		putc('\n', stderr);
	    log("ǥå¤礬ޤ(֥å=%lu)\n",
		cur_block());
	    return ERR;
	}
	if (get_error() > 0 || write_newblock() == ERR) {
	    if (tty)
		putc('\n', stderr);
	    log("եν񤭹˥顼ȯޤ\n");
	    return ERR;
	}
	read_block();
    }
    if (ref > 0) {
	if (tty)
	    putc('\n', stderr);
	log("Τʤǥåޤ(Ŀ=%ld, ǽ=%lu:%d)\n",
	    ref, errblk, erroff);
    }
    return OK;
}

int
copydata(itemid, topblk, blks)
int	itemid;
long	topblk, blks;
{
    int		pc, npc;
    long	n;

    if (tty) {
	pc = -1;
	putc('\r', stderr);
    }
    log("ID=%02X, =ǡ, ϥ֥å=%ld, ֥å=%ld\n",
	itemid, topblk, blks);
    reset_error();
    n = cur_newblock();
    while (blks--) {
	if (tty) {
	    npc = (int)(n++ * 100 / totalblks);
	    if (npc > pc) {
		fprintf(stderr, "\rǤ(%d%%)", npc);
		fflush(stderr);
		pc = npc;
	    }
	}
	getbytes(buf, BLKSIZ);
	putbytes(buf, BLKSIZ);
	if (get_error() > 0) {
	    if (tty)
		putc('\n', stderr);
	    log("եν񤭹˥顼ȯޤ\n");
	    return ERR;
	}
    }
    return OK;
}
