// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file unionsTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "unionsTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "unions.hpp"

#include "helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Short_type_identifier(
        TypeIdentifierPair& type_ids_Union_Short)
{
    ReturnCode_t return_code_Union_Short {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Short =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Short", type_ids_Union_Short);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Short)
    {
        UnionTypeFlag union_flags_Union_Short = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Short = "Union_Short";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Short;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Short;
        CompleteTypeDetail detail_Union_Short = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Short, ann_custom_Union_Short, type_name_Union_Short.to_string());
        CompleteUnionHeader header_Union_Short = TypeObjectUtils::build_complete_union_header(detail_Union_Short);
        UnionDiscriminatorFlag member_flags_Union_Short = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Short =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_Short);

        if (return_code_Union_Short != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Short;
        if (EK_COMPLETE == type_ids_Union_Short.type_identifier1()._d() || TK_NONE == type_ids_Union_Short.type_identifier2()._d())
        {
            common_Union_Short = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Short, type_ids_Union_Short.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Short.type_identifier2()._d())
        {
            common_Union_Short = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Short, type_ids_Union_Short.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Short discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Short.reset();
        ann_custom_Union_Short.reset();
        CompleteDiscriminatorMember discriminator_Union_Short = TypeObjectUtils::build_complete_discriminator_member(common_Union_Short,
                type_ann_builtin_Union_Short, ann_custom_Union_Short);
        CompleteUnionMemberSeq member_seq_Union_Short;
        {
            return_code_Union_Short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_Union_Short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "a Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_a = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_a;
            TypeObjectUtils::add_union_case_label(label_seq_a, static_cast<int32_t>(0));
            MemberId member_id_a = 0x00000001;
            bool common_a_ec {false};
            CommonUnionMember common_a {TypeObjectUtils::build_common_union_member(member_id_a,
                    member_flags_a, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Short,
                        common_a_ec), label_seq_a)};
            if (!common_a_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union a member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_a = "a";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_a;
            ann_custom_Union_Short.reset();
            CompleteMemberDetail detail_a = TypeObjectUtils::build_complete_member_detail(name_a, member_ann_builtin_a, ann_custom_Union_Short);
            CompleteUnionMember member_a = TypeObjectUtils::build_complete_union_member(common_a, detail_a);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Short, member_a);
        }
        CompleteUnionType union_type_Union_Short = TypeObjectUtils::build_complete_union_type(union_flags_Union_Short, header_Union_Short, discriminator_Union_Short,
                member_seq_Union_Short);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Short, type_name_Union_Short.to_string(), type_ids_Union_Short))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Short already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_UShort_type_identifier(
        TypeIdentifierPair& type_ids_Union_UShort)
{
    ReturnCode_t return_code_Union_UShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_UShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_UShort", type_ids_Union_UShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_UShort)
    {
        UnionTypeFlag union_flags_Union_UShort = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_UShort = "Union_UShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_UShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_UShort;
        CompleteTypeDetail detail_Union_UShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_UShort, ann_custom_Union_UShort, type_name_Union_UShort.to_string());
        CompleteUnionHeader header_Union_UShort = TypeObjectUtils::build_complete_union_header(detail_Union_UShort);
        UnionDiscriminatorFlag member_flags_Union_UShort = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_UShort =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_UShort);

        if (return_code_Union_UShort != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_UShort;
        if (EK_COMPLETE == type_ids_Union_UShort.type_identifier1()._d() || TK_NONE == type_ids_Union_UShort.type_identifier2()._d())
        {
            common_Union_UShort = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_UShort, type_ids_Union_UShort.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_UShort.type_identifier2()._d())
        {
            common_Union_UShort = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_UShort, type_ids_Union_UShort.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_UShort discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_UShort.reset();
        ann_custom_Union_UShort.reset();
        CompleteDiscriminatorMember discriminator_Union_UShort = TypeObjectUtils::build_complete_discriminator_member(common_Union_UShort,
                type_ann_builtin_Union_UShort, ann_custom_Union_UShort);
        CompleteUnionMemberSeq member_seq_Union_UShort;
        {
            return_code_Union_UShort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_Union_UShort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_UShort)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "b Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_b = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_b;
            TypeObjectUtils::add_union_case_label(label_seq_b, static_cast<int32_t>(1));
            MemberId member_id_b = 0x00000001;
            bool common_b_ec {false};
            CommonUnionMember common_b {TypeObjectUtils::build_common_union_member(member_id_b,
                    member_flags_b, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_UShort,
                        common_b_ec), label_seq_b)};
            if (!common_b_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union b member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_b = "b";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_b;
            ann_custom_Union_UShort.reset();
            CompleteMemberDetail detail_b = TypeObjectUtils::build_complete_member_detail(name_b, member_ann_builtin_b, ann_custom_Union_UShort);
            CompleteUnionMember member_b = TypeObjectUtils::build_complete_union_member(common_b, detail_b);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_UShort, member_b);
        }
        CompleteUnionType union_type_Union_UShort = TypeObjectUtils::build_complete_union_type(union_flags_Union_UShort, header_Union_UShort, discriminator_Union_UShort,
                member_seq_Union_UShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_UShort, type_name_Union_UShort.to_string(), type_ids_Union_UShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_UShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Long_type_identifier(
        TypeIdentifierPair& type_ids_Union_Long)
{
    ReturnCode_t return_code_Union_Long {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Long =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Long", type_ids_Union_Long);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Long)
    {
        UnionTypeFlag union_flags_Union_Long = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Long = "Union_Long";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Long;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Long;
        CompleteTypeDetail detail_Union_Long = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Long, ann_custom_Union_Long, type_name_Union_Long.to_string());
        CompleteUnionHeader header_Union_Long = TypeObjectUtils::build_complete_union_header(detail_Union_Long);
        UnionDiscriminatorFlag member_flags_Union_Long = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Long =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_Long);

        if (return_code_Union_Long != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Long;
        if (EK_COMPLETE == type_ids_Union_Long.type_identifier1()._d() || TK_NONE == type_ids_Union_Long.type_identifier2()._d())
        {
            common_Union_Long = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Long, type_ids_Union_Long.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Long.type_identifier2()._d())
        {
            common_Union_Long = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Long, type_ids_Union_Long.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Long discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Long.reset();
        ann_custom_Union_Long.reset();
        CompleteDiscriminatorMember discriminator_Union_Long = TypeObjectUtils::build_complete_discriminator_member(common_Union_Long,
                type_ann_builtin_Union_Long, ann_custom_Union_Long);
        CompleteUnionMemberSeq member_seq_Union_Long;
        {
            return_code_Union_Long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_Union_Long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "c Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_c = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_c;
            TypeObjectUtils::add_union_case_label(label_seq_c, static_cast<int32_t>(2));
            MemberId member_id_c = 0x00000001;
            bool common_c_ec {false};
            CommonUnionMember common_c {TypeObjectUtils::build_common_union_member(member_id_c,
                    member_flags_c, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Long,
                        common_c_ec), label_seq_c)};
            if (!common_c_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union c member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_c = "c";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_c;
            ann_custom_Union_Long.reset();
            CompleteMemberDetail detail_c = TypeObjectUtils::build_complete_member_detail(name_c, member_ann_builtin_c, ann_custom_Union_Long);
            CompleteUnionMember member_c = TypeObjectUtils::build_complete_union_member(common_c, detail_c);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Long, member_c);
        }
        CompleteUnionType union_type_Union_Long = TypeObjectUtils::build_complete_union_type(union_flags_Union_Long, header_Union_Long, discriminator_Union_Long,
                member_seq_Union_Long);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Long, type_name_Union_Long.to_string(), type_ids_Union_Long))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Long already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_ULong_type_identifier(
        TypeIdentifierPair& type_ids_Union_ULong)
{
    ReturnCode_t return_code_Union_ULong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_ULong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_ULong", type_ids_Union_ULong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_ULong)
    {
        UnionTypeFlag union_flags_Union_ULong = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_ULong = "Union_ULong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_ULong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_ULong;
        CompleteTypeDetail detail_Union_ULong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_ULong, ann_custom_Union_ULong, type_name_Union_ULong.to_string());
        CompleteUnionHeader header_Union_ULong = TypeObjectUtils::build_complete_union_header(detail_Union_ULong);
        UnionDiscriminatorFlag member_flags_Union_ULong = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_ULong =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_ULong);

        if (return_code_Union_ULong != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_ULong;
        if (EK_COMPLETE == type_ids_Union_ULong.type_identifier1()._d() || TK_NONE == type_ids_Union_ULong.type_identifier2()._d())
        {
            common_Union_ULong = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_ULong, type_ids_Union_ULong.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_ULong.type_identifier2()._d())
        {
            common_Union_ULong = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_ULong, type_ids_Union_ULong.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_ULong discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_ULong.reset();
        ann_custom_Union_ULong.reset();
        CompleteDiscriminatorMember discriminator_Union_ULong = TypeObjectUtils::build_complete_discriminator_member(common_Union_ULong,
                type_ann_builtin_Union_ULong, ann_custom_Union_ULong);
        CompleteUnionMemberSeq member_seq_Union_ULong;
        {
            return_code_Union_ULong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_Union_ULong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_ULong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "d Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_d = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_d;
            TypeObjectUtils::add_union_case_label(label_seq_d, static_cast<int32_t>(3));
            MemberId member_id_d = 0x00000001;
            bool common_d_ec {false};
            CommonUnionMember common_d {TypeObjectUtils::build_common_union_member(member_id_d,
                    member_flags_d, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_ULong,
                        common_d_ec), label_seq_d)};
            if (!common_d_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union d member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_d = "d";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_d;
            ann_custom_Union_ULong.reset();
            CompleteMemberDetail detail_d = TypeObjectUtils::build_complete_member_detail(name_d, member_ann_builtin_d, ann_custom_Union_ULong);
            CompleteUnionMember member_d = TypeObjectUtils::build_complete_union_member(common_d, detail_d);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_ULong, member_d);
        }
        CompleteUnionType union_type_Union_ULong = TypeObjectUtils::build_complete_union_type(union_flags_Union_ULong, header_Union_ULong, discriminator_Union_ULong,
                member_seq_Union_ULong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_ULong, type_name_Union_ULong.to_string(), type_ids_Union_ULong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_ULong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_LongLong_type_identifier(
        TypeIdentifierPair& type_ids_Union_LongLong)
{
    ReturnCode_t return_code_Union_LongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_LongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_LongLong", type_ids_Union_LongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_LongLong)
    {
        UnionTypeFlag union_flags_Union_LongLong = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_LongLong = "Union_LongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_LongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_LongLong;
        CompleteTypeDetail detail_Union_LongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_LongLong, ann_custom_Union_LongLong, type_name_Union_LongLong.to_string());
        CompleteUnionHeader header_Union_LongLong = TypeObjectUtils::build_complete_union_header(detail_Union_LongLong);
        UnionDiscriminatorFlag member_flags_Union_LongLong = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_LongLong =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_LongLong);

        if (return_code_Union_LongLong != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_LongLong;
        if (EK_COMPLETE == type_ids_Union_LongLong.type_identifier1()._d() || TK_NONE == type_ids_Union_LongLong.type_identifier2()._d())
        {
            common_Union_LongLong = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_LongLong, type_ids_Union_LongLong.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_LongLong.type_identifier2()._d())
        {
            common_Union_LongLong = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_LongLong, type_ids_Union_LongLong.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_LongLong discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_LongLong.reset();
        ann_custom_Union_LongLong.reset();
        CompleteDiscriminatorMember discriminator_Union_LongLong = TypeObjectUtils::build_complete_discriminator_member(common_Union_LongLong,
                type_ann_builtin_Union_LongLong, ann_custom_Union_LongLong);
        CompleteUnionMemberSeq member_seq_Union_LongLong;
        {
            return_code_Union_LongLong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_Union_LongLong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_LongLong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "e Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_e = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_e;
            TypeObjectUtils::add_union_case_label(label_seq_e, static_cast<int32_t>(4));
            MemberId member_id_e = 0x00000001;
            bool common_e_ec {false};
            CommonUnionMember common_e {TypeObjectUtils::build_common_union_member(member_id_e,
                    member_flags_e, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_LongLong,
                        common_e_ec), label_seq_e)};
            if (!common_e_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union e member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_e = "e";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_e;
            ann_custom_Union_LongLong.reset();
            CompleteMemberDetail detail_e = TypeObjectUtils::build_complete_member_detail(name_e, member_ann_builtin_e, ann_custom_Union_LongLong);
            CompleteUnionMember member_e = TypeObjectUtils::build_complete_union_member(common_e, detail_e);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_LongLong, member_e);
        }
        CompleteUnionType union_type_Union_LongLong = TypeObjectUtils::build_complete_union_type(union_flags_Union_LongLong, header_Union_LongLong, discriminator_Union_LongLong,
                member_seq_Union_LongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_LongLong, type_name_Union_LongLong.to_string(), type_ids_Union_LongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_LongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_ULongLOng_type_identifier(
        TypeIdentifierPair& type_ids_Union_ULongLOng)
{
    ReturnCode_t return_code_Union_ULongLOng {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_ULongLOng =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_ULongLOng", type_ids_Union_ULongLOng);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_ULongLOng)
    {
        UnionTypeFlag union_flags_Union_ULongLOng = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_ULongLOng = "Union_ULongLOng";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_ULongLOng;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_ULongLOng;
        CompleteTypeDetail detail_Union_ULongLOng = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_ULongLOng, ann_custom_Union_ULongLOng, type_name_Union_ULongLOng.to_string());
        CompleteUnionHeader header_Union_ULongLOng = TypeObjectUtils::build_complete_union_header(detail_Union_ULongLOng);
        UnionDiscriminatorFlag member_flags_Union_ULongLOng = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_ULongLOng =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_ULongLOng);

        if (return_code_Union_ULongLOng != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_ULongLOng;
        if (EK_COMPLETE == type_ids_Union_ULongLOng.type_identifier1()._d() || TK_NONE == type_ids_Union_ULongLOng.type_identifier2()._d())
        {
            common_Union_ULongLOng = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_ULongLOng, type_ids_Union_ULongLOng.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_ULongLOng.type_identifier2()._d())
        {
            common_Union_ULongLOng = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_ULongLOng, type_ids_Union_ULongLOng.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_ULongLOng discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_ULongLOng.reset();
        ann_custom_Union_ULongLOng.reset();
        CompleteDiscriminatorMember discriminator_Union_ULongLOng = TypeObjectUtils::build_complete_discriminator_member(common_Union_ULongLOng,
                type_ann_builtin_Union_ULongLOng, ann_custom_Union_ULongLOng);
        CompleteUnionMemberSeq member_seq_Union_ULongLOng;
        {
            return_code_Union_ULongLOng =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_Union_ULongLOng);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_ULongLOng)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "f Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_f = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_f;
            TypeObjectUtils::add_union_case_label(label_seq_f, static_cast<int32_t>(5));
            MemberId member_id_f = 0x00000001;
            bool common_f_ec {false};
            CommonUnionMember common_f {TypeObjectUtils::build_common_union_member(member_id_f,
                    member_flags_f, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_ULongLOng,
                        common_f_ec), label_seq_f)};
            if (!common_f_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union f member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_f = "f";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_f;
            ann_custom_Union_ULongLOng.reset();
            CompleteMemberDetail detail_f = TypeObjectUtils::build_complete_member_detail(name_f, member_ann_builtin_f, ann_custom_Union_ULongLOng);
            CompleteUnionMember member_f = TypeObjectUtils::build_complete_union_member(common_f, detail_f);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_ULongLOng, member_f);
        }
        CompleteUnionType union_type_Union_ULongLOng = TypeObjectUtils::build_complete_union_type(union_flags_Union_ULongLOng, header_Union_ULongLOng, discriminator_Union_ULongLOng,
                member_seq_Union_ULongLOng);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_ULongLOng, type_name_Union_ULongLOng.to_string(), type_ids_Union_ULongLOng))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_ULongLOng already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Float_type_identifier(
        TypeIdentifierPair& type_ids_Union_Float)
{
    ReturnCode_t return_code_Union_Float {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Float =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Float", type_ids_Union_Float);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Float)
    {
        UnionTypeFlag union_flags_Union_Float = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Float = "Union_Float";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Float;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Float;
        CompleteTypeDetail detail_Union_Float = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Float, ann_custom_Union_Float, type_name_Union_Float.to_string());
        CompleteUnionHeader header_Union_Float = TypeObjectUtils::build_complete_union_header(detail_Union_Float);
        UnionDiscriminatorFlag member_flags_Union_Float = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Float =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_Float);

        if (return_code_Union_Float != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Float;
        if (EK_COMPLETE == type_ids_Union_Float.type_identifier1()._d() || TK_NONE == type_ids_Union_Float.type_identifier2()._d())
        {
            common_Union_Float = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Float, type_ids_Union_Float.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Float.type_identifier2()._d())
        {
            common_Union_Float = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Float, type_ids_Union_Float.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Float discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Float.reset();
        ann_custom_Union_Float.reset();
        CompleteDiscriminatorMember discriminator_Union_Float = TypeObjectUtils::build_complete_discriminator_member(common_Union_Float,
                type_ann_builtin_Union_Float, ann_custom_Union_Float);
        CompleteUnionMemberSeq member_seq_Union_Float;
        {
            return_code_Union_Float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_Union_Float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Float)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "g Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_g = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_g;
            TypeObjectUtils::add_union_case_label(label_seq_g, static_cast<int32_t>(6));
            MemberId member_id_g = 0x00000001;
            bool common_g_ec {false};
            CommonUnionMember common_g {TypeObjectUtils::build_common_union_member(member_id_g,
                    member_flags_g, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Float,
                        common_g_ec), label_seq_g)};
            if (!common_g_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union g member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_g = "g";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_g;
            ann_custom_Union_Float.reset();
            CompleteMemberDetail detail_g = TypeObjectUtils::build_complete_member_detail(name_g, member_ann_builtin_g, ann_custom_Union_Float);
            CompleteUnionMember member_g = TypeObjectUtils::build_complete_union_member(common_g, detail_g);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Float, member_g);
        }
        CompleteUnionType union_type_Union_Float = TypeObjectUtils::build_complete_union_type(union_flags_Union_Float, header_Union_Float, discriminator_Union_Float,
                member_seq_Union_Float);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Float, type_name_Union_Float.to_string(), type_ids_Union_Float))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Float already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Double_type_identifier(
        TypeIdentifierPair& type_ids_Union_Double)
{
    ReturnCode_t return_code_Union_Double {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Double =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Double", type_ids_Union_Double);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Double)
    {
        UnionTypeFlag union_flags_Union_Double = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Double = "Union_Double";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Double;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Double;
        CompleteTypeDetail detail_Union_Double = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Double, ann_custom_Union_Double, type_name_Union_Double.to_string());
        CompleteUnionHeader header_Union_Double = TypeObjectUtils::build_complete_union_header(detail_Union_Double);
        UnionDiscriminatorFlag member_flags_Union_Double = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Double =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_Double);

        if (return_code_Union_Double != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Double;
        if (EK_COMPLETE == type_ids_Union_Double.type_identifier1()._d() || TK_NONE == type_ids_Union_Double.type_identifier2()._d())
        {
            common_Union_Double = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Double, type_ids_Union_Double.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Double.type_identifier2()._d())
        {
            common_Union_Double = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Double, type_ids_Union_Double.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Double discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Double.reset();
        ann_custom_Union_Double.reset();
        CompleteDiscriminatorMember discriminator_Union_Double = TypeObjectUtils::build_complete_discriminator_member(common_Union_Double,
                type_ann_builtin_Union_Double, ann_custom_Union_Double);
        CompleteUnionMemberSeq member_seq_Union_Double;
        {
            return_code_Union_Double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_Union_Double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Double)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "h Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_h = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_h;
            TypeObjectUtils::add_union_case_label(label_seq_h, static_cast<int32_t>(7));
            MemberId member_id_h = 0x00000001;
            bool common_h_ec {false};
            CommonUnionMember common_h {TypeObjectUtils::build_common_union_member(member_id_h,
                    member_flags_h, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Double,
                        common_h_ec), label_seq_h)};
            if (!common_h_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union h member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_h = "h";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_h;
            ann_custom_Union_Double.reset();
            CompleteMemberDetail detail_h = TypeObjectUtils::build_complete_member_detail(name_h, member_ann_builtin_h, ann_custom_Union_Double);
            CompleteUnionMember member_h = TypeObjectUtils::build_complete_union_member(common_h, detail_h);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Double, member_h);
        }
        CompleteUnionType union_type_Union_Double = TypeObjectUtils::build_complete_union_type(union_flags_Union_Double, header_Union_Double, discriminator_Union_Double,
                member_seq_Union_Double);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Double, type_name_Union_Double.to_string(), type_ids_Union_Double))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Double already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_LongDouble_type_identifier(
        TypeIdentifierPair& type_ids_Union_LongDouble)
{
    ReturnCode_t return_code_Union_LongDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_LongDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_LongDouble", type_ids_Union_LongDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_LongDouble)
    {
        UnionTypeFlag union_flags_Union_LongDouble = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_LongDouble = "Union_LongDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_LongDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_LongDouble;
        CompleteTypeDetail detail_Union_LongDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_LongDouble, ann_custom_Union_LongDouble, type_name_Union_LongDouble.to_string());
        CompleteUnionHeader header_Union_LongDouble = TypeObjectUtils::build_complete_union_header(detail_Union_LongDouble);
        UnionDiscriminatorFlag member_flags_Union_LongDouble = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_LongDouble =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_LongDouble);

        if (return_code_Union_LongDouble != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_LongDouble;
        if (EK_COMPLETE == type_ids_Union_LongDouble.type_identifier1()._d() || TK_NONE == type_ids_Union_LongDouble.type_identifier2()._d())
        {
            common_Union_LongDouble = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_LongDouble, type_ids_Union_LongDouble.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_LongDouble.type_identifier2()._d())
        {
            common_Union_LongDouble = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_LongDouble, type_ids_Union_LongDouble.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_LongDouble discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_LongDouble.reset();
        ann_custom_Union_LongDouble.reset();
        CompleteDiscriminatorMember discriminator_Union_LongDouble = TypeObjectUtils::build_complete_discriminator_member(common_Union_LongDouble,
                type_ann_builtin_Union_LongDouble, ann_custom_Union_LongDouble);
        CompleteUnionMemberSeq member_seq_Union_LongDouble;
        {
            return_code_Union_LongDouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_Union_LongDouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_LongDouble)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "i Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_i = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_i;
            TypeObjectUtils::add_union_case_label(label_seq_i, static_cast<int32_t>(8));
            MemberId member_id_i = 0x00000001;
            bool common_i_ec {false};
            CommonUnionMember common_i {TypeObjectUtils::build_common_union_member(member_id_i,
                    member_flags_i, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_LongDouble,
                        common_i_ec), label_seq_i)};
            if (!common_i_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union i member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_i = "i";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_i;
            ann_custom_Union_LongDouble.reset();
            CompleteMemberDetail detail_i = TypeObjectUtils::build_complete_member_detail(name_i, member_ann_builtin_i, ann_custom_Union_LongDouble);
            CompleteUnionMember member_i = TypeObjectUtils::build_complete_union_member(common_i, detail_i);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_LongDouble, member_i);
        }
        CompleteUnionType union_type_Union_LongDouble = TypeObjectUtils::build_complete_union_type(union_flags_Union_LongDouble, header_Union_LongDouble, discriminator_Union_LongDouble,
                member_seq_Union_LongDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_LongDouble, type_name_Union_LongDouble.to_string(), type_ids_Union_LongDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_LongDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Boolean_type_identifier(
        TypeIdentifierPair& type_ids_Union_Boolean)
{
    ReturnCode_t return_code_Union_Boolean {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Boolean =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Boolean", type_ids_Union_Boolean);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Boolean)
    {
        UnionTypeFlag union_flags_Union_Boolean = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Boolean = "Union_Boolean";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Boolean;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Boolean;
        CompleteTypeDetail detail_Union_Boolean = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Boolean, ann_custom_Union_Boolean, type_name_Union_Boolean.to_string());
        CompleteUnionHeader header_Union_Boolean = TypeObjectUtils::build_complete_union_header(detail_Union_Boolean);
        UnionDiscriminatorFlag member_flags_Union_Boolean = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Boolean =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_Boolean);

        if (return_code_Union_Boolean != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Boolean;
        if (EK_COMPLETE == type_ids_Union_Boolean.type_identifier1()._d() || TK_NONE == type_ids_Union_Boolean.type_identifier2()._d())
        {
            common_Union_Boolean = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Boolean, type_ids_Union_Boolean.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Boolean.type_identifier2()._d())
        {
            common_Union_Boolean = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Boolean, type_ids_Union_Boolean.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Boolean discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Boolean.reset();
        ann_custom_Union_Boolean.reset();
        CompleteDiscriminatorMember discriminator_Union_Boolean = TypeObjectUtils::build_complete_discriminator_member(common_Union_Boolean,
                type_ann_builtin_Union_Boolean, ann_custom_Union_Boolean);
        CompleteUnionMemberSeq member_seq_Union_Boolean;
        {
            return_code_Union_Boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_Union_Boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Boolean)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "j Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_j = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_j;
            TypeObjectUtils::add_union_case_label(label_seq_j, static_cast<int32_t>(9));
            MemberId member_id_j = 0x00000001;
            bool common_j_ec {false};
            CommonUnionMember common_j {TypeObjectUtils::build_common_union_member(member_id_j,
                    member_flags_j, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Boolean,
                        common_j_ec), label_seq_j)};
            if (!common_j_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union j member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_j = "j";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_j;
            ann_custom_Union_Boolean.reset();
            CompleteMemberDetail detail_j = TypeObjectUtils::build_complete_member_detail(name_j, member_ann_builtin_j, ann_custom_Union_Boolean);
            CompleteUnionMember member_j = TypeObjectUtils::build_complete_union_member(common_j, detail_j);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Boolean, member_j);
        }
        CompleteUnionType union_type_Union_Boolean = TypeObjectUtils::build_complete_union_type(union_flags_Union_Boolean, header_Union_Boolean, discriminator_Union_Boolean,
                member_seq_Union_Boolean);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Boolean, type_name_Union_Boolean.to_string(), type_ids_Union_Boolean))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Boolean already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Octet_type_identifier(
        TypeIdentifierPair& type_ids_Union_Octet)
{
    ReturnCode_t return_code_Union_Octet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Octet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Octet", type_ids_Union_Octet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Octet)
    {
        UnionTypeFlag union_flags_Union_Octet = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Octet = "Union_Octet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Octet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Octet;
        CompleteTypeDetail detail_Union_Octet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Octet, ann_custom_Union_Octet, type_name_Union_Octet.to_string());
        CompleteUnionHeader header_Union_Octet = TypeObjectUtils::build_complete_union_header(detail_Union_Octet);
        UnionDiscriminatorFlag member_flags_Union_Octet = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Octet =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_Octet);

        if (return_code_Union_Octet != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Octet;
        if (EK_COMPLETE == type_ids_Union_Octet.type_identifier1()._d() || TK_NONE == type_ids_Union_Octet.type_identifier2()._d())
        {
            common_Union_Octet = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Octet, type_ids_Union_Octet.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Octet.type_identifier2()._d())
        {
            common_Union_Octet = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Octet, type_ids_Union_Octet.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Octet discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Octet.reset();
        ann_custom_Union_Octet.reset();
        CompleteDiscriminatorMember discriminator_Union_Octet = TypeObjectUtils::build_complete_discriminator_member(common_Union_Octet,
                type_ann_builtin_Union_Octet, ann_custom_Union_Octet);
        CompleteUnionMemberSeq member_seq_Union_Octet;
        {
            return_code_Union_Octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_Union_Octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Octet)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "k Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_k = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_k;
            TypeObjectUtils::add_union_case_label(label_seq_k, static_cast<int32_t>(10));
            MemberId member_id_k = 0x00000001;
            bool common_k_ec {false};
            CommonUnionMember common_k {TypeObjectUtils::build_common_union_member(member_id_k,
                    member_flags_k, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Octet,
                        common_k_ec), label_seq_k)};
            if (!common_k_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union k member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_k = "k";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_k;
            ann_custom_Union_Octet.reset();
            CompleteMemberDetail detail_k = TypeObjectUtils::build_complete_member_detail(name_k, member_ann_builtin_k, ann_custom_Union_Octet);
            CompleteUnionMember member_k = TypeObjectUtils::build_complete_union_member(common_k, detail_k);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Octet, member_k);
        }
        CompleteUnionType union_type_Union_Octet = TypeObjectUtils::build_complete_union_type(union_flags_Union_Octet, header_Union_Octet, discriminator_Union_Octet,
                member_seq_Union_Octet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Octet, type_name_Union_Octet.to_string(), type_ids_Union_Octet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Octet already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Char_type_identifier(
        TypeIdentifierPair& type_ids_Union_Char)
{
    ReturnCode_t return_code_Union_Char {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Char =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Char", type_ids_Union_Char);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Char)
    {
        UnionTypeFlag union_flags_Union_Char = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Char = "Union_Char";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Char;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Char;
        CompleteTypeDetail detail_Union_Char = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Char, ann_custom_Union_Char, type_name_Union_Char.to_string());
        CompleteUnionHeader header_Union_Char = TypeObjectUtils::build_complete_union_header(detail_Union_Char);
        UnionDiscriminatorFlag member_flags_Union_Char = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Char =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_Char);

        if (return_code_Union_Char != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Char;
        if (EK_COMPLETE == type_ids_Union_Char.type_identifier1()._d() || TK_NONE == type_ids_Union_Char.type_identifier2()._d())
        {
            common_Union_Char = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Char, type_ids_Union_Char.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Char.type_identifier2()._d())
        {
            common_Union_Char = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Char, type_ids_Union_Char.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Char discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Char.reset();
        ann_custom_Union_Char.reset();
        CompleteDiscriminatorMember discriminator_Union_Char = TypeObjectUtils::build_complete_discriminator_member(common_Union_Char,
                type_ann_builtin_Union_Char, ann_custom_Union_Char);
        CompleteUnionMemberSeq member_seq_Union_Char;
        {
            return_code_Union_Char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_Union_Char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Char)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "l Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_l = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_l;
            TypeObjectUtils::add_union_case_label(label_seq_l, static_cast<int32_t>(11));
            MemberId member_id_l = 0x00000001;
            bool common_l_ec {false};
            CommonUnionMember common_l {TypeObjectUtils::build_common_union_member(member_id_l,
                    member_flags_l, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Char,
                        common_l_ec), label_seq_l)};
            if (!common_l_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union l member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_l = "l";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_l;
            ann_custom_Union_Char.reset();
            CompleteMemberDetail detail_l = TypeObjectUtils::build_complete_member_detail(name_l, member_ann_builtin_l, ann_custom_Union_Char);
            CompleteUnionMember member_l = TypeObjectUtils::build_complete_union_member(common_l, detail_l);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Char, member_l);
        }
        CompleteUnionType union_type_Union_Char = TypeObjectUtils::build_complete_union_type(union_flags_Union_Char, header_Union_Char, discriminator_Union_Char,
                member_seq_Union_Char);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Char, type_name_Union_Char.to_string(), type_ids_Union_Char))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Char already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_WChar_type_identifier(
        TypeIdentifierPair& type_ids_Union_WChar)
{
    ReturnCode_t return_code_Union_WChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_WChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_WChar", type_ids_Union_WChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_WChar)
    {
        UnionTypeFlag union_flags_Union_WChar = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_WChar = "Union_WChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_WChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_WChar;
        CompleteTypeDetail detail_Union_WChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_WChar, ann_custom_Union_WChar, type_name_Union_WChar.to_string());
        CompleteUnionHeader header_Union_WChar = TypeObjectUtils::build_complete_union_header(detail_Union_WChar);
        UnionDiscriminatorFlag member_flags_Union_WChar = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_WChar =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_WChar);

        if (return_code_Union_WChar != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_WChar;
        if (EK_COMPLETE == type_ids_Union_WChar.type_identifier1()._d() || TK_NONE == type_ids_Union_WChar.type_identifier2()._d())
        {
            common_Union_WChar = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_WChar, type_ids_Union_WChar.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_WChar.type_identifier2()._d())
        {
            common_Union_WChar = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_WChar, type_ids_Union_WChar.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_WChar discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_WChar.reset();
        ann_custom_Union_WChar.reset();
        CompleteDiscriminatorMember discriminator_Union_WChar = TypeObjectUtils::build_complete_discriminator_member(common_Union_WChar,
                type_ann_builtin_Union_WChar, ann_custom_Union_WChar);
        CompleteUnionMemberSeq member_seq_Union_WChar;
        {
            return_code_Union_WChar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_Union_WChar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_WChar)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "m Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_m = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_m;
            TypeObjectUtils::add_union_case_label(label_seq_m, static_cast<int32_t>(12));
            MemberId member_id_m = 0x00000001;
            bool common_m_ec {false};
            CommonUnionMember common_m {TypeObjectUtils::build_common_union_member(member_id_m,
                    member_flags_m, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_WChar,
                        common_m_ec), label_seq_m)};
            if (!common_m_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union m member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_m = "m";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_m;
            ann_custom_Union_WChar.reset();
            CompleteMemberDetail detail_m = TypeObjectUtils::build_complete_member_detail(name_m, member_ann_builtin_m, ann_custom_Union_WChar);
            CompleteUnionMember member_m = TypeObjectUtils::build_complete_union_member(common_m, detail_m);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_WChar, member_m);
        }
        CompleteUnionType union_type_Union_WChar = TypeObjectUtils::build_complete_union_type(union_flags_Union_WChar, header_Union_WChar, discriminator_Union_WChar,
                member_seq_Union_WChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_WChar, type_name_Union_WChar.to_string(), type_ids_Union_WChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_WChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_String_type_identifier(
        TypeIdentifierPair& type_ids_Union_String)
{
    ReturnCode_t return_code_Union_String {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_String =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_String", type_ids_Union_String);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_String)
    {
        UnionTypeFlag union_flags_Union_String = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_String = "Union_String";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_String;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_String;
        CompleteTypeDetail detail_Union_String = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_String, ann_custom_Union_String, type_name_Union_String.to_string());
        CompleteUnionHeader header_Union_String = TypeObjectUtils::build_complete_union_header(detail_Union_String);
        UnionDiscriminatorFlag member_flags_Union_String = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_String =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_String);

        if (return_code_Union_String != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_String;
        if (EK_COMPLETE == type_ids_Union_String.type_identifier1()._d() || TK_NONE == type_ids_Union_String.type_identifier2()._d())
        {
            common_Union_String = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_String, type_ids_Union_String.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_String.type_identifier2()._d())
        {
            common_Union_String = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_String, type_ids_Union_String.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_String discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_String.reset();
        ann_custom_Union_String.reset();
        CompleteDiscriminatorMember discriminator_Union_String = TypeObjectUtils::build_complete_discriminator_member(common_Union_String,
                type_ann_builtin_Union_String, ann_custom_Union_String);
        CompleteUnionMemberSeq member_seq_Union_String;
        {
            return_code_Union_String =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_Union_String);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_String)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_Union_String))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            UnionMemberFlag member_flags_n = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_n;
            TypeObjectUtils::add_union_case_label(label_seq_n, static_cast<int32_t>(13));
            MemberId member_id_n = 0x00000001;
            bool common_n_ec {false};
            CommonUnionMember common_n {TypeObjectUtils::build_common_union_member(member_id_n,
                    member_flags_n, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_String,
                        common_n_ec), label_seq_n)};
            if (!common_n_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union n member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_n = "n";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_n;
            ann_custom_Union_String.reset();
            CompleteMemberDetail detail_n = TypeObjectUtils::build_complete_member_detail(name_n, member_ann_builtin_n, ann_custom_Union_String);
            CompleteUnionMember member_n = TypeObjectUtils::build_complete_union_member(common_n, detail_n);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_String, member_n);
        }
        CompleteUnionType union_type_Union_String = TypeObjectUtils::build_complete_union_type(union_flags_Union_String, header_Union_String, discriminator_Union_String,
                member_seq_Union_String);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_String, type_name_Union_String.to_string(), type_ids_Union_String))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_String already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_WString_type_identifier(
        TypeIdentifierPair& type_ids_Union_WString)
{
    ReturnCode_t return_code_Union_WString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_WString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_WString", type_ids_Union_WString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_WString)
    {
        UnionTypeFlag union_flags_Union_WString = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_WString = "Union_WString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_WString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_WString;
        CompleteTypeDetail detail_Union_WString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_WString, ann_custom_Union_WString, type_name_Union_WString.to_string());
        CompleteUnionHeader header_Union_WString = TypeObjectUtils::build_complete_union_header(detail_Union_WString);
        UnionDiscriminatorFlag member_flags_Union_WString = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_WString =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_WString);

        if (return_code_Union_WString != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_WString;
        if (EK_COMPLETE == type_ids_Union_WString.type_identifier1()._d() || TK_NONE == type_ids_Union_WString.type_identifier2()._d())
        {
            common_Union_WString = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_WString, type_ids_Union_WString.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_WString.type_identifier2()._d())
        {
            common_Union_WString = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_WString, type_ids_Union_WString.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_WString discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_WString.reset();
        ann_custom_Union_WString.reset();
        CompleteDiscriminatorMember discriminator_Union_WString = TypeObjectUtils::build_complete_discriminator_member(common_Union_WString,
                type_ann_builtin_Union_WString, ann_custom_Union_WString);
        CompleteUnionMemberSeq member_seq_Union_WString;
        {
            return_code_Union_WString =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_wstring_unbounded", type_ids_Union_WString);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_WString)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_wstring_unbounded", type_ids_Union_WString, true))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            UnionMemberFlag member_flags_o = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_o;
            TypeObjectUtils::add_union_case_label(label_seq_o, static_cast<int32_t>(14));
            MemberId member_id_o = 0x00000001;
            bool common_o_ec {false};
            CommonUnionMember common_o {TypeObjectUtils::build_common_union_member(member_id_o,
                    member_flags_o, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_WString,
                        common_o_ec), label_seq_o)};
            if (!common_o_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union o member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_o = "o";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_o;
            ann_custom_Union_WString.reset();
            CompleteMemberDetail detail_o = TypeObjectUtils::build_complete_member_detail(name_o, member_ann_builtin_o, ann_custom_Union_WString);
            CompleteUnionMember member_o = TypeObjectUtils::build_complete_union_member(common_o, detail_o);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_WString, member_o);
        }
        CompleteUnionType union_type_Union_WString = TypeObjectUtils::build_complete_union_type(union_flags_Union_WString, header_Union_WString, discriminator_Union_WString,
                member_seq_Union_WString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_WString, type_name_Union_WString.to_string(), type_ids_Union_WString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_WString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_BoundedString_type_identifier(
        TypeIdentifierPair& type_ids_Union_BoundedString)
{
    ReturnCode_t return_code_Union_BoundedString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_BoundedString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_BoundedString", type_ids_Union_BoundedString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_BoundedString)
    {
        UnionTypeFlag union_flags_Union_BoundedString = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_BoundedString = "Union_BoundedString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_BoundedString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_BoundedString;
        CompleteTypeDetail detail_Union_BoundedString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_BoundedString, ann_custom_Union_BoundedString, type_name_Union_BoundedString.to_string());
        CompleteUnionHeader header_Union_BoundedString = TypeObjectUtils::build_complete_union_header(detail_Union_BoundedString);
        UnionDiscriminatorFlag member_flags_Union_BoundedString = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_BoundedString =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_BoundedString);

        if (return_code_Union_BoundedString != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_BoundedString;
        if (EK_COMPLETE == type_ids_Union_BoundedString.type_identifier1()._d() || TK_NONE == type_ids_Union_BoundedString.type_identifier2()._d())
        {
            common_Union_BoundedString = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_BoundedString, type_ids_Union_BoundedString.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_BoundedString.type_identifier2()._d())
        {
            common_Union_BoundedString = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_BoundedString, type_ids_Union_BoundedString.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_BoundedString discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_BoundedString.reset();
        ann_custom_Union_BoundedString.reset();
        CompleteDiscriminatorMember discriminator_Union_BoundedString = TypeObjectUtils::build_complete_discriminator_member(common_Union_BoundedString,
                type_ann_builtin_Union_BoundedString, ann_custom_Union_BoundedString);
        CompleteUnionMemberSeq member_seq_Union_BoundedString;
        {
            return_code_Union_BoundedString =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Inner_alias_bounded_string_helper", type_ids_Union_BoundedString);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_BoundedString)
            {
            ::register_Inner_alias_bounded_string_helper_type_identifier(type_ids_Union_BoundedString);
            }
            UnionMemberFlag member_flags_bn = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_bn;
            TypeObjectUtils::add_union_case_label(label_seq_bn, static_cast<int32_t>(13));
            MemberId member_id_bn = 0x00000001;
            bool common_bn_ec {false};
            CommonUnionMember common_bn {TypeObjectUtils::build_common_union_member(member_id_bn,
                    member_flags_bn, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_BoundedString,
                        common_bn_ec), label_seq_bn)};
            if (!common_bn_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union bn member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bn = "bn";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bn;
            ann_custom_Union_BoundedString.reset();
            CompleteMemberDetail detail_bn = TypeObjectUtils::build_complete_member_detail(name_bn, member_ann_builtin_bn, ann_custom_Union_BoundedString);
            CompleteUnionMember member_bn = TypeObjectUtils::build_complete_union_member(common_bn, detail_bn);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_BoundedString, member_bn);
        }
        CompleteUnionType union_type_Union_BoundedString = TypeObjectUtils::build_complete_union_type(union_flags_Union_BoundedString, header_Union_BoundedString, discriminator_Union_BoundedString,
                member_seq_Union_BoundedString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_BoundedString, type_name_Union_BoundedString.to_string(), type_ids_Union_BoundedString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_BoundedString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_BoundedWString_type_identifier(
        TypeIdentifierPair& type_ids_Union_BoundedWString)
{
    ReturnCode_t return_code_Union_BoundedWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_BoundedWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_BoundedWString", type_ids_Union_BoundedWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_BoundedWString)
    {
        UnionTypeFlag union_flags_Union_BoundedWString = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_BoundedWString = "Union_BoundedWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_BoundedWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_BoundedWString;
        CompleteTypeDetail detail_Union_BoundedWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_BoundedWString, ann_custom_Union_BoundedWString, type_name_Union_BoundedWString.to_string());
        CompleteUnionHeader header_Union_BoundedWString = TypeObjectUtils::build_complete_union_header(detail_Union_BoundedWString);
        UnionDiscriminatorFlag member_flags_Union_BoundedWString = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_BoundedWString =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_BoundedWString);

        if (return_code_Union_BoundedWString != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_BoundedWString;
        if (EK_COMPLETE == type_ids_Union_BoundedWString.type_identifier1()._d() || TK_NONE == type_ids_Union_BoundedWString.type_identifier2()._d())
        {
            common_Union_BoundedWString = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_BoundedWString, type_ids_Union_BoundedWString.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_BoundedWString.type_identifier2()._d())
        {
            common_Union_BoundedWString = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_BoundedWString, type_ids_Union_BoundedWString.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_BoundedWString discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_BoundedWString.reset();
        ann_custom_Union_BoundedWString.reset();
        CompleteDiscriminatorMember discriminator_Union_BoundedWString = TypeObjectUtils::build_complete_discriminator_member(common_Union_BoundedWString,
                type_ann_builtin_Union_BoundedWString, ann_custom_Union_BoundedWString);
        CompleteUnionMemberSeq member_seq_Union_BoundedWString;
        {
            return_code_Union_BoundedWString =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Inner_alias_bounded_wstring_helper", type_ids_Union_BoundedWString);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_BoundedWString)
            {
            ::register_Inner_alias_bounded_wstring_helper_type_identifier(type_ids_Union_BoundedWString);
            }
            UnionMemberFlag member_flags_bo = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_bo;
            TypeObjectUtils::add_union_case_label(label_seq_bo, static_cast<int32_t>(14));
            MemberId member_id_bo = 0x00000001;
            bool common_bo_ec {false};
            CommonUnionMember common_bo {TypeObjectUtils::build_common_union_member(member_id_bo,
                    member_flags_bo, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_BoundedWString,
                        common_bo_ec), label_seq_bo)};
            if (!common_bo_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union bo member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bo = "bo";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bo;
            ann_custom_Union_BoundedWString.reset();
            CompleteMemberDetail detail_bo = TypeObjectUtils::build_complete_member_detail(name_bo, member_ann_builtin_bo, ann_custom_Union_BoundedWString);
            CompleteUnionMember member_bo = TypeObjectUtils::build_complete_union_member(common_bo, detail_bo);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_BoundedWString, member_bo);
        }
        CompleteUnionType union_type_Union_BoundedWString = TypeObjectUtils::build_complete_union_type(union_flags_Union_BoundedWString, header_Union_BoundedWString, discriminator_Union_BoundedWString,
                member_seq_Union_BoundedWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_BoundedWString, type_name_Union_BoundedWString.to_string(), type_ids_Union_BoundedWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_BoundedWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_InnerEnumHelper_type_identifier(
        TypeIdentifierPair& type_ids_Union_InnerEnumHelper)
{
    ReturnCode_t return_code_Union_InnerEnumHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_InnerEnumHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_InnerEnumHelper", type_ids_Union_InnerEnumHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_InnerEnumHelper)
    {
        UnionTypeFlag union_flags_Union_InnerEnumHelper = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_InnerEnumHelper = "Union_InnerEnumHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_InnerEnumHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_InnerEnumHelper;
        CompleteTypeDetail detail_Union_InnerEnumHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_InnerEnumHelper, ann_custom_Union_InnerEnumHelper, type_name_Union_InnerEnumHelper.to_string());
        CompleteUnionHeader header_Union_InnerEnumHelper = TypeObjectUtils::build_complete_union_header(detail_Union_InnerEnumHelper);
        UnionDiscriminatorFlag member_flags_Union_InnerEnumHelper = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_InnerEnumHelper =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_InnerEnumHelper);

        if (return_code_Union_InnerEnumHelper != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_InnerEnumHelper;
        if (EK_COMPLETE == type_ids_Union_InnerEnumHelper.type_identifier1()._d() || TK_NONE == type_ids_Union_InnerEnumHelper.type_identifier2()._d())
        {
            common_Union_InnerEnumHelper = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_InnerEnumHelper, type_ids_Union_InnerEnumHelper.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_InnerEnumHelper.type_identifier2()._d())
        {
            common_Union_InnerEnumHelper = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_InnerEnumHelper, type_ids_Union_InnerEnumHelper.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_InnerEnumHelper discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_InnerEnumHelper.reset();
        ann_custom_Union_InnerEnumHelper.reset();
        CompleteDiscriminatorMember discriminator_Union_InnerEnumHelper = TypeObjectUtils::build_complete_discriminator_member(common_Union_InnerEnumHelper,
                type_ann_builtin_Union_InnerEnumHelper, ann_custom_Union_InnerEnumHelper);
        CompleteUnionMemberSeq member_seq_Union_InnerEnumHelper;
        {
            return_code_Union_InnerEnumHelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerEnumHelper", type_ids_Union_InnerEnumHelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_InnerEnumHelper)
            {
            ::register_InnerEnumHelper_type_identifier(type_ids_Union_InnerEnumHelper);
            }
            UnionMemberFlag member_flags_p = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_p;
            TypeObjectUtils::add_union_case_label(label_seq_p, static_cast<int32_t>(15));
            MemberId member_id_p = 0x00000001;
            bool common_p_ec {false};
            CommonUnionMember common_p {TypeObjectUtils::build_common_union_member(member_id_p,
                    member_flags_p, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_InnerEnumHelper,
                        common_p_ec), label_seq_p)};
            if (!common_p_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union p member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_p = "p";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_p;
            ann_custom_Union_InnerEnumHelper.reset();
            CompleteMemberDetail detail_p = TypeObjectUtils::build_complete_member_detail(name_p, member_ann_builtin_p, ann_custom_Union_InnerEnumHelper);
            CompleteUnionMember member_p = TypeObjectUtils::build_complete_union_member(common_p, detail_p);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_InnerEnumHelper, member_p);
        }
        CompleteUnionType union_type_Union_InnerEnumHelper = TypeObjectUtils::build_complete_union_type(union_flags_Union_InnerEnumHelper, header_Union_InnerEnumHelper, discriminator_Union_InnerEnumHelper,
                member_seq_Union_InnerEnumHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_InnerEnumHelper, type_name_Union_InnerEnumHelper.to_string(), type_ids_Union_InnerEnumHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_InnerEnumHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_InnerBitMaskHelper_type_identifier(
        TypeIdentifierPair& type_ids_Union_InnerBitMaskHelper)
{
    ReturnCode_t return_code_Union_InnerBitMaskHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_InnerBitMaskHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_InnerBitMaskHelper", type_ids_Union_InnerBitMaskHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_InnerBitMaskHelper)
    {
        UnionTypeFlag union_flags_Union_InnerBitMaskHelper = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_InnerBitMaskHelper = "Union_InnerBitMaskHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_InnerBitMaskHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_InnerBitMaskHelper;
        CompleteTypeDetail detail_Union_InnerBitMaskHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_InnerBitMaskHelper, ann_custom_Union_InnerBitMaskHelper, type_name_Union_InnerBitMaskHelper.to_string());
        CompleteUnionHeader header_Union_InnerBitMaskHelper = TypeObjectUtils::build_complete_union_header(detail_Union_InnerBitMaskHelper);
        UnionDiscriminatorFlag member_flags_Union_InnerBitMaskHelper = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_InnerBitMaskHelper =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_InnerBitMaskHelper);

        if (return_code_Union_InnerBitMaskHelper != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_InnerBitMaskHelper;
        if (EK_COMPLETE == type_ids_Union_InnerBitMaskHelper.type_identifier1()._d() || TK_NONE == type_ids_Union_InnerBitMaskHelper.type_identifier2()._d())
        {
            common_Union_InnerBitMaskHelper = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_InnerBitMaskHelper, type_ids_Union_InnerBitMaskHelper.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_InnerBitMaskHelper.type_identifier2()._d())
        {
            common_Union_InnerBitMaskHelper = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_InnerBitMaskHelper, type_ids_Union_InnerBitMaskHelper.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_InnerBitMaskHelper discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_InnerBitMaskHelper.reset();
        ann_custom_Union_InnerBitMaskHelper.reset();
        CompleteDiscriminatorMember discriminator_Union_InnerBitMaskHelper = TypeObjectUtils::build_complete_discriminator_member(common_Union_InnerBitMaskHelper,
                type_ann_builtin_Union_InnerBitMaskHelper, ann_custom_Union_InnerBitMaskHelper);
        CompleteUnionMemberSeq member_seq_Union_InnerBitMaskHelper;
        {
            return_code_Union_InnerBitMaskHelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerBitMaskHelper", type_ids_Union_InnerBitMaskHelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_InnerBitMaskHelper)
            {
            ::register_InnerBitMaskHelper_type_identifier(type_ids_Union_InnerBitMaskHelper);
            }
            UnionMemberFlag member_flags_q = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_q;
            TypeObjectUtils::add_union_case_label(label_seq_q, static_cast<int32_t>(16));
            MemberId member_id_q = 0x00000001;
            bool common_q_ec {false};
            CommonUnionMember common_q {TypeObjectUtils::build_common_union_member(member_id_q,
                    member_flags_q, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_InnerBitMaskHelper,
                        common_q_ec), label_seq_q)};
            if (!common_q_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union q member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_q = "q";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_q;
            ann_custom_Union_InnerBitMaskHelper.reset();
            CompleteMemberDetail detail_q = TypeObjectUtils::build_complete_member_detail(name_q, member_ann_builtin_q, ann_custom_Union_InnerBitMaskHelper);
            CompleteUnionMember member_q = TypeObjectUtils::build_complete_union_member(common_q, detail_q);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_InnerBitMaskHelper, member_q);
        }
        CompleteUnionType union_type_Union_InnerBitMaskHelper = TypeObjectUtils::build_complete_union_type(union_flags_Union_InnerBitMaskHelper, header_Union_InnerBitMaskHelper, discriminator_Union_InnerBitMaskHelper,
                member_seq_Union_InnerBitMaskHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_InnerBitMaskHelper, type_name_Union_InnerBitMaskHelper.to_string(), type_ids_Union_InnerBitMaskHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_InnerBitMaskHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_InnerAliasHelper_type_identifier(
        TypeIdentifierPair& type_ids_Union_InnerAliasHelper)
{
    ReturnCode_t return_code_Union_InnerAliasHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_InnerAliasHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_InnerAliasHelper", type_ids_Union_InnerAliasHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_InnerAliasHelper)
    {
        UnionTypeFlag union_flags_Union_InnerAliasHelper = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_InnerAliasHelper = "Union_InnerAliasHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_InnerAliasHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_InnerAliasHelper;
        CompleteTypeDetail detail_Union_InnerAliasHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_InnerAliasHelper, ann_custom_Union_InnerAliasHelper, type_name_Union_InnerAliasHelper.to_string());
        CompleteUnionHeader header_Union_InnerAliasHelper = TypeObjectUtils::build_complete_union_header(detail_Union_InnerAliasHelper);
        UnionDiscriminatorFlag member_flags_Union_InnerAliasHelper = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_InnerAliasHelper =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_InnerAliasHelper);

        if (return_code_Union_InnerAliasHelper != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_InnerAliasHelper;
        if (EK_COMPLETE == type_ids_Union_InnerAliasHelper.type_identifier1()._d() || TK_NONE == type_ids_Union_InnerAliasHelper.type_identifier2()._d())
        {
            common_Union_InnerAliasHelper = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_InnerAliasHelper, type_ids_Union_InnerAliasHelper.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_InnerAliasHelper.type_identifier2()._d())
        {
            common_Union_InnerAliasHelper = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_InnerAliasHelper, type_ids_Union_InnerAliasHelper.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_InnerAliasHelper discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_InnerAliasHelper.reset();
        ann_custom_Union_InnerAliasHelper.reset();
        CompleteDiscriminatorMember discriminator_Union_InnerAliasHelper = TypeObjectUtils::build_complete_discriminator_member(common_Union_InnerAliasHelper,
                type_ann_builtin_Union_InnerAliasHelper, ann_custom_Union_InnerAliasHelper);
        CompleteUnionMemberSeq member_seq_Union_InnerAliasHelper;
        {
            return_code_Union_InnerAliasHelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerAliasHelper", type_ids_Union_InnerAliasHelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_InnerAliasHelper)
            {
            ::register_InnerAliasHelper_type_identifier(type_ids_Union_InnerAliasHelper);
            }
            UnionMemberFlag member_flags_r = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_r;
            TypeObjectUtils::add_union_case_label(label_seq_r, static_cast<int32_t>(17));
            MemberId member_id_r = 0x00000001;
            bool common_r_ec {false};
            CommonUnionMember common_r {TypeObjectUtils::build_common_union_member(member_id_r,
                    member_flags_r, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_InnerAliasHelper,
                        common_r_ec), label_seq_r)};
            if (!common_r_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union r member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_r = "r";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_r;
            ann_custom_Union_InnerAliasHelper.reset();
            CompleteMemberDetail detail_r = TypeObjectUtils::build_complete_member_detail(name_r, member_ann_builtin_r, ann_custom_Union_InnerAliasHelper);
            CompleteUnionMember member_r = TypeObjectUtils::build_complete_union_member(common_r, detail_r);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_InnerAliasHelper, member_r);
        }
        CompleteUnionType union_type_Union_InnerAliasHelper = TypeObjectUtils::build_complete_union_type(union_flags_Union_InnerAliasHelper, header_Union_InnerAliasHelper, discriminator_Union_InnerAliasHelper,
                member_seq_Union_InnerAliasHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_InnerAliasHelper, type_name_Union_InnerAliasHelper.to_string(), type_ids_Union_InnerAliasHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_InnerAliasHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Array_type_identifier(
        TypeIdentifierPair& type_ids_Union_Array)
{
    ReturnCode_t return_code_Union_Array {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Array =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Array", type_ids_Union_Array);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Array)
    {
        UnionTypeFlag union_flags_Union_Array = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Array = "Union_Array";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Array;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Array;
        CompleteTypeDetail detail_Union_Array = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Array, ann_custom_Union_Array, type_name_Union_Array.to_string());
        CompleteUnionHeader header_Union_Array = TypeObjectUtils::build_complete_union_header(detail_Union_Array);
        UnionDiscriminatorFlag member_flags_Union_Array = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Array =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_Array);

        if (return_code_Union_Array != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Array;
        if (EK_COMPLETE == type_ids_Union_Array.type_identifier1()._d() || TK_NONE == type_ids_Union_Array.type_identifier2()._d())
        {
            common_Union_Array = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Array, type_ids_Union_Array.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Array.type_identifier2()._d())
        {
            common_Union_Array = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Array, type_ids_Union_Array.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Array discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Array.reset();
        ann_custom_Union_Array.reset();
        CompleteDiscriminatorMember discriminator_Union_Array = TypeObjectUtils::build_complete_discriminator_member(common_Union_Array,
                type_ann_builtin_Union_Array, ann_custom_Union_Array);
        CompleteUnionMemberSeq member_seq_Union_Array;
        {
            return_code_Union_Array =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Inner_alias_array_helper", type_ids_Union_Array);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Array)
            {
            ::register_Inner_alias_array_helper_type_identifier(type_ids_Union_Array);
            }
            UnionMemberFlag member_flags_s = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_s;
            TypeObjectUtils::add_union_case_label(label_seq_s, static_cast<int32_t>(18));
            MemberId member_id_s = 0x00000001;
            bool common_s_ec {false};
            CommonUnionMember common_s {TypeObjectUtils::build_common_union_member(member_id_s,
                    member_flags_s, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Array,
                        common_s_ec), label_seq_s)};
            if (!common_s_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union s member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_s = "s";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_s;
            ann_custom_Union_Array.reset();
            CompleteMemberDetail detail_s = TypeObjectUtils::build_complete_member_detail(name_s, member_ann_builtin_s, ann_custom_Union_Array);
            CompleteUnionMember member_s = TypeObjectUtils::build_complete_union_member(common_s, detail_s);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Array, member_s);
        }
        CompleteUnionType union_type_Union_Array = TypeObjectUtils::build_complete_union_type(union_flags_Union_Array, header_Union_Array, discriminator_Union_Array,
                member_seq_Union_Array);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Array, type_name_Union_Array.to_string(), type_ids_Union_Array))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Array already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Sequence_type_identifier(
        TypeIdentifierPair& type_ids_Union_Sequence)
{
    ReturnCode_t return_code_Union_Sequence {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Sequence =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Sequence", type_ids_Union_Sequence);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Sequence)
    {
        UnionTypeFlag union_flags_Union_Sequence = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Sequence = "Union_Sequence";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Sequence;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Sequence;
        CompleteTypeDetail detail_Union_Sequence = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Sequence, ann_custom_Union_Sequence, type_name_Union_Sequence.to_string());
        CompleteUnionHeader header_Union_Sequence = TypeObjectUtils::build_complete_union_header(detail_Union_Sequence);
        UnionDiscriminatorFlag member_flags_Union_Sequence = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Sequence =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_Sequence);

        if (return_code_Union_Sequence != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Sequence;
        if (EK_COMPLETE == type_ids_Union_Sequence.type_identifier1()._d() || TK_NONE == type_ids_Union_Sequence.type_identifier2()._d())
        {
            common_Union_Sequence = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Sequence, type_ids_Union_Sequence.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Sequence.type_identifier2()._d())
        {
            common_Union_Sequence = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Sequence, type_ids_Union_Sequence.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Sequence discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Sequence.reset();
        ann_custom_Union_Sequence.reset();
        CompleteDiscriminatorMember discriminator_Union_Sequence = TypeObjectUtils::build_complete_discriminator_member(common_Union_Sequence,
                type_ann_builtin_Union_Sequence, ann_custom_Union_Sequence);
        CompleteUnionMemberSeq member_seq_Union_Sequence;
        {
            return_code_Union_Sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int16_t_unbounded", type_ids_Union_Sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Sequence)
            {
                return_code_Union_Sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_Union_Sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Sequence)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Sequence, element_identifier_anonymous_sequence_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int16_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_Union_Sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int16_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int16_t_unbounded, element_flags_anonymous_sequence_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int16_t_unbounded", type_ids_Union_Sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            UnionMemberFlag member_flags_t = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_t;
            TypeObjectUtils::add_union_case_label(label_seq_t, static_cast<int32_t>(19));
            MemberId member_id_t = 0x00000001;
            bool common_t_ec {false};
            CommonUnionMember common_t {TypeObjectUtils::build_common_union_member(member_id_t,
                    member_flags_t, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Sequence,
                        common_t_ec), label_seq_t)};
            if (!common_t_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union t member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_t = "t";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_t;
            ann_custom_Union_Sequence.reset();
            CompleteMemberDetail detail_t = TypeObjectUtils::build_complete_member_detail(name_t, member_ann_builtin_t, ann_custom_Union_Sequence);
            CompleteUnionMember member_t = TypeObjectUtils::build_complete_union_member(common_t, detail_t);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Sequence, member_t);
        }
        CompleteUnionType union_type_Union_Sequence = TypeObjectUtils::build_complete_union_type(union_flags_Union_Sequence, header_Union_Sequence, discriminator_Union_Sequence,
                member_seq_Union_Sequence);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Sequence, type_name_Union_Sequence.to_string(), type_ids_Union_Sequence))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Sequence already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Map_type_identifier(
        TypeIdentifierPair& type_ids_Union_Map)
{
    ReturnCode_t return_code_Union_Map {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Map =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Map", type_ids_Union_Map);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Map)
    {
        UnionTypeFlag union_flags_Union_Map = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Map = "Union_Map";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Map;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Map;
        CompleteTypeDetail detail_Union_Map = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Map, ann_custom_Union_Map, type_name_Union_Map.to_string());
        CompleteUnionHeader header_Union_Map = TypeObjectUtils::build_complete_union_header(detail_Union_Map);
        UnionDiscriminatorFlag member_flags_Union_Map = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Map =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_Map);

        if (return_code_Union_Map != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Map;
        if (EK_COMPLETE == type_ids_Union_Map.type_identifier1()._d() || TK_NONE == type_ids_Union_Map.type_identifier2()._d())
        {
            common_Union_Map = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Map, type_ids_Union_Map.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Map.type_identifier2()._d())
        {
            common_Union_Map = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Map, type_ids_Union_Map.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Map discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Map.reset();
        ann_custom_Union_Map.reset();
        CompleteDiscriminatorMember discriminator_Union_Map = TypeObjectUtils::build_complete_discriminator_member(common_Union_Map,
                type_ann_builtin_Union_Map, ann_custom_Union_Map);
        CompleteUnionMemberSeq member_seq_Union_Map;
        {
            return_code_Union_Map =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_int32_t_unbounded", type_ids_Union_Map);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Map)
            {
                return_code_Union_Map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_Union_Map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Map)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Map, element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int32_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_Union_Map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_Union_Map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Map)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Map, key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int32_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_int32_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_int32_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_int32_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_int32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_int32_t_unbounded, element_flags_anonymous_map_int32_t_int32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_int32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_int32_t_unbounded), key_flags_anonymous_map_int32_t_int32_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_int32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_int32_t_unbounded", type_ids_Union_Map))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            UnionMemberFlag member_flags_u = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_u;
            TypeObjectUtils::add_union_case_label(label_seq_u, static_cast<int32_t>(20));
            MemberId member_id_u = 0x00000001;
            bool common_u_ec {false};
            CommonUnionMember common_u {TypeObjectUtils::build_common_union_member(member_id_u,
                    member_flags_u, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Map,
                        common_u_ec), label_seq_u)};
            if (!common_u_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union u member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_u = "u";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_u;
            ann_custom_Union_Map.reset();
            CompleteMemberDetail detail_u = TypeObjectUtils::build_complete_member_detail(name_u, member_ann_builtin_u, ann_custom_Union_Map);
            CompleteUnionMember member_u = TypeObjectUtils::build_complete_union_member(common_u, detail_u);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Map, member_u);
        }
        CompleteUnionType union_type_Union_Map = TypeObjectUtils::build_complete_union_type(union_flags_Union_Map, header_Union_Map, discriminator_Union_Map,
                member_seq_Union_Map);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Map, type_name_Union_Map.to_string(), type_ids_Union_Map))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Map already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_InnerUnionHelper_type_identifier(
        TypeIdentifierPair& type_ids_Union_InnerUnionHelper)
{
    ReturnCode_t return_code_Union_InnerUnionHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_InnerUnionHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_InnerUnionHelper", type_ids_Union_InnerUnionHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_InnerUnionHelper)
    {
        UnionTypeFlag union_flags_Union_InnerUnionHelper = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_InnerUnionHelper = "Union_InnerUnionHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_InnerUnionHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_InnerUnionHelper;
        CompleteTypeDetail detail_Union_InnerUnionHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_InnerUnionHelper, ann_custom_Union_InnerUnionHelper, type_name_Union_InnerUnionHelper.to_string());
        CompleteUnionHeader header_Union_InnerUnionHelper = TypeObjectUtils::build_complete_union_header(detail_Union_InnerUnionHelper);
        UnionDiscriminatorFlag member_flags_Union_InnerUnionHelper = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_InnerUnionHelper =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_InnerUnionHelper);

        if (return_code_Union_InnerUnionHelper != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_InnerUnionHelper;
        if (EK_COMPLETE == type_ids_Union_InnerUnionHelper.type_identifier1()._d() || TK_NONE == type_ids_Union_InnerUnionHelper.type_identifier2()._d())
        {
            common_Union_InnerUnionHelper = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_InnerUnionHelper, type_ids_Union_InnerUnionHelper.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_InnerUnionHelper.type_identifier2()._d())
        {
            common_Union_InnerUnionHelper = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_InnerUnionHelper, type_ids_Union_InnerUnionHelper.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_InnerUnionHelper discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_InnerUnionHelper.reset();
        ann_custom_Union_InnerUnionHelper.reset();
        CompleteDiscriminatorMember discriminator_Union_InnerUnionHelper = TypeObjectUtils::build_complete_discriminator_member(common_Union_InnerUnionHelper,
                type_ann_builtin_Union_InnerUnionHelper, ann_custom_Union_InnerUnionHelper);
        CompleteUnionMemberSeq member_seq_Union_InnerUnionHelper;
        {
            return_code_Union_InnerUnionHelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerUnionHelper", type_ids_Union_InnerUnionHelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_InnerUnionHelper)
            {
            ::register_InnerUnionHelper_type_identifier(type_ids_Union_InnerUnionHelper);
            }
            UnionMemberFlag member_flags_v = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_v;
            TypeObjectUtils::add_union_case_label(label_seq_v, static_cast<int32_t>(21));
            MemberId member_id_v = 0x00000001;
            bool common_v_ec {false};
            CommonUnionMember common_v {TypeObjectUtils::build_common_union_member(member_id_v,
                    member_flags_v, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_InnerUnionHelper,
                        common_v_ec), label_seq_v)};
            if (!common_v_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union v member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_v = "v";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_v;
            ann_custom_Union_InnerUnionHelper.reset();
            CompleteMemberDetail detail_v = TypeObjectUtils::build_complete_member_detail(name_v, member_ann_builtin_v, ann_custom_Union_InnerUnionHelper);
            CompleteUnionMember member_v = TypeObjectUtils::build_complete_union_member(common_v, detail_v);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_InnerUnionHelper, member_v);
        }
        CompleteUnionType union_type_Union_InnerUnionHelper = TypeObjectUtils::build_complete_union_type(union_flags_Union_InnerUnionHelper, header_Union_InnerUnionHelper, discriminator_Union_InnerUnionHelper,
                member_seq_Union_InnerUnionHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_InnerUnionHelper, type_name_Union_InnerUnionHelper.to_string(), type_ids_Union_InnerUnionHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_InnerUnionHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_InnerStructureHelper_type_identifier(
        TypeIdentifierPair& type_ids_Union_InnerStructureHelper)
{
    ReturnCode_t return_code_Union_InnerStructureHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_InnerStructureHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_InnerStructureHelper", type_ids_Union_InnerStructureHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_InnerStructureHelper)
    {
        UnionTypeFlag union_flags_Union_InnerStructureHelper = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_InnerStructureHelper = "Union_InnerStructureHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_InnerStructureHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_InnerStructureHelper;
        CompleteTypeDetail detail_Union_InnerStructureHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_InnerStructureHelper, ann_custom_Union_InnerStructureHelper, type_name_Union_InnerStructureHelper.to_string());
        CompleteUnionHeader header_Union_InnerStructureHelper = TypeObjectUtils::build_complete_union_header(detail_Union_InnerStructureHelper);
        UnionDiscriminatorFlag member_flags_Union_InnerStructureHelper = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_InnerStructureHelper =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_InnerStructureHelper);

        if (return_code_Union_InnerStructureHelper != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_InnerStructureHelper;
        if (EK_COMPLETE == type_ids_Union_InnerStructureHelper.type_identifier1()._d() || TK_NONE == type_ids_Union_InnerStructureHelper.type_identifier2()._d())
        {
            common_Union_InnerStructureHelper = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_InnerStructureHelper, type_ids_Union_InnerStructureHelper.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_InnerStructureHelper.type_identifier2()._d())
        {
            common_Union_InnerStructureHelper = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_InnerStructureHelper, type_ids_Union_InnerStructureHelper.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_InnerStructureHelper discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_InnerStructureHelper.reset();
        ann_custom_Union_InnerStructureHelper.reset();
        CompleteDiscriminatorMember discriminator_Union_InnerStructureHelper = TypeObjectUtils::build_complete_discriminator_member(common_Union_InnerStructureHelper,
                type_ann_builtin_Union_InnerStructureHelper, ann_custom_Union_InnerStructureHelper);
        CompleteUnionMemberSeq member_seq_Union_InnerStructureHelper;
        {
            return_code_Union_InnerStructureHelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructureHelper", type_ids_Union_InnerStructureHelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_InnerStructureHelper)
            {
            ::register_InnerStructureHelper_type_identifier(type_ids_Union_InnerStructureHelper);
            }
            UnionMemberFlag member_flags_w = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_w;
            TypeObjectUtils::add_union_case_label(label_seq_w, static_cast<int32_t>(22));
            MemberId member_id_w = 0x00000001;
            bool common_w_ec {false};
            CommonUnionMember common_w {TypeObjectUtils::build_common_union_member(member_id_w,
                    member_flags_w, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_InnerStructureHelper,
                        common_w_ec), label_seq_w)};
            if (!common_w_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union w member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_w = "w";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_w;
            ann_custom_Union_InnerStructureHelper.reset();
            CompleteMemberDetail detail_w = TypeObjectUtils::build_complete_member_detail(name_w, member_ann_builtin_w, ann_custom_Union_InnerStructureHelper);
            CompleteUnionMember member_w = TypeObjectUtils::build_complete_union_member(common_w, detail_w);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_InnerStructureHelper, member_w);
        }
        CompleteUnionType union_type_Union_InnerStructureHelper = TypeObjectUtils::build_complete_union_type(union_flags_Union_InnerStructureHelper, header_Union_InnerStructureHelper, discriminator_Union_InnerStructureHelper,
                member_seq_Union_InnerStructureHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_InnerStructureHelper, type_name_Union_InnerStructureHelper.to_string(), type_ids_Union_InnerStructureHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_InnerStructureHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_InnerBitsetHelper_type_identifier(
        TypeIdentifierPair& type_ids_Union_InnerBitsetHelper)
{
    ReturnCode_t return_code_Union_InnerBitsetHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_InnerBitsetHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_InnerBitsetHelper", type_ids_Union_InnerBitsetHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_InnerBitsetHelper)
    {
        UnionTypeFlag union_flags_Union_InnerBitsetHelper = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_InnerBitsetHelper = "Union_InnerBitsetHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_InnerBitsetHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_InnerBitsetHelper;
        CompleteTypeDetail detail_Union_InnerBitsetHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_InnerBitsetHelper, ann_custom_Union_InnerBitsetHelper, type_name_Union_InnerBitsetHelper.to_string());
        CompleteUnionHeader header_Union_InnerBitsetHelper = TypeObjectUtils::build_complete_union_header(detail_Union_InnerBitsetHelper);
        UnionDiscriminatorFlag member_flags_Union_InnerBitsetHelper = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_InnerBitsetHelper =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_InnerBitsetHelper);

        if (return_code_Union_InnerBitsetHelper != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_InnerBitsetHelper;
        if (EK_COMPLETE == type_ids_Union_InnerBitsetHelper.type_identifier1()._d() || TK_NONE == type_ids_Union_InnerBitsetHelper.type_identifier2()._d())
        {
            common_Union_InnerBitsetHelper = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_InnerBitsetHelper, type_ids_Union_InnerBitsetHelper.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_InnerBitsetHelper.type_identifier2()._d())
        {
            common_Union_InnerBitsetHelper = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_InnerBitsetHelper, type_ids_Union_InnerBitsetHelper.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_InnerBitsetHelper discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_InnerBitsetHelper.reset();
        ann_custom_Union_InnerBitsetHelper.reset();
        CompleteDiscriminatorMember discriminator_Union_InnerBitsetHelper = TypeObjectUtils::build_complete_discriminator_member(common_Union_InnerBitsetHelper,
                type_ann_builtin_Union_InnerBitsetHelper, ann_custom_Union_InnerBitsetHelper);
        CompleteUnionMemberSeq member_seq_Union_InnerBitsetHelper;
        {
            return_code_Union_InnerBitsetHelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerBitsetHelper", type_ids_Union_InnerBitsetHelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_InnerBitsetHelper)
            {
            ::register_InnerBitsetHelper_type_identifier(type_ids_Union_InnerBitsetHelper);
            }
            UnionMemberFlag member_flags_x = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_x;
            TypeObjectUtils::add_union_case_label(label_seq_x, static_cast<int32_t>(23));
            MemberId member_id_x = 0x00000001;
            bool common_x_ec {false};
            CommonUnionMember common_x {TypeObjectUtils::build_common_union_member(member_id_x,
                    member_flags_x, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_InnerBitsetHelper,
                        common_x_ec), label_seq_x)};
            if (!common_x_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union x member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_x = "x";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_x;
            ann_custom_Union_InnerBitsetHelper.reset();
            CompleteMemberDetail detail_x = TypeObjectUtils::build_complete_member_detail(name_x, member_ann_builtin_x, ann_custom_Union_InnerBitsetHelper);
            CompleteUnionMember member_x = TypeObjectUtils::build_complete_union_member(common_x, detail_x);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_InnerBitsetHelper, member_x);
        }
        CompleteUnionType union_type_Union_InnerBitsetHelper = TypeObjectUtils::build_complete_union_type(union_flags_Union_InnerBitsetHelper, header_Union_InnerBitsetHelper, discriminator_Union_InnerBitsetHelper,
                member_seq_Union_InnerBitsetHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_InnerBitsetHelper, type_name_Union_InnerBitsetHelper.to_string(), type_ids_Union_InnerBitsetHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_InnerBitsetHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Discriminator_short_type_identifier(
        TypeIdentifierPair& type_ids_Union_Discriminator_short)
{
    ReturnCode_t return_code_Union_Discriminator_short {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Discriminator_short =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Discriminator_short", type_ids_Union_Discriminator_short);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_short)
    {
        UnionTypeFlag union_flags_Union_Discriminator_short = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Discriminator_short = "Union_Discriminator_short";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Discriminator_short;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Discriminator_short;
        CompleteTypeDetail detail_Union_Discriminator_short = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Discriminator_short, ann_custom_Union_Discriminator_short, type_name_Union_Discriminator_short.to_string());
        CompleteUnionHeader header_Union_Discriminator_short = TypeObjectUtils::build_complete_union_header(detail_Union_Discriminator_short);
        UnionDiscriminatorFlag member_flags_Union_Discriminator_short = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Discriminator_short =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int16_t", type_ids_Union_Discriminator_short);

        if (return_code_Union_Discriminator_short != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Discriminator_short;
        if (EK_COMPLETE == type_ids_Union_Discriminator_short.type_identifier1()._d() || TK_NONE == type_ids_Union_Discriminator_short.type_identifier2()._d())
        {
            common_Union_Discriminator_short = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_short, type_ids_Union_Discriminator_short.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Discriminator_short.type_identifier2()._d())
        {
            common_Union_Discriminator_short = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_short, type_ids_Union_Discriminator_short.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_short discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Discriminator_short.reset();
        ann_custom_Union_Discriminator_short.reset();
        CompleteDiscriminatorMember discriminator_Union_Discriminator_short = TypeObjectUtils::build_complete_discriminator_member(common_Union_Discriminator_short,
                type_ann_builtin_Union_Discriminator_short, ann_custom_Union_Discriminator_short);
        CompleteUnionMemberSeq member_seq_Union_Discriminator_short;
        {
            return_code_Union_Discriminator_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_Union_Discriminator_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "first Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_first = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_first;
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>(1));
            MemberId member_id_first = 0x00000001;
            bool common_first_ec {false};
            CommonUnionMember common_first {TypeObjectUtils::build_common_union_member(member_id_first,
                    member_flags_first, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_short,
                        common_first_ec), label_seq_first)};
            if (!common_first_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union first member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_first = "first";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_first;
            ann_custom_Union_Discriminator_short.reset();
            CompleteMemberDetail detail_first = TypeObjectUtils::build_complete_member_detail(name_first, member_ann_builtin_first, ann_custom_Union_Discriminator_short);
            CompleteUnionMember member_first = TypeObjectUtils::build_complete_union_member(common_first, detail_first);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_short, member_first);
        }
        {
            return_code_Union_Discriminator_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_Union_Discriminator_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "second Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_second = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_second;
            TypeObjectUtils::add_union_case_label(label_seq_second, static_cast<int32_t>(-2));
            MemberId member_id_second = 0x00000002;
            bool common_second_ec {false};
            CommonUnionMember common_second {TypeObjectUtils::build_common_union_member(member_id_second,
                    member_flags_second, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_short,
                        common_second_ec), label_seq_second)};
            if (!common_second_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union second member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_second = "second";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_second;
            ann_custom_Union_Discriminator_short.reset();
            CompleteMemberDetail detail_second = TypeObjectUtils::build_complete_member_detail(name_second, member_ann_builtin_second, ann_custom_Union_Discriminator_short);
            CompleteUnionMember member_second = TypeObjectUtils::build_complete_union_member(common_second, detail_second);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_short, member_second);
        }
        CompleteUnionType union_type_Union_Discriminator_short = TypeObjectUtils::build_complete_union_type(union_flags_Union_Discriminator_short, header_Union_Discriminator_short, discriminator_Union_Discriminator_short,
                member_seq_Union_Discriminator_short);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Discriminator_short, type_name_Union_Discriminator_short.to_string(), type_ids_Union_Discriminator_short))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_short already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Discriminator_unsigned_short_type_identifier(
        TypeIdentifierPair& type_ids_Union_Discriminator_unsigned_short)
{
    ReturnCode_t return_code_Union_Discriminator_unsigned_short {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Discriminator_unsigned_short =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Discriminator_unsigned_short", type_ids_Union_Discriminator_unsigned_short);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_unsigned_short)
    {
        UnionTypeFlag union_flags_Union_Discriminator_unsigned_short = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Discriminator_unsigned_short = "Union_Discriminator_unsigned_short";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Discriminator_unsigned_short;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Discriminator_unsigned_short;
        CompleteTypeDetail detail_Union_Discriminator_unsigned_short = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Discriminator_unsigned_short, ann_custom_Union_Discriminator_unsigned_short, type_name_Union_Discriminator_unsigned_short.to_string());
        CompleteUnionHeader header_Union_Discriminator_unsigned_short = TypeObjectUtils::build_complete_union_header(detail_Union_Discriminator_unsigned_short);
        UnionDiscriminatorFlag member_flags_Union_Discriminator_unsigned_short = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Discriminator_unsigned_short =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_uint16_t", type_ids_Union_Discriminator_unsigned_short);

        if (return_code_Union_Discriminator_unsigned_short != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Discriminator_unsigned_short;
        if (EK_COMPLETE == type_ids_Union_Discriminator_unsigned_short.type_identifier1()._d() || TK_NONE == type_ids_Union_Discriminator_unsigned_short.type_identifier2()._d())
        {
            common_Union_Discriminator_unsigned_short = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_unsigned_short, type_ids_Union_Discriminator_unsigned_short.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Discriminator_unsigned_short.type_identifier2()._d())
        {
            common_Union_Discriminator_unsigned_short = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_unsigned_short, type_ids_Union_Discriminator_unsigned_short.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_unsigned_short discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Discriminator_unsigned_short.reset();
        ann_custom_Union_Discriminator_unsigned_short.reset();
        CompleteDiscriminatorMember discriminator_Union_Discriminator_unsigned_short = TypeObjectUtils::build_complete_discriminator_member(common_Union_Discriminator_unsigned_short,
                type_ann_builtin_Union_Discriminator_unsigned_short, ann_custom_Union_Discriminator_unsigned_short);
        CompleteUnionMemberSeq member_seq_Union_Discriminator_unsigned_short;
        {
            return_code_Union_Discriminator_unsigned_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_Union_Discriminator_unsigned_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_unsigned_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "first Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_first = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_first;
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>(1));
            MemberId member_id_first = 0x00000001;
            bool common_first_ec {false};
            CommonUnionMember common_first {TypeObjectUtils::build_common_union_member(member_id_first,
                    member_flags_first, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_unsigned_short,
                        common_first_ec), label_seq_first)};
            if (!common_first_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union first member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_first = "first";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_first;
            ann_custom_Union_Discriminator_unsigned_short.reset();
            CompleteMemberDetail detail_first = TypeObjectUtils::build_complete_member_detail(name_first, member_ann_builtin_first, ann_custom_Union_Discriminator_unsigned_short);
            CompleteUnionMember member_first = TypeObjectUtils::build_complete_union_member(common_first, detail_first);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_unsigned_short, member_first);
        }
        {
            return_code_Union_Discriminator_unsigned_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_Union_Discriminator_unsigned_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_unsigned_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "second Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_second = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_second;
            TypeObjectUtils::add_union_case_label(label_seq_second, static_cast<int32_t>(2));
            MemberId member_id_second = 0x00000002;
            bool common_second_ec {false};
            CommonUnionMember common_second {TypeObjectUtils::build_common_union_member(member_id_second,
                    member_flags_second, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_unsigned_short,
                        common_second_ec), label_seq_second)};
            if (!common_second_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union second member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_second = "second";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_second;
            ann_custom_Union_Discriminator_unsigned_short.reset();
            CompleteMemberDetail detail_second = TypeObjectUtils::build_complete_member_detail(name_second, member_ann_builtin_second, ann_custom_Union_Discriminator_unsigned_short);
            CompleteUnionMember member_second = TypeObjectUtils::build_complete_union_member(common_second, detail_second);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_unsigned_short, member_second);
        }
        CompleteUnionType union_type_Union_Discriminator_unsigned_short = TypeObjectUtils::build_complete_union_type(union_flags_Union_Discriminator_unsigned_short, header_Union_Discriminator_unsigned_short, discriminator_Union_Discriminator_unsigned_short,
                member_seq_Union_Discriminator_unsigned_short);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Discriminator_unsigned_short, type_name_Union_Discriminator_unsigned_short.to_string(), type_ids_Union_Discriminator_unsigned_short))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_unsigned_short already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Discriminator_long_type_identifier(
        TypeIdentifierPair& type_ids_Union_Discriminator_long)
{
    ReturnCode_t return_code_Union_Discriminator_long {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Discriminator_long =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Discriminator_long", type_ids_Union_Discriminator_long);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_long)
    {
        UnionTypeFlag union_flags_Union_Discriminator_long = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Discriminator_long = "Union_Discriminator_long";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Discriminator_long;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Discriminator_long;
        CompleteTypeDetail detail_Union_Discriminator_long = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Discriminator_long, ann_custom_Union_Discriminator_long, type_name_Union_Discriminator_long.to_string());
        CompleteUnionHeader header_Union_Discriminator_long = TypeObjectUtils::build_complete_union_header(detail_Union_Discriminator_long);
        UnionDiscriminatorFlag member_flags_Union_Discriminator_long = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Discriminator_long =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_Discriminator_long);

        if (return_code_Union_Discriminator_long != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Discriminator_long;
        if (EK_COMPLETE == type_ids_Union_Discriminator_long.type_identifier1()._d() || TK_NONE == type_ids_Union_Discriminator_long.type_identifier2()._d())
        {
            common_Union_Discriminator_long = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_long, type_ids_Union_Discriminator_long.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Discriminator_long.type_identifier2()._d())
        {
            common_Union_Discriminator_long = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_long, type_ids_Union_Discriminator_long.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_long discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Discriminator_long.reset();
        ann_custom_Union_Discriminator_long.reset();
        CompleteDiscriminatorMember discriminator_Union_Discriminator_long = TypeObjectUtils::build_complete_discriminator_member(common_Union_Discriminator_long,
                type_ann_builtin_Union_Discriminator_long, ann_custom_Union_Discriminator_long);
        CompleteUnionMemberSeq member_seq_Union_Discriminator_long;
        {
            return_code_Union_Discriminator_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_Union_Discriminator_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "first Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_first = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_first;
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>(1));
            MemberId member_id_first = 0x00000001;
            bool common_first_ec {false};
            CommonUnionMember common_first {TypeObjectUtils::build_common_union_member(member_id_first,
                    member_flags_first, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_long,
                        common_first_ec), label_seq_first)};
            if (!common_first_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union first member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_first = "first";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_first;
            ann_custom_Union_Discriminator_long.reset();
            CompleteMemberDetail detail_first = TypeObjectUtils::build_complete_member_detail(name_first, member_ann_builtin_first, ann_custom_Union_Discriminator_long);
            CompleteUnionMember member_first = TypeObjectUtils::build_complete_union_member(common_first, detail_first);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_long, member_first);
        }
        {
            return_code_Union_Discriminator_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_Union_Discriminator_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "second Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_second = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_second;
            TypeObjectUtils::add_union_case_label(label_seq_second, static_cast<int32_t>(-2));
            MemberId member_id_second = 0x00000002;
            bool common_second_ec {false};
            CommonUnionMember common_second {TypeObjectUtils::build_common_union_member(member_id_second,
                    member_flags_second, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_long,
                        common_second_ec), label_seq_second)};
            if (!common_second_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union second member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_second = "second";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_second;
            ann_custom_Union_Discriminator_long.reset();
            CompleteMemberDetail detail_second = TypeObjectUtils::build_complete_member_detail(name_second, member_ann_builtin_second, ann_custom_Union_Discriminator_long);
            CompleteUnionMember member_second = TypeObjectUtils::build_complete_union_member(common_second, detail_second);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_long, member_second);
        }
        CompleteUnionType union_type_Union_Discriminator_long = TypeObjectUtils::build_complete_union_type(union_flags_Union_Discriminator_long, header_Union_Discriminator_long, discriminator_Union_Discriminator_long,
                member_seq_Union_Discriminator_long);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Discriminator_long, type_name_Union_Discriminator_long.to_string(), type_ids_Union_Discriminator_long))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_long already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Discriminator_unsigned_long_type_identifier(
        TypeIdentifierPair& type_ids_Union_Discriminator_unsigned_long)
{
    ReturnCode_t return_code_Union_Discriminator_unsigned_long {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Discriminator_unsigned_long =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Discriminator_unsigned_long", type_ids_Union_Discriminator_unsigned_long);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_unsigned_long)
    {
        UnionTypeFlag union_flags_Union_Discriminator_unsigned_long = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Discriminator_unsigned_long = "Union_Discriminator_unsigned_long";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Discriminator_unsigned_long;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Discriminator_unsigned_long;
        CompleteTypeDetail detail_Union_Discriminator_unsigned_long = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Discriminator_unsigned_long, ann_custom_Union_Discriminator_unsigned_long, type_name_Union_Discriminator_unsigned_long.to_string());
        CompleteUnionHeader header_Union_Discriminator_unsigned_long = TypeObjectUtils::build_complete_union_header(detail_Union_Discriminator_unsigned_long);
        UnionDiscriminatorFlag member_flags_Union_Discriminator_unsigned_long = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Discriminator_unsigned_long =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_uint32_t", type_ids_Union_Discriminator_unsigned_long);

        if (return_code_Union_Discriminator_unsigned_long != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Discriminator_unsigned_long;
        if (EK_COMPLETE == type_ids_Union_Discriminator_unsigned_long.type_identifier1()._d() || TK_NONE == type_ids_Union_Discriminator_unsigned_long.type_identifier2()._d())
        {
            common_Union_Discriminator_unsigned_long = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_unsigned_long, type_ids_Union_Discriminator_unsigned_long.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Discriminator_unsigned_long.type_identifier2()._d())
        {
            common_Union_Discriminator_unsigned_long = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_unsigned_long, type_ids_Union_Discriminator_unsigned_long.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_unsigned_long discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Discriminator_unsigned_long.reset();
        ann_custom_Union_Discriminator_unsigned_long.reset();
        CompleteDiscriminatorMember discriminator_Union_Discriminator_unsigned_long = TypeObjectUtils::build_complete_discriminator_member(common_Union_Discriminator_unsigned_long,
                type_ann_builtin_Union_Discriminator_unsigned_long, ann_custom_Union_Discriminator_unsigned_long);
        CompleteUnionMemberSeq member_seq_Union_Discriminator_unsigned_long;
        {
            return_code_Union_Discriminator_unsigned_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_Union_Discriminator_unsigned_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_unsigned_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "first Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_first = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_first;
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>(1));
            MemberId member_id_first = 0x00000001;
            bool common_first_ec {false};
            CommonUnionMember common_first {TypeObjectUtils::build_common_union_member(member_id_first,
                    member_flags_first, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_unsigned_long,
                        common_first_ec), label_seq_first)};
            if (!common_first_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union first member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_first = "first";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_first;
            ann_custom_Union_Discriminator_unsigned_long.reset();
            CompleteMemberDetail detail_first = TypeObjectUtils::build_complete_member_detail(name_first, member_ann_builtin_first, ann_custom_Union_Discriminator_unsigned_long);
            CompleteUnionMember member_first = TypeObjectUtils::build_complete_union_member(common_first, detail_first);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_unsigned_long, member_first);
        }
        {
            return_code_Union_Discriminator_unsigned_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_Union_Discriminator_unsigned_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_unsigned_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "second Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_second = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_second;
            TypeObjectUtils::add_union_case_label(label_seq_second, static_cast<int32_t>(2));
            MemberId member_id_second = 0x00000002;
            bool common_second_ec {false};
            CommonUnionMember common_second {TypeObjectUtils::build_common_union_member(member_id_second,
                    member_flags_second, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_unsigned_long,
                        common_second_ec), label_seq_second)};
            if (!common_second_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union second member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_second = "second";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_second;
            ann_custom_Union_Discriminator_unsigned_long.reset();
            CompleteMemberDetail detail_second = TypeObjectUtils::build_complete_member_detail(name_second, member_ann_builtin_second, ann_custom_Union_Discriminator_unsigned_long);
            CompleteUnionMember member_second = TypeObjectUtils::build_complete_union_member(common_second, detail_second);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_unsigned_long, member_second);
        }
        CompleteUnionType union_type_Union_Discriminator_unsigned_long = TypeObjectUtils::build_complete_union_type(union_flags_Union_Discriminator_unsigned_long, header_Union_Discriminator_unsigned_long, discriminator_Union_Discriminator_unsigned_long,
                member_seq_Union_Discriminator_unsigned_long);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Discriminator_unsigned_long, type_name_Union_Discriminator_unsigned_long.to_string(), type_ids_Union_Discriminator_unsigned_long))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_unsigned_long already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Discriminator_long_long_type_identifier(
        TypeIdentifierPair& type_ids_Union_Discriminator_long_long)
{
    ReturnCode_t return_code_Union_Discriminator_long_long {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Discriminator_long_long =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Discriminator_long_long", type_ids_Union_Discriminator_long_long);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_long_long)
    {
        UnionTypeFlag union_flags_Union_Discriminator_long_long = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Discriminator_long_long = "Union_Discriminator_long_long";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Discriminator_long_long;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Discriminator_long_long;
        CompleteTypeDetail detail_Union_Discriminator_long_long = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Discriminator_long_long, ann_custom_Union_Discriminator_long_long, type_name_Union_Discriminator_long_long.to_string());
        CompleteUnionHeader header_Union_Discriminator_long_long = TypeObjectUtils::build_complete_union_header(detail_Union_Discriminator_long_long);
        UnionDiscriminatorFlag member_flags_Union_Discriminator_long_long = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Discriminator_long_long =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int64_t", type_ids_Union_Discriminator_long_long);

        if (return_code_Union_Discriminator_long_long != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Discriminator_long_long;
        if (EK_COMPLETE == type_ids_Union_Discriminator_long_long.type_identifier1()._d() || TK_NONE == type_ids_Union_Discriminator_long_long.type_identifier2()._d())
        {
            common_Union_Discriminator_long_long = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_long_long, type_ids_Union_Discriminator_long_long.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Discriminator_long_long.type_identifier2()._d())
        {
            common_Union_Discriminator_long_long = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_long_long, type_ids_Union_Discriminator_long_long.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_long_long discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Discriminator_long_long.reset();
        ann_custom_Union_Discriminator_long_long.reset();
        CompleteDiscriminatorMember discriminator_Union_Discriminator_long_long = TypeObjectUtils::build_complete_discriminator_member(common_Union_Discriminator_long_long,
                type_ann_builtin_Union_Discriminator_long_long, ann_custom_Union_Discriminator_long_long);
        CompleteUnionMemberSeq member_seq_Union_Discriminator_long_long;
        {
            return_code_Union_Discriminator_long_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_Union_Discriminator_long_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_long_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "first Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_first = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_first;
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>(1));
            MemberId member_id_first = 0x00000001;
            bool common_first_ec {false};
            CommonUnionMember common_first {TypeObjectUtils::build_common_union_member(member_id_first,
                    member_flags_first, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_long_long,
                        common_first_ec), label_seq_first)};
            if (!common_first_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union first member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_first = "first";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_first;
            ann_custom_Union_Discriminator_long_long.reset();
            CompleteMemberDetail detail_first = TypeObjectUtils::build_complete_member_detail(name_first, member_ann_builtin_first, ann_custom_Union_Discriminator_long_long);
            CompleteUnionMember member_first = TypeObjectUtils::build_complete_union_member(common_first, detail_first);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_long_long, member_first);
        }
        {
            return_code_Union_Discriminator_long_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_Union_Discriminator_long_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_long_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "second Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_second = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_second;
            TypeObjectUtils::add_union_case_label(label_seq_second, static_cast<int32_t>(-2));
            MemberId member_id_second = 0x00000002;
            bool common_second_ec {false};
            CommonUnionMember common_second {TypeObjectUtils::build_common_union_member(member_id_second,
                    member_flags_second, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_long_long,
                        common_second_ec), label_seq_second)};
            if (!common_second_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union second member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_second = "second";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_second;
            ann_custom_Union_Discriminator_long_long.reset();
            CompleteMemberDetail detail_second = TypeObjectUtils::build_complete_member_detail(name_second, member_ann_builtin_second, ann_custom_Union_Discriminator_long_long);
            CompleteUnionMember member_second = TypeObjectUtils::build_complete_union_member(common_second, detail_second);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_long_long, member_second);
        }
        CompleteUnionType union_type_Union_Discriminator_long_long = TypeObjectUtils::build_complete_union_type(union_flags_Union_Discriminator_long_long, header_Union_Discriminator_long_long, discriminator_Union_Discriminator_long_long,
                member_seq_Union_Discriminator_long_long);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Discriminator_long_long, type_name_Union_Discriminator_long_long.to_string(), type_ids_Union_Discriminator_long_long))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_long_long already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Discriminator_unsigned_long_long_type_identifier(
        TypeIdentifierPair& type_ids_Union_Discriminator_unsigned_long_long)
{
    ReturnCode_t return_code_Union_Discriminator_unsigned_long_long {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Discriminator_unsigned_long_long =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Discriminator_unsigned_long_long", type_ids_Union_Discriminator_unsigned_long_long);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_unsigned_long_long)
    {
        UnionTypeFlag union_flags_Union_Discriminator_unsigned_long_long = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Discriminator_unsigned_long_long = "Union_Discriminator_unsigned_long_long";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Discriminator_unsigned_long_long;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Discriminator_unsigned_long_long;
        CompleteTypeDetail detail_Union_Discriminator_unsigned_long_long = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Discriminator_unsigned_long_long, ann_custom_Union_Discriminator_unsigned_long_long, type_name_Union_Discriminator_unsigned_long_long.to_string());
        CompleteUnionHeader header_Union_Discriminator_unsigned_long_long = TypeObjectUtils::build_complete_union_header(detail_Union_Discriminator_unsigned_long_long);
        UnionDiscriminatorFlag member_flags_Union_Discriminator_unsigned_long_long = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Discriminator_unsigned_long_long =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_uint64_t", type_ids_Union_Discriminator_unsigned_long_long);

        if (return_code_Union_Discriminator_unsigned_long_long != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Discriminator_unsigned_long_long;
        if (EK_COMPLETE == type_ids_Union_Discriminator_unsigned_long_long.type_identifier1()._d() || TK_NONE == type_ids_Union_Discriminator_unsigned_long_long.type_identifier2()._d())
        {
            common_Union_Discriminator_unsigned_long_long = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_unsigned_long_long, type_ids_Union_Discriminator_unsigned_long_long.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Discriminator_unsigned_long_long.type_identifier2()._d())
        {
            common_Union_Discriminator_unsigned_long_long = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_unsigned_long_long, type_ids_Union_Discriminator_unsigned_long_long.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_unsigned_long_long discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Discriminator_unsigned_long_long.reset();
        ann_custom_Union_Discriminator_unsigned_long_long.reset();
        CompleteDiscriminatorMember discriminator_Union_Discriminator_unsigned_long_long = TypeObjectUtils::build_complete_discriminator_member(common_Union_Discriminator_unsigned_long_long,
                type_ann_builtin_Union_Discriminator_unsigned_long_long, ann_custom_Union_Discriminator_unsigned_long_long);
        CompleteUnionMemberSeq member_seq_Union_Discriminator_unsigned_long_long;
        {
            return_code_Union_Discriminator_unsigned_long_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_Union_Discriminator_unsigned_long_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_unsigned_long_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "first Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_first = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_first;
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>(2));
            MemberId member_id_first = 0x00000001;
            bool common_first_ec {false};
            CommonUnionMember common_first {TypeObjectUtils::build_common_union_member(member_id_first,
                    member_flags_first, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_unsigned_long_long,
                        common_first_ec), label_seq_first)};
            if (!common_first_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union first member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_first = "first";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_first;
            ann_custom_Union_Discriminator_unsigned_long_long.reset();
            CompleteMemberDetail detail_first = TypeObjectUtils::build_complete_member_detail(name_first, member_ann_builtin_first, ann_custom_Union_Discriminator_unsigned_long_long);
            CompleteUnionMember member_first = TypeObjectUtils::build_complete_union_member(common_first, detail_first);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_unsigned_long_long, member_first);
        }
        {
            return_code_Union_Discriminator_unsigned_long_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_Union_Discriminator_unsigned_long_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_unsigned_long_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "second Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_second = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_second;
            TypeObjectUtils::add_union_case_label(label_seq_second, static_cast<int32_t>(1));
            MemberId member_id_second = 0x00000002;
            bool common_second_ec {false};
            CommonUnionMember common_second {TypeObjectUtils::build_common_union_member(member_id_second,
                    member_flags_second, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_unsigned_long_long,
                        common_second_ec), label_seq_second)};
            if (!common_second_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union second member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_second = "second";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_second;
            ann_custom_Union_Discriminator_unsigned_long_long.reset();
            CompleteMemberDetail detail_second = TypeObjectUtils::build_complete_member_detail(name_second, member_ann_builtin_second, ann_custom_Union_Discriminator_unsigned_long_long);
            CompleteUnionMember member_second = TypeObjectUtils::build_complete_union_member(common_second, detail_second);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_unsigned_long_long, member_second);
        }
        CompleteUnionType union_type_Union_Discriminator_unsigned_long_long = TypeObjectUtils::build_complete_union_type(union_flags_Union_Discriminator_unsigned_long_long, header_Union_Discriminator_unsigned_long_long, discriminator_Union_Discriminator_unsigned_long_long,
                member_seq_Union_Discriminator_unsigned_long_long);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Discriminator_unsigned_long_long, type_name_Union_Discriminator_unsigned_long_long.to_string(), type_ids_Union_Discriminator_unsigned_long_long))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_unsigned_long_long already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Discriminator_boolean_type_identifier(
        TypeIdentifierPair& type_ids_Union_Discriminator_boolean)
{
    ReturnCode_t return_code_Union_Discriminator_boolean {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Discriminator_boolean =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Discriminator_boolean", type_ids_Union_Discriminator_boolean);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_boolean)
    {
        UnionTypeFlag union_flags_Union_Discriminator_boolean = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Discriminator_boolean = "Union_Discriminator_boolean";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Discriminator_boolean;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Discriminator_boolean;
        CompleteTypeDetail detail_Union_Discriminator_boolean = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Discriminator_boolean, ann_custom_Union_Discriminator_boolean, type_name_Union_Discriminator_boolean.to_string());
        CompleteUnionHeader header_Union_Discriminator_boolean = TypeObjectUtils::build_complete_union_header(detail_Union_Discriminator_boolean);
        UnionDiscriminatorFlag member_flags_Union_Discriminator_boolean = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Discriminator_boolean =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_bool", type_ids_Union_Discriminator_boolean);

        if (return_code_Union_Discriminator_boolean != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Discriminator_boolean;
        if (EK_COMPLETE == type_ids_Union_Discriminator_boolean.type_identifier1()._d() || TK_NONE == type_ids_Union_Discriminator_boolean.type_identifier2()._d())
        {
            common_Union_Discriminator_boolean = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_boolean, type_ids_Union_Discriminator_boolean.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Discriminator_boolean.type_identifier2()._d())
        {
            common_Union_Discriminator_boolean = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_boolean, type_ids_Union_Discriminator_boolean.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_boolean discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Discriminator_boolean.reset();
        ann_custom_Union_Discriminator_boolean.reset();
        CompleteDiscriminatorMember discriminator_Union_Discriminator_boolean = TypeObjectUtils::build_complete_discriminator_member(common_Union_Discriminator_boolean,
                type_ann_builtin_Union_Discriminator_boolean, ann_custom_Union_Discriminator_boolean);
        CompleteUnionMemberSeq member_seq_Union_Discriminator_boolean;
        {
            return_code_Union_Discriminator_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_Union_Discriminator_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_boolean)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "first Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_first = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_first;
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>(true));
            MemberId member_id_first = 0x00000001;
            bool common_first_ec {false};
            CommonUnionMember common_first {TypeObjectUtils::build_common_union_member(member_id_first,
                    member_flags_first, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_boolean,
                        common_first_ec), label_seq_first)};
            if (!common_first_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union first member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_first = "first";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_first;
            ann_custom_Union_Discriminator_boolean.reset();
            CompleteMemberDetail detail_first = TypeObjectUtils::build_complete_member_detail(name_first, member_ann_builtin_first, ann_custom_Union_Discriminator_boolean);
            CompleteUnionMember member_first = TypeObjectUtils::build_complete_union_member(common_first, detail_first);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_boolean, member_first);
        }
        {
            return_code_Union_Discriminator_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_Union_Discriminator_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_boolean)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "second Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_second = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_second;
            TypeObjectUtils::add_union_case_label(label_seq_second, static_cast<int32_t>(false));
            MemberId member_id_second = 0x00000002;
            bool common_second_ec {false};
            CommonUnionMember common_second {TypeObjectUtils::build_common_union_member(member_id_second,
                    member_flags_second, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_boolean,
                        common_second_ec), label_seq_second)};
            if (!common_second_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union second member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_second = "second";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_second;
            ann_custom_Union_Discriminator_boolean.reset();
            CompleteMemberDetail detail_second = TypeObjectUtils::build_complete_member_detail(name_second, member_ann_builtin_second, ann_custom_Union_Discriminator_boolean);
            CompleteUnionMember member_second = TypeObjectUtils::build_complete_union_member(common_second, detail_second);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_boolean, member_second);
        }
        CompleteUnionType union_type_Union_Discriminator_boolean = TypeObjectUtils::build_complete_union_type(union_flags_Union_Discriminator_boolean, header_Union_Discriminator_boolean, discriminator_Union_Discriminator_boolean,
                member_seq_Union_Discriminator_boolean);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Discriminator_boolean, type_name_Union_Discriminator_boolean.to_string(), type_ids_Union_Discriminator_boolean))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_boolean already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Discriminator_octet_type_identifier(
        TypeIdentifierPair& type_ids_Union_Discriminator_octet)
{
    ReturnCode_t return_code_Union_Discriminator_octet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Discriminator_octet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Discriminator_octet", type_ids_Union_Discriminator_octet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_octet)
    {
        UnionTypeFlag union_flags_Union_Discriminator_octet = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Discriminator_octet = "Union_Discriminator_octet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Discriminator_octet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Discriminator_octet;
        CompleteTypeDetail detail_Union_Discriminator_octet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Discriminator_octet, ann_custom_Union_Discriminator_octet, type_name_Union_Discriminator_octet.to_string());
        CompleteUnionHeader header_Union_Discriminator_octet = TypeObjectUtils::build_complete_union_header(detail_Union_Discriminator_octet);
        UnionDiscriminatorFlag member_flags_Union_Discriminator_octet = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Discriminator_octet =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_byte", type_ids_Union_Discriminator_octet);

        if (return_code_Union_Discriminator_octet != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Discriminator_octet;
        if (EK_COMPLETE == type_ids_Union_Discriminator_octet.type_identifier1()._d() || TK_NONE == type_ids_Union_Discriminator_octet.type_identifier2()._d())
        {
            common_Union_Discriminator_octet = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_octet, type_ids_Union_Discriminator_octet.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Discriminator_octet.type_identifier2()._d())
        {
            common_Union_Discriminator_octet = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_octet, type_ids_Union_Discriminator_octet.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_octet discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Discriminator_octet.reset();
        ann_custom_Union_Discriminator_octet.reset();
        CompleteDiscriminatorMember discriminator_Union_Discriminator_octet = TypeObjectUtils::build_complete_discriminator_member(common_Union_Discriminator_octet,
                type_ann_builtin_Union_Discriminator_octet, ann_custom_Union_Discriminator_octet);
        CompleteUnionMemberSeq member_seq_Union_Discriminator_octet;
        {
            return_code_Union_Discriminator_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_Union_Discriminator_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_octet)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "first Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_first = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_first;
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>(0));
            MemberId member_id_first = 0x00000001;
            bool common_first_ec {false};
            CommonUnionMember common_first {TypeObjectUtils::build_common_union_member(member_id_first,
                    member_flags_first, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_octet,
                        common_first_ec), label_seq_first)};
            if (!common_first_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union first member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_first = "first";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_first;
            ann_custom_Union_Discriminator_octet.reset();
            CompleteMemberDetail detail_first = TypeObjectUtils::build_complete_member_detail(name_first, member_ann_builtin_first, ann_custom_Union_Discriminator_octet);
            CompleteUnionMember member_first = TypeObjectUtils::build_complete_union_member(common_first, detail_first);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_octet, member_first);
        }
        {
            return_code_Union_Discriminator_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_Union_Discriminator_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_octet)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "second Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_second = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_second;
            TypeObjectUtils::add_union_case_label(label_seq_second, static_cast<int32_t>(1));
            MemberId member_id_second = 0x00000002;
            bool common_second_ec {false};
            CommonUnionMember common_second {TypeObjectUtils::build_common_union_member(member_id_second,
                    member_flags_second, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_octet,
                        common_second_ec), label_seq_second)};
            if (!common_second_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union second member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_second = "second";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_second;
            ann_custom_Union_Discriminator_octet.reset();
            CompleteMemberDetail detail_second = TypeObjectUtils::build_complete_member_detail(name_second, member_ann_builtin_second, ann_custom_Union_Discriminator_octet);
            CompleteUnionMember member_second = TypeObjectUtils::build_complete_union_member(common_second, detail_second);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_octet, member_second);
        }
        CompleteUnionType union_type_Union_Discriminator_octet = TypeObjectUtils::build_complete_union_type(union_flags_Union_Discriminator_octet, header_Union_Discriminator_octet, discriminator_Union_Discriminator_octet,
                member_seq_Union_Discriminator_octet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Discriminator_octet, type_name_Union_Discriminator_octet.to_string(), type_ids_Union_Discriminator_octet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_octet already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Discriminator_char_type_identifier(
        TypeIdentifierPair& type_ids_Union_Discriminator_char)
{
    ReturnCode_t return_code_Union_Discriminator_char {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Discriminator_char =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Discriminator_char", type_ids_Union_Discriminator_char);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_char)
    {
        UnionTypeFlag union_flags_Union_Discriminator_char = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Discriminator_char = "Union_Discriminator_char";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Discriminator_char;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Discriminator_char;
        CompleteTypeDetail detail_Union_Discriminator_char = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Discriminator_char, ann_custom_Union_Discriminator_char, type_name_Union_Discriminator_char.to_string());
        CompleteUnionHeader header_Union_Discriminator_char = TypeObjectUtils::build_complete_union_header(detail_Union_Discriminator_char);
        UnionDiscriminatorFlag member_flags_Union_Discriminator_char = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Discriminator_char =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_char", type_ids_Union_Discriminator_char);

        if (return_code_Union_Discriminator_char != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Discriminator_char;
        if (EK_COMPLETE == type_ids_Union_Discriminator_char.type_identifier1()._d() || TK_NONE == type_ids_Union_Discriminator_char.type_identifier2()._d())
        {
            common_Union_Discriminator_char = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_char, type_ids_Union_Discriminator_char.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Discriminator_char.type_identifier2()._d())
        {
            common_Union_Discriminator_char = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_char, type_ids_Union_Discriminator_char.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_char discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Discriminator_char.reset();
        ann_custom_Union_Discriminator_char.reset();
        CompleteDiscriminatorMember discriminator_Union_Discriminator_char = TypeObjectUtils::build_complete_discriminator_member(common_Union_Discriminator_char,
                type_ann_builtin_Union_Discriminator_char, ann_custom_Union_Discriminator_char);
        CompleteUnionMemberSeq member_seq_Union_Discriminator_char;
        {
            return_code_Union_Discriminator_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_Union_Discriminator_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_char)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "first Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_first = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_first;
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>('a'));
            MemberId member_id_first = 0x00000001;
            bool common_first_ec {false};
            CommonUnionMember common_first {TypeObjectUtils::build_common_union_member(member_id_first,
                    member_flags_first, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_char,
                        common_first_ec), label_seq_first)};
            if (!common_first_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union first member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_first = "first";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_first;
            ann_custom_Union_Discriminator_char.reset();
            CompleteMemberDetail detail_first = TypeObjectUtils::build_complete_member_detail(name_first, member_ann_builtin_first, ann_custom_Union_Discriminator_char);
            CompleteUnionMember member_first = TypeObjectUtils::build_complete_union_member(common_first, detail_first);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_char, member_first);
        }
        {
            return_code_Union_Discriminator_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_Union_Discriminator_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_char)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "second Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_second = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_second;
            TypeObjectUtils::add_union_case_label(label_seq_second, static_cast<int32_t>('b'));
            MemberId member_id_second = 0x00000002;
            bool common_second_ec {false};
            CommonUnionMember common_second {TypeObjectUtils::build_common_union_member(member_id_second,
                    member_flags_second, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_char,
                        common_second_ec), label_seq_second)};
            if (!common_second_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union second member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_second = "second";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_second;
            ann_custom_Union_Discriminator_char.reset();
            CompleteMemberDetail detail_second = TypeObjectUtils::build_complete_member_detail(name_second, member_ann_builtin_second, ann_custom_Union_Discriminator_char);
            CompleteUnionMember member_second = TypeObjectUtils::build_complete_union_member(common_second, detail_second);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_char, member_second);
        }
        CompleteUnionType union_type_Union_Discriminator_char = TypeObjectUtils::build_complete_union_type(union_flags_Union_Discriminator_char, header_Union_Discriminator_char, discriminator_Union_Discriminator_char,
                member_seq_Union_Discriminator_char);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Discriminator_char, type_name_Union_Discriminator_char.to_string(), type_ids_Union_Discriminator_char))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_char already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Discriminator_wchar_type_identifier(
        TypeIdentifierPair& type_ids_Union_Discriminator_wchar)
{
    ReturnCode_t return_code_Union_Discriminator_wchar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Discriminator_wchar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Discriminator_wchar", type_ids_Union_Discriminator_wchar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_wchar)
    {
        UnionTypeFlag union_flags_Union_Discriminator_wchar = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Discriminator_wchar = "Union_Discriminator_wchar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Discriminator_wchar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Discriminator_wchar;
        CompleteTypeDetail detail_Union_Discriminator_wchar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Discriminator_wchar, ann_custom_Union_Discriminator_wchar, type_name_Union_Discriminator_wchar.to_string());
        CompleteUnionHeader header_Union_Discriminator_wchar = TypeObjectUtils::build_complete_union_header(detail_Union_Discriminator_wchar);
        UnionDiscriminatorFlag member_flags_Union_Discriminator_wchar = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Discriminator_wchar =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_wchar_t", type_ids_Union_Discriminator_wchar);

        if (return_code_Union_Discriminator_wchar != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Discriminator_wchar;
        if (EK_COMPLETE == type_ids_Union_Discriminator_wchar.type_identifier1()._d() || TK_NONE == type_ids_Union_Discriminator_wchar.type_identifier2()._d())
        {
            common_Union_Discriminator_wchar = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_wchar, type_ids_Union_Discriminator_wchar.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Discriminator_wchar.type_identifier2()._d())
        {
            common_Union_Discriminator_wchar = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_wchar, type_ids_Union_Discriminator_wchar.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_wchar discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Discriminator_wchar.reset();
        ann_custom_Union_Discriminator_wchar.reset();
        CompleteDiscriminatorMember discriminator_Union_Discriminator_wchar = TypeObjectUtils::build_complete_discriminator_member(common_Union_Discriminator_wchar,
                type_ann_builtin_Union_Discriminator_wchar, ann_custom_Union_Discriminator_wchar);
        CompleteUnionMemberSeq member_seq_Union_Discriminator_wchar;
        {
            return_code_Union_Discriminator_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_Union_Discriminator_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_wchar)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "first Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_first = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_first;
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>(L'a'));
            MemberId member_id_first = 0x00000001;
            bool common_first_ec {false};
            CommonUnionMember common_first {TypeObjectUtils::build_common_union_member(member_id_first,
                    member_flags_first, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_wchar,
                        common_first_ec), label_seq_first)};
            if (!common_first_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union first member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_first = "first";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_first;
            ann_custom_Union_Discriminator_wchar.reset();
            CompleteMemberDetail detail_first = TypeObjectUtils::build_complete_member_detail(name_first, member_ann_builtin_first, ann_custom_Union_Discriminator_wchar);
            CompleteUnionMember member_first = TypeObjectUtils::build_complete_union_member(common_first, detail_first);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_wchar, member_first);
        }
        {
            return_code_Union_Discriminator_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_Union_Discriminator_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_wchar)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "second Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_second = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_second;
            TypeObjectUtils::add_union_case_label(label_seq_second, static_cast<int32_t>(L'b'));
            MemberId member_id_second = 0x00000002;
            bool common_second_ec {false};
            CommonUnionMember common_second {TypeObjectUtils::build_common_union_member(member_id_second,
                    member_flags_second, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_wchar,
                        common_second_ec), label_seq_second)};
            if (!common_second_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union second member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_second = "second";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_second;
            ann_custom_Union_Discriminator_wchar.reset();
            CompleteMemberDetail detail_second = TypeObjectUtils::build_complete_member_detail(name_second, member_ann_builtin_second, ann_custom_Union_Discriminator_wchar);
            CompleteUnionMember member_second = TypeObjectUtils::build_complete_union_member(common_second, detail_second);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_wchar, member_second);
        }
        CompleteUnionType union_type_Union_Discriminator_wchar = TypeObjectUtils::build_complete_union_type(union_flags_Union_Discriminator_wchar, header_Union_Discriminator_wchar, discriminator_Union_Discriminator_wchar,
                member_seq_Union_Discriminator_wchar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Discriminator_wchar, type_name_Union_Discriminator_wchar.to_string(), type_ids_Union_Discriminator_wchar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_wchar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Discriminator_enum_type_identifier(
        TypeIdentifierPair& type_ids_Union_Discriminator_enum)
{
    ReturnCode_t return_code_Union_Discriminator_enum {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Discriminator_enum =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Discriminator_enum", type_ids_Union_Discriminator_enum);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_enum)
    {
        UnionTypeFlag union_flags_Union_Discriminator_enum = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Discriminator_enum = "Union_Discriminator_enum";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Discriminator_enum;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Discriminator_enum;
        CompleteTypeDetail detail_Union_Discriminator_enum = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Discriminator_enum, ann_custom_Union_Discriminator_enum, type_name_Union_Discriminator_enum.to_string());
        CompleteUnionHeader header_Union_Discriminator_enum = TypeObjectUtils::build_complete_union_header(detail_Union_Discriminator_enum);
        UnionDiscriminatorFlag member_flags_Union_Discriminator_enum = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Discriminator_enum =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "InnerEnumHelper", type_ids_Union_Discriminator_enum);

        if (return_code_Union_Discriminator_enum != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_InnerEnumHelper_type_identifier(type_ids_Union_Discriminator_enum);
        }
        CommonDiscriminatorMember common_Union_Discriminator_enum;
        if (EK_COMPLETE == type_ids_Union_Discriminator_enum.type_identifier1()._d() || TK_NONE == type_ids_Union_Discriminator_enum.type_identifier2()._d())
        {
            common_Union_Discriminator_enum = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_enum, type_ids_Union_Discriminator_enum.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Discriminator_enum.type_identifier2()._d())
        {
            common_Union_Discriminator_enum = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_enum, type_ids_Union_Discriminator_enum.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_enum discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Discriminator_enum.reset();
        ann_custom_Union_Discriminator_enum.reset();
        CompleteDiscriminatorMember discriminator_Union_Discriminator_enum = TypeObjectUtils::build_complete_discriminator_member(common_Union_Discriminator_enum,
                type_ann_builtin_Union_Discriminator_enum, ann_custom_Union_Discriminator_enum);
        CompleteUnionMemberSeq member_seq_Union_Discriminator_enum;
        {
            return_code_Union_Discriminator_enum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_Union_Discriminator_enum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_enum)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "first Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_first = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_first;
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>(InnerEnumHelper::ENUM_VALUE_1));
            MemberId member_id_first = 0x00000001;
            bool common_first_ec {false};
            CommonUnionMember common_first {TypeObjectUtils::build_common_union_member(member_id_first,
                    member_flags_first, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_enum,
                        common_first_ec), label_seq_first)};
            if (!common_first_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union first member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_first = "first";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_first;
            ann_custom_Union_Discriminator_enum.reset();
            CompleteMemberDetail detail_first = TypeObjectUtils::build_complete_member_detail(name_first, member_ann_builtin_first, ann_custom_Union_Discriminator_enum);
            CompleteUnionMember member_first = TypeObjectUtils::build_complete_union_member(common_first, detail_first);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_enum, member_first);
        }
        {
            return_code_Union_Discriminator_enum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_Union_Discriminator_enum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_enum)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "second Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_second = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_second;
            TypeObjectUtils::add_union_case_label(label_seq_second, static_cast<int32_t>(InnerEnumHelper::ENUM_VALUE_2));
            MemberId member_id_second = 0x00000002;
            bool common_second_ec {false};
            CommonUnionMember common_second {TypeObjectUtils::build_common_union_member(member_id_second,
                    member_flags_second, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_enum,
                        common_second_ec), label_seq_second)};
            if (!common_second_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union second member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_second = "second";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_second;
            ann_custom_Union_Discriminator_enum.reset();
            CompleteMemberDetail detail_second = TypeObjectUtils::build_complete_member_detail(name_second, member_ann_builtin_second, ann_custom_Union_Discriminator_enum);
            CompleteUnionMember member_second = TypeObjectUtils::build_complete_union_member(common_second, detail_second);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_enum, member_second);
        }
        {
            return_code_Union_Discriminator_enum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_Union_Discriminator_enum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_enum)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "third Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_third = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false);
            UnionCaseLabelSeq label_seq_third;
            MemberId member_id_third = 0x00000003;
            bool common_third_ec {false};
            CommonUnionMember common_third {TypeObjectUtils::build_common_union_member(member_id_third,
                    member_flags_third, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_enum,
                        common_third_ec), label_seq_third)};
            if (!common_third_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union third member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_third = "third";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_third;
            ann_custom_Union_Discriminator_enum.reset();
            CompleteMemberDetail detail_third = TypeObjectUtils::build_complete_member_detail(name_third, member_ann_builtin_third, ann_custom_Union_Discriminator_enum);
            CompleteUnionMember member_third = TypeObjectUtils::build_complete_union_member(common_third, detail_third);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_enum, member_third);
        }
        CompleteUnionType union_type_Union_Discriminator_enum = TypeObjectUtils::build_complete_union_type(union_flags_Union_Discriminator_enum, header_Union_Discriminator_enum, discriminator_Union_Discriminator_enum,
                member_seq_Union_Discriminator_enum);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Discriminator_enum, type_name_Union_Discriminator_enum.to_string(), type_ids_Union_Discriminator_enum))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_enum already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Discriminator_enum_labels_type_identifier(
        TypeIdentifierPair& type_ids_Union_Discriminator_enum_labels)
{
    ReturnCode_t return_code_Union_Discriminator_enum_labels {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Discriminator_enum_labels =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Discriminator_enum_labels", type_ids_Union_Discriminator_enum_labels);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_enum_labels)
    {
        UnionTypeFlag union_flags_Union_Discriminator_enum_labels = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Discriminator_enum_labels = "Union_Discriminator_enum_labels";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Discriminator_enum_labels;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Discriminator_enum_labels;
        CompleteTypeDetail detail_Union_Discriminator_enum_labels = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Discriminator_enum_labels, ann_custom_Union_Discriminator_enum_labels, type_name_Union_Discriminator_enum_labels.to_string());
        CompleteUnionHeader header_Union_Discriminator_enum_labels = TypeObjectUtils::build_complete_union_header(detail_Union_Discriminator_enum_labels);
        UnionDiscriminatorFlag member_flags_Union_Discriminator_enum_labels = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Discriminator_enum_labels =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "InnerEnumHelper", type_ids_Union_Discriminator_enum_labels);

        if (return_code_Union_Discriminator_enum_labels != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_InnerEnumHelper_type_identifier(type_ids_Union_Discriminator_enum_labels);
        }
        CommonDiscriminatorMember common_Union_Discriminator_enum_labels;
        if (EK_COMPLETE == type_ids_Union_Discriminator_enum_labels.type_identifier1()._d() || TK_NONE == type_ids_Union_Discriminator_enum_labels.type_identifier2()._d())
        {
            common_Union_Discriminator_enum_labels = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_enum_labels, type_ids_Union_Discriminator_enum_labels.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Discriminator_enum_labels.type_identifier2()._d())
        {
            common_Union_Discriminator_enum_labels = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_enum_labels, type_ids_Union_Discriminator_enum_labels.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_enum_labels discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Discriminator_enum_labels.reset();
        ann_custom_Union_Discriminator_enum_labels.reset();
        CompleteDiscriminatorMember discriminator_Union_Discriminator_enum_labels = TypeObjectUtils::build_complete_discriminator_member(common_Union_Discriminator_enum_labels,
                type_ann_builtin_Union_Discriminator_enum_labels, ann_custom_Union_Discriminator_enum_labels);
        CompleteUnionMemberSeq member_seq_Union_Discriminator_enum_labels;
        {
            return_code_Union_Discriminator_enum_labels =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_Union_Discriminator_enum_labels);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_enum_labels)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "first Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_first = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_first;
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>(InnerEnumHelper::ENUM_VALUE_3));
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>(InnerEnumHelper::ENUM_VALUE_1));
            MemberId member_id_first = 0x00000001;
            bool common_first_ec {false};
            CommonUnionMember common_first {TypeObjectUtils::build_common_union_member(member_id_first,
                    member_flags_first, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_enum_labels,
                        common_first_ec), label_seq_first)};
            if (!common_first_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union first member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_first = "first";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_first;
            ann_custom_Union_Discriminator_enum_labels.reset();
            CompleteMemberDetail detail_first = TypeObjectUtils::build_complete_member_detail(name_first, member_ann_builtin_first, ann_custom_Union_Discriminator_enum_labels);
            CompleteUnionMember member_first = TypeObjectUtils::build_complete_union_member(common_first, detail_first);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_enum_labels, member_first);
        }
        {
            return_code_Union_Discriminator_enum_labels =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_Union_Discriminator_enum_labels);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_enum_labels)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "second Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_second = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_second;
            TypeObjectUtils::add_union_case_label(label_seq_second, static_cast<int32_t>(InnerEnumHelper::ENUM_VALUE_2));
            MemberId member_id_second = 0x00000002;
            bool common_second_ec {false};
            CommonUnionMember common_second {TypeObjectUtils::build_common_union_member(member_id_second,
                    member_flags_second, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_enum_labels,
                        common_second_ec), label_seq_second)};
            if (!common_second_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union second member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_second = "second";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_second;
            ann_custom_Union_Discriminator_enum_labels.reset();
            CompleteMemberDetail detail_second = TypeObjectUtils::build_complete_member_detail(name_second, member_ann_builtin_second, ann_custom_Union_Discriminator_enum_labels);
            CompleteUnionMember member_second = TypeObjectUtils::build_complete_union_member(common_second, detail_second);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_enum_labels, member_second);
        }
        CompleteUnionType union_type_Union_Discriminator_enum_labels = TypeObjectUtils::build_complete_union_type(union_flags_Union_Discriminator_enum_labels, header_Union_Discriminator_enum_labels, discriminator_Union_Discriminator_enum_labels,
                member_seq_Union_Discriminator_enum_labels);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Discriminator_enum_labels, type_name_Union_Discriminator_enum_labels.to_string(), type_ids_Union_Discriminator_enum_labels))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_enum_labels already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Discriminator_alias_type_identifier(
        TypeIdentifierPair& type_ids_Union_Discriminator_alias)
{
    ReturnCode_t return_code_Union_Discriminator_alias {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Discriminator_alias =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Discriminator_alias", type_ids_Union_Discriminator_alias);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_alias)
    {
        UnionTypeFlag union_flags_Union_Discriminator_alias = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Discriminator_alias = "Union_Discriminator_alias";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Discriminator_alias;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Discriminator_alias;
        CompleteTypeDetail detail_Union_Discriminator_alias = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Discriminator_alias, ann_custom_Union_Discriminator_alias, type_name_Union_Discriminator_alias.to_string());
        CompleteUnionHeader header_Union_Discriminator_alias = TypeObjectUtils::build_complete_union_header(detail_Union_Discriminator_alias);
        UnionDiscriminatorFlag member_flags_Union_Discriminator_alias = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Discriminator_alias =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "InnerAliasHelper", type_ids_Union_Discriminator_alias);

        if (return_code_Union_Discriminator_alias != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_InnerAliasHelper_type_identifier(type_ids_Union_Discriminator_alias);
        }
        CommonDiscriminatorMember common_Union_Discriminator_alias;
        if (EK_COMPLETE == type_ids_Union_Discriminator_alias.type_identifier1()._d() || TK_NONE == type_ids_Union_Discriminator_alias.type_identifier2()._d())
        {
            common_Union_Discriminator_alias = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_alias, type_ids_Union_Discriminator_alias.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Discriminator_alias.type_identifier2()._d())
        {
            common_Union_Discriminator_alias = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Discriminator_alias, type_ids_Union_Discriminator_alias.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_alias discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Discriminator_alias.reset();
        ann_custom_Union_Discriminator_alias.reset();
        CompleteDiscriminatorMember discriminator_Union_Discriminator_alias = TypeObjectUtils::build_complete_discriminator_member(common_Union_Discriminator_alias,
                type_ann_builtin_Union_Discriminator_alias, ann_custom_Union_Discriminator_alias);
        CompleteUnionMemberSeq member_seq_Union_Discriminator_alias;
        {
            return_code_Union_Discriminator_alias =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_Union_Discriminator_alias);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_alias)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "first Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_first = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_first;
            TypeObjectUtils::add_union_case_label(label_seq_first, static_cast<int32_t>(1));
            MemberId member_id_first = 0x00000001;
            bool common_first_ec {false};
            CommonUnionMember common_first {TypeObjectUtils::build_common_union_member(member_id_first,
                    member_flags_first, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_alias,
                        common_first_ec), label_seq_first)};
            if (!common_first_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union first member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_first = "first";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_first;
            ann_custom_Union_Discriminator_alias.reset();
            CompleteMemberDetail detail_first = TypeObjectUtils::build_complete_member_detail(name_first, member_ann_builtin_first, ann_custom_Union_Discriminator_alias);
            CompleteUnionMember member_first = TypeObjectUtils::build_complete_union_member(common_first, detail_first);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_alias, member_first);
        }
        {
            return_code_Union_Discriminator_alias =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_Union_Discriminator_alias);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Discriminator_alias)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "second Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_second = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_second;
            TypeObjectUtils::add_union_case_label(label_seq_second, static_cast<int32_t>(2));
            MemberId member_id_second = 0x00000002;
            bool common_second_ec {false};
            CommonUnionMember common_second {TypeObjectUtils::build_common_union_member(member_id_second,
                    member_flags_second, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Discriminator_alias,
                        common_second_ec), label_seq_second)};
            if (!common_second_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union second member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_second = "second";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_second;
            ann_custom_Union_Discriminator_alias.reset();
            CompleteMemberDetail detail_second = TypeObjectUtils::build_complete_member_detail(name_second, member_ann_builtin_second, ann_custom_Union_Discriminator_alias);
            CompleteUnionMember member_second = TypeObjectUtils::build_complete_union_member(common_second, detail_second);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Discriminator_alias, member_second);
        }
        CompleteUnionType union_type_Union_Discriminator_alias = TypeObjectUtils::build_complete_union_type(union_flags_Union_Discriminator_alias, header_Union_Discriminator_alias, discriminator_Union_Discriminator_alias,
                member_seq_Union_Discriminator_alias);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Discriminator_alias, type_name_Union_Discriminator_alias.to_string(), type_ids_Union_Discriminator_alias))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Discriminator_alias already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Several_Fields_type_identifier(
        TypeIdentifierPair& type_ids_Union_Several_Fields)
{
    ReturnCode_t return_code_Union_Several_Fields {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Several_Fields =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Several_Fields", type_ids_Union_Several_Fields);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Several_Fields)
    {
        UnionTypeFlag union_flags_Union_Several_Fields = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Several_Fields = "Union_Several_Fields";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Several_Fields;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Several_Fields;
        CompleteTypeDetail detail_Union_Several_Fields = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Several_Fields, ann_custom_Union_Several_Fields, type_name_Union_Several_Fields.to_string());
        CompleteUnionHeader header_Union_Several_Fields = TypeObjectUtils::build_complete_union_header(detail_Union_Several_Fields);
        UnionDiscriminatorFlag member_flags_Union_Several_Fields = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Several_Fields =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_Several_Fields);

        if (return_code_Union_Several_Fields != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Several_Fields;
        if (EK_COMPLETE == type_ids_Union_Several_Fields.type_identifier1()._d() || TK_NONE == type_ids_Union_Several_Fields.type_identifier2()._d())
        {
            common_Union_Several_Fields = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Several_Fields, type_ids_Union_Several_Fields.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Several_Fields.type_identifier2()._d())
        {
            common_Union_Several_Fields = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Several_Fields, type_ids_Union_Several_Fields.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Several_Fields discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Several_Fields.reset();
        ann_custom_Union_Several_Fields.reset();
        CompleteDiscriminatorMember discriminator_Union_Several_Fields = TypeObjectUtils::build_complete_discriminator_member(common_Union_Several_Fields,
                type_ann_builtin_Union_Several_Fields, ann_custom_Union_Several_Fields);
        CompleteUnionMemberSeq member_seq_Union_Several_Fields;
        {
            return_code_Union_Several_Fields =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructureHelper", type_ids_Union_Several_Fields);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Several_Fields)
            {
            ::register_InnerStructureHelper_type_identifier(type_ids_Union_Several_Fields);
            }
            UnionMemberFlag member_flags_a = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_a;
            TypeObjectUtils::add_union_case_label(label_seq_a, static_cast<int32_t>(0));
            MemberId member_id_a = 0x00000001;
            bool common_a_ec {false};
            CommonUnionMember common_a {TypeObjectUtils::build_common_union_member(member_id_a,
                    member_flags_a, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Several_Fields,
                        common_a_ec), label_seq_a)};
            if (!common_a_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union a member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_a = "a";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_a;
            ann_custom_Union_Several_Fields.reset();
            CompleteMemberDetail detail_a = TypeObjectUtils::build_complete_member_detail(name_a, member_ann_builtin_a, ann_custom_Union_Several_Fields);
            CompleteUnionMember member_a = TypeObjectUtils::build_complete_union_member(common_a, detail_a);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Several_Fields, member_a);
        }
        {
            return_code_Union_Several_Fields =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerEmptyStructureHelper", type_ids_Union_Several_Fields);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Several_Fields)
            {
            ::register_InnerEmptyStructureHelper_type_identifier(type_ids_Union_Several_Fields);
            }
            UnionMemberFlag member_flags_b = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_b;
            TypeObjectUtils::add_union_case_label(label_seq_b, static_cast<int32_t>(1));
            MemberId member_id_b = 0x00000002;
            bool common_b_ec {false};
            CommonUnionMember common_b {TypeObjectUtils::build_common_union_member(member_id_b,
                    member_flags_b, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Several_Fields,
                        common_b_ec), label_seq_b)};
            if (!common_b_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union b member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_b = "b";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_b;
            ann_custom_Union_Several_Fields.reset();
            CompleteMemberDetail detail_b = TypeObjectUtils::build_complete_member_detail(name_b, member_ann_builtin_b, ann_custom_Union_Several_Fields);
            CompleteUnionMember member_b = TypeObjectUtils::build_complete_union_member(common_b, detail_b);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Several_Fields, member_b);
        }
        {
            return_code_Union_Several_Fields =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Inner_alias_bounded_string_helper", type_ids_Union_Several_Fields);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Several_Fields)
            {
            ::register_Inner_alias_bounded_string_helper_type_identifier(type_ids_Union_Several_Fields);
            }
            UnionMemberFlag member_flags_c = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_c;
            TypeObjectUtils::add_union_case_label(label_seq_c, static_cast<int32_t>(2));
            MemberId member_id_c = 0x00000003;
            bool common_c_ec {false};
            CommonUnionMember common_c {TypeObjectUtils::build_common_union_member(member_id_c,
                    member_flags_c, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Several_Fields,
                        common_c_ec), label_seq_c)};
            if (!common_c_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union c member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_c = "c";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_c;
            ann_custom_Union_Several_Fields.reset();
            CompleteMemberDetail detail_c = TypeObjectUtils::build_complete_member_detail(name_c, member_ann_builtin_c, ann_custom_Union_Several_Fields);
            CompleteUnionMember member_c = TypeObjectUtils::build_complete_union_member(common_c, detail_c);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Several_Fields, member_c);
        }
        {
            return_code_Union_Several_Fields =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Inner_alias_array_helper", type_ids_Union_Several_Fields);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Several_Fields)
            {
            ::register_Inner_alias_array_helper_type_identifier(type_ids_Union_Several_Fields);
            }
            UnionMemberFlag member_flags_d = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_d;
            TypeObjectUtils::add_union_case_label(label_seq_d, static_cast<int32_t>(3));
            MemberId member_id_d = 0x00000004;
            bool common_d_ec {false};
            CommonUnionMember common_d {TypeObjectUtils::build_common_union_member(member_id_d,
                    member_flags_d, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Several_Fields,
                        common_d_ec), label_seq_d)};
            if (!common_d_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union d member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_d = "d";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_d;
            ann_custom_Union_Several_Fields.reset();
            CompleteMemberDetail detail_d = TypeObjectUtils::build_complete_member_detail(name_d, member_ann_builtin_d, ann_custom_Union_Several_Fields);
            CompleteUnionMember member_d = TypeObjectUtils::build_complete_union_member(common_d, detail_d);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Several_Fields, member_d);
        }
        {
            return_code_Union_Several_Fields =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Inner_alias_sequence_helper", type_ids_Union_Several_Fields);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Several_Fields)
            {
            ::register_Inner_alias_sequence_helper_type_identifier(type_ids_Union_Several_Fields);
            }
            UnionMemberFlag member_flags_e = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_e;
            TypeObjectUtils::add_union_case_label(label_seq_e, static_cast<int32_t>(4));
            MemberId member_id_e = 0x00000005;
            bool common_e_ec {false};
            CommonUnionMember common_e {TypeObjectUtils::build_common_union_member(member_id_e,
                    member_flags_e, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Several_Fields,
                        common_e_ec), label_seq_e)};
            if (!common_e_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union e member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_e = "e";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_e;
            ann_custom_Union_Several_Fields.reset();
            CompleteMemberDetail detail_e = TypeObjectUtils::build_complete_member_detail(name_e, member_ann_builtin_e, ann_custom_Union_Several_Fields);
            CompleteUnionMember member_e = TypeObjectUtils::build_complete_union_member(common_e, detail_e);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Several_Fields, member_e);
        }
        CompleteUnionType union_type_Union_Several_Fields = TypeObjectUtils::build_complete_union_type(union_flags_Union_Several_Fields, header_Union_Several_Fields, discriminator_Union_Several_Fields,
                member_seq_Union_Several_Fields);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Several_Fields, type_name_Union_Several_Fields.to_string(), type_ids_Union_Several_Fields))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Several_Fields already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Union_Several_Fields_With_Default_type_identifier(
        TypeIdentifierPair& type_ids_Union_Several_Fields_With_Default)
{
    ReturnCode_t return_code_Union_Several_Fields_With_Default {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Union_Several_Fields_With_Default =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Union_Several_Fields_With_Default", type_ids_Union_Several_Fields_With_Default);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Several_Fields_With_Default)
    {
        UnionTypeFlag union_flags_Union_Several_Fields_With_Default = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Union_Several_Fields_With_Default = "Union_Several_Fields_With_Default";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Union_Several_Fields_With_Default;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Union_Several_Fields_With_Default;
        CompleteTypeDetail detail_Union_Several_Fields_With_Default = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Union_Several_Fields_With_Default, ann_custom_Union_Several_Fields_With_Default, type_name_Union_Several_Fields_With_Default.to_string());
        CompleteUnionHeader header_Union_Several_Fields_With_Default = TypeObjectUtils::build_complete_union_header(detail_Union_Several_Fields_With_Default);
        UnionDiscriminatorFlag member_flags_Union_Several_Fields_With_Default = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Union_Several_Fields_With_Default =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_Union_Several_Fields_With_Default);

        if (return_code_Union_Several_Fields_With_Default != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Union_Several_Fields_With_Default;
        if (EK_COMPLETE == type_ids_Union_Several_Fields_With_Default.type_identifier1()._d() || TK_NONE == type_ids_Union_Several_Fields_With_Default.type_identifier2()._d())
        {
            common_Union_Several_Fields_With_Default = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Several_Fields_With_Default, type_ids_Union_Several_Fields_With_Default.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Union_Several_Fields_With_Default.type_identifier2()._d())
        {
            common_Union_Several_Fields_With_Default = TypeObjectUtils::build_common_discriminator_member(member_flags_Union_Several_Fields_With_Default, type_ids_Union_Several_Fields_With_Default.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Several_Fields_With_Default discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Union_Several_Fields_With_Default.reset();
        ann_custom_Union_Several_Fields_With_Default.reset();
        CompleteDiscriminatorMember discriminator_Union_Several_Fields_With_Default = TypeObjectUtils::build_complete_discriminator_member(common_Union_Several_Fields_With_Default,
                type_ann_builtin_Union_Several_Fields_With_Default, ann_custom_Union_Several_Fields_With_Default);
        CompleteUnionMemberSeq member_seq_Union_Several_Fields_With_Default;
        {
            return_code_Union_Several_Fields_With_Default =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructureHelper", type_ids_Union_Several_Fields_With_Default);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Several_Fields_With_Default)
            {
            ::register_InnerStructureHelper_type_identifier(type_ids_Union_Several_Fields_With_Default);
            }
            UnionMemberFlag member_flags_a = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_a;
            TypeObjectUtils::add_union_case_label(label_seq_a, static_cast<int32_t>(0));
            MemberId member_id_a = 0x00000001;
            bool common_a_ec {false};
            CommonUnionMember common_a {TypeObjectUtils::build_common_union_member(member_id_a,
                    member_flags_a, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Several_Fields_With_Default,
                        common_a_ec), label_seq_a)};
            if (!common_a_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union a member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_a = "a";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_a;
            ann_custom_Union_Several_Fields_With_Default.reset();
            CompleteMemberDetail detail_a = TypeObjectUtils::build_complete_member_detail(name_a, member_ann_builtin_a, ann_custom_Union_Several_Fields_With_Default);
            CompleteUnionMember member_a = TypeObjectUtils::build_complete_union_member(common_a, detail_a);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Several_Fields_With_Default, member_a);
        }
        {
            return_code_Union_Several_Fields_With_Default =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerEmptyStructureHelper", type_ids_Union_Several_Fields_With_Default);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Several_Fields_With_Default)
            {
            ::register_InnerEmptyStructureHelper_type_identifier(type_ids_Union_Several_Fields_With_Default);
            }
            UnionMemberFlag member_flags_b = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_b;
            TypeObjectUtils::add_union_case_label(label_seq_b, static_cast<int32_t>(1));
            MemberId member_id_b = 0x00000002;
            bool common_b_ec {false};
            CommonUnionMember common_b {TypeObjectUtils::build_common_union_member(member_id_b,
                    member_flags_b, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Several_Fields_With_Default,
                        common_b_ec), label_seq_b)};
            if (!common_b_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union b member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_b = "b";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_b;
            ann_custom_Union_Several_Fields_With_Default.reset();
            CompleteMemberDetail detail_b = TypeObjectUtils::build_complete_member_detail(name_b, member_ann_builtin_b, ann_custom_Union_Several_Fields_With_Default);
            CompleteUnionMember member_b = TypeObjectUtils::build_complete_union_member(common_b, detail_b);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Several_Fields_With_Default, member_b);
        }
        {
            return_code_Union_Several_Fields_With_Default =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Inner_alias_bounded_string_helper", type_ids_Union_Several_Fields_With_Default);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Several_Fields_With_Default)
            {
            ::register_Inner_alias_bounded_string_helper_type_identifier(type_ids_Union_Several_Fields_With_Default);
            }
            UnionMemberFlag member_flags_c = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_c;
            TypeObjectUtils::add_union_case_label(label_seq_c, static_cast<int32_t>(2));
            MemberId member_id_c = 0x00000003;
            bool common_c_ec {false};
            CommonUnionMember common_c {TypeObjectUtils::build_common_union_member(member_id_c,
                    member_flags_c, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Several_Fields_With_Default,
                        common_c_ec), label_seq_c)};
            if (!common_c_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union c member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_c = "c";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_c;
            ann_custom_Union_Several_Fields_With_Default.reset();
            CompleteMemberDetail detail_c = TypeObjectUtils::build_complete_member_detail(name_c, member_ann_builtin_c, ann_custom_Union_Several_Fields_With_Default);
            CompleteUnionMember member_c = TypeObjectUtils::build_complete_union_member(common_c, detail_c);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Several_Fields_With_Default, member_c);
        }
        {
            return_code_Union_Several_Fields_With_Default =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Inner_alias_array_helper", type_ids_Union_Several_Fields_With_Default);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Several_Fields_With_Default)
            {
            ::register_Inner_alias_array_helper_type_identifier(type_ids_Union_Several_Fields_With_Default);
            }
            UnionMemberFlag member_flags_d = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_d;
            TypeObjectUtils::add_union_case_label(label_seq_d, static_cast<int32_t>(3));
            MemberId member_id_d = 0x00000004;
            bool common_d_ec {false};
            CommonUnionMember common_d {TypeObjectUtils::build_common_union_member(member_id_d,
                    member_flags_d, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Several_Fields_With_Default,
                        common_d_ec), label_seq_d)};
            if (!common_d_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union d member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_d = "d";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_d;
            ann_custom_Union_Several_Fields_With_Default.reset();
            CompleteMemberDetail detail_d = TypeObjectUtils::build_complete_member_detail(name_d, member_ann_builtin_d, ann_custom_Union_Several_Fields_With_Default);
            CompleteUnionMember member_d = TypeObjectUtils::build_complete_union_member(common_d, detail_d);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Several_Fields_With_Default, member_d);
        }
        {
            return_code_Union_Several_Fields_With_Default =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Inner_alias_sequence_helper", type_ids_Union_Several_Fields_With_Default);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Several_Fields_With_Default)
            {
            ::register_Inner_alias_sequence_helper_type_identifier(type_ids_Union_Several_Fields_With_Default);
            }
            UnionMemberFlag member_flags_e = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_e;
            TypeObjectUtils::add_union_case_label(label_seq_e, static_cast<int32_t>(4));
            MemberId member_id_e = 0x00000005;
            bool common_e_ec {false};
            CommonUnionMember common_e {TypeObjectUtils::build_common_union_member(member_id_e,
                    member_flags_e, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Several_Fields_With_Default,
                        common_e_ec), label_seq_e)};
            if (!common_e_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union e member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_e = "e";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_e;
            ann_custom_Union_Several_Fields_With_Default.reset();
            CompleteMemberDetail detail_e = TypeObjectUtils::build_complete_member_detail(name_e, member_ann_builtin_e, ann_custom_Union_Several_Fields_With_Default);
            CompleteUnionMember member_e = TypeObjectUtils::build_complete_union_member(common_e, detail_e);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Several_Fields_With_Default, member_e);
        }
        {
            return_code_Union_Several_Fields_With_Default =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int16_t_30", type_ids_Union_Several_Fields_With_Default);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Several_Fields_With_Default)
            {
                return_code_Union_Several_Fields_With_Default =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_Union_Several_Fields_With_Default);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_Union_Several_Fields_With_Default)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int16_t_30_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int16_t_30 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Several_Fields_With_Default, element_identifier_anonymous_sequence_int16_t_30_ec))};
                if (!element_identifier_anonymous_sequence_int16_t_30_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int16_t_30 = EK_COMPLETE;
                if (TK_NONE == type_ids_Union_Several_Fields_With_Default.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int16_t_30 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int16_t_30 = 0;
                PlainCollectionHeader header_anonymous_sequence_int16_t_30 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int16_t_30, element_flags_anonymous_sequence_int16_t_30);
                {
                    SBound bound = static_cast<SBound>(30);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int16_t_30, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int16_t_30));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int16_t_30", type_ids_Union_Several_Fields_With_Default))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int16_t_30 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            UnionMemberFlag member_flags_f = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false);
            UnionCaseLabelSeq label_seq_f;
            MemberId member_id_f = 0x00000006;
            bool common_f_ec {false};
            CommonUnionMember common_f {TypeObjectUtils::build_common_union_member(member_id_f,
                    member_flags_f, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Union_Several_Fields_With_Default,
                        common_f_ec), label_seq_f)};
            if (!common_f_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union f member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_f = "f";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_f;
            ann_custom_Union_Several_Fields_With_Default.reset();
            CompleteMemberDetail detail_f = TypeObjectUtils::build_complete_member_detail(name_f, member_ann_builtin_f, ann_custom_Union_Several_Fields_With_Default);
            CompleteUnionMember member_f = TypeObjectUtils::build_complete_union_member(common_f, detail_f);
            TypeObjectUtils::add_complete_union_member(member_seq_Union_Several_Fields_With_Default, member_f);
        }
        CompleteUnionType union_type_Union_Several_Fields_With_Default = TypeObjectUtils::build_complete_union_type(union_flags_Union_Several_Fields_With_Default, header_Union_Several_Fields_With_Default, discriminator_Union_Several_Fields_With_Default,
                member_seq_Union_Several_Fields_With_Default);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Union_Several_Fields_With_Default, type_name_Union_Several_Fields_With_Default.to_string(), type_ids_Union_Several_Fields_With_Default))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union_Several_Fields_With_Default already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionShort_type_identifier(
        TypeIdentifierPair& type_ids_UnionShort)
{

    ReturnCode_t return_code_UnionShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionShort", type_ids_UnionShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionShort)
    {
        StructTypeFlag struct_flags_UnionShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionShort = "UnionShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionShort;
        CompleteTypeDetail detail_UnionShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionShort, ann_custom_UnionShort, type_name_UnionShort.to_string());
        CompleteStructHeader header_UnionShort;
        header_UnionShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionShort);
        CompleteStructMemberSeq member_seq_UnionShort;
        {
            TypeIdentifierPair type_ids_var_union_short;
            ReturnCode_t return_code_var_union_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Short", type_ids_var_union_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_short)
            {
            ::register_Union_Short_type_identifier(type_ids_var_union_short);
            }
            StructMemberFlag member_flags_var_union_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_short = 0x00000000;
            bool common_var_union_short_ec {false};
            CommonStructMember common_var_union_short {TypeObjectUtils::build_common_struct_member(member_id_var_union_short, member_flags_var_union_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_short, common_var_union_short_ec))};
            if (!common_var_union_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_short = "var_union_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_short;
            ann_custom_UnionShort.reset();
            CompleteMemberDetail detail_var_union_short = TypeObjectUtils::build_complete_member_detail(name_var_union_short, member_ann_builtin_var_union_short, ann_custom_UnionShort);
            CompleteStructMember member_var_union_short = TypeObjectUtils::build_complete_struct_member(common_var_union_short, detail_var_union_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionShort, member_var_union_short);
        }
        CompleteStructType struct_type_UnionShort = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionShort, header_UnionShort, member_seq_UnionShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionShort, type_name_UnionShort.to_string(), type_ids_UnionShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionUShort_type_identifier(
        TypeIdentifierPair& type_ids_UnionUShort)
{

    ReturnCode_t return_code_UnionUShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionUShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionUShort", type_ids_UnionUShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionUShort)
    {
        StructTypeFlag struct_flags_UnionUShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionUShort = "UnionUShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionUShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionUShort;
        CompleteTypeDetail detail_UnionUShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionUShort, ann_custom_UnionUShort, type_name_UnionUShort.to_string());
        CompleteStructHeader header_UnionUShort;
        header_UnionUShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionUShort);
        CompleteStructMemberSeq member_seq_UnionUShort;
        {
            TypeIdentifierPair type_ids_var_union_ushort;
            ReturnCode_t return_code_var_union_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_UShort", type_ids_var_union_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_ushort)
            {
            ::register_Union_UShort_type_identifier(type_ids_var_union_ushort);
            }
            StructMemberFlag member_flags_var_union_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_ushort = 0x00000000;
            bool common_var_union_ushort_ec {false};
            CommonStructMember common_var_union_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_union_ushort, member_flags_var_union_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_ushort, common_var_union_ushort_ec))};
            if (!common_var_union_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_ushort = "var_union_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_ushort;
            ann_custom_UnionUShort.reset();
            CompleteMemberDetail detail_var_union_ushort = TypeObjectUtils::build_complete_member_detail(name_var_union_ushort, member_ann_builtin_var_union_ushort, ann_custom_UnionUShort);
            CompleteStructMember member_var_union_ushort = TypeObjectUtils::build_complete_struct_member(common_var_union_ushort, detail_var_union_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionUShort, member_var_union_ushort);
        }
        CompleteStructType struct_type_UnionUShort = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionUShort, header_UnionUShort, member_seq_UnionUShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionUShort, type_name_UnionUShort.to_string(), type_ids_UnionUShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionUShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionLong_type_identifier(
        TypeIdentifierPair& type_ids_UnionLong)
{

    ReturnCode_t return_code_UnionLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionLong", type_ids_UnionLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionLong)
    {
        StructTypeFlag struct_flags_UnionLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionLong = "UnionLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionLong;
        CompleteTypeDetail detail_UnionLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionLong, ann_custom_UnionLong, type_name_UnionLong.to_string());
        CompleteStructHeader header_UnionLong;
        header_UnionLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionLong);
        CompleteStructMemberSeq member_seq_UnionLong;
        {
            TypeIdentifierPair type_ids_var_union_long;
            ReturnCode_t return_code_var_union_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Long", type_ids_var_union_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_long)
            {
            ::register_Union_Long_type_identifier(type_ids_var_union_long);
            }
            StructMemberFlag member_flags_var_union_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_long = 0x00000000;
            bool common_var_union_long_ec {false};
            CommonStructMember common_var_union_long {TypeObjectUtils::build_common_struct_member(member_id_var_union_long, member_flags_var_union_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_long, common_var_union_long_ec))};
            if (!common_var_union_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_long = "var_union_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_long;
            ann_custom_UnionLong.reset();
            CompleteMemberDetail detail_var_union_long = TypeObjectUtils::build_complete_member_detail(name_var_union_long, member_ann_builtin_var_union_long, ann_custom_UnionLong);
            CompleteStructMember member_var_union_long = TypeObjectUtils::build_complete_struct_member(common_var_union_long, detail_var_union_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionLong, member_var_union_long);
        }
        CompleteStructType struct_type_UnionLong = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionLong, header_UnionLong, member_seq_UnionLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionLong, type_name_UnionLong.to_string(), type_ids_UnionLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionULong_type_identifier(
        TypeIdentifierPair& type_ids_UnionULong)
{

    ReturnCode_t return_code_UnionULong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionULong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionULong", type_ids_UnionULong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionULong)
    {
        StructTypeFlag struct_flags_UnionULong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionULong = "UnionULong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionULong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionULong;
        CompleteTypeDetail detail_UnionULong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionULong, ann_custom_UnionULong, type_name_UnionULong.to_string());
        CompleteStructHeader header_UnionULong;
        header_UnionULong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionULong);
        CompleteStructMemberSeq member_seq_UnionULong;
        {
            TypeIdentifierPair type_ids_var_union_ulong;
            ReturnCode_t return_code_var_union_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_ULong", type_ids_var_union_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_ulong)
            {
            ::register_Union_ULong_type_identifier(type_ids_var_union_ulong);
            }
            StructMemberFlag member_flags_var_union_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_ulong = 0x00000000;
            bool common_var_union_ulong_ec {false};
            CommonStructMember common_var_union_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_union_ulong, member_flags_var_union_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_ulong, common_var_union_ulong_ec))};
            if (!common_var_union_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_ulong = "var_union_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_ulong;
            ann_custom_UnionULong.reset();
            CompleteMemberDetail detail_var_union_ulong = TypeObjectUtils::build_complete_member_detail(name_var_union_ulong, member_ann_builtin_var_union_ulong, ann_custom_UnionULong);
            CompleteStructMember member_var_union_ulong = TypeObjectUtils::build_complete_struct_member(common_var_union_ulong, detail_var_union_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionULong, member_var_union_ulong);
        }
        CompleteStructType struct_type_UnionULong = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionULong, header_UnionULong, member_seq_UnionULong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionULong, type_name_UnionULong.to_string(), type_ids_UnionULong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionULong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionLongLong_type_identifier(
        TypeIdentifierPair& type_ids_UnionLongLong)
{

    ReturnCode_t return_code_UnionLongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionLongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionLongLong", type_ids_UnionLongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionLongLong)
    {
        StructTypeFlag struct_flags_UnionLongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionLongLong = "UnionLongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionLongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionLongLong;
        CompleteTypeDetail detail_UnionLongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionLongLong, ann_custom_UnionLongLong, type_name_UnionLongLong.to_string());
        CompleteStructHeader header_UnionLongLong;
        header_UnionLongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionLongLong);
        CompleteStructMemberSeq member_seq_UnionLongLong;
        {
            TypeIdentifierPair type_ids_var_union_long_long;
            ReturnCode_t return_code_var_union_long_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_long_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_LongLong", type_ids_var_union_long_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_long_long)
            {
            ::register_Union_LongLong_type_identifier(type_ids_var_union_long_long);
            }
            StructMemberFlag member_flags_var_union_long_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_long_long = 0x00000000;
            bool common_var_union_long_long_ec {false};
            CommonStructMember common_var_union_long_long {TypeObjectUtils::build_common_struct_member(member_id_var_union_long_long, member_flags_var_union_long_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_long_long, common_var_union_long_long_ec))};
            if (!common_var_union_long_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_long_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_long_long = "var_union_long_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_long_long;
            ann_custom_UnionLongLong.reset();
            CompleteMemberDetail detail_var_union_long_long = TypeObjectUtils::build_complete_member_detail(name_var_union_long_long, member_ann_builtin_var_union_long_long, ann_custom_UnionLongLong);
            CompleteStructMember member_var_union_long_long = TypeObjectUtils::build_complete_struct_member(common_var_union_long_long, detail_var_union_long_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionLongLong, member_var_union_long_long);
        }
        CompleteStructType struct_type_UnionLongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionLongLong, header_UnionLongLong, member_seq_UnionLongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionLongLong, type_name_UnionLongLong.to_string(), type_ids_UnionLongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionLongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionULongLong_type_identifier(
        TypeIdentifierPair& type_ids_UnionULongLong)
{

    ReturnCode_t return_code_UnionULongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionULongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionULongLong", type_ids_UnionULongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionULongLong)
    {
        StructTypeFlag struct_flags_UnionULongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionULongLong = "UnionULongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionULongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionULongLong;
        CompleteTypeDetail detail_UnionULongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionULongLong, ann_custom_UnionULongLong, type_name_UnionULongLong.to_string());
        CompleteStructHeader header_UnionULongLong;
        header_UnionULongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionULongLong);
        CompleteStructMemberSeq member_seq_UnionULongLong;
        {
            TypeIdentifierPair type_ids_var_union_ulong_long;
            ReturnCode_t return_code_var_union_ulong_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_ulong_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_ULongLOng", type_ids_var_union_ulong_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_ulong_long)
            {
            ::register_Union_ULongLOng_type_identifier(type_ids_var_union_ulong_long);
            }
            StructMemberFlag member_flags_var_union_ulong_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_ulong_long = 0x00000000;
            bool common_var_union_ulong_long_ec {false};
            CommonStructMember common_var_union_ulong_long {TypeObjectUtils::build_common_struct_member(member_id_var_union_ulong_long, member_flags_var_union_ulong_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_ulong_long, common_var_union_ulong_long_ec))};
            if (!common_var_union_ulong_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_ulong_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_ulong_long = "var_union_ulong_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_ulong_long;
            ann_custom_UnionULongLong.reset();
            CompleteMemberDetail detail_var_union_ulong_long = TypeObjectUtils::build_complete_member_detail(name_var_union_ulong_long, member_ann_builtin_var_union_ulong_long, ann_custom_UnionULongLong);
            CompleteStructMember member_var_union_ulong_long = TypeObjectUtils::build_complete_struct_member(common_var_union_ulong_long, detail_var_union_ulong_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionULongLong, member_var_union_ulong_long);
        }
        CompleteStructType struct_type_UnionULongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionULongLong, header_UnionULongLong, member_seq_UnionULongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionULongLong, type_name_UnionULongLong.to_string(), type_ids_UnionULongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionULongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionFloat_type_identifier(
        TypeIdentifierPair& type_ids_UnionFloat)
{

    ReturnCode_t return_code_UnionFloat {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionFloat =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionFloat", type_ids_UnionFloat);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionFloat)
    {
        StructTypeFlag struct_flags_UnionFloat = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionFloat = "UnionFloat";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionFloat;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionFloat;
        CompleteTypeDetail detail_UnionFloat = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionFloat, ann_custom_UnionFloat, type_name_UnionFloat.to_string());
        CompleteStructHeader header_UnionFloat;
        header_UnionFloat = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionFloat);
        CompleteStructMemberSeq member_seq_UnionFloat;
        {
            TypeIdentifierPair type_ids_var_union_float;
            ReturnCode_t return_code_var_union_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Float", type_ids_var_union_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_float)
            {
            ::register_Union_Float_type_identifier(type_ids_var_union_float);
            }
            StructMemberFlag member_flags_var_union_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_float = 0x00000000;
            bool common_var_union_float_ec {false};
            CommonStructMember common_var_union_float {TypeObjectUtils::build_common_struct_member(member_id_var_union_float, member_flags_var_union_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_float, common_var_union_float_ec))};
            if (!common_var_union_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_float = "var_union_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_float;
            ann_custom_UnionFloat.reset();
            CompleteMemberDetail detail_var_union_float = TypeObjectUtils::build_complete_member_detail(name_var_union_float, member_ann_builtin_var_union_float, ann_custom_UnionFloat);
            CompleteStructMember member_var_union_float = TypeObjectUtils::build_complete_struct_member(common_var_union_float, detail_var_union_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionFloat, member_var_union_float);
        }
        CompleteStructType struct_type_UnionFloat = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionFloat, header_UnionFloat, member_seq_UnionFloat);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionFloat, type_name_UnionFloat.to_string(), type_ids_UnionFloat))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionFloat already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionDouble_type_identifier(
        TypeIdentifierPair& type_ids_UnionDouble)
{

    ReturnCode_t return_code_UnionDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionDouble", type_ids_UnionDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionDouble)
    {
        StructTypeFlag struct_flags_UnionDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionDouble = "UnionDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionDouble;
        CompleteTypeDetail detail_UnionDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionDouble, ann_custom_UnionDouble, type_name_UnionDouble.to_string());
        CompleteStructHeader header_UnionDouble;
        header_UnionDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionDouble);
        CompleteStructMemberSeq member_seq_UnionDouble;
        {
            TypeIdentifierPair type_ids_var_union_double;
            ReturnCode_t return_code_var_union_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Double", type_ids_var_union_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_double)
            {
            ::register_Union_Double_type_identifier(type_ids_var_union_double);
            }
            StructMemberFlag member_flags_var_union_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_double = 0x00000000;
            bool common_var_union_double_ec {false};
            CommonStructMember common_var_union_double {TypeObjectUtils::build_common_struct_member(member_id_var_union_double, member_flags_var_union_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_double, common_var_union_double_ec))};
            if (!common_var_union_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_double = "var_union_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_double;
            ann_custom_UnionDouble.reset();
            CompleteMemberDetail detail_var_union_double = TypeObjectUtils::build_complete_member_detail(name_var_union_double, member_ann_builtin_var_union_double, ann_custom_UnionDouble);
            CompleteStructMember member_var_union_double = TypeObjectUtils::build_complete_struct_member(common_var_union_double, detail_var_union_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionDouble, member_var_union_double);
        }
        CompleteStructType struct_type_UnionDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionDouble, header_UnionDouble, member_seq_UnionDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionDouble, type_name_UnionDouble.to_string(), type_ids_UnionDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionLongDouble_type_identifier(
        TypeIdentifierPair& type_ids_UnionLongDouble)
{

    ReturnCode_t return_code_UnionLongDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionLongDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionLongDouble", type_ids_UnionLongDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionLongDouble)
    {
        StructTypeFlag struct_flags_UnionLongDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionLongDouble = "UnionLongDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionLongDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionLongDouble;
        CompleteTypeDetail detail_UnionLongDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionLongDouble, ann_custom_UnionLongDouble, type_name_UnionLongDouble.to_string());
        CompleteStructHeader header_UnionLongDouble;
        header_UnionLongDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionLongDouble);
        CompleteStructMemberSeq member_seq_UnionLongDouble;
        {
            TypeIdentifierPair type_ids_var_union_long_double;
            ReturnCode_t return_code_var_union_long_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_long_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_LongDouble", type_ids_var_union_long_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_long_double)
            {
            ::register_Union_LongDouble_type_identifier(type_ids_var_union_long_double);
            }
            StructMemberFlag member_flags_var_union_long_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_long_double = 0x00000000;
            bool common_var_union_long_double_ec {false};
            CommonStructMember common_var_union_long_double {TypeObjectUtils::build_common_struct_member(member_id_var_union_long_double, member_flags_var_union_long_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_long_double, common_var_union_long_double_ec))};
            if (!common_var_union_long_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_long_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_long_double = "var_union_long_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_long_double;
            ann_custom_UnionLongDouble.reset();
            CompleteMemberDetail detail_var_union_long_double = TypeObjectUtils::build_complete_member_detail(name_var_union_long_double, member_ann_builtin_var_union_long_double, ann_custom_UnionLongDouble);
            CompleteStructMember member_var_union_long_double = TypeObjectUtils::build_complete_struct_member(common_var_union_long_double, detail_var_union_long_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionLongDouble, member_var_union_long_double);
        }
        CompleteStructType struct_type_UnionLongDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionLongDouble, header_UnionLongDouble, member_seq_UnionLongDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionLongDouble, type_name_UnionLongDouble.to_string(), type_ids_UnionLongDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionLongDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionBoolean_type_identifier(
        TypeIdentifierPair& type_ids_UnionBoolean)
{

    ReturnCode_t return_code_UnionBoolean {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionBoolean =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionBoolean", type_ids_UnionBoolean);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionBoolean)
    {
        StructTypeFlag struct_flags_UnionBoolean = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionBoolean = "UnionBoolean";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionBoolean;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionBoolean;
        CompleteTypeDetail detail_UnionBoolean = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionBoolean, ann_custom_UnionBoolean, type_name_UnionBoolean.to_string());
        CompleteStructHeader header_UnionBoolean;
        header_UnionBoolean = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionBoolean);
        CompleteStructMemberSeq member_seq_UnionBoolean;
        {
            TypeIdentifierPair type_ids_var_union_boolean;
            ReturnCode_t return_code_var_union_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Boolean", type_ids_var_union_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_boolean)
            {
            ::register_Union_Boolean_type_identifier(type_ids_var_union_boolean);
            }
            StructMemberFlag member_flags_var_union_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_boolean = 0x00000000;
            bool common_var_union_boolean_ec {false};
            CommonStructMember common_var_union_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_union_boolean, member_flags_var_union_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_boolean, common_var_union_boolean_ec))};
            if (!common_var_union_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_boolean = "var_union_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_boolean;
            ann_custom_UnionBoolean.reset();
            CompleteMemberDetail detail_var_union_boolean = TypeObjectUtils::build_complete_member_detail(name_var_union_boolean, member_ann_builtin_var_union_boolean, ann_custom_UnionBoolean);
            CompleteStructMember member_var_union_boolean = TypeObjectUtils::build_complete_struct_member(common_var_union_boolean, detail_var_union_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionBoolean, member_var_union_boolean);
        }
        CompleteStructType struct_type_UnionBoolean = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionBoolean, header_UnionBoolean, member_seq_UnionBoolean);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionBoolean, type_name_UnionBoolean.to_string(), type_ids_UnionBoolean))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionBoolean already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionOctet_type_identifier(
        TypeIdentifierPair& type_ids_UnionOctet)
{

    ReturnCode_t return_code_UnionOctet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionOctet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionOctet", type_ids_UnionOctet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionOctet)
    {
        StructTypeFlag struct_flags_UnionOctet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionOctet = "UnionOctet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionOctet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionOctet;
        CompleteTypeDetail detail_UnionOctet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionOctet, ann_custom_UnionOctet, type_name_UnionOctet.to_string());
        CompleteStructHeader header_UnionOctet;
        header_UnionOctet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionOctet);
        CompleteStructMemberSeq member_seq_UnionOctet;
        {
            TypeIdentifierPair type_ids_var_union_octet;
            ReturnCode_t return_code_var_union_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Octet", type_ids_var_union_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_octet)
            {
            ::register_Union_Octet_type_identifier(type_ids_var_union_octet);
            }
            StructMemberFlag member_flags_var_union_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_octet = 0x00000000;
            bool common_var_union_octet_ec {false};
            CommonStructMember common_var_union_octet {TypeObjectUtils::build_common_struct_member(member_id_var_union_octet, member_flags_var_union_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_octet, common_var_union_octet_ec))};
            if (!common_var_union_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_octet = "var_union_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_octet;
            ann_custom_UnionOctet.reset();
            CompleteMemberDetail detail_var_union_octet = TypeObjectUtils::build_complete_member_detail(name_var_union_octet, member_ann_builtin_var_union_octet, ann_custom_UnionOctet);
            CompleteStructMember member_var_union_octet = TypeObjectUtils::build_complete_struct_member(common_var_union_octet, detail_var_union_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionOctet, member_var_union_octet);
        }
        CompleteStructType struct_type_UnionOctet = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionOctet, header_UnionOctet, member_seq_UnionOctet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionOctet, type_name_UnionOctet.to_string(), type_ids_UnionOctet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionOctet already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionChar_type_identifier(
        TypeIdentifierPair& type_ids_UnionChar)
{

    ReturnCode_t return_code_UnionChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionChar", type_ids_UnionChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionChar)
    {
        StructTypeFlag struct_flags_UnionChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionChar = "UnionChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionChar;
        CompleteTypeDetail detail_UnionChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionChar, ann_custom_UnionChar, type_name_UnionChar.to_string());
        CompleteStructHeader header_UnionChar;
        header_UnionChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionChar);
        CompleteStructMemberSeq member_seq_UnionChar;
        {
            TypeIdentifierPair type_ids_var_union_char;
            ReturnCode_t return_code_var_union_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Char", type_ids_var_union_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_char)
            {
            ::register_Union_Char_type_identifier(type_ids_var_union_char);
            }
            StructMemberFlag member_flags_var_union_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_char = 0x00000000;
            bool common_var_union_char_ec {false};
            CommonStructMember common_var_union_char {TypeObjectUtils::build_common_struct_member(member_id_var_union_char, member_flags_var_union_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_char, common_var_union_char_ec))};
            if (!common_var_union_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_char = "var_union_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_char;
            ann_custom_UnionChar.reset();
            CompleteMemberDetail detail_var_union_char = TypeObjectUtils::build_complete_member_detail(name_var_union_char, member_ann_builtin_var_union_char, ann_custom_UnionChar);
            CompleteStructMember member_var_union_char = TypeObjectUtils::build_complete_struct_member(common_var_union_char, detail_var_union_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionChar, member_var_union_char);
        }
        CompleteStructType struct_type_UnionChar = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionChar, header_UnionChar, member_seq_UnionChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionChar, type_name_UnionChar.to_string(), type_ids_UnionChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionWChar_type_identifier(
        TypeIdentifierPair& type_ids_UnionWChar)
{

    ReturnCode_t return_code_UnionWChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionWChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionWChar", type_ids_UnionWChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionWChar)
    {
        StructTypeFlag struct_flags_UnionWChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionWChar = "UnionWChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionWChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionWChar;
        CompleteTypeDetail detail_UnionWChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionWChar, ann_custom_UnionWChar, type_name_UnionWChar.to_string());
        CompleteStructHeader header_UnionWChar;
        header_UnionWChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionWChar);
        CompleteStructMemberSeq member_seq_UnionWChar;
        {
            TypeIdentifierPair type_ids_var_union_wchar;
            ReturnCode_t return_code_var_union_wchar {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_WChar", type_ids_var_union_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_wchar)
            {
            ::register_Union_WChar_type_identifier(type_ids_var_union_wchar);
            }
            StructMemberFlag member_flags_var_union_wchar = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_wchar = 0x00000000;
            bool common_var_union_wchar_ec {false};
            CommonStructMember common_var_union_wchar {TypeObjectUtils::build_common_struct_member(member_id_var_union_wchar, member_flags_var_union_wchar, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_wchar, common_var_union_wchar_ec))};
            if (!common_var_union_wchar_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_wchar member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_wchar = "var_union_wchar";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_wchar;
            ann_custom_UnionWChar.reset();
            CompleteMemberDetail detail_var_union_wchar = TypeObjectUtils::build_complete_member_detail(name_var_union_wchar, member_ann_builtin_var_union_wchar, ann_custom_UnionWChar);
            CompleteStructMember member_var_union_wchar = TypeObjectUtils::build_complete_struct_member(common_var_union_wchar, detail_var_union_wchar);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionWChar, member_var_union_wchar);
        }
        CompleteStructType struct_type_UnionWChar = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionWChar, header_UnionWChar, member_seq_UnionWChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionWChar, type_name_UnionWChar.to_string(), type_ids_UnionWChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionWChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionString_type_identifier(
        TypeIdentifierPair& type_ids_UnionString)
{

    ReturnCode_t return_code_UnionString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionString", type_ids_UnionString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionString)
    {
        StructTypeFlag struct_flags_UnionString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionString = "UnionString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionString;
        CompleteTypeDetail detail_UnionString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionString, ann_custom_UnionString, type_name_UnionString.to_string());
        CompleteStructHeader header_UnionString;
        header_UnionString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionString);
        CompleteStructMemberSeq member_seq_UnionString;
        {
            TypeIdentifierPair type_ids_var_union_string;
            ReturnCode_t return_code_var_union_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_String", type_ids_var_union_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_string)
            {
            ::register_Union_String_type_identifier(type_ids_var_union_string);
            }
            StructMemberFlag member_flags_var_union_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_string = 0x00000000;
            bool common_var_union_string_ec {false};
            CommonStructMember common_var_union_string {TypeObjectUtils::build_common_struct_member(member_id_var_union_string, member_flags_var_union_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_string, common_var_union_string_ec))};
            if (!common_var_union_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_string = "var_union_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_string;
            ann_custom_UnionString.reset();
            CompleteMemberDetail detail_var_union_string = TypeObjectUtils::build_complete_member_detail(name_var_union_string, member_ann_builtin_var_union_string, ann_custom_UnionString);
            CompleteStructMember member_var_union_string = TypeObjectUtils::build_complete_struct_member(common_var_union_string, detail_var_union_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionString, member_var_union_string);
        }
        CompleteStructType struct_type_UnionString = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionString, header_UnionString, member_seq_UnionString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionString, type_name_UnionString.to_string(), type_ids_UnionString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionWString_type_identifier(
        TypeIdentifierPair& type_ids_UnionWString)
{

    ReturnCode_t return_code_UnionWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionWString", type_ids_UnionWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionWString)
    {
        StructTypeFlag struct_flags_UnionWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionWString = "UnionWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionWString;
        CompleteTypeDetail detail_UnionWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionWString, ann_custom_UnionWString, type_name_UnionWString.to_string());
        CompleteStructHeader header_UnionWString;
        header_UnionWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionWString);
        CompleteStructMemberSeq member_seq_UnionWString;
        {
            TypeIdentifierPair type_ids_var_union_wstring;
            ReturnCode_t return_code_var_union_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_WString", type_ids_var_union_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_wstring)
            {
            ::register_Union_WString_type_identifier(type_ids_var_union_wstring);
            }
            StructMemberFlag member_flags_var_union_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_wstring = 0x00000000;
            bool common_var_union_wstring_ec {false};
            CommonStructMember common_var_union_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_union_wstring, member_flags_var_union_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_wstring, common_var_union_wstring_ec))};
            if (!common_var_union_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_wstring = "var_union_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_wstring;
            ann_custom_UnionWString.reset();
            CompleteMemberDetail detail_var_union_wstring = TypeObjectUtils::build_complete_member_detail(name_var_union_wstring, member_ann_builtin_var_union_wstring, ann_custom_UnionWString);
            CompleteStructMember member_var_union_wstring = TypeObjectUtils::build_complete_struct_member(common_var_union_wstring, detail_var_union_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionWString, member_var_union_wstring);
        }
        CompleteStructType struct_type_UnionWString = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionWString, header_UnionWString, member_seq_UnionWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionWString, type_name_UnionWString.to_string(), type_ids_UnionWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionBoundedString_type_identifier(
        TypeIdentifierPair& type_ids_UnionBoundedString)
{

    ReturnCode_t return_code_UnionBoundedString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionBoundedString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionBoundedString", type_ids_UnionBoundedString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionBoundedString)
    {
        StructTypeFlag struct_flags_UnionBoundedString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionBoundedString = "UnionBoundedString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionBoundedString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionBoundedString;
        CompleteTypeDetail detail_UnionBoundedString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionBoundedString, ann_custom_UnionBoundedString, type_name_UnionBoundedString.to_string());
        CompleteStructHeader header_UnionBoundedString;
        header_UnionBoundedString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionBoundedString);
        CompleteStructMemberSeq member_seq_UnionBoundedString;
        {
            TypeIdentifierPair type_ids_var_union_bounded_string;
            ReturnCode_t return_code_var_union_bounded_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_bounded_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_BoundedString", type_ids_var_union_bounded_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_bounded_string)
            {
            ::register_Union_BoundedString_type_identifier(type_ids_var_union_bounded_string);
            }
            StructMemberFlag member_flags_var_union_bounded_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_bounded_string = 0x00000000;
            bool common_var_union_bounded_string_ec {false};
            CommonStructMember common_var_union_bounded_string {TypeObjectUtils::build_common_struct_member(member_id_var_union_bounded_string, member_flags_var_union_bounded_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_bounded_string, common_var_union_bounded_string_ec))};
            if (!common_var_union_bounded_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_bounded_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_bounded_string = "var_union_bounded_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_bounded_string;
            ann_custom_UnionBoundedString.reset();
            CompleteMemberDetail detail_var_union_bounded_string = TypeObjectUtils::build_complete_member_detail(name_var_union_bounded_string, member_ann_builtin_var_union_bounded_string, ann_custom_UnionBoundedString);
            CompleteStructMember member_var_union_bounded_string = TypeObjectUtils::build_complete_struct_member(common_var_union_bounded_string, detail_var_union_bounded_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionBoundedString, member_var_union_bounded_string);
        }
        CompleteStructType struct_type_UnionBoundedString = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionBoundedString, header_UnionBoundedString, member_seq_UnionBoundedString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionBoundedString, type_name_UnionBoundedString.to_string(), type_ids_UnionBoundedString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionBoundedString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionBoundedWString_type_identifier(
        TypeIdentifierPair& type_ids_UnionBoundedWString)
{

    ReturnCode_t return_code_UnionBoundedWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionBoundedWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionBoundedWString", type_ids_UnionBoundedWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionBoundedWString)
    {
        StructTypeFlag struct_flags_UnionBoundedWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionBoundedWString = "UnionBoundedWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionBoundedWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionBoundedWString;
        CompleteTypeDetail detail_UnionBoundedWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionBoundedWString, ann_custom_UnionBoundedWString, type_name_UnionBoundedWString.to_string());
        CompleteStructHeader header_UnionBoundedWString;
        header_UnionBoundedWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionBoundedWString);
        CompleteStructMemberSeq member_seq_UnionBoundedWString;
        {
            TypeIdentifierPair type_ids_var_union_bounded_wstring;
            ReturnCode_t return_code_var_union_bounded_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_bounded_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_BoundedWString", type_ids_var_union_bounded_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_bounded_wstring)
            {
            ::register_Union_BoundedWString_type_identifier(type_ids_var_union_bounded_wstring);
            }
            StructMemberFlag member_flags_var_union_bounded_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_bounded_wstring = 0x00000000;
            bool common_var_union_bounded_wstring_ec {false};
            CommonStructMember common_var_union_bounded_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_union_bounded_wstring, member_flags_var_union_bounded_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_bounded_wstring, common_var_union_bounded_wstring_ec))};
            if (!common_var_union_bounded_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_bounded_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_bounded_wstring = "var_union_bounded_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_bounded_wstring;
            ann_custom_UnionBoundedWString.reset();
            CompleteMemberDetail detail_var_union_bounded_wstring = TypeObjectUtils::build_complete_member_detail(name_var_union_bounded_wstring, member_ann_builtin_var_union_bounded_wstring, ann_custom_UnionBoundedWString);
            CompleteStructMember member_var_union_bounded_wstring = TypeObjectUtils::build_complete_struct_member(common_var_union_bounded_wstring, detail_var_union_bounded_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionBoundedWString, member_var_union_bounded_wstring);
        }
        CompleteStructType struct_type_UnionBoundedWString = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionBoundedWString, header_UnionBoundedWString, member_seq_UnionBoundedWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionBoundedWString, type_name_UnionBoundedWString.to_string(), type_ids_UnionBoundedWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionBoundedWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionInnerEnumHelper_type_identifier(
        TypeIdentifierPair& type_ids_UnionInnerEnumHelper)
{

    ReturnCode_t return_code_UnionInnerEnumHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionInnerEnumHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionInnerEnumHelper", type_ids_UnionInnerEnumHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionInnerEnumHelper)
    {
        StructTypeFlag struct_flags_UnionInnerEnumHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionInnerEnumHelper = "UnionInnerEnumHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionInnerEnumHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionInnerEnumHelper;
        CompleteTypeDetail detail_UnionInnerEnumHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionInnerEnumHelper, ann_custom_UnionInnerEnumHelper, type_name_UnionInnerEnumHelper.to_string());
        CompleteStructHeader header_UnionInnerEnumHelper;
        header_UnionInnerEnumHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionInnerEnumHelper);
        CompleteStructMemberSeq member_seq_UnionInnerEnumHelper;
        {
            TypeIdentifierPair type_ids_var_union_my_enum;
            ReturnCode_t return_code_var_union_my_enum {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_my_enum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_InnerEnumHelper", type_ids_var_union_my_enum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_my_enum)
            {
            ::register_Union_InnerEnumHelper_type_identifier(type_ids_var_union_my_enum);
            }
            StructMemberFlag member_flags_var_union_my_enum = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_my_enum = 0x00000000;
            bool common_var_union_my_enum_ec {false};
            CommonStructMember common_var_union_my_enum {TypeObjectUtils::build_common_struct_member(member_id_var_union_my_enum, member_flags_var_union_my_enum, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_my_enum, common_var_union_my_enum_ec))};
            if (!common_var_union_my_enum_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_my_enum member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_my_enum = "var_union_my_enum";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_my_enum;
            ann_custom_UnionInnerEnumHelper.reset();
            CompleteMemberDetail detail_var_union_my_enum = TypeObjectUtils::build_complete_member_detail(name_var_union_my_enum, member_ann_builtin_var_union_my_enum, ann_custom_UnionInnerEnumHelper);
            CompleteStructMember member_var_union_my_enum = TypeObjectUtils::build_complete_struct_member(common_var_union_my_enum, detail_var_union_my_enum);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionInnerEnumHelper, member_var_union_my_enum);
        }
        CompleteStructType struct_type_UnionInnerEnumHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionInnerEnumHelper, header_UnionInnerEnumHelper, member_seq_UnionInnerEnumHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionInnerEnumHelper, type_name_UnionInnerEnumHelper.to_string(), type_ids_UnionInnerEnumHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionInnerEnumHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionInnerBitMaskHelper_type_identifier(
        TypeIdentifierPair& type_ids_UnionInnerBitMaskHelper)
{

    ReturnCode_t return_code_UnionInnerBitMaskHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionInnerBitMaskHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionInnerBitMaskHelper", type_ids_UnionInnerBitMaskHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionInnerBitMaskHelper)
    {
        StructTypeFlag struct_flags_UnionInnerBitMaskHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionInnerBitMaskHelper = "UnionInnerBitMaskHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionInnerBitMaskHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionInnerBitMaskHelper;
        CompleteTypeDetail detail_UnionInnerBitMaskHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionInnerBitMaskHelper, ann_custom_UnionInnerBitMaskHelper, type_name_UnionInnerBitMaskHelper.to_string());
        CompleteStructHeader header_UnionInnerBitMaskHelper;
        header_UnionInnerBitMaskHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionInnerBitMaskHelper);
        CompleteStructMemberSeq member_seq_UnionInnerBitMaskHelper;
        {
            TypeIdentifierPair type_ids_var_union_my_bit_mask;
            ReturnCode_t return_code_var_union_my_bit_mask {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_my_bit_mask =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_InnerBitMaskHelper", type_ids_var_union_my_bit_mask);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_my_bit_mask)
            {
            ::register_Union_InnerBitMaskHelper_type_identifier(type_ids_var_union_my_bit_mask);
            }
            StructMemberFlag member_flags_var_union_my_bit_mask = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_my_bit_mask = 0x00000000;
            bool common_var_union_my_bit_mask_ec {false};
            CommonStructMember common_var_union_my_bit_mask {TypeObjectUtils::build_common_struct_member(member_id_var_union_my_bit_mask, member_flags_var_union_my_bit_mask, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_my_bit_mask, common_var_union_my_bit_mask_ec))};
            if (!common_var_union_my_bit_mask_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_my_bit_mask member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_my_bit_mask = "var_union_my_bit_mask";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_my_bit_mask;
            ann_custom_UnionInnerBitMaskHelper.reset();
            CompleteMemberDetail detail_var_union_my_bit_mask = TypeObjectUtils::build_complete_member_detail(name_var_union_my_bit_mask, member_ann_builtin_var_union_my_bit_mask, ann_custom_UnionInnerBitMaskHelper);
            CompleteStructMember member_var_union_my_bit_mask = TypeObjectUtils::build_complete_struct_member(common_var_union_my_bit_mask, detail_var_union_my_bit_mask);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionInnerBitMaskHelper, member_var_union_my_bit_mask);
        }
        CompleteStructType struct_type_UnionInnerBitMaskHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionInnerBitMaskHelper, header_UnionInnerBitMaskHelper, member_seq_UnionInnerBitMaskHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionInnerBitMaskHelper, type_name_UnionInnerBitMaskHelper.to_string(), type_ids_UnionInnerBitMaskHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionInnerBitMaskHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionInnerAliasHelper_type_identifier(
        TypeIdentifierPair& type_ids_UnionInnerAliasHelper)
{

    ReturnCode_t return_code_UnionInnerAliasHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionInnerAliasHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionInnerAliasHelper", type_ids_UnionInnerAliasHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionInnerAliasHelper)
    {
        StructTypeFlag struct_flags_UnionInnerAliasHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionInnerAliasHelper = "UnionInnerAliasHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionInnerAliasHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionInnerAliasHelper;
        CompleteTypeDetail detail_UnionInnerAliasHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionInnerAliasHelper, ann_custom_UnionInnerAliasHelper, type_name_UnionInnerAliasHelper.to_string());
        CompleteStructHeader header_UnionInnerAliasHelper;
        header_UnionInnerAliasHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionInnerAliasHelper);
        CompleteStructMemberSeq member_seq_UnionInnerAliasHelper;
        {
            TypeIdentifierPair type_ids_var_union_my_alias;
            ReturnCode_t return_code_var_union_my_alias {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_my_alias =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_InnerAliasHelper", type_ids_var_union_my_alias);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_my_alias)
            {
            ::register_Union_InnerAliasHelper_type_identifier(type_ids_var_union_my_alias);
            }
            StructMemberFlag member_flags_var_union_my_alias = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_my_alias = 0x00000000;
            bool common_var_union_my_alias_ec {false};
            CommonStructMember common_var_union_my_alias {TypeObjectUtils::build_common_struct_member(member_id_var_union_my_alias, member_flags_var_union_my_alias, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_my_alias, common_var_union_my_alias_ec))};
            if (!common_var_union_my_alias_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_my_alias member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_my_alias = "var_union_my_alias";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_my_alias;
            ann_custom_UnionInnerAliasHelper.reset();
            CompleteMemberDetail detail_var_union_my_alias = TypeObjectUtils::build_complete_member_detail(name_var_union_my_alias, member_ann_builtin_var_union_my_alias, ann_custom_UnionInnerAliasHelper);
            CompleteStructMember member_var_union_my_alias = TypeObjectUtils::build_complete_struct_member(common_var_union_my_alias, detail_var_union_my_alias);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionInnerAliasHelper, member_var_union_my_alias);
        }
        CompleteStructType struct_type_UnionInnerAliasHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionInnerAliasHelper, header_UnionInnerAliasHelper, member_seq_UnionInnerAliasHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionInnerAliasHelper, type_name_UnionInnerAliasHelper.to_string(), type_ids_UnionInnerAliasHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionInnerAliasHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionArray_type_identifier(
        TypeIdentifierPair& type_ids_UnionArray)
{

    ReturnCode_t return_code_UnionArray {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionArray =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionArray", type_ids_UnionArray);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionArray)
    {
        StructTypeFlag struct_flags_UnionArray = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionArray = "UnionArray";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionArray;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionArray;
        CompleteTypeDetail detail_UnionArray = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionArray, ann_custom_UnionArray, type_name_UnionArray.to_string());
        CompleteStructHeader header_UnionArray;
        header_UnionArray = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionArray);
        CompleteStructMemberSeq member_seq_UnionArray;
        {
            TypeIdentifierPair type_ids_var_union_array;
            ReturnCode_t return_code_var_union_array {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_array =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Array", type_ids_var_union_array);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_array)
            {
            ::register_Union_Array_type_identifier(type_ids_var_union_array);
            }
            StructMemberFlag member_flags_var_union_array = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_array = 0x00000000;
            bool common_var_union_array_ec {false};
            CommonStructMember common_var_union_array {TypeObjectUtils::build_common_struct_member(member_id_var_union_array, member_flags_var_union_array, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_array, common_var_union_array_ec))};
            if (!common_var_union_array_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_array member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_array = "var_union_array";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_array;
            ann_custom_UnionArray.reset();
            CompleteMemberDetail detail_var_union_array = TypeObjectUtils::build_complete_member_detail(name_var_union_array, member_ann_builtin_var_union_array, ann_custom_UnionArray);
            CompleteStructMember member_var_union_array = TypeObjectUtils::build_complete_struct_member(common_var_union_array, detail_var_union_array);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionArray, member_var_union_array);
        }
        CompleteStructType struct_type_UnionArray = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionArray, header_UnionArray, member_seq_UnionArray);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionArray, type_name_UnionArray.to_string(), type_ids_UnionArray))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionArray already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionSequence_type_identifier(
        TypeIdentifierPair& type_ids_UnionSequence)
{

    ReturnCode_t return_code_UnionSequence {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionSequence =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionSequence", type_ids_UnionSequence);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionSequence)
    {
        StructTypeFlag struct_flags_UnionSequence = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionSequence = "UnionSequence";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionSequence;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionSequence;
        CompleteTypeDetail detail_UnionSequence = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionSequence, ann_custom_UnionSequence, type_name_UnionSequence.to_string());
        CompleteStructHeader header_UnionSequence;
        header_UnionSequence = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionSequence);
        CompleteStructMemberSeq member_seq_UnionSequence;
        {
            TypeIdentifierPair type_ids_var_union_sequence;
            ReturnCode_t return_code_var_union_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Sequence", type_ids_var_union_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_sequence)
            {
            ::register_Union_Sequence_type_identifier(type_ids_var_union_sequence);
            }
            StructMemberFlag member_flags_var_union_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_sequence = 0x00000000;
            bool common_var_union_sequence_ec {false};
            CommonStructMember common_var_union_sequence {TypeObjectUtils::build_common_struct_member(member_id_var_union_sequence, member_flags_var_union_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_sequence, common_var_union_sequence_ec))};
            if (!common_var_union_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_sequence = "var_union_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_sequence;
            ann_custom_UnionSequence.reset();
            CompleteMemberDetail detail_var_union_sequence = TypeObjectUtils::build_complete_member_detail(name_var_union_sequence, member_ann_builtin_var_union_sequence, ann_custom_UnionSequence);
            CompleteStructMember member_var_union_sequence = TypeObjectUtils::build_complete_struct_member(common_var_union_sequence, detail_var_union_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionSequence, member_var_union_sequence);
        }
        CompleteStructType struct_type_UnionSequence = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionSequence, header_UnionSequence, member_seq_UnionSequence);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionSequence, type_name_UnionSequence.to_string(), type_ids_UnionSequence))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionSequence already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionMap_type_identifier(
        TypeIdentifierPair& type_ids_UnionMap)
{

    ReturnCode_t return_code_UnionMap {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionMap =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionMap", type_ids_UnionMap);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionMap)
    {
        StructTypeFlag struct_flags_UnionMap = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionMap = "UnionMap";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionMap;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionMap;
        CompleteTypeDetail detail_UnionMap = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionMap, ann_custom_UnionMap, type_name_UnionMap.to_string());
        CompleteStructHeader header_UnionMap;
        header_UnionMap = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionMap);
        CompleteStructMemberSeq member_seq_UnionMap;
        {
            TypeIdentifierPair type_ids_var_union_map;
            ReturnCode_t return_code_var_union_map {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_map =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Map", type_ids_var_union_map);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_map)
            {
            ::register_Union_Map_type_identifier(type_ids_var_union_map);
            }
            StructMemberFlag member_flags_var_union_map = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_map = 0x00000000;
            bool common_var_union_map_ec {false};
            CommonStructMember common_var_union_map {TypeObjectUtils::build_common_struct_member(member_id_var_union_map, member_flags_var_union_map, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_map, common_var_union_map_ec))};
            if (!common_var_union_map_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_map member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_map = "var_union_map";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_map;
            ann_custom_UnionMap.reset();
            CompleteMemberDetail detail_var_union_map = TypeObjectUtils::build_complete_member_detail(name_var_union_map, member_ann_builtin_var_union_map, ann_custom_UnionMap);
            CompleteStructMember member_var_union_map = TypeObjectUtils::build_complete_struct_member(common_var_union_map, detail_var_union_map);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionMap, member_var_union_map);
        }
        CompleteStructType struct_type_UnionMap = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionMap, header_UnionMap, member_seq_UnionMap);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionMap, type_name_UnionMap.to_string(), type_ids_UnionMap))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionMap already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionInnerUnionHelper_type_identifier(
        TypeIdentifierPair& type_ids_UnionInnerUnionHelper)
{

    ReturnCode_t return_code_UnionInnerUnionHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionInnerUnionHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionInnerUnionHelper", type_ids_UnionInnerUnionHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionInnerUnionHelper)
    {
        StructTypeFlag struct_flags_UnionInnerUnionHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionInnerUnionHelper = "UnionInnerUnionHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionInnerUnionHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionInnerUnionHelper;
        CompleteTypeDetail detail_UnionInnerUnionHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionInnerUnionHelper, ann_custom_UnionInnerUnionHelper, type_name_UnionInnerUnionHelper.to_string());
        CompleteStructHeader header_UnionInnerUnionHelper;
        header_UnionInnerUnionHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionInnerUnionHelper);
        CompleteStructMemberSeq member_seq_UnionInnerUnionHelper;
        {
            TypeIdentifierPair type_ids_var_union_my_union;
            ReturnCode_t return_code_var_union_my_union {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_my_union =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_InnerUnionHelper", type_ids_var_union_my_union);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_my_union)
            {
            ::register_Union_InnerUnionHelper_type_identifier(type_ids_var_union_my_union);
            }
            StructMemberFlag member_flags_var_union_my_union = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_my_union = 0x00000000;
            bool common_var_union_my_union_ec {false};
            CommonStructMember common_var_union_my_union {TypeObjectUtils::build_common_struct_member(member_id_var_union_my_union, member_flags_var_union_my_union, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_my_union, common_var_union_my_union_ec))};
            if (!common_var_union_my_union_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_my_union member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_my_union = "var_union_my_union";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_my_union;
            ann_custom_UnionInnerUnionHelper.reset();
            CompleteMemberDetail detail_var_union_my_union = TypeObjectUtils::build_complete_member_detail(name_var_union_my_union, member_ann_builtin_var_union_my_union, ann_custom_UnionInnerUnionHelper);
            CompleteStructMember member_var_union_my_union = TypeObjectUtils::build_complete_struct_member(common_var_union_my_union, detail_var_union_my_union);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionInnerUnionHelper, member_var_union_my_union);
        }
        CompleteStructType struct_type_UnionInnerUnionHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionInnerUnionHelper, header_UnionInnerUnionHelper, member_seq_UnionInnerUnionHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionInnerUnionHelper, type_name_UnionInnerUnionHelper.to_string(), type_ids_UnionInnerUnionHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionInnerUnionHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionInnerStructureHelper_type_identifier(
        TypeIdentifierPair& type_ids_UnionInnerStructureHelper)
{

    ReturnCode_t return_code_UnionInnerStructureHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionInnerStructureHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionInnerStructureHelper", type_ids_UnionInnerStructureHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionInnerStructureHelper)
    {
        StructTypeFlag struct_flags_UnionInnerStructureHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionInnerStructureHelper = "UnionInnerStructureHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionInnerStructureHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionInnerStructureHelper;
        CompleteTypeDetail detail_UnionInnerStructureHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionInnerStructureHelper, ann_custom_UnionInnerStructureHelper, type_name_UnionInnerStructureHelper.to_string());
        CompleteStructHeader header_UnionInnerStructureHelper;
        header_UnionInnerStructureHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionInnerStructureHelper);
        CompleteStructMemberSeq member_seq_UnionInnerStructureHelper;
        {
            TypeIdentifierPair type_ids_var_union_my_structure;
            ReturnCode_t return_code_var_union_my_structure {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_my_structure =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_InnerStructureHelper", type_ids_var_union_my_structure);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_my_structure)
            {
            ::register_Union_InnerStructureHelper_type_identifier(type_ids_var_union_my_structure);
            }
            StructMemberFlag member_flags_var_union_my_structure = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_my_structure = 0x00000000;
            bool common_var_union_my_structure_ec {false};
            CommonStructMember common_var_union_my_structure {TypeObjectUtils::build_common_struct_member(member_id_var_union_my_structure, member_flags_var_union_my_structure, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_my_structure, common_var_union_my_structure_ec))};
            if (!common_var_union_my_structure_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_my_structure member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_my_structure = "var_union_my_structure";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_my_structure;
            ann_custom_UnionInnerStructureHelper.reset();
            CompleteMemberDetail detail_var_union_my_structure = TypeObjectUtils::build_complete_member_detail(name_var_union_my_structure, member_ann_builtin_var_union_my_structure, ann_custom_UnionInnerStructureHelper);
            CompleteStructMember member_var_union_my_structure = TypeObjectUtils::build_complete_struct_member(common_var_union_my_structure, detail_var_union_my_structure);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionInnerStructureHelper, member_var_union_my_structure);
        }
        CompleteStructType struct_type_UnionInnerStructureHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionInnerStructureHelper, header_UnionInnerStructureHelper, member_seq_UnionInnerStructureHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionInnerStructureHelper, type_name_UnionInnerStructureHelper.to_string(), type_ids_UnionInnerStructureHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionInnerStructureHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionInnerBitsetHelper_type_identifier(
        TypeIdentifierPair& type_ids_UnionInnerBitsetHelper)
{

    ReturnCode_t return_code_UnionInnerBitsetHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionInnerBitsetHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionInnerBitsetHelper", type_ids_UnionInnerBitsetHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionInnerBitsetHelper)
    {
        StructTypeFlag struct_flags_UnionInnerBitsetHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionInnerBitsetHelper = "UnionInnerBitsetHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionInnerBitsetHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionInnerBitsetHelper;
        CompleteTypeDetail detail_UnionInnerBitsetHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionInnerBitsetHelper, ann_custom_UnionInnerBitsetHelper, type_name_UnionInnerBitsetHelper.to_string());
        CompleteStructHeader header_UnionInnerBitsetHelper;
        header_UnionInnerBitsetHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionInnerBitsetHelper);
        CompleteStructMemberSeq member_seq_UnionInnerBitsetHelper;
        {
            TypeIdentifierPair type_ids_var_union_my_bitset;
            ReturnCode_t return_code_var_union_my_bitset {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_my_bitset =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_InnerBitsetHelper", type_ids_var_union_my_bitset);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_my_bitset)
            {
            ::register_Union_InnerBitsetHelper_type_identifier(type_ids_var_union_my_bitset);
            }
            StructMemberFlag member_flags_var_union_my_bitset = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_my_bitset = 0x00000000;
            bool common_var_union_my_bitset_ec {false};
            CommonStructMember common_var_union_my_bitset {TypeObjectUtils::build_common_struct_member(member_id_var_union_my_bitset, member_flags_var_union_my_bitset, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_my_bitset, common_var_union_my_bitset_ec))};
            if (!common_var_union_my_bitset_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_my_bitset member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_my_bitset = "var_union_my_bitset";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_my_bitset;
            ann_custom_UnionInnerBitsetHelper.reset();
            CompleteMemberDetail detail_var_union_my_bitset = TypeObjectUtils::build_complete_member_detail(name_var_union_my_bitset, member_ann_builtin_var_union_my_bitset, ann_custom_UnionInnerBitsetHelper);
            CompleteStructMember member_var_union_my_bitset = TypeObjectUtils::build_complete_struct_member(common_var_union_my_bitset, detail_var_union_my_bitset);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionInnerBitsetHelper, member_var_union_my_bitset);
        }
        CompleteStructType struct_type_UnionInnerBitsetHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionInnerBitsetHelper, header_UnionInnerBitsetHelper, member_seq_UnionInnerBitsetHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionInnerBitsetHelper, type_name_UnionInnerBitsetHelper.to_string(), type_ids_UnionInnerBitsetHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionInnerBitsetHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionDiscriminatorShort_type_identifier(
        TypeIdentifierPair& type_ids_UnionDiscriminatorShort)
{

    ReturnCode_t return_code_UnionDiscriminatorShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionDiscriminatorShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionDiscriminatorShort", type_ids_UnionDiscriminatorShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionDiscriminatorShort)
    {
        StructTypeFlag struct_flags_UnionDiscriminatorShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionDiscriminatorShort = "UnionDiscriminatorShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionDiscriminatorShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionDiscriminatorShort;
        CompleteTypeDetail detail_UnionDiscriminatorShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionDiscriminatorShort, ann_custom_UnionDiscriminatorShort, type_name_UnionDiscriminatorShort.to_string());
        CompleteStructHeader header_UnionDiscriminatorShort;
        header_UnionDiscriminatorShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionDiscriminatorShort);
        CompleteStructMemberSeq member_seq_UnionDiscriminatorShort;
        {
            TypeIdentifierPair type_ids_var_union_discriminator_short;
            ReturnCode_t return_code_var_union_discriminator_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_discriminator_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Discriminator_short", type_ids_var_union_discriminator_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_discriminator_short)
            {
            ::register_Union_Discriminator_short_type_identifier(type_ids_var_union_discriminator_short);
            }
            StructMemberFlag member_flags_var_union_discriminator_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_discriminator_short = 0x00000000;
            bool common_var_union_discriminator_short_ec {false};
            CommonStructMember common_var_union_discriminator_short {TypeObjectUtils::build_common_struct_member(member_id_var_union_discriminator_short, member_flags_var_union_discriminator_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_discriminator_short, common_var_union_discriminator_short_ec))};
            if (!common_var_union_discriminator_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_discriminator_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_discriminator_short = "var_union_discriminator_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_discriminator_short;
            ann_custom_UnionDiscriminatorShort.reset();
            CompleteMemberDetail detail_var_union_discriminator_short = TypeObjectUtils::build_complete_member_detail(name_var_union_discriminator_short, member_ann_builtin_var_union_discriminator_short, ann_custom_UnionDiscriminatorShort);
            CompleteStructMember member_var_union_discriminator_short = TypeObjectUtils::build_complete_struct_member(common_var_union_discriminator_short, detail_var_union_discriminator_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionDiscriminatorShort, member_var_union_discriminator_short);
        }
        CompleteStructType struct_type_UnionDiscriminatorShort = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionDiscriminatorShort, header_UnionDiscriminatorShort, member_seq_UnionDiscriminatorShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionDiscriminatorShort, type_name_UnionDiscriminatorShort.to_string(), type_ids_UnionDiscriminatorShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionDiscriminatorShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionDiscriminatorUShort_type_identifier(
        TypeIdentifierPair& type_ids_UnionDiscriminatorUShort)
{

    ReturnCode_t return_code_UnionDiscriminatorUShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionDiscriminatorUShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionDiscriminatorUShort", type_ids_UnionDiscriminatorUShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionDiscriminatorUShort)
    {
        StructTypeFlag struct_flags_UnionDiscriminatorUShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionDiscriminatorUShort = "UnionDiscriminatorUShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionDiscriminatorUShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionDiscriminatorUShort;
        CompleteTypeDetail detail_UnionDiscriminatorUShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionDiscriminatorUShort, ann_custom_UnionDiscriminatorUShort, type_name_UnionDiscriminatorUShort.to_string());
        CompleteStructHeader header_UnionDiscriminatorUShort;
        header_UnionDiscriminatorUShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionDiscriminatorUShort);
        CompleteStructMemberSeq member_seq_UnionDiscriminatorUShort;
        {
            TypeIdentifierPair type_ids_var_union_discriminator_ushort;
            ReturnCode_t return_code_var_union_discriminator_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_discriminator_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Discriminator_unsigned_short", type_ids_var_union_discriminator_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_discriminator_ushort)
            {
            ::register_Union_Discriminator_unsigned_short_type_identifier(type_ids_var_union_discriminator_ushort);
            }
            StructMemberFlag member_flags_var_union_discriminator_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_discriminator_ushort = 0x00000000;
            bool common_var_union_discriminator_ushort_ec {false};
            CommonStructMember common_var_union_discriminator_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_union_discriminator_ushort, member_flags_var_union_discriminator_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_discriminator_ushort, common_var_union_discriminator_ushort_ec))};
            if (!common_var_union_discriminator_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_discriminator_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_discriminator_ushort = "var_union_discriminator_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_discriminator_ushort;
            ann_custom_UnionDiscriminatorUShort.reset();
            CompleteMemberDetail detail_var_union_discriminator_ushort = TypeObjectUtils::build_complete_member_detail(name_var_union_discriminator_ushort, member_ann_builtin_var_union_discriminator_ushort, ann_custom_UnionDiscriminatorUShort);
            CompleteStructMember member_var_union_discriminator_ushort = TypeObjectUtils::build_complete_struct_member(common_var_union_discriminator_ushort, detail_var_union_discriminator_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionDiscriminatorUShort, member_var_union_discriminator_ushort);
        }
        CompleteStructType struct_type_UnionDiscriminatorUShort = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionDiscriminatorUShort, header_UnionDiscriminatorUShort, member_seq_UnionDiscriminatorUShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionDiscriminatorUShort, type_name_UnionDiscriminatorUShort.to_string(), type_ids_UnionDiscriminatorUShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionDiscriminatorUShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionDiscriminatorLong_type_identifier(
        TypeIdentifierPair& type_ids_UnionDiscriminatorLong)
{

    ReturnCode_t return_code_UnionDiscriminatorLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionDiscriminatorLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionDiscriminatorLong", type_ids_UnionDiscriminatorLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionDiscriminatorLong)
    {
        StructTypeFlag struct_flags_UnionDiscriminatorLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionDiscriminatorLong = "UnionDiscriminatorLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionDiscriminatorLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionDiscriminatorLong;
        CompleteTypeDetail detail_UnionDiscriminatorLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionDiscriminatorLong, ann_custom_UnionDiscriminatorLong, type_name_UnionDiscriminatorLong.to_string());
        CompleteStructHeader header_UnionDiscriminatorLong;
        header_UnionDiscriminatorLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionDiscriminatorLong);
        CompleteStructMemberSeq member_seq_UnionDiscriminatorLong;
        {
            TypeIdentifierPair type_ids_var_union_discriminator_long;
            ReturnCode_t return_code_var_union_discriminator_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_discriminator_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Discriminator_long", type_ids_var_union_discriminator_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_discriminator_long)
            {
            ::register_Union_Discriminator_long_type_identifier(type_ids_var_union_discriminator_long);
            }
            StructMemberFlag member_flags_var_union_discriminator_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_discriminator_long = 0x00000000;
            bool common_var_union_discriminator_long_ec {false};
            CommonStructMember common_var_union_discriminator_long {TypeObjectUtils::build_common_struct_member(member_id_var_union_discriminator_long, member_flags_var_union_discriminator_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_discriminator_long, common_var_union_discriminator_long_ec))};
            if (!common_var_union_discriminator_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_discriminator_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_discriminator_long = "var_union_discriminator_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_discriminator_long;
            ann_custom_UnionDiscriminatorLong.reset();
            CompleteMemberDetail detail_var_union_discriminator_long = TypeObjectUtils::build_complete_member_detail(name_var_union_discriminator_long, member_ann_builtin_var_union_discriminator_long, ann_custom_UnionDiscriminatorLong);
            CompleteStructMember member_var_union_discriminator_long = TypeObjectUtils::build_complete_struct_member(common_var_union_discriminator_long, detail_var_union_discriminator_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionDiscriminatorLong, member_var_union_discriminator_long);
        }
        CompleteStructType struct_type_UnionDiscriminatorLong = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionDiscriminatorLong, header_UnionDiscriminatorLong, member_seq_UnionDiscriminatorLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionDiscriminatorLong, type_name_UnionDiscriminatorLong.to_string(), type_ids_UnionDiscriminatorLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionDiscriminatorLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionDiscriminatorULong_type_identifier(
        TypeIdentifierPair& type_ids_UnionDiscriminatorULong)
{

    ReturnCode_t return_code_UnionDiscriminatorULong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionDiscriminatorULong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionDiscriminatorULong", type_ids_UnionDiscriminatorULong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionDiscriminatorULong)
    {
        StructTypeFlag struct_flags_UnionDiscriminatorULong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionDiscriminatorULong = "UnionDiscriminatorULong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionDiscriminatorULong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionDiscriminatorULong;
        CompleteTypeDetail detail_UnionDiscriminatorULong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionDiscriminatorULong, ann_custom_UnionDiscriminatorULong, type_name_UnionDiscriminatorULong.to_string());
        CompleteStructHeader header_UnionDiscriminatorULong;
        header_UnionDiscriminatorULong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionDiscriminatorULong);
        CompleteStructMemberSeq member_seq_UnionDiscriminatorULong;
        {
            TypeIdentifierPair type_ids_var_union_discriminator_ulong;
            ReturnCode_t return_code_var_union_discriminator_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_discriminator_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Discriminator_unsigned_long", type_ids_var_union_discriminator_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_discriminator_ulong)
            {
            ::register_Union_Discriminator_unsigned_long_type_identifier(type_ids_var_union_discriminator_ulong);
            }
            StructMemberFlag member_flags_var_union_discriminator_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_discriminator_ulong = 0x00000000;
            bool common_var_union_discriminator_ulong_ec {false};
            CommonStructMember common_var_union_discriminator_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_union_discriminator_ulong, member_flags_var_union_discriminator_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_discriminator_ulong, common_var_union_discriminator_ulong_ec))};
            if (!common_var_union_discriminator_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_discriminator_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_discriminator_ulong = "var_union_discriminator_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_discriminator_ulong;
            ann_custom_UnionDiscriminatorULong.reset();
            CompleteMemberDetail detail_var_union_discriminator_ulong = TypeObjectUtils::build_complete_member_detail(name_var_union_discriminator_ulong, member_ann_builtin_var_union_discriminator_ulong, ann_custom_UnionDiscriminatorULong);
            CompleteStructMember member_var_union_discriminator_ulong = TypeObjectUtils::build_complete_struct_member(common_var_union_discriminator_ulong, detail_var_union_discriminator_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionDiscriminatorULong, member_var_union_discriminator_ulong);
        }
        CompleteStructType struct_type_UnionDiscriminatorULong = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionDiscriminatorULong, header_UnionDiscriminatorULong, member_seq_UnionDiscriminatorULong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionDiscriminatorULong, type_name_UnionDiscriminatorULong.to_string(), type_ids_UnionDiscriminatorULong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionDiscriminatorULong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionDiscriminatorLongLong_type_identifier(
        TypeIdentifierPair& type_ids_UnionDiscriminatorLongLong)
{

    ReturnCode_t return_code_UnionDiscriminatorLongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionDiscriminatorLongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionDiscriminatorLongLong", type_ids_UnionDiscriminatorLongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionDiscriminatorLongLong)
    {
        StructTypeFlag struct_flags_UnionDiscriminatorLongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionDiscriminatorLongLong = "UnionDiscriminatorLongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionDiscriminatorLongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionDiscriminatorLongLong;
        CompleteTypeDetail detail_UnionDiscriminatorLongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionDiscriminatorLongLong, ann_custom_UnionDiscriminatorLongLong, type_name_UnionDiscriminatorLongLong.to_string());
        CompleteStructHeader header_UnionDiscriminatorLongLong;
        header_UnionDiscriminatorLongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionDiscriminatorLongLong);
        CompleteStructMemberSeq member_seq_UnionDiscriminatorLongLong;
        {
            TypeIdentifierPair type_ids_var_union_discriminator_long_long;
            ReturnCode_t return_code_var_union_discriminator_long_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_discriminator_long_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Discriminator_long_long", type_ids_var_union_discriminator_long_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_discriminator_long_long)
            {
            ::register_Union_Discriminator_long_long_type_identifier(type_ids_var_union_discriminator_long_long);
            }
            StructMemberFlag member_flags_var_union_discriminator_long_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_discriminator_long_long = 0x00000000;
            bool common_var_union_discriminator_long_long_ec {false};
            CommonStructMember common_var_union_discriminator_long_long {TypeObjectUtils::build_common_struct_member(member_id_var_union_discriminator_long_long, member_flags_var_union_discriminator_long_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_discriminator_long_long, common_var_union_discriminator_long_long_ec))};
            if (!common_var_union_discriminator_long_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_discriminator_long_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_discriminator_long_long = "var_union_discriminator_long_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_discriminator_long_long;
            ann_custom_UnionDiscriminatorLongLong.reset();
            CompleteMemberDetail detail_var_union_discriminator_long_long = TypeObjectUtils::build_complete_member_detail(name_var_union_discriminator_long_long, member_ann_builtin_var_union_discriminator_long_long, ann_custom_UnionDiscriminatorLongLong);
            CompleteStructMember member_var_union_discriminator_long_long = TypeObjectUtils::build_complete_struct_member(common_var_union_discriminator_long_long, detail_var_union_discriminator_long_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionDiscriminatorLongLong, member_var_union_discriminator_long_long);
        }
        CompleteStructType struct_type_UnionDiscriminatorLongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionDiscriminatorLongLong, header_UnionDiscriminatorLongLong, member_seq_UnionDiscriminatorLongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionDiscriminatorLongLong, type_name_UnionDiscriminatorLongLong.to_string(), type_ids_UnionDiscriminatorLongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionDiscriminatorLongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionDiscriminatorULongLong_type_identifier(
        TypeIdentifierPair& type_ids_UnionDiscriminatorULongLong)
{

    ReturnCode_t return_code_UnionDiscriminatorULongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionDiscriminatorULongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionDiscriminatorULongLong", type_ids_UnionDiscriminatorULongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionDiscriminatorULongLong)
    {
        StructTypeFlag struct_flags_UnionDiscriminatorULongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionDiscriminatorULongLong = "UnionDiscriminatorULongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionDiscriminatorULongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionDiscriminatorULongLong;
        CompleteTypeDetail detail_UnionDiscriminatorULongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionDiscriminatorULongLong, ann_custom_UnionDiscriminatorULongLong, type_name_UnionDiscriminatorULongLong.to_string());
        CompleteStructHeader header_UnionDiscriminatorULongLong;
        header_UnionDiscriminatorULongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionDiscriminatorULongLong);
        CompleteStructMemberSeq member_seq_UnionDiscriminatorULongLong;
        {
            TypeIdentifierPair type_ids_var_union_discriminator_ulong_long;
            ReturnCode_t return_code_var_union_discriminator_ulong_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_discriminator_ulong_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Discriminator_unsigned_long_long", type_ids_var_union_discriminator_ulong_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_discriminator_ulong_long)
            {
            ::register_Union_Discriminator_unsigned_long_long_type_identifier(type_ids_var_union_discriminator_ulong_long);
            }
            StructMemberFlag member_flags_var_union_discriminator_ulong_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_discriminator_ulong_long = 0x00000000;
            bool common_var_union_discriminator_ulong_long_ec {false};
            CommonStructMember common_var_union_discriminator_ulong_long {TypeObjectUtils::build_common_struct_member(member_id_var_union_discriminator_ulong_long, member_flags_var_union_discriminator_ulong_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_discriminator_ulong_long, common_var_union_discriminator_ulong_long_ec))};
            if (!common_var_union_discriminator_ulong_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_discriminator_ulong_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_discriminator_ulong_long = "var_union_discriminator_ulong_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_discriminator_ulong_long;
            ann_custom_UnionDiscriminatorULongLong.reset();
            CompleteMemberDetail detail_var_union_discriminator_ulong_long = TypeObjectUtils::build_complete_member_detail(name_var_union_discriminator_ulong_long, member_ann_builtin_var_union_discriminator_ulong_long, ann_custom_UnionDiscriminatorULongLong);
            CompleteStructMember member_var_union_discriminator_ulong_long = TypeObjectUtils::build_complete_struct_member(common_var_union_discriminator_ulong_long, detail_var_union_discriminator_ulong_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionDiscriminatorULongLong, member_var_union_discriminator_ulong_long);
        }
        CompleteStructType struct_type_UnionDiscriminatorULongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionDiscriminatorULongLong, header_UnionDiscriminatorULongLong, member_seq_UnionDiscriminatorULongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionDiscriminatorULongLong, type_name_UnionDiscriminatorULongLong.to_string(), type_ids_UnionDiscriminatorULongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionDiscriminatorULongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionDiscriminatorBoolean_type_identifier(
        TypeIdentifierPair& type_ids_UnionDiscriminatorBoolean)
{

    ReturnCode_t return_code_UnionDiscriminatorBoolean {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionDiscriminatorBoolean =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionDiscriminatorBoolean", type_ids_UnionDiscriminatorBoolean);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionDiscriminatorBoolean)
    {
        StructTypeFlag struct_flags_UnionDiscriminatorBoolean = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionDiscriminatorBoolean = "UnionDiscriminatorBoolean";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionDiscriminatorBoolean;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionDiscriminatorBoolean;
        CompleteTypeDetail detail_UnionDiscriminatorBoolean = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionDiscriminatorBoolean, ann_custom_UnionDiscriminatorBoolean, type_name_UnionDiscriminatorBoolean.to_string());
        CompleteStructHeader header_UnionDiscriminatorBoolean;
        header_UnionDiscriminatorBoolean = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionDiscriminatorBoolean);
        CompleteStructMemberSeq member_seq_UnionDiscriminatorBoolean;
        {
            TypeIdentifierPair type_ids_var_union_discriminator_boolean;
            ReturnCode_t return_code_var_union_discriminator_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_discriminator_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Discriminator_boolean", type_ids_var_union_discriminator_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_discriminator_boolean)
            {
            ::register_Union_Discriminator_boolean_type_identifier(type_ids_var_union_discriminator_boolean);
            }
            StructMemberFlag member_flags_var_union_discriminator_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_discriminator_boolean = 0x00000000;
            bool common_var_union_discriminator_boolean_ec {false};
            CommonStructMember common_var_union_discriminator_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_union_discriminator_boolean, member_flags_var_union_discriminator_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_discriminator_boolean, common_var_union_discriminator_boolean_ec))};
            if (!common_var_union_discriminator_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_discriminator_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_discriminator_boolean = "var_union_discriminator_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_discriminator_boolean;
            ann_custom_UnionDiscriminatorBoolean.reset();
            CompleteMemberDetail detail_var_union_discriminator_boolean = TypeObjectUtils::build_complete_member_detail(name_var_union_discriminator_boolean, member_ann_builtin_var_union_discriminator_boolean, ann_custom_UnionDiscriminatorBoolean);
            CompleteStructMember member_var_union_discriminator_boolean = TypeObjectUtils::build_complete_struct_member(common_var_union_discriminator_boolean, detail_var_union_discriminator_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionDiscriminatorBoolean, member_var_union_discriminator_boolean);
        }
        CompleteStructType struct_type_UnionDiscriminatorBoolean = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionDiscriminatorBoolean, header_UnionDiscriminatorBoolean, member_seq_UnionDiscriminatorBoolean);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionDiscriminatorBoolean, type_name_UnionDiscriminatorBoolean.to_string(), type_ids_UnionDiscriminatorBoolean))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionDiscriminatorBoolean already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionDiscriminatorOctet_type_identifier(
        TypeIdentifierPair& type_ids_UnionDiscriminatorOctet)
{

    ReturnCode_t return_code_UnionDiscriminatorOctet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionDiscriminatorOctet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionDiscriminatorOctet", type_ids_UnionDiscriminatorOctet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionDiscriminatorOctet)
    {
        StructTypeFlag struct_flags_UnionDiscriminatorOctet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionDiscriminatorOctet = "UnionDiscriminatorOctet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionDiscriminatorOctet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionDiscriminatorOctet;
        CompleteTypeDetail detail_UnionDiscriminatorOctet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionDiscriminatorOctet, ann_custom_UnionDiscriminatorOctet, type_name_UnionDiscriminatorOctet.to_string());
        CompleteStructHeader header_UnionDiscriminatorOctet;
        header_UnionDiscriminatorOctet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionDiscriminatorOctet);
        CompleteStructMemberSeq member_seq_UnionDiscriminatorOctet;
        {
            TypeIdentifierPair type_ids_var_union_discriminator_octet;
            ReturnCode_t return_code_var_union_discriminator_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_discriminator_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Discriminator_octet", type_ids_var_union_discriminator_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_discriminator_octet)
            {
            ::register_Union_Discriminator_octet_type_identifier(type_ids_var_union_discriminator_octet);
            }
            StructMemberFlag member_flags_var_union_discriminator_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_discriminator_octet = 0x00000000;
            bool common_var_union_discriminator_octet_ec {false};
            CommonStructMember common_var_union_discriminator_octet {TypeObjectUtils::build_common_struct_member(member_id_var_union_discriminator_octet, member_flags_var_union_discriminator_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_discriminator_octet, common_var_union_discriminator_octet_ec))};
            if (!common_var_union_discriminator_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_discriminator_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_discriminator_octet = "var_union_discriminator_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_discriminator_octet;
            ann_custom_UnionDiscriminatorOctet.reset();
            CompleteMemberDetail detail_var_union_discriminator_octet = TypeObjectUtils::build_complete_member_detail(name_var_union_discriminator_octet, member_ann_builtin_var_union_discriminator_octet, ann_custom_UnionDiscriminatorOctet);
            CompleteStructMember member_var_union_discriminator_octet = TypeObjectUtils::build_complete_struct_member(common_var_union_discriminator_octet, detail_var_union_discriminator_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionDiscriminatorOctet, member_var_union_discriminator_octet);
        }
        CompleteStructType struct_type_UnionDiscriminatorOctet = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionDiscriminatorOctet, header_UnionDiscriminatorOctet, member_seq_UnionDiscriminatorOctet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionDiscriminatorOctet, type_name_UnionDiscriminatorOctet.to_string(), type_ids_UnionDiscriminatorOctet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionDiscriminatorOctet already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionDiscriminatorChar_type_identifier(
        TypeIdentifierPair& type_ids_UnionDiscriminatorChar)
{

    ReturnCode_t return_code_UnionDiscriminatorChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionDiscriminatorChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionDiscriminatorChar", type_ids_UnionDiscriminatorChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionDiscriminatorChar)
    {
        StructTypeFlag struct_flags_UnionDiscriminatorChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionDiscriminatorChar = "UnionDiscriminatorChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionDiscriminatorChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionDiscriminatorChar;
        CompleteTypeDetail detail_UnionDiscriminatorChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionDiscriminatorChar, ann_custom_UnionDiscriminatorChar, type_name_UnionDiscriminatorChar.to_string());
        CompleteStructHeader header_UnionDiscriminatorChar;
        header_UnionDiscriminatorChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionDiscriminatorChar);
        CompleteStructMemberSeq member_seq_UnionDiscriminatorChar;
        {
            TypeIdentifierPair type_ids_var_union_discriminator_char;
            ReturnCode_t return_code_var_union_discriminator_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_discriminator_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Discriminator_char", type_ids_var_union_discriminator_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_discriminator_char)
            {
            ::register_Union_Discriminator_char_type_identifier(type_ids_var_union_discriminator_char);
            }
            StructMemberFlag member_flags_var_union_discriminator_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_discriminator_char = 0x00000000;
            bool common_var_union_discriminator_char_ec {false};
            CommonStructMember common_var_union_discriminator_char {TypeObjectUtils::build_common_struct_member(member_id_var_union_discriminator_char, member_flags_var_union_discriminator_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_discriminator_char, common_var_union_discriminator_char_ec))};
            if (!common_var_union_discriminator_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_discriminator_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_discriminator_char = "var_union_discriminator_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_discriminator_char;
            ann_custom_UnionDiscriminatorChar.reset();
            CompleteMemberDetail detail_var_union_discriminator_char = TypeObjectUtils::build_complete_member_detail(name_var_union_discriminator_char, member_ann_builtin_var_union_discriminator_char, ann_custom_UnionDiscriminatorChar);
            CompleteStructMember member_var_union_discriminator_char = TypeObjectUtils::build_complete_struct_member(common_var_union_discriminator_char, detail_var_union_discriminator_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionDiscriminatorChar, member_var_union_discriminator_char);
        }
        CompleteStructType struct_type_UnionDiscriminatorChar = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionDiscriminatorChar, header_UnionDiscriminatorChar, member_seq_UnionDiscriminatorChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionDiscriminatorChar, type_name_UnionDiscriminatorChar.to_string(), type_ids_UnionDiscriminatorChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionDiscriminatorChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionDiscriminatorWChar_type_identifier(
        TypeIdentifierPair& type_ids_UnionDiscriminatorWChar)
{

    ReturnCode_t return_code_UnionDiscriminatorWChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionDiscriminatorWChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionDiscriminatorWChar", type_ids_UnionDiscriminatorWChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionDiscriminatorWChar)
    {
        StructTypeFlag struct_flags_UnionDiscriminatorWChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionDiscriminatorWChar = "UnionDiscriminatorWChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionDiscriminatorWChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionDiscriminatorWChar;
        CompleteTypeDetail detail_UnionDiscriminatorWChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionDiscriminatorWChar, ann_custom_UnionDiscriminatorWChar, type_name_UnionDiscriminatorWChar.to_string());
        CompleteStructHeader header_UnionDiscriminatorWChar;
        header_UnionDiscriminatorWChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionDiscriminatorWChar);
        CompleteStructMemberSeq member_seq_UnionDiscriminatorWChar;
        {
            TypeIdentifierPair type_ids_var_union_discriminator_wchar;
            ReturnCode_t return_code_var_union_discriminator_wchar {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_discriminator_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Discriminator_wchar", type_ids_var_union_discriminator_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_discriminator_wchar)
            {
            ::register_Union_Discriminator_wchar_type_identifier(type_ids_var_union_discriminator_wchar);
            }
            StructMemberFlag member_flags_var_union_discriminator_wchar = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_discriminator_wchar = 0x00000000;
            bool common_var_union_discriminator_wchar_ec {false};
            CommonStructMember common_var_union_discriminator_wchar {TypeObjectUtils::build_common_struct_member(member_id_var_union_discriminator_wchar, member_flags_var_union_discriminator_wchar, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_discriminator_wchar, common_var_union_discriminator_wchar_ec))};
            if (!common_var_union_discriminator_wchar_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_discriminator_wchar member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_discriminator_wchar = "var_union_discriminator_wchar";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_discriminator_wchar;
            ann_custom_UnionDiscriminatorWChar.reset();
            CompleteMemberDetail detail_var_union_discriminator_wchar = TypeObjectUtils::build_complete_member_detail(name_var_union_discriminator_wchar, member_ann_builtin_var_union_discriminator_wchar, ann_custom_UnionDiscriminatorWChar);
            CompleteStructMember member_var_union_discriminator_wchar = TypeObjectUtils::build_complete_struct_member(common_var_union_discriminator_wchar, detail_var_union_discriminator_wchar);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionDiscriminatorWChar, member_var_union_discriminator_wchar);
        }
        CompleteStructType struct_type_UnionDiscriminatorWChar = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionDiscriminatorWChar, header_UnionDiscriminatorWChar, member_seq_UnionDiscriminatorWChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionDiscriminatorWChar, type_name_UnionDiscriminatorWChar.to_string(), type_ids_UnionDiscriminatorWChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionDiscriminatorWChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionDiscriminatorEnum_type_identifier(
        TypeIdentifierPair& type_ids_UnionDiscriminatorEnum)
{

    ReturnCode_t return_code_UnionDiscriminatorEnum {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionDiscriminatorEnum =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionDiscriminatorEnum", type_ids_UnionDiscriminatorEnum);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionDiscriminatorEnum)
    {
        StructTypeFlag struct_flags_UnionDiscriminatorEnum = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionDiscriminatorEnum = "UnionDiscriminatorEnum";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionDiscriminatorEnum;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionDiscriminatorEnum;
        CompleteTypeDetail detail_UnionDiscriminatorEnum = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionDiscriminatorEnum, ann_custom_UnionDiscriminatorEnum, type_name_UnionDiscriminatorEnum.to_string());
        CompleteStructHeader header_UnionDiscriminatorEnum;
        header_UnionDiscriminatorEnum = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionDiscriminatorEnum);
        CompleteStructMemberSeq member_seq_UnionDiscriminatorEnum;
        {
            TypeIdentifierPair type_ids_var_union_discriminator_enum;
            ReturnCode_t return_code_var_union_discriminator_enum {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_discriminator_enum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Discriminator_enum", type_ids_var_union_discriminator_enum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_discriminator_enum)
            {
            ::register_Union_Discriminator_enum_type_identifier(type_ids_var_union_discriminator_enum);
            }
            StructMemberFlag member_flags_var_union_discriminator_enum = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_discriminator_enum = 0x00000000;
            bool common_var_union_discriminator_enum_ec {false};
            CommonStructMember common_var_union_discriminator_enum {TypeObjectUtils::build_common_struct_member(member_id_var_union_discriminator_enum, member_flags_var_union_discriminator_enum, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_discriminator_enum, common_var_union_discriminator_enum_ec))};
            if (!common_var_union_discriminator_enum_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_discriminator_enum member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_discriminator_enum = "var_union_discriminator_enum";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_discriminator_enum;
            ann_custom_UnionDiscriminatorEnum.reset();
            CompleteMemberDetail detail_var_union_discriminator_enum = TypeObjectUtils::build_complete_member_detail(name_var_union_discriminator_enum, member_ann_builtin_var_union_discriminator_enum, ann_custom_UnionDiscriminatorEnum);
            CompleteStructMember member_var_union_discriminator_enum = TypeObjectUtils::build_complete_struct_member(common_var_union_discriminator_enum, detail_var_union_discriminator_enum);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionDiscriminatorEnum, member_var_union_discriminator_enum);
        }
        CompleteStructType struct_type_UnionDiscriminatorEnum = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionDiscriminatorEnum, header_UnionDiscriminatorEnum, member_seq_UnionDiscriminatorEnum);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionDiscriminatorEnum, type_name_UnionDiscriminatorEnum.to_string(), type_ids_UnionDiscriminatorEnum))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionDiscriminatorEnum already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionDiscriminatorEnumLabel_type_identifier(
        TypeIdentifierPair& type_ids_UnionDiscriminatorEnumLabel)
{

    ReturnCode_t return_code_UnionDiscriminatorEnumLabel {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionDiscriminatorEnumLabel =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionDiscriminatorEnumLabel", type_ids_UnionDiscriminatorEnumLabel);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionDiscriminatorEnumLabel)
    {
        StructTypeFlag struct_flags_UnionDiscriminatorEnumLabel = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionDiscriminatorEnumLabel = "UnionDiscriminatorEnumLabel";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionDiscriminatorEnumLabel;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionDiscriminatorEnumLabel;
        CompleteTypeDetail detail_UnionDiscriminatorEnumLabel = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionDiscriminatorEnumLabel, ann_custom_UnionDiscriminatorEnumLabel, type_name_UnionDiscriminatorEnumLabel.to_string());
        CompleteStructHeader header_UnionDiscriminatorEnumLabel;
        header_UnionDiscriminatorEnumLabel = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionDiscriminatorEnumLabel);
        CompleteStructMemberSeq member_seq_UnionDiscriminatorEnumLabel;
        {
            TypeIdentifierPair type_ids_var_union_discriminator_enum;
            ReturnCode_t return_code_var_union_discriminator_enum {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_discriminator_enum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Discriminator_enum_labels", type_ids_var_union_discriminator_enum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_discriminator_enum)
            {
            ::register_Union_Discriminator_enum_labels_type_identifier(type_ids_var_union_discriminator_enum);
            }
            StructMemberFlag member_flags_var_union_discriminator_enum = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_discriminator_enum = 0x00000000;
            bool common_var_union_discriminator_enum_ec {false};
            CommonStructMember common_var_union_discriminator_enum {TypeObjectUtils::build_common_struct_member(member_id_var_union_discriminator_enum, member_flags_var_union_discriminator_enum, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_discriminator_enum, common_var_union_discriminator_enum_ec))};
            if (!common_var_union_discriminator_enum_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_discriminator_enum member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_discriminator_enum = "var_union_discriminator_enum";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_discriminator_enum;
            ann_custom_UnionDiscriminatorEnumLabel.reset();
            CompleteMemberDetail detail_var_union_discriminator_enum = TypeObjectUtils::build_complete_member_detail(name_var_union_discriminator_enum, member_ann_builtin_var_union_discriminator_enum, ann_custom_UnionDiscriminatorEnumLabel);
            CompleteStructMember member_var_union_discriminator_enum = TypeObjectUtils::build_complete_struct_member(common_var_union_discriminator_enum, detail_var_union_discriminator_enum);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionDiscriminatorEnumLabel, member_var_union_discriminator_enum);
        }
        CompleteStructType struct_type_UnionDiscriminatorEnumLabel = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionDiscriminatorEnumLabel, header_UnionDiscriminatorEnumLabel, member_seq_UnionDiscriminatorEnumLabel);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionDiscriminatorEnumLabel, type_name_UnionDiscriminatorEnumLabel.to_string(), type_ids_UnionDiscriminatorEnumLabel))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionDiscriminatorEnumLabel already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionDiscriminatorAlias_type_identifier(
        TypeIdentifierPair& type_ids_UnionDiscriminatorAlias)
{

    ReturnCode_t return_code_UnionDiscriminatorAlias {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionDiscriminatorAlias =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionDiscriminatorAlias", type_ids_UnionDiscriminatorAlias);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionDiscriminatorAlias)
    {
        StructTypeFlag struct_flags_UnionDiscriminatorAlias = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionDiscriminatorAlias = "UnionDiscriminatorAlias";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionDiscriminatorAlias;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionDiscriminatorAlias;
        CompleteTypeDetail detail_UnionDiscriminatorAlias = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionDiscriminatorAlias, ann_custom_UnionDiscriminatorAlias, type_name_UnionDiscriminatorAlias.to_string());
        CompleteStructHeader header_UnionDiscriminatorAlias;
        header_UnionDiscriminatorAlias = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionDiscriminatorAlias);
        CompleteStructMemberSeq member_seq_UnionDiscriminatorAlias;
        {
            TypeIdentifierPair type_ids_var_union_discriminator_alias;
            ReturnCode_t return_code_var_union_discriminator_alias {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_discriminator_alias =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Discriminator_alias", type_ids_var_union_discriminator_alias);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_discriminator_alias)
            {
            ::register_Union_Discriminator_alias_type_identifier(type_ids_var_union_discriminator_alias);
            }
            StructMemberFlag member_flags_var_union_discriminator_alias = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_discriminator_alias = 0x00000000;
            bool common_var_union_discriminator_alias_ec {false};
            CommonStructMember common_var_union_discriminator_alias {TypeObjectUtils::build_common_struct_member(member_id_var_union_discriminator_alias, member_flags_var_union_discriminator_alias, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_discriminator_alias, common_var_union_discriminator_alias_ec))};
            if (!common_var_union_discriminator_alias_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_discriminator_alias member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_discriminator_alias = "var_union_discriminator_alias";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_discriminator_alias;
            ann_custom_UnionDiscriminatorAlias.reset();
            CompleteMemberDetail detail_var_union_discriminator_alias = TypeObjectUtils::build_complete_member_detail(name_var_union_discriminator_alias, member_ann_builtin_var_union_discriminator_alias, ann_custom_UnionDiscriminatorAlias);
            CompleteStructMember member_var_union_discriminator_alias = TypeObjectUtils::build_complete_struct_member(common_var_union_discriminator_alias, detail_var_union_discriminator_alias);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionDiscriminatorAlias, member_var_union_discriminator_alias);
        }
        CompleteStructType struct_type_UnionDiscriminatorAlias = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionDiscriminatorAlias, header_UnionDiscriminatorAlias, member_seq_UnionDiscriminatorAlias);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionDiscriminatorAlias, type_name_UnionDiscriminatorAlias.to_string(), type_ids_UnionDiscriminatorAlias))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionDiscriminatorAlias already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionSeveralFields_type_identifier(
        TypeIdentifierPair& type_ids_UnionSeveralFields)
{

    ReturnCode_t return_code_UnionSeveralFields {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionSeveralFields =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionSeveralFields", type_ids_UnionSeveralFields);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionSeveralFields)
    {
        StructTypeFlag struct_flags_UnionSeveralFields = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionSeveralFields = "UnionSeveralFields";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionSeveralFields;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionSeveralFields;
        CompleteTypeDetail detail_UnionSeveralFields = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionSeveralFields, ann_custom_UnionSeveralFields, type_name_UnionSeveralFields.to_string());
        CompleteStructHeader header_UnionSeveralFields;
        header_UnionSeveralFields = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionSeveralFields);
        CompleteStructMemberSeq member_seq_UnionSeveralFields;
        {
            TypeIdentifierPair type_ids_var_union_several_fields;
            ReturnCode_t return_code_var_union_several_fields {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_several_fields =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Several_Fields", type_ids_var_union_several_fields);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_several_fields)
            {
            ::register_Union_Several_Fields_type_identifier(type_ids_var_union_several_fields);
            }
            StructMemberFlag member_flags_var_union_several_fields = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_several_fields = 0x00000000;
            bool common_var_union_several_fields_ec {false};
            CommonStructMember common_var_union_several_fields {TypeObjectUtils::build_common_struct_member(member_id_var_union_several_fields, member_flags_var_union_several_fields, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_several_fields, common_var_union_several_fields_ec))};
            if (!common_var_union_several_fields_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_several_fields member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_several_fields = "var_union_several_fields";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_several_fields;
            ann_custom_UnionSeveralFields.reset();
            CompleteMemberDetail detail_var_union_several_fields = TypeObjectUtils::build_complete_member_detail(name_var_union_several_fields, member_ann_builtin_var_union_several_fields, ann_custom_UnionSeveralFields);
            CompleteStructMember member_var_union_several_fields = TypeObjectUtils::build_complete_struct_member(common_var_union_several_fields, detail_var_union_several_fields);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionSeveralFields, member_var_union_several_fields);
        }
        CompleteStructType struct_type_UnionSeveralFields = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionSeveralFields, header_UnionSeveralFields, member_seq_UnionSeveralFields);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionSeveralFields, type_name_UnionSeveralFields.to_string(), type_ids_UnionSeveralFields))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionSeveralFields already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionSeveralFieldsWithDefault_type_identifier(
        TypeIdentifierPair& type_ids_UnionSeveralFieldsWithDefault)
{

    ReturnCode_t return_code_UnionSeveralFieldsWithDefault {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionSeveralFieldsWithDefault =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionSeveralFieldsWithDefault", type_ids_UnionSeveralFieldsWithDefault);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionSeveralFieldsWithDefault)
    {
        StructTypeFlag struct_flags_UnionSeveralFieldsWithDefault = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionSeveralFieldsWithDefault = "UnionSeveralFieldsWithDefault";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionSeveralFieldsWithDefault;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionSeveralFieldsWithDefault;
        CompleteTypeDetail detail_UnionSeveralFieldsWithDefault = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionSeveralFieldsWithDefault, ann_custom_UnionSeveralFieldsWithDefault, type_name_UnionSeveralFieldsWithDefault.to_string());
        CompleteStructHeader header_UnionSeveralFieldsWithDefault;
        header_UnionSeveralFieldsWithDefault = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionSeveralFieldsWithDefault);
        CompleteStructMemberSeq member_seq_UnionSeveralFieldsWithDefault;
        {
            TypeIdentifierPair type_ids_var_union_several_fields_with_default;
            ReturnCode_t return_code_var_union_several_fields_with_default {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_several_fields_with_default =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Several_Fields_With_Default", type_ids_var_union_several_fields_with_default);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_several_fields_with_default)
            {
            ::register_Union_Several_Fields_With_Default_type_identifier(type_ids_var_union_several_fields_with_default);
            }
            StructMemberFlag member_flags_var_union_several_fields_with_default = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_several_fields_with_default = 0x00000000;
            bool common_var_union_several_fields_with_default_ec {false};
            CommonStructMember common_var_union_several_fields_with_default {TypeObjectUtils::build_common_struct_member(member_id_var_union_several_fields_with_default, member_flags_var_union_several_fields_with_default, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_several_fields_with_default, common_var_union_several_fields_with_default_ec))};
            if (!common_var_union_several_fields_with_default_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_several_fields_with_default member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_several_fields_with_default = "var_union_several_fields_with_default";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_several_fields_with_default;
            ann_custom_UnionSeveralFieldsWithDefault.reset();
            CompleteMemberDetail detail_var_union_several_fields_with_default = TypeObjectUtils::build_complete_member_detail(name_var_union_several_fields_with_default, member_ann_builtin_var_union_several_fields_with_default, ann_custom_UnionSeveralFieldsWithDefault);
            CompleteStructMember member_var_union_several_fields_with_default = TypeObjectUtils::build_complete_struct_member(common_var_union_several_fields_with_default, detail_var_union_several_fields_with_default);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionSeveralFieldsWithDefault, member_var_union_several_fields_with_default);
        }
        CompleteStructType struct_type_UnionSeveralFieldsWithDefault = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionSeveralFieldsWithDefault, header_UnionSeveralFieldsWithDefault, member_seq_UnionSeveralFieldsWithDefault);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionSeveralFieldsWithDefault, type_name_UnionSeveralFieldsWithDefault.to_string(), type_ids_UnionSeveralFieldsWithDefault))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionSeveralFieldsWithDefault already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_DefaultAnnotation_type_identifier(
        TypeIdentifierPair& type_ids_DefaultAnnotation)
{
    ReturnCode_t return_code_DefaultAnnotation {eprosima::fastdds::dds::RETCODE_OK};
    return_code_DefaultAnnotation =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "DefaultAnnotation", type_ids_DefaultAnnotation);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_DefaultAnnotation)
    {
        UnionTypeFlag union_flags_DefaultAnnotation = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_DefaultAnnotation = "DefaultAnnotation";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_DefaultAnnotation;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_DefaultAnnotation;
        CompleteTypeDetail detail_DefaultAnnotation = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_DefaultAnnotation, ann_custom_DefaultAnnotation, type_name_DefaultAnnotation.to_string());
        CompleteUnionHeader header_DefaultAnnotation = TypeObjectUtils::build_complete_union_header(detail_DefaultAnnotation);
        UnionDiscriminatorFlag member_flags_DefaultAnnotation = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_DefaultAnnotation =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_DefaultAnnotation);

        if (return_code_DefaultAnnotation != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_DefaultAnnotation;
        if (EK_COMPLETE == type_ids_DefaultAnnotation.type_identifier1()._d() || TK_NONE == type_ids_DefaultAnnotation.type_identifier2()._d())
        {
            common_DefaultAnnotation = TypeObjectUtils::build_common_discriminator_member(member_flags_DefaultAnnotation, type_ids_DefaultAnnotation.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_DefaultAnnotation.type_identifier2()._d())
        {
            common_DefaultAnnotation = TypeObjectUtils::build_common_discriminator_member(member_flags_DefaultAnnotation, type_ids_DefaultAnnotation.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "DefaultAnnotation discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_DefaultAnnotation.reset();
        ann_custom_DefaultAnnotation.reset();
        AppliedAnnotationSeq tmp_ann_custom_discriminator;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_discriminator;
        if (!tmp_ann_custom_discriminator.empty())
        {
            ann_custom_DefaultAnnotation = tmp_ann_custom_discriminator;
        }

        CompleteDiscriminatorMember discriminator_DefaultAnnotation = TypeObjectUtils::build_complete_discriminator_member(common_DefaultAnnotation,
                type_ann_builtin_DefaultAnnotation, ann_custom_DefaultAnnotation);
        CompleteUnionMemberSeq member_seq_DefaultAnnotation;
        {
            return_code_DefaultAnnotation =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_DefaultAnnotation);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_DefaultAnnotation)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "a Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_a = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_a;
            TypeObjectUtils::add_union_case_label(label_seq_a, static_cast<int32_t>(0));
            MemberId member_id_a = 0x00000001;
            bool common_a_ec {false};
            CommonUnionMember common_a {TypeObjectUtils::build_common_union_member(member_id_a,
                    member_flags_a, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_DefaultAnnotation,
                        common_a_ec), label_seq_a)};
            if (!common_a_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union a member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_a = "a";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_a;
            ann_custom_DefaultAnnotation.reset();
            CompleteMemberDetail detail_a = TypeObjectUtils::build_complete_member_detail(name_a, member_ann_builtin_a, ann_custom_DefaultAnnotation);
            CompleteUnionMember member_a = TypeObjectUtils::build_complete_union_member(common_a, detail_a);
            TypeObjectUtils::add_complete_union_member(member_seq_DefaultAnnotation, member_a);
        }
        {
            return_code_DefaultAnnotation =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_DefaultAnnotation);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_DefaultAnnotation)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "b Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_b = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_b;
            TypeObjectUtils::add_union_case_label(label_seq_b, static_cast<int32_t>(1));
            MemberId member_id_b = 0x00000002;
            bool common_b_ec {false};
            CommonUnionMember common_b {TypeObjectUtils::build_common_union_member(member_id_b,
                    member_flags_b, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_DefaultAnnotation,
                        common_b_ec), label_seq_b)};
            if (!common_b_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union b member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_b = "b";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_b;
            ann_custom_DefaultAnnotation.reset();
            CompleteMemberDetail detail_b = TypeObjectUtils::build_complete_member_detail(name_b, member_ann_builtin_b, ann_custom_DefaultAnnotation);
            CompleteUnionMember member_b = TypeObjectUtils::build_complete_union_member(common_b, detail_b);
            TypeObjectUtils::add_complete_union_member(member_seq_DefaultAnnotation, member_b);
        }
        {
            return_code_DefaultAnnotation =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_DefaultAnnotation);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_DefaultAnnotation)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "c Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_c = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false);
            UnionCaseLabelSeq label_seq_c;
            MemberId member_id_c = 0x00000003;
            bool common_c_ec {false};
            CommonUnionMember common_c {TypeObjectUtils::build_common_union_member(member_id_c,
                    member_flags_c, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_DefaultAnnotation,
                        common_c_ec), label_seq_c)};
            if (!common_c_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union c member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_c = "c";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_c;
            ann_custom_DefaultAnnotation.reset();
            CompleteMemberDetail detail_c = TypeObjectUtils::build_complete_member_detail(name_c, member_ann_builtin_c, ann_custom_DefaultAnnotation);
            CompleteUnionMember member_c = TypeObjectUtils::build_complete_union_member(common_c, detail_c);
            TypeObjectUtils::add_complete_union_member(member_seq_DefaultAnnotation, member_c);
        }
        CompleteUnionType union_type_DefaultAnnotation = TypeObjectUtils::build_complete_union_type(union_flags_DefaultAnnotation, header_DefaultAnnotation, discriminator_DefaultAnnotation,
                member_seq_DefaultAnnotation);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_DefaultAnnotation, type_name_DefaultAnnotation.to_string(), type_ids_DefaultAnnotation))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "DefaultAnnotation already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_DefaultAnnotationExternalValue_type_identifier(
        TypeIdentifierPair& type_ids_DefaultAnnotationExternalValue)
{
    ReturnCode_t return_code_DefaultAnnotationExternalValue {eprosima::fastdds::dds::RETCODE_OK};
    return_code_DefaultAnnotationExternalValue =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "DefaultAnnotationExternalValue", type_ids_DefaultAnnotationExternalValue);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_DefaultAnnotationExternalValue)
    {
        UnionTypeFlag union_flags_DefaultAnnotationExternalValue = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_DefaultAnnotationExternalValue = "DefaultAnnotationExternalValue";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_DefaultAnnotationExternalValue;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_DefaultAnnotationExternalValue;
        CompleteTypeDetail detail_DefaultAnnotationExternalValue = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_DefaultAnnotationExternalValue, ann_custom_DefaultAnnotationExternalValue, type_name_DefaultAnnotationExternalValue.to_string());
        CompleteUnionHeader header_DefaultAnnotationExternalValue = TypeObjectUtils::build_complete_union_header(detail_DefaultAnnotationExternalValue);
        UnionDiscriminatorFlag member_flags_DefaultAnnotationExternalValue = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_DefaultAnnotationExternalValue =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_DefaultAnnotationExternalValue);

        if (return_code_DefaultAnnotationExternalValue != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_DefaultAnnotationExternalValue;
        if (EK_COMPLETE == type_ids_DefaultAnnotationExternalValue.type_identifier1()._d() || TK_NONE == type_ids_DefaultAnnotationExternalValue.type_identifier2()._d())
        {
            common_DefaultAnnotationExternalValue = TypeObjectUtils::build_common_discriminator_member(member_flags_DefaultAnnotationExternalValue, type_ids_DefaultAnnotationExternalValue.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_DefaultAnnotationExternalValue.type_identifier2()._d())
        {
            common_DefaultAnnotationExternalValue = TypeObjectUtils::build_common_discriminator_member(member_flags_DefaultAnnotationExternalValue, type_ids_DefaultAnnotationExternalValue.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "DefaultAnnotationExternalValue discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_DefaultAnnotationExternalValue.reset();
        ann_custom_DefaultAnnotationExternalValue.reset();
        AppliedAnnotationSeq tmp_ann_custom_discriminator;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_discriminator;
        if (!tmp_ann_custom_discriminator.empty())
        {
            ann_custom_DefaultAnnotationExternalValue = tmp_ann_custom_discriminator;
        }

        CompleteDiscriminatorMember discriminator_DefaultAnnotationExternalValue = TypeObjectUtils::build_complete_discriminator_member(common_DefaultAnnotationExternalValue,
                type_ann_builtin_DefaultAnnotationExternalValue, ann_custom_DefaultAnnotationExternalValue);
        CompleteUnionMemberSeq member_seq_DefaultAnnotationExternalValue;
        {
            return_code_DefaultAnnotationExternalValue =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_DefaultAnnotationExternalValue);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_DefaultAnnotationExternalValue)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "a Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_a = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_a;
            TypeObjectUtils::add_union_case_label(label_seq_a, static_cast<int32_t>(0));
            MemberId member_id_a = 0x00000001;
            bool common_a_ec {false};
            CommonUnionMember common_a {TypeObjectUtils::build_common_union_member(member_id_a,
                    member_flags_a, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_DefaultAnnotationExternalValue,
                        common_a_ec), label_seq_a)};
            if (!common_a_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union a member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_a = "a";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_a;
            ann_custom_DefaultAnnotationExternalValue.reset();
            CompleteMemberDetail detail_a = TypeObjectUtils::build_complete_member_detail(name_a, member_ann_builtin_a, ann_custom_DefaultAnnotationExternalValue);
            CompleteUnionMember member_a = TypeObjectUtils::build_complete_union_member(common_a, detail_a);
            TypeObjectUtils::add_complete_union_member(member_seq_DefaultAnnotationExternalValue, member_a);
        }
        {
            return_code_DefaultAnnotationExternalValue =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_DefaultAnnotationExternalValue);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_DefaultAnnotationExternalValue)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "b Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_b = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_b;
            TypeObjectUtils::add_union_case_label(label_seq_b, static_cast<int32_t>(1));
            MemberId member_id_b = 0x00000002;
            bool common_b_ec {false};
            CommonUnionMember common_b {TypeObjectUtils::build_common_union_member(member_id_b,
                    member_flags_b, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_DefaultAnnotationExternalValue,
                        common_b_ec), label_seq_b)};
            if (!common_b_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union b member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_b = "b";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_b;
            ann_custom_DefaultAnnotationExternalValue.reset();
            CompleteMemberDetail detail_b = TypeObjectUtils::build_complete_member_detail(name_b, member_ann_builtin_b, ann_custom_DefaultAnnotationExternalValue);
            CompleteUnionMember member_b = TypeObjectUtils::build_complete_union_member(common_b, detail_b);
            TypeObjectUtils::add_complete_union_member(member_seq_DefaultAnnotationExternalValue, member_b);
        }
        CompleteUnionType union_type_DefaultAnnotationExternalValue = TypeObjectUtils::build_complete_union_type(union_flags_DefaultAnnotationExternalValue, header_DefaultAnnotationExternalValue, discriminator_DefaultAnnotationExternalValue,
                member_seq_DefaultAnnotationExternalValue);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_DefaultAnnotationExternalValue, type_name_DefaultAnnotationExternalValue.to_string(), type_ids_DefaultAnnotationExternalValue))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "DefaultAnnotationExternalValue already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionShortExtraMember_type_identifier(
        TypeIdentifierPair& type_ids_UnionShortExtraMember)
{

    ReturnCode_t return_code_UnionShortExtraMember {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionShortExtraMember =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UnionShortExtraMember", type_ids_UnionShortExtraMember);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionShortExtraMember)
    {
        StructTypeFlag struct_flags_UnionShortExtraMember = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionShortExtraMember = "UnionShortExtraMember";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionShortExtraMember;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionShortExtraMember;
        CompleteTypeDetail detail_UnionShortExtraMember = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionShortExtraMember, ann_custom_UnionShortExtraMember, type_name_UnionShortExtraMember.to_string());
        CompleteStructHeader header_UnionShortExtraMember;
        header_UnionShortExtraMember = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UnionShortExtraMember);
        CompleteStructMemberSeq member_seq_UnionShortExtraMember;
        {
            TypeIdentifierPair type_ids_var_union_short;
            ReturnCode_t return_code_var_union_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Union_Short", type_ids_var_union_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union_short)
            {
            ::register_Union_Short_type_identifier(type_ids_var_union_short);
            }
            StructMemberFlag member_flags_var_union_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union_short = 0x00000000;
            bool common_var_union_short_ec {false};
            CommonStructMember common_var_union_short {TypeObjectUtils::build_common_struct_member(member_id_var_union_short, member_flags_var_union_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union_short, common_var_union_short_ec))};
            if (!common_var_union_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union_short = "var_union_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union_short;
            ann_custom_UnionShortExtraMember.reset();
            CompleteMemberDetail detail_var_union_short = TypeObjectUtils::build_complete_member_detail(name_var_union_short, member_ann_builtin_var_union_short, ann_custom_UnionShortExtraMember);
            CompleteStructMember member_var_union_short = TypeObjectUtils::build_complete_struct_member(common_var_union_short, detail_var_union_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionShortExtraMember, member_var_union_short);
        }
        {
            TypeIdentifierPair type_ids_var_long;
            ReturnCode_t return_code_var_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_var_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_long = 0x00000001;
            bool common_var_long_ec {false};
            CommonStructMember common_var_long {TypeObjectUtils::build_common_struct_member(member_id_var_long, member_flags_var_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_long, common_var_long_ec))};
            if (!common_var_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_long = "var_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_long;
            ann_custom_UnionShortExtraMember.reset();
            CompleteMemberDetail detail_var_long = TypeObjectUtils::build_complete_member_detail(name_var_long, member_ann_builtin_var_long, ann_custom_UnionShortExtraMember);
            CompleteStructMember member_var_long = TypeObjectUtils::build_complete_struct_member(common_var_long, detail_var_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_UnionShortExtraMember, member_var_long);
        }
        CompleteStructType struct_type_UnionShortExtraMember = TypeObjectUtils::build_complete_struct_type(struct_flags_UnionShortExtraMember, header_UnionShortExtraMember, member_seq_UnionShortExtraMember);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UnionShortExtraMember, type_name_UnionShortExtraMember.to_string(), type_ids_UnionShortExtraMember))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UnionShortExtraMember already registered in TypeObjectRegistry for a different type.");
        }
    }
}

